#!perl -T

use 5.006;
use strict;
use warnings;
use Test::More;

plan tests => 30;

use Math::AnyNum;

my $q = Math::AnyNum->new_q('3/4');
$q = $q->log;
like($q, qr/^-0\.2876820724517809274392190059\d*\z/);
$q = $q->log($q);
is($q, 1);

$q = $q->add('3/4');
is($q, '1.75');
$q = $q->log2;
like($q, qr/^0\.807354922057604107441969317\d*\z/);
$q = $q->float->neg;
$q = $q->log2;
like($q, qr/^-0\.308725057411847770159350729\d*\+4\.532360141827193809627682945\d*i\z/);
$q = $q->log2;
like($q, qr/^2\.1836016369170527163123880503447\d*\+2\.36429874726537384962181\d*i\z/);

$q = $q->log10;
like($q, qr/^0\.5076384706335070839076009277355\d*\+0\.358340398981472556097649240\d*i\z/);

my $f = Math::AnyNum->new_f('5.12');
$f = $f->log;
like($f, qr/^1\.633154439051416416719106183754\d*\z/);
$f = $f->neg->log;
like($f, qr/^0\.49051338333856146211797438\d*\+3\.1415926535897932384626433\d*i\z/);
$f = $f->log($f);
is($f, 1);
$f = $f->rat;
$f = $f->add('3/7');
is($f, '10/7');
$f = $f->log10;
like($f, qr/^0\.15490195998574316928778374\d*/);
$f = $f->log10;
like($f, qr/^-0\.809943087046425840374251533\d*/);
$f = $f->log10;
like($f, qr/^-0\.0915454969856344811384522\d*\+1\.36437635384184134748\d*i\z/);
$f = $f->log10;
like($f, qr/^0\.13590958714256937908116291991\d*\+0\.711284402196657627826\d*i\z/);

my $z = Math::AnyNum->new_z('12');
$z = $z->log;
like($z, qr/^2\.484906649788000310229709479838\d*\z/);
$z = $z->log($z);
is($z, 1);

my $z2 = Math::AnyNum->new_z('-12');
$z2 = $z2->log;
like($z2, qr/^2\.48490664978800031022970947983\d*\+3\.141592653589793238462643383\d*i\z/);
$z2 = $z2->log($z2);
is($z2, 1);

my $z3 = Math::AnyNum->new_z('12345');
$z3 = $z3->log('14');
like($z3, qr/^3\.5698377204836032070641968436795293361\d*\z/);
$z3 = $z3->log('2');
like($z3, qr/^1\.835858492972909133630016527893470154893\d*\z/);

my $c = Math::AnyNum->new_c('3', '4');
$c = $c->log;
like($c, qr/^1\.609437912434100374600759\d*\+0\.92729521800161223242851246292\d*i\z/);
$c = $c->log($c);
is($c, 1);

#
## ilog / ilog2 / ilog10
#
my $f2 = Math::AnyNum->new('9123124124123.42123123');
is($f2->ilog10,                       '12');
is(Math::AnyNum->new_z('123')->ilog2, '6');
is(Math::AnyNum->new_q('123', '4')->ilog2, '4');

my $f3 = Math::AnyNum->new('9123124124123.42123123');
is($f3->ilog(13),      '11');
is($f3->ilog(2),       '43');
is($f3->ilog(10),      '12');
is($f3->rat->ilog(16), '10');
