use strict;
use Test::More tests => 22605;

use_ok('Number::ZipCode::JP', 'company');

my $zip = Number::ZipCode::JP->new;
ok($zip->set_number('0018501')->is_valid_number, '学校法人 創成学園 札幌創成高等学校');
ok($zip->set_number('0018521')->is_valid_number, '札幌私書箱センター');
ok($zip->set_number('0018588')->is_valid_number, '北海道 札幌道税事務所 自動車税部');
ok($zip->set_number('0018612')->is_valid_number, '札幌市北区役所');
ok($zip->set_number('0028501')->is_valid_number, '北海道教育大学 本部');
ok($zip->set_number('0028502')->is_valid_number, '北海道教育大学 札幌校');
ok($zip->set_number('0028503')->is_valid_number, '北海道教育大学 附属図書館');
ok($zip->set_number('0028504')->is_valid_number, '北海道 有朋高等学校');
ok($zip->set_number('0038501')->is_valid_number, '三菱ふそうトラック・バス 株式会社 北海道ふそう');
ok($zip->set_number('0038502')->is_valid_number, '大丸藤井 (株)');
ok($zip->set_number('0038503')->is_valid_number, 'ブリヂストンタイヤ北海道販売 (株)');
ok($zip->set_number('0038504')->is_valid_number, '大丸藤井 (株)');
ok($zip->set_number('0038505')->is_valid_number, '札幌市 衛生研究所');
ok($zip->set_number('0038510')->is_valid_number, '勤医協 札幌病院');
ok($zip->set_number('0038511')->is_valid_number, '(株) クワザワ工業');
ok($zip->set_number('0038515')->is_valid_number, '(株) アレフ');
ok($zip->set_number('0038519')->is_valid_number, '株式会社 東光ストア');
ok($zip->set_number('0038530')->is_valid_number, '日本年金機構 札幌東年金事務所');
ok($zip->set_number('0038531')->is_valid_number, '北海電気工事 株式会社');
ok($zip->set_number('0038558')->is_valid_number, 'ミサワホーム北海道 株式会社');
ok($zip->set_number('0038566')->is_valid_number, '株式会社 RJオグラ');
ok($zip->set_number('0038567')->is_valid_number, '(株) 恵和ビジネス');
ok($zip->set_number('0038570')->is_valid_number, '北海道グルメ会');
ok($zip->set_number('0038577')->is_valid_number, 'ユアサ商事 株式会社 北海道支社');
ok($zip->set_number('0038580')->is_valid_number, '株式会社 菱食 北海道支社');
ok($zip->set_number('0038581')->is_valid_number, '株式会社 リョーショクリカー 北海道支社');
ok($zip->set_number('0038582')->is_valid_number, '株式会社 北海道リョーショク');
ok($zip->set_number('0038585')->is_valid_number, '医療法人 東札幌病院');
ok($zip->set_number('0038588')->is_valid_number, '株式会社 札幌パリ');
ok($zip->set_number('0038601')->is_valid_number, '日本通運 株式会社 札幌支店');
ok($zip->set_number('0038610')->is_valid_number, '株式会社 宮川建設');
ok($zip->set_number('0038612')->is_valid_number, '札幌市白石区役所');
ok($zip->set_number('0038630')->is_valid_number, 'イオン北海道 株式会社');
ok($zip->set_number('0038631')->is_valid_number, '株式会社 北海道観光物産興社');
ok($zip->set_number('0038639')->is_valid_number, '株式会社 ナニワ');
ok($zip->set_number('0038640')->is_valid_number, 'ダイハツ北海道販売 株式会社');
ok($zip->set_number('0038668')->is_valid_number, '独立行政法人 国際協力機構 札幌国際センター');
ok($zip->set_number('0038701')->is_valid_number, '西山製麺 株式会社');
ok($zip->set_number('0038702')->is_valid_number, '北海道銀行 事務センター');
ok($zip->set_number('0038705')->is_valid_number, 'NTT北海道情報システムサービスセンター');
ok($zip->set_number('0048502')->is_valid_number, '丸善(株)札幌支店営業センター');
ok($zip->set_number('0048503')->is_valid_number, '北海道札幌清田高等学校');
ok($zip->set_number('0048505')->is_valid_number, '北海道いすゞ自動車 株式会社 清田営業所');
ok($zip->set_number('0048510')->is_valid_number, '(株) 松井');
ok($zip->set_number('0048512')->is_valid_number, '東日本高速道路 株式会社 北海道支社');
ok($zip->set_number('0048515')->is_valid_number, '丸善らがぁーる 新札幌DUO店');
ok($zip->set_number('0048518')->is_valid_number, '札幌東労働基準監督署');
ok($zip->set_number('0048522')->is_valid_number, '日特建設 株式会社 札幌支店');
ok($zip->set_number('0048523')->is_valid_number, '日産ディーゼル北海道販売 株式会社');
ok($zip->set_number('0048530')->is_valid_number, '株式会社 弁釜');
ok($zip->set_number('0048531')->is_valid_number, '雪印種苗 株式会社');
ok($zip->set_number('0048533')->is_valid_number, '北星学園大学図書館');
ok($zip->set_number('0048550')->is_valid_number, '富士通札幌システムラボラトリ');
ok($zip->set_number('0048555')->is_valid_number, '札幌市交通局');
ok($zip->set_number('0048558')->is_valid_number, '日本年金機構 新さっぽろ年金事務所');
ok($zip->set_number('0048560')->is_valid_number, '北海道年金裁定センター');
ok($zip->set_number('0048567')->is_valid_number, '創価学会 北海道方面事務局');
ok($zip->set_number('0048577')->is_valid_number, '(株) ダイエーカテプリ 新さっぽろ');
ok($zip->set_number('0048585')->is_valid_number, '(株) ドーコン');
ok($zip->set_number('0048588')->is_valid_number, '北海道コカ・コーラボトリング(株)');
ok($zip->set_number('0048602')->is_valid_number, '札幌国際大学');
ok($zip->set_number('0048603')->is_valid_number, '札幌国際大学短期大学部');
ok($zip->set_number('0048610')->is_valid_number, '三菱電機住環境システムズ 株式会社 北海道社');
ok($zip->set_number('0048611')->is_valid_number, 'ホーマック 株式会社');
ok($zip->set_number('0048612')->is_valid_number, '札幌市厚別区役所');
ok($zip->set_number('0048613')->is_valid_number, '札幌市清田区役所');
ok($zip->set_number('0048616')->is_valid_number, '清田区 土木センター');
ok($zip->set_number('0048618')->is_valid_number, '札幌社会保険総合病院');
ok($zip->set_number('0048629')->is_valid_number, 'プリマハム 株式会社 北海道支店');
ok($zip->set_number('0048631')->is_valid_number, '北星学園大学');
ok($zip->set_number('0048641')->is_valid_number, '札幌市東部市税事務所');
ok($zip->set_number('0058501')->is_valid_number, '医療法人 愛全会 愛全病院');
ok($zip->set_number('0058543')->is_valid_number, '陸上自衛隊 真駒内駐屯地');
ok($zip->set_number('0058555')->is_valid_number, '医療法人 医仁会 中村記念南病院');
ok($zip->set_number('0058585')->is_valid_number, '岡本興業 株式会社');
ok($zip->set_number('0058601')->is_valid_number, '北海道東海大学 札幌校舎');
ok($zip->set_number('0058602')->is_valid_number, '東海大学付属第四高等学校・東海大学付属第四高等学校中等部');
ok($zip->set_number('0058612')->is_valid_number, '札幌市南区役所');
ok($zip->set_number('0058798')->is_valid_number, '札幌逓信病院');
ok($zip->set_number('0068520')->is_valid_number, '(株) ニトリ');
ok($zip->set_number('0068530')->is_valid_number, '札幌市山口斎場');
ok($zip->set_number('0068555')->is_valid_number, '医療法人 渓仁会 手稲渓仁会病院');
ok($zip->set_number('0068561')->is_valid_number, '株式会社 ムトウ SPDセンター');
ok($zip->set_number('0068585')->is_valid_number, '北海道工業大学');
ok($zip->set_number('0068612')->is_valid_number, '札幌市手稲区役所');
ok($zip->set_number('0078501')->is_valid_number, 'オリヒロ (株) 札幌営業所');
ok($zip->set_number('0078503')->is_valid_number, '丘珠駐屯地');
ok($zip->set_number('0078505')->is_valid_number, '勤医協 中央病院');
ok($zip->set_number('0078507')->is_valid_number, '北海道日野自動車 (株)');
ok($zip->set_number('0078508')->is_valid_number, '泉州電業 株式会社 札幌支店');
ok($zip->set_number('0078632')->is_valid_number, '札幌日産自動車 株式会社 東苗穂店');
ok($zip->set_number('0100195')->is_valid_number, '公立大学法人 秋田県立大学');
ok($zip->set_number('0100492')->is_valid_number, 'あきたこまち生産者協会');
ok($zip->set_number('0100493')->is_valid_number, '秋田県男鹿市役所若美庁舎');
ok($zip->set_number('0100494')->is_valid_number, '大潟村役場');
ok($zip->set_number('0100595')->is_valid_number, '男鹿市役所');
ok($zip->set_number('0101292')->is_valid_number, '公立大学法人 国際教養大学');
ok($zip->set_number('0101492')->is_valid_number, '日本赤十字秋田短期大学');
ok($zip->set_number('0101493')->is_valid_number, '日本赤十字秋田看護大学');
ok($zip->set_number('0101494')->is_valid_number, '株式会社 中三 秋田店');
ok($zip->set_number('0108501')->is_valid_number, '日本放送協会 秋田放送局');
ok($zip->set_number('0108502')->is_valid_number, '国立大学法人 秋田大学');
ok($zip->set_number('0108504')->is_valid_number, '秋田地方・家庭・簡易裁判所');
ok($zip->set_number('0108505')->is_valid_number, '株式会社 西武百貨店 秋田店');
ok($zip->set_number('0108507')->is_valid_number, '全国健康保険協会 秋田支部');
ok($zip->set_number('0108515')->is_valid_number, '学校法人 ノースアジア大学');
ok($zip->set_number('0108518')->is_valid_number, '株式会社 秋田ト一屋');
ok($zip->set_number('0108520')->is_valid_number, '株式会社 相場商店');
ok($zip->set_number('0108522')->is_valid_number, '株式会社 イトーヨーカドー 秋田店');
ok($zip->set_number('0108525')->is_valid_number, '明桜高等学校');
ok($zip->set_number('0108530')->is_valid_number, '秋田ステーションビル 株式会社');
ok($zip->set_number('0108533')->is_valid_number, '学校法人 聖霊学園');
ok($zip->set_number('0108543')->is_valid_number, '秋田大学医学部附属病院');
ok($zip->set_number('0108550')->is_valid_number, '東北森林管理局');
ok($zip->set_number('0108558')->is_valid_number, '全国農業協同組合連合会 秋田県本部');
ok($zip->set_number('0108560')->is_valid_number, '秋田市役所');
ok($zip->set_number('0108564')->is_valid_number, '(株) シグマ ソリューションズ');
ok($zip->set_number('0108570')->is_valid_number, '秋田県庁');
ok($zip->set_number('0108572')->is_valid_number, '秋田県庁 第二庁舎');
ok($zip->set_number('0108574')->is_valid_number, '東日本電信電話 株式会社 秋田支店');
ok($zip->set_number('0108577')->is_valid_number, '医療法人 明和会 中通総合病院');
ok($zip->set_number('0108580')->is_valid_number, '秋田県教育委員会 秋田県教育庁');
ok($zip->set_number('0108585')->is_valid_number, '株式会社 トーケムプロダクツ');
ok($zip->set_number('0108588')->is_valid_number, '東北電力 株式会社 秋田営業所');
ok($zip->set_number('0108601')->is_valid_number, '株式会社 秋田魁新報社');
ok($zip->set_number('0108611')->is_valid_number, '株式会社 秋田放送');
ok($zip->set_number('0108622')->is_valid_number, '秋田南税務署');
ok($zip->set_number('0108633')->is_valid_number, '商工組合 中央金庫 秋田支店');
ok($zip->set_number('0108655')->is_valid_number, '株式会社 秋田銀行');
ok($zip->set_number('0108668')->is_valid_number, '秋田テレビ 株式会社');
ok($zip->set_number('0108677')->is_valid_number, '株式会社 北都銀行');
ok($zip->set_number('0108678')->is_valid_number, '秋田ゼロックス 株式会社');
ok($zip->set_number('0108794')->is_valid_number, '株式会社 ゆうちょ銀行 秋田地域センター');
ok($zip->set_number('0118501')->is_valid_number, '株式会社 ホテル大和');
ok($zip->set_number('0118510')->is_valid_number, '秋田住友ベーク 株式会社');
ok($zip->set_number('0118511')->is_valid_number, '秋田工業高等専門学校');
ok($zip->set_number('0118520')->is_valid_number, '誠文社');
ok($zip->set_number('0118555')->is_valid_number, '秋田製錬 株式会社');
ok($zip->set_number('0118577')->is_valid_number, '秋田北税務署');
ok($zip->set_number('0118585')->is_valid_number, '秋田海陸運送 株式会社');
ok($zip->set_number('0118605')->is_valid_number, '株式会社 北都銀行 土崎支店');
ok($zip->set_number('0118611')->is_valid_number, '陸上自衛隊 秋田駐屯地');
ok($zip->set_number('0118686')->is_valid_number, '株式会社 秋田銀行 土崎支店');
ok($zip->set_number('0128501')->is_valid_number, '湯沢市役所');
ok($zip->set_number('0128502')->is_valid_number, '湯沢 税務署');
ok($zip->set_number('0128511')->is_valid_number, '秋田県醗酵工業 株式会社');
ok($zip->set_number('0128601')->is_valid_number, '株式会社 皆常商店');
ok($zip->set_number('0128604')->is_valid_number, '株式会社 秋田銀行 湯沢支店');
ok($zip->set_number('0128651')->is_valid_number, '株式会社 丸大工機商会');
ok($zip->set_number('0130498')->is_valid_number, '秋田睦合成 株式会社');
ok($zip->set_number('0138501')->is_valid_number, '日本電信電話 株式会社 横手支店');
ok($zip->set_number('0138502')->is_valid_number, '秋田県平鹿地域振興局');
ok($zip->set_number('0138503')->is_valid_number, '秋田県平鹿地域振興局 福祉環境部');
ok($zip->set_number('0138504')->is_valid_number, '横手税務署');
ok($zip->set_number('0138592')->is_valid_number, 'ユニシアジェーケーシーステアリングシステム 株式会社 秋田工場');
ok($zip->set_number('0138601')->is_valid_number, '横手市役所');
ok($zip->set_number('0138602')->is_valid_number, '市立 横手病院');
ok($zip->set_number('0138609')->is_valid_number, '横手公共職業安定所');
ok($zip->set_number('0138610')->is_valid_number, '平鹿総合病院');
ok($zip->set_number('0140292')->is_valid_number, '大仙市役所 中仙総合支所');
ok($zip->set_number('0140392')->is_valid_number, '仙北市角館庁舎');
ok($zip->set_number('0140393')->is_valid_number, '秋田県立 角館高等学校');
ok($zip->set_number('0140394')->is_valid_number, '仙北市立 角館総合病院');
ok($zip->set_number('0140592')->is_valid_number, '仙北市役所 西木庁舎');
ok($zip->set_number('0141192')->is_valid_number, '株式会社 わらび座');
ok($zip->set_number('0141298')->is_valid_number, '仙北市役所 田沢湖庁舎');
ok($zip->set_number('0148601')->is_valid_number, '大仙市役所');
ok($zip->set_number('0148611')->is_valid_number, '大曲税務署');
ok($zip->set_number('0150295')->is_valid_number, '由利本荘市 東由利総合支所');
ok($zip->set_number('0158501')->is_valid_number, '由利本荘市役所');
ok($zip->set_number('0158505')->is_valid_number, '秋田社会保険事務局 本荘事務所');
ok($zip->set_number('0158510')->is_valid_number, '秋田プリマ食品 株式会社');
ok($zip->set_number('0158511')->is_valid_number, '由利組合総合病院');
ok($zip->set_number('0158515')->is_valid_number, '由利地域振興局');
ok($zip->set_number('0158530')->is_valid_number, '秋田県立由利工業高等学校');
ok($zip->set_number('0158543')->is_valid_number, '秋田県立 由利高等学校');
ok($zip->set_number('0158555')->is_valid_number, '佐藤病院');
ok($zip->set_number('0158558')->is_valid_number, '株式会社 秋田新電元本社 大浦工場');
ok($zip->set_number('0158567')->is_valid_number, '医療法人 青嵐会 (本荘第一病院)');
ok($zip->set_number('0158585')->is_valid_number, '秋田県立 本荘高等学校');
ok($zip->set_number('0158601')->is_valid_number, '羽後信用金庫');
ok($zip->set_number('0158602')->is_valid_number, '株式会社 北都銀行 本荘支店');
ok($zip->set_number('0158611')->is_valid_number, '株式会社 秋田銀行 本荘支店');
ok($zip->set_number('0158622')->is_valid_number, '本荘税務署');
ok($zip->set_number('0158630')->is_valid_number, '村岡建設工業 株式会社');
ok($zip->set_number('0158642')->is_valid_number, '由利本荘市ガス水道局');
ok($zip->set_number('0158666')->is_valid_number, '医療法人 荘和会(菅原病院・老人保険施設荘和)');
ok($zip->set_number('0158686')->is_valid_number, '小林工業 株式会社');
ok($zip->set_number('0158688')->is_valid_number, '長田建設 株式会社');
ok($zip->set_number('0168501')->is_valid_number, '能代市役所');
ok($zip->set_number('0168555')->is_valid_number, '山本地方部 県民室');
ok($zip->set_number('0168601')->is_valid_number, '能代税務署');
ok($zip->set_number('0168602')->is_valid_number, '株式会社 秋田銀行 能代駅前支店');
ok($zip->set_number('0170292')->is_valid_number, '小坂町役場');
ok($zip->set_number('0170293')->is_valid_number, 'タナックス (株)');
ok($zip->set_number('0178510')->is_valid_number, 'いとく大館ショッピングセンター');
ok($zip->set_number('0178550')->is_valid_number, '大館市立総合病院');
ok($zip->set_number('0178555')->is_valid_number, '大館市役所');
ok($zip->set_number('0178567')->is_valid_number, '国民生活金融公庫 大館支店');
ok($zip->set_number('0178585')->is_valid_number, '秋北バス 株式会社');
ok($zip->set_number('0178686')->is_valid_number, '大館 税務署');
ok($zip->set_number('0180192')->is_valid_number, 'にかほ市役所 象潟庁舎');
ok($zip->set_number('0180492')->is_valid_number, 'にかほ市役所 仁賀保庁舎');
ok($zip->set_number('0180493')->is_valid_number, 'TDK 株式会社 秋田地区');
ok($zip->set_number('0180692')->is_valid_number, '由利本荘市役所 西目総合支所');
ok($zip->set_number('0180795')->is_valid_number, '由利本荘市役所 大内総合支所');
ok($zip->set_number('0181392')->is_valid_number, '由利本荘市 岩城総合支所');
ok($zip->set_number('0181393')->is_valid_number, '独立行政法人 国立病院機構 あきた病院');
ok($zip->set_number('0181595')->is_valid_number, '潟上市役所 飯田川庁舎');
ok($zip->set_number('0181596')->is_valid_number, '井川町役場');
ok($zip->set_number('0181692')->is_valid_number, '八郎潟町役場');
ok($zip->set_number('0181792')->is_valid_number, '五城目町役場');
ok($zip->set_number('0181793')->is_valid_number, '秋田信用金庫 五城目支店');
ok($zip->set_number('0182498')->is_valid_number, '三種町役場');
ok($zip->set_number('0183192')->is_valid_number, '能代市役所 二ツ井町庁舎');
ok($zip->set_number('0183392')->is_valid_number, '北秋田市役所');
ok($zip->set_number('0183393')->is_valid_number, '秋田県 北秋田地域振興局');
ok($zip->set_number('0183592')->is_valid_number, '株式会社 日本オート電子工業');
ok($zip->set_number('0183593')->is_valid_number, '株式会社 田代製作所');
ok($zip->set_number('0183595')->is_valid_number, '大館市役所 田代総合支所');
ok($zip->set_number('0183596')->is_valid_number, '秋田共同乳業 株式会社');
ok($zip->set_number('0184392')->is_valid_number, '北秋田市役所 森吉支所');
ok($zip->set_number('0184393')->is_valid_number, '公立 米内沢総合病院');
ok($zip->set_number('0184394')->is_valid_number, '国土交通省 東北地方整備局 森吉山ダム工事事務所');
ok($zip->set_number('0184395')->is_valid_number, '秋田県立 米内沢高等学校');
ok($zip->set_number('0184494')->is_valid_number, '上小阿仁村役場');
ok($zip->set_number('0184692')->is_valid_number, '北秋田市役所 阿仁支所');
ok($zip->set_number('0184693')->is_valid_number, '阿仁スキー場');
ok($zip->set_number('0185292')->is_valid_number, '鹿角市役所');
ok($zip->set_number('0185792')->is_valid_number, '大館市役所 比内総合支所');
ok($zip->set_number('0185793')->is_valid_number, '大館市立 扇田病院');
ok($zip->set_number('0190792')->is_valid_number, '横手市役所 増田地域局');
ok($zip->set_number('0190793')->is_valid_number, 'JUKI電子工業 株式会社');
ok($zip->set_number('0191397')->is_valid_number, '株式会社 ヤマダフーズ');
ok($zip->set_number('0191692')->is_valid_number, '大仙市 太田総合支所');
ok($zip->set_number('0192192')->is_valid_number, '大仙市役所 西仙北総合支所');
ok($zip->set_number('0192692')->is_valid_number, '秋田市河辺市民センター');
ok($zip->set_number('0200180')->is_valid_number, 'いわて生活 協同組合');
ok($zip->set_number('0200181')->is_valid_number, '岩手県学校生活 協同組合');
ok($zip->set_number('0200182')->is_valid_number, '株式会社 赤澤紙業');
ok($zip->set_number('0200183')->is_valid_number, '盛岡大学');
ok($zip->set_number('0200184')->is_valid_number, '山口北州印刷 株式会社');
ok($zip->set_number('0200185')->is_valid_number, '株式会社 石田商会');
ok($zip->set_number('0200187')->is_valid_number, '菱和建設 株式会社');
ok($zip->set_number('0200188')->is_valid_number, '株式会社 ミクニ');
ok($zip->set_number('0200192')->is_valid_number, '滝沢村役場');
ok($zip->set_number('0200193')->is_valid_number, '岩手県立大学');
ok($zip->set_number('0200195')->is_valid_number, '日本たばこ産業 (株) 東北地方原料本部');
ok($zip->set_number('0200196')->is_valid_number, '財団法人 岩手県青少年会館');
ok($zip->set_number('0200198')->is_valid_number, '独立行政法人 農業・食品産業技術総合研究機構 東北農業研究センター');
ok($zip->set_number('0200493')->is_valid_number, '東北資材工業 株式会社');
ok($zip->set_number('0200495')->is_valid_number, '白石食品工業 株式会社');
ok($zip->set_number('0200496')->is_valid_number, '株式会社 ベルセンター乙部');
ok($zip->set_number('0200592')->is_valid_number, '新岩手農業協同組合 雫石中央支所');
ok($zip->set_number('0200593')->is_valid_number, '株式会社 プリンスホテル 雫石プリンスホテル');
ok($zip->set_number('0200595')->is_valid_number, '雫石町役場');
ok($zip->set_number('0200596')->is_valid_number, '盛岡セイコー工業 株式会社');
ok($zip->set_number('0208501')->is_valid_number, '盛岡グランドホテル');
ok($zip->set_number('0208502')->is_valid_number, 'ホーマック 株式会社 盛岡事務所');
ok($zip->set_number('0208505')->is_valid_number, '学校法人 岩手医科大学');
ok($zip->set_number('0208507')->is_valid_number, '盛岡商工会議所');
ok($zip->set_number('0208508')->is_valid_number, '全国健康保険協会 岩手支部');
ok($zip->set_number('0208510')->is_valid_number, '岩手県自治会館');
ok($zip->set_number('0208511')->is_valid_number, '盛岡社会保険事務所');
ok($zip->set_number('0208512')->is_valid_number, '株式会社 エフエム岩手');
ok($zip->set_number('0208513')->is_valid_number, '株式会社 東山堂');
ok($zip->set_number('0208515')->is_valid_number, '岩手県立 盛岡第一高等学校');
ok($zip->set_number('0208518')->is_valid_number, '盛岡ターミナルビル 株式会社');
ok($zip->set_number('0208520')->is_valid_number, '盛岡地方裁判所');
ok($zip->set_number('0208521')->is_valid_number, '東北電力 株式会社 盛岡営業所');
ok($zip->set_number('0208522')->is_valid_number, '岩手労働基準局');
ok($zip->set_number('0208525')->is_valid_number, 'JTB 盛岡支店');
ok($zip->set_number('0208530')->is_valid_number, '盛岡市役所');
ok($zip->set_number('0208531')->is_valid_number, '盛岡市役所 若園町分庁舎');
ok($zip->set_number('0208532')->is_valid_number, '盛岡市役所 都南総合支所');
ok($zip->set_number('0208533')->is_valid_number, '東日本旅客鉄道 株式会社 盛岡支社');
ok($zip->set_number('0208540')->is_valid_number, '岩手県 警察本部');
ok($zip->set_number('0208543')->is_valid_number, '岩手県立 杜陵高等学校');
ok($zip->set_number('0208544')->is_valid_number, '株式会社 アイシーエス');
ok($zip->set_number('0208550')->is_valid_number, '岩手大学 (本部関係)');
ok($zip->set_number('0208551')->is_valid_number, '岩手大学 工学部');
ok($zip->set_number('0208553')->is_valid_number, '協同組合 日専連盛岡');
ok($zip->set_number('0208555')->is_valid_number, '日本放送協会 盛岡放送局');
ok($zip->set_number('0208557')->is_valid_number, '株式会社 日専連パートナーズ');
ok($zip->set_number('0208558')->is_valid_number, '東日本電信電話 株式会社 岩手支店');
ok($zip->set_number('0208560')->is_valid_number, '盛岡赤十字病院');
ok($zip->set_number('0208561')->is_valid_number, '株式会社 木津屋本店');
ok($zip->set_number('0208566')->is_valid_number, '株式会社 IBC岩手放送');
ok($zip->set_number('0208567')->is_valid_number, '盛岡市中央御売市場');
ok($zip->set_number('0208570')->is_valid_number, '岩手県庁');
ok($zip->set_number('0208573')->is_valid_number, '株式会社 中三盛岡店');
ok($zip->set_number('0208575')->is_valid_number, '株式会社 ワイズマン');
ok($zip->set_number('0208577')->is_valid_number, '岩手県衛生研究所');
ok($zip->set_number('0208580')->is_valid_number, '東京海上日動火災保険 株式会社 盛岡支店');
ok($zip->set_number('0208584')->is_valid_number, '社団法人 岩手県医師会');
ok($zip->set_number('0208585')->is_valid_number, '財団法人 岩手県予防医学協会');
ok($zip->set_number('0208586')->is_valid_number, '東日本ハウス 株式会社');
ok($zip->set_number('0208588')->is_valid_number, '株式会社 タカヤ');
ok($zip->set_number('0208601')->is_valid_number, '東北労働金庫 岩手県本部');
ok($zip->set_number('0208602')->is_valid_number, '日本生命保険 相互会社 盛岡支社');
ok($zip->set_number('0208605')->is_valid_number, '全国農業協同組合連合会 岩手県本部');
ok($zip->set_number('0208606')->is_valid_number, '株式会社 東北銀行');
ok($zip->set_number('0208610')->is_valid_number, '国民生活金融公庫 盛岡支店');
ok($zip->set_number('0208611')->is_valid_number, '岩手繊維 株式会社');
ok($zip->set_number('0208612')->is_valid_number, 'エビー 株式会社');
ok($zip->set_number('0208620')->is_valid_number, '株式会社 三田商店');
ok($zip->set_number('0208622')->is_valid_number, '岩手日報社');
ok($zip->set_number('0208633')->is_valid_number, '岩手めんこいテレビ');
ok($zip->set_number('0208641')->is_valid_number, '盛岡信用金庫');
ok($zip->set_number('0208650')->is_valid_number, '株式会社 テレビ岩手');
ok($zip->set_number('0208654')->is_valid_number, '農林中央金庫 盛岡支店');
ok($zip->set_number('0208655')->is_valid_number, '株式会社 川徳');
ok($zip->set_number('0208661')->is_valid_number, '株式会社 木津屋本店');
ok($zip->set_number('0208666')->is_valid_number, '株式会社 北日本銀行');
ok($zip->set_number('0208667')->is_valid_number, '株式会社 熊善商店');
ok($zip->set_number('0208672')->is_valid_number, '第一開明 株式会社');
ok($zip->set_number('0208677')->is_valid_number, '盛岡税務署');
ok($zip->set_number('0208678')->is_valid_number, '東北住建 株式会社');
ok($zip->set_number('0208686')->is_valid_number, '株式会社 東流社 北東北支店 盛岡営業所');
ok($zip->set_number('0208688')->is_valid_number, '株式会社 岩手銀行');
ok($zip->set_number('0208794')->is_valid_number, '岩手地域センター');
ok($zip->set_number('0218501')->is_valid_number, '一関市役所');
ok($zip->set_number('0218502')->is_valid_number, '一関社会保険事務所');
ok($zip->set_number('0218503')->is_valid_number, '県南広域振興局 一関総合支局');
ok($zip->set_number('0218504')->is_valid_number, '一関教育事務所');
ok($zip->set_number('0218506')->is_valid_number, '一関保健所');
ok($zip->set_number('0218511')->is_valid_number, '国立一関工業高等専門学校');
ok($zip->set_number('0218544')->is_valid_number, '株式会社 佐原');
ok($zip->set_number('0218555')->is_valid_number, '株式会社 平野組');
ok($zip->set_number('0218566')->is_valid_number, '日本電産コパル 株式会社 一関工場');
ok($zip->set_number('0218567')->is_valid_number, 'NECトーキン岩手 株式会社 岩手事業所');
ok($zip->set_number('0218577')->is_valid_number, 'おりお 株式会社');
ok($zip->set_number('0218604')->is_valid_number, '一関税務署');
ok($zip->set_number('0218611')->is_valid_number, '東北日本電気 株式会社');
ok($zip->set_number('0218633')->is_valid_number, '株式会社 佐々木組');
ok($zip->set_number('0218687')->is_valid_number, '岩手日日新聞社 東台センター');
ok($zip->set_number('0228501')->is_valid_number, '大船渡市役所');
ok($zip->set_number('0228502')->is_valid_number, '大船渡地方振興局');
ok($zip->set_number('0228503')->is_valid_number, '(株) マイヤ');
ok($zip->set_number('0228504')->is_valid_number, '株式会社 アマタケ');
ok($zip->set_number('0228505')->is_valid_number, '大船渡水産物商業協同組合');
ok($zip->set_number('0228507')->is_valid_number, '大船渡農業協同組合');
ok($zip->set_number('0228508')->is_valid_number, '鎌田水産 株式会社');
ok($zip->set_number('0228512')->is_valid_number, '岩手県立 大船渡病院');
ok($zip->set_number('0228602')->is_valid_number, '橋爪商事 (株)');
ok($zip->set_number('0230492')->is_valid_number, '奥州市 胆沢総合支所');
ok($zip->set_number('0230493')->is_valid_number, '(株) 小山製麺');
ok($zip->set_number('0231192')->is_valid_number, '奥州市 江刺総合支所');
ok($zip->set_number('0238501')->is_valid_number, '奥州市役所');
ok($zip->set_number('0238502')->is_valid_number, '水沢公共職業安定所');
ok($zip->set_number('0240192')->is_valid_number, '岩手スリーエム 株式会社');
ok($zip->set_number('0240193')->is_valid_number, '明治製菓 株式会社 北上工場');
ok($zip->set_number('0240194')->is_valid_number, '株式会社 鈴木商館 岩手営業所');
ok($zip->set_number('0240195')->is_valid_number, 'グリンクス 株式会社');
ok($zip->set_number('0240392')->is_valid_number, '北上市役所 和賀庁舎');
ok($zip->set_number('0248501')->is_valid_number, '北上市役所');
ok($zip->set_number('0248505')->is_valid_number, '北上市農業協同組合');
ok($zip->set_number('0248507')->is_valid_number, '岩手県立 中部病院');
ok($zip->set_number('0248510')->is_valid_number, '岩手東芝エレクトロニクス 株式会社');
ok($zip->set_number('0248511')->is_valid_number, 'さくら野百貨店 北上店');
ok($zip->set_number('0248513')->is_valid_number, '専修大学 北上福祉教育専門学校');
ok($zip->set_number('0248518')->is_valid_number, '岩手県立 黒沢尻工業高等学校');
ok($zip->set_number('0248520')->is_valid_number, '北上地方振興局');
ok($zip->set_number('0248650')->is_valid_number, 'アムコー岩手 株式会社');
ok($zip->set_number('0250392')->is_valid_number, '花巻温泉 株式会社');
ok($zip->set_number('0250393')->is_valid_number, '株式会社 小田島');
ok($zip->set_number('0250394')->is_valid_number, 'リコー光学 株式会社');
ok($zip->set_number('0250395')->is_valid_number, '岩手県立 総合教育センター');
ok($zip->set_number('0258601')->is_valid_number, '花巻市役所');
ok($zip->set_number('0258602')->is_valid_number, '花巻 税務署');
ok($zip->set_number('0268550')->is_valid_number, '岩手県立 釜石病院');
ok($zip->set_number('0268567')->is_valid_number, '新日本製鐵 株式会社 釜石製鐵所');
ok($zip->set_number('0268686')->is_valid_number, '釜石市役所');
ok($zip->set_number('0270595')->is_valid_number, '岩泉町役場');
ok($zip->set_number('0278501')->is_valid_number, '宮古市役所');
ok($zip->set_number('0278502')->is_valid_number, '岩手県立 宮古病院');
ok($zip->set_number('0278503')->is_valid_number, '宮古社会保険事務所');
ok($zip->set_number('0280192')->is_valid_number, '花巻市 東和総合支所');
ok($zip->set_number('0280392')->is_valid_number, '遠野市 宮守総合支所');
ok($zip->set_number('0280592')->is_valid_number, '遠野市役所');
ok($zip->set_number('0281192')->is_valid_number, '大槌町役場');
ok($zip->set_number('0281392')->is_valid_number, '山田町役場');
ok($zip->set_number('0283392')->is_valid_number, '紫波町役場');
ok($zip->set_number('0283692')->is_valid_number, '矢巾町役場');
ok($zip->set_number('0283694')->is_valid_number, '岩手医科大学 矢巾キャンパス');
ok($zip->set_number('0283697')->is_valid_number, '株式会社 昆松');
ok($zip->set_number('0284193')->is_valid_number, '北日本機械 株式会社');
ok($zip->set_number('0284195')->is_valid_number, '盛岡市役所 玉山総合事務所');
ok($zip->set_number('0284393')->is_valid_number, '岩手警察署');
ok($zip->set_number('0284395')->is_valid_number, '岩手町役場');
ok($zip->set_number('0284398')->is_valid_number, '岩手県立 沼宮内高等学校');
ok($zip->set_number('0285495')->is_valid_number, '葛巻町役場');
ok($zip->set_number('0286192')->is_valid_number, '二戸市役所');
ok($zip->set_number('0286193')->is_valid_number, '岩手県立 二戸病院');
ok($zip->set_number('0286195')->is_valid_number, '株式会社 菅文');
ok($zip->set_number('0286196')->is_valid_number, '二戸社会保険事務所');
ok($zip->set_number('0286198')->is_valid_number, '二戸市総合福祉センター');
ok($zip->set_number('0286892')->is_valid_number, '二戸市役所 浄法寺総合支所');
ok($zip->set_number('0287192')->is_valid_number, '八幡平市役所');
ok($zip->set_number('0287392')->is_valid_number, '八幡平市 松尾総合支所');
ok($zip->set_number('0287393')->is_valid_number, '安比高原ゴルフクラブ');
ok($zip->set_number('0287394')->is_valid_number, '八幡平ロイヤルホテル');
ok($zip->set_number('0287395')->is_valid_number, '株式会社 岩手ホテル&リゾート');
ok($zip->set_number('0287396')->is_valid_number, 'ホテル安比グランド');
ok($zip->set_number('0287592')->is_valid_number, '八幡平市 安代総合支所');
ok($zip->set_number('0287995')->is_valid_number, '洋野町役場');
ok($zip->set_number('0288030')->is_valid_number, '久慈市役所');
ok($zip->set_number('0288031')->is_valid_number, '宮城建設 株式会社');
ok($zip->set_number('0288040')->is_valid_number, '岩手県立 久慈病院');
ok($zip->set_number('0288042')->is_valid_number, '久慈地方振興局');
ok($zip->set_number('0288392')->is_valid_number, '普代村役場');
ok($zip->set_number('0288696')->is_valid_number, '久慈市役所 山形総合支所');
ok($zip->set_number('0290192')->is_valid_number, '岩手県立 磐井病院');
ok($zip->set_number('0292292')->is_valid_number, '陸前高田市役所');
ok($zip->set_number('0292293')->is_valid_number, '陸前高田市 農業協合組合');
ok($zip->set_number('0292396')->is_valid_number, '住田町役場');
ok($zip->set_number('0294192')->is_valid_number, '平泉町役場');
ok($zip->set_number('0294194')->is_valid_number, '川嶋印刷 株式会社');
ok($zip->set_number('0294195')->is_valid_number, '中尊寺');
ok($zip->set_number('0294292')->is_valid_number, '奥州市 前沢総合支所');
ok($zip->set_number('0294293')->is_valid_number, 'ジャスコ 株式会社 前沢店');
ok($zip->set_number('0294592')->is_valid_number, '金ケ崎町役場');
ok($zip->set_number('0294593')->is_valid_number, '富士通マイクロエレクトロニクス 株式会社 岩手工場');
ok($zip->set_number('0295692')->is_valid_number, '西和賀町役場 沢内庁舎');
ok($zip->set_number('0300180')->is_valid_number, '株式会社 東奥日報社');
ok($zip->set_number('0300181')->is_valid_number, '青森朝日放送 株式会社');
ok($zip->set_number('0300183')->is_valid_number, '中水青森中央水産 株式会社');
ok($zip->set_number('0300184')->is_valid_number, '青森県立図書館');
ok($zip->set_number('0300185')->is_valid_number, '青森魚類 株式会社');
ok($zip->set_number('0300186')->is_valid_number, '丸大堀内 株式会社');
ok($zip->set_number('0300188')->is_valid_number, '八甲田ロープウェー 株式会社');
ok($zip->set_number('0300192')->is_valid_number, '富士通 株式会社 青森システムラボラトリ');
ok($zip->set_number('0300196')->is_valid_number, '青森公立大学');
ok($zip->set_number('0301393')->is_valid_number, '外ヶ浜町役場');
ok($zip->set_number('0301492')->is_valid_number, '外ヶ浜町役場 平舘支所');
ok($zip->set_number('0301496')->is_valid_number, '社会福祉法人 平舘福祉会 かもめ苑');
ok($zip->set_number('0301798')->is_valid_number, '外ヶ浜町役場 三厩支所');
ok($zip->set_number('0308503')->is_valid_number, '株式会社 中三 本店');
ok($zip->set_number('0308505')->is_valid_number, '青森県立 保健大学');
ok($zip->set_number('0308510')->is_valid_number, '協同組合 日専連青森');
ok($zip->set_number('0308511')->is_valid_number, '青森地方法務局');
ok($zip->set_number('0308513')->is_valid_number, '東日本電信電話 株式会社 青森支店');
ok($zip->set_number('0308515')->is_valid_number, '青森商工会議所');
ok($zip->set_number('0308520')->is_valid_number, '青森山田高等学校');
ok($zip->set_number('0308521')->is_valid_number, '株式会社 奥村工務店');
ok($zip->set_number('0308522')->is_valid_number, '青森地方裁判所');
ok($zip->set_number('0308523')->is_valid_number, '青森家庭裁判所');
ok($zip->set_number('0308524')->is_valid_number, '青森簡易裁判所');
ok($zip->set_number('0308530')->is_valid_number, '青森県税事務所');
ok($zip->set_number('0308533')->is_valid_number, '協同組合 サンロード青森');
ok($zip->set_number('0308540')->is_valid_number, '青森県 教育庁');
ok($zip->set_number('0308541')->is_valid_number, '青森県 信用保証協会');
ok($zip->set_number('0308543')->is_valid_number, '株式会社 角弘');
ok($zip->set_number('0308545')->is_valid_number, '青森地方検察庁');
ok($zip->set_number('0308550')->is_valid_number, '株式会社 オリエントコーポレーション 青森支店');
ok($zip->set_number('0308552')->is_valid_number, '全国健康保険協会 青森支部');
ok($zip->set_number('0308553')->is_valid_number, '青森県立 中央病院');
ok($zip->set_number('0308554')->is_valid_number, '日本年金機構 青森年金事務所');
ok($zip->set_number('0308555')->is_valid_number, '青森市役所');
ok($zip->set_number('0308556')->is_valid_number, '日本年金機構 青森事務センター');
ok($zip->set_number('0308558')->is_valid_number, '青森労働局');
ok($zip->set_number('0308560')->is_valid_number, '東北電力 株式会社 青森支店');
ok($zip->set_number('0308566')->is_valid_number, '青森県 環境保健センター');
ok($zip->set_number('0308567')->is_valid_number, '青森県 市町村職員共済組合');
ok($zip->set_number('0308570')->is_valid_number, '青森県庁');
ok($zip->set_number('0308574')->is_valid_number, 'さくら野東北 株式会社 青森店');
ok($zip->set_number('0308577')->is_valid_number, '財務省 東北財務局 青森財務事務所');
ok($zip->set_number('0308580')->is_valid_number, '東北電力 株式会社 青森営業所');
ok($zip->set_number('0308585')->is_valid_number, '株式会社 みちのく銀行 事務集中室');
ok($zip->set_number('0308604')->is_valid_number, '日本生命保険 相互会社 青森支社');
ok($zip->set_number('0308610')->is_valid_number, '株式会社 みちのく銀行事務センター');
ok($zip->set_number('0308611')->is_valid_number, '大和證券 株式会社 青森支店');
ok($zip->set_number('0308622')->is_valid_number, '株式会社 みちのく銀行');
ok($zip->set_number('0308633')->is_valid_number, '日本放送協会 青森放送局');
ok($zip->set_number('0308649')->is_valid_number, '青森県信用組合');
ok($zip->set_number('0308655')->is_valid_number, '青森放送 株式会社');
ok($zip->set_number('0308667')->is_valid_number, '商工組合中央金庫 青森支店');
ok($zip->set_number('0308668')->is_valid_number, '株式会社 青森銀行');
ok($zip->set_number('0308677')->is_valid_number, '日本銀行 青森支店');
ok($zip->set_number('0308686')->is_valid_number, '株式会社 青森テレビ');
ok($zip->set_number('0318501')->is_valid_number, '八戸工業大学');
ok($zip->set_number('0318504')->is_valid_number, 'マルヨ水産 株式会社');
ok($zip->set_number('0318505')->is_valid_number, '八戸工業大学第二高等学校');
ok($zip->set_number('0318507')->is_valid_number, '光星学院高等学校');
ok($zip->set_number('0318510')->is_valid_number, '八戸警察署');
ok($zip->set_number('0318511')->is_valid_number, '八戸商工会議所');
ok($zip->set_number('0318520')->is_valid_number, '株式会社 帝国データバンク 八戸支店');
ok($zip->set_number('0318533')->is_valid_number, '株式会社 三春屋');
ok($zip->set_number('0318538')->is_valid_number, '長崎屋 八戸店');
ok($zip->set_number('0318543')->is_valid_number, '有限会社 ヴィアノヴァ');
ok($zip->set_number('0318544')->is_valid_number, '学校法人 光星学院 本部事務局');
ok($zip->set_number('0318545')->is_valid_number, '医療法人 平成会');
ok($zip->set_number('0318550')->is_valid_number, '東北電力 株式会社 八戸営業所');
ok($zip->set_number('0318551')->is_valid_number, '青森労災病院');
ok($zip->set_number('0318555')->is_valid_number, '八戸市立 市民病院');
ok($zip->set_number('0318558')->is_valid_number, '株式会社 ヒグチ');
ok($zip->set_number('0318570')->is_valid_number, '株式会社 八戸パークホテル');
ok($zip->set_number('0318577')->is_valid_number, '株式会社 ヤマヨ');
ok($zip->set_number('0318585')->is_valid_number, 'ラピア (八戸ショッピングセンター)');
ok($zip->set_number('0318588')->is_valid_number, '八戸大学');
ok($zip->set_number('0318601')->is_valid_number, '株式会社 デーリー東北新聞社');
ok($zip->set_number('0318608')->is_valid_number, '八戸港湾運送 株式会社');
ok($zip->set_number('0318611')->is_valid_number, '八戸税務署');
ok($zip->set_number('0318612')->is_valid_number, '八戸信用金庫');
ok($zip->set_number('0318617')->is_valid_number, '大平洋金属 株式会社 八戸製造所');
ok($zip->set_number('0318655')->is_valid_number, '株式会社 吉田産業');
ok($zip->set_number('0318686')->is_valid_number, '八戸市役所');
ok($zip->set_number('0338604')->is_valid_number, '航空自衛隊 三沢基地');
ok($zip->set_number('0338666')->is_valid_number, '三沢市役所');
ok($zip->set_number('0338688')->is_valid_number, '株式会社 古牧温泉渋沢公園');
ok($zip->set_number('0340392')->is_valid_number, '十和田市役所 十和田湖支所');
ok($zip->set_number('0340393')->is_valid_number, '八甲田農業協同組合 十和田湖支店');
ok($zip->set_number('0340398')->is_valid_number, '奥入瀬渓流グランドホテル');
ok($zip->set_number('0348565')->is_valid_number, '東北電力 株式会社 十和田営業所');
ok($zip->set_number('0348578')->is_valid_number, '青森県立 三本木農業高等学校');
ok($zip->set_number('0348605')->is_valid_number, '株式会社 青森銀行 十和田支店');
ok($zip->set_number('0348613')->is_valid_number, '十和田税務署');
ok($zip->set_number('0348615')->is_valid_number, '十和田市役所');
ok($zip->set_number('0348618')->is_valid_number, '株式会社 ササキコーポレーション');
ok($zip->set_number('0348628')->is_valid_number, '北里大学 獣医畜産学部');
ok($zip->set_number('0358686')->is_valid_number, 'むつ市役所');
ok($zip->set_number('0360392')->is_valid_number, '株式会社 キョーエイ');
ok($zip->set_number('0360396')->is_valid_number, '黒石市役所');
ok($zip->set_number('0361393')->is_valid_number, '弘前市 岩木庁舎');
ok($zip->set_number('0361492')->is_valid_number, '西目屋村役場');
ok($zip->set_number('0361592')->is_valid_number, '弘前市 相馬庁舎');
ok($zip->set_number('0361593')->is_valid_number, '相馬村 農業協同組合');
ok($zip->set_number('0368501')->is_valid_number, '株式会社 サイキ');
ok($zip->set_number('0368502')->is_valid_number, 'ハローワーク弘前・弘前公共職業安定所');
ok($zip->set_number('0368503')->is_valid_number, '東北女子短期大学');
ok($zip->set_number('0368511')->is_valid_number, '健生病院');
ok($zip->set_number('0368522')->is_valid_number, '弘前市農業協同組合');
ok($zip->set_number('0368530')->is_valid_number, '東北女子大学');
ok($zip->set_number('0368533')->is_valid_number, '陸上自衛隊 弘前駐屯地');
ok($zip->set_number('0368538')->is_valid_number, '日本年金機構 弘前年金事務所');
ok($zip->set_number('0368545')->is_valid_number, '独立行政法人 国立病院機構 弘前病院');
ok($zip->set_number('0368550')->is_valid_number, '弘前中央高等学校');
ok($zip->set_number('0368551')->is_valid_number, '弘前市役所');
ok($zip->set_number('0368555')->is_valid_number, '東北電力 株式会社 弘前営業所');
ok($zip->set_number('0368558')->is_valid_number, '弘前高等学校');
ok($zip->set_number('0368560')->is_valid_number, '弘前大学 (本部)');
ok($zip->set_number('0368560')->is_valid_number, '弘前大学 学生部');
ok($zip->set_number('0368560')->is_valid_number, '弘前大学 教育学部');
ok($zip->set_number('0368560')->is_valid_number, '弘前大学 生涯学習教育研究センター');
ok($zip->set_number('0368560')->is_valid_number, '弘前大学 人文学部');
ok($zip->set_number('0368560')->is_valid_number, '弘前大学 附属図書館');
ok($zip->set_number('0368560')->is_valid_number, '弘前大学 保健管理センター');
ok($zip->set_number('0368560')->is_valid_number, '弘前大学事務局 (本部)');
ok($zip->set_number('0368561')->is_valid_number, '弘前大学 遺伝子実験施設');
ok($zip->set_number('0368561')->is_valid_number, '弘前大学 総合情報処理センター');
ok($zip->set_number('0368561')->is_valid_number, '弘前大学 理工学部');
ok($zip->set_number('0368561')->is_valid_number, '弘前大学農学生命科学部');
ok($zip->set_number('0368562')->is_valid_number, '弘前大学 (医学部)');
ok($zip->set_number('0368563')->is_valid_number, '弘前大学 医学部附属病院');
ok($zip->set_number('0368564')->is_valid_number, '弘前大学大学院 保健学研究科');
ok($zip->set_number('0368567')->is_valid_number, '弘前商工会議所');
ok($zip->set_number('0368577')->is_valid_number, '弘前学院大学');
ok($zip->set_number('0368585')->is_valid_number, '弘前工業高等学校');
ok($zip->set_number('0368588')->is_valid_number, '社団法人 弘前観光コンベンション協会');
ok($zip->set_number('0368601')->is_valid_number, '弘果弘前中央青果 株式会社');
ok($zip->set_number('0368642')->is_valid_number, '有限会社 鎌田屋商店');
ok($zip->set_number('0368655')->is_valid_number, '東北化学薬品 株式会社');
ok($zip->set_number('0368666')->is_valid_number, '弘前航空電子 株式会社');
ok($zip->set_number('0368686')->is_valid_number, '株式会社 青森銀行 弘前支店');
ok($zip->set_number('0368688')->is_valid_number, 'キタエアップル 株式会社');
ok($zip->set_number('0368689')->is_valid_number, '弘前 税務署');
ok($zip->set_number('0368788')->is_valid_number, 'アップルウェーブ 株式会社');
ok($zip->set_number('0370392')->is_valid_number, '中泊町役場');
ok($zip->set_number('0378655')->is_valid_number, '青森地方法務局 五所川原支局');
ok($zip->set_number('0378686')->is_valid_number, '五所川原市役所');
ok($zip->set_number('0380192')->is_valid_number, '平川市役所 碇ケ関総合支所');
ok($zip->set_number('0380194')->is_valid_number, '財団法人 黎明郷');
ok($zip->set_number('0380292')->is_valid_number, '大鰐町役場');
ok($zip->set_number('0381392')->is_valid_number, '青森市役所 浪岡事務所');
ok($zip->set_number('0382792')->is_valid_number, '鯵ケ沢町役場');
ok($zip->set_number('0382793')->is_valid_number, '鯵ケ沢プリンスホテル');
ok($zip->set_number('0382892')->is_valid_number, 'つがる市役所 森田支所');
ok($zip->set_number('0383192')->is_valid_number, 'つがる市役所');
ok($zip->set_number('0383193')->is_valid_number, '県立木造高校');
ok($zip->set_number('0383194')->is_valid_number, '誠仁会 尾野病院');
ok($zip->set_number('0383195')->is_valid_number, '木造町農業協同組合');
ok($zip->set_number('0383196')->is_valid_number, 'つがる市役所 柏支所');
ok($zip->set_number('0383392')->is_valid_number, 'つがる市車力支所');
ok($zip->set_number('0383393')->is_valid_number, '航空自衛隊 車力分屯基地');
ok($zip->set_number('0383394')->is_valid_number, '高山稲荷神社');
ok($zip->set_number('0383595')->is_valid_number, '鶴田町役場');
ok($zip->set_number('0383692')->is_valid_number, '板柳町役場');
ok($zip->set_number('0383892')->is_valid_number, '藤崎町役場');
ok($zip->set_number('0388505')->is_valid_number, '青森市役所 柳川庁舎');
ok($zip->set_number('0388550')->is_valid_number, '青い森鉄道 株式会社');
ok($zip->set_number('0388555')->is_valid_number, '盛岡ターミナルビル 株式会社 ラビナ店');
ok($zip->set_number('0388560')->is_valid_number, '青森ヤクルト販売 株式会社');
ok($zip->set_number('0388585')->is_valid_number, '青森県 視覚障害者情報センター');
ok($zip->set_number('0390195')->is_valid_number, '南部町役場 南部分庁舎');
ok($zip->set_number('0390198')->is_valid_number, '三戸町役場');
ok($zip->set_number('0390292')->is_valid_number, '田子町役場');
ok($zip->set_number('0390595')->is_valid_number, '南部町役場 名川分庁舎');
ok($zip->set_number('0390892')->is_valid_number, '南部町役場');
ok($zip->set_number('0391180')->is_valid_number, '海上自衛隊 八戸航空基地隊');
ok($zip->set_number('0391181')->is_valid_number, '青森地方法務局 八戸支局');
ok($zip->set_number('0391185')->is_valid_number, '株式会社 ユニバース');
ok($zip->set_number('0391192')->is_valid_number, '八戸工業高等専門学校');
ok($zip->set_number('0391193')->is_valid_number, 'カメイ 株式会社 八戸支店');
ok($zip->set_number('0391197')->is_valid_number, '三菱製紙 株式会社 八戸工場');
ok($zip->set_number('0392192')->is_valid_number, 'おいらせ町役場');
ok($zip->set_number('0392280')->is_valid_number, 'アルバック東北 株式会社');
ok($zip->set_number('0392281')->is_valid_number, 'アルバックマテリアル 株式会社 東北事業所');
ok($zip->set_number('0392282')->is_valid_number, 'アクセスケーブル 株式会社 八戸工場');
ok($zip->set_number('0392283')->is_valid_number, '八戸東洋 株式会社');
ok($zip->set_number('0392285')->is_valid_number, '東北容器工業 株式会社');
ok($zip->set_number('0392286')->is_valid_number, '日本フードパッカー 株式会社 青森工場');
ok($zip->set_number('0392287')->is_valid_number, '八戸協和水産 株式会社');
ok($zip->set_number('0392289')->is_valid_number, 'おいらせ町役場 分庁舎');
ok($zip->set_number('0392292')->is_valid_number, 'アンデス電気 株式会社 八戸工場');
ok($zip->set_number('0392293')->is_valid_number, '桃川 株式会社');
ok($zip->set_number('0392392')->is_valid_number, '六戸町役場');
ok($zip->set_number('0392393')->is_valid_number, 'おいらせ農業協同組合 六戸支店');
ok($zip->set_number('0392492')->is_valid_number, '東北町役場');
ok($zip->set_number('0392493')->is_valid_number, '八甲田農業協同組合');
ok($zip->set_number('0392592')->is_valid_number, '七戸町役場 七戸庁舎');
ok($zip->set_number('0392593')->is_valid_number, '上北教育事務所');
ok($zip->set_number('0392594')->is_valid_number, '上北地方福祉事務所');
ok($zip->set_number('0392595')->is_valid_number, '公立七戸病院');
ok($zip->set_number('0392597')->is_valid_number, '青森県立 七戸養護学校');
ok($zip->set_number('0392598')->is_valid_number, '青森県営農大学校');
ok($zip->set_number('0392696')->is_valid_number, '東北町役場 東北分庁舎');
ok($zip->set_number('0392792')->is_valid_number, '七戸町役場');
ok($zip->set_number('0392793')->is_valid_number, 'とうほく天間農業協同組合 天間林支所');
ok($zip->set_number('0393393')->is_valid_number, '平内町役場');
ok($zip->set_number('0394292')->is_valid_number, '東通村役場');
ok($zip->set_number('0394293')->is_valid_number, '東北電力 株式会社 東通原子力発電所');
ok($zip->set_number('0394495')->is_valid_number, 'むつ市役所 大畑庁舎');
ok($zip->set_number('0394692')->is_valid_number, '大間町役場');
ok($zip->set_number('0408501')->is_valid_number, '北海道開発局 函館開発建設部');
ok($zip->set_number('0408502')->is_valid_number, '函館市 消防本部');
ok($zip->set_number('0408510')->is_valid_number, '函館練成会');
ok($zip->set_number('0408511')->is_valid_number, '北海道警察 函館方面本部');
ok($zip->set_number('0408512')->is_valid_number, '株式会社 アドバンスド・デパートメントストアーズオブジャパン 棒二森屋店');
ok($zip->set_number('0408520')->is_valid_number, '株式会社 函館アポロ商会');
ok($zip->set_number('0408522')->is_valid_number, '大槻食材 株式会社');
ok($zip->set_number('0408530')->is_valid_number, '(株) 魚長食品');
ok($zip->set_number('0408533')->is_valid_number, '函館地方法務局');
ok($zip->set_number('0408541')->is_valid_number, '函館市水道局');
ok($zip->set_number('0408543')->is_valid_number, '遺愛女子中学高等学校');
ok($zip->set_number('0408550')->is_valid_number, '函館保護観察所');
ok($zip->set_number('0408551')->is_valid_number, '(株) 弘報社 函館支社');
ok($zip->set_number('0408552')->is_valid_number, '北海道函館児童相談所');
ok($zip->set_number('0408555')->is_valid_number, '日本年金機構 函館年金事務所');
ok($zip->set_number('0408558')->is_valid_number, '北海道旅客鉄道 株式会社 函館支社');
ok($zip->set_number('0408560')->is_valid_number, '(株) JTB 函館支店');
ok($zip->set_number('0408561')->is_valid_number, '函館税関');
ok($zip->set_number('0408566')->is_valid_number, '株式会社 ハコセン');
ok($zip->set_number('0408567')->is_valid_number, '北海道教育大学 教育学部 函館校');
ok($zip->set_number('0408577')->is_valid_number, '社会福祉法人 函館共愛会 共愛会病院');
ok($zip->set_number('0408580')->is_valid_number, 'サッポロビール 株式会社 函館支店');
ok($zip->set_number('0408581')->is_valid_number, '函館米穀 (株)');
ok($zip->set_number('0408585')->is_valid_number, '函館中央病院');
ok($zip->set_number('0408588')->is_valid_number, '明光産業 株式会社');
ok($zip->set_number('0408601')->is_valid_number, '函館地方裁判所');
ok($zip->set_number('0408602')->is_valid_number, '函館家庭裁判所');
ok($zip->set_number('0408603')->is_valid_number, '函館簡易裁判所');
ok($zip->set_number('0408605')->is_valid_number, '函館どつく 株式会社 函館造船所');
ok($zip->set_number('0408609')->is_valid_number, '函館公共職業安定所');
ok($zip->set_number('0408610')->is_valid_number, '(株) テーオー小笠原');
ok($zip->set_number('0408611')->is_valid_number, '函館五稜郭病院');
ok($zip->set_number('0408616')->is_valid_number, '北海道放送 株式会社 函館放送局');
ok($zip->set_number('0408631')->is_valid_number, '函館赤十字病院');
ok($zip->set_number('0408632')->is_valid_number, '(株) エスイーシー');
ok($zip->set_number('0408640')->is_valid_number, '(株) 森川組');
ok($zip->set_number('0408642')->is_valid_number, '海上自衛隊 函館基地隊');
ok($zip->set_number('0408655')->is_valid_number, '日本生命相互会社 函館支店');
ok($zip->set_number('0408660')->is_valid_number, '前側石油 株式会社');
ok($zip->set_number('0408666')->is_valid_number, '函館市役所');
ok($zip->set_number('0408668')->is_valid_number, '(株) 北海道銀行 函館支店');
ok($zip->set_number('0408670')->is_valid_number, '北海道電力 (株) 函館支店');
ok($zip->set_number('0408677')->is_valid_number, '(株) 青森銀行 函館支店');
ok($zip->set_number('0408680')->is_valid_number, '日本放送協会 函館放送局');
ok($zip->set_number('0408686')->is_valid_number, '商工中金 函館支店');
ok($zip->set_number('0408688')->is_valid_number, '(株) 北海道新聞社 函館支社');
ok($zip->set_number('0408710')->is_valid_number, '日本銀行 函館支店');
ok($zip->set_number('0408717')->is_valid_number, '(株) 北洋銀行 函館中央支店');
ok($zip->set_number('0408720')->is_valid_number, '函館信用金庫');
ok($zip->set_number('0408727')->is_valid_number, '(株) 北陸銀行 函館支店');
ok($zip->set_number('0411192')->is_valid_number, '七飯町役場');
ok($zip->set_number('0411193')->is_valid_number, '七飯町教育委員会');
ok($zip->set_number('0411194')->is_valid_number, '七飯町農業協同組合');
ok($zip->set_number('0411195')->is_valid_number, '函館厚生院 ななえ新病院');
ok($zip->set_number('0411196')->is_valid_number, '株式会社 ルネサス北日本コンダクタ');
ok($zip->set_number('0411392')->is_valid_number, '株式会社 プリンスホテル 函館大沼プリンスホテル');
ok($zip->set_number('0411496')->is_valid_number, '鹿部ロイヤルホテル');
ok($zip->set_number('0411497')->is_valid_number, '鹿部カントリー倶楽部');
ok($zip->set_number('0411498')->is_valid_number, '鹿部町役場');
ok($zip->set_number('0411692')->is_valid_number, '函館市役所南茅部支所');
ok($zip->set_number('0418501')->is_valid_number, '(株) イトーヨーカドー 函館店');
ok($zip->set_number('0418510')->is_valid_number, '大丸藤井 株式会社 函館支店');
ok($zip->set_number('0418511')->is_valid_number, '大一興業 株式会社');
ok($zip->set_number('0418515')->is_valid_number, '大興電機 株式会社');
ok($zip->set_number('0418522')->is_valid_number, '社団法人 函館市医師会 函館市医師会病院');
ok($zip->set_number('0418523')->is_valid_number, '日産サニープリンス函館販売 (株)');
ok($zip->set_number('0418533')->is_valid_number, '(株) 長崎屋 函館店');
ok($zip->set_number('0418540')->is_valid_number, '(株) 函館新聞社');
ok($zip->set_number('0418551')->is_valid_number, '北海道渡島保健所');
ok($zip->set_number('0418552')->is_valid_number, '北海道教育庁 実習船管理局');
ok($zip->set_number('0418553')->is_valid_number, '北海道計量検定所 函館支所');
ok($zip->set_number('0418554')->is_valid_number, '函館土木現業所');
ok($zip->set_number('0418555')->is_valid_number, '医療法人社団 仁生会 西堀病院');
ok($zip->set_number('0418556')->is_valid_number, '渡島中部地区 水産技術普及指導所');
ok($zip->set_number('0418557')->is_valid_number, '北海道教育庁 渡島教育局');
ok($zip->set_number('0418558')->is_valid_number, '北海道 渡島支庁');
ok($zip->set_number('0418560')->is_valid_number, '函館白百合学園 中学高等学校');
ok($zip->set_number('0418567')->is_valid_number, '(株) ヤマツ');
ok($zip->set_number('0418577')->is_valid_number, 'トヨタビスタ函館 (株)');
ok($zip->set_number('0418588')->is_valid_number, '函館運送 (株)');
ok($zip->set_number('0418589')->is_valid_number, '(株) 不二屋本店');
ok($zip->set_number('0418610')->is_valid_number, '(株) テーオー小笠原');
ok($zip->set_number('0418611')->is_valid_number, '北海道大学 水産学部');
ok($zip->set_number('0418623')->is_valid_number, '函館日産自動車 株式会社 神山店');
ok($zip->set_number('0418633')->is_valid_number, '第二物産 (株)');
ok($zip->set_number('0418648')->is_valid_number, '(株) クワザワ 函館支店');
ok($zip->set_number('0418655')->is_valid_number, '公立はこだて未来大学');
ok($zip->set_number('0418680')->is_valid_number, '函館市病院局');
ok($zip->set_number('0418711')->is_valid_number, '函館トヨペット 株式会社');
ok($zip->set_number('0428501')->is_valid_number, '函館工業高等専門学校');
ok($zip->set_number('0428511')->is_valid_number, '医療法人 富田病院');
ok($zip->set_number('0428550')->is_valid_number, '北海道森林管理局 函館事務所');
ok($zip->set_number('0428555')->is_valid_number, '函館環境衛生 株式会社');
ok($zip->set_number('0428567')->is_valid_number, '陸上自衛隊 函館駐屯地');
ok($zip->set_number('0428585')->is_valid_number, '日本中央競馬会 函館競馬場');
ok($zip->set_number('0428588')->is_valid_number, '函館大学 付属有斗高等学校');
ok($zip->set_number('0428639')->is_valid_number, '函館少年刑務所');
ok($zip->set_number('0428642')->is_valid_number, '(株) 北洋銀行 湯川支店');
ok($zip->set_number('0428678')->is_valid_number, '医療法人 函館渡辺病院');
ok($zip->set_number('0430495')->is_valid_number, '八雲町 熊石総合支所');
ok($zip->set_number('0430595')->is_valid_number, 'せたな町役場 大成支所');
ok($zip->set_number('0431498')->is_valid_number, '奥尻町役場');
ok($zip->set_number('0438558')->is_valid_number, '北海道 桧山支庁');
ok($zip->set_number('0438560')->is_valid_number, '江差町役場');
ok($zip->set_number('0438609')->is_valid_number, '函館公共職業安定所 江差出張所');
ok($zip->set_number('0438651')->is_valid_number, '江差信用金庫');
ok($zip->set_number('0440292')->is_valid_number, '喜茂別町役場');
ok($zip->set_number('0440295')->is_valid_number, 'クレードル興農 株式会社 喜茂別工場');
ok($zip->set_number('0440296')->is_valid_number, '喜茂別町商工会');
ok($zip->set_number('0448544')->is_valid_number, '北海道教育庁 後志教育局');
ok($zip->set_number('0448588')->is_valid_number, '北海道 後志支庁');
ok($zip->set_number('0458555')->is_valid_number, '岩内町役場');
ok($zip->set_number('0458609')->is_valid_number, '岩内公共職業安定所');
ok($zip->set_number('0460192')->is_valid_number, '古平町役場');
ok($zip->set_number('0460194')->is_valid_number, '社会福祉法人 古平福祉会');
ok($zip->set_number('0460292')->is_valid_number, '積丹町役場');
ok($zip->set_number('0460592')->is_valid_number, '赤井川村役場');
ok($zip->set_number('0460593')->is_valid_number, '(株) キロロアソシエイツ');
ok($zip->set_number('0460594')->is_valid_number, '小樽赤井川ゴルフクラブ');
ok($zip->set_number('0468546')->is_valid_number, '余市町役場');
ok($zip->set_number('0468555')->is_valid_number, '北海道立 中央水産試験場');
ok($zip->set_number('0468686')->is_valid_number, '北海信用金庫');
ok($zip->set_number('0470192')->is_valid_number, '小樽簡易保険加入者ホーム');
ok($zip->set_number('0470292')->is_valid_number, '独立行政法人 雇用・能力開発機構 北海道職業能力開発大学校');
ok($zip->set_number('0470298')->is_valid_number, '合同化成 株式会社');
ok($zip->set_number('0478501')->is_valid_number, '小樽商科大学');
ok($zip->set_number('0478502')->is_valid_number, '小樽商科大学 附属図書館');
ok($zip->set_number('0478503')->is_valid_number, '小樽商科大学 生活協同組合');
ok($zip->set_number('0478519')->is_valid_number, '日本電信電話 (株)');
ok($zip->set_number('0478520')->is_valid_number, '小樽商工会議所');
ok($zip->set_number('0478555')->is_valid_number, '小樽開発建設部');
ok($zip->set_number('0478558')->is_valid_number, '学校法人 北照高等学校');
ok($zip->set_number('0478560')->is_valid_number, '第一管区 海上保安本部');
ok($zip->set_number('0478567')->is_valid_number, '(株) 丸井今井 小樽店');
ok($zip->set_number('0478585')->is_valid_number, '医療法人 北仁会 石橋病院');
ok($zip->set_number('0478601')->is_valid_number, '北海道中央バス (株)');
ok($zip->set_number('0478609')->is_valid_number, '小樽公共職業安定所');
ok($zip->set_number('0478611')->is_valid_number, '小樽短期大学');
ok($zip->set_number('0478660')->is_valid_number, '小樽市役所');
ok($zip->set_number('0478663')->is_valid_number, '株式会社 新宮商行');
ok($zip->set_number('0478666')->is_valid_number, '日本年金機構 小樽年金事務所');
ok($zip->set_number('0478677')->is_valid_number, '北海道ワイン (株)');
ok($zip->set_number('0478686')->is_valid_number, '株式会社 光合金製作所');
ok($zip->set_number('0478794')->is_valid_number, '小樽貯金事務センター');
ok($zip->set_number('0480192')->is_valid_number, '黒松内町役場');
ok($zip->set_number('0481392')->is_valid_number, '蘭越町役場');
ok($zip->set_number('0481393')->is_valid_number, 'ようてい農業協同組合 蘭越支所');
ok($zip->set_number('0481394')->is_valid_number, '(株) 熊谷本店');
ok($zip->set_number('0481395')->is_valid_number, '北海信用金庫 蘭越支店');
ok($zip->set_number('0481396')->is_valid_number, '室野建設工業 (株)');
ok($zip->set_number('0481592')->is_valid_number, 'ヒルトンニセコビレッジ');
ok($zip->set_number('0481595')->is_valid_number, 'ニセコ町役場');
ok($zip->set_number('0482292')->is_valid_number, '共和町役場');
ok($zip->set_number('0482492')->is_valid_number, '仁木町役場');
ok($zip->set_number('0482493')->is_valid_number, '新おたる農業協同組合');
ok($zip->set_number('0490192')->is_valid_number, '北斗市役所');
ok($zip->set_number('0490193')->is_valid_number, '日本セメント (株)');
ok($zip->set_number('0490692')->is_valid_number, '江差信用金庫 上ノ国支店');
ok($zip->set_number('0490693')->is_valid_number, '株式会社 カイト');
ok($zip->set_number('0490695')->is_valid_number, '北海道上ノ国高等学校');
ok($zip->set_number('0490697')->is_valid_number, '新函館農業協同組合 上ノ国支店');
ok($zip->set_number('0490698')->is_valid_number, '上ノ国町役場');
ok($zip->set_number('0491392')->is_valid_number, '福島町役場');
ok($zip->set_number('0491592')->is_valid_number, '松前町役場');
ok($zip->set_number('0491593')->is_valid_number, '松前町立松前病院');
ok($zip->set_number('0491594')->is_valid_number, '松前町教育委員会');
ok($zip->set_number('0492192')->is_valid_number, 'グリーンピア大沼');
ok($zip->set_number('0492392')->is_valid_number, '渡島信用金庫');
ok($zip->set_number('0492393')->is_valid_number, '森町役場');
ok($zip->set_number('0492394')->is_valid_number, '北海道森高等学校');
ok($zip->set_number('0493192')->is_valid_number, '八雲町役場');
ok($zip->set_number('0493197')->is_valid_number, '八雲総合病院');
ok($zip->set_number('0493198')->is_valid_number, '独立行政法人 国立病院機構 八雲病院');
ok($zip->set_number('0493592')->is_valid_number, '長万部町役場');
ok($zip->set_number('0494393')->is_valid_number, '今金町役場');
ok($zip->set_number('0494397')->is_valid_number, '今金町農業協同組合');
ok($zip->set_number('0494592')->is_valid_number, 'せたな町役場');
ok($zip->set_number('0494595')->is_valid_number, '北檜山町農業協同組合');
ok($zip->set_number('0495492')->is_valid_number, '豊浦町役場');
ok($zip->set_number('0495692')->is_valid_number, '洞爺湖町役場');
ok($zip->set_number('0495892')->is_valid_number, '洞爺温泉病院');
ok($zip->set_number('0508510')->is_valid_number, '日鐵セメント 株式会社');
ok($zip->set_number('0508511')->is_valid_number, '(株) NTT東日本 北海道 室蘭支店');
ok($zip->set_number('0508518')->is_valid_number, '(株) 北洋銀行 中島町支店');
ok($zip->set_number('0508550')->is_valid_number, '新日本製鉄 (株) 室蘭製鉄所');
ok($zip->set_number('0508555')->is_valid_number, '(株)丸井今井 室蘭店');
ok($zip->set_number('0508570')->is_valid_number, '株式会社 楢崎製作所');
ok($zip->set_number('0508582')->is_valid_number, 'トヨタカローラ室蘭 (株)');
ok($zip->set_number('0508585')->is_valid_number, '室蘭工業大学');
ok($zip->set_number('0508588')->is_valid_number, '株式会社 モロオ 室蘭営業所');
ok($zip->set_number('0518501')->is_valid_number, '医療法人社団 日鋼記念病院');
ok($zip->set_number('0518505')->is_valid_number, '株式会社 日本製鋼所 室蘭製作所');
ok($zip->set_number('0518511')->is_valid_number, '室蘭市役所');
ok($zip->set_number('0518512')->is_valid_number, '市立室蘭総合病院');
ok($zip->set_number('0518524')->is_valid_number, '室蘭開発建設部');
ok($zip->set_number('0518530')->is_valid_number, '室蘭市役所 広域センタービル庁舎');
ok($zip->set_number('0518546')->is_valid_number, '日鋼協力会');
ok($zip->set_number('0518550')->is_valid_number, '株式会社 室蘭民報社');
ok($zip->set_number('0518555')->is_valid_number, '北海道 室蘭保健所');
ok($zip->set_number('0518558')->is_valid_number, '北海道 胆振支庁');
ok($zip->set_number('0518585')->is_valid_number, '室蘭社会保険事務所');
ok($zip->set_number('0518588')->is_valid_number, '吉沢商事 (株)');
ok($zip->set_number('0518650')->is_valid_number, '室蘭信用金庫');
ok($zip->set_number('0518660')->is_valid_number, '日専連 室蘭');
ok($zip->set_number('0528511')->is_valid_number, '総合病院 伊達赤十字病院');
ok($zip->set_number('0528550')->is_valid_number, '(株) ダテハキ');
ok($zip->set_number('0528585')->is_valid_number, '北海道立 太陽の園');
ok($zip->set_number('0528586')->is_valid_number, '伊達市立通勤センター事務所');
ok($zip->set_number('0528650')->is_valid_number, '伊達信用金庫');
ok($zip->set_number('0528666')->is_valid_number, '伊達市農業協同組合');
ok($zip->set_number('0528686')->is_valid_number, '商業協同組合 日専連だて');
ok($zip->set_number('0538505')->is_valid_number, '光陽商事 (株)');
ok($zip->set_number('0538506')->is_valid_number, '医療法人 王子総合病院');
ok($zip->set_number('0538511')->is_valid_number, '苫小牧埠頭 (株)');
ok($zip->set_number('0538512')->is_valid_number, '(株) 長崎屋 苫小牧店');
ok($zip->set_number('0538522')->is_valid_number, 'ナラサキスタックス (株)');
ok($zip->set_number('0538533')->is_valid_number, '(株) 三星');
ok($zip->set_number('0538540')->is_valid_number, '苫小牧労働基準監督署');
ok($zip->set_number('0538541')->is_valid_number, '駒澤大学附属 苫小牧高等学校');
ok($zip->set_number('0538555')->is_valid_number, '北海道苫小牧東高等学校');
ok($zip->set_number('0538570')->is_valid_number, '社団法人 苫小牧市医師会');
ok($zip->set_number('0538585')->is_valid_number, '(株) 丸井今井 苫小牧店');
ok($zip->set_number('0538588')->is_valid_number, '苫小牧社会保険事務所');
ok($zip->set_number('0538609')->is_valid_number, '苫小牧公共職業安定所');
ok($zip->set_number('0538611')->is_valid_number, '(株) 苫小牧民報社');
ok($zip->set_number('0538619')->is_valid_number, '日本電信電話 (株) 苫小牧支店');
ok($zip->set_number('0538648')->is_valid_number, '生活協同組合 コープさっぽろ 苫小牧地区本部');
ok($zip->set_number('0538653')->is_valid_number, 'ホクレン農業協同組合連合会 苫小牧支所');
ok($zip->set_number('0538654')->is_valid_number, '苫小牧信用金庫');
ok($zip->set_number('0538666')->is_valid_number, '日本生命保険 相互会社 苫小牧支社');
ok($zip->set_number('0538711')->is_valid_number, '王子製紙 株式会社 苫小牧工場');
ok($zip->set_number('0538722')->is_valid_number, '苫小牧市役所');
ok($zip->set_number('0548660')->is_valid_number, 'むかわ町役場');
ok($zip->set_number('0550192')->is_valid_number, '平取町役場');
ok($zip->set_number('0550193')->is_valid_number, '平取町農業協同組合');
ok($zip->set_number('0550195')->is_valid_number, 'ふれあいセンターびらとり');
ok($zip->set_number('0568650')->is_valid_number, '新ひだか町役場');
ok($zip->set_number('0578511')->is_valid_number, '浦河町役場');
ok($zip->set_number('0578558')->is_valid_number, '北海道 日高支庁');
ok($zip->set_number('0580292')->is_valid_number, 'えりも町役場');
ok($zip->set_number('0588501')->is_valid_number, '様似町役場');
ok($zip->set_number('0590492')->is_valid_number, '株式会社 北海道マリンパーク');
ok($zip->set_number('0590493')->is_valid_number, '医療法人社団 千寿会 三愛病院');
ok($zip->set_number('0590496')->is_valid_number, 'マルヒラ 渡辺水産 株式会社');
ok($zip->set_number('0590592')->is_valid_number, '株式会社 登別グランドホテル');
ok($zip->set_number('0590595')->is_valid_number, '株式会社 第一滝本館');
ok($zip->set_number('0590596')->is_valid_number, '登別プリンスホテル 石水亭');
ok($zip->set_number('0590598')->is_valid_number, '登別厚生年金病院');
ok($zip->set_number('0590993')->is_valid_number, '日本製紙 株式会社 白老工場');
ok($zip->set_number('0590995')->is_valid_number, '白老町役場');
ok($zip->set_number('0590997')->is_valid_number, '白老町消防本部');
ok($zip->set_number('0590998')->is_valid_number, '北海道栄高等学校');
ok($zip->set_number('0591292')->is_valid_number, '苫小牧駒澤大学');
ok($zip->set_number('0591392')->is_valid_number, '出光興産 (株) 北海道製油所');
ok($zip->set_number('0591393')->is_valid_number, 'トヨタ自動車北海道 株式会社');
ok($zip->set_number('0591394')->is_valid_number, '株式会社 イワクラ');
ok($zip->set_number('0591395')->is_valid_number, '日本製紙 (株) 勇払工場');
ok($zip->set_number('0591396')->is_valid_number, '豊田通商 株式会社 北海道支店');
ok($zip->set_number('0591592')->is_valid_number, '北央信用組合 早来支店');
ok($zip->set_number('0591593')->is_valid_number, 'とまこまい広域農業協同組合 早来支所');
ok($zip->set_number('0591594')->is_valid_number, '株式会社 北海道銀行 早来支店');
ok($zip->set_number('0591595')->is_valid_number, '安平町役場');
ok($zip->set_number('0591596')->is_valid_number, '早来町商工会');
ok($zip->set_number('0591692')->is_valid_number, '厚真町役場');
ok($zip->set_number('0591693')->is_valid_number, 'とまこまい広域農業協同組合 厚真支所');
ok($zip->set_number('0592192')->is_valid_number, '日高町役場');
ok($zip->set_number('0592492')->is_valid_number, '新冠町役場');
ok($zip->set_number('0592598')->is_valid_number, '陸上自衛隊 静内駐屯地');
ok($zip->set_number('0593195')->is_valid_number, '新ひだか町役場 三石総合支所');
ok($zip->set_number('0598601')->is_valid_number, '日本工学院北海道専門学校');
ok($zip->set_number('0598701')->is_valid_number, '登別市役所');
ok($zip->set_number('0608501')->is_valid_number, '北海道放送 株式会社 (HBC)');
ok($zip->set_number('0608502')->is_valid_number, '株式会社 パルコ 札幌店');
ok($zip->set_number('0608503')->is_valid_number, 'メディカルプラザ札幌');
ok($zip->set_number('0608505')->is_valid_number, '丸水札幌中央水産 (株)');
ok($zip->set_number('0608506')->is_valid_number, '北海道開発局 札幌開発建設部');
ok($zip->set_number('0608508')->is_valid_number, '株式会社 ニッセンレンエスコート');
ok($zip->set_number('0608509')->is_valid_number, '株式会社 角川マガジンズ 北海道オフィス');
ok($zip->set_number('0608510')->is_valid_number, '株式会社 北洋銀行 札幌営業部');
ok($zip->set_number('0608511')->is_valid_number, '北海道開発局');
ok($zip->set_number('0608512')->is_valid_number, '扶洋薬品 株式会社');
ok($zip->set_number('0608513')->is_valid_number, '札幌中央信用組合');
ok($zip->set_number('0608514')->is_valid_number, 'スキーハウス');
ok($zip->set_number('0608515')->is_valid_number, '株式会社 東急コミュニティー 北海道支店');
ok($zip->set_number('0608516')->is_valid_number, '新日本法規出版 (株) 札幌支社');
ok($zip->set_number('0608517')->is_valid_number, '株式会社 テレビ北海道 (TVh)');
ok($zip->set_number('0608519')->is_valid_number, '東日本電信電話 株式会社 北海道支店');
ok($zip->set_number('0608520')->is_valid_number, '北海道警察本部');
ok($zip->set_number('0608521')->is_valid_number, '株式会社 北海道日刊スポーツ新聞社');
ok($zip->set_number('0608522')->is_valid_number, 'キヤノンマーケティングジャパン 株式会社 札幌支店');
ok($zip->set_number('0608523')->is_valid_number, '札幌日産自動車 株式会社');
ok($zip->set_number('0608524')->is_valid_number, '全国健康保険協会 北海道支部');
ok($zip->set_number('0608525')->is_valid_number, '株式会社 モロオ');
ok($zip->set_number('0608526')->is_valid_number, '札幌公共職業安定所 札幌学生職業センター');
ok($zip->set_number('0608527')->is_valid_number, '北海道文化放送 株式会社 (UHB)');
ok($zip->set_number('0608529')->is_valid_number, '日本製粉 (株) 札幌支店');
ok($zip->set_number('0608530')->is_valid_number, '北海道瓦斯 株式会社');
ok($zip->set_number('0608531')->is_valid_number, '東京海上日動火災保険 株式会社');
ok($zip->set_number('0608532')->is_valid_number, '(株) エフエム北海道');
ok($zip->set_number('0608533')->is_valid_number, '(株) スズケン');
ok($zip->set_number('0608536')->is_valid_number, '(株) 帝国データバンク 札幌支店');
ok($zip->set_number('0608537')->is_valid_number, 'エムエムエス マンションマネージメントサービス (株)');
ok($zip->set_number('0608538')->is_valid_number, '北海道住宅供給公社');
ok($zip->set_number('0608539')->is_valid_number, '中道リース 株式会社');
ok($zip->set_number('0608540')->is_valid_number, '潮物産 株式会社');
ok($zip->set_number('0608541')->is_valid_number, '北海道開発局 石狩川開発建設部');
ok($zip->set_number('0608542')->is_valid_number, '恵比寿ガーデンプレイス 株式会社 サッポロファクトリー事業部');
ok($zip->set_number('0608543')->is_valid_number, '札幌医科大学付属病院');
ok($zip->set_number('0608544')->is_valid_number, '北海道教育庁');
ok($zip->set_number('0608545')->is_valid_number, '株式会社 電通北海道');
ok($zip->set_number('0608546')->is_valid_number, 'サッポロ都市開発 株式会社');
ok($zip->set_number('0608547')->is_valid_number, '伊藤忠商事 (株) 北海道支社');
ok($zip->set_number('0608548')->is_valid_number, '札幌三井不動産販売 (株)');
ok($zip->set_number('0608549')->is_valid_number, '北海道教育庁 石狩教育局');
ok($zip->set_number('0608550')->is_valid_number, '株式会社 ホクレン商事');
ok($zip->set_number('0608551')->is_valid_number, '北海道社会保険診療報酬支払基金');
ok($zip->set_number('0608552')->is_valid_number, '株式会社 損害保険ジャパン');
ok($zip->set_number('0608553')->is_valid_number, 'あいおい損害保険 株式会社');
ok($zip->set_number('0608554')->is_valid_number, '伊藤組土建 (株)');
ok($zip->set_number('0608555')->is_valid_number, '株式会社 西武百貨店 札幌店');
ok($zip->set_number('0608556')->is_valid_number, '札幌医科大学');
ok($zip->set_number('0608557')->is_valid_number, '(株) エフエム・ノースウエーブ');
ok($zip->set_number('0608558')->is_valid_number, '北海道 石狩支庁');
ok($zip->set_number('0608559')->is_valid_number, 'セカンドポスト');
ok($zip->set_number('0608560')->is_valid_number, '財団法人 北海道公立学校教職員互助会');
ok($zip->set_number('0608561')->is_valid_number, '北海道瓦斯 (株)');
ok($zip->set_number('0608563')->is_valid_number, '綜合警備保障 (株) 北海道支社');
ok($zip->set_number('0608565')->is_valid_number, '株式会社 ほくせん');
ok($zip->set_number('0608566')->is_valid_number, '北海道労働局');
ok($zip->set_number('0608568')->is_valid_number, '株式会社 小宮山屋');
ok($zip->set_number('0608570')->is_valid_number, '医療法人 医仁会 中村記念病院');
ok($zip->set_number('0608572')->is_valid_number, '札幌市中央市税事務所');
ok($zip->set_number('0608573')->is_valid_number, '社団法人 北海道歯科医師会');
ok($zip->set_number('0608574')->is_valid_number, '北海道社会保険事務局 事務センター');
ok($zip->set_number('0608576')->is_valid_number, '株式会社 キムラ');
ok($zip->set_number('0608577')->is_valid_number, '株式会社 ジャックス 札幌支社');
ok($zip->set_number('0608578')->is_valid_number, '北海道市町村職員共済組合');
ok($zip->set_number('0608579')->is_valid_number, '北海道財務局');
ok($zip->set_number('0608580')->is_valid_number, '株式会社 ニトリパブリック');
ok($zip->set_number('0608581')->is_valid_number, '社団法人 札幌市医師会');
ok($zip->set_number('0608582')->is_valid_number, '(株) りんゆう観光');
ok($zip->set_number('0608583')->is_valid_number, '北海道電力 株式会社 ほくでん契約センター');
ok($zip->set_number('0608584')->is_valid_number, '札幌ビジネスオンデマンド スマイルポスト');
ok($zip->set_number('0608585')->is_valid_number, '日本年金機構 札幌西年金事務所');
ok($zip->set_number('0608586')->is_valid_number, '北海道大学 歯学部');
ok($zip->set_number('0608587')->is_valid_number, '札幌中央労働基準監督署');
ok($zip->set_number('0608588')->is_valid_number, '北海道庁');
ok($zip->set_number('0608589')->is_valid_number, '北海道大学 農学部');
ok($zip->set_number('0608601')->is_valid_number, '大和証券 株式会社 札幌支店');
ok($zip->set_number('0608602')->is_valid_number, '朝日新聞社 北海道支社');
ok($zip->set_number('0608603')->is_valid_number, '財団法人 消防試験研究センター 北海道支部');
ok($zip->set_number('0608604')->is_valid_number, '市立札幌病院');
ok($zip->set_number('0608605')->is_valid_number, '株式会社 インテリジェンス');
ok($zip->set_number('0608607')->is_valid_number, '北海道商工会連合会');
ok($zip->set_number('0608608')->is_valid_number, '道銀カード 株式会社');
ok($zip->set_number('0608609')->is_valid_number, '三井住友海上火災保険 (株)');
ok($zip->set_number('0608610')->is_valid_number, '札幌商工会議所');
ok($zip->set_number('0608611')->is_valid_number, '札幌市役所');
ok($zip->set_number('0608612')->is_valid_number, '札幌市中央区役所');
ok($zip->set_number('0608613')->is_valid_number, 'AIGエジソン生命保険 株式会社 北海道事務センター');
ok($zip->set_number('0608614')->is_valid_number, '財団法人 札幌市交通事業振興公社');
ok($zip->set_number('0608615')->is_valid_number, '札幌プリンスホテル');
ok($zip->set_number('0608616')->is_valid_number, '日本労働組合 総連合会 北海道連合会');
ok($zip->set_number('0608617')->is_valid_number, '清水建設 (株) 北海道支店');
ok($zip->set_number('0608618')->is_valid_number, '中道機械 (株)');
ok($zip->set_number('0608619')->is_valid_number, '株式会社 東急百貨店 札幌店');
ok($zip->set_number('0608620')->is_valid_number, '(株) 道新サービスセンター オントナ事業部');
ok($zip->set_number('0608621')->is_valid_number, '株式会社 日本経済新聞社 札幌支社');
ok($zip->set_number('0608622')->is_valid_number, '第一三共 株式会社 札幌支店');
ok($zip->set_number('0608622')->is_valid_number, '第一三共ヘルスケア 株式会社 東日本支店 札幌オフィス');
ok($zip->set_number('0608623')->is_valid_number, '株式会社 ジェーシービー 北海道支社');
ok($zip->set_number('0608624')->is_valid_number, '日立キャピタル (株) 北海道営業本部');
ok($zip->set_number('0608625')->is_valid_number, 'UFJニコス 株式会社');
ok($zip->set_number('0608626')->is_valid_number, '株式会社 武富士 札幌支店');
ok($zip->set_number('0608627')->is_valid_number, '社団法人 北海道医師会');
ok($zip->set_number('0608628')->is_valid_number, '北海道大学大学院 工学研究科工学部');
ok($zip->set_number('0608629')->is_valid_number, '札幌らーめん共和国');
ok($zip->set_number('0608630')->is_valid_number, '岩田地崎建設 株式会社');
ok($zip->set_number('0608631')->is_valid_number, '三井住友海上火災保険 株式会社');
ok($zip->set_number('0608633')->is_valid_number, '東京海上日動火災保険 株式会社');
ok($zip->set_number('0608634')->is_valid_number, '北海道社会保険事務局 事務センター');
ok($zip->set_number('0608635')->is_valid_number, '富士火災海上保険 (株) 北海道本部');
ok($zip->set_number('0608636')->is_valid_number, '丸紅 (株) 北海道支社');
ok($zip->set_number('0608637')->is_valid_number, '(株) 亜璃西社');
ok($zip->set_number('0608638')->is_valid_number, '北海道大学 医学部');
ok($zip->set_number('0608639')->is_valid_number, '北海道電力 株式会社 札幌支店');
ok($zip->set_number('0608640')->is_valid_number, '株式会社 北海道二十一世紀総合研究所');
ok($zip->set_number('0608641')->is_valid_number, '札幌市北部市税事務所');
ok($zip->set_number('0608642')->is_valid_number, '株式会社 リクルート北海道じゃらん');
ok($zip->set_number('0608643')->is_valid_number, '(株) 毎日新聞社 北海道支社');
ok($zip->set_number('0608644')->is_valid_number, '北海道旅客鉄道 株式会社');
ok($zip->set_number('0608646')->is_valid_number, '株式会社 ロイズコンフェクト');
ok($zip->set_number('0608647')->is_valid_number, '(株) 北海道アルバイト情報社');
ok($zip->set_number('0608648')->is_valid_number, '北海道大学病院');
ok($zip->set_number('0608649')->is_valid_number, '札幌市中央市税事務所 市民税課');
ok($zip->set_number('0608651')->is_valid_number, 'ホクレン 農業協同組合連合会');
ok($zip->set_number('0608654')->is_valid_number, '三菱商事 株式会社 北海道支社');
ok($zip->set_number('0608655')->is_valid_number, '道栄紙業 株式会社 (コアレックス)');
ok($zip->set_number('0608656')->is_valid_number, '(株) 読売新聞 東京本社 北海道支社');
ok($zip->set_number('0608658')->is_valid_number, '株式会社 北海道建設新聞社');
ok($zip->set_number('0608661')->is_valid_number, '株式会社 北洋銀行 本店');
ok($zip->set_number('0608666')->is_valid_number, '株式会社 三越 札幌店');
ok($zip->set_number('0608667')->is_valid_number, '株式会社 丸井今井 札幌本店');
ok($zip->set_number('0608668')->is_valid_number, '株式会社 丸ヨ池内');
ok($zip->set_number('0608670')->is_valid_number, '北海道信用保証協会');
ok($zip->set_number('0608671')->is_valid_number, '高橋水産 (株)');
ok($zip->set_number('0608676')->is_valid_number, '株式会社 北海道銀行');
ok($zip->set_number('0608677')->is_valid_number, '北海道電力 株式会社');
ok($zip->set_number('0608678')->is_valid_number, '日本生命保険 相互会社 札幌支社');
ok($zip->set_number('0608703')->is_valid_number, '日本放送協会 札幌放送局 (NHK)');
ok($zip->set_number('0608705')->is_valid_number, '札幌テレビ放送 株式会社 (STV)');
ok($zip->set_number('0608706')->is_valid_number, '札幌テレビ放送 株式会社 (STV)');
ok($zip->set_number('0608707')->is_valid_number, '札幌テレビ放送 株式会社 (STV) どさんこワイド212');
ok($zip->set_number('0608711')->is_valid_number, '株式会社 北海道新聞社');
ok($zip->set_number('0608720')->is_valid_number, '野村證券 株式会社 札幌支店');
ok($zip->set_number('0608721')->is_valid_number, '日藤 株式会社');
ok($zip->set_number('0608725')->is_valid_number, '北海道労働金庫 本部');
ok($zip->set_number('0608767')->is_valid_number, 'KDDI 株式会社');
ok($zip->set_number('0608792')->is_valid_number, '仙台サービスセンター 郵便局サービス課');
ok($zip->set_number('0608795')->is_valid_number, '北海道総合通信局');
ok($zip->set_number('0608796')->is_valid_number, '札幌監査室');
ok($zip->set_number('0608797')->is_valid_number, '株式会社 ゆうちょ銀行 札幌支店');
ok($zip->set_number('0608797')->is_valid_number, '株式会社 かんぽ生命 札幌支店');
ok($zip->set_number('0608797')->is_valid_number, '郵便局 株式会社 北海道支社');
ok($zip->set_number('0608797')->is_valid_number, '郵便事業 株式会社 北海道支社');
ok($zip->set_number('0610292')->is_valid_number, '当別町役場');
ok($zip->set_number('0610293')->is_valid_number, '学校法人 東日本学園北海道医療大学');
ok($zip->set_number('0610295')->is_valid_number, '当別町農業協同組合');
ok($zip->set_number('0610296')->is_valid_number, '北海道当別高等学校');
ok($zip->set_number('0610592')->is_valid_number, '月形町役場');
ok($zip->set_number('0610595')->is_valid_number, '月形刑務所');
ok($zip->set_number('0610692')->is_valid_number, '浦臼町役場');
ok($zip->set_number('0611192')->is_valid_number, '北広島市役所');
ok($zip->set_number('0611193')->is_valid_number, '株式会社 プリンスホテル 札幌北広島プリンスホテル');
ok($zip->set_number('0611195')->is_valid_number, '社会福祉法人 北海道リハビリー');
ok($zip->set_number('0611196')->is_valid_number, '北海道櫻井産業学園');
ok($zip->set_number('0611392')->is_valid_number, '道央農業協同組合 恵庭支所');
ok($zip->set_number('0611393')->is_valid_number, '陸上自衛隊 北海道地区補給処');
ok($zip->set_number('0611395')->is_valid_number, '医療法人 北晨会 恵み野病院');
ok($zip->set_number('0611396')->is_valid_number, '北海道ハイテクノロジー専門学校');
ok($zip->set_number('0611492')->is_valid_number, '合同容器 株式会社');
ok($zip->set_number('0611493')->is_valid_number, '株式会社 堀川 北海道事業部');
ok($zip->set_number('0611496')->is_valid_number, '三和シャッター工業 株式会社 札幌工場');
ok($zip->set_number('0611497')->is_valid_number, 'ニチレキ 株式会社 北海道支店');
ok($zip->set_number('0611498')->is_valid_number, '恵庭市役所');
ok($zip->set_number('0612292')->is_valid_number, '北海道札幌南陵高等学校');
ok($zip->set_number('0613197')->is_valid_number, '石狩市役所 浜益支所');
ok($zip->set_number('0613292')->is_valid_number, '石狩市役所');
ok($zip->set_number('0613293')->is_valid_number, 'エコートレーディング 株式会社 札幌支店');
ok($zip->set_number('0613294')->is_valid_number, '株式会社 モロオ 石狩物流センター');
ok($zip->set_number('0613295')->is_valid_number, 'ピップトウキョウ 株式会社 札幌センター');
ok($zip->set_number('0613296')->is_valid_number, 'YKK AP (株) 北海道工場');
ok($zip->set_number('0613692')->is_valid_number, '石狩市役所 厚田支所');
ok($zip->set_number('0628501')->is_valid_number, '北海道テレビ放送 株式会社 (HTB)');
ok($zip->set_number('0628510')->is_valid_number, '日糧製パン 株式会社');
ok($zip->set_number('0628511')->is_valid_number, '北海道開発局 防災技術センター');
ok($zip->set_number('0628513')->is_valid_number, '医療法人 柏葉脳神経外科病院');
ok($zip->set_number('0628514')->is_valid_number, '株式会社 ヤナセ 札幌支店');
ok($zip->set_number('0628516')->is_valid_number, '森林総合研究所 北海道支所');
ok($zip->set_number('0628517')->is_valid_number, '独立行政法人 産業技術総合研究所 北海道センター');
ok($zip->set_number('0628520')->is_valid_number, '札幌大学');
ok($zip->set_number('0628530')->is_valid_number, '北海道信用農業協同組合連合会 事務センター');
ok($zip->set_number('0628532')->is_valid_number, '矢崎総業 株式会社 札幌支社');
ok($zip->set_number('0628539')->is_valid_number, '株式会社 シージーシー 北海道本部');
ok($zip->set_number('0628555')->is_valid_number, '独立行政法人 農業・食品産業技術総合研究機構 北海道農業研究センター');
ok($zip->set_number('0628558')->is_valid_number, '札幌トヨペット 株式会社');
ok($zip->set_number('0628570')->is_valid_number, '札幌市下水道局');
ok($zip->set_number('0628572')->is_valid_number, '財団法人 北海道体育協会');
ok($zip->set_number('0628575')->is_valid_number, '(株) エフエムとよひら');
ok($zip->set_number('0628601')->is_valid_number, '北海高等学校');
ok($zip->set_number('0628602')->is_valid_number, '独立行政法人 土木研究所 寒地土木研究所');
ok($zip->set_number('0628603')->is_valid_number, '札幌商業高等学校');
ok($zip->set_number('0628605')->is_valid_number, '北海学園大学');
ok($zip->set_number('0628607')->is_valid_number, '北海商科大学');
ok($zip->set_number('0628608')->is_valid_number, '岩倉建材 株式会社');
ok($zip->set_number('0628609')->is_valid_number, '札幌東公共職業安定所');
ok($zip->set_number('0628610')->is_valid_number, '自衛隊札幌病院');
ok($zip->set_number('0628612')->is_valid_number, '札幌市豊平区役所');
ok($zip->set_number('0628617')->is_valid_number, '丸彦渡辺建設 株式会社');
ok($zip->set_number('0628618')->is_valid_number, '北海道 社会保険中央病院');
ok($zip->set_number('0628622')->is_valid_number, '株式会社 ハドソン');
ok($zip->set_number('0628624')->is_valid_number, '株式会社 ジェイコム札幌');
ok($zip->set_number('0628630')->is_valid_number, '日本道路 株式会社 北海道支店');
ok($zip->set_number('0628631')->is_valid_number, '財団法人 北海道薬剤師会');
ok($zip->set_number('0628633')->is_valid_number, 'イワクラホーム 株式会社');
ok($zip->set_number('0628635')->is_valid_number, '株式会社 ベルコ');
ok($zip->set_number('0628641')->is_valid_number, '札幌市南部市税事務所');
ok($zip->set_number('0628642')->is_valid_number, '株式会社 本の店 岩本');
ok($zip->set_number('0628655')->is_valid_number, '株式会社 北海道日本ハムファイターズ');
ok($zip->set_number('0628666')->is_valid_number, 'トヨタカローラ札幌 (株)');
ok($zip->set_number('0628668')->is_valid_number, 'ヤナセオートモーティブ 株式会社 札幌支店(アウディ月寒)');
ok($zip->set_number('0628686')->is_valid_number, '(株) JA北海道情報センター');
ok($zip->set_number('0638501')->is_valid_number, '生活協同組合 コープさっぽろ');
ok($zip->set_number('0638507')->is_valid_number, '和光技研 株式会社');
ok($zip->set_number('0638510')->is_valid_number, 'ニチロ畜産 株式会社');
ok($zip->set_number('0638515')->is_valid_number, '株式会社 西友 西町店');
ok($zip->set_number('0638558')->is_valid_number, '株式会社 エス・エス・ソリューションズ');
ok($zip->set_number('0638580')->is_valid_number, '岩橋印刷 株式会社');
ok($zip->set_number('0638585')->is_valid_number, 'イオン札幌発寒ショッピングセンター');
ok($zip->set_number('0638601')->is_valid_number, '株式会社 札幌銀行 事務センター');
ok($zip->set_number('0638602')->is_valid_number, '(株) ウエス');
ok($zip->set_number('0638603')->is_valid_number, '株式会社 須田製版');
ok($zip->set_number('0638606')->is_valid_number, '丸高水産 株式会社');
ok($zip->set_number('0638607')->is_valid_number, '豊平製鋼 株式会社');
ok($zip->set_number('0638608')->is_valid_number, '大丸藤井 株式会社 紙包材営業部');
ok($zip->set_number('0638611')->is_valid_number, '株式会社 アマネセルR&Dセンター');
ok($zip->set_number('0638612')->is_valid_number, '札幌市西区役所');
ok($zip->set_number('0638641')->is_valid_number, '札幌市西部市税事務所');
ok($zip->set_number('0648501')->is_valid_number, '財団法人 北海道体育協会');
ok($zip->set_number('0648502')->is_valid_number, '北海商銀信用組合');
ok($zip->set_number('0648503')->is_valid_number, '渥美工業 (株)');
ok($zip->set_number('0648505')->is_valid_number, '北海道神宮');
ok($zip->set_number('0648506')->is_valid_number, '財団法人 北海道難病連');
ok($zip->set_number('0648509')->is_valid_number, '(株) 札幌東急イン');
ok($zip->set_number('0648510')->is_valid_number, '陸上自衛隊 北部方面総監部');
ok($zip->set_number('0648511')->is_valid_number, '株式会社 アマネセル');
ok($zip->set_number('0648512')->is_valid_number, '三井道路 (株) 北海道支社');
ok($zip->set_number('0648515')->is_valid_number, '北海道換気 株式会社');
ok($zip->set_number('0648516')->is_valid_number, '札幌市 中央図書館');
ok($zip->set_number('0648519')->is_valid_number, 'NTTテレワイズ・ワイドサービスセンター');
ok($zip->set_number('0648520')->is_valid_number, '札幌河辺石油 (株)');
ok($zip->set_number('0648521')->is_valid_number, '清水勧業 (株)');
ok($zip->set_number('0648522')->is_valid_number, '(有) 日本書道評論社 北海道書道協会');
ok($zip->set_number('0648523')->is_valid_number, '北星学園 女子中学校高等学校');
ok($zip->set_number('0648524')->is_valid_number, '北星学園 女子短期大学');
ok($zip->set_number('0648525')->is_valid_number, '株式会社 さくらパートナー');
ok($zip->set_number('0648526')->is_valid_number, '(株) サミットインターナショナル');
ok($zip->set_number('0648528')->is_valid_number, '株式会社 タカノ 札幌支店');
ok($zip->set_number('0648530')->is_valid_number, '(株) ユタカ商会');
ok($zip->set_number('0648532')->is_valid_number, 'サッポロウエシマコーヒー 株式会社');
ok($zip->set_number('0648533')->is_valid_number, '(株) ジャスマックプラザホテル');
ok($zip->set_number('0648535')->is_valid_number, '北海道 札幌旭丘高等学校');
ok($zip->set_number('0648536')->is_valid_number, '医療法人社団 慈藻会 平松病院');
ok($zip->set_number('0648537')->is_valid_number, '北海道営林局');
ok($zip->set_number('0648540')->is_valid_number, '学校法人 聖心女子学院 札幌聖心女子学院');
ok($zip->set_number('0648541')->is_valid_number, 'トヨタビスタ札幌 (株)');
ok($zip->set_number('0648542')->is_valid_number, '(株) 日本商工振興会');
ok($zip->set_number('0648543')->is_valid_number, 'ヤマハ (株) 北海道支店');
ok($zip->set_number('0648544')->is_valid_number, '大日本インキ化学工業 (株) 札幌支店');
ok($zip->set_number('0648545')->is_valid_number, '(株) 日商物産 札幌支店');
ok($zip->set_number('0648546')->is_valid_number, 'ロッテ商事 (株) 北海道統轄支店');
ok($zip->set_number('0648550')->is_valid_number, '(株) 財界さっぽろ');
ok($zip->set_number('0648551')->is_valid_number, '株式会社 福本商店');
ok($zip->set_number('0648552')->is_valid_number, '前田建設工業 (株) 北海道支店');
ok($zip->set_number('0648554')->is_valid_number, '税理士法人 池脇会計事務所');
ok($zip->set_number('0648555')->is_valid_number, '財団法人 日本気象協会 北海道本部');
ok($zip->set_number('0648556')->is_valid_number, '日本ビジネス綜合専門学校');
ok($zip->set_number('0648557')->is_valid_number, '医療法人 渓仁会 西円山病院');
ok($zip->set_number('0648558')->is_valid_number, '株式会社 エス・ビー・シー');
ok($zip->set_number('0648560')->is_valid_number, '道路工業 (株)');
ok($zip->set_number('0648561')->is_valid_number, '(株) ホテルアーサー札幌');
ok($zip->set_number('0648562')->is_valid_number, '株式会社 USEN 北海道支社');
ok($zip->set_number('0648563')->is_valid_number, '(株) アンフィニアクト札幌');
ok($zip->set_number('0648564')->is_valid_number, '北海道 中央児童相談所');
ok($zip->set_number('0648565')->is_valid_number, '北海道 自動車交通共済協同組合');
ok($zip->set_number('0648566')->is_valid_number, '北海道立 教職員検診センター');
ok($zip->set_number('0648567')->is_valid_number, '医療法人 シオン');
ok($zip->set_number('0648570')->is_valid_number, '医療法人 讃生会 宮の森記念病院');
ok($zip->set_number('0648571')->is_valid_number, '大正製薬 株式会社 札幌支店');
ok($zip->set_number('0648575')->is_valid_number, '社会福祉法人 札幌慈啓会 慈啓会病院');
ok($zip->set_number('0648577')->is_valid_number, '北海道いすゞ自動車 株式会社');
ok($zip->set_number('0648581')->is_valid_number, '(株) 太陽');
ok($zip->set_number('0648584')->is_valid_number, '株式会社 大京 北海道支店');
ok($zip->set_number('0648585')->is_valid_number, '株式会社 シミズ電建');
ok($zip->set_number('0648586')->is_valid_number, '札幌市消防局');
ok($zip->set_number('0648587')->is_valid_number, '(株) 小鍛冶組');
ok($zip->set_number('0648589')->is_valid_number, '三井観光開発 (株) 札幌パークホテル');
ok($zip->set_number('0648601')->is_valid_number, '株式会社 帝国データバンク 札幌支店');
ok($zip->set_number('0648605')->is_valid_number, '株式会社 学生援護会北海道');
ok($zip->set_number('0648609')->is_valid_number, '札幌公共職業安定所');
ok($zip->set_number('0648610')->is_valid_number, '株式会社 アークス');
ok($zip->set_number('0648611')->is_valid_number, '北海道札幌南高等学校');
ok($zip->set_number('0648620')->is_valid_number, '(株) セイコーマート');
ok($zip->set_number('0648621')->is_valid_number, '株式会社 ラルズ');
ok($zip->set_number('0648622')->is_valid_number, '北海道循環器病院');
ok($zip->set_number('0648624')->is_valid_number, '北海道 札幌西高等学校');
ok($zip->set_number('0648628')->is_valid_number, '(株) 銭高組 北海道支店');
ok($zip->set_number('0648629')->is_valid_number, '北海道高等盲学校');
ok($zip->set_number('0648630')->is_valid_number, '株式会社 ダブルス');
ok($zip->set_number('0648633')->is_valid_number, '(株) ビッグ');
ok($zip->set_number('0648639')->is_valid_number, '北海道 税理士会');
ok($zip->set_number('0648641')->is_valid_number, 'エスエス製薬 株式会社 北海道支店');
ok($zip->set_number('0648642')->is_valid_number, '株式会社 タイタススキャット');
ok($zip->set_number('0648644')->is_valid_number, 'サザエ食品 (株)');
ok($zip->set_number('0648645')->is_valid_number, '北海道 都市職員共済組合');
ok($zip->set_number('0648648')->is_valid_number, '(株) 村住経営');
ok($zip->set_number('0648649')->is_valid_number, '札幌市市民局 文化部');
ok($zip->set_number('0648668')->is_valid_number, '株式会社 スポーツハウス');
ok($zip->set_number('0648686')->is_valid_number, 'ホシ伊藤 株式会社');
ok($zip->set_number('0648798')->is_valid_number, '北海道郵政研修センター');
ok($zip->set_number('0658501')->is_valid_number, '関販テクノ 株式会社');
ok($zip->set_number('0658508')->is_valid_number, '(株) 北海道アマダ');
ok($zip->set_number('0658510')->is_valid_number, '(株) 構研エンジニアリング');
ok($zip->set_number('0658511')->is_valid_number, '(株) さつでん');
ok($zip->set_number('0658518')->is_valid_number, 'アリオ札幌ショッピングセンター');
ok($zip->set_number('0658522')->is_valid_number, '日本アクセス北海道 (株)');
ok($zip->set_number('0658533')->is_valid_number, '財団法人 北海道対がん協会');
ok($zip->set_number('0658543')->is_valid_number, '北海道 青果商業協同組合');
ok($zip->set_number('0658550')->is_valid_number, '大和ハウス工業 株式会社 札幌支店');
ok($zip->set_number('0658555')->is_valid_number, '医療法人社団 道都病院');
ok($zip->set_number('0658558')->is_valid_number, '北海道 札幌開成高等学校');
ok($zip->set_number('0658567')->is_valid_number, '札幌大谷短期大学');
ok($zip->set_number('0658578')->is_valid_number, '学校法人 札幌北斗学園');
ok($zip->set_number('0658601')->is_valid_number, 'ネッツトヨタ札幌 株式会社');
ok($zip->set_number('0658609')->is_valid_number, '札幌北公共職業安定所');
ok($zip->set_number('0658610')->is_valid_number, '株式会社 中山組');
ok($zip->set_number('0658611')->is_valid_number, '医療法人社団 カレスアライアンス天使病院');
ok($zip->set_number('0658612')->is_valid_number, '札幌市東区役所');
ok($zip->set_number('0658633')->is_valid_number, 'サッポロビール (株) 北海道本社');
ok($zip->set_number('0658639')->is_valid_number, 'サツラク農業協同組合');
ok($zip->set_number('0658686')->is_valid_number, '日本ハム 株式会社 北海道販売部');
ok($zip->set_number('0668501')->is_valid_number, '北海道千歳高等学校');
ok($zip->set_number('0668502')->is_valid_number, 'パナソニックエレクトロニックデバイス北海道 株式会社');
ok($zip->set_number('0668504')->is_valid_number, '国土交通省 東京航空局 新千歳空港事務所');
ok($zip->set_number('0668508')->is_valid_number, '千歳市商店街振興組合連合会');
ok($zip->set_number('0668510')->is_valid_number, '航空自衛隊 千歳基地');
ok($zip->set_number('0668512')->is_valid_number, '北海道森紙業 株式会社 札幌事業所千歳工場');
ok($zip->set_number('0668515')->is_valid_number, '道央農協協同組合 千歳支所');
ok($zip->set_number('0668520')->is_valid_number, '千歳国際ホテル 株式会社');
ok($zip->set_number('0668533')->is_valid_number, 'ミツミ電機 株式会社 千歳事業所');
ok($zip->set_number('0668550')->is_valid_number, '市立千歳市民病院');
ok($zip->set_number('0668555')->is_valid_number, 'スター農機 株式会社');
ok($zip->set_number('0668557')->is_valid_number, '(株) ポスフール 千歳店');
ok($zip->set_number('0668558')->is_valid_number, '千歳商工会議所');
ok($zip->set_number('0668566')->is_valid_number, '国際電気 株式会社 千歳工場');
ok($zip->set_number('0668567')->is_valid_number, 'カルビー 株式会社 千歳工場');
ok($zip->set_number('0668570')->is_valid_number, '東洋製罐 株式会社 千歳工場');
ok($zip->set_number('0668577')->is_valid_number, '陸上自衛隊 東千歳駐屯地');
ok($zip->set_number('0668585')->is_valid_number, '株式会社 ダイナックス');
ok($zip->set_number('0668588')->is_valid_number, 'フランスベット 株式会社 北海道工場');
ok($zip->set_number('0668601')->is_valid_number, '千歳印刷 株式会社');
ok($zip->set_number('0668610')->is_valid_number, '日本赤十字社 血漿分画センター');
ok($zip->set_number('0668611')->is_valid_number, '北海道千歳北陽高等学校');
ok($zip->set_number('0668622')->is_valid_number, '日本航空専門学校');
ok($zip->set_number('0668633')->is_valid_number, '北海道電力 株式会社 千歳支社');
ok($zip->set_number('0668637')->is_valid_number, '千歳全日空ホテル');
ok($zip->set_number('0668639')->is_valid_number, '北央三菱自動車販売 株式会社');
ok($zip->set_number('0668649')->is_valid_number, '全日本空輸 株式会社 千歳空港支店');
ok($zip->set_number('0668655')->is_valid_number, '千歳科学技術大学');
ok($zip->set_number('0668660')->is_valid_number, '株式会社 山三ふじや');
ok($zip->set_number('0668666')->is_valid_number, '北海道石狩保険福祉事務所 千歳地域保健部');
ok($zip->set_number('0668668')->is_valid_number, '陸上自衛隊 北千歳駐屯地');
ok($zip->set_number('0668686')->is_valid_number, '千歳市役所');
ok($zip->set_number('0668711')->is_valid_number, 'キリンビール 株式会社 千歳工場');
ok($zip->set_number('0668765')->is_valid_number, '千歳アウトレットモール・レラ');
ok($zip->set_number('0668787')->is_valid_number, 'セイコーエプソン (株) 千歳事業所');
ok($zip->set_number('0678501')->is_valid_number, '株式会社 ペイロール 北海道BPOセンター');
ok($zip->set_number('0678547')->is_valid_number, '江別商工会議所');
ok($zip->set_number('0678551')->is_valid_number, '(株) 菊水');
ok($zip->set_number('0678564')->is_valid_number, '江別高等学校');
ok($zip->set_number('0678565')->is_valid_number, '北海鋼機 (株)');
ok($zip->set_number('0678585')->is_valid_number, '江別市立病院');
ok($zip->set_number('0678674')->is_valid_number, '江別市役所');
ok($zip->set_number('0680194')->is_valid_number, '岩見市役所 栗沢支所');
ok($zip->set_number('0680492')->is_valid_number, '夕張市役所');
ok($zip->set_number('0681192')->is_valid_number, '新篠津村役場');
ok($zip->set_number('0681193')->is_valid_number, '新篠津村農業協同組合');
ok($zip->set_number('0681194')->is_valid_number, '北海道新篠津高等養護学校');
ok($zip->set_number('0681195')->is_valid_number, '社会福祉法人 新篠津福祉会');
ok($zip->set_number('0681292')->is_valid_number, '岩見沢市役所 北村支所');
ok($zip->set_number('0682192')->is_valid_number, '三笠市役所');
ok($zip->set_number('0682193')->is_valid_number, '三笠市教育委員会');
ok($zip->set_number('0682194')->is_valid_number, '市立三笠総合病院');
ok($zip->set_number('0688550')->is_valid_number, '北海道 教育庁空知教育局');
ok($zip->set_number('0688555')->is_valid_number, '岩見沢市立総合病院');
ok($zip->set_number('0688558')->is_valid_number, '北海道 空知支庁');
ok($zip->set_number('0688588')->is_valid_number, '(株) きたいち');
ok($zip->set_number('0688609')->is_valid_number, '岩見沢公共職業安定所');
ok($zip->set_number('0688639')->is_valid_number, '株式会社 コミュニティエフエムはまなす');
ok($zip->set_number('0688642')->is_valid_number, '北海道 教育大学教育学部岩見沢校');
ok($zip->set_number('0688650')->is_valid_number, '岩石綜合物産');
ok($zip->set_number('0688660')->is_valid_number, '空知信用金庫');
ok($zip->set_number('0688666')->is_valid_number, '北燃商事 株式会社');
ok($zip->set_number('0688686')->is_valid_number, '岩見沢市役所');
ok($zip->set_number('0688688')->is_valid_number, '岩見沢ガス (株)');
ok($zip->set_number('0690292')->is_valid_number, '南幌町役場');
ok($zip->set_number('0690293')->is_valid_number, '南幌町農業協同組合');
ok($zip->set_number('0691292')->is_valid_number, '由仁町役場');
ok($zip->set_number('0691293')->is_valid_number, '由仁町立由仁中学校');
ok($zip->set_number('0691295')->is_valid_number, '北海道由仁商業高等学校');
ok($zip->set_number('0691296')->is_valid_number, '由仁町農業協同組合');
ok($zip->set_number('0691297')->is_valid_number, '空知信用金庫 由仁支店');
ok($zip->set_number('0691298')->is_valid_number, '由仁町商工会');
ok($zip->set_number('0691392')->is_valid_number, '長沼町役場');
ok($zip->set_number('0691393')->is_valid_number, 'ながぬま農業協同組合');
ok($zip->set_number('0691394')->is_valid_number, '航空自衛隊長沼分屯基地');
ok($zip->set_number('0691395')->is_valid_number, '北海道立 中央農業試験場');
ok($zip->set_number('0698501')->is_valid_number, '酪農学園大学');
ok($zip->set_number('0698511')->is_valid_number, '北翔大学・北翔大学短期大学部');
ok($zip->set_number('0698533')->is_valid_number, 'とわの森三愛高等学校');
ok($zip->set_number('0698555')->is_valid_number, '札幌学院大学');
ok($zip->set_number('0698585')->is_valid_number, '北海道情報大学');
ok($zip->set_number('0708502')->is_valid_number, '株式会社 湯浅');
ok($zip->set_number('0708503')->is_valid_number, '株式会社 丸善三番館');
ok($zip->set_number('0708505')->is_valid_number, '旭川社会保険事務所');
ok($zip->set_number('0708507')->is_valid_number, '(株) 西武百貨店 旭川店');
ok($zip->set_number('0708510')->is_valid_number, '(株) NTT東日本北海道 116旭川センター');
ok($zip->set_number('0708511')->is_valid_number, '株式会社 エヌシーマック');
ok($zip->set_number('0708515')->is_valid_number, '旭川ガス (株)');
ok($zip->set_number('0708520')->is_valid_number, '(株) NTT東日本北海道 旭川支店');
ok($zip->set_number('0708525')->is_valid_number, '旭川市役所');
ok($zip->set_number('0708530')->is_valid_number, '総合病院 旭川赤十字病院');
ok($zip->set_number('0708540')->is_valid_number, '旭川商工会議所');
ok($zip->set_number('0708541')->is_valid_number, '旭川市水道局');
ok($zip->set_number('0708550')->is_valid_number, '北海道森林管理局 旭川事務所');
ok($zip->set_number('0708560')->is_valid_number, '旭川トヨペット 株式会社');
ok($zip->set_number('0708567')->is_valid_number, '(株) 北海道伝統美術工芸村');
ok($zip->set_number('0708601')->is_valid_number, '北海道東海大学 旭川校舎');
ok($zip->set_number('0708610')->is_valid_number, '市立旭川病院');
ok($zip->set_number('0708611')->is_valid_number, '日本製紙 株式会社 旭川工場');
ok($zip->set_number('0708612')->is_valid_number, '株式会社 アーバンライフ 建築総合研究所');
ok($zip->set_number('0708616')->is_valid_number, '北海道旭川土木現業所');
ok($zip->set_number('0708621')->is_valid_number, '北海道教育大学 教育学部 旭川校');
ok($zip->set_number('0708630')->is_valid_number, '陸上自衛隊 旭川駐屯地');
ok($zip->set_number('0708636')->is_valid_number, '旭川地方検察庁');
ok($zip->set_number('0708639')->is_valid_number, '(株) ポスフール 春光店');
ok($zip->set_number('0708640')->is_valid_number, '旭川地方裁判所');
ok($zip->set_number('0708641')->is_valid_number, '旭川家庭裁判所');
ok($zip->set_number('0708642')->is_valid_number, '旭川簡易裁判所');
ok($zip->set_number('0708644')->is_valid_number, '独立行政法人 国立病院機構 道北病院');
ok($zip->set_number('0708650')->is_valid_number, '山室繊維 株式会社');
ok($zip->set_number('0708651')->is_valid_number, '日本生命保険 相互会社 旭川支社');
ok($zip->set_number('0708653')->is_valid_number, '上川生産連農業会館 管理協議会');
ok($zip->set_number('0708655')->is_valid_number, '株式会社 丸井今井 旭川店');
ok($zip->set_number('0708660')->is_valid_number, '旭川信用金庫');
ok($zip->set_number('0708666')->is_valid_number, '株式会社 キシイ');
ok($zip->set_number('0708670')->is_valid_number, '株式会社 北陸銀行 旭川支店');
ok($zip->set_number('0708676')->is_valid_number, '旭川日産自動車 株式会社');
ok($zip->set_number('0708677')->is_valid_number, '株式会社 北野組');
ok($zip->set_number('0708678')->is_valid_number, '北海道電力 株式会社 旭川支店');
ok($zip->set_number('0708680')->is_valid_number, '日本放送協会 旭川放送局');
ok($zip->set_number('0708686')->is_valid_number, '北海道労働金庫 旭川支店');
ok($zip->set_number('0708688')->is_valid_number, '株式会社 谷内');
ok($zip->set_number('0708701')->is_valid_number, '協同組合 日専連旭川');
ok($zip->set_number('0708710')->is_valid_number, '(株) 北洋銀行 旭川中央支店');
ok($zip->set_number('0708711')->is_valid_number, '旭川トヨタ自動車 株式会社');
ok($zip->set_number('0708720')->is_valid_number, '株式会社 北海道新聞 旭川支社');
ok($zip->set_number('0708722')->is_valid_number, '旭陽電機 株式会社');
ok($zip->set_number('0710192')->is_valid_number, '東神楽農業協同組合 西神楽支店');
ok($zip->set_number('0710198')->is_valid_number, '北海道立 林産試験場');
ok($zip->set_number('0710292')->is_valid_number, '美瑛町役場');
ok($zip->set_number('0710298')->is_valid_number, '美瑛町農業協同組合');
ok($zip->set_number('0710596')->is_valid_number, '上富良野町役場');
ok($zip->set_number('0710597')->is_valid_number, 'ふらの農業協同組合 上富良野支所');
ok($zip->set_number('0710795')->is_valid_number, '中富良野町役場');
ok($zip->set_number('0710798')->is_valid_number, '株式会社 西條スーパーセンターBESTOM 中富良野店');
ok($zip->set_number('0711292')->is_valid_number, '鷹栖町役場');
ok($zip->set_number('0711293')->is_valid_number, 'たいせつ農業協同組合 鷹栖支所');
ok($zip->set_number('0711295')->is_valid_number, '株式会社 ヘルス');
ok($zip->set_number('0711298')->is_valid_number, '株式会社 みらいプリンティング');
ok($zip->set_number('0711492')->is_valid_number, '東川町役場');
ok($zip->set_number('0711493')->is_valid_number, '東川町教育委員会');
ok($zip->set_number('0711494')->is_valid_number, '株式会社 天人閣');
ok($zip->set_number('0711495')->is_valid_number, '東川町農業協同組合');
ok($zip->set_number('0711496')->is_valid_number, '北工学園旭川福祉専門学校');
ok($zip->set_number('0711497')->is_valid_number, '北海道理工福祉専門学校');
ok($zip->set_number('0711592')->is_valid_number, '東神楽町役場');
ok($zip->set_number('0711593')->is_valid_number, '東神楽農業協同組合');
ok($zip->set_number('0711596')->is_valid_number, '株式会社 ヨコマク');
ok($zip->set_number('0728660')->is_valid_number, '美唄市役所');
ok($zip->set_number('0730192')->is_valid_number, '砂川社会保険事務所');
ok($zip->set_number('0730195')->is_valid_number, '砂川市役所');
ok($zip->set_number('0730196')->is_valid_number, '砂川市立病院');
ok($zip->set_number('0730292')->is_valid_number, '上砂川町役場');
ok($zip->set_number('0730492')->is_valid_number, '歌志内市役所');
ok($zip->set_number('0738501')->is_valid_number, '中山組');
ok($zip->set_number('0738502')->is_valid_number, '滝川労働基準監督署');
ok($zip->set_number('0738510')->is_valid_number, '陸上自衛隊 滝川駐屯地');
ok($zip->set_number('0738511')->is_valid_number, '滝川商工会議所');
ok($zip->set_number('0738585')->is_valid_number, '札幌法務局 滝川支局');
ok($zip->set_number('0738686')->is_valid_number, '滝川市役所');
ok($zip->set_number('0738688')->is_valid_number, '北門信用金庫');
ok($zip->set_number('0740492')->is_valid_number, '幌加内町役場');
ok($zip->set_number('0740493')->is_valid_number, '幌加内町農業協同組合');
ok($zip->set_number('0740494')->is_valid_number, '幌加内営林署');
ok($zip->set_number('0740495')->is_valid_number, '幌加内高等学校');
ok($zip->set_number('0748585')->is_valid_number, '拓殖大学 北海道短期大学');
ok($zip->set_number('0748650')->is_valid_number, '深川市役所');
ok($zip->set_number('0748686')->is_valid_number, '北空知信用金庫');
ok($zip->set_number('0758501')->is_valid_number, '芦別市立病院');
ok($zip->set_number('0758711')->is_valid_number, '芦別市役所');
ok($zip->set_number('0768511')->is_valid_number, '株式会社 プリンスホテル 新富良野プリンスホテル');
ok($zip->set_number('0768555')->is_valid_number, '富良野市役所');
ok($zip->set_number('0768609')->is_valid_number, '旭川公共職業安定所 富良野出張所');
ok($zip->set_number('0768666')->is_valid_number, 'ふらの農業協同組合');
ok($zip->set_number('0768765')->is_valid_number, '社会福祉法人 北海道社会事業協会 富良野病院');
ok($zip->set_number('0770292')->is_valid_number, '増毛町役場');
ok($zip->set_number('0770293')->is_valid_number, '増毛漁業協同組合');
ok($zip->set_number('0770295')->is_valid_number, '増毛町教育委員会');
ok($zip->set_number('0770296')->is_valid_number, '増毛町立増毛中学校');
ok($zip->set_number('0770297')->is_valid_number, '北海道増毛高等学校');
ok($zip->set_number('0778501')->is_valid_number, '留萌開発建設部');
ok($zip->set_number('0778511')->is_valid_number, '留萌市立総合病院');
ok($zip->set_number('0778585')->is_valid_number, '北海道 留萌支庁');
ok($zip->set_number('0778601')->is_valid_number, '留萌市役所');
ok($zip->set_number('0778660')->is_valid_number, '留萌地区農業団体連絡協議会');
ok($zip->set_number('0778686')->is_valid_number, '留萌信用金庫');
ok($zip->set_number('0780392')->is_valid_number, '比布町役場');
ok($zip->set_number('0780397')->is_valid_number, '北海道立 上川農業試験場');
ok($zip->set_number('0781393')->is_valid_number, '当麻町役場');
ok($zip->set_number('0781395')->is_valid_number, '当麻農業協同組合');
ok($zip->set_number('0781492')->is_valid_number, '愛別町役場');
ok($zip->set_number('0781493')->is_valid_number, '愛別町教育委員会');
ok($zip->set_number('0781495')->is_valid_number, '愛別町農業協同組合');
ok($zip->set_number('0781792')->is_valid_number, '(株) 層雲閣グランドホテル');
ok($zip->set_number('0781793')->is_valid_number, '西野目産業 (株) ホテル大雪');
ok($zip->set_number('0781795')->is_valid_number, '層雲峡プリンスホテル朝陽亭');
ok($zip->set_number('0781796')->is_valid_number, 'ホテル層雲');
ok($zip->set_number('0781797')->is_valid_number, '大友観光開発 (株) 層雲峡観光ホテル');
ok($zip->set_number('0782192')->is_valid_number, '秩父別町役場');
ok($zip->set_number('0782193')->is_valid_number, '北いぶき農業協同組合');
ok($zip->set_number('0782692')->is_valid_number, '雨竜町役場');
ok($zip->set_number('0783392')->is_valid_number, '小平町役場');
ok($zip->set_number('0783393')->is_valid_number, '小平町教育委員会');
ok($zip->set_number('0783394')->is_valid_number, 'JA南るもい農業協同組合 小平支所');
ok($zip->set_number('0783792')->is_valid_number, '苫前町役場');
ok($zip->set_number('0784193')->is_valid_number, '留萌信用金庫 羽幌支店');
ok($zip->set_number('0784194')->is_valid_number, '北海道羽幌高等学校');
ok($zip->set_number('0784196')->is_valid_number, '(株) 北海道銀行 羽幌支店');
ok($zip->set_number('0784198')->is_valid_number, '羽幌町役場');
ok($zip->set_number('0784492')->is_valid_number, '初山別村役場');
ok($zip->set_number('0788501')->is_valid_number, '旭川行政評価分室');
ok($zip->set_number('0788502')->is_valid_number, '旭川地方法務局');
ok($zip->set_number('0788503')->is_valid_number, '旭川財務事務所');
ok($zip->set_number('0788504')->is_valid_number, '旭川中税務署');
ok($zip->set_number('0788505')->is_valid_number, '旭川労働基準監督署');
ok($zip->set_number('0788506')->is_valid_number, '農林水産省 北海道農政事務所 地域第四課 旭川統計情報センター');
ok($zip->set_number('0788510')->is_valid_number, '旭川医科大学');
ok($zip->set_number('0788511')->is_valid_number, '北海道警察旭川方面本部');
ok($zip->set_number('0788513')->is_valid_number, '旭川開発建設部');
ok($zip->set_number('0788555')->is_valid_number, '中小企業大学校旭川校');
ok($zip->set_number('0790192')->is_valid_number, 'JAみねのぶ');
ok($zip->set_number('0790197')->is_valid_number, '専修大学北海道短期大学');
ok($zip->set_number('0790198')->is_valid_number, '北海道立 林業試験場');
ok($zip->set_number('0790392')->is_valid_number, '奈井江町役場');
ok($zip->set_number('0790393')->is_valid_number, '新砂川農業協同組合 奈井江支所');
ok($zip->set_number('0790394')->is_valid_number, '株式会社 砂子組');
ok($zip->set_number('0790397')->is_valid_number, '釜屋電機 株式会社 北海道奈井江工場');
ok($zip->set_number('0790592')->is_valid_number, '妹背牛町役場');
ok($zip->set_number('0790593')->is_valid_number, '北いぶき農業協同組合 妹背牛支所');
ok($zip->set_number('0790595')->is_valid_number, '妻神工業 株式会社');
ok($zip->set_number('0791192')->is_valid_number, '赤平市役所');
ok($zip->set_number('0791393')->is_valid_number, '株式会社 オプトエレクトロニクス 芦別工場');
ok($zip->set_number('0791396')->is_valid_number, '滝沢ベニヤ 株式会社');
ok($zip->set_number('0791397')->is_valid_number, '北日本精機 株式会社');
ok($zip->set_number('0798501')->is_valid_number, '旭川大学・旭川大学女子短期大学部');
ok($zip->set_number('0798502')->is_valid_number, '丸日商事 株式会社');
ok($zip->set_number('0798503')->is_valid_number, '株式会社 トワニ 旭川店');
ok($zip->set_number('0798505')->is_valid_number, '旭川大学高等学校');
ok($zip->set_number('0798507')->is_valid_number, '株式会社 スハラ食品');
ok($zip->set_number('0798508')->is_valid_number, '北海道旭川凌雲高等学校');
ok($zip->set_number('0798509')->is_valid_number, '株式会社 カンディハウス');
ok($zip->set_number('0798510')->is_valid_number, '三井食品 株式会社 北海道支社 旭川支店');
ok($zip->set_number('0798511')->is_valid_number, '株式会社 中野銘木店');
ok($zip->set_number('0798513')->is_valid_number, '株式会社 ほくやく 旭川支店');
ok($zip->set_number('0798514')->is_valid_number, '大丸藤井 株式会社 旭川支店');
ok($zip->set_number('0798516')->is_valid_number, 'ジャパン建材 (株) 旭川営業所');
ok($zip->set_number('0798518')->is_valid_number, '株式会社 北海道リョーショク 旭川支社');
ok($zip->set_number('0798519')->is_valid_number, '株式会社 松井旭川');
ok($zip->set_number('0798550')->is_valid_number, 'ネッツトヨタたいせつ 株式会社');
ok($zip->set_number('0798555')->is_valid_number, '株式会社 コハタ');
ok($zip->set_number('0798585')->is_valid_number, '株式会社 ふじ');
ok($zip->set_number('0798588')->is_valid_number, '旭川国分 (株)');
ok($zip->set_number('0798610')->is_valid_number, '北海道上川支庁');
ok($zip->set_number('0798611')->is_valid_number, '北海道上川保健所');
ok($zip->set_number('0798612')->is_valid_number, '北海道教育庁 上川教育局');
ok($zip->set_number('0798613')->is_valid_number, '北海道旭川土木現業所');
ok($zip->set_number('0798650')->is_valid_number, '株式会社 キョクイチ');
ok($zip->set_number('0798651')->is_valid_number, '丸果 旭川青果卸売市場 株式会社');
ok($zip->set_number('0798652')->is_valid_number, '株式会社 一印 旭川魚卸売市場');
ok($zip->set_number('0798653')->is_valid_number, '永山農業協同組合');
ok($zip->set_number('0798655')->is_valid_number, '今井金商 株式会社 旭川支店');
ok($zip->set_number('0798656')->is_valid_number, '(株) ホクレン油機サービス 旭川支店');
ok($zip->set_number('0800196')->is_valid_number, '株式会社 柳月');
ok($zip->set_number('0800197')->is_valid_number, '十勝川温泉 第一ホテル');
ok($zip->set_number('0800198')->is_valid_number, '音更町役場');
ok($zip->set_number('0801492')->is_valid_number, '上士幌町役場');
ok($zip->set_number('0801493')->is_valid_number, '上士幌町農業協同組合');
ok($zip->set_number('0802492')->is_valid_number, '帯広地方卸売市場 株式会社');
ok($zip->set_number('0802493')->is_valid_number, '帯広松下電工 (株)');
ok($zip->set_number('0802495')->is_valid_number, '帯広三菱ふそう自動車販売 (株)');
ok($zip->set_number('0802496')->is_valid_number, '六花亭製菓 株式会社');
ok($zip->set_number('0802497')->is_valid_number, '東北海道日野自動車 株式会社');
ok($zip->set_number('0802498')->is_valid_number, '(株) 福原');
ok($zip->set_number('0808501')->is_valid_number, '株式会社 イトーヨーカ堂 帯広店');
ok($zip->set_number('0808502')->is_valid_number, '厚生連総合病院 帯広厚生病院');
ok($zip->set_number('0808503')->is_valid_number, '北海道帯広柏葉高等学校');
ok($zip->set_number('0808510')->is_valid_number, '釧路地方法務局 帯広支局');
ok($zip->set_number('0808511')->is_valid_number, '株式会社 北海道ホテル');
ok($zip->set_number('0808518')->is_valid_number, '独立行政法人 国立病院機構 帯広病院');
ok($zip->set_number('0808531')->is_valid_number, 'ポスフール 帯広店');
ok($zip->set_number('0808538')->is_valid_number, '株式会社 長崎屋 帯広店');
ok($zip->set_number('0808550')->is_valid_number, '株式会社 NTT東日本北海道 帯広支店');
ok($zip->set_number('0808555')->is_valid_number, '帯広畜産大学');
ok($zip->set_number('0808560')->is_valid_number, '北海道放送 帯広放送局');
ok($zip->set_number('0808570')->is_valid_number, 'トータルフーズ 株式会社');
ok($zip->set_number('0808585')->is_valid_number, '帯広開発建設部');
ok($zip->set_number('0808588')->is_valid_number, '北海道 十勝支庁');
ok($zip->set_number('0808601')->is_valid_number, '丸越 株式会社');
ok($zip->set_number('0808609')->is_valid_number, '帯広公共職業安定所');
ok($zip->set_number('0808623')->is_valid_number, '帯広日産自動車 株式会社');
ok($zip->set_number('0808639')->is_valid_number, '陸上自衛隊 帯広駐屯地');
ok($zip->set_number('0808642')->is_valid_number, '帯広市民生活協同組合');
ok($zip->set_number('0808655')->is_valid_number, '北海道新聞 帯広支社');
ok($zip->set_number('0808660')->is_valid_number, '北海道電力 株式会社 帯広支店');
ok($zip->set_number('0808666')->is_valid_number, '山田機械工業 株式会社');
ok($zip->set_number('0808670')->is_valid_number, '帯広市役所');
ok($zip->set_number('0808677')->is_valid_number, '株式会社 藤丸');
ok($zip->set_number('0808680')->is_valid_number, '(株) 北洋銀行 帯広中央支店');
ok($zip->set_number('0808686')->is_valid_number, '(株) 日専連おびひろ');
ok($zip->set_number('0808688')->is_valid_number, '株式会社 十勝毎日新聞社');
ok($zip->set_number('0808701')->is_valid_number, '帯広信用金庫');
ok($zip->set_number('0808708')->is_valid_number, '株式会社 エヌシーおびひろ');
ok($zip->set_number('0808711')->is_valid_number, '帯広商工会議所');
ok($zip->set_number('0808718')->is_valid_number, 'ホクレン農業協同組合連合会 帯広支所');
ok($zip->set_number('0810292')->is_valid_number, '鹿追町役場');
ok($zip->set_number('0810293')->is_valid_number, '鹿追町農業協同組合');
ok($zip->set_number('0810294')->is_valid_number, '陸上自衛隊 鹿追駐屯地業務隊');
ok($zip->set_number('0810295')->is_valid_number, '鹿追町国民健康保険病院');
ok($zip->set_number('0818501')->is_valid_number, '新得町役場');
ok($zip->set_number('0828650')->is_valid_number, '芽室町農業協同組合');
ok($zip->set_number('0828651')->is_valid_number, '芽室町役場');
ok($zip->set_number('0838585')->is_valid_number, '(有) ノース・ドリーム');
ok($zip->set_number('0838650')->is_valid_number, '池田町役場');
ok($zip->set_number('0848501')->is_valid_number, '道東国分 株式会社');
ok($zip->set_number('0848511')->is_valid_number, '釧路運転免許試験場');
ok($zip->set_number('0848555')->is_valid_number, '釧路スバル自動車 株式会社');
ok($zip->set_number('0848567')->is_valid_number, '株式会社 スハラ食品 釧路支店');
ok($zip->set_number('0848601')->is_valid_number, '杉野商事 株式会社 釧路店');
ok($zip->set_number('0848670')->is_valid_number, '大丸藤井 株式会社 釧路支店');
ok($zip->set_number('0848686')->is_valid_number, 'サンエス電気通信 株式会社');
ok($zip->set_number('0850292')->is_valid_number, '釧路市阿寒町行政センター');
ok($zip->set_number('0850293')->is_valid_number, '阿寒農業協同組合');
ok($zip->set_number('0858501')->is_valid_number, '株式会社 NTT東日本北海道 釧路支店');
ok($zip->set_number('0858502')->is_valid_number, '釧路社会保険事務所');
ok($zip->set_number('0858505')->is_valid_number, '釧路市役所');
ok($zip->set_number('0858510')->is_valid_number, '釧路労働基準監督署');
ok($zip->set_number('0858512')->is_valid_number, '総合病院 釧路赤十字病院');
ok($zip->set_number('0858515')->is_valid_number, '釧路税務署');
ok($zip->set_number('0858522')->is_valid_number, '釧路地方法務局');
ok($zip->set_number('0858527')->is_valid_number, '株式会社 日専連釧路');
ok($zip->set_number('0858533')->is_valid_number, '独立行政法人 労働者健康福祉機構 釧路労災病院');
ok($zip->set_number('0858535')->is_valid_number, '釧路保護観察所');
ok($zip->set_number('0858550')->is_valid_number, '金井漁業 (株)');
ok($zip->set_number('0858551')->is_valid_number, '釧路開発建設部');
ok($zip->set_number('0858555')->is_valid_number, '釧路ガス (株)');
ok($zip->set_number('0858557')->is_valid_number, '釧路地方検察庁');
ok($zip->set_number('0858558')->is_valid_number, '市立釧路総合病院');
ok($zip->set_number('0858580')->is_valid_number, '北海道教育大学 教育学部 釧路校');
ok($zip->set_number('0858581')->is_valid_number, '釧路プリンスホテル');
ok($zip->set_number('0858585')->is_valid_number, '釧路公立大学');
ok($zip->set_number('0858586')->is_valid_number, '釧路地方気象台');
ok($zip->set_number('0858588')->is_valid_number, '北海道釧路支庁');
ok($zip->set_number('0858639')->is_valid_number, '北海道地方環境事務所 釧路自然環境事務所');
ok($zip->set_number('0858649')->is_valid_number, '釧路財務事務所');
ok($zip->set_number('0858650')->is_valid_number, '(株) 釧路新聞社');
ok($zip->set_number('0858655')->is_valid_number, '(株) 北海道新聞社 釧路支社');
ok($zip->set_number('0858660')->is_valid_number, '日本放送協会 釧路放送局');
ok($zip->set_number('0858668')->is_valid_number, '北海道電力 (株) 釧路支店');
ok($zip->set_number('0858677')->is_valid_number, '日本生命保険 相互会社 釧路支社');
ok($zip->set_number('0861197')->is_valid_number, '中標津町役場');
ok($zip->set_number('0861892')->is_valid_number, '羅臼町役場');
ok($zip->set_number('0861893')->is_valid_number, '羅臼漁業協同組合');
ok($zip->set_number('0870192')->is_valid_number, '歯舞漁業協同組合');
ok($zip->set_number('0878555')->is_valid_number, '航空自衛隊 根室分屯基地');
ok($zip->set_number('0878588')->is_valid_number, '北海道根室支庁');
ok($zip->set_number('0878609')->is_valid_number, '根室公共職業安定所');
ok($zip->set_number('0878686')->is_valid_number, '市立根室病院');
ok($zip->set_number('0878711')->is_valid_number, '根室市役所');
ok($zip->set_number('0880192')->is_valid_number, '釧路市音別町行政センター');
ok($zip->set_number('0880193')->is_valid_number, '株式会社 大塚製薬工場 釧路工場');
ok($zip->set_number('0880392')->is_valid_number, '白糠町役場');
ok($zip->set_number('0880393')->is_valid_number, '白糠町農業 協同組合');
ok($zip->set_number('0880394')->is_valid_number, '白糠町漁業 協同組合');
ok($zip->set_number('0880395')->is_valid_number, '白糠町商工会');
ok($zip->set_number('0880592')->is_valid_number, '東和食品 株式会社');
ok($zip->set_number('0880595')->is_valid_number, '株式会社 釧路丸水');
ok($zip->set_number('0880598')->is_valid_number, '広洋水産 株式会社');
ok($zip->set_number('0880692')->is_valid_number, '釧路町役場');
ok($zip->set_number('0881192')->is_valid_number, '厚岸町役場');
ok($zip->set_number('0881193')->is_valid_number, '大地みらい信用金庫 厚岸支店');
ok($zip->set_number('0881194')->is_valid_number, '北海道釧路土木現業所 厚岸出張所');
ok($zip->set_number('0881195')->is_valid_number, '町立厚岸病院');
ok($zip->set_number('0881196')->is_valid_number, '釧路開発建設部 厚岸道路維持事業所');
ok($zip->set_number('0881592')->is_valid_number, '浜中町役場');
ok($zip->set_number('0882592')->is_valid_number, '道東あさひ農業協同組合 西春別支所');
ok($zip->set_number('0882593')->is_valid_number, '陸上自衛隊 別海駐屯地');
ok($zip->set_number('0883292')->is_valid_number, '弟子屈町');
ok($zip->set_number('0883395')->is_valid_number, '屈斜路プリンスホテル');
ok($zip->set_number('0890192')->is_valid_number, '清水町役場');
ok($zip->set_number('0890195')->is_valid_number, '清水赤十字病院');
ok($zip->set_number('0890198')->is_valid_number, '十勝清水町農業協同組合');
ok($zip->set_number('0890592')->is_valid_number, '札内農業協同組合');
ok($zip->set_number('0890595')->is_valid_number, '(株) 十勝正直村');
ok($zip->set_number('0890598')->is_valid_number, '札内砕石砂利 株式会社');
ok($zip->set_number('0890692')->is_valid_number, '幕別町役場');
ok($zip->set_number('0890693')->is_valid_number, '幕別町農業協同組合');
ok($zip->set_number('0891192')->is_valid_number, '帯広刑務所');
ok($zip->set_number('0891198')->is_valid_number, '帯広市川西農業協同組合');
ok($zip->set_number('0891392')->is_valid_number, '中札内村役場');
ok($zip->set_number('0891395')->is_valid_number, '中札内村農業協同組合');
ok($zip->set_number('0891592')->is_valid_number, '更別村農業協同組合');
ok($zip->set_number('0891595')->is_valid_number, '更別村役場');
ok($zip->set_number('0891795')->is_valid_number, '幕別町役場 忠類総合支所');
ok($zip->set_number('0892195')->is_valid_number, '大樹町役場');
ok($zip->set_number('0892492')->is_valid_number, '広尾町農業協同組合');
ok($zip->set_number('0892692')->is_valid_number, '広尾町');
ok($zip->set_number('0892693')->is_valid_number, '広尾サンタランド事務局');
ok($zip->set_number('0892695')->is_valid_number, '帯広信用金庫 広尾支店');
ok($zip->set_number('0892696')->is_valid_number, '株式会社 北海道銀行 広尾支店');
ok($zip->set_number('0892697')->is_valid_number, '日高信用金庫 広尾支店');
ok($zip->set_number('0893392')->is_valid_number, '本別町役場');
ok($zip->set_number('0893797')->is_valid_number, '足寄町役場');
ok($zip->set_number('0895392')->is_valid_number, '豊頃町役場');
ok($zip->set_number('0895393')->is_valid_number, '豊頃町農業協同組合');
ok($zip->set_number('0895692')->is_valid_number, '浦幌町役場');
ok($zip->set_number('0895695')->is_valid_number, '浦幌町農業協同組合');
ok($zip->set_number('0908501')->is_valid_number, '北見市役所');
ok($zip->set_number('0908502')->is_valid_number, '株式会社 トワニ 北見店');
ok($zip->set_number('0908503')->is_valid_number, '北見バス (株)');
ok($zip->set_number('0908507')->is_valid_number, '北見工業大学');
ok($zip->set_number('0908509')->is_valid_number, '(株) きたみ東急百貨店');
ok($zip->set_number('0908511')->is_valid_number, '北海道警察 北見方面本部');
ok($zip->set_number('0908518')->is_valid_number, '北海道 北見保健所');
ok($zip->set_number('0908519')->is_valid_number, '株式会社 北見東急イン');
ok($zip->set_number('0908532')->is_valid_number, '北海道労働金庫 北見支店');
ok($zip->set_number('0908533')->is_valid_number, '北海道北見柏陽高等学校');
ok($zip->set_number('0908540')->is_valid_number, '北見労働基準監督署');
ok($zip->set_number('0908550')->is_valid_number, '大丸藤井 株式会社 道北支店 北見出張所');
ok($zip->set_number('0908555')->is_valid_number, '北海商科大学 (北見キャンパス)');
ok($zip->set_number('0908558')->is_valid_number, '北海道 北見緑陵高等学校');
ok($zip->set_number('0908560')->is_valid_number, '株式会社 マルモ');
ok($zip->set_number('0908567')->is_valid_number, '小林病院');
ok($zip->set_number('0908580')->is_valid_number, '株式会社 ノースウインド');
ok($zip->set_number('0908585')->is_valid_number, '北見社会保険事務所');
ok($zip->set_number('0908588')->is_valid_number, '北海道森林管理局 北見事務所');
ok($zip->set_number('0908610')->is_valid_number, '有限会社 勉強屋本部');
ok($zip->set_number('0908642')->is_valid_number, '北見藤女子高等学校');
ok($zip->set_number('0908650')->is_valid_number, '北見農業会館管理運営委員会');
ok($zip->set_number('0908652')->is_valid_number, '北見トヨペット (株)');
ok($zip->set_number('0908655')->is_valid_number, '北海道新聞 北見支社');
ok($zip->set_number('0908666')->is_valid_number, '総合病院 北見赤十字病院');
ok($zip->set_number('0908680')->is_valid_number, '(株) 帝国データバンク 北見支店');
ok($zip->set_number('0908710')->is_valid_number, '北見商工会議所');
ok($zip->set_number('0908711')->is_valid_number, '北見信用金庫');
ok($zip->set_number('0908722')->is_valid_number, '住友生命保険 相互会社 北見支店');
ok($zip->set_number('0908723')->is_valid_number, '北見日産自動車 株式会社');
ok($zip->set_number('0908729')->is_valid_number, '(株) 日専連ニックコーポレーション');
ok($zip->set_number('0910192')->is_valid_number, 'きたみらい農業協同組合 温根湯支所');
ok($zip->set_number('0910193')->is_valid_number, '(株) 大江本家');
ok($zip->set_number('0910194')->is_valid_number, 'オホーツク観光 (株) 温根湯ホテル');
ok($zip->set_number('0918666')->is_valid_number, '北見市役所 留辺蘂総合支所');
ok($zip->set_number('0920292')->is_valid_number, '津別町役場');
ok($zip->set_number('0928501')->is_valid_number, '陸上自衛隊 美幌駐屯地');
ok($zip->set_number('0928650')->is_valid_number, '美幌町役場');
ok($zip->set_number('0928651')->is_valid_number, '美幌町農業協同組合');
ok($zip->set_number('0930292')->is_valid_number, '北見市役所 常呂総合支所');
ok($zip->set_number('0930592')->is_valid_number, '佐呂間町役場');
ok($zip->set_number('0930593')->is_valid_number, '佐呂間町農業協同組合');
ok($zip->set_number('0930594')->is_valid_number, '佐呂間漁業協同組合');
ok($zip->set_number('0938544')->is_valid_number, '北海道開発局 網走開発建設部');
ok($zip->set_number('0938555')->is_valid_number, '網走市役所');
ok($zip->set_number('0938585')->is_valid_number, '北海道網走支庁');
ok($zip->set_number('0938609')->is_valid_number, '網走公共職業安定所');
ok($zip->set_number('0938619')->is_valid_number, '北海道教育庁網走教育局');
ok($zip->set_number('0938650')->is_valid_number, '網走信用金庫 本店');
ok($zip->set_number('0938670')->is_valid_number, '北海道 網走土木現業所');
ok($zip->set_number('0938680')->is_valid_number, '(株) 北洋銀行 網走支店');
ok($zip->set_number('0938686')->is_valid_number, '釧路信用組合 網走支店');
ok($zip->set_number('0938710')->is_valid_number, '(株) 光和');
ok($zip->set_number('0938711')->is_valid_number, '島田建設 (株)');
ok($zip->set_number('0938728')->is_valid_number, 'オホーツク網走農業協同組合');
ok($zip->set_number('0948551')->is_valid_number, 'みゆき観光開発 株式会社');
ok($zip->set_number('0948552')->is_valid_number, '有限会社 紋別旅行');
ok($zip->set_number('0948553')->is_valid_number, '北方建設産業 株式会社');
ok($zip->set_number('0948554')->is_valid_number, '網走支庁 紋別道税事務所');
ok($zip->set_number('0948581')->is_valid_number, '北海道紋別北高等学校');
ok($zip->set_number('0948601')->is_valid_number, '紋別漁業協同組合');
ok($zip->set_number('0948602')->is_valid_number, '北海道信用漁業協同組合連合会 北見支部');
ok($zip->set_number('0948603')->is_valid_number, '株式会社 流氷のふるさと');
ok($zip->set_number('0948604')->is_valid_number, '株式会社 オホーツク観光物産');
ok($zip->set_number('0948605')->is_valid_number, '北海道信用漁業協同組合連合会');
ok($zip->set_number('0948609')->is_valid_number, '紋別公共職業安定所');
ok($zip->set_number('0948641')->is_valid_number, '紋別警察署');
ok($zip->set_number('0948642')->is_valid_number, '北海道 紋別保健所');
ok($zip->set_number('0948643')->is_valid_number, '北海道紋別南高等学校');
ok($zip->set_number('0948644')->is_valid_number, 'マルカイチ水産 株式会社');
ok($zip->set_number('0948645')->is_valid_number, '株式会社 マイカル北海道 紋別店');
ok($zip->set_number('0948646')->is_valid_number, '北海道立 紋別高等看護学院');
ok($zip->set_number('0948701')->is_valid_number, '紋別商工会議所');
ok($zip->set_number('0948702')->is_valid_number, '株式会社 丸三 岩倉商店');
ok($zip->set_number('0948703')->is_valid_number, '(株) 北洋銀行 紋別中央支店');
ok($zip->set_number('0948704')->is_valid_number, '大安サービス 株式会社');
ok($zip->set_number('0948705')->is_valid_number, '株式会社 三幸');
ok($zip->set_number('0948706')->is_valid_number, '紋別信用金庫');
ok($zip->set_number('0948707')->is_valid_number, '紋別市役所');
ok($zip->set_number('0948708')->is_valid_number, '東海倉庫 株式会社');
ok($zip->set_number('0948709')->is_valid_number, '広域紋別病院企業団');
ok($zip->set_number('0948710')->is_valid_number, '紋別市農業協同組合');
ok($zip->set_number('0948712')->is_valid_number, '株式会社 民友商事');
ok($zip->set_number('0948713')->is_valid_number, '株式会社 北海道銀行 紋別支店');
ok($zip->set_number('0948714')->is_valid_number, '大原病院');
ok($zip->set_number('0948715')->is_valid_number, '株式会社 西村組 紋別支店');
ok($zip->set_number('0948716')->is_valid_number, '紋別医師会');
ok($zip->set_number('0948717')->is_valid_number, '株式会社 藤川水産');
ok($zip->set_number('0950492')->is_valid_number, '士別市 朝日総合支所');
ok($zip->set_number('0958609')->is_valid_number, '名寄公共職業安定所 士別出張所');
ok($zip->set_number('0958686')->is_valid_number, '士別市役所');
ok($zip->set_number('0968501')->is_valid_number, '株式会社 西條');
ok($zip->set_number('0968508')->is_valid_number, '株式会社 西厚商事');
ok($zip->set_number('0968511')->is_valid_number, '名寄市立総合病院');
ok($zip->set_number('0968555')->is_valid_number, '北陽製紙 (株)');
ok($zip->set_number('0968558')->is_valid_number, '(株) 西條本部');
ok($zip->set_number('0968584')->is_valid_number, '陸上自衛隊 名寄駐屯地');
ok($zip->set_number('0968585')->is_valid_number, '吉田病院');
ok($zip->set_number('0968609')->is_valid_number, '名寄公共職業安定所');
ok($zip->set_number('0968641')->is_valid_number, '市立名寄短期大学');
ok($zip->set_number('0968666')->is_valid_number, '名寄信用金庫');
ok($zip->set_number('0968686')->is_valid_number, '名寄市役所');
ok($zip->set_number('0978510')->is_valid_number, '稚内社会保険事務所');
ok($zip->set_number('0978525')->is_valid_number, '北海道 稚内保健所');
ok($zip->set_number('0978527')->is_valid_number, '稚内開発建設部');
ok($zip->set_number('0978555')->is_valid_number, '市立稚内病院');
ok($zip->set_number('0978558')->is_valid_number, '北海道 宗谷支庁');
ok($zip->set_number('0978585')->is_valid_number, '稚内土木現業所');
ok($zip->set_number('0978609')->is_valid_number, '稚内公共職業安定所');
ok($zip->set_number('0978639')->is_valid_number, '北海道教育庁 宗谷教育局');
ok($zip->set_number('0978666')->is_valid_number, '稚内信用金庫 本店');
ok($zip->set_number('0978686')->is_valid_number, '稚内市役所');
ok($zip->set_number('0980192')->is_valid_number, '和寒町役場');
ok($zip->set_number('0980392')->is_valid_number, '剣淵町役場');
ok($zip->set_number('0981692')->is_valid_number, '興部町役場');
ok($zip->set_number('0981693')->is_valid_number, '興部町農業協同組合');
ok($zip->set_number('0981792')->is_valid_number, '雄武町役場');
ok($zip->set_number('0982892')->is_valid_number, '中川町役場');
ok($zip->set_number('0983392')->is_valid_number, '留萌北部森林管理署');
ok($zip->set_number('0983393')->is_valid_number, '北海道天塩高等学校');
ok($zip->set_number('0983395')->is_valid_number, '天塩町農業協同組合');
ok($zip->set_number('0983396')->is_valid_number, '留萌保健福祉事務所 天塩支所');
ok($zip->set_number('0983398')->is_valid_number, '天塩町役場');
ok($zip->set_number('0985298')->is_valid_number, '枝幸町役場 歌登総合支所');
ok($zip->set_number('0985595')->is_valid_number, '中頓別町役場');
ok($zip->set_number('0985792')->is_valid_number, '浜頓別町役場');
ok($zip->set_number('0985892')->is_valid_number, '枝幸町役場');
ok($zip->set_number('0986292')->is_valid_number, '猿払村役場');
ok($zip->set_number('0990492')->is_valid_number, '遠軽町役場');
ok($zip->set_number('0990494')->is_valid_number, '遠軽厚生病院');
ok($zip->set_number('0990495')->is_valid_number, '遠軽信用金庫');
ok($zip->set_number('0991197')->is_valid_number, 'きたみらい農業協同組合 置戸支所');
ok($zip->set_number('0991198')->is_valid_number, '置戸町役場');
ok($zip->set_number('0991492')->is_valid_number, 'きたみらい農業協同組合 訓子府支所');
ok($zip->set_number('0991495')->is_valid_number, '北海道クノール食品 (株)');
ok($zip->set_number('0991496')->is_valid_number, '北海道北見農業試験場');
ok($zip->set_number('0991498')->is_valid_number, '訓子府町役場');
ok($zip->set_number('0991595')->is_valid_number, '京セラ 株式会社 北海道北見工場');
ok($zip->set_number('0992192')->is_valid_number, '北見市役所 端野総合支所');
ok($zip->set_number('0992193')->is_valid_number, 'きたみらい農業協同組合 端野支所');
ok($zip->set_number('0992194')->is_valid_number, '北見市教育委員会');
ok($zip->set_number('0992195')->is_valid_number, '東武端野店');
ok($zip->set_number('0992196')->is_valid_number, 'オホーツク観光 株式会社');
ok($zip->set_number('0992197')->is_valid_number, '網走水産 株式会社');
ok($zip->set_number('0992198')->is_valid_number, '北海道北見商業高等学校');
ok($zip->set_number('0992392')->is_valid_number, '大空町役場');
ok($zip->set_number('0992492')->is_valid_number, '道東観光開発 株式会社');
ok($zip->set_number('0992493')->is_valid_number, '東京農業大学 生物産業学部');
ok($zip->set_number('0992495')->is_valid_number, '株式会社 ホテルビューパーク');
ok($zip->set_number('0993292')->is_valid_number, '東藻琴村農業協同組合');
ok($zip->set_number('0993293')->is_valid_number, '大空町 東藻琴総合支所');
ok($zip->set_number('0993697')->is_valid_number, '小清水町農業協同組合');
ok($zip->set_number('0993698')->is_valid_number, '小清水町役場');
ok($zip->set_number('0994192')->is_valid_number, '斜里町役場');
ok($zip->set_number('0994195')->is_valid_number, '斜里町農業協同組合');
ok($zip->set_number('0994196')->is_valid_number, 'ホクレン農業協同組合連合会 中斜里製糖工場');
ok($zip->set_number('0994492')->is_valid_number, '清里町役場');
ok($zip->set_number('0995692')->is_valid_number, '滝上町役場');
ok($zip->set_number('0996592')->is_valid_number, '湧別町役場');
ok($zip->set_number('1001492')->is_valid_number, '東京都八丈支庁');
ok($zip->set_number('1001498')->is_valid_number, '八丈町役場');
ok($zip->set_number('1003131')->is_valid_number, '東京税関 東京外郵出張所');
ok($zip->set_number('1006066')->is_valid_number, '森六 株式会社');
ok($zip->set_number('1006080')->is_valid_number, '伊藤忠テクノソリューションズ 株式会社');
ok($zip->set_number('1006150')->is_valid_number, '株式会社 エヌ・ティ・ティ・ドコモ');
ok($zip->set_number('1006151')->is_valid_number, '株式会社 ユーズパートナーサービス');
ok($zip->set_number('1006152')->is_valid_number, 'U\'s音楽出版 株式会社');
ok($zip->set_number('1006162')->is_valid_number, 'ディ・エグゼクティブ・センター・ジャパン 株式会社');
ok($zip->set_number('1006170')->is_valid_number, 'ドイチェ・バンク 東京支店');
ok($zip->set_number('1006171')->is_valid_number, 'ドイチェ証券会社 東京支店');
ok($zip->set_number('1006172')->is_valid_number, 'ドイチェ信託銀行 株式会社');
ok($zip->set_number('1006173')->is_valid_number, 'ドイチェ・アセット・マネジメント 株式会社');
ok($zip->set_number('1006174')->is_valid_number, 'ドイツ・リアルエステイト・コンサルティング 有限会社');
ok($zip->set_number('1006175')->is_valid_number, 'ドイツ銀キャピタル・パートナーズ 株式会社');
ok($zip->set_number('1006177')->is_valid_number, '消費者委員会');
ok($zip->set_number('1006178')->is_valid_number, '消費者庁');
ok($zip->set_number('1006255')->is_valid_number, 'エヌエスパーソネルサービス 株式会社');
ok($zip->set_number('1006260')->is_valid_number, '株式会社 クラスト');
ok($zip->set_number('1006262')->is_valid_number, 'メールボックス・エトセトラ 東京駅店');
ok($zip->set_number('1006277')->is_valid_number, 'フォーシーズンズホテル丸の内 東京');
ok($zip->set_number('1006751')->is_valid_number, '株式会社 大和証券グループ 本社');
ok($zip->set_number('1006752')->is_valid_number, '大和証券 株式会社');
ok($zip->set_number('1006753')->is_valid_number, '大和証券キャピタル・マーケッツ 株式会社');
ok($zip->set_number('1006754')->is_valid_number, '大和証券エスエムビーシープリンシパル・インベストメンツ 株式会社');
ok($zip->set_number('1006755')->is_valid_number, '大和証券 株式会社 本店');
ok($zip->set_number('1006756')->is_valid_number, '株式会社 大和ネクスト銀行');
ok($zip->set_number('1008019')->is_valid_number, 'エヌ・ティ・ティ・コミュニケーションズ 株式会社');
ok($zip->set_number('1008050')->is_valid_number, '東京海上日動火災保険 株式会社');
ok($zip->set_number('1008051')->is_valid_number, '株式会社 毎日新聞社 東京本社');
ok($zip->set_number('1008066')->is_valid_number, '株式会社 日本経済新聞社');
ok($zip->set_number('1008070')->is_valid_number, '川鉄商事 株式会社 (カワショウ)');
ok($zip->set_number('1008077')->is_valid_number, '株式会社 産業経済新聞社');
ok($zip->set_number('1008078')->is_valid_number, '株式会社 産業経済新聞社');
ok($zip->set_number('1008079')->is_valid_number, '株式会社 産業経済新聞社');
ok($zip->set_number('1008086')->is_valid_number, '三菱商事 株式会社');
ok($zip->set_number('1008088')->is_valid_number, '丸紅 株式会社');
ok($zip->set_number('1008102')->is_valid_number, '東京国税局');
ok($zip->set_number('1008103')->is_valid_number, '朝日生命保険 相互会社');
ok($zip->set_number('1008105')->is_valid_number, 'チッソ 株式会社');
ok($zip->set_number('1008108')->is_valid_number, 'NSユナイテッド海運 株式会社');
ok($zip->set_number('1008110')->is_valid_number, '株式会社 産経デジタル');
ok($zip->set_number('1008111')->is_valid_number, '宮内庁');
ok($zip->set_number('1008113')->is_valid_number, '三菱地所リアルエステートサービス 株式会社');
ok($zip->set_number('1008115')->is_valid_number, '株式会社 クラレ');
ok($zip->set_number('1008117')->is_valid_number, '三菱マテリアル 株式会社');
ok($zip->set_number('1008118')->is_valid_number, '電気事業連合会');
ok($zip->set_number('1008119')->is_valid_number, '東京消防庁');
ok($zip->set_number('1008120')->is_valid_number, '農林中央金庫');
ok($zip->set_number('1008121')->is_valid_number, '日立造船 株式会社 東京支社');
ok($zip->set_number('1008122')->is_valid_number, '気象庁');
ok($zip->set_number('1008123')->is_valid_number, '三井生命保険 株式会社');
ok($zip->set_number('1008125')->is_valid_number, '株式会社 日本工業新聞社');
ok($zip->set_number('1008126')->is_valid_number, '財団法人 電力中央研究所');
ok($zip->set_number('1008128')->is_valid_number, 'NTTコミュニケーションズ 株式会社');
ok($zip->set_number('1008130')->is_valid_number, '野村證券 株式会社');
ok($zip->set_number('1008131')->is_valid_number, '株式会社 HS情報システムズ');
ok($zip->set_number('1008135')->is_valid_number, '財団法人 国語作文教育研究所');
ok($zip->set_number('1008138')->is_valid_number, 'UFJつばさ証券 株式会社');
ok($zip->set_number('1008139')->is_valid_number, '財団法人 逓信協会');
ok($zip->set_number('1008140')->is_valid_number, '株式会社 産業経済新聞社サンケイスポーツ');
ok($zip->set_number('1008141')->is_valid_number, '株式会社 三菱総合研究所');
ok($zip->set_number('1008144')->is_valid_number, '株式会社 日本政策金融公庫 国際協力銀行');
ok($zip->set_number('1008149')->is_valid_number, '社団法人 在家佛教協会');
ok($zip->set_number('1008150')->is_valid_number, 'ウシオ電機 株式会社');
ok($zip->set_number('1008151')->is_valid_number, '株式会社 読売巨人軍');
ok($zip->set_number('1008156')->is_valid_number, '日本製紙クレシア 株式会社');
ok($zip->set_number('1008157')->is_valid_number, '日本製紙木材 株式会社');
ok($zip->set_number('1008158')->is_valid_number, '日本紙通商 株式会社');
ok($zip->set_number('1008160')->is_valid_number, '株式会社 産業経済新聞社夕刊フジ');
ok($zip->set_number('1008161')->is_valid_number, 'JXホールディングス 株式会社');
ok($zip->set_number('1008162')->is_valid_number, 'JX日鉱日石エネルギー 株式会社');
ok($zip->set_number('1008163')->is_valid_number, 'JX日鉱日石開発 株式会社');
ok($zip->set_number('1008164')->is_valid_number, 'JX日鉱日石金属 株式会社');
ok($zip->set_number('1008165')->is_valid_number, '日本曹達 株式会社');
ok($zip->set_number('1008166')->is_valid_number, '日立電線 株式会社');
ok($zip->set_number('1008167')->is_valid_number, '新日石ビジネスサービス 株式会社');
ok($zip->set_number('1008168')->is_valid_number, '新日石トレーディング 株式会社');
ok($zip->set_number('1008169')->is_valid_number, '新日石プラスト 株式会社');
ok($zip->set_number('1008171')->is_valid_number, '社団法人 日本民営鉄道協会');
ok($zip->set_number('1008172')->is_valid_number, 'あずさ監査法人');
ok($zip->set_number('1008173')->is_valid_number, '新日石不動産 株式会社');
ok($zip->set_number('1008177')->is_valid_number, '伊藤忠丸紅鉄鋼 株式会社');
ok($zip->set_number('1008180')->is_valid_number, 'メリルリンチ証券会社 東京支店');
ok($zip->set_number('1008181')->is_valid_number, '株式会社 ユーエフジェイカード');
ok($zip->set_number('1008182')->is_valid_number, '石川島播磨重工業 株式会社');
ok($zip->set_number('1008185')->is_valid_number, '協和発酵工業 株式会社');
ok($zip->set_number('1008186')->is_valid_number, '国際電信電話 株式会社 営業本部');
ok($zip->set_number('1008187')->is_valid_number, '一般社団法人 日本経団連事業サービス');
ok($zip->set_number('1008188')->is_valid_number, '社団法人 日本経済団体連合会');
ok($zip->set_number('1008189')->is_valid_number, '三菱地所レジデンス 株式会社');
ok($zip->set_number('1008201')->is_valid_number, '株式会社 三井住友銀行');
ok($zip->set_number('1008203')->is_valid_number, '丸善 丸の内本店');
ok($zip->set_number('1008210')->is_valid_number, '株式会社 みずほコーポレート銀行');
ok($zip->set_number('1008211')->is_valid_number, 'バイエルマテリアルサイエンス 株式会社');
ok($zip->set_number('1008214')->is_valid_number, 'UFJ信託銀行 株式会社');
ok($zip->set_number('1008215')->is_valid_number, 'ランクセス 株式会社');
ok($zip->set_number('1008216')->is_valid_number, '一般社団法人 全国銀行協会');
ok($zip->set_number('1008219')->is_valid_number, 'ニッセイアセットマネジメント 株式会社');
ok($zip->set_number('1008227')->is_valid_number, '株式会社 メタルワン建材');
ok($zip->set_number('1008228')->is_valid_number, '株式会社 パソナ');
ok($zip->set_number('1008232')->is_valid_number, '住友信託銀行 株式会社');
ok($zip->set_number('1008233')->is_valid_number, '住友信託銀行 株式会社');
ok($zip->set_number('1008234')->is_valid_number, 'AIU保険会社');
ok($zip->set_number('1008246')->is_valid_number, '日本ゼオン 株式会社');
ok($zip->set_number('1008260')->is_valid_number, '宇宙航空研究開発機構');
ok($zip->set_number('1008262')->is_valid_number, 'バイエルクロップサイエンス 株式会社');
ok($zip->set_number('1008265')->is_valid_number, 'バイエル薬品 株式会社');
ok($zip->set_number('1008267')->is_valid_number, '住化バイエルウレタン 株式会社 東京支店');
ok($zip->set_number('1008268')->is_valid_number, 'バイエルホールディング 株式会社');
ok($zip->set_number('1008270')->is_valid_number, '住友林業 株式会社');
ok($zip->set_number('1008282')->is_valid_number, '同和鉱業 株式会社');
ok($zip->set_number('1008283')->is_valid_number, 'シャングリ・ラホテル東京');
ok($zip->set_number('1008285')->is_valid_number, '佐藤商事 株式会社');
ok($zip->set_number('1008288')->is_valid_number, '日本生命保険 相互会社');
ok($zip->set_number('1008302')->is_valid_number, '白銅 株式会社');
ok($zip->set_number('1008303')->is_valid_number, '三菱電線工業 株式会社');
ok($zip->set_number('1008307')->is_valid_number, 'アコム 株式会社');
ok($zip->set_number('1008308')->is_valid_number, '財団法人 日本品質保証機構');
ok($zip->set_number('1008310')->is_valid_number, '三菱電機 株式会社');
ok($zip->set_number('1008311')->is_valid_number, '明和産業 株式会社');
ok($zip->set_number('1008321')->is_valid_number, '出光興産 株式会社');
ok($zip->set_number('1008322')->is_valid_number, '古河電気工業 株式会社');
ok($zip->set_number('1008324')->is_valid_number, '三菱ガス化学 株式会社');
ok($zip->set_number('1008325')->is_valid_number, '日興コーディアル証券 株式会社');
ok($zip->set_number('1008331')->is_valid_number, '株式会社 ニコン');
ok($zip->set_number('1008333')->is_valid_number, '株式会社 みずほフィナンシャルグループ');
ok($zip->set_number('1008338')->is_valid_number, '三菱マテリアル 株式会社');
ok($zip->set_number('1008341')->is_valid_number, '日本電子計算機 株式会社');
ok($zip->set_number('1008345')->is_valid_number, '日本ロレックス 株式会社');
ok($zip->set_number('1008348')->is_valid_number, '三菱地所住宅販売 株式会社');
ok($zip->set_number('1008350')->is_valid_number, '三菱商事プラスチック 株式会社');
ok($zip->set_number('1008351')->is_valid_number, 'グリーンスタンプ 株式会社');
ok($zip->set_number('1008355')->is_valid_number, '中村合同特許法律事務所');
ok($zip->set_number('1008366')->is_valid_number, '日新製鋼 株式会社');
ok($zip->set_number('1008370')->is_valid_number, '古河機械金属 株式会社');
ok($zip->set_number('1008380')->is_valid_number, '東京商工会議所');
ok($zip->set_number('1008383')->is_valid_number, '新東亜交易 株式会社 本店 (SHINTOA CORPORATION)and(SHINTOA KOEKI KAISHA.LTD.)');
ok($zip->set_number('1008388')->is_valid_number, '株式会社 東京三菱銀行');
ok($zip->set_number('1008402')->is_valid_number, '財団法人 企業経営通信学院');
ok($zip->set_number('1008410')->is_valid_number, '休暇村東京センター');
ok($zip->set_number('1008411')->is_valid_number, '第一生命保険 相互会社');
ok($zip->set_number('1008415')->is_valid_number, '東宝 株式会社');
ok($zip->set_number('1008420')->is_valid_number, '農林中央金庫');
ok($zip->set_number('1008421')->is_valid_number, 'TOHOシネマズ 株式会社');
ok($zip->set_number('1008424')->is_valid_number, 'パーク24 株式会社');
ok($zip->set_number('1008427')->is_valid_number, '株式会社 関電工 中央支社');
ok($zip->set_number('1008430')->is_valid_number, '株式会社 サンケイリビング新聞社');
ok($zip->set_number('1008439')->is_valid_number, '株式会社 ニッポン放送');
ok($zip->set_number('1008440')->is_valid_number, '旭化成工業 株式会社');
ok($zip->set_number('1008444')->is_valid_number, '日本生命保険 相互会社');
ok($zip->set_number('1008448')->is_valid_number, '財団法人 企業経営通信学院');
ok($zip->set_number('1008456')->is_valid_number, '株式会社 日本製鋼所');
ok($zip->set_number('1008484')->is_valid_number, '三機工業 株式会社');
ok($zip->set_number('1008488')->is_valid_number, '株式会社 阪急百貨店 有楽町阪急');
ok($zip->set_number('1008503')->is_valid_number, '東芝機械 株式会社');
ok($zip->set_number('1008505')->is_valid_number, '中日新聞社 東京本社');
ok($zip->set_number('1008506')->is_valid_number, '飯野海運 株式会社');
ok($zip->set_number('1008507')->is_valid_number, '日比谷中日ビルディング');
ok($zip->set_number('1008511')->is_valid_number, '石油公団');
ok($zip->set_number('1008520')->is_valid_number, '富国生命保険 相互会社');
ok($zip->set_number('1008522')->is_valid_number, '東洋製罐 株式会社');
ok($zip->set_number('1008543')->is_valid_number, '社団法人 日本新聞協会');
ok($zip->set_number('1008550')->is_valid_number, '旭化成工業 株式会社');
ok($zip->set_number('1008555')->is_valid_number, 'ティ・アンド・ディ・フィナンシャル生命保険 株式会社');
ok($zip->set_number('1008558')->is_valid_number, '株式会社 帝國ホテル');
ok($zip->set_number('1008560')->is_valid_number, '東京電力 株式会社');
ok($zip->set_number('1008567')->is_valid_number, '九州石油 株式会社');
ok($zip->set_number('1008575')->is_valid_number, 'プラチナ・ギルド・インターナショナル 株式会社');
ok($zip->set_number('1008577')->is_valid_number, '日本原子力研究開発機構 東京事務所');
ok($zip->set_number('1008585')->is_valid_number, '帝人 株式会社 東京本社');
ok($zip->set_number('1008588')->is_valid_number, '株式会社 コスモスイニシア');
ok($zip->set_number('1008602')->is_valid_number, 'ユーシーカード 株式会社');
ok($zip->set_number('1008606')->is_valid_number, '株式会社 主婦と生活社');
ok($zip->set_number('1008608')->is_valid_number, '株式会社 マルハニチロ水産');
ok($zip->set_number('1008610')->is_valid_number, '株式会社 ディーエムエス');
ok($zip->set_number('1008615')->is_valid_number, '株式会社 トーハン');
ok($zip->set_number('1008617')->is_valid_number, '株式会社 デック');
ok($zip->set_number('1008620')->is_valid_number, '株式会社 トッパンコミュニケーションプロダクツ');
ok($zip->set_number('1008621')->is_valid_number, '株式会社 プランニングオフィス トライ・アングル');
ok($zip->set_number('1008629')->is_valid_number, '株式会社 サミット');
ok($zip->set_number('1008630')->is_valid_number, '日本銀行');
ok($zip->set_number('1008631')->is_valid_number, '三井物産 株式会社');
ok($zip->set_number('1008632')->is_valid_number, '株式会社 角川SSコミュニケーションズ');
ok($zip->set_number('1008639')->is_valid_number, '株式会社 メールハウス');
ok($zip->set_number('1008640')->is_valid_number, '東京セールス・プロデュース 株式会社');
ok($zip->set_number('1008644')->is_valid_number, '株式会社 産業経済新聞社');
ok($zip->set_number('1008649')->is_valid_number, '株式会社 産業経済新聞社');
ok($zip->set_number('1008655')->is_valid_number, 'セイコー ウオッチ 株式会社');
ok($zip->set_number('1008663')->is_valid_number, 'アイアンドエス・ビービーディオー');
ok($zip->set_number('1008665')->is_valid_number, '産業経済新聞社');
ok($zip->set_number('1008666')->is_valid_number, '株式会社 スポーツニッポン新聞社');
ok($zip->set_number('1008668')->is_valid_number, '株式会社 ザ・パブリックアフェアーズ');
ok($zip->set_number('1008670')->is_valid_number, '極東貿易 株式会社 本店');
ok($zip->set_number('1008676')->is_valid_number, '株式会社 興伸');
ok($zip->set_number('1008677')->is_valid_number, '株式会社 ベターサービス');
ok($zip->set_number('1008686')->is_valid_number, '日本水産 株式会社');
ok($zip->set_number('1008791')->is_valid_number, '共通事務センター');
ok($zip->set_number('1008795')->is_valid_number, '関東総合通信局');
ok($zip->set_number('1008798')->is_valid_number, '株式会社 ゆうちょ銀行');
ok($zip->set_number('1008798')->is_valid_number, '株式会社 かんぽ生命');
ok($zip->set_number('1008798')->is_valid_number, '日本郵政 株式会社');
ok($zip->set_number('1008798')->is_valid_number, '郵便局 株式会社');
ok($zip->set_number('1008798')->is_valid_number, '郵便事業 株式会社');
ok($zip->set_number('1008901')->is_valid_number, '経済産業省');
ok($zip->set_number('1008902')->is_valid_number, '経済産業省 調査統計部');
ok($zip->set_number('1008903')->is_valid_number, '東京地方検察庁');
ok($zip->set_number('1008904')->is_valid_number, '東京高等検察庁');
ok($zip->set_number('1008905')->is_valid_number, '公認会計士・監査審査会');
ok($zip->set_number('1008907')->is_valid_number, '水産庁');
ok($zip->set_number('1008909')->is_valid_number, '社会民主党全国連合');
ok($zip->set_number('1008910')->is_valid_number, '自由民主党本部');
ok($zip->set_number('1008912')->is_valid_number, '中小企業庁');
ok($zip->set_number('1008913')->is_valid_number, '人事院 事務総局');
ok($zip->set_number('1008914')->is_valid_number, '内閣府');
ok($zip->set_number('1008915')->is_valid_number, '特許庁');
ok($zip->set_number('1008916')->is_valid_number, '厚生労働省');
ok($zip->set_number('1008917')->is_valid_number, '財団法人 全国老人クラブ連合会');
ok($zip->set_number('1008918')->is_valid_number, '国土交通省');
ok($zip->set_number('1008919')->is_valid_number, '外務省');
ok($zip->set_number('1008920')->is_valid_number, '東京地方裁判所');
ok($zip->set_number('1008921')->is_valid_number, '独立行政法人 産業技術総合研究所');
ok($zip->set_number('1008922')->is_valid_number, '証券取引等監視委員会');
ok($zip->set_number('1008924')->is_valid_number, '国立国会図書館');
ok($zip->set_number('1008925')->is_valid_number, '財団法人 日本博物館協会');
ok($zip->set_number('1008926')->is_valid_number, '総務省');
ok($zip->set_number('1008927')->is_valid_number, '消防庁');
ok($zip->set_number('1008929')->is_valid_number, '警視庁');
ok($zip->set_number('1008930')->is_valid_number, '首都高速道路 株式会社');
ok($zip->set_number('1008931')->is_valid_number, '資源エネルギー庁');
ok($zip->set_number('1008933')->is_valid_number, '東京高等裁判所');
ok($zip->set_number('1008937')->is_valid_number, '日本金属工業 株式会社');
ok($zip->set_number('1008940')->is_valid_number, '財務省');
ok($zip->set_number('1008941')->is_valid_number, '会計検査院');
ok($zip->set_number('1008945')->is_valid_number, '社会保険庁');
ok($zip->set_number('1008950')->is_valid_number, '農林水産省');
ok($zip->set_number('1008951')->is_valid_number, '国立教育政策研究所');
ok($zip->set_number('1008952')->is_valid_number, '林野庁');
ok($zip->set_number('1008953')->is_valid_number, 'ジブラルタ生命保険 株式会社');
ok($zip->set_number('1008955')->is_valid_number, '社団法人 日本道路協会');
ok($zip->set_number('1008956')->is_valid_number, '東京家庭裁判所');
ok($zip->set_number('1008959')->is_valid_number, '文部科学省');
ok($zip->set_number('1008960')->is_valid_number, '衆議院');
ok($zip->set_number('1008961')->is_valid_number, '参議院');
ok($zip->set_number('1008962')->is_valid_number, '参議院議員会館');
ok($zip->set_number('1008965')->is_valid_number, '日本興亜損害保険 株式会社');
ok($zip->set_number('1008966')->is_valid_number, '株式会社 スター・チャンネル');
ok($zip->set_number('1008967')->is_valid_number, '金融庁');
ok($zip->set_number('1008968')->is_valid_number, '内閣官房');
ok($zip->set_number('1008969')->is_valid_number, '内閣府');
ok($zip->set_number('1008970')->is_valid_number, '内閣府');
ok($zip->set_number('1008971')->is_valid_number, '東京簡易裁判所');
ok($zip->set_number('1008972')->is_valid_number, '日本アジア投資 株式会社');
ok($zip->set_number('1008974')->is_valid_number, '警察庁');
ok($zip->set_number('1008975')->is_valid_number, '環境省');
ok($zip->set_number('1008977')->is_valid_number, '法務省');
ok($zip->set_number('1008978')->is_valid_number, '国税庁');
ok($zip->set_number('1008979')->is_valid_number, '日本道路公団');
ok($zip->set_number('1008980')->is_valid_number, '社会福祉法人 全国社会福祉協議会');
ok($zip->set_number('1008981')->is_valid_number, '衆議院第一議員会館');
ok($zip->set_number('1008982')->is_valid_number, '衆議院第二議員会館');
ok($zip->set_number('1008983')->is_valid_number, '株式会社 トクヤマ');
ok($zip->set_number('1008985')->is_valid_number, '年金資金運用基金');
ok($zip->set_number('1008986')->is_valid_number, '原子力・安全保安院');
ok($zip->set_number('1008987')->is_valid_number, '公正取引委員会 事務総局');
ok($zip->set_number('1008989')->is_valid_number, '内閣府 食品安全委員会');
ok($zip->set_number('1008994')->is_valid_number, '東京中央郵便局');
ok($zip->set_number('1008996')->is_valid_number, '株式会社 ゆうちょ銀行 本店(分室)');
ok($zip->set_number('1018001')->is_valid_number, '株式会社 小学館');
ok($zip->set_number('1018002')->is_valid_number, '株式会社 岩波書店');
ok($zip->set_number('1018011')->is_valid_number, '三井住友海上火災保険 株式会社');
ok($zip->set_number('1018050')->is_valid_number, '株式会社 集英社');
ok($zip->set_number('1018077')->is_valid_number, '株式会社 飛鳥新社');
ok($zip->set_number('1018101')->is_valid_number, '旭化成 株式会社');
ok($zip->set_number('1018201')->is_valid_number, '株式会社 インテージ');
ok($zip->set_number('1018202')->is_valid_number, '株式会社 アスクレップ');
ok($zip->set_number('1018203')->is_valid_number, '株式会社 インテージ・インタラクティブ');
ok($zip->set_number('1018204')->is_valid_number, '株式会社 インテージ・アソシエイツ');
ok($zip->set_number('1018301')->is_valid_number, '学校法人 明治大学');
ok($zip->set_number('1018302')->is_valid_number, '日立化成商事 株式会社');
ok($zip->set_number('1018305')->is_valid_number, '株式会社 メディアワークス');
ok($zip->set_number('1018307')->is_valid_number, '社団法人 日本化学会');
ok($zip->set_number('1018308')->is_valid_number, '日本大学 理工学部');
ok($zip->set_number('1018309')->is_valid_number, '駿河台日本大学病院');
ok($zip->set_number('1018310')->is_valid_number, '日本大学 歯学部');
ok($zip->set_number('1018311')->is_valid_number, '株式会社 キョーリン');
ok($zip->set_number('1018313')->is_valid_number, '学校法人 駿河台学園 駿台予備学校');
ok($zip->set_number('1018314')->is_valid_number, '富士ゼロックスオフィスサプライ 株式会社');
ok($zip->set_number('1018315')->is_valid_number, '労働金庫会館');
ok($zip->set_number('1018316')->is_valid_number, '株式会社 鴻池組 東京本店');
ok($zip->set_number('1018317')->is_valid_number, '協同リース 株式会社');
ok($zip->set_number('1018321')->is_valid_number, '高砂熱学工業 株式会社');
ok($zip->set_number('1018322')->is_valid_number, '丸紅エネルギー 株式会社');
ok($zip->set_number('1018323')->is_valid_number, '株式会社 日本経済広告社');
ok($zip->set_number('1018324')->is_valid_number, '中央大学 駿河台記念館');
ok($zip->set_number('1018325')->is_valid_number, '管工業健康保険組合');
ok($zip->set_number('1018326')->is_valid_number, '社団法人 東京都教職員互助会 三楽病院');
ok($zip->set_number('1018327')->is_valid_number, '東邦ホールディングス 株式会社');
ok($zip->set_number('1018328')->is_valid_number, '社団法人 東京都医師会');
ok($zip->set_number('1018331')->is_valid_number, '丸紅ガスエナジー 株式会社');
ok($zip->set_number('1018333')->is_valid_number, '財団法人 産業経理協会');
ok($zip->set_number('1018335')->is_valid_number, '株式会社 損保會舘');
ok($zip->set_number('1018345')->is_valid_number, '神田社会保険事務所');
ok($zip->set_number('1018346')->is_valid_number, '財団法人 日本眼科学会');
ok($zip->set_number('1018350')->is_valid_number, '東光電気工事 株式会社');
ok($zip->set_number('1018351')->is_valid_number, '学校法人 大原学園');
ok($zip->set_number('1018352')->is_valid_number, '大原簿記学校');
ok($zip->set_number('1018353')->is_valid_number, '大原法律専門学校');
ok($zip->set_number('1018354')->is_valid_number, '日本大学 通信教育部');
ok($zip->set_number('1018355')->is_valid_number, '株式会社 朝日出版社');
ok($zip->set_number('1018356')->is_valid_number, '(株) 銀英社');
ok($zip->set_number('1018358')->is_valid_number, '財団法人 日本書道教育学会');
ok($zip->set_number('1018359')->is_valid_number, '独立行政法人 日本貿易保険');
ok($zip->set_number('1018360')->is_valid_number, '日本大学 経済学部');
ok($zip->set_number('1018362')->is_valid_number, 'NECトーキン (株)');
ok($zip->set_number('1018363')->is_valid_number, '丸紅テレコム (株)');
ok($zip->set_number('1018365')->is_valid_number, '株式会社 桃園書房');
ok($zip->set_number('1018366')->is_valid_number, '鉄建建設 (株)');
ok($zip->set_number('1018370')->is_valid_number, '理研ビタミン 株式会社');
ok($zip->set_number('1018371')->is_valid_number, '株式会社 三省堂');
ok($zip->set_number('1018375')->is_valid_number, '日本大学 法学部');
ok($zip->set_number('1018378')->is_valid_number, '社団法人 全日本病院協会');
ok($zip->set_number('1018380')->is_valid_number, '芙蓉総合リース 株式会社');
ok($zip->set_number('1018381')->is_valid_number, '株式会社 ベースボール・マガジン社');
ok($zip->set_number('1018383')->is_valid_number, 'タック 株式会社');
ok($zip->set_number('1018385')->is_valid_number, '(社) 倫理研究所');
ok($zip->set_number('1018388')->is_valid_number, '株式会社 少年画報社');
ok($zip->set_number('1018405')->is_valid_number, '株式会社 二見書房');
ok($zip->set_number('1018407')->is_valid_number, '(株)日本文芸社');
ok($zip->set_number('1018408')->is_valid_number, '株式会社 つり人社');
ok($zip->set_number('1018409')->is_valid_number, '平和出版 株式会社');
ok($zip->set_number('1018410')->is_valid_number, '株式会社 シノテスト');
ok($zip->set_number('1018411')->is_valid_number, '図書印刷 株式会社');
ok($zip->set_number('1018412')->is_valid_number, '社会福祉法人 全国盲ろう者協会');
ok($zip->set_number('1018415')->is_valid_number, '株式会社 小学館集英社プロダクション');
ok($zip->set_number('1018416')->is_valid_number, '太平電業 株式会社');
ok($zip->set_number('1018418')->is_valid_number, '株式会社 ゼンリン');
ok($zip->set_number('1018419')->is_valid_number, '株式会社 二玄社');
ok($zip->set_number('1018421')->is_valid_number, '株式会社 じほう');
ok($zip->set_number('1018422')->is_valid_number, '郵船トラベル (株)');
ok($zip->set_number('1018425')->is_valid_number, '学校法人 専修大学');
ok($zip->set_number('1018430')->is_valid_number, '情報・システム研究機構 国立情報学研究所');
ok($zip->set_number('1018433')->is_valid_number, '学校法人 共立女子学園');
ok($zip->set_number('1018437')->is_valid_number, '共立女子大学');
ok($zip->set_number('1018439')->is_valid_number, '一橋大学 大学院 国際企業戦略研究科');
ok($zip->set_number('1018441')->is_valid_number, '日清製粉 株式会社');
ok($zip->set_number('1018443')->is_valid_number, 'みずほ情報総研 株式会社');
ok($zip->set_number('1018444')->is_valid_number, '大鵬薬品工業 株式会社');
ok($zip->set_number('1018445')->is_valid_number, 'イオンクレジットサービス (株)');
ok($zip->set_number('1018446')->is_valid_number, '菱栄 (株)');
ok($zip->set_number('1018447')->is_valid_number, '(株) ジーアンドシー');
ok($zip->set_number('1018448')->is_valid_number, '株式会社 島津製作所 東京支社');
ok($zip->set_number('1018449')->is_valid_number, '株式会社 ICSコンベンションデザイン');
ok($zip->set_number('1018450')->is_valid_number, '株式会社 シンコーミュージック・エンタテイメント');
ok($zip->set_number('1018451')->is_valid_number, '新生紙パルプ商事 株式会社');
ok($zip->set_number('1018452')->is_valid_number, '富士フイルムグラフィックシステムズ 株式会社');
ok($zip->set_number('1018453')->is_valid_number, '住商エレクトロニクス 株式会社');
ok($zip->set_number('1018454')->is_valid_number, '株式会社 バーン・コーポレーション');
ok($zip->set_number('1018456')->is_valid_number, '学校法人 正則学園');
ok($zip->set_number('1018457')->is_valid_number, '学校法人 東京電機大学');
ok($zip->set_number('1018458')->is_valid_number, '三井住友海上きらめき生命保険 株式会社');
ok($zip->set_number('1018459')->is_valid_number, '社団法人 学士会');
ok($zip->set_number('1018460')->is_valid_number, '株式会社 オーム社');
ok($zip->set_number('1018464')->is_valid_number, '神田税務署');
ok($zip->set_number('1018465')->is_valid_number, '株式会社 スミテックス');
ok($zip->set_number('1018466')->is_valid_number, '株式会社 大修館書店');
ok($zip->set_number('1018467')->is_valid_number, '株式会社 エス・エス・コミュニケーションズ');
ok($zip->set_number('1018468')->is_valid_number, 'ショーボンド建設 株式会社');
ok($zip->set_number('1018469')->is_valid_number, '株式会社 アンビット ニンドリ編集部');
ok($zip->set_number('1018470')->is_valid_number, '株式会社 ディーエムエス');
ok($zip->set_number('1018475')->is_valid_number, '株式会社 シンコーミュージック・エンタテイメント');
ok($zip->set_number('1018476')->is_valid_number, '(株) キッズステーション');
ok($zip->set_number('1018477')->is_valid_number, 'ミズノ 株式会社');
ok($zip->set_number('1018481')->is_valid_number, '旭化成ファーマ 株式会社');
ok($zip->set_number('1018483')->is_valid_number, 'ニチモ 株式会社');
ok($zip->set_number('1018501')->is_valid_number, '全国農業協同組合連合会全農東京支所');
ok($zip->set_number('1018502')->is_valid_number, '全農物流 株式会社');
ok($zip->set_number('1018503')->is_valid_number, '全国漁業 協同組合連合会');
ok($zip->set_number('1018504')->is_valid_number, 'オザックス 株式会社');
ok($zip->set_number('1018506')->is_valid_number, '農林漁業信用基金');
ok($zip->set_number('1018507')->is_valid_number, '農林中央金庫');
ok($zip->set_number('1018508')->is_valid_number, '全国森林組合連合会');
ok($zip->set_number('1018509')->is_valid_number, '(社) 全国地方銀行協会');
ok($zip->set_number('1018510')->is_valid_number, '協同クレジットサービス 株式会社');
ok($zip->set_number('1018511')->is_valid_number, '農林漁業団体職員共済組合');
ok($zip->set_number('1018512')->is_valid_number, 'アルフレッサ 株式会社');
ok($zip->set_number('1018514')->is_valid_number, 'マルゼン商事 (株)');
ok($zip->set_number('1018515')->is_valid_number, '東京ロイヤルプラザ 管理組合');
ok($zip->set_number('1018516')->is_valid_number, 'エムオーツーリスト 株式会社');
ok($zip->set_number('1018519')->is_valid_number, '株式会社 ラーニングネット');
ok($zip->set_number('1018520')->is_valid_number, '東京都千代田都税事務所');
ok($zip->set_number('1018521')->is_valid_number, '昭和産業 株式会社');
ok($zip->set_number('1018522')->is_valid_number, '株式会社 社会保険研究所');
ok($zip->set_number('1018523')->is_valid_number, '東京都水道局 千代田営業所');
ok($zip->set_number('1018525')->is_valid_number, '専門学校 神田外語学院(学校法人 佐野学園)');
ok($zip->set_number('1018526')->is_valid_number, '(株) アクティブ');
ok($zip->set_number('1018528')->is_valid_number, 'ピップ 株式会社');
ok($zip->set_number('1018530')->is_valid_number, '東亜商事 株式会社');
ok($zip->set_number('1018531')->is_valid_number, '有限会社 科学評論社');
ok($zip->set_number('1018532')->is_valid_number, 'NECインフロンティア 株式会社');
ok($zip->set_number('1018533')->is_valid_number, '東京都 小型コンピュータソフトウェア 産業健康保険組合 神田支部');
ok($zip->set_number('1018534')->is_valid_number, '社団法人 全国信用保証協会連合会');
ok($zip->set_number('1018535')->is_valid_number, '大塚製薬 株式会社');
ok($zip->set_number('1018542')->is_valid_number, 'フジパン (株) 関東事業部');
ok($zip->set_number('1018543')->is_valid_number, '(株) 樫村');
ok($zip->set_number('1018544')->is_valid_number, '社団法人 産業環境管理協会');
ok($zip->set_number('1018545')->is_valid_number, 'くめ・クオリティ・プロダクツ 株式会社');
ok($zip->set_number('1018552')->is_valid_number, '社団法人 ジャパンケネルクラブ');
ok($zip->set_number('1018558')->is_valid_number, '株式会社 イワキ');
ok($zip->set_number('1018559')->is_valid_number, '佐藤金属 株式会社');
ok($zip->set_number('1018560')->is_valid_number, '株式会社 近代映画社');
ok($zip->set_number('1018561')->is_valid_number, '株式会社 日本マンパワー');
ok($zip->set_number('1018562')->is_valid_number, '株式会社 東日本銀行 事務センター');
ok($zip->set_number('1018565')->is_valid_number, '株式会社 東日本銀行 神田支店');
ok($zip->set_number('1018566')->is_valid_number, '株式会社 ヤマヤコーポレーション');
ok($zip->set_number('1018568')->is_valid_number, '株式会社 コクゴ');
ok($zip->set_number('1018576')->is_valid_number, '株式会社 日本法令');
ok($zip->set_number('1018577')->is_valid_number, '(株) タジマ');
ok($zip->set_number('1018578')->is_valid_number, '持田商工 (株)');
ok($zip->set_number('1018579')->is_valid_number, '田島ルーフィング (株)');
ok($zip->set_number('1018581')->is_valid_number, '(財) ポスタルサービスセンター');
ok($zip->set_number('1018585')->is_valid_number, '山崎製パン 株式会社');
ok($zip->set_number('1018586')->is_valid_number, '貝印 株式会社');
ok($zip->set_number('1018588')->is_valid_number, '株式会社 白石');
ok($zip->set_number('1018605')->is_valid_number, '橋本産業 (株)');
ok($zip->set_number('1018606')->is_valid_number, 'フマキラー 株式会社');
ok($zip->set_number('1018607')->is_valid_number, '三菱文具 株式会社');
ok($zip->set_number('1018609')->is_valid_number, 'ニチモコミュニティ 株式会社');
ok($zip->set_number('1018610')->is_valid_number, '株式会社 ソフマップ');
ok($zip->set_number('1018611')->is_valid_number, '社団法人 東京都交友会');
ok($zip->set_number('1018612')->is_valid_number, '(株) トランスネット');
ok($zip->set_number('1018613')->is_valid_number, '株式会社 農協観光');
ok($zip->set_number('1018614')->is_valid_number, '日本バイリーン 株式会社');
ok($zip->set_number('1018617')->is_valid_number, '同和鉱業 株式会社');
ok($zip->set_number('1018619')->is_valid_number, '株式会社 ダイドーリミテッド');
ok($zip->set_number('1018620')->is_valid_number, 'ヤマギワ 株式会社');
ok($zip->set_number('1018621')->is_valid_number, '(株) 共立メンテナンス');
ok($zip->set_number('1018622')->is_valid_number, '石丸電気 株式会社');
ok($zip->set_number('1018624')->is_valid_number, '株式会社 かんそうしん');
ok($zip->set_number('1018625')->is_valid_number, '富士電機リテイルシステムズ 株式会社');
ok($zip->set_number('1018626')->is_valid_number, 'ヤマキ 株式会社 東京支店');
ok($zip->set_number('1018627')->is_valid_number, '加賀電子 株式会社 特機事業本部他');
ok($zip->set_number('1018628')->is_valid_number, '加賀電子 株式会社 電子事業本部他');
ok($zip->set_number('1018629')->is_valid_number, '加賀電子 株式会社 管理本部他');
ok($zip->set_number('1018630')->is_valid_number, '東浴 信用組合');
ok($zip->set_number('1018633')->is_valid_number, 'スガツネ工業 株式会社');
ok($zip->set_number('1018634')->is_valid_number, 'ビー・アップル 株式会社');
ok($zip->set_number('1018636')->is_valid_number, '株式会社 スズケン');
ok($zip->set_number('1018637')->is_valid_number, '三菱UFJファクター 株式会社');
ok($zip->set_number('1018638')->is_valid_number, '株式会社 日本医療事務センター');
ok($zip->set_number('1018641')->is_valid_number, '近畿日本ツーリスト 株式会社');
ok($zip->set_number('1018642')->is_valid_number, 'YKK 株式会社');
ok($zip->set_number('1018643')->is_valid_number, '社会福祉法人 三井記念病院');
ok($zip->set_number('1018645')->is_valid_number, 'キリンビバレッジ 株式会社');
ok($zip->set_number('1018646')->is_valid_number, '鶴岡 株式会社');
ok($zip->set_number('1018648')->is_valid_number, '株式会社 薬事日報社');
ok($zip->set_number('1018651')->is_valid_number, '丸高興業 株式会社');
ok($zip->set_number('1018654')->is_valid_number, '石福金属興業 株式会社');
ok($zip->set_number('1018655')->is_valid_number, '朝日火災海上保険 株式会社');
ok($zip->set_number('1018656')->is_valid_number, '小学館プロダクション');
ok($zip->set_number('1018662')->is_valid_number, '(株) 西村書店');
ok($zip->set_number('1018665')->is_valid_number, '株式会社 ディック');
ok($zip->set_number('1018667')->is_valid_number, '株式会社 ディック');
ok($zip->set_number('1018668')->is_valid_number, '株式会社 主婦の友社');
ok($zip->set_number('1018670')->is_valid_number, '東京セールスプロデュース 株式会社');
ok($zip->set_number('1018672')->is_valid_number, '(株) 極東書店');
ok($zip->set_number('1018676')->is_valid_number, '(株) 武蔵野銀行 東京支店');
ok($zip->set_number('1018682')->is_valid_number, '三洋貿易 (株)');
ok($zip->set_number('1018688')->is_valid_number, '(株) ニチイ学館');
ok($zip->set_number('1018701')->is_valid_number, '株式会社 祥伝社');
ok($zip->set_number('1018703')->is_valid_number, 'トーア再保険 株式会社');
ok($zip->set_number('1018707')->is_valid_number, '(株) 日本パーソナルセンター');
ok($zip->set_number('1018710')->is_valid_number, '日本出版販売 (株)');
ok($zip->set_number('1018711')->is_valid_number, '(株) 白泉社');
ok($zip->set_number('1018712')->is_valid_number, '神田物産 (株)');
ok($zip->set_number('1018715')->is_valid_number, '全日本書芸文化院');
ok($zip->set_number('1018716')->is_valid_number, '株式会社 主婦と生活社');
ok($zip->set_number('1018717')->is_valid_number, '明治乳業 株式会社');
ok($zip->set_number('1018718')->is_valid_number, '株式会社 日本醫事新報社');
ok($zip->set_number('1018901')->is_valid_number, '株式会社 日本マンパワー内かんぽLC事務局');
ok($zip->set_number('1018911')->is_valid_number, '主婦の友社');
ok($zip->set_number('1018935')->is_valid_number, '(株) 新声社');
ok($zip->set_number('1018941')->is_valid_number, '株式会社 日立ビルシステム');
ok($zip->set_number('1018946')->is_valid_number, 'ニッポンレンタカーアーバンネット 株式会社 東京ディビジョン');
ok($zip->set_number('1018950')->is_valid_number, '大建工業 株式会社');
ok($zip->set_number('1018970')->is_valid_number, '古河スカイ 株式会社');
ok($zip->set_number('1018971')->is_valid_number, '日立電線 (株)');
ok($zip->set_number('1018972')->is_valid_number, '株式会社 ミツウロコ');
ok($zip->set_number('1018973')->is_valid_number, '株式会社 アクセル');
ok($zip->set_number('1018977')->is_valid_number, 'グローリー 株式会社 東京本部');
ok($zip->set_number('1018980')->is_valid_number, '株式会社 日立国際電気');
ok($zip->set_number('1018983')->is_valid_number, '財団法人 母子衛生研究会');
ok($zip->set_number('1018986')->is_valid_number, '一般財団法人 日本建築センター');
ok($zip->set_number('1018991')->is_valid_number, '(株) 亜土電子工業');
ok($zip->set_number('1028008')->is_valid_number, '株式会社 文藝春秋');
ok($zip->set_number('1028011')->is_valid_number, '財団法人 JKA');
ok($zip->set_number('1028012')->is_valid_number, '独立行政法人 国際協力機構');
ok($zip->set_number('1028015')->is_valid_number, 'プルデンシャルファイナンシャルジャパン生命保険 株式会社');
ok($zip->set_number('1028016')->is_valid_number, '全国健康保険協会 船員保険部');
ok($zip->set_number('1028018')->is_valid_number, 'ダイヤル・サービス 株式会社');
ok($zip->set_number('1028019')->is_valid_number, '株式会社 マッグガーデン');
ok($zip->set_number('1028077')->is_valid_number, '株式会社 角川クロスメディア');
ok($zip->set_number('1028080')->is_valid_number, '株式会社 エフエム東京');
ok($zip->set_number('1028081')->is_valid_number, '国家公務員 共済組合連合会 (連合会代表)');
ok($zip->set_number('1028082')->is_valid_number, '国家公務員 共済組合連合会 (年金部)');
ok($zip->set_number('1028083')->is_valid_number, '国家公務員 共済組合連合会 (旧令年金部)');
ok($zip->set_number('1028085')->is_valid_number, '中央労働基準監督署');
ok($zip->set_number('1028101')->is_valid_number, '株式会社 秋田書店');
ok($zip->set_number('1028102')->is_valid_number, '古久根建設 株式会社');
ok($zip->set_number('1028103')->is_valid_number, '株式会社 産業教育センター');
ok($zip->set_number('1028105')->is_valid_number, '日立キャピタル 株式会社');
ok($zip->set_number('1028109')->is_valid_number, '株式会社 アシスト');
ok($zip->set_number('1028110')->is_valid_number, '株式会社 潮出版社');
ok($zip->set_number('1028111')->is_valid_number, '昭和アルミニウム 株式会社');
ok($zip->set_number('1028112')->is_valid_number, '大和ハウス工業 株式会社');
ok($zip->set_number('1028117')->is_valid_number, '株式会社 日建設計');
ok($zip->set_number('1028118')->is_valid_number, '新村印刷 株式会社');
ok($zip->set_number('1028120')->is_valid_number, 'ゼネラルエレクトリックキャピタルカーシステム 株式会社');
ok($zip->set_number('1028122')->is_valid_number, '東亜販売 株式会社');
ok($zip->set_number('1028123')->is_valid_number, '日販アイ・ピー・エス 株式会社');
ok($zip->set_number('1028125')->is_valid_number, 'セントラル総合開発 株式会社');
ok($zip->set_number('1028128')->is_valid_number, 'アコム 株式会社');
ok($zip->set_number('1028130')->is_valid_number, '株式会社 ホテルエドモント');
ok($zip->set_number('1028131')->is_valid_number, 'トッパン・フォームズ 株式会社');
ok($zip->set_number('1028132')->is_valid_number, '法政大学 (保健体育部)');
ok($zip->set_number('1028138')->is_valid_number, '在日本朝鮮人総聯合会 中央本部 (朝鮮総聯中央本部)');
ok($zip->set_number('1028139')->is_valid_number, '株式会社 田中歯科器械店');
ok($zip->set_number('1028140')->is_valid_number, '三和電気工業 株式会社 営業本部');
ok($zip->set_number('1028141')->is_valid_number, '株式会社 IDGコミュニケーションズ');
ok($zip->set_number('1028142')->is_valid_number, '株式会社 鐵原');
ok($zip->set_number('1028144')->is_valid_number, '富士見書房');
ok($zip->set_number('1028150')->is_valid_number, 'アコム 株式会社');
ok($zip->set_number('1028151')->is_valid_number, '前田建設工業 株式会社');
ok($zip->set_number('1028152')->is_valid_number, '株式会社 研究社本社');
ok($zip->set_number('1028155')->is_valid_number, '株式会社 保健同人社');
ok($zip->set_number('1028160')->is_valid_number, '法政大学');
ok($zip->set_number('1028161')->is_valid_number, '東京警察病院');
ok($zip->set_number('1028166')->is_valid_number, '伊藤忠テクノソリューションズ 株式会社');
ok($zip->set_number('1028170')->is_valid_number, '高山工業 株式会社');
ok($zip->set_number('1028171')->is_valid_number, 'ピー・シー・エー 株式会社');
ok($zip->set_number('1028172')->is_valid_number, '日本化薬 株式会社');
ok($zip->set_number('1028175')->is_valid_number, 'ダイダン 株式会社 東京本社');
ok($zip->set_number('1028176')->is_valid_number, 'ミシュランタイヤグループ');
ok($zip->set_number('1028177')->is_valid_number, '株式会社 角川書店');
ok($zip->set_number('1028178')->is_valid_number, '学校法人 嘉悦学園');
ok($zip->set_number('1028180')->is_valid_number, '株式会社 くもん出版');
ok($zip->set_number('1028181')->is_valid_number, '株式会社 日刊工業新聞社');
ok($zip->set_number('1028182')->is_valid_number, '常盤工業 株式会社');
ok($zip->set_number('1028184')->is_valid_number, '社団法人 日本アイスクリーム協会');
ok($zip->set_number('1028185')->is_valid_number, '学校法人 白百合学園');
ok($zip->set_number('1028186')->is_valid_number, '株式会社 椿本チエイン 東京支社');
ok($zip->set_number('1028187')->is_valid_number, '株式会社 世界文化社');
ok($zip->set_number('1028188')->is_valid_number, '日本地所 株式会社');
ok($zip->set_number('1028201')->is_valid_number, '住宅・都市整備公団');
ok($zip->set_number('1028205')->is_valid_number, '株式会社 テクノ大手');
ok($zip->set_number('1028211')->is_valid_number, '株式会社 千修');
ok($zip->set_number('1028215')->is_valid_number, '前田建設工業 株式会社 関東支社・東京支店');
ok($zip->set_number('1028218')->is_valid_number, '日本中国語検定協会');
ok($zip->set_number('1028222')->is_valid_number, 'ニチレキ 株式会社');
ok($zip->set_number('1028225')->is_valid_number, '東京法務局');
ok($zip->set_number('1028226')->is_valid_number, '東京法務局');
ok($zip->set_number('1028228')->is_valid_number, '株式会社 カントー');
ok($zip->set_number('1028230')->is_valid_number, '株式会社 コーエーテクモゲームス');
ok($zip->set_number('1028231')->is_valid_number, '石垣食品 株式会社');
ok($zip->set_number('1028232')->is_valid_number, '株式会社 少年写真新聞社');
ok($zip->set_number('1028234')->is_valid_number, '社団法人 建設荷役車両安全技術協会');
ok($zip->set_number('1028236')->is_valid_number, 'ライト工業 株式会社');
ok($zip->set_number('1028238')->is_valid_number, '株式会社 昭文社');
ok($zip->set_number('1028240')->is_valid_number, '法政大学 就職部');
ok($zip->set_number('1028241')->is_valid_number, '社団法人 東京都歯科医師会');
ok($zip->set_number('1028246')->is_valid_number, '靖國神社');
ok($zip->set_number('1028250')->is_valid_number, '丸紅メタル 株式会社');
ok($zip->set_number('1028251')->is_valid_number, '日本大学大学院総合科学研究科');
ok($zip->set_number('1028255')->is_valid_number, '富士通 株式会社');
ok($zip->set_number('1028260')->is_valid_number, '株式会社 培風館');
ok($zip->set_number('1028262')->is_valid_number, '(株) デルフィス');
ok($zip->set_number('1028264')->is_valid_number, '日本公認会計士協会');
ok($zip->set_number('1028265')->is_valid_number, '東京乗用旅客自動車厚生年金基金');
ok($zip->set_number('1028272')->is_valid_number, '日本鉄鋼建材リース 株式会社');
ok($zip->set_number('1028275')->is_valid_number, '日本大学 本部');
ok($zip->set_number('1028277')->is_valid_number, '能美防災 株式会社');
ok($zip->set_number('1028288')->is_valid_number, '財団法人 東京顕微鏡院');
ok($zip->set_number('1028301')->is_valid_number, '株式会社 シティ出版');
ok($zip->set_number('1028302')->is_valid_number, '株式会社 角川書店');
ok($zip->set_number('1028303')->is_valid_number, '株式会社 プレゼントハウス');
ok($zip->set_number('1028305')->is_valid_number, '厚生労働省 東京労働局');
ok($zip->set_number('1028309')->is_valid_number, '厚生労働省 関東信越厚生局 麻薬取締部');
ok($zip->set_number('1028310')->is_valid_number, '朝日エティック 株式会社');
ok($zip->set_number('1028311')->is_valid_number, '麹町税務署');
ok($zip->set_number('1028313')->is_valid_number, '角川シネプレックス 株式会社');
ok($zip->set_number('1028314')->is_valid_number, '丸紅インフォテック 株式会社');
ok($zip->set_number('1028320')->is_valid_number, '株式会社 トヨタレンタリース東京');
ok($zip->set_number('1028321')->is_valid_number, '財団法人 日本武道館');
ok($zip->set_number('1028322')->is_valid_number, '東京国立近代美術館');
ok($zip->set_number('1028324')->is_valid_number, '株式会社 ライブリッジ');
ok($zip->set_number('1028331')->is_valid_number, '株式会社 PHP研究所');
ok($zip->set_number('1028332')->is_valid_number, '飛島建設 株式会社');
ok($zip->set_number('1028333')->is_valid_number, '三喜商事 株式会社');
ok($zip->set_number('1028335')->is_valid_number, '財団法人 大蔵財務協会');
ok($zip->set_number('1028336')->is_valid_number, '学校法人 二松学舎');
ok($zip->set_number('1028341')->is_valid_number, '学校法人 東京家政学院');
ok($zip->set_number('1028349')->is_valid_number, '(株) オークネット');
ok($zip->set_number('1028350')->is_valid_number, '株式会社 日新');
ok($zip->set_number('1028353')->is_valid_number, '(株) ソニー・ミュージックエンタテインメント');
ok($zip->set_number('1028355')->is_valid_number, '田辺製薬 株式会社 東京事業所');
ok($zip->set_number('1028356')->is_valid_number, '社団法人 第二地方銀行協会');
ok($zip->set_number('1028357')->is_valid_number, '学校法人 大妻学院 大妻女子大学 大妻女子大学短期大学部 大妻中学校 大妻高等学校');
ok($zip->set_number('1028362')->is_valid_number, '東工コーセン 株式会社');
ok($zip->set_number('1028364')->is_valid_number, '九段PFIサービス (株)');
ok($zip->set_number('1028368')->is_valid_number, '丸紅テレコム 株式会社');
ok($zip->set_number('1028370')->is_valid_number, '株式会社 伊勢半');
ok($zip->set_number('1028372')->is_valid_number, '株式会社 明光商会');
ok($zip->set_number('1028373')->is_valid_number, '冨士機材 (株)');
ok($zip->set_number('1028377')->is_valid_number, '実教出版 株式会社');
ok($zip->set_number('1028381')->is_valid_number, '英国大使館');
ok($zip->set_number('1028382')->is_valid_number, '東京硝子 株式会社');
ok($zip->set_number('1028383')->is_valid_number, 'コープケミカル 株式会社');
ok($zip->set_number('1028388')->is_valid_number, '株式会社 宝島社');
ok($zip->set_number('1028401')->is_valid_number, '株式会社 リビングプロシード');
ok($zip->set_number('1028402')->is_valid_number, 'フェデラルエクスプレスジャパン 株式会社');
ok($zip->set_number('1028405')->is_valid_number, '株式会社 ぶんか社');
ok($zip->set_number('1028406')->is_valid_number, '株式会社 ぶんか社 営業局');
ok($zip->set_number('1028407')->is_valid_number, '株式会社 ぶんか社 編集局');
ok($zip->set_number('1028410')->is_valid_number, '三進興産 株式会社');
ok($zip->set_number('1028411')->is_valid_number, '社団法人 全国農業共済協会');
ok($zip->set_number('1028414')->is_valid_number, '(社) 日本病院会');
ok($zip->set_number('1028415')->is_valid_number, '株式会社 セブン&アイ・フードシステムズ');
ok($zip->set_number('1028417')->is_valid_number, '株式会社 ヨークマート');
ok($zip->set_number('1028419')->is_valid_number, '財団法人 地方自治情報センター');
ok($zip->set_number('1028420')->is_valid_number, 'オーロラ 株式会社');
ok($zip->set_number('1028421')->is_valid_number, '電設工業 健康保険組合');
ok($zip->set_number('1028424')->is_valid_number, '大日本商事 (株)');
ok($zip->set_number('1028426')->is_valid_number, '株式会社 セブン・ミールサービス');
ok($zip->set_number('1028427')->is_valid_number, '株式会社 オッシュマンズ・ジャパン');
ok($zip->set_number('1028429')->is_valid_number, '株式会社 メリーアン');
ok($zip->set_number('1028430')->is_valid_number, '第一火災海上保険 相互会社');
ok($zip->set_number('1028431')->is_valid_number, '株式会社 エンターブレイン');
ok($zip->set_number('1028432')->is_valid_number, '株式会社 ヨークインシュアランス');
ok($zip->set_number('1028433')->is_valid_number, '株式会社 細川洋行');
ok($zip->set_number('1028435')->is_valid_number, '株式会社 セブン・フィナンシャルサービス');
ok($zip->set_number('1028437')->is_valid_number, '株式会社 アイワイ・カード・サービス');
ok($zip->set_number('1028438')->is_valid_number, '株式会社 セブン&アイ出版');
ok($zip->set_number('1028440')->is_valid_number, '株式会社 サンテック');
ok($zip->set_number('1028445')->is_valid_number, '法政大学 通信教育部');
ok($zip->set_number('1028447')->is_valid_number, '東洋鋼鈑 株式会社');
ok($zip->set_number('1028450')->is_valid_number, '(株) イトーヨーカ堂');
ok($zip->set_number('1028451')->is_valid_number, '東亜建設工業 株式会社');
ok($zip->set_number('1028452')->is_valid_number, '株式会社 セブン&アイ・ホールディングス');
ok($zip->set_number('1028455')->is_valid_number, '株式会社 セブン-イレブン・ジャパン');
ok($zip->set_number('1028456')->is_valid_number, '日本デリカフーズ協同組合');
ok($zip->set_number('1028459')->is_valid_number, '興研 株式会社');
ok($zip->set_number('1028460')->is_valid_number, 'KDDI 株式会社');
ok($zip->set_number('1028461')->is_valid_number, 'KDDI 株式会社');
ok($zip->set_number('1028462')->is_valid_number, 'KDDI 株式会社');
ok($zip->set_number('1028464')->is_valid_number, '全日本自治団体 労働組合');
ok($zip->set_number('1028465')->is_valid_number, '住友大阪セメント 株式会社');
ok($zip->set_number('1028466')->is_valid_number, '株式会社 セブンドリーム・ドットコム');
ok($zip->set_number('1028468')->is_valid_number, 'バクスター 株式会社');
ok($zip->set_number('1028470')->is_valid_number, '学校法人 雙葉学園');
ok($zip->set_number('1028474')->is_valid_number, '財団法人 河川情報センター');
ok($zip->set_number('1028477')->is_valid_number, 'プルデンシャル生命保険 株式会社');
ok($zip->set_number('1028478')->is_valid_number, 'クラフト 株式会社');
ok($zip->set_number('1028481')->is_valid_number, '株式会社 コングレ');
ok($zip->set_number('1028483')->is_valid_number, '三菱電機情報ネットワーク 株式会社');
ok($zip->set_number('1028484')->is_valid_number, 'トラベラー 株式会社');
ok($zip->set_number('1028488')->is_valid_number, '株式会社 スポーツマーケティングプロパティーズ');
ok($zip->set_number('1028489')->is_valid_number, '日東紡績 株式会社');
ok($zip->set_number('1028502')->is_valid_number, '財団法人 歯科医療研修振興財団');
ok($zip->set_number('1028503')->is_valid_number, '株式会社 オリエントコーポレーション');
ok($zip->set_number('1028504')->is_valid_number, '株式会社 オリエントコーポレーション 首都圏管理センター');
ok($zip->set_number('1028505')->is_valid_number, '全国建設厚生年金基金');
ok($zip->set_number('1028506')->is_valid_number, '株式会社 ワコール 東京支社');
ok($zip->set_number('1028508')->is_valid_number, '医療法人社団 こころとからだの元氣プラザ');
ok($zip->set_number('1028510')->is_valid_number, 'ジブラルタ生命保険 株式会社');
ok($zip->set_number('1028511')->is_valid_number, '株式会社 アダック');
ok($zip->set_number('1028515')->is_valid_number, '株式会社 サンケイリビング新聞社');
ok($zip->set_number('1028516')->is_valid_number, '松井証券 株式会社');
ok($zip->set_number('1028518')->is_valid_number, '日本アジア投資 株式会社');
ok($zip->set_number('1028520')->is_valid_number, '株式会社 ミカミ');
ok($zip->set_number('1028522')->is_valid_number, '株式会社 協同宣伝');
ok($zip->set_number('1028528')->is_valid_number, '株式会社 生産日本社');
ok($zip->set_number('1028529')->is_valid_number, '真柄建設 株式会社 東京支店');
ok($zip->set_number('1028530')->is_valid_number, 'サントリー 株式会社');
ok($zip->set_number('1028531')->is_valid_number, 'クレジット債権管理組合');
ok($zip->set_number('1028533')->is_valid_number, '株式会社 エスコム');
ok($zip->set_number('1028539')->is_valid_number, '日本工営 株式会社');
ok($zip->set_number('1028540')->is_valid_number, '株式会社 かんき出版');
ok($zip->set_number('1028541')->is_valid_number, '海洋水産資源開発センター');
ok($zip->set_number('1028543')->is_valid_number, '扶桑レクセル 株式会社');
ok($zip->set_number('1028550')->is_valid_number, '三菱伸銅 株式会社');
ok($zip->set_number('1028552')->is_valid_number, '株式会社 角川マーケティング');
ok($zip->set_number('1028554')->is_valid_number, '上智大学 (上智学院)');
ok($zip->set_number('1028555')->is_valid_number, '財団法人 新エネルギー財団');
ok($zip->set_number('1028556')->is_valid_number, '社団法人 全国自治体病院協議会');
ok($zip->set_number('1028557')->is_valid_number, 'MBE 紀尾井町店');
ok($zip->set_number('1028558')->is_valid_number, '株式会社 スタッフ・サービス 千代田支社');
ok($zip->set_number('1028559')->is_valid_number, '社団法人 日本文藝家協會');
ok($zip->set_number('1028560')->is_valid_number, 'ハウス食品 株式会社');
ok($zip->set_number('1028567')->is_valid_number, '財団法人 日本海事協会');
ok($zip->set_number('1028569')->is_valid_number, '株式会社 ニッポン放送プロジェクト');
ok($zip->set_number('1028570')->is_valid_number, 'ビーエーエスエフジャパン 株式会社');
ok($zip->set_number('1028571')->is_valid_number, 'SJハウス');
ok($zip->set_number('1028573')->is_valid_number, '株式会社 大塚商会');
ok($zip->set_number('1028575')->is_valid_number, '全国健康保険協会');
ok($zip->set_number('1028577')->is_valid_number, '社団法人 日本民間放送連盟');
ok($zip->set_number('1028578')->is_valid_number, '株式会社 ホテルニューオータニ');
ok($zip->set_number('1028580')->is_valid_number, '株式会社 インフィニトラベルインフォメーション');
ok($zip->set_number('1028584')->is_valid_number, '株式会社 アスキー・メディアワークス');
ok($zip->set_number('1028585')->is_valid_number, '赤坂プリンスホテル');
ok($zip->set_number('1028588')->is_valid_number, '警察共済組合 本部');
ok($zip->set_number('1028601')->is_valid_number, '地方職員 共済組合');
ok($zip->set_number('1028602')->is_valid_number, '株式会社 放送出版プロモーション');
ok($zip->set_number('1028603')->is_valid_number, '社団法人 日本船主協会');
ok($zip->set_number('1028604')->is_valid_number, '株式会社 放送出版エージェンシー');
ok($zip->set_number('1028607')->is_valid_number, '警察職員生活協同組合');
ok($zip->set_number('1028609')->is_valid_number, '株式会社 読売情報開発 読売ファミリー・サークル');
ok($zip->set_number('1028610')->is_valid_number, '生活協同組合全国都市職員災害共済会');
ok($zip->set_number('1028611')->is_valid_number, '株式会社 システム収納センター');
ok($zip->set_number('1028612')->is_valid_number, '株式会社 水中造形センター');
ok($zip->set_number('1028613')->is_valid_number, '伊藤忠フアインケミカル 株式会社');
ok($zip->set_number('1028614')->is_valid_number, '住銀保証 株式会社');
ok($zip->set_number('1028617')->is_valid_number, '株式会社 ディー・エム・ジェイ');
ok($zip->set_number('1028618')->is_valid_number, '(株) 読売情報開発');
ok($zip->set_number('1028619')->is_valid_number, '(株) 読売ハートサービス');
ok($zip->set_number('1028620')->is_valid_number, '株式会社 ブティック社');
ok($zip->set_number('1028621')->is_valid_number, '株式会社 みらい建設グループ');
ok($zip->set_number('1028626')->is_valid_number, '日本能力科学アカデミー');
ok($zip->set_number('1028627')->is_valid_number, '株式会社 日本通信教育連合会');
ok($zip->set_number('1028628')->is_valid_number, 'きんでん 東京本社');
ok($zip->set_number('1028630')->is_valid_number, '全国共済農業協同組合連合会 全国本部');
ok($zip->set_number('1028631')->is_valid_number, '野村貿易 株式会社');
ok($zip->set_number('1028632')->is_valid_number, 'プリメイト');
ok($zip->set_number('1028633')->is_valid_number, '株式会社 たいよう共済');
ok($zip->set_number('1028635')->is_valid_number, '全国市長会');
ok($zip->set_number('1028637')->is_valid_number, '株式会社 日本通信販売連合会');
ok($zip->set_number('1028639')->is_valid_number, 'あしなが育英会');
ok($zip->set_number('1028642')->is_valid_number, '株式会社 ユーラシア旅行社');
ok($zip->set_number('1028644')->is_valid_number, '株式会社 ビーエス日本(ビーエス日テレ)');
ok($zip->set_number('1028645')->is_valid_number, 'セコム損害保険 株式会社');
ok($zip->set_number('1028650')->is_valid_number, '財形住宅金融 株式会社');
ok($zip->set_number('1028651')->is_valid_number, '最高裁判所');
ok($zip->set_number('1028656')->is_valid_number, '日本芸術文化振興会');
ok($zip->set_number('1028660')->is_valid_number, '株式会社 あおぞら銀行');
ok($zip->set_number('1028666')->is_valid_number, '独立行政法人 科学技術振興機構');
ok($zip->set_number('1028667')->is_valid_number, '万有製薬 株式会社');
ok($zip->set_number('1028668')->is_valid_number, '財団法人 日本棋院');
ok($zip->set_number('1028671')->is_valid_number, '株式会社 エルヴィジョン');
ok($zip->set_number('1028677')->is_valid_number, '株式会社 日本金融通信社 (ニッキン)');
ok($zip->set_number('1028678')->is_valid_number, '株式会社 錢高組 東京本社・支社');
ok($zip->set_number('1028679')->is_valid_number, '株式会社 ソニー・マガジンズ');
ok($zip->set_number('1028680')->is_valid_number, '株式会社 世界文化社');
ok($zip->set_number('1028685')->is_valid_number, '株式会社 角川ヘラルド・ピクチャーズ');
ok($zip->set_number('1028688')->is_valid_number, '東京都千代田区役所');
ok($zip->set_number('1028689')->is_valid_number, '株式会社 第一学習社');
ok($zip->set_number('1028795')->is_valid_number, '総務省 関東総合通信局');
ok($zip->set_number('1028798')->is_valid_number, '東京逓信病院');
ok($zip->set_number('1038001')->is_valid_number, '株式会社 三越');
ok($zip->set_number('1038011')->is_valid_number, '野村証券 株式会社');
ok($zip->set_number('1038201')->is_valid_number, '三洋証券 株式会社');
ok($zip->set_number('1038202')->is_valid_number, '日本証券代行 株式会社');
ok($zip->set_number('1038203')->is_valid_number, 'オーストラリアドライフルーツ 株式会社');
ok($zip->set_number('1038203')->is_valid_number, '株式会社 京まろん');
ok($zip->set_number('1038203')->is_valid_number, '株式会社 正栄デリシィ');
ok($zip->set_number('1038203')->is_valid_number, '株式会社 ロビニア');
ok($zip->set_number('1038203')->is_valid_number, '正栄食品工業 株式会社');
ok($zip->set_number('1038203')->is_valid_number, '成光商事 株式会社');
ok($zip->set_number('1038203')->is_valid_number, '筑波乳業 株式会社');
ok($zip->set_number('1038203')->is_valid_number, '本多興産 有限会社');
ok($zip->set_number('1038204')->is_valid_number, '住友三井オートサービス 株式会社');
ok($zip->set_number('1038205')->is_valid_number, 'ハナマルキ 株式会社');
ok($zip->set_number('1038206')->is_valid_number, '田中貴金属工業 株式会社');
ok($zip->set_number('1038210')->is_valid_number, '花王 株式会社');
ok($zip->set_number('1038211')->is_valid_number, '澁澤倉庫 株式会社');
ok($zip->set_number('1038212')->is_valid_number, '全国経済事業協同組合連合会');
ok($zip->set_number('1038214')->is_valid_number, '株式会社 第一成和事務所');
ok($zip->set_number('1038217')->is_valid_number, '日本電子計算 株式会社');
ok($zip->set_number('1038218')->is_valid_number, '高島屋スペースクリエイツ (株)');
ok($zip->set_number('1038221')->is_valid_number, 'SMBCフレンド証券 株式会社');
ok($zip->set_number('1038222')->is_valid_number, '平和不動産 株式会社');
ok($zip->set_number('1038224')->is_valid_number, '株式会社 東京証券取引所グループ');
ok($zip->set_number('1038225')->is_valid_number, '株式会社 日興コーディアルグループ 日興コーディアル証券 株式会社');
ok($zip->set_number('1038228')->is_valid_number, '加藤産商 株式会社');
ok($zip->set_number('1038229')->is_valid_number, '東京證券取引所 自主規制法人');
ok($zip->set_number('1038230')->is_valid_number, 'メリルリンチ日本証券 株式会社');
ok($zip->set_number('1038231')->is_valid_number, '株式会社 毎日EVRシステム');
ok($zip->set_number('1038232')->is_valid_number, '宝酒造 株式会社 首都圏支社');
ok($zip->set_number('1038233')->is_valid_number, 'DIC 株式会社');
ok($zip->set_number('1038235')->is_valid_number, '高島屋クレジット 株式会社');
ok($zip->set_number('1038236')->is_valid_number, '日本農薬 株式会社');
ok($zip->set_number('1038237')->is_valid_number, '日本鐵板 株式会社');
ok($zip->set_number('1038238')->is_valid_number, '株式会社 東日本銀行');
ok($zip->set_number('1038239')->is_valid_number, '株式会社 オンワード樫山');
ok($zip->set_number('1038240')->is_valid_number, '大和製罐 株式会社');
ok($zip->set_number('1038241')->is_valid_number, '国分 株式会社');
ok($zip->set_number('1038242')->is_valid_number, '三菱UFJメリルリンチPB証券 株式会社');
ok($zip->set_number('1038243')->is_valid_number, '富士電機イー・アイ・シー 株式会社');
ok($zip->set_number('1038245')->is_valid_number, '丸善 株式会社');
ok($zip->set_number('1038246')->is_valid_number, '株式会社 スタートラストインターナショナル');
ok($zip->set_number('1038247')->is_valid_number, '伊藤忠丸紅鉄鋼 株式会社');
ok($zip->set_number('1038248')->is_valid_number, '株式会社 馬渕商事');
ok($zip->set_number('1038250')->is_valid_number, 'ニッセイ同和損害保険 株式会社');
ok($zip->set_number('1038251')->is_valid_number, '株式会社 コーセー');
ok($zip->set_number('1038252')->is_valid_number, '日本生命保険 相互会社 日本橋総支社');
ok($zip->set_number('1038255')->is_valid_number, '日本興亜損害保険 株式会社');
ok($zip->set_number('1038256')->is_valid_number, '日野自動車工業 株式会社');
ok($zip->set_number('1038258')->is_valid_number, '丸三証券 株式会社');
ok($zip->set_number('1038259')->is_valid_number, 'スミダ電機 株式会社');
ok($zip->set_number('1038260')->is_valid_number, '野村アセットマネジメント 株式会社');
ok($zip->set_number('1038261')->is_valid_number, '神鋼商事 株式会社');
ok($zip->set_number('1038263')->is_valid_number, '三井造船 株式会社');
ok($zip->set_number('1038265')->is_valid_number, '株式会社 高島屋');
ok($zip->set_number('1038270')->is_valid_number, '日本橋社会保険事務所');
ok($zip->set_number('1038272')->is_valid_number, 'TDK 株式会社');
ok($zip->set_number('1038273')->is_valid_number, '三井リース事業 株式会社');
ok($zip->set_number('1038275')->is_valid_number, '東海東京証券 株式会社');
ok($zip->set_number('1038278')->is_valid_number, '岡三証券 株式会社');
ok($zip->set_number('1038284')->is_valid_number, '株式会社 東陽テクニカ');
ok($zip->set_number('1038285')->is_valid_number, '東京建物 株式会社');
ok($zip->set_number('1038287')->is_valid_number, '株式会社 廣瀬商会');
ok($zip->set_number('1038301')->is_valid_number, '緑屋電気 株式会社');
ok($zip->set_number('1038303')->is_valid_number, '株式会社 新生銀行');
ok($zip->set_number('1038306')->is_valid_number, '東京製綱 株式会社');
ok($zip->set_number('1038307')->is_valid_number, 'ブリヂストン化成品東京 株式会社');
ok($zip->set_number('1038308')->is_valid_number, '富士フィルター工業 株式会社');
ok($zip->set_number('1038310')->is_valid_number, '株式会社 クボタ 東京本社');
ok($zip->set_number('1038311')->is_valid_number, '旭電化工業 株式会社');
ok($zip->set_number('1038313')->is_valid_number, '小堺化学工業 株式会社');
ok($zip->set_number('1038317')->is_valid_number, '株式会社 QUICK 本社');
ok($zip->set_number('1038320')->is_valid_number, '伊藤忠食品 株式会社');
ok($zip->set_number('1038321')->is_valid_number, 'ユニチカ 株式会社 東京本社');
ok($zip->set_number('1038323')->is_valid_number, '三井信託銀行 株式会社');
ok($zip->set_number('1038324')->is_valid_number, '中外製薬 株式会社');
ok($zip->set_number('1038328')->is_valid_number, 'マンダリン・オリエンタル東京 株式会社');
ok($zip->set_number('1038330')->is_valid_number, 'わかもと製薬 株式会社');
ok($zip->set_number('1038331')->is_valid_number, '三機工業 株式会社');
ok($zip->set_number('1038333')->is_valid_number, 'UFJつばさ証券 株式会社');
ok($zip->set_number('1038335')->is_valid_number, '日本レジャーカードシステム 株式会社');
ok($zip->set_number('1038337')->is_valid_number, 'MBEジャパン 株式会社');
ok($zip->set_number('1038338')->is_valid_number, '電気化学工業 株式会社');
ok($zip->set_number('1038339')->is_valid_number, '三省物産 株式会社');
ok($zip->set_number('1038341')->is_valid_number, '北興化学工業 株式会社');
ok($zip->set_number('1038345')->is_valid_number, '株式会社 東洋経済新報社');
ok($zip->set_number('1038346')->is_valid_number, '全国社会保険労務士会連合会');
ok($zip->set_number('1038347')->is_valid_number, '全国社会保険労務士会連合会 社会保険労務士試験センター');
ok($zip->set_number('1038350')->is_valid_number, '早川商事 株式会社');
ok($zip->set_number('1038351')->is_valid_number, 'ゼリア新薬工業 株式会社');
ok($zip->set_number('1038352')->is_valid_number, '小原化工 株式会社');
ok($zip->set_number('1038354')->is_valid_number, '株式会社 アドバンス');
ok($zip->set_number('1038355')->is_valid_number, '長瀬産業 株式会社');
ok($zip->set_number('1038358')->is_valid_number, '日本トレーディング 株式会社');
ok($zip->set_number('1038360')->is_valid_number, '東京都中央区日本橋特別出張所');
ok($zip->set_number('1038363')->is_valid_number, '橋本総業 株式会社');
ok($zip->set_number('1038366')->is_valid_number, '曽田香料 株式会社');
ok($zip->set_number('1038370')->is_valid_number, '株式会社 エトワール海渡');
ok($zip->set_number('1038373')->is_valid_number, '東洋佐々木ガラス 株式会社');
ok($zip->set_number('1038380')->is_valid_number, '株式会社 岡永');
ok($zip->set_number('1038383')->is_valid_number, '大日精化工業 株式会社');
ok($zip->set_number('1038384')->is_valid_number, '学校法人 日本橋女学館');
ok($zip->set_number('1038388')->is_valid_number, 'マービー 株式会社');
ok($zip->set_number('1038401')->is_valid_number, '大木建設 株式会社');
ok($zip->set_number('1038402')->is_valid_number, '信越ポリマー 株式会社');
ok($zip->set_number('1038403')->is_valid_number, 'イワキ 株式会社');
ok($zip->set_number('1038404')->is_valid_number, 'ツカモト 株式会社');
ok($zip->set_number('1038405')->is_valid_number, '三菱ウェルファーマ 株式会社 東京オフィス');
ok($zip->set_number('1038407')->is_valid_number, '東洋ケミカルズ 株式会社');
ok($zip->set_number('1038410')->is_valid_number, '岸本産業 株式会社');
ok($zip->set_number('1038411')->is_valid_number, 'アステラス製薬 株式会社');
ok($zip->set_number('1038412')->is_valid_number, '関東化学 株式会社');
ok($zip->set_number('1038413')->is_valid_number, 'カネダ 株式会社');
ok($zip->set_number('1038414')->is_valid_number, '丹平中田 株式会社 東京支社');
ok($zip->set_number('1038415')->is_valid_number, '伊藤忠紙パルプ 株式会社');
ok($zip->set_number('1038416')->is_valid_number, '萬有製薬 株式会社');
ok($zip->set_number('1038417')->is_valid_number, 'オー・ジー 株式会社 東京支店');
ok($zip->set_number('1038419')->is_valid_number, '伊藤忠建材 (株)');
ok($zip->set_number('1038422')->is_valid_number, '日曹商事 株式会社');
ok($zip->set_number('1038423')->is_valid_number, '三井製糖 株式会社');
ok($zip->set_number('1038424')->is_valid_number, 'ポリマテック 株式会社');
ok($zip->set_number('1038425')->is_valid_number, '大建工業 株式会社');
ok($zip->set_number('1038426')->is_valid_number, '第一三共 株式会社 本社ビル');
ok($zip->set_number('1038427')->is_valid_number, '伊藤忠連合健康保険組合');
ok($zip->set_number('1038430')->is_valid_number, '株式会社 建設技術研究所');
ok($zip->set_number('1038431')->is_valid_number, '長谷川香料 株式会社');
ok($zip->set_number('1038432')->is_valid_number, 'ヤマト科学 株式会社');
ok($zip->set_number('1038433')->is_valid_number, '興和 株式会社 東京支店');
ok($zip->set_number('1038434')->is_valid_number, '岩城製薬 株式会社');
ok($zip->set_number('1038435')->is_valid_number, '小津産業 株式会社');
ok($zip->set_number('1038437')->is_valid_number, '東邦亜鉛 株式会社');
ok($zip->set_number('1038438')->is_valid_number, 'リケンテクノス 株式会社');
ok($zip->set_number('1038439')->is_valid_number, '鳥居薬品 株式会社');
ok($zip->set_number('1038443')->is_valid_number, '株式会社 つぼ八');
ok($zip->set_number('1038444')->is_valid_number, '松吉医科器機 株式会社');
ok($zip->set_number('1038448')->is_valid_number, '稲畑産業 株式会社 東京本社');
ok($zip->set_number('1038449')->is_valid_number, '株式会社 サッポロライオン');
ok($zip->set_number('1038450')->is_valid_number, '株式会社 上田嘉一朗商店');
ok($zip->set_number('1038451')->is_valid_number, '株式会社 ガイア');
ok($zip->set_number('1038456')->is_valid_number, '新日本無線 株式会社');
ok($zip->set_number('1038460')->is_valid_number, 'ミツワ電機 株式会社');
ok($zip->set_number('1038461')->is_valid_number, 'カゴメ 株式会社 東京本社');
ok($zip->set_number('1038462')->is_valid_number, 'カゴメ 株式会社 東京支社');
ok($zip->set_number('1038465')->is_valid_number, '東京実業健康保険組合');
ok($zip->set_number('1038466')->is_valid_number, '株式会社 大山');
ok($zip->set_number('1038470')->is_valid_number, '三共生興 株式会社');
ok($zip->set_number('1038471')->is_valid_number, '斎長物産 株式会社');
ok($zip->set_number('1038472')->is_valid_number, '豊島 株式会社 東京本社');
ok($zip->set_number('1038473')->is_valid_number, 'ゼリア新薬工業 株式会社 東京支店');
ok($zip->set_number('1038480')->is_valid_number, 'ピジョン 株式会社');
ok($zip->set_number('1038481')->is_valid_number, 'エスエス製薬 株式会社');
ok($zip->set_number('1038481')->is_valid_number, 'ベーリンガーインゲルハイムジャパン 株式会社');
ok($zip->set_number('1038481')->is_valid_number, 'ベーリンガーインゲルハイム製薬 株式会社');
ok($zip->set_number('1038484')->is_valid_number, '社団法人 日本ボウリング場協会');
ok($zip->set_number('1038486')->is_valid_number, '旭化成 株式会社・旭化成アミダス 株式会社');
ok($zip->set_number('1038487')->is_valid_number, '長瀬ランダウア 株式会社');
ok($zip->set_number('1038501')->is_valid_number, 'ソフトバンク 株式会社');
ok($zip->set_number('1038502')->is_valid_number, 'マックス 株式会社');
ok($zip->set_number('1038503')->is_valid_number, '協和発酵工業 株式会社 東京支社');
ok($zip->set_number('1038506')->is_valid_number, '全国建設工事業国民健康保険組合');
ok($zip->set_number('1038507')->is_valid_number, 'エス・アンド・アイ 株式会社');
ok($zip->set_number('1038510')->is_valid_number, '日本アイ・ビー・エム 株式会社 箱崎事業所');
ok($zip->set_number('1038511')->is_valid_number, '大東紡織 株式会社');
ok($zip->set_number('1038512')->is_valid_number, '日本オフィス・システム 株式会社');
ok($zip->set_number('1038515')->is_valid_number, '株式会社 明電舎');
ok($zip->set_number('1038520')->is_valid_number, '株式会社 ロイヤルパークホテル');
ok($zip->set_number('1038521')->is_valid_number, '株式会社 インパクト21');
ok($zip->set_number('1038522')->is_valid_number, '株式会社 桃屋');
ok($zip->set_number('1038525')->is_valid_number, '株式会社 ジャック');
ok($zip->set_number('1038530')->is_valid_number, '東洋紡績 株式会社 東京支社');
ok($zip->set_number('1038531')->is_valid_number, '日本重化学工業 株式会社');
ok($zip->set_number('1038533')->is_valid_number, '三菱UFJ信託銀行 株式会社');
ok($zip->set_number('1038534')->is_valid_number, '曙ブレーキ工業 株式会社');
ok($zip->set_number('1038535')->is_valid_number, '(株) 新聞編集センター');
ok($zip->set_number('1038536')->is_valid_number, '日新製糖 株式会社');
ok($zip->set_number('1038537')->is_valid_number, 'ユーシーカード 株式会社');
ok($zip->set_number('1038538')->is_valid_number, 'ぺんてる 株式会社');
ok($zip->set_number('1038542')->is_valid_number, '株式会社 山下設計');
ok($zip->set_number('1038543')->is_valid_number, '株式会社 不動テトラ');
ok($zip->set_number('1038545')->is_valid_number, '株式会社 旅行読売出版社');
ok($zip->set_number('1038548')->is_valid_number, '株式会社 日刊工業新聞社');
ok($zip->set_number('1038552')->is_valid_number, '株式会社 クレハ');
ok($zip->set_number('1038554')->is_valid_number, '東京織物健康保険組合');
ok($zip->set_number('1038555')->is_valid_number, 'さくらカード 株式会社');
ok($zip->set_number('1038556')->is_valid_number, '三井物産フューチャーズ 株式会社');
ok($zip->set_number('1038558')->is_valid_number, '市田 株式会社');
ok($zip->set_number('1038560')->is_valid_number, 'チョーギン 株式会社');
ok($zip->set_number('1038566')->is_valid_number, 'デンヨー 株式会社');
ok($zip->set_number('1038567')->is_valid_number, '株式会社 サントリーショッピングクラブ');
ok($zip->set_number('1038570')->is_valid_number, 'ユアサ商事 株式会社');
ok($zip->set_number('1038571')->is_valid_number, 'ヤマト 株式会社');
ok($zip->set_number('1038575')->is_valid_number, 'ノボノルディスクファーマ 株式会社');
ok($zip->set_number('1038577')->is_valid_number, '丸文 株式会社');
ok($zip->set_number('1038584')->is_valid_number, 'トスコ 株式会社');
ok($zip->set_number('1038585')->is_valid_number, '富士紡ホールディングス 株式会社');
ok($zip->set_number('1038586')->is_valid_number, '日本トータルテレマーケティング 株式会社');
ok($zip->set_number('1038588')->is_valid_number, '株式会社 パーカーコーポレーション');
ok($zip->set_number('1038589')->is_valid_number, 'スミダコーポレーション 株式会社');
ok($zip->set_number('1038630')->is_valid_number, '三菱倉庫 株式会社');
ok($zip->set_number('1038631')->is_valid_number, '出光クレジット 株式会社');
ok($zip->set_number('1038632')->is_valid_number, '株式会社 百十四銀行 東京支店');
ok($zip->set_number('1038636')->is_valid_number, '株式会社 興伸');
ok($zip->set_number('1038639')->is_valid_number, '佐藤工業 株式会社');
ok($zip->set_number('1038640')->is_valid_number, '日本アジア証券 株式会社');
ok($zip->set_number('1038641')->is_valid_number, '日本紙パルプ商事 株式会社');
ok($zip->set_number('1038644')->is_valid_number, '株式会社 第四銀行 東京支店');
ok($zip->set_number('1038650')->is_valid_number, '日清紡 株式会社');
ok($zip->set_number('1038651')->is_valid_number, '株式会社 山口銀行 東京支店');
ok($zip->set_number('1038652')->is_valid_number, '蝶理 株式会社 東京本社');
ok($zip->set_number('1038653')->is_valid_number, '株式会社 千葉銀行 東京営業部');
ok($zip->set_number('1038656')->is_valid_number, '株式会社 広島銀行 東京支店');
ok($zip->set_number('1038660')->is_valid_number, '日本銀行');
ok($zip->set_number('1038665')->is_valid_number, '野崎産業 株式会社');
ok($zip->set_number('1038666')->is_valid_number, '東レ 株式会社 本社');
ok($zip->set_number('1038668')->is_valid_number, '武田薬品工業 株式会社');
ok($zip->set_number('1038670')->is_valid_number, 'みずほ信託銀行 株式会社');
ok($zip->set_number('1038675')->is_valid_number, '株式会社 りそな銀行 日本橋支店');
ok($zip->set_number('1038676')->is_valid_number, '株式会社 群馬銀行 東京支店');
ok($zip->set_number('1038677')->is_valid_number, '株式会社 みずほコーポレート銀行');
ok($zip->set_number('1038680')->is_valid_number, '株式会社 守谷商会');
ok($zip->set_number('1038684')->is_valid_number, '株式会社 三菱東京UFJ銀行');
ok($zip->set_number('1038686')->is_valid_number, '株式会社 ベネッセコーポレーション');
ok($zip->set_number('1038689')->is_valid_number, 'スルガ銀行 株式会社 東京支店');
ok($zip->set_number('1046241')->is_valid_number, '住商情報システム 株式会社');
ok($zip->set_number('1048001')->is_valid_number, '株式会社 リクルート 銀座8丁目ビル');
ok($zip->set_number('1048003')->is_valid_number, '株式会社 マガジンハウス');
ok($zip->set_number('1048004')->is_valid_number, '株式会社 東京ニュース通信社');
ok($zip->set_number('1048007')->is_valid_number, '株式会社 日刊現代');
ok($zip->set_number('1048010')->is_valid_number, '株式会社 資生堂');
ok($zip->set_number('1048011')->is_valid_number, '朝日新聞 東京本社');
ok($zip->set_number('1048055')->is_valid_number, '株式会社 日刊スポーツ新聞社');
ok($zip->set_number('1048077')->is_valid_number, '財団法人 都民劇場');
ok($zip->set_number('1048101')->is_valid_number, '株式会社 紀文食品');
ok($zip->set_number('1048102')->is_valid_number, '株式会社 ワシントン靴店');
ok($zip->set_number('1048104')->is_valid_number, '株式会社 法研');
ok($zip->set_number('1048105')->is_valid_number, '株式会社 和光');
ok($zip->set_number('1048106')->is_valid_number, '株式会社 電通ワークス');
ok($zip->set_number('1048108')->is_valid_number, '東映 株式会社');
ok($zip->set_number('1048109')->is_valid_number, 'ソマール 株式会社');
ok($zip->set_number('1048111')->is_valid_number, '廣告社 株式会社');
ok($zip->set_number('1048112')->is_valid_number, '日本電工 (株)');
ok($zip->set_number('1048114')->is_valid_number, '社団法人 公開経営指導協会');
ok($zip->set_number('1048115')->is_valid_number, '千代田工販 株式会社');
ok($zip->set_number('1048116')->is_valid_number, '北野建設 株式会社 東京本社');
ok($zip->set_number('1048117')->is_valid_number, '大和自動車交通 株式會社');
ok($zip->set_number('1048118')->is_valid_number, '高島 株式会社');
ok($zip->set_number('1048122')->is_valid_number, '富士火災海上保険 株式会社');
ok($zip->set_number('1048123')->is_valid_number, 'UIP映画');
ok($zip->set_number('1048124')->is_valid_number, '中越パルプ工業 株式会社');
ok($zip->set_number('1048125')->is_valid_number, 'ヤマト運輸 株式会社');
ok($zip->set_number('1048128')->is_valid_number, '綜合ユニコム 株式会社');
ok($zip->set_number('1048129')->is_valid_number, 'セイコーホールディングス 株式会社');
ok($zip->set_number('1048130')->is_valid_number, '株式会社 松屋 銀座本店');
ok($zip->set_number('1048131')->is_valid_number, '押谷フエルト化成 株式会社');
ok($zip->set_number('1048132')->is_valid_number, '株式会社 博品館');
ok($zip->set_number('1048133')->is_valid_number, '東京電力 株式会社 銀座支店');
ok($zip->set_number('1048134')->is_valid_number, 'リコーリース 株式会社');
ok($zip->set_number('1048135')->is_valid_number, '株式会社 日本香堂');
ok($zip->set_number('1048138')->is_valid_number, '株式会社 ゼアリズ');
ok($zip->set_number('1048142')->is_valid_number, '株式会社 ジャパン・エンターテイメント・ネットワーク');
ok($zip->set_number('1048145')->is_valid_number, '株式会社 ミキモト');
ok($zip->set_number('1048151')->is_valid_number, '東京海上日動火災保険 株式会社');
ok($zip->set_number('1048155')->is_valid_number, '株式会社 リコー 銀座事業所');
ok($zip->set_number('1048158')->is_valid_number, '共同ピーアール 株式会社');
ok($zip->set_number('1048161')->is_valid_number, '株式会社 名鉄エージェンシー 東京支社');
ok($zip->set_number('1048162')->is_valid_number, '合同酒精 株式会社');
ok($zip->set_number('1048163')->is_valid_number, '株式会社 松坂屋 法人外商統括部');
ok($zip->set_number('1048164')->is_valid_number, '株式会社 読売広告社');
ok($zip->set_number('1048165')->is_valid_number, '電源開発 株式会社');
ok($zip->set_number('1048166')->is_valid_number, '株式会社 松坂屋 銀座店');
ok($zip->set_number('1048167')->is_valid_number, '日放 株式会社');
ok($zip->set_number('1048168')->is_valid_number, '株式会社 近代映画社');
ok($zip->set_number('1048170')->is_valid_number, '株式会社 イノアックコーポレーション');
ok($zip->set_number('1048171')->is_valid_number, '株式会社 電通リサーチ');
ok($zip->set_number('1048172')->is_valid_number, '株式会社 アサツー ディ・ケイ');
ok($zip->set_number('1048175')->is_valid_number, '日本年金機構 中央年金事務所');
ok($zip->set_number('1048176')->is_valid_number, '株式会社 日本経済社');
ok($zip->set_number('1048177')->is_valid_number, '株式会社 七十七銀行 東京支店');
ok($zip->set_number('1048178')->is_valid_number, '株式会社 時事通信社');
ok($zip->set_number('1048180')->is_valid_number, 'リコー販売 株式会社');
ok($zip->set_number('1048181')->is_valid_number, '株式会社 不二家');
ok($zip->set_number('1048183')->is_valid_number, '株式会社 東成社');
ok($zip->set_number('1048189')->is_valid_number, '株式会社 栄美通信');
ok($zip->set_number('1048205')->is_valid_number, '福徳長酒類 株式会社');
ok($zip->set_number('1048206')->is_valid_number, '共和ピー・アール 株式会社');
ok($zip->set_number('1048208')->is_valid_number, '株式会社 ノエビア');
ok($zip->set_number('1048210')->is_valid_number, '株式会社 電通パブリックリレーションズ');
ok($zip->set_number('1048211')->is_valid_number, '中央宣興 株式会社');
ok($zip->set_number('1048212')->is_valid_number, '株式会社 三越 銀座店');
ok($zip->set_number('1048215')->is_valid_number, '株式会社 ピーエス三菱 本社');
ok($zip->set_number('1048218')->is_valid_number, '株式会社 ENEOSフロンティア');
ok($zip->set_number('1048222')->is_valid_number, '株式会社 リコー 本社事業所');
ok($zip->set_number('1048228')->is_valid_number, '株式会社 音楽専科社');
ok($zip->set_number('1048233')->is_valid_number, '株式会社 実業之日本社');
ok($zip->set_number('1048238')->is_valid_number, 'ストックプラス');
ok($zip->set_number('1048240')->is_valid_number, '株式会社 ヒサヤ大黒堂');
ok($zip->set_number('1048243')->is_valid_number, '株式会社 読売新聞 東京本社');
ok($zip->set_number('1048250')->is_valid_number, '全国印刷工業 健康保険組合');
ok($zip->set_number('1048251')->is_valid_number, '株式会社 アカギ');
ok($zip->set_number('1048252')->is_valid_number, '三井住友海上火災保険 株式会社');
ok($zip->set_number('1048253')->is_valid_number, '三菱UFJリース 株式会社');
ok($zip->set_number('1048255')->is_valid_number, 'セントラルスポーツ 株式会社');
ok($zip->set_number('1048256')->is_valid_number, '株式会社 グランビスタ ホテル&リゾート');
ok($zip->set_number('1048257')->is_valid_number, '日本重化学工業 株式会社');
ok($zip->set_number('1048260')->is_valid_number, '住友化学 株式会社');
ok($zip->set_number('1048262')->is_valid_number, '青山特殊鋼 株式会社');
ok($zip->set_number('1048266')->is_valid_number, '株式会社 鈴乃屋');
ok($zip->set_number('1048270')->is_valid_number, '三谷産業 株式会社 東京本社');
ok($zip->set_number('1048277')->is_valid_number, '三井食品 株式会社');
ok($zip->set_number('1048280')->is_valid_number, '新日鉄ソリューションズ 株式会社');
ok($zip->set_number('1048281')->is_valid_number, '松井建設 株式会社');
ok($zip->set_number('1048282')->is_valid_number, '株式会社 内田洋行');
ok($zip->set_number('1048284')->is_valid_number, 'アイク 株式会社');
ok($zip->set_number('1048285')->is_valid_number, '日清オイリオグループ 株式会社');
ok($zip->set_number('1048288')->is_valid_number, 'キリンビール 株式会社');
ok($zip->set_number('1048289')->is_valid_number, '大豊建設 株式会社');
ok($zip->set_number('1048302')->is_valid_number, '株式会社 明治屋');
ok($zip->set_number('1048303')->is_valid_number, '阪神航空');
ok($zip->set_number('1048304')->is_valid_number, '株式会社 パイロットコーポレーション');
ok($zip->set_number('1048305')->is_valid_number, 'メルシャン 株式会社');
ok($zip->set_number('1048309')->is_valid_number, '日本相互証券 株式会社');
ok($zip->set_number('1048310')->is_valid_number, '全国信用協同組合連合会');
ok($zip->set_number('1048311')->is_valid_number, '蛇の目ミシン工業 株式会社');
ok($zip->set_number('1048312')->is_valid_number, '片倉工業 株式会社');
ok($zip->set_number('1048313')->is_valid_number, '株式会社 朝日広告社');
ok($zip->set_number('1048315')->is_valid_number, '味の素 株式会社 (本社)');
ok($zip->set_number('1048317')->is_valid_number, '東海東京証券 株式会社');
ok($zip->set_number('1048319')->is_valid_number, '王子ネピア 株式会社');
ok($zip->set_number('1048320')->is_valid_number, '株式会社 中央公論社');
ok($zip->set_number('1048321')->is_valid_number, 'シーアイ化成 株式会社');
ok($zip->set_number('1048324')->is_valid_number, '東洋熱工業 株式会社');
ok($zip->set_number('1048325')->is_valid_number, '株式会社 読売新聞社 事業局');
ok($zip->set_number('1048328')->is_valid_number, '株式会社 オービック');
ok($zip->set_number('1048330')->is_valid_number, '有楽土地 株式会社');
ok($zip->set_number('1048332')->is_valid_number, '大成サービス 株式会社');
ok($zip->set_number('1048333')->is_valid_number, '国際紙パルプ商事 株式会社');
ok($zip->set_number('1048335')->is_valid_number, '株式会社 巴川製紙所');
ok($zip->set_number('1048338')->is_valid_number, '兼松エレクトロニクス 株式会社');
ok($zip->set_number('1048340')->is_valid_number, '株式会社 ブリヂストン');
ok($zip->set_number('1048344')->is_valid_number, '大成サービス 株式会社 東京支店');
ok($zip->set_number('1048351')->is_valid_number, '前澤工業 株式会社');
ok($zip->set_number('1048356')->is_valid_number, '大日本住友製薬 株式会社');
ok($zip->set_number('1048357')->is_valid_number, '株式会社 主婦と生活社');
ok($zip->set_number('1048360')->is_valid_number, '興銀リース 株式会社');
ok($zip->set_number('1048361')->is_valid_number, '富士産業 株式会社');
ok($zip->set_number('1048365')->is_valid_number, '日本冶金工業 株式会社');
ok($zip->set_number('1048372')->is_valid_number, '三菱製紙販売 株式会社');
ok($zip->set_number('1048377')->is_valid_number, '東洋インキSCホールディングス 株式会社');
ok($zip->set_number('1048380')->is_valid_number, '株式会社 NIPPOコーポレーション');
ok($zip->set_number('1048383')->is_valid_number, '大成ロテック 株式会社');
ok($zip->set_number('1048388')->is_valid_number, '戸田建設 株式会社');
ok($zip->set_number('1048401')->is_valid_number, '日本管材センター 株式会社');
ok($zip->set_number('1048402')->is_valid_number, '株式会社 ニチレイ');
ok($zip->set_number('1048403')->is_valid_number, '築地魚市場 株式会社');
ok($zip->set_number('1048404')->is_valid_number, '東京都中央区役所');
ok($zip->set_number('1048405')->is_valid_number, '東京教区教務所');
ok($zip->set_number('1048406')->is_valid_number, '日通商事 株式会社');
ok($zip->set_number('1048407')->is_valid_number, '日本興亜生命保険 株式会社');
ok($zip->set_number('1048408')->is_valid_number, '菱洋エレクトロ 株式会社');
ok($zip->set_number('1048410')->is_valid_number, 'JSR 株式会社');
ok($zip->set_number('1048411')->is_valid_number, '株式会社 電通テック');
ok($zip->set_number('1048415')->is_valid_number, '株式会社 東京ニュース 通信社');
ok($zip->set_number('1048418')->is_valid_number, 'ITサービスフォース 株式会社');
ok($zip->set_number('1048419')->is_valid_number, '全国情報サービス産業厚生年金基金');
ok($zip->set_number('1048420')->is_valid_number, '株式会社 読売旅行');
ok($zip->set_number('1048421')->is_valid_number, 'オフィストウエンティワン 株式会社');
ok($zip->set_number('1048422')->is_valid_number, '松竹 株式会社');
ok($zip->set_number('1048424')->is_valid_number, '株式会社 日刊スポーツ出版社');
ok($zip->set_number('1048425')->is_valid_number, '日本興亜損害保険 株式会社 東京営業第一部');
ok($zip->set_number('1048429')->is_valid_number, '阪和興業 株式会社');
ok($zip->set_number('1048430')->is_valid_number, '住友生命保険 相互会社');
ok($zip->set_number('1048431')->is_valid_number, '株式会社 中村自工');
ok($zip->set_number('1048433')->is_valid_number, '株式会社 朝日学生新聞社');
ok($zip->set_number('1048434')->is_valid_number, '東都水産 株式会社');
ok($zip->set_number('1048435')->is_valid_number, '本願寺 築地別院');
ok($zip->set_number('1048436')->is_valid_number, '大都魚類 株式会社');
ok($zip->set_number('1048438')->is_valid_number, '東日本建設業保証 株式会社');
ok($zip->set_number('1048440')->is_valid_number, '株式会社 サンギ');
ok($zip->set_number('1048443')->is_valid_number, '朝日ニュースター 株式会社 衛星チャンネル');
ok($zip->set_number('1048444')->is_valid_number, '日商エレクトロニクス 株式会社');
ok($zip->set_number('1048445')->is_valid_number, '中央魚類 株式会社');
ok($zip->set_number('1048447')->is_valid_number, '丸千千代田水産 株式会社');
ok($zip->set_number('1048448')->is_valid_number, '興和創薬 株式会社');
ok($zip->set_number('1048450')->is_valid_number, '商工組合中央金庫 本店');
ok($zip->set_number('1048451')->is_valid_number, '京セラ 株式会社 東京八重洲事業所');
ok($zip->set_number('1048455')->is_valid_number, 'キグナス石油 株式会社');
ok($zip->set_number('1048456')->is_valid_number, '株式会社 八重洲ブックセンター');
ok($zip->set_number('1048460')->is_valid_number, '国際興業 株式会社');
ok($zip->set_number('1048466')->is_valid_number, '日本酒類販売 株式会社');
ok($zip->set_number('1048468')->is_valid_number, '大王製紙 株式会社');
ok($zip->set_number('1048470')->is_valid_number, '東京信用保証協会');
ok($zip->set_number('1048476')->is_valid_number, '住友信託銀行 株式会社');
ok($zip->set_number('1048478')->is_valid_number, '株式会社 穴吹工務店');
ok($zip->set_number('1048481')->is_valid_number, 'みずほ証券 株式会社');
ok($zip->set_number('1048486')->is_valid_number, 'ヤンマー 株式会社 東京支社');
ok($zip->set_number('1048488')->is_valid_number, '株式会社 八重洲出版');
ok($zip->set_number('1048501')->is_valid_number, 'ライオンズクラブ東京合同事務局');
ok($zip->set_number('1048502')->is_valid_number, '丸善石油化学 株式会社');
ok($zip->set_number('1048505')->is_valid_number, '日之出出版 株式会社');
ok($zip->set_number('1048506')->is_valid_number, '三機工業 株式会社');
ok($zip->set_number('1048510')->is_valid_number, '東京貿易 株式会社');
ok($zip->set_number('1048512')->is_valid_number, 'ユニデン 株式会社');
ok($zip->set_number('1048518')->is_valid_number, '太平洋セメント 株式会社');
ok($zip->set_number('1048520')->is_valid_number, '東海興業 株式会社');
ok($zip->set_number('1048521')->is_valid_number, '富士電機総設 株式会社');
ok($zip->set_number('1048523')->is_valid_number, '富士電機ITソリューション 株式会社');
ok($zip->set_number('1048528')->is_valid_number, 'エンパイヤ自動車 株式会社');
ok($zip->set_number('1048530')->is_valid_number, 'ナラサキ産業 株式会社');
ok($zip->set_number('1048533')->is_valid_number, '月星商事 株式会社');
ok($zip->set_number('1048535')->is_valid_number, '株式会社 タビックスジャパン');
ok($zip->set_number('1048538')->is_valid_number, '株式会社 サークルKサンクス');
ok($zip->set_number('1048539')->is_valid_number, '株式会社 共同紙販ホールディングス');
ok($zip->set_number('1048540')->is_valid_number, '日本瓦斯 株式会社');
ok($zip->set_number('1048544')->is_valid_number, '第一中央汽船 株式会社');
ok($zip->set_number('1048546')->is_valid_number, '三井住商建材 株式会社');
ok($zip->set_number('1048548')->is_valid_number, '住友商事マシネックス 株式会社');
ok($zip->set_number('1048550')->is_valid_number, '三菱製鋼 株式会社');
ok($zip->set_number('1048551')->is_valid_number, '江間忠合板 株式会社');
ok($zip->set_number('1048553')->is_valid_number, 'キッコーマンソイフーズ 株式会社');
ok($zip->set_number('1048554')->is_valid_number, '平野通信機材 株式会社');
ok($zip->set_number('1048556')->is_valid_number, 'ニッセイ同和損害保険 株式会社');
ok($zip->set_number('1048558')->is_valid_number, '東京都中央都税事務所');
ok($zip->set_number('1048559')->is_valid_number, '日本酒類販売 株式会社');
ok($zip->set_number('1048560')->is_valid_number, '財団法人 聖路加国際病院');
ok($zip->set_number('1048563')->is_valid_number, 'ブルックハルトジャパン 株式会社');
ok($zip->set_number('1048566')->is_valid_number, 'うおがし銘茶 株式会社');
ok($zip->set_number('1048567')->is_valid_number, '大明工機 株式会社');
ok($zip->set_number('1048568')->is_valid_number, '株式会社 サントリー・ショッピング・クラブ');
ok($zip->set_number('1048570')->is_valid_number, '株式会社 三越伊勢丹フードサービス');
ok($zip->set_number('1048572')->is_valid_number, '株式会社 ピーエス三菱 東京土木支店・東京建築支店');
ok($zip->set_number('1048580')->is_valid_number, 'キヤノンITソリューションズ 株式会社');
ok($zip->set_number('1048581')->is_valid_number, '財団法人 日本エネルギー経済研究所 石油情報センター');
ok($zip->set_number('1048584')->is_valid_number, '一般財団法人 電気技術者試験センター');
ok($zip->set_number('1048585')->is_valid_number, '中央区月島特別出張所 (月島区民センター)');
ok($zip->set_number('1048587')->is_valid_number, 'サンテレホン 株式会社');
ok($zip->set_number('1048588')->is_valid_number, '大栄太源 株式会社');
ok($zip->set_number('1048650')->is_valid_number, '株式会社 ディーエムエス');
ok($zip->set_number('1048660')->is_valid_number, '東京アテナ 株式会社');
ok($zip->set_number('1048661')->is_valid_number, '朝日新聞 東京支社(編集・出版・文化企画)');
ok($zip->set_number('1048665')->is_valid_number, '朝日新聞 東京支社(友の会・販売・広告)');
ok($zip->set_number('1048668')->is_valid_number, '明治製菓 株式会社');
ok($zip->set_number('1048670')->is_valid_number, '株式会社 不二家');
ok($zip->set_number('1048678')->is_valid_number, '東洋証券 株式会社');
ok($zip->set_number('1048680')->is_valid_number, '味の素 株式会社');
ok($zip->set_number('1048685')->is_valid_number, '株式会社 帝国データバンクビジネスサービス');
ok($zip->set_number('1057444')->is_valid_number, '日本テレビ放送網 株式会社');
ok($zip->set_number('1058001')->is_valid_number, '株式会社 東芝');
ok($zip->set_number('1058002')->is_valid_number, '株式会社 文化放送');
ok($zip->set_number('1058005')->is_valid_number, '兼松 株式会社');
ok($zip->set_number('1058007')->is_valid_number, '清水建設 株式会社');
ok($zip->set_number('1058008')->is_valid_number, '株式会社 ライトアップショッピングクラブ');
ok($zip->set_number('1058010')->is_valid_number, '独立行政法人 農業者年金基金');
ok($zip->set_number('1058011')->is_valid_number, '三井住友カード 株式会社');
ok($zip->set_number('1058012')->is_valid_number, '株式会社 テレビ東京');
ok($zip->set_number('1058055')->is_valid_number, '(株) 徳間書店');
ok($zip->set_number('1058070')->is_valid_number, '(株) 扶桑社');
ok($zip->set_number('1058077')->is_valid_number, '独立行政法人 勤労者退職金共済機構');
ok($zip->set_number('1058085')->is_valid_number, '(株) カネボウ化粧品');
ok($zip->set_number('1058088')->is_valid_number, '企業年金連合会');
ok($zip->set_number('1058301')->is_valid_number, '松下電工 株式会社 東京本社');
ok($zip->set_number('1058310')->is_valid_number, '株式会社 資生堂');
ok($zip->set_number('1058311')->is_valid_number, 'トッパン・フォームズ 株式会社');
ok($zip->set_number('1058312')->is_valid_number, 'トッパン・フォームズ・オペレーション 株式会社');
ok($zip->set_number('1058313')->is_valid_number, 'テクノ・トッパン・フォームズ 株式会社');
ok($zip->set_number('1058322')->is_valid_number, '日本通運 株式会社');
ok($zip->set_number('1058333')->is_valid_number, '株式会社 ロイヤルパーク汐留タワー');
ok($zip->set_number('1058401')->is_valid_number, '西松建設 株式会社');
ok($zip->set_number('1058402')->is_valid_number, '東京都情報サービス産業健康保険組合');
ok($zip->set_number('1058404')->is_valid_number, 'サーモス 株式会社 本社');
ok($zip->set_number('1058405')->is_valid_number, '株式会社 角川・エス・エス・コミュニケーションズ');
ok($zip->set_number('1058407')->is_valid_number, '(株) ジャパンエナジー');
ok($zip->set_number('1058408')->is_valid_number, '日本技術貿易 株式会社');
ok($zip->set_number('1058410')->is_valid_number, '日立アプライアンス 株式会社');
ok($zip->set_number('1058411')->is_valid_number, '日精 株式会社');
ok($zip->set_number('1058412')->is_valid_number, '新日本石油 株式会社');
ok($zip->set_number('1058414')->is_valid_number, 'ローレルバンクマシン (株)');
ok($zip->set_number('1058415')->is_valid_number, '株式会社 ソニー・ピクチャーズエンタテインメント');
ok($zip->set_number('1058416')->is_valid_number, '株式会社 ホテルオークラ');
ok($zip->set_number('1058418')->is_valid_number, '株式会社 日立ハイテクトレーディング');
ok($zip->set_number('1058419')->is_valid_number, '東亞合成 株式会社');
ok($zip->set_number('1058420')->is_valid_number, '都築電産 株式会社');
ok($zip->set_number('1058421')->is_valid_number, '川崎汽船 株式会社');
ok($zip->set_number('1058422')->is_valid_number, '日本たばこ産業 株式会社');
ok($zip->set_number('1058424')->is_valid_number, 'シリリュス・サービスセンター');
ok($zip->set_number('1058427')->is_valid_number, '三井農林 株式会社');
ok($zip->set_number('1058428')->is_valid_number, 'キッコーマン 株式会社');
ok($zip->set_number('1058429')->is_valid_number, '株式会社 トクヤマ');
ok($zip->set_number('1058432')->is_valid_number, '昭光通商 株式会社');
ok($zip->set_number('1058434')->is_valid_number, '独立行政法人 鉄道建設・運輸施設整備支援機構 国鉄精算事業本部');
ok($zip->set_number('1058435')->is_valid_number, '北海道新聞 東京支社');
ok($zip->set_number('1058436')->is_valid_number, '株式会社 日本教育新聞社');
ok($zip->set_number('1058437')->is_valid_number, '美浜 株式会社');
ok($zip->set_number('1058439')->is_valid_number, 'カンタス・オーストラリア航空');
ok($zip->set_number('1058440')->is_valid_number, '東京実業健康保険組合 城南支部');
ok($zip->set_number('1058441')->is_valid_number, '財団法人 ゆうちょ財団');
ok($zip->set_number('1058444')->is_valid_number, '昭和電線ホールディングス 株式会社');
ok($zip->set_number('1058445')->is_valid_number, '独立行政法人 国立印刷局');
ok($zip->set_number('1058446')->is_valid_number, '財団法人 長寿社会開発センター');
ok($zip->set_number('1058447')->is_valid_number, '高圧ガス保安協会');
ok($zip->set_number('1058448')->is_valid_number, '株式会社 永谷園');
ok($zip->set_number('1058449')->is_valid_number, '宇部興産 株式会社');
ok($zip->set_number('1058450')->is_valid_number, '積水化学工業 株式会社');
ok($zip->set_number('1058451')->is_valid_number, '森村商事 株式会社');
ok($zip->set_number('1058452')->is_valid_number, 'クオール 株式会社');
ok($zip->set_number('1058453')->is_valid_number, '独立行政法人 中小企業基盤整備機構');
ok($zip->set_number('1058455')->is_valid_number, '株式会社 角川マーケティング');
ok($zip->set_number('1058456')->is_valid_number, '日本ポラロイド (株)');
ok($zip->set_number('1058457')->is_valid_number, '日本デスコ 株式会社');
ok($zip->set_number('1058458')->is_valid_number, '岩谷産業 株式会社');
ok($zip->set_number('1058460')->is_valid_number, '沖電気工業 株式会社');
ok($zip->set_number('1058461')->is_valid_number, '学校法人 慈恵大学');
ok($zip->set_number('1058464')->is_valid_number, '三井住友ファイナンス&リース 株式会社');
ok($zip->set_number('1058465')->is_valid_number, '競馬セキュリティサービス 株式会社');
ok($zip->set_number('1058467')->is_valid_number, 'セイコーウオッチ 株式会社');
ok($zip->set_number('1058470')->is_valid_number, '国家公務員 共済組合連合会 虎の門病院');
ok($zip->set_number('1058471')->is_valid_number, '東京慈恵会医科大学附属病院');
ok($zip->set_number('1058472')->is_valid_number, '財団法人 家電製品協会');
ok($zip->set_number('1058473')->is_valid_number, '株式会社 角川マガジンズ');
ok($zip->set_number('1058479')->is_valid_number, '株式会社 間組');
ok($zip->set_number('1058480')->is_valid_number, '財団法人 ブルーシー・アンド・グリーンランド財団');
ok($zip->set_number('1058482')->is_valid_number, 'コロムビアミュージックエンタテインメント 株式会社');
ok($zip->set_number('1058483')->is_valid_number, 'カンタスエアーウエイズリミテッド');
ok($zip->set_number('1058484')->is_valid_number, 'マグレガーゴルフジャパン 株式会社');
ok($zip->set_number('1058485')->is_valid_number, '財団法人 日本不動産研究所');
ok($zip->set_number('1058486')->is_valid_number, '独立行政法人 福祉医療機構');
ok($zip->set_number('1058487')->is_valid_number, '株式会社 ポニーキャニオン');
ok($zip->set_number('1058488')->is_valid_number, '岩田地崎建設 株式会社');
ok($zip->set_number('1058505')->is_valid_number, 'セイコーホールディングス 株式会社');
ok($zip->set_number('1058507')->is_valid_number, '株式会社 長谷工コーポレーション &(株)長谷工アーベストを除くグループ会社');
ok($zip->set_number('1058509')->is_valid_number, '世紀東急工業 株式会社');
ok($zip->set_number('1058510')->is_valid_number, '美和ロック 株式会社');
ok($zip->set_number('1058511')->is_valid_number, '東京都港区役所');
ok($zip->set_number('1058512')->is_valid_number, '慶應義塾大学 薬学部');
ok($zip->set_number('1058515')->is_valid_number, '高千穂電気 株式会社');
ok($zip->set_number('1058517')->is_valid_number, '森永製菓 株式会社 首都圏統括支店');
ok($zip->set_number('1058518')->is_valid_number, '昭和電工 株式会社');
ok($zip->set_number('1058520')->is_valid_number, '株式会社 日本能率協会マネジメントセンター');
ok($zip->set_number('1058521')->is_valid_number, '日本赤十字社');
ok($zip->set_number('1058522')->is_valid_number, '社団法人 日本能率協会');
ok($zip->set_number('1058523')->is_valid_number, '全日産・一般業種 労働組合連合会(略称:日産労連)');
ok($zip->set_number('1058525')->is_valid_number, 'シナネン 株式会社');
ok($zip->set_number('1058527')->is_valid_number, '東京ガス (株)');
ok($zip->set_number('1058528')->is_valid_number, 'コスモ石油 (株)');
ok($zip->set_number('1058529')->is_valid_number, 'オックスフォード大学出版局 株式会社');
ok($zip->set_number('1058530')->is_valid_number, '社団法人 日本自動車販売協会連合会');
ok($zip->set_number('1058534')->is_valid_number, '株式会社 日本能率協会コンサルティング');
ok($zip->set_number('1058535')->is_valid_number, 'エヌ・ティ・ティ・コミュニケーションズ 株式会社');
ok($zip->set_number('1058537')->is_valid_number, '阿部電材 株式会社');
ok($zip->set_number('1058543')->is_valid_number, '株式会社 朝日工業社');
ok($zip->set_number('1058545')->is_valid_number, '株式会社 長谷工アーベスト');
ok($zip->set_number('1058546')->is_valid_number, '三菱アルミニウム 株式会社');
ok($zip->set_number('1058548')->is_valid_number, '株式会社 朝日旅行');
ok($zip->set_number('1058549')->is_valid_number, '株式会社 朝日旅行');
ok($zip->set_number('1058550')->is_valid_number, '礎会館(東京電力労働組合)');
ok($zip->set_number('1058552')->is_valid_number, '日本板硝子 株式会社');
ok($zip->set_number('1058553')->is_valid_number, 'ポケットカード 株式会社');
ok($zip->set_number('1058554')->is_valid_number, 'スカイマークエアラインズ 株式会社');
ok($zip->set_number('1058555')->is_valid_number, 'ニチアス 株式会社');
ok($zip->set_number('1058556')->is_valid_number, '大島椿 株式会社');
ok($zip->set_number('1058557')->is_valid_number, '株式会社 アドピア');
ok($zip->set_number('1058558')->is_valid_number, '東京計装 株式会社');
ok($zip->set_number('1058560')->is_valid_number, '東京プリンスホテル');
ok($zip->set_number('1058563')->is_valid_number, '東京プリンスホテル パークタワー');
ok($zip->set_number('1058567')->is_valid_number, '日昭産業 株式会社');
ok($zip->set_number('1058568')->is_valid_number, '菱三商事 株式会社');
ok($zip->set_number('1058574')->is_valid_number, '中央三井信託銀行 株式会社');
ok($zip->set_number('1058575')->is_valid_number, '株式会社 ヤナセ');
ok($zip->set_number('1058576')->is_valid_number, '株式会社 ホスピタリティ・ネットワーク');
ok($zip->set_number('1058577')->is_valid_number, 'UCC上島珈琲 株式会社 東京本部');
ok($zip->set_number('1058578')->is_valid_number, '日本ビジネスシステムズ (株)');
ok($zip->set_number('1058579')->is_valid_number, '日本マスタートラスト信託銀行 株式会社');
ok($zip->set_number('1058580')->is_valid_number, '株式会社 バンザイ');
ok($zip->set_number('1058581')->is_valid_number, 'パナソニック 株式会社 東京パナソニックビル1号館');
ok($zip->set_number('1058582')->is_valid_number, 'メルパルク TOKYO');
ok($zip->set_number('1058584')->is_valid_number, 'オイレス工業 株式会社');
ok($zip->set_number('1058585')->is_valid_number, 'NOK 株式会社');
ok($zip->set_number('1058587')->is_valid_number, 'イーグル工業 (株)');
ok($zip->set_number('1058588')->is_valid_number, '協栄電気 株式会社');
ok($zip->set_number('1058589')->is_valid_number, 'オリックス自動車 (株)');
ok($zip->set_number('1058603')->is_valid_number, '株式会社 紀文産業');
ok($zip->set_number('1058604')->is_valid_number, '共栄火災海上保険 株式会社');
ok($zip->set_number('1058606')->is_valid_number, '株式会社 日本旅行');
ok($zip->set_number('1058608')->is_valid_number, '有限会社 つきプランニング');
ok($zip->set_number('1058610')->is_valid_number, '大東京信用組合');
ok($zip->set_number('1058611')->is_valid_number, '株式会社 モーターマガジン社');
ok($zip->set_number('1058613')->is_valid_number, '電通ヤング・アンド・ルビカム 株式会社');
ok($zip->set_number('1058614')->is_valid_number, '日立金属 株式会社');
ok($zip->set_number('1058618')->is_valid_number, '株式会社 日本ジャーナル出版');
ok($zip->set_number('1058621')->is_valid_number, '第一ホテル東京');
ok($zip->set_number('1058623')->is_valid_number, '東ソー 株式会社');
ok($zip->set_number('1058624')->is_valid_number, 'TIS 株式会社');
ok($zip->set_number('1058626')->is_valid_number, '株式会社 紀文食品');
ok($zip->set_number('1058630')->is_valid_number, '古河産業 株式会社');
ok($zip->set_number('1058631')->is_valid_number, '三菱UFJリサーチ&コンサルティング 株式会社');
ok($zip->set_number('1058634')->is_valid_number, '株式会社 SUMCO');
ok($zip->set_number('1058640')->is_valid_number, 'JSR 株式会社');
ok($zip->set_number('1058642')->is_valid_number, '株式会社 コシダテック');
ok($zip->set_number('1058654')->is_valid_number, 'NTTファイナンス 株式会社');
ok($zip->set_number('1058660')->is_valid_number, '株式会社 ヤクルト本社');
ok($zip->set_number('1058665')->is_valid_number, '都築電気 株式会社');
ok($zip->set_number('1058666')->is_valid_number, '社団法人 日本港運協会');
ok($zip->set_number('1058668')->is_valid_number, '富士通エフ・アイ・ピー (株) アクティブオフィス');
ok($zip->set_number('1058670')->is_valid_number, '株式会社 ゴルフダイジェスト社');
ok($zip->set_number('1058677')->is_valid_number, 'FDK 株式会社');
ok($zip->set_number('1058678')->is_valid_number, '(株) 東京商工リサーチ');
ok($zip->set_number('1058680')->is_valid_number, '株式会社 アシェット 婦人画報社');
ok($zip->set_number('1058685')->is_valid_number, '横浜ゴム 株式会社');
ok($zip->set_number('1058686')->is_valid_number, '八洲電機 株式会社');
ok($zip->set_number('1058687')->is_valid_number, '株式会社 カナデン');
ok($zip->set_number('1058688')->is_valid_number, '株式会社 商船三井');
ok($zip->set_number('1058689')->is_valid_number, '商工組合中央金庫 東京支店');
ok($zip->set_number('1058701')->is_valid_number, '企業年金連合会');
ok($zip->set_number('1058702')->is_valid_number, '企業年金連合会');
ok($zip->set_number('1058707')->is_valid_number, '株式会社 興伸アクトサービス');
ok($zip->set_number('1058711')->is_valid_number, '株式会社 エックスワン');
ok($zip->set_number('1058712')->is_valid_number, '日立キャピタル 株式会社');
ok($zip->set_number('1058716')->is_valid_number, '住友金属鉱山 株式会社');
ok($zip->set_number('1058717')->is_valid_number, '株式会社 日立ハイテクノロジーズ');
ok($zip->set_number('1066060')->is_valid_number, '株式会社 アーキテクト');
ok($zip->set_number('1066066')->is_valid_number, '株式会社 クラップ&ウォーク');
ok($zip->set_number('1066161')->is_valid_number, '株式会社 サイバード');
ok($zip->set_number('1066188')->is_valid_number, '株式会社 エフエムジャパン');
ok($zip->set_number('1068001')->is_valid_number, 'テレビ朝日');
ok($zip->set_number('1068011')->is_valid_number, '株式会社 スペースシャワーネットワーク');
ok($zip->set_number('1068039')->is_valid_number, '株式会社 アール・エフラジオ日本');
ok($zip->set_number('1068401')->is_valid_number, '日本中央競馬会 六本木事務所');
ok($zip->set_number('1068508')->is_valid_number, '日本ルーセントテクノロジー 株式会社');
ok($zip->set_number('1068514')->is_valid_number, 'フランス大使館');
ok($zip->set_number('1068515')->is_valid_number, '港区麻布支署');
ok($zip->set_number('1068518')->is_valid_number, '株式会社 内原');
ok($zip->set_number('1068521')->is_valid_number, '株式会社 ほうらいやビル');
ok($zip->set_number('1068522')->is_valid_number, '株式会社 WDI');
ok($zip->set_number('1068532')->is_valid_number, '氷川きよしファンクラブ');
ok($zip->set_number('1068535')->is_valid_number, 'アボットジャパン 株式会社');
ok($zip->set_number('1068541')->is_valid_number, 'ハリウッド美容専門学校');
ok($zip->set_number('1068543')->is_valid_number, '有限会社 エフコミュニケイションズ');
ok($zip->set_number('1068544')->is_valid_number, '株式会社 フリップサイド');
ok($zip->set_number('1068550')->is_valid_number, '東芝シリコーン 株式会社');
ok($zip->set_number('1068551')->is_valid_number, '東通産業 株式会社');
ok($zip->set_number('1068552')->is_valid_number, '株式会社 テレビ朝日ミュージック');
ok($zip->set_number('1068553')->is_valid_number, 'アスミック・エース エンタテイメント 株式会社');
ok($zip->set_number('1068555')->is_valid_number, '日本学術会議');
ok($zip->set_number('1068556')->is_valid_number, '株式会社 シーボン');
ok($zip->set_number('1068558')->is_valid_number, '独立行政法人 国立美術館 国立新美術館');
ok($zip->set_number('1068559')->is_valid_number, 'MTV JAPAN');
ok($zip->set_number('1068560')->is_valid_number, '東京都港都税事務所');
ok($zip->set_number('1068561')->is_valid_number, '駐日フィンランド大使館');
ok($zip->set_number('1068562')->is_valid_number, '株式会社 エル');
ok($zip->set_number('1068563')->is_valid_number, '社団法人 東亜科学技術協力協会');
ok($zip->set_number('1068565')->is_valid_number, 'コロムビアミュージックエンタテインメント 株式会社');
ok($zip->set_number('1068566')->is_valid_number, 'エヌ・ティ・ティ ラーニングシステムズ 株式会社');
ok($zip->set_number('1068567')->is_valid_number, '株式会社 佐藤渡辺');
ok($zip->set_number('1068569')->is_valid_number, '統計数理研究所');
ok($zip->set_number('1068571')->is_valid_number, '株式会社 ディーエイチシー');
ok($zip->set_number('1068573')->is_valid_number, '日本モトローラ 株式会社');
ok($zip->set_number('1068576')->is_valid_number, 'マサモト 株式会社');
ok($zip->set_number('1068577')->is_valid_number, '駐日大韓民国大使館');
ok($zip->set_number('1068578')->is_valid_number, '象印マホービン 株式会社');
ok($zip->set_number('1068580')->is_valid_number, '恩賜財団 母子愛育会');
ok($zip->set_number('1068581')->is_valid_number, '医療法人財団 厚生会');
ok($zip->set_number('1068585')->is_valid_number, '在日本大韓民国民団 中央本部');
ok($zip->set_number('1068587')->is_valid_number, '株式会社 日比谷花壇');
ok($zip->set_number('1068588')->is_valid_number, '株式会社 一徳商会');
ok($zip->set_number('1068589')->is_valid_number, 'スイス大使館');
ok($zip->set_number('1068601')->is_valid_number, '日本シャクリー 株式会社');
ok($zip->set_number('1068608')->is_valid_number, '財団法人 書海社');
ok($zip->set_number('1068611')->is_valid_number, '株式会社 ユース・プランニングセンター');
ok($zip->set_number('1068616')->is_valid_number, '日本タッパーウェア 株式会社');
ok($zip->set_number('1068618')->is_valid_number, 'ノバルティスファーマー 株式会社');
ok($zip->set_number('1068620')->is_valid_number, '富士写真フイルム 株式会社');
ok($zip->set_number('1068622')->is_valid_number, 'SBIマーケティング 株式会社');
ok($zip->set_number('1068625')->is_valid_number, '財団法人 日本オペラ振興会');
ok($zip->set_number('1068626')->is_valid_number, '株式会社 ファンキー・ジャム');
ok($zip->set_number('1068630')->is_valid_number, '麻布税務署');
ok($zip->set_number('1068636')->is_valid_number, '株式会社 商業界');
ok($zip->set_number('1068639')->is_valid_number, '地方競馬全国協会');
ok($zip->set_number('1068640')->is_valid_number, '株式会社 ケンコーポレーション');
ok($zip->set_number('1068641')->is_valid_number, '株式会社 マツイ');
ok($zip->set_number('1068642')->is_valid_number, 'NTTビジュアル通信 株式会社');
ok($zip->set_number('1068644')->is_valid_number, '霊友会');
ok($zip->set_number('1068645')->is_valid_number, '株式会社 スター・チャンネル');
ok($zip->set_number('1068648')->is_valid_number, 'ピーネット通信 株式会社');
ok($zip->set_number('1068649')->is_valid_number, '社団法人 東京アメリカンクラブ');
ok($zip->set_number('1068652')->is_valid_number, 'トヨタ部品東京共販 株式会社');
ok($zip->set_number('1068655')->is_valid_number, '株式会社 東機貿');
ok($zip->set_number('1068661')->is_valid_number, '株式会社 ステレオサウンド');
ok($zip->set_number('1068665')->is_valid_number, '有限会社 エリカインターナショナル');
ok($zip->set_number('1068668')->is_valid_number, 'チューブ・ライダース');
ok($zip->set_number('1068677')->is_valid_number, '政策研究大学院大学');
ok($zip->set_number('1068681')->is_valid_number, '株式会社 興伸');
ok($zip->set_number('1068685')->is_valid_number, '興和不動産 株式会社 本店');
ok($zip->set_number('1068711')->is_valid_number, '日本アイ・ビー・エム 株式会社');
ok($zip->set_number('1068797')->is_valid_number, '株式会社 かんぽ生命 麻布支店');
ok($zip->set_number('1068797')->is_valid_number, '郵便局 株式会社 東京支社');
ok($zip->set_number('1068797')->is_valid_number, '郵便事業 株式会社 東京支社');
ok($zip->set_number('1078006')->is_valid_number, '株式会社 東京放送');
ok($zip->set_number('1078077')->is_valid_number, '伊藤忠商事 株式会社');
ok($zip->set_number('1078320')->is_valid_number, 'トーヨーマテリア 株式会社');
ok($zip->set_number('1078323')->is_valid_number, 'コナミ 株式会社');
ok($zip->set_number('1078324')->is_valid_number, '株式会社 コナミデジタルエンタテインメント');
ok($zip->set_number('1078326')->is_valid_number, 'コナミリアルエステート 株式会社');
ok($zip->set_number('1078331')->is_valid_number, 'ソフトバンクパブリッシング 株式会社');
ok($zip->set_number('1078335')->is_valid_number, '株式会社 宣伝会議(本社)');
ok($zip->set_number('1078336')->is_valid_number, '株式会社 グッデイ');
ok($zip->set_number('1078338')->is_valid_number, '衛星デジタル音楽放送 株式会社 (セント・ギガ)');
ok($zip->set_number('1078340')->is_valid_number, 'ファミリー劇場');
ok($zip->set_number('1078342')->is_valid_number, '株式会社 インターネットレボリューション');
ok($zip->set_number('1078348')->is_valid_number, '鹿島建設 株式会社 赤坂別館');
ok($zip->set_number('1078355')->is_valid_number, '株式会社 ソーゴー東京');
ok($zip->set_number('1078370')->is_valid_number, '(株) ビー・エス・ジェイ・ラジオ');
ok($zip->set_number('1078371')->is_valid_number, '学校法人 山脇学園');
ok($zip->set_number('1078373')->is_valid_number, '株式会社 日経ラジオ社');
ok($zip->set_number('1078380')->is_valid_number, '株式会社 日音');
ok($zip->set_number('1078388')->is_valid_number, '鹿島建設 株式会社 本社');
ok($zip->set_number('1078401')->is_valid_number, '株式会社 虎屋');
ok($zip->set_number('1078403')->is_valid_number, 'サントリー 株式会社 サントリーホール');
ok($zip->set_number('1078404')->is_valid_number, '日本財団');
ok($zip->set_number('1078410')->is_valid_number, '株式会社 山と渓谷社');
ok($zip->set_number('1078414')->is_valid_number, '株式会社 小松製作所');
ok($zip->set_number('1078416')->is_valid_number, '財団法人 日本建設情報総合センター');
ok($zip->set_number('1078417')->is_valid_number, '株式会社 東急エージェンシー');
ok($zip->set_number('1078419')->is_valid_number, '全国卸商業団地厚生年金基金');
ok($zip->set_number('1078420')->is_valid_number, '米国大使館');
ok($zip->set_number('1078434')->is_valid_number, 'ANAインターコンチネンタルホテル東京');
ok($zip->set_number('1078440')->is_valid_number, '財団法人 日本規格協会');
ok($zip->set_number('1078448')->is_valid_number, '株式会社 松田平田設計');
ok($zip->set_number('1078456')->is_valid_number, '日本カルミック 株式会社');
ok($zip->set_number('1078460')->is_valid_number, '株式会社 東北新社');
ok($zip->set_number('1078466')->is_valid_number, '日本国土開発 株式会社');
ok($zip->set_number('1078467')->is_valid_number, '日本国土開発 株式会社 東京支店');
ok($zip->set_number('1078477')->is_valid_number, '鹿島建設 株式会社 東京支店');
ok($zip->set_number('1078482')->is_valid_number, '株式会社 TBSサービス');
ok($zip->set_number('1078484')->is_valid_number, '八洲貿易 株式会社');
ok($zip->set_number('1078502')->is_valid_number, '鹿島建設 株式会社 KIビル');
ok($zip->set_number('1078505')->is_valid_number, '財団法人 草月会');
ok($zip->set_number('1078508')->is_valid_number, 'タカタ 株式会社');
ok($zip->set_number('1078511')->is_valid_number, '綜合警備保障 株式会社');
ok($zip->set_number('1078515')->is_valid_number, '日本サブウェイ 株式会社');
ok($zip->set_number('1078520')->is_valid_number, '株式会社 アメリア・ネットワーク');
ok($zip->set_number('1078521')->is_valid_number, '株式会社 ツムラ');
ok($zip->set_number('1078522')->is_valid_number, 'エイベックスネットワーク 株式会社');
ok($zip->set_number('1078524')->is_valid_number, '三菱地所ホーム 株式会社');
ok($zip->set_number('1078525')->is_valid_number, 'エイベックス・グループ・ホールディングス 株式会社');
ok($zip->set_number('1078527')->is_valid_number, '住金物産 株式会社');
ok($zip->set_number('1078528')->is_valid_number, 'ザ・シネマ');
ok($zip->set_number('1078530')->is_valid_number, '全国共済農業協同組合連合会');
ok($zip->set_number('1078532')->is_valid_number, '商船三井客船 株式会社');
ok($zip->set_number('1078533')->is_valid_number, '株式会社 テノックス');
ok($zip->set_number('1078543')->is_valid_number, '株式会社 青松社');
ok($zip->set_number('1078545')->is_valid_number, '中央物産 株式会社');
ok($zip->set_number('1078546')->is_valid_number, 'ハーバライフ・オブ・ジャパン 株式会社');
ok($zip->set_number('1078550')->is_valid_number, '株式会社 宣伝会議(南青山5丁目オフィス)');
ok($zip->set_number('1078551')->is_valid_number, '株式会社 三松');
ok($zip->set_number('1078552')->is_valid_number, '株式会社 アクシヴ');
ok($zip->set_number('1078556')->is_valid_number, '本田技研工業 株式会社');
ok($zip->set_number('1078557')->is_valid_number, 'エイベックス・マーケティング・コミュニケーションズ 株式会社');
ok($zip->set_number('1078558')->is_valid_number, '健康保険組合連合会');
ok($zip->set_number('1078560')->is_valid_number, '第一法規出版 株式会社');
ok($zip->set_number('1078563')->is_valid_number, '株式会社 キネマ旬報社');
ok($zip->set_number('1078565')->is_valid_number, '株式会社 生活科学研究所');
ok($zip->set_number('1078567')->is_valid_number, '株式会社 朝日データサービス');
ok($zip->set_number('1078570')->is_valid_number, 'エイベックス・ライヴ・クリエイティヴ 株式会社');
ok($zip->set_number('1078575')->is_valid_number, '株式会社 トゥーマックス');
ok($zip->set_number('1078577')->is_valid_number, 'エイベックス・エンタテインメント 株式会社');
ok($zip->set_number('1078579')->is_valid_number, '日本映画衛星放送 株式会社');
ok($zip->set_number('1078581')->is_valid_number, '(株) プレアデスセンター');
ok($zip->set_number('1078583')->is_valid_number, 'ユニバーサル ミュージック 株式会社');
ok($zip->set_number('1078585')->is_valid_number, 'ソニー生命保険 株式会社');
ok($zip->set_number('1078588')->is_valid_number, '株式会社 経済界');
ok($zip->set_number('1078589')->is_valid_number, 'エスエス製薬 株式会社');
ok($zip->set_number('1078601')->is_valid_number, '株式会社 NHK文化センター');
ok($zip->set_number('1078604')->is_valid_number, '株式会社 東京ソワール');
ok($zip->set_number('1078611')->is_valid_number, '南海辰村建設 株式会社 東京支店');
ok($zip->set_number('1078615')->is_valid_number, '株式会社 ホギメディカル');
ok($zip->set_number('1078616')->is_valid_number, 'ニッカウイスキー 株式会社');
ok($zip->set_number('1078617')->is_valid_number, '株式会社 フルハウス');
ok($zip->set_number('1078619')->is_valid_number, '株式会社 アイプラネット');
ok($zip->set_number('1078620')->is_valid_number, '株式会社 ワールド');
ok($zip->set_number('1078622')->is_valid_number, '株式会社 スタート・フロム・ゼロ');
ok($zip->set_number('1078623')->is_valid_number, '株式会社 鎌倉製作所');
ok($zip->set_number('1078625')->is_valid_number, '株式会社 ハウスオブローゼ');
ok($zip->set_number('1078627')->is_valid_number, '株式会社 スーパーネットワーク');
ok($zip->set_number('1078628')->is_valid_number, '株式会社 ヒストリーチャンネル・ジャパン');
ok($zip->set_number('1078630')->is_valid_number, '株式会社 クレヨンハウス');
ok($zip->set_number('1078631')->is_valid_number, 'サントリー 株式会社');
ok($zip->set_number('1078632')->is_valid_number, 'サントリーフーズ 株式会社');
ok($zip->set_number('1078633')->is_valid_number, 'ブラジル大使館');
ok($zip->set_number('1078636')->is_valid_number, '東海カーボン 株式会社');
ok($zip->set_number('1078638')->is_valid_number, 'かたばみ興業 株式会社');
ok($zip->set_number('1078639')->is_valid_number, '株式会社 ワーナーミュージック・ジャパン');
ok($zip->set_number('1078642')->is_valid_number, '有限会社 ウドー音楽事務所');
ok($zip->set_number('1078650')->is_valid_number, '三菱UFJ信託銀行');
ok($zip->set_number('1078655')->is_valid_number, '双日 株式会社');
ok($zip->set_number('1078667')->is_valid_number, 'ウェアーハウザー・ジャパン 株式会社');
ok($zip->set_number('1078668')->is_valid_number, '社団法人 農山漁村文化協会');
ok($zip->set_number('1078674')->is_valid_number, '株式会社 日本教文社');
ok($zip->set_number('1078676')->is_valid_number, '株式会社 興伸');
ok($zip->set_number('1078680')->is_valid_number, '帝国データバンク');
ok($zip->set_number('1078686')->is_valid_number, '株式会社 ジェーシービー 青山本社');
ok($zip->set_number('1086350')->is_valid_number, 'SMBCファイナンスサービス 株式会社');
ok($zip->set_number('1086363')->is_valid_number, 'SMBC電子債権記録 株式会社');
ok($zip->set_number('1088001')->is_valid_number, '日本電気 株式会社');
ok($zip->set_number('1088005')->is_valid_number, 'エクソンモービル 有限会社');
ok($zip->set_number('1088011')->is_valid_number, 'キヤノンマーケティングジャパン 株式会社');
ok($zip->set_number('1088020')->is_valid_number, 'アクサ生命保険 株式会社');
ok($zip->set_number('1088050')->is_valid_number, 'サクサ 株式会社');
ok($zip->set_number('1088070')->is_valid_number, 'エフエムインターウェーブ 株式会社');
ok($zip->set_number('1088071')->is_valid_number, '株式会社 ジャパンタイムズ');
ok($zip->set_number('1088080')->is_valid_number, 'クラシエホールディングス 株式会社');
ok($zip->set_number('1088088')->is_valid_number, '博報堂');
ok($zip->set_number('1088117')->is_valid_number, '株式会社 セディナ');
ok($zip->set_number('1088201')->is_valid_number, 'KDDI 株式会社');
ok($zip->set_number('1088202')->is_valid_number, 'NTTソフトウェア 株式会社');
ok($zip->set_number('1088203')->is_valid_number, '株式会社 シャルレ');
ok($zip->set_number('1088208')->is_valid_number, '豊田通商 株式会社');
ok($zip->set_number('1088210')->is_valid_number, 'ヒュー・マネジメント・ジャパン 株式会社');
ok($zip->set_number('1088211')->is_valid_number, '大東建託 株式会社');
ok($zip->set_number('1088220')->is_valid_number, '黒田電気 株式会社');
ok($zip->set_number('1088221')->is_valid_number, '株式会社 富士通パーソナルズ');
ok($zip->set_number('1088222')->is_valid_number, '椿本興業 (株) 東京本社');
ok($zip->set_number('1088228')->is_valid_number, '三菱商事 株式会社');
ok($zip->set_number('1088230')->is_valid_number, 'ダイセル化学工業 (株)');
ok($zip->set_number('1088231')->is_valid_number, 'ダイセルポリマー 株式会社');
ok($zip->set_number('1088232')->is_valid_number, 'ダイセルバリューコーティング (株)');
ok($zip->set_number('1088233')->is_valid_number, 'Y・S物流 (株)');
ok($zip->set_number('1088234')->is_valid_number, '共栄殖産 (株) 東京営業所');
ok($zip->set_number('1088241')->is_valid_number, '大塚ホールディングス 株式会社');
ok($zip->set_number('1088242')->is_valid_number, '大塚製薬 株式会社');
ok($zip->set_number('1088248')->is_valid_number, '三菱UFJリサーチ&コンサルティング 株式会社');
ok($zip->set_number('1088250')->is_valid_number, '株式会社 日立システムアンドサービス');
ok($zip->set_number('1088255')->is_valid_number, '東京入国管理局');
ok($zip->set_number('1088270')->is_valid_number, '株式会社 ソニー・コンピュータエンタテインメント');
ok($zip->set_number('1088275')->is_valid_number, '日本トーター 株式会社');
ok($zip->set_number('1088276')->is_valid_number, '法務省 入国管理局 登録課分室');
ok($zip->set_number('1088277')->is_valid_number, 'キヤノンソフトウェア 株式会社 三田事業所');
ok($zip->set_number('1088278')->is_valid_number, 'Man to Man G.com 株式会社');
ok($zip->set_number('1088280')->is_valid_number, 'ポリプラスチックス 株式会社');
ok($zip->set_number('1088282')->is_valid_number, 'ストリングスホテル東京インターコンチネンタル');
ok($zip->set_number('1088303')->is_valid_number, '住友電設 株式会社');
ok($zip->set_number('1088305')->is_valid_number, '株式会社 NECライベックス');
ok($zip->set_number('1088307')->is_valid_number, 'フジテック 株式会社 東京支社');
ok($zip->set_number('1088311')->is_valid_number, '前田機工 株式会社 東京支店');
ok($zip->set_number('1088313')->is_valid_number, '株式会社 一点');
ok($zip->set_number('1088317')->is_valid_number, 'キヤノンソフトウエア 株式会社');
ok($zip->set_number('1088320')->is_valid_number, '図書印刷 株式会社');
ok($zip->set_number('1088321')->is_valid_number, '西川計測 株式会社');
ok($zip->set_number('1088322')->is_valid_number, '双信電機 株式会社');
ok($zip->set_number('1088323')->is_valid_number, '株式会社 日産クレジット');
ok($zip->set_number('1088325')->is_valid_number, '株式会社 新進商会');
ok($zip->set_number('1088326')->is_valid_number, '全日本電機電子情報関連産業 労働組合連合会');
ok($zip->set_number('1088328')->is_valid_number, '株式会社 ゼネシス 東京支店');
ok($zip->set_number('1088329')->is_valid_number, '国際医療福祉大学附属三田病院');
ok($zip->set_number('1088331')->is_valid_number, 'シャトー三田');
ok($zip->set_number('1088333')->is_valid_number, '矢崎総業 株式会社');
ok($zip->set_number('1088334')->is_valid_number, '立川ブラインド工業 株式会社');
ok($zip->set_number('1088338')->is_valid_number, 'NECネクサソリューションズ(株)');
ok($zip->set_number('1088339')->is_valid_number, '株式会社 都イン東京');
ok($zip->set_number('1088341')->is_valid_number, '福西電機 株式会社');
ok($zip->set_number('1088345')->is_valid_number, '慶應義塾');
ok($zip->set_number('1088350')->is_valid_number, '株式会社 サニクリーン 本部');
ok($zip->set_number('1088351')->is_valid_number, '松下電工 (株) 東部電子材料営業部');
ok($zip->set_number('1088355')->is_valid_number, '株式会社 阪急交通社');
ok($zip->set_number('1088358')->is_valid_number, '財団法人 香川育英会');
ok($zip->set_number('1088360')->is_valid_number, 'DKSHジャパン 株式会社');
ok($zip->set_number('1088361')->is_valid_number, 'オーストラリア大使館 AUSTRALIAN EMBASSY');
ok($zip->set_number('1088366')->is_valid_number, '株式会社 エイ・アイ・エス');
ok($zip->set_number('1088368')->is_valid_number, 'ソラン 株式会社');
ok($zip->set_number('1088370')->is_valid_number, '株式会社 アイスター共済会 (株式会社 アイボシ)');
ok($zip->set_number('1088371')->is_valid_number, '日本電気ファクトリエンジニアリング 株式会社');
ok($zip->set_number('1088372')->is_valid_number, '社団法人 日本作業環境測定協会');
ok($zip->set_number('1088373')->is_valid_number, '宇都宮螺子 株式会社');
ok($zip->set_number('1088377')->is_valid_number, '六興電気 株式会社');
ok($zip->set_number('1088378')->is_valid_number, '廣済堂');
ok($zip->set_number('1088379')->is_valid_number, '株式会社 インボイス');
ok($zip->set_number('1088381')->is_valid_number, '株式会社 奥村組 東京支社');
ok($zip->set_number('1088383')->is_valid_number, '株式会社 長谷工コミュニティ');
ok($zip->set_number('1088384')->is_valid_number, '森永乳業 株式会社');
ok($zip->set_number('1088386')->is_valid_number, 'オックスフォード大学出版局 株式会社');
ok($zip->set_number('1088388')->is_valid_number, '横浜化成 株式会社');
ok($zip->set_number('1088389')->is_valid_number, '合成化学産業 労働組合連合');
ok($zip->set_number('1088403')->is_valid_number, '森永製菓 株式会社');
ok($zip->set_number('1088404')->is_valid_number, '三信電気 株式会社');
ok($zip->set_number('1088407')->is_valid_number, 'MMCダイヤモンドファイナンス 株式会社');
ok($zip->set_number('1088410')->is_valid_number, '三菱自動車工業 株式会社');
ok($zip->set_number('1088411')->is_valid_number, '三菱オートリース 株式会社');
ok($zip->set_number('1088412')->is_valid_number, 'マリンフーズ 株式会社');
ok($zip->set_number('1088414')->is_valid_number, '社団法人 日本建築学会');
ok($zip->set_number('1088415')->is_valid_number, '三菱化学メディア 株式会社');
ok($zip->set_number('1088416')->is_valid_number, '株式会社 コスモスイニシア');
ok($zip->set_number('1088417')->is_valid_number, '株式会社 コスモスイニシア');
ok($zip->set_number('1088420')->is_valid_number, '日本電気 株式会社');
ok($zip->set_number('1088421')->is_valid_number, '日本電気 株式会社');
ok($zip->set_number('1088423')->is_valid_number, '日本電気 株式会社');
ok($zip->set_number('1088424')->is_valid_number, '日本電気 株式会社');
ok($zip->set_number('1088425')->is_valid_number, '日本電気 株式会社');
ok($zip->set_number('1088430')->is_valid_number, '佐伯国総建設 株式会社');
ok($zip->set_number('1088432')->is_valid_number, '国土総合建設 株式会社');
ok($zip->set_number('1088439')->is_valid_number, '(株) オンワード樫山');
ok($zip->set_number('1088444')->is_valid_number, 'アプライドマテリアルズジャパン 株式会社');
ok($zip->set_number('1088448')->is_valid_number, '栗林運輸 株式会社');
ok($zip->set_number('1088451')->is_valid_number, 'イトキン 株式会社');
ok($zip->set_number('1088456')->is_valid_number, 'ケイヒン 株式会社');
ok($zip->set_number('1088466')->is_valid_number, '日本カーバイド工業 株式会社 東京支店');
ok($zip->set_number('1088467')->is_valid_number, '株式会社 荏原電産');
ok($zip->set_number('1088474')->is_valid_number, '日東通建 株式会社');
ok($zip->set_number('1088477')->is_valid_number, '東京海洋大学');
ok($zip->set_number('1088478')->is_valid_number, '大同特殊鋼 株式会社 東京本社');
ok($zip->set_number('1088484')->is_valid_number, '株式会社 ジュン');
ok($zip->set_number('1088485')->is_valid_number, '株式会社 報知新聞社');
ok($zip->set_number('1088501')->is_valid_number, '東洋水産 株式会社');
ok($zip->set_number('1088502')->is_valid_number, '株式会社 大林組 東京本社 品川事務所');
ok($zip->set_number('1088503')->is_valid_number, 'サイクルテレホン事務センター');
ok($zip->set_number('1088505')->is_valid_number, '株式会社 エヌ・ティ・ティ・データ通信');
ok($zip->set_number('1088506')->is_valid_number, '三菱レイヨン 株式会社');
ok($zip->set_number('1088509')->is_valid_number, '日本エア・リキード 株式会社');
ok($zip->set_number('1088510')->is_valid_number, '株式会社 トーメンエレクトロニクス');
ok($zip->set_number('1088512')->is_valid_number, '東京コカコーラボトリング 株式会社');
ok($zip->set_number('1088515')->is_valid_number, 'ネッツトヨタ東京 株式会社');
ok($zip->set_number('1088518')->is_valid_number, 'ラオックス 株式会社');
ok($zip->set_number('1088520')->is_valid_number, '株式会社 タツノ・メカトロニクス');
ok($zip->set_number('1088523')->is_valid_number, '太洋日産自動車販売 株式会社');
ok($zip->set_number('1088525')->is_valid_number, '伊藤忠エネクス 株式会社');
ok($zip->set_number('1088530')->is_valid_number, '監査法人 トーマツ');
ok($zip->set_number('1088532')->is_valid_number, 'あすか製薬 株式会社');
ok($zip->set_number('1088533')->is_valid_number, '株式会社 関電工');
ok($zip->set_number('1088536')->is_valid_number, '株式会社 トッパン・コスモ');
ok($zip->set_number('1088539')->is_valid_number, '住友電気工業 株式会社');
ok($zip->set_number('1088540')->is_valid_number, '株式会社 ダイトーコーポレーション');
ok($zip->set_number('1088543')->is_valid_number, '中野冷機 株式会社');
ok($zip->set_number('1088544')->is_valid_number, '安藤建設 株式会社');
ok($zip->set_number('1088545')->is_valid_number, '株式会社 タカマコンペテイションプロダクト');
ok($zip->set_number('1088547')->is_valid_number, '港区 芝浦港南地区総合支所');
ok($zip->set_number('1088548')->is_valid_number, '芝浦工業大学');
ok($zip->set_number('1088550')->is_valid_number, '五十嵐冷蔵 株式会社');
ok($zip->set_number('1088551')->is_valid_number, '沖電気工業 株式会社');
ok($zip->set_number('1088552')->is_valid_number, '株式会社 スマイルドラッグ');
ok($zip->set_number('1088553')->is_valid_number, '株式会社 ITサービス 芝浦事業所');
ok($zip->set_number('1088555')->is_valid_number, '日本シティメディア 株式会社');
ok($zip->set_number('1088556')->is_valid_number, '日本電気 (株)');
ok($zip->set_number('1088557')->is_valid_number, '日本電気 株式会社');
ok($zip->set_number('1088558')->is_valid_number, '日本電気 株式会社');
ok($zip->set_number('1088559')->is_valid_number, '三菱化学メディエンス 株式会社');
ok($zip->set_number('1088561')->is_valid_number, '日本タイムシエア 株式会社');
ok($zip->set_number('1088562')->is_valid_number, '礎会館(東京電力労働組合)');
ok($zip->set_number('1088564')->is_valid_number, '(株) コスモ総合研究所');
ok($zip->set_number('1088565')->is_valid_number, '株式会社 乃村工藝社');
ok($zip->set_number('1088566')->is_valid_number, '社団法人 全国消費生活相談員協会');
ok($zip->set_number('1088567')->is_valid_number, '株式会社 ホテル京急 ホテルパシフィック東京');
ok($zip->set_number('1088568')->is_valid_number, 'ヤマハ 株式会社 東京営業事務所');
ok($zip->set_number('1088570')->is_valid_number, 'フジテックエンジニアリング 株式会社');
ok($zip->set_number('1088571')->is_valid_number, '株式会社 JIPMソリューション');
ok($zip->set_number('1088573')->is_valid_number, '株式会社 ドウシシャ');
ok($zip->set_number('1088575')->is_valid_number, 'ユニ・チャーム 株式会社');
ok($zip->set_number('1088578')->is_valid_number, 'フジテック 株式会社 東京支社');
ok($zip->set_number('1088580')->is_valid_number, '東芝キヤリア 株式会社');
ok($zip->set_number('1088581')->is_valid_number, '東京都 港区役所高輪支所');
ok($zip->set_number('1088583')->is_valid_number, '社団法人 全国社会保険協会連合会');
ok($zip->set_number('1088585')->is_valid_number, '社団法人 日本フラワーデザイナー協会');
ok($zip->set_number('1088586')->is_valid_number, '日本トムソン 株式会社');
ok($zip->set_number('1088588')->is_valid_number, 'テクマトリックス 株式会社');
ok($zip->set_number('1088601')->is_valid_number, '日本特殊陶業 株式会社');
ok($zip->set_number('1088602')->is_valid_number, '国民生活センター');
ok($zip->set_number('1088606')->is_valid_number, '東京船員保険病院');
ok($zip->set_number('1088607')->is_valid_number, '財団法人 日本ユニセフ協会');
ok($zip->set_number('1088608')->is_valid_number, 'ミノルタ (株) 東京支社');
ok($zip->set_number('1088610')->is_valid_number, '日本コムシス 株式会社');
ok($zip->set_number('1088611')->is_valid_number, '品川プリンスホテル');
ok($zip->set_number('1088612')->is_valid_number, '高輪プリンスホテル 新高輪プリンスホテル');
ok($zip->set_number('1088615')->is_valid_number, '株式会社 レアソン');
ok($zip->set_number('1088616')->is_valid_number, '社会保険病院 健康保険組合');
ok($zip->set_number('1088618')->is_valid_number, 'ミノルタ販売 (株)');
ok($zip->set_number('1088620')->is_valid_number, '図書印刷 株式会社');
ok($zip->set_number('1088621')->is_valid_number, 'ソニー 株式会社 高輪オフィス');
ok($zip->set_number('1088622')->is_valid_number, '品川税務署');
ok($zip->set_number('1088628')->is_valid_number, '株式会社 二葉');
ok($zip->set_number('1088632')->is_valid_number, '株式会社 近鉄ホテルシステムズ');
ok($zip->set_number('1088633')->is_valid_number, '株式会社 ヤマプラス');
ok($zip->set_number('1088635')->is_valid_number, '(株) ウェルストーン・ヴォイス');
ok($zip->set_number('1088636')->is_valid_number, '明治学院大学');
ok($zip->set_number('1088637')->is_valid_number, '国立環境研究所 廃棄物研究部');
ok($zip->set_number('1088638')->is_valid_number, 'アクサ損害保険 株式会社');
ok($zip->set_number('1088640')->is_valid_number, '株式会社 都ホテル東京');
ok($zip->set_number('1088641')->is_valid_number, '学校法人 北里研究所');
ok($zip->set_number('1088642')->is_valid_number, '北里研究所病院');
ok($zip->set_number('1088644')->is_valid_number, '株式会社 IMAGICA ティーヴィ');
ok($zip->set_number('1088646')->is_valid_number, '株式会社 日経BP');
ok($zip->set_number('1088648')->is_valid_number, 'サクサビジネスシステム 株式会社');
ok($zip->set_number('1088650')->is_valid_number, 'さくら情報システム 株式会社');
ok($zip->set_number('1088701')->is_valid_number, '海外新聞普及 株式会社');
ok($zip->set_number('1088702')->is_valid_number, 'テイ・エヌ・テイ・エクスプレス 株式会社');
ok($zip->set_number('1088703')->is_valid_number, 'シティバンク銀行 株式会社');
ok($zip->set_number('1088707')->is_valid_number, '財団法人 日本モーターボート競走会');
ok($zip->set_number('1088710')->is_valid_number, 'コクヨ (株) 品川オフィス');
ok($zip->set_number('1088713')->is_valid_number, '東京トヨペット 株式会社');
ok($zip->set_number('1088723')->is_valid_number, '小糸工業 株式会社');
ok($zip->set_number('1098792')->is_valid_number, '東京サービスセンター');
ok($zip->set_number('1108408')->is_valid_number, '栄研化学 株式会社');
ok($zip->set_number('1108501')->is_valid_number, '野村證券 株式会社 上野支店');
ok($zip->set_number('1108502')->is_valid_number, '株式会社 丸井 上野店');
ok($zip->set_number('1108503')->is_valid_number, '株式会社 松坂屋 上野店');
ok($zip->set_number('1108505')->is_valid_number, '株式会社 真多呂人形');
ok($zip->set_number('1108507')->is_valid_number, '株式会社 ヨシダ');
ok($zip->set_number('1108508')->is_valid_number, '児玉化学工業 株式会社');
ok($zip->set_number('1108509')->is_valid_number, '橋本産業 株式会社');
ok($zip->set_number('1108510')->is_valid_number, '株式会社 下谷金属');
ok($zip->set_number('1108511')->is_valid_number, '株式会社 トータルアクセスシャトル');
ok($zip->set_number('1108512')->is_valid_number, 'あいおい損害保険 株式会社');
ok($zip->set_number('1108513')->is_valid_number, '株式会社 モリタ');
ok($zip->set_number('1108515')->is_valid_number, '大和證券 株式会社 上野支店');
ok($zip->set_number('1108517')->is_valid_number, 'ヒカリ興業 株式会社');
ok($zip->set_number('1108518')->is_valid_number, '株式会社 一富士');
ok($zip->set_number('1108520')->is_valid_number, '株式会社 理研グリーン');
ok($zip->set_number('1108521')->is_valid_number, '株式会社 極東商会');
ok($zip->set_number('1108522')->is_valid_number, '株式会社 吉池');
ok($zip->set_number('1108523')->is_valid_number, '株式会社 高貴ワールドビューティー');
ok($zip->set_number('1108524')->is_valid_number, '朝日生命保険 相互会社 東京東統括支社');
ok($zip->set_number('1108527')->is_valid_number, '株式会社 銀座セントメリーフジヤマ');
ok($zip->set_number('1108528')->is_valid_number, '財団法人 郵政弘済会 関東地方本部');
ok($zip->set_number('1108530')->is_valid_number, '株式会社 日本歯科工業社');
ok($zip->set_number('1108531')->is_valid_number, '株式会社 台和');
ok($zip->set_number('1108532')->is_valid_number, '株式会社 文昌堂');
ok($zip->set_number('1108533')->is_valid_number, '株式会社 新生銀行 上野支店');
ok($zip->set_number('1108534')->is_valid_number, '三洋電機 株式会社');
ok($zip->set_number('1108535')->is_valid_number, '社団法人 産業環境管理協会');
ok($zip->set_number('1108536')->is_valid_number, 'オリエンタルモーター 株式会社');
ok($zip->set_number('1108537')->is_valid_number, '(株) 鈴乃屋');
ok($zip->set_number('1108539')->is_valid_number, '株式会社 上野風月堂');
ok($zip->set_number('1108540')->is_valid_number, '財団法人 日本船員住宅協会');
ok($zip->set_number('1108541')->is_valid_number, '(株) アブアブ赤札堂');
ok($zip->set_number('1108543')->is_valid_number, '株式会社 和光ハトヤ');
ok($zip->set_number('1108544')->is_valid_number, '千代田火災海上保険 株式会社 関東第一業総部');
ok($zip->set_number('1108546')->is_valid_number, '株式会社 ナガホリ');
ok($zip->set_number('1108548')->is_valid_number, '株式会社 酒悦');
ok($zip->set_number('1108549')->is_valid_number, '(株) 丹青社');
ok($zip->set_number('1108550')->is_valid_number, '三共スポーツ 株式会社');
ok($zip->set_number('1108553')->is_valid_number, '株式会社 わかば');
ok($zip->set_number('1108555')->is_valid_number, 'サンデン 株式会社 東京本社');
ok($zip->set_number('1108558')->is_valid_number, '株式会社 ウイン・インターナショナル');
ok($zip->set_number('1108559')->is_valid_number, 'イン・ステップ 有限会社');
ok($zip->set_number('1108560')->is_valid_number, '凸版印刷 株式会社');
ok($zip->set_number('1108561')->is_valid_number, '東京法務局 台東出張所');
ok($zip->set_number('1108562')->is_valid_number, '日本リテイルシステム 株式会社');
ok($zip->set_number('1108565')->is_valid_number, '東日本電信電話 株式会社 上野支店');
ok($zip->set_number('1108566')->is_valid_number, '藤川伝導機 株式会社');
ok($zip->set_number('1108567')->is_valid_number, '社団法人 日本動物園水族館協会');
ok($zip->set_number('1108573')->is_valid_number, '三菱樹脂 株式会社 関東支社');
ok($zip->set_number('1108575')->is_valid_number, '山田マシンツール 株式会社');
ok($zip->set_number('1108576')->is_valid_number, '昭和室内工業 (株)');
ok($zip->set_number('1108577')->is_valid_number, '千代田機工 株式会社');
ok($zip->set_number('1108578')->is_valid_number, '株式会社 内外出版社');
ok($zip->set_number('1108579')->is_valid_number, '株式会社 近畿日本ツーリスト 東京事務センター');
ok($zip->set_number('1108580')->is_valid_number, '東京アール・ビー商事 株式会社');
ok($zip->set_number('1108582')->is_valid_number, 'YKK ファスニングプロダクツ販売 株式会社');
ok($zip->set_number('1108583')->is_valid_number, '株式会社 多慶屋');
ok($zip->set_number('1108584')->is_valid_number, '株式会社 富士商会');
ok($zip->set_number('1108586')->is_valid_number, '東和通商 株式会社');
ok($zip->set_number('1108588')->is_valid_number, '神田電子工業 株式会社');
ok($zip->set_number('1108602')->is_valid_number, '警視庁 上野警察署');
ok($zip->set_number('1108603')->is_valid_number, '株式会社 関東松坂屋ストア');
ok($zip->set_number('1108605')->is_valid_number, '日本国際ボランティアセンター');
ok($zip->set_number('1108609')->is_valid_number, '上野公共職業安定所');
ok($zip->set_number('1108610')->is_valid_number, '共立食品 株式会社');
ok($zip->set_number('1108613')->is_valid_number, 'ジャパンギャランティサービス 株式会社');
ok($zip->set_number('1108614')->is_valid_number, '東京地下鉄 株式会社');
ok($zip->set_number('1108615')->is_valid_number, '東京都台東区役所');
ok($zip->set_number('1108617')->is_valid_number, '株式会社 ホッタ');
ok($zip->set_number('1108618')->is_valid_number, 'J-NET中央 株式会社');
ok($zip->set_number('1108619')->is_valid_number, 'ウインドミル 株式会社');
ok($zip->set_number('1108620')->is_valid_number, '新明和工業 株式会社 パーキングシステム事業部');
ok($zip->set_number('1108621')->is_valid_number, '株式会社 シー・アイ・シー');
ok($zip->set_number('1108622')->is_valid_number, 'プラチナ萬年筆 株式会社');
ok($zip->set_number('1108624')->is_valid_number, '西野商事 株式会社');
ok($zip->set_number('1108625')->is_valid_number, '株式会社 笠倉出版社');
ok($zip->set_number('1108626')->is_valid_number, '社団法人 日本ジュエリー協会');
ok($zip->set_number('1108628')->is_valid_number, '大同生命保険 相互会社 上野支社');
ok($zip->set_number('1108630')->is_valid_number, '金方堂松本工業 株式会社');
ok($zip->set_number('1108635')->is_valid_number, '中央日立家電 株式会社');
ok($zip->set_number('1108638')->is_valid_number, 'ジェイ・アキュレート 株式会社');
ok($zip->set_number('1108642')->is_valid_number, '学校法人 上野学園');
ok($zip->set_number('1108644')->is_valid_number, 'ヨシディア 株式会社');
ok($zip->set_number('1108645')->is_valid_number, '財団法人 ライフ・エクステンション研究所 附属 永寿総合病院');
ok($zip->set_number('1108653')->is_valid_number, '日本通信紙 株式会社');
ok($zip->set_number('1108654')->is_valid_number, '株式会社 インターコム');
ok($zip->set_number('1108660')->is_valid_number, '日本年金機構 上野年金事務所');
ok($zip->set_number('1108661')->is_valid_number, '勝村建設 株式会社');
ok($zip->set_number('1108662')->is_valid_number, '学校法人 華学園 華服飾専門学校 華調理師専門学校 華学園栄養専門学校 華学園オーケービジネス専門学校');
ok($zip->set_number('1108665')->is_valid_number, '株式会社 タジマヤ');
ok($zip->set_number('1108669')->is_valid_number, '株式会社 鈴木産業');
ok($zip->set_number('1108671')->is_valid_number, '株式会社 萬代');
ok($zip->set_number('1108673')->is_valid_number, '丸喜 株式会社 東京支店');
ok($zip->set_number('1108675')->is_valid_number, '株式会社 シモダイラ');
ok($zip->set_number('1108676')->is_valid_number, '財団法人 自然環境研究センター');
ok($zip->set_number('1108677')->is_valid_number, '三輝工業 株式会社');
ok($zip->set_number('1108678')->is_valid_number, '警視庁 下谷警察署');
ok($zip->set_number('1108680')->is_valid_number, 'アトムリビンテック 株式会社');
ok($zip->set_number('1108681')->is_valid_number, '株式会社 ムトウ 東京事業本部');
ok($zip->set_number('1108685')->is_valid_number, '株式会社 マシモ');
ok($zip->set_number('1108686')->is_valid_number, '日本エアーテック 株式会社');
ok($zip->set_number('1108687')->is_valid_number, '(財)東京菓子会館');
ok($zip->set_number('1108688')->is_valid_number, '株式会社 ムトウ 東京SPDセンター');
ok($zip->set_number('1108697')->is_valid_number, 'サンスター文具 株式会社');
ok($zip->set_number('1108701')->is_valid_number, '柴田科学 株式会社');
ok($zip->set_number('1108706')->is_valid_number, '日本電設工業 株式会社');
ok($zip->set_number('1108708')->is_valid_number, '日本郵政グループ労働組合');
ok($zip->set_number('1108712')->is_valid_number, '東京国立博物館');
ok($zip->set_number('1108713')->is_valid_number, '独立行政法人 文化財研究所 東京文化財研究所');
ok($zip->set_number('1108714')->is_valid_number, '東京芸術大学');
ok($zip->set_number('1108715')->is_valid_number, '(株) 精養軒');
ok($zip->set_number('1108716')->is_valid_number, '東京文化会館');
ok($zip->set_number('1108721')->is_valid_number, '株式会社 東和エンジニアリング');
ok($zip->set_number('1108722')->is_valid_number, '全国新聞情報農業 協同組合連合会 (日本農業新聞)');
ok($zip->set_number('1108723')->is_valid_number, '正栄食品工業 株式会社');
ok($zip->set_number('1108725')->is_valid_number, '東洋ロープ 株式会社');
ok($zip->set_number('1108733')->is_valid_number, '株式会社 三共 東京支店');
ok($zip->set_number('1108736')->is_valid_number, '日水製薬 株式会社');
ok($zip->set_number('1108740')->is_valid_number, '中央三井信託銀行 (株) 上野支店');
ok($zip->set_number('1108745')->is_valid_number, '第一生命保険 相互会社 上野総合支社');
ok($zip->set_number('1108750')->is_valid_number, '株式会社 キムラヤ');
ok($zip->set_number('1108755')->is_valid_number, 'マルピー薬品 株式会社 東京事務所');
ok($zip->set_number('1108757')->is_valid_number, '株式会社 近畿日本ツーリスト 東京事務センター');
ok($zip->set_number('1108780')->is_valid_number, '株式会社 落合');
ok($zip->set_number('1108782')->is_valid_number, 'クミアイ化学工業 株式会社');
ok($zip->set_number('1108787')->is_valid_number, '商工中金 上野支店');
ok($zip->set_number('1108807')->is_valid_number, '株式会社 オンダ');
ok($zip->set_number('1108808')->is_valid_number, 'マツ六 株式会社 東京支社');
ok($zip->set_number('1118081')->is_valid_number, '株式会社 バンダイ');
ok($zip->set_number('1118501')->is_valid_number, '浅草警察署');
ok($zip->set_number('1118502')->is_valid_number, 'エスエスユニオン 株式会社');
ok($zip->set_number('1118505')->is_valid_number, 'ハインツ日本 株式会社');
ok($zip->set_number('1118506')->is_valid_number, 'キング工業 株式会社');
ok($zip->set_number('1118507')->is_valid_number, '勝村建設 株式会社');
ok($zip->set_number('1118508')->is_valid_number, '日新明弘テック 株式会社');
ok($zip->set_number('1118510')->is_valid_number, '株式会社 十字屋');
ok($zip->set_number('1118511')->is_valid_number, '滝川 株式会社');
ok($zip->set_number('1118512')->is_valid_number, 'マドラス 株式会社');
ok($zip->set_number('1118515')->is_valid_number, '株式会社 吉徳');
ok($zip->set_number('1118518')->is_valid_number, '株式会社 木馬');
ok($zip->set_number('1118521')->is_valid_number, '東都フジクラ販売 株式会社');
ok($zip->set_number('1118522')->is_valid_number, '日本マタイ 株式会社');
ok($zip->set_number('1118525')->is_valid_number, '株式会社 ブンカ');
ok($zip->set_number('1118530')->is_valid_number, '東京電子機械工業 健康保険組合');
ok($zip->set_number('1118531')->is_valid_number, '株式会社 東京ユニコム');
ok($zip->set_number('1118532')->is_valid_number, '協同組合 趣味の百撰会');
ok($zip->set_number('1118533')->is_valid_number, '株式会社 ノダ');
ok($zip->set_number('1118534')->is_valid_number, 'セイコーミシン 株式会社');
ok($zip->set_number('1118539')->is_valid_number, '株式会社 シタシオンジャパン');
ok($zip->set_number('1118543')->is_valid_number, '株式会社 壽商会');
ok($zip->set_number('1118555')->is_valid_number, '株式会社 エポック社');
ok($zip->set_number('1118556')->is_valid_number, '株式会社 ジェイ・エス・ティ');
ok($zip->set_number('1118558')->is_valid_number, 'バンダイビジュアル 株式会社');
ok($zip->set_number('1118560')->is_valid_number, 'ミツワ 株式会社');
ok($zip->set_number('1118561')->is_valid_number, '株式会社 ケーブル・アンド・ワイヤレス・アイディーシー・エスアイ');
ok($zip->set_number('1118566')->is_valid_number, '松本徽章工業 株式会社');
ok($zip->set_number('1118567')->is_valid_number, '株式会社 コマキ楽器');
ok($zip->set_number('1118575')->is_valid_number, 'モリト 株式会社 東京支社');
ok($zip->set_number('1118577')->is_valid_number, 'トッパンレーベル 株式会社');
ok($zip->set_number('1118580')->is_valid_number, '株式会社 エスエスケイ 東京支店');
ok($zip->set_number('1118585')->is_valid_number, '衛星デジタル音楽放送 株式会社');
ok($zip->set_number('1118588')->is_valid_number, '株式会社 高山');
ok($zip->set_number('1118602')->is_valid_number, '浅草税務署');
ok($zip->set_number('1118605')->is_valid_number, 'ファースト・ファシリティーズ 株式会社');
ok($zip->set_number('1118606')->is_valid_number, '東京都台東都税事務所');
ok($zip->set_number('1118608')->is_valid_number, '株式会社 ベンチャー・リンク');
ok($zip->set_number('1118610')->is_valid_number, '株式会社 コロンブス');
ok($zip->set_number('1118611')->is_valid_number, '株式会社 東京文具共和会館');
ok($zip->set_number('1118612')->is_valid_number, 'カネダ 株式会社');
ok($zip->set_number('1118615')->is_valid_number, '株式会社 リンク総研');
ok($zip->set_number('1118618')->is_valid_number, '株式会社 エポック社');
ok($zip->set_number('1118620')->is_valid_number, '株式会社 コバヤシ');
ok($zip->set_number('1118621')->is_valid_number, '台東区生涯学習センター');
ok($zip->set_number('1118622')->is_valid_number, 'ミツワ産業 株式会社');
ok($zip->set_number('1118625')->is_valid_number, '日本コパック 株式会社');
ok($zip->set_number('1118628')->is_valid_number, '有限会社 ニイミ洋食器店');
ok($zip->set_number('1118630')->is_valid_number, '東和エンタープライズ 株式会社');
ok($zip->set_number('1118631')->is_valid_number, '日本電子総合サービス 株式会社');
ok($zip->set_number('1118633')->is_valid_number, 'アクサ損害保険 株式会社');
ok($zip->set_number('1118637')->is_valid_number, '小野田ケミコ 株式会社');
ok($zip->set_number('1118639')->is_valid_number, '三平建設 株式会社');
ok($zip->set_number('1118640')->is_valid_number, '株式会社 内田');
ok($zip->set_number('1118642')->is_valid_number, '株式会社 トークツ');
ok($zip->set_number('1118650')->is_valid_number, '緑川化成工業 株式会社');
ok($zip->set_number('1118655')->is_valid_number, 'エース 株式会社 東京店');
ok($zip->set_number('1118656')->is_valid_number, '永寿総合病院');
ok($zip->set_number('1118661')->is_valid_number, '株式会社 マルショウエンドウ');
ok($zip->set_number('1118666')->is_valid_number, 'レデイマドラス 株式会社');
ok($zip->set_number('1118676')->is_valid_number, '株式会社 アルメックス');
ok($zip->set_number('1118677')->is_valid_number, '首都圏新都市鉄道 株式会社');
ok($zip->set_number('1118678')->is_valid_number, '株式会社 増田屋コーポレーション');
ok($zip->set_number('1118681')->is_valid_number, '株式会社 エポック社');
ok($zip->set_number('1118683')->is_valid_number, '中部物産貿易 株式会社 東京支店');
ok($zip->set_number('1118686')->is_valid_number, '株式会社 神栄');
ok($zip->set_number('1118688')->is_valid_number, '株式会社 盛光');
ok($zip->set_number('1118701')->is_valid_number, '大和証券 雷門支店');
ok($zip->set_number('1118707')->is_valid_number, '株式会社 東京デジタルホン');
ok($zip->set_number('1118708')->is_valid_number, '野村ファンドネット証券 株式会社');
ok($zip->set_number('1118710')->is_valid_number, 'ユウユウ〈株式会社ユウメディア〉');
ok($zip->set_number('1118711')->is_valid_number, '株式会社 陶漆芸巧');
ok($zip->set_number('1118721')->is_valid_number, '株式会社 シンエイ');
ok($zip->set_number('1118755')->is_valid_number, '株式会社 筑摩書房');
ok($zip->set_number('1118765')->is_valid_number, '浅草ビューホテル');
ok($zip->set_number('1118788')->is_valid_number, '首都圏ネットワークセンター');
ok($zip->set_number('1118798')->is_valid_number, '日本郵政 株式会社 CRE部門 ファシリティマネジメント部');
ok($zip->set_number('1128001')->is_valid_number, '株式会社 講談社');
ok($zip->set_number('1128011')->is_valid_number, '株式会社 光文社');
ok($zip->set_number('1128088')->is_valid_number, 'エーザイ 株式会社');
ok($zip->set_number('1128501')->is_valid_number, '共同印刷 株式会社');
ok($zip->set_number('1128502')->is_valid_number, 'キネマ旬報社');
ok($zip->set_number('1128503')->is_valid_number, '中央職業能力開発協会');
ok($zip->set_number('1128505')->is_valid_number, '日本建設 株式会社 東京支店');
ok($zip->set_number('1128506')->is_valid_number, '財団法人 加越能育英社 明倫学館');
ok($zip->set_number('1128508')->is_valid_number, '株式会社 HS情報システムズ');
ok($zip->set_number('1128509')->is_valid_number, 'レック 株式会社');
ok($zip->set_number('1128510')->is_valid_number, '日立キャピタル 株式会社');
ok($zip->set_number('1128511')->is_valid_number, '明星電気 株式会社');
ok($zip->set_number('1128512')->is_valid_number, '株式会社 チャイルド本社');
ok($zip->set_number('1128514')->is_valid_number, '株式会社 キッズステーション');
ok($zip->set_number('1128515')->is_valid_number, '株式会社 ディスコ');
ok($zip->set_number('1128516')->is_valid_number, '株式会社 瑞穂');
ok($zip->set_number('1128522')->is_valid_number, '株式会社 ローム');
ok($zip->set_number('1128524')->is_valid_number, 'カテナ (株) 水道橋オフィス');
ok($zip->set_number('1128528')->is_valid_number, '大新東 株式会社');
ok($zip->set_number('1128531')->is_valid_number, '凸版印刷 (株) パッケージ事業本部');
ok($zip->set_number('1128533')->is_valid_number, '成美堂出版 株式会社');
ok($zip->set_number('1128538')->is_valid_number, '株式会社 大阪屋 東京本部');
ok($zip->set_number('1128540')->is_valid_number, '株式会社 太洋社');
ok($zip->set_number('1128541')->is_valid_number, '株式会社 精案社 DMセンター');
ok($zip->set_number('1128548')->is_valid_number, '浜井電球工業 株式会社');
ok($zip->set_number('1128550')->is_valid_number, '東京都文京都税事務所');
ok($zip->set_number('1128551')->is_valid_number, '中央大学 理工学部');
ok($zip->set_number('1128555')->is_valid_number, '文京区役所');
ok($zip->set_number('1128556')->is_valid_number, '株式会社 ウィズマン');
ok($zip->set_number('1128557')->is_valid_number, '有限会社 ウィズアドバタイジング');
ok($zip->set_number('1128558')->is_valid_number, '小石川税務署');
ok($zip->set_number('1128560')->is_valid_number, 'NECネッツエスアイ 株式会社');
ok($zip->set_number('1128562')->is_valid_number, '東京ドームホテル');
ok($zip->set_number('1128563')->is_valid_number, '日立建機 (株)');
ok($zip->set_number('1128566')->is_valid_number, '鹿島道路 株式会社');
ok($zip->set_number('1128569')->is_valid_number, '全逓会館');
ok($zip->set_number('1128570')->is_valid_number, '独立行政法人 住宅金融支援機構');
ok($zip->set_number('1128572')->is_valid_number, '株式会社 富士通ビジネスシステム');
ok($zip->set_number('1128573')->is_valid_number, '中央労働基準監督署');
ok($zip->set_number('1128574')->is_valid_number, '昭和リース 株式会社');
ok($zip->set_number('1128575')->is_valid_number, '株式会社 東京ドーム');
ok($zip->set_number('1128576')->is_valid_number, '五洋建設 株式会社');
ok($zip->set_number('1128580')->is_valid_number, '株式会社 芳文社');
ok($zip->set_number('1128582')->is_valid_number, '商船三井ロジスティクス 株式会社');
ok($zip->set_number('1128585')->is_valid_number, '学校法人 拓殖大学(文京キャンパス)');
ok($zip->set_number('1128601')->is_valid_number, '宝くじ業務センター 通信販売係');
ok($zip->set_number('1128606')->is_valid_number, '東洋大学');
ok($zip->set_number('1128607')->is_valid_number, '京北学園');
ok($zip->set_number('1128610')->is_valid_number, 'お茶の水女子大学');
ok($zip->set_number('1128611')->is_valid_number, '裁判所 裁判書記官研修所');
ok($zip->set_number('1128612')->is_valid_number, '京華学園');
ok($zip->set_number('1128618')->is_valid_number, '株式会社 ヨツワ産業');
ok($zip->set_number('1128620')->is_valid_number, '文京カテリーナ');
ok($zip->set_number('1128622')->is_valid_number, 'アカツキ産業 株式会社');
ok($zip->set_number('1128625')->is_valid_number, '学校法人 貞静学園');
ok($zip->set_number('1128627')->is_valid_number, '全国森林関連産業労働者共済 生活協同組合');
ok($zip->set_number('1128629')->is_valid_number, '学校法人 跡見学園');
ok($zip->set_number('1128630')->is_valid_number, '貞静学園短期大学');
ok($zip->set_number('1128632')->is_valid_number, '(株) 図書館流通センター');
ok($zip->set_number('1128633')->is_valid_number, '(株) コア・ブレイン');
ok($zip->set_number('1128634')->is_valid_number, '株式会社 村田金箔');
ok($zip->set_number('1128635')->is_valid_number, '株式会社 文渓堂');
ok($zip->set_number('1128642')->is_valid_number, '住商マシネックス 株式会社');
ok($zip->set_number('1128644')->is_valid_number, '音羽女子学生会館');
ok($zip->set_number('1128650')->is_valid_number, '全薬工業 株式会社');
ok($zip->set_number('1128651')->is_valid_number, '(株) エーオーエーアオバ');
ok($zip->set_number('1128652')->is_valid_number, '講談社インターナショナル 株式会社');
ok($zip->set_number('1128654')->is_valid_number, 'プラス 株式会社');
ok($zip->set_number('1128655')->is_valid_number, '(株) 二見書房');
ok($zip->set_number('1128657')->is_valid_number, '加賀電子 株式会社');
ok($zip->set_number('1128660')->is_valid_number, 'センコー商事 株式会社');
ok($zip->set_number('1128662')->is_valid_number, '古久根建設 株式会社');
ok($zip->set_number('1128663')->is_valid_number, 'ニチバン 株式会社');
ok($zip->set_number('1128664')->is_valid_number, '藤田観光 株式会社');
ok($zip->set_number('1128667')->is_valid_number, 'フォーシーズンズホテル椿山荘東京');
ok($zip->set_number('1128668')->is_valid_number, '株式会社 アイ・エヌ・エー');
ok($zip->set_number('1128670')->is_valid_number, 'Jフォン');
ok($zip->set_number('1128671')->is_valid_number, '住宅金融支援機構 首都圏支店');
ok($zip->set_number('1128677')->is_valid_number, '日本興亜損害保険 (株)');
ok($zip->set_number('1128678')->is_valid_number, '日本総合住生活 株式会社 東京支社');
ok($zip->set_number('1128680')->is_valid_number, '藤田観光 株式会社 椿山荘事業所');
ok($zip->set_number('1128681')->is_valid_number, '日本女子大学');
ok($zip->set_number('1128682')->is_valid_number, '和敬塾');
ok($zip->set_number('1128683')->is_valid_number, '株式会社 リテック・コンサルタンツ');
ok($zip->set_number('1128684')->is_valid_number, '株式会社 トルテック都市建築設計事務所');
ok($zip->set_number('1128685')->is_valid_number, '株式会社 デュープレックス・ギャザリング');
ok($zip->set_number('1128687')->is_valid_number, '跡見学園女子大学');
ok($zip->set_number('1128690')->is_valid_number, '株式会社 JTB商事');
ok($zip->set_number('1128701')->is_valid_number, 'トヨタ自動車 株式会社 東京本社');
ok($zip->set_number('1128702')->is_valid_number, '株式会社 日本アカデミー');
ok($zip->set_number('1128710')->is_valid_number, 'クラリオン販売 株式会社');
ok($zip->set_number('1128733')->is_valid_number, '株式会社 ディスコ');
ok($zip->set_number('1138311')->is_valid_number, '財団法人 日本サッカー協会');
ok($zip->set_number('1138401')->is_valid_number, 'ビッグホリデー 株式会社');
ok($zip->set_number('1138402')->is_valid_number, '株式会社 シード');
ok($zip->set_number('1138404')->is_valid_number, '東邦テナックス 株式会社');
ok($zip->set_number('1138408')->is_valid_number, '栄研化学 株式会社');
ok($zip->set_number('1138410')->is_valid_number, '株式会社 南江堂');
ok($zip->set_number('1138411')->is_valid_number, '三菱UFJニコス 株式会社');
ok($zip->set_number('1138412')->is_valid_number, '三菱UFJニコス 株式会社');
ok($zip->set_number('1138413')->is_valid_number, '三菱UFJニコス 株式会社');
ok($zip->set_number('1138415')->is_valid_number, 'パラテクノ 株式会社');
ok($zip->set_number('1138418')->is_valid_number, '社団法人 日本整形外科学会');
ok($zip->set_number('1138420')->is_valid_number, 'フクダ電子 (株)');
ok($zip->set_number('1138421')->is_valid_number, '順天堂大学');
ok($zip->set_number('1138422')->is_valid_number, 'ADEKAクリーンエイド 株式会社');
ok($zip->set_number('1138423')->is_valid_number, '株式会社 りそな銀行 本郷支店');
ok($zip->set_number('1138431')->is_valid_number, '順天堂大学附属 順天堂医院');
ok($zip->set_number('1138433')->is_valid_number, '社団法人 日本内科学会');
ok($zip->set_number('1138434')->is_valid_number, '三洋電機 株式会社 日本サッカー協会ビル');
ok($zip->set_number('1138435')->is_valid_number, 'トノクラ医科工業 株式会社');
ok($zip->set_number('1138441')->is_valid_number, '日本私立学校振興・共済事業団');
ok($zip->set_number('1138444')->is_valid_number, '富士エレクトロニクス 株式会社');
ok($zip->set_number('1138448')->is_valid_number, '株式会社 日本スポーツ企画出版社');
ok($zip->set_number('1138450')->is_valid_number, '株式会社 第一科学');
ok($zip->set_number('1138451')->is_valid_number, '村中医療器 株式会社 東京支店');
ok($zip->set_number('1138456')->is_valid_number, '東芝メディカル 株式会社');
ok($zip->set_number('1138459')->is_valid_number, '本郷税務署');
ok($zip->set_number('1138462')->is_valid_number, '全国労働組合総連合');
ok($zip->set_number('1138463')->is_valid_number, '日本国民救援会');
ok($zip->set_number('1138464')->is_valid_number, '原水爆禁止日本協議会');
ok($zip->set_number('1138465')->is_valid_number, '全日本民主医療機関連合会');
ok($zip->set_number('1138466')->is_valid_number, '株式会社 工業調査会');
ok($zip->set_number('1138471')->is_valid_number, '東京スバル 株式会社');
ok($zip->set_number('1138474')->is_valid_number, '株式会社 太平エンジニアリング');
ok($zip->set_number('1138477')->is_valid_number, '株式会社 柴田書店');
ok($zip->set_number('1138479')->is_valid_number, '株式会社 シモン');
ok($zip->set_number('1138483')->is_valid_number, 'フクダ電子 (株)');
ok($zip->set_number('1138484')->is_valid_number, '欧文印刷 株式会社');
ok($zip->set_number('1138488')->is_valid_number, 'ワールド通商 株式会社');
ok($zip->set_number('1138501')->is_valid_number, '株式会社 新建築社');
ok($zip->set_number('1138503')->is_valid_number, '加賀電子 株式会社');
ok($zip->set_number('1138504')->is_valid_number, '加賀電子 株式会社');
ok($zip->set_number('1138505')->is_valid_number, '加賀電子 株式会社');
ok($zip->set_number('1138507')->is_valid_number, '日本金型工業厚生年金基金');
ok($zip->set_number('1138509')->is_valid_number, 'コミュニティ・ネットワーク 株式会社');
ok($zip->set_number('1138510')->is_valid_number, '東京医科歯科大学 本部');
ok($zip->set_number('1138513')->is_valid_number, '東邦レマック 株式会社');
ok($zip->set_number('1138519')->is_valid_number, '東京医科歯科大学 医学部');
ok($zip->set_number('1138520')->is_valid_number, '松吉医科器械 株式会社');
ok($zip->set_number('1138521')->is_valid_number, '株式会社 TONEGAWA');
ok($zip->set_number('1138524')->is_valid_number, '株式会社 交通タイムス社');
ok($zip->set_number('1138525')->is_valid_number, '株式会社 オーディオテクニカ');
ok($zip->set_number('1138526')->is_valid_number, '株式会社 関電工 東京支店');
ok($zip->set_number('1138530')->is_valid_number, '社団法人 日本ウオーキング協会');
ok($zip->set_number('1138534')->is_valid_number, '株式会社 三啓');
ok($zip->set_number('1138535')->is_valid_number, '文化シヤッター 株式会社');
ok($zip->set_number('1138536')->is_valid_number, '株式会社 関工ファシリティーズ');
ok($zip->set_number('1138541')->is_valid_number, '株式会社 大修館書店');
ok($zip->set_number('1138543')->is_valid_number, 'ヨネックス 株式会社');
ok($zip->set_number('1138546')->is_valid_number, '東京工事警備 株式会社');
ok($zip->set_number('1138549')->is_valid_number, '東京医科歯科大学 歯学部');
ok($zip->set_number('1138551')->is_valid_number, '株式会社 夏目製作所');
ok($zip->set_number('1138553')->is_valid_number, '財務省関東財務局 東京財務事務所');
ok($zip->set_number('1138555')->is_valid_number, '東京都電機厚生年金基金');
ok($zip->set_number('1138556')->is_valid_number, '株式会社 ケイリース');
ok($zip->set_number('1138560')->is_valid_number, '株式会社 マキノ出版');
ok($zip->set_number('1138561')->is_valid_number, '株式会社 マイヘルス社');
ok($zip->set_number('1138562')->is_valid_number, '株式会社 特選街出版');
ok($zip->set_number('1138563')->is_valid_number, '株式会社 壮快薬品');
ok($zip->set_number('1138564')->is_valid_number, '株式会社 壮快薬品');
ok($zip->set_number('1138566')->is_valid_number, '東京都電機健康保険組合');
ok($zip->set_number('1138570')->is_valid_number, '株式会社 コスミック出版');
ok($zip->set_number('1138586')->is_valid_number, '関工商事 (株)');
ok($zip->set_number('1138601')->is_valid_number, 'キャピタル (株)');
ok($zip->set_number('1138602')->is_valid_number, '日本医科大学');
ok($zip->set_number('1138603')->is_valid_number, '日本医科大学付属病院');
ok($zip->set_number('1138604')->is_valid_number, '学校法人 日本医科大学');
ok($zip->set_number('1138608')->is_valid_number, '開隆堂出版 (株)');
ok($zip->set_number('1138610')->is_valid_number, '日本工業出版 株式会社');
ok($zip->set_number('1138611')->is_valid_number, '株式会社 フレーベル館');
ok($zip->set_number('1138612')->is_valid_number, '医歯薬出版 (株)');
ok($zip->set_number('1138633')->is_valid_number, '株式会社 アストリア');
ok($zip->set_number('1138638')->is_valid_number, '株式会社 セムコーポレーション');
ok($zip->set_number('1138650')->is_valid_number, '科研製薬 株式会社');
ok($zip->set_number('1138654')->is_valid_number, '東京大学 本部事務組織');
ok($zip->set_number('1138655')->is_valid_number, '東京大学医学部附属病院');
ok($zip->set_number('1138656')->is_valid_number, '東京大学 工学部');
ok($zip->set_number('1138657')->is_valid_number, '東京大学 農学部');
ok($zip->set_number('1138658')->is_valid_number, '東京大学 情報基盤センター');
ok($zip->set_number('1138660')->is_valid_number, '文京グリーンコートビル (株)');
ok($zip->set_number('1138661')->is_valid_number, '日本生命保険 相互会社');
ok($zip->set_number('1138662')->is_valid_number, 'クラリアントジャパン (株)');
ok($zip->set_number('1138663')->is_valid_number, '独立行政法人 情報処理推進機構 情報処理技術者試験センター');
ok($zip->set_number('1138681')->is_valid_number, '株式会社 千代田テクノル');
ok($zip->set_number('1138686')->is_valid_number, '株式会社 福音館書店');
ok($zip->set_number('1138687')->is_valid_number, '金原出版 株式会社');
ok($zip->set_number('1138701')->is_valid_number, '財団法人 日本青少年ペンフレンドクラブ協会');
ok($zip->set_number('1138711')->is_valid_number, 'UFJニコス 株式会社');
ok($zip->set_number('1138712')->is_valid_number, 'UFJニコス 株式会社');
ok($zip->set_number('1138719')->is_valid_number, '医学書院');
ok($zip->set_number('1148501')->is_valid_number, '株式会社 コモディイイダ');
ok($zip->set_number('1148502')->is_valid_number, '聖学院中学校高等学校');
ok($zip->set_number('1148503')->is_valid_number, '北とぴあ');
ok($zip->set_number('1148505')->is_valid_number, '川田建設 株式会社');
ok($zip->set_number('1148506')->is_valid_number, '東京都水道局 北営業所');
ok($zip->set_number('1148507')->is_valid_number, '朝日生命保険 相互会社 首都圏第二営業本部 事務センター');
ok($zip->set_number('1148508')->is_valid_number, '東京都北区役所');
ok($zip->set_number('1148510')->is_valid_number, '日本リーテック 株式会社');
ok($zip->set_number('1148512')->is_valid_number, '東京シンコール 株式会社');
ok($zip->set_number('1148513')->is_valid_number, '住友石炭鉱業 株式会社');
ok($zip->set_number('1148514')->is_valid_number, '全日本運輸一般 労働組合');
ok($zip->set_number('1148515')->is_valid_number, '株式会社 ヨコオ');
ok($zip->set_number('1148517')->is_valid_number, '東京都北都税事務所');
ok($zip->set_number('1148518')->is_valid_number, 'リョービ 株式会社');
ok($zip->set_number('1148519')->is_valid_number, '株式会社 サーベイリサーチセンター');
ok($zip->set_number('1148520')->is_valid_number, '京三電線 株式会社');
ok($zip->set_number('1148521')->is_valid_number, '城北信用金庫 本部');
ok($zip->set_number('1148522')->is_valid_number, '城北信用金庫 王子営業部');
ok($zip->set_number('1148524')->is_valid_number, '東京書籍 株式会社');
ok($zip->set_number('1148526')->is_valid_number, '学校法人 東京成徳学園');
ok($zip->set_number('1148528')->is_valid_number, '東京フェライト製造 株式会社');
ok($zip->set_number('1148530')->is_valid_number, 'リーベ 株式会社');
ok($zip->set_number('1148531')->is_valid_number, '東京法務局 北出張所');
ok($zip->set_number('1148532')->is_valid_number, 'フジ電設 株式会社');
ok($zip->set_number('1148534')->is_valid_number, '北区滝野川会館');
ok($zip->set_number('1148535')->is_valid_number, '東京ガス (株) 北部事業本部');
ok($zip->set_number('1148538')->is_valid_number, '株式会社 三共製作所');
ok($zip->set_number('1148539')->is_valid_number, '東海商事 株式会社');
ok($zip->set_number('1148540')->is_valid_number, 'タツミ産業 株式会社');
ok($zip->set_number('1148541')->is_valid_number, '(株) 小泉 中央城北営業所');
ok($zip->set_number('1148543')->is_valid_number, '学校法人 中央工学校');
ok($zip->set_number('1148544')->is_valid_number, '池野通建 株式会社');
ok($zip->set_number('1148545')->is_valid_number, 'トーメン食品 株式会社');
ok($zip->set_number('1148550')->is_valid_number, '東日本旅客鉄道 株式会社 東京地域本社');
ok($zip->set_number('1148552')->is_valid_number, '十條木材 株式会社');
ok($zip->set_number('1148553')->is_valid_number, 'サイタ工業 株式会社');
ok($zip->set_number('1148554')->is_valid_number, '学校法人 桜丘女子学園');
ok($zip->set_number('1148555')->is_valid_number, 'エヌピー総合開発 株式会社');
ok($zip->set_number('1148557')->is_valid_number, '株式会社 東洋精機製作所');
ok($zip->set_number('1148560')->is_valid_number, '王子税務署');
ok($zip->set_number('1148561')->is_valid_number, '東京都立 飛鳥高等学校');
ok($zip->set_number('1148562')->is_valid_number, '川田工業 株式会社');
ok($zip->set_number('1148565')->is_valid_number, '海上自衛隊 需給統制隊');
ok($zip->set_number('1148571')->is_valid_number, '瀧野川信用金庫');
ok($zip->set_number('1148574')->is_valid_number, '学校法人聖学院 聖学院広報センター 女子聖学院中学校高等学校 聖学院小学校 聖学院幼稚園');
ok($zip->set_number('1148577')->is_valid_number, '株式会社 模範薬品研究所');
ok($zip->set_number('1148580')->is_valid_number, '東京外国語大学');
ok($zip->set_number('1148581')->is_valid_number, '株式会社 アドバネクス');
ok($zip->set_number('1148583')->is_valid_number, '株式会社 トンボ鉛筆');
ok($zip->set_number('1148584')->is_valid_number, '日本特殊塗料 (株)');
ok($zip->set_number('1148585')->is_valid_number, 'コーセー化粧品販売 株式会社 東京支社');
ok($zip->set_number('1148588')->is_valid_number, '吉澤原動機 株式会社');
ok($zip->set_number('1148595')->is_valid_number, 'みどり生命保険 株式会社');
ok($zip->set_number('1148602')->is_valid_number, '株式会社 なとり 東京営業所');
ok($zip->set_number('1148603')->is_valid_number, '株式会社 全珍 東京営業所');
ok($zip->set_number('1148604')->is_valid_number, '株式会社 好好飲茶');
ok($zip->set_number('1148605')->is_valid_number, '株式会社 なとりデリカ');
ok($zip->set_number('1148606')->is_valid_number, '株式会社 なとり 食品総合ラボラトリー');
ok($zip->set_number('1148611')->is_valid_number, '株式会社 なとり');
ok($zip->set_number('1148686')->is_valid_number, '中央工学校 生涯学習センター');
ok($zip->set_number('1158507')->is_valid_number, '日本オーナメント 株式会社');
ok($zip->set_number('1158510')->is_valid_number, '日本交通 株式会社 本社');
ok($zip->set_number('1158511')->is_valid_number, '株式会社 ディー・エヌ・ケー');
ok($zip->set_number('1158524')->is_valid_number, '学校法人 星美学園 短期大学、高等学校、中学校、小学校、幼稚園');
ok($zip->set_number('1158529')->is_valid_number, '株式会社 吉野家');
ok($zip->set_number('1158555')->is_valid_number, '三恵技研工業 株式会社');
ok($zip->set_number('1158567')->is_valid_number, '株式会社 日伝 東京支店');
ok($zip->set_number('1158585')->is_valid_number, '大日本運輸 株式会社');
ok($zip->set_number('1158586')->is_valid_number, '東京都立産業技術研究所');
ok($zip->set_number('1158588')->is_valid_number, '日本化薬 株式会社 東京工場');
ok($zip->set_number('1158601')->is_valid_number, 'カルビー 株式会社');
ok($zip->set_number('1158711')->is_valid_number, '大和証券 株式会社 赤羽支店');
ok($zip->set_number('1168501')->is_valid_number, '荒川区役所');
ok($zip->set_number('1168502')->is_valid_number, '荒川区保健所');
ok($zip->set_number('1168503')->is_valid_number, '株式会社 白興');
ok($zip->set_number('1168505')->is_valid_number, '三菱電機ビルテクノサービス 株式会社');
ok($zip->set_number('1168507')->is_valid_number, '荒川区がん予防・健康づくりセンター');
ok($zip->set_number('1168508')->is_valid_number, '株式会社 ヤマトメ');
ok($zip->set_number('1168521')->is_valid_number, '東京都水道局 荒川営業所');
ok($zip->set_number('1168522')->is_valid_number, '東京ガス 株式会社 東部事業本部');
ok($zip->set_number('1168523')->is_valid_number, '東京都立産業技術高等専門学校 荒川キャンパス');
ok($zip->set_number('1168524')->is_valid_number, '城信ビジネスサービス 株式会社');
ok($zip->set_number('1168532')->is_valid_number, '株式会社 タカイシ');
ok($zip->set_number('1168533')->is_valid_number, '東京シンコーレザー 株式会社');
ok($zip->set_number('1168537')->is_valid_number, '株式会社 エドウイン');
ok($zip->set_number('1168540')->is_valid_number, 'アイセック 株式会社');
ok($zip->set_number('1168541')->is_valid_number, '井関農機 株式会社');
ok($zip->set_number('1168543')->is_valid_number, '井嶋金銀工業 株式会社');
ok($zip->set_number('1168546')->is_valid_number, '株式会社 千代田');
ok($zip->set_number('1168548')->is_valid_number, '東京海上日動火災保険 株式会社');
ok($zip->set_number('1168549')->is_valid_number, '東栄産業 株式会社');
ok($zip->set_number('1168550')->is_valid_number, '東京電力 株式会社 東京工事センター');
ok($zip->set_number('1168551')->is_valid_number, '東京都立医療技術短期大学');
ok($zip->set_number('1168552')->is_valid_number, '長島特殊塗料 株式会社');
ok($zip->set_number('1168556')->is_valid_number, '高六商事 株式会社');
ok($zip->set_number('1168561')->is_valid_number, '日本アンテナ 株式会社');
ok($zip->set_number('1168562')->is_valid_number, '稲垣機材 株式会社');
ok($zip->set_number('1168567')->is_valid_number, '東京女子医科大学附属第二病院');
ok($zip->set_number('1168571')->is_valid_number, '株式会社 ウチダ和漢薬');
ok($zip->set_number('1168580')->is_valid_number, '(株) ダイナム');
ok($zip->set_number('1168581')->is_valid_number, '株式会社 サーベイリサーチセンター');
ok($zip->set_number('1168584')->is_valid_number, 'イセキ販売金融 株式会社');
ok($zip->set_number('1168585')->is_valid_number, '井島貴金属精錬 株式会社');
ok($zip->set_number('1168586')->is_valid_number, '荒川都税事務所');
ok($zip->set_number('1168587')->is_valid_number, 'クリナップ 株式会社');
ok($zip->set_number('1168588')->is_valid_number, '荒川税務署');
ok($zip->set_number('1168611')->is_valid_number, '中山式産業 株式会社');
ok($zip->set_number('1208501')->is_valid_number, '(株) 丸井 北千住店');
ok($zip->set_number('1208507')->is_valid_number, '東京電力 株式会社 東京支店上野支社足立営業センター');
ok($zip->set_number('1208508')->is_valid_number, '東京都足立都税事務所');
ok($zip->set_number('1208510')->is_valid_number, '足立区役所');
ok($zip->set_number('1208512')->is_valid_number, '足立区役所 区民部 戸籍住民課');
ok($zip->set_number('1208520')->is_valid_number, '足立税務署');
ok($zip->set_number('1208526')->is_valid_number, '株式会社 タジマ');
ok($zip->set_number('1208528')->is_valid_number, '荒川商業高等学校');
ok($zip->set_number('1208530')->is_valid_number, '足立公共職業安定所');
ok($zip->set_number('1208534')->is_valid_number, '財団法人 海外技術者研修協会');
ok($zip->set_number('1208536')->is_valid_number, '株式会社 吉安本店');
ok($zip->set_number('1208539')->is_valid_number, '協和機工 株式会社');
ok($zip->set_number('1208544')->is_valid_number, '株式会社 丸愛');
ok($zip->set_number('1208550')->is_valid_number, '東京千住魚市場卸協同組合');
ok($zip->set_number('1208553')->is_valid_number, '株式会社 リーガルコーポレーション');
ok($zip->set_number('1208555')->is_valid_number, '千住金属工業 株式会社');
ok($zip->set_number('1208556')->is_valid_number, '大都魚類 株式会社 千住支社');
ok($zip->set_number('1208558')->is_valid_number, '東京北魚 株式会社');
ok($zip->set_number('1208570')->is_valid_number, '太陽生命保険 相互会社 千住支社');
ok($zip->set_number('1208575')->is_valid_number, '財団法人 足立区勤労福祉サービスセンター');
ok($zip->set_number('1208577')->is_valid_number, '株式会社 佐山製作所');
ok($zip->set_number('1208581')->is_valid_number, '株式会社 江戸一');
ok($zip->set_number('1208601')->is_valid_number, '株式会社 ニッピ');
ok($zip->set_number('1208602')->is_valid_number, '株式会社 ニッピコラーゲン化粧品');
ok($zip->set_number('1218080')->is_valid_number, '株式会社 トップアート');
ok($zip->set_number('1218502')->is_valid_number, 'NTT 上野支店 足立お客様サービスセンター');
ok($zip->set_number('1218504')->is_valid_number, '杉本興業 株式会社');
ok($zip->set_number('1218505')->is_valid_number, '日東燃料工業 (株)');
ok($zip->set_number('1218510')->is_valid_number, '東京北足立市場青果卸売 協同組合');
ok($zip->set_number('1218511')->is_valid_number, '株式会社 ニッソー');
ok($zip->set_number('1218520')->is_valid_number, 'イワヤ (株)');
ok($zip->set_number('1218521')->is_valid_number, '(株) アローシステム開発');
ok($zip->set_number('1218522')->is_valid_number, '東亜燃料工業 (株)');
ok($zip->set_number('1218523')->is_valid_number, '(株) モトール');
ok($zip->set_number('1218524')->is_valid_number, '矢野新商事 株式会社');
ok($zip->set_number('1218533')->is_valid_number, '株式会社 宏和');
ok($zip->set_number('1218540')->is_valid_number, '株式会社 ヒラタ');
ok($zip->set_number('1218550')->is_valid_number, '東京都水道局 足立東営業所');
ok($zip->set_number('1218555')->is_valid_number, '足立区北部福祉事務所');
ok($zip->set_number('1218585')->is_valid_number, '東京エコール 総合流通センター');
ok($zip->set_number('1218588')->is_valid_number, '東京千住青果 株式会社');
ok($zip->set_number('1218601')->is_valid_number, 'サリ 株式会社');
ok($zip->set_number('1218610')->is_valid_number, '加藤産業 株式会社 足立支店');
ok($zip->set_number('1218611')->is_valid_number, '株式会社 丸井スズキ');
ok($zip->set_number('1218616')->is_valid_number, '(株) 明治屋 東京支店 足立営業所');
ok($zip->set_number('1218621')->is_valid_number, '株式会社 正直屋 東京支店');
ok($zip->set_number('1218633')->is_valid_number, '株式会社 サンエス');
ok($zip->set_number('1218639')->is_valid_number, '(株) 第一エレクトロニクス');
ok($zip->set_number('1218680')->is_valid_number, 'アスクル');
ok($zip->set_number('1218681')->is_valid_number, 'ピジョン');
ok($zip->set_number('1218682')->is_valid_number, '(株) トップライン');
ok($zip->set_number('1218701')->is_valid_number, '森永乳業 (株)');
ok($zip->set_number('1218710')->is_valid_number, 'シチズン商事 (株)');
ok($zip->set_number('1218711')->is_valid_number, 'マスセット (株)');
ok($zip->set_number('1218729')->is_valid_number, 'シーエル商事 (株)');
ok($zip->set_number('1238501')->is_valid_number, '西新井税務署');
ok($zip->set_number('1238503')->is_valid_number, '森宮電機 株式会社');
ok($zip->set_number('1238505')->is_valid_number, '富双合成 株式会社');
ok($zip->set_number('1238506')->is_valid_number, '信州名鉄運輸 株式会社');
ok($zip->set_number('1238508')->is_valid_number, 'イーダ 株式会社');
ok($zip->set_number('1238509')->is_valid_number, '株式会社 アベルコ');
ok($zip->set_number('1238511')->is_valid_number, '並木精密宝石 株式会社');
ok($zip->set_number('1238514')->is_valid_number, '丸石自転車 株式会社 東京工場');
ok($zip->set_number('1238517')->is_valid_number, '水道局 足立西営業所');
ok($zip->set_number('1238540')->is_valid_number, '警視庁 西新井警察署');
ok($zip->set_number('1238585')->is_valid_number, '日清紡績 株式会社 東京工場');
ok($zip->set_number('1238588')->is_valid_number, 'トークシステム 株式会社');
ok($zip->set_number('1248070')->is_valid_number, 'ダイエーOMC');
ok($zip->set_number('1248501')->is_valid_number, '東栄信用金庫');
ok($zip->set_number('1248502')->is_valid_number, '東京法務局 城北出張所');
ok($zip->set_number('1248503')->is_valid_number, '株式会社 国際貿易');
ok($zip->set_number('1248509')->is_valid_number, '松久 株式会社');
ok($zip->set_number('1248510')->is_valid_number, 'ミヨシ油脂 株式会社');
ok($zip->set_number('1248511')->is_valid_number, '株式会社 タカラトミー');
ok($zip->set_number('1248518')->is_valid_number, '株式会社 萬和');
ok($zip->set_number('1248520')->is_valid_number, '東京都 葛飾都税事務所');
ok($zip->set_number('1248522')->is_valid_number, '同朋金属工業 株式会社');
ok($zip->set_number('1248524')->is_valid_number, '葛飾商工信用組合');
ok($zip->set_number('1248533')->is_valid_number, '鬼怒川パシフィック 株式会社');
ok($zip->set_number('1248535')->is_valid_number, '大成化工 株式会社');
ok($zip->set_number('1248538')->is_valid_number, '辰巳屋興業 株式会社');
ok($zip->set_number('1248539')->is_valid_number, 'NTT葛飾');
ok($zip->set_number('1248550')->is_valid_number, '小里機材 株式会社');
ok($zip->set_number('1248555')->is_valid_number, '葛飾区役所');
ok($zip->set_number('1248560')->is_valid_number, '葛飾税務署');
ok($zip->set_number('1248566')->is_valid_number, '株式会社 荒井製作所');
ok($zip->set_number('1248577')->is_valid_number, '森永乳業 株式会社 東京工場');
ok($zip->set_number('1248585')->is_valid_number, '株式会社 バンダイロジパル');
ok($zip->set_number('1248588')->is_valid_number, 'カール事務器 株式会社');
ok($zip->set_number('1258503')->is_valid_number, '株式会社 タカラトミー');
ok($zip->set_number('1258504')->is_valid_number, '石徳螺子 株式会社');
ok($zip->set_number('1258505')->is_valid_number, '三和ニードルベアリング 株式会社');
ok($zip->set_number('1258506')->is_valid_number, '東京慈恵会 医科大学附属青戸病院');
ok($zip->set_number('1258507')->is_valid_number, '修徳高等学校');
ok($zip->set_number('1258508')->is_valid_number, '亀有信用金庫');
ok($zip->set_number('1258511')->is_valid_number, '株式会社 アズウェル');
ok($zip->set_number('1258512')->is_valid_number, '(財) 東京都保健医療公社 東部地域病院');
ok($zip->set_number('1258513')->is_valid_number, '株式会社 ジョイフルまるやま');
ok($zip->set_number('1258514')->is_valid_number, '株式会社 京成ストア');
ok($zip->set_number('1258515')->is_valid_number, '株式会社 タカシマ');
ok($zip->set_number('1258517')->is_valid_number, '京成不動産 株式会社');
ok($zip->set_number('1258520')->is_valid_number, '亀有病院');
ok($zip->set_number('1258522')->is_valid_number, '葛飾区東福祉サービスセンター');
ok($zip->set_number('1258526')->is_valid_number, '株式会社 三王商会');
ok($zip->set_number('1258555')->is_valid_number, '株式会社 葛飾ケーブルネットワーク');
ok($zip->set_number('1258588')->is_valid_number, '医療法人社団 玲瓏会 金町中央病院');
ok($zip->set_number('1258601')->is_valid_number, '三菱ガス化学 株式会社 東京開発センター');
ok($zip->set_number('1258602')->is_valid_number, '日本数学検定協会');
ok($zip->set_number('1308501')->is_valid_number, '株式会社 ハセガワ');
ok($zip->set_number('1308503')->is_valid_number, '株式会社 大和研材商会');
ok($zip->set_number('1308504')->is_valid_number, '株式会社 ロゴスコーポレーション');
ok($zip->set_number('1308505')->is_valid_number, '新藤美術印刷 株式会社');
ok($zip->set_number('1308506')->is_valid_number, '株式会社 ミノウラ');
ok($zip->set_number('1308507')->is_valid_number, 'ヤバネスポーツ 株式会社');
ok($zip->set_number('1308508')->is_valid_number, 'ハクバ写真産業 株式会社');
ok($zip->set_number('1308509')->is_valid_number, '大東信用金庫');
ok($zip->set_number('1308510')->is_valid_number, '株式会社 ローズマダム');
ok($zip->set_number('1308511')->is_valid_number, '千代田管鉄 株式会社');
ok($zip->set_number('1308512')->is_valid_number, '石塚電子 株式会社');
ok($zip->set_number('1308513')->is_valid_number, '日本硝子建材 株式会社');
ok($zip->set_number('1308514')->is_valid_number, '東京文具 株式会社');
ok($zip->set_number('1308515')->is_valid_number, '助野靴下 株式会社 東京支店');
ok($zip->set_number('1308516')->is_valid_number, '株式会社 吉田製作所');
ok($zip->set_number('1308517')->is_valid_number, 'ツバメ石油 株式会社');
ok($zip->set_number('1308518')->is_valid_number, '株式会社 丸井 錦糸町店');
ok($zip->set_number('1308520')->is_valid_number, '渡辺パイプ 株式会社');
ok($zip->set_number('1308522')->is_valid_number, '坂田建設 株式会社');
ok($zip->set_number('1308525')->is_valid_number, 'ピップトウキョウ 株式会社 メディカル事業部');
ok($zip->set_number('1308528')->is_valid_number, 'ナイガイ 株式会社');
ok($zip->set_number('1308530')->is_valid_number, '岡部バルブ工業 株式会社');
ok($zip->set_number('1308531')->is_valid_number, '三井金属エンジニアリング 株式会社');
ok($zip->set_number('1308533')->is_valid_number, '協和自動車 株式会社');
ok($zip->set_number('1308534')->is_valid_number, '株式会社 サンヨー堂');
ok($zip->set_number('1308535')->is_valid_number, '株式会社 東京楽天地');
ok($zip->set_number('1308538')->is_valid_number, '近江屋写真用品 株式会社');
ok($zip->set_number('1308539')->is_valid_number, '国宝商事 株式会社');
ok($zip->set_number('1308543')->is_valid_number, '株式会社 昭電');
ok($zip->set_number('1308545')->is_valid_number, '中央信用金庫');
ok($zip->set_number('1308548')->is_valid_number, '株式会社 セディナ');
ok($zip->set_number('1308554')->is_valid_number, '日本金属プレス工業厚生年金基金');
ok($zip->set_number('1308555')->is_valid_number, '株式会社 ティムコ');
ok($zip->set_number('1308556')->is_valid_number, '日本電技 株式会社');
ok($zip->set_number('1308557')->is_valid_number, 'エイアイジー・スター生命保険 株式会社');
ok($zip->set_number('1308558')->is_valid_number, '株式会社 アイフルホームテクノロジー');
ok($zip->set_number('1308565')->is_valid_number, '学校法人 東京IT会計法律学園');
ok($zip->set_number('1308566')->is_valid_number, '大井工業 株式会社');
ok($zip->set_number('1308567')->is_valid_number, 'マルヤマエクセル 株式会社');
ok($zip->set_number('1308570')->is_valid_number, 'ロンシール工業 株式会社');
ok($zip->set_number('1308575')->is_valid_number, '東京都立墨東病院');
ok($zip->set_number('1308577')->is_valid_number, 'アカツキ商事 株式会社');
ok($zip->set_number('1308580')->is_valid_number, '株式会社 錦糸町ステーションビル');
ok($zip->set_number('1308583')->is_valid_number, 'エムシーエス債権管理回収 株式会社');
ok($zip->set_number('1308584')->is_valid_number, 'ライオンハイジーン 株式会社');
ok($zip->set_number('1308585')->is_valid_number, '株式会社 アシックス 東京支社');
ok($zip->set_number('1308588')->is_valid_number, '三浦印刷 株式会社');
ok($zip->set_number('1308601')->is_valid_number, 'オーベクス 株式会社');
ok($zip->set_number('1308602')->is_valid_number, 'アサヒビール 株式会社');
ok($zip->set_number('1308603')->is_valid_number, '日本たばこ産業 株式会社 東京工場');
ok($zip->set_number('1308604')->is_valid_number, '石川玩具 株式会社');
ok($zip->set_number('1308605')->is_valid_number, '西武商事 株式会社');
ok($zip->set_number('1308608')->is_valid_number, '東京都墨田都税事務所');
ok($zip->set_number('1308609')->is_valid_number, '墨田 公共職業安定所');
ok($zip->set_number('1308611')->is_valid_number, '社団法人 日本玩具協会');
ok($zip->set_number('1308615')->is_valid_number, '安田学園');
ok($zip->set_number('1308625')->is_valid_number, 'AIGエジソン生命保険 株式会社');
ok($zip->set_number('1308636')->is_valid_number, '東京簡易裁判所 墨田庁舎');
ok($zip->set_number('1308637')->is_valid_number, '東京簡易裁判所 墨田庁舎');
ok($zip->set_number('1308640')->is_valid_number, '墨田区役所');
ok($zip->set_number('1308642')->is_valid_number, '田中商事 株式会社');
ok($zip->set_number('1308650')->is_valid_number, '明治乳業 株式会社 東京支社');
ok($zip->set_number('1308655')->is_valid_number, '株式会社 三喜');
ok($zip->set_number('1308660')->is_valid_number, 'エイアイジー・スター生命保険 株式会社');
ok($zip->set_number('1308666')->is_valid_number, '株式会社 小森コーポレーション');
ok($zip->set_number('1308668')->is_valid_number, 'オキナ 株式会社');
ok($zip->set_number('1308671')->is_valid_number, 'クラヤ商事 株式会社');
ok($zip->set_number('1308677')->is_valid_number, 'ニコンカメラ販売 株式会社');
ok($zip->set_number('1308686')->is_valid_number, '本所税務署');
ok($zip->set_number('1308701')->is_valid_number, '株式会社 東京鋲兼');
ok($zip->set_number('1308706')->is_valid_number, '株式会社 ミドリ');
ok($zip->set_number('1308710')->is_valid_number, '東興商事 株式会社');
ok($zip->set_number('1308720')->is_valid_number, '株式会社 ヤマモリ');
ok($zip->set_number('1318501')->is_valid_number, '花王 株式会社 すみだ事業所');
ok($zip->set_number('1318503')->is_valid_number, '東武商事 株式会社');
ok($zip->set_number('1318504')->is_valid_number, '東武トラベル 株式会社');
ok($zip->set_number('1318505')->is_valid_number, '岡部 株式会社');
ok($zip->set_number('1318506')->is_valid_number, '東陶メンテナンス 株式会社');
ok($zip->set_number('1318507')->is_valid_number, '株式会社 久保商会');
ok($zip->set_number('1318508')->is_valid_number, '東武バス 株式会社');
ok($zip->set_number('1318509')->is_valid_number, '向島税務署');
ok($zip->set_number('1318510')->is_valid_number, '株式会社 大林組 東京本社 墨田事務所');
ok($zip->set_number('1318511')->is_valid_number, '株式会社 ハクタ商会');
ok($zip->set_number('1318512')->is_valid_number, '山下商事 株式会社');
ok($zip->set_number('1318513')->is_valid_number, 'カネボウ物流 株式会社 東京支店');
ok($zip->set_number('1318518')->is_valid_number, '杉本商事 株式会社 墨田営業所');
ok($zip->set_number('1318519')->is_valid_number, '株式会社 イナゲ');
ok($zip->set_number('1318520')->is_valid_number, 'ナガセケンコー 株式会社');
ok($zip->set_number('1318524')->is_valid_number, '東武谷内田建設 株式会社');
ok($zip->set_number('1318526')->is_valid_number, '株式会社 ときわ商会');
ok($zip->set_number('1318527')->is_valid_number, '丸源飲料工業 株式会社');
ok($zip->set_number('1318530')->is_valid_number, '東京東 信用金庫');
ok($zip->set_number('1318533')->is_valid_number, 'NECインフロンティア 株式会社 墨田事業所');
ok($zip->set_number('1318540')->is_valid_number, '大林道路 株式会社');
ok($zip->set_number('1318550')->is_valid_number, '東武ビル管理');
ok($zip->set_number('1318555')->is_valid_number, '京成電鉄 株式会社');
ok($zip->set_number('1318565')->is_valid_number, '株式会社 日本旅行 東日本営業本部');
ok($zip->set_number('1318584')->is_valid_number, 'さくらケーブルテレビ 株式会社');
ok($zip->set_number('1318585')->is_valid_number, '小管 株式会社');
ok($zip->set_number('1318588')->is_valid_number, '株式会社 フタキ商事');
ok($zip->set_number('1318711')->is_valid_number, 'エヌティティテレマーケティング 株式会社');
ok($zip->set_number('1328501')->is_valid_number, '江戸川区役所');
ok($zip->set_number('1328503')->is_valid_number, '京和工業 (株)');
ok($zip->set_number('1328507')->is_valid_number, '江戸川保健所');
ok($zip->set_number('1328533')->is_valid_number, '株式会社 小松川プラスチックス');
ok($zip->set_number('1328550')->is_valid_number, '東京電力 株式会社 江東支店 江戸川営業センター');
ok($zip->set_number('1328551')->is_valid_number, '東京都江戸川都税事務所');
ok($zip->set_number('1328555')->is_valid_number, '株式会社 大同商会');
ok($zip->set_number('1328562')->is_valid_number, '(株) ホリゾン東テクノ');
ok($zip->set_number('1328567')->is_valid_number, '東京都水道局 江戸川営業所');
ok($zip->set_number('1328585')->is_valid_number, '東京法務局 江戸川出張所');
ok($zip->set_number('1328601')->is_valid_number, '東金属 株式会社');
ok($zip->set_number('1328666')->is_valid_number, '内宮運輸機工 株式会社');
ok($zip->set_number('1328668')->is_valid_number, '江戸川北税務署');
ok($zip->set_number('1328674')->is_valid_number, '社団法人 江戸川区 医師会');
ok($zip->set_number('1328686')->is_valid_number, 'タイヘイ 株式会社');
ok($zip->set_number('1328688')->is_valid_number, '興伸');
ok($zip->set_number('1328711')->is_valid_number, '小松川信用金庫');
ok($zip->set_number('1328715')->is_valid_number, '株式会社 ツーリストサービス');
ok($zip->set_number('1328730')->is_valid_number, 'アイリス企画');
ok($zip->set_number('1328732')->is_valid_number, 'ネグロス電工 株式会社');
ok($zip->set_number('1328739')->is_valid_number, 'スピーディ');
ok($zip->set_number('1338501')->is_valid_number, 'エステイワイ工業 株式会社');
ok($zip->set_number('1338511')->is_valid_number, '王子製紙 (株) 江戸川工場');
ok($zip->set_number('1338552')->is_valid_number, '学校法人 江戸川学園 江戸川女子中学校 江戸川女子高等学校');
ok($zip->set_number('1338553')->is_valid_number, '株式会社 丸昌 小岩店');
ok($zip->set_number('1338558')->is_valid_number, '株式会社 タカノスマイル');
ok($zip->set_number('1338580')->is_valid_number, '王子パッケージング (株)');
ok($zip->set_number('1338585')->is_valid_number, '学校法人 愛国学園');
ok($zip->set_number('1338704')->is_valid_number, '野村証券 株式会社 小岩支店');
ok($zip->set_number('1338706')->is_valid_number, '株式会社 興伸デリバリーセンター モンダミン係');
ok($zip->set_number('1348502')->is_valid_number, '株式会社 白子');
ok($zip->set_number('1348503')->is_valid_number, 'スターツ 株式会社');
ok($zip->set_number('1348507')->is_valid_number, '(株) ノニ21');
ok($zip->set_number('1348515')->is_valid_number, 'スターツデベロップメント 株式会社');
ok($zip->set_number('1348520')->is_valid_number, '月島食品工業 株式会社');
ok($zip->set_number('1348533')->is_valid_number, '日本ロール製造 株式会社');
ok($zip->set_number('1348555')->is_valid_number, '東京都立葛西南高等学校');
ok($zip->set_number('1348570')->is_valid_number, 'センコー 株式会社');
ok($zip->set_number('1348575')->is_valid_number, '日本統計調査 株式会社');
ok($zip->set_number('1348576')->is_valid_number, 'バニーアルコート 株式会社');
ok($zip->set_number('1348577')->is_valid_number, '株式会社 ジェイ・エー・エー');
ok($zip->set_number('1348585')->is_valid_number, '株式会社 アテナ');
ok($zip->set_number('1348586')->is_valid_number, '株式会社 マリモクラフト');
ok($zip->set_number('1348588')->is_valid_number, 'アドレス通商 株式会社');
ok($zip->set_number('1348601')->is_valid_number, '江戸川区スポーツセンター');
ok($zip->set_number('1348602')->is_valid_number, '株式会社 ニチベイパーツ');
ok($zip->set_number('1348603')->is_valid_number, 'ジャスコ 株式会社 葛西店');
ok($zip->set_number('1348609')->is_valid_number, 'みずほ情報総研 (株)');
ok($zip->set_number('1348610')->is_valid_number, 'NTT データ通信 株式会社');
ok($zip->set_number('1348612')->is_valid_number, '山一興産 株式会社');
ok($zip->set_number('1348622')->is_valid_number, '懸賞TV 株式会社');
ok($zip->set_number('1348630')->is_valid_number, '第一三共 株式会社 葛西研究開発センター');
ok($zip->set_number('1348631')->is_valid_number, '丸泰土木 株式会社');
ok($zip->set_number('1348640')->is_valid_number, 'カツデン 株式会社');
ok($zip->set_number('1348642')->is_valid_number, '株式会社 ライト');
ok($zip->set_number('1348678')->is_valid_number, '葛西循環器脳神経外科病院');
ok($zip->set_number('1348686')->is_valid_number, '株式会社 リケン');
ok($zip->set_number('1348702')->is_valid_number, '(株) 三井住友銀行 葛西支店');
ok($zip->set_number('1358110')->is_valid_number, '住商情報システム 株式会社');
ok($zip->set_number('1358111')->is_valid_number, '株式会社 ミライト・ホールディングス');
ok($zip->set_number('1358112')->is_valid_number, '大明 株式会社 本社');
ok($zip->set_number('1358113')->is_valid_number, '株式会社 コミューチュア');
ok($zip->set_number('1358114')->is_valid_number, '株式会社 東電通');
ok($zip->set_number('1358301')->is_valid_number, '株式会社 レイメイ藤井');
ok($zip->set_number('1358303')->is_valid_number, '株式会社 シモダ');
ok($zip->set_number('1358310')->is_valid_number, '小浅商事 株式会社 東京支店');
ok($zip->set_number('1358311')->is_valid_number, '江東西税務署');
ok($zip->set_number('1358312')->is_valid_number, 'セーラー万年筆 (株)');
ok($zip->set_number('1358318')->is_valid_number, '印刷製本包装機械健康保険組合');
ok($zip->set_number('1358320')->is_valid_number, '全国信用協同組合連合会 東京支店');
ok($zip->set_number('1358322')->is_valid_number, '石川島播磨重工業 株式会社 江東事務所');
ok($zip->set_number('1358330')->is_valid_number, '栄進物産 株式会社');
ok($zip->set_number('1358331')->is_valid_number, '株式会社 イヨベ工芸社');
ok($zip->set_number('1358350')->is_valid_number, '(株) 東京クラウン');
ok($zip->set_number('1358360')->is_valid_number, '株式会社 紅三');
ok($zip->set_number('1358362')->is_valid_number, '(株) 日立オートサービス');
ok($zip->set_number('1358363')->is_valid_number, '日立機材 株式会社');
ok($zip->set_number('1358366')->is_valid_number, '日立冷熱 株式会社 東京サービスエンジニアリングセンター');
ok($zip->set_number('1358370')->is_valid_number, 'リコーテクノネット 株式会社 東京本社');
ok($zip->set_number('1358372')->is_valid_number, '株式会社 日立物流');
ok($zip->set_number('1358375')->is_valid_number, '関東森林管理局 東京事務所');
ok($zip->set_number('1358383')->is_valid_number, '東京都江東区役所');
ok($zip->set_number('1358384')->is_valid_number, '日本ボールドウィン 株式会社');
ok($zip->set_number('1358385')->is_valid_number, '明治安田システム・テクノロジー 株式会社 MBS事業部門');
ok($zip->set_number('1358387')->is_valid_number, '神鋼電機 (株)');
ok($zip->set_number('1358388')->is_valid_number, '日本電子計算 株式会社');
ok($zip->set_number('1358402')->is_valid_number, '株式会社 ザ マイラ');
ok($zip->set_number('1358404')->is_valid_number, '学校法人 中村学園');
ok($zip->set_number('1358411')->is_valid_number, '岩野物産 株式会社');
ok($zip->set_number('1358415')->is_valid_number, '株式会社 レオテックス');
ok($zip->set_number('1358422')->is_valid_number, '株式会社 日立東サービスエンジニアリング 本社');
ok($zip->set_number('1358430')->is_valid_number, '日本プレシジョン・サーキッツ 株式会社');
ok($zip->set_number('1358432')->is_valid_number, '株式会社 マサル');
ok($zip->set_number('1358436')->is_valid_number, '株式会社 ヤマタネ 情報本部');
ok($zip->set_number('1358440')->is_valid_number, '江東オール印刷 株式会社');
ok($zip->set_number('1358443')->is_valid_number, '社団法人 日本倉庫協会');
ok($zip->set_number('1358445')->is_valid_number, '旭硝子保険マネジメント 株式会社');
ok($zip->set_number('1358448')->is_valid_number, '東京アール・ビー商事 株式会社');
ok($zip->set_number('1358451')->is_valid_number, '株式会社 JPビジネスサービス');
ok($zip->set_number('1358458')->is_valid_number, '(株) ミスミ');
ok($zip->set_number('1358460')->is_valid_number, '株式会社 大和総研 本社');
ok($zip->set_number('1358461')->is_valid_number, '株式会社 大和総研 東京センター');
ok($zip->set_number('1358464')->is_valid_number, '財団法人 競馬農林水産情報衛星通信機構 (グリーンチャンネル)');
ok($zip->set_number('1358470')->is_valid_number, '株式会社 レナウン');
ok($zip->set_number('1358471')->is_valid_number, '小川テント 株式会社');
ok($zip->set_number('1358473')->is_valid_number, '財団法人 未来工学研究所');
ok($zip->set_number('1358477')->is_valid_number, '日本中央競馬会 電話投票センター');
ok($zip->set_number('1358480')->is_valid_number, '株式会社 ムトウユニパック');
ok($zip->set_number('1358481')->is_valid_number, '東京倉庫協会');
ok($zip->set_number('1358482')->is_valid_number, '株式会社 前川製作所');
ok($zip->set_number('1358501')->is_valid_number, '株式会社 ヤマタネ');
ok($zip->set_number('1358504')->is_valid_number, '株式会社 ユニパック・ダイレクト');
ok($zip->set_number('1358505')->is_valid_number, '東芝情報機器 株式会社');
ok($zip->set_number('1358508')->is_valid_number, 'オーク 株式会社');
ok($zip->set_number('1358510')->is_valid_number, '大丸コアビル');
ok($zip->set_number('1358511')->is_valid_number, '日本アイ・ビー・エム 株式会社 豊洲事業所');
ok($zip->set_number('1358512')->is_valid_number, '株式会社 フジクラ');
ok($zip->set_number('1358513')->is_valid_number, '澁澤倉庫 株式会社');
ok($zip->set_number('1358514')->is_valid_number, 'アーバンドック ららぽーと豊洲アネックス');
ok($zip->set_number('1358517')->is_valid_number, '(株) スポーツニッポン新聞 東京本社');
ok($zip->set_number('1358518')->is_valid_number, 'リコーリース 株式会社');
ok($zip->set_number('1358521')->is_valid_number, '日本赤十字社 血液事業本部 辰巳分室');
ok($zip->set_number('1358522')->is_valid_number, '株式会社 芳賀洋紙店');
ok($zip->set_number('1358523')->is_valid_number, '日本赤十字社 血液事業本部 中央骨髄データセンター');
ok($zip->set_number('1358525')->is_valid_number, 'フジコピアン 株式会社 東京支店');
ok($zip->set_number('1358528')->is_valid_number, '昭和リース 株式会社');
ok($zip->set_number('1358530')->is_valid_number, '清水建設 (株) 技術研究所 管理部');
ok($zip->set_number('1358531')->is_valid_number, '株式会社 トラベルプラザインターナショナル');
ok($zip->set_number('1358532')->is_valid_number, '日興ビジネスシステムズ 株式会社');
ok($zip->set_number('1358533')->is_valid_number, '東京商船大学');
ok($zip->set_number('1358535')->is_valid_number, '(株) 長谷川萬治商店');
ok($zip->set_number('1358540')->is_valid_number, 'エース損害保険 株式会社');
ok($zip->set_number('1358548')->is_valid_number, '芝浦工業大学');
ok($zip->set_number('1358550')->is_valid_number, '財団法人 癌研究会');
ok($zip->set_number('1358551')->is_valid_number, '日産ディーゼル東京販売 株式会社');
ok($zip->set_number('1358552')->is_valid_number, '日本衛星放送 (株) WOWOW');
ok($zip->set_number('1358553')->is_valid_number, '日新製糖 株式会社 余暇開発本部 ドゥ・スポーツプラザ晴海');
ok($zip->set_number('1358554')->is_valid_number, '日本電子計算 株式会社');
ok($zip->set_number('1358555')->is_valid_number, '滝商事 株式会社');
ok($zip->set_number('1358556')->is_valid_number, '(株) 東京宇佐美');
ok($zip->set_number('1358557')->is_valid_number, 'セイコークロック 株式会社');
ok($zip->set_number('1358558')->is_valid_number, '王子製紙 株式会社 東雲研究センター');
ok($zip->set_number('1358559')->is_valid_number, 'シネックスインフォテック 株式会社');
ok($zip->set_number('1358560')->is_valid_number, '日本ユニシス 株式会社');
ok($zip->set_number('1358563')->is_valid_number, '六三印刷 株式会社');
ok($zip->set_number('1358565')->is_valid_number, 'カテナ (株)');
ok($zip->set_number('1358566')->is_valid_number, 'デイリースポーツ社');
ok($zip->set_number('1358567')->is_valid_number, '株式会社 久米設計');
ok($zip->set_number('1358570')->is_valid_number, '日新製糖 株式会社 豊洲工場');
ok($zip->set_number('1358573')->is_valid_number, '(株)ジャノメクレディア 出光クレジット係');
ok($zip->set_number('1358574')->is_valid_number, 'ジャノメクレディア 情報処理本部');
ok($zip->set_number('1358575')->is_valid_number, '株式会社 ペイロール');
ok($zip->set_number('1358577')->is_valid_number, '昭和大学附属豊洲病院');
ok($zip->set_number('1358578')->is_valid_number, '太平洋セメント 株式会社');
ok($zip->set_number('1358579')->is_valid_number, '株式会社 ナカノ 東京支店');
ok($zip->set_number('1358581')->is_valid_number, '株式会社 りそな銀行');
ok($zip->set_number('1358582')->is_valid_number, '株式会社 りそなホールディングス');
ok($zip->set_number('1358585')->is_valid_number, '宗教法人 カトリック中央協議会');
ok($zip->set_number('1358586')->is_valid_number, '明治屋商事 株式会社');
ok($zip->set_number('1358587')->is_valid_number, '財団法人 日本海事科学振興財団');
ok($zip->set_number('1358602')->is_valid_number, '株式会社 アイアイジェイフィナンシャルシステムズ');
ok($zip->set_number('1358611')->is_valid_number, 'アクサ損害保険 株式会社');
ok($zip->set_number('1358614')->is_valid_number, 'アーバンドック ららぽーと豊洲');
ok($zip->set_number('1358616')->is_valid_number, '株式会社 博報堂DYホールディングス');
ok($zip->set_number('1358617')->is_valid_number, '株式会社 博報堂DYアイ・オー');
ok($zip->set_number('1358618')->is_valid_number, '株式会社 博報堂DYトータルサポート');
ok($zip->set_number('1358619')->is_valid_number, '株式会社 博報堂プロダクツ');
ok($zip->set_number('1358620')->is_valid_number, '株式会社 博報堂アドダム');
ok($zip->set_number('1358621')->is_valid_number, '株式会社 博報堂アイ・スタジオ');
ok($zip->set_number('1358622')->is_valid_number, '株式会社 乃村工藝社');
ok($zip->set_number('1358625')->is_valid_number, '株式会社 東京ヒューマニアエンタプライズ');
ok($zip->set_number('1358630')->is_valid_number, '国際研究交流大学村 東京国際交流館');
ok($zip->set_number('1358631')->is_valid_number, 'サントリー 株式会社');
ok($zip->set_number('1358632')->is_valid_number, 'サントリーフーズ 株式会社');
ok($zip->set_number('1358639')->is_valid_number, '東京都赤十字血液センター');
ok($zip->set_number('1358641')->is_valid_number, 'ヤマトマテリアル 株式会社');
ok($zip->set_number('1358650')->is_valid_number, 'ソフトバンクテレコム 株式会社');
ok($zip->set_number('1358655')->is_valid_number, '日商岩井 株式会社');
ok($zip->set_number('1358659')->is_valid_number, '株式会社 コックス');
ok($zip->set_number('1358661')->is_valid_number, '日本テレコムIDC 株式会社');
ok($zip->set_number('1358666')->is_valid_number, '日本ベニア 株式会社 東京営業所');
ok($zip->set_number('1358668')->is_valid_number, '株式会社 衛星ネットワーク');
ok($zip->set_number('1358670')->is_valid_number, '株式会社 システムソフト 東京センター');
ok($zip->set_number('1358671')->is_valid_number, '株式会社 エヌ・ティ・ティ・データ');
ok($zip->set_number('1358677')->is_valid_number, 'エヌ・ティ・ティ・データ カスタマサービス 株式会社');
ok($zip->set_number('1358678')->is_valid_number, 'NTTデータ東京SMS 株式会社');
ok($zip->set_number('1358686')->is_valid_number, '富士通エフ・アイ・ピー 株式会社');
ok($zip->set_number('1358701')->is_valid_number, 'ホテルグランパシフィック・メリディアン');
ok($zip->set_number('1358707')->is_valid_number, 'アクアシティお台場');
ok($zip->set_number('1358710')->is_valid_number, '株式会社 IHI');
ok($zip->set_number('1358711')->is_valid_number, 'かえつ有明中学校・かえつ有明高等学校');
ok($zip->set_number('1358717')->is_valid_number, '株式会社 オートバックスセブン');
ok($zip->set_number('1358718')->is_valid_number, 'メディアージュ');
ok($zip->set_number('1358720')->is_valid_number, '明治生命保険相互会社');
ok($zip->set_number('1358721')->is_valid_number, '東京スポーツ新聞社');
ok($zip->set_number('1358722')->is_valid_number, '安田信託銀行 (株) 証券代行部');
ok($zip->set_number('1358723')->is_valid_number, '安田信託銀行 株式会社 事務推進部');
ok($zip->set_number('1358730')->is_valid_number, '株式会社 内田洋行');
ok($zip->set_number('1358731')->is_valid_number, '石川島播磨重工業 株式会社 東京第一工場');
ok($zip->set_number('1358732')->is_valid_number, '石川島播磨重工業 株式会社 東二テクニカルセンター');
ok($zip->set_number('1358733')->is_valid_number, '石川島播磨重工業 株式会社 豊洲総合事務所');
ok($zip->set_number('1358738')->is_valid_number, '財団法人 郵便文化振興協会');
ok($zip->set_number('1368405')->is_valid_number, 'JKホールディングス 株式会社');
ok($zip->set_number('1368501')->is_valid_number, '川鉄建材');
ok($zip->set_number('1368502')->is_valid_number, '三洋工業');
ok($zip->set_number('1368505')->is_valid_number, '江東東税務署');
ok($zip->set_number('1368507')->is_valid_number, '翼システム');
ok($zip->set_number('1368512')->is_valid_number, 'セイコーインスツルメンツ 株式会社');
ok($zip->set_number('1368513')->is_valid_number, '亀戸労働基準監督署');
ok($zip->set_number('1368515')->is_valid_number, '日本化学工業 株式会社');
ok($zip->set_number('1368517')->is_valid_number, '大末建設 株式会社');
ok($zip->set_number('1368521')->is_valid_number, 'ヤマト特殊鋼 株式会社');
ok($zip->set_number('1368522')->is_valid_number, 'サンコーコンサルタント 株式会社 東京本社');
ok($zip->set_number('1368523')->is_valid_number, 'みずほ信託銀行 株式会社');
ok($zip->set_number('1368525')->is_valid_number, '日本年金機構 江東年金事務所');
ok($zip->set_number('1368531')->is_valid_number, '吉野工業所');
ok($zip->set_number('1368533')->is_valid_number, '江東都税事務所');
ok($zip->set_number('1368540')->is_valid_number, '昭電');
ok($zip->set_number('1368543')->is_valid_number, '物林 株式会社');
ok($zip->set_number('1368550')->is_valid_number, '多田建設 株式会社');
ok($zip->set_number('1368555')->is_valid_number, '日本レジャーカードシステム 株式会社');
ok($zip->set_number('1368558')->is_valid_number, '協和発酵フーズ (株)');
ok($zip->set_number('1368560')->is_valid_number, '日本テレコム 株式会社');
ok($zip->set_number('1368567')->is_valid_number, '三和紙業 株式会社');
ok($zip->set_number('1368570')->is_valid_number, '株式会社 竹中土木');
ok($zip->set_number('1368575')->is_valid_number, '株式会社 ぎょうせい');
ok($zip->set_number('1368577')->is_valid_number, '基礎地盤コンサルタンツ 株式会社');
ok($zip->set_number('1368580')->is_valid_number, '丸文 株式会社 南砂事業所');
ok($zip->set_number('1368581')->is_valid_number, '(株) CRC総合研究所');
ok($zip->set_number('1368588')->is_valid_number, '川崎重工業 株式会社 東京設計事務所');
ok($zip->set_number('1368589')->is_valid_number, '株式会社 志正堂');
ok($zip->set_number('1368603')->is_valid_number, '(株) 徳間書店');
ok($zip->set_number('1368605')->is_valid_number, '株式会社 銘林');
ok($zip->set_number('1368607')->is_valid_number, '内田食品 株式会社');
ok($zip->set_number('1368611')->is_valid_number, '神東塗料 (株)');
ok($zip->set_number('1368612')->is_valid_number, '東京集成材工業 株式会社 東京営業所');
ok($zip->set_number('1368615')->is_valid_number, '株式会社 もくもく');
ok($zip->set_number('1368620')->is_valid_number, 'ヤバネスポーツ 株式会社');
ok($zip->set_number('1368622')->is_valid_number, '兼松日産農林 株式会社');
ok($zip->set_number('1368626')->is_valid_number, '株式会社 西林');
ok($zip->set_number('1368627')->is_valid_number, 'NECソフト 株式会社');
ok($zip->set_number('1368630')->is_valid_number, '江戸川木材工業 株式会社');
ok($zip->set_number('1368635')->is_valid_number, 'JST 株式会社');
ok($zip->set_number('1368637')->is_valid_number, '株式会社 インテック');
ok($zip->set_number('1368640')->is_valid_number, '株式会社 日本デジタル研究所');
ok($zip->set_number('1368648')->is_valid_number, '株式会社 IHI 砂町工場');
ok($zip->set_number('1368666')->is_valid_number, 'トーヨーカネツ 株式会社 本社');
ok($zip->set_number('1368670')->is_valid_number, 'パラマウントベッド 株式会社');
ok($zip->set_number('1368675')->is_valid_number, 'ヤマトシステム開発 株式会社');
ok($zip->set_number('1368686')->is_valid_number, '株式会社 三越伊勢丹通信販売');
ok($zip->set_number('1368711')->is_valid_number, '日本ヒューレット・パッカード 株式会社');
ok($zip->set_number('1368723')->is_valid_number, '株式会社 東京ダンケ');
ok($zip->set_number('1368733')->is_valid_number, '日鉄商事 株式会社');
ok($zip->set_number('1368880')->is_valid_number, '株式会社 鴻池組');
ok($zip->set_number('1368908')->is_valid_number, '株式会社 明治');
ok($zip->set_number('1378081')->is_valid_number, '三菱UFJ信託銀行 株式会社 証券代行部');
ok($zip->set_number('1378088')->is_valid_number, '株式会社 フジテレビジョン');
ok($zip->set_number('1378581')->is_valid_number, '郵便局ビジネスサポート (株)');
ok($zip->set_number('1378623')->is_valid_number, '北三 株式会社');
ok($zip->set_number('1378650')->is_valid_number, '日本証券代行 株式会社 代理部');
ok($zip->set_number('1378686')->is_valid_number, '株式会社 ニッポン放送');
ok($zip->set_number('1408501')->is_valid_number, 'ニシヤマ');
ok($zip->set_number('1408502')->is_valid_number, '日立電子サービス 株式会社 システム事業本部');
ok($zip->set_number('1408505')->is_valid_number, '(株)ニコン');
ok($zip->set_number('1408506')->is_valid_number, '三菱総研DCS 株式会社');
ok($zip->set_number('1408507')->is_valid_number, '米山紙商事 株式会社');
ok($zip->set_number('1408508')->is_valid_number, '富士通 (株) 大井町ビル');
ok($zip->set_number('1408511')->is_valid_number, '株式会社 ニッセイコム');
ok($zip->set_number('1408512')->is_valid_number, '株式会社 日立システムアンドサービス');
ok($zip->set_number('1408515')->is_valid_number, '大成温調 株式会社');
ok($zip->set_number('1408516')->is_valid_number, 'フクビ化学工業');
ok($zip->set_number('1408520')->is_valid_number, '関西ペイント 株式会社 東京事務所');
ok($zip->set_number('1408521')->is_valid_number, '前田硝子 株式会社');
ok($zip->set_number('1408523')->is_valid_number, '日産プリンス東京販売 株式会社');
ok($zip->set_number('1408525')->is_valid_number, 'ドウシシャ 東京本社');
ok($zip->set_number('1408529')->is_valid_number, 'プリマハム (株)');
ok($zip->set_number('1408530')->is_valid_number, 'シンワ 株式会社');
ok($zip->set_number('1408531')->is_valid_number, '光文工業');
ok($zip->set_number('1408533')->is_valid_number, '株式会社 理研オプテック');
ok($zip->set_number('1408536')->is_valid_number, '株式会社 東京書芸館');
ok($zip->set_number('1408538')->is_valid_number, '株式会社 加藤製作所');
ok($zip->set_number('1408539')->is_valid_number, '三愛石油');
ok($zip->set_number('1408540')->is_valid_number, '株式会社 シンクロン');
ok($zip->set_number('1408541')->is_valid_number, 'ハイデルベルグ・ジャパン 株式会社');
ok($zip->set_number('1408542')->is_valid_number, 'ニシヤマ');
ok($zip->set_number('1408543')->is_valid_number, '田中商事 株式会社');
ok($zip->set_number('1408547')->is_valid_number, '斎藤コード製造 (株)');
ok($zip->set_number('1408548')->is_valid_number, '企業年金ビジネスサービス 株式会社');
ok($zip->set_number('1408549')->is_valid_number, '企業年金ビジネスサービス 株式会社');
ok($zip->set_number('1408550')->is_valid_number, '三菱伸銅 株式会社');
ok($zip->set_number('1408551')->is_valid_number, '平河ヒューテック 株式会社');
ok($zip->set_number('1408552')->is_valid_number, '東京下田工業 株式会社');
ok($zip->set_number('1408558')->is_valid_number, '株式会社 竹虎');
ok($zip->set_number('1408560')->is_valid_number, '(株) 東京測器研究所');
ok($zip->set_number('1408563')->is_valid_number, 'ニッサン・モータースポーツ・インターナショナル 株式会社');
ok($zip->set_number('1408566')->is_valid_number, 'サンワサプライ (株) 東京サプライセンター');
ok($zip->set_number('1408567')->is_valid_number, '富士通サポートアンドサービス 株式会社');
ok($zip->set_number('1408571')->is_valid_number, '株式会社 日平トヤマ');
ok($zip->set_number('1408572')->is_valid_number, '株式会社 日立製作所 情報・通信グループ');
ok($zip->set_number('1408573')->is_valid_number, '株式会社 日立製作所 情報・通信グループ');
ok($zip->set_number('1408576')->is_valid_number, '(株) ロキテクノ');
ok($zip->set_number('1408580')->is_valid_number, 'テクノレント 株式会社');
ok($zip->set_number('1408590')->is_valid_number, '株式会社 バンダイナムコゲームス');
ok($zip->set_number('1408601')->is_valid_number, '(株) ニコン大井製作所');
ok($zip->set_number('1408607')->is_valid_number, '株式会社 日本航空ジャパン');
ok($zip->set_number('1408611')->is_valid_number, '株式会社 サンゲツ 東京店');
ok($zip->set_number('1408613')->is_valid_number, '日本ドライケミカル 株式会社');
ok($zip->set_number('1408614')->is_valid_number, '株式会社 コスモトレード&サービス');
ok($zip->set_number('1408615')->is_valid_number, '寺田倉庫 株式会社');
ok($zip->set_number('1408616')->is_valid_number, 'ベークライト商事 株式会社');
ok($zip->set_number('1408617')->is_valid_number, 'ダウ・ケミカル日本 株式会社');
ok($zip->set_number('1408619')->is_valid_number, '株式会社 アクセス国際ネットワーク');
ok($zip->set_number('1408621')->is_valid_number, 'ネットワンシステムズ 株式会社');
ok($zip->set_number('1408623')->is_valid_number, '富士通 株式会社 (東京MIビル)');
ok($zip->set_number('1408625')->is_valid_number, 'JAL マイレージバンク日本地区会員事務局');
ok($zip->set_number('1408626')->is_valid_number, 'アイ・シー・アイ・ジャパン 株式会社');
ok($zip->set_number('1408628')->is_valid_number, '日本軽金属');
ok($zip->set_number('1408630')->is_valid_number, '上野メタレックス');
ok($zip->set_number('1408631')->is_valid_number, '株式会社 ナイキジャパン');
ok($zip->set_number('1408634')->is_valid_number, '日軽商事 (株)');
ok($zip->set_number('1408637')->is_valid_number, '日本航空 株式会社');
ok($zip->set_number('1408639')->is_valid_number, 'シティバンク銀行 株式会社');
ok($zip->set_number('1408640')->is_valid_number, '東芝ライテック');
ok($zip->set_number('1408644')->is_valid_number, '株式会社 東機貿 天王州オフィス');
ok($zip->set_number('1408650')->is_valid_number, 'キヤノンシステムアンドサポート 株式会社');
ok($zip->set_number('1408653')->is_valid_number, '株式会社 ジャルキャピタル');
ok($zip->set_number('1408655')->is_valid_number, '(株) リコー 空白システムセンター');
ok($zip->set_number('1408656')->is_valid_number, '(株) ジャルカード');
ok($zip->set_number('1408658')->is_valid_number, '株式会社 ジャルパック');
ok($zip->set_number('1408660')->is_valid_number, '東芝ライテック');
ok($zip->set_number('1408661')->is_valid_number, '(株) 恒陽社印刷');
ok($zip->set_number('1408666')->is_valid_number, '(株) 日光商会');
ok($zip->set_number('1408668')->is_valid_number, '山岸塗装 株式会社 本社');
ok($zip->set_number('1408670')->is_valid_number, '東洋紙業 株式会社 東京本社');
ok($zip->set_number('1408675')->is_valid_number, '日本ペイント (株)');
ok($zip->set_number('1408677')->is_valid_number, '日本ペイント販売 (株) 東日本支店');
ok($zip->set_number('1408678')->is_valid_number, '株式会社 古西電機');
ok($zip->set_number('1408680')->is_valid_number, '丸磯建設 株式会社 本社、東京支店');
ok($zip->set_number('1408687')->is_valid_number, '日本ゼネラルモーターズ 株式会社');
ok($zip->set_number('1408688')->is_valid_number, '沖電気工事 株式会社');
ok($zip->set_number('1408702')->is_valid_number, '株式会社 勝亦電機製作所');
ok($zip->set_number('1408707')->is_valid_number, '品川女子学院');
ok($zip->set_number('1408709')->is_valid_number, '社団法人 日本生花通信配達協会');
ok($zip->set_number('1408710')->is_valid_number, '第一三共 株式会社 品川研究開発センター');
ok($zip->set_number('1408711')->is_valid_number, '株式会社 寺岡製作所');
ok($zip->set_number('1408715')->is_valid_number, '品川区役所');
ok($zip->set_number('1408716')->is_valid_number, '東京都品川都税事務所');
ok($zip->set_number('1408717')->is_valid_number, '法務局 品川出張所');
ok($zip->set_number('1408721')->is_valid_number, '山下電気 株式会社');
ok($zip->set_number('1408722')->is_valid_number, 'いすゞ自動車 株式会社');
ok($zip->set_number('1408788')->is_valid_number, '東京都民銀行 楽天支店');
ok($zip->set_number('1418001')->is_valid_number, '大日本印刷 株式会社');
ok($zip->set_number('1418411')->is_valid_number, '株式会社 学研エデュケーショナル');
ok($zip->set_number('1418412')->is_valid_number, '株式会社 学研パブリッシング');
ok($zip->set_number('1418413')->is_valid_number, '株式会社 学研教育出版');
ok($zip->set_number('1418414')->is_valid_number, '株式会社 学研メディカル秀潤社');
ok($zip->set_number('1418415')->is_valid_number, '株式会社 学研マーケティング');
ok($zip->set_number('1418416')->is_valid_number, '株式会社 学研教育みらい');
ok($zip->set_number('1418417')->is_valid_number, '株式会社 学研ネクスト');
ok($zip->set_number('1418418')->is_valid_number, '株式会社 学研プロダクツサポート');
ok($zip->set_number('1418419')->is_valid_number, '株式会社 学研ステイフル');
ok($zip->set_number('1418420')->is_valid_number, '株式会社 学研ココファンホールディングス');
ok($zip->set_number('1418421')->is_valid_number, '株式会社 学研ロジスティクス');
ok($zip->set_number('1418422')->is_valid_number, '株式会社 学研メディコン');
ok($zip->set_number('1418423')->is_valid_number, '銀座アスター食品 株式会社');
ok($zip->set_number('1418501')->is_valid_number, 'アルパイン 株式会社');
ok($zip->set_number('1418503')->is_valid_number, 'THK 株式会社');
ok($zip->set_number('1418504')->is_valid_number, '大和証券 株式会社 五反田支店');
ok($zip->set_number('1418505')->is_valid_number, '三菱電機クレジット 株式会社');
ok($zip->set_number('1418507')->is_valid_number, '東京電力 品川支社');
ok($zip->set_number('1418508')->is_valid_number, 'イワタボルト 株式会社');
ok($zip->set_number('1418510')->is_valid_number, '学習研究社');
ok($zip->set_number('1418512')->is_valid_number, '株式会社 ハマイ');
ok($zip->set_number('1418514')->is_valid_number, '日本アイ・ビー・エム 株式会社');
ok($zip->set_number('1418515')->is_valid_number, '正電社');
ok($zip->set_number('1418517')->is_valid_number, '長田電機工業 株式会社');
ok($zip->set_number('1418519')->is_valid_number, '共和化工 (株)');
ok($zip->set_number('1418520')->is_valid_number, '株式会社 レナウン');
ok($zip->set_number('1418521')->is_valid_number, '社団法人 関東年金福祉協会');
ok($zip->set_number('1418522')->is_valid_number, '伊藤忠テクノソリューションズ (株) 大崎オフィス');
ok($zip->set_number('1418525')->is_valid_number, '小澤物産 (株)');
ok($zip->set_number('1418526')->is_valid_number, 'UFJニコス 株式会社 五反田支店');
ok($zip->set_number('1418529')->is_valid_number, '日本ブリタニカ (株)');
ok($zip->set_number('1418530')->is_valid_number, '株式会社 ジェーシー・フーズ');
ok($zip->set_number('1418533')->is_valid_number, '神田通信工業 株式会社');
ok($zip->set_number('1418534')->is_valid_number, '住江織物 (株) 東京支店');
ok($zip->set_number('1418535')->is_valid_number, 'NEC Avio赤外線テクノロジー 株式会社');
ok($zip->set_number('1418540')->is_valid_number, '新光商事 株式会社');
ok($zip->set_number('1418544')->is_valid_number, '(株) エフ・ディ・シィ・プロダクツ');
ok($zip->set_number('1418545')->is_valid_number, '藤倉ゴム工業 株式会社');
ok($zip->set_number('1418550')->is_valid_number, '株式会社 ジェットツアー');
ok($zip->set_number('1418555')->is_valid_number, '辰巳産業 株式会社');
ok($zip->set_number('1418556')->is_valid_number, '甲陽建設工業 株式会社');
ok($zip->set_number('1418557')->is_valid_number, '久光製薬 株式会社 東京本社');
ok($zip->set_number('1418559')->is_valid_number, 'ヤスマ (株)');
ok($zip->set_number('1418560')->is_valid_number, '日本精工 株式会社');
ok($zip->set_number('1418561')->is_valid_number, '太陽金網 株式会社');
ok($zip->set_number('1418565')->is_valid_number, '(株) 明電舎 東京事業所');
ok($zip->set_number('1418566')->is_valid_number, '株式会社 寺岡精工 営業本部');
ok($zip->set_number('1418567')->is_valid_number, '光村印刷 (株)');
ok($zip->set_number('1418568')->is_valid_number, '品川商工 株式会社');
ok($zip->set_number('1418571')->is_valid_number, '株式会社 ユーエスシー');
ok($zip->set_number('1418572')->is_valid_number, '日本年金機構 品川年金事務所');
ok($zip->set_number('1418575')->is_valid_number, 'NSK販売 株式会社');
ok($zip->set_number('1418576')->is_valid_number, '日立オムロンターミナルソリューションズ 株式会社');
ok($zip->set_number('1418580')->is_valid_number, '葵プロモーション');
ok($zip->set_number('1418582')->is_valid_number, '株式会社 日本アクセス');
ok($zip->set_number('1418583')->is_valid_number, '富士通デバイス 株式会社');
ok($zip->set_number('1418584')->is_valid_number, '三井金属鉱業 株式会社');
ok($zip->set_number('1418585')->is_valid_number, '全国健康保険協会 東京支部');
ok($zip->set_number('1418586')->is_valid_number, 'ヒロセ電機 株式会社 営業本部');
ok($zip->set_number('1418588')->is_valid_number, 'センチュリーメディカル 株式会社');
ok($zip->set_number('1418602')->is_valid_number, '立正大学');
ok($zip->set_number('1418603')->is_valid_number, '株式会社 サンリオ');
ok($zip->set_number('1418604')->is_valid_number, '新日鉄エンジニアリング 株式会社');
ok($zip->set_number('1418605')->is_valid_number, '日本ケミコン 株式会社');
ok($zip->set_number('1418606')->is_valid_number, '協同広告 株式会社');
ok($zip->set_number('1418610')->is_valid_number, 'ソニー 株式会社 ソニーシティ大崎');
ok($zip->set_number('1418611')->is_valid_number, '三英電業 株式会社');
ok($zip->set_number('1418615')->is_valid_number, '三明化成 株式会社');
ok($zip->set_number('1418616')->is_valid_number, '明電興産 株式会社');
ok($zip->set_number('1418618')->is_valid_number, 'オリックス・システム 株式会社');
ok($zip->set_number('1418620')->is_valid_number, 'セメダイン 株式会社');
ok($zip->set_number('1418621')->is_valid_number, '(株) キャプティ');
ok($zip->set_number('1418623')->is_valid_number, '東京日産自動車販売 株式会社');
ok($zip->set_number('1418628')->is_valid_number, '株式会社 ランドコンピュータ');
ok($zip->set_number('1418629')->is_valid_number, '株式会社 セントラルフーズ');
ok($zip->set_number('1418630')->is_valid_number, '富士通コンポーネント 株式会社');
ok($zip->set_number('1418631')->is_valid_number, '株式会社 コミューチュア');
ok($zip->set_number('1418633')->is_valid_number, '東洋紡績 株式会社');
ok($zip->set_number('1418636')->is_valid_number, 'オートビジネスサービス 株式会社');
ok($zip->set_number('1418637')->is_valid_number, 'リコーエレメックス 株式会社');
ok($zip->set_number('1418638')->is_valid_number, '(株) 千趣会');
ok($zip->set_number('1418639')->is_valid_number, 'ネツレン');
ok($zip->set_number('1418640')->is_valid_number, '東洋製缶 株式会社 東京工場');
ok($zip->set_number('1418641')->is_valid_number, 'シーメンス 株式会社');
ok($zip->set_number('1418642')->is_valid_number, '清泉女子大学');
ok($zip->set_number('1418643')->is_valid_number, '(株) ローソン');
ok($zip->set_number('1418646')->is_valid_number, '大崎電気工業 株式会社');
ok($zip->set_number('1418647')->is_valid_number, '日本コムシス 株式会社');
ok($zip->set_number('1418648')->is_valid_number, '東京医療保健大学');
ok($zip->set_number('1418650')->is_valid_number, '日本建工 株式会社');
ok($zip->set_number('1418653')->is_valid_number, 'ファイザー製薬 (株) コンシューマー・ヘルスケア事業部');
ok($zip->set_number('1418655')->is_valid_number, '株式会社 ジャパンコーポレーション');
ok($zip->set_number('1418656')->is_valid_number, '日本クラフトフーズ 株式会社');
ok($zip->set_number('1418657')->is_valid_number, '株式会社 ジェイ・アイ・シー');
ok($zip->set_number('1418658')->is_valid_number, '井上電気 株式会社');
ok($zip->set_number('1418660')->is_valid_number, 'ホーチキ 株式会社');
ok($zip->set_number('1418662')->is_valid_number, '株式会社 ニューズ出版');
ok($zip->set_number('1418664')->is_valid_number, '東芝テック 株式会社');
ok($zip->set_number('1418665')->is_valid_number, '前田道路 株式会社');
ok($zip->set_number('1418666')->is_valid_number, '朝日建物');
ok($zip->set_number('1418668')->is_valid_number, '株式会社 学研クレジット');
ok($zip->set_number('1418670')->is_valid_number, '(株) アイフォー');
ok($zip->set_number('1418671')->is_valid_number, 'シック・ジャパン 株式会社');
ok($zip->set_number('1418672')->is_valid_number, '株式会社 日立情報システムズ');
ok($zip->set_number('1418673')->is_valid_number, 'シーメンスメディカルソリューションズ・ダイアグノスティクス (株)');
ok($zip->set_number('1418676')->is_valid_number, '株式会社 技術評論社');
ok($zip->set_number('1418680')->is_valid_number, 'ソニー 株式会社 本社');
ok($zip->set_number('1418681')->is_valid_number, 'オリックス・レンテック 株式会社');
ok($zip->set_number('1418683')->is_valid_number, '武藤工業 株式会社');
ok($zip->set_number('1418686')->is_valid_number, '住友重機械工業 (株)');
ok($zip->set_number('1418687')->is_valid_number, '株式会社 ソニー・ヤングラボラトリー');
ok($zip->set_number('1418688')->is_valid_number, '株式会社 神戸製鋼所 東京本社');
ok($zip->set_number('1418701')->is_valid_number, '株式会社 第一興商');
ok($zip->set_number('1418702')->is_valid_number, '保安工業 株式会社');
ok($zip->set_number('1418707')->is_valid_number, 'グラフテック 株式会社');
ok($zip->set_number('1418710')->is_valid_number, '城南信用金庫');
ok($zip->set_number('1418715')->is_valid_number, '(株) 電波新聞社');
ok($zip->set_number('1428501')->is_valid_number, '星薬科大学');
ok($zip->set_number('1428511')->is_valid_number, 'SMK 株式会社');
ok($zip->set_number('1428522')->is_valid_number, '日本信託銀行 株式会社 事務部');
ok($zip->set_number('1428533')->is_valid_number, '杉本電器 株式会社');
ok($zip->set_number('1428540')->is_valid_number, '荏原税務署');
ok($zip->set_number('1428550')->is_valid_number, '青稜中学高等学校');
ok($zip->set_number('1428555')->is_valid_number, '昭和大学');
ok($zip->set_number('1428558')->is_valid_number, '大陽日酸 株式会社');
ok($zip->set_number('1428567')->is_valid_number, '都築電気 株式会社');
ok($zip->set_number('1428585')->is_valid_number, '国文学研究資料館');
ok($zip->set_number('1428588')->is_valid_number, '東光サービス 株式会社');
ok($zip->set_number('1428611')->is_valid_number, '株式会社 三英社製作所');
ok($zip->set_number('1428639')->is_valid_number, '株式会社 大興電機製作所');
ok($zip->set_number('1428666')->is_valid_number, '昭和大学病院');
ok($zip->set_number('1436501')->is_valid_number, 'ブラック・ボックス・ジャパン 株式会社');
ok($zip->set_number('1438504')->is_valid_number, '株式会社 ヤマダコーポレーション');
ok($zip->set_number('1438505')->is_valid_number, '医療法人財団 仁医会 牧田総合病院');
ok($zip->set_number('1438506')->is_valid_number, '住電オプコム 株式会社');
ok($zip->set_number('1438507')->is_valid_number, '株式会社 ケツト科学研究所');
ok($zip->set_number('1438508')->is_valid_number, '株式会社 メリーチョコレートカムパニー');
ok($zip->set_number('1438511')->is_valid_number, '池伝 株式会社');
ok($zip->set_number('1438514')->is_valid_number, '東京海上日動ローンサービス 株式会社');
ok($zip->set_number('1438515')->is_valid_number, '山一電機 株式会社');
ok($zip->set_number('1438528')->is_valid_number, '共栄工業 株式会社');
ok($zip->set_number('1438531')->is_valid_number, 'フコク物産 株式会社');
ok($zip->set_number('1438533')->is_valid_number, '株式会社 トミタ');
ok($zip->set_number('1438535')->is_valid_number, '株式会社 増田製作所');
ok($zip->set_number('1438538')->is_valid_number, '株式会社 ジーネット 東京支社');
ok($zip->set_number('1438539')->is_valid_number, 'テクニカル電子 株式会社');
ok($zip->set_number('1438540')->is_valid_number, '学校法人 東邦大学');
ok($zip->set_number('1438541')->is_valid_number, '東邦大学 医療センター 大森病院');
ok($zip->set_number('1438544')->is_valid_number, '長野計器 株式会社');
ok($zip->set_number('1438550')->is_valid_number, '日外アソシエーツ 株式会社');
ok($zip->set_number('1438552')->is_valid_number, '東京都水道局 大田北営業所');
ok($zip->set_number('1438555')->is_valid_number, '株式会社 リコー 大森事務所');
ok($zip->set_number('1438558')->is_valid_number, '株式会社 電業社機械製作所');
ok($zip->set_number('1438560')->is_valid_number, 'サンワテクノス 株式会社');
ok($zip->set_number('1438564')->is_valid_number, 'パイオニア (株) 大森事業所');
ok($zip->set_number('1438565')->is_valid_number, '大森税務署');
ok($zip->set_number('1438567')->is_valid_number, '株式会社 ベンカン・ジャパン');
ok($zip->set_number('1438568')->is_valid_number, '株式会社 ユニックス');
ok($zip->set_number('1438570')->is_valid_number, '株式会社 浅井');
ok($zip->set_number('1438580')->is_valid_number, '株式会社 ディスコ 本社');
ok($zip->set_number('1438585')->is_valid_number, '株式会社 NTT東日本-東京 営業部業務推進部門 公衆電話サービスセンタテレカ充当担当');
ok($zip->set_number('1448505')->is_valid_number, '株式会社 巴商会');
ok($zip->set_number('1448506')->is_valid_number, '東京都立六郷工科高等学校');
ok($zip->set_number('1448510')->is_valid_number, '株式会社 荏原製作所');
ok($zip->set_number('1448511')->is_valid_number, '東京都大田都税事務所');
ok($zip->set_number('1448513')->is_valid_number, '日本調理機 株式会社');
ok($zip->set_number('1448515')->is_valid_number, '全日本空輸 株式会社 羽田空港 第1ターミナル');
ok($zip->set_number('1448516')->is_valid_number, '株式会社 丸昌');
ok($zip->set_number('1448525')->is_valid_number, '全日本空輸 株式会社 羽田空港 第2ターミナル');
ok($zip->set_number('1448530')->is_valid_number, '蒲田社会保険事務所');
ok($zip->set_number('1448531')->is_valid_number, '株式会社 セガ');
ok($zip->set_number('1448532')->is_valid_number, '株式会社 セガ');
ok($zip->set_number('1448533')->is_valid_number, '東京都立 つばさ総合高等学校');
ok($zip->set_number('1448535')->is_valid_number, '東京工科大学');
ok($zip->set_number('1448536')->is_valid_number, '東京工科大学附属日本語学校');
ok($zip->set_number('1448544')->is_valid_number, '蒲田女子高等学校');
ok($zip->set_number('1448544')->is_valid_number, '蒲田保育専門学校');
ok($zip->set_number('1448544')->is_valid_number, '蒲田保育専門学校附属幼稚園');
ok($zip->set_number('1448550')->is_valid_number, '五十鈴 株式会社');
ok($zip->set_number('1448551')->is_valid_number, '東京計器 株式会社');
ok($zip->set_number('1448555')->is_valid_number, '日本防蝕工業 株式会社');
ok($zip->set_number('1448570')->is_valid_number, '東京南部法律事務所');
ok($zip->set_number('1448575')->is_valid_number, '全日本空輸 株式会社 国際旅客ターミナル');
ok($zip->set_number('1448577')->is_valid_number, '石川島建機 株式会社 東京本部');
ok($zip->set_number('1448580')->is_valid_number, '大田区立新蒲田福祉センター');
ok($zip->set_number('1448588')->is_valid_number, '富士通 株式会社 情報処理システムラボラトリ');
ok($zip->set_number('1448602')->is_valid_number, '株式会社 エヌエス商事');
ok($zip->set_number('1448610')->is_valid_number, '荏原エンジニアリングサービス 株式会社');
ok($zip->set_number('1448611')->is_valid_number, 'イーター電機工業 株式会社');
ok($zip->set_number('1448614')->is_valid_number, '松下電器健康保険組合 松下東京健康管理センター 松下産業衛生科学センター 東京支所');
ok($zip->set_number('1448621')->is_valid_number, '大田区役所');
ok($zip->set_number('1448622')->is_valid_number, '大田区役所');
ok($zip->set_number('1448623')->is_valid_number, '大田区教育委員会');
ok($zip->set_number('1448635')->is_valid_number, '株式会社 アートコーヒー');
ok($zip->set_number('1448650')->is_valid_number, '学校法人 片柳学園');
ok($zip->set_number('1448655')->is_valid_number, '学校法人 片柳学園 日本工学院専門学校');
ok($zip->set_number('1448656')->is_valid_number, '蒲田ゴム 株式会社');
ok($zip->set_number('1448660')->is_valid_number, 'ユザワヤ商事 株式会社');
ok($zip->set_number('1448661')->is_valid_number, '大一商事 株式会社');
ok($zip->set_number('1448677')->is_valid_number, '荏原テクノサーブ 株式会社');
ok($zip->set_number('1448678')->is_valid_number, 'ソレキア 株式会社');
ok($zip->set_number('1458501')->is_valid_number, 'アルプス電気 株式会社');
ok($zip->set_number('1458511')->is_valid_number, '天象短歌会');
ok($zip->set_number('1458515')->is_valid_number, '昭和大学 歯科病院');
ok($zip->set_number('1458523')->is_valid_number, '東京日産モーター 株式会社');
ok($zip->set_number('1458533')->is_valid_number, '銀座マギー');
ok($zip->set_number('1458558')->is_valid_number, '(株) メディカルカラー現像所');
ok($zip->set_number('1458566')->is_valid_number, '斉藤税務会計事務所');
ok($zip->set_number('1468501')->is_valid_number, 'キヤノン 株式会社');
ok($zip->set_number('1468510')->is_valid_number, 'ユシロ化学工業 株式会社');
ok($zip->set_number('1468511')->is_valid_number, '株式会社 小野測器');
ok($zip->set_number('1468512')->is_valid_number, 'キヤノン (株) 本社別館1.2');
ok($zip->set_number('1468522')->is_valid_number, '株式会社 桂川精螺製作所');
ok($zip->set_number('1468531')->is_valid_number, '医療法人 社団松和会 池上総合病院');
ok($zip->set_number('1468540')->is_valid_number, '松下電工制御テクノ 株式会社');
ok($zip->set_number('1468543')->is_valid_number, '株式会社 稲葉製作所');
ok($zip->set_number('1468544')->is_valid_number, '宗教法人 日蓮宗宗務院');
ok($zip->set_number('1468551')->is_valid_number, '日本電熱計器 株式会社');
ok($zip->set_number('1468555')->is_valid_number, '日東工器 株式会社');
ok($zip->set_number('1468567')->is_valid_number, '池上通信機 株式会社');
ok($zip->set_number('1468576')->is_valid_number, '池上 本門寺');
ok($zip->set_number('1468577')->is_valid_number, '株式会社 金羊社');
ok($zip->set_number('1468580')->is_valid_number, '株式会社 寺岡精工');
ok($zip->set_number('1468585')->is_valid_number, '株式会社 三桂製作所');
ok($zip->set_number('1468588')->is_valid_number, '日体荏原高等学校');
ok($zip->set_number('1468601')->is_valid_number, '株式会社 TKR');
ok($zip->set_number('1468610')->is_valid_number, '東京電力 株式会社 品川支社 大田営業センター');
ok($zip->set_number('1468620')->is_valid_number, '株式会社 白洋舎 東京支店');
ok($zip->set_number('1468623')->is_valid_number, '日産部品東京神奈川販売 株式会社');
ok($zip->set_number('1468631')->is_valid_number, '篠田商事 株式会社');
ok($zip->set_number('1468650')->is_valid_number, '日本プリメックス (株)');
ok($zip->set_number('1468655')->is_valid_number, '株式会社 バンダイナムコゲームス');
ok($zip->set_number('1468656')->is_valid_number, '株式会社 ナムコ');
ok($zip->set_number('1468666')->is_valid_number, '太産工業 株式会社');
ok($zip->set_number('1468668')->is_valid_number, '大宏電機 株式会社');
ok($zip->set_number('1468677')->is_valid_number, '日本オートマチックマシン');
ok($zip->set_number('1468678')->is_valid_number, '大同信号 株式会社');
ok($zip->set_number('1508001')->is_valid_number, 'NHK放送センター');
ok($zip->set_number('1508010')->is_valid_number, '東京都 渋谷区役所');
ok($zip->set_number('1508015')->is_valid_number, '株式会社 ディーシーカード');
ok($zip->set_number('1508019')->is_valid_number, '株式会社 東急百貨店 本店');
ok($zip->set_number('1508081')->is_valid_number, '株式会社 日本放送出版協会');
ok($zip->set_number('1508301')->is_valid_number, '東京法務局 渋谷出張所');
ok($zip->set_number('1508303')->is_valid_number, '京セラ 株式会社 東京原宿事業所');
ok($zip->set_number('1508306')->is_valid_number, '東京都渋谷都税事務所');
ok($zip->set_number('1508307')->is_valid_number, '公益財団法人 日本生産性本部');
ok($zip->set_number('1508319')->is_valid_number, '株式会社 東急百貨店 東横店');
ok($zip->set_number('1508322')->is_valid_number, '東京都 住宅供給公社');
ok($zip->set_number('1508324')->is_valid_number, '昭和オートレンタリース 株式会社');
ok($zip->set_number('1508325')->is_valid_number, '株式会社 トイズファクトリー');
ok($zip->set_number('1508326')->is_valid_number, '(株) スカイパーフェクト・コミュニケーションズ');
ok($zip->set_number('1508327')->is_valid_number, '株式会社 三共');
ok($zip->set_number('1508328')->is_valid_number, '財団法人 NHKサービスセンター');
ok($zip->set_number('1508330')->is_valid_number, '株式会社 そごう・西武 西武渋谷店');
ok($zip->set_number('1508333')->is_valid_number, '渋谷税務署');
ok($zip->set_number('1508338')->is_valid_number, 'キユーピー 株式会社');
ok($zip->set_number('1508340')->is_valid_number, '東急建設 株式会社');
ok($zip->set_number('1508343')->is_valid_number, '株式会社 プラップジャパン');
ok($zip->set_number('1508350')->is_valid_number, '株式会社 BMGジャパン');
ok($zip->set_number('1508355')->is_valid_number, '国際教育交換協議会');
ok($zip->set_number('1508360')->is_valid_number, 'ボッシュ 株式会社');
ok($zip->set_number('1508363')->is_valid_number, '財団法人 ベターホーム協会');
ok($zip->set_number('1508366')->is_valid_number, '学校法人 青山学院');
ok($zip->set_number('1508373')->is_valid_number, '商工組合 中央金庫 渋谷支店');
ok($zip->set_number('1508377')->is_valid_number, '株式会社 パルコ 渋谷店');
ok($zip->set_number('1508383')->is_valid_number, '株式会社 トクヤマ');
ok($zip->set_number('1508384')->is_valid_number, '日本生命保険 相互会社 渋谷総支社');
ok($zip->set_number('1508385')->is_valid_number, '東京都水道局 渋谷営業所');
ok($zip->set_number('1508402')->is_valid_number, 'バークレイズ・グローバル・インベスターズ信託銀行 株式会社');
ok($zip->set_number('1508408')->is_valid_number, '東京スバル 株式会社');
ok($zip->set_number('1508409')->is_valid_number, '株式会社 ダイヤモンド社');
ok($zip->set_number('1508412')->is_valid_number, '株式会社 ドトールコーヒー');
ok($zip->set_number('1508436')->is_valid_number, 'ニッセイ電機 株式会社');
ok($zip->set_number('1508440')->is_valid_number, '学校法人 國學院大學');
ok($zip->set_number('1508448')->is_valid_number, '株式会社 トゥモローランド');
ok($zip->set_number('1508451')->is_valid_number, 'コーンズドッドウェル (株)');
ok($zip->set_number('1508455')->is_valid_number, 'ミドリ安全 株式会社');
ok($zip->set_number('1508482')->is_valid_number, '株式会社 ワニブックス');
ok($zip->set_number('1508488')->is_valid_number, 'あいおい損害保険 株式会社');
ok($zip->set_number('1508502')->is_valid_number, '海光電業 株式会社');
ok($zip->set_number('1508503')->is_valid_number, '財団法人 東京都防災・建築まちづくりセンター');
ok($zip->set_number('1508505')->is_valid_number, '日本たばこ産業 株式会社');
ok($zip->set_number('1508507')->is_valid_number, '株式会社 東急文化村');
ok($zip->set_number('1508508')->is_valid_number, '株式会社 ジェイアール東日本企画');
ok($zip->set_number('1508511')->is_valid_number, '東京急行電鉄 株式会社');
ok($zip->set_number('1508512')->is_valid_number, 'セルリアンタワー');
ok($zip->set_number('1508514')->is_valid_number, '株式会社 アバハウスインターナショナル');
ok($zip->set_number('1508515')->is_valid_number, 'ニッポンレンタカーサービス 株式会社');
ok($zip->set_number('1508516')->is_valid_number, '株式会社 テイチクエンタテインメント');
ok($zip->set_number('1508517')->is_valid_number, '株式会社 ゴールドウイン');
ok($zip->set_number('1508522')->is_valid_number, 'サッポロビール 株式会社');
ok($zip->set_number('1508525')->is_valid_number, '伊藤忠プラスチックス 株式会社');
ok($zip->set_number('1508530')->is_valid_number, 'トランス・コスモス 株式会社');
ok($zip->set_number('1508533')->is_valid_number, '東京急行電鉄 株式会社');
ok($zip->set_number('1508545')->is_valid_number, 'トランスワールドジャパン 株式会社');
ok($zip->set_number('1508550')->is_valid_number, 'ジャニーズファミリークラブ');
ok($zip->set_number('1508555')->is_valid_number, '明和地所 株式会社');
ok($zip->set_number('1508563')->is_valid_number, '養命酒製造 株式会社');
ok($zip->set_number('1508567')->is_valid_number, '日本レストランシステム 株式会社');
ok($zip->set_number('1508569')->is_valid_number, '株式会社 ロッキング・オン');
ok($zip->set_number('1508575')->is_valid_number, '株式会社 ティーガイア');
ok($zip->set_number('1508577')->is_valid_number, '日本システムウェア 株式会社');
ok($zip->set_number('1508585')->is_valid_number, '協栄産業 株式会社');
ok($zip->set_number('1508586')->is_valid_number, '日本ケンタッキーフライドチキン 株式会社');
ok($zip->set_number('1508587')->is_valid_number, '株式会社 花形商品研究所');
ok($zip->set_number('1508672')->is_valid_number, '宗教法人 生長の家');
ok($zip->set_number('1508673')->is_valid_number, '塩野義製薬 株式会社 東京支店');
ok($zip->set_number('1508677')->is_valid_number, '日機装 株式会社');
ok($zip->set_number('1508688')->is_valid_number, '株式会社 アカデミー出版');
ok($zip->set_number('1508902')->is_valid_number, '第一園芸 株式会社');
ok($zip->set_number('1508911')->is_valid_number, '東京自動車サービス健康保険組合');
ok($zip->set_number('1508923')->is_valid_number, '財団法人 母子衛生研究会(母子保健事業団)');
ok($zip->set_number('1508925')->is_valid_number, '国際連合大学');
ok($zip->set_number('1508932')->is_valid_number, '株式会社 ジャックス');
ok($zip->set_number('1508935')->is_valid_number, '日本赤十字社医療センター');
ok($zip->set_number('1508938')->is_valid_number, '聖心女子大学');
ok($zip->set_number('1508940')->is_valid_number, '株式会社 キリンビジネスシステム');
ok($zip->set_number('1508955')->is_valid_number, '株式会社 ポリスター');
ok($zip->set_number('1518401')->is_valid_number, '株式会社 アートネイチャー');
ok($zip->set_number('1518404')->is_valid_number, 'ジャパンシステム 株式会社');
ok($zip->set_number('1518502')->is_valid_number, '全日本郵政 労働組合');
ok($zip->set_number('1518503')->is_valid_number, '株式会社 フジタ 東京支店');
ok($zip->set_number('1518504')->is_valid_number, '(株) かんそうしん');
ok($zip->set_number('1518505')->is_valid_number, '社団法人 日本理容美容教育センター');
ok($zip->set_number('1518507')->is_valid_number, '明星食品 株式会社');
ok($zip->set_number('1518509')->is_valid_number, '(社) 輿論科学協会');
ok($zip->set_number('1518510')->is_valid_number, 'イトキン 株式会社');
ok($zip->set_number('1518511')->is_valid_number, '株式会社 ソキア');
ok($zip->set_number('1518516')->is_valid_number, '社団法人 日本将棋連盟');
ok($zip->set_number('1518517')->is_valid_number, '株式会社 パソナソフトバンク');
ok($zip->set_number('1518518')->is_valid_number, 'テイーポール 株式会社');
ok($zip->set_number('1518519')->is_valid_number, 'トータルライフサービス 株式会社');
ok($zip->set_number('1518521')->is_valid_number, '学校法人 文化学園');
ok($zip->set_number('1518522')->is_valid_number, '文化服装学院');
ok($zip->set_number('1518523')->is_valid_number, '文化女子大学');
ok($zip->set_number('1518524')->is_valid_number, '文化出版局');
ok($zip->set_number('1518525')->is_valid_number, '日本交通公社教育旅行 東京西支店');
ok($zip->set_number('1518528')->is_valid_number, '東日本旅客鉄道 株式会社 JR東京総合病院');
ok($zip->set_number('1518529')->is_valid_number, '文化学園服飾博物館');
ok($zip->set_number('1518530')->is_valid_number, 'あいおいニッセイ同和損害保険 株式会社');
ok($zip->set_number('1518531')->is_valid_number, '全国労働者 共済生活 共同組合 再共済連合会');
ok($zip->set_number('1518532')->is_valid_number, '株式会社 エム・エム・エフ');
ok($zip->set_number('1518533')->is_valid_number, 'マイクロソフト 株式会社');
ok($zip->set_number('1518534')->is_valid_number, '鉄道情報システム 株式会社 本社');
ok($zip->set_number('1518535')->is_valid_number, 'ニッタン 株式会社');
ok($zip->set_number('1518536')->is_valid_number, '株式会社 アトリエサブ');
ok($zip->set_number('1518537')->is_valid_number, '日本製粉 株式会社');
ok($zip->set_number('1518538')->is_valid_number, '社団法人 日本経営協会');
ok($zip->set_number('1518539')->is_valid_number, '山野美容専門学校');
ok($zip->set_number('1518540')->is_valid_number, '(社) 日本音楽著作権協会');
ok($zip->set_number('1518541')->is_valid_number, '株式会社 中村屋');
ok($zip->set_number('1518542')->is_valid_number, '株式会社 有働音楽事務所');
ok($zip->set_number('1518543')->is_valid_number, 'カシオ計算機 (株)');
ok($zip->set_number('1518544')->is_valid_number, '株式会社 スクウェア・エニックス');
ok($zip->set_number('1518545')->is_valid_number, '財団法人 電気安全環境研究所');
ok($zip->set_number('1518547')->is_valid_number, '文化ファッション大学院大学');
ok($zip->set_number('1518548')->is_valid_number, '株式会社 ガーリック事務所');
ok($zip->set_number('1518549')->is_valid_number, '株式会社 ウェットウエア');
ok($zip->set_number('1518552')->is_valid_number, '東京興産 株式会社/東興管理 株式会社');
ok($zip->set_number('1518554')->is_valid_number, '(株) イッセイ ミヤケ');
ok($zip->set_number('1518555')->is_valid_number, '財団法人 企業経営通信学院');
ok($zip->set_number('1518558')->is_valid_number, '独立行政法人 国際協力機構');
ok($zip->set_number('1518559')->is_valid_number, '学校法人 高宮学園代々木ゼミナール');
ok($zip->set_number('1518561')->is_valid_number, '株式会社 イセキ開発工機');
ok($zip->set_number('1518562')->is_valid_number, '株式会社 アグレックス');
ok($zip->set_number('1518563')->is_valid_number, 'アボットジャパン 株式会社');
ok($zip->set_number('1518565')->is_valid_number, '帝国石油 (株)');
ok($zip->set_number('1518566')->is_valid_number, 'グラクソスミスクライン 株式会社');
ok($zip->set_number('1518567')->is_valid_number, 'YKT 株式会社');
ok($zip->set_number('1518568')->is_valid_number, '東京税理士会');
ok($zip->set_number('1518569')->is_valid_number, '日本電波工業 株式会社 本社事務所');
ok($zip->set_number('1518570')->is_valid_number, '株式会社 フジタ');
ok($zip->set_number('1518571')->is_valid_number, '全国労働者 共済生活 協同組合連合会');
ok($zip->set_number('1518572')->is_valid_number, '日本ロレアル (株)');
ok($zip->set_number('1518573')->is_valid_number, '日本ロレアル (株)');
ok($zip->set_number('1518574')->is_valid_number, '山野医療専門学校');
ok($zip->set_number('1518576')->is_valid_number, '株式会社 エス・シー・アライアンス');
ok($zip->set_number('1518577')->is_valid_number, '有限会社 ヨシムラエンタープライズ');
ok($zip->set_number('1518578')->is_valid_number, 'JR東日本 (株) 本社');
ok($zip->set_number('1518583')->is_valid_number, '小田急サザンタワー');
ok($zip->set_number('1518584')->is_valid_number, 'テルモ (株)');
ok($zip->set_number('1518585')->is_valid_number, '株式会社 ホーメスト');
ok($zip->set_number('1518586')->is_valid_number, '日本共産党 中央委員会');
ok($zip->set_number('1518587')->is_valid_number, '櫻護謨 株式会社');
ok($zip->set_number('1518590')->is_valid_number, 'コンフェックス 株式会社');
ok($zip->set_number('1518591')->is_valid_number, '日本郵政グループ労働者共済生活協同組合');
ok($zip->set_number('1518600')->is_valid_number, '株式会社 フリップサイド');
ok($zip->set_number('1518671')->is_valid_number, '日本園芸協会');
ok($zip->set_number('1518672')->is_valid_number, '(株) 東京書道教育会');
ok($zip->set_number('1518673')->is_valid_number, '(株) いいもの王国');
ok($zip->set_number('1518674')->is_valid_number, '株式会社 カタログハウス');
ok($zip->set_number('1518675')->is_valid_number, '赤旗編集局');
ok($zip->set_number('1518676')->is_valid_number, '文化書道学会');
ok($zip->set_number('1518677')->is_valid_number, '学校法人 東海大学');
ok($zip->set_number('1528503')->is_valid_number, '光明理化学工業 株式会社');
ok($zip->set_number('1528506')->is_valid_number, 'エーアイ出版 株式会社');
ok($zip->set_number('1528507')->is_valid_number, '株式会社 小笠原計器制作所');
ok($zip->set_number('1528508')->is_valid_number, '(株) 日本エレクトリック・インスルメント');
ok($zip->set_number('1528510')->is_valid_number, '前澤給装工業 株式会社');
ok($zip->set_number('1528511')->is_valid_number, '株式会社 創育');
ok($zip->set_number('1528520')->is_valid_number, '本多通信工業 株式会社');
ok($zip->set_number('1528521')->is_valid_number, '東京法務局 目黒出張所');
ok($zip->set_number('1528522')->is_valid_number, 'アイア 株式会社');
ok($zip->set_number('1528525')->is_valid_number, '敷島製パン 株式会社 東京事業部');
ok($zip->set_number('1528527')->is_valid_number, '東京地方裁判所 民事執行センター');
ok($zip->set_number('1528531')->is_valid_number, 'プリマハム 株式会社');
ok($zip->set_number('1528532')->is_valid_number, '株式会社 ランナーズ');
ok($zip->set_number('1528533')->is_valid_number, '株式会社 レックス');
ok($zip->set_number('1528535')->is_valid_number, '東京物産 株式会社');
ok($zip->set_number('1528541')->is_valid_number, '泰榮商工 株式会社');
ok($zip->set_number('1528544')->is_valid_number, '株式会社 ジャップス');
ok($zip->set_number('1528549')->is_valid_number, '(株) エディトリアル・クリッパー');
ok($zip->set_number('1528550')->is_valid_number, '東京工業大学');
ok($zip->set_number('1528551')->is_valid_number, '東京工業大学 理学部');
ok($zip->set_number('1528552')->is_valid_number, '東京工業大学 工学部');
ok($zip->set_number('1528558')->is_valid_number, '東京医療保健大学 東が丘看護学部');
ok($zip->set_number('1528561')->is_valid_number, '大和証券 株式会社 自由が丘支店');
ok($zip->set_number('1528570')->is_valid_number, 'キヤノンプレシジョン 株式会社');
ok($zip->set_number('1528578')->is_valid_number, '株式会社 牧野フライス製作所');
ok($zip->set_number('1528601')->is_valid_number, '株式会社 平凡社');
ok($zip->set_number('1528621')->is_valid_number, '独立行政法人 国立病院機構本部');
ok($zip->set_number('1528902')->is_valid_number, '独立行政法人 国立病院機構 東京医療センター');
ok($zip->set_number('1528904')->is_valid_number, '株式会社 亀屋万年堂');
ok($zip->set_number('1528905')->is_valid_number, '株式会社 私の部屋リビング');
ok($zip->set_number('1528907')->is_valid_number, 'ニッカン工業 株式会社');
ok($zip->set_number('1528909')->is_valid_number, '株式会社 東急ステーションリテールサービス');
ok($zip->set_number('1528910')->is_valid_number, '日本オンライン整備 株式会社');
ok($zip->set_number('1528913')->is_valid_number, '六桜商事 株式会社');
ok($zip->set_number('1538501')->is_valid_number, '大学入試センター');
ok($zip->set_number('1538502')->is_valid_number, 'りそな決済サービス (株) 支払業務センター');
ok($zip->set_number('1538503')->is_valid_number, '(財) 日本国際教育支援協会');
ok($zip->set_number('1538504')->is_valid_number, '株式会社 紀伊國屋書店');
ok($zip->set_number('1538505')->is_valid_number, '東京大学生産技術研究所');
ok($zip->set_number('1538506')->is_valid_number, 'りそな決済サービス (株) 支払業務センター');
ok($zip->set_number('1538508')->is_valid_number, '学校法人 日本工業大学');
ok($zip->set_number('1538509')->is_valid_number, '東急ファシリティサービス 株式会社');
ok($zip->set_number('1538510')->is_valid_number, 'やまう 株式会社');
ok($zip->set_number('1538512')->is_valid_number, '株式会社 ヴァンテック');
ok($zip->set_number('1538515')->is_valid_number, '東邦大学医学部付属 大橋病院');
ok($zip->set_number('1538516')->is_valid_number, '社会福祉法人 愛隣会');
ok($zip->set_number('1538518')->is_valid_number, '東急バス 株式会社');
ok($zip->set_number('1538520')->is_valid_number, '株式会社 ジェディックス');
ok($zip->set_number('1538521')->is_valid_number, '株式会社 ジュンアシダ');
ok($zip->set_number('1538522')->is_valid_number, '財団法人 日本地図センター');
ok($zip->set_number('1538523')->is_valid_number, 'あおば生命 株式会社');
ok($zip->set_number('1538525')->is_valid_number, '株式会社 聖林公司');
ok($zip->set_number('1538526')->is_valid_number, 'メルク製薬 株式会社');
ok($zip->set_number('1538530')->is_valid_number, 'エトー 株式会社');
ok($zip->set_number('1538531')->is_valid_number, '株式会社 ジャパンライフデザインシステムズ');
ok($zip->set_number('1538536')->is_valid_number, '株式会社 ピー・エックス');
ok($zip->set_number('1538539')->is_valid_number, '日本航空電子工業 株式会社');
ok($zip->set_number('1538540')->is_valid_number, 'チャコット 株式会社');
ok($zip->set_number('1538541')->is_valid_number, '株式会社 阪急コミュニケーションズ');
ok($zip->set_number('1538543')->is_valid_number, '株式会社 阪急トラベルサポート');
ok($zip->set_number('1538545')->is_valid_number, '株式会社 ネコ・パブリッシング');
ok($zip->set_number('1538550')->is_valid_number, 'トップツアー 株式会社');
ok($zip->set_number('1538551')->is_valid_number, '田中興産 株式会社 絵里奈事業部');
ok($zip->set_number('1538552')->is_valid_number, '自衛隊中央病院 高等看護学院');
ok($zip->set_number('1538553')->is_valid_number, 'ニッポンレンタカーアーバンネット 株式会社 東京ディビジョン');
ok($zip->set_number('1538554')->is_valid_number, 'ビーシーアイ 株式会社');
ok($zip->set_number('1538555')->is_valid_number, '株式会社 パスコ 東京支社');
ok($zip->set_number('1538556')->is_valid_number, 'りそな決済サービス (株) 代金回収センター(公文)');
ok($zip->set_number('1538558')->is_valid_number, '太陽工業株式会社');
ok($zip->set_number('1538560')->is_valid_number, '株式会社 イワセ・エスタ');
ok($zip->set_number('1538565')->is_valid_number, '株式会社 カイタックインターナショナル');
ok($zip->set_number('1538566')->is_valid_number, '東急ファシリティサービス 株式会社');
ok($zip->set_number('1538567')->is_valid_number, '株式会社 リアルロックス');
ok($zip->set_number('1538570')->is_valid_number, 'アコム 株式会社 AVレンタル営業部');
ok($zip->set_number('1538571')->is_valid_number, 'アベイズム 株式会社');
ok($zip->set_number('1538573')->is_valid_number, '目黒区役所');
ok($zip->set_number('1538577')->is_valid_number, '株式会社 東急ストア');
ok($zip->set_number('1538578')->is_valid_number, 'ユニリーバ・ジャパン ホールディングス 株式会社');
ok($zip->set_number('1538580')->is_valid_number, '株式会社 三田ホールディング ウェスティンホテル東京');
ok($zip->set_number('1538581')->is_valid_number, '総合病院 厚生中央病院');
ok($zip->set_number('1538582')->is_valid_number, '東京都 水道局 目黒営業所');
ok($zip->set_number('1538585')->is_valid_number, '社団法人 目黒法人会');
ok($zip->set_number('1538586')->is_valid_number, '中央化学産業 株式会社');
ok($zip->set_number('1538587')->is_valid_number, '伊藤ハム 株式会社');
ok($zip->set_number('1538589')->is_valid_number, '株式会社 阪急交通社');
ok($zip->set_number('1538601')->is_valid_number, '中央三井信託銀行 株式会社 信託センター');
ok($zip->set_number('1538620')->is_valid_number, '株式会社 ホットスタッフ・プロモーション');
ok($zip->set_number('1538630')->is_valid_number, '防衛省 技術研究本部 艦艇装備研究所');
ok($zip->set_number('1538631')->is_valid_number, '学校法人 目黒学院');
ok($zip->set_number('1538633')->is_valid_number, '目黒税務署');
ok($zip->set_number('1538635')->is_valid_number, '株式会社 アートコーヒー');
ok($zip->set_number('1538636')->is_valid_number, 'スタンレー電気 株式会社');
ok($zip->set_number('1538638')->is_valid_number, '株式会社 ルック');
ok($zip->set_number('1538640')->is_valid_number, '全国酒販会館');
ok($zip->set_number('1538641')->is_valid_number, '株式会社 エヌジェーケー');
ok($zip->set_number('1538644')->is_valid_number, '八重洲無線 株式会社');
ok($zip->set_number('1538645')->is_valid_number, '(株) スタンダード');
ok($zip->set_number('1538648')->is_valid_number, '防衛庁 防衛研究所');
ok($zip->set_number('1538650')->is_valid_number, '新光商事 株式会社');
ok($zip->set_number('1538652')->is_valid_number, '株式会社 日本ホールマーク');
ok($zip->set_number('1538653')->is_valid_number, '株式会社 コミューチュア 東京支店');
ok($zip->set_number('1538654')->is_valid_number, 'パイオニア 株式会社');
ok($zip->set_number('1538655')->is_valid_number, '伊藤忠エネクス 株式会社');
ok($zip->set_number('1538657')->is_valid_number, '森永乳業 株式会社 東日本管理センター');
ok($zip->set_number('1538660')->is_valid_number, '株式会社 ホリプロ');
ok($zip->set_number('1538662')->is_valid_number, 'ミネベア 株式会社');
ok($zip->set_number('1538665')->is_valid_number, 'パイオニア 株式会社 PAXビル');
ok($zip->set_number('1538666')->is_valid_number, '一般財団法人 ヤマハ音楽振興会');
ok($zip->set_number('1538668')->is_valid_number, 'ジプロ 株式会社');
ok($zip->set_number('1538669')->is_valid_number, '目黒雅叙園');
ok($zip->set_number('1538670')->is_valid_number, '株式会社 ディスクガレージ');
ok($zip->set_number('1538677')->is_valid_number, 'さわやか信用金庫');
ok($zip->set_number('1538687')->is_valid_number, 'パナソニックコミュニケーションズ 株式会社');
ok($zip->set_number('1538688')->is_valid_number, '株式会社 スクウェア');
ok($zip->set_number('1538902')->is_valid_number, '東京大学大学院総合文化研究科・教養学部');
ok($zip->set_number('1538904')->is_valid_number, '東京大学先端科学技術研究センター');
ok($zip->set_number('1538906')->is_valid_number, '株式会社 メルローズ');
ok($zip->set_number('1538911')->is_valid_number, '東京富士 株式会社');
ok($zip->set_number('1538913')->is_valid_number, '株式会社 ホワイ');
ok($zip->set_number('1538914')->is_valid_number, '東京大学大学院 数理科学研究科');
ok($zip->set_number('1538922')->is_valid_number, 'ウォルト・ディズニー・ジャパン 株式会社');
ok($zip->set_number('1538923')->is_valid_number, 'サクサ 株式会社');
ok($zip->set_number('1538925')->is_valid_number, '株式会社 リテイルネットワークス');
ok($zip->set_number('1538927')->is_valid_number, 'メルク 株式会社');
ok($zip->set_number('1538930')->is_valid_number, '雅叙園観光 株式会社');
ok($zip->set_number('1538933')->is_valid_number, '航空自衛隊目黒基地 幹部学校');
ok($zip->set_number('1538934')->is_valid_number, '国家公務員共済組合連合会総合病院東京共済病院');
ok($zip->set_number('1538936')->is_valid_number, '目黒信用金庫');
ok($zip->set_number('1538937')->is_valid_number, '東京都 目黒都税事務所');
ok($zip->set_number('1538939')->is_valid_number, '東京都教育相談センター');
ok($zip->set_number('1548503')->is_valid_number, '(株) 東京メガネ');
ok($zip->set_number('1548504')->is_valid_number, '世田谷区役所');
ok($zip->set_number('1548505')->is_valid_number, '丸幸製茶販売 (株)');
ok($zip->set_number('1548506')->is_valid_number, '昭和オプトロニクス 株式会社');
ok($zip->set_number('1548510')->is_valid_number, '株式会社 エヌ・ユー・エス');
ok($zip->set_number('1548511')->is_valid_number, '防衛省 技術研究本部電子装備研究所');
ok($zip->set_number('1548515')->is_valid_number, '国士舘大学');
ok($zip->set_number('1548516')->is_valid_number, '株式会社 グレイスファミリー');
ok($zip->set_number('1548520')->is_valid_number, '三菱電機システムサービス 株式会社');
ok($zip->set_number('1548521')->is_valid_number, '旭日電気工業 (株)');
ok($zip->set_number('1548523')->is_valid_number, '世田谷税務署');
ok($zip->set_number('1548525')->is_valid_number, '駒澤大学');
ok($zip->set_number('1548530')->is_valid_number, '国土情報開発 株式会社');
ok($zip->set_number('1548531')->is_valid_number, '東京法務局 世田谷出張所');
ok($zip->set_number('1548532')->is_valid_number, '自衛隊中央病院');
ok($zip->set_number('1548533')->is_valid_number, '昭和女子大学');
ok($zip->set_number('1548536')->is_valid_number, '(株) ニューズヴァリュー');
ok($zip->set_number('1548539')->is_valid_number, 'エム・シー・エム・ジャパン (株)');
ok($zip->set_number('1548543')->is_valid_number, '東京電力 世田谷支社');
ok($zip->set_number('1548544')->is_valid_number, '学校法人 食糧学院');
ok($zip->set_number('1548545')->is_valid_number, '公益財団法人 プラン・ジャパン');
ok($zip->set_number('1548551')->is_valid_number, 'オットージャパン 株式会社');
ok($zip->set_number('1548552')->is_valid_number, '株式会社 コア');
ok($zip->set_number('1548553')->is_valid_number, '国士舘中学校・高等学校');
ok($zip->set_number('1548554')->is_valid_number, '世田谷区役所');
ok($zip->set_number('1548555')->is_valid_number, '世田谷社会保険事務所');
ok($zip->set_number('1548565')->is_valid_number, 'セントラル工商 株式会社');
ok($zip->set_number('1548566')->is_valid_number, '陸上自衛隊衛生学校');
ok($zip->set_number('1548567')->is_valid_number, 'エディー・バウアー・ジャパン 株式会社');
ok($zip->set_number('1548568')->is_valid_number, '東京医療保健大学');
ok($zip->set_number('1548570')->is_valid_number, 'チャコット 株式会社 営業センター');
ok($zip->set_number('1548571')->is_valid_number, '昭和女子大学 オープンカレッジ');
ok($zip->set_number('1548577')->is_valid_number, '世田谷都税事務所');
ok($zip->set_number('1548580')->is_valid_number, '株式会社 東京特殊印刷工業');
ok($zip->set_number('1548581')->is_valid_number, '世田谷信用金庫');
ok($zip->set_number('1548582')->is_valid_number, '株式会社 テック・インデックス');
ok($zip->set_number('1548584')->is_valid_number, 'ロイヤル (株) 東京本部');
ok($zip->set_number('1548585')->is_valid_number, '国土環境 株式会社');
ok($zip->set_number('1548703')->is_valid_number, '株式会社 グローバル');
ok($zip->set_number('1548732')->is_valid_number, '東京都水道局 世田谷東営業所');
ok($zip->set_number('1558610')->is_valid_number, '学校法人 松蔭学園');
ok($zip->set_number('1558626')->is_valid_number, '(株) 第二書房');
ok($zip->set_number('1558633')->is_valid_number, '小林製薬工業 株式会社');
ok($zip->set_number('1558655')->is_valid_number, '東邦薬品 株式会社');
ok($zip->set_number('1558663')->is_valid_number, '(財) 秋田県育英会 東京寮');
ok($zip->set_number('1558668')->is_valid_number, '学校法人 成徳学園');
ok($zip->set_number('1568501')->is_valid_number, '株式会社 京王エージェンシー');
ok($zip->set_number('1568502')->is_valid_number, '学校法人 東京農業大学');
ok($zip->set_number('1568506')->is_valid_number, '財団法人 東京都医学総合研究所');
ok($zip->set_number('1568510')->is_valid_number, '株式会社 玉川繊維工業所');
ok($zip->set_number('1568511')->is_valid_number, '東京いすゞ自動車 株式会社');
ok($zip->set_number('1568522')->is_valid_number, '東京都水道局 世田谷西営業所');
ok($zip->set_number('1568533')->is_valid_number, '株式会社 ディーエム情報システム');
ok($zip->set_number('1568555')->is_valid_number, '北沢税務署');
ok($zip->set_number('1568585')->is_valid_number, '財団法人 東京都精神医学総合研究所');
ok($zip->set_number('1568587')->is_valid_number, '東芝ファイナンス 株式会社');
ok($zip->set_number('1568588')->is_valid_number, 'キーウェアソリューションズ (株)');
ok($zip->set_number('1568666')->is_valid_number, '株式会社 美好屋商店');
ok($zip->set_number('1568678')->is_valid_number, '株式会社 円谷プロダクション');
ok($zip->set_number('1578501')->is_valid_number, '世田谷区 砧総合支所');
ok($zip->set_number('1578510')->is_valid_number, '日本放送協会 放送技術研究所');
ok($zip->set_number('1578511')->is_valid_number, '学校法人 成城学園');
ok($zip->set_number('1578520')->is_valid_number, '財団法人 NHK放送研修センター');
ok($zip->set_number('1578521')->is_valid_number, '日本書学舘');
ok($zip->set_number('1578522')->is_valid_number, '学校法人 成城学園 初等学校');
ok($zip->set_number('1578530')->is_valid_number, 'NHK 首都圏事務センター');
ok($zip->set_number('1578535')->is_valid_number, '国立 成育医療センター');
ok($zip->set_number('1578543')->is_valid_number, '(株) ティ・ヴイクラブ');
ok($zip->set_number('1578550')->is_valid_number, '(社) 至誠会 第二病院');
ok($zip->set_number('1578561')->is_valid_number, '東宝 (株) 東宝スタジオ');
ok($zip->set_number('1578562')->is_valid_number, '学校法人 科学技術学園');
ok($zip->set_number('1578563')->is_valid_number, '株式会社 ジャパンハウス');
ok($zip->set_number('1578565')->is_valid_number, '学校法人 二階堂学園');
ok($zip->set_number('1578566')->is_valid_number, 'サクラビア成城 (株) プライムステージ');
ok($zip->set_number('1578567')->is_valid_number, '(株) ウテナ');
ok($zip->set_number('1578570')->is_valid_number, '日本大学 商学部');
ok($zip->set_number('1578573')->is_valid_number, '財団法人 日本品質保証機構');
ok($zip->set_number('1578575')->is_valid_number, '(社) 友愛十字会');
ok($zip->set_number('1588501')->is_valid_number, '国立医薬品食品衛生研究所');
ok($zip->set_number('1588502')->is_valid_number, '東神開発 株式会社');
ok($zip->set_number('1588505')->is_valid_number, 'ジャガージャパン 株式会社');
ok($zip->set_number('1588508')->is_valid_number, '日本体育大学');
ok($zip->set_number('1588509')->is_valid_number, '株式会社 東急コミュニティー');
ok($zip->set_number('1588510')->is_valid_number, '(財) 五島美術館');
ok($zip->set_number('1588511')->is_valid_number, '学校法人 田園調布雙葉学園');
ok($zip->set_number('1588512')->is_valid_number, '学校法人 調布学園');
ok($zip->set_number('1588513')->is_valid_number, '昭栄電気工具 株式会社');
ok($zip->set_number('1588514')->is_valid_number, '石橋刷子製造 株式会社');
ok($zip->set_number('1588518')->is_valid_number, '新日本気象海洋 株式会社');
ok($zip->set_number('1588520')->is_valid_number, '株式会社 ジャレコ');
ok($zip->set_number('1588522')->is_valid_number, '株式会社 アサヒ安全業務社');
ok($zip->set_number('1588523')->is_valid_number, '日本中央競馬会 馬事公苑');
ok($zip->set_number('1588525')->is_valid_number, '明星電気 株式会社');
ok($zip->set_number('1588530')->is_valid_number, '新キャタピラー三菱 株式会社');
ok($zip->set_number('1588531')->is_valid_number, '公立学校共済組合 関東中央病院');
ok($zip->set_number('1588533')->is_valid_number, 'シンコー 株式会社');
ok($zip->set_number('1588543')->is_valid_number, '岡谷電機産業 株式会社');
ok($zip->set_number('1588544')->is_valid_number, '愛国産業 株式会社');
ok($zip->set_number('1588549')->is_valid_number, '株式会社 サクラス');
ok($zip->set_number('1588550')->is_valid_number, '日本ジョンソン・アンド・ヒギンズ 株式会社');
ok($zip->set_number('1588551')->is_valid_number, '株式会社 本間ゴルフ');
ok($zip->set_number('1588552')->is_valid_number, '長谷川病院');
ok($zip->set_number('1588555')->is_valid_number, '株式会社 平野デザイン設計');
ok($zip->set_number('1588557')->is_valid_number, '東京都市大学');
ok($zip->set_number('1588558')->is_valid_number, '学校法人 多摩美術大学');
ok($zip->set_number('1588566')->is_valid_number, '東京都立園芸高等学校');
ok($zip->set_number('1588567')->is_valid_number, '株式会社 レアーズ');
ok($zip->set_number('1588575')->is_valid_number, '株式会社 サンエー・インターナショナル');
ok($zip->set_number('1588577')->is_valid_number, '学校法人 駒澤大学高等学校');
ok($zip->set_number('1588578')->is_valid_number, '株式会社 オリーブ情報システム');
ok($zip->set_number('1588580')->is_valid_number, '東京外かく環状道路調査事務所');
ok($zip->set_number('1588583')->is_valid_number, '住友スリーエム 株式会社');
ok($zip->set_number('1588585')->is_valid_number, '医療法人 社団和乃会小倉病院');
ok($zip->set_number('1588586')->is_valid_number, '東横学園 東横短期大学');
ok($zip->set_number('1588588')->is_valid_number, 'ファーレン東京 株式会社');
ok($zip->set_number('1588601')->is_valid_number, '玉川税務署');
ok($zip->set_number('1588602')->is_valid_number, '株式会社 銀座マギー');
ok($zip->set_number('1588610')->is_valid_number, '京セラ 株式会社 東京用賀事業所');
ok($zip->set_number('1588611')->is_valid_number, '株式会社 レリアン');
ok($zip->set_number('1588615')->is_valid_number, 'タイコヘルスケアジャパン 株式会社');
ok($zip->set_number('1588628')->is_valid_number, '株式会社 タカラ 東京本社');
ok($zip->set_number('1588630')->is_valid_number, '産能大学');
ok($zip->set_number('1588631')->is_valid_number, '産能大学');
ok($zip->set_number('1588632')->is_valid_number, '産能大学');
ok($zip->set_number('1588633')->is_valid_number, '日本オラクル 株式会社');
ok($zip->set_number('1588640')->is_valid_number, 'エディトリアルクリッパー');
ok($zip->set_number('1588666')->is_valid_number, '株式会社 伸商');
ok($zip->set_number('1588701')->is_valid_number, '(株) 高島屋 玉川店');
ok($zip->set_number('1588771')->is_valid_number, '株式会社 大正オーディット');
ok($zip->set_number('1608001')->is_valid_number, '株式会社 小田急百貨店');
ok($zip->set_number('1608070')->is_valid_number, '聖教新聞社');
ok($zip->set_number('1608301')->is_valid_number, '株式会社 秀栄興産');
ok($zip->set_number('1608304')->is_valid_number, '東京都新宿都税事務所');
ok($zip->set_number('1608306')->is_valid_number, '株式会社 日本小児医事出版社');
ok($zip->set_number('1608308')->is_valid_number, 'クラブツーリズム 株式会社');
ok($zip->set_number('1608309')->is_valid_number, '小田急電鉄 株式会社');
ok($zip->set_number('1608311')->is_valid_number, '有限会社 森野ウレタン社');
ok($zip->set_number('1608316')->is_valid_number, '富士重工業 株式会社');
ok($zip->set_number('1608319')->is_valid_number, '株式会社 ビックカメラ 新宿西口店');
ok($zip->set_number('1608321')->is_valid_number, '株式会社 京王百貨店');
ok($zip->set_number('1608324')->is_valid_number, 'エプソン販売 株式会社');
ok($zip->set_number('1608325')->is_valid_number, '兼松コミュニケーションズ 株式会社');
ok($zip->set_number('1608327')->is_valid_number, '中央職業能力開発協会');
ok($zip->set_number('1608330')->is_valid_number, '株式会社 京王プラザホテル');
ok($zip->set_number('1608331')->is_valid_number, '三井不動産住宅サービス 株式会社');
ok($zip->set_number('1608333')->is_valid_number, '三和ファイナンス (株)');
ok($zip->set_number('1608334')->is_valid_number, '株式会社 三松');
ok($zip->set_number('1608335')->is_valid_number, 'クレディ・スイス生命保険 株式会社');
ok($zip->set_number('1608336')->is_valid_number, '新宿ワシントンホテル');
ok($zip->set_number('1608338')->is_valid_number, '株式会社 損害保険ジャパン');
ok($zip->set_number('1608341')->is_valid_number, '株式会社 エアーリンク');
ok($zip->set_number('1608343')->is_valid_number, '進和テック 株式会社');
ok($zip->set_number('1608351')->is_valid_number, '野村リビングサポート 株式会社');
ok($zip->set_number('1608355')->is_valid_number, 'エムシーメディカル 株式会社');
ok($zip->set_number('1608357')->is_valid_number, 'オリックス・クレジット 株式会社');
ok($zip->set_number('1608358')->is_valid_number, '株式会社 ビックピーカン');
ok($zip->set_number('1608361')->is_valid_number, '全研本社 株式会社');
ok($zip->set_number('1608366')->is_valid_number, '日本テキサス・インスツルメンツ 株式会社');
ok($zip->set_number('1608368')->is_valid_number, '富国生命保険 相互会社 新宿支社');
ok($zip->set_number('1608369')->is_valid_number, '東京リース 株式会社');
ok($zip->set_number('1608374')->is_valid_number, '芸能花伝舎');
ok($zip->set_number('1608375')->is_valid_number, '株式会社 シー・アイ・シー');
ok($zip->set_number('1608377')->is_valid_number, '小田急建設 株式会社');
ok($zip->set_number('1608383')->is_valid_number, '栗田工業 株式会社');
ok($zip->set_number('1608389')->is_valid_number, '社団法人 日本薬剤師会');
ok($zip->set_number('1608401')->is_valid_number, '大和証券 株式会社 新宿支店');
ok($zip->set_number('1608402')->is_valid_number, '学校法人 東京医科大学');
ok($zip->set_number('1608403')->is_valid_number, '川辺 株式会社');
ok($zip->set_number('1608407')->is_valid_number, '財団法人 東京社会保険協会');
ok($zip->set_number('1608408')->is_valid_number, '株式会社 エムアイカード');
ok($zip->set_number('1608410')->is_valid_number, '日本ハウズイング 株式会社');
ok($zip->set_number('1608411')->is_valid_number, '日神不動産 株式会社');
ok($zip->set_number('1608415')->is_valid_number, 'ネッツトヨタ東京 株式会社');
ok($zip->set_number('1608420')->is_valid_number, '株式会社 マースエンジニアリング');
ok($zip->set_number('1608421')->is_valid_number, '古鷹商事 (株)');
ok($zip->set_number('1608422')->is_valid_number, 'キーウェアソリューションズ 株式会社');
ok($zip->set_number('1608423')->is_valid_number, 'オートビジネスサービス 株式会社');
ok($zip->set_number('1608429')->is_valid_number, '株式会社 アデランス');
ok($zip->set_number('1608431')->is_valid_number, '株式会社 八千代銀行');
ok($zip->set_number('1608433')->is_valid_number, '株式会社 佐藤秀');
ok($zip->set_number('1608444')->is_valid_number, 'あいおい損害保険 株式会社');
ok($zip->set_number('1608450')->is_valid_number, '株式会社 長谷工コミュニティ 東京支店');
ok($zip->set_number('1608451')->is_valid_number, '株式会社 吉野家');
ok($zip->set_number('1608455')->is_valid_number, '株式会社 三越 新宿店');
ok($zip->set_number('1608472')->is_valid_number, '新宿区役所 地域調整課 文化国際課');
ok($zip->set_number('1608477')->is_valid_number, '東京ミサワホーム 株式会社');
ok($zip->set_number('1608484')->is_valid_number, '新宿区役所');
ok($zip->set_number('1608485')->is_valid_number, '新宿区役所 総務部 税務課');
ok($zip->set_number('1608487')->is_valid_number, '新宿プリンスホテル');
ok($zip->set_number('1608488')->is_valid_number, '財団法人 東京都保険医療公社 大久保病院');
ok($zip->set_number('1608489')->is_valid_number, '新宿公共職業安定所');
ok($zip->set_number('1608501')->is_valid_number, '株式会社 サンミュージックプロダクション');
ok($zip->set_number('1608505')->is_valid_number, '株式会社 池光エンタープライズ');
ok($zip->set_number('1608510')->is_valid_number, '新菱冷熱工業 株式会社');
ok($zip->set_number('1608511')->is_valid_number, '大塚刷毛製造 (株)');
ok($zip->set_number('1608512')->is_valid_number, '生活協同組合 東京マイコープ');
ok($zip->set_number('1608515')->is_valid_number, '持田製薬 (株)');
ok($zip->set_number('1608519')->is_valid_number, '社団法人 金融財政事情研究会');
ok($zip->set_number('1608520')->is_valid_number, '株式会社 きんざい');
ok($zip->set_number('1608521')->is_valid_number, '公明機関紙局');
ok($zip->set_number('1608522')->is_valid_number, '女子学生会館 「明泉」');
ok($zip->set_number('1608524')->is_valid_number, '日清食品 株式会社 東京本社');
ok($zip->set_number('1608529')->is_valid_number, '社団法人 金融財政事情研究会 検定センター');
ok($zip->set_number('1608530')->is_valid_number, '四谷税務署');
ok($zip->set_number('1608543')->is_valid_number, 'コモンズ 株式会社');
ok($zip->set_number('1608547')->is_valid_number, '株式会社 三栄書房');
ok($zip->set_number('1608549')->is_valid_number, '株式会社 公募ガイド社');
ok($zip->set_number('1608555')->is_valid_number, '株式会社 ピーアールアベニュー');
ok($zip->set_number('1608557')->is_valid_number, '株式会社 イデア');
ok($zip->set_number('1608560')->is_valid_number, '学校法人 大塚学院');
ok($zip->set_number('1608565')->is_valid_number, '株式会社 ポプラ社');
ok($zip->set_number('1608571')->is_valid_number, '株式会社 太田出版');
ok($zip->set_number('1608575')->is_valid_number, '雪印メグミルク 株式会社');
ok($zip->set_number('1608577')->is_valid_number, '三井住友建設 株式会社');
ok($zip->set_number('1608580')->is_valid_number, '株式会社 ワニマガジン社');
ok($zip->set_number('1608581')->is_valid_number, '新宿区 四谷特別出張所');
ok($zip->set_number('1608581')->is_valid_number, '四谷区民ホール');
ok($zip->set_number('1608581')->is_valid_number, '四谷地域センター');
ok($zip->set_number('1608581')->is_valid_number, '四谷図書館');
ok($zip->set_number('1608582')->is_valid_number, '慶應義塾大学 医学部');
ok($zip->set_number('1608583')->is_valid_number, '創価学会');
ok($zip->set_number('1608585')->is_valid_number, 'チューリッヒ保険会社');
ok($zip->set_number('1608586')->is_valid_number, '東京金属事業厚生年金基金');
ok($zip->set_number('1608587')->is_valid_number, '東京都水道局 新宿営業所');
ok($zip->set_number('1608588')->is_valid_number, '(財) 民主音楽協会');
ok($zip->set_number('1608589')->is_valid_number, '東鉄工業 株式会社');
ok($zip->set_number('1608680')->is_valid_number, 'あんしん財団 「楽しいイベント」係');
ok($zip->set_number('1608910')->is_valid_number, '伯東 株式会社');
ok($zip->set_number('1618508')->is_valid_number, '株式会社 オーバル');
ok($zip->set_number('1618510')->is_valid_number, '株式会社 国土社');
ok($zip->set_number('1618511')->is_valid_number, '下田商事 株式会社');
ok($zip->set_number('1618520')->is_valid_number, 'ライオン企画 株式会社');
ok($zip->set_number('1618521')->is_valid_number, '社会福祉法人 聖母会 聖母病院');
ok($zip->set_number('1618525')->is_valid_number, 'HOYA 株式会社');
ok($zip->set_number('1618528')->is_valid_number, 'JA全農たまご 株式会社');
ok($zip->set_number('1618531')->is_valid_number, 'ウエットマスター 株式会社');
ok($zip->set_number('1618539')->is_valid_number, '目白学園');
ok($zip->set_number('1618540')->is_valid_number, 'エステー化学 株式会社');
ok($zip->set_number('1618541')->is_valid_number, '三宝製薬 株式会社');
ok($zip->set_number('1618545')->is_valid_number, '工新建設 株式会社');
ok($zip->set_number('1618546')->is_valid_number, 'アニコム損害保険 株式会社');
ok($zip->set_number('1618551')->is_valid_number, '株式会社 東陽印刷所');
ok($zip->set_number('1618552')->is_valid_number, '株式会社 誠和');
ok($zip->set_number('1618553')->is_valid_number, '株式会社 日本コンサルタントグループ');
ok($zip->set_number('1618554')->is_valid_number, '福島印刷工業 株式会社');
ok($zip->set_number('1618556')->is_valid_number, '学校法人 東京富士大学');
ok($zip->set_number('1618557')->is_valid_number, '学校法人 田中芸術学園 東京美容専門学校');
ok($zip->set_number('1618558')->is_valid_number, '一世印刷 株式会社');
ok($zip->set_number('1618560')->is_valid_number, '日本光電工業 株式会社');
ok($zip->set_number('1618565')->is_valid_number, '相模商工 株式会社');
ok($zip->set_number('1618567')->is_valid_number, '東京日産モーター 株式会社 丸山店');
ok($zip->set_number('1618570')->is_valid_number, '株式会社 ケンコー・トキナー');
ok($zip->set_number('1618575')->is_valid_number, '八千代エンジニヤリング 株式会社');
ok($zip->set_number('1618710')->is_valid_number, '株式会社 講談社');
ok($zip->set_number('1628001')->is_valid_number, '大日本印刷 株式会社');
ok($zip->set_number('1628022')->is_valid_number, '総務省 人事・恩給局');
ok($zip->set_number('1628055')->is_valid_number, '財団法人 日本英語検定協会');
ok($zip->set_number('1628401')->is_valid_number, '株式会社 旭屋出版');
ok($zip->set_number('1628402')->is_valid_number, '財団法人 東京都予防医学協会');
ok($zip->set_number('1628405')->is_valid_number, '井村屋製菓 株式会社');
ok($zip->set_number('1628407')->is_valid_number, '新日本法規出版 株式会社');
ok($zip->set_number('1628408')->is_valid_number, 'シャープ 株式会社 (市ケ谷ビル)');
ok($zip->set_number('1628409')->is_valid_number, '株式会社 ダルトン');
ok($zip->set_number('1628411')->is_valid_number, '株式会社 福田組 東京本店');
ok($zip->set_number('1628412')->is_valid_number, '独立行政法人 日本学生支援機構');
ok($zip->set_number('1628415')->is_valid_number, '東京日仏学院');
ok($zip->set_number('1628421')->is_valid_number, '株式会社 経済法令研究会');
ok($zip->set_number('1628422')->is_valid_number, '菱電エレベータ施設 株式会社');
ok($zip->set_number('1628433')->is_valid_number, '独立行政法人 国際協力機構研究所');
ok($zip->set_number('1628440')->is_valid_number, '東京産婦人科医会');
ok($zip->set_number('1628445')->is_valid_number, '成美堂出版 (株)');
ok($zip->set_number('1628446')->is_valid_number, '(株) JTBパブリッシング');
ok($zip->set_number('1628448')->is_valid_number, '社団法人 家の光協会');
ok($zip->set_number('1628449')->is_valid_number, '株式会社 流行通信社');
ok($zip->set_number('1628450')->is_valid_number, '株式会社 偕成社');
ok($zip->set_number('1628451')->is_valid_number, '持田製薬 株式会社 本社別館');
ok($zip->set_number('1628455')->is_valid_number, '株式会社 井田両国堂');
ok($zip->set_number('1628464')->is_valid_number, '銀行業務検定協会');
ok($zip->set_number('1628471')->is_valid_number, '経済アナリスト協会');
ok($zip->set_number('1628473')->is_valid_number, '中央大学 市ヶ谷キャンパス');
ok($zip->set_number('1628476')->is_valid_number, '株式会社 学生援護会');
ok($zip->set_number('1628478')->is_valid_number, '中央大学 市ヶ谷田町キャンパス');
ok($zip->set_number('1628480')->is_valid_number, '早稲田大学先端生命医科学センター');
ok($zip->set_number('1628484')->is_valid_number, '財団法人 ユネスコ・アジア文化センター');
ok($zip->set_number('1628488')->is_valid_number, '職業訓練法人 日本技能教育開発センター');
ok($zip->set_number('1628501')->is_valid_number, '株式会社 モスフードサービス');
ok($zip->set_number('1628502')->is_valid_number, '株式会社 山文');
ok($zip->set_number('1628503')->is_valid_number, '東京シティ信用金庫 神楽坂支店');
ok($zip->set_number('1628505')->is_valid_number, '株式会社 日本スタデオ');
ok($zip->set_number('1628512')->is_valid_number, '株式会社 自治体研究社');
ok($zip->set_number('1628515')->is_valid_number, '株式会社 現代書林');
ok($zip->set_number('1628522')->is_valid_number, '日本地所 株式会社');
ok($zip->set_number('1628527')->is_valid_number, '株式会社 ライジングドリーム');
ok($zip->set_number('1628529')->is_valid_number, '日本鉄鋼建材リース 株式会社');
ok($zip->set_number('1628530')->is_valid_number, '三晃印刷 株式会社');
ok($zip->set_number('1628533')->is_valid_number, '株式会社 小学館プロダクション物流センター');
ok($zip->set_number('1628535')->is_valid_number, '株式会社 アプラス');
ok($zip->set_number('1628540')->is_valid_number, '株式会社 双葉社');
ok($zip->set_number('1628541')->is_valid_number, '株式会社 ぎょうせい 南関東支社');
ok($zip->set_number('1628543')->is_valid_number, '東京厚生年金病院');
ok($zip->set_number('1628551')->is_valid_number, '朝日監査法人');
ok($zip->set_number('1628556')->is_valid_number, '株式会社 銀座コージーコーナー');
ok($zip->set_number('1628557')->is_valid_number, '株式会社 熊谷組');
ok($zip->set_number('1628558')->is_valid_number, '株式会社 アスク講談社');
ok($zip->set_number('1628560')->is_valid_number, '株式会社 ぎょうせい 北関東支社');
ok($zip->set_number('1628562')->is_valid_number, 'ゼブラ 株式会社');
ok($zip->set_number('1628565')->is_valid_number, '大興電子通信 株式会社');
ok($zip->set_number('1628568')->is_valid_number, '緑営開発 株式会社');
ok($zip->set_number('1628575')->is_valid_number, '協立機電工業 株式会社');
ok($zip->set_number('1628577')->is_valid_number, '株式会社 アミックス 東京支店');
ok($zip->set_number('1628580')->is_valid_number, '住商エレクトロニクス 株式会社');
ok($zip->set_number('1628585')->is_valid_number, '株式会社 TKC 東京本社');
ok($zip->set_number('1628587')->is_valid_number, '土地興業 株式会社');
ok($zip->set_number('1628601')->is_valid_number, '学校法人 東京理科大学');
ok($zip->set_number('1628602')->is_valid_number, '株式会社 新学社 東京支社');
ok($zip->set_number('1628604')->is_valid_number, '株式会社 ダイアプレス');
ok($zip->set_number('1628608')->is_valid_number, '株式会社 ピーズサイテック');
ok($zip->set_number('1628611')->is_valid_number, '株式会社 宙出版');
ok($zip->set_number('1628612')->is_valid_number, '東京都立新宿山吹高等学校');
ok($zip->set_number('1628614')->is_valid_number, '株式会社 大洋図書');
ok($zip->set_number('1628615')->is_valid_number, '株式会社 ムックハウス');
ok($zip->set_number('1628616')->is_valid_number, 'イカロス出版 株式会社');
ok($zip->set_number('1628620')->is_valid_number, '大日本印刷 株式会社 榎町工場');
ok($zip->set_number('1628622')->is_valid_number, '東洋ゴム工販東日本 株式会社');
ok($zip->set_number('1628624')->is_valid_number, '教職員共済生活協同組合');
ok($zip->set_number('1628626')->is_valid_number, '全国測量業 厚生年金基金');
ok($zip->set_number('1628627')->is_valid_number, 'いきいき 株式会社');
ok($zip->set_number('1628628')->is_valid_number, '株式会社 サイエンス リサーチアンドコンサルティング');
ok($zip->set_number('1628629')->is_valid_number, '生活協同組合 東京マイコープ');
ok($zip->set_number('1628630')->is_valid_number, '株式会社 カーメイト');
ok($zip->set_number('1628633')->is_valid_number, '英知出版 株式会社');
ok($zip->set_number('1628636')->is_valid_number, '独立行政法人 国立健康・栄養研究所');
ok($zip->set_number('1628638')->is_valid_number, '東洋ゴム工業 株式会社 ダイバーテックカンパニー環境工事システム販売部');
ok($zip->set_number('1628640')->is_valid_number, '国立感染症研究所');
ok($zip->set_number('1628644')->is_valid_number, '早稲田大学 第一文学部');
ok($zip->set_number('1628646')->is_valid_number, '共栄電資 株式会社');
ok($zip->set_number('1628650')->is_valid_number, '学習院女子大学');
ok($zip->set_number('1628654')->is_valid_number, '学校法人 早稲田高等学校');
ok($zip->set_number('1628655')->is_valid_number, '国立国際医療センター');
ok($zip->set_number('1628666')->is_valid_number, '学校法人 東京女子医科大学');
ok($zip->set_number('1628668')->is_valid_number, '総務省 統計局');
ok($zip->set_number('1628669')->is_valid_number, '綜通 株式会社');
ok($zip->set_number('1628670')->is_valid_number, '成城中・高等学校');
ok($zip->set_number('1628672')->is_valid_number, '独立行政法人 平和祈念事業特別基金');
ok($zip->set_number('1628676')->is_valid_number, '(財) 日本LL教育センター');
ok($zip->set_number('1628680')->is_valid_number, '株式会社 旺文社');
ok($zip->set_number('1628701')->is_valid_number, '株式会社 ディスコ');
ok($zip->set_number('1628705')->is_valid_number, '株式会社 日本ヴォーグ社');
ok($zip->set_number('1628707')->is_valid_number, '株式会社 朝倉書店');
ok($zip->set_number('1628708')->is_valid_number, '株式会社 雄鶏社');
ok($zip->set_number('1628710')->is_valid_number, '株式会社 トーハン');
ok($zip->set_number('1628711')->is_valid_number, '株式会社 新潮社');
ok($zip->set_number('1628716')->is_valid_number, '株式会社 音楽之友社');
ok($zip->set_number('1628717')->is_valid_number, '株式会社 学文社');
ok($zip->set_number('1628718')->is_valid_number, '株式会社 学文社');
ok($zip->set_number('1628801')->is_valid_number, '防衛庁 内部部局');
ok($zip->set_number('1628802')->is_valid_number, '防衛庁 陸上幕僚監部');
ok($zip->set_number('1628803')->is_valid_number, '防衛庁 海上幕僚監部');
ok($zip->set_number('1628804')->is_valid_number, '防衛庁 航空幕僚監部');
ok($zip->set_number('1628805')->is_valid_number, '防衛庁 統合幕僚会議');
ok($zip->set_number('1628806')->is_valid_number, '防衛庁情報本部');
ok($zip->set_number('1628807')->is_valid_number, '防衛省 防衛監察本部');
ok($zip->set_number('1628830')->is_valid_number, '防衛庁 技術研究本部');
ok($zip->set_number('1628853')->is_valid_number, '防衛庁 共済組合');
ok($zip->set_number('1628860')->is_valid_number, '防衛省 装備施設本部');
ok($zip->set_number('1628861')->is_valid_number, '防衛施設庁 内部部局');
ok($zip->set_number('1628953')->is_valid_number, '社会福祉法人 東京都社会福祉協議会');
ok($zip->set_number('1630268')->is_valid_number, '三井住友海上火災保険 (株)');
ok($zip->set_number('1630269')->is_valid_number, '日本綜合テレビ (株)');
ok($zip->set_number('1630278')->is_valid_number, '株式会社 朝日カルチャーセンター 通信講座');
ok($zip->set_number('1630456')->is_valid_number, 'アメリカンファミリー生命保険会社');
ok($zip->set_number('1630460')->is_valid_number, '三井不動産販売 株式会社');
ok($zip->set_number('1630466')->is_valid_number, 'イーエムシージャパン (株)');
ok($zip->set_number('1630467')->is_valid_number, '日本コンピュータシステム (株)');
ok($zip->set_number('1630470')->is_valid_number, '日本金属工業 (株) 本社');
ok($zip->set_number('1630478')->is_valid_number, '三和ホールディングス 株式会社');
ok($zip->set_number('1630553')->is_valid_number, 'AIU保険会社 新宿支店');
ok($zip->set_number('1630557')->is_valid_number, '(株) 総合資格');
ok($zip->set_number('1630558')->is_valid_number, '松田産業 (株)');
ok($zip->set_number('1630559')->is_valid_number, '日本興亜損保 株式会社');
ok($zip->set_number('1630560')->is_valid_number, '東京実業健康保険組合 城西支部');
ok($zip->set_number('1630566')->is_valid_number, '野村不動産 (株)');
ok($zip->set_number('1630569')->is_valid_number, '日本デルファイ・オートモーティブ・システムズ 株式会社');
ok($zip->set_number('1630575')->is_valid_number, '住鉱潤滑剤 株式会社');
ok($zip->set_number('1630576')->is_valid_number, '野村不動産アーバンネット 株式会社');
ok($zip->set_number('1630655')->is_valid_number, 'TBCグループ 株式会社');
ok($zip->set_number('1630659')->is_valid_number, 'エス・バイ・エル (株) 東京支店');
ok($zip->set_number('1630663')->is_valid_number, '大和証券 株式会社 新宿センタービル支店');
ok($zip->set_number('1630665')->is_valid_number, '東京建物不動産販売 (株)');
ok($zip->set_number('1630667')->is_valid_number, '(株) 日本医療情報センター');
ok($zip->set_number('1630669')->is_valid_number, '二幸産業 (株)');
ok($zip->set_number('1630675')->is_valid_number, '(株) ナック');
ok($zip->set_number('1630676')->is_valid_number, '株式会社 みずほ銀行 新宿新都心支店');
ok($zip->set_number('1630677')->is_valid_number, '芙蓉総合リース (株) 新宿支店');
ok($zip->set_number('1630688')->is_valid_number, 'ファインクレジット (株)');
ok($zip->set_number('1630727')->is_valid_number, '積水化成品工業 株式会社 東京本部');
ok($zip->set_number('1630729')->is_valid_number, '株式会社 ジェピコ');
ok($zip->set_number('1630730')->is_valid_number, 'パシフィックコンサルタンツ 株式会社');
ok($zip->set_number('1630731')->is_valid_number, '富士通エレクトロニクス 株式会社 本社事務所');
ok($zip->set_number('1630733')->is_valid_number, '相互住宅 株式会社 新宿営業所');
ok($zip->set_number('1630777')->is_valid_number, '株式会社 日本システムディベロップメント');
ok($zip->set_number('1630831')->is_valid_number, 'セントラル警備保障 (株)');
ok($zip->set_number('1630833')->is_valid_number, 'ミサワホーム (株)');
ok($zip->set_number('1630836')->is_valid_number, '株式会社 エヌ・ティ・ティ・ドコモ 新宿支店');
ok($zip->set_number('1630850')->is_valid_number, 'ミサワホームホールディングス 株式会社');
ok($zip->set_number('1630867')->is_valid_number, '株式会社 京王エージェンシー');
ok($zip->set_number('1630935')->is_valid_number, '財団法人 東京都道路整備保全公社');
ok($zip->set_number('1630938')->is_valid_number, 'エボニック デグサ ジャパン 株式会社');
ok($zip->set_number('1630939')->is_valid_number, '旭化成ホームズ 株式会社');
ok($zip->set_number('1630943')->is_valid_number, '有限会社 東京エイドセンター');
ok($zip->set_number('1631053')->is_valid_number, '東京ガス都市開発 (株)');
ok($zip->set_number('1631055')->is_valid_number, 'パークタワーホテル (株) パークハイアット東京');
ok($zip->set_number('1631065')->is_valid_number, '株式会社 JTB法人東京');
ok($zip->set_number('1631066')->is_valid_number, '株式会社 JTB法人東京');
ok($zip->set_number('1631071')->is_valid_number, '日本ロレアル 株式会社');
ok($zip->set_number('1631345')->is_valid_number, '独立行政法人 都市再生機構 募集販売本部');
ok($zip->set_number('1631348')->is_valid_number, '株式会社 URコムシステム');
ok($zip->set_number('1631349')->is_valid_number, 'オータ事務所 株式会社');
ok($zip->set_number('1631350')->is_valid_number, '有限会社 アイランド建設業経営状況分析センター');
ok($zip->set_number('1631363')->is_valid_number, '東日本住宅 (株)');
ok($zip->set_number('1631368')->is_valid_number, '(株) 新都市ライフ');
ok($zip->set_number('1631371')->is_valid_number, 'インセル 株式会社');
ok($zip->set_number('1631378')->is_valid_number, 'インターニックス 株式会社');
ok($zip->set_number('1631382')->is_valid_number, '独立行政法人 都市再生機構 東日本支社');
ok($zip->set_number('1631388')->is_valid_number, '日本シイエムケイ (株)');
ok($zip->set_number('1631455')->is_valid_number, '社団法人 電気通信協会');
ok($zip->set_number('1631462')->is_valid_number, '(株) ジュピタープログラミングネットワーク');
ok($zip->set_number('1631469')->is_valid_number, '(社) 全国公立文化施設協会 芸術情報プラザ');
ok($zip->set_number('1631470')->is_valid_number, '東京通販 株式会社');
ok($zip->set_number('1631480')->is_valid_number, 'アップルコンピュータ (株)');
ok($zip->set_number('1631488')->is_valid_number, 'サノフィ・アベンティス 株式会社');
ok($zip->set_number('1631533')->is_valid_number, '株式会社 三菱東京UFJ銀行 新宿新都心支店');
ok($zip->set_number('1631537')->is_valid_number, '三信東栄 株式会社');
ok($zip->set_number('1631555')->is_valid_number, '(株) ニッシン 東京本部');
ok($zip->set_number('1631588')->is_valid_number, '(株) 日税ビジネスサービス');
ok($zip->set_number('1638001')->is_valid_number, '東京都庁');
ok($zip->set_number('1638003')->is_valid_number, 'KDDI 株式会社');
ok($zip->set_number('1638012')->is_valid_number, 'アイタウンプラザ・アイタウンレピア');
ok($zip->set_number('1638019')->is_valid_number, '日本電信電話 株式会社');
ok($zip->set_number('1638080')->is_valid_number, '株式会社 フジサンケイリビングサービス');
ok($zip->set_number('1638081')->is_valid_number, '株式会社 フジサンケイリビングサービス');
ok($zip->set_number('1638082')->is_valid_number, '株式会社 フジサンケイリビングサービス');
ok($zip->set_number('1638339')->is_valid_number, '東京都住宅供給公社');
ok($zip->set_number('1638535')->is_valid_number, 'KDDI総合サービス 株式会社');
ok($zip->set_number('1638548')->is_valid_number, '株式会社 KDDIテレサーブ');
ok($zip->set_number('1638602')->is_valid_number, '三菱UFJ信託銀行 株式会社 新宿支店');
ok($zip->set_number('1638610')->is_valid_number, 'オリンパス光学工業 株式会社');
ok($zip->set_number('1638626')->is_valid_number, '損保ジャパンひまわり生命保険 株式会社');
ok($zip->set_number('1638638')->is_valid_number, '株式会社 日商データ・サービス');
ok($zip->set_number('1638639')->is_valid_number, '大正薬化工業');
ok($zip->set_number('1638654')->is_valid_number, '(株) 武富士');
ok($zip->set_number('1638660')->is_valid_number, '財団法人 実務教育研究所');
ok($zip->set_number('1638661')->is_valid_number, '株式会社 実務教育出版');
ok($zip->set_number('1638663')->is_valid_number, '(株) 武富士');
ok($zip->set_number('1638666')->is_valid_number, '商工組合中央金庫 新宿支店');
ok($zip->set_number('1638671')->is_valid_number, '株式会社 実務教育出版');
ok($zip->set_number('1638672')->is_valid_number, '日本興亜生命保険 株式会社');
ok($zip->set_number('1638677')->is_valid_number, '学校法人 工学院大学');
ok($zip->set_number('1638680')->is_valid_number, '(株) ロッテリア');
ok($zip->set_number('1648501')->is_valid_number, '中野区役所');
ok($zip->set_number('1648503')->is_valid_number, '三協アルミニウム工業 株式会社');
ok($zip->set_number('1648504')->is_valid_number, '株式会社 インターコミュニケーションズ');
ok($zip->set_number('1648505')->is_valid_number, '株式会社 SCC');
ok($zip->set_number('1648512')->is_valid_number, '株式会社 中野サンプラザ');
ok($zip->set_number('1648522')->is_valid_number, '三和電気工業 株式会社');
ok($zip->set_number('1648541')->is_valid_number, '東京警察病院');
ok($zip->set_number('1648550')->is_valid_number, '学校法人 森谷学園');
ok($zip->set_number('1648555')->is_valid_number, '三井情報 株式会社');
ok($zip->set_number('1648567')->is_valid_number, '株式会社 アポロ社');
ok($zip->set_number('1648577')->is_valid_number, 'west53rd');
ok($zip->set_number('1648585')->is_valid_number, '学校法人 窪田学園 窪田理容美容専門学校');
ok($zip->set_number('1648588')->is_valid_number, 'アーク・インターナショナル 株式会社');
ok($zip->set_number('1648611')->is_valid_number, '株式会社 カーメイト');
ok($zip->set_number('1648617')->is_valid_number, '立正佼成会附属佼成病院');
ok($zip->set_number('1648620')->is_valid_number, '株式会社 矢野経済研究所');
ok($zip->set_number('1648638')->is_valid_number, '学校法人 新渡戸文化学園');
ok($zip->set_number('1648642')->is_valid_number, '入一通信工業 株式会社');
ok($zip->set_number('1648644')->is_valid_number, '株式会社 ジャパン イマジネーション');
ok($zip->set_number('1648650')->is_valid_number, '鉱研工業 株式会社');
ok($zip->set_number('1648666')->is_valid_number, '日本アルミット 株式会社');
ok($zip->set_number('1648678')->is_valid_number, '学校法人 東京工芸大学');
ok($zip->set_number('1648682')->is_valid_number, '富士ゼロックスサービスクリエイティブ 株式会社');
ok($zip->set_number('1648686')->is_valid_number, '日商簿記専門学校(日商クリエーション)');
ok($zip->set_number('1648701')->is_valid_number, '株式会社 丸井');
ok($zip->set_number('1648725')->is_valid_number, 'NTT クオリス (株)');
ok($zip->set_number('1658555')->is_valid_number, '株式会社 クレディセゾン 顧客サービス部');
ok($zip->set_number('1658780')->is_valid_number, '東京法務局 民事行政部 動産・債券登録課');
ok($zip->set_number('1668501')->is_valid_number, '杉並税務署');
ok($zip->set_number('1668502')->is_valid_number, '東京都杉並都税事務所');
ok($zip->set_number('1668503')->is_valid_number, '東京都水道局 杉並東営業所');
ok($zip->set_number('1668506')->is_valid_number, '株式会社 チヨダ');
ok($zip->set_number('1668520')->is_valid_number, '武蔵野産業 株式会社');
ok($zip->set_number('1668531')->is_valid_number, '立花産業 株式会社');
ok($zip->set_number('1668533')->is_valid_number, '救心製薬 株式会社');
ok($zip->set_number('1668535')->is_valid_number, '株式会社 佼成出版社');
ok($zip->set_number('1668538')->is_valid_number, '学校法人 女子美術大学');
ok($zip->set_number('1668539')->is_valid_number, '社団法人 日本印刷技術協会');
ok($zip->set_number('1668540')->is_valid_number, '白石建設 株式会社');
ok($zip->set_number('1668542')->is_valid_number, '学校法人 中央ゼミナール');
ok($zip->set_number('1668545')->is_valid_number, '(株) 桐原書店');
ok($zip->set_number('1668555')->is_valid_number, '短歌新聞社');
ok($zip->set_number('1668565')->is_valid_number, '株式会社 ヴァル研究所');
ok($zip->set_number('1668566')->is_valid_number, '株式会社 ヴァル研究所');
ok($zip->set_number('1668567')->is_valid_number, '学校法人 立志舎');
ok($zip->set_number('1668570')->is_valid_number, '杉並区役所');
ok($zip->set_number('1668577')->is_valid_number, '株式会社 細田工務店');
ok($zip->set_number('1668578')->is_valid_number, '(株) 大丸ピーコック');
ok($zip->set_number('1668585')->is_valid_number, '伴久ホテル 東京営業所');
ok($zip->set_number('1668588')->is_valid_number, '医療法人財団 河北総合病院');
ok($zip->set_number('1668601')->is_valid_number, '株式会社 タマス');
ok($zip->set_number('1668610')->is_valid_number, '有限会社 いわさきちひろ作品普及会');
ok($zip->set_number('1678001')->is_valid_number, 'アメリカン・エキスプレス・インターナショナル.Inc.');
ok($zip->set_number('1678070')->is_valid_number, '株式会社 イー・エス・エス');
ok($zip->set_number('1678501')->is_valid_number, '株式会社 新星堂');
ok($zip->set_number('1678506')->is_valid_number, '荻窪税務署');
ok($zip->set_number('1678507')->is_valid_number, '東京衛生病院');
ok($zip->set_number('1678510')->is_valid_number, '東亜紙巧業 株式会社');
ok($zip->set_number('1678515')->is_valid_number, '荻窪病院');
ok($zip->set_number('1678520')->is_valid_number, '丸美屋食品工業 株式会社');
ok($zip->set_number('1678533')->is_valid_number, '日本ヒューレット・パッカード 株式会社');
ok($zip->set_number('1678534')->is_valid_number, '東京電力 株式会社 東京支店荻窪支社');
ok($zip->set_number('1678540')->is_valid_number, '日本無線 株式会社');
ok($zip->set_number('1678551')->is_valid_number, 'ケーオーデンタル 株式会社');
ok($zip->set_number('1678555')->is_valid_number, '株式会社 小泉');
ok($zip->set_number('1678560')->is_valid_number, '『杉並文化村』');
ok($zip->set_number('1678567')->is_valid_number, '株式会社 エス・シー・アライアンス');
ok($zip->set_number('1678577')->is_valid_number, '株式会社 ビーアンドディー');
ok($zip->set_number('1678578')->is_valid_number, '株式会社 ジャパレン');
ok($zip->set_number('1678585')->is_valid_number, '東京女子大学');
ok($zip->set_number('1678601')->is_valid_number, '株式会社 イー・エス・エス');
ok($zip->set_number('1678602')->is_valid_number, '株式会社 イー・エス・エス');
ok($zip->set_number('1678610')->is_valid_number, '丸美屋食品工業 株式会社');
ok($zip->set_number('1678628')->is_valid_number, '株式会社 日本標準');
ok($zip->set_number('1688081')->is_valid_number, '株式会社 郵趣サービス社');
ok($zip->set_number('1688501')->is_valid_number, '岩崎通信機 株式会社');
ok($zip->set_number('1688502')->is_valid_number, '岩通システムソリューション 株式会社');
ok($zip->set_number('1688503')->is_valid_number, '株式会社 岩通シャトルシステム');
ok($zip->set_number('1688504')->is_valid_number, '岩通アイセック 株式会社');
ok($zip->set_number('1688506')->is_valid_number, '朝日生命保険 相互会社');
ok($zip->set_number('1688508')->is_valid_number, '学校法人 高千穂学園');
ok($zip->set_number('1688510')->is_valid_number, '浴風会');
ok($zip->set_number('1688511')->is_valid_number, '岩通計測 株式会社');
ok($zip->set_number('1688512')->is_valid_number, '岩通計測製造 株式会社 久我山工場');
ok($zip->set_number('1688520')->is_valid_number, '松風園');
ok($zip->set_number('1688525')->is_valid_number, '浴風会ケアハウス');
ok($zip->set_number('1688530')->is_valid_number, '浴風園');
ok($zip->set_number('1688533')->is_valid_number, 'ミサワホーム 株式会社');
ok($zip->set_number('1688550')->is_valid_number, '南陽園');
ok($zip->set_number('1688555')->is_valid_number, '学校法人 明治大学 和泉校舎');
ok($zip->set_number('1688558')->is_valid_number, '山崎製パン 株式会社 杉並工場');
ok($zip->set_number('1688560')->is_valid_number, '第二南陽園');
ok($zip->set_number('1688570')->is_valid_number, '宗教法人 大宮八幡宮');
ok($zip->set_number('1688585')->is_valid_number, '日本ヒューレット・パッカード 株式会社 高井戸事業所');
ok($zip->set_number('1688601')->is_valid_number, '東京水道局 杉並西営業所');
ok($zip->set_number('1688611')->is_valid_number, '株式会社 アルク');
ok($zip->set_number('1688616')->is_valid_number, '学校法人 立教女学院');
ok($zip->set_number('1688626')->is_valid_number, '立教女学院短期大学');
ok($zip->set_number('1688681')->is_valid_number, '株式会社 アルク');
ok($zip->set_number('1688686')->is_valid_number, 'サミット 株式会社');
ok($zip->set_number('1698011')->is_valid_number, '日本通信教育連盟');
ok($zip->set_number('1698012')->is_valid_number, '東京社会保険事務局');
ok($zip->set_number('1698050')->is_valid_number, '早稲田大学');
ok($zip->set_number('1698077')->is_valid_number, '株式会社 説話社 マイバースディ編集室');
ok($zip->set_number('1698503')->is_valid_number, '呉羽化学工業 株式会社 生物医学研究所');
ok($zip->set_number('1698507')->is_valid_number, 'ホテル 海洋');
ok($zip->set_number('1698508')->is_valid_number, '日本年金機構 健康保険組合');
ok($zip->set_number('1698509')->is_valid_number, 'キリスト教学校教育同盟');
ok($zip->set_number('1698510')->is_valid_number, '株式会社 コスモリバティ社');
ok($zip->set_number('1698511')->is_valid_number, '株式会社 コクド東京セールスセンター');
ok($zip->set_number('1698515')->is_valid_number, '株式会社 ロッテ 新宿工場');
ok($zip->set_number('1698516')->is_valid_number, '関東ITソフトウェア健康保険組合');
ok($zip->set_number('1698517')->is_valid_number, '大久保健診センター');
ok($zip->set_number('1698520')->is_valid_number, '株式会社 井成');
ok($zip->set_number('1698521')->is_valid_number, '社団法人 俳人協会');
ok($zip->set_number('1698522')->is_valid_number, '学校法人 電子学園 日本電子専門学校');
ok($zip->set_number('1698525')->is_valid_number, '株式会社 益田屋');
ok($zip->set_number('1698526')->is_valid_number, '生活協同組合 パルシステム東京');
ok($zip->set_number('1698527')->is_valid_number, 'パルシステム 生活協同組合連合会');
ok($zip->set_number('1698530')->is_valid_number, '株式会社 ニユートーキヨー');
ok($zip->set_number('1698531')->is_valid_number, '株式会社 シジシージャパン');
ok($zip->set_number('1698533')->is_valid_number, '豊生堂');
ok($zip->set_number('1698535')->is_valid_number, '日本年金機構 会計部');
ok($zip->set_number('1698540')->is_valid_number, '日本赤十字社 東京都支部');
ok($zip->set_number('1698541')->is_valid_number, '東京税務会計事務所 健康保険組合');
ok($zip->set_number('1698543')->is_valid_number, '東京特殊電線 株式会社');
ok($zip->set_number('1698550')->is_valid_number, '株式会社 三徳');
ok($zip->set_number('1698551')->is_valid_number, '株式会社 博鳳堂');
ok($zip->set_number('1698555')->is_valid_number, '早稲田大学 理工学部');
ok($zip->set_number('1698556')->is_valid_number, '東京都 電設工業厚生年金基金');
ok($zip->set_number('1698558')->is_valid_number, '株式会社 河田');
ok($zip->set_number('1698560')->is_valid_number, '大東 株式会社');
ok($zip->set_number('1698561')->is_valid_number, '新宿税務署');
ok($zip->set_number('1698568')->is_valid_number, '財団法人 実務技能検定協会');
ok($zip->set_number('1698570')->is_valid_number, '日拓エンタープライズ (株)');
ok($zip->set_number('1698577')->is_valid_number, '(株) 白夜書房');
ok($zip->set_number('1698580')->is_valid_number, 'マルコメ (株) 東京支店');
ok($zip->set_number('1698585')->is_valid_number, '株式会社 ヨドバシカメラ');
ok($zip->set_number('1698586')->is_valid_number, '社会福祉法人 日本点字図書館');
ok($zip->set_number('1698588')->is_valid_number, '株式会社 三栄書房');
ok($zip->set_number('1698601')->is_valid_number, '新宿社会保険事務所');
ok($zip->set_number('1698603')->is_valid_number, '日本カードセンター (株)');
ok($zip->set_number('1698605')->is_valid_number, '株式会社 ぱぁとわん');
ok($zip->set_number('1698608')->is_valid_number, '(株) 學燈社');
ok($zip->set_number('1698610')->is_valid_number, '警視庁 戸塚警察署');
ok($zip->set_number('1698611')->is_valid_number, 'シャプラニール 市民による海外協力の会');
ok($zip->set_number('1698612')->is_valid_number, '中央開発 株式会社');
ok($zip->set_number('1698613')->is_valid_number, '(株) リーガロイヤルホテル早稲田');
ok($zip->set_number('1698616')->is_valid_number, '(財) 早稲田奉仕園');
ok($zip->set_number('1698620')->is_valid_number, '株式会社 CSK');
ok($zip->set_number('1698624')->is_valid_number, '財団法人 宇宙環境利用推進センター');
ok($zip->set_number('1698631')->is_valid_number, 'エコラボ (株)');
ok($zip->set_number('1698637')->is_valid_number, 'ゼンケン教育システム 株式会社');
ok($zip->set_number('1698639')->is_valid_number, '株式会社 サンマーク');
ok($zip->set_number('1698640')->is_valid_number, 'コーエークレジット 株式会社');
ok($zip->set_number('1698644')->is_valid_number, '三葉化工 株式会社');
ok($zip->set_number('1698645')->is_valid_number, 'コーエークレジット 株式会社 管理部');
ok($zip->set_number('1698648')->is_valid_number, '東亜ディーケーケー 株式会社');
ok($zip->set_number('1698650')->is_valid_number, '全国建設労働組合総連合');
ok($zip->set_number('1698655')->is_valid_number, '株式会社 マツダアンフィニ東京');
ok($zip->set_number('1698656')->is_valid_number, '中央建設国民健康保険組合');
ok($zip->set_number('1698661')->is_valid_number, 'HOYA 株式会社');
ok($zip->set_number('1698664')->is_valid_number, '社会福祉法人 日本盲人会連合');
ok($zip->set_number('1698666')->is_valid_number, '株式会社 三菱電機ビジネスシステム');
ok($zip->set_number('1698668')->is_valid_number, '花田歯科医院');
ok($zip->set_number('1698677')->is_valid_number, 'ビッグボックス西武スポーツプラザ');
ok($zip->set_number('1698678')->is_valid_number, '若生出版 株式会社');
ok($zip->set_number('1698701')->is_valid_number, '安田生命保険 相互会社');
ok($zip->set_number('1698711')->is_valid_number, '株式会社 日本文化センター');
ok($zip->set_number('1698722')->is_valid_number, '株式会社 プランネル');
ok($zip->set_number('1698915')->is_valid_number, '日本文化出版 (株)');
ok($zip->set_number('1706080')->is_valid_number, 'アグリネット');
ok($zip->set_number('1708073')->is_valid_number, '社団法人 日本アマチュア無線連盟');
ok($zip->set_number('1708401')->is_valid_number, '株式会社 マルエツ');
ok($zip->set_number('1708402')->is_valid_number, '株式会社 クレディセゾン 東京営業所');
ok($zip->set_number('1708404')->is_valid_number, '株式会社 ファミリーマート 本部');
ok($zip->set_number('1708405')->is_valid_number, 'トヨタ自動車 株式会社 池袋ビル');
ok($zip->set_number('1708406')->is_valid_number, 'カードショップ 羅針盤');
ok($zip->set_number('1708409')->is_valid_number, '池袋公共職業安定所(ハローワーク池袋)');
ok($zip->set_number('1708410')->is_valid_number, '大東京火災海上保険 株式会社');
ok($zip->set_number('1708411')->is_valid_number, 'NTTインターナショナル (株)');
ok($zip->set_number('1708415')->is_valid_number, '株式会社 ワンダーライフ');
ok($zip->set_number('1708416')->is_valid_number, 'デュプロ 株式会社');
ok($zip->set_number('1708417')->is_valid_number, '株式会社 倉本産業');
ok($zip->set_number('1708419')->is_valid_number, 'ビックカメラ 本店');
ok($zip->set_number('1708420')->is_valid_number, '日本信販 株式会社 事務システム本部');
ok($zip->set_number('1708421')->is_valid_number, 'ダイワ商事 株式会社');
ok($zip->set_number('1708422')->is_valid_number, '豊島区役所');
ok($zip->set_number('1708423')->is_valid_number, 'テンプスタッフ 株式会社');
ok($zip->set_number('1708424')->is_valid_number, '良品計画・東池袋');
ok($zip->set_number('1708426')->is_valid_number, '学校法人 東京福祉大学');
ok($zip->set_number('1708427')->is_valid_number, '株式会社 芸文社');
ok($zip->set_number('1708430')->is_valid_number, 'ドコモサービス 株式会社 東京モバイル第一料金センター');
ok($zip->set_number('1708432')->is_valid_number, '株式会社 三貴');
ok($zip->set_number('1708433')->is_valid_number, '池袋ショッピングパーク');
ok($zip->set_number('1708434')->is_valid_number, '学校法人 サンシャイン学園');
ok($zip->set_number('1708436')->is_valid_number, 'サミー 株式会社');
ok($zip->set_number('1708438')->is_valid_number, '株式会社 ビーエフ');
ok($zip->set_number('1708440')->is_valid_number, 'サンシャインシティプリンスホテル');
ok($zip->set_number('1708441')->is_valid_number, '木内建設 株式会社 東京支店');
ok($zip->set_number('1708442')->is_valid_number, '豊島区立中央図書館');
ok($zip->set_number('1708444')->is_valid_number, '学校法人 都築関東学園東京国際情報ビジネス専門学校');
ok($zip->set_number('1708447')->is_valid_number, '株式会社 アムラックス・トヨタ');
ok($zip->set_number('1708448')->is_valid_number, '菱電商事 株式会社');
ok($zip->set_number('1708450')->is_valid_number, '株式会社 アーバンウエスト');
ok($zip->set_number('1708451')->is_valid_number, '山洋電気 株式会社');
ok($zip->set_number('1708455')->is_valid_number, '財団法人 癌研究会');
ok($zip->set_number('1708456')->is_valid_number, '東都化学工業 株式会社');
ok($zip->set_number('1708457')->is_valid_number, '株式会社 ベストセラーズ');
ok($zip->set_number('1708458')->is_valid_number, '(社) 全日本ピアノ指導者協会');
ok($zip->set_number('1708459')->is_valid_number, '株式会社 ユーコー');
ok($zip->set_number('1708460')->is_valid_number, '株式会社 銀行研修社');
ok($zip->set_number('1708461')->is_valid_number, 'CQ出版 株式会社');
ok($zip->set_number('1708465')->is_valid_number, '株式会社 東京めいらく');
ok($zip->set_number('1708466')->is_valid_number, '株式会社 日立プラントテクノロジー');
ok($zip->set_number('1708470')->is_valid_number, '大正大学');
ok($zip->set_number('1708476')->is_valid_number, '東京都立大塚病院');
ok($zip->set_number('1708477')->is_valid_number, '巣鴨信用金庫');
ok($zip->set_number('1708480')->is_valid_number, '財団法人 電気通信振興会');
ok($zip->set_number('1708488')->is_valid_number, '永田精機 株式会社');
ok($zip->set_number('1708551')->is_valid_number, 'ナウカ 株式会社');
ok($zip->set_number('1708585')->is_valid_number, '財団法人 日本データ通信協会');
ok($zip->set_number('1708602')->is_valid_number, '第一勧業銀行 池袋支店');
ok($zip->set_number('1708605')->is_valid_number, '中央三井信託銀行');
ok($zip->set_number('1708612')->is_valid_number, '光文社');
ok($zip->set_number('1708633')->is_valid_number, '大正製薬 株式会社');
ok($zip->set_number('1708635')->is_valid_number, '大正富山医薬品 株式会社');
ok($zip->set_number('1708653')->is_valid_number, '日本長期信用銀行 池袋支店');
ok($zip->set_number('1708666')->is_valid_number, '有限会社 エンゼルダイレクト');
ok($zip->set_number('1708686')->is_valid_number, '株式会社 日本香堂');
ok($zip->set_number('1718501')->is_valid_number, '立教大学');
ok($zip->set_number('1718502')->is_valid_number, '池袋労働基準監督署');
ok($zip->set_number('1718503')->is_valid_number, '財団法人 関東電気保安協会');
ok($zip->set_number('1718507')->is_valid_number, '東京法務局 豊島出張所');
ok($zip->set_number('1718508')->is_valid_number, '三菱信託銀行 株式会社 証券代行部');
ok($zip->set_number('1718509')->is_valid_number, '東京都自動車税総合事務所');
ok($zip->set_number('1718510')->is_valid_number, '株式会社 婦人之友社');
ok($zip->set_number('1718511')->is_valid_number, '株式会社 建築資料研究社');
ok($zip->set_number('1718512')->is_valid_number, '株式会社 東武百貨店 池袋店');
ok($zip->set_number('1718514')->is_valid_number, '株式会社 日立国際電気サービス');
ok($zip->set_number('1718516')->is_valid_number, '日本加除出版 株式会社');
ok($zip->set_number('1718518')->is_valid_number, '(株) アップルホテルズ');
ok($zip->set_number('1718520')->is_valid_number, 'ハナシン 株式会社');
ok($zip->set_number('1718521')->is_valid_number, '豊島税務署');
ok($zip->set_number('1718522')->is_valid_number, 'オリヒロ 株式会社 東京支店');
ok($zip->set_number('1718523')->is_valid_number, '警視庁 池袋通告センター');
ok($zip->set_number('1718525')->is_valid_number, 'リコーエレメックス 株式会社');
ok($zip->set_number('1718526')->is_valid_number, '養老乃瀧 株式会社');
ok($zip->set_number('1718527')->is_valid_number, '株式会社 ジェムスタージャパン');
ok($zip->set_number('1718528')->is_valid_number, '東京都主税局 徴収部 都税還付管理室');
ok($zip->set_number('1718531')->is_valid_number, '綜研化学 株式会社');
ok($zip->set_number('1718535')->is_valid_number, '株式会社 エイ・エス・ティ');
ok($zip->set_number('1718539')->is_valid_number, 'ワールドファミリー 株式会社');
ok($zip->set_number('1718540')->is_valid_number, '東京音楽大学');
ok($zip->set_number('1718544')->is_valid_number, '東洋ゴム工業 株式会社 東京本社');
ok($zip->set_number('1718545')->is_valid_number, '中外製薬 株式会社 中央研究所');
ok($zip->set_number('1718550')->is_valid_number, '株式会社 キンカ堂');
ok($zip->set_number('1718552')->is_valid_number, '白十字 株式会社');
ok($zip->set_number('1718555')->is_valid_number, 'オリジン電気 株式会社');
ok($zip->set_number('1718557')->is_valid_number, '株式会社 パルコ');
ok($zip->set_number('1718558')->is_valid_number, 'エヌピー通信社');
ok($zip->set_number('1718560')->is_valid_number, '株木建設 株式会社 本社');
ok($zip->set_number('1718561')->is_valid_number, '株木建設 株式会社 東京支店');
ok($zip->set_number('1718568')->is_valid_number, '株式会社 清和ライフサービス');
ok($zip->set_number('1718569')->is_valid_number, '株式会社 西武百貨店 池袋店');
ok($zip->set_number('1718570')->is_valid_number, '株式会社 白夜書房');
ok($zip->set_number('1718572')->is_valid_number, '鉱研工業 株式会社');
ok($zip->set_number('1718577')->is_valid_number, '(有) オートショップ馬力屋');
ok($zip->set_number('1718582')->is_valid_number, '株式会社 日本ドリコム');
ok($zip->set_number('1718586')->is_valid_number, '(財) 実務技能検定協会');
ok($zip->set_number('1738501')->is_valid_number, '東京都 板橋区役所');
ok($zip->set_number('1738510')->is_valid_number, '東京都板橋都税事務所');
ok($zip->set_number('1738511')->is_valid_number, '株式会社 モトヤ 東京本社');
ok($zip->set_number('1738512')->is_valid_number, '株式会社 ハリカ');
ok($zip->set_number('1738515')->is_valid_number, '国立極地研究所');
ok($zip->set_number('1738516')->is_valid_number, '(株) マツダアンフィニ東京');
ok($zip->set_number('1738517')->is_valid_number, '(株) マツダアンフィニ南東京');
ok($zip->set_number('1738518')->is_valid_number, '(株) マツダアンフィニ西東京');
ok($zip->set_number('1738519')->is_valid_number, '(株) マツダアンフィニ北東京');
ok($zip->set_number('1738530')->is_valid_number, '板橋税務署');
ok($zip->set_number('1738540')->is_valid_number, 'エクシオ物流サービス 株式会社');
ok($zip->set_number('1738543')->is_valid_number, '松崎商事 株式会社');
ok($zip->set_number('1738552')->is_valid_number, '株式会社 イシダ 東京支店');
ok($zip->set_number('1738555')->is_valid_number, '学校法人 帝京学園 帝京中学校 帝京高等学校');
ok($zip->set_number('1738558')->is_valid_number, '株式会社 ムービック');
ok($zip->set_number('1738561')->is_valid_number, '株式会社 フロンティアワークス');
ok($zip->set_number('1738580')->is_valid_number, '昭産商事 株式会社');
ok($zip->set_number('1738585')->is_valid_number, '株式会社 コバックス');
ok($zip->set_number('1738588')->is_valid_number, '財団法人 愛世会 愛誠病院');
ok($zip->set_number('1738601')->is_valid_number, '株式会社 ライカ 東京支店');
ok($zip->set_number('1738602')->is_valid_number, '東京家政大学');
ok($zip->set_number('1738605')->is_valid_number, '帝京大学');
ok($zip->set_number('1738606')->is_valid_number, '帝京大学医学部附属病院');
ok($zip->set_number('1738610')->is_valid_number, '日本大学 医学部');
ok($zip->set_number('1738611')->is_valid_number, '板橋工業 株式会社');
ok($zip->set_number('1738632')->is_valid_number, '株式会社 チノー');
ok($zip->set_number('1738639')->is_valid_number, 'カネボウフーズ 株式会社');
ok($zip->set_number('1738648')->is_valid_number, '富士テレコム 株式会社');
ok($zip->set_number('1738666')->is_valid_number, '東洋インキSCホールディングス 株式会社 十条センター');
ok($zip->set_number('1738710')->is_valid_number, '株式会社 日刊建設産業新聞社');
ok($zip->set_number('1748501')->is_valid_number, 'トックベアリング (株)');
ok($zip->set_number('1748505')->is_valid_number, 'オリエンタル酵母工業 株式会社');
ok($zip->set_number('1748520')->is_valid_number, '大日本インキ化学工業 株式会社');
ok($zip->set_number('1748521')->is_valid_number, '東京日野自動車 株式会社');
ok($zip->set_number('1748524')->is_valid_number, '芝浦工業大学中学高等学校');
ok($zip->set_number('1748526')->is_valid_number, '電設健保総合健康管理センター');
ok($zip->set_number('1748530')->is_valid_number, '群峰工業 (株)');
ok($zip->set_number('1748550')->is_valid_number, '日本電産コパル 株式会社');
ok($zip->set_number('1748555')->is_valid_number, '三菱化学メディエンス 株式会社');
ok($zip->set_number('1748558')->is_valid_number, '凸版印刷 株式会社 情報コミュニケーション事業本部');
ok($zip->set_number('1748560')->is_valid_number, '日本金属 株式会社 板橋工場');
ok($zip->set_number('1748567')->is_valid_number, '(株) 鈴木商館');
ok($zip->set_number('1748588')->is_valid_number, '淑徳小学校');
ok($zip->set_number('1748601')->is_valid_number, '(株) タニタハウジングウェア');
ok($zip->set_number('1748612')->is_valid_number, 'アステラス製薬 株式会社 総務室');
ok($zip->set_number('1748633')->is_valid_number, '(株) ライト製作所');
ok($zip->set_number('1748636')->is_valid_number, '千葉金属工業 株式会社');
ok($zip->set_number('1748639')->is_valid_number, 'ペンタックス 株式会社');
ok($zip->set_number('1748646')->is_valid_number, '淑徳幼児教育専門学校');
ok($zip->set_number('1748680')->is_valid_number, '飯沼病院');
ok($zip->set_number('1748686')->is_valid_number, '医療法人 慈誠会 上板橋病院');
ok($zip->set_number('1748688')->is_valid_number, '日本教育書道連盟、財団法人 日本書道美術館');
ok($zip->set_number('1748701')->is_valid_number, '株式会社 昭和コーポレーション');
ok($zip->set_number('1748711')->is_valid_number, '城北学園');
ok($zip->set_number('1748730')->is_valid_number, '金門製作所');
ok($zip->set_number('1748737')->is_valid_number, '株式会社 中央社');
ok($zip->set_number('1748739')->is_valid_number, '栗田出版販売');
ok($zip->set_number('1748740')->is_valid_number, '東京セールスプロデュース (株)');
ok($zip->set_number('1748741')->is_valid_number, '(株) ディーエムエス');
ok($zip->set_number('1748743')->is_valid_number, '(株) ディーエムエス');
ok($zip->set_number('1748744')->is_valid_number, '理研計器 株式会社');
ok($zip->set_number('1748860')->is_valid_number, '共立印刷 (株)');
ok($zip->set_number('1748903')->is_valid_number, '清水産業 (株)');
ok($zip->set_number('1758571')->is_valid_number, '学校法人 大東文化学園');
ok($zip->set_number('1758577')->is_valid_number, '株式会社 クレディセゾン 管理部');
ok($zip->set_number('1758588')->is_valid_number, '日本電機ヒーター 株式会社');
ok($zip->set_number('1768501')->is_valid_number, '練馬区役所');
ok($zip->set_number('1768502')->is_valid_number, '株式会社 シコクヤ');
ok($zip->set_number('1768503')->is_valid_number, '練馬東税務署');
ok($zip->set_number('1768507')->is_valid_number, 'アイカ販売 株式会社');
ok($zip->set_number('1768508')->is_valid_number, '太陽インキ製造 株式会社');
ok($zip->set_number('1768510')->is_valid_number, '株式会社 兼松KGK');
ok($zip->set_number('1768511')->is_valid_number, '東京都練馬都税事務所');
ok($zip->set_number('1768512')->is_valid_number, '品川電線 株式会社');
ok($zip->set_number('1768515')->is_valid_number, '東京電力 株式会社 練馬営業センター');
ok($zip->set_number('1768516')->is_valid_number, '三菱電線工業 株式会社');
ok($zip->set_number('1768518')->is_valid_number, '株式会社 永岡書店');
ok($zip->set_number('1768521')->is_valid_number, '学校法人 武蔵野音楽学園');
ok($zip->set_number('1768522')->is_valid_number, '野口興産 株式会社');
ok($zip->set_number('1768525')->is_valid_number, '日本大学 芸術学部');
ok($zip->set_number('1768528')->is_valid_number, 'アジアカラー 株式会社');
ok($zip->set_number('1768530')->is_valid_number, '練馬総合病院');
ok($zip->set_number('1768531')->is_valid_number, '株式会社 豊島園');
ok($zip->set_number('1768533')->is_valid_number, '学校法人 根津育英会');
ok($zip->set_number('1768534')->is_valid_number, '武蔵大学');
ok($zip->set_number('1768535')->is_valid_number, '武蔵高等学校・中学校');
ok($zip->set_number('1768536')->is_valid_number, '内野建設 株式会社');
ok($zip->set_number('1768540')->is_valid_number, '都水道局 練馬東営業所');
ok($zip->set_number('1768560')->is_valid_number, '(株) 協和');
ok($zip->set_number('1768585')->is_valid_number, '三笠製薬 株式会社');
ok($zip->set_number('1778501')->is_valid_number, '大陽ステンレススプリング (株)');
ok($zip->set_number('1778502')->is_valid_number, '独立行政法人 労働政策研究・研修機構');
ok($zip->set_number('1778503')->is_valid_number, '株式会社 アートプリントジャパン');
ok($zip->set_number('1778505')->is_valid_number, '株式会社 タケダ');
ok($zip->set_number('1778507')->is_valid_number, '東京都水道局 練馬西営業所');
ok($zip->set_number('1778508')->is_valid_number, '社団法人 練馬区医師会');
ok($zip->set_number('1778509')->is_valid_number, '練馬区石神井庁舎');
ok($zip->set_number('1778511')->is_valid_number, '生活協同組合 コープとうきょう');
ok($zip->set_number('1778521')->is_valid_number, '順天堂大学医学部附属 練馬病院');
ok($zip->set_number('1788501')->is_valid_number, '陸上自衛隊 朝霞駐屯地');
ok($zip->set_number('1788502')->is_valid_number, '株式会社 西友オズ 大泉西武店');
ok($zip->set_number('1788511')->is_valid_number, '株式会社 タムラ製作所');
ok($zip->set_number('1788555')->is_valid_number, 'ペンタックスインダストリアルインスツルメンツ 株式会社');
ok($zip->set_number('1788567')->is_valid_number, '東映アニメーション 株式会社');
ok($zip->set_number('1788601')->is_valid_number, '大泉 総合福祉事務所');
ok($zip->set_number('1788624')->is_valid_number, '練馬西 税務署');
ok($zip->set_number('1788666')->is_valid_number, '東映 株式会社 東京撮影所');
ok($zip->set_number('1788686')->is_valid_number, '株式会社 セコニック');
ok($zip->set_number('1798501')->is_valid_number, '東京法務局 練馬出張所');
ok($zip->set_number('1798901')->is_valid_number, '松下ライフエレクトロニクス (株)');
ok($zip->set_number('1798903')->is_valid_number, '前田建設 (株)');
ok($zip->set_number('1798904')->is_valid_number, '河端建設 (株)');
ok($zip->set_number('1798906')->is_valid_number, '光が丘パークヴィラ');
ok($zip->set_number('1798907')->is_valid_number, '光が丘高等学校');
ok($zip->set_number('1798909')->is_valid_number, '練馬工業高等学校');
ok($zip->set_number('1798910')->is_valid_number, '科学技術振興機構 情報資料館');
ok($zip->set_number('1798911')->is_valid_number, 'トモダ企画');
ok($zip->set_number('1798914')->is_valid_number, '前田建設 技術研究所');
ok($zip->set_number('1808505')->is_valid_number, '学校法人 井之頭学園藤村女子中学・高等学校');
ok($zip->set_number('1808508')->is_valid_number, '株式会社 日本マイクロニクス');
ok($zip->set_number('1808517')->is_valid_number, 'サンケイリビング新聞社 武蔵野本部');
ok($zip->set_number('1808519')->is_valid_number, '株式会社 東急百貨店 吉祥寺店');
ok($zip->set_number('1808522')->is_valid_number, '武蔵野税務署');
ok($zip->set_number('1808527')->is_valid_number, '株式会社 冬水社');
ok($zip->set_number('1808531')->is_valid_number, '三井生命 武蔵野支社');
ok($zip->set_number('1808533')->is_valid_number, '名糖運輸 株式会社');
ok($zip->set_number('1808538')->is_valid_number, '株式会社 モンテローザ');
ok($zip->set_number('1808550')->is_valid_number, 'ティアック 株式会社');
ok($zip->set_number('1808555')->is_valid_number, 'ヒューマン 株式会社');
ok($zip->set_number('1808566')->is_valid_number, '学校法人 武蔵野美術大学 武蔵野美術学園 武蔵野美術大学短期大学部 通信教育部');
ok($zip->set_number('1808567')->is_valid_number, '三和ファイナンス 株式会社');
ok($zip->set_number('1808571')->is_valid_number, '太平信用金庫');
ok($zip->set_number('1808577')->is_valid_number, '東京電力 株式会社 武蔵野支社');
ok($zip->set_number('1808580')->is_valid_number, '株式会社 すかいらーく');
ok($zip->set_number('1808602')->is_valid_number, '日本獣医畜産大学');
ok($zip->set_number('1808608')->is_valid_number, '株式会社 すかいらーくD&M');
ok($zip->set_number('1808610')->is_valid_number, '武蔵野赤十字病院');
ok($zip->set_number('1808611')->is_valid_number, 'ユニダックス 株式会社');
ok($zip->set_number('1808618')->is_valid_number, '日本赤十字武蔵野短期大学');
ok($zip->set_number('1808629')->is_valid_number, '学校法人 亜細亜学園');
ok($zip->set_number('1808630')->is_valid_number, '東亜ディーケーケー (株) 武蔵野RDセンター');
ok($zip->set_number('1808633')->is_valid_number, '学校法人 成蹊学園(成蹊大学・成蹊高等学校・成蹊中学校・成蹊小学校)');
ok($zip->set_number('1808660')->is_valid_number, '株式会社 ティアックシステムクリエイト');
ok($zip->set_number('1808750')->is_valid_number, '横河電機 株式会社');
ok($zip->set_number('1808777')->is_valid_number, '武蔵野市役所');
ok($zip->set_number('1818001')->is_valid_number, '株式会社 ジェーシービー JCBカードセンター');
ok($zip->set_number('1818503')->is_valid_number, '医療法人財団 慈生会 野村病院');
ok($zip->set_number('1818505')->is_valid_number, '三鷹市教育委員会');
ok($zip->set_number('1818510')->is_valid_number, '日本無線 株式会社');
ok($zip->set_number('1818511')->is_valid_number, 'セントラル・コンピュータ・サービス 株式会社 情報通信センター');
ok($zip->set_number('1818515')->is_valid_number, '株式会社 東京精密');
ok($zip->set_number('1818517')->is_valid_number, '三鷹公共職業安定所');
ok($zip->set_number('1818518')->is_valid_number, '春日電機 株式会社');
ok($zip->set_number('1818520')->is_valid_number, 'キヤノンファインテック 株式会社');
ok($zip->set_number('1818521')->is_valid_number, 'セコムTEセンター');
ok($zip->set_number('1818522')->is_valid_number, '株式会社 ジャパンエナジー JOMOカードセンター');
ok($zip->set_number('1818528')->is_valid_number, 'セコムSCセンター');
ok($zip->set_number('1818531')->is_valid_number, '財団法人 井之頭病院');
ok($zip->set_number('1818533')->is_valid_number, 'アツデン 株式会社');
ok($zip->set_number('1818535')->is_valid_number, '株式会社 テスコ');
ok($zip->set_number('1818541')->is_valid_number, 'サンマルイ (株) 西東京カンパニー');
ok($zip->set_number('1818551')->is_valid_number, '酒井薬品 株式会社');
ok($zip->set_number('1818555')->is_valid_number, '三鷹市役所');
ok($zip->set_number('1818571')->is_valid_number, '株式会社 ジャムコ');
ok($zip->set_number('1818577')->is_valid_number, '富士重工業 株式会社 東京事業所');
ok($zip->set_number('1818585')->is_valid_number, '学校法人 国際基督教大学(ICU)');
ok($zip->set_number('1818586')->is_valid_number, '長谷川病院');
ok($zip->set_number('1818587')->is_valid_number, '廣屋国分 株式会社');
ok($zip->set_number('1818588')->is_valid_number, '大学共同利用機関法人 自然科学研究機構 国立天文台');
ok($zip->set_number('1818601')->is_valid_number, 'アサカ物産 株式会社');
ok($zip->set_number('1818608')->is_valid_number, 'アイデックスラボラトリーズ 株式会社');
ok($zip->set_number('1818611')->is_valid_number, '学校法人 杏林学園');
ok($zip->set_number('1818614')->is_valid_number, '杏林大学医学部付属看護専門学校');
ok($zip->set_number('1818622')->is_valid_number, 'アロカ 株式会社');
ok($zip->set_number('1818633')->is_valid_number, '消防研究所');
ok($zip->set_number('1818648')->is_valid_number, 'いずみ書房 株式会社');
ok($zip->set_number('1828001')->is_valid_number, 'アフラック調布サウスゲートビル');
ok($zip->set_number('1828508')->is_valid_number, '消防大学校');
ok($zip->set_number('1828510')->is_valid_number, '桐朋学園 女子部門');
ok($zip->set_number('1828511')->is_valid_number, '調布市役所');
ok($zip->set_number('1828512')->is_valid_number, '林建設 株式会社');
ok($zip->set_number('1828520')->is_valid_number, '株式会社 共和電業');
ok($zip->set_number('1828522')->is_valid_number, '航空宇宙技術研究所');
ok($zip->set_number('1828525')->is_valid_number, '白百合女子大学');
ok($zip->set_number('1828555')->is_valid_number, '株式会社 東京現像所');
ok($zip->set_number('1828558')->is_valid_number, 'キユーピー 株式会社 仙川工場');
ok($zip->set_number('1828567')->is_valid_number, '小田急バス 株式会社');
ok($zip->set_number('1828570')->is_valid_number, '東京慈恵会 医科大学');
ok($zip->set_number('1828585')->is_valid_number, '電気通信大学');
ok($zip->set_number('1828601')->is_valid_number, '第百生命保険 相互会社');
ok($zip->set_number('1828602')->is_valid_number, '島田理化工業 (株)');
ok($zip->set_number('1828621')->is_valid_number, 'マニュライフ・センチュリー生命保険 株式会社');
ok($zip->set_number('1828686')->is_valid_number, '株式会社 フジカラーサービス 東京事業所');
ok($zip->set_number('1838501')->is_valid_number, '日本電気 株式会社 府中事業場');
ok($zip->set_number('1838502')->is_valid_number, 'NEC中河原技術センター');
ok($zip->set_number('1838505')->is_valid_number, '府中社会保険事務所');
ok($zip->set_number('1838506')->is_valid_number, '警視庁 府中運転免許試験場');
ok($zip->set_number('1838508')->is_valid_number, 'キヤノンアネルバ 株式会社');
ok($zip->set_number('1838511')->is_valid_number, '(株) 東芝 府中事業所');
ok($zip->set_number('1838512')->is_valid_number, '東芝ソリューション 株式会社 府中ソリューションセンター');
ok($zip->set_number('1838513')->is_valid_number, '東芝プラントシステム 株式会社 府中事務所');
ok($zip->set_number('1838514')->is_valid_number, '多摩川競艇場');
ok($zip->set_number('1838516')->is_valid_number, '横河ディジタルコンピュータ 株式会社');
ok($zip->set_number('1838521')->is_valid_number, '航空自衛隊 府中基地');
ok($zip->set_number('1838522')->is_valid_number, '株式会社 ドライバースタンド');
ok($zip->set_number('1838524')->is_valid_number, '都立府中病院');
ok($zip->set_number('1838525')->is_valid_number, '府中市生涯学習センター');
ok($zip->set_number('1838526')->is_valid_number, '財団法人 東京都神経科学総合研究所');
ok($zip->set_number('1838528')->is_valid_number, '東芝ITサービス 株式会社');
ok($zip->set_number('1838529')->is_valid_number, '(株) 大東京綜合卸売センター');
ok($zip->set_number('1838530')->is_valid_number, '株式会社 五藤光学研究所');
ok($zip->set_number('1838532')->is_valid_number, '東芝ソリューション 株式会社 府中エンジニアリングセンター');
ok($zip->set_number('1838534')->is_valid_number, '東京外国語大学');
ok($zip->set_number('1838539')->is_valid_number, '株式会社 セイジョー');
ok($zip->set_number('1838540')->is_valid_number, '株式会社 ワイ・ディ・シー');
ok($zip->set_number('1838541')->is_valid_number, '株式会社 伊勢丹 府中店');
ok($zip->set_number('1838548')->is_valid_number, '武蔵府中税務署');
ok($zip->set_number('1838549')->is_valid_number, '東京都 府中都税支所');
ok($zip->set_number('1838550')->is_valid_number, '東京競馬場');
ok($zip->set_number('1838551')->is_valid_number, 'NEC東芝スペースシステム 株式会社');
ok($zip->set_number('1838553')->is_valid_number, '東京都立 府中療育センター');
ok($zip->set_number('1838561')->is_valid_number, '東京都立 小児総合医療センター');
ok($zip->set_number('1838701')->is_valid_number, '住友信託銀行');
ok($zip->set_number('1838702')->is_valid_number, '日本銀行 府中分館');
ok($zip->set_number('1838703')->is_valid_number, '府中市役所');
ok($zip->set_number('1838705')->is_valid_number, '東京エレクトロン 株式会社 府中テクノロジーセンター');
ok($zip->set_number('1838706')->is_valid_number, '自動車安全運転センター 東京都事務所');
ok($zip->set_number('1838707')->is_valid_number, '株式会社 スーパーヤマザキ');
ok($zip->set_number('1848501')->is_valid_number, '東京学芸大学');
ok($zip->set_number('1848502')->is_valid_number, '株式会社 ヤジマ');
ok($zip->set_number('1848503')->is_valid_number, '国際基督教大学高等学校');
ok($zip->set_number('1848504')->is_valid_number, '小金井市役所');
ok($zip->set_number('1848505')->is_valid_number, 'あいおい損害保険 (株)');
ok($zip->set_number('1848508')->is_valid_number, '財団法人 日本リハビリテーション振興会専門学校社会医学技術学院');
ok($zip->set_number('1848510')->is_valid_number, '株式会社 長崎屋 小金井店');
ok($zip->set_number('1848511')->is_valid_number, '社会福祉法人 聖ヨハネ会総合病院 桜町病院');
ok($zip->set_number('1848522')->is_valid_number, '株式会社 ムラコシ');
ok($zip->set_number('1848533')->is_valid_number, '株式会社 コガネイ');
ok($zip->set_number('1848543')->is_valid_number, '学校法人 東京工学院専門学校');
ok($zip->set_number('1848555')->is_valid_number, '東京電機大学中学校・高等学校');
ok($zip->set_number('1848558')->is_valid_number, '医療法人財団 美生会小金井病院');
ok($zip->set_number('1848567')->is_valid_number, '株式会社 ジュピターテレコム 東京メディアセンター');
ok($zip->set_number('1848575')->is_valid_number, '中央大学附属高等学校');
ok($zip->set_number('1848577')->is_valid_number, '劇団ふるさときゃらばん');
ok($zip->set_number('1848581')->is_valid_number, '東京都立小金井工業高等学校');
ok($zip->set_number('1848585')->is_valid_number, '医療法人社団 総合会武蔵野中央病院');
ok($zip->set_number('1848588')->is_valid_number, '東京農工大学 工学部');
ok($zip->set_number('1848595')->is_valid_number, '株式会社 ムラコシ精工');
ok($zip->set_number('1848795')->is_valid_number, '独立行政法人 情報通信研究機構');
ok($zip->set_number('1858501')->is_valid_number, '国分寺市役所');
ok($zip->set_number('1858502')->is_valid_number, '東京経済大学');
ok($zip->set_number('1858506')->is_valid_number, '早稲田大学系属 早稲田実業学校 初等部');
ok($zip->set_number('1858510')->is_valid_number, '鉄道情報システム 株式会社');
ok($zip->set_number('1858511')->is_valid_number, '農林水産省動物医薬品検査所');
ok($zip->set_number('1858533')->is_valid_number, 'リオン 株式会社');
ok($zip->set_number('1858540')->is_valid_number, '財団法人 鉄道総合技術研究所');
ok($zip->set_number('1858562')->is_valid_number, '株式会社 丸井 マルイファミリー国分寺');
ok($zip->set_number('1858567')->is_valid_number, 'ダイトエレクトロン 株式会社 商品仕入部 東京センター');
ok($zip->set_number('1858601')->is_valid_number, '株式会社 日立製作所 中央研究所');
ok($zip->set_number('1858795')->is_valid_number, '情報通信政策研究所');
ok($zip->set_number('1868001')->is_valid_number, 'NHK学園');
ok($zip->set_number('1868501')->is_valid_number, '国立市役所');
ok($zip->set_number('1868519')->is_valid_number, '進学舎');
ok($zip->set_number('1868585')->is_valid_number, '株式会社 セカンドスタッフ(パラダイスレコード)');
ok($zip->set_number('1868601')->is_valid_number, '一橋大学');
ok($zip->set_number('1868602')->is_valid_number, '一橋大学付属図書館');
ok($zip->set_number('1868603')->is_valid_number, '一橋大学経済研究所');
ok($zip->set_number('1868611')->is_valid_number, 'ENA');
ok($zip->set_number('1868619')->is_valid_number, '進研社');
ok($zip->set_number('1868650')->is_valid_number, 'ヤクルト中央研究所');
ok($zip->set_number('1868666')->is_valid_number, '切手趣味研究会');
ok($zip->set_number('1868668')->is_valid_number, '東京女子体育大学');
ok($zip->set_number('1868680')->is_valid_number, '東京多摩青果 株式会社');
ok($zip->set_number('1868686')->is_valid_number, '多摩中央信用金庫 国立支店');
ok($zip->set_number('1868688')->is_valid_number, '大和證券 国立支店');
ok($zip->set_number('1868797')->is_valid_number, '郵政大学校');
ok($zip->set_number('1868798')->is_valid_number, '中央郵政研修センター');
ok($zip->set_number('1878502')->is_valid_number, '国立精神・神経センター神経研究所');
ok($zip->set_number('1878503')->is_valid_number, 'わらべや日洋 株式会社');
ok($zip->set_number('1878505')->is_valid_number, '武蔵野美術大学');
ok($zip->set_number('1878507')->is_valid_number, '有限会社 鈴木園');
ok($zip->set_number('1878510')->is_valid_number, '公立昭和病院');
ok($zip->set_number('1878511')->is_valid_number, '株式会社 日立国際電気');
ok($zip->set_number('1878512')->is_valid_number, '株式会社 日立国際電気サービス');
ok($zip->set_number('1878518')->is_valid_number, '東京むさし農業共同組合 小平支店');
ok($zip->set_number('1878520')->is_valid_number, '国土交通省 国土交通大学校');
ok($zip->set_number('1878522')->is_valid_number, '株式会社 日立超LSIシステムズ');
ok($zip->set_number('1878531')->is_valid_number, '株式会社 ブリヂストン 東京工場');
ok($zip->set_number('1878533')->is_valid_number, '東京都小平都税支所');
ok($zip->set_number('1878540')->is_valid_number, '財団法人 全国建設研修センター');
ok($zip->set_number('1878551')->is_valid_number, '国立精神神経センター');
ok($zip->set_number('1878553')->is_valid_number, '国立精神・神経センター 精神保健研究所');
ok($zip->set_number('1878555')->is_valid_number, '警視庁 小平警察署');
ok($zip->set_number('1878558')->is_valid_number, '株式会社 コバヤシ');
ok($zip->set_number('1878560')->is_valid_number, '学校法人 東京朝鮮学園 朝鮮大学校');
ok($zip->set_number('1878567')->is_valid_number, '株式会社 小泉 多摩本社');
ok($zip->set_number('1878570')->is_valid_number, '学校法人 白梅学園');
ok($zip->set_number('1878577')->is_valid_number, '学校法人 津田塾大学');
ok($zip->set_number('1878578')->is_valid_number, '嘉悦大学');
ok($zip->set_number('1878581')->is_valid_number, '株式会社 紙叶');
ok($zip->set_number('1878585')->is_valid_number, '財団法人 多摩緑成会');
ok($zip->set_number('1878587')->is_valid_number, '大学評価・学位授与機構');
ok($zip->set_number('1878588')->is_valid_number, '株式会社 ルネサステクノロジ 武蔵事業所');
ok($zip->set_number('1878611')->is_valid_number, '第一屋製パン 株式会社');
ok($zip->set_number('1878701')->is_valid_number, '小平市役所');
ok($zip->set_number('1888511')->is_valid_number, 'シチズン時計 株式会社 田無製造所');
ok($zip->set_number('1888555')->is_valid_number, '石川島播磨重工業 株式会社');
ok($zip->set_number('1888585')->is_valid_number, '住友重機械工業 株式会社 田無製造所');
ok($zip->set_number('1888666')->is_valid_number, '西東京市役所 田無庁舎');
ok($zip->set_number('1888680')->is_valid_number, '株式会社 ロッテ ((株) 有謝商会)');
ok($zip->set_number('1888701')->is_valid_number, '(株) インテージ');
ok($zip->set_number('1898501')->is_valid_number, '東村山市役所');
ok($zip->set_number('1898511')->is_valid_number, '東京都 多摩老人医療センター');
ok($zip->set_number('1898520')->is_valid_number, '日機装 株式会社 東村山製作所');
ok($zip->set_number('1898521')->is_valid_number, '冨士機材 株式会社 多摩支店');
ok($zip->set_number('1898550')->is_valid_number, '国立療養所 多磨全生園');
ok($zip->set_number('1898555')->is_valid_number, '東村山税務署');
ok($zip->set_number('1898585')->is_valid_number, '山崎製パン (株) 武蔵野第二工場');
ok($zip->set_number('1900192')->is_valid_number, '日の出町役場');
ok($zip->set_number('1901292')->is_valid_number, '瑞穂町役場');
ok($zip->set_number('1901293')->is_valid_number, '株式会社 桝屋');
ok($zip->set_number('1901295')->is_valid_number, '株式会社 ソニック');
ok($zip->set_number('1901297')->is_valid_number, '株式会社 IHI');
ok($zip->set_number('1908501')->is_valid_number, '陸上自衛隊 立川駐屯地');
ok($zip->set_number('1908503')->is_valid_number, '住宅・都市整備公団 東京支社 北多摩営業所');
ok($zip->set_number('1908505')->is_valid_number, '株式会社 和凰');
ok($zip->set_number('1908506')->is_valid_number, '第一デパート (株式会社 サビアコーポレーション)');
ok($zip->set_number('1908507')->is_valid_number, '株式会社 高島屋 立川店');
ok($zip->set_number('1908508')->is_valid_number, '多摩運送 株式会社');
ok($zip->set_number('1908509')->is_valid_number, '立川公共職業安定所');
ok($zip->set_number('1908510')->is_valid_number, '株式会社 日本旅行 立川支店');
ok($zip->set_number('1908511')->is_valid_number, '株式会社 伊勢丹 立川店');
ok($zip->set_number('1908513')->is_valid_number, '日本信販 株式会社 西関東統括部');
ok($zip->set_number('1908514')->is_valid_number, '株式会社 東京スター銀行 立川支店');
ok($zip->set_number('1908515')->is_valid_number, '軽貨急配シーエス 株式会社 立川支店');
ok($zip->set_number('1908516')->is_valid_number, '立川労働基準監督署');
ok($zip->set_number('1908517')->is_valid_number, '株式会社 いなげや');
ok($zip->set_number('1908518')->is_valid_number, '国立極地研究所');
ok($zip->set_number('1908519')->is_valid_number, '宗教法人 真如苑');
ok($zip->set_number('1908520')->is_valid_number, '学校法人 国立音楽大学');
ok($zip->set_number('1908521')->is_valid_number, 'オリオン書房');
ok($zip->set_number('1908522')->is_valid_number, '超音波工業 株式会社');
ok($zip->set_number('1908528')->is_valid_number, 'オリックス・クレジット 株式会社');
ok($zip->set_number('1908530')->is_valid_number, '財団法人 公園緑地管理財団昭和管理センター');
ok($zip->set_number('1908531')->is_valid_number, '国家公務員共済組合連合会 立川病院');
ok($zip->set_number('1908535')->is_valid_number, '財団法人 東京顕微鏡院');
ok($zip->set_number('1908536')->is_valid_number, '株式会社 NTTドコモ 多摩支店');
ok($zip->set_number('1908537')->is_valid_number, 'NEC三栄 株式会社');
ok($zip->set_number('1908539')->is_valid_number, 'マイ・テレビ 株式会社');
ok($zip->set_number('1908540')->is_valid_number, '読売新聞 東京本社 立川支局');
ok($zip->set_number('1908543')->is_valid_number, '東京都立多摩社会教育会館');
ok($zip->set_number('1908544')->is_valid_number, '東京地方検察庁 立川支部');
ok($zip->set_number('1908550')->is_valid_number, 'あいおい損害保険 株式会社');
ok($zip->set_number('1908551')->is_valid_number, '国民金融公庫 立川支店');
ok($zip->set_number('1908553')->is_valid_number, 'あいおい損害保険 株式会社 東京西支店');
ok($zip->set_number('1908554')->is_valid_number, 'ジェイアール東日本商業開発 株式会社 (グランデュオ)');
ok($zip->set_number('1908555')->is_valid_number, '株式会社 田島');
ok($zip->set_number('1908557')->is_valid_number, '森永乳業 株式会社 多摩支店');
ok($zip->set_number('1908558')->is_valid_number, '国土交通省 関東地方整備局 国営昭和記念公園事務所');
ok($zip->set_number('1908560')->is_valid_number, '株式会社 日本アクセス 東京西支店');
ok($zip->set_number('1908561')->is_valid_number, '大学共同利用機関法人 人間文化研究機構 国立国語研究所');
ok($zip->set_number('1908562')->is_valid_number, '情報・システム研究機構 統計数理研究所');
ok($zip->set_number('1908565')->is_valid_number, '立川税務署');
ok($zip->set_number('1908566')->is_valid_number, '株式会社 セレモアつくば');
ok($zip->set_number('1908567')->is_valid_number, '株式会社 エスアールエル');
ok($zip->set_number('1908571')->is_valid_number, '東京地方裁判所 立川支部');
ok($zip->set_number('1908572')->is_valid_number, '立川簡易裁判所');
ok($zip->set_number('1908573')->is_valid_number, '東京都市町村 職員共済組合');
ok($zip->set_number('1908575')->is_valid_number, '関東財務局 立川出張所');
ok($zip->set_number('1908578')->is_valid_number, '医療法人社団 健生会立川相互病院');
ok($zip->set_number('1908581')->is_valid_number, '自治大学校');
ok($zip->set_number('1908582')->is_valid_number, '日本生命保険 相互会社 東京西支社');
ok($zip->set_number('1908583')->is_valid_number, '東京都立砂川高等学校');
ok($zip->set_number('1908586')->is_valid_number, '横河電機 株式会社 立川オフィス');
ok($zip->set_number('1908588')->is_valid_number, 'サンケイリビング新聞社 多摩本部');
ok($zip->set_number('1908589')->is_valid_number, '東京家庭裁判所 立川支部');
ok($zip->set_number('1908666')->is_valid_number, '立川市役所');
ok($zip->set_number('1908680')->is_valid_number, '立飛企業 株式会社');
ok($zip->set_number('1908681')->is_valid_number, '多摩信用金庫');
ok($zip->set_number('1908686')->is_valid_number, '大和証券 株式会社 立川支店');
ok($zip->set_number('1908688')->is_valid_number, '新立川航空機 株式会社');
ok($zip->set_number('1918501')->is_valid_number, 'セイコーエプソン 株式会社');
ok($zip->set_number('1918502')->is_valid_number, '富士電機 株式会社 東京工場');
ok($zip->set_number('1918503')->is_valid_number, 'GEヘルスケア・ジャパン 株式会社');
ok($zip->set_number('1918505')->is_valid_number, 'ユアサ商事 (株) 西関東営業所');
ok($zip->set_number('1918506')->is_valid_number, '明星大学');
ok($zip->set_number('1918507')->is_valid_number, '東京電力 株式会社 総合研修センター');
ok($zip->set_number('1918509')->is_valid_number, 'ファナック 株式会社');
ok($zip->set_number('1918510')->is_valid_number, '実践女子大学');
ok($zip->set_number('1918511')->is_valid_number, 'コニカミノルタ 東京サイト日野');
ok($zip->set_number('1918512')->is_valid_number, '帝人株式会社 東京研究センター');
ok($zip->set_number('1918520')->is_valid_number, '日野税務署');
ok($zip->set_number('1918555')->is_valid_number, '株式会社東芝 日野工場');
ok($zip->set_number('1918660')->is_valid_number, '日野自動車 株式会社');
ok($zip->set_number('1918686')->is_valid_number, '日野市役所');
ok($zip->set_number('1920392')->is_valid_number, '東京薬科大学');
ok($zip->set_number('1920393')->is_valid_number, '中央大学');
ok($zip->set_number('1920394')->is_valid_number, '学校法人 多摩美術大学 八王子校舎');
ok($zip->set_number('1920395')->is_valid_number, '帝京大学 八王子校舎');
ok($zip->set_number('1920396')->is_valid_number, '山野美容芸術短期大学');
ok($zip->set_number('1920397')->is_valid_number, '首都大学東京');
ok($zip->set_number('1920398')->is_valid_number, '東京都水道局 多摩ニュータウン水道事務所');
ok($zip->set_number('1920981')->is_valid_number, '学校法人 片柳学園');
ok($zip->set_number('1920982')->is_valid_number, '学校法人 片柳学園 東京工科大学');
ok($zip->set_number('1920983')->is_valid_number, '日本工学院八王子専門学校');
ok($zip->set_number('1920986')->is_valid_number, '日本文化大學');
ok($zip->set_number('1920988')->is_valid_number, '日本水産 株式会社 八王子総合工場');
ok($zip->set_number('1920989')->is_valid_number, '八王子総合卸売センター 株式会社');
ok($zip->set_number('1920992')->is_valid_number, '東京造形大学');
ok($zip->set_number('1920993')->is_valid_number, '東京電力 株式会社 多摩支店');
ok($zip->set_number('1920994')->is_valid_number, '八王子税務署');
ok($zip->set_number('1928501')->is_valid_number, '八王子市役所');
ok($zip->set_number('1928502')->is_valid_number, '東日本旅客鉄道 株式会社 八王子支社');
ok($zip->set_number('1928505')->is_valid_number, 'コニカミノルタ 東京サイト八王子');
ok($zip->set_number('1928506')->is_valid_number, '八王子社会保険事務所');
ok($zip->set_number('1928507')->is_valid_number, 'オリンパス光学工業 株式会社 技術開発センター石川');
ok($zip->set_number('1928508')->is_valid_number, '杏林大学');
ok($zip->set_number('1928510')->is_valid_number, 'アジレント・テクノロジー 株式会社');
ok($zip->set_number('1928511')->is_valid_number, '株式会社 八王子そごう');
ok($zip->set_number('1928512')->is_valid_number, 'オリンパス光学工業 株式会社 技術開発センター宇津木');
ok($zip->set_number('1928515')->is_valid_number, '株式会社 東京精密');
ok($zip->set_number('1928516')->is_valid_number, '東京地方裁判所 八王子支部');
ok($zip->set_number('1928520')->is_valid_number, '八王子商工会議所');
ok($zip->set_number('1928522')->is_valid_number, '株式会社 ニレコ');
ok($zip->set_number('1928525')->is_valid_number, '(株) ケンウッド');
ok($zip->set_number('1928532')->is_valid_number, '中央電子 株式会社');
ok($zip->set_number('1928533')->is_valid_number, '双葉産業 (株)');
ok($zip->set_number('1928535')->is_valid_number, '(株) エスアールエル 八王子ラボラトリー');
ok($zip->set_number('1928536')->is_valid_number, '読売新聞 東京本社 八王子支局');
ok($zip->set_number('1928537')->is_valid_number, '日本分光 株式会社');
ok($zip->set_number('1928538')->is_valid_number, '東京家庭裁判所 八王子支部');
ok($zip->set_number('1928551')->is_valid_number, '株式会社 村内ファニチャーアクセス');
ok($zip->set_number('1928553')->is_valid_number, '東京地方検察庁 八王子支部');
ok($zip->set_number('1928556')->is_valid_number, 'カシオ計算機 株式会社 八王子研究所');
ok($zip->set_number('1928558')->is_valid_number, '(株) 関電工 多摩支店');
ok($zip->set_number('1928562')->is_valid_number, '東京都立南多摩高等学校');
ok($zip->set_number('1928568')->is_valid_number, '東京都立八王子東高等学校');
ok($zip->set_number('1928577')->is_valid_number, '学校法人 創価大学');
ok($zip->set_number('1928585')->is_valid_number, '日本ヒューレット・パッカード 株式会社 八王子事業所');
ok($zip->set_number('1928611')->is_valid_number, '東京都八王子都税事務所');
ok($zip->set_number('1928622')->is_valid_number, '工学院大学附属中学・高等学校');
ok($zip->set_number('1928633')->is_valid_number, '木住野商事 株式会社');
ok($zip->set_number('1928644')->is_valid_number, '日本銀刺ワーム');
ok($zip->set_number('1928648')->is_valid_number, '中日本高速道路 (株) 八王子支社');
ok($zip->set_number('1928650')->is_valid_number, '商工中金 八王子支店');
ok($zip->set_number('1928651')->is_valid_number, '八王子信用金庫');
ok($zip->set_number('1928655')->is_valid_number, '大和證券 八王子支店');
ok($zip->set_number('1928702')->is_valid_number, '八王子市役所 市民部市民課');
ok($zip->set_number('1930985')->is_valid_number, '拓殖大学 (八王子キャンパス)');
ok($zip->set_number('1930991')->is_valid_number, '蛇の目ミシン工業 株式会社');
ok($zip->set_number('1930997')->is_valid_number, '東京工業高等専門学校');
ok($zip->set_number('1930998')->is_valid_number, '東京医科大八王子医療センター');
ok($zip->set_number('1938501')->is_valid_number, '共立女子大学');
ok($zip->set_number('1938505')->is_valid_number, '医療法人財団 青渓会 駒木野病院');
ok($zip->set_number('1938510')->is_valid_number, '(株) 育良精機製作所 八王子事業所');
ok($zip->set_number('1938511')->is_valid_number, '高尾登山電鉄 株式会社');
ok($zip->set_number('1938520')->is_valid_number, '八王子保健生活協同組合');
ok($zip->set_number('1938525')->is_valid_number, 'HOYA (株) 八王子工場');
ok($zip->set_number('1938533')->is_valid_number, '株式会社 スリーボンド');
ok($zip->set_number('1938550')->is_valid_number, 'OKIセミコンダクタ 株式会社');
ok($zip->set_number('1938570')->is_valid_number, '林野庁 森林技術総合研修所');
ok($zip->set_number('1938666')->is_valid_number, '共立女子第二中学・高等学校');
ok($zip->set_number('1938686')->is_valid_number, '宗教法人 薬王院');
ok($zip->set_number('1940292')->is_valid_number, '東京家政学院大学');
ok($zip->set_number('1940293')->is_valid_number, '中央協同組合学園');
ok($zip->set_number('1940294')->is_valid_number, '桜美林学園');
ok($zip->set_number('1940295')->is_valid_number, '株式会社 オーク製作所');
ok($zip->set_number('1940296')->is_valid_number, '東京航空計器 株式会社');
ok($zip->set_number('1940297')->is_valid_number, '医療法人社団 幸隆会多摩丘陵病院');
ok($zip->set_number('1940298')->is_valid_number, '法政大学');
ok($zip->set_number('1948502')->is_valid_number, '大学案内メールセンター 株式会社');
ok($zip->set_number('1948503')->is_valid_number, '株式会社 エルハート 横浜店');
ok($zip->set_number('1948505')->is_valid_number, '株式会社 東急ハンズ 町田店');
ok($zip->set_number('1948507')->is_valid_number, '株式会社 家具の大正堂');
ok($zip->set_number('1948508')->is_valid_number, '株式会社 高速道路総合技術研究所');
ok($zip->set_number('1948510')->is_valid_number, '株式会社 PFU');
ok($zip->set_number('1948511')->is_valid_number, '三菱化学生命科学研究所');
ok($zip->set_number('1948515')->is_valid_number, '株式会社 サマディ');
ok($zip->set_number('1948520')->is_valid_number, '町田市役所');
ok($zip->set_number('1948527')->is_valid_number, '(株) 東京新聞ショッパー社 町田相模原支社');
ok($zip->set_number('1948530')->is_valid_number, '株式会社 三和');
ok($zip->set_number('1948533')->is_valid_number, '協和発酵工業 株式会社 東京研究所');
ok($zip->set_number('1948538')->is_valid_number, '株式会社 長崎屋 町田店');
ok($zip->set_number('1948540')->is_valid_number, '東京都 町田都税事務所');
ok($zip->set_number('1948543')->is_valid_number, '学校法人 昭和薬科大学');
ok($zip->set_number('1948550')->is_valid_number, '小田急百貨店 町田店');
ok($zip->set_number('1948551')->is_valid_number, 'サンケイリビング新聞社 まちだ・さがみ本部');
ok($zip->set_number('1948555')->is_valid_number, '株式会社 ケーユー');
ok($zip->set_number('1948558')->is_valid_number, '株式会社 東京三菱銀行 町田支店');
ok($zip->set_number('1948560')->is_valid_number, '電気化学工業 株式会社 総合研究所');
ok($zip->set_number('1948566')->is_valid_number, '株式会社 オーディオテクニカ 成瀬事業所');
ok($zip->set_number('1948567')->is_valid_number, '町田税務署');
ok($zip->set_number('1948577')->is_valid_number, 'ホーチキ 株式会社 町田事業所');
ok($zip->set_number('1948580')->is_valid_number, '町田市役所市民課');
ok($zip->set_number('1948585')->is_valid_number, 'オリックス・レンテック 株式会社');
ok($zip->set_number('1948586')->is_valid_number, '町田郵便貯金地域文化活動支援施設');
ok($zip->set_number('1948588')->is_valid_number, '協栄電気 株式会社');
ok($zip->set_number('1948610')->is_valid_number, '学校法人 玉川学園');
ok($zip->set_number('1948611')->is_valid_number, '玉川大学 通信教育部');
ok($zip->set_number('1948612')->is_valid_number, '玉川大学・玉川学園女子短期大学 入試部');
ok($zip->set_number('1948666')->is_valid_number, '株式会社 オーディオテクニカ');
ok($zip->set_number('1958550')->is_valid_number, '国士舘大学');
ok($zip->set_number('1958555')->is_valid_number, '学校法人 和光学園');
ok($zip->set_number('1958585')->is_valid_number, '和光大学');
ok($zip->set_number('1968501')->is_valid_number, 'スタック電子 株式会社');
ok($zip->set_number('1968510')->is_valid_number, 'HOYA 株式会社 昭島工場');
ok($zip->set_number('1968511')->is_valid_number, '昭島市役所');
ok($zip->set_number('1968522')->is_valid_number, '昭和飛行機工業 株式会社');
ok($zip->set_number('1968550')->is_valid_number, 'フォスター電機 株式会社');
ok($zip->set_number('1968555')->is_valid_number, '日本航空電子工業 株式会社');
ok($zip->set_number('1968558')->is_valid_number, '日本電子 株式会社');
ok($zip->set_number('1968585')->is_valid_number, '三井造船マシナリー・サービス 株式会社');
ok($zip->set_number('1968588')->is_valid_number, '協立包装材 (株)');
ok($zip->set_number('1968601')->is_valid_number, 'アーバンリゾーツ昭和の森 株式会社');
ok($zip->set_number('1968611')->is_valid_number, '株式会社 タチエス');
ok($zip->set_number('1968666')->is_valid_number, '株式会社 リガク');
ok($zip->set_number('1968668')->is_valid_number, '日本ゼネラルモーターズ 株式会社/デルファイ・オートモーティブ・システムズ');
ok($zip->set_number('1968686')->is_valid_number, '株式会社 IHI');
ok($zip->set_number('1978501')->is_valid_number, '福生市役所');
ok($zip->set_number('1978511')->is_valid_number, '福生病院組合');
ok($zip->set_number('1978555')->is_valid_number, '武陽ガス 株式会社');
ok($zip->set_number('1978601')->is_valid_number, '株式会社 大多摩ハム 小林商会');
ok($zip->set_number('1978623')->is_valid_number, '石川酒造 株式会社');
ok($zip->set_number('1988510')->is_valid_number, '株式会社 東邦製作所');
ok($zip->set_number('1988512')->is_valid_number, '株式会社 日立製作所 マイクロデバイス事業部');
ok($zip->set_number('1988522')->is_valid_number, 'ホットマン 株式会社');
ok($zip->set_number('1988525')->is_valid_number, '日本年金機構 青梅年金事務所');
ok($zip->set_number('1988531')->is_valid_number, '社会福祉法人 聖明福祉協会');
ok($zip->set_number('1988532')->is_valid_number, '株式会社 ルネサス 東日本セミコンダクタ');
ok($zip->set_number('1988555')->is_valid_number, 'カシオ計算機 株式会社 青梅事業所、カシオマイクロニクス株式会社');
ok($zip->set_number('1988577')->is_valid_number, 'アロカ 株式会社 東京事業所');
ok($zip->set_number('1988585')->is_valid_number, '青梅商工会議所');
ok($zip->set_number('1988588')->is_valid_number, '株式会社 オザム');
ok($zip->set_number('1988601')->is_valid_number, '住友金属鉱山 株式会社 電子事業本部');
ok($zip->set_number('1988611')->is_valid_number, '日立ライティング 株式会社 青梅事業所');
ok($zip->set_number('1988666')->is_valid_number, 'アジアエレクトロニクス 株式会社');
ok($zip->set_number('1988701')->is_valid_number, '青梅市役所');
ok($zip->set_number('1988710')->is_valid_number, '株式会社 東芝 青梅事業所');
ok($zip->set_number('1988711')->is_valid_number, '株式会社 共立');
ok($zip->set_number('1988722')->is_valid_number, '青梅信用金庫');
ok($zip->set_number('1988760')->is_valid_number, '(株) やまびこ');
ok($zip->set_number('2018501')->is_valid_number, '東京都立狛江高等学校');
ok($zip->set_number('2018511')->is_valid_number, '財団法人 電力中央研究所');
ok($zip->set_number('2018585')->is_valid_number, '狛江市役所');
ok($zip->set_number('2018588')->is_valid_number, '第一電材 株式会社');
ok($zip->set_number('2018601')->is_valid_number, '東京慈恵会医科大学附属第三病院');
ok($zip->set_number('2018648')->is_valid_number, '京セラキンセキ 株式会社');
ok($zip->set_number('2018686')->is_valid_number, '学校法人 狛江こだま学園');
ok($zip->set_number('2028520')->is_valid_number, '株式会社 パルコ ひばりが丘店');
ok($zip->set_number('2028555')->is_valid_number, '西東京市役所 保谷庁舎');
ok($zip->set_number('2028558')->is_valid_number, '株式会社 損害保険ジャパン');
ok($zip->set_number('2028585')->is_valid_number, '学校法人 武蔵野女子学院 (武蔵野大学)');
ok($zip->set_number('2038511')->is_valid_number, 'グローブライド 株式会社');
ok($zip->set_number('2038521')->is_valid_number, '自由学園(初等部・男子部中等科・女子部中等科・高等科・最高学部)');
ok($zip->set_number('2038555')->is_valid_number, '東久留米市役所');
ok($zip->set_number('2038585')->is_valid_number, '山崎製パン 株式会社 武蔵野工場');
ok($zip->set_number('2038588')->is_valid_number, '日本興亜損害保険 (株)');
ok($zip->set_number('2038601')->is_valid_number, '株式会社 インテージ');
ok($zip->set_number('2038739')->is_valid_number, '株式会社 インテージリサーチ IFIセンター');
ok($zip->set_number('2048511')->is_valid_number, '清瀬市役所');
ok($zip->set_number('2048522')->is_valid_number, '財団法人 結核予防会 複十字病院');
ok($zip->set_number('2048533')->is_valid_number, '財団法人 結核予防会 結核研究所');
ok($zip->set_number('2048555')->is_valid_number, '日本社会事業大学');
ok($zip->set_number('2048558')->is_valid_number, '株式会社 大林組 技術研究所');
ok($zip->set_number('2048567')->is_valid_number, '東京都立 清瀬小児病院');
ok($zip->set_number('2048585')->is_valid_number, '独立行政法人 国立病院機構 東京病院');
ok($zip->set_number('2048588')->is_valid_number, '明治薬科大学');
ok($zip->set_number('2048589')->is_valid_number, '明治薬科大学 図書館');
ok($zip->set_number('2058501')->is_valid_number, 'あすか製薬 株式会社');
ok($zip->set_number('2058503')->is_valid_number, '富士フレーバー 株式会社');
ok($zip->set_number('2058511')->is_valid_number, '日本フィルター工業 株式会社');
ok($zip->set_number('2058555')->is_valid_number, 'カシオ計算機 株式会社 羽村技術センター');
ok($zip->set_number('2058601')->is_valid_number, '羽村市役所');
ok($zip->set_number('2058603')->is_valid_number, 'コニカミノルタパッケージング 株式会社');
ok($zip->set_number('2058604')->is_valid_number, '三和テスメックス 株式会社');
ok($zip->set_number('2058606')->is_valid_number, '株式会社 日立国際電気 羽村工場');
ok($zip->set_number('2058607')->is_valid_number, '株式会社 カイジョー');
ok($zip->set_number('2058660')->is_valid_number, '日野自動車工業 株式会社 羽村工場');
ok($zip->set_number('2058666')->is_valid_number, '株式会社 ダイエー羽村プロセスセンター');
ok($zip->set_number('2068502')->is_valid_number, '京王電鉄 株式会社');
ok($zip->set_number('2068503')->is_valid_number, '富士通 株式会社');
ok($zip->set_number('2068505')->is_valid_number, '生活協同組合 東京マイコープ');
ok($zip->set_number('2068511')->is_valid_number, '学校法人 駒澤学園');
ok($zip->set_number('2068512')->is_valid_number, '日本医科大学付属多摩永山病院');
ok($zip->set_number('2068515')->is_valid_number, '国士舘大学 体育学部');
ok($zip->set_number('2068520')->is_valid_number, '大和證券 株式会社 多摩支店');
ok($zip->set_number('2068522')->is_valid_number, '株式会社 京王ストア');
ok($zip->set_number('2068525')->is_valid_number, 'ミタニマイクロニクス 株式会社');
ok($zip->set_number('2068530')->is_valid_number, 'ティアック 株式会社');
ok($zip->set_number('2068540')->is_valid_number, '大妻学院 多摩校');
ok($zip->set_number('2068543')->is_valid_number, '三越 多摩センター店');
ok($zip->set_number('2068550')->is_valid_number, 'パシフィックコンサルタンツ 株式会社');
ok($zip->set_number('2068555')->is_valid_number, '富士通フロンテック 株式会社');
ok($zip->set_number('2068566')->is_valid_number, '株式会社 よみうりランド');
ok($zip->set_number('2068567')->is_valid_number, 'ミツミ電機 株式会社');
ok($zip->set_number('2068577')->is_valid_number, '日本フイルコン 株式会社 東京事務所');
ok($zip->set_number('2068585')->is_valid_number, 'トヨタ西東京カローラ 株式会社');
ok($zip->set_number('2068586')->is_valid_number, '恵泉女学園大学');
ok($zip->set_number('2068588')->is_valid_number, '株式会社 サンリオエンターテイメント');
ok($zip->set_number('2068601')->is_valid_number, '稲城市役所');
ok($zip->set_number('2068602')->is_valid_number, '株式会社 新学社 東京支社');
ok($zip->set_number('2068611')->is_valid_number, '朝日生命保険 相互会社 多摩本社');
ok($zip->set_number('2068666')->is_valid_number, '多摩市役所');
ok($zip->set_number('2068686')->is_valid_number, '株式会社 ベネッセコーポレーション');
ok($zip->set_number('2078501')->is_valid_number, '株式会社 カシオ日立モバイルコミュニケーションズ');
ok($zip->set_number('2078515')->is_valid_number, '独立行政法人 中小企業基盤整備機構 関東支部 中小企業大学校 東京校');
ok($zip->set_number('2078585')->is_valid_number, '東大和市役所');
ok($zip->set_number('2088501')->is_valid_number, '武蔵村山市役所');
ok($zip->set_number('2088502')->is_valid_number, '武蔵村山市民総合センター');
ok($zip->set_number('2088503')->is_valid_number, '武蔵村山市社会福祉協議会');
ok($zip->set_number('2088550')->is_valid_number, '株式会社 日本犬舎');
ok($zip->set_number('2088555')->is_valid_number, '株式会社 コトブキ 村山工場');
ok($zip->set_number('2088585')->is_valid_number, '株式会社 新川');
ok($zip->set_number('2108501')->is_valid_number, 'コマツエンジニアリング 株式会社');
ok($zip->set_number('2108502')->is_valid_number, '大和証券 株式会社 川崎支店');
ok($zip->set_number('2108504')->is_valid_number, '株式会社 岡田屋モアーズ');
ok($zip->set_number('2108506')->is_valid_number, 'トラスコ中山 株式会社 プラネット東京');
ok($zip->set_number('2108511')->is_valid_number, '川崎市 かわさき市税事務所 法人課税課');
ok($zip->set_number('2108512')->is_valid_number, 'プレス工業 株式会社');
ok($zip->set_number('2108515')->is_valid_number, '株式会社 オー・シー・エス');
ok($zip->set_number('2108521')->is_valid_number, '川崎大師 平間寺');
ok($zip->set_number('2108522')->is_valid_number, 'コロムビアデジタルメディア 株式会社');
ok($zip->set_number('2108523')->is_valid_number, '東燃ゼネラル石油 (株) 川崎工場');
ok($zip->set_number('2108531')->is_valid_number, '川崎南税務署');
ok($zip->set_number('2108532')->is_valid_number, '新日本石油株式会社 川崎事業所');
ok($zip->set_number('2108537')->is_valid_number, '横浜家庭裁判所 川崎支部');
ok($zip->set_number('2108540')->is_valid_number, '東芝情報システム 株式会社');
ok($zip->set_number('2108541')->is_valid_number, '東芝自動機器システムサービス 株式会社');
ok($zip->set_number('2108544')->is_valid_number, '川崎合同法律事務所');
ok($zip->set_number('2108545')->is_valid_number, 'JX日鉱日石エネルギー (株) 川崎製造所');
ok($zip->set_number('2108547')->is_valid_number, '日本ポリエチレン (株) 川崎工場');
ok($zip->set_number('2108548')->is_valid_number, '日本ポリエチレン(株) 研究開発センター');
ok($zip->set_number('2108550')->is_valid_number, '日本アイ・ビー・エム 株式会社');
ok($zip->set_number('2108552')->is_valid_number, '住友生命保険 相互会社 川崎支社');
ok($zip->set_number('2108557')->is_valid_number, '東京新聞TODAY');
ok($zip->set_number('2108558')->is_valid_number, '株式会社 YAKIN川崎');
ok($zip->set_number('2108559')->is_valid_number, '横浜地方裁判所 川崎支部');
ok($zip->set_number('2108560')->is_valid_number, '三菱化工機 株式会社');
ok($zip->set_number('2108562')->is_valid_number, '神奈川県 川崎県税事務所');
ok($zip->set_number('2108565')->is_valid_number, '川崎市消防局');
ok($zip->set_number('2108569')->is_valid_number, '株式会社 ディーアンドエムホールディングス');
ok($zip->set_number('2108570')->is_valid_number, '川崎区役所');
ok($zip->set_number('2108571')->is_valid_number, '富士通ネットワークソリューションズ (株)');
ok($zip->set_number('2108576')->is_valid_number, '川崎市 かわさき市税事務所');
ok($zip->set_number('2108577')->is_valid_number, '川崎市役所');
ok($zip->set_number('2108583')->is_valid_number, '株式会社 東芝 セミコンダクター社 マイクロエレクトロニクスセンター');
ok($zip->set_number('2108586')->is_valid_number, '株式会社 さいか屋');
ok($zip->set_number('2108601')->is_valid_number, '株式会社 S&Sエンジニアリング');
ok($zip->set_number('2108604')->is_valid_number, '野村證券 株式会社 川崎支店');
ok($zip->set_number('2108666')->is_valid_number, '川崎ダイスビル');
ok($zip->set_number('2108680')->is_valid_number, '味の素 (株) 川崎工場');
ok($zip->set_number('2108681')->is_valid_number, '味の素(株) 中央研究所');
ok($zip->set_number('2108686')->is_valid_number, '商工組合中央金庫 川崎支店');
ok($zip->set_number('2109507')->is_valid_number, '日本ゼオン 株式会社 川崎工場');
ok($zip->set_number('2109511')->is_valid_number, 'アライオートオークションベイサイド');
ok($zip->set_number('2109526')->is_valid_number, '東燃ゼネラル石油 (株) 150号地');
ok($zip->set_number('2109530')->is_valid_number, '富士電機 株式会社 川崎工場');
ok($zip->set_number('2109533')->is_valid_number, '池上通信機 (株) 塩浜事業所');
ok($zip->set_number('2109555')->is_valid_number, '山本商会 株式会社');
ok($zip->set_number('2109567')->is_valid_number, '日本鋳造 株式会社');
ok($zip->set_number('2109582')->is_valid_number, '味の素(株) 西工場');
ok($zip->set_number('2109588')->is_valid_number, 'アスクル (株) 横浜センター');
ok($zip->set_number('2109650')->is_valid_number, '日立造船 株式会社 神奈川工場');
ok($zip->set_number('2118501')->is_valid_number, 'キヤノン 株式会社 小杉事業所');
ok($zip->set_number('2118502')->is_valid_number, '東横化学 株式会社');
ok($zip->set_number('2118505')->is_valid_number, '株式会社 ドメス');
ok($zip->set_number('2118510')->is_valid_number, '関東労災病院');
ok($zip->set_number('2118511')->is_valid_number, '第一メール 株式会社');
ok($zip->set_number('2118520')->is_valid_number, '富士通 FIP');
ok($zip->set_number('2118530')->is_valid_number, '帝国通信工業 株式会社');
ok($zip->set_number('2118540')->is_valid_number, '富士通エフ・アイ・ピー 株式会社');
ok($zip->set_number('2118550')->is_valid_number, '株式会社 東計電算');
ok($zip->set_number('2118555')->is_valid_number, '株式会社 テクノ');
ok($zip->set_number('2118558')->is_valid_number, '株式会社 ロジタック');
ok($zip->set_number('2118566')->is_valid_number, '川崎市民放送 株式会社');
ok($zip->set_number('2118570')->is_valid_number, '中原区役所');
ok($zip->set_number('2118577')->is_valid_number, '三木プーリ 株式会社');
ok($zip->set_number('2118585')->is_valid_number, '沖電線 株式会社');
ok($zip->set_number('2118588')->is_valid_number, '富士通 株式会社 川崎工場');
ok($zip->set_number('2118611')->is_valid_number, 'パイオニアプラズマディスプレイ 株式会社');
ok($zip->set_number('2118666')->is_valid_number, '日本電気 株式会社 玉川事業場');
ok($zip->set_number('2118668')->is_valid_number, 'ルネサスエレクトロニクス 株式会社');
ok($zip->set_number('2128501')->is_valid_number, '株式会社 東芝 柳町事業所');
ok($zip->set_number('2128502')->is_valid_number, 'タタ・エレクシー・リミテッド');
ok($zip->set_number('2128503')->is_valid_number, '株式会社 タンガロイ');
ok($zip->set_number('2128508')->is_valid_number, '田中製菓 株式会社');
ok($zip->set_number('2128509')->is_valid_number, '大陽日酸 株式会社 関東支社');
ok($zip->set_number('2128511')->is_valid_number, 'キグナス石油販売 株式会社');
ok($zip->set_number('2128513')->is_valid_number, '東洋通信機 (株)');
ok($zip->set_number('2128520')->is_valid_number, '株式会社 東芝 マイクロエレクトロニクスセンター 半導体システム技術センター分室');
ok($zip->set_number('2128525')->is_valid_number, '株式会社 東邦事業');
ok($zip->set_number('2128525')->is_valid_number, '株式会社 横浜シャーウッド');
ok($zip->set_number('2128525')->is_valid_number, '和幸商事 株式会社');
ok($zip->set_number('2128525')->is_valid_number, '和幸フーズ 株式会社');
ok($zip->set_number('2128530')->is_valid_number, 'キヤノン 株式会社 矢向事業所');
ok($zip->set_number('2128531')->is_valid_number, '川崎南税務署');
ok($zip->set_number('2128536')->is_valid_number, '第一生命保険 相互会社');
ok($zip->set_number('2128544')->is_valid_number, '東洋無線システム 株式会社');
ok($zip->set_number('2128551')->is_valid_number, '東芝プラントシステム 株式会社');
ok($zip->set_number('2128554')->is_valid_number, 'ミューザ川崎 管理組合');
ok($zip->set_number('2128555')->is_valid_number, '株式会社 エヌ・ケー・エクサ');
ok($zip->set_number('2128557')->is_valid_number, '財団法人 川崎市文化財団');
ok($zip->set_number('2128560')->is_valid_number, '黒田精工 株式会社');
ok($zip->set_number('2128563')->is_valid_number, '株式会社 PFU');
ok($zip->set_number('2128564')->is_valid_number, '株式会社 中央コンピュータシステム');
ok($zip->set_number('2128566')->is_valid_number, '日本トイザらス (株)');
ok($zip->set_number('2128567')->is_valid_number, '株式会社 日立製作所 情報システム事業部');
ok($zip->set_number('2128570')->is_valid_number, '川崎市幸区役所');
ok($zip->set_number('2128572')->is_valid_number, '株式会社 東芝 川崎事業所');
ok($zip->set_number('2128576')->is_valid_number, 'ラゾーナ川崎プラザ');
ok($zip->set_number('2128581')->is_valid_number, '株式会社 東芝 小向工場');
ok($zip->set_number('2128582')->is_valid_number, '株式会社 東芝 研究開発センター');
ok($zip->set_number('2128583')->is_valid_number, '株式会社 東芝 セミコンダクター社 マイクロエレクトロセンター');
ok($zip->set_number('2128584')->is_valid_number, '株式会社 ビックカメラ');
ok($zip->set_number('2128588')->is_valid_number, '保土谷化学工業 株式会社');
ok($zip->set_number('2128589')->is_valid_number, 'デルコンピュータ 株式会社');
ok($zip->set_number('2128590')->is_valid_number, '東洋無線システム 株式会社');
ok($zip->set_number('2128602')->is_valid_number, 'キヤノン 株式会社 川崎事業所');
ok($zip->set_number('2138502')->is_valid_number, '株式会社 富士通ゼネラル');
ok($zip->set_number('2138503')->is_valid_number, '川崎北税務署');
ok($zip->set_number('2138505')->is_valid_number, 'クノール食品 株式会社');
ok($zip->set_number('2138507')->is_valid_number, '帝京大学 医学部附属 溝口病院');
ok($zip->set_number('2138511')->is_valid_number, 'NECインフロンティア 株式会社');
ok($zip->set_number('2138512')->is_valid_number, 'キヤノン 株式会社');
ok($zip->set_number('2138515')->is_valid_number, '神奈川県高津県税事務所');
ok($zip->set_number('2138520')->is_valid_number, '株式会社 ナガイ');
ok($zip->set_number('2138521')->is_valid_number, '株式会社 日立情報システムズ');
ok($zip->set_number('2138522')->is_valid_number, 'あすか製薬 株式会社 川崎事業所');
ok($zip->set_number('2138523')->is_valid_number, 'トップツアー 株式会社 個人旅行事業部(WEB販売センター・提携販売センター)');
ok($zip->set_number('2138525')->is_valid_number, '株式会社 文教堂');
ok($zip->set_number('2138533')->is_valid_number, '株式会社 ミツトヨ');
ok($zip->set_number('2138535')->is_valid_number, 'タイコ エレクトロニクスアンプ 株式会社');
ok($zip->set_number('2138550')->is_valid_number, '川崎電線 株式会社');
ok($zip->set_number('2138551')->is_valid_number, '昭和薬品 株式会社');
ok($zip->set_number('2138553')->is_valid_number, '日本開閉器工業 株式会社');
ok($zip->set_number('2138558')->is_valid_number, '株式会社 高砂製作所');
ok($zip->set_number('2138559')->is_valid_number, '株式会社 サンジェルマン');
ok($zip->set_number('2138566')->is_valid_number, '株式会社 磐城無線研究所');
ok($zip->set_number('2138570')->is_valid_number, '高津区役所');
ok($zip->set_number('2138573')->is_valid_number, '川崎北 公共職業安定所');
ok($zip->set_number('2138576')->is_valid_number, '川崎市 みぞのくち市税事務所');
ok($zip->set_number('2138577')->is_valid_number, '関東地方整備局 川崎国道事務所');
ok($zip->set_number('2138580')->is_valid_number, '学校法人 洗足学園');
ok($zip->set_number('2138581')->is_valid_number, '株式会社 ユーハイム');
ok($zip->set_number('2138585')->is_valid_number, '株式会社 アイネス');
ok($zip->set_number('2138586')->is_valid_number, '富士通アクセス 株式会社');
ok($zip->set_number('2138587')->is_valid_number, '虎の門病院 分院');
ok($zip->set_number('2138588')->is_valid_number, '株式会社 常光');
ok($zip->set_number('2138589')->is_valid_number, '宗教法人 大明王院');
ok($zip->set_number('2148525')->is_valid_number, '川崎市立 多摩病院');
ok($zip->set_number('2148533')->is_valid_number, 'タイコエレクトロニクスジャパン 合同会社');
ok($zip->set_number('2148565')->is_valid_number, '学校法人 日本女子大学');
ok($zip->set_number('2148570')->is_valid_number, '多摩区役所');
ok($zip->set_number('2148571')->is_valid_number, '明治大学 生田校舎');
ok($zip->set_number('2148580')->is_valid_number, '学校法人 専修大学');
ok($zip->set_number('2148585')->is_valid_number, '独立行政法人 産業医学 総合研究所');
ok($zip->set_number('2148588')->is_valid_number, '株式会社 電元社製作所');
ok($zip->set_number('2158509')->is_valid_number, '株式会社 ジェイコムせたまち');
ok($zip->set_number('2158510')->is_valid_number, '株式会社 光和電機');
ok($zip->set_number('2158511')->is_valid_number, '株式会社 マイタウンにじゅういち');
ok($zip->set_number('2158515')->is_valid_number, '(株) NTTソルコ新百合ヶ丘センター');
ok($zip->set_number('2158520')->is_valid_number, '聖マリアンナ医科大学附属研究所ブレスト&イメージング先端医療センター附属クリニック');
ok($zip->set_number('2158521')->is_valid_number, '神津精機 株式会社');
ok($zip->set_number('2158527')->is_valid_number, '神奈川県麻生県税事務所');
ok($zip->set_number('2158530')->is_valid_number, '株式会社 シグマ');
ok($zip->set_number('2158542')->is_valid_number, '調布学園女子短期大学');
ok($zip->set_number('2158550')->is_valid_number, 'キヤノンアネルバ 株式会社');
ok($zip->set_number('2158558')->is_valid_number, '昭和音楽大学');
ok($zip->set_number('2158560')->is_valid_number, '(株) NTTソルコ新百合ヶ丘センター');
ok($zip->set_number('2158570')->is_valid_number, '麻生区役所');
ok($zip->set_number('2158576')->is_valid_number, '川崎市 しんゆり市税事務所');
ok($zip->set_number('2158585')->is_valid_number, '川崎西税務署');
ok($zip->set_number('2158588')->is_valid_number, '株式会社 ソフィアシステムズ マイコンシティ事業所');
ok($zip->set_number('2168501')->is_valid_number, '財団法人 労働科学研究所');
ok($zip->set_number('2168502')->is_valid_number, 'セキシステムサプライ 株式会社');
ok($zip->set_number('2168505')->is_valid_number, '株式会社 山善');
ok($zip->set_number('2168510')->is_valid_number, '日本道路公団 東京第一管理局');
ok($zip->set_number('2168511')->is_valid_number, '聖マリアンナ医科大学');
ok($zip->set_number('2168512')->is_valid_number, '聖マリアンナ難病センター');
ok($zip->set_number('2168514')->is_valid_number, '聖マリアンナ看護専門学校');
ok($zip->set_number('2168519')->is_valid_number, '株式会社 東急百貨店 通信販売事業部');
ok($zip->set_number('2168522')->is_valid_number, '川崎市中央卸売市場 北部市場');
ok($zip->set_number('2168556')->is_valid_number, '株式会社 シーボンパビリオン');
ok($zip->set_number('2168566')->is_valid_number, '株式会社 西川商事');
ok($zip->set_number('2168570')->is_valid_number, '宮前区役所');
ok($zip->set_number('2208080')->is_valid_number, '(株) ワウワウ・コミュニケーションズ');
ok($zip->set_number('2208501')->is_valid_number, '横浜ベイシェラトンホテル&タワーズ');
ok($zip->set_number('2208502')->is_valid_number, '国際連合大学高等研究所');
ok($zip->set_number('2208510')->is_valid_number, '株式会社 そごう 横浜店');
ok($zip->set_number('2208511')->is_valid_number, 'NTTデータ通信 株式会社');
ok($zip->set_number('2208515')->is_valid_number, '株式会社 山縣印刷所');
ok($zip->set_number('2208520')->is_valid_number, '東京電力 株式会社 横浜支社');
ok($zip->set_number('2208521')->is_valid_number, '財団法人 神奈川県警友会 けいゆう病院');
ok($zip->set_number('2208522')->is_valid_number, 'ヨコハマグランドインターコンチネンタルホテル');
ok($zip->set_number('2208523')->is_valid_number, '神奈川 日産自動車 株式会社');
ok($zip->set_number('2208536')->is_valid_number, '株式会社 エヌ・ティ・ティ・ドコモ 神奈川支店');
ok($zip->set_number('2208539')->is_valid_number, '株式会社 横浜ステーションビル');
ok($zip->set_number('2208540')->is_valid_number, '(株) 関電工 神奈川支店');
ok($zip->set_number('2208541')->is_valid_number, '株式会社 システム情報センター');
ok($zip->set_number('2208542')->is_valid_number, '株式会社 クイーンズイースト');
ok($zip->set_number('2208558')->is_valid_number, '神奈川県 信用保証協会');
ok($zip->set_number('2208565')->is_valid_number, '東京海上日動火災保険 株式会社');
ok($zip->set_number('2208566')->is_valid_number, '財団法人 神奈川県高等学校教育会館');
ok($zip->set_number('2208577')->is_valid_number, '株式会社 マイカル 横浜ビブレ');
ok($zip->set_number('2208580')->is_valid_number, '東電同窓電気 株式会社');
ok($zip->set_number('2208585')->is_valid_number, '神奈川県立 図書館');
ok($zip->set_number('2208588')->is_valid_number, '株式会社 神奈川新聞社');
ok($zip->set_number('2208601')->is_valid_number, '株式会社 高島屋 横浜店');
ok($zip->set_number('2208604')->is_valid_number, '野村證券 (株)');
ok($zip->set_number('2208609')->is_valid_number, '商工中金 横浜西口支店');
ok($zip->set_number('2208611')->is_valid_number, '株式会社 横浜銀行');
ok($zip->set_number('2208612')->is_valid_number, '株式会社 横浜銀行 本店営業部');
ok($zip->set_number('2208613')->is_valid_number, '浜銀ファイナンス');
ok($zip->set_number('2208614')->is_valid_number, '横浜信用保証 株式会社');
ok($zip->set_number('2208615')->is_valid_number, '横浜銀行バンクカード');
ok($zip->set_number('2208616')->is_valid_number, '株式会社 浜銀総合研究所');
ok($zip->set_number('2208620')->is_valid_number, '大和ハウス工業 株式会社 横浜支社');
ok($zip->set_number('2208622')->is_valid_number, '株式会社 三越 横浜店');
ok($zip->set_number('2208660')->is_valid_number, 'みずほ信託銀行 株式会社 横浜支店');
ok($zip->set_number('2208668')->is_valid_number, '富士ゼロックス 株式会社 横浜みなとみらい事業所');
ok($zip->set_number('2208674')->is_valid_number, 'AIGエジソン生命保険 株式会社');
ok($zip->set_number('2208678')->is_valid_number, '富士ゼロックスアドバンストテクノロジー 株式会社 横浜みなとみらい事業所');
ok($zip->set_number('2208680')->is_valid_number, '株式会社 シンクロン');
ok($zip->set_number('2208686')->is_valid_number, '日産自動車 株式会社');
ok($zip->set_number('2218511')->is_valid_number, '楠原輸送 株式会社');
ok($zip->set_number('2218517')->is_valid_number, '昭和電工 株式会社 横浜事業所');
ok($zip->set_number('2218520')->is_valid_number, '株式会社 インテック');
ok($zip->set_number('2218522')->is_valid_number, '株式会社 インテックコスモセンター');
ok($zip->set_number('2218523')->is_valid_number, '横浜マリノス 株式会社');
ok($zip->set_number('2218528')->is_valid_number, '日本ビクター 株式会社 本社工場');
ok($zip->set_number('2218537')->is_valid_number, '千代田火災海上保険 株式会社 神奈川自動車支店');
ok($zip->set_number('2218540')->is_valid_number, 'コマツ物流 株式会社');
ok($zip->set_number('2218550')->is_valid_number, '三菱鉛筆 株式会社 横浜事業所');
ok($zip->set_number('2218555')->is_valid_number, '株式会社 ジューテック');
ok($zip->set_number('2218558')->is_valid_number, 'キリンエンジニアリング 株式会社');
ok($zip->set_number('2218560')->is_valid_number, '日立キャピタル 株式会社 神奈川支店');
ok($zip->set_number('2218588')->is_valid_number, '株式会社 カナセキユニオン');
ok($zip->set_number('2218611')->is_valid_number, 'ミツワ電機 株式会社 横浜支店');
ok($zip->set_number('2218623')->is_valid_number, '日産自動車');
ok($zip->set_number('2218666')->is_valid_number, '株式会社 スルガコーポレーション');
ok($zip->set_number('2218686')->is_valid_number, '神奈川大学');
ok($zip->set_number('2218688')->is_valid_number, '株式会社 リコー 横浜研修所');
ok($zip->set_number('2218701')->is_valid_number, '松下電工 株式会社 横浜ショウルーム');
ok($zip->set_number('2218702')->is_valid_number, '日本発条 株式会社 横浜分室');
ok($zip->set_number('2218703')->is_valid_number, '株式会社 ハリマビステム');
ok($zip->set_number('2218705')->is_valid_number, '株式会社 ベリテ');
ok($zip->set_number('2218712')->is_valid_number, '東邦電気 株式会社');
ok($zip->set_number('2218741')->is_valid_number, '株式会社 創健社');
ok($zip->set_number('2218765')->is_valid_number, '明和管理 株式会社');
ok($zip->set_number('2228501')->is_valid_number, '全労済 神奈川県本部');
ok($zip->set_number('2228505')->is_valid_number, '株式会社 図研');
ok($zip->set_number('2228507')->is_valid_number, '株式会社 小野測器');
ok($zip->set_number('2228508')->is_valid_number, '富士通エレクトロニクス 株式会社');
ok($zip->set_number('2228509')->is_valid_number, '中日本高速道路 (株) 横浜支社');
ok($zip->set_number('2228511')->is_valid_number, '株式会社 日能研');
ok($zip->set_number('2228515')->is_valid_number, '中央労働金庫 業務集中センター');
ok($zip->set_number('2228520')->is_valid_number, 'NECモバイリング 株式会社');
ok($zip->set_number('2228523')->is_valid_number, '株式会社 エヌ・ティ・エス');
ok($zip->set_number('2228525')->is_valid_number, '株式会社 チップワンストップ');
ok($zip->set_number('2228530')->is_valid_number, '株式会社 リコー 新横浜事業所');
ok($zip->set_number('2228533')->is_valid_number, '新横浜プリンスホテル');
ok($zip->set_number('2228550')->is_valid_number, '神奈川税務署');
ok($zip->set_number('2228552')->is_valid_number, 'レーザーテック 株式会社');
ok($zip->set_number('2228556')->is_valid_number, 'アクサ損害保険 株式会社');
ok($zip->set_number('2228558')->is_valid_number, 'アマノ 株式会社');
ok($zip->set_number('2228561')->is_valid_number, '株式会社 マクニカ');
ok($zip->set_number('2228562')->is_valid_number, '株式会社 マクニカ');
ok($zip->set_number('2228563')->is_valid_number, '株式会社 アルティマ');
ok($zip->set_number('2228564')->is_valid_number, 'アマノマネジメントサービス 株式会社');
ok($zip->set_number('2228565')->is_valid_number, 'アマノメンテナンスエンジニアリング 株式会社');
ok($zip->set_number('2228566')->is_valid_number, 'ヒロセ電機 株式会社 横浜営業所');
ok($zip->set_number('2228577')->is_valid_number, '株式会社 聘珍樓');
ok($zip->set_number('2228580')->is_valid_number, 'イノテック 株式会社');
ok($zip->set_number('2228585')->is_valid_number, '日本ランズエンド 株式会社');
ok($zip->set_number('2228586')->is_valid_number, 'イノマイクロ 株式会社');
ok($zip->set_number('2228622')->is_valid_number, '社団法人 書燈社');
ok($zip->set_number('2228652')->is_valid_number, 'ユーコープかながわ');
ok($zip->set_number('2238501')->is_valid_number, 'アネスト岩田 株式会社');
ok($zip->set_number('2238502')->is_valid_number, 'アルプス電気 株式会社 横浜事業所');
ok($zip->set_number('2238505')->is_valid_number, 'リーダー電子 株式会社');
ok($zip->set_number('2238506')->is_valid_number, '日本工営 株式会社 横浜事業所');
ok($zip->set_number('2238507')->is_valid_number, '日本無線 株式会社');
ok($zip->set_number('2238508')->is_valid_number, '株式会社 エヌエフ回路設計ブロック');
ok($zip->set_number('2238510')->is_valid_number, '株式会社 トーエル');
ok($zip->set_number('2238512')->is_valid_number, 'ホリエ電機 株式会社');
ok($zip->set_number('2238515')->is_valid_number, '横浜信用金庫');
ok($zip->set_number('2238520')->is_valid_number, '株式会社 大堀');
ok($zip->set_number('2238521')->is_valid_number, '慶應義塾大学 日吉キャンパス');
ok($zip->set_number('2238522')->is_valid_number, '慶應義塾大学 理工学部');
ok($zip->set_number('2238525')->is_valid_number, '株式会社 松永製作所');
ok($zip->set_number('2238526')->is_valid_number, '慶應義塾協生館');
ok($zip->set_number('2238530')->is_valid_number, '東京エルピー瓦斯 株式会社');
ok($zip->set_number('2238533')->is_valid_number, '株式会社 岡本工作機械製作所');
ok($zip->set_number('2238539')->is_valid_number, '松下通信システム建設 株式会社');
ok($zip->set_number('2238540')->is_valid_number, '三光発条 株式会社');
ok($zip->set_number('2238541')->is_valid_number, '株式会社 ガリバー');
ok($zip->set_number('2238542')->is_valid_number, '株式会社 小泉神奈川');
ok($zip->set_number('2238550')->is_valid_number, '日本電熱計器 株式会社');
ok($zip->set_number('2238555')->is_valid_number, '株式会社 ナイガイ横浜センター');
ok($zip->set_number('2238558')->is_valid_number, 'オータックス 株式会社');
ok($zip->set_number('2238560')->is_valid_number, '株式会社 トーゴ');
ok($zip->set_number('2238566')->is_valid_number, '日本大学高等学校・日本大学中学校');
ok($zip->set_number('2238567')->is_valid_number, 'ユニー 日吉店');
ok($zip->set_number('2238572')->is_valid_number, 'ジェイ・アール・シー特機 株式会社');
ok($zip->set_number('2238577')->is_valid_number, '大塚製靴 株式会社 日吉工場');
ok($zip->set_number('2238580')->is_valid_number, '株式会社 浅川製作所');
ok($zip->set_number('2238585')->is_valid_number, 'ワコー電子 株式会社');
ok($zip->set_number('2238588')->is_valid_number, '株式会社 エイト工業');
ok($zip->set_number('2238686')->is_valid_number, '興亜火災海上保険 株式会社');
ok($zip->set_number('2238687')->is_valid_number, 'パナソニックCCソリューションズ 株式会社');
ok($zip->set_number('2248501')->is_valid_number, 'ボッシュ 株式会社');
ok($zip->set_number('2248502')->is_valid_number, '京セラ 株式会社 横浜事業所');
ok($zip->set_number('2248503')->is_valid_number, '昭和大学 横浜市北部病院');
ok($zip->set_number('2248504')->is_valid_number, '昭和大学 診療放射線専門学校');
ok($zip->set_number('2248505')->is_valid_number, '富士通化成 株式会社');
ok($zip->set_number('2248510')->is_valid_number, '東京濾器 株式会社');
ok($zip->set_number('2248520')->is_valid_number, 'パナソニック 株式会社 オートモーティブシステムズ社');
ok($zip->set_number('2248522')->is_valid_number, '株式会社 ソディック');
ok($zip->set_number('2248524')->is_valid_number, '亀屋万年堂製菓 株式会社');
ok($zip->set_number('2248530')->is_valid_number, '株式会社 エンジェリーベ');
ok($zip->set_number('2248533')->is_valid_number, '株式会社 エンジェリーベP&N');
ok($zip->set_number('2248539')->is_valid_number, 'パナソニックモバイルコミュニケーションズ 株式会社');
ok($zip->set_number('2248550')->is_valid_number, '日本ヒルティ 株式会社');
ok($zip->set_number('2248551')->is_valid_number, '東京都市大学 横浜キャンパス');
ok($zip->set_number('2248578')->is_valid_number, '株式会社 オリヒカ');
ok($zip->set_number('2248580')->is_valid_number, '株式会社 図研');
ok($zip->set_number('2248585')->is_valid_number, '株式会社 図研');
ok($zip->set_number('2248686')->is_valid_number, '株式会社 サカタのタネ');
ok($zip->set_number('2248688')->is_valid_number, '株式会社 AOKI');
ok($zip->set_number('2248730')->is_valid_number, '株式会社 エンジェリーベ');
ok($zip->set_number('2258501')->is_valid_number, '株式会社 ジャンボ');
ok($zip->set_number('2258502')->is_valid_number, '学校法人 桐蔭学園');
ok($zip->set_number('2258503')->is_valid_number, '桐蔭横浜大学');
ok($zip->set_number('2258508')->is_valid_number, 'アキュフェーズ 株式会社');
ok($zip->set_number('2258513')->is_valid_number, '緑県税事務所');
ok($zip->set_number('2258525')->is_valid_number, 'トップツアー 株式会社 個人旅行事業部(WEB販売センター・提携販売センター)');
ok($zip->set_number('2258535')->is_valid_number, 'たまプラーザテラス');
ok($zip->set_number('2258539')->is_valid_number, '株式会社 ブルックス');
ok($zip->set_number('2258550')->is_valid_number, '緑税務署');
ok($zip->set_number('2258560')->is_valid_number, 'イッツ・コミュニケーションズ (株)');
ok($zip->set_number('2258585')->is_valid_number, '劇団四季 (四季 株式会社)');
ok($zip->set_number('2268501')->is_valid_number, '東京工業大学 生命理工学部');
ok($zip->set_number('2268502')->is_valid_number, '東京工業大学 大学院総合理工学研究科');
ok($zip->set_number('2268503')->is_valid_number, '東京工業大学 その他');
ok($zip->set_number('2268507')->is_valid_number, '株式会社 小野測器');
ok($zip->set_number('2268510')->is_valid_number, '独立行政法人 中小企業基盤整備機構 東工大横浜ベンチャープラザ');
ok($zip->set_number('2268512')->is_valid_number, '京セラエルコ 株式会社');
ok($zip->set_number('2268525')->is_valid_number, '株式会社 ケンウッド 横浜事業所');
ok($zip->set_number('2268555')->is_valid_number, '昭和大学 保健医療学部');
ok($zip->set_number('2278501')->is_valid_number, '昭和大学藤が丘病院');
ok($zip->set_number('2278502')->is_valid_number, '三菱化学 株式会社 横浜センター');
ok($zip->set_number('2278505')->is_valid_number, '藤が丘女子学生会館');
ok($zip->set_number('2278508')->is_valid_number, '丸子電気工事 株式会社');
ok($zip->set_number('2278512')->is_valid_number, '日本たばこ産業 株式会社 たばこ中央研究所');
ok($zip->set_number('2278518')->is_valid_number, '昭和大学藤が丘リハビリテーション病院');
ok($zip->set_number('2278522')->is_valid_number, '星槎大学 横浜情報処理センター');
ok($zip->set_number('2278540')->is_valid_number, '東急テクノシステム 株式会社 長津田工場');
ok($zip->set_number('2308501')->is_valid_number, '鶴見大学');
ok($zip->set_number('2308504')->is_valid_number, '森永製菓');
ok($zip->set_number('2308511')->is_valid_number, '株式会社 エーアンドエーマテリアル');
ok($zip->set_number('2308550')->is_valid_number, '鶴見 税務署');
ok($zip->set_number('2308555')->is_valid_number, '鶴見社会保険事務所');
ok($zip->set_number('2308571')->is_valid_number, 'ナイス 株式会社');
ok($zip->set_number('2308577')->is_valid_number, '横浜商科大学');
ok($zip->set_number('2308585')->is_valid_number, '株式会社 トランテックス');
ok($zip->set_number('2308601')->is_valid_number, '千代田化工建設');
ok($zip->set_number('2308611')->is_valid_number, 'JFEエンジニアリング 株式会社 鶴見事業所');
ok($zip->set_number('2308623')->is_valid_number, '株式会社 ゼロ');
ok($zip->set_number('2308628')->is_valid_number, 'キリンビール 横浜工場');
ok($zip->set_number('2308666')->is_valid_number, '日本ファーネス工業');
ok($zip->set_number('2308686')->is_valid_number, '大本山総持寺');
ok($zip->set_number('2308765')->is_valid_number, '社会福祉法人恩賜財団 済生会 横浜市東部病院');
ok($zip->set_number('2318001')->is_valid_number, '株式会社 テレビ神奈川');
ok($zip->set_number('2318008')->is_valid_number, '富士ソフト 株式会社');
ok($zip->set_number('2318080')->is_valid_number, '(株) ワウワウ・コミュニケーションズ');
ok($zip->set_number('2318310')->is_valid_number, '(社) 神奈川県産業貿易振興協会');
ok($zip->set_number('2318311')->is_valid_number, '財団法人 日本新聞教育財団');
ok($zip->set_number('2318314')->is_valid_number, '横浜市特別徴収事務センター');
ok($zip->set_number('2318315')->is_valid_number, '横浜アイランドタワー');
ok($zip->set_number('2318320')->is_valid_number, '(財) 神奈川県厚生福利振興会');
ok($zip->set_number('2318321')->is_valid_number, '株式会社 熊谷組 横浜支店');
ok($zip->set_number('2318323')->is_valid_number, '神奈川県福祉共済協同組合');
ok($zip->set_number('2318324')->is_valid_number, '日本放送協会 横浜放送局');
ok($zip->set_number('2318330')->is_valid_number, '株式会社 ダイトーコーポレーション 横浜支店');
ok($zip->set_number('2318331')->is_valid_number, 'TOCみなとみらい');
ok($zip->set_number('2318338')->is_valid_number, 'WMBSサポートセンター');
ok($zip->set_number('2318411')->is_valid_number, '横浜地方法務局');
ok($zip->set_number('2318419')->is_valid_number, '丸全昭和運輸');
ok($zip->set_number('2318434')->is_valid_number, '神奈川労働局');
ok($zip->set_number('2318445')->is_valid_number, '株式会社 神奈川新聞社');
ok($zip->set_number('2318461')->is_valid_number, '千代田火災海上保険 株式会社 神奈川第一支店');
ok($zip->set_number('2318470')->is_valid_number, '日本信販 株式会社 横浜統括部');
ok($zip->set_number('2318477')->is_valid_number, '株式会社 日新');
ok($zip->set_number('2318478')->is_valid_number, '株式会社 オーヴァル');
ok($zip->set_number('2318484')->is_valid_number, '日本国土開発 株式会社 横浜支店');
ok($zip->set_number('2318520')->is_valid_number, '株式会社 ホテルニューグランド');
ok($zip->set_number('2318534')->is_valid_number, '神奈川県 社会保険診療報酬支払基金');
ok($zip->set_number('2318536')->is_valid_number, '日本赤十字社 神奈川県支部');
ok($zip->set_number('2318542')->is_valid_number, '株式会社 テレビ神奈川');
ok($zip->set_number('2318550')->is_valid_number, '横浜中税務署');
ok($zip->set_number('2318562')->is_valid_number, '横浜雙葉小学校');
ok($zip->set_number('2318566')->is_valid_number, 'あいおいニッセイ同和損害保険 (株)');
ok($zip->set_number('2318580')->is_valid_number, '株式会社 フジタ 横浜支店');
ok($zip->set_number('2318588')->is_valid_number, '神奈川県庁');
ok($zip->set_number('2318616')->is_valid_number, '大成建設 株式会社 横浜支店');
ok($zip->set_number('2318650')->is_valid_number, '中央大学横浜山手中学校・高等学校');
ok($zip->set_number('2318654')->is_valid_number, '学校法人 サンモールインターナショナルスクール');
ok($zip->set_number('2318682')->is_valid_number, '横浜市立 みなと赤十字病院');
ok($zip->set_number('2318711')->is_valid_number, '商工組合中央金庫 横浜支店');
ok($zip->set_number('2318966')->is_valid_number, '日石横浜ビル');
ok($zip->set_number('2328515')->is_valid_number, '宗教法人 大山ねずの命神示教会');
ok($zip->set_number('2328531')->is_valid_number, '株式会社 ノグチ 横浜支店');
ok($zip->set_number('2328555')->is_valid_number, '神奈川県立こども医療センター');
ok($zip->set_number('2328558')->is_valid_number, '馬淵建設 株式会社');
ok($zip->set_number('2328576')->is_valid_number, '株式会社 キャプティ');
ok($zip->set_number('2328580')->is_valid_number, '学校法人 横浜英和学院');
ok($zip->set_number('2328585')->is_valid_number, '横浜南社会保険事務所');
ok($zip->set_number('2328587')->is_valid_number, '横浜植木 株式会社');
ok($zip->set_number('2328602')->is_valid_number, '神奈川県自動車税管理事務所');
ok($zip->set_number('2328688')->is_valid_number, '株式会社ヤマシタ');
ok($zip->set_number('2338501')->is_valid_number, '横浜刑務所');
ok($zip->set_number('2338502')->is_valid_number, '横浜拘置支所');
ok($zip->set_number('2338503')->is_valid_number, '国立療養所南横浜病院');
ok($zip->set_number('2338550')->is_valid_number, '(株) 日揮');
ok($zip->set_number('2338555')->is_valid_number, '株式会社 京急ショッピングセンター');
ok($zip->set_number('2338556')->is_valid_number, '株式会社 京急百貨店');
ok($zip->set_number('2358501')->is_valid_number, '株式会社 IHI 横浜事業所');
ok($zip->set_number('2358505')->is_valid_number, 'リバースチール 株式会社');
ok($zip->set_number('2358522')->is_valid_number, '株式会社 東芝 横浜事業所');
ok($zip->set_number('2358523')->is_valid_number, '株式会社 東芝 磯子エンジニアリングセンター');
ok($zip->set_number('2358558')->is_valid_number, '日清オイリオグループ 株式会社 横浜磯子事業場');
ok($zip->set_number('2358588')->is_valid_number, '株式会社 大井製作所');
ok($zip->set_number('2368501')->is_valid_number, '関東学院大学');
ok($zip->set_number('2368502')->is_valid_number, '関東学院大学 金沢文庫キャンパス');
ok($zip->set_number('2368503')->is_valid_number, '関東学院大学 金沢八景室の木キャンパス');
ok($zip->set_number('2368504')->is_valid_number, '関東学院六浦中学校・高等学校');
ok($zip->set_number('2368515')->is_valid_number, '三菱重工業 株式会社 横浜製作所');
ok($zip->set_number('2368550')->is_valid_number, '横浜南税務署');
ok($zip->set_number('2368555')->is_valid_number, '杉田ゴルフ場');
ok($zip->set_number('2368648')->is_valid_number, '独立行政法人 水産総合研究センター 中央水産研究所');
ok($zip->set_number('2368653')->is_valid_number, '社会福祉法人 恩賜財団 済生会若草病院');
ok($zip->set_number('2378510')->is_valid_number, '東芝ライテック 株式会社 横須賀事業所');
ok($zip->set_number('2378515')->is_valid_number, '海上自衛隊 横須賀基地業務隊');
ok($zip->set_number('2378523')->is_valid_number, '日産自動車 株式会社 追浜工場');
ok($zip->set_number('2378555')->is_valid_number, '住友重機械工業 株式会社 横須賀造船所');
ok($zip->set_number('2378585')->is_valid_number, '関東自動車工業 株式会社');
ok($zip->set_number('2378588')->is_valid_number, '国家公務員共済組合連合会 横須賀北部共済病院');
ok($zip->set_number('2380292')->is_valid_number, 'ビバリーコート油壷');
ok($zip->set_number('2380298')->is_valid_number, '三浦市役所');
ok($zip->set_number('2388501')->is_valid_number, 'さいか屋 横須賀店');
ok($zip->set_number('2388510')->is_valid_number, '横浜地方裁判所 横須賀支部');
ok($zip->set_number('2388511')->is_valid_number, '学校法人 横須賀学院');
ok($zip->set_number('2388520')->is_valid_number, '西友 横須賀店');
ok($zip->set_number('2388522')->is_valid_number, '神奈川県立 保健福祉大学');
ok($zip->set_number('2388533')->is_valid_number, 'モアーズシティ');
ok($zip->set_number('2388541')->is_valid_number, 'ダイエー 横須賀店');
ok($zip->set_number('2388550')->is_valid_number, '横須賀市役所');
ok($zip->set_number('2388558')->is_valid_number, '横須賀共済病院');
ok($zip->set_number('2388565')->is_valid_number, '横須賀税務署');
ok($zip->set_number('2388567')->is_valid_number, '横須賀市立 うわまち病院');
ok($zip->set_number('2388580')->is_valid_number, '神奈川歯科大学');
ok($zip->set_number('2388585')->is_valid_number, '横須賀商工会議所');
ok($zip->set_number('2388588')->is_valid_number, '社会福祉法人 日本医療伝道会 総合病院 衣笠病院');
ok($zip->set_number('2388616')->is_valid_number, '湘南信用金庫');
ok($zip->set_number('2388686')->is_valid_number, '三浦藤沢信用金庫');
ok($zip->set_number('2398501')->is_valid_number, 'ウィング久里浜');
ok($zip->set_number('2398585')->is_valid_number, '独立行政法人 国立特殊教育総合研究所');
ok($zip->set_number('2398588')->is_valid_number, '東京電力 株式会社 横須賀火力発電所');
ok($zip->set_number('2398686')->is_valid_number, '防衛大学校');
ok($zip->set_number('2398688')->is_valid_number, '株式会社 ヤマリア');
ok($zip->set_number('2400192')->is_valid_number, '葉山町役場');
ok($zip->set_number('2400193')->is_valid_number, '総合研究大学院大学');
ok($zip->set_number('2400194')->is_valid_number, '株式会社 富士電機総合研究所');
ok($zip->set_number('2400195')->is_valid_number, '横須賀市立 市民病院');
ok($zip->set_number('2400196')->is_valid_number, '財団法人 電力中央研究所 横須賀研究所');
ok($zip->set_number('2400197')->is_valid_number, '社会福祉法人 全国社会福祉協議会 中央福祉学院');
ok($zip->set_number('2400198')->is_valid_number, '株式会社 湘南国際村協会');
ok($zip->set_number('2408501')->is_valid_number, '横浜国立大学');
ok($zip->set_number('2408515')->is_valid_number, '全国健康保険協会 神奈川支部');
ok($zip->set_number('2408521')->is_valid_number, '聖隷横浜病院');
ok($zip->set_number('2408540')->is_valid_number, 'NTT横浜情報サービスセンター');
ok($zip->set_number('2408550')->is_valid_number, '保土ケ谷税務署');
ok($zip->set_number('2418501')->is_valid_number, 'セブンスデー・アドベンチスト教団');
ok($zip->set_number('2418502')->is_valid_number, '学校法人 富士見丘学園 横浜富士見丘学園中等教育学校');
ok($zip->set_number('2418515')->is_valid_number, '神奈川県立 がんセンター');
ok($zip->set_number('2418606')->is_valid_number, '医療法人 順正会 横浜鶴ヶ峰病院');
ok($zip->set_number('2428507')->is_valid_number, '大和ラジオ放送 株式会社');
ok($zip->set_number('2428555')->is_valid_number, '太平金属工業 株式会社');
ok($zip->set_number('2428577')->is_valid_number, '株式会社 ガスター');
ok($zip->set_number('2428601')->is_valid_number, '大和市役所');
ok($zip->set_number('2428610')->is_valid_number, 'イオンリテール 株式会社 イオン大和店');
ok($zip->set_number('2430192')->is_valid_number, '日産自動車 株式会社 日産テクニカルセンター');
ok($zip->set_number('2430193')->is_valid_number, 'キヤノン 株式会社 中央研究所');
ok($zip->set_number('2430195')->is_valid_number, '清川村役場');
ok($zip->set_number('2430197')->is_valid_number, '株式会社 富士通研究所');
ok($zip->set_number('2430198')->is_valid_number, 'N・T・T・基礎技術総合研究所');
ok($zip->set_number('2430292')->is_valid_number, '神奈川工科大学');
ok($zip->set_number('2430297')->is_valid_number, '東京工芸大学');
ok($zip->set_number('2430298')->is_valid_number, '株式会社 リコー 厚木事業所');
ok($zip->set_number('2430392')->is_valid_number, '愛川町役場');
ok($zip->set_number('2430460')->is_valid_number, 'リコーテクノロジーセンター');
ok($zip->set_number('2430483')->is_valid_number, '株式会社 丸井 マルイファミリー海老名');
ok($zip->set_number('2430484')->is_valid_number, 'ビナウォーク4番館');
ok($zip->set_number('2430485')->is_valid_number, 'ビナウォーク管理センター');
ok($zip->set_number('2430486')->is_valid_number, 'TOHOシネマズ海老名');
ok($zip->set_number('2430488')->is_valid_number, '日立ビアメカニクス 株式会社');
ok($zip->set_number('2430489')->is_valid_number, '株式会社 ジャックス');
ok($zip->set_number('2430492')->is_valid_number, '海老名市役所');
ok($zip->set_number('2430493')->is_valid_number, 'アツギ 株式会社');
ok($zip->set_number('2430494')->is_valid_number, '富士ゼロックス 株式会社 海老名事業所');
ok($zip->set_number('2430495')->is_valid_number, '富士コカ・コーラボトリング 株式会社');
ok($zip->set_number('2430496')->is_valid_number, 'ものみの塔聖書冊子協会');
ok($zip->set_number('2430497')->is_valid_number, '富士ゼロックスマニュファクチュアリング 株式会社 海老名(本社)');
ok($zip->set_number('2430498')->is_valid_number, '株式会社 タイトー海老名開発センター');
ok($zip->set_number('2438501')->is_valid_number, 'ソニー学園湘北短期大学');
ok($zip->set_number('2438505')->is_valid_number, '公共シィー・アール・イー 株式会社 厚木営業所');
ok($zip->set_number('2438510')->is_valid_number, '株式会社 日立製作所 オートモティブシステムグループ厚木事業所');
ok($zip->set_number('2438511')->is_valid_number, '厚木市役所');
ok($zip->set_number('2438521')->is_valid_number, '昭和音楽大学');
ok($zip->set_number('2438533')->is_valid_number, 'ミツミ電機 株式会社 厚木事業所');
ok($zip->set_number('2438550')->is_valid_number, '湘南厚木クリニック');
ok($zip->set_number('2438551')->is_valid_number, '湘南厚木病院');
ok($zip->set_number('2438555')->is_valid_number, 'アンリツ 株式会社');
ok($zip->set_number('2438571')->is_valid_number, '東名厚木病院');
ok($zip->set_number('2438577')->is_valid_number, '厚木税務署');
ok($zip->set_number('2438588')->is_valid_number, '厚木市立病院');
ok($zip->set_number('2438601')->is_valid_number, '大和証券');
ok($zip->set_number('2438604')->is_valid_number, '野村證券(株)厚木支店');
ok($zip->set_number('2448501')->is_valid_number, '株式会社 タツノ・メカトロニクス 横浜工場');
ok($zip->set_number('2448502')->is_valid_number, '日立ハイブリッドネットワーク 株式会社');
ok($zip->set_number('2448503')->is_valid_number, 'グラフテック 株式会社');
ok($zip->set_number('2448510')->is_valid_number, '株式会社 ブリヂストン横浜工場');
ok($zip->set_number('2448522')->is_valid_number, '株式会社 ニフコ');
ok($zip->set_number('2448528')->is_valid_number, 'ダイエー 東戸塚店');
ok($zip->set_number('2448530')->is_valid_number, '株式会社 西武百貨店 東戸塚店');
ok($zip->set_number('2448533')->is_valid_number, '株式会社 ニコン 横浜製作所');
ok($zip->set_number('2448539')->is_valid_number, '明治学院大学 横浜校舎');
ok($zip->set_number('2448550')->is_valid_number, '戸塚税務署');
ok($zip->set_number('2448555')->is_valid_number, '(株) 日立製作所ソフトウェア事業部');
ok($zip->set_number('2448558')->is_valid_number, '大洋建設 株式会社');
ok($zip->set_number('2448566')->is_valid_number, 'JCN神奈川エリア');
ok($zip->set_number('2448569')->is_valid_number, 'KIホールディングス 株式会社');
ok($zip->set_number('2448571')->is_valid_number, 'コイト電工 株式会社');
ok($zip->set_number('2448577')->is_valid_number, '株式会社 ファンケル');
ok($zip->set_number('2448585')->is_valid_number, '株式会社 有隣堂');
ok($zip->set_number('2448588')->is_valid_number, '住友電気工業 株式会社 横浜製作所');
ok($zip->set_number('2448589')->is_valid_number, 'SEIオプティフロンティア 株式会社 本社・横浜事業所');
ok($zip->set_number('2448601')->is_valid_number, '大和証券 株式会社 戸塚支店');
ok($zip->set_number('2458501')->is_valid_number, '株式会社 モリリカ');
ok($zip->set_number('2458510')->is_valid_number, '株式会社 ミツバ 横浜本社');
ok($zip->set_number('2458542')->is_valid_number, 'かもめプロペラ 株式会社');
ok($zip->set_number('2458550')->is_valid_number, '日本貿易印刷 株式会社');
ok($zip->set_number('2458553')->is_valid_number, '神奈川県立和泉高等学校');
ok($zip->set_number('2458555')->is_valid_number, 'ユージエム 株式会社');
ok($zip->set_number('2458558')->is_valid_number, '株式会社 日産クリエイティブサービス');
ok($zip->set_number('2458560')->is_valid_number, '医療法人 横浜博萌会 西横浜国際総合病院');
ok($zip->set_number('2458575')->is_valid_number, '独立行政法人 国立病院機構 横浜医療センター');
ok($zip->set_number('2458577')->is_valid_number, '三池工業 株式会社');
ok($zip->set_number('2458589')->is_valid_number, '横浜薬科大学');
ok($zip->set_number('2468520')->is_valid_number, '(株) カナジュウ・コーポレーション');
ok($zip->set_number('2468550')->is_valid_number, '清水建設 株式会社 相模機械センター');
ok($zip->set_number('2468556')->is_valid_number, '株式会社 竹虎');
ok($zip->set_number('2478510')->is_valid_number, '電気化学工業 株式会社 大船工場');
ok($zip->set_number('2478530')->is_valid_number, '中外製薬 株式会社');
ok($zip->set_number('2478550')->is_valid_number, 'シンロイヒ (株)');
ok($zip->set_number('2478577')->is_valid_number, '株式会社 ファンケル');
ok($zip->set_number('2478588')->is_valid_number, '株式会社 アテニア');
ok($zip->set_number('2478686')->is_valid_number, '株式会社 鎌倉ケーブルコミュニケーションズ');
ok($zip->set_number('2488555')->is_valid_number, '東レ 株式会社 基礎研究センター');
ok($zip->set_number('2488558')->is_valid_number, '鎌倉県税事務所');
ok($zip->set_number('2488686')->is_valid_number, '鎌倉市役所');
ok($zip->set_number('2498510')->is_valid_number, '逗子開成中学・高等学校');
ok($zip->set_number('2498686')->is_valid_number, '逗子市役所');
ok($zip->set_number('2500192')->is_valid_number, '南足柄市役所');
ok($zip->set_number('2500280')->is_valid_number, '日本曹達 株式会社 小田原研究所');
ok($zip->set_number('2500292')->is_valid_number, '株式会社 竿好');
ok($zip->set_number('2500293')->is_valid_number, '愛光電気 株式会社');
ok($zip->set_number('2500294')->is_valid_number, '有限会社 ルートフィッシィング');
ok($zip->set_number('2500295')->is_valid_number, '日本インジェクタ 株式会社');
ok($zip->set_number('2500296')->is_valid_number, '小田原市水道局');
ok($zip->set_number('2500298')->is_valid_number, '株式会社 大川');
ok($zip->set_number('2500392')->is_valid_number, '富士屋ホテル 株式会社 湯本富士屋ホテル');
ok($zip->set_number('2500398')->is_valid_number, '箱根町役場');
ok($zip->set_number('2500592')->is_valid_number, '箱根プリンスホテル');
ok($zip->set_number('2508511')->is_valid_number, '小田原税務署');
ok($zip->set_number('2508555')->is_valid_number, '小田原市役所');
ok($zip->set_number('2508588')->is_valid_number, '国際医療福祉大学 小田原保健医療学部');
ok($zip->set_number('2518501')->is_valid_number, '日本精工 株式会社 藤沢工場');
ok($zip->set_number('2518502')->is_valid_number, '株式会社 荏原製作所');
ok($zip->set_number('2518505')->is_valid_number, '学校法人 湘南学園');
ok($zip->set_number('2518510')->is_valid_number, 'ソニー 株式会社 湘南テクノロジーセンター');
ok($zip->set_number('2518511')->is_valid_number, '学校法人 湘南工科大学');
ok($zip->set_number('2518513')->is_valid_number, '池上通信機 株式会社 放送通信事業本部 湘南工場');
ok($zip->set_number('2518515')->is_valid_number, 'キーパー 株式会社');
ok($zip->set_number('2518520')->is_valid_number, '松下冷機 株式会社 冷機デバイス事業部');
ok($zip->set_number('2518522')->is_valid_number, '株式会社 山武 藤沢工場');
ok($zip->set_number('2518530')->is_valid_number, '医療法人 社団清心会 藤沢病院');
ok($zip->set_number('2518531')->is_valid_number, 'ミネベア 株式会社 藤沢製作所');
ok($zip->set_number('2518534')->is_valid_number, '藤沢県税事務所');
ok($zip->set_number('2518540')->is_valid_number, '株式会社 佐賀鉄工所 藤沢工場');
ok($zip->set_number('2518550')->is_valid_number, '藤沢市民病院');
ok($zip->set_number('2518551')->is_valid_number, '株式会社 神戸製鋼所 藤沢事業所');
ok($zip->set_number('2518555')->is_valid_number, '武田薬品工業 (株) 湘南研究所');
ok($zip->set_number('2518558')->is_valid_number, '株式会社 さいか屋 藤沢店');
ok($zip->set_number('2518560')->is_valid_number, '株式会社 ジェイコム湘南');
ok($zip->set_number('2518566')->is_valid_number, '藤沢税務署');
ok($zip->set_number('2518567')->is_valid_number, '吉原建設 株式会社');
ok($zip->set_number('2518581')->is_valid_number, '東京スター銀行 藤沢支店');
ok($zip->set_number('2518588')->is_valid_number, '協同油脂 株式会社');
ok($zip->set_number('2518601')->is_valid_number, '藤沢市役所');
ok($zip->set_number('2520370')->is_valid_number, '株式会社 横浜岡田屋');
ok($zip->set_number('2520373')->is_valid_number, '学校法人 北里研究所');
ok($zip->set_number('2520374')->is_valid_number, '北里大学 医学部');
ok($zip->set_number('2520375')->is_valid_number, '北里大学病院');
ok($zip->set_number('2520377')->is_valid_number, '相模原市 南区役所');
ok($zip->set_number('2520380')->is_valid_number, '北里大学東病院');
ok($zip->set_number('2520381')->is_valid_number, '相模原県税事務所');
ok($zip->set_number('2520383')->is_valid_number, '学校法人 相模女子大学');
ok($zip->set_number('2520385')->is_valid_number, '東芝林間病院');
ok($zip->set_number('2520386')->is_valid_number, '特別養護老人ホーム グレープの里');
ok($zip->set_number('2520388')->is_valid_number, '相模原年金事務所');
ok($zip->set_number('2520392')->is_valid_number, '独立行政法人 国立病院機構 相模原病院');
ok($zip->set_number('2520395')->is_valid_number, '東海大学付属相模高等学校・中等部');
ok($zip->set_number('2520398')->is_valid_number, '株式会社 家具の大正堂 本部');
ok($zip->set_number('2520880')->is_valid_number, '日本大学 生物資源科学部 湘南校舎');
ok($zip->set_number('2520881')->is_valid_number, 'いすゞ自動車 (株) 藤沢工場');
ok($zip->set_number('2520882')->is_valid_number, '慶應義塾湘南藤沢事務室');
ok($zip->set_number('2520883')->is_valid_number, '慶應義塾大学 看護医療学部');
ok($zip->set_number('2520885')->is_valid_number, '日本大学藤沢高等学校・日本大学藤沢中学校');
ok($zip->set_number('2520886')->is_valid_number, '社会福祉法人 光友会');
ok($zip->set_number('2520888')->is_valid_number, '株式会社 日立グローバルストレージテクノロジーズ 藤沢事業所');
ok($zip->set_number('2521192')->is_valid_number, '綾瀬市役所');
ok($zip->set_number('2521193')->is_valid_number, '財団法人 相模中央化学研究所');
ok($zip->set_number('2521195')->is_valid_number, '株式会社 ガステック');
ok($zip->set_number('2525152')->is_valid_number, '相模原市 藤野総合事務所');
ok($zip->set_number('2525162')->is_valid_number, '相模原市 相模湖総合事務所');
ok($zip->set_number('2525172')->is_valid_number, '相模原市 津久井総合事務所');
ok($zip->set_number('2525177')->is_valid_number, '相模原市 緑区役所');
ok($zip->set_number('2525181')->is_valid_number, 'アイダエンジニアリング 株式会社');
ok($zip->set_number('2525182')->is_valid_number, 'セントラル自動車 株式会社');
ok($zip->set_number('2525188')->is_valid_number, '相模原協同病院');
ok($zip->set_number('2525191')->is_valid_number, 'アイダエンジニアリング 株式会社 津久井事業所');
ok($zip->set_number('2525192')->is_valid_number, '相模原市 城山総合事務所');
ok($zip->set_number('2525196')->is_valid_number, '独立行政法人 雇用・能力開発機構 職業能力開発総合大学校');
ok($zip->set_number('2525201')->is_valid_number, '学校法人 麻布獣医学園');
ok($zip->set_number('2525210')->is_valid_number, '宇宙航空研究開発機構 宇宙科学研究所');
ok($zip->set_number('2525211')->is_valid_number, '相模原税務署');
ok($zip->set_number('2525221')->is_valid_number, 'サクサ 株式会社 相模原オフィス');
ok($zip->set_number('2525222')->is_valid_number, '和泉短期大学');
ok($zip->set_number('2525225')->is_valid_number, '社会福祉法人 相模更正会 総合相模更正病院');
ok($zip->set_number('2525233')->is_valid_number, 'J:COM');
ok($zip->set_number('2525252')->is_valid_number, '株式会社 オリバーツウ・リアルエステート');
ok($zip->set_number('2525255')->is_valid_number, '株式会社 ウイッツコミュニティ');
ok($zip->set_number('2525258')->is_valid_number, '青山学院大学 相模原キャンパス');
ok($zip->set_number('2525277')->is_valid_number, '相模原市役所');
ok($zip->set_number('2525280')->is_valid_number, '株式会社 デュプロ');
ok($zip->set_number('2525285')->is_valid_number, '住友スリーエム 株式会社 相模原事業所');
ok($zip->set_number('2525286')->is_valid_number, '株式会社 オハラ');
ok($zip->set_number('2525288')->is_valid_number, '株式会社 エフエムさがみ');
ok($zip->set_number('2525292')->is_valid_number, 'キャタピラージャパン 株式会社 相模事業所');
ok($zip->set_number('2525293')->is_valid_number, '三菱重工業 株式会社 汎用機・特車事業本部');
ok($zip->set_number('2525294')->is_valid_number, '株式会社 ノジマ 相模原本店');
ok($zip->set_number('2525295')->is_valid_number, '三菱電機 株式会社 半導体・デバイス業務統括部 相模事務所');
ok($zip->set_number('2525297')->is_valid_number, '日本電気 株式会社 橋本技術センター');
ok($zip->set_number('2525298')->is_valid_number, '日本電気 株式会社 相模原事業場');
ok($zip->set_number('2528502')->is_valid_number, '日産自動車 株式会社 座間事業所');
ok($zip->set_number('2528511')->is_valid_number, 'キャンプ座間');
ok($zip->set_number('2528522')->is_valid_number, '株式会社 Paltac 横浜支社');
ok($zip->set_number('2528538')->is_valid_number, '女子美術大学');
ok($zip->set_number('2528539')->is_valid_number, '株式会社 マルスコーポレーション');
ok($zip->set_number('2528540')->is_valid_number, 'NPO法人 神奈川県視覚障害者福祉協会');
ok($zip->set_number('2528550')->is_valid_number, '東京コスモス電機 株式会社');
ok($zip->set_number('2528558')->is_valid_number, '株式会社 ユーテムプレシジョン');
ok($zip->set_number('2528566')->is_valid_number, '座間市役所');
ok($zip->set_number('2528567')->is_valid_number, '株式会社 シーイーシー');
ok($zip->set_number('2528570')->is_valid_number, '日本電産トーソク 株式会社');
ok($zip->set_number('2528585')->is_valid_number, '三木プーリ (株) 相模事業所');
ok($zip->set_number('2530192')->is_valid_number, 'エプソントヨコム 株式会社 湘南事業所');
ok($zip->set_number('2530193')->is_valid_number, 'トーヨーアルファネット 株式会社 相模事業所');
ok($zip->set_number('2530195')->is_valid_number, '寒川神社');
ok($zip->set_number('2530196')->is_valid_number, '寒川町役場');
ok($zip->set_number('2530197')->is_valid_number, '東洋無線システム 株式会社');
ok($zip->set_number('2530198')->is_valid_number, '東洋ネットワークシステムズ 株式会社 相模事業所');
ok($zip->set_number('2538501')->is_valid_number, '株式会社 はせがわ');
ok($zip->set_number('2538510')->is_valid_number, '東邦チタニウム 株式会社');
ok($zip->set_number('2538522')->is_valid_number, 'アルバック・ファイ 株式会社');
ok($zip->set_number('2538531')->is_valid_number, '株式会社 マイカル 茅ヶ崎サティ');
ok($zip->set_number('2538543')->is_valid_number, '株式会社 アルバック');
ok($zip->set_number('2538550')->is_valid_number, '文教大学 湘南校舎 文教大学 女子短期大学部');
ok($zip->set_number('2538555')->is_valid_number, 'アルバックテクノ 株式会社');
ok($zip->set_number('2538558')->is_valid_number, '茅ヶ崎徳洲会総合病院');
ok($zip->set_number('2538567')->is_valid_number, 'パナソニック (株) エナジー社');
ok($zip->set_number('2538571')->is_valid_number, '株式会社 オーテックジャパン');
ok($zip->set_number('2538577')->is_valid_number, '東陶機器 株式会社 茅ヶ崎工場');
ok($zip->set_number('2538585')->is_valid_number, 'セイミケミカル 株式会社');
ok($zip->set_number('2538588')->is_valid_number, '宮田工業 株式会社');
ok($zip->set_number('2538686')->is_valid_number, '茅ヶ崎市役所');
ok($zip->set_number('2548501')->is_valid_number, '神奈川中央交通 株式会社');
ok($zip->set_number('2548502')->is_valid_number, '平塚共済病院');
ok($zip->set_number('2548532')->is_valid_number, '株式会社 日産 サティオ湘南');
ok($zip->set_number('2548533')->is_valid_number, '平塚税務署');
ok($zip->set_number('2548543')->is_valid_number, '小松エレクトロニクス 株式会社');
ok($zip->set_number('2548555')->is_valid_number, '株式会社 小松製作所 開発本部 建機エレクトロニクス事業部');
ok($zip->set_number('2548585')->is_valid_number, '株式会社 パイロットコーポレーション 平塚工場');
ok($zip->set_number('2548588')->is_valid_number, 'ネッツトヨタ 神奈川 株式会社');
ok($zip->set_number('2548601')->is_valid_number, '横浜ゴム 株式会社 平塚製造所');
ok($zip->set_number('2548610')->is_valid_number, '日産車体 株式会社');
ok($zip->set_number('2548612')->is_valid_number, '菱和ロジテム 株式会社 平塚支店');
ok($zip->set_number('2548614')->is_valid_number, '三菱樹脂 株式会社 平塚工場');
ok($zip->set_number('2548686')->is_valid_number, '平塚市役所');
ok($zip->set_number('2558555')->is_valid_number, '大磯町役場');
ok($zip->set_number('2568510')->is_valid_number, '株式会社 日立グローバル ストレージテクノロジーズ');
ok($zip->set_number('2578501')->is_valid_number, '秦野市役所');
ok($zip->set_number('2578502')->is_valid_number, '横河電子機器 株式会社');
ok($zip->set_number('2578511')->is_valid_number, '日本インター 株式会社');
ok($zip->set_number('2578522')->is_valid_number, '県立・大秦野高等学校');
ok($zip->set_number('2578523')->is_valid_number, '食品薬品安全センター');
ok($zip->set_number('2578533')->is_valid_number, '東京電力');
ok($zip->set_number('2578555')->is_valid_number, 'スタンレー電気 株式会社');
ok($zip->set_number('2578566')->is_valid_number, 'コバレントマテリアル 株式会社 秦野事業所');
ok($zip->set_number('2578584')->is_valid_number, '日立インフォメーション・テクノロジー');
ok($zip->set_number('2578585')->is_valid_number, '国立療養所 神奈川病院');
ok($zip->set_number('2578586')->is_valid_number, '株式会社 リコー 秦野事業所');
ok($zip->set_number('2578588')->is_valid_number, '秦野商工会議所');
ok($zip->set_number('2578686')->is_valid_number, '株式会社 トープラ');
ok($zip->set_number('2580195')->is_valid_number, '山北町役場');
ok($zip->set_number('2588501')->is_valid_number, '大井町役場');
ok($zip->set_number('2588506')->is_valid_number, '明治ゴム化成 株式会社');
ok($zip->set_number('2588508')->is_valid_number, '株式会社 ソキア');
ok($zip->set_number('2588511')->is_valid_number, '第一生命保険相互会社 大井事業所');
ok($zip->set_number('2588533')->is_valid_number, 'NEC湘南テクニカルセンター');
ok($zip->set_number('2588538')->is_valid_number, '富士写真フイルム 株式会社 宮台技術開発センター');
ok($zip->set_number('2588585')->is_valid_number, '松田町役場');
ok($zip->set_number('2590192')->is_valid_number, 'ファインテック製品事業本部');
ok($zip->set_number('2590193')->is_valid_number, '大磯プリンスホテル');
ok($zip->set_number('2590194')->is_valid_number, '有限会社 富士見グリーンサービス');
ok($zip->set_number('2590196')->is_valid_number, '二宮町役場');
ok($zip->set_number('2590197')->is_valid_number, '中井町役場');
ok($zip->set_number('2590198')->is_valid_number, '東海大学大磯病院');
ok($zip->set_number('2590392')->is_valid_number, '湯河原町役場');
ok($zip->set_number('2590393')->is_valid_number, '株式会社 ちぼり');
ok($zip->set_number('2590395')->is_valid_number, '財団法人 日本老人福祉財団 湯河原ゆうゆうの里');
ok($zip->set_number('2590396')->is_valid_number, '湯河原厚生年金病院');
ok($zip->set_number('2591185')->is_valid_number, '学校法人 向上学園');
ok($zip->set_number('2591188')->is_valid_number, '伊勢原市役所');
ok($zip->set_number('2591192')->is_valid_number, '市光工業 株式会社');
ok($zip->set_number('2591193')->is_valid_number, '東海大学医学部付属病院');
ok($zip->set_number('2591195')->is_valid_number, '株式会社 山武');
ok($zip->set_number('2591196')->is_valid_number, '株式会社 アマダ');
ok($zip->set_number('2591197')->is_valid_number, '産能大学');
ok($zip->set_number('2591198')->is_valid_number, 'オリイメック 株式会社');
ok($zip->set_number('2591292')->is_valid_number, '東海大学 湘南校舎');
ok($zip->set_number('2591293')->is_valid_number, '神奈川大学 湘南ひらつかキャンパス');
ok($zip->set_number('2591392')->is_valid_number, '株式会社 日立製作所 汎用コンピュータ事業部');
ok($zip->set_number('2591396')->is_valid_number, '株式会社 日立インフォメーションテクノロジー 神奈川事業所');
ok($zip->set_number('2608501')->is_valid_number, '千葉県信用保証協会');
ok($zip->set_number('2608502')->is_valid_number, '千葉県市町村職員 共済組合');
ok($zip->set_number('2608505')->is_valid_number, '日本興亜損害保険 株式会社 千葉支店');
ok($zip->set_number('2608506')->is_valid_number, '千葉労働基準監督署');
ok($zip->set_number('2608507')->is_valid_number, '千葉県赤十字血液センター 千葉港出張所');
ok($zip->set_number('2608508')->is_valid_number, '社会福祉法人 千葉県社会福祉協議会');
ok($zip->set_number('2608509')->is_valid_number, '日本赤十字社 千葉県支部');
ok($zip->set_number('2608510')->is_valid_number, '千葉中央警察署');
ok($zip->set_number('2608511')->is_valid_number, '千葉市中央保健福祉センター');
ok($zip->set_number('2608512')->is_valid_number, '全労済 千葉県本部');
ok($zip->set_number('2608513')->is_valid_number, '千葉保護観察所');
ok($zip->set_number('2608514')->is_valid_number, '財団法人 千葉県私学会館');
ok($zip->set_number('2608515')->is_valid_number, '日産プリンス千葉販売 株式会社');
ok($zip->set_number('2608516')->is_valid_number, '株式会社 NTTドコモ 千葉支店');
ok($zip->set_number('2608518')->is_valid_number, '千葉地方法務局');
ok($zip->set_number('2608523')->is_valid_number, '千葉県自動車税事務所');
ok($zip->set_number('2608524')->is_valid_number, '福井電機 株式会社');
ok($zip->set_number('2608532')->is_valid_number, '全労済 マイカー共済 千葉サービスセンター');
ok($zip->set_number('2608535')->is_valid_number, '千葉構内タクシー 株式会社');
ok($zip->set_number('2608538')->is_valid_number, '千葉トヨタ自動車 株式会社');
ok($zip->set_number('2608540')->is_valid_number, '株式会社 NTTドコモ 千葉支店');
ok($zip->set_number('2608551')->is_valid_number, '東日本旅客鉄道 株式会社 千葉支社');
ok($zip->set_number('2608552')->is_valid_number, '株式会社 飯豊');
ok($zip->set_number('2608554')->is_valid_number, '株式会社 角川書店クロスメディア');
ok($zip->set_number('2608555')->is_valid_number, 'リコージャパン 株式会社 千葉支社');
ok($zip->set_number('2608556')->is_valid_number, '西松建設 株式会社 東関東支店');
ok($zip->set_number('2608557')->is_valid_number, '株式会社 そごう 千葉支店');
ok($zip->set_number('2608559')->is_valid_number, 'サンケイリビング新聞社 千葉本部');
ok($zip->set_number('2608560')->is_valid_number, '安田火災海上保険 千葉支店 千葉SC業務部 千葉自動車営業部');
ok($zip->set_number('2608563')->is_valid_number, 'ネッツトヨタ南千葉 株式会社');
ok($zip->set_number('2608564')->is_valid_number, '株式会社 千葉薬品');
ok($zip->set_number('2608566')->is_valid_number, '社団法人 千葉県防犯協会');
ok($zip->set_number('2608567')->is_valid_number, '株式会社 千葉測器');
ok($zip->set_number('2608577')->is_valid_number, '千葉東税務署');
ok($zip->set_number('2608585')->is_valid_number, '千葉日産自動車 株式会社');
ok($zip->set_number('2608586')->is_valid_number, '千葉県酒類販売 株式会社');
ok($zip->set_number('2608588')->is_valid_number, '株式会社 ライフランド');
ok($zip->set_number('2608601')->is_valid_number, '学校法人 植草学園');
ok($zip->set_number('2608603')->is_valid_number, '中央労働金庫');
ok($zip->set_number('2608606')->is_valid_number, '独立行政法人 国立病院機構 千葉医療センター');
ok($zip->set_number('2608607')->is_valid_number, '財務省 関東財務局 千葉財務事務所');
ok($zip->set_number('2608610')->is_valid_number, '日本放送協会 千葉放送局');
ok($zip->set_number('2608611')->is_valid_number, '三菱電機ビルテクノサービス 株式会社 東関東支社');
ok($zip->set_number('2608612')->is_valid_number, '千葉労働局');
ok($zip->set_number('2608613')->is_valid_number, '株式会社 帝国データバンク 千葉支店');
ok($zip->set_number('2608616')->is_valid_number, '三井住友海上火災保険 株式会社 千葉中央ビル');
ok($zip->set_number('2608618')->is_valid_number, '千葉市ボランティアセンター');
ok($zip->set_number('2608619')->is_valid_number, '公立学校共済組合 千葉支部');
ok($zip->set_number('2608620')->is_valid_number, '千葉地方検察庁');
ok($zip->set_number('2608621')->is_valid_number, '住友生命保険 相互会社 千葉支社');
ok($zip->set_number('2608625')->is_valid_number, '株式会社 ベイエフエム');
ok($zip->set_number('2608626')->is_valid_number, '株式会社 三井不動産ホテルマネジメント 三井ガーデンホテル千葉');
ok($zip->set_number('2608631')->is_valid_number, '株式会社 三越 千葉店');
ok($zip->set_number('2608633')->is_valid_number, '朝日生命保険 千葉支社');
ok($zip->set_number('2608636')->is_valid_number, '株式会社 東京三菱銀行 千葉支店');
ok($zip->set_number('2608637')->is_valid_number, '株式会社 大崎コンピュータエンヂニアリング 千葉支店');
ok($zip->set_number('2608645')->is_valid_number, '全国健康保険協会 千葉支部');
ok($zip->set_number('2608654')->is_valid_number, '千葉県中央県税事務所');
ok($zip->set_number('2608656')->is_valid_number, '柏戸病院');
ok($zip->set_number('2608660')->is_valid_number, '千葉県立 中央図書館');
ok($zip->set_number('2608661')->is_valid_number, '財団法人 千葉県文化振興財団');
ok($zip->set_number('2608663')->is_valid_number, '旭建設 株式会社');
ok($zip->set_number('2608665')->is_valid_number, '千葉県病院局');
ok($zip->set_number('2608666')->is_valid_number, '千葉窯業 株式会社');
ok($zip->set_number('2608667')->is_valid_number, '千葉県');
ok($zip->set_number('2608668')->is_valid_number, '千葉県警察本部');
ok($zip->set_number('2608670')->is_valid_number, '千葉大学 医学部');
ok($zip->set_number('2608671')->is_valid_number, '千葉大学附属図書館 亥鼻分館');
ok($zip->set_number('2608672')->is_valid_number, '千葉大学 看護学部');
ok($zip->set_number('2608673')->is_valid_number, '千葉大学真菌医学研究センター');
ok($zip->set_number('2608675')->is_valid_number, '千葉大学 薬学部 (医薬系総合研究棟)');
ok($zip->set_number('2608677')->is_valid_number, '千葉大学医学部附属病院');
ok($zip->set_number('2608682')->is_valid_number, '千葉県立 中央博物館');
ok($zip->set_number('2608685')->is_valid_number, '学校法人 千葉明徳学園');
ok($zip->set_number('2608688')->is_valid_number, '千葉南税務署');
ok($zip->set_number('2608701')->is_valid_number, '淑徳大学 千葉キャンパス');
ok($zip->set_number('2608702')->is_valid_number, '千葉県医療技術大学校');
ok($zip->set_number('2608703')->is_valid_number, '淑徳大学 看護学部');
ok($zip->set_number('2608707')->is_valid_number, '医療法人 緑栄会 三愛記念 そが病院');
ok($zip->set_number('2608710')->is_valid_number, '千葉社会保険病院');
ok($zip->set_number('2608712')->is_valid_number, '独立行政法人 国立病院機構 千葉東病院');
ok($zip->set_number('2608715')->is_valid_number, '千葉県衛生研究所');
ok($zip->set_number('2608717')->is_valid_number, '千葉県がんセンター');
ok($zip->set_number('2608720')->is_valid_number, '株式会社 千葉銀行');
ok($zip->set_number('2608722')->is_valid_number, '千葉市役所');
ok($zip->set_number('2608730')->is_valid_number, '千葉市教育委員会');
ok($zip->set_number('2608733')->is_valid_number, '千葉市中央区役所');
ok($zip->set_number('2618501')->is_valid_number, '幕張テクノガーデン');
ok($zip->set_number('2618502')->is_valid_number, '東京歯科大学');
ok($zip->set_number('2618503')->is_valid_number, 'イオンリテール 株式会社 稲毛海岸事務所');
ok($zip->set_number('2618507')->is_valid_number, 'セイコーインスツル 株式会社');
ok($zip->set_number('2618508')->is_valid_number, '千葉県千葉西県税事務所');
ok($zip->set_number('2618512')->is_valid_number, '株式会社 京葉銀行 幸町センター');
ok($zip->set_number('2618513')->is_valid_number, 'イオンリテール 株式会社 ジャスコマリンピア店');
ok($zip->set_number('2618515')->is_valid_number, 'イオン 株式会社');
ok($zip->set_number('2618521')->is_valid_number, '東京電力 株式会社 千葉支社');
ok($zip->set_number('2618522')->is_valid_number, '日本アイ・ビー・エム 株式会社 幕張事業所');
ok($zip->set_number('2618530')->is_valid_number, '山崎製パン 株式会社千葉工場');
ok($zip->set_number('2618544')->is_valid_number, 'キヤノンマーケティングジャパン 株式会社 幕張事業所');
ok($zip->set_number('2618545')->is_valid_number, '日本貿易振興機構(ジェトロ) アジア経済研究所');
ok($zip->set_number('2618552')->is_valid_number, '千葉県 企業庁');
ok($zip->set_number('2618554')->is_valid_number, '株式会社 大地を守る会');
ok($zip->set_number('2618555')->is_valid_number, '双葉電子工業 (株)');
ok($zip->set_number('2618566')->is_valid_number, 'スターツアメニティー 株式会社');
ok($zip->set_number('2618575')->is_valid_number, '(株) 日産フィナンシャルサービス');
ok($zip->set_number('2618581')->is_valid_number, '千葉市 美浜保健福祉センター');
ok($zip->set_number('2618582')->is_valid_number, '千葉市 西部市税事務所');
ok($zip->set_number('2618586')->is_valid_number, '放送大学');
ok($zip->set_number('2618587')->is_valid_number, '株式会社 千葉ロッテマリーンズ');
ok($zip->set_number('2618588')->is_valid_number, '富士通 株式会社');
ok($zip->set_number('2618609')->is_valid_number, '千葉公共職業安定所');
ok($zip->set_number('2618686')->is_valid_number, '放送大学');
ok($zip->set_number('2618733')->is_valid_number, '美浜区役所');
ok($zip->set_number('2628502')->is_valid_number, '千葉西税務署');
ok($zip->set_number('2628503')->is_valid_number, '千葉地方法務局 千葉西出張所');
ok($zip->set_number('2628504')->is_valid_number, '千葉畜産工業 株式会社');
ok($zip->set_number('2628506')->is_valid_number, '医療法人社団 有相会 最成病院');
ok($zip->set_number('2628508')->is_valid_number, 'ハイテック精工 株式会社');
ok($zip->set_number('2628510')->is_valid_number, '千葉市花見川保健福祉センター');
ok($zip->set_number('2628511')->is_valid_number, '医療法人 社団有相会 介護老人保健施設 ゆうあい苑');
ok($zip->set_number('2628512')->is_valid_number, '千葉県 水道局');
ok($zip->set_number('2628536')->is_valid_number, 'NTT 移動通信網 株式会社 千葉支店');
ok($zip->set_number('2628555')->is_valid_number, '株式会社 ガイア');
ok($zip->set_number('2628710')->is_valid_number, '株式会社 ベターサービス');
ok($zip->set_number('2628733')->is_valid_number, '花見川区役所');
ok($zip->set_number('2638506')->is_valid_number, '二宮産業 株式会社');
ok($zip->set_number('2638512')->is_valid_number, '財団法人 日本分析センター');
ok($zip->set_number('2638522')->is_valid_number, '国立大学法人 千葉大学');
ok($zip->set_number('2638533')->is_valid_number, '(株) スズケン 千葉支店');
ok($zip->set_number('2638550')->is_valid_number, '千葉市稲毛保健福祉センター');
ok($zip->set_number('2638555')->is_valid_number, '独立行政法人 放射線医学総合研究所');
ok($zip->set_number('2638577')->is_valid_number, '千葉県教育庁 千葉地方出張所');
ok($zip->set_number('2638585')->is_valid_number, '千葉経済大学附属高等学校');
ok($zip->set_number('2638588')->is_valid_number, '敬愛大学');
ok($zip->set_number('2638733')->is_valid_number, '稲毛区役所');
ok($zip->set_number('2648501')->is_valid_number, '陸上自衛隊 下志津駐屯地');
ok($zip->set_number('2648505')->is_valid_number, '千葉県立 千葉大宮高等学校');
ok($zip->set_number('2648530')->is_valid_number, 'みつわ台総合病院');
ok($zip->set_number('2648550')->is_valid_number, '千葉市若葉保健福祉センター');
ok($zip->set_number('2648582')->is_valid_number, '千葉市 東部市税事務所');
ok($zip->set_number('2648585')->is_valid_number, '千葉刑務所');
ok($zip->set_number('2648601')->is_valid_number, '大和証券 千葉支店');
ok($zip->set_number('2648604')->is_valid_number, '野村証券 千葉支店');
ok($zip->set_number('2648646')->is_valid_number, '三菱UFJ信託銀行 株式会社 千葉支店');
ok($zip->set_number('2648651')->is_valid_number, '千葉日産自動車 株式会社');
ok($zip->set_number('2648733')->is_valid_number, '若葉区役所');
ok($zip->set_number('2658501')->is_valid_number, '東京情報大学');
ok($zip->set_number('2668550')->is_valid_number, '千葉市 緑保健福祉センター');
ok($zip->set_number('2668733')->is_valid_number, '千葉市緑区役所');
ok($zip->set_number('2700192')->is_valid_number, '流山市役所');
ok($zip->set_number('2700198')->is_valid_number, '江戸川学園(江戸川大学・江戸川短期大学・江戸川大学総合福祉専門学校)');
ok($zip->set_number('2701192')->is_valid_number, '我孫子市役所');
ok($zip->set_number('2701194')->is_valid_number, '財団法人 電力中央研究所');
ok($zip->set_number('2701196')->is_valid_number, '中央学院大学');
ok($zip->set_number('2701198')->is_valid_number, '日本電気 株式会社 我孫子事業場');
ok($zip->set_number('2701381')->is_valid_number, '三井住友海上火災保険 株式会社');
ok($zip->set_number('2701382')->is_valid_number, '東京電機大学 千葉ニュータウンキャンパス');
ok($zip->set_number('2701383')->is_valid_number, 'フコク生命 千葉ニュータウン本社');
ok($zip->set_number('2701385')->is_valid_number, 'イオンリテール 株式会社 ジャスコ千葉ニュータウン店');
ok($zip->set_number('2701387')->is_valid_number, '印西地区消防組合');
ok($zip->set_number('2701392')->is_valid_number, 'イオン 千葉ニュータウン ショッピングセンター');
ok($zip->set_number('2701393')->is_valid_number, 'みずほ銀行');
ok($zip->set_number('2701395')->is_valid_number, '(株) 竹中工務店 技術研究所');
ok($zip->set_number('2701396')->is_valid_number, '印西市役所');
ok($zip->set_number('2701398')->is_valid_number, 'ソフトバンクテレコム 株式会社');
ok($zip->set_number('2701492')->is_valid_number, '白井市役所');
ok($zip->set_number('2701493')->is_valid_number, '社会保険大学校');
ok($zip->set_number('2701495')->is_valid_number, 'フクダ電子 (株)');
ok($zip->set_number('2701496')->is_valid_number, '信組情報サービス (株)');
ok($zip->set_number('2701592')->is_valid_number, '栄町役場');
ok($zip->set_number('2701693')->is_valid_number, '印西市役所 印旛支所');
ok($zip->set_number('2701694')->is_valid_number, '日本医科大学 千葉北総病院');
ok($zip->set_number('2701695')->is_valid_number, '順天堂大学');
ok($zip->set_number('2702280')->is_valid_number, 'マブチモーター 株式会社');
ok($zip->set_number('2702288')->is_valid_number, '陸上自衛隊 松戸駐屯地');
ok($zip->set_number('2702292')->is_valid_number, 'よしざわ 株式会社');
ok($zip->set_number('2702295')->is_valid_number, '日立粉末冶金 株式会社');
ok($zip->set_number('2702297')->is_valid_number, '株式会社 吉野工業所 松戸工場');
ok($zip->set_number('2702298')->is_valid_number, 'ウェル・エイジングプラザ松戸ニッセイエデンの園');
ok($zip->set_number('2702392')->is_valid_number, '印西市役所 本埜支所');
ok($zip->set_number('2702393')->is_valid_number, 'マブチモーター');
ok($zip->set_number('2708501')->is_valid_number, '株式会社 マツモトキヨシ');
ok($zip->set_number('2708511')->is_valid_number, '株式会社 マツモトキヨシホールディングス');
ok($zip->set_number('2708521')->is_valid_number, '株式会社 マツモトキヨシホールディングス 本社別館');
ok($zip->set_number('2708555')->is_valid_number, '流通経済大学');
ok($zip->set_number('2708625')->is_valid_number, '二光 株式会社');
ok($zip->set_number('2718501')->is_valid_number, '大和証券 株式会社 松戸支店');
ok($zip->set_number('2718510')->is_valid_number, '千葉大学 園芸学部');
ok($zip->set_number('2718511')->is_valid_number, '国保松戸市立病院');
ok($zip->set_number('2718515')->is_valid_number, '千歳電気工業 株式会社 鉄道本部');
ok($zip->set_number('2718518')->is_valid_number, '千葉地方法務局 松戸支局');
ok($zip->set_number('2718522')->is_valid_number, '千葉地方裁判所 松戸支部');
ok($zip->set_number('2718533')->is_valid_number, '松戸税務署');
ok($zip->set_number('2718550')->is_valid_number, '伊勢丹 松戸店');
ok($zip->set_number('2718551')->is_valid_number, '聖徳大学 (10号館)');
ok($zip->set_number('2718555')->is_valid_number, '聖徳大学');
ok($zip->set_number('2718557')->is_valid_number, '松戸警察署');
ok($zip->set_number('2718560')->is_valid_number, '千葉県東葛飾県民センター');
ok($zip->set_number('2718562')->is_valid_number, '松戸健康福祉センター');
ok($zip->set_number('2718563')->is_valid_number, '千葉県教育庁 東葛飾教育事務所');
ok($zip->set_number('2718564')->is_valid_number, '千葉県松戸県税事務所');
ok($zip->set_number('2718580')->is_valid_number, '山崎製パン 株式会社松戸工場');
ok($zip->set_number('2718585')->is_valid_number, '専修大学 松戸高等学校');
ok($zip->set_number('2718588')->is_valid_number, '松戸市役所');
ok($zip->set_number('2718620')->is_valid_number, '松戸市農業協同組合');
ok($zip->set_number('2718625')->is_valid_number, '日興コーディアル証券 株式会社 松戸支店');
ok($zip->set_number('2718666')->is_valid_number, '関東つくば銀行 松戸支店');
ok($zip->set_number('2718672')->is_valid_number, '商工組合中央金庫 松戸支店');
ok($zip->set_number('2720192')->is_valid_number, '市川市役所 行徳支所');
ok($zip->set_number('2728501')->is_valid_number, '市川市役所');
ok($zip->set_number('2728511')->is_valid_number, '市川簡易裁判所千葉家庭裁判所 市川出張所');
ok($zip->set_number('2728512')->is_valid_number, '学校法人 千葉学園');
ok($zip->set_number('2728513')->is_valid_number, '東京歯科大学市川総合病院');
ok($zip->set_number('2728516')->is_valid_number, '国立精神・神経センター国府台病院');
ok($zip->set_number('2728518')->is_valid_number, '株式会社 市進');
ok($zip->set_number('2728520')->is_valid_number, '千葉県立市川工業高等学校');
ok($zip->set_number('2728522')->is_valid_number, '市川商工会議所');
ok($zip->set_number('2728533')->is_valid_number, '和洋学園');
ok($zip->set_number('2728538')->is_valid_number, '株式会社 スズキ技研');
ok($zip->set_number('2728543')->is_valid_number, '市川公共職業安定所');
ok($zip->set_number('2728550')->is_valid_number, 'ユトー 株式会社');
ok($zip->set_number('2728555')->is_valid_number, '財団法人 市川市文化振興財団');
ok($zip->set_number('2728558')->is_valid_number, 'TDK 株式会社 テクニカルセンター');
ok($zip->set_number('2728560')->is_valid_number, '筑波大学付属聴覚特別支援学校');
ok($zip->set_number('2728561')->is_valid_number, '本八幡ビル 株式会社');
ok($zip->set_number('2728573')->is_valid_number, '市川税務署');
ok($zip->set_number('2728580')->is_valid_number, '京葉瓦斯 株式会社');
ok($zip->set_number('2728585')->is_valid_number, '市川よみうり新聞社');
ok($zip->set_number('2728588')->is_valid_number, '住友金属鉱山 株式会社 技術本部中央研究所');
ok($zip->set_number('2730192')->is_valid_number, '新京成電鉄 株式会社');
ok($zip->set_number('2730193')->is_valid_number, '茂野製麺');
ok($zip->set_number('2730195')->is_valid_number, '鎌ケ谷市役所');
ok($zip->set_number('2730197')->is_valid_number, 'イオン鎌ヶ谷ショッピングセンター');
ok($zip->set_number('2738501')->is_valid_number, '船橋市役所');
ok($zip->set_number('2738502')->is_valid_number, '日鉄鋼板 株式会社 船橋製造所');
ok($zip->set_number('2738503')->is_valid_number, '東京都生コンクリート工業組合');
ok($zip->set_number('2738504')->is_valid_number, '船橋市役所 分庁舎');
ok($zip->set_number('2738505')->is_valid_number, '船橋ケーブルネットワーク 株式会社');
ok($zip->set_number('2738508')->is_valid_number, '株式会社 ぱど 船橋営業所');
ok($zip->set_number('2738510')->is_valid_number, '伊藤ハムフードソリューション');
ok($zip->set_number('2738511')->is_valid_number, '船橋商工会議所');
ok($zip->set_number('2738512')->is_valid_number, '渡辺パイプ 株式会社');
ok($zip->set_number('2738515')->is_valid_number, '株式会社 東京スター銀行 船橋支店');
ok($zip->set_number('2738520')->is_valid_number, '社会保険 船橋保健看護専門学校');
ok($zip->set_number('2738521')->is_valid_number, 'ニツスイ工業 株式会社');
ok($zip->set_number('2738522')->is_valid_number, 'フジフーズ 株式会社');
ok($zip->set_number('2738523')->is_valid_number, 'サンケイリビング新聞社');
ok($zip->set_number('2738530')->is_valid_number, 'ららぽーと TOKYO-BAY');
ok($zip->set_number('2738533')->is_valid_number, '京葉瓦斯 株式会社 船橋支社');
ok($zip->set_number('2738540')->is_valid_number, '財団法人 復光会総武病院');
ok($zip->set_number('2738542')->is_valid_number, '杉山金属印刷 株式会社');
ok($zip->set_number('2738543')->is_valid_number, '岡本 株式会社');
ok($zip->set_number('2738550')->is_valid_number, '西武百貨店 船橋店');
ok($zip->set_number('2738551')->is_valid_number, 'ユアサ・フナショク 株式会社');
ok($zip->set_number('2738555')->is_valid_number, '京葉住設 株式会社');
ok($zip->set_number('2738556')->is_valid_number, '社会保険船橋中央病院');
ok($zip->set_number('2738558')->is_valid_number, '千葉地方法務局 船橋支局');
ok($zip->set_number('2738560')->is_valid_number, '葛南県民センター');
ok($zip->set_number('2738566')->is_valid_number, '社会保険看護研修センター');
ok($zip->set_number('2738567')->is_valid_number, '株式会社 東武百貨店 船橋店');
ok($zip->set_number('2738570')->is_valid_number, '日本中央競馬会 中山競馬場');
ok($zip->set_number('2738574')->is_valid_number, '船橋税務署');
ok($zip->set_number('2738584')->is_valid_number, 'ロイヤル 株式会社');
ok($zip->set_number('2738585')->is_valid_number, 'ららぽーとマネジメント 株式会社');
ok($zip->set_number('2738588')->is_valid_number, '船橋市立医療センター');
ok($zip->set_number('2738601')->is_valid_number, '石井食品 株式会社');
ok($zip->set_number('2738627')->is_valid_number, 'ネクスト船橋');
ok($zip->set_number('2738733')->is_valid_number, 'ティーエルトレーディング');
ok($zip->set_number('2748501')->is_valid_number, '日本大学 理工学部');
ok($zip->set_number('2748503')->is_valid_number, '徳州会病院');
ok($zip->set_number('2748504')->is_valid_number, '日大習志野高校');
ok($zip->set_number('2748505')->is_valid_number, '積和不動産 株式会社');
ok($zip->set_number('2748506')->is_valid_number, '船橋二和病院');
ok($zip->set_number('2748507')->is_valid_number, '日産化学工業 株式会社');
ok($zip->set_number('2748510')->is_valid_number, '学校法人 東邦大学');
ok($zip->set_number('2748520')->is_valid_number, '瀧川化学工業 株式会社');
ok($zip->set_number('2748530')->is_valid_number, '日軽建材工業 株式会社');
ok($zip->set_number('2748533')->is_valid_number, '株式会社 高山 船橋営業所');
ok($zip->set_number('2748555')->is_valid_number, '日本大学 薬学部');
ok($zip->set_number('2748558')->is_valid_number, 'イオン 株式会社 ジャスコ高根木戸店');
ok($zip->set_number('2748577')->is_valid_number, '陸上自衛隊 習志野駐屯地');
ok($zip->set_number('2748585')->is_valid_number, '日東ベスト 株式会社');
ok($zip->set_number('2748601')->is_valid_number, '住友大阪セメント 株式会社');
ok($zip->set_number('2758501')->is_valid_number, '白井建設 株式会社');
ok($zip->set_number('2758511')->is_valid_number, '東邦大学付属東邦中学校・高等学校');
ok($zip->set_number('2758528')->is_valid_number, '大平洋機工 株式会社');
ok($zip->set_number('2758533')->is_valid_number, '天龍 株式会社');
ok($zip->set_number('2758560')->is_valid_number, 'セイコークロック 株式会社');
ok($zip->set_number('2758572')->is_valid_number, 'アシザワ・ファインテック 株式会社');
ok($zip->set_number('2758575')->is_valid_number, '日本大学 生産工学部');
ok($zip->set_number('2758576')->is_valid_number, '日本大学 生産工学部 実籾校舎');
ok($zip->set_number('2758577')->is_valid_number, '鈴木金属工業 株式会社');
ok($zip->set_number('2758585')->is_valid_number, '株式会社 ダーバン 物流東京センター');
ok($zip->set_number('2758588')->is_valid_number, '学校法人 千葉工業大学 津田沼校舎');
ok($zip->set_number('2758601')->is_valid_number, '習志野市役所');
ok($zip->set_number('2758611')->is_valid_number, '株式会社 日立産機システム 習志野事業所');
ok($zip->set_number('2758666')->is_valid_number, '習志野企業局');
ok($zip->set_number('2768501')->is_valid_number, '八千代市役所');
ok($zip->set_number('2768523')->is_valid_number, 'エドワーズ 株式会社');
ok($zip->set_number('2768524')->is_valid_number, '東京女子医科大学附属 八千代医療センター');
ok($zip->set_number('2768580')->is_valid_number, '石井食品 株式会社 八千代工場');
ok($zip->set_number('2778501')->is_valid_number, '株式会社 みずほ銀行 柏支店');
ok($zip->set_number('2778503')->is_valid_number, '柏市沼南庁舎');
ok($zip->set_number('2778504')->is_valid_number, '財務省 税関研修所');
ok($zip->set_number('2778505')->is_valid_number, '柏市役所');
ok($zip->set_number('2778507')->is_valid_number, '住友生命保険 相互会社 柏支社');
ok($zip->set_number('2778511')->is_valid_number, '株式会社 バンダイお客様相談センター');
ok($zip->set_number('2778515')->is_valid_number, '大機エンジニアリング 株式会社');
ok($zip->set_number('2778518')->is_valid_number, 'ららぽーと 柏の葉');
ok($zip->set_number('2778521')->is_valid_number, '株式会社 そごう 柏店');
ok($zip->set_number('2778522')->is_valid_number, '柏税務署');
ok($zip->set_number('2778531')->is_valid_number, '株式会社 DNPテクノフィルム');
ok($zip->set_number('2778533')->is_valid_number, '株式会社 トクシキ');
ok($zip->set_number('2778539')->is_valid_number, '三協フロンテア 株式会社');
ok($zip->set_number('2778550')->is_valid_number, '柏高島屋ステーションモール');
ok($zip->set_number('2778551')->is_valid_number, '柏厚生総合病院');
ok($zip->set_number('2778554')->is_valid_number, '柏警察署');
ok($zip->set_number('2778556')->is_valid_number, '昭和ゴム 株式会社');
ok($zip->set_number('2778557')->is_valid_number, 'パウダーテック 株式会社');
ok($zip->set_number('2778558')->is_valid_number, '千葉県 柏県税事務所');
ok($zip->set_number('2778561')->is_valid_number, '東京大学大学院 新領域創成科学研究科');
ok($zip->set_number('2778565')->is_valid_number, '株式会社 DNPテクノポリマー');
ok($zip->set_number('2778566')->is_valid_number, '読売旅行 柏営業所');
ok($zip->set_number('2778570')->is_valid_number, '千葉県立 東葛飾高等学校');
ok($zip->set_number('2778577')->is_valid_number, '国立がんセンター東病院');
ok($zip->set_number('2778581')->is_valid_number, '東京大学 物性研究所');
ok($zip->set_number('2778582')->is_valid_number, '東京大学 宇宙線研究所');
ok($zip->set_number('2778584')->is_valid_number, '東京大学 柏地区第2総合研究棟');
ok($zip->set_number('2778585')->is_valid_number, '二松学舎大学');
ok($zip->set_number('2778586')->is_valid_number, '伊藤ハム 株式会社 東京工場');
ok($zip->set_number('2778587')->is_valid_number, '独立行政法人 日本原子力研究開発機構 システム計算科学センター');
ok($zip->set_number('2778588')->is_valid_number, 'サンケイリビング新聞社 東葛本部');
ok($zip->set_number('2778654')->is_valid_number, '財団法人 モラロジー研究所');
ok($zip->set_number('2778655')->is_valid_number, '三井生命保険 株式会社 事務センター');
ok($zip->set_number('2778661')->is_valid_number, '下総航空基地');
ok($zip->set_number('2778666')->is_valid_number, '株式会社 高島屋 柏店');
ok($zip->set_number('2778686')->is_valid_number, '学校法人 廣池学園');
ok($zip->set_number('2788501')->is_valid_number, '小張総合病院');
ok($zip->set_number('2788510')->is_valid_number, '東京理科大学');
ok($zip->set_number('2788521')->is_valid_number, '宗教法人 霊波之光');
ok($zip->set_number('2788533')->is_valid_number, '協栄電気 株式会社 野田受注センター');
ok($zip->set_number('2788550')->is_valid_number, '野田市役所');
ok($zip->set_number('2788555')->is_valid_number, '窪田味噌醤油 株式会社');
ok($zip->set_number('2788577')->is_valid_number, 'カイト化学工業 株式会社');
ok($zip->set_number('2788601')->is_valid_number, 'キッコーマン飲料 株式会社');
ok($zip->set_number('2788601')->is_valid_number, 'キッコーマン食品 株式会社');
ok($zip->set_number('2788601')->is_valid_number, 'キッコーマンバイオケミファ 株式会社');
ok($zip->set_number('2788601')->is_valid_number, 'キッコーマンビジネスサービス 株式会社');
ok($zip->set_number('2788601')->is_valid_number, 'キッコーマン 株式会社');
ok($zip->set_number('2788686')->is_valid_number, '利根コカ・コーラボトリング 株式会社');
ok($zip->set_number('2798501')->is_valid_number, '浦安市役所');
ok($zip->set_number('2798502')->is_valid_number, 'ファウンテンテラスホテル');
ok($zip->set_number('2798503')->is_valid_number, 'パームテラスホテル');
ok($zip->set_number('2798505')->is_valid_number, '東京ディズニーランドホテル');
ok($zip->set_number('2798509')->is_valid_number, 'こどもPOST HOUSE');
ok($zip->set_number('2798511')->is_valid_number, '株式会社 オリエンタルランド');
ok($zip->set_number('2798516')->is_valid_number, '株式会社 Eプロダクション');
ok($zip->set_number('2798518')->is_valid_number, 'シルク・ドゥ・ソレイユ シアター東京');
ok($zip->set_number('2798521')->is_valid_number, '株式会社 舞浜コーポレーション');
ok($zip->set_number('2798522')->is_valid_number, '株式会社 舞浜リゾートホテル');
ok($zip->set_number('2798525')->is_valid_number, '株式会社 フォトワークス');
ok($zip->set_number('2798526')->is_valid_number, '株式会社 デザインファクトリー');
ok($zip->set_number('2798527')->is_valid_number, '株式会社 ベイフードサービス');
ok($zip->set_number('2798530')->is_valid_number, '東京電力 株式会社 市川浦安営業所');
ok($zip->set_number('2798541')->is_valid_number, '株式会社 パルタック 東京支社');
ok($zip->set_number('2798550')->is_valid_number, '明海大学');
ok($zip->set_number('2798553')->is_valid_number, '株式会社 リーガルコーポレーション');
ok($zip->set_number('2798555')->is_valid_number, '東レ 株式会社 第2本社');
ok($zip->set_number('2798558')->is_valid_number, '東海大学付属 浦安高等学校');
ok($zip->set_number('2798567')->is_valid_number, '学校法人 了徳寺大学');
ok($zip->set_number('2798585')->is_valid_number, '株式会社 ホテルオークラ東京ベイ');
ok($zip->set_number('2798588')->is_valid_number, '日本コープ共済生活協同組合連合会');
ok($zip->set_number('2798686')->is_valid_number, '株式会社 インシップ');
ok($zip->set_number('2828603')->is_valid_number, '成田税関支署');
ok($zip->set_number('2828610')->is_valid_number, '日本航空インターナショナル 成田空港支店');
ok($zip->set_number('2830195')->is_valid_number, '九十九里町役場');
ok($zip->set_number('2838501')->is_valid_number, '千葉県東金県税事務所');
ok($zip->set_number('2838511')->is_valid_number, '東金市役所');
ok($zip->set_number('2838555')->is_valid_number, '城西国際大学');
ok($zip->set_number('2838588')->is_valid_number, '千葉県立東金病院');
ok($zip->set_number('2838650')->is_valid_number, '医療法人 静和会 浅井病院');
ok($zip->set_number('2848555')->is_valid_number, '四街道市役所');
ok($zip->set_number('2858501')->is_valid_number, '佐倉市役所');
ok($zip->set_number('2858502')->is_valid_number, '国立歴史民俗博物館');
ok($zip->set_number('2858503')->is_valid_number, '北総県民センター');
ok($zip->set_number('2858510')->is_valid_number, '酒々井町役場');
ok($zip->set_number('2858511')->is_valid_number, '古河ユニック 株式会社 佐倉工場');
ok($zip->set_number('2858520')->is_valid_number, '千葉県 印旛健康福祉センター');
ok($zip->set_number('2858521')->is_valid_number, '株式会社 QVCジャパン');
ok($zip->set_number('2858522')->is_valid_number, '古河ユニック 株式会社 サービス部');
ok($zip->set_number('2858550')->is_valid_number, '株式会社 フジクラ 佐倉事業所');
ok($zip->set_number('2858567')->is_valid_number, '千葉敬愛短期大学');
ok($zip->set_number('2858585')->is_valid_number, 'TOTOバスクリエイト 株式会社');
ok($zip->set_number('2858586')->is_valid_number, '株式会社 広域高速ネット二九六');
ok($zip->set_number('2858588')->is_valid_number, '株式会社 ホソヤコーポレーション');
ok($zip->set_number('2858619')->is_valid_number, '佐倉市 八街市 酒々井町 消防組合');
ok($zip->set_number('2858650')->is_valid_number, '株式会社 ダイケン 千葉工場');
ok($zip->set_number('2858655')->is_valid_number, '太平洋セメント 株式会社 中央研究所');
ok($zip->set_number('2858765')->is_valid_number, '社会福祉法人 聖隷福祉事業団 聖隷佐倉市民病院');
ok($zip->set_number('2860292')->is_valid_number, '富里市役所');
ok($zip->set_number('2860293')->is_valid_number, 'ノースウエスト航空会社 予約部');
ok($zip->set_number('2868501')->is_valid_number, '成田税務署');
ok($zip->set_number('2868531')->is_valid_number, 'ホンダベルタ');
ok($zip->set_number('2868585')->is_valid_number, '成田市役所');
ok($zip->set_number('2868588')->is_valid_number, 'TDK 株式会社 成田工場');
ok($zip->set_number('2870292')->is_valid_number, '成田市役所 大栄支所');
ok($zip->set_number('2878501')->is_valid_number, '香取市役所');
ok($zip->set_number('2878502')->is_valid_number, '千葉県 北総県民センター 香取事務所');
ok($zip->set_number('2878503')->is_valid_number, '千葉県 佐原県税事務所');
ok($zip->set_number('2878510')->is_valid_number, '国土交通省 利根川下流河川事務所');
ok($zip->set_number('2878555')->is_valid_number, '佐原税務署');
ok($zip->set_number('2878585')->is_valid_number, '千葉社会保険事務局 佐原事務所');
ok($zip->set_number('2878601')->is_valid_number, '佐原信用金庫');
ok($zip->set_number('2888601')->is_valid_number, '銚子市役所');
ok($zip->set_number('2890192')->is_valid_number, '成田市 下総支所');
ok($zip->set_number('2890292')->is_valid_number, '神崎町役場');
ok($zip->set_number('2890392')->is_valid_number, 'アタリヤ農園');
ok($zip->set_number('2890393')->is_valid_number, '香取市役所 小見川区事務所');
ok($zip->set_number('2890394')->is_valid_number, 'ソニーイーエムシーエス 株式会社 小見川テック');
ok($zip->set_number('2890492')->is_valid_number, '香取市役所 山田区事務所');
ok($zip->set_number('2890592')->is_valid_number, '旭市 干潟支所');
ok($zip->set_number('2890692')->is_valid_number, '東庄町役場');
ok($zip->set_number('2891192')->is_valid_number, '八街市役所');
ok($zip->set_number('2891297')->is_valid_number, 'アルバックマテリアル 株式会社');
ok($zip->set_number('2891298')->is_valid_number, '山武市役所 山武支所');
ok($zip->set_number('2891392')->is_valid_number, '山武市役所');
ok($zip->set_number('2891592')->is_valid_number, '富士フイルムRIファーマ 株式会社 千葉事業所');
ok($zip->set_number('2891593')->is_valid_number, '山武市役所 松尾支所');
ok($zip->set_number('2891594')->is_valid_number, '千葉県立 松尾高等学校');
ok($zip->set_number('2891692')->is_valid_number, '芝山町役場');
ok($zip->set_number('2891693')->is_valid_number, '日本オーチス・エレベータ 株式会社');
ok($zip->set_number('2891792')->is_valid_number, '横芝光町役場 行政センター');
ok($zip->set_number('2891793')->is_valid_number, '横芝光町役場');
ok($zip->set_number('2892192')->is_valid_number, '匝瑳市役所 野栄総合支所');
ok($zip->set_number('2892197')->is_valid_number, 'タイヘイ 株式会社');
ok($zip->set_number('2892198')->is_valid_number, '匝瑳市役所');
ok($zip->set_number('2892292')->is_valid_number, '多古町役場');
ok($zip->set_number('2892595')->is_valid_number, '旭市役所');
ok($zip->set_number('2900192')->is_valid_number, '帝京平成短期大学');
ok($zip->set_number('2900193')->is_valid_number, '帝京平成大学');
ok($zip->set_number('2900194')->is_valid_number, 'unimoちはら台');
ok($zip->set_number('2908501')->is_valid_number, '市原市役所');
ok($zip->set_number('2908503')->is_valid_number, '丸善石油化学 株式会社 千葉工場');
ok($zip->set_number('2908510')->is_valid_number, '旭硝子エンジニアリング 株式会社');
ok($zip->set_number('2908511')->is_valid_number, '富士電機システムズ 株式会社 千葉工場');
ok($zip->set_number('2908530')->is_valid_number, '日本曹達 株式会社 千葉工場');
ok($zip->set_number('2908531')->is_valid_number, '三井造船 株式会社 千葉事業所');
ok($zip->set_number('2908550')->is_valid_number, '宇部興産 株式会社 千葉石油化学工場');
ok($zip->set_number('2908551')->is_valid_number, 'チッソ石油化学 株式会社 五井製造所');
ok($zip->set_number('2908555')->is_valid_number, '古河電気工業 株式会社 千葉事業所');
ok($zip->set_number('2908558')->is_valid_number, 'コスモ石油 株式会社 千葉製油所');
ok($zip->set_number('2908560')->is_valid_number, '協和発酵ケミカル 株式会社 千葉工場');
ok($zip->set_number('2908566')->is_valid_number, '旭硝子 株式会社 千葉工場');
ok($zip->set_number('2908577')->is_valid_number, '株式会社 ヒノックス');
ok($zip->set_number('2908585')->is_valid_number, '大日本インキ化学工業 株式会社 千葉工場');
ok($zip->set_number('2908588')->is_valid_number, '電気化学工業 株式会社 千葉工場');
ok($zip->set_number('2908610')->is_valid_number, '不二サッシ 株式会社 千葉工場');
ok($zip->set_number('2928501')->is_valid_number, '木更津市役所');
ok($zip->set_number('2928510')->is_valid_number, '陸上自衛隊 木更津駐屯地');
ok($zip->set_number('2928511')->is_valid_number, '学校法人 君津学園');
ok($zip->set_number('2928520')->is_valid_number, '千葉県南房総県民センター');
ok($zip->set_number('2928522')->is_valid_number, '東京電力 (株) 木更津支社');
ok($zip->set_number('2928525')->is_valid_number, '千葉県木更津県税事務所');
ok($zip->set_number('2928530')->is_valid_number, '日本年金機構 木更津年金事務所');
ok($zip->set_number('2928533')->is_valid_number, 'ソニーイーエムシーエス (株) 木更津テック');
ok($zip->set_number('2928535')->is_valid_number, '君津中央病院');
ok($zip->set_number('2928539')->is_valid_number, '山九 株式会社 君津支店');
ok($zip->set_number('2928550')->is_valid_number, '木更津税務署');
ok($zip->set_number('2928555')->is_valid_number, '学校法人 君津学園 清和大学');
ok($zip->set_number('2928565')->is_valid_number, '学校法人 暁星国際学園');
ok($zip->set_number('2928568')->is_valid_number, '学校法人 紅陵学院、志学館中・高等学校、拓殖大学紅陵高等学校');
ok($zip->set_number('2928611')->is_valid_number, '千葉信用金庫');
ok($zip->set_number('2928686')->is_valid_number, '海上自衛隊 航空補給処');
ok($zip->set_number('2938506')->is_valid_number, '富津市役所');
ok($zip->set_number('2938511')->is_valid_number, '新日本製鐡 株式会社 技術開発本部');
ok($zip->set_number('2948501')->is_valid_number, '海上自衛隊 館山航空基地');
ok($zip->set_number('2948502')->is_valid_number, 'ユー・エム・シー・ジャパン 株式会社');
ok($zip->set_number('2948503')->is_valid_number, '館山税務署');
ok($zip->set_number('2948601')->is_valid_number, '館山市役所');
ok($zip->set_number('2948701')->is_valid_number, '南房総市役所 三芳支所');
ok($zip->set_number('2950192')->is_valid_number, '南房総市役所 白浜支所');
ok($zip->set_number('2958601')->is_valid_number, '南房総市役所 千倉支所');
ok($zip->set_number('2960197')->is_valid_number, 'ヤスダファインテ 株式会社');
ok($zip->set_number('2968601')->is_valid_number, '鴨川市役所');
ok($zip->set_number('2968602')->is_valid_number, '医療法人 鉄蕉会 亀田総合病院');
ok($zip->set_number('2970192')->is_valid_number, '長南町役場');
ok($zip->set_number('2970193')->is_valid_number, '長南カントリークラブ');
ok($zip->set_number('2970194')->is_valid_number, 'ゴールデンクロスカントリークラブ');
ok($zip->set_number('2970195')->is_valid_number, 'トーヨーカントリークラブ');
ok($zip->set_number('2970196')->is_valid_number, '南茂原カントリークラブ');
ok($zip->set_number('2970197')->is_valid_number, 'アバイディングクラブ');
ok($zip->set_number('2970198')->is_valid_number, 'グレートアイランド倶楽部');
ok($zip->set_number('2970292')->is_valid_number, '大崎電気システムズ 株式会社 千葉工場');
ok($zip->set_number('2970298')->is_valid_number, '長柄町役場');
ok($zip->set_number('2978501')->is_valid_number, '茂原税務署');
ok($zip->set_number('2978511')->is_valid_number, '茂原市役所');
ok($zip->set_number('2978533')->is_valid_number, '千葉県東上総県民センター');
ok($zip->set_number('2978555')->is_valid_number, '東芝コンポーネンツ 株式会社');
ok($zip->set_number('2978558')->is_valid_number, '日本電信電話 株式会社 茂原支店');
ok($zip->set_number('2978567')->is_valid_number, '大多喜ガス 株式会社');
ok($zip->set_number('2978581')->is_valid_number, '株式会社 日立ディスプレイデバイシズ');
ok($zip->set_number('2978585')->is_valid_number, '株式会社 サカモト');
ok($zip->set_number('2978588')->is_valid_number, '双葉電子工業 株式会社');
ok($zip->set_number('2978611')->is_valid_number, '房総信用組合');
ok($zip->set_number('2978622')->is_valid_number, '株式会社 日立ディスプレイズ');
ok($zip->set_number('2978666')->is_valid_number, '三井東圧化学 株式会社 千葉工業所');
ok($zip->set_number('2980292')->is_valid_number, '大多喜町役場');
ok($zip->set_number('2980295')->is_valid_number, '平林物産 株式会社');
ok($zip->set_number('2980296')->is_valid_number, 'サンファーム 株式会社');
ok($zip->set_number('2980297')->is_valid_number, '三育学院短期大学');
ok($zip->set_number('2988501')->is_valid_number, 'いすみ市役所');
ok($zip->set_number('2990192')->is_valid_number, '出光興産 株式会社 千葉製油所');
ok($zip->set_number('2990193')->is_valid_number, '出光石油化学 株式会社 千葉工場');
ok($zip->set_number('2990194')->is_valid_number, '出光エンジニアリング 株式会社 千葉事業所');
ok($zip->set_number('2990195')->is_valid_number, '住友化学工業 株式会社 千葉工場');
ok($zip->set_number('2990198')->is_valid_number, '出光千葉建設保全協力会センター');
ok($zip->set_number('2990292')->is_valid_number, '袖ケ浦市役所');
ok($zip->set_number('2990293')->is_valid_number, '出光興産 株式会社 先進技術研究所');
ok($zip->set_number('2990295')->is_valid_number, '住友化学 株式会社 千葉工場');
ok($zip->set_number('2990296')->is_valid_number, '株式会社 荏原製作所 袖ヶ浦事業所');
ok($zip->set_number('2990297')->is_valid_number, '旭化成ケミカルズ 株式会社 川崎製造所 千葉工場');
ok($zip->set_number('2990298')->is_valid_number, '社会福祉法人 千葉県社会福祉事業団');
ok($zip->set_number('2991192')->is_valid_number, '君津市役所');
ok($zip->set_number('2991193')->is_valid_number, '新日本製鐵 株式会社 君津製鐵所');
ok($zip->set_number('2991194')->is_valid_number, '株式会社 日鉄エレックス 君津支店');
ok($zip->set_number('2991195')->is_valid_number, '三島光産 株式会社 鉄鋼事業本部');
ok($zip->set_number('2992192')->is_valid_number, '鋸南町役場');
ok($zip->set_number('2992292')->is_valid_number, '南房総市役所 富山支所');
ok($zip->set_number('2992492')->is_valid_number, '南房総市役所');
ok($zip->set_number('2992592')->is_valid_number, '南房総市役所 丸山分庁舎・丸山支所');
ok($zip->set_number('2992792')->is_valid_number, '南房総市役所 和田支所');
ok($zip->set_number('2992795')->is_valid_number, '安房拓心高等学校');
ok($zip->set_number('2993292')->is_valid_number, '大網白里町役場');
ok($zip->set_number('2994192')->is_valid_number, '公立長生病院');
ok($zip->set_number('2994292')->is_valid_number, '白子町役場');
ok($zip->set_number('2994392')->is_valid_number, 'ホテル一宮シーサイドオーツカ');
ok($zip->set_number('2994394')->is_valid_number, '長生村役場');
ok($zip->set_number('2994395')->is_valid_number, '双葉電子工業 株式会社');
ok($zip->set_number('2994396')->is_valid_number, '一宮町役場');
ok($zip->set_number('2994492')->is_valid_number, '睦沢町役場');
ok($zip->set_number('2994493')->is_valid_number, '房総カントリークラブ');
ok($zip->set_number('2994692')->is_valid_number, 'いすみ市役所 岬庁舎');
ok($zip->set_number('2995192')->is_valid_number, '御宿町役場');
ok($zip->set_number('2995292')->is_valid_number, '勝浦市役所');
ok($zip->set_number('2995295')->is_valid_number, '国際武道大学');
ok($zip->set_number('3000192')->is_valid_number, 'かすみがうら市総務部霞ケ浦庁舎');
ok($zip->set_number('3000193')->is_valid_number, '株式会社 三喜つくば流通センター');
ok($zip->set_number('3000392')->is_valid_number, '阿見町役場');
ok($zip->set_number('3000393')->is_valid_number, '茨城大学 農学部');
ok($zip->set_number('3000394')->is_valid_number, '茨城県立医療大学');
ok($zip->set_number('3000395')->is_valid_number, '東京医科大学 霞ケ浦病院');
ok($zip->set_number('3000396')->is_valid_number, 'デンセイ・ラムダ 株式会社 筑波事業所');
ok($zip->set_number('3000397')->is_valid_number, '三菱化学 (株) 科学技術戦略室 筑波センター');
ok($zip->set_number('3000398')->is_valid_number, '協和発酵フーズ 株式会社 土浦工場');
ok($zip->set_number('3000492')->is_valid_number, '美浦村役場');
ok($zip->set_number('3000496')->is_valid_number, '日本テキサスインスツルメンツ 株式会社');
ok($zip->set_number('3000593')->is_valid_number, '茨城県土浦県税事務所 稲敷支所');
ok($zip->set_number('3000595')->is_valid_number, '稲敷市役所');
ok($zip->set_number('3000692')->is_valid_number, '稲敷市役所桜川庁舎');
ok($zip->set_number('3000792')->is_valid_number, '稲敷市役所 東庁舎');
ok($zip->set_number('3001192')->is_valid_number, '株式会社 ツムラ 茨城工場');
ok($zip->set_number('3001193')->is_valid_number, '株式会社 長崎屋 荒川沖店');
ok($zip->set_number('3001195')->is_valid_number, 'キヤノン 株式会社 阿見事業所');
ok($zip->set_number('3001292')->is_valid_number, '牛久市役所');
ok($zip->set_number('3001293')->is_valid_number, 'つくば市役所 茎崎庁舎');
ok($zip->set_number('3001294')->is_valid_number, 'キヤノン化成 株式会社 本社筑波事業所');
ok($zip->set_number('3001295')->is_valid_number, '三菱化学 株式会社 筑波事業所');
ok($zip->set_number('3001296')->is_valid_number, '牛久愛和総合病院');
ok($zip->set_number('3001392')->is_valid_number, '河内町役場');
ok($zip->set_number('3001492')->is_valid_number, '稲敷市役所 新利根庁舎');
ok($zip->set_number('3001696')->is_valid_number, '利根町役場');
ok($zip->set_number('3002395')->is_valid_number, 'つくばみらい市役所 伊奈庁舎');
ok($zip->set_number('3002492')->is_valid_number, 'つくばみらい市役所 谷和原庁舎');
ok($zip->set_number('3002493')->is_valid_number, 'SMC 株式会社 筑波技術センター');
ok($zip->set_number('3002494')->is_valid_number, 'トーソー 株式会社');
ok($zip->set_number('3002495')->is_valid_number, 'ピジョン 株式会社 常総研究所');
ok($zip->set_number('3002496')->is_valid_number, '日立マクセル 株式会社');
ok($zip->set_number('3002497')->is_valid_number, '不二製油 株式会社 つくば開発研究センター');
ok($zip->set_number('3002498')->is_valid_number, '丸井加工 株式会社');
ok($zip->set_number('3002593')->is_valid_number, 'SMC 株式会社 筑波工場');
ok($zip->set_number('3002595')->is_valid_number, '日立マクセル 株式会社 筑波事業所');
ok($zip->set_number('3002686')->is_valid_number, '長瀬ランダウア 株式会社');
ok($zip->set_number('3002695')->is_valid_number, 'インテルジャパン 株式会社');
ok($zip->set_number('3002698')->is_valid_number, 'アステラス製薬 株式会社 東光台研究センター');
ok($zip->set_number('3002792')->is_valid_number, '常総市 石下総合福祉センター');
ok($zip->set_number('3002793')->is_valid_number, '常総市役所 石下庁舎');
ok($zip->set_number('3002795')->is_valid_number, '三菱マテリアル 株式会社 筑波製作所');
ok($zip->set_number('3002797')->is_valid_number, '常総市 石下総合運動公園 スポーツ振興課');
ok($zip->set_number('3002798')->is_valid_number, 'キヤノン化成 株式会社 石下工場');
ok($zip->set_number('3003292')->is_valid_number, 'つくば市大穂庁舎');
ok($zip->set_number('3003294')->is_valid_number, '住友化学 株式会社 筑波研究所');
ok($zip->set_number('3003295')->is_valid_number, '医療法人 健佑会');
ok($zip->set_number('3003592')->is_valid_number, '八千代町役場');
ok($zip->set_number('3003595')->is_valid_number, '理化工業 株式会社');
ok($zip->set_number('3003598')->is_valid_number, 'ヤマダイ 株式会社');
ok($zip->set_number('3004192')->is_valid_number, '土浦市役所 新治庁舎');
ok($zip->set_number('3004193')->is_valid_number, 'エポック社');
ok($zip->set_number('3004293')->is_valid_number, '武田薬品工業 株式会社');
ok($zip->set_number('3004295')->is_valid_number, '株式会社 マルハニチロホールディングス 中央研究所');
ok($zip->set_number('3004495')->is_valid_number, '桜川市役所 真壁庁舎');
ok($zip->set_number('3004598')->is_valid_number, '筑西市役所明野支所');
ok($zip->set_number('3008550')->is_valid_number, 'オリエンタルモーター 株式会社 土浦事業所');
ok($zip->set_number('3008567')->is_valid_number, '土浦簡易裁判所');
ok($zip->set_number('3008567')->is_valid_number, '土浦検察審査会');
ok($zip->set_number('3008567')->is_valid_number, '水戸家庭裁判所 土浦支部');
ok($zip->set_number('3008567')->is_valid_number, '水戸地方裁判所 土浦支部');
ok($zip->set_number('3008588')->is_valid_number, 'ボッシュ・レックスロス 株式会社');
ok($zip->set_number('3008601')->is_valid_number, '土浦税務署');
ok($zip->set_number('3008619')->is_valid_number, '陸上自衛隊 霞ヶ浦駐屯地');
ok($zip->set_number('3008686')->is_valid_number, '土浦市役所');
ok($zip->set_number('3018501')->is_valid_number, 'TCM 株式会社 竜ヶ崎工場');
ok($zip->set_number('3018505')->is_valid_number, 'イセデリカ (株)');
ok($zip->set_number('3018555')->is_valid_number, '流通経済大学');
ok($zip->set_number('3018601')->is_valid_number, '竜ヶ崎税務署');
ok($zip->set_number('3018602')->is_valid_number, '株式会社 龍ケ崎カントリー倶楽部');
ok($zip->set_number('3018610')->is_valid_number, '日立ライティング 株式会社 竜ケ崎事業所');
ok($zip->set_number('3018611')->is_valid_number, '龍ケ崎市役所');
ok($zip->set_number('3020192')->is_valid_number, '明星電気 株式会社 守谷工場');
ok($zip->set_number('3020198')->is_valid_number, '守谷市役所');
ok($zip->set_number('3028501')->is_valid_number, 'キヤノン 株式会社 取手事業所');
ok($zip->set_number('3028502')->is_valid_number, 'キリンビール 株式会社 取手工場');
ok($zip->set_number('3028585')->is_valid_number, '取手市役所');
ok($zip->set_number('3038501')->is_valid_number, '常総市役所');
ok($zip->set_number('3038503')->is_valid_number, 'キヤノンファインテック 株式会社');
ok($zip->set_number('3048501')->is_valid_number, '下妻市役所');
ok($zip->set_number('3048601')->is_valid_number, '株式会社 関東つくば銀行 下妻営業部');
ok($zip->set_number('3058501')->is_valid_number, '日本電気 株式会社 筑波研究所');
ok($zip->set_number('3058504')->is_valid_number, 'クリタ分析センター 株式会社');
ok($zip->set_number('3058506')->is_valid_number, '独立行政法人 国立環境研究所');
ok($zip->set_number('3058515')->is_valid_number, '関彰商事 株式会社');
ok($zip->set_number('3058516')->is_valid_number, '独立行政法人 土木研究所');
ok($zip->set_number('3058520')->is_valid_number, '国立大学法人 筑波技術大学 天久保キャンパス');
ok($zip->set_number('3058521')->is_valid_number, '国立大学法人 筑波技術大学 春日キャンパス');
ok($zip->set_number('3058555')->is_valid_number, 'つくば市役所');
ok($zip->set_number('3058561')->is_valid_number, '独立行政法人 産業技術総合研究所 つくば中央第1事業所');
ok($zip->set_number('3058562')->is_valid_number, '独立行政法人 産業技術総合研究所 つくば中央第4事業所');
ok($zip->set_number('3058563')->is_valid_number, '独立行政法人 産業技術総合研究所 つくば中央第3事業所');
ok($zip->set_number('3058564')->is_valid_number, '独立行政法人 産業技術総合研究所 つくば東事業所');
ok($zip->set_number('3058565')->is_valid_number, '独立行政法人 産業技術総合研究所 つくば中央第5事業所');
ok($zip->set_number('3058566')->is_valid_number, '独立行政法人 産業技術総合研究所 つくば中央第6事業所');
ok($zip->set_number('3058567')->is_valid_number, '独立行政法人 産業技術総合研究所 つくば中央第7事業所');
ok($zip->set_number('3058568')->is_valid_number, '独立行政法人 産業技術総合研究所 つくば中央第2事業所');
ok($zip->set_number('3058569')->is_valid_number, '独立行政法人 産業技術総合研究所 つくば西事業所');
ok($zip->set_number('3058585')->is_valid_number, 'アステラス製薬 株式会社 御幸が丘研究センター');
ok($zip->set_number('3058588')->is_valid_number, 'つくば市上下水道部');
ok($zip->set_number('3058601')->is_valid_number, '農林水産技術会議事務局 筑波事務所');
ok($zip->set_number('3058602')->is_valid_number, '独立行政法人 農業生物資源研究所');
ok($zip->set_number('3058642')->is_valid_number, '独立行政法人 食品総合研究所');
ok($zip->set_number('3058686')->is_valid_number, '国際農林水産業研究センター');
ok($zip->set_number('3058687')->is_valid_number, '独立行政法人 森林総合研究所');
ok($zip->set_number('3060392')->is_valid_number, '五霞町役場');
ok($zip->set_number('3060492')->is_valid_number, '株式会社 アサヒペン 関東流通センター');
ok($zip->set_number('3060493')->is_valid_number, '旭化成建材 株式会社 境工場');
ok($zip->set_number('3060495')->is_valid_number, '境町役場');
ok($zip->set_number('3060497')->is_valid_number, '日本たばこ産業 (株) 食品事業本部 品質保証室');
ok($zip->set_number('3060595')->is_valid_number, '坂東市役所 猿島庁舎');
ok($zip->set_number('3060692')->is_valid_number, '坂東市役所 岩井庁舎');
ok($zip->set_number('3068601')->is_valid_number, '古河市役所');
ok($zip->set_number('3068686')->is_valid_number, '古河税務署');
ok($zip->set_number('3078501')->is_valid_number, '結城市役所');
ok($zip->set_number('3078502')->is_valid_number, '結城市教育委員会');
ok($zip->set_number('3078601')->is_valid_number, '結城信用金庫');
ok($zip->set_number('3080193')->is_valid_number, 'ソレクトロン 株式会社');
ok($zip->set_number('3080194')->is_valid_number, '筑西市役所関城支所');
ok($zip->set_number('3088510')->is_valid_number, '茨城県県西県民センター');
ok($zip->set_number('3088511')->is_valid_number, '茨城県 筑西県税事務所');
ok($zip->set_number('3088512')->is_valid_number, '関彰商事 株式会社');
ok($zip->set_number('3088513')->is_valid_number, '日本ハム 株式会社 茨城工場');
ok($zip->set_number('3088521')->is_valid_number, '日立化成工業 株式会社 下館事業所');
ok($zip->set_number('3088522')->is_valid_number, '日本コンクリート工業 株式会社 川島工場');
ok($zip->set_number('3088523')->is_valid_number, '株式会社 日立ハウステック 結城工場');
ok($zip->set_number('3088524')->is_valid_number, '日立化成工業 株式会社 五所宮事業所');
ok($zip->set_number('3088540')->is_valid_number, '東京電力 株式会社 下館支社');
ok($zip->set_number('3088608')->is_valid_number, '下館税務署');
ok($zip->set_number('3088616')->is_valid_number, '筑西市役所');
ok($zip->set_number('3088638')->is_valid_number, '株式会社 MCC');
ok($zip->set_number('3091192')->is_valid_number, '筑西市役所 協和支所');
ok($zip->set_number('3091195')->is_valid_number, '協和中央病院');
ok($zip->set_number('3091292')->is_valid_number, '桜川市役所 岩瀬庁舎');
ok($zip->set_number('3091293')->is_valid_number, '桜川市役所');
ok($zip->set_number('3091294')->is_valid_number, '茨城県立 岩瀬高等学校');
ok($zip->set_number('3091295')->is_valid_number, '県西総合病院');
ok($zip->set_number('3091296')->is_valid_number, '岩崎電気 株式会社');
ok($zip->set_number('3091297')->is_valid_number, '株式会社 スミハツ');
ok($zip->set_number('3091698')->is_valid_number, '笠間市役所 笠間支所');
ok($zip->set_number('3091792')->is_valid_number, '笠間市役所');
ok($zip->set_number('3091793')->is_valid_number, '茨城県立 中央病院');
ok($zip->set_number('3108282')->is_valid_number, '株式会社 関西ケーズデンキ');
ok($zip->set_number('3108282')->is_valid_number, '株式会社 九州ケーズデンキ');
ok($zip->set_number('3108282')->is_valid_number, '株式会社 ケーズホールディングス');
ok($zip->set_number('3108282')->is_valid_number, '株式会社 デジックスケーズ');
ok($zip->set_number('3108282')->is_valid_number, '株式会社 マックスブロードバンド');
ok($zip->set_number('3108501')->is_valid_number, '財団法人 茨城県総合健診協会');
ok($zip->set_number('3108502')->is_valid_number, '全国健康保険協会 茨城支部');
ok($zip->set_number('3108505')->is_valid_number, '株式会社 茨城放送');
ok($zip->set_number('3108511')->is_valid_number, '茨城労働局');
ok($zip->set_number('3108512')->is_valid_number, '茨城大学');
ok($zip->set_number('3108520')->is_valid_number, '三菱ふそうトラック・バス 株式会社 茨城ふそう 水戸支店');
ok($zip->set_number('3108522')->is_valid_number, 'UFJニコス 株式会社');
ok($zip->set_number('3108525')->is_valid_number, '昭和建設 株式会社');
ok($zip->set_number('3108528')->is_valid_number, 'ビクター アドバンスト メディア (株)');
ok($zip->set_number('3108533')->is_valid_number, '日本エー・エム・ピー 株式会社 水戸営業所');
ok($zip->set_number('3108536')->is_valid_number, '株式会社 NTTドコモ 茨城支店');
ok($zip->set_number('3108540')->is_valid_number, '水戸地方検察庁');
ok($zip->set_number('3108550')->is_valid_number, '茨城県警察本部');
ok($zip->set_number('3108551')->is_valid_number, '水戸警察署');
ok($zip->set_number('3108555')->is_valid_number, '茨城県庁');
ok($zip->set_number('3108558')->is_valid_number, '東日本電信電話 株式会社 茨城支店');
ok($zip->set_number('3108567')->is_valid_number, '日本放送協会 水戸放送局');
ok($zip->set_number('3108577')->is_valid_number, '株式会社 茨城銀行');
ok($zip->set_number('3108581')->is_valid_number, '財団法人 茨城県メディカルセンター');
ok($zip->set_number('3108585')->is_valid_number, '常磐大学');
ok($zip->set_number('3108588')->is_valid_number, '茨城県教育庁');
ok($zip->set_number('3108601')->is_valid_number, '大和證券 株式会社 水戸支店');
ok($zip->set_number('3108602')->is_valid_number, '日本生命保険 相互会社 水戸支社');
ok($zip->set_number('3108604')->is_valid_number, '株式会社 常陽銀行 本店');
ok($zip->set_number('3108610')->is_valid_number, '水戸市役所');
ok($zip->set_number('3108611')->is_valid_number, '茨城銀行 本店');
ok($zip->set_number('3108616')->is_valid_number, '茨城県信用農業 協同組合連合会');
ok($zip->set_number('3108622')->is_valid_number, '茨城県信用組合');
ok($zip->set_number('3108641')->is_valid_number, '(株) 奈良屋');
ok($zip->set_number('3108666')->is_valid_number, '水戸 税務署');
ok($zip->set_number('3108668')->is_valid_number, '茨城県共済農業協同組合連合会');
ok($zip->set_number('3108671')->is_valid_number, '読売新聞 水戸支局');
ok($zip->set_number('3108677')->is_valid_number, '商工組合 中央金庫 水戸支店');
ok($zip->set_number('3108686')->is_valid_number, '茨城新聞');
ok($zip->set_number('3108753')->is_valid_number, '茨城県 神社庁');
ok($zip->set_number('3110192')->is_valid_number, '那珂市役所');
ok($zip->set_number('3110193')->is_valid_number, '独立行政法人 日本原子力研究開発機構 那珂核融合研究所');
ok($zip->set_number('3110194')->is_valid_number, '株式会社 水戸ニコン');
ok($zip->set_number('3111392')->is_valid_number, '大洗町役場');
ok($zip->set_number('3111393')->is_valid_number, '独立行政法人 日本原子力研究開発機構 大洗研究開発センター');
ok($zip->set_number('3111492')->is_valid_number, '鉾田市役所 旭総合支所');
ok($zip->set_number('3111493')->is_valid_number, '千代田メインテナンス 株式会社');
ok($zip->set_number('3111592')->is_valid_number, '茨城県 鉾田市役所');
ok($zip->set_number('3111593')->is_valid_number, '茨城県 鹿行総合事務所');
ok($zip->set_number('3111792')->is_valid_number, '行方市役所 北浦庁舎');
ok($zip->set_number('3112492')->is_valid_number, '潮来税務署');
ok($zip->set_number('3112493')->is_valid_number, '潮来市役所');
ok($zip->set_number('3112495')->is_valid_number, '潮来市役所 牛堀支所');
ok($zip->set_number('3113192')->is_valid_number, '茨城町役場');
ok($zip->set_number('3113193')->is_valid_number, '独立行政法人 国立病院機構 水戸医療センター');
ok($zip->set_number('3113194')->is_valid_number, '三菱ふそうトラック・バス (株) 茨城ふそう');
ok($zip->set_number('3113195')->is_valid_number, '茨城県工業技術センター');
ok($zip->set_number('3113197')->is_valid_number, '茨城県警察本部 交通部運転免許センター');
ok($zip->set_number('3113492')->is_valid_number, '小美玉市役所 小川総合支所');
ok($zip->set_number('3113493')->is_valid_number, 'クレハプラスチックス 株式会社');
ok($zip->set_number('3113494')->is_valid_number, '航空自衛隊 百里基地');
ok($zip->set_number('3113497')->is_valid_number, 'ぺんてる 株式会社 茨城工場');
ok($zip->set_number('3113498')->is_valid_number, '丸玉産業');
ok($zip->set_number('3113892')->is_valid_number, '行方市役所');
ok($zip->set_number('3113893')->is_valid_number, '茨城県 行方県税事務所');
ok($zip->set_number('3113894')->is_valid_number, '茨城ライスミル 株式会社');
ok($zip->set_number('3114193')->is_valid_number, 'いばらきコープ生活 協同組合');
ok($zip->set_number('3114194')->is_valid_number, '茨城県教科書販売 株式会社');
ok($zip->set_number('3114195')->is_valid_number, '戸田産業 株式会社');
ok($zip->set_number('3114196')->is_valid_number, '株式会社 ケーシーエス');
ok($zip->set_number('3114198')->is_valid_number, '水戸済生会総合病院');
ok($zip->set_number('3114391')->is_valid_number, '城里町役場 本庁舎');
ok($zip->set_number('3114392')->is_valid_number, '茨城県立常北高等学校');
ok($zip->set_number('3114393')->is_valid_number, '株式会社 イトウ');
ok($zip->set_number('3114592')->is_valid_number, '常陸大宮市役所 御前山総合支所');
ok($zip->set_number('3114595')->is_valid_number, '城里町役場 桂支所');
ok($zip->set_number('3128501')->is_valid_number, 'ひたちなか市役所');
ok($zip->set_number('3128502')->is_valid_number, '日立工機 株式会社');
ok($zip->set_number('3128503')->is_valid_number, '日立製作所 オートモティブシステムグループ');
ok($zip->set_number('3128504')->is_valid_number, '株式会社 日立ハイテクノロジーズ');
ok($zip->set_number('3128505')->is_valid_number, '日立製作所 デジタルメディア事業部');
ok($zip->set_number('3128507')->is_valid_number, '日立協和エンジニアリング 株式会社');
ok($zip->set_number('3128508')->is_valid_number, '茨城工業高等専門学校');
ok($zip->set_number('3128511')->is_valid_number, '株式会社 日立ハイテクマニファクチャ&サービス');
ok($zip->set_number('3138511')->is_valid_number, '川崎病院');
ok($zip->set_number('3138555')->is_valid_number, '常陸河川国道事務所');
ok($zip->set_number('3138585')->is_valid_number, '武藤建設 株式会社');
ok($zip->set_number('3138611')->is_valid_number, '常陸太田市役所');
ok($zip->set_number('3138666')->is_valid_number, '茨城県常陸太田県税事務所');
ok($zip->set_number('3138686')->is_valid_number, '太田 税務署');
ok($zip->set_number('3140192')->is_valid_number, '神栖市役所');
ok($zip->set_number('3140193')->is_valid_number, '大日本インキ化学工業 株式会社 鹿島工場');
ok($zip->set_number('3140194')->is_valid_number, '昭和産業 株式会社 鹿島工場');
ok($zip->set_number('3140195')->is_valid_number, '旭硝子 株式会社 鹿島工場');
ok($zip->set_number('3140197')->is_valid_number, '株式会社 クラレ 鹿島工場');
ok($zip->set_number('3140198')->is_valid_number, '鹿島石油 株式会社 鹿島製油所');
ok($zip->set_number('3148501')->is_valid_number, '独立行政法人 情報通信研究機構 鹿島宇宙技術センター');
ok($zip->set_number('3148655')->is_valid_number, '鹿嶋市役所');
ok($zip->set_number('3150195')->is_valid_number, '八郷総合支所');
ok($zip->set_number('3158511')->is_valid_number, '東日電線 株式会社');
ok($zip->set_number('3158512')->is_valid_number, 'かすみがうら市役所 千代田庁舎');
ok($zip->set_number('3158522')->is_valid_number, '湖北水道企業団');
ok($zip->set_number('3158585')->is_valid_number, '東洋製罐 株式会社 石岡工場');
ok($zip->set_number('3158640')->is_valid_number, '石岡市役所');
ok($zip->set_number('3168501')->is_valid_number, '日立製作所 国分工場');
ok($zip->set_number('3168502')->is_valid_number, '日立製作所 電化機器事業部');
ok($zip->set_number('3168511')->is_valid_number, '茨城大学 工学部');
ok($zip->set_number('3168533')->is_valid_number, '医療法人 愛宣会 秦病院');
ok($zip->set_number('3178511')->is_valid_number, '株式会社 日立製作所 日立事業所');
ok($zip->set_number('3178555')->is_valid_number, '日立化成工業 株式会社 山崎事業所');
ok($zip->set_number('3178601')->is_valid_number, '日立市役所');
ok($zip->set_number('3178602')->is_valid_number, '日立 税務署');
ok($zip->set_number('3188511')->is_valid_number, '高萩市役所');
ok($zip->set_number('3190192')->is_valid_number, '小美玉市役所');
ok($zip->set_number('3190198')->is_valid_number, '横浜ゴム 株式会社 茨城工場');
ok($zip->set_number('3190292')->is_valid_number, '茨城県農業総合センター');
ok($zip->set_number('3190293')->is_valid_number, '加藤産業 株式会社 茨城支店');
ok($zip->set_number('3190294')->is_valid_number, '笠間市役所 岩間支所');
ok($zip->set_number('3190295')->is_valid_number, '株式会社 金陽社 茨城工場');
ok($zip->set_number('3190393')->is_valid_number, '水戸市役所 内原支所');
ok($zip->set_number('3190394')->is_valid_number, 'イオン 水戸内原ショッピングセンター');
ok($zip->set_number('3190395')->is_valid_number, 'ジャスコ 水戸内原店');
ok($zip->set_number('3190397')->is_valid_number, '茨城県神社庁');
ok($zip->set_number('3191184')->is_valid_number, '独立行政法人 日本原子力研究開発機構');
ok($zip->set_number('3191188')->is_valid_number, '東京大学大学院 工学系研究科 原子力専攻');
ok($zip->set_number('3191192')->is_valid_number, '東海村役場');
ok($zip->set_number('3191194')->is_valid_number, '独立行政法人 日本原子力研究開発機構 東海研究開発センター核燃料サイクル工学研究所');
ok($zip->set_number('3191195')->is_valid_number, '独立行政法人 日本原子力研究開発機構 東海研究開発センター原子力科学研究所');
ok($zip->set_number('3191196')->is_valid_number, '原子燃料工業 株式会社 東海事業所');
ok($zip->set_number('3191292')->is_valid_number, '株式会社 日立製作所 日立研究所');
ok($zip->set_number('3191293')->is_valid_number, '株式会社 日立製作所 情報制御システム事業部');
ok($zip->set_number('3191295')->is_valid_number, '茨城キリスト教学園');
ok($zip->set_number('3191393')->is_valid_number, '国民宿舎「鵜の岬」');
ok($zip->set_number('3191592')->is_valid_number, '北茨城市役所');
ok($zip->set_number('3191593')->is_valid_number, 'ユニマテック 株式会社');
ok($zip->set_number('3192692')->is_valid_number, '常陸大宮市役所美和総合所');
ok($zip->set_number('3193595')->is_valid_number, '大子町役場');
ok($zip->set_number('3208501')->is_valid_number, '栃木県庁');
ok($zip->set_number('3208502')->is_valid_number, 'NHK 宇都宮放送局');
ok($zip->set_number('3208503')->is_valid_number, 'とちぎ健康の森');
ok($zip->set_number('3208505')->is_valid_number, '宇都宮地方裁判所');
ok($zip->set_number('3208507')->is_valid_number, '住友生命保険 相互会社');
ok($zip->set_number('3208508')->is_valid_number, 'とちぎ福祉プラザ');
ok($zip->set_number('3208510')->is_valid_number, '栃木県警察本部');
ok($zip->set_number('3208511')->is_valid_number, '東京海上日動火災保険 株式会社 栃木支店');
ok($zip->set_number('3208512')->is_valid_number, '株式会社 下野新聞アドセンター');
ok($zip->set_number('3208514')->is_valid_number, '全国健康保険協会 栃木支部');
ok($zip->set_number('3208515')->is_valid_number, '宇都宮地方法務局');
ok($zip->set_number('3208517')->is_valid_number, '株式会社 栃木よみうり');
ok($zip->set_number('3208521')->is_valid_number, '医療法人 報徳会');
ok($zip->set_number('3208522')->is_valid_number, '栃木社会保険事務局');
ok($zip->set_number('3208523')->is_valid_number, '栃木日産自動車販売 株式会社');
ok($zip->set_number('3208525')->is_valid_number, '作新学院');
ok($zip->set_number('3208528')->is_valid_number, '株式会社 コジマ');
ok($zip->set_number('3208530')->is_valid_number, '財団法人 とちぎ生涯学習文化財団');
ok($zip->set_number('3208531')->is_valid_number, '(株) とちぎテレビ');
ok($zip->set_number('3208532')->is_valid_number, '財務省 関東財務局 宇都宮財務事務所');
ok($zip->set_number('3208533')->is_valid_number, '宇都宮ビジネス電子専門学校');
ok($zip->set_number('3208538')->is_valid_number, '宇都宮大学教育学部附属学校');
ok($zip->set_number('3208540')->is_valid_number, '宇都宮市役所');
ok($zip->set_number('3208541')->is_valid_number, 'トヨタウッドユーホーム 株式会社');
ok($zip->set_number('3208543')->is_valid_number, '宇都宮市上下水道局');
ok($zip->set_number('3208550')->is_valid_number, '株式会社 エフエム栃木');
ok($zip->set_number('3208551')->is_valid_number, '帝京大学 理工学部');
ok($zip->set_number('3208555')->is_valid_number, '栃木社会保険事務局 宇都宮西社会保険事務室');
ok($zip->set_number('3208558')->is_valid_number, '栃木県立 宇都宮工業高等学校');
ok($zip->set_number('3208560')->is_valid_number, '株式会社 東武宇都宮百貨店');
ok($zip->set_number('3208564')->is_valid_number, '富士重工業 株式会社 宇都宮製作所');
ok($zip->set_number('3208566')->is_valid_number, '株式会社 パルコ 宇都宮店');
ok($zip->set_number('3208567')->is_valid_number, '栃木マツダ販売 株式会社');
ok($zip->set_number('3208570')->is_valid_number, '(財) 宇都宮市文化会館管理公社');
ok($zip->set_number('3208577')->is_valid_number, '栃木県社会保険診療報酬支払基金');
ok($zip->set_number('3208580')->is_valid_number, '独立行政法人 国立病院機構 栃木病院');
ok($zip->set_number('3208585')->is_valid_number, '宇都宮短期大学附属高等学校');
ok($zip->set_number('3208588')->is_valid_number, '栃木トヨペット 株式会社');
ok($zip->set_number('3208601')->is_valid_number, '株式会社 栃木放送');
ok($zip->set_number('3208607')->is_valid_number, 'ダマール 株式会社 宇都宮オペレーションセンター');
ok($zip->set_number('3208610')->is_valid_number, '株式会社 足利銀行');
ok($zip->set_number('3208611')->is_valid_number, '大和証券 株式会社 宇都宮支店');
ok($zip->set_number('3208618')->is_valid_number, '栃木県信用保証協会');
ok($zip->set_number('3208620')->is_valid_number, '株式会社 足利銀行 宇都宮中央支店');
ok($zip->set_number('3208655')->is_valid_number, '宇都宮 税務署');
ok($zip->set_number('3208668')->is_valid_number, '商工組合 中央金庫 宇都宮支店');
ok($zip->set_number('3208680')->is_valid_number, '株式会社 栃木銀行');
ok($zip->set_number('3208686')->is_valid_number, '株式会社 下野新聞社');
ok($zip->set_number('3208688')->is_valid_number, '株式会社 足利銀行 宇都宮支店');
ok($zip->set_number('3210194')->is_valid_number, 'トヨタカローラ栃木 株式会社');
ok($zip->set_number('3210195')->is_valid_number, 'とちぎコープ生活 協同組合');
ok($zip->set_number('3210198')->is_valid_number, '栃木県立 宇都宮工業高等学校');
ok($zip->set_number('3210292')->is_valid_number, '壬生町役場');
ok($zip->set_number('3210293')->is_valid_number, '獨協医科大学');
ok($zip->set_number('3210295')->is_valid_number, '日立古河建機 株式会社');
ok($zip->set_number('3210298')->is_valid_number, '株式会社 バンダイ 栃木修理・配送センター');
ok($zip->set_number('3210592')->is_valid_number, '那須南農業協同組合');
ok($zip->set_number('3210593')->is_valid_number, '矢崎部品 株式会社 栃木工場');
ok($zip->set_number('3210595')->is_valid_number, '那須烏山市 南那須庁舎');
ok($zip->set_number('3210692')->is_valid_number, '那須烏山市役所');
ok($zip->set_number('3211292')->is_valid_number, '日光市役所');
ok($zip->set_number('3211297')->is_valid_number, '株式会社 高橋弥次右衛門商店');
ok($zip->set_number('3211492')->is_valid_number, '日光市役所 日光総合支所');
ok($zip->set_number('3211493')->is_valid_number, '古河電工');
ok($zip->set_number('3211692')->is_valid_number, '日光プリンスホテル');
ok($zip->set_number('3212492')->is_valid_number, '東武建設 株式会社');
ok($zip->set_number('3212493')->is_valid_number, 'ジャスコ 今市店');
ok($zip->set_number('3212592')->is_valid_number, '金谷ホテル観光 株式会社 鬼怒川温泉ホテル');
ok($zip->set_number('3212593')->is_valid_number, '獨協医科大学 日光医療センター');
ok($zip->set_number('3212595')->is_valid_number, '日光市 藤原総合支所');
ok($zip->set_number('3212596')->is_valid_number, '日光市 藤原水道事務所');
ok($zip->set_number('3212598')->is_valid_number, '株式会社 あさやホテル');
ok($zip->set_number('3212792')->is_valid_number, '栃木県酪農業協同組合・大笹牧場');
ok($zip->set_number('3213292')->is_valid_number, 'キヤノン 株式会社 宇都宮光学機器事業所');
ok($zip->set_number('3213293')->is_valid_number, 'キヤノン 株式会社 宇都宮工場');
ok($zip->set_number('3213295')->is_valid_number, '作新学院大学');
ok($zip->set_number('3213296')->is_valid_number, 'エム・イー・エム・シー 株式会社');
ok($zip->set_number('3213297')->is_valid_number, 'マルハ 株式会社 宇都宮工場');
ok($zip->set_number('3213298')->is_valid_number, 'キヤノン 株式会社 光学技術研究所');
ok($zip->set_number('3213392')->is_valid_number, '芳賀町役場');
ok($zip->set_number('3213395')->is_valid_number, 'ホンダエンジニアリング 株式会社');
ok($zip->set_number('3213493')->is_valid_number, '市貝町役場');
ok($zip->set_number('3213497')->is_valid_number, '花王 株式会社 栃木工場');
ok($zip->set_number('3213498')->is_valid_number, '花王 株式会社 栃木研究所');
ok($zip->set_number('3213595')->is_valid_number, '栃木県立茂木高等高校');
ok($zip->set_number('3213598')->is_valid_number, '茂木町役場');
ok($zip->set_number('3214292')->is_valid_number, 'ペンタックス 株式会社 益子事業所');
ok($zip->set_number('3214293')->is_valid_number, '益子町役場');
ok($zip->set_number('3214295')->is_valid_number, '益子焼窯元共販 株式会社');
ok($zip->set_number('3214392')->is_valid_number, 'SABICイノベーティブプラスチックスジャパン 合同会社 真岡事業所');
ok($zip->set_number('3214393')->is_valid_number, '第一電子工業 株式会社');
ok($zip->set_number('3214395')->is_valid_number, '真岡市役所');
ok($zip->set_number('3214396')->is_valid_number, '富士ファイバーグラス 株式会社');
ok($zip->set_number('3214398')->is_valid_number, '真岡県税事務所');
ok($zip->set_number('3218502')->is_valid_number, 'パナソニック コミュニケーションズ 株式会社');
ok($zip->set_number('3218505')->is_valid_number, '宇都宮大学');
ok($zip->set_number('3218555')->is_valid_number, '株式会社 ベルモール');
ok($zip->set_number('3218585')->is_valid_number, '宇都宮大学 工学部');
ok($zip->set_number('3220393')->is_valid_number, '鹿沼市役所 粟野支所');
ok($zip->set_number('3220692')->is_valid_number, '西方町役場');
ok($zip->set_number('3228501')->is_valid_number, 'ソニーケミカル 株式会社 鹿沼事業所 第1工場');
ok($zip->set_number('3228502')->is_valid_number, 'ソニーケミカル 株式会社 鹿沼事業所 第2工場');
ok($zip->set_number('3228503')->is_valid_number, 'ソニーケミカル 株式会社 鹿沼事業所 第3工場');
ok($zip->set_number('3228511')->is_valid_number, '株式会社 JSP 鹿沼工場');
ok($zip->set_number('3228550')->is_valid_number, '上都賀厚生農業協同組合連合会 上都賀病院');
ok($zip->set_number('3228555')->is_valid_number, '株式会社 東京インテリア家具 本部情報商品センター');
ok($zip->set_number('3228585')->is_valid_number, '住友電工電子ワイヤー 株式会社');
ok($zip->set_number('3228588')->is_valid_number, '株式会社 関口');
ok($zip->set_number('3228601')->is_valid_number, '鹿沼市役所');
ok($zip->set_number('3228603')->is_valid_number, '鹿沼 税務署');
ok($zip->set_number('3228666')->is_valid_number, '株式会社 ナカニシ');
ok($zip->set_number('3228688')->is_valid_number, '株式会社 栃の葉書房');
ok($zip->set_number('3230192')->is_valid_number, 'ソニーエナジー・デバイス 株式会社 栃木事業所');
ok($zip->set_number('3231192')->is_valid_number, '栃木市役所 藤岡総合支所');
ok($zip->set_number('3238511')->is_valid_number, '富士通 株式会社 小山工場');
ok($zip->set_number('3238558')->is_valid_number, '株式会社 小松製作所 小山工場');
ok($zip->set_number('3238567')->is_valid_number, 'コマツ ユーティリティ技術本部');
ok($zip->set_number('3238585')->is_valid_number, '白鴎大学');
ok($zip->set_number('3238586')->is_valid_number, '白鴎大学 駅東キャンパス');
ok($zip->set_number('3238601')->is_valid_number, '古河機械金属 株式会社 小山工場');
ok($zip->set_number('3238611')->is_valid_number, '小平産業 株式会社');
ok($zip->set_number('3238678')->is_valid_number, '昭和アルミニウム 株式会社 小山製造所');
ok($zip->set_number('3238686')->is_valid_number, '小山市役所');
ok($zip->set_number('3240292')->is_valid_number, '大田原市役所 黒羽支所');
ok($zip->set_number('3240293')->is_valid_number, '黒羽刑務所');
ok($zip->set_number('3240492')->is_valid_number, '大田原市役所 湯津上庁舎');
ok($zip->set_number('3240592')->is_valid_number, '株式会社 吉野工業所 那須小川工場');
ok($zip->set_number('3240593')->is_valid_number, '株式会社 吉野工業所 小川第二工場');
ok($zip->set_number('3240594')->is_valid_number, '株式会社 吉野工業所 小川金型工場');
ok($zip->set_number('3240595')->is_valid_number, '那珂川町役場 小川支所');
ok($zip->set_number('3240596')->is_valid_number, '那須小川ゴルフクラブ');
ok($zip->set_number('3240692')->is_valid_number, '那珂川町役場');
ok($zip->set_number('3240693')->is_valid_number, '住友金属鉱山シポレックス 株式会社 栃木工場');
ok($zip->set_number('3248501')->is_valid_number, '国際医療福祉大学');
ok($zip->set_number('3248510')->is_valid_number, '富士電機 株式会社 大田原工場');
ok($zip->set_number('3248516')->is_valid_number, '大日本塗料 株式会社 那須工場');
ok($zip->set_number('3248550')->is_valid_number, '東芝電子管デバイス 株式会社');
ok($zip->set_number('3248551')->is_valid_number, '大田原県税事務所');
ok($zip->set_number('3248555')->is_valid_number, '富士通 株式会社 那須工場');
ok($zip->set_number('3248585')->is_valid_number, '那須福祉事務所');
ok($zip->set_number('3248625')->is_valid_number, '株式会社 栃木ニコン');
ok($zip->set_number('3248641')->is_valid_number, '大田原市役所');
ok($zip->set_number('3248642')->is_valid_number, '大田原 税務署');
ok($zip->set_number('3250392')->is_valid_number, '株式会社 サンバレー那須');
ok($zip->set_number('3250393')->is_valid_number, '有限会社 南ケ丘牧場');
ok($zip->set_number('3250395')->is_valid_number, '那須ビューホテル');
ok($zip->set_number('3250397')->is_valid_number, '那須興業 株式会社');
ok($zip->set_number('3250398')->is_valid_number, '藤和那須リゾート 株式会社');
ok($zip->set_number('3260392')->is_valid_number, '両毛丸善 株式会社');
ok($zip->set_number('3260393')->is_valid_number, 'ナカノ薬品 株式会社');
ok($zip->set_number('3260395')->is_valid_number, '三和シャッター 株式会社');
ok($zip->set_number('3268501')->is_valid_number, '株式会社 レンタルのニッケン');
ok($zip->set_number('3268502')->is_valid_number, '足利商工会議所');
ok($zip->set_number('3268505')->is_valid_number, '株式会社 開倫塾');
ok($zip->set_number('3268510')->is_valid_number, '足利赤十字病院');
ok($zip->set_number('3268511')->is_valid_number, 'アキレス 株式会社');
ok($zip->set_number('3268520')->is_valid_number, '(株) コスミックインターナショナル');
ok($zip->set_number('3268550')->is_valid_number, '株式会社 足利モール');
ok($zip->set_number('3268555')->is_valid_number, '栃木県足利県税事務所');
ok($zip->set_number('3268558')->is_valid_number, '足利工業大学');
ok($zip->set_number('3268572')->is_valid_number, 'アピタ 足利店');
ok($zip->set_number('3268585')->is_valid_number, '株式会社 信栄');
ok($zip->set_number('3268601')->is_valid_number, '足利市役所');
ok($zip->set_number('3268611')->is_valid_number, '株式会社 足利銀行 足利支店');
ok($zip->set_number('3268630')->is_valid_number, '足利税務署');
ok($zip->set_number('3268655')->is_valid_number, '足利小山信用金庫');
ok($zip->set_number('3268686')->is_valid_number, '商工組合 中央金庫 足利支店');
ok($zip->set_number('3270192')->is_valid_number, '佐野日本大学中学・高等学校');
ok($zip->set_number('3270398')->is_valid_number, '佐野市役所 田沼庁舎');
ok($zip->set_number('3270592')->is_valid_number, '吉澤石灰工業 株式会社');
ok($zip->set_number('3270595')->is_valid_number, '佐野市役所 葛生庁舎');
ok($zip->set_number('3278501')->is_valid_number, '佐野市役所');
ok($zip->set_number('3278503')->is_valid_number, '佐野県税事務所');
ok($zip->set_number('3278511')->is_valid_number, '佐野厚生農業協同組合連合会 佐野厚生総合病院');
ok($zip->set_number('3278601')->is_valid_number, '佐野 税務署');
ok($zip->set_number('3278603')->is_valid_number, '佐野信用金庫');
ok($zip->set_number('3278678')->is_valid_number, '株式会社 足利銀行 佐野支店');
ok($zip->set_number('3280192')->is_valid_number, '栃木市役所 都賀総合支所');
ok($zip->set_number('3288501')->is_valid_number, 'イオン (株) ジャスコ栃木店');
ok($zip->set_number('3288502')->is_valid_number, 'GKNドライブラインジャパン 株式会社');
ok($zip->set_number('3288503')->is_valid_number, '三井鉱山 株式会社 栃木事業所');
ok($zip->set_number('3288504')->is_valid_number, '栃木県税事務所');
ok($zip->set_number('3288505')->is_valid_number, '下都賀総合病院');
ok($zip->set_number('3288533')->is_valid_number, '栃木年金事務所');
ok($zip->set_number('3288550')->is_valid_number, '栃木刑務所');
ok($zip->set_number('3288555')->is_valid_number, '岩下食品 株式会社');
ok($zip->set_number('3288556')->is_valid_number, '不二ラテックス 株式会社 栃木工場');
ok($zip->set_number('3288558')->is_valid_number, '栃木県立学悠館高等学校');
ok($zip->set_number('3288585')->is_valid_number, '栃木商工会議所');
ok($zip->set_number('3288586')->is_valid_number, '滝沢ハム 株式会社');
ok($zip->set_number('3288588')->is_valid_number, '國學院大學栃木学園');
ok($zip->set_number('3288666')->is_valid_number, '栃木 税務署');
ok($zip->set_number('3288668')->is_valid_number, '株式会社 足利銀行 栃木支店');
ok($zip->set_number('3288686')->is_valid_number, '栃木市役所');
ok($zip->set_number('3290195')->is_valid_number, '野木町役場');
ok($zip->set_number('3290492')->is_valid_number, '下野市役所');
ok($zip->set_number('3290498')->is_valid_number, '自治医科大学');
ok($zip->set_number('3290595')->is_valid_number, 'グンゼ 株式会社 宇都宮工場');
ok($zip->set_number('3290596')->is_valid_number, '石橋総合病院');
ok($zip->set_number('3290598')->is_valid_number, '第一化成 株式会社');
ok($zip->set_number('3290692')->is_valid_number, '日産自動車 株式会社 栃木工場');
ok($zip->set_number('3290696')->is_valid_number, '上三川町役場');
ok($zip->set_number('3291193')->is_valid_number, '独立行政法人 国立病院機構 宇都宮病院');
ok($zip->set_number('3291194')->is_valid_number, '財団法人 栃木県保健衛生事業団 岡本水質食品検査所');
ok($zip->set_number('3291195')->is_valid_number, '河内地域自治センター');
ok($zip->set_number('3291196')->is_valid_number, '栃木県保健環境センター');
ok($zip->set_number('3291198')->is_valid_number, '財団法人 栃木県環境技術協会');
ok($zip->set_number('3291292')->is_valid_number, '高根沢町役場');
ok($zip->set_number('3291392')->is_valid_number, 'さくら市役所');
ok($zip->set_number('3291393')->is_valid_number, '氏家税務署');
ok($zip->set_number('3291394')->is_valid_number, '栃木県立 氏家高等学校');
ok($zip->set_number('3291395')->is_valid_number, '社団医療法人 恵生会 黒須病院');
ok($zip->set_number('3291493')->is_valid_number, '喜連川社会復帰促進センター');
ok($zip->set_number('3292192')->is_valid_number, '矢板市役所');
ok($zip->set_number('3292193')->is_valid_number, 'シャープ 株式会社 AVシステム事業本部');
ok($zip->set_number('3292292')->is_valid_number, '塩谷町役場');
ok($zip->set_number('3292792')->is_valid_number, '那須塩原市役所 西那須野支所');
ok($zip->set_number('3292793')->is_valid_number, '独立行政法人 農業・食品産業技術総合研究機構 畜産草地研究所');
ok($zip->set_number('3292797')->is_valid_number, 'ダマール 株式会社 ロジスティックセンター');
ok($zip->set_number('3292992')->is_valid_number, '株式会社 ホテルニュー塩原');
ok($zip->set_number('3292993')->is_valid_number, '那須塩原市役所 塩原支所');
ok($zip->set_number('3293292')->is_valid_number, '那須町役場');
ok($zip->set_number('3294392')->is_valid_number, '岩舟町役場');
ok($zip->set_number('3294492')->is_valid_number, '栃木市役所 大平総合支所');
ok($zip->set_number('3294493')->is_valid_number, '日立アプライアンス (株) 栃木空調本部');
ok($zip->set_number('3308503')->is_valid_number, '自治医科大学附属 大宮医療センター');
ok($zip->set_number('3308505')->is_valid_number, 'NTT 大宮支店');
ok($zip->set_number('3308506')->is_valid_number, '社団法人 埼玉県トラック協会');
ok($zip->set_number('3308508')->is_valid_number, '三菱マテリアル 株式会社');
ok($zip->set_number('3308510')->is_valid_number, '郵便局ビジネスサポート 株式会社 関東地方運用センター');
ok($zip->set_number('3308511')->is_valid_number, '株式会社 高島屋 大宮店');
ok($zip->set_number('3308518')->is_valid_number, '埼玉会館');
ok($zip->set_number('3308519')->is_valid_number, '朝日生命保険 相互会社 浦和支社');
ok($zip->set_number('3308522')->is_valid_number, '埼玉県社会福祉事業団 障害者交流センター');
ok($zip->set_number('3308529')->is_valid_number, '埼玉県社会福祉協議会');
ok($zip->set_number('3308532')->is_valid_number, 'さいたま市 水道局');
ok($zip->set_number('3308533')->is_valid_number, '埼玉県警察本部');
ok($zip->set_number('3308538')->is_valid_number, '株式会社 テレビ埼玉');
ok($zip->set_number('3308547')->is_valid_number, '株式会社 日本政策金融公庫 さいたま支店 国民生活事業');
ok($zip->set_number('3308550')->is_valid_number, 'サンケイリビング新聞社 埼玉本部');
ok($zip->set_number('3308551')->is_valid_number, '読売新聞社 浦和支局');
ok($zip->set_number('3308565')->is_valid_number, '株式会社 住田光学ガラス');
ok($zip->set_number('3308566')->is_valid_number, '新洋信販 株式会社');
ok($zip->set_number('3308571')->is_valid_number, '全労済 埼玉県本部');
ok($zip->set_number('3308572')->is_valid_number, '浦和地方検察庁');
ok($zip->set_number('3308579')->is_valid_number, '株式会社 エフエム埼玉 NACK5');
ok($zip->set_number('3308580')->is_valid_number, '浦和年金事務所');
ok($zip->set_number('3308581')->is_valid_number, '株式会社 富士薬品');
ok($zip->set_number('3308585')->is_valid_number, '株式会社 ユーディケー');
ok($zip->set_number('3308601')->is_valid_number, '大和証券 株式会社 大宮支店');
ok($zip->set_number('3308669')->is_valid_number, 'ソニックシティビル');
ok($zip->set_number('3308686')->is_valid_number, '全国健康保険協会 埼玉支部');
ok($zip->set_number('3308688')->is_valid_number, 'アクサ損害保険 株式会社');
ok($zip->set_number('3309011')->is_valid_number, '大平ビルサービス 株式会社 さいたま支店');
ok($zip->set_number('3309045')->is_valid_number, 'NTT東日本料金サービスセンター');
ok($zip->set_number('3309077')->is_valid_number, '株式会社 埼玉りそな銀行 浦和中央支店');
ok($zip->set_number('3309088')->is_valid_number, '株式会社 埼玉りそな銀行 さいたま営業部');
ok($zip->set_number('3309109')->is_valid_number, '株式会社 ミュージアム・タイセイ');
ok($zip->set_number('3309111')->is_valid_number, '株式会社 さいたまアリーナ');
ok($zip->set_number('3309301')->is_valid_number, '埼玉県');
ok($zip->set_number('3309310')->is_valid_number, '日本放送協会 さいたま放送局');
ok($zip->set_number('3309311')->is_valid_number, '日新火災海上保険 株式会社');
ok($zip->set_number('3309330')->is_valid_number, '埼玉県立 浦和高等学校');
ok($zip->set_number('3309377')->is_valid_number, '埼玉SR経営労務センター');
ok($zip->set_number('3309501')->is_valid_number, '株式会社 丸井 大宮店');
ok($zip->set_number('3309502')->is_valid_number, 'ネッツ埼玉 株式会社');
ok($zip->set_number('3309503')->is_valid_number, '株式会社 富士通ビジネスシステム 関東支店');
ok($zip->set_number('3309507')->is_valid_number, '日本年金機構 北関東信越ブロック本部');
ok($zip->set_number('3309508')->is_valid_number, '株式会社 富士薬品');
ok($zip->set_number('3309509')->is_valid_number, '日本興亜損保');
ok($zip->set_number('3309510')->is_valid_number, '富士通 株式会社 関東支社');
ok($zip->set_number('3309511')->is_valid_number, '埼玉県社会保険診療報酬支払基金');
ok($zip->set_number('3309512')->is_valid_number, '学校法人 佐藤栄学園');
ok($zip->set_number('3309523')->is_valid_number, '損保ジャパン');
ok($zip->set_number('3309525')->is_valid_number, 'クレディ・スイス生命保険 株式会社 大宮支社');
ok($zip->set_number('3309531')->is_valid_number, '東芝エレベータ 株式会社 北関東支社');
ok($zip->set_number('3309535')->is_valid_number, '三光ソフラン 株式会社');
ok($zip->set_number('3309536')->is_valid_number, '株式会社 NTTドコモ 埼玉支店');
ok($zip->set_number('3309540')->is_valid_number, '山善 北関東支社');
ok($zip->set_number('3309543')->is_valid_number, '株式会社 埼玉マツダ');
ok($zip->set_number('3309544')->is_valid_number, 'キヤノン販売 株式会社 大宮営業所');
ok($zip->set_number('3309545')->is_valid_number, '富士レビオ 株式会社 北関東支店');
ok($zip->set_number('3309548')->is_valid_number, '東京新聞ショッパー社');
ok($zip->set_number('3309550')->is_valid_number, '毎日新聞 浦和支局');
ok($zip->set_number('3309551')->is_valid_number, 'リズム時計工業 株式会社');
ok($zip->set_number('3309553')->is_valid_number, '株式会社 ウィズウェイストジャパン');
ok($zip->set_number('3309555')->is_valid_number, '東日本旅客鉄道 (株) 大宮支社');
ok($zip->set_number('3309558')->is_valid_number, '大和ハウス工業 株式会社 埼玉支店');
ok($zip->set_number('3309559')->is_valid_number, 'コクーン新都心');
ok($zip->set_number('3309564')->is_valid_number, '昌和貿易 株式会社');
ok($zip->set_number('3309565')->is_valid_number, '埼玉県自動車販売整備健康保険組合');
ok($zip->set_number('3309566')->is_valid_number, '株式会社 マルフク');
ok($zip->set_number('3309575')->is_valid_number, '埼玉県自動車販売整備厚生年金基金');
ok($zip->set_number('3309577')->is_valid_number, '東日本旅客鉄道 (株) 大宮工場');
ok($zip->set_number('3309580')->is_valid_number, '日本信販 株式会社 関東第2エリア営業開発グループ');
ok($zip->set_number('3309581')->is_valid_number, '日本信販 株式会社 大宮支店');
ok($zip->set_number('3309582')->is_valid_number, 'エヌ・エス債権回収 株式会社 大宮支店');
ok($zip->set_number('3309583')->is_valid_number, '株式会社 日本ビジネスリース さいたま支店');
ok($zip->set_number('3309585')->is_valid_number, '株式会社 熊谷組 北関東支店');
ok($zip->set_number('3309586')->is_valid_number, '浦和区役所');
ok($zip->set_number('3309588')->is_valid_number, 'さいたま市役所');
ok($zip->set_number('3309590')->is_valid_number, '浦和税務署');
ok($zip->set_number('3309601')->is_valid_number, '日本生命保険 相互会社 埼玉総支社');
ok($zip->set_number('3309608')->is_valid_number, '埼玉県信用保証協会');
ok($zip->set_number('3309611')->is_valid_number, '(株) エフエム浦和');
ok($zip->set_number('3309621')->is_valid_number, '株式会社 ロフト 大宮ロフト');
ok($zip->set_number('3309622')->is_valid_number, '(株) JTBトラベランド 関越事業部');
ok($zip->set_number('3309626')->is_valid_number, '大宮商工会議所');
ok($zip->set_number('3309630')->is_valid_number, '株式会社 ティー・ピー・エス テプコソニック');
ok($zip->set_number('3309666')->is_valid_number, 'りそな決済サービス 株式会社 集金代行部');
ok($zip->set_number('3309688')->is_valid_number, '財団法人 新藤花道学院');
ok($zip->set_number('3309696')->is_valid_number, '株式会社 ジャックス 大宮支店');
ok($zip->set_number('3309715')->is_valid_number, '関東経済産業局');
ok($zip->set_number('3309796')->is_valid_number, '埼玉監査室');
ok($zip->set_number('3309797')->is_valid_number, '株式会社 ゆうちょ銀行 さいたま支店');
ok($zip->set_number('3309797')->is_valid_number, '株式会社 かんぽ生命 さいたま支店');
ok($zip->set_number('3309797')->is_valid_number, '郵便局 株式会社 関東支社');
ok($zip->set_number('3309797')->is_valid_number, '郵便事業 株式会社 関東支社');
ok($zip->set_number('3309850')->is_valid_number, '太陽生命保険 相互会社');
ok($zip->set_number('3318501')->is_valid_number, 'カルソニックカンセイ 株式会社');
ok($zip->set_number('3318511')->is_valid_number, '株式会社 島忠');
ok($zip->set_number('3318513')->is_valid_number, 'JR東日本 研究開発センター');
ok($zip->set_number('3318520')->is_valid_number, 'ツルゲン情報 株式会社');
ok($zip->set_number('3318532')->is_valid_number, '明治乳業 株式会社 東京支社 東関東支店');
ok($zip->set_number('3318533')->is_valid_number, '安田 株式会社 埼玉支店');
ok($zip->set_number('3318537')->is_valid_number, '生物系特定産業技術研究支援センター');
ok($zip->set_number('3318540')->is_valid_number, 'ユアサ商事 (株) 北関東支社');
ok($zip->set_number('3318550')->is_valid_number, '陸上自衛隊 大宮駐屯地');
ok($zip->set_number('3318552')->is_valid_number, '株式会社 カネゲン');
ok($zip->set_number('3318560')->is_valid_number, '岩谷産業 株式会社 関東支社');
ok($zip->set_number('3318567')->is_valid_number, '大宮中央総合病院付属 大宮中央クリニック');
ok($zip->set_number('3318580')->is_valid_number, '埼玉県自動車税事務所');
ok($zip->set_number('3318586')->is_valid_number, '北区役所');
ok($zip->set_number('3318587')->is_valid_number, '西区役所');
ok($zip->set_number('3318588')->is_valid_number, '高田製薬 株式会社');
ok($zip->set_number('3318633')->is_valid_number, 'カシュー 株式会社');
ok($zip->set_number('3318658')->is_valid_number, '株式会社 スズキ自販埼玉');
ok($zip->set_number('3318686')->is_valid_number, '株式会社 埼玉新聞社');
ok($zip->set_number('3318687')->is_valid_number, 'パナソニックSSマーケティング 株式会社 関越社');
ok($zip->set_number('3319510')->is_valid_number, '信越ポリマー 株式会社');
ok($zip->set_number('3319520')->is_valid_number, '大正製薬 株式会社 大宮工場');
ok($zip->set_number('3319530')->is_valid_number, '大正製薬 株式会社 総合研究所');
ok($zip->set_number('3319550')->is_valid_number, '株式会社 しまむら');
ok($zip->set_number('3319577')->is_valid_number, '大宮年金事務所');
ok($zip->set_number('3319624')->is_valid_number, 'フジノン 株式会社');
ok($zip->set_number('3328501')->is_valid_number, '川口水道局');
ok($zip->set_number('3328502')->is_valid_number, '川口金属工業 株式会社');
ok($zip->set_number('3328510')->is_valid_number, 'マイクロソフト');
ok($zip->set_number('3328511')->is_valid_number, 'そごう 川口店');
ok($zip->set_number('3328512')->is_valid_number, '田中徳兵衛商店');
ok($zip->set_number('3328521')->is_valid_number, 'カシオテクノ 株式会社');
ok($zip->set_number('3328548')->is_valid_number, 'NTT東日本-埼玉 埼玉南営業支店');
ok($zip->set_number('3328555')->is_valid_number, '株式会社 深川製作所 株式会社 フカガワ 深川機械販売 株式会社');
ok($zip->set_number('3328556')->is_valid_number, '前沢工業');
ok($zip->set_number('3328558')->is_valid_number, '済生会川口総合病院');
ok($zip->set_number('3328577')->is_valid_number, '中興電機 株式会社');
ok($zip->set_number('3328585')->is_valid_number, 'クロゼン');
ok($zip->set_number('3328601')->is_valid_number, '川口市役所');
ok($zip->set_number('3328654')->is_valid_number, '西川口税務署');
ok($zip->set_number('3328666')->is_valid_number, '川口税務署');
ok($zip->set_number('3328686')->is_valid_number, '川口信用金庫');
ok($zip->set_number('3338601')->is_valid_number, '株式会社 改良園');
ok($zip->set_number('3338611')->is_valid_number, '株式会社 日本花卉');
ok($zip->set_number('3348501')->is_valid_number, '協和ゴム工業 株式会社');
ok($zip->set_number('3348511')->is_valid_number, '鳩ケ谷市役所');
ok($zip->set_number('3358501')->is_valid_number, '蕨市役所');
ok($zip->set_number('3358502')->is_valid_number, '株式会社 ジャパンエナジー総合研究所');
ok($zip->set_number('3358503')->is_valid_number, '株式会社 ジャパンエナジー分析研究センター');
ok($zip->set_number('3358505')->is_valid_number, '田辺製薬 株式会社 戸田事業所');
ok($zip->set_number('3358510')->is_valid_number, '沖電気工業 株式会社');
ok($zip->set_number('3358511')->is_valid_number, 'クラリオン 株式会社 埼玉事業所');
ok($zip->set_number('3358522')->is_valid_number, '株式会社 日教販');
ok($zip->set_number('3358533')->is_valid_number, '蕨警察署');
ok($zip->set_number('3358555')->is_valid_number, '戸田中央総合病院');
ok($zip->set_number('3358585')->is_valid_number, '株式会社 JOMOテクニカルリサーチセンター');
ok($zip->set_number('3358588')->is_valid_number, '戸田市役所');
ok($zip->set_number('3358655')->is_valid_number, '株式会社 埼玉りそな銀行 蕨支店');
ok($zip->set_number('3358666')->is_valid_number, '株式会社 埼玉りそな銀行 戸田支店');
ok($zip->set_number('3358792')->is_valid_number, '東日本情報管理センター');
ok($zip->set_number('3368505')->is_valid_number, '浦和レッドダイヤモンズ');
ok($zip->set_number('3368506')->is_valid_number, '日本クラッチ 株式会社');
ok($zip->set_number('3368508')->is_valid_number, '全国生活協同組合連合会');
ok($zip->set_number('3368512')->is_valid_number, '埼玉土建一般労働組合');
ok($zip->set_number('3368515')->is_valid_number, '社団法人 埼玉建設産業団体連合会');
ok($zip->set_number('3368520')->is_valid_number, '三菱文具 株式会社');
ok($zip->set_number('3368522')->is_valid_number, 'さいたま市立病院');
ok($zip->set_number('3368525')->is_valid_number, 'レッドダイヤモンズ後援会');
ok($zip->set_number('3368526')->is_valid_number, '生活協同組合連合会 コープネット事業連合');
ok($zip->set_number('3368540')->is_valid_number, '埼玉三菱ふそう自動車販売 株式会社');
ok($zip->set_number('3368555')->is_valid_number, '埼玉県立 南教育センター');
ok($zip->set_number('3368558')->is_valid_number, '株式会社 長崎屋 浦和店');
ok($zip->set_number('3368561')->is_valid_number, '日特エンジニアリング 株式会社');
ok($zip->set_number('3368564')->is_valid_number, '株式会社 関電工 埼玉支店');
ok($zip->set_number('3368581')->is_valid_number, 'マミヤ・オーピー 株式会社');
ok($zip->set_number('3368586')->is_valid_number, '南区役所');
ok($zip->set_number('3368587')->is_valid_number, '緑区役所');
ok($zip->set_number('3368601')->is_valid_number, '株式会社 ロッテ 浦和工場');
ok($zip->set_number('3368636')->is_valid_number, '株式会社 コーケン');
ok($zip->set_number('3368655')->is_valid_number, '日本電信電話 株式会社');
ok($zip->set_number('3368760')->is_valid_number, 'イオン 浦和美園ショッピングセンター');
ok($zip->set_number('3378502')->is_valid_number, '八木アンテナ 株式会社');
ok($zip->set_number('3378507')->is_valid_number, '新日本法規出版 (株) 関東支社');
ok($zip->set_number('3378532')->is_valid_number, 'トキタ種苗 株式会社');
ok($zip->set_number('3378570')->is_valid_number, '芝浦工業大学');
ok($zip->set_number('3378586')->is_valid_number, '見沼区役所');
ok($zip->set_number('3388503')->is_valid_number, '日本ピストンリング 株式会社 本社');
ok($zip->set_number('3388504')->is_valid_number, '全労済 埼玉県本部');
ok($zip->set_number('3388506')->is_valid_number, '(財) 埼玉県芸術文化振興財団 彩の国さいたま芸術劇場');
ok($zip->set_number('3388508')->is_valid_number, '埼玉トヨペット 株式会社');
ok($zip->set_number('3388510')->is_valid_number, 'ミサワホーム西関東 (株)');
ok($zip->set_number('3388512')->is_valid_number, '日本通運 株式会社 埼玉支店');
ok($zip->set_number('3388513')->is_valid_number, 'さいたま地方法務局');
ok($zip->set_number('3388515')->is_valid_number, '株式会社 大塚商会 埼玉営業部');
ok($zip->set_number('3388523')->is_valid_number, '日産プリンス埼玉販売 株式会社');
ok($zip->set_number('3388524')->is_valid_number, 'コニシ 株式会社 浦和工場');
ok($zip->set_number('3388525')->is_valid_number, '埼玉日産自動車 株式会社');
ok($zip->set_number('3388531')->is_valid_number, '社団法人 日本自動車連盟 埼玉支部');
ok($zip->set_number('3388538')->is_valid_number, '株式会社 モリタ 東京製作所');
ok($zip->set_number('3388540')->is_valid_number, 'ドイト 株式会社 通販部');
ok($zip->set_number('3388541')->is_valid_number, '三輪精機 株式会社');
ok($zip->set_number('3388551')->is_valid_number, '浦和中央青果市場 株式会社');
ok($zip->set_number('3388553')->is_valid_number, 'さいたま赤十字病院');
ok($zip->set_number('3388555')->is_valid_number, '埼玉スバル自動車 株式会社');
ok($zip->set_number('3388557')->is_valid_number, 'あいおいニッセイ同和損害保険 株式会社');
ok($zip->set_number('3388558')->is_valid_number, 'UFJニコス 株式会社 北関東管理部');
ok($zip->set_number('3388566')->is_valid_number, 'ドイト 株式会社');
ok($zip->set_number('3388567')->is_valid_number, '株式会社 与野フードセンター');
ok($zip->set_number('3388570')->is_valid_number, '埼玉大学');
ok($zip->set_number('3388571')->is_valid_number, '埼玉大学 国際交流会館');
ok($zip->set_number('3388575')->is_valid_number, '株式会社 カバサワ');
ok($zip->set_number('3388577')->is_valid_number, '埼玉精神神経センター');
ok($zip->set_number('3388580')->is_valid_number, '東京電力 株式会社 さいたま支社');
ok($zip->set_number('3388585')->is_valid_number, 'トヨタカローラ新埼玉 株式会社');
ok($zip->set_number('3388586')->is_valid_number, '桜区役所');
ok($zip->set_number('3388686')->is_valid_number, '中央区役所');
ok($zip->set_number('3398501')->is_valid_number, '目白大学');
ok($zip->set_number('3398509')->is_valid_number, '富士ゼロックス (株) 岩槻事務所');
ok($zip->set_number('3398510')->is_valid_number, '藤倉ゴム工業 株式会社 岩槻工場');
ok($zip->set_number('3398511')->is_valid_number, '北海製罐 (株) 岩槻工場');
ok($zip->set_number('3398521')->is_valid_number, '丸山記念総合病院');
ok($zip->set_number('3398539')->is_valid_number, '人間総合科学大学');
ok($zip->set_number('3398551')->is_valid_number, '埼玉県立 小児医療センター');
ok($zip->set_number('3398558')->is_valid_number, '株式会社 プラコー');
ok($zip->set_number('3398566')->is_valid_number, '株式会社 トーモク岩槻工場');
ok($zip->set_number('3398585')->is_valid_number, '岩槻区役所');
ok($zip->set_number('3398601')->is_valid_number, '曙ブレーキ岩槻製造 株式会社');
ok($zip->set_number('3398686')->is_valid_number, '花菱縫製 株式会社');
ok($zip->set_number('3400192')->is_valid_number, '幸手市役所');
ok($zip->set_number('3400193')->is_valid_number, 'コスモ石油 (株) 中央研究所');
ok($zip->set_number('3400295')->is_valid_number, '久喜市 鷲宮総合支所');
ok($zip->set_number('3408501')->is_valid_number, '株式会社 ティ・アンド・ケイ・パッケージ');
ok($zip->set_number('3408509')->is_valid_number, '草加公共職業安定所');
ok($zip->set_number('3408510')->is_valid_number, '富安金属印刷 株式会社');
ok($zip->set_number('3408511')->is_valid_number, '旭鋼管工業 株式会社');
ok($zip->set_number('3408524')->is_valid_number, '埼玉県立草加西高等学校');
ok($zip->set_number('3408533')->is_valid_number, '株式会社 流通サービス');
ok($zip->set_number('3408550')->is_valid_number, '草加市役所');
ok($zip->set_number('3408551')->is_valid_number, '堀川産業 株式会社');
ok($zip->set_number('3408555')->is_valid_number, '草加市 水道部');
ok($zip->set_number('3408560')->is_valid_number, '草加市立病院');
ok($zip->set_number('3408567')->is_valid_number, 'タカギ冷機 株式会社');
ok($zip->set_number('3408568')->is_valid_number, '株式会社 川島製作所');
ok($zip->set_number('3408577')->is_valid_number, '東日本電信電話 株式会社 草加ビル');
ok($zip->set_number('3408585')->is_valid_number, '獨協大学 入試部');
ok($zip->set_number('3408588')->is_valid_number, '八潮市役所');
ok($zip->set_number('3408610')->is_valid_number, '天田印刷加工 株式会社');
ok($zip->set_number('3408611')->is_valid_number, '株式会社 クレシア 東京工場');
ok($zip->set_number('3408659')->is_valid_number, 'SMC 株式会社');
ok($zip->set_number('3408686')->is_valid_number, 'ソマール 株式会社');
ok($zip->set_number('3418501')->is_valid_number, '三郷市役所');
ok($zip->set_number('3418526')->is_valid_number, '医療法人 社団愛友会 三郷順心総合病院');
ok($zip->set_number('3418527')->is_valid_number, 'キヤノンファインテック 株式会社');
ok($zip->set_number('3418550')->is_valid_number, 'ららぽーと新三郷');
ok($zip->set_number('3418555')->is_valid_number, 'みさと健和病院');
ok($zip->set_number('3418558')->is_valid_number, '株式会社 七虹');
ok($zip->set_number('3428501')->is_valid_number, '吉川市役所');
ok($zip->set_number('3428502')->is_valid_number, '株式会社 オーム電機');
ok($zip->set_number('3428505')->is_valid_number, '株式会社 丸和運輸機関');
ok($zip->set_number('3428601')->is_valid_number, '株式会社 アサヒ情報');
ok($zip->set_number('3430192')->is_valid_number, '松伏町役場');
ok($zip->set_number('3430193')->is_valid_number, '大正大学 埼玉校舎');
ok($zip->set_number('3438501')->is_valid_number, '越谷市役所');
ok($zip->set_number('3438502')->is_valid_number, '林恒 株式会社');
ok($zip->set_number('3438511')->is_valid_number, '文教大学');
ok($zip->set_number('3438540')->is_valid_number, '埼玉県立大学');
ok($zip->set_number('3438554')->is_valid_number, '株式会社 ウエノ');
ok($zip->set_number('3438555')->is_valid_number, '独協医科大学 越谷病院');
ok($zip->set_number('3438585')->is_valid_number, '越谷年金事務所');
ok($zip->set_number('3438601')->is_valid_number, '越谷税務署');
ok($zip->set_number('3448506')->is_valid_number, '春日部労働基準監督署');
ok($zip->set_number('3448508')->is_valid_number, '埼玉県信用保証協会 春日部支店');
ok($zip->set_number('3448511')->is_valid_number, '株式会社 高橋監理');
ok($zip->set_number('3448521')->is_valid_number, '春日部女子高等学校');
ok($zip->set_number('3448522')->is_valid_number, '株式会社 桃屋 春日部工場');
ok($zip->set_number('3448533')->is_valid_number, 'ロビンソン百貨店');
ok($zip->set_number('3448535')->is_valid_number, '春日部警察署');
ok($zip->set_number('3448540')->is_valid_number, '栄和 株式会社');
ok($zip->set_number('3448555')->is_valid_number, '埼玉県春日部県税事務所');
ok($zip->set_number('3448566')->is_valid_number, '株式会社 マルヤ');
ok($zip->set_number('3448577')->is_valid_number, '春日部市役所');
ok($zip->set_number('3448585')->is_valid_number, '春日部商工会議所');
ok($zip->set_number('3448588')->is_valid_number, '春日部市立病院');
ok($zip->set_number('3448686')->is_valid_number, '春日部税務署');
ok($zip->set_number('3458501')->is_valid_number, '日本工業大学');
ok($zip->set_number('3458502')->is_valid_number, '杉戸町役場');
ok($zip->set_number('3458504')->is_valid_number, '宮代町役場');
ok($zip->set_number('3458508')->is_valid_number, '凸版印刷 株式会社');
ok($zip->set_number('3460192')->is_valid_number, '久喜市 菖蒲総合支所');
ok($zip->set_number('3460193')->is_valid_number, '日本鋳鉄管 株式会社');
ok($zip->set_number('3460194')->is_valid_number, '株式会社 エフテック');
ok($zip->set_number('3460195')->is_valid_number, 'モラージュ菖蒲');
ok($zip->set_number('3460196')->is_valid_number, '日本マタイ 株式会社 埼玉工場');
ok($zip->set_number('3460198')->is_valid_number, '株式会社 NSKマシナリー');
ok($zip->set_number('3468501')->is_valid_number, '久喜市役所');
ok($zip->set_number('3468506')->is_valid_number, '埼玉県立久喜図書館');
ok($zip->set_number('3468524')->is_valid_number, '日本信号 (株)');
ok($zip->set_number('3468530')->is_valid_number, '埼玉県厚生農業協同組合連合会 久喜総合病院');
ok($zip->set_number('3468540')->is_valid_number, 'ベネッセコーポレーション (株)');
ok($zip->set_number('3468685')->is_valid_number, 'ベネッセコーポレーション');
ok($zip->set_number('3468686')->is_valid_number, 'ベネッセコーポレーション');
ok($zip->set_number('3470192')->is_valid_number, '加須市 騎西総合支所');
ok($zip->set_number('3470195')->is_valid_number, 'キサイフーズ工業 株式会社');
ok($zip->set_number('3478501')->is_valid_number, '加須市役所');
ok($zip->set_number('3478502')->is_valid_number, '花咲徳栄高校');
ok($zip->set_number('3478503')->is_valid_number, '埼玉短期大学');
ok($zip->set_number('3478504')->is_valid_number, '平成国際大学');
ok($zip->set_number('3478510')->is_valid_number, '社会福祉法人 愛の泉');
ok($zip->set_number('3478513')->is_valid_number, '県立不動岡高校');
ok($zip->set_number('3478550')->is_valid_number, 'ブリヂストンBRM 株式会社');
ok($zip->set_number('3478555')->is_valid_number, 'アトミクス 株式会社');
ok($zip->set_number('3478567')->is_valid_number, '大昭和紙工産業 株式会社 加須工場');
ok($zip->set_number('3478585')->is_valid_number, '日本ワイパブレード 株式会社');
ok($zip->set_number('3488501')->is_valid_number, '曙ブレーキ羽生製造 株式会社');
ok($zip->set_number('3488503')->is_valid_number, '金子農機 株式会社');
ok($zip->set_number('3488505')->is_valid_number, '埼玉医療生活協同組合 羽生総合病院');
ok($zip->set_number('3488506')->is_valid_number, '日本精工 株式会社');
ok($zip->set_number('3488507')->is_valid_number, '関東三洋セミコンダクターズ 株式会社 羽生工場');
ok($zip->set_number('3488512')->is_valid_number, 'エーダイニット 株式会社');
ok($zip->set_number('3488513')->is_valid_number, 'ほくさい農業協同組合');
ok($zip->set_number('3488525')->is_valid_number, '田中鉄鋼販売 株式会社');
ok($zip->set_number('3488530')->is_valid_number, '共愛会');
ok($zip->set_number('3488540')->is_valid_number, '大正製薬 株式会社 羽生工場');
ok($zip->set_number('3488549')->is_valid_number, '日清ヨーク 株式会社 関東工場');
ok($zip->set_number('3488555')->is_valid_number, '株式会社 ダイチュー テクノロジーズ');
ok($zip->set_number('3488601')->is_valid_number, '羽生市役所');
ok($zip->set_number('3490192')->is_valid_number, '東光電気 株式会社');
ok($zip->set_number('3490193')->is_valid_number, '蓮田市役所');
ok($zip->set_number('3490195')->is_valid_number, '東京セキスイ工業 株式会社');
ok($zip->set_number('3490196')->is_valid_number, '独立行政法人 国立病院機構 東埼玉病院');
ok($zip->set_number('3490198')->is_valid_number, '積水化学工業 株式会社 武蔵工場');
ok($zip->set_number('3490292')->is_valid_number, '白岡町役場');
ok($zip->set_number('3490293')->is_valid_number, '大成ラミック 株式会社');
ok($zip->set_number('3490294')->is_valid_number, '日産化学工業 株式会社');
ok($zip->set_number('3491192')->is_valid_number, '久喜市 栗橋総合支所');
ok($zip->set_number('3491193')->is_valid_number, '加須市 大利根総合支所');
ok($zip->set_number('3491292')->is_valid_number, '加須市 北川辺総合支所');
ok($zip->set_number('3500192')->is_valid_number, '川島町役場');
ok($zip->set_number('3500193')->is_valid_number, '三井精機工業 株式会社 川島工場');
ok($zip->set_number('3500197')->is_valid_number, 'イーデーエム 株式会社 テクノセンター');
ok($zip->set_number('3500280')->is_valid_number, '株式会社 日東');
ok($zip->set_number('3500282')->is_valid_number, 'ソニーイーエムシーエス 株式会社 埼玉テック');
ok($zip->set_number('3500283')->is_valid_number, '明海大学');
ok($zip->set_number('3500284')->is_valid_number, '株式会社 高純度化学研究所');
ok($zip->set_number('3500285')->is_valid_number, 'イーグル工業');
ok($zip->set_number('3500286')->is_valid_number, '株式会社 パイオニアFA');
ok($zip->set_number('3500287')->is_valid_number, 'パイオニアファインテック 株式会社');
ok($zip->set_number('3500288')->is_valid_number, '女子栄養大学');
ok($zip->set_number('3500289')->is_valid_number, '明治製菓');
ok($zip->set_number('3500292')->is_valid_number, '坂戸市役所');
ok($zip->set_number('3500295')->is_valid_number, '城西大学');
ok($zip->set_number('3500392')->is_valid_number, '鳩山町役場');
ok($zip->set_number('3500393')->is_valid_number, '独立行政法人 宇宙航空研究開発機構 地球観測センター');
ok($zip->set_number('3500394')->is_valid_number, '東京電機大学 理工学部');
ok($zip->set_number('3500395')->is_valid_number, '株式会社 日立製作所 基礎研究所');
ok($zip->set_number('3500396')->is_valid_number, '山村学園短期大学');
ok($zip->set_number('3500493')->is_valid_number, '毛呂山町役場');
ok($zip->set_number('3500494')->is_valid_number, '越生町役場');
ok($zip->set_number('3500495')->is_valid_number, '埼玉医科大学');
ok($zip->set_number('3500496')->is_valid_number, '学校法人 埼玉医科大学 保健医療学部 川角キャンパス');
ok($zip->set_number('3501181')->is_valid_number, '株式会社 アイエムエス');
ok($zip->set_number('3501192')->is_valid_number, '小松ゼノア 株式会社');
ok($zip->set_number('3501196')->is_valid_number, '川越年金事務所');
ok($zip->set_number('3501197')->is_valid_number, '学校法人 金子教育団 東京国際大学(第一キャンパス)');
ok($zip->set_number('3501198')->is_valid_number, '学校法人 金子教育団 東京国際大学 (第二キャンパス)');
ok($zip->set_number('3501292')->is_valid_number, '日高市役所');
ok($zip->set_number('3501295')->is_valid_number, 'NECネットワーク・センサ 株式会社');
ok($zip->set_number('3501296')->is_valid_number, '太平洋セメント 株式会社 埼玉工場');
ok($zip->set_number('3501297')->is_valid_number, 'シグマ光機 株式会社');
ok($zip->set_number('3501298')->is_valid_number, '埼玉医科大学国際医療センター');
ok($zip->set_number('3501380')->is_valid_number, '狭山市役所');
ok($zip->set_number('3501388')->is_valid_number, '東亜ディーケーケー 株式会社 狭山テクニカルセンター');
ok($zip->set_number('3501392')->is_valid_number, '本田技研工業 株式会社 埼玉製作所');
ok($zip->set_number('3501398')->is_valid_number, '東京家政大学 狭山校舎');
ok($zip->set_number('3502280')->is_valid_number, '東洋電装 株式会社');
ok($zip->set_number('3502281')->is_valid_number, '東光 (株) 埼玉事業所');
ok($zip->set_number('3502287')->is_valid_number, '株式会社 ネオシス');
ok($zip->set_number('3502288')->is_valid_number, 'パイオニア');
ok($zip->set_number('3502292')->is_valid_number, '鶴ヶ島市役所');
ok($zip->set_number('3508501')->is_valid_number, '川越プリンスホテル');
ok($zip->set_number('3508508')->is_valid_number, '埼玉県信用保証協会 川越支所');
ok($zip->set_number('3508511')->is_valid_number, '株式会社 丸広百貨店');
ok($zip->set_number('3508531')->is_valid_number, 'さいたま地方裁判所 川越支部');
ok($zip->set_number('3508550')->is_valid_number, '埼玉医科大学総合医療センター');
ok($zip->set_number('3508555')->is_valid_number, 'パイオニア 株式会社 川越事業所');
ok($zip->set_number('3508585')->is_valid_number, '学校法人 東洋大学');
ok($zip->set_number('3508588')->is_valid_number, '医療法人 康正会病院');
ok($zip->set_number('3508601')->is_valid_number, '川越市役所');
ok($zip->set_number('3508666')->is_valid_number, '川越税務署');
ok($zip->set_number('3510188')->is_valid_number, '本田技研工業 株式会社 和光ビル');
ok($zip->set_number('3510192')->is_valid_number, '和光市役所');
ok($zip->set_number('3510193')->is_valid_number, '本田技術研究所');
ok($zip->set_number('3510194')->is_valid_number, '司法研修所');
ok($zip->set_number('3510196')->is_valid_number, '裁判所職員総合研修所');
ok($zip->set_number('3510197')->is_valid_number, '国立保健医療科学院');
ok($zip->set_number('3510198')->is_valid_number, '独立行政法人 理化学研究所');
ok($zip->set_number('3518501')->is_valid_number, '朝霞市役所');
ok($zip->set_number('3518508')->is_valid_number, '株式会社 東京印書館');
ok($zip->set_number('3518510')->is_valid_number, '東洋大学 朝霞校舎');
ok($zip->set_number('3518511')->is_valid_number, '積水化学工業 株式会社 東京工場');
ok($zip->set_number('3518520')->is_valid_number, 'すまいるエフエム 株式会社');
ok($zip->set_number('3518551')->is_valid_number, '医療法人社団 武蔵野会 朝霞台中央総合病院');
ok($zip->set_number('3518560')->is_valid_number, '朝霞市社会福祉協議会');
ok($zip->set_number('3518585')->is_valid_number, '富士写真フィルム 株式会社 朝霞技術開発センター');
ok($zip->set_number('3518586')->is_valid_number, '株式会社 M-TEC');
ok($zip->set_number('3518601')->is_valid_number, '朝霞税務署');
ok($zip->set_number('3528501')->is_valid_number, '跡見学園女子大学');
ok($zip->set_number('3528510')->is_valid_number, '十文字学園女子大学・十文字学園女子大学 短期大学部');
ok($zip->set_number('3528523')->is_valid_number, '立教新座中学校・高等学校');
ok($zip->set_number('3528549')->is_valid_number, '立教大学 野球部');
ok($zip->set_number('3528555')->is_valid_number, '法台寺');
ok($zip->set_number('3528558')->is_valid_number, '立教大学 新座キャンパス');
ok($zip->set_number('3528572')->is_valid_number, '株式会社 ボッシュオートモーティブシステム 志木事務所');
ok($zip->set_number('3528577')->is_valid_number, '株式会社 マイカル新座サテイ');
ok($zip->set_number('3528588')->is_valid_number, '東京カネカ食品販売 株式会社');
ok($zip->set_number('3528589')->is_valid_number, '株式会社 ホンダアクセス');
ok($zip->set_number('3528623')->is_valid_number, '新座市役所');
ok($zip->set_number('3528666')->is_valid_number, 'サンケン電気 株式会社 本社');
ok($zip->set_number('3538501')->is_valid_number, '志木市役所');
ok($zip->set_number('3538555')->is_valid_number, '東京電力 株式会社 埼玉支店 志木支社');
ok($zip->set_number('3548501')->is_valid_number, '大崎電気 株式会社 埼玉事業所');
ok($zip->set_number('3548503')->is_valid_number, 'オーサワジャパン 株式会社');
ok($zip->set_number('3548504')->is_valid_number, '(株) 学研ロジスティクス');
ok($zip->set_number('3548505')->is_valid_number, '株式会社 主婦の友社');
ok($zip->set_number('3548510')->is_valid_number, '淑徳大学 国際コミュニケーション学部');
ok($zip->set_number('3548511')->is_valid_number, '富士見市役所');
ok($zip->set_number('3548533')->is_valid_number, '株式会社主婦の友社 通販事業部');
ok($zip->set_number('3548555')->is_valid_number, '三芳町役場');
ok($zip->set_number('3548558')->is_valid_number, '大日本印刷 株式会社');
ok($zip->set_number('3548577')->is_valid_number, '株式会社 T&K TOKA');
ok($zip->set_number('3548580')->is_valid_number, '日本シイエムケイ 株式会社 SEセンター');
ok($zip->set_number('3548585')->is_valid_number, '日酸TANAKA 株式会社');
ok($zip->set_number('3550192')->is_valid_number, '吉見町役場');
ok($zip->set_number('3550193')->is_valid_number, '東洋製罐 株式会社 埼玉工場');
ok($zip->set_number('3550195')->is_valid_number, 'プリマ食品 株式会社');
ok($zip->set_number('3550292')->is_valid_number, '独立行政法人 国立女性教育会館');
ok($zip->set_number('3550392')->is_valid_number, '小川町役場');
ok($zip->set_number('3550395')->is_valid_number, 'ときがわ町役場');
ok($zip->set_number('3558501')->is_valid_number, '大東文化大学');
ok($zip->set_number('3558585')->is_valid_number, '滑川町役場');
ok($zip->set_number('3558601')->is_valid_number, '東松山市役所');
ok($zip->set_number('3558602')->is_valid_number, 'ボッシュ 株式会社 東松山第2工場');
ok($zip->set_number('3558603')->is_valid_number, 'ボッシュ 株式会社');
ok($zip->set_number('3558604')->is_valid_number, '東松山税務署');
ok($zip->set_number('3558605')->is_valid_number, 'ユニー 株式会社 アピタ東松山店');
ok($zip->set_number('3558606')->is_valid_number, 'ユニー 株式会社 ピオニウォーク東松山');
ok($zip->set_number('3568501')->is_valid_number, 'ふじみ野市役所');
ok($zip->set_number('3568502')->is_valid_number, '株式会社 KDDI研究所');
ok($zip->set_number('3568507')->is_valid_number, '大日本印刷 株式会社 上福岡工場');
ok($zip->set_number('3568510')->is_valid_number, '新日本無線 株式会社 川越製作所');
ok($zip->set_number('3568511')->is_valid_number, '(株) 日清製粉グループ本社');
ok($zip->set_number('3568533')->is_valid_number, '文京学院大学');
ok($zip->set_number('3568550')->is_valid_number, '株式会社 内外テクノス');
ok($zip->set_number('3568555')->is_valid_number, 'ふじみ野市 大井総合支所');
ok($zip->set_number('3568556')->is_valid_number, '山下ゴム 株式会社');
ok($zip->set_number('3568567')->is_valid_number, '学校法人 ホンダ学園 ホンダテクニカルカレッジ関東');
ok($zip->set_number('3568585')->is_valid_number, '近藤建設 株式会社');
ok($zip->set_number('3578501')->is_valid_number, '飯能市役所');
ok($zip->set_number('3578510')->is_valid_number, '株式会社 椿本チエイン');
ok($zip->set_number('3578527')->is_valid_number, '大鵬薬品工業 株式会社');
ok($zip->set_number('3578550')->is_valid_number, '自由の森学園');
ok($zip->set_number('3578555')->is_valid_number, '駿河台大学');
ok($zip->set_number('3578558')->is_valid_number, '飯能信用金庫');
ok($zip->set_number('3578585')->is_valid_number, '新電元工業 株式会社');
ok($zip->set_number('3578588')->is_valid_number, '飯能ケーブルテレビ 株式会社');
ok($zip->set_number('3578673')->is_valid_number, '郵NET');
ok($zip->set_number('3588501')->is_valid_number, '株式会社 タムラ製作所');
ok($zip->set_number('3588510')->is_valid_number, 'ティアック 株式会社 EMCセンター');
ok($zip->set_number('3588511')->is_valid_number, '入間市役所');
ok($zip->set_number('3588515')->is_valid_number, '入間アウトレットパークOPC');
ok($zip->set_number('3588521')->is_valid_number, '武蔵野音楽学園');
ok($zip->set_number('3588555')->is_valid_number, '株式会社 安川電機');
ok($zip->set_number('3588558')->is_valid_number, '東野高等学校');
ok($zip->set_number('3588585')->is_valid_number, 'プラス工業 株式会社');
ok($zip->set_number('3588588')->is_valid_number, '大妻女子大学 狭山台校');
ok($zip->set_number('3591188')->is_valid_number, '平岩建設 株式会社');
ok($zip->set_number('3591189')->is_valid_number, '株式会社 西武ライオンズ');
ok($zip->set_number('3591192')->is_valid_number, '早稲田大学');
ok($zip->set_number('3591193')->is_valid_number, '大和証券 株式会社 所沢支店');
ok($zip->set_number('3591195')->is_valid_number, '埼玉りそな銀行 所沢支店');
ok($zip->set_number('3591196')->is_valid_number, '西武ライオンズ球場');
ok($zip->set_number('3598501')->is_valid_number, '所沢市役所');
ok($zip->set_number('3598505')->is_valid_number, '所沢年金事務所');
ok($zip->set_number('3598507')->is_valid_number, '株式会社 バンガードシステムズ');
ok($zip->set_number('3598510')->is_valid_number, '(株) 西武ホールディングス');
ok($zip->set_number('3598511')->is_valid_number, '株式会社 シチズン時計');
ok($zip->set_number('3598513')->is_valid_number, '防衛医大');
ok($zip->set_number('3598520')->is_valid_number, '西武鉄道 株式会社');
ok($zip->set_number('3598522')->is_valid_number, 'パイオニア (株) 所沢工場');
ok($zip->set_number('3598533')->is_valid_number, 'NTT 所沢支店');
ok($zip->set_number('3598542')->is_valid_number, '東京電力 志木支社 所沢営業所センター');
ok($zip->set_number('3598550')->is_valid_number, '西武建設 株式会社');
ok($zip->set_number('3598555')->is_valid_number, '国立身体障害者リハビリセンター');
ok($zip->set_number('3598558')->is_valid_number, '読売センター 東所沢');
ok($zip->set_number('3598560')->is_valid_number, '西武運輸 株式会社');
ok($zip->set_number('3598570')->is_valid_number, '西武バス 株式会社 本社');
ok($zip->set_number('3598585')->is_valid_number, '埼玉県 所沢県税事務所');
ok($zip->set_number('3598601')->is_valid_number, '所沢税務署');
ok($zip->set_number('3598648')->is_valid_number, '(株) 東京新聞ショッパー社');
ok($zip->set_number('3598686')->is_valid_number, '株式会社 タマス 所沢事業所');
ok($zip->set_number('3600192')->is_valid_number, '江南行政センター');
ok($zip->set_number('3600193')->is_valid_number, '株式会社 ゼクセルヴァレオ クライメートコントロール江南工場');
ok($zip->set_number('3600194')->is_valid_number, '立正大学 熊谷校舎');
ok($zip->set_number('3600195')->is_valid_number, '大里行政センター');
ok($zip->set_number('3600196')->is_valid_number, '株式会社 オキナヤ');
ok($zip->set_number('3608501')->is_valid_number, '埼玉県 熊谷県税事務所');
ok($zip->set_number('3608502')->is_valid_number, '(株) 八木橋');
ok($zip->set_number('3608512')->is_valid_number, '日東富士製粉 株式会社 埼玉工場');
ok($zip->set_number('3608515')->is_valid_number, 'シスコム 株式会社');
ok($zip->set_number('3608520')->is_valid_number, '関東国分 株式会社');
ok($zip->set_number('3608521')->is_valid_number, '株式会社 清水アーネット');
ok($zip->set_number('3608522')->is_valid_number, 'リケン 熊谷事業所');
ok($zip->set_number('3608523')->is_valid_number, '(株) 徳田練磨工作所');
ok($zip->set_number('3608532')->is_valid_number, '日東都市開発 株式会社');
ok($zip->set_number('3608543')->is_valid_number, '(株) アーレスティ 熊谷工場');
ok($zip->set_number('3608555')->is_valid_number, 'NTT東日本-埼玉');
ok($zip->set_number('3608558')->is_valid_number, '日本山村硝子 株式会社 埼玉工場');
ok($zip->set_number('3608559')->is_valid_number, '(株) ニコン 熊谷製作所');
ok($zip->set_number('3608567')->is_valid_number, '埼玉県厚生連 熊谷総合病院');
ok($zip->set_number('3608577')->is_valid_number, '日立金属 (株) 熊谷工場');
ok($zip->set_number('3608580')->is_valid_number, '航空自衛隊 熊谷基地');
ok($zip->set_number('3608585')->is_valid_number, '熊谷年金事務所');
ok($zip->set_number('3608601')->is_valid_number, '熊谷市役所');
ok($zip->set_number('3608608')->is_valid_number, '埼玉県信用保証協会 熊谷支店');
ok($zip->set_number('3608611')->is_valid_number, '埼玉縣信用金庫');
ok($zip->set_number('3608620')->is_valid_number, '熊谷税務署');
ok($zip->set_number('3618503')->is_valid_number, '埼玉県行田県税事務所');
ok($zip->set_number('3618504')->is_valid_number, '行田労働基準監督署');
ok($zip->set_number('3618505')->is_valid_number, '岩崎電気');
ok($zip->set_number('3618506')->is_valid_number, '株式会社 ショーワ 本社 開発本部');
ok($zip->set_number('3618507')->is_valid_number, '株式会社 ショーワ 埼玉工場');
ok($zip->set_number('3618508')->is_valid_number, '株式会社 ショーワ 生産技術本部');
ok($zip->set_number('3618510')->is_valid_number, '東京軽合金製作所');
ok($zip->set_number('3618511')->is_valid_number, 'ジェコー');
ok($zip->set_number('3618513')->is_valid_number, '電元オートメーション');
ok($zip->set_number('3618539')->is_valid_number, '森乳業');
ok($zip->set_number('3618555')->is_valid_number, '寿屋フロンテ 埼玉工場');
ok($zip->set_number('3618585')->is_valid_number, 'ニッコー');
ok($zip->set_number('3618601')->is_valid_number, '行田市役所');
ok($zip->set_number('3618602')->is_valid_number, '行田税務署');
ok($zip->set_number('3618603')->is_valid_number, '足利銀行 行田支店');
ok($zip->set_number('3618604')->is_valid_number, 'トヨクニ電線');
ok($zip->set_number('3628501')->is_valid_number, '上尾市役所');
ok($zip->set_number('3628504')->is_valid_number, '上尾税務署');
ok($zip->set_number('3628510')->is_valid_number, '東京電力 株式会社 さいたま支社 上尾営業センター');
ok($zip->set_number('3628511')->is_valid_number, '昭産開発 株式会社');
ok($zip->set_number('3628517')->is_valid_number, '伊奈町役場');
ok($zip->set_number('3628520')->is_valid_number, 'ブリヂストンサイクル (株)');
ok($zip->set_number('3628521')->is_valid_number, 'ブリヂストンサイクル東日本販売 (株)');
ok($zip->set_number('3628523')->is_valid_number, '日産ディーゼル工業 株式会社');
ok($zip->set_number('3628531')->is_valid_number, '株式会社 サイサン');
ok($zip->set_number('3628542')->is_valid_number, '株式会社 日本アクセス 埼玉支店');
ok($zip->set_number('3628550')->is_valid_number, '株式会社 アイチコーポレーション 上尾事業所');
ok($zip->set_number('3628553')->is_valid_number, '株式会社 日本アクセス 伊奈チルド物流センター');
ok($zip->set_number('3628555')->is_valid_number, 'トステムビバ 株式会社');
ok($zip->set_number('3628567')->is_valid_number, '埼玉県総合リハビリテーションセンター');
ok($zip->set_number('3628577')->is_valid_number, '大日本インキ化学工業 株式会社 埼玉工場');
ok($zip->set_number('3628585')->is_valid_number, '聖学院大学');
ok($zip->set_number('3628588')->is_valid_number, '医療法人社団 愛友会 上尾中央総合病院');
ok($zip->set_number('3628688')->is_valid_number, '株式会社 ベルーナ');
ok($zip->set_number('3638501')->is_valid_number, '桶川市役所');
ok($zip->set_number('3638509')->is_valid_number, 'マルキュー 株式会社');
ok($zip->set_number('3638510')->is_valid_number, '三菱マテリアル 株式会社 桶川製作所');
ok($zip->set_number('3638601')->is_valid_number, '三国・コカコーラボトリング 株式会社');
ok($zip->set_number('3648501')->is_valid_number, '北里研究所 メディカルセンター病院');
ok($zip->set_number('3648511')->is_valid_number, '富士重工業 株式会社 埼玉製作所');
ok($zip->set_number('3648555')->is_valid_number, 'コマツ埼玉 株式会社');
ok($zip->set_number('3648585')->is_valid_number, '株式会社 エーアンド・デイ');
ok($zip->set_number('3648633')->is_valid_number, '北本市役所');
ok($zip->set_number('3658501')->is_valid_number, '運転免許センター');
ok($zip->set_number('3658502')->is_valid_number, '鴻巣市 川里支所');
ok($zip->set_number('3658503')->is_valid_number, '(株) イングコーポレーション');
ok($zip->set_number('3658505')->is_valid_number, 'イセデリカ 株式会社 鴻巣工場');
ok($zip->set_number('3658506')->is_valid_number, '野崎印刷紙業 株式会社 関東工場');
ok($zip->set_number('3658508')->is_valid_number, 'アサヒ紙工 株式会社');
ok($zip->set_number('3658511')->is_valid_number, '株式会社 メデカジャパン');
ok($zip->set_number('3658512')->is_valid_number, '済生会鴻巣病院');
ok($zip->set_number('3658514')->is_valid_number, '(株) 広田屋');
ok($zip->set_number('3658555')->is_valid_number, 'イセ食品 株式会社');
ok($zip->set_number('3658585')->is_valid_number, '株式会社 メデカジャパン・ラボラトリー');
ok($zip->set_number('3658601')->is_valid_number, '鴻巣市役所');
ok($zip->set_number('3658603')->is_valid_number, '中央化学 株式会社');
ok($zip->set_number('3658611')->is_valid_number, '有限会社 鴻文堂書店');
ok($zip->set_number('3668501')->is_valid_number, '深谷市役所');
ok($zip->set_number('3668502')->is_valid_number, '赤城乳業 株式会社');
ok($zip->set_number('3668510')->is_valid_number, '株式会社 東芝 深谷工場');
ok($zip->set_number('3668511')->is_valid_number, '古河スカイ (株) 製板事業部 深谷工場');
ok($zip->set_number('3668515')->is_valid_number, '埼玉県立 深谷高等学校');
ok($zip->set_number('3668567')->is_valid_number, '株式会社 セキネ');
ok($zip->set_number('3668581')->is_valid_number, '三矢精工 株式会社');
ok($zip->set_number('3670192')->is_valid_number, 'キヤノン電子 株式会社 美里工場');
ok($zip->set_number('3670194')->is_valid_number, '美里町役場');
ok($zip->set_number('3670198')->is_valid_number, 'エーザイ 株式会社 美里工場');
ok($zip->set_number('3670292')->is_valid_number, '神川町役場');
ok($zip->set_number('3670297')->is_valid_number, '埼玉日本電気 株式会社');
ok($zip->set_number('3670298')->is_valid_number, '本庄市 児玉総合支所');
ok($zip->set_number('3678501')->is_valid_number, '本庄市役所');
ok($zip->set_number('3678686')->is_valid_number, '沖電気工業 株式会社');
ok($zip->set_number('3680192')->is_valid_number, '小鹿野町役場');
ok($zip->set_number('3680193')->is_valid_number, '株式会社 秩父富士');
ok($zip->set_number('3680195')->is_valid_number, '株式会社 秩父富士 長若工場');
ok($zip->set_number('3680292')->is_valid_number, '小鹿野町役場 両神庁舎');
ok($zip->set_number('3688501')->is_valid_number, '三菱マテリアル 株式会社 横瀬工場');
ok($zip->set_number('3688502')->is_valid_number, '三菱マテリアル 株式会社 セラミックス工場');
ok($zip->set_number('3688505')->is_valid_number, '菱光石灰工業 株式会社 生川事業所');
ok($zip->set_number('3688680')->is_valid_number, '株式会社 矢尾百貨店');
ok($zip->set_number('3688686')->is_valid_number, '秩父市役所');
ok($zip->set_number('3690192')->is_valid_number, '富士電機機器制御 株式会社 吹上事業所');
ok($zip->set_number('3690195')->is_valid_number, '鴻巣市 吹上支所');
ok($zip->set_number('3690198')->is_valid_number, '富士電機リテイルシステムズ 株式会社 埼玉工場');
ok($zip->set_number('3690292')->is_valid_number, '深谷市 岡部総合支所');
ok($zip->set_number('3690293')->is_valid_number, '埼玉工業大学');
ok($zip->set_number('3690295')->is_valid_number, 'リケンテクノス 株式会社');
ok($zip->set_number('3690297')->is_valid_number, '新神戸電機 株式会社 埼玉事業所');
ok($zip->set_number('3690392')->is_valid_number, '上里町役場');
ok($zip->set_number('3690393')->is_valid_number, 'キヤノン・コンポーネンツ 株式会社');
ok($zip->set_number('3690395')->is_valid_number, '株式会社 日立ハイテクノロジーズ 埼玉地区');
ok($zip->set_number('3691192')->is_valid_number, '深谷市 川本総合支所');
ok($zip->set_number('3691193')->is_valid_number, 'KYB 株式会社 熊谷工場');
ok($zip->set_number('3691195')->is_valid_number, '米久デリカ 株式会社');
ok($zip->set_number('3691292')->is_valid_number, '寄居町役場');
ok($zip->set_number('3691293')->is_valid_number, '深谷市 花園総合支所');
ok($zip->set_number('3691295')->is_valid_number, '三菱電機ホーム機器 (株)');
ok($zip->set_number('3691298')->is_valid_number, '株式会社 ベルク');
ok($zip->set_number('3691392')->is_valid_number, '長瀞町役場');
ok($zip->set_number('3691492')->is_valid_number, '皆野町役場');
ok($zip->set_number('3691592')->is_valid_number, '秩父市役所 吉田総合支所');
ok($zip->set_number('3691593')->is_valid_number, '株式会社 タイセー');
ok($zip->set_number('3691596')->is_valid_number, '株式会社 善山JAPAN ユニオンエースゴルフクラブ ホテルユニオンヴェール');
ok($zip->set_number('3691892')->is_valid_number, 'キヤノン電子 株式会社 本社影森工場');
ok($zip->set_number('3691893')->is_valid_number, '昭和電工 株式会社 秩父工場');
ok($zip->set_number('3691894')->is_valid_number, '秩父市役所 荒川総合支所');
ok($zip->set_number('3691895')->is_valid_number, '株式会社 ウッディーコイケ');
ok($zip->set_number('3691998')->is_valid_number, '秩父市役所 大滝総合支所');
ok($zip->set_number('3700193')->is_valid_number, '株式会社 日本アクセス 群馬支店');
ok($zip->set_number('3700492')->is_valid_number, '三菱電機 株式会社 群馬製作所');
ok($zip->set_number('3700495')->is_valid_number, '太田市尾島総合支所');
ok($zip->set_number('3700595')->is_valid_number, '大泉町役場');
ok($zip->set_number('3700596')->is_valid_number, '三洋電機 株式会社');
ok($zip->set_number('3700598')->is_valid_number, '千代田町役場');
ok($zip->set_number('3700692')->is_valid_number, '邑楽町役場');
ok($zip->set_number('3700795')->is_valid_number, '明和町役場');
ok($zip->set_number('3701192')->is_valid_number, '玉村町役場');
ok($zip->set_number('3701193')->is_valid_number, '群馬県立女子大学');
ok($zip->set_number('3701195')->is_valid_number, '王子チヨダコンテナー 株式会社 高崎工場');
ok($zip->set_number('3701196')->is_valid_number, '太陽誘電 (株) 玉村工場');
ok($zip->set_number('3701292')->is_valid_number, '(独) 日本原子力研究開発機構 高崎量子応用研究所');
ok($zip->set_number('3701293')->is_valid_number, '群馬県立 近代美術館');
ok($zip->set_number('3701295')->is_valid_number, 'キリンビール 株式会社 医薬探索研究所');
ok($zip->set_number('3701392')->is_valid_number, '高崎市 新町支所');
ok($zip->set_number('3701393')->is_valid_number, '学校法人 学文館法人本部 上武大学');
ok($zip->set_number('3701394')->is_valid_number, '陸上自衛隊 新町駐屯地');
ok($zip->set_number('3701395')->is_valid_number, 'カネボウフーズ 株式会社 新町工場');
ok($zip->set_number('3701396')->is_valid_number, '加ト吉水産 株式会社 フーズ部 群馬工場');
ok($zip->set_number('3701592')->is_valid_number, '神流町役場');
ok($zip->set_number('3702192')->is_valid_number, '高崎市 吉井支所');
ok($zip->set_number('3702292')->is_valid_number, '甘楽町役場');
ok($zip->set_number('3702392')->is_valid_number, '富岡市役所');
ok($zip->set_number('3702393')->is_valid_number, '公立富岡総合病院');
ok($zip->set_number('3702395')->is_valid_number, 'しののめ信用金庫');
ok($zip->set_number('3702396')->is_valid_number, '甘楽富岡農業 協同組合');
ok($zip->set_number('3702398')->is_valid_number, '株式会社 アイ・エイチ・アイ・エアロスペース 富岡事業所');
ok($zip->set_number('3702495')->is_valid_number, '株式会社 ヨコオ');
ok($zip->set_number('3702498')->is_valid_number, '株式会社 マンナンライフ');
ok($zip->set_number('3702498')->is_valid_number, '鶴田食品工業 株式会社');
ok($zip->set_number('3703192')->is_valid_number, '高崎市 箕郷支所');
ok($zip->set_number('3703392')->is_valid_number, '高崎市 榛名支所');
ok($zip->set_number('3703393')->is_valid_number, '社会福祉法人 新生会');
ok($zip->set_number('3703492')->is_valid_number, '高崎市 倉渕支所');
ok($zip->set_number('3703592')->is_valid_number, '高崎市 群馬支所');
ok($zip->set_number('3703593')->is_valid_number, '榛東村役場');
ok($zip->set_number('3703594')->is_valid_number, '陸上自衛隊 相馬原駐屯地');
ok($zip->set_number('3703692')->is_valid_number, '吉岡町役場');
ok($zip->set_number('3708501')->is_valid_number, '高崎市役所');
ok($zip->set_number('3708511')->is_valid_number, '高崎商工会議所');
ok($zip->set_number('3708522')->is_valid_number, '太陽誘電 株式会社 江木工場');
ok($zip->set_number('3708531')->is_valid_number, '前橋地方裁判所 高崎支部 前橋家庭裁判所高崎支部 高崎簡易裁判所 高崎検察審査会');
ok($zip->set_number('3708537')->is_valid_number, '独立行政法人 国立病院機構 高崎病院');
ok($zip->set_number('3708543')->is_valid_number, '東日本旅客鉄道 株式会社 高崎支社');
ok($zip->set_number('3708550')->is_valid_number, '日本たばこ産業 株式会社 高崎支店');
ok($zip->set_number('3708555')->is_valid_number, '株式会社 スズラン 高崎店');
ok($zip->set_number('3708565')->is_valid_number, '株式会社 高崎高島屋');
ok($zip->set_number('3708585')->is_valid_number, '沖電気工業 株式会社 高崎地区');
ok($zip->set_number('3708588')->is_valid_number, '井上工業 株式会社');
ok($zip->set_number('3708601')->is_valid_number, '大和証券 株式会社 高崎支店');
ok($zip->set_number('3708611')->is_valid_number, '高崎 税務署');
ok($zip->set_number('3708622')->is_valid_number, '株式会社 群馬銀行 高崎支店');
ok($zip->set_number('3708666')->is_valid_number, '東日本電信電話 (株) 群馬支店');
ok($zip->set_number('3708668')->is_valid_number, '高崎信用金庫');
ok($zip->set_number('3708686')->is_valid_number, '株式会社 ベネッセコーポレーション');
ok($zip->set_number('3710192')->is_valid_number, '前橋市 富士見支所');
ok($zip->set_number('3710294')->is_valid_number, '前橋市 宮城支所');
ok($zip->set_number('3718501')->is_valid_number, '群馬県 前橋県税事務所');
ok($zip->set_number('3718502')->is_valid_number, '群馬県社会保険診療報酬支払基金');
ok($zip->set_number('3718503')->is_valid_number, 'カネコ種苗 株式会社');
ok($zip->set_number('3718504')->is_valid_number, '中央労働金庫 群馬県本部');
ok($zip->set_number('3718505')->is_valid_number, '群馬県 市町村職員共済組合');
ok($zip->set_number('3718507')->is_valid_number, '群馬県 自動車税事務所');
ok($zip->set_number('3718508')->is_valid_number, '関東森林管理局');
ok($zip->set_number('3718510')->is_valid_number, '群馬大学 事務局 学生部 附属図書館 教育学部 社会情報学部');
ok($zip->set_number('3718511')->is_valid_number, '群馬大学 医学部');
ok($zip->set_number('3718512')->is_valid_number, '群馬大学 生体調節研究所');
ok($zip->set_number('3718513')->is_valid_number, '群馬大学 総合情報メディアセンター図書館 医学分館');
ok($zip->set_number('3718514')->is_valid_number, '群馬大学大学院 保健学研究科');
ok($zip->set_number('3718516')->is_valid_number, '全国健康保険協会 群馬支部');
ok($zip->set_number('3718517')->is_valid_number, '財団法人 群馬県長寿社会づくり財団');
ok($zip->set_number('3718522')->is_valid_number, '群馬 トヨペット株式会社');
ok($zip->set_number('3718525')->is_valid_number, '群馬県社会福祉協議会');
ok($zip->set_number('3718543')->is_valid_number, '日本ビクター 株式会社');
ok($zip->set_number('3718550')->is_valid_number, '前橋地方検察庁');
ok($zip->set_number('3718551')->is_valid_number, '群馬社会保険事務局');
ok($zip->set_number('3718567')->is_valid_number, '群馬労働局');
ok($zip->set_number('3718570')->is_valid_number, '群馬県庁');
ok($zip->set_number('3718585')->is_valid_number, '群馬県卸酒販 株式会社');
ok($zip->set_number('3718601')->is_valid_number, '前橋市役所');
ok($zip->set_number('3718611')->is_valid_number, '株式会社 群馬銀行');
ok($zip->set_number('3718640')->is_valid_number, '日本銀行 前橋支店');
ok($zip->set_number('3718666')->is_valid_number, '株式会社 上毛新聞社');
ok($zip->set_number('3718686')->is_valid_number, '前橋 税務署');
ok($zip->set_number('3728501')->is_valid_number, '伊勢崎市役所');
ok($zip->set_number('3728502')->is_valid_number, 'サンデン 株式会社');
ok($zip->set_number('3728508')->is_valid_number, '富士重工 株式会社');
ok($zip->set_number('3728558')->is_valid_number, 'サンデン 株式会社 八斗島事業所');
ok($zip->set_number('3728567')->is_valid_number, '株式会社 パイロットコーポレーション 伊勢崎工場');
ok($zip->set_number('3728580')->is_valid_number, '株式会社 ベイシア流通技術研究所');
ok($zip->set_number('3728585')->is_valid_number, '明星電気 株式会社 伊勢崎工場');
ok($zip->set_number('3728588')->is_valid_number, '上武大学');
ok($zip->set_number('3728686')->is_valid_number, '伊勢崎 税務署');
ok($zip->set_number('3738501')->is_valid_number, '富士部品工業 株式会社');
ok($zip->set_number('3738505')->is_valid_number, '東芝シリコーン 株式会社 太田事業所');
ok($zip->set_number('3738508')->is_valid_number, '群馬県太田県税事務所');
ok($zip->set_number('3738509')->is_valid_number, '群馬県太田行政事務所');
ok($zip->set_number('3738510')->is_valid_number, '坂本工業 株式会社 新島工場');
ok($zip->set_number('3738511')->is_valid_number, '県立太田女子高等学校');
ok($zip->set_number('3738513')->is_valid_number, '太田福島総合病院');
ok($zip->set_number('3738515')->is_valid_number, '関東学園大学');
ok($zip->set_number('3738521')->is_valid_number, '太田商工会議所');
ok($zip->set_number('3738530')->is_valid_number, '石橋建設工業 株式会社');
ok($zip->set_number('3738531')->is_valid_number, '前橋地方裁判所 太田支部');
ok($zip->set_number('3738540')->is_valid_number, '日産ディーゼル工業 株式会社 群馬工場');
ok($zip->set_number('3738550')->is_valid_number, '群馬県立 がんセンター');
ok($zip->set_number('3738551')->is_valid_number, '丸幸 株式会社');
ok($zip->set_number('3738555')->is_valid_number, '富士重工 株式会社 群馬製作所本工場');
ok($zip->set_number('3738557')->is_valid_number, '株式会社 栗原医療器械店');
ok($zip->set_number('3738560')->is_valid_number, '双葉繊維工業 株式会社');
ok($zip->set_number('3738561')->is_valid_number, '太田双葉カントリークラブ');
ok($zip->set_number('3738567')->is_valid_number, 'コムベックス 株式会社');
ok($zip->set_number('3738578')->is_valid_number, '株式会社 フジタコーポレーション');
ok($zip->set_number('3738585')->is_valid_number, '総合太田病院');
ok($zip->set_number('3738588')->is_valid_number, 'しげる工業 株式会社');
ok($zip->set_number('3738601')->is_valid_number, '医療法人 三省会 堀江病院');
ok($zip->set_number('3738610')->is_valid_number, '東京電力 株式会社 太田営業所');
ok($zip->set_number('3738611')->is_valid_number, '株式会社 群馬銀行 太田支店');
ok($zip->set_number('3738622')->is_valid_number, '坂本工業 株式会社 本社');
ok($zip->set_number('3738630')->is_valid_number, '株式会社 オギハラ');
ok($zip->set_number('3738639')->is_valid_number, '株式会社 大同');
ok($zip->set_number('3738660')->is_valid_number, 'NECパーソナルプロダクツ 株式会社 群馬事業場');
ok($zip->set_number('3738666')->is_valid_number, '株式会社 アイリス');
ok($zip->set_number('3738686')->is_valid_number, 'NTT 太田支店');
ok($zip->set_number('3738688')->is_valid_number, '日本生命保険 相互会社 太田支社');
ok($zip->set_number('3740192')->is_valid_number, '板倉町役場');
ok($zip->set_number('3740193')->is_valid_number, '東洋大学 板倉キャンパス');
ok($zip->set_number('3748501')->is_valid_number, '館林市役所');
ok($zip->set_number('3748510')->is_valid_number, '正田醤油 株式会社');
ok($zip->set_number('3748511')->is_valid_number, '株式会社 アルティア橋本 館林工場');
ok($zip->set_number('3748512')->is_valid_number, '株式会社 とりせん');
ok($zip->set_number('3748518')->is_valid_number, 'ニプロ医工 株式会社');
ok($zip->set_number('3748520')->is_valid_number, '正田醤油株式会社 館林工場');
ok($zip->set_number('3748521')->is_valid_number, '群馬ウシオ電機 株式会社');
ok($zip->set_number('3748533')->is_valid_number, '館林厚生病院');
ok($zip->set_number('3748555')->is_valid_number, '関東学園');
ok($zip->set_number('3748577')->is_valid_number, '株式会社 アルファ 群馬工場');
ok($zip->set_number('3748588')->is_valid_number, '株式会社 館林うどん');
ok($zip->set_number('3748601')->is_valid_number, '群馬銀行 館林支店');
ok($zip->set_number('3748608')->is_valid_number, '館林信用金庫');
ok($zip->set_number('3748611')->is_valid_number, '館林市農業協同組合');
ok($zip->set_number('3748622')->is_valid_number, '第一紙工 株式会社');
ok($zip->set_number('3748640')->is_valid_number, '館林商工会議所');
ok($zip->set_number('3748686')->is_valid_number, '館林 税務署');
ok($zip->set_number('3758501')->is_valid_number, '三菱鉛筆 株式会社 群馬工場');
ok($zip->set_number('3758502')->is_valid_number, 'ヨシモトポール 株式会社');
ok($zip->set_number('3758503')->is_valid_number, '公立 藤岡総合病院');
ok($zip->set_number('3758504')->is_valid_number, '藤岡高校');
ok($zip->set_number('3758505')->is_valid_number, '株式会社 チノー');
ok($zip->set_number('3758506')->is_valid_number, '藤岡商工会議所');
ok($zip->set_number('3758601')->is_valid_number, '藤岡市役所');
ok($zip->set_number('3758602')->is_valid_number, '藤岡 税務署');
ok($zip->set_number('3758603')->is_valid_number, '多野信用金庫');
ok($zip->set_number('3758604')->is_valid_number, '群馬銀行');
ok($zip->set_number('3760192')->is_valid_number, 'みどり市役所 大間々庁舎');
ok($zip->set_number('3760193')->is_valid_number, '星野物産 株式会社');
ok($zip->set_number('3760194')->is_valid_number, '桐生市役所 新里支所');
ok($zip->set_number('3760392')->is_valid_number, 'サンレイク草木');
ok($zip->set_number('3760397')->is_valid_number, 'みどり市役所 東庁舎');
ok($zip->set_number('3768501')->is_valid_number, '桐生市役所');
ok($zip->set_number('3768502')->is_valid_number, '株式会社 両毛システムズ');
ok($zip->set_number('3768503')->is_valid_number, '株式会社 サンフィールド・インターネット');
ok($zip->set_number('3768510')->is_valid_number, '株式会社 長崎屋 桐生店');
ok($zip->set_number('3768515')->is_valid_number, '群馬大学 工学部');
ok($zip->set_number('3768516')->is_valid_number, '群馬大学 総合情報メディアセンター図書館工学部分館');
ok($zip->set_number('3768523')->is_valid_number, '生活協同組合 コープぐんま');
ok($zip->set_number('3768528')->is_valid_number, '株式会社 桐生タイムス社');
ok($zip->set_number('3768531')->is_valid_number, '前橋地裁 桐生支部');
ok($zip->set_number('3768555')->is_valid_number, '株式会社 ミツバ');
ok($zip->set_number('3768558')->is_valid_number, '有限会社 ウオチ産業');
ok($zip->set_number('3768585')->is_valid_number, '株式会社 山田製作所');
ok($zip->set_number('3768588')->is_valid_number, '株式会社 平和');
ok($zip->set_number('3768666')->is_valid_number, '株式会社 カネトモ');
ok($zip->set_number('3768668')->is_valid_number, '桐生信用金庫');
ok($zip->set_number('3768686')->is_valid_number, '桐生 税務署');
ok($zip->set_number('3770192')->is_valid_number, '渋川市 伊香保総合支所');
ok($zip->set_number('3770193')->is_valid_number, '株式会社 福一');
ok($zip->set_number('3770195')->is_valid_number, '株式会社 天坊');
ok($zip->set_number('3770292')->is_valid_number, '渋川市 子持総合支所');
ok($zip->set_number('3770293')->is_valid_number, '日本精密測器 株式会社');
ok($zip->set_number('3770294')->is_valid_number, '社会福祉法人 渋川市社会福祉協議会 子持支所');
ok($zip->set_number('3770392')->is_valid_number, '渋川市 小野上総合支所');
ok($zip->set_number('3770395')->is_valid_number, '東吾妻町役場 東支所');
ok($zip->set_number('3770492')->is_valid_number, '中之条税務署');
ok($zip->set_number('3770494')->is_valid_number, '中之条町役場');
ok($zip->set_number('3770792')->is_valid_number, '高山村役場');
ok($zip->set_number('3770882')->is_valid_number, '原町赤十字病院');
ok($zip->set_number('3770883')->is_valid_number, '池原工業 株式会社');
ok($zip->set_number('3770892')->is_valid_number, '東吾妻町役場');
ok($zip->set_number('3770893')->is_valid_number, 'あがつま農業協同組合');
ok($zip->set_number('3770894')->is_valid_number, '群馬県立 吾妻高等学校');
ok($zip->set_number('3770896')->is_valid_number, '南波建設 株式会社');
ok($zip->set_number('3770897')->is_valid_number, 'リンテック 株式会社 吾妻工場');
ok($zip->set_number('3770898')->is_valid_number, '朝日ナショナル照明 株式会社 群馬工場');
ok($zip->set_number('3771392')->is_valid_number, '長野原町役場');
ok($zip->set_number('3771393')->is_valid_number, '群馬県立長野原高等学校');
ok($zip->set_number('3771395')->is_valid_number, '国土交通省関東地方建設局 八ツ場ダム工事事務所');
ok($zip->set_number('3771593')->is_valid_number, '鬼押出し園');
ok($zip->set_number('3771594')->is_valid_number, '嬬恋プリンスホテル 嬬恋高原ゴルフ場');
ok($zip->set_number('3771595')->is_valid_number, '万座プリンスホテル');
ok($zip->set_number('3771692')->is_valid_number, '嬬恋村役場');
ok($zip->set_number('3771693')->is_valid_number, 'JA 嬬恋村');
ok($zip->set_number('3771695')->is_valid_number, '休暇村鹿沢高原');
ok($zip->set_number('3771792')->is_valid_number, '草津町役場');
ok($zip->set_number('3771793')->is_valid_number, '株式会社 中沢ヴィレッジ');
ok($zip->set_number('3771794')->is_valid_number, '草津簡易保険保養センター');
ok($zip->set_number('3771795')->is_valid_number, '中之条町 六合支所');
ok($zip->set_number('3771796')->is_valid_number, '株式会社 ホテル一井');
ok($zip->set_number('3771797')->is_valid_number, '草津温泉旅館協同組合');
ok($zip->set_number('3778501')->is_valid_number, '渋川市役所');
ok($zip->set_number('3778502')->is_valid_number, '渋川市 北橘総合支所');
ok($zip->set_number('3778503')->is_valid_number, '太田物産 株式会社');
ok($zip->set_number('3778508')->is_valid_number, 'エクセルイン渋川');
ok($zip->set_number('3778510')->is_valid_number, '株式会社 小笠原');
ok($zip->set_number('3778511')->is_valid_number, '独立行政法人 国立病院機構 西群馬病院');
ok($zip->set_number('3778513')->is_valid_number, '関東電化工業 株式会社 渋川工場');
ok($zip->set_number('3778520')->is_valid_number, '電気化学工業 株式会社 渋川工場');
ok($zip->set_number('3778533')->is_valid_number, '株式会社 津久井工務店');
ok($zip->set_number('3778555')->is_valid_number, '財団法人 群馬県埋蔵文化財調査事業団');
ok($zip->set_number('3778567')->is_valid_number, '社会福祉法人 恵の園');
ok($zip->set_number('3778577')->is_valid_number, '群馬県立 小児医療センター');
ok($zip->set_number('3778585')->is_valid_number, '南澤建設 株式会社');
ok($zip->set_number('3778588')->is_valid_number, '日本年金機構 渋川年金事務所');
ok($zip->set_number('3778601')->is_valid_number, '日本カーリット 株式会社');
ok($zip->set_number('3778616')->is_valid_number, '北群馬信用金庫');
ok($zip->set_number('3780498')->is_valid_number, '片品村役場');
ok($zip->set_number('3788501')->is_valid_number, '沼田市役所');
ok($zip->set_number('3790192')->is_valid_number, '安中市役所');
ok($zip->set_number('3790193')->is_valid_number, '群馬県信用組合');
ok($zip->set_number('3790195')->is_valid_number, '信越化学工業 株式会社 群馬事業所');
ok($zip->set_number('3790196')->is_valid_number, '信越半導体 株式会社 磯部工場');
ok($zip->set_number('3790292')->is_valid_number, '安中市役所 松井田支所');
ok($zip->set_number('3791192')->is_valid_number, '赤城総合支所');
ok($zip->set_number('3791298')->is_valid_number, '昭和村役場');
ok($zip->set_number('3791393')->is_valid_number, 'みなかみ町役場');
ok($zip->set_number('3791498')->is_valid_number, 'みなかみ町役場 新治支所');
ok($zip->set_number('3791692')->is_valid_number, 'みなかみ町役場 水上支所');
ok($zip->set_number('3792180')->is_valid_number, '株式会社 チヨダコーポレーション');
ok($zip->set_number('3792181')->is_valid_number, '群馬県赤十字血液センター');
ok($zip->set_number('3792184')->is_valid_number, '学校法人 山崎学園');
ok($zip->set_number('3792185')->is_valid_number, '共愛学園中学高等学校');
ok($zip->set_number('3792187')->is_valid_number, '株式会社 ベイシア');
ok($zip->set_number('3792192')->is_valid_number, '共愛学園前橋国際大学');
ok($zip->set_number('3792193')->is_valid_number, 'ナイス 株式会社 前橋市場');
ok($zip->set_number('3792194')->is_valid_number, '社団法人 群馬県トラック協会');
ok($zip->set_number('3792195')->is_valid_number, 'マック食品 株式会社');
ok($zip->set_number('3792197')->is_valid_number, 'マチダコーポレーション 株式会社');
ok($zip->set_number('3792198')->is_valid_number, '株式会社 フレッセイ');
ok($zip->set_number('3792292')->is_valid_number, '伊勢崎市 あずま支所');
ok($zip->set_number('3792298')->is_valid_number, '伊勢崎市 赤堀支所');
ok($zip->set_number('3792392')->is_valid_number, '桐生短期大学');
ok($zip->set_number('3792393')->is_valid_number, '太田市薮塚本町総合支所');
ok($zip->set_number('3792395')->is_valid_number, 'みどり市役所 笠懸庁舎');
ok($zip->set_number('3792398')->is_valid_number, '関東開発 株式会社');
ok($zip->set_number('3808501')->is_valid_number, '善光寺大勧進');
ok($zip->set_number('3808502')->is_valid_number, 'NHK 長野放送局');
ok($zip->set_number('3808503')->is_valid_number, '株式会社 たちばな');
ok($zip->set_number('3808505')->is_valid_number, '大和ハウス工業 株式会社 長野支店');
ok($zip->set_number('3808506')->is_valid_number, '社団法人 長野県雇用開発協会');
ok($zip->set_number('3808507')->is_valid_number, '昭和電機産業 株式会社');
ok($zip->set_number('3808508')->is_valid_number, '東京海上日動火災保険 株式会社 長野支店');
ok($zip->set_number('3808510')->is_valid_number, '長野県警察本部');
ok($zip->set_number('3808511')->is_valid_number, 'NTT 年金医療保険センター');
ok($zip->set_number('3808512')->is_valid_number, '長野市役所');
ok($zip->set_number('3808515')->is_valid_number, '長野県長野高等学校');
ok($zip->set_number('3808516')->is_valid_number, '株式会社 丸乙 小林商店');
ok($zip->set_number('3808518')->is_valid_number, '株式会社 トーエネック長野支店');
ok($zip->set_number('3808519')->is_valid_number, 'NTT 長野支店');
ok($zip->set_number('3808520')->is_valid_number, '株式会社 林');
ok($zip->set_number('3808521')->is_valid_number, '信越放送 株式会社');
ok($zip->set_number('3808522')->is_valid_number, '株式会社 蔦友');
ok($zip->set_number('3808524')->is_valid_number, '北野建設 株式会社');
ok($zip->set_number('3808525')->is_valid_number, '長野県短期大学');
ok($zip->set_number('3808526')->is_valid_number, '日東都市開発 株式会社 長野事業所');
ok($zip->set_number('3808530')->is_valid_number, '長野県長野西高等学校');
ok($zip->set_number('3808531')->is_valid_number, '丸文商事 株式会社');
ok($zip->set_number('3808533')->is_valid_number, '株式会社 守谷商会');
ok($zip->set_number('3808534')->is_valid_number, '信州ジャスコ 株式会社 長野店');
ok($zip->set_number('3808535')->is_valid_number, '長野県 社会保険診療報酬支払基金');
ok($zip->set_number('3808536')->is_valid_number, '株式会社 NTTドコモ長野支店');
ok($zip->set_number('3808537')->is_valid_number, '東日本建設業保証 株式会社 長野支店');
ok($zip->set_number('3808538')->is_valid_number, '株式会社 帝国データバンク 長野支店');
ok($zip->set_number('3808539')->is_valid_number, '株式会社 ながの東急百貨店');
ok($zip->set_number('3808540')->is_valid_number, '株式会社 ケイシイシイ');
ok($zip->set_number('3808543')->is_valid_number, '長野ステーションビル 株式会社');
ok($zip->set_number('3808545')->is_valid_number, '財団法人 長野県労働会館');
ok($zip->set_number('3808546')->is_valid_number, '信濃毎日新聞 株式会社');
ok($zip->set_number('3808550')->is_valid_number, '長野朝日放送 株式会社');
ok($zip->set_number('3808551')->is_valid_number, '長野県酒類販売 株式会社');
ok($zip->set_number('3808552')->is_valid_number, '株式会社 夏目');
ok($zip->set_number('3808555')->is_valid_number, '株式会社 テレビ信州');
ok($zip->set_number('3808557')->is_valid_number, '住友生命保険 相互会社 長野支社');
ok($zip->set_number('3808558')->is_valid_number, '日本信販 株式会社 長野支店');
ok($zip->set_number('3808560')->is_valid_number, 'マルナカ通商 株式会社');
ok($zip->set_number('3808561')->is_valid_number, '(株) YKKAP長野');
ok($zip->set_number('3808565')->is_valid_number, '株式会社 長野ダイハツモータース');
ok($zip->set_number('3808566')->is_valid_number, '第一法規出版 株式会社');
ok($zip->set_number('3808567')->is_valid_number, '社団法人 長野県林業センター');
ok($zip->set_number('3808568')->is_valid_number, '株式会社 長野バスターミナル');
ok($zip->set_number('3808570')->is_valid_number, '長野県庁');
ok($zip->set_number('3808572')->is_valid_number, '長野労働局');
ok($zip->set_number('3808573')->is_valid_number, '長野労働基準監督署');
ok($zip->set_number('3808575')->is_valid_number, '中部森林管理局');
ok($zip->set_number('3808576')->is_valid_number, '株式会社 エヌ・ティ・ティ・テレコムエンジニアリング 信越');
ok($zip->set_number('3808577')->is_valid_number, '株式会社 協同測量社');
ok($zip->set_number('3808580')->is_valid_number, '財団法人 郵政福祉 信越地方本部');
ok($zip->set_number('3808581')->is_valid_number, '株式会社インテージ長野');
ok($zip->set_number('3808583')->is_valid_number, '全国健康保険協会 長野支部');
ok($zip->set_number('3808584')->is_valid_number, 'メルパルク長野(メルパルクナガノ)');
ok($zip->set_number('3808585')->is_valid_number, '社団法人 長野県地域包括医療協議会');
ok($zip->set_number('3808586')->is_valid_number, '長野県 市町村職員共済組合(山王共済会館)');
ok($zip->set_number('3808588')->is_valid_number, '株式会社 シューマート');
ok($zip->set_number('3808589')->is_valid_number, '郵便局ビジネスサポート 株式会社 信越地方運用センター');
ok($zip->set_number('3808601')->is_valid_number, 'テルウェル東日本 株式会社 首都圏北支店 長野営業担当');
ok($zip->set_number('3808605')->is_valid_number, '丸小商事 株式会社');
ok($zip->set_number('3808608')->is_valid_number, '株式会社 越前屋');
ok($zip->set_number('3808610')->is_valid_number, 'カワイ 株式会社');
ok($zip->set_number('3808611')->is_valid_number, '長野県 労働金庫');
ok($zip->set_number('3808612')->is_valid_number, '長野税務署');
ok($zip->set_number('3808614')->is_valid_number, '全国農業協同組合連合会 長野県支部');
ok($zip->set_number('3808622')->is_valid_number, '株式会社 新建新聞社');
ok($zip->set_number('3808630')->is_valid_number, '鹿島・北野建設共同企業体 長野県庁本館棟耐震改修建築工事事務所');
ok($zip->set_number('3808633')->is_valid_number, '株式会社 長野放送');
ok($zip->set_number('3808639')->is_valid_number, 'JA長野共済連');
ok($zip->set_number('3808640')->is_valid_number, '野村證券 株式会社 長野支店');
ok($zip->set_number('3808648')->is_valid_number, '第一生命保険 相互会社 長野支社');
ok($zip->set_number('3808655')->is_valid_number, '日本生命保険 相互会社 長野支社');
ok($zip->set_number('3808660')->is_valid_number, 'NTT信越情報システムセンター');
ok($zip->set_number('3808666')->is_valid_number, '中部電力 株式会社 長野支店');
ok($zip->set_number('3808668')->is_valid_number, '長野県 信用組合');
ok($zip->set_number('3808686')->is_valid_number, '長野信用金庫');
ok($zip->set_number('3808688')->is_valid_number, '東京法令出版 株式会社');
ok($zip->set_number('3808794')->is_valid_number, '長野貯金事務センター');
ok($zip->set_number('3808795')->is_valid_number, '信越総合通信局');
ok($zip->set_number('3808796')->is_valid_number, '信越監査室');
ok($zip->set_number('3808797')->is_valid_number, '株式会社 ゆうちょ銀行 長野支店');
ok($zip->set_number('3808797')->is_valid_number, '株式会社 かんぽ生命 長野支店');
ok($zip->set_number('3808797')->is_valid_number, '郵便局 株式会社 信越支社');
ok($zip->set_number('3808797')->is_valid_number, '郵便事業 株式会社 信越支社');
ok($zip->set_number('3808798')->is_valid_number, '信越郵政研修センター');
ok($zip->set_number('3810192')->is_valid_number, '株式会社 丸水長野県水 長野支店');
ok($zip->set_number('3810193')->is_valid_number, '東日本システム建設 株式会社');
ok($zip->set_number('3810292')->is_valid_number, '株式会社 竹風堂');
ok($zip->set_number('3810293')->is_valid_number, '株式会社 小布施堂');
ok($zip->set_number('3810295')->is_valid_number, '新生病院');
ok($zip->set_number('3810297')->is_valid_number, '小布施町役場');
ok($zip->set_number('3810298')->is_valid_number, '桜井甘精堂');
ok($zip->set_number('3810497')->is_valid_number, '志賀高原プリンスホテル');
ok($zip->set_number('3810498')->is_valid_number, '山ノ内町役場');
ok($zip->set_number('3812281')->is_valid_number, '株式会社 マルイチ産商');
ok($zip->set_number('3812282')->is_valid_number, '長野愛知電機 株式会社');
ok($zip->set_number('3812283')->is_valid_number, 'ミヤマ 株式会社');
ok($zip->set_number('3812285')->is_valid_number, '長野日野自動車 株式会社');
ok($zip->set_number('3812286')->is_valid_number, '株式会社 丸水長野県水');
ok($zip->set_number('3812287')->is_valid_number, '新光電気工業 株式会社');
ok($zip->set_number('3812288')->is_valid_number, '長野日本無線 株式会社');
ok($zip->set_number('3812292')->is_valid_number, '株式会社 エス・エス・ブイ');
ok($zip->set_number('3812295')->is_valid_number, 'セラテックジャパン (株)');
ok($zip->set_number('3812298')->is_valid_number, '財団法人 長野県健康づくり事業団');
ok($zip->set_number('3814192')->is_valid_number, '長野市役所 戸隠支所');
ok($zip->set_number('3814193')->is_valid_number, '株式会社 おびなた');
ok($zip->set_number('3814393')->is_valid_number, '有限会社 いろは堂');
ok($zip->set_number('3818501')->is_valid_number, '富士通 株式会社 長野工場');
ok($zip->set_number('3818503')->is_valid_number, '新潟運輸局 長野陸運支局');
ok($zip->set_number('3818508')->is_valid_number, '株式会社 デジタル・ラボラトリー');
ok($zip->set_number('3818510')->is_valid_number, '社団法人 長野県自動車整備振興会');
ok($zip->set_number('3818511')->is_valid_number, '蔦友印刷 株式会社');
ok($zip->set_number('3818512')->is_valid_number, '株式会社 クギヤ');
ok($zip->set_number('3818520')->is_valid_number, '株式会社 シンエイハイテック');
ok($zip->set_number('3818525')->is_valid_number, '株式会社 デンセン');
ok($zip->set_number('3818530')->is_valid_number, '麻場産業 株式会社');
ok($zip->set_number('3818539')->is_valid_number, '松田産業 株式会社');
ok($zip->set_number('3818545')->is_valid_number, '株式会社 クリエイティブヨーコ');
ok($zip->set_number('3818548')->is_valid_number, '東日本システム建設 株式会社');
ok($zip->set_number('3818556')->is_valid_number, '長野県 トラック会館');
ok($zip->set_number('3818558')->is_valid_number, '長野北社会保険事務所');
ok($zip->set_number('3818560')->is_valid_number, '岡谷酸素 株式会社 長野事業部');
ok($zip->set_number('3818567')->is_valid_number, '国立療養所 東長野病院');
ok($zip->set_number('3818570')->is_valid_number, '長野県立 長野吉田高校');
ok($zip->set_number('3818577')->is_valid_number, '長野県 身体障害者リハビリテーションセンター');
ok($zip->set_number('3818580')->is_valid_number, '社会福祉法人 長野若槻園');
ok($zip->set_number('3818588')->is_valid_number, '株式会社 本久');
ok($zip->set_number('3818602')->is_valid_number, '富国物産 株式会社');
ok($zip->set_number('3818686')->is_valid_number, '株式会社 角藤');
ok($zip->set_number('3818791')->is_valid_number, '共通事務センター');
ok($zip->set_number('3818793')->is_valid_number, '郵便事業株式会社 信越支社 郵便事業部 (三種)');
ok($zip->set_number('3828501')->is_valid_number, '富士通 株式会社 須坂工場');
ok($zip->set_number('3828502')->is_valid_number, 'オリオン機械 株式会社');
ok($zip->set_number('3828508')->is_valid_number, 'アスザック 株式会社');
ok($zip->set_number('3828510')->is_valid_number, '高山村役場');
ok($zip->set_number('3828511')->is_valid_number, '須坂市役所');
ok($zip->set_number('3828533')->is_valid_number, '株式会社 サンジュニア');
ok($zip->set_number('3828555')->is_valid_number, '株式会社 前田鉄工所');
ok($zip->set_number('3828585')->is_valid_number, '北陸コカ・コーラボトリング 株式会社');
ok($zip->set_number('3828587')->is_valid_number, '須高農業協同組合');
ok($zip->set_number('3828588')->is_valid_number, '株式会社 鈴木');
ok($zip->set_number('3828633')->is_valid_number, '長野刑務所');
ok($zip->set_number('3838501')->is_valid_number, '有限会社 小林果樹園');
ok($zip->set_number('3838505')->is_valid_number, 'JA 長野厚生連 北信総合病院');
ok($zip->set_number('3838506')->is_valid_number, '長野県 中野高等学校');
ok($zip->set_number('3838511')->is_valid_number, '長野県 中野西高等学校');
ok($zip->set_number('3838515')->is_valid_number, '長野県 北信合同庁舎');
ok($zip->set_number('3838555')->is_valid_number, '株式会社 コシナ');
ok($zip->set_number('3838567')->is_valid_number, '中野実業高等学校');
ok($zip->set_number('3838581')->is_valid_number, '新光電気工業 株式会社 高丘工場');
ok($zip->set_number('3838585')->is_valid_number, '株式会社 タカギセイコー');
ok($zip->set_number('3838588')->is_valid_number, '中野市農業協同組合');
ok($zip->set_number('3838614')->is_valid_number, '中野市役所');
ok($zip->set_number('3838686')->is_valid_number, '信濃中野税務署');
ok($zip->set_number('3840692')->is_valid_number, '株式会社 八十二銀行 佐久町支店');
ok($zip->set_number('3840695')->is_valid_number, '南佐久農業協同組合');
ok($zip->set_number('3840697')->is_valid_number, '佐久穂町役場 佐久庁舎');
ok($zip->set_number('3840698')->is_valid_number, '佐久穂町立 千曲病院');
ok($zip->set_number('3840798')->is_valid_number, '佐久穂町役場 八千穂庁舎');
ok($zip->set_number('3841192')->is_valid_number, '小海町役場');
ok($zip->set_number('3842292')->is_valid_number, '川西赤十字病院');
ok($zip->set_number('3848501')->is_valid_number, '小諸市役所');
ok($zip->set_number('3848558')->is_valid_number, '中棚温泉 中棚荘');
ok($zip->set_number('3848585')->is_valid_number, '日精エー・エス・ビー機械 株式会社');
ok($zip->set_number('3848588')->is_valid_number, '小諸厚生総合病院');
ok($zip->set_number('3848605')->is_valid_number, '小諸社会保険事務所');
ok($zip->set_number('3858501')->is_valid_number, '佐久市役所');
ok($zip->set_number('3858511')->is_valid_number, '樫山工業 株式会社');
ok($zip->set_number('3858522')->is_valid_number, 'ジャスコ 佐久平店');
ok($zip->set_number('3858533')->is_valid_number, '佐久地方事務所');
ok($zip->set_number('3858555')->is_valid_number, 'TDK株式会社 浅間テクノ工場');
ok($zip->set_number('3858558')->is_valid_number, '佐久市立国保 浅間総合病院');
ok($zip->set_number('3858585')->is_valid_number, 'JA 佐久浅間');
ok($zip->set_number('3858586')->is_valid_number, 'ツガミ 株式会社 信州工場');
ok($zip->set_number('3858588')->is_valid_number, '佐久長聖高等学校');
ok($zip->set_number('3858601')->is_valid_number, 'TDK 株式会社 千曲川テクノ工場');
ok($zip->set_number('3858611')->is_valid_number, '佐久税務署');
ok($zip->set_number('3860192')->is_valid_number, '東京特殊電線 株式会社');
ok($zip->set_number('3860393')->is_valid_number, '三才山病院');
ok($zip->set_number('3860396')->is_valid_number, '鹿教湯病院');
ok($zip->set_number('3860492')->is_valid_number, '上田市役所 丸子地域自治センター');
ok($zip->set_number('3860493')->is_valid_number, '医療法人 丸山会 丸子中央総合病院');
ok($zip->set_number('3860495')->is_valid_number, '三洋精密 株式会社');
ok($zip->set_number('3860497')->is_valid_number, '松山 株式会社');
ok($zip->set_number('3860498')->is_valid_number, 'シナノケンシ 株式会社');
ok($zip->set_number('3860592')->is_valid_number, '武石地域自治センター');
ok($zip->set_number('3861192')->is_valid_number, '日置電機 株式会社');
ok($zip->set_number('3861193')->is_valid_number, 'カネテック 株式会社');
ok($zip->set_number('3861298')->is_valid_number, '長野大学');
ok($zip->set_number('3862292')->is_valid_number, '上田市役所 真田地域自治センター');
ok($zip->set_number('3868501')->is_valid_number, '長野計器 株式会社');
ok($zip->set_number('3868505')->is_valid_number, '日信工業 株式会社');
ok($zip->set_number('3868510')->is_valid_number, '医療法人 健静会 上田病院');
ok($zip->set_number('3868511')->is_valid_number, '上田警察署');
ok($zip->set_number('3868522')->is_valid_number, '上田商工会議所');
ok($zip->set_number('3868543')->is_valid_number, '医療法人 慈善会 安藤病院');
ok($zip->set_number('3868551')->is_valid_number, '株式会社 新村');
ok($zip->set_number('3868553')->is_valid_number, '鍋林 株式会社 上田支店');
ok($zip->set_number('3868555')->is_valid_number, '長野県 上田合同庁舎');
ok($zip->set_number('3868558')->is_valid_number, '株式会社 ミヤノ');
ok($zip->set_number('3868567')->is_valid_number, '信州大学 繊維学部');
ok($zip->set_number('3868577')->is_valid_number, '上田交通 株式会社');
ok($zip->set_number('3868584')->is_valid_number, '医療法人 友愛会 千曲荘病院');
ok($zip->set_number('3868585')->is_valid_number, '長野県 上田千曲高等学校');
ok($zip->set_number('3868588')->is_valid_number, '永井プラスチック工業 株式会社');
ok($zip->set_number('3868601')->is_valid_number, '上田市役所');
ok($zip->set_number('3868607')->is_valid_number, '日本たばこ産業 株式会社 上田工場');
ok($zip->set_number('3868608')->is_valid_number, '上田日本無線 株式会社');
ok($zip->set_number('3868609')->is_valid_number, 'ハローワーク上田(上田公共職業安定所)');
ok($zip->set_number('3868610')->is_valid_number, '国立 長野病院');
ok($zip->set_number('3868611')->is_valid_number, '笠原工業 株式会社 上田工場');
ok($zip->set_number('3868624')->is_valid_number, '上田西高等学校');
ok($zip->set_number('3868634')->is_valid_number, '山洋電気 株式会社 上田事業所 神川工場');
ok($zip->set_number('3868638')->is_valid_number, '株式会社 三葉製作所');
ok($zip->set_number('3868666')->is_valid_number, '株式会社 信和');
ok($zip->set_number('3868668')->is_valid_number, '信州うえだ 農業協同組合');
ok($zip->set_number('3868677')->is_valid_number, 'LIVIN');
ok($zip->set_number('3868683')->is_valid_number, '長野県 上田東高等学校');
ok($zip->set_number('3868685')->is_valid_number, '長野県 上田染谷丘高等学校');
ok($zip->set_number('3868686')->is_valid_number, '信州ハム 株式会社');
ok($zip->set_number('3868688')->is_valid_number, '長野県厚生農業協同組合連合会 鹿教湯三才山リハビリテーションセンター 介護療養型老人保健施設いずみの');
ok($zip->set_number('3868701')->is_valid_number, '上田信用金庫');
ok($zip->set_number('3868705')->is_valid_number, '中部電力 株式会社 上田営業所');
ok($zip->set_number('3868710')->is_valid_number, '株式会社 八十二銀行 上田支店');
ok($zip->set_number('3868715')->is_valid_number, '長野県 上田高等学校');
ok($zip->set_number('3868720')->is_valid_number, '上田税務署');
ok($zip->set_number('3878501')->is_valid_number, '長野県 屋代高等学校');
ok($zip->set_number('3878502')->is_valid_number, '長野県 屋代南高等学校');
ok($zip->set_number('3878503')->is_valid_number, '株式会社 菱食 長野支店');
ok($zip->set_number('3878511')->is_valid_number, '千曲市役所');
ok($zip->set_number('3878512')->is_valid_number, '更埴中央病院');
ok($zip->set_number('3878521')->is_valid_number, 'ちくま農業協同組合');
ok($zip->set_number('3878555')->is_valid_number, '長野電子工業 株式会社');
ok($zip->set_number('3878561')->is_valid_number, '長野工業 株式会社');
ok($zip->set_number('3878585')->is_valid_number, '丸善食品工業 株式会社');
ok($zip->set_number('3878601')->is_valid_number, 'フレックスジャパン 株式会社');
ok($zip->set_number('3878603')->is_valid_number, 'エムケー精工 株式会社');
ok($zip->set_number('3888511')->is_valid_number, 'JAグリーン長野');
ok($zip->set_number('3888522')->is_valid_number, '株式会社 前田製作所');
ok($zip->set_number('3888555')->is_valid_number, 'コープながの');
ok($zip->set_number('3890192')->is_valid_number, '軽井沢町役場');
ok($zip->set_number('3890194')->is_valid_number, '株式会社 星野リゾート');
ok($zip->set_number('3890195')->is_valid_number, 'ホテルブレストンコート');
ok($zip->set_number('3890196')->is_valid_number, '塩壺温泉ホテル');
ok($zip->set_number('3890197')->is_valid_number, '軽井沢72ゴルフ');
ok($zip->set_number('3890198')->is_valid_number, '軽井沢千ヶ滝温泉ホテル');
ok($zip->set_number('3890292')->is_valid_number, '御代田町役場');
ok($zip->set_number('3890293')->is_valid_number, 'ミネベア 株式会社 軽井沢工場');
ok($zip->set_number('3890295')->is_valid_number, 'シチズンファインテックミヨタ 株式会社');
ok($zip->set_number('3890296')->is_valid_number, 'ミネベアモータ 株式会社 軽井沢事業所');
ok($zip->set_number('3890298')->is_valid_number, 'シチズン時計ミヨタ 株式会社');
ok($zip->set_number('3890592')->is_valid_number, '東御市役所');
ok($zip->set_number('3890593')->is_valid_number, '株式会社 アヅマ');
ok($zip->set_number('3890595')->is_valid_number, 'マルイチ産商');
ok($zip->set_number('3890598')->is_valid_number, '永井農場');
ok($zip->set_number('3890681')->is_valid_number, '(株) 都築製作所');
ok($zip->set_number('3890682')->is_valid_number, 'ミヤリサン (株)');
ok($zip->set_number('3890688')->is_valid_number, '(株) 柳沢精機製作所');
ok($zip->set_number('3890692')->is_valid_number, '坂城町役場');
ok($zip->set_number('3890693')->is_valid_number, '日精樹脂工業 (株)');
ok($zip->set_number('3890695')->is_valid_number, '(株) 栗林製作所');
ok($zip->set_number('3890696')->is_valid_number, 'デイリーフーズ (株)');
ok($zip->set_number('3890697')->is_valid_number, '寿製薬 (株)');
ok($zip->set_number('3890698')->is_valid_number, '(株) アルプスツール');
ok($zip->set_number('3890892')->is_valid_number, '千曲市役所 戸倉庁舎');
ok($zip->set_number('3890893')->is_valid_number, '株式会社 宮下商店');
ok($zip->set_number('3890897')->is_valid_number, '千曲市役所 上山田庁舎');
ok($zip->set_number('3890898')->is_valid_number, 'アピックヤマダ 株式会社');
ok($zip->set_number('3891192')->is_valid_number, '長野市役所 豊野支所');
ok($zip->set_number('3891195')->is_valid_number, '鳥居化成 株式会社');
ok($zip->set_number('3891196')->is_valid_number, '仁科工業 株式会社');
ok($zip->set_number('3891293')->is_valid_number, '飯綱町役場');
ok($zip->set_number('3891392')->is_valid_number, '信濃町役場');
ok($zip->set_number('3892192')->is_valid_number, '中野市役所 豊田支所');
ok($zip->set_number('3892292')->is_valid_number, '飯山市役所');
ok($zip->set_number('3892298')->is_valid_number, '株式会社 しなの富士通');
ok($zip->set_number('3892392')->is_valid_number, '木島平村役場');
ok($zip->set_number('3892592')->is_valid_number, '野沢温泉村役場');
ok($zip->set_number('3892792')->is_valid_number, '栄村役場');
ok($zip->set_number('3901181')->is_valid_number, '株式会社 アップルランド');
ok($zip->set_number('3901182')->is_valid_number, '松本養護学校');
ok($zip->set_number('3901183')->is_valid_number, '片倉機器工業 株式会社');
ok($zip->set_number('3901185')->is_valid_number, '松築 株式会社');
ok($zip->set_number('3901186')->is_valid_number, '株式会社 マルイチ産商 松本支店');
ok($zip->set_number('3901187')->is_valid_number, '株式会社 エフケーケー');
ok($zip->set_number('3901188')->is_valid_number, '朝日村役場');
ok($zip->set_number('3901189')->is_valid_number, 'エヌシーシー 株式会社 松本支店');
ok($zip->set_number('3901193')->is_valid_number, '信濃朝日農協');
ok($zip->set_number('3901197')->is_valid_number, '長野三菱ふそう自動車販売 株式会社 松本支店');
ok($zip->set_number('3901198')->is_valid_number, '株式会社 ワールドインダストリー松本技術研究所');
ok($zip->set_number('3901293')->is_valid_number, 'キッセイコムテック 株式会社');
ok($zip->set_number('3901295')->is_valid_number, '松本大学');
ok($zip->set_number('3901295')->is_valid_number, '松本大学 松商短期大学部');
ok($zip->set_number('3901298')->is_valid_number, '東洋計器 株式会社');
ok($zip->set_number('3901392')->is_valid_number, '山形村役場');
ok($zip->set_number('3901393')->is_valid_number, 'サンリン 株式会社');
ok($zip->set_number('3901394')->is_valid_number, 'アイシティー21 株式会社 井上');
ok($zip->set_number('3901492')->is_valid_number, '松本市役所 波田支所');
ok($zip->set_number('3901592')->is_valid_number, '松本市役所 安曇支所');
ok($zip->set_number('3901792')->is_valid_number, '松本市役所 梓川支所');
ok($zip->set_number('3908501')->is_valid_number, '岡野薬品 株式会社');
ok($zip->set_number('3908502')->is_valid_number, 'NHK 松本支局');
ok($zip->set_number('3908503')->is_valid_number, '松本商工会議所');
ok($zip->set_number('3908505')->is_valid_number, '松本協立病院');
ok($zip->set_number('3908506')->is_valid_number, '中部電力 株式会社 松本営業所');
ok($zip->set_number('3908507')->is_valid_number, '株式会社 井上');
ok($zip->set_number('3908508')->is_valid_number, '陸上自衛隊 松本駐屯地');
ok($zip->set_number('3908510')->is_valid_number, '特定医療法人 慈泉会 (財団) 相沢病院');
ok($zip->set_number('3908511')->is_valid_number, '社団法人 才能教育研究会');
ok($zip->set_number('3908513')->is_valid_number, '長野ニューホーム');
ok($zip->set_number('3908515')->is_valid_number, '松商学園高等学校');
ok($zip->set_number('3908518')->is_valid_number, '松本電気鉄道 株式会社');
ok($zip->set_number('3908520')->is_valid_number, '長野エフエム放送 株式会社');
ok($zip->set_number('3908523')->is_valid_number, '松本日産自動車 株式会社');
ok($zip->set_number('3908525')->is_valid_number, '長野県松本工業高等学校');
ok($zip->set_number('3908528')->is_valid_number, '信州ジャスコ 株式会社');
ok($zip->set_number('3908530')->is_valid_number, 'シンケン 株式会社');
ok($zip->set_number('3908531')->is_valid_number, '長野県 松本筑摩高等学校');
ok($zip->set_number('3908533')->is_valid_number, 'トヨタカローラ南信 株式会社');
ok($zip->set_number('3908535')->is_valid_number, '国民生活金融公庫');
ok($zip->set_number('3908539')->is_valid_number, '(株) 市民タイムス');
ok($zip->set_number('3908540')->is_valid_number, 'ソラン 株式会社');
ok($zip->set_number('3908541')->is_valid_number, 'ハナ信用組合 松本支店');
ok($zip->set_number('3908543')->is_valid_number, '長野県松本県ケ丘高等学校');
ok($zip->set_number('3908555')->is_valid_number, '松本ハイランド農協');
ok($zip->set_number('3908601')->is_valid_number, '医療法人抱生会 丸の内病院');
ok($zip->set_number('3908602')->is_valid_number, '長野県松本美須々ケ丘高等学校');
ok($zip->set_number('3908603')->is_valid_number, '長野県松本深志高等学校');
ok($zip->set_number('3908605')->is_valid_number, '長野県松本蟻ケ崎高等学校');
ok($zip->set_number('3908610')->is_valid_number, '株式会社 エイコー');
ok($zip->set_number('3908611')->is_valid_number, '株式会社 テレビ信州');
ok($zip->set_number('3908615')->is_valid_number, 'マルマツ 株式会社');
ok($zip->set_number('3908620')->is_valid_number, '松本市役所');
ok($zip->set_number('3908621')->is_valid_number, '信州大学');
ok($zip->set_number('3908623')->is_valid_number, '学校法人 外語学園 信農むつみ高等学校');
ok($zip->set_number('3908630')->is_valid_number, '株式会社 ニシマ');
ok($zip->set_number('3908639')->is_valid_number, '株式会社 アスピア');
ok($zip->set_number('3908640')->is_valid_number, 'セイコーエプソン 株式会社 島内事業所');
ok($zip->set_number('3908648')->is_valid_number, '医療法人 城西医療財団 城西病院');
ok($zip->set_number('3908686')->is_valid_number, '株式会社 中部日本医薬');
ok($zip->set_number('3908701')->is_valid_number, '日本生命保険 相互会社 松本支社');
ok($zip->set_number('3908702')->is_valid_number, '松本社会保険事務所');
ok($zip->set_number('3908703')->is_valid_number, 'NTT 松本営業支店');
ok($zip->set_number('3908707')->is_valid_number, '第一生命保険 相互会社 松本支社');
ok($zip->set_number('3908710')->is_valid_number, '松本税務署');
ok($zip->set_number('3908711')->is_valid_number, '松本ガス 株式会社');
ok($zip->set_number('3908712')->is_valid_number, '日本銀行 松本支店');
ok($zip->set_number('3908714')->is_valid_number, '石川島芝浦機械 株式会社 松本工場');
ok($zip->set_number('3908715')->is_valid_number, '株式会社 第一勧業銀行 松本支店');
ok($zip->set_number('3908722')->is_valid_number, '鍋林 株式会社');
ok($zip->set_number('3910192')->is_valid_number, '原村役場');
ok($zip->set_number('3910292')->is_valid_number, '諏訪 東京理科大学');
ok($zip->set_number('3910293')->is_valid_number, '株式会社 コダックデジタルプロダクトセンター');
ok($zip->set_number('3910294')->is_valid_number, '株式会社 ダイイチコンポーネンツ');
ok($zip->set_number('3910295')->is_valid_number, '宮坂ゴム 株式会社');
ok($zip->set_number('3910296')->is_valid_number, '株式会社 サンヨー工業');
ok($zip->set_number('3910392')->is_valid_number, '池の平ホテル');
ok($zip->set_number('3910393')->is_valid_number, '蓼科グランドホテル滝の湯');
ok($zip->set_number('3910394')->is_valid_number, '蓼科パークホテル');
ok($zip->set_number('3910395')->is_valid_number, 'アートランドホテル蓼科');
ok($zip->set_number('3910396')->is_valid_number, '株式会社 渡辺製麺');
ok($zip->set_number('3918501')->is_valid_number, '茅野市役所');
ok($zip->set_number('3918503')->is_valid_number, '諏訪中央病院');
ok($zip->set_number('3918507')->is_valid_number, '関東でき太の会');
ok($zip->set_number('3918510')->is_valid_number, '山高味噌 株式会社');
ok($zip->set_number('3918511')->is_valid_number, '長野県立 茅野高等学校');
ok($zip->set_number('3918512')->is_valid_number, '東海大学第三高等学校');
ok($zip->set_number('3918521')->is_valid_number, '茅野商工会議所');
ok($zip->set_number('3918522')->is_valid_number, 'JA 信州諏訪');
ok($zip->set_number('3928501')->is_valid_number, '株式会社 諏訪丸光');
ok($zip->set_number('3928502')->is_valid_number, 'セイコーエプソン 株式会社 本社');
ok($zip->set_number('3928505')->is_valid_number, '株式会社 国興');
ok($zip->set_number('3928510')->is_valid_number, '諏訪 赤十字病院');
ok($zip->set_number('3928511')->is_valid_number, '諏訪市役所');
ok($zip->set_number('3928520')->is_valid_number, '信濃毎日新聞 諏訪支社');
ok($zip->set_number('3928540')->is_valid_number, '(株) 竹屋');
ok($zip->set_number('3928548')->is_valid_number, '長野県諏訪清陵高等学校');
ok($zip->set_number('3928549')->is_valid_number, '長野県諏訪二葉高等学校');
ok($zip->set_number('3928555')->is_valid_number, '諏訪商工会議所');
ok($zip->set_number('3928577')->is_valid_number, '株式会社 ホテル紅や');
ok($zip->set_number('3928578')->is_valid_number, 'JA信州諏訪農業協同組合');
ok($zip->set_number('3928585')->is_valid_number, '太陽工業 株式会社');
ok($zip->set_number('3928601')->is_valid_number, '長野県 諏訪建設事務所');
ok($zip->set_number('3928601')->is_valid_number, '長野県 諏訪地方事務所');
ok($zip->set_number('3928601')->is_valid_number, '長野県 諏訪保健所');
ok($zip->set_number('3928601')->is_valid_number, '長野県 農業改良普及センター');
ok($zip->set_number('3928609')->is_valid_number, 'エルシーブイ 株式会社');
ok($zip->set_number('3928610')->is_valid_number, '諏訪税務署');
ok($zip->set_number('3928611')->is_valid_number, '株式会社 長野日報社');
ok($zip->set_number('3928627')->is_valid_number, '商工組合中央金庫 諏訪支店');
ok($zip->set_number('3928628')->is_valid_number, '株式会社 八十二銀行 諏訪支店');
ok($zip->set_number('3928686')->is_valid_number, '宮坂醸造 (株) 丸高工場');
ok($zip->set_number('3938501')->is_valid_number, '下諏訪町役場');
ok($zip->set_number('3938502')->is_valid_number, '山王閣');
ok($zip->set_number('3938503')->is_valid_number, '奏鳴館');
ok($zip->set_number('3938511')->is_valid_number, '日本電産サンキョー 株式会社');
ok($zip->set_number('3938585')->is_valid_number, '(株) 武藤工業');
ok($zip->set_number('3938601')->is_valid_number, '株式会社 オノウエ印刷 カード受注センター');
ok($zip->set_number('3948510')->is_valid_number, '岡谷市役所');
ok($zip->set_number('3948511')->is_valid_number, '帝国ピストンリング 株式会社 長野岡谷工場');
ok($zip->set_number('3948512')->is_valid_number, '市立岡谷病院');
ok($zip->set_number('3948515')->is_valid_number, '医療法人 研成会 諏訪湖畔病院');
ok($zip->set_number('3948520')->is_valid_number, '株式会社 みくに工業');
ok($zip->set_number('3948540')->is_valid_number, 'マルヤス機械 株式会社');
ok($zip->set_number('3948550')->is_valid_number, '京セラ 株式会社 長野岡谷工場');
ok($zip->set_number('3948555')->is_valid_number, '株式会社 マルニシ');
ok($zip->set_number('3948577')->is_valid_number, '株式会社 中外商工');
ok($zip->set_number('3948585')->is_valid_number, '岡谷酸素 株式会社');
ok($zip->set_number('3948588')->is_valid_number, '健康保険 岡谷塩嶺病院');
ok($zip->set_number('3948611')->is_valid_number, '諏訪信用金庫');
ok($zip->set_number('3948665')->is_valid_number, '岡谷社会保険事務所');
ok($zip->set_number('3948686')->is_valid_number, '沖電線 株式会社 岡谷工場');
ok($zip->set_number('3950192')->is_valid_number, 'みなみ信州 農業協同組合');
ok($zip->set_number('3950193')->is_valid_number, '綿半鋼機 株式会社');
ok($zip->set_number('3950195')->is_valid_number, '株式会社 平和時計製作所');
ok($zip->set_number('3950196')->is_valid_number, '天竜丸澤 株式会社');
ok($zip->set_number('3958501')->is_valid_number, '飯田市役所');
ok($zip->set_number('3958502')->is_valid_number, '飯田市立病院');
ok($zip->set_number('3958503')->is_valid_number, '飯田市立高松病院');
ok($zip->set_number('3958505')->is_valid_number, '飯田病院');
ok($zip->set_number('3958511')->is_valid_number, '株式会社 マルタ');
ok($zip->set_number('3958515')->is_valid_number, '多摩川精機 (株)');
ok($zip->set_number('3958520')->is_valid_number, '多摩川精機 株式会社 第2事業所');
ok($zip->set_number('3958522')->is_valid_number, '健和会病院');
ok($zip->set_number('3958528')->is_valid_number, '飯田女子高等学校');
ok($zip->set_number('3958533')->is_valid_number, '飯田広域消防本部');
ok($zip->set_number('3958543')->is_valid_number, '長野県飯田風越高等学校');
ok($zip->set_number('3958555')->is_valid_number, '株式会社 長野県農協直販');
ok($zip->set_number('3958556')->is_valid_number, '信南交通 株式会社');
ok($zip->set_number('3958558')->is_valid_number, '医療法人 輝山会記念病院');
ok($zip->set_number('3958566')->is_valid_number, '株式会社 ミヤウチ');
ok($zip->set_number('3958567')->is_valid_number, '飯田女子短期大学');
ok($zip->set_number('3958577')->is_valid_number, '株式会社 平和時計製作所 松尾工場');
ok($zip->set_number('3958585')->is_valid_number, '株式会社 原鉄');
ok($zip->set_number('3958588')->is_valid_number, '株式会社 トマツ本店');
ok($zip->set_number('3958609')->is_valid_number, '飯田公共職業安定所');
ok($zip->set_number('3958611')->is_valid_number, '飯田信用金庫');
ok($zip->set_number('3958622')->is_valid_number, '中部電力 株式会社 飯田営業所');
ok($zip->set_number('3958646')->is_valid_number, '飯田税務署');
ok($zip->set_number('3958655')->is_valid_number, '飯田社会保険事務所');
ok($zip->set_number('3958682')->is_valid_number, '株式会社 八十二銀行 飯田支店');
ok($zip->set_number('3958688')->is_valid_number, '株式会社 外松');
ok($zip->set_number('3960198')->is_valid_number, '長野日本電気 株式会社');
ok($zip->set_number('3960293')->is_valid_number, '長野県高遠高等学校');
ok($zip->set_number('3968501')->is_valid_number, 'ベルシャイン伊那店');
ok($zip->set_number('3968510')->is_valid_number, '上伊那農業協同組合(JA上伊那)');
ok($zip->set_number('3968511')->is_valid_number, '株式会社 三協精機製作所 伊那工場');
ok($zip->set_number('3968550')->is_valid_number, '伊那税務署');
ok($zip->set_number('3968555')->is_valid_number, '伊那 中央病院');
ok($zip->set_number('3968558')->is_valid_number, '長野県 伊那北高等学校');
ok($zip->set_number('3968585')->is_valid_number, 'KOA 株式会社');
ok($zip->set_number('3968609')->is_valid_number, '伊那公共職業安定所');
ok($zip->set_number('3968611')->is_valid_number, 'アルプス中央 信用金庫');
ok($zip->set_number('3968617')->is_valid_number, '伊那市役所');
ok($zip->set_number('3968682')->is_valid_number, '株式会社 八十二銀行 伊那支店');
ok($zip->set_number('3970292')->is_valid_number, '長野県製薬 株式会社');
ok($zip->set_number('3970392')->is_valid_number, '木曽町 開田支所');
ok($zip->set_number('3978555')->is_valid_number, '長野県立 木曽病院');
ok($zip->set_number('3978567')->is_valid_number, '長野県立 木曽山林高等学校');
ok($zip->set_number('3978571')->is_valid_number, '長野県立 木曽高等学校');
ok($zip->set_number('3978585')->is_valid_number, '木曽町 木曽福島支所');
ok($zip->set_number('3978588')->is_valid_number, '木曽町役場');
ok($zip->set_number('3978602')->is_valid_number, '木曽税務署');
ok($zip->set_number('3978609')->is_valid_number, '木曽福島公共職業安定所');
ok($zip->set_number('3988501')->is_valid_number, '大町税務署');
ok($zip->set_number('3988601')->is_valid_number, '大町市役所');
ok($zip->set_number('3988602')->is_valid_number, '長野県大町合同庁舎');
ok($zip->set_number('3988686')->is_valid_number, '株式会社 相模組');
ok($zip->set_number('3990292')->is_valid_number, '富士見町役場');
ok($zip->set_number('3990293')->is_valid_number, 'セイコーエプソン 株式会社 富士見事業所');
ok($zip->set_number('3990295')->is_valid_number, 'セイコーエプソン 株式会社 諏訪南事業所');
ok($zip->set_number('3990492')->is_valid_number, '石川島汎用機械 株式会社');
ok($zip->set_number('3990493')->is_valid_number, '辰野町役場');
ok($zip->set_number('3990495')->is_valid_number, 'オリンパス 株式会社 辰野事業場');
ok($zip->set_number('3990496')->is_valid_number, '町立 辰野総合病院');
ok($zip->set_number('3990497')->is_valid_number, '株式会社 マブチ・エスアンドティー');
ok($zip->set_number('3990498')->is_valid_number, '信州豊南短期大学');
ok($zip->set_number('3990781')->is_valid_number, '学校法人 松本歯科大学');
ok($zip->set_number('3990782')->is_valid_number, '株式会社 サンコー');
ok($zip->set_number('3990785')->is_valid_number, 'セイコーエプソン 株式会社 広丘事業所');
ok($zip->set_number('3990786')->is_valid_number, '塩尻市役所');
ok($zip->set_number('3990795')->is_valid_number, '塩尻市農業協同組合');
ok($zip->set_number('3990796')->is_valid_number, 'セイコーエプソン 株式会社 塩尻事業所');
ok($zip->set_number('3991392')->is_valid_number, '飯田市役所 南信濃自治振興センター');
ok($zip->set_number('3991511')->is_valid_number, '阿南町役場');
ok($zip->set_number('3991689')->is_valid_number, '売木村役場');
ok($zip->set_number('3991895')->is_valid_number, '泰阜村役場');
ok($zip->set_number('3993192')->is_valid_number, '株式会社 マツザワ');
ok($zip->set_number('3993193')->is_valid_number, '高森町役場');
ok($zip->set_number('3993295')->is_valid_number, '豊丘村役場');
ok($zip->set_number('3993797')->is_valid_number, '飯島町役場');
ok($zip->set_number('3993892')->is_valid_number, '中川村役場');
ok($zip->set_number('3994192')->is_valid_number, '駒ヶ根市役所');
ok($zip->set_number('3994195')->is_valid_number, '株式会社 ヤマウラ');
ok($zip->set_number('3994392')->is_valid_number, '宮田村役場');
ok($zip->set_number('3994393')->is_valid_number, '株式会社 LIXIL');
ok($zip->set_number('3994394')->is_valid_number, '横河マニュファクチャリング 株式会社');
ok($zip->set_number('3994395')->is_valid_number, '株式会社 マルニシ 伊那店');
ok($zip->set_number('3994498')->is_valid_number, '伊那食品工業 株式会社 本社');
ok($zip->set_number('3994564')->is_valid_number, '西箕輪小学校');
ok($zip->set_number('3994565')->is_valid_number, '西箕輪中学校');
ok($zip->set_number('3994566')->is_valid_number, '南部小学校');
ok($zip->set_number('3994567')->is_valid_number, '南箕輪小学校');
ok($zip->set_number('3994568')->is_valid_number, '南箕輪中学校');
ok($zip->set_number('3994570')->is_valid_number, '国興 株式会社');
ok($zip->set_number('3994571')->is_valid_number, '越前屋 株式会社');
ok($zip->set_number('3994572')->is_valid_number, '上野興業 株式会社');
ok($zip->set_number('3994573')->is_valid_number, 'ジャパンエアガシズ');
ok($zip->set_number('3994575')->is_valid_number, 'エルコム');
ok($zip->set_number('3994576')->is_valid_number, '高山理化精機 株式会社');
ok($zip->set_number('3994578')->is_valid_number, 'ミツワマシンサービス');
ok($zip->set_number('3994581')->is_valid_number, 'BOCエドワーズ 株式会社');
ok($zip->set_number('3994583')->is_valid_number, 'マシンエンジニアリング 株式会社');
ok($zip->set_number('3994584')->is_valid_number, 'ニッセイ電子工業 株式会社');
ok($zip->set_number('3994585')->is_valid_number, '創研 株式会社');
ok($zip->set_number('3994586')->is_valid_number, 'ピスコ販売');
ok($zip->set_number('3994587')->is_valid_number, '日本ピスコ 第一工場');
ok($zip->set_number('3994588')->is_valid_number, '日本ピスコ 第二工場');
ok($zip->set_number('3994589')->is_valid_number, '信英蓄電器箔 株式会社');
ok($zip->set_number('3994592')->is_valid_number, '南箕輪村役場');
ok($zip->set_number('3994593')->is_valid_number, 'ルビコン 株式会社');
ok($zip->set_number('3994594')->is_valid_number, '長野県上伊那農業高等学校');
ok($zip->set_number('3994595')->is_valid_number, '株式会社 ハーモ');
ok($zip->set_number('3994597')->is_valid_number, '大明化学工業 株式会社');
ok($zip->set_number('3994598')->is_valid_number, '信州大学 農学部');
ok($zip->set_number('3994692')->is_valid_number, '株式会社 伸光製作所');
ok($zip->set_number('3994693')->is_valid_number, 'セイコーエプソン 株式会社 松島事業所');
ok($zip->set_number('3994695')->is_valid_number, '箕輪町役場');
ok($zip->set_number('3994696')->is_valid_number, 'セイコーエプソン 株式会社 伊那事業所');
ok($zip->set_number('3994697')->is_valid_number, '株式会社 KOAアースウイング');
ok($zip->set_number('3997192')->is_valid_number, '安曇野市役所 明科総合支所');
ok($zip->set_number('3998192')->is_valid_number, '安曇野市役所 三郷総合支所');
ok($zip->set_number('3998281')->is_valid_number, '豊科町役場');
ok($zip->set_number('3998282')->is_valid_number, 'ソニーデジタルプロダクツ 株式会社');
ok($zip->set_number('3998283')->is_valid_number, 'あづみ農業協同組合');
ok($zip->set_number('3998285')->is_valid_number, '三洋エプソンイメージングデバイス 株式会社');
ok($zip->set_number('3998286')->is_valid_number, 'GAC 株式会社');
ok($zip->set_number('3998288')->is_valid_number, '長野県立 こども病院');
ok($zip->set_number('3998292')->is_valid_number, '豊科赤十字病院');
ok($zip->set_number('3998293')->is_valid_number, '日本電熱 株式会社');
ok($zip->set_number('3998295')->is_valid_number, '(財) アルプスあづみの公園管理センター');
ok($zip->set_number('3998297')->is_valid_number, '国土交通省 関東地方整備局 国営アルプスあづみの公園事務所');
ok($zip->set_number('3998386')->is_valid_number, 'GAC 株式会社');
ok($zip->set_number('3998392')->is_valid_number, '安曇野市役所 穂高総合支所');
ok($zip->set_number('3998695')->is_valid_number, '長野県厚生農業協同組合連合会 安曇総合病院');
ok($zip->set_number('3998696')->is_valid_number, '池田町役場');
ok($zip->set_number('3998701')->is_valid_number, '国立松本病院');
ok($zip->set_number('3998702')->is_valid_number, 'セイコーエプソン 株式会社 松本南事業所');
ok($zip->set_number('3998703')->is_valid_number, 'エプソンダイレクト 株式会社');
ok($zip->set_number('3998707')->is_valid_number, 'セイコーエプソン 株式会社 村井事業所');
ok($zip->set_number('3998710')->is_valid_number, 'キッセイ薬品工業 株式会社');
ok($zip->set_number('3998711')->is_valid_number, '信濃毎日新聞 株式会社 松本本社');
ok($zip->set_number('3998712')->is_valid_number, '株式会社 ナガノトマト');
ok($zip->set_number('3998720')->is_valid_number, '長野 コカ・コーラボトリング 株式会社');
ok($zip->set_number('3998721')->is_valid_number, '株式会社 泉精器製作所');
ok($zip->set_number('3998722')->is_valid_number, '高山理化精機 株式会社');
ok($zip->set_number('3998725')->is_valid_number, '桜田電気工業 株式会社 松本支店');
ok($zip->set_number('3998728')->is_valid_number, '信州ジャスコ 株式会社 管理本部');
ok($zip->set_number('3998730')->is_valid_number, 'パナソニック オートモーティブシステムズ 株式会社 松本工場');
ok($zip->set_number('3998733')->is_valid_number, '株式会社 シマコー');
ok($zip->set_number('3998738')->is_valid_number, '伊藤伊 株式会社 甲信支店');
ok($zip->set_number('3998739')->is_valid_number, 'セントラルパック 株式会社');
ok($zip->set_number('3998744')->is_valid_number, 'タカヤマケミカル 株式会社');
ok($zip->set_number('3998750')->is_valid_number, '株式会社 日邦バルブ');
ok($zip->set_number('3998751')->is_valid_number, '株式会社 ヤマサ');
ok($zip->set_number('3998754')->is_valid_number, '鍋林サイエンス 株式会社');
ok($zip->set_number('3998755')->is_valid_number, '花村産業 株式会社');
ok($zip->set_number('3998760')->is_valid_number, '株式会社 上條器械店 松本営業所');
ok($zip->set_number('3999192')->is_valid_number, '大町市 美麻支所');
ok($zip->set_number('3999393')->is_valid_number, '白馬村役場');
ok($zip->set_number('3999494')->is_valid_number, '小谷村役場');
ok($zip->set_number('4000192')->is_valid_number, '甲斐市役所');
ok($zip->set_number('4000193')->is_valid_number, '甲斐市役所 敷島支所');
ok($zip->set_number('4000194')->is_valid_number, '株式会社 光彩工芸');
ok($zip->set_number('4000195')->is_valid_number, '竜王社会保険事務所');
ok($zip->set_number('4000196')->is_valid_number, '甲斐市役所 双葉庁舎');
ok($zip->set_number('4000280')->is_valid_number, '清水工機 株式会社');
ok($zip->set_number('4000292')->is_valid_number, '南アルプス市役所 白根支所');
ok($zip->set_number('4000293')->is_valid_number, '南アルプス市役所 芦安支所');
ok($zip->set_number('4000298')->is_valid_number, '南アルプス市役所 八田支所');
ok($zip->set_number('4000393')->is_valid_number, '南アルプス市役所 若草支所');
ok($zip->set_number('4000395')->is_valid_number, '南アルプス市役所');
ok($zip->set_number('4000398')->is_valid_number, '巨摩共立病院');
ok($zip->set_number('4000492')->is_valid_number, '南アルプス市役所 甲西支所');
ok($zip->set_number('4000493')->is_valid_number, '山梨松下電工 株式会社');
ok($zip->set_number('4000495')->is_valid_number, 'TDK (株) 甲府工場');
ok($zip->set_number('4000498')->is_valid_number, '山梨アビオニクス (株)');
ok($zip->set_number('4000592')->is_valid_number, '富士川町役場');
ok($zip->set_number('4000593')->is_valid_number, 'ニスカ 株式会社');
ok($zip->set_number('4000598')->is_valid_number, '株式会社 はくばく');
ok($zip->set_number('4000692')->is_valid_number, '山梨県 峡南地域県民センター');
ok($zip->set_number('4000693')->is_valid_number, '鰍沢税務署');
ok($zip->set_number('4000695')->is_valid_number, '富士川町役場 分庁舎');
ok($zip->set_number('4001592')->is_valid_number, '甲府市役所 中道支所');
ok($zip->set_number('4001593')->is_valid_number, '株式会社 シャトレーゼ');
ok($zip->set_number('4001594')->is_valid_number, '中央市役所 豊富支所');
ok($zip->set_number('4001597')->is_valid_number, 'よっちゃん食品工業 株式会社');
ok($zip->set_number('4001598')->is_valid_number, '株式会社 チロリーナ');
ok($zip->set_number('4008501')->is_valid_number, '山梨県庁');
ok($zip->set_number('4008505')->is_valid_number, '株式会社 山梨文化会館');
ok($zip->set_number('4008506')->is_valid_number, '山梨県立 中央病院');
ok($zip->set_number('4008508')->is_valid_number, '学校法人 山梨英和学院');
ok($zip->set_number('4008510')->is_valid_number, '山梨大学');
ok($zip->set_number('4008511')->is_valid_number, '山梨大学 工学部');
ok($zip->set_number('4008512')->is_valid_number, '甲府商工会議所');
ok($zip->set_number('4008515')->is_valid_number, '株式会社 山梨日々新聞社');
ok($zip->set_number('4008521')->is_valid_number, '甲府富士屋ホテル');
ok($zip->set_number('4008525')->is_valid_number, '株式会社 山梨放送');
ok($zip->set_number('4008531')->is_valid_number, '山梨社会保険事務局');
ok($zip->set_number('4008533')->is_valid_number, '独立行政法人 国立病院機構 甲府病院');
ok($zip->set_number('4008535')->is_valid_number, '株式会社 アドブレーン社');
ok($zip->set_number('4008536')->is_valid_number, '株式会社 エヌ・ティ・ティドコモ 山梨支店');
ok($zip->set_number('4008540')->is_valid_number, '清水工機 株式会社');
ok($zip->set_number('4008543')->is_valid_number, '中北保険福祉事務所');
ok($zip->set_number('4008544')->is_valid_number, 'UFJニコス 株式会社');
ok($zip->set_number('4008545')->is_valid_number, '株式会社 YBST&L');
ok($zip->set_number('4008550')->is_valid_number, '株式会社 エフエム富士');
ok($zip->set_number('4008555')->is_valid_number, '山梨英和大学');
ok($zip->set_number('4008556')->is_valid_number, '甲府地方検察庁');
ok($zip->set_number('4008558')->is_valid_number, '横河電機 株式会社 甲府事業所');
ok($zip->set_number('4008559')->is_valid_number, '全国健康保険協会 山梨支部');
ok($zip->set_number('4008565')->is_valid_number, '甲府社会保険事務所');
ok($zip->set_number('4008566')->is_valid_number, '中部食品 株式会社');
ok($zip->set_number('4008570')->is_valid_number, '株式会社 テレビ山梨');
ok($zip->set_number('4008571')->is_valid_number, '山梨労働局 労働基準部 労災補償課分室');
ok($zip->set_number('4008575')->is_valid_number, '山梨学院大学');
ok($zip->set_number('4008577')->is_valid_number, '山梨労働局');
ok($zip->set_number('4008578')->is_valid_number, '国土交通省 甲府河川国道事務所');
ok($zip->set_number('4008585')->is_valid_number, '甲府市役所');
ok($zip->set_number('4008586')->is_valid_number, '山梨県警察本部');
ok($zip->set_number('4008588')->is_valid_number, '長田組土木 株式会社');
ok($zip->set_number('4008601')->is_valid_number, '山梨中央銀行');
ok($zip->set_number('4008610')->is_valid_number, '日本生命保険 相互会社 甲府支社');
ok($zip->set_number('4008633')->is_valid_number, '商工組合中央金庫 甲府支店');
ok($zip->set_number('4008666')->is_valid_number, '株式会社 テンヨ武田');
ok($zip->set_number('4010292')->is_valid_number, '上野原市役所 秋山支所');
ok($zip->set_number('4010380')->is_valid_number, '学校法人 第一藍野学院 健康科学大学');
ok($zip->set_number('4010395')->is_valid_number, '河口湖精密 株式会社');
ok($zip->set_number('4010396')->is_valid_number, '富士観光開発 株式会社');
ok($zip->set_number('4010397')->is_valid_number, 'アネルバ 株式会社 富士工場');
ok($zip->set_number('4010398')->is_valid_number, '鳴沢村役場');
ok($zip->set_number('4010592')->is_valid_number, '忍野村役場');
ok($zip->set_number('4010595')->is_valid_number, '山中湖村役場');
ok($zip->set_number('4010597')->is_valid_number, 'ファナック 株式会社');
ok($zip->set_number('4018501')->is_valid_number, '山梨社会保険事務局 大月事務所');
ok($zip->set_number('4018601')->is_valid_number, '大月市役所');
ok($zip->set_number('4028501')->is_valid_number, '都留市役所');
ok($zip->set_number('4028555')->is_valid_number, '都留文科大学');
ok($zip->set_number('4038522')->is_valid_number, '中央観光 株式会社');
ok($zip->set_number('4038555')->is_valid_number, '全国柔道整復師会');
ok($zip->set_number('4038601')->is_valid_number, '富士吉田市役所');
ok($zip->set_number('4048501')->is_valid_number, '甲州市役所');
ok($zip->set_number('4048601')->is_valid_number, '峡東地域県民センター');
ok($zip->set_number('4058501')->is_valid_number, '山梨市役所');
ok($zip->set_number('4058555')->is_valid_number, '笛吹市役所 一宮支所');
ok($zip->set_number('4058577')->is_valid_number, '日本システムウエア 株式会社');
ok($zip->set_number('4058585')->is_valid_number, '山梨税務署');
ok($zip->set_number('4068505')->is_valid_number, '笛吹市役所 春日居分庁舎');
ok($zip->set_number('4068510')->is_valid_number, '笛吹市役所');
ok($zip->set_number('4068555')->is_valid_number, '笛吹市役所 八代分庁舎');
ok($zip->set_number('4068558')->is_valid_number, '山梨県自動車税事務所');
ok($zip->set_number('4068601')->is_valid_number, '山梨県総合県税事務所');
ok($zip->set_number('4078501')->is_valid_number, '韮崎市役所');
ok($zip->set_number('4078511')->is_valid_number, '東京エレクトロン 株式会社');
ok($zip->set_number('4078555')->is_valid_number, '三井金属鉱業 株式会社');
ok($zip->set_number('4080188')->is_valid_number, '北杜市役所');
ok($zip->set_number('4080192')->is_valid_number, '北杜市役所 須玉総合支所');
ok($zip->set_number('4088515')->is_valid_number, '株式会社 キッツ 長坂工場');
ok($zip->set_number('4088522')->is_valid_number, '株式会社 アルソア本社');
ok($zip->set_number('4088533')->is_valid_number, '株式会社 ミヨシ');
ok($zip->set_number('4088550')->is_valid_number, 'HOYA 株式会社 長坂工場');
ok($zip->set_number('4088555')->is_valid_number, '北杜市役所 小淵沢総合支所');
ok($zip->set_number('4088585')->is_valid_number, '北杜市役所 長坂総合支所');
ok($zip->set_number('4090192')->is_valid_number, '上野原市役所');
ok($zip->set_number('4090193')->is_valid_number, '帝京科学大学');
ok($zip->set_number('4090195')->is_valid_number, '日本大学明誠高等学校');
ok($zip->set_number('4090198')->is_valid_number, '株式会社 エノモト');
ok($zip->set_number('4091298')->is_valid_number, '甲州市 大和地域総合局');
ok($zip->set_number('4091392')->is_valid_number, '甲州市 勝沼地域総合局');
ok($zip->set_number('4092192')->is_valid_number, '南部町役場');
ok($zip->set_number('4092193')->is_valid_number, 'JAふじかわ 富沢支店');
ok($zip->set_number('4092194')->is_valid_number, '富士ロイヤルカントリークラブ');
ok($zip->set_number('4092195')->is_valid_number, '随縁カントリー倶楽部 センチュリー富士コース');
ok($zip->set_number('4092196')->is_valid_number, '中央化学 (株) 山梨工場 第二事業所');
ok($zip->set_number('4092398')->is_valid_number, '南部町役場 南部分庁舎');
ok($zip->set_number('4092592')->is_valid_number, '身延町役場 身延支所');
ok($zip->set_number('4092593')->is_valid_number, '身延山久遠寺');
ok($zip->set_number('4092597')->is_valid_number, '身延山学園');
ok($zip->set_number('4092598')->is_valid_number, '上沢寺');
ok($zip->set_number('4092992')->is_valid_number, '身延町役場 下部支所');
ok($zip->set_number('4093293')->is_valid_number, '開運社');
ok($zip->set_number('4093392')->is_valid_number, '身延町役場');
ok($zip->set_number('4093393')->is_valid_number, '富士川カントリークラブ');
ok($zip->set_number('4093692')->is_valid_number, '株式会社 マルアイ');
ok($zip->set_number('4093792')->is_valid_number, '甲府市 上九一色出張所');
ok($zip->set_number('4093793')->is_valid_number, '笛吹市役所 芦川支所');
ok($zip->set_number('4093880')->is_valid_number, '昭和町役場');
ok($zip->set_number('4093881')->is_valid_number, '株式会社 キトー');
ok($zip->set_number('4093883')->is_valid_number, 'ユーディナディバイス 株式会社');
ok($zip->set_number('4093885')->is_valid_number, '株式会社 渡辺商店');
ok($zip->set_number('4093887')->is_valid_number, '(株) やまひろ');
ok($zip->set_number('4093888')->is_valid_number, '株式会社 サン宝石');
ok($zip->set_number('4093889')->is_valid_number, 'パイオニア・ディスプレイ・プロダクツ 株式会社');
ok($zip->set_number('4093892')->is_valid_number, '中央市役所 田富庁舎');
ok($zip->set_number('4093893')->is_valid_number, '中央市役所 玉穂庁舎');
ok($zip->set_number('4093894')->is_valid_number, '株式会社 甲府明電舎');
ok($zip->set_number('4093895')->is_valid_number, 'パナソニックファクトリーソリューションズ 株式会社');
ok($zip->set_number('4093896')->is_valid_number, '甲府カシオ 株式会社');
ok($zip->set_number('4093897')->is_valid_number, '株式会社 アピオ');
ok($zip->set_number('4093898')->is_valid_number, '山梨大学医学部付属病院');
ok($zip->set_number('4100192')->is_valid_number, '加倉水産');
ok($zip->set_number('4100395')->is_valid_number, '東海大学沼津校舎');
ok($zip->set_number('4100396')->is_valid_number, '富士通 株式会社 沼津工場');
ok($zip->set_number('4100398')->is_valid_number, '図書印刷 株式会社 沼津工場');
ok($zip->set_number('4101192')->is_valid_number, '裾野市役所');
ok($zip->set_number('4101193')->is_valid_number, 'トヨタ自動車 株式会社 東富士研究所');
ok($zip->set_number('4101195')->is_valid_number, '関東自動車工業 株式会社 東富士工場');
ok($zip->set_number('4101196')->is_valid_number, 'キヤノン 株式会社 富士裾野リサーチパーク');
ok($zip->set_number('4101392')->is_valid_number, 'ユニバーサル製缶 株式会社');
ok($zip->set_number('4101393')->is_valid_number, 'エスアイアイ・ナノテクノロジー 株式会社 小山工場');
ok($zip->set_number('4101394')->is_valid_number, 'フジボウ愛媛 株式会社 小山工場');
ok($zip->set_number('4101395')->is_valid_number, '小山町役場');
ok($zip->set_number('4101396')->is_valid_number, '株式会社 センサータ・テクノロジーズジャパン');
ok($zip->set_number('4102192')->is_valid_number, '伊豆の国市役所韮山支所');
ok($zip->set_number('4102193')->is_valid_number, 'ABB日本ベーレー 株式会社');
ok($zip->set_number('4102194')->is_valid_number, '伊豆の国農業協同組合');
ok($zip->set_number('4102195')->is_valid_number, '伊豆韮山温泉病院');
ok($zip->set_number('4102292')->is_valid_number, '伊豆の国市役所');
ok($zip->set_number('4102295')->is_valid_number, '順天堂大学 医学部附属 静岡病院');
ok($zip->set_number('4102297')->is_valid_number, '株式会社 コクド 三養荘');
ok($zip->set_number('4102392')->is_valid_number, '東芝テック 株式会社 大仁事業所');
ok($zip->set_number('4102393')->is_valid_number, 'ワールドメイト');
ok($zip->set_number('4102394')->is_valid_number, 'ニッサン・モータースポーツ・インターナショナル (株) モビリティーパーク事業部');
ok($zip->set_number('4102395')->is_valid_number, '静岡県立 大仁高等学校');
ok($zip->set_number('4102396')->is_valid_number, '伊豆の国市役所 大仁支所');
ok($zip->set_number('4102592')->is_valid_number, '伊豆市 中伊豆支所');
ok($zip->set_number('4103292')->is_valid_number, '伊豆市役所 天城湯ヶ島支所');
ok($zip->set_number('4103293')->is_valid_number, '慶應義塾大学 月ケ瀬リハビリテーションセンター');
ok($zip->set_number('4103693')->is_valid_number, '松崎高校');
ok($zip->set_number('4103696')->is_valid_number, '松崎町役場');
ok($zip->set_number('4108501')->is_valid_number, '沼津工業高等専門学校');
ok($zip->set_number('4108504')->is_valid_number, '株式会社 フジクラ 沼津工場');
ok($zip->set_number('4108508')->is_valid_number, '沼津警察署');
ok($zip->set_number('4108510')->is_valid_number, '東芝機械 株式会社 沼津事業所');
ok($zip->set_number('4108511')->is_valid_number, '矢崎総業 株式会社');
ok($zip->set_number('4108514')->is_valid_number, '岩崎一雄税理士事務所');
ok($zip->set_number('4108515')->is_valid_number, '矢崎電線 株式会社 沼津製作所');
ok($zip->set_number('4108520')->is_valid_number, '沼津財務事務所');
ok($zip->set_number('4108522')->is_valid_number, '東部教育事務所');
ok($zip->set_number('4108525')->is_valid_number, '株式会社 すみや電器 沼津営業所');
ok($zip->set_number('4108530')->is_valid_number, '米久 株式会社');
ok($zip->set_number('4108531')->is_valid_number, '三井生命保険 相互会社 沼津支社');
ok($zip->set_number('4108533')->is_valid_number, '沼津市立図書館');
ok($zip->set_number('4108535')->is_valid_number, '富士ロビン 株式会社');
ok($zip->set_number('4108540')->is_valid_number, '株式会社 特電');
ok($zip->set_number('4108543')->is_valid_number, '沼津保健所');
ok($zip->set_number('4108544')->is_valid_number, '静岡県農業協同組合中央会 東部支所');
ok($zip->set_number('4108550')->is_valid_number, '静岡地方裁判所 沼津支部 静岡家庭裁判所 沼津支部 沼津簡易裁判所 沼津検察審査会');
ok($zip->set_number('4108551')->is_valid_number, '株式会社 マルヤ水産');
ok($zip->set_number('4108552')->is_valid_number, '羽野水産 株式会社');
ok($zip->set_number('4108555')->is_valid_number, '財団法人 芙蓉協会 聖隷沼津病院');
ok($zip->set_number('4108558')->is_valid_number, 'NTT西日本 沼津支店');
ok($zip->set_number('4108567')->is_valid_number, '国土交通省 中部地方整備局 沼津河川国道事務所');
ok($zip->set_number('4108570')->is_valid_number, '株式会社 西武百貨店 沼津店');
ok($zip->set_number('4108575')->is_valid_number, '財団法人 復康会 沼津中央病院');
ok($zip->set_number('4108580')->is_valid_number, '聖隷沼津健康診断センター');
ok($zip->set_number('4108585')->is_valid_number, '株式会社 日本政策金融公庫 沼津支店');
ok($zip->set_number('4108588')->is_valid_number, '株式会社 明電舎 沼津事業所');
ok($zip->set_number('4108601')->is_valid_number, '沼津市役所');
ok($zip->set_number('4108602')->is_valid_number, '日本生命保険 相互会社 沼津支社');
ok($zip->set_number('4108610')->is_valid_number, '沼津信用金庫 本店 本部');
ok($zip->set_number('4108654')->is_valid_number, '商工組合中央金庫 沼津支店');
ok($zip->set_number('4108655')->is_valid_number, '沼津社会保険事務所');
ok($zip->set_number('4108686')->is_valid_number, '沼津税務署');
ok($zip->set_number('4108689')->is_valid_number, '株式会社 駿河銀行');
ok($zip->set_number('4108710')->is_valid_number, '株式会社 静岡中央銀行');
ok($zip->set_number('4108739')->is_valid_number, '株式会社 増進会出版社');
ok($zip->set_number('4118502')->is_valid_number, '静岡県立 静岡中央高等学校 通信制課程 東部キャンパス');
ok($zip->set_number('4118510')->is_valid_number, '東栄電機 株式会社');
ok($zip->set_number('4118511')->is_valid_number, 'オムロン 株式会社 三島事業所');
ok($zip->set_number('4118520')->is_valid_number, '東芝テック 株式会社 三島事業所');
ok($zip->set_number('4118525')->is_valid_number, '株式会社 三静工業');
ok($zip->set_number('4118533')->is_valid_number, '伊豆箱根鉄道 株式会社');
ok($zip->set_number('4118540')->is_valid_number, '大学共同利用機関法人 情報システム研究機構');
ok($zip->set_number('4118541')->is_valid_number, '和興産業 株式会社');
ok($zip->set_number('4118551')->is_valid_number, '三島税務署');
ok($zip->set_number('4118555')->is_valid_number, '日本大学 国際関係学部');
ok($zip->set_number('4118560')->is_valid_number, '株式会社 電業社 機械製作所');
ok($zip->set_number('4118577')->is_valid_number, '株式会社 鈴木工務店');
ok($zip->set_number('4118610')->is_valid_number, '臼井国際産業 株式会社');
ok($zip->set_number('4118611')->is_valid_number, '独立行政法人 国立病院機構 静岡医療センター');
ok($zip->set_number('4118620')->is_valid_number, '野口アルミ箔加工紙 株式会社');
ok($zip->set_number('4118623')->is_valid_number, '株式会社 大成');
ok($zip->set_number('4118630')->is_valid_number, '近鉄物流 株式会社');
ok($zip->set_number('4118641')->is_valid_number, 'フジトク 株式会社');
ok($zip->set_number('4118644')->is_valid_number, '三島商工会議所');
ok($zip->set_number('4118648')->is_valid_number, '明治ケンコーハム 株式会社 三島工場');
ok($zip->set_number('4118650')->is_valid_number, '清水町役場');
ok($zip->set_number('4118651')->is_valid_number, '三島信用金庫');
ok($zip->set_number('4118652')->is_valid_number, '東レ株式会社 三島工場');
ok($zip->set_number('4118660')->is_valid_number, '三島社会保険事務所');
ok($zip->set_number('4118666')->is_valid_number, '三島市役所');
ok($zip->set_number('4118668')->is_valid_number, '長泉町役場');
ok($zip->set_number('4118689')->is_valid_number, '株式会社 駿河銀行');
ok($zip->set_number('4118720')->is_valid_number, '東邦テナックス 株式会社 三島事業所');
ok($zip->set_number('4118722')->is_valid_number, '岳南光機 株式会社');
ok($zip->set_number('4118725')->is_valid_number, '株式会社 共和工機');
ok($zip->set_number('4118730')->is_valid_number, '株式会社 不二精機製造所');
ok($zip->set_number('4118731')->is_valid_number, '協和発酵工業 株式会社 富士工場');
ok($zip->set_number('4118740')->is_valid_number, 'ハックキミサワ');
ok($zip->set_number('4118750')->is_valid_number, '特種製紙');
ok($zip->set_number('4118777')->is_valid_number, '静岡県立 静岡がんセンター');
ok($zip->set_number('4118787')->is_valid_number, '順天堂大学 保健看護学部');
ok($zip->set_number('4128501')->is_valid_number, 'ジェイビルサーキット御殿場 株式会社');
ok($zip->set_number('4128505')->is_valid_number, '東芝イーエムアイ 株式会社 御殿場工場');
ok($zip->set_number('4128511')->is_valid_number, '株式会社 ショーワ 御殿場工場');
ok($zip->set_number('4128512')->is_valid_number, '国立駿河療養所');
ok($zip->set_number('4128513')->is_valid_number, '中外製薬 株式会社 富士御殿場研究所');
ok($zip->set_number('4128524')->is_valid_number, '持田製薬 株式会社 富士中央研究所');
ok($zip->set_number('4128550')->is_valid_number, '陸上自衛隊 滝ケ原駐屯地');
ok($zip->set_number('4128585')->is_valid_number, '陸上自衛隊駒門駐屯地');
ok($zip->set_number('4128601')->is_valid_number, '御殿場市役所');
ok($zip->set_number('4128605')->is_valid_number, '御殿場 農業協同組合');
ok($zip->set_number('4128609')->is_valid_number, '駿河信用金庫 本店・本部(総務部・人事部・経理部・業務部・管理部・審査部・事務部・総合企業部・検査部)');
ok($zip->set_number('4128630')->is_valid_number, '菱和金属工業 株式会社');
ok($zip->set_number('4128634')->is_valid_number, '陸上自衛隊 板妻駐屯地');
ok($zip->set_number('4130196')->is_valid_number, '株式会社 間瀬');
ok($zip->set_number('4130292')->is_valid_number, '伊豆急行 株式会社');
ok($zip->set_number('4130293')->is_valid_number, '伊豆高原ゆうゆうの里');
ok($zip->set_number('4130298')->is_valid_number, '伊豆急不動産 株式会社');
ok($zip->set_number('4130492')->is_valid_number, 'ホテル銀水荘');
ok($zip->set_number('4130493')->is_valid_number, '株式会社 徳造丸');
ok($zip->set_number('4138502')->is_valid_number, '熱海税務署');
ok($zip->set_number('4138505')->is_valid_number, '熱海簡易裁判所');
ok($zip->set_number('4138510')->is_valid_number, '日本ジャンボー 株式会社');
ok($zip->set_number('4138511')->is_valid_number, '財団法人 エム・オー・エー美術・文化財団 MOA美術館');
ok($zip->set_number('4138530')->is_valid_number, '株式会社 寿恵会 ネオ・サミット湯河原');
ok($zip->set_number('4138550')->is_valid_number, '熱海市役所');
ok($zip->set_number('4138555')->is_valid_number, 'ホテルニューアカオ');
ok($zip->set_number('4138558')->is_valid_number, '株式会社 中銀ライフケア');
ok($zip->set_number('4138560')->is_valid_number, '静岡地方法務局 熱海出張所');
ok($zip->set_number('4138566')->is_valid_number, '社会福祉法人 黎明会 熱海ゆとりあの郷');
ok($zip->set_number('4138567')->is_valid_number, '国際医療福祉大学附属熱海病院');
ok($zip->set_number('4138585')->is_valid_number, '世界救世教 いづのめ教団');
ok($zip->set_number('4138589')->is_valid_number, '熱海身代り不動尊');
ok($zip->set_number('4138611')->is_valid_number, 'ホテル大野屋');
ok($zip->set_number('4138618')->is_valid_number, '中島水産 株式会社');
ok($zip->set_number('4138626')->is_valid_number, '熱海後楽園');
ok($zip->set_number('4138678')->is_valid_number, 'ホテル池田');
ok($zip->set_number('4148511')->is_valid_number, '東海自動車 株式会社');
ok($zip->set_number('4148550')->is_valid_number, '株式会社 杉山製茶工場');
ok($zip->set_number('4148555')->is_valid_number, '伊東市役所');
ok($zip->set_number('4148601')->is_valid_number, '伊豆信用金庫 本店 本部');
ok($zip->set_number('4148602')->is_valid_number, '伊豆信用金庫 事務部');
ok($zip->set_number('4150192')->is_valid_number, '南伊豆国民休暇村');
ok($zip->set_number('4150193')->is_valid_number, '共立湊病院');
ok($zip->set_number('4150194')->is_valid_number, '南伊豆町観光協会');
ok($zip->set_number('4150392')->is_valid_number, '南伊豆町役場');
ok($zip->set_number('4158501')->is_valid_number, '下田市役所');
ok($zip->set_number('4158502')->is_valid_number, '藤田観光 (株) 下田事業所');
ok($zip->set_number('4158505')->is_valid_number, '下田市 観光協会');
ok($zip->set_number('4158506')->is_valid_number, '下田市 民宿組合連合会');
ok($zip->set_number('4158507')->is_valid_number, '株式会社 永谷');
ok($zip->set_number('4158508')->is_valid_number, '株式会社 静岡銀行 下田支店');
ok($zip->set_number('4158509')->is_valid_number, '下田公共職業安定所');
ok($zip->set_number('4158510')->is_valid_number, '株式会社 下田東急ホテル');
ok($zip->set_number('4158511')->is_valid_number, '株式会社 下田大和館');
ok($zip->set_number('4158512')->is_valid_number, 'ホテル伊豆急');
ok($zip->set_number('4158513')->is_valid_number, '下田ガス 株式会社');
ok($zip->set_number('4158514')->is_valid_number, '株式会社 黒船ホテル');
ok($zip->set_number('4158515')->is_valid_number, '下田税務署');
ok($zip->set_number('4158516')->is_valid_number, '賀茂米穀卸 株式会社');
ok($zip->set_number('4158517')->is_valid_number, 'サガミシード 株式会社');
ok($zip->set_number('4158518')->is_valid_number, '伊豆太陽農業 協同組合');
ok($zip->set_number('4158520')->is_valid_number, '静岡地方裁判所 下田支部');
ok($zip->set_number('4158521')->is_valid_number, '伊豆下田病院');
ok($zip->set_number('4158522')->is_valid_number, 'NTT 下田営業所');
ok($zip->set_number('4158523')->is_valid_number, '東京電力 株式会社 下田営業所');
ok($zip->set_number('4158524')->is_valid_number, '静岡地方法務局 下田支局');
ok($zip->set_number('4158525')->is_valid_number, '下田プリンスホテル');
ok($zip->set_number('4158526')->is_valid_number, '静岡県立下田南高等学校');
ok($zip->set_number('4158527')->is_valid_number, '静岡県立下田北高等学校');
ok($zip->set_number('4158528')->is_valid_number, '下田警察署');
ok($zip->set_number('4158530')->is_valid_number, '株式会社 サンプラーザ');
ok($zip->set_number('4158602')->is_valid_number, '下田信用金庫');
ok($zip->set_number('4158603')->is_valid_number, '下田商工会議所');
ok($zip->set_number('4158611')->is_valid_number, '河津建設 株式会社');
ok($zip->set_number('4168501')->is_valid_number, '旭化成 株式会社 富士支社');
ok($zip->set_number('4168521')->is_valid_number, '東芝キャリア 株式会社');
ok($zip->set_number('4168530')->is_valid_number, '日本製紙 株式会社 富士工場');
ok($zip->set_number('4168533')->is_valid_number, 'ポリプラスチックス 株式会社 富士工場');
ok($zip->set_number('4168540')->is_valid_number, 'オー・ジー 株式会社 富士支店');
ok($zip->set_number('4168544')->is_valid_number, '富士財務事務所');
ok($zip->set_number('4168555')->is_valid_number, '学校法人 富士学園 静岡県富士見高等学校');
ok($zip->set_number('4168558')->is_valid_number, '富士市 保健女性センター');
ok($zip->set_number('4168577')->is_valid_number, '株式会社 アール・アンド・ケー');
ok($zip->set_number('4168650')->is_valid_number, '富士税務署');
ok($zip->set_number('4168654')->is_valid_number, '富士社会保険事務所');
ok($zip->set_number('4168655')->is_valid_number, '富士化工 株式会社');
ok($zip->set_number('4168656')->is_valid_number, '王子製紙 株式会社 富士工場');
ok($zip->set_number('4168659')->is_valid_number, '株式会社 石井組');
ok($zip->set_number('4168660')->is_valid_number, '大興製紙 株式会社');
ok($zip->set_number('4178501')->is_valid_number, 'アスト 株式会社');
ok($zip->set_number('4178503')->is_valid_number, '春日製紙工業 株式会社');
ok($zip->set_number('4178505')->is_valid_number, '高木産業 株式会社');
ok($zip->set_number('4178506')->is_valid_number, '静岡県 労働金庫 吉原支店');
ok($zip->set_number('4178507')->is_valid_number, 'イデシギョー 株式会社');
ok($zip->set_number('4178508')->is_valid_number, '株式会社 ひのや');
ok($zip->set_number('4178510')->is_valid_number, '株式会社 スギヤマ');
ok($zip->set_number('4178511')->is_valid_number, '静岡地方裁判所 富士支部 静岡家庭裁判所 富士支部 富士簡易裁判所');
ok($zip->set_number('4178512')->is_valid_number, '株式会社 サンメイカ 富士支店');
ok($zip->set_number('4178519')->is_valid_number, 'NTTマーケティングアクト静岡 株式会社 富士ソリューション営業部');
ok($zip->set_number('4178520')->is_valid_number, '日本大昭和板紙吉永 株式会社');
ok($zip->set_number('4178522')->is_valid_number, '日本プラスト 株式会社');
ok($zip->set_number('4178529')->is_valid_number, '株式会社 イエローハット');
ok($zip->set_number('4178530')->is_valid_number, '日本食品化工 株式会社');
ok($zip->set_number('4178531')->is_valid_number, '川商コイル 株式会社');
ok($zip->set_number('4178533')->is_valid_number, '株式会社 中村組');
ok($zip->set_number('4178535')->is_valid_number, '三興製紙 株式会社');
ok($zip->set_number('4178538')->is_valid_number, '第一建設');
ok($zip->set_number('4178540')->is_valid_number, '株式会社 鈴木建設工業');
ok($zip->set_number('4178543')->is_valid_number, '櫻井化学興業 株式会社');
ok($zip->set_number('4178545')->is_valid_number, '県立吉原高等学校');
ok($zip->set_number('4178550')->is_valid_number, '静岡県富士工業技術支援センター');
ok($zip->set_number('4178555')->is_valid_number, '五條製紙 株式会社');
ok($zip->set_number('4178560')->is_valid_number, '株式会社 興人富士工場');
ok($zip->set_number('4178565')->is_valid_number, '株式会社 齊藤商会');
ok($zip->set_number('4178566')->is_valid_number, '静岡県富士警察署');
ok($zip->set_number('4178567')->is_valid_number, '富士市立中央病院');
ok($zip->set_number('4178570')->is_valid_number, '大昭和紙工産業');
ok($zip->set_number('4178571')->is_valid_number, '県立富士東高等学校');
ok($zip->set_number('4178575')->is_valid_number, 'ビヨンズ 株式会社');
ok($zip->set_number('4178577')->is_valid_number, '株式会社 近藤商店');
ok($zip->set_number('4178580')->is_valid_number, '株式会社 マルダイ');
ok($zip->set_number('4178585')->is_valid_number, 'ジヤトコ 株式会社');
ok($zip->set_number('4178588')->is_valid_number, '藤沢薬品工業 株式会社 富士工場');
ok($zip->set_number('4178601')->is_valid_number, '富士市役所');
ok($zip->set_number('4178609')->is_valid_number, '富士公共職業安定所');
ok($zip->set_number('4178610')->is_valid_number, '日本製紙 株式会社 鈴川工場');
ok($zip->set_number('4178632')->is_valid_number, '富士商工会議所');
ok($zip->set_number('4178650')->is_valid_number, '興和 株式会社 富士工場');
ok($zip->set_number('4178686')->is_valid_number, '富士信用金庫');
ok($zip->set_number('4180192')->is_valid_number, '株式会社 エッチ・ケー・エス');
ok($zip->set_number('4188601')->is_valid_number, '富士宮市役所');
ok($zip->set_number('4188666')->is_valid_number, '富士写真フイルム 株式会社 富士宮工場');
ok($zip->set_number('4188686')->is_valid_number, '富士宮信用金庫');
ok($zip->set_number('4190192')->is_valid_number, '函南町役場');
ok($zip->set_number('4190193')->is_valid_number, 'NTT東日本 伊豆病院');
ok($zip->set_number('4190293')->is_valid_number, '丸井製紙 株式会社');
ok($zip->set_number('4190295')->is_valid_number, '丸富製紙 株式会社 富士根工場');
ok($zip->set_number('4190392')->is_valid_number, '芝川町役場');
ok($zip->set_number('4208501')->is_valid_number, '日本信販 株式会社 静岡統括部');
ok($zip->set_number('4208502')->is_valid_number, '静岡県立 静岡中央高等学校');
ok($zip->set_number('4208503')->is_valid_number, '株式会社 静岡リビング新聞社');
ok($zip->set_number('4208505')->is_valid_number, '三井住友建設 (株) 静岡支店');
ok($zip->set_number('4208507')->is_valid_number, '静岡工科専門学校');
ok($zip->set_number('4208508')->is_valid_number, '新静岡セノバ');
ok($zip->set_number('4208509')->is_valid_number, '静鉄観光サービス 株式会社');
ok($zip->set_number('4208510')->is_valid_number, '静岡鉄道 株式会社');
ok($zip->set_number('4208511')->is_valid_number, '東海大学短期大学部');
ok($zip->set_number('4208512')->is_valid_number, '全国健康保険協会 静岡支部');
ok($zip->set_number('4208515')->is_valid_number, '株式会社 日本交通公社 静岡支店');
ok($zip->set_number('4208520')->is_valid_number, '静岡広告 株式会社');
ok($zip->set_number('4208521')->is_valid_number, '富士ゼロックス 株式会社 静岡営業所');
ok($zip->set_number('4208522')->is_valid_number, '株式会社 静岡フジカラー');
ok($zip->set_number('4208523')->is_valid_number, '株式会社 青島文化教材社');
ok($zip->set_number('4208525')->is_valid_number, '相川鉄工 株式会社');
ok($zip->set_number('4208528')->is_valid_number, '株式会社 メガネトップ');
ok($zip->set_number('4208530')->is_valid_number, 'あいおい損害保険 株式会社');
ok($zip->set_number('4208536')->is_valid_number, '株式会社 静岡三共');
ok($zip->set_number('4208537')->is_valid_number, '静岡産業技術専門学校');
ok($zip->set_number('4208538')->is_valid_number, '学校法人 静岡理工科大学');
ok($zip->set_number('4208550')->is_valid_number, '株式会社 村上開明堂');
ok($zip->set_number('4208555')->is_valid_number, '株式会社 西武百貨店 静岡店');
ok($zip->set_number('4208557')->is_valid_number, '静岡県 トラック運送健康組合');
ok($zip->set_number('4208558')->is_valid_number, '静岡県 国民健康保険団体連合会');
ok($zip->set_number('4208560')->is_valid_number, '株式会社 松阪屋 静岡店');
ok($zip->set_number('4208567')->is_valid_number, '株式会社 静岡朝日テレビ');
ok($zip->set_number('4208570')->is_valid_number, '株式会社 白形傳四郎商店');
ok($zip->set_number('4208580')->is_valid_number, 'ヤマキ 株式会社');
ok($zip->set_number('4208581')->is_valid_number, '静岡トヨペット 株式会社');
ok($zip->set_number('4208585')->is_valid_number, '東京海上日動火災保険 株式会社 静岡支店');
ok($zip->set_number('4208588')->is_valid_number, '常葉学園中・高等学校');
ok($zip->set_number('4208601')->is_valid_number, '静岡県庁');
ok($zip->set_number('4208602')->is_valid_number, '静岡市役所');
ok($zip->set_number('4208603')->is_valid_number, '社団法人 静岡市静岡医師会');
ok($zip->set_number('4208604')->is_valid_number, '静岡家庭裁判所');
ok($zip->set_number('4208606')->is_valid_number, '静岡税務署');
ok($zip->set_number('4208610')->is_valid_number, '静岡県警察本部');
ok($zip->set_number('4208611')->is_valid_number, '静岡地方検察庁');
ok($zip->set_number('4208612')->is_valid_number, '安藤建設 株式会社 静岡支店');
ok($zip->set_number('4208616')->is_valid_number, '日本生命保険 相互会社 静岡支社');
ok($zip->set_number('4208618')->is_valid_number, '農林水産省関東農政局 静岡農政事務所');
ok($zip->set_number('4208620')->is_valid_number, '静岡中央警察署');
ok($zip->set_number('4208622')->is_valid_number, '静岡労働基準監督署');
ok($zip->set_number('4208623')->is_valid_number, 'JA静岡厚生連静岡厚生病院');
ok($zip->set_number('4208624')->is_valid_number, '静岡シェル石油販売 株式会社');
ok($zip->set_number('4208630')->is_valid_number, '静岡市立静岡病院');
ok($zip->set_number('4208633')->is_valid_number, '静岡地方裁判所');
ok($zip->set_number('4208636')->is_valid_number, '東海財務局 静岡財務事務所');
ok($zip->set_number('4208637')->is_valid_number, '静岡県 環境衛生科学研究所');
ok($zip->set_number('4208639')->is_valid_number, '静岡労働基準局');
ok($zip->set_number('4208641')->is_valid_number, '株式会社 中日ショッパー 静岡統括部');
ok($zip->set_number('4208644')->is_valid_number, '静岡県信用漁業協同組合連合会');
ok($zip->set_number('4208650')->is_valid_number, '静岡地方法務局');
ok($zip->set_number('4208655')->is_valid_number, '高田薬局');
ok($zip->set_number('4208660')->is_valid_number, '静岡県立 こども病院');
ok($zip->set_number('4208666')->is_valid_number, '静岡県漁業協同組合連合会');
ok($zip->set_number('4208670')->is_valid_number, '社会福祉法人 静岡県社会福祉協議会');
ok($zip->set_number('4208677')->is_valid_number, '株式会社 トーエネック 静岡支店');
ok($zip->set_number('4208680')->is_valid_number, '株式会社 帝国データバンク 静岡支店');
ok($zip->set_number('4208681')->is_valid_number, '株式会社 バンダイ お客様相談センター');
ok($zip->set_number('4208685')->is_valid_number, '西日本電信電話 株式会社 静岡支店');
ok($zip->set_number('4208686')->is_valid_number, '株式会社 エヌ・ビー中根屋');
ok($zip->set_number('4208688')->is_valid_number, '独立行政法人 国立病院機構 静岡てんかん神経医療センター');
ok($zip->set_number('4208702')->is_valid_number, '株式会社 中部銀行');
ok($zip->set_number('4208703')->is_valid_number, '静岡県労働金庫');
ok($zip->set_number('4208704')->is_valid_number, '中央三井信託銀行 株式会社 静岡支店');
ok($zip->set_number('4208706')->is_valid_number, '共栄火災海上保険 株式会社');
ok($zip->set_number('4208709')->is_valid_number, '稲葉商店');
ok($zip->set_number('4208710')->is_valid_number, '静岡県信用保証協会');
ok($zip->set_number('4208712')->is_valid_number, 'ヒダ 株式会社');
ok($zip->set_number('4208720')->is_valid_number, '日本銀行 静岡支店');
ok($zip->set_number('4208721')->is_valid_number, '日本放送協会 静岡放送局');
ok($zip->set_number('4208722')->is_valid_number, '大和証券 株式会社 静岡支店');
ok($zip->set_number('4208733')->is_valid_number, '中部電力 株式会社 静岡支店');
ok($zip->set_number('4208738')->is_valid_number, '株式会社 茜屋');
ok($zip->set_number('4208739')->is_valid_number, '商工組合中央金庫 静岡支店');
ok($zip->set_number('4208740')->is_valid_number, '三井物産 株式会社 静岡支店');
ok($zip->set_number('4208747')->is_valid_number, '三菱UFJ信託銀行 株式会社 静岡支店');
ok($zip->set_number('4208760')->is_valid_number, '株式会社 静岡銀行 本部');
ok($zip->set_number('4208761')->is_valid_number, '株式会社 静岡銀行 本店');
ok($zip->set_number('4210188')->is_valid_number, '株式会社 市川園');
ok($zip->set_number('4210192')->is_valid_number, '株式会社 巴川製紙所 静岡事業所');
ok($zip->set_number('4210193')->is_valid_number, '医療法人 沖縄徳洲会 静岡徳洲会病院');
ok($zip->set_number('4210195')->is_valid_number, '株式会社 平喜');
ok($zip->set_number('4210197')->is_valid_number, '中央物産 株式会社');
ok($zip->set_number('4210198')->is_valid_number, '株式会社 市川園');
ok($zip->set_number('4210292')->is_valid_number, '大井川庁舎');
ok($zip->set_number('4210293')->is_valid_number, '航空自衛隊');
ok($zip->set_number('4210298')->is_valid_number, '株式会社 ニッセー');
ok($zip->set_number('4210392')->is_valid_number, '株式会社 ソニー・ファミリークラブ');
ok($zip->set_number('4210393')->is_valid_number, '株式会社 ソニー・ファミリークラブ');
ok($zip->set_number('4210394')->is_valid_number, '株式会社 ソニー・ファミリークラブ');
ok($zip->set_number('4210395')->is_valid_number, '吉田町役場');
ok($zip->set_number('4210396')->is_valid_number, '富士写真フイルム 株式会社 吉田南工場');
ok($zip->set_number('4210397')->is_valid_number, '(株) ソニー・ファミリークラブ');
ok($zip->set_number('4210492')->is_valid_number, '矢崎部品 株式会社 榛原工場');
ok($zip->set_number('4210493')->is_valid_number, '榛原総合病院');
ok($zip->set_number('4210495')->is_valid_number, '牧之原市役所');
ok($zip->set_number('4210496')->is_valid_number, '日機装 株式会社 静岡製作所');
ok($zip->set_number('4210592')->is_valid_number, '牧之原市役所 相良庁舎');
ok($zip->set_number('4210593')->is_valid_number, '相良物産 株式会社');
ok($zip->set_number('4210595')->is_valid_number, 'TDK 株式会社 静岡工場');
ok($zip->set_number('4210596')->is_valid_number, '相良高等学校');
ok($zip->set_number('4210598')->is_valid_number, '東洋製罐 株式会社 静岡工場');
ok($zip->set_number('4211295')->is_valid_number, 'コクヨ西関東販売 株式会社');
ok($zip->set_number('4211298')->is_valid_number, '静岡県 静岡工業技術センター');
ok($zip->set_number('4211392')->is_valid_number, '株式会社 佐藤園');
ok($zip->set_number('4213292')->is_valid_number, 'リョービ 株式会社 静岡工場');
ok($zip->set_number('4213295')->is_valid_number, '株式会社 ホテイフーズコーポレーション');
ok($zip->set_number('4213296')->is_valid_number, 'ニチフリ食品 株式会社');
ok($zip->set_number('4213297')->is_valid_number, '日本軽金属 株式会社 蒲原製造所');
ok($zip->set_number('4228502')->is_valid_number, '静岡いすず自動車 株式会社');
ok($zip->set_number('4228504')->is_valid_number, '大和ハウス工業 株式会社 静岡支店');
ok($zip->set_number('4228505')->is_valid_number, '村田工業 株式会社');
ok($zip->set_number('4228506')->is_valid_number, '静岡市 農業協同組合');
ok($zip->set_number('4228507')->is_valid_number, '太陽建機レンタル 株式会社');
ok($zip->set_number('4228509')->is_valid_number, '日産部品静岡販売 株式会社');
ok($zip->set_number('4228510')->is_valid_number, '社団法人 静岡県トラック協会');
ok($zip->set_number('4228511')->is_valid_number, '社会保険診療報酬支払基金 静岡支部');
ok($zip->set_number('4228512')->is_valid_number, '静岡日産自動車 株式会社');
ok($zip->set_number('4228514')->is_valid_number, '東海自動車工業 株式会社');
ok($zip->set_number('4228515')->is_valid_number, '静岡トヨタ自動車 株式会社');
ok($zip->set_number('4228516')->is_valid_number, '日星石油 株式会社');
ok($zip->set_number('4228517')->is_valid_number, '社団法人 日本自動車連盟 静岡支部');
ok($zip->set_number('4228518')->is_valid_number, '日産プリンス静岡販売 株式会社');
ok($zip->set_number('4228519')->is_valid_number, '矢崎化工 株式会社');
ok($zip->set_number('4228520')->is_valid_number, '静岡県 教職員生活協同組合');
ok($zip->set_number('4228521')->is_valid_number, 'トラスコ中山 株式会社 静岡営業所');
ok($zip->set_number('4228522')->is_valid_number, '株式会社 ビープラン');
ok($zip->set_number('4228523')->is_valid_number, '株式会社 オズ');
ok($zip->set_number('4228524')->is_valid_number, '株式会社 エスラップコミニュケーションズ');
ok($zip->set_number('4228525')->is_valid_number, 'テレビ静岡');
ok($zip->set_number('4228526')->is_valid_number, '静岡県立大学');
ok($zip->set_number('4228527')->is_valid_number, '静岡済生会総合病院');
ok($zip->set_number('4228528')->is_valid_number, '三菱電機 株式会社 静岡製作所');
ok($zip->set_number('4228529')->is_valid_number, '静岡大学');
ok($zip->set_number('4228530')->is_valid_number, '理研軽金属工業 株式会社');
ok($zip->set_number('4228531')->is_valid_number, '静岡大学片山寮');
ok($zip->set_number('4228545')->is_valid_number, '静岡英和学院大学 短期大学部');
ok($zip->set_number('4228550')->is_valid_number, '静岡市駿河区役所');
ok($zip->set_number('4228560')->is_valid_number, '株式会社 静岡第一テレビ');
ok($zip->set_number('4228561')->is_valid_number, '起立木工 株式会社');
ok($zip->set_number('4228562')->is_valid_number, '株式会社 グローバルアクト');
ok($zip->set_number('4228563')->is_valid_number, '株式会社 フロックス');
ok($zip->set_number('4228564')->is_valid_number, '富士工業 株式会社');
ok($zip->set_number('4228565')->is_valid_number, '東海家具工業 株式会社');
ok($zip->set_number('4228566')->is_valid_number, '真富士屋食品 株式会社');
ok($zip->set_number('4228567')->is_valid_number, '遠藤科学 株式会社');
ok($zip->set_number('4228568')->is_valid_number, 'NTT 静岡支店');
ok($zip->set_number('4228569')->is_valid_number, '株式会社 村上開明堂');
ok($zip->set_number('4228570')->is_valid_number, '旭化成ホームズ (株)');
ok($zip->set_number('4228571')->is_valid_number, '(株) ヤマシタコーポレーション');
ok($zip->set_number('4228572')->is_valid_number, '株式会社 富士通ソフトウェアテクノロジーズ 静岡事業所');
ok($zip->set_number('4228573')->is_valid_number, '丸紅 (株) 静岡支店');
ok($zip->set_number('4228574')->is_valid_number, '(株) 富士ロジテック');
ok($zip->set_number('4228575')->is_valid_number, '(株) ホテル小田急静岡');
ok($zip->set_number('4228576')->is_valid_number, '(株) マルウ海野商店');
ok($zip->set_number('4228577')->is_valid_number, '日本興亜損害保険 株式会社');
ok($zip->set_number('4228578')->is_valid_number, '静岡南警察署');
ok($zip->set_number('4228580')->is_valid_number, '旭化成リフォーム 株式会社 静岡事業所');
ok($zip->set_number('4228610')->is_valid_number, '株式会社 タミヤ');
ok($zip->set_number('4228615')->is_valid_number, '株式会社 シャンソン化粧品');
ok($zip->set_number('4228619')->is_valid_number, '静岡県 農業協同組合中央会');
ok($zip->set_number('4228620')->is_valid_number, '静岡県 経済農業協同組合連合会');
ok($zip->set_number('4228621')->is_valid_number, '静岡県 信用農業協同組合連合会');
ok($zip->set_number('4228622')->is_valid_number, '全国共済農業協同組合連合会 静岡県本部');
ok($zip->set_number('4228628')->is_valid_number, '日本電信電話 株式会社 静岡情報システムサービスセンタ');
ok($zip->set_number('4228630')->is_valid_number, '静岡県 静岡財務事務所');
ok($zip->set_number('4228633')->is_valid_number, '木内建設 株式会社');
ok($zip->set_number('4228650')->is_valid_number, '平和みらい 株式会社');
ok($zip->set_number('4228654')->is_valid_number, 'スター精密 株式会社');
ok($zip->set_number('4228666')->is_valid_number, '日本レーベル印刷 株式会社');
ok($zip->set_number('4228668')->is_valid_number, '静岡社会保険事務局 静岡社会保険事務室');
ok($zip->set_number('4228670')->is_valid_number, '株式会社 静岡新聞社');
ok($zip->set_number('4228677')->is_valid_number, '株式会社 静岡鐵工所');
ok($zip->set_number('4228680')->is_valid_number, '静岡放送 株式会社');
ok($zip->set_number('4228686')->is_valid_number, '協立電機 株式会社');
ok($zip->set_number('4228688')->is_valid_number, '静岡ガス 株式会社');
ok($zip->set_number('4228766')->is_valid_number, '静岡ガス 株式会社 静岡支社');
ok($zip->set_number('4240192')->is_valid_number, '清水農業協同組合');
ok($zip->set_number('4240193')->is_valid_number, 'JA静岡厚生連 清水厚生病院');
ok($zip->set_number('4240292')->is_valid_number, '独立行政法人 農業・食品産業技術総合研究機構 果樹研究所カンキツ研究興津拠点');
ok($zip->set_number('4248502')->is_valid_number, '東海溶材 株式会社');
ok($zip->set_number('4248503')->is_valid_number, '静岡スバル自動車 株式会社');
ok($zip->set_number('4248510')->is_valid_number, '株式会社 アイ・テック');
ok($zip->set_number('4248511')->is_valid_number, '東洋冷蔵 株式会社(清水)');
ok($zip->set_number('4248550')->is_valid_number, '静岡県立 清水東高等学校');
ok($zip->set_number('4248555')->is_valid_number, '菊池建設 株式会社');
ok($zip->set_number('4248558')->is_valid_number, '日本ケミカル工業 株式会社');
ok($zip->set_number('4248566')->is_valid_number, '駿河精機 株式会社');
ok($zip->set_number('4248601')->is_valid_number, '社会保険 桜ケ丘総合病院');
ok($zip->set_number('4248602')->is_valid_number, '静岡コンピューターサービス 株式会社');
ok($zip->set_number('4248603')->is_valid_number, 'JFEエンジニアリング 株式会社 清水製作所');
ok($zip->set_number('4248610')->is_valid_number, '東海大学 清水校舎');
ok($zip->set_number('4248611')->is_valid_number, '東海大学付属翔洋中等・高等学校');
ok($zip->set_number('4248620')->is_valid_number, '東海大学 社会教育センター');
ok($zip->set_number('4248622')->is_valid_number, '静岡県立 清水南高等学校');
ok($zip->set_number('4248624')->is_valid_number, '学校法人 星美学園');
ok($zip->set_number('4248631')->is_valid_number, '三井・デュポンフロロケミカル 株式会社 清水工場');
ok($zip->set_number('4248633')->is_valid_number, '独立行政法人 水産総合研究センター 遠洋水産研究所');
ok($zip->set_number('4248636')->is_valid_number, '静岡市立 清水病院');
ok($zip->set_number('4248637')->is_valid_number, '静岡県立 清水西高等学校');
ok($zip->set_number('4248648')->is_valid_number, '大和製缶 株式会社');
ok($zip->set_number('4248650')->is_valid_number, '静岡地方法務局 清水出張所');
ok($zip->set_number('4248666')->is_valid_number, '清和海運 株式会社');
ok($zip->set_number('4248668')->is_valid_number, '株式会社 古川組 静岡支店');
ok($zip->set_number('4248677')->is_valid_number, '株式会社 静岡銀行');
ok($zip->set_number('4248678')->is_valid_number, '独立行政法人 海員学校国立清水海上技術短期大学校');
ok($zip->set_number('4248686')->is_valid_number, '株式会社 カナサシ重工');
ok($zip->set_number('4248688')->is_valid_number, '協和医科器械 株式会社');
ok($zip->set_number('4248701')->is_valid_number, '静岡市役所 清水庁舎');
ok($zip->set_number('4248708')->is_valid_number, '村上貿易 株式会社');
ok($zip->set_number('4248715')->is_valid_number, '株式会社 清水銀行');
ok($zip->set_number('4248717')->is_valid_number, '株式会社 三明');
ok($zip->set_number('4248719')->is_valid_number, '株式会社 ニッセー日本平ホテル');
ok($zip->set_number('4248720')->is_valid_number, '株式会社 ノダ 清水事業所');
ok($zip->set_number('4248721')->is_valid_number, '株式会社 静岡銀行 清水支店');
ok($zip->set_number('4248724')->is_valid_number, '東燃ゼネラル石油 株式会社 清水油漕所');
ok($zip->set_number('4248727')->is_valid_number, '望月燃料 株式会社');
ok($zip->set_number('4248730')->is_valid_number, 'ヤヨイ食品 株式会社');
ok($zip->set_number('4248734')->is_valid_number, '清水商工会議所');
ok($zip->set_number('4248750')->is_valid_number, 'はごろもフーズ 株式会社');
ok($zip->set_number('4248751')->is_valid_number, '清水税務署');
ok($zip->set_number('4248752')->is_valid_number, '静岡市立 清水商業高等学校');
ok($zip->set_number('4248755')->is_valid_number, '北静木材 株式会社');
ok($zip->set_number('4248760')->is_valid_number, 'アオキトランス 株式会社');
ok($zip->set_number('4248767')->is_valid_number, 'クミアイ化学工業 株式会社');
ok($zip->set_number('4258501')->is_valid_number, '焼津信用金庫');
ok($zip->set_number('4258502')->is_valid_number, '焼津市役所');
ok($zip->set_number('4258503')->is_valid_number, '株式会社 菱食 静岡支店');
ok($zip->set_number('4258505')->is_valid_number, '焼津市立総合病院');
ok($zip->set_number('4258508')->is_valid_number, '株式会社 ハットリ製茶');
ok($zip->set_number('4258511')->is_valid_number, '株式会社 赤阪鉄工所');
ok($zip->set_number('4258522')->is_valid_number, 'サッポロビール 株式会社 静岡工場');
ok($zip->set_number('4258533')->is_valid_number, '焼津簡易保険保養センター');
ok($zip->set_number('4258555')->is_valid_number, '株式会社 ビック東海 西静支社');
ok($zip->set_number('4258560')->is_valid_number, '株式会社 アンビ・ア');
ok($zip->set_number('4258570')->is_valid_number, '焼津水産化学工業 株式会社');
ok($zip->set_number('4258585')->is_valid_number, '焼津市文化会館');
ok($zip->set_number('4258611')->is_valid_number, '静岡福祉大学');
ok($zip->set_number('4258680')->is_valid_number, '株式会社 富士屋');
ok($zip->set_number('4258686')->is_valid_number, '石原水産 株式会社');
ok($zip->set_number('4258701')->is_valid_number, '焼津漁業協同組合');
ok($zip->set_number('4258708')->is_valid_number, '株式会社 柳屋 本店');
ok($zip->set_number('4258711')->is_valid_number, '株式会社 ハセガワ');
ok($zip->set_number('4260292')->is_valid_number, '日本ビクター 株式会社 モーター事業部');
ok($zip->set_number('4268501')->is_valid_number, '株式会社 大黒屋');
ok($zip->set_number('4268503')->is_valid_number, '株式会社 静岡産業社 藤枝営業所');
ok($zip->set_number('4268510')->is_valid_number, '富士鋼業 株式会社');
ok($zip->set_number('4268511')->is_valid_number, '株式会社 マルタカ');
ok($zip->set_number('4268515')->is_valid_number, 'ヤマキ 株式会社 藤枝支店');
ok($zip->set_number('4268539')->is_valid_number, '株式会社 ツムラ 静岡工場');
ok($zip->set_number('4268543')->is_valid_number, '株式会社 西友 藤枝店');
ok($zip->set_number('4268566')->is_valid_number, '株式会社 扶桑工業');
ok($zip->set_number('4268567')->is_valid_number, '三井農林 株式会社 藤枝工場');
ok($zip->set_number('4268570')->is_valid_number, '株式会社 アライドマテリアル');
ok($zip->set_number('4268575')->is_valid_number, '株式会社 山田組');
ok($zip->set_number('4268577')->is_valid_number, '静岡県立 藤枝東高等学校');
ok($zip->set_number('4268601')->is_valid_number, '株式会社 村上開明堂 ミラー機器事業部');
ok($zip->set_number('4268612')->is_valid_number, '住友ベークライト 株式会社');
ok($zip->set_number('4268617')->is_valid_number, '有限会社 新日邦');
ok($zip->set_number('4268631')->is_valid_number, '藤枝製紙 株式会社');
ok($zip->set_number('4268633')->is_valid_number, '共和成産 株式会社');
ok($zip->set_number('4268640')->is_valid_number, '持田製薬 株式会社 藤枝事業所');
ok($zip->set_number('4268642')->is_valid_number, '日清紡 藤枝工場');
ok($zip->set_number('4268646')->is_valid_number, '科研製薬 株式会社 静岡工場');
ok($zip->set_number('4268662')->is_valid_number, '医療法人社団 平成会藤枝平成記念病院');
ok($zip->set_number('4268663')->is_valid_number, '藤枝財務事務所');
ok($zip->set_number('4268666')->is_valid_number, '株式会社 藤越');
ok($zip->set_number('4268668')->is_valid_number, '静岡産業大学 国際情報学部');
ok($zip->set_number('4268670')->is_valid_number, '株式会社 ニシムラ');
ok($zip->set_number('4268677')->is_valid_number, '藤枝市立総合病院');
ok($zip->set_number('4268711')->is_valid_number, '藤枝 税務署');
ok($zip->set_number('4268722')->is_valid_number, '藤枝市役所');
ok($zip->set_number('4270193')->is_valid_number, '静岡カントリー事務センター 株式会社 東興');
ok($zip->set_number('4270195')->is_valid_number, '株式会社 ヤマシタコーポレーション 静岡事業所');
ok($zip->set_number('4270196')->is_valid_number, '(株)ヤマシタコーポレーション 本社業務部');
ok($zip->set_number('4278501')->is_valid_number, '島田市役所');
ok($zip->set_number('4278502')->is_valid_number, '市立島田市民病院');
ok($zip->set_number('4278505')->is_valid_number, '東海加工紙 株式会社');
ok($zip->set_number('4278508')->is_valid_number, '島田労働基準監督署');
ok($zip->set_number('4278509')->is_valid_number, '島田公共職業安定所');
ok($zip->set_number('4278510')->is_valid_number, '東海パルプ 株式会社');
ok($zip->set_number('4278511')->is_valid_number, '株式会社 シズテー');
ok($zip->set_number('4278512')->is_valid_number, 'サカイ産業 株式会社');
ok($zip->set_number('4278522')->is_valid_number, '大河原建設 株式会社');
ok($zip->set_number('4278525')->is_valid_number, '島田理化工業 株式会社 島田製作所');
ok($zip->set_number('4278541')->is_valid_number, '静岡県立島田工業高等学校');
ok($zip->set_number('4278555')->is_valid_number, '矢崎計器 株式会社 島田製作所');
ok($zip->set_number('4278581')->is_valid_number, '日清紡 株式会社 島田工場');
ok($zip->set_number('4278588')->is_valid_number, '静岡県立島田高等学校');
ok($zip->set_number('4278601')->is_valid_number, '島田 税務署');
ok($zip->set_number('4278602')->is_valid_number, '島田信用金庫');
ok($zip->set_number('4278686')->is_valid_number, '島田信用金庫 事務集中部');
ok($zip->set_number('4280192')->is_valid_number, '白瀧製茶 株式会社');
ok($zip->set_number('4288501')->is_valid_number, '野菜茶業試験場');
ok($zip->set_number('4288502')->is_valid_number, '株式会社 寺田製作所');
ok($zip->set_number('4288503')->is_valid_number, '大井川鉄道 株式会社');
ok($zip->set_number('4288650')->is_valid_number, '島田市役所 金谷支所');
ok($zip->set_number('4288651')->is_valid_number, 'ティーライフ 株式会社');
ok($zip->set_number('4288652')->is_valid_number, 'サンエムパッケージ 株式会社');
ok($zip->set_number('4288686')->is_valid_number, 'なかすぎ園');
ok($zip->set_number('4300898')->is_valid_number, '浜松市 南区役所');
ok($zip->set_number('4308511')->is_valid_number, 'ホテル クラウンパレス浜松');
ok($zip->set_number('4308520')->is_valid_number, '静岡地方裁判所 浜松支部');
ok($zip->set_number('4308530')->is_valid_number, 'アズマ工業 (株)');
ok($zip->set_number('4308533')->is_valid_number, '学校法人 静岡文化芸術大学');
ok($zip->set_number('4308536')->is_valid_number, '豊島 株式会社 浜松支店');
ok($zip->set_number('4308540')->is_valid_number, '日管 (株)');
ok($zip->set_number('4308553')->is_valid_number, '小栗 株式会社');
ok($zip->set_number('4308555')->is_valid_number, '株式会社 大誠');
ok($zip->set_number('4308558')->is_valid_number, '聖隷浜松病院');
ok($zip->set_number('4308560')->is_valid_number, '遠州綿業 株式会社');
ok($zip->set_number('4308567')->is_valid_number, '富士ハウス 株式会社');
ok($zip->set_number('4308570')->is_valid_number, '浜松簡易裁判所');
ok($zip->set_number('4308575')->is_valid_number, 'K・MIX 静岡エフエム放送');
ok($zip->set_number('4308577')->is_valid_number, '東京海上日動火災保険 株式会社');
ok($zip->set_number('4308580')->is_valid_number, '榎本 株式会社');
ok($zip->set_number('4308585')->is_valid_number, '浜松西税務署');
ok($zip->set_number('4308587')->is_valid_number, '浜松ホトニクス 株式会社 本社事務所');
ok($zip->set_number('4308588')->is_valid_number, '株式会社 遠鉄百貨店');
ok($zip->set_number('4308620')->is_valid_number, '静岡家庭裁判所 浜松支部');
ok($zip->set_number('4308630')->is_valid_number, '静岡地方検察庁浜松支部,浜松区検察庁');
ok($zip->set_number('4308639')->is_valid_number, '浜松労働基準監督署');
ok($zip->set_number('4308650')->is_valid_number, 'ヤマハ 株式会社');
ok($zip->set_number('4308652')->is_valid_number, '浜松市役所・浜松市中区役所');
ok($zip->set_number('4308653')->is_valid_number, '浜松市役所・浜松市中区役所');
ok($zip->set_number('4308654')->is_valid_number, '株式会社 静岡銀行 浜松営業部');
ok($zip->set_number('4308655')->is_valid_number, '遠州鉄道 株式会社');
ok($zip->set_number('4308665')->is_valid_number, '株式会社 河合楽器製作所');
ok($zip->set_number('4308667')->is_valid_number, '浜松東税務署');
ok($zip->set_number('4308668')->is_valid_number, '西日本電信電話 株式会社 浜松市支店');
ok($zip->set_number('4308670')->is_valid_number, '浜松信用金庫');
ok($zip->set_number('4308675')->is_valid_number, '大和証券 株式会社 浜松支店');
ok($zip->set_number('4308677')->is_valid_number, '株式会社 ウチゲン');
ok($zip->set_number('4308678')->is_valid_number, '中村建設 株式会社');
ok($zip->set_number('4308680')->is_valid_number, '商工組合中央金庫 浜松支店');
ok($zip->set_number('4308686')->is_valid_number, '三立製菓 株式会社');
ok($zip->set_number('4308687')->is_valid_number, '豊田通商 株式会社 浜松支店');
ok($zip->set_number('4308689')->is_valid_number, '遠州信用金庫');
ok($zip->set_number('4310192')->is_valid_number, '株式会社 アツミテック');
ok($zip->set_number('4310193')->is_valid_number, '浜松西区役所 雄踏地域自治センター');
ok($zip->set_number('4310292')->is_valid_number, '舞阪地域自治センター');
ok($zip->set_number('4310295')->is_valid_number, '大和養魚 株式会社');
ok($zip->set_number('4310298')->is_valid_number, 'スズキ直納 株式会社');
ok($zip->set_number('4310395')->is_valid_number, '新居町役場');
ok($zip->set_number('4310492')->is_valid_number, '湖西市役所');
ok($zip->set_number('4310493')->is_valid_number, 'アスモ 株式会社');
ok($zip->set_number('4310494')->is_valid_number, '株式会社 ユニバンス');
ok($zip->set_number('4310495')->is_valid_number, 'FDK 株式会社 湖西工場');
ok($zip->set_number('4310496')->is_valid_number, 'ソニーブロードキャストプロダクツ 株式会社');
ok($zip->set_number('4311392')->is_valid_number, '社会福祉法人 聖隷福祉事業団 浜名湖エデンの園');
ok($zip->set_number('4311393')->is_valid_number, '財団法人 日本老人福祉財団 浜松ゆうゆうの里');
ok($zip->set_number('4311394')->is_valid_number, '株式会社 エフ・シー・シー');
ok($zip->set_number('4311395')->is_valid_number, '浜松市北区役所・細江地域自治センター');
ok($zip->set_number('4311495')->is_valid_number, '北区三ヶ日地域自治センター');
ok($zip->set_number('4311496')->is_valid_number, '浜名湖三ケ日簡易保険保養センター');
ok($zip->set_number('4311497')->is_valid_number, '三ケ日町 農業協同組合');
ok($zip->set_number('4312295')->is_valid_number, '引佐地域自治センター');
ok($zip->set_number('4313192')->is_valid_number, '浜松医科大学');
ok($zip->set_number('4313193')->is_valid_number, 'とぴあ浜松農業協同組合');
ok($zip->set_number('4313194')->is_valid_number, '株式会社 ユタカ技研');
ok($zip->set_number('4313195')->is_valid_number, '株式会社 日進機械製作所');
ok($zip->set_number('4313196')->is_valid_number, '浜松ホトニクス 株式会社 常光製作所');
ok($zip->set_number('4313392')->is_valid_number, '浜松市天竜区役所・天竜地域自治センター');
ok($zip->set_number('4313393')->is_valid_number, '矢崎資源 株式会社 天竜工場');
ok($zip->set_number('4313492')->is_valid_number, '天竜厚生会');
ok($zip->set_number('4314195')->is_valid_number, '水窪地域自治センター');
ok($zip->set_number('4328501')->is_valid_number, '浜松商工会議所');
ok($zip->set_number('4328507')->is_valid_number, '株式会社 聴涛館');
ok($zip->set_number('4328508')->is_valid_number, '株式会社 丸八真綿');
ok($zip->set_number('4328520')->is_valid_number, '株式会社 土屋建設');
ok($zip->set_number('4328521')->is_valid_number, '株式会社 クラベ');
ok($zip->set_number('4328522')->is_valid_number, 'エンシュウ 株式会社');
ok($zip->set_number('4328523')->is_valid_number, '沢根スプリング 株式会社');
ok($zip->set_number('4328528')->is_valid_number, 'ヤマハ発動機 株式会社 浜松マリン事業所');
ok($zip->set_number('4328531')->is_valid_number, '天方産業 株式会社');
ok($zip->set_number('4328532')->is_valid_number, '中泉 株式会社 浜松支店');
ok($zip->set_number('4328537')->is_valid_number, '浜松公共職業安定所');
ok($zip->set_number('4328541')->is_valid_number, '中部電力 (株) 浜松営業所');
ok($zip->set_number('4328550')->is_valid_number, '浜松市保健所');
ok($zip->set_number('4328551')->is_valid_number, '航空自衛隊 浜松基地');
ok($zip->set_number('4328555')->is_valid_number, '浜松労働基準監督署');
ok($zip->set_number('4328561')->is_valid_number, '静岡大学 工学部');
ok($zip->set_number('4328562')->is_valid_number, '須山建設 株式会社');
ok($zip->set_number('4328580')->is_valid_number, '財団法人 浜松市医療公社 浜松医療センター');
ok($zip->set_number('4328608')->is_valid_number, '株式会社 丸八');
ok($zip->set_number('4328611')->is_valid_number, 'スズキ 株式会社');
ok($zip->set_number('4328626')->is_valid_number, '浜松西社会保険事務所');
ok($zip->set_number('4328680')->is_valid_number, '株式会社 ハマネツ');
ok($zip->set_number('4328686')->is_valid_number, '静岡県立 浜松大平台高等学校');
ok($zip->set_number('4328688')->is_valid_number, '株式会社 ムトウ');
ok($zip->set_number('4338501')->is_valid_number, '本田技研工業 株式会社 浜松製作所');
ok($zip->set_number('4338510')->is_valid_number, 'パルステック工業 株式会社');
ok($zip->set_number('4338511')->is_valid_number, '浜松市 リハビリテーション病院');
ok($zip->set_number('4338520')->is_valid_number, '(株) アーレスティ');
ok($zip->set_number('4338530')->is_valid_number, '(株) フジコーポレーション');
ok($zip->set_number('4338540')->is_valid_number, 'サンカ');
ok($zip->set_number('4338550')->is_valid_number, '株式会社 栃木屋 東海営業所');
ok($zip->set_number('4338555')->is_valid_number, 'ユニー (株) アピタ初生店');
ok($zip->set_number('4338558')->is_valid_number, '社会福祉法人 聖隷福祉事業団 聖隷三方原病院');
ok($zip->set_number('4338567')->is_valid_number, '浜松工業高校');
ok($zip->set_number('4338601')->is_valid_number, '浜松信用金庫 事務集中部');
ok($zip->set_number('4348501')->is_valid_number, 'ヤマハ発動機 株式会社 浜北工場');
ok($zip->set_number('4348502')->is_valid_number, 'プレ葉ウォーク浜北');
ok($zip->set_number('4348505')->is_valid_number, '静岡県立浜北特別支援学校');
ok($zip->set_number('4348511')->is_valid_number, '独立行政法人 国立病院機構 天竜病院');
ok($zip->set_number('4348533')->is_valid_number, '浜松赤十字病院');
ok($zip->set_number('4348550')->is_valid_number, '浜松市浜北区役所');
ok($zip->set_number('4348601')->is_valid_number, '浜松ホトニクス 株式会社 中央研究所');
ok($zip->set_number('4358502')->is_valid_number, '浜松プラザウエスト');
ok($zip->set_number('4358505')->is_valid_number, 'オー・ジー 株式会社 浜松支店');
ok($zip->set_number('4358510')->is_valid_number, '株式会社 スズケン 浜松支店');
ok($zip->set_number('4358515')->is_valid_number, '株式会社 マルト 神戸屋');
ok($zip->set_number('4358520')->is_valid_number, 'ナガセ東海 株式会社');
ok($zip->set_number('4358522')->is_valid_number, '東海染工 株式会社 浜松事業所');
ok($zip->set_number('4358533')->is_valid_number, '大興産業 株式会社');
ok($zip->set_number('4358539')->is_valid_number, '浜松日産自動車 株式会社');
ok($zip->set_number('4358540')->is_valid_number, '株式会社 マキ製作所');
ok($zip->set_number('4358551')->is_valid_number, 'トヨタビスタ浜松 株式会社');
ok($zip->set_number('4358555')->is_valid_number, '中日新聞社 東海本社');
ok($zip->set_number('4358557')->is_valid_number, '株式会社 中日ショッパー');
ok($zip->set_number('4358558')->is_valid_number, '浜松ホトニクス 株式会社 本社工場');
ok($zip->set_number('4358560')->is_valid_number, '(株)ソミック石川');
ok($zip->set_number('4358561')->is_valid_number, '(株) 出雲流通センター');
ok($zip->set_number('4358567')->is_valid_number, 'ヤマハ (株) 天竜工場');
ok($zip->set_number('4358568')->is_valid_number, 'ヤマハファインテック (株)');
ok($zip->set_number('4358575')->is_valid_number, '矢崎総業 (株)');
ok($zip->set_number('4358585')->is_valid_number, 'ソニーイーエムシーエス 株式会社 浜松テック');
ok($zip->set_number('4358588')->is_valid_number, '弥栄商事 株式会社');
ok($zip->set_number('4358611')->is_valid_number, '株式会社 コーエイ');
ok($zip->set_number('4358619')->is_valid_number, '浜松東社会保険事務所');
ok($zip->set_number('4358642')->is_valid_number, '浜松市保健環境研究所');
ok($zip->set_number('4358660')->is_valid_number, '株式会社 ムトウ');
ok($zip->set_number('4358661')->is_valid_number, '株式会社 静岡メイカン');
ok($zip->set_number('4358686')->is_valid_number, '浜松市 東区役所');
ok($zip->set_number('4368501')->is_valid_number, 'NECアクセステクニカ 株式会社');
ok($zip->set_number('4368502')->is_valid_number, '掛川市立総合病院');
ok($zip->set_number('4368503')->is_valid_number, '丸和商事 株式会社');
ok($zip->set_number('4368650')->is_valid_number, '掛川市役所');
ok($zip->set_number('4368651')->is_valid_number, '掛川信用金庫');
ok($zip->set_number('4368652')->is_valid_number, '掛川 税務署');
ok($zip->set_number('4368653')->is_valid_number, '日本年金機構 掛川年金事務所');
ok($zip->set_number('4370292')->is_valid_number, '森山工業 株式会社');
ok($zip->set_number('4370293')->is_valid_number, '森町役場');
ok($zip->set_number('4370693')->is_valid_number, '秋葉神社');
ok($zip->set_number('4371192')->is_valid_number, '袋井市 浅羽支所');
ok($zip->set_number('4371193')->is_valid_number, 'ミネベア 株式会社 浜松製作所');
ok($zip->set_number('4371194')->is_valid_number, '株式会社 ショーワ 浅羽工場');
ok($zip->set_number('4371195')->is_valid_number, '天龍製鋸 株式会社');
ok($zip->set_number('4371196')->is_valid_number, '株式会社 スタジオコバ');
ok($zip->set_number('4371197')->is_valid_number, '日本ハイパック 株式会社 静岡工場');
ok($zip->set_number('4371292')->is_valid_number, '磐田市 福田支所');
ok($zip->set_number('4371392')->is_valid_number, '株式会社 遠興');
ok($zip->set_number('4371393')->is_valid_number, '掛川市役所 大須賀支所');
ok($zip->set_number('4371395')->is_valid_number, '横須賀高等学校');
ok($zip->set_number('4371397')->is_valid_number, 'コーニングジャパン 株式会社');
ok($zip->set_number('4371492')->is_valid_number, '株式会社 キャタラー');
ok($zip->set_number('4371494')->is_valid_number, '矢崎部品 株式会社 大浜工場');
ok($zip->set_number('4371495')->is_valid_number, '積水ハウス 株式会社 静岡工場');
ok($zip->set_number('4371496')->is_valid_number, 'クラリアントジャパン 株式会社 静岡工場');
ok($zip->set_number('4371592')->is_valid_number, '菊川市役所小笠支所');
ok($zip->set_number('4371593')->is_valid_number, '遠州夢咲 農業協同組合');
ok($zip->set_number('4371594')->is_valid_number, 'フガク工機 株式会社');
ok($zip->set_number('4371686')->is_valid_number, '株式会社 静岡カントリー 浜岡コース');
ok($zip->set_number('4371687')->is_valid_number, '浜岡原子力保安検査官事務所');
ok($zip->set_number('4371688')->is_valid_number, '御前崎市総合保健福祉センター');
ok($zip->set_number('4371692')->is_valid_number, '御前崎市役所');
ok($zip->set_number('4371693')->is_valid_number, '東海サンド 株式会社');
ok($zip->set_number('4371694')->is_valid_number, '御前崎市教育会館・市役所 御前崎支所');
ok($zip->set_number('4371695')->is_valid_number, '中部電力 株式会社 浜岡原子力発電所 総合事務所');
ok($zip->set_number('4371696')->is_valid_number, '市立御前崎総合病院');
ok($zip->set_number('4371697')->is_valid_number, 'シェブロンジャパン 株式会社 御前崎事業場');
ok($zip->set_number('4371698')->is_valid_number, 'エイケン工業 株式会社');
ok($zip->set_number('4378501')->is_valid_number, '株式会社 静岡カントリー 袋井コース');
ok($zip->set_number('4378511')->is_valid_number, '静岡パイオニア 株式会社');
ok($zip->set_number('4378545')->is_valid_number, 'エヌエスケー・ワーナー 株式会社');
ok($zip->set_number('4378555')->is_valid_number, '静岡理工科大学');
ok($zip->set_number('4378601')->is_valid_number, '静岡製機 株式会社');
ok($zip->set_number('4378611')->is_valid_number, '豊田肥料 株式会社');
ok($zip->set_number('4378666')->is_valid_number, '袋井市役所');
ok($zip->set_number('4378686')->is_valid_number, '丸尾興商 株式会社');
ok($zip->set_number('4380192')->is_valid_number, 'ヤマハ 株式会社 豊岡工場');
ok($zip->set_number('4380193')->is_valid_number, '浜松ホトニクス 株式会社 豊岡製作所');
ok($zip->set_number('4380195')->is_valid_number, '磐田市 豊岡支所');
ok($zip->set_number('4380292')->is_valid_number, '磐田市 竜洋支所');
ok($zip->set_number('4388501')->is_valid_number, 'ヤマハ発動機 株式会社');
ok($zip->set_number('4388510')->is_valid_number, 'NTN (株)');
ok($zip->set_number('4388543')->is_valid_number, '遠菱アルミホイール 株式会社');
ok($zip->set_number('4388550')->is_valid_number, '磐田市立総合病院');
ok($zip->set_number('4388555')->is_valid_number, '本州静岡ダンボール 株式会社');
ok($zip->set_number('4388558')->is_valid_number, '静岡県 中遠農林事務所');
ok($zip->set_number('4388577')->is_valid_number, '県立農林大学校');
ok($zip->set_number('4388585')->is_valid_number, '磐田労働基準監督署');
ok($zip->set_number('4388601')->is_valid_number, '磐田市 豊田支所');
ok($zip->set_number('4388611')->is_valid_number, '大日精化工業 株式会社 東海製造事業所');
ok($zip->set_number('4388622')->is_valid_number, '静岡県 中東遠健康福祉センター');
ok($zip->set_number('4388650')->is_valid_number, '磐田市役所');
ok($zip->set_number('4388686')->is_valid_number, '磐田南高等学校');
ok($zip->set_number('4388711')->is_valid_number, '磐田 税務署');
ok($zip->set_number('4388718')->is_valid_number, '磐田農業高等学校');
ok($zip->set_number('4398650')->is_valid_number, '菊川市役所');
ok($zip->set_number('4398651')->is_valid_number, '旭テック 株式会社');
ok($zip->set_number('4408501')->is_valid_number, '豊橋市役所');
ok($zip->set_number('4408502')->is_valid_number, '豊橋市上下水道局');
ok($zip->set_number('4408504')->is_valid_number, '豊橋税務署');
ok($zip->set_number('4408505')->is_valid_number, 'NTT 三河支店');
ok($zip->set_number('4408506')->is_valid_number, '豊橋労働基準監督署');
ok($zip->set_number('4408507')->is_valid_number, '豊橋公共職業安定所');
ok($zip->set_number('4408508')->is_valid_number, '豊橋商工会議所');
ok($zip->set_number('4408510')->is_valid_number, '国立病院機構豊橋医療センター');
ok($zip->set_number('4408511')->is_valid_number, '豊橋創造大学');
ok($zip->set_number('4408512')->is_valid_number, '豊橋創造大学 短期大学部');
ok($zip->set_number('4408513')->is_valid_number, '鈴与商事 株式会社 豊橋支店');
ok($zip->set_number('4408514')->is_valid_number, 'マルキチ商事 有限会社');
ok($zip->set_number('4408515')->is_valid_number, '愛知県東三河県民事務所');
ok($zip->set_number('4408516')->is_valid_number, '学校法人 桜丘学園');
ok($zip->set_number('4408517')->is_valid_number, '株式会社 精文館書店');
ok($zip->set_number('4408518')->is_valid_number, 'ササキ 株式会社');
ok($zip->set_number('4408519')->is_valid_number, '株式会社 豊橋トーエー');
ok($zip->set_number('4408520')->is_valid_number, '医療法人 青雲会佐野病院');
ok($zip->set_number('4408521')->is_valid_number, '株式会社 大仙');
ok($zip->set_number('4408522')->is_valid_number, '東愛知日産自動車 株式会社');
ok($zip->set_number('4408523')->is_valid_number, '中西相互 株式会社');
ok($zip->set_number('4408524')->is_valid_number, 'スバル東愛知販売 株式会社');
ok($zip->set_number('4408525')->is_valid_number, '株式会社 フジ電材');
ok($zip->set_number('4408526')->is_valid_number, '岩附 株式会社');
ok($zip->set_number('4408527')->is_valid_number, '豊橋ケーブルネットワーク 株式会社');
ok($zip->set_number('4408528')->is_valid_number, '愛知県東三河県税事務所');
ok($zip->set_number('4408530')->is_valid_number, '東海漬物 株式会社');
ok($zip->set_number('4408531')->is_valid_number, '中部ガス 株式会社');
ok($zip->set_number('4408532')->is_valid_number, 'ガステックサービス 株式会社');
ok($zip->set_number('4408533')->is_valid_number, '株式会社 サーラコーポレーション');
ok($zip->set_number('4408601')->is_valid_number, '三菱レイヨン 株式会社 豊橋事業所');
ok($zip->set_number('4408602')->is_valid_number, '株式会社 豊橋丸栄');
ok($zip->set_number('4408603')->is_valid_number, '豊橋信用金庫');
ok($zip->set_number('4408604')->is_valid_number, '豊橋鉄道 株式会社');
ok($zip->set_number('4410193')->is_valid_number, '日本トレクス 株式会社');
ok($zip->set_number('4410194')->is_valid_number, 'サンビシ 株式会社');
ok($zip->set_number('4410195')->is_valid_number, '医療法人 宝美会 総合青山病院');
ok($zip->set_number('4410292')->is_valid_number, '豊川市 音羽支所');
ok($zip->set_number('4410295')->is_valid_number, '株式会社 東海理化電機製作所 音羽工場');
ok($zip->set_number('4410392')->is_valid_number, '豊川市 御津支所');
ok($zip->set_number('4410393')->is_valid_number, '株式会社 丸上製作所');
ok($zip->set_number('4411292')->is_valid_number, '豊川市一宮総合支所');
ok($zip->set_number('4411293')->is_valid_number, '豊川信用金庫 事務センター');
ok($zip->set_number('4411294')->is_valid_number, 'オーエスジー 株式会社');
ok($zip->set_number('4411295')->is_valid_number, '住友軽金属工業 株式会社');
ok($zip->set_number('4411392')->is_valid_number, '新城市役所');
ok($zip->set_number('4411492')->is_valid_number, '新城市 作手総合支所');
ok($zip->set_number('4411692')->is_valid_number, '新城市 鳳来総合支所');
ok($zip->set_number('4413192')->is_valid_number, '朝日工業 株式会社');
ok($zip->set_number('4413193')->is_valid_number, '本多電子 株式会社');
ok($zip->set_number('4413194')->is_valid_number, '日東電工 株式会社 豊橋事業所');
ok($zip->set_number('4413195')->is_valid_number, '神鋼電機 株式会社 豊橋事業所');
ok($zip->set_number('4413196')->is_valid_number, '福井漁網 株式会社');
ok($zip->set_number('4413492')->is_valid_number, '田原市役所');
ok($zip->set_number('4413695')->is_valid_number, '田原市役所 渥美支所');
ok($zip->set_number('4418501')->is_valid_number, 'ガステックサービス 株式会社 豊橋事業所');
ok($zip->set_number('4418502')->is_valid_number, '株式会社 住野商会');
ok($zip->set_number('4418503')->is_valid_number, '株式会社 マーメイド');
ok($zip->set_number('4418507')->is_valid_number, '渥美運輸 株式会社');
ok($zip->set_number('4418510')->is_valid_number, 'トピー工業 株式会社 豊橋製造所');
ok($zip->set_number('4418511')->is_valid_number, '中部ガス 株式会社 豊橋支店');
ok($zip->set_number('4418512')->is_valid_number, '株式会社 丸金商会');
ok($zip->set_number('4418515')->is_valid_number, '玉川屋 株式会社');
ok($zip->set_number('4418517')->is_valid_number, 'トヨハシ種苗 株式会社');
ok($zip->set_number('4418519')->is_valid_number, '株式会社 石黒製薬所');
ok($zip->set_number('4418520')->is_valid_number, 'ユタカ自動車総業 株式会社');
ok($zip->set_number('4418522')->is_valid_number, '愛知大学');
ok($zip->set_number('4418525')->is_valid_number, '愛知県経済農業 協同組合連合会');
ok($zip->set_number('4418530')->is_valid_number, '医療法人 澄心会 豊橋ハートセンター');
ok($zip->set_number('4418533')->is_valid_number, '守田屋塗料 株式会社');
ok($zip->set_number('4418539')->is_valid_number, '豊橋市保健所・保健センター及びこども発達センター');
ok($zip->set_number('4418540')->is_valid_number, 'ポップリベット・ファスナー 株式会社');
ok($zip->set_number('4418543')->is_valid_number, '株式会社 エフエム豊橋');
ok($zip->set_number('4418545')->is_valid_number, 'ユーアイ電子 株式会社');
ok($zip->set_number('4418550')->is_valid_number, 'フォルクスワーゲングループジャパン 株式会社');
ok($zip->set_number('4418555')->is_valid_number, '医療法人 義興会 可知病院');
ok($zip->set_number('4418558')->is_valid_number, '中部ホームサービスステーション');
ok($zip->set_number('4418560')->is_valid_number, '武蔵精密工業 株式会社');
ok($zip->set_number('4418566')->is_valid_number, 'ガステックサービス 株式会社');
ok($zip->set_number('4418570')->is_valid_number, '豊橋市民病院');
ok($zip->set_number('4418577')->is_valid_number, '株式会社 新来島豊橋造船');
ok($zip->set_number('4418580')->is_valid_number, '豊橋技術科学大学');
ok($zip->set_number('4418588')->is_valid_number, '株式会社 中部');
ok($zip->set_number('4418666')->is_valid_number, '株式会社 東愛知新聞社');
ok($zip->set_number('4418686')->is_valid_number, '伊藤ハム 株式会社 豊橋工場');
ok($zip->set_number('4428501')->is_valid_number, 'シロキ工業 株式会社');
ok($zip->set_number('4428502')->is_valid_number, '日本車輌製造 株式会社 豊川製作所');
ok($zip->set_number('4428503')->is_valid_number, 'コニカミノルタ 瑞穂サイト');
ok($zip->set_number('4428505')->is_valid_number, '新東工業 株式会社 豊川製作所');
ok($zip->set_number('4428506')->is_valid_number, 'トピー工業 株式会社 豊川製造所');
ok($zip->set_number('4428507')->is_valid_number, '名古屋大学太陽地球環境研究所');
ok($zip->set_number('4428509')->is_valid_number, '旭テック 株式会社 豊川事業所');
ok($zip->set_number('4428510')->is_valid_number, '中日精工 株式会社');
ok($zip->set_number('4428511')->is_valid_number, '千代田電子工業 株式会社');
ok($zip->set_number('4428512')->is_valid_number, '株式会社 富士精工');
ok($zip->set_number('4428513')->is_valid_number, 'バスデイ 株式会社');
ok($zip->set_number('4428515')->is_valid_number, '新東ブレーター 株式会社');
ok($zip->set_number('4428516')->is_valid_number, 'トーアス 株式会社');
ok($zip->set_number('4428517')->is_valid_number, 'ひまわり 農業協同組合');
ok($zip->set_number('4428518')->is_valid_number, 'ユニー 株式会社 アピタ豊川店');
ok($zip->set_number('4428520')->is_valid_number, '豊川信用金庫');
ok($zip->set_number('4428530')->is_valid_number, '株式会社 共栄社');
ok($zip->set_number('4428531')->is_valid_number, '石黒商事 有限会社');
ok($zip->set_number('4428532')->is_valid_number, '宮地病院');
ok($zip->set_number('4428533')->is_valid_number, '株式会社 三菱東京UFJ銀行 豊川支店');
ok($zip->set_number('4428535')->is_valid_number, '株式会社 トヨテック 本社');
ok($zip->set_number('4428538')->is_valid_number, '宗教法人 豊川閣妙厳寺');
ok($zip->set_number('4428540')->is_valid_number, '豊川商工会議所');
ok($zip->set_number('4428541')->is_valid_number, '株式会社 ツシマ');
ok($zip->set_number('4428543')->is_valid_number, 'オーエスジー 株式会社');
ok($zip->set_number('4428544')->is_valid_number, 'オーエスジー 株式会社 R&Dセンター');
ok($zip->set_number('4428545')->is_valid_number, '福山通運 株式会社 豊橋支店');
ok($zip->set_number('4428546')->is_valid_number, '株式会社 豊梱');
ok($zip->set_number('4428558')->is_valid_number, 'コニカミノルタ 豊川サイト');
ok($zip->set_number('4428561')->is_valid_number, '豊川市民病院');
ok($zip->set_number('4428566')->is_valid_number, 'マルスホームデザイン');
ok($zip->set_number('4428569')->is_valid_number, '株式会社 対松堂');
ok($zip->set_number('4428573')->is_valid_number, '愛知県立豊川工業高等学校');
ok($zip->set_number('4428575')->is_valid_number, 'スズキ 株式会社 豊川工場');
ok($zip->set_number('4428576')->is_valid_number, '株式会社 アイイーメカトロニクス');
ok($zip->set_number('4428577')->is_valid_number, '岡田建設 株式会社');
ok($zip->set_number('4428580')->is_valid_number, '株式会社 AIHO');
ok($zip->set_number('4428581')->is_valid_number, '東海セイホク 株式会社');
ok($zip->set_number('4428582')->is_valid_number, '医療法人社団 隆豊会');
ok($zip->set_number('4428585')->is_valid_number, 'コニカミノルタ 三河サイト');
ok($zip->set_number('4428586')->is_valid_number, '愛知県立国府高等学校');
ok($zip->set_number('4428587')->is_valid_number, 'イトモル 株式会社');
ok($zip->set_number('4428588')->is_valid_number, 'イトモル精密株式会社');
ok($zip->set_number('4428590')->is_valid_number, '協同組合 ギフト用品卸販売二十一世紀');
ok($zip->set_number('4428591')->is_valid_number, '旭テックTDM 株式会社');
ok($zip->set_number('4428601')->is_valid_number, '豊川市役所');
ok($zip->set_number('4428602')->is_valid_number, '陸上自衛隊 豊川駐屯地');
ok($zip->set_number('4428603')->is_valid_number, '世界心道教');
ok($zip->set_number('4430192')->is_valid_number, '泰興 株式会社');
ok($zip->set_number('4430193')->is_valid_number, '株式会社 蒲サ食品');
ok($zip->set_number('4430194')->is_valid_number, 'カネキ水産 株式会社');
ok($zip->set_number('4438555')->is_valid_number, 'アイシン・エイ・ダブリュ 株式会社 蒲郡工場');
ok($zip->set_number('4438588')->is_valid_number, '学校法人 海陽学園 海陽中等教育学校');
ok($zip->set_number('4438601')->is_valid_number, '蒲郡市役所');
ok($zip->set_number('4438611')->is_valid_number, '竹本油脂 株式会社');
ok($zip->set_number('4440192')->is_valid_number, '幸田町役場');
ok($zip->set_number('4440193')->is_valid_number, '株式会社 デンソー 幸田製作所');
ok($zip->set_number('4440194')->is_valid_number, 'ソニーイーエムシーエス 株式会社 幸田テック');
ok($zip->set_number('4440381')->is_valid_number, '旭鉄工 株式会社');
ok($zip->set_number('4440391')->is_valid_number, '岡崎信用金庫 平坂支店');
ok($zip->set_number('4440392')->is_valid_number, '株式会社 オティックス');
ok($zip->set_number('4440393')->is_valid_number, '株式会社 杉浦製作所');
ok($zip->set_number('4440394')->is_valid_number, '東洋タイヤコード 株式会社');
ok($zip->set_number('4440395')->is_valid_number, '碧海工機 株式会社');
ok($zip->set_number('4440396')->is_valid_number, '幡豆工業 株式会社');
ok($zip->set_number('4440397')->is_valid_number, '(株) 松川鉄工所');
ok($zip->set_number('4440398')->is_valid_number, '阪部工業 (株)');
ok($zip->set_number('4440492')->is_valid_number, '一色町役場');
ok($zip->set_number('4440493')->is_valid_number, '毎味水産 株式会社');
ok($zip->set_number('4440494')->is_valid_number, 'イケダヤ製菓 株式会社');
ok($zip->set_number('4440495')->is_valid_number, '医療法人 社団福祉会 高須病院');
ok($zip->set_number('4440496')->is_valid_number, '一色高校');
ok($zip->set_number('4440592')->is_valid_number, '(株) キラ.コーポレーション');
ok($zip->set_number('4440593')->is_valid_number, '大丸産業 株式会社');
ok($zip->set_number('4440595')->is_valid_number, '朝岡ワールド 株式会社');
ok($zip->set_number('4440596')->is_valid_number, '吉良町役場');
ok($zip->set_number('4440798')->is_valid_number, '幡豆町役場');
ok($zip->set_number('4441192')->is_valid_number, 'アイシン・エイ・ダブリュ 株式会社');
ok($zip->set_number('4441193')->is_valid_number, '東洋理工 株式会社');
ok($zip->set_number('4441195')->is_valid_number, '株式会社 イノアックコーポレーション 桜井事業所');
ok($zip->set_number('4441198')->is_valid_number, '株式会社 南山園');
ok($zip->set_number('4441295')->is_valid_number, '株式会社 豊田自動織機 安城工場');
ok($zip->set_number('4441296')->is_valid_number, '株式会社 タケヒロ');
ok($zip->set_number('4441297')->is_valid_number, '株式会社 ニッセイ');
ok($zip->set_number('4441298')->is_valid_number, 'いずみ製菓 株式会社');
ok($zip->set_number('4441385')->is_valid_number, 'エヌティーテクノ 株式会社');
ok($zip->set_number('4441386')->is_valid_number, 'エヌティーツール 株式会社');
ok($zip->set_number('4441387')->is_valid_number, 'エヌティーエンジニアリング 株式会社');
ok($zip->set_number('4441388')->is_valid_number, 'エヌティー精密 株式会社');
ok($zip->set_number('4441393')->is_valid_number, '株式会社 豊田自動織機製作所 高浜工場');
ok($zip->set_number('4441394')->is_valid_number, '株式会社 スギヤス');
ok($zip->set_number('4441394')->is_valid_number, '株式会社 スギヤスエンタープライズ');
ok($zip->set_number('4441397')->is_valid_number, 'ユアサ建材工業 株式会社');
ok($zip->set_number('4441398')->is_valid_number, '愛知県 高浜市役所');
ok($zip->set_number('4442192')->is_valid_number, '東海光学 株式会社');
ok($zip->set_number('4442193')->is_valid_number, 'マルサンアイ 株式会社');
ok($zip->set_number('4442194')->is_valid_number, '三菱自動車教育センター 株式会社');
ok($zip->set_number('4442892')->is_valid_number, '豊田市役所 旭支所');
ok($zip->set_number('4442893')->is_valid_number, '愛知県旭高原少年自然の家');
ok($zip->set_number('4443592')->is_valid_number, '豊興工業 株式会社');
ok($zip->set_number('4443593')->is_valid_number, '株式会社 ジェイテクト 岡崎工場');
ok($zip->set_number('4443594')->is_valid_number, '豊田バンモップス 株式会社');
ok($zip->set_number('4443595')->is_valid_number, '株式会社 前田シェルサービス');
ok($zip->set_number('4443692')->is_valid_number, '株式会社 高木製作所 岡崎工場');
ok($zip->set_number('4443695')->is_valid_number, '日本タッパーウェア 株式会社 岡崎製作所');
ok($zip->set_number('4443696')->is_valid_number, '岡崎市役所 額田支所');
ok($zip->set_number('4443698')->is_valid_number, 'スタンレー電気 株式会社 岡崎工場');
ok($zip->set_number('4448501')->is_valid_number, '三菱自動車工業 株式会社 名古屋自動車製作所・技術センター');
ok($zip->set_number('4448507')->is_valid_number, '東京海上火災保険 株式会社');
ok($zip->set_number('4448508')->is_valid_number, '名邦塗料商事 株式会社');
ok($zip->set_number('4448510')->is_valid_number, '日清紡績 株式会社 美合工場');
ok($zip->set_number('4448511')->is_valid_number, 'ユニチカ 株式会社 岡崎工場');
ok($zip->set_number('4448512')->is_valid_number, '東レ・モノフィラメント 株式会社');
ok($zip->set_number('4448516')->is_valid_number, 'ヤック 株式会社');
ok($zip->set_number('4448517')->is_valid_number, '住友生命保険 相互会社 愛知東支社');
ok($zip->set_number('4448520')->is_valid_number, '愛知学泉大学');
ok($zip->set_number('4448522')->is_valid_number, '東レ株式会社 岡崎工場');
ok($zip->set_number('4448530')->is_valid_number, '株式会社 川本製作所 岡崎工場');
ok($zip->set_number('4448533')->is_valid_number, '名古屋法務局 岡崎支局');
ok($zip->set_number('4448542')->is_valid_number, '三菱UFJニコス 株式会社 岡崎支店');
ok($zip->set_number('4448543')->is_valid_number, '株式会社 新東');
ok($zip->set_number('4448545')->is_valid_number, '岡崎市保健所');
ok($zip->set_number('4448551')->is_valid_number, '愛知県西三河事務所');
ok($zip->set_number('4448552')->is_valid_number, '岡崎税務署');
ok($zip->set_number('4448553')->is_valid_number, '岡崎市民病院');
ok($zip->set_number('4448554')->is_valid_number, '名古屋地方裁判所 岡崎支部');
ok($zip->set_number('4448555')->is_valid_number, '愛知県立岡崎工業高等学校');
ok($zip->set_number('4448558')->is_valid_number, 'フタバ産業 株式会社');
ok($zip->set_number('4448560')->is_valid_number, '日清紡績 株式会社 美合工機工場');
ok($zip->set_number('4448564')->is_valid_number, 'アイシン・エイ・ダブリュ (株) 岡崎工場');
ok($zip->set_number('4448567')->is_valid_number, '株式会社 レッドバロン');
ok($zip->set_number('4448577')->is_valid_number, 'ユアサ商事 株式会社 岡崎支店');
ok($zip->set_number('4448581')->is_valid_number, '志賀為 株式会社');
ok($zip->set_number('4448585')->is_valid_number, '大学共同利用機関法人 自然科学研究機構');
ok($zip->set_number('4448586')->is_valid_number, 'リコーエレメックス 株式会社 岡崎事業所');
ok($zip->set_number('4448588')->is_valid_number, '峰澤鋼機 株式会社');
ok($zip->set_number('4448601')->is_valid_number, '岡崎市役所');
ok($zip->set_number('4448602')->is_valid_number, '岡崎信用金庫');
ok($zip->set_number('4448606')->is_valid_number, '中部電力 株式会社 岡崎支店');
ok($zip->set_number('4448610')->is_valid_number, '大久保商事 株式会社');
ok($zip->set_number('4448611')->is_valid_number, '岡崎商工会議所');
ok($zip->set_number('4448612')->is_valid_number, '愛知県信用保証協会 西三河支所');
ok($zip->set_number('4448686')->is_valid_number, 'IPC国際ペットカルチャー総合学院');
ok($zip->set_number('4448710')->is_valid_number, '西武百貨店 岡崎店');
ok($zip->set_number('4448787')->is_valid_number, '大学共同利用機関法人 自然科学研究機構 岡崎山手地区');
ok($zip->set_number('4458501')->is_valid_number, '西尾市役所');
ok($zip->set_number('4458502')->is_valid_number, '株式会社 デンソー 西尾製作所');
ok($zip->set_number('4458503')->is_valid_number, '西尾ニュータウン開発 株式会社');
ok($zip->set_number('4458505')->is_valid_number, '西尾商工会議所');
ok($zip->set_number('4458510')->is_valid_number, '西尾市民病院');
ok($zip->set_number('4458511')->is_valid_number, '名古屋法務局 西尾支局');
ok($zip->set_number('4458585')->is_valid_number, 'おしろタウン シャオ');
ok($zip->set_number('4458601')->is_valid_number, '西尾信用金庫');
ok($zip->set_number('4458602')->is_valid_number, '西尾税務署');
ok($zip->set_number('4468501')->is_valid_number, '安城市役所');
ok($zip->set_number('4468502')->is_valid_number, '株式会社 マキタ');
ok($zip->set_number('4468503')->is_valid_number, 'アンデン 株式会社');
ok($zip->set_number('4468504')->is_valid_number, '株式会社 イノアックコーポレーション 安城事業所');
ok($zip->set_number('4468505')->is_valid_number, '三浦電気 株式会社');
ok($zip->set_number('4468506')->is_valid_number, '愛知県経済農業協同組合連合会 西三河センター');
ok($zip->set_number('4468507')->is_valid_number, '株式会社 デンソー 高棚製作所');
ok($zip->set_number('4468508')->is_valid_number, '愛知県西三河県税事務所 安城県税センター');
ok($zip->set_number('4468511')->is_valid_number, '株式会社 デンソー 安城製作所');
ok($zip->set_number('4468512')->is_valid_number, '安城商工会議所');
ok($zip->set_number('4468514')->is_valid_number, 'タツミ商事 株式会社 豊田支店');
ok($zip->set_number('4468517')->is_valid_number, '衣浦東部保健所 安城支所');
ok($zip->set_number('4468518')->is_valid_number, '株式会社 クオリ');
ok($zip->set_number('4468520')->is_valid_number, '株式会社 ムロコーポレーション');
ok($zip->set_number('4468522')->is_valid_number, '万能工業 株式会社');
ok($zip->set_number('4468523')->is_valid_number, '三河日産自動車 株式会社');
ok($zip->set_number('4468524')->is_valid_number, 'アイシン精機 株式会社 安城工場');
ok($zip->set_number('4468525')->is_valid_number, '森永製菓 株式会社 中京工場');
ok($zip->set_number('4468526')->is_valid_number, '安城簡易裁判所');
ok($zip->set_number('4468533')->is_valid_number, '株式会社 ユーハイム');
ok($zip->set_number('4468535')->is_valid_number, '株式会社 SKコーポレーション');
ok($zip->set_number('4468540')->is_valid_number, 'カリツー 株式会社');
ok($zip->set_number('4468555')->is_valid_number, '山崎製パン 株式会社 安城工場');
ok($zip->set_number('4468558')->is_valid_number, '豊臣機工 株式会社');
ok($zip->set_number('4468585')->is_valid_number, '碧海信用金庫事務センター');
ok($zip->set_number('4468588')->is_valid_number, '大見工業 株式会社');
ok($zip->set_number('4468601')->is_valid_number, 'あいち中央農業 協同組合');
ok($zip->set_number('4468602')->is_valid_number, '愛知県 更正農業協同組合連合会 更正病院');
ok($zip->set_number('4468635')->is_valid_number, '安城学園高等学校');
ok($zip->set_number('4468641')->is_valid_number, '倉敷紡績 株式会社 安城工場');
ok($zip->set_number('4468686')->is_valid_number, '碧海信用金庫');
ok($zip->set_number('4478501')->is_valid_number, '碧南商工会議所');
ok($zip->set_number('4478502')->is_valid_number, '碧南市民病院');
ok($zip->set_number('4478503')->is_valid_number, '中庸スプリング 株式会社');
ok($zip->set_number('4478505')->is_valid_number, '旭鉄工 株式会社');
ok($zip->set_number('4478506')->is_valid_number, '伊藤忠製糖 株式会社');
ok($zip->set_number('4478507')->is_valid_number, '株式会社 豊田自動織機製作所 碧南工場');
ok($zip->set_number('4478510')->is_valid_number, '医療法人 愛生館 小林記念病院');
ok($zip->set_number('4478511')->is_valid_number, '株式会社 五十鈴製作所');
ok($zip->set_number('4478512')->is_valid_number, '丸栄陶業 株式会社');
ok($zip->set_number('4478601')->is_valid_number, '碧南市役所');
ok($zip->set_number('4478603')->is_valid_number, '九重味淋 株式会社');
ok($zip->set_number('4478605')->is_valid_number, '愛知県中央信用組合');
ok($zip->set_number('4478608')->is_valid_number, '日本コーンスターチ 株式会社 衣浦事業所');
ok($zip->set_number('4478610')->is_valid_number, '日本金属工業 株式会社 衣浦製造所');
ok($zip->set_number('4478680')->is_valid_number, '株式会社 平岩鉄工所');
ok($zip->set_number('4488501')->is_valid_number, '刈谷市役所');
ok($zip->set_number('4488506')->is_valid_number, '豊田通商 株式会社 刈谷支店');
ok($zip->set_number('4488523')->is_valid_number, '刈谷税務署');
ok($zip->set_number('4488531')->is_valid_number, '株式会社 東陽');
ok($zip->set_number('4488550')->is_valid_number, '株式会社 豊電子工業 第3工場');
ok($zip->set_number('4488601')->is_valid_number, 'アイリスオーヤマ 株式会社 名古屋営業所');
ok($zip->set_number('4488602')->is_valid_number, '株式会社 ブックセンター名豊');
ok($zip->set_number('4488605')->is_valid_number, 'アイシン・エンジニアリング 株式会社');
ok($zip->set_number('4488609')->is_valid_number, '刈谷公共職業安定所');
ok($zip->set_number('4488610')->is_valid_number, '大興運輸 株式会社 刈谷支店');
ok($zip->set_number('4488650')->is_valid_number, 'アイシン精機 株式会社');
ok($zip->set_number('4488651')->is_valid_number, 'トヨタ紡織 株式会社');
ok($zip->set_number('4488652')->is_valid_number, '株式会社 ジェイテクト');
ok($zip->set_number('4488653')->is_valid_number, '愛知県立 刈谷東高等学校');
ok($zip->set_number('4488655')->is_valid_number, '太田商事 株式会社');
ok($zip->set_number('4488656')->is_valid_number, '小林クリエイト 株式会社');
ok($zip->set_number('4488657')->is_valid_number, '津田工業 株式会社');
ok($zip->set_number('4488660')->is_valid_number, '中部電力 株式会社 刈谷営業所');
ok($zip->set_number('4488661')->is_valid_number, '株式会社 デンソー本社');
ok($zip->set_number('4488665')->is_valid_number, '東芝セラミックス 株式会社 刈谷製造所');
ok($zip->set_number('4488666')->is_valid_number, 'トヨタ車体 株式会社');
ok($zip->set_number('4488670')->is_valid_number, '大興運輸 株式会社 本社');
ok($zip->set_number('4488671')->is_valid_number, '株式会社 豊田自動織機');
ok($zip->set_number('4488677')->is_valid_number, '衣浦東部広域連合');
ok($zip->set_number('4488686')->is_valid_number, '株式会社 豊田自動織機 情報技術研究所');
ok($zip->set_number('4488688')->is_valid_number, '株式会社 アドヴィックス');
ok($zip->set_number('4488731')->is_valid_number, '株式会社 東陽');
ok($zip->set_number('4490292')->is_valid_number, '東栄町役場');
ok($zip->set_number('4490293')->is_valid_number, '東栄病院');
ok($zip->set_number('4490294')->is_valid_number, '愛知県立 新城東高等学校 本郷校舎');
ok($zip->set_number('4506133')->is_valid_number, 'ジェイアールセントラルビル 株式会社');
ok($zip->set_number('4508501')->is_valid_number, '名古屋鉄道 株式会社');
ok($zip->set_number('4508502')->is_valid_number, '株式会社 松坂屋 名古屋駅店');
ok($zip->set_number('4508505')->is_valid_number, '株式会社 名鉄百貨店');
ok($zip->set_number('4508510')->is_valid_number, '近畿日本ツーリスト 株式会社 中部営業本部');
ok($zip->set_number('4508515')->is_valid_number, '株式会社 ジェイテクト 名古屋本社');
ok($zip->set_number('4508520')->is_valid_number, '三協化成産業 株式会社');
ok($zip->set_number('4508521')->is_valid_number, '稲畑産業 株式会社 名古屋支店');
ok($zip->set_number('4508522')->is_valid_number, '三菱電機 株式会社 中部支社');
ok($zip->set_number('4508523')->is_valid_number, '森定興商 株式会社');
ok($zip->set_number('4508530')->is_valid_number, '監査法人 トーマツ');
ok($zip->set_number('4508532')->is_valid_number, '三菱化学 株式会社 中部支社');
ok($zip->set_number('4508533')->is_valid_number, '株式会社 阪急交通社 名古屋支店');
ok($zip->set_number('4508538')->is_valid_number, '富士フイルムロジスティック 株式会社');
ok($zip->set_number('4508540')->is_valid_number, '明和産業 株式会社 名古屋支店');
ok($zip->set_number('4508561')->is_valid_number, '株式会社 中部経済新聞社');
ok($zip->set_number('4508567')->is_valid_number, '三機工業 株式会社 名古屋支店');
ok($zip->set_number('4508575')->is_valid_number, '豊田通商 株式会社');
ok($zip->set_number('4508577')->is_valid_number, '名鉄観光サービス 株式会社');
ok($zip->set_number('4508580')->is_valid_number, '株式会社 アルペン');
ok($zip->set_number('4508583')->is_valid_number, '愛知社会保険事務局');
ok($zip->set_number('4508585')->is_valid_number, '小淺商事 株式会社');
ok($zip->set_number('4508601')->is_valid_number, '日鉄商事 株式会社 名古屋支店');
ok($zip->set_number('4508611')->is_valid_number, '松下電工 株式会社 中部管理センター');
ok($zip->set_number('4508614')->is_valid_number, '東陽倉庫 株式会社');
ok($zip->set_number('4508618')->is_valid_number, '名鉄協商 株式会社');
ok($zip->set_number('4508620')->is_valid_number, '藤田螺子工業 株式会社');
ok($zip->set_number('4508626')->is_valid_number, '名古屋市 ささしま市税事務所');
ok($zip->set_number('4508640')->is_valid_number, 'ダイコク電機 株式会社');
ok($zip->set_number('4508650')->is_valid_number, '三菱UFJ信託銀行 株式会社 名古屋中央支店 名古屋駅前出張所');
ok($zip->set_number('4508651')->is_valid_number, '株式会社 毎日新聞社 中部本社');
ok($zip->set_number('4508677')->is_valid_number, '三井物産 株式会社 中部支社');
ok($zip->set_number('4508680')->is_valid_number, '三菱商事 株式会社 中部支社');
ok($zip->set_number('4508711')->is_valid_number, 'トヨタ自動車 株式会社 名古屋オフィス');
ok($zip->set_number('4508730')->is_valid_number, '日通商事 株式会社 名古屋支店');
ok($zip->set_number('4508765')->is_valid_number, '株式会社 クレディセゾン 東海支店');
ok($zip->set_number('4518501')->is_valid_number, '株式会社 ノリタケカンパニーリミテド');
ok($zip->set_number('4518502')->is_valid_number, '(株) 東芝 中部支社');
ok($zip->set_number('4518503')->is_valid_number, '名古屋西税務署');
ok($zip->set_number('4518508')->is_valid_number, '名古屋市西区役所');
ok($zip->set_number('4518511')->is_valid_number, '名鉄病院');
ok($zip->set_number('4518520')->is_valid_number, '名糖産業');
ok($zip->set_number('4518521')->is_valid_number, 'エステー化学 株式会社 名古屋支店');
ok($zip->set_number('4518525')->is_valid_number, 'YKKファスニングプロダクツ販売 株式会社');
ok($zip->set_number('4518541')->is_valid_number, 'ヒューマンライフ 株式会社');
ok($zip->set_number('4518550')->is_valid_number, '株式会社 ヤマダヤ');
ok($zip->set_number('4518551')->is_valid_number, '株式会社 ナゴヤキャッスル');
ok($zip->set_number('4518555')->is_valid_number, '愛知県 名古屋北部県税事務所');
ok($zip->set_number('4518560')->is_valid_number, 'クロスプラス 株式会社');
ok($zip->set_number('4518561')->is_valid_number, '愛知県立名古屋西高等学校');
ok($zip->set_number('4518565')->is_valid_number, '山崎製パン 株式会社 名古屋工場');
ok($zip->set_number('4518568')->is_valid_number, '株式会社 フジキカイ');
ok($zip->set_number('4518570')->is_valid_number, '株式会社 カノークス');
ok($zip->set_number('4518571')->is_valid_number, '丸川製菓 株式会社');
ok($zip->set_number('4518575')->is_valid_number, '株式会社 サンゲツ');
ok($zip->set_number('4518577')->is_valid_number, '株式会社 ミヤタコーポレーション');
ok($zip->set_number('4518585')->is_valid_number, '三洋電機クレジット 株式会社');
ok($zip->set_number('4518650')->is_valid_number, 'ニッセイ同和損害保険 株式会社');
ok($zip->set_number('4518688')->is_valid_number, 'タキヒヨー 株式会社');
ok($zip->set_number('4518701')->is_valid_number, '瀧冨工業 株式会社');
ok($zip->set_number('4528501')->is_valid_number, 'サカエ理研工業 株式会社');
ok($zip->set_number('4528502')->is_valid_number, '株式会社 フジミインコーポレーテッド');
ok($zip->set_number('4528503')->is_valid_number, '清須市役所 西枇杷島庁舎');
ok($zip->set_number('4528521')->is_valid_number, '名古屋松下電工 株式会社');
ok($zip->set_number('4528544')->is_valid_number, 'イオン 株式会社 ジャスコワンダーシティ店');
ok($zip->set_number('4528561')->is_valid_number, '三菱重工業 株式会社 冷熱事業本部');
ok($zip->set_number('4528562')->is_valid_number, '麒麟麦酒 株式会社 名古屋工場');
ok($zip->set_number('4528563')->is_valid_number, '清須市役所 清洲庁舎');
ok($zip->set_number('4528564')->is_valid_number, '豊田合成 株式会社');
ok($zip->set_number('4528565')->is_valid_number, '春日支所');
ok($zip->set_number('4528566')->is_valid_number, 'トッパンフォームズ東海 (株)');
ok($zip->set_number('4528567')->is_valid_number, '学校法人 トヨタ名古屋整備学園');
ok($zip->set_number('4528569')->is_valid_number, '清須市役所');
ok($zip->set_number('4528570')->is_valid_number, '御幸ホールディングス 株式会社');
ok($zip->set_number('4528601')->is_valid_number, '豊和工業 株式会社');
ok($zip->set_number('4528602')->is_valid_number, '株式会社 明電舎');
ok($zip->set_number('4528603')->is_valid_number, '東海機器工業 (株)');
ok($zip->set_number('4528604')->is_valid_number, '(株) 高岳製作所 名古屋事業所');
ok($zip->set_number('4538501')->is_valid_number, '中村区役所');
ok($zip->set_number('4538505')->is_valid_number, '中村県税事務所');
ok($zip->set_number('4538510')->is_valid_number, 'エスエス製薬 株式会社 名古屋支店');
ok($zip->set_number('4538511')->is_valid_number, '名古屋第一赤十字病院');
ok($zip->set_number('4538512')->is_valid_number, '株式会社 ジュニアー');
ok($zip->set_number('4538518')->is_valid_number, '愛鉄連厚生年金基金');
ok($zip->set_number('4538521')->is_valid_number, '財団法人 名古屋公衆医学研究所');
ok($zip->set_number('4538522')->is_valid_number, '山田工業 株式会社');
ok($zip->set_number('4538530')->is_valid_number, 'イオ 信用組合');
ok($zip->set_number('4538533')->is_valid_number, '株式会社 萬勇');
ok($zip->set_number('4538539')->is_valid_number, '株式会社 レアールパスコベーカリーズ');
ok($zip->set_number('4538540')->is_valid_number, '学校法人 同朋学園');
ok($zip->set_number('4538555')->is_valid_number, '株式会社 奥村組 名古屋支店');
ok($zip->set_number('4538565')->is_valid_number, '学校法人 東京IT会計法律名古屋学園');
ok($zip->set_number('4538577')->is_valid_number, '株式会社 大同商会');
ok($zip->set_number('4538580')->is_valid_number, '明治電機工業 株式会社');
ok($zip->set_number('4538581')->is_valid_number, '株式会社 アイコー');
ok($zip->set_number('4538581')->is_valid_number, '株式会社 EXCITE');
ok($zip->set_number('4538581')->is_valid_number, '株式会社 シンセイ');
ok($zip->set_number('4538581')->is_valid_number, '株式会社 ニューギン・アドバンス');
ok($zip->set_number('4538581')->is_valid_number, '株式会社 ニューギン販売');
ok($zip->set_number('4538581')->is_valid_number, '(株) ニューギン');
ok($zip->set_number('4538585')->is_valid_number, '株式会社 ユーハイム 東海支社');
ok($zip->set_number('4538601')->is_valid_number, '中部電力 株式会社 中村営業所');
ok($zip->set_number('4538611')->is_valid_number, '河田フェザー 株式会社');
ok($zip->set_number('4538662')->is_valid_number, '東海デキストリン 株式会社');
ok($zip->set_number('4538686')->is_valid_number, '名古屋中村税務署');
ok($zip->set_number('4538765')->is_valid_number, '株式会社 ミスターゴルフ');
ok($zip->set_number('4548501')->is_valid_number, '中川区役所');
ok($zip->set_number('4548502')->is_valid_number, '名古屋掖済会病院');
ok($zip->set_number('4548503')->is_valid_number, '愛知県 名古屋西部県税事務所');
ok($zip->set_number('4548504')->is_valid_number, '(株) 鈴木商会');
ok($zip->set_number('4548505')->is_valid_number, '株式会社 ナスコム');
ok($zip->set_number('4548506')->is_valid_number, '中部鋼鈑 株式会社');
ok($zip->set_number('4548508')->is_valid_number, '上地木材');
ok($zip->set_number('4548509')->is_valid_number, '藤田保健衛生大学 坂文種報徳會病院');
ok($zip->set_number('4548511')->is_valid_number, '中川税務署');
ok($zip->set_number('4548512')->is_valid_number, '株式会社 太田廣');
ok($zip->set_number('4548514')->is_valid_number, '株式会社 ミツウロコ中部事業部');
ok($zip->set_number('4548515')->is_valid_number, '名鉄交通 株式会社');
ok($zip->set_number('4548516')->is_valid_number, '大東建託 株式会社 名古屋事務所');
ok($zip->set_number('4548517')->is_valid_number, '瀧上工業 株式会社');
ok($zip->set_number('4548518')->is_valid_number, '中日本氷糖 株式会社');
ok($zip->set_number('4548519')->is_valid_number, 'シャープファイナンス 株式会社 中部統轄支店');
ok($zip->set_number('4548520')->is_valid_number, '日清製粉 株式会社 名古屋工場');
ok($zip->set_number('4548521')->is_valid_number, '宮崎精鋼 株式会社');
ok($zip->set_number('4548522')->is_valid_number, '愛知県 中川警察署');
ok($zip->set_number('4548524')->is_valid_number, 'シンコール 株式会社');
ok($zip->set_number('4548525')->is_valid_number, '医療法人 偕行会 名古屋共立病院');
ok($zip->set_number('4548526')->is_valid_number, '金印 株式会社');
ok($zip->set_number('4548527')->is_valid_number, 'ワタナベフーマック 株式会社');
ok($zip->set_number('4548529')->is_valid_number, 'シャープエレクトロニクスマーケティング 株式会社');
ok($zip->set_number('4548530')->is_valid_number, '三ツ矢製菓 株式会社');
ok($zip->set_number('4548533')->is_valid_number, '西山商事 株式会社');
ok($zip->set_number('4548550')->is_valid_number, '株式会社 アズパーク');
ok($zip->set_number('4548555')->is_valid_number, '株式会社 名鉄交通商事 名鉄タクシーチケットセンター');
ok($zip->set_number('4548558')->is_valid_number, '中部運輸局 愛知運輸支局');
ok($zip->set_number('4548560')->is_valid_number, '(株) あかのれん 千音寺店');
ok($zip->set_number('4548565')->is_valid_number, '伊藤ハム 株式会社 名古屋事務所');
ok($zip->set_number('4548651')->is_valid_number, 'リンナイ 株式会社');
ok($zip->set_number('4558501')->is_valid_number, '株式会社 エイデン');
ok($zip->set_number('4558505')->is_valid_number, '株式会社 ダイセキ');
ok($zip->set_number('4558515')->is_valid_number, '三菱重工業 株式会社 名古屋航空宇宙システム製作所');
ok($zip->set_number('4558521')->is_valid_number, 'NTT マーケティングアクト名古屋 株式会社 中央南営業所');
ok($zip->set_number('4558530')->is_valid_number, '独立行政法人 労働者健康福祉機構 中部労災病院');
ok($zip->set_number('4558545')->is_valid_number, '国土交通省 中部地方整備局');
ok($zip->set_number('4558555')->is_valid_number, '三菱航空機 株式会社');
ok($zip->set_number('4558585')->is_valid_number, '吉田産業 株式会社');
ok($zip->set_number('4558601')->is_valid_number, '法務省 名古屋入国管理局');
ok($zip->set_number('4558620')->is_valid_number, 'ジャスコ 株式会社 南陽店');
ok($zip->set_number('4558626')->is_valid_number, '名古屋市 ささしま市税事務所 東海通出張所');
ok($zip->set_number('4558630')->is_valid_number, 'ヤマト運輸 株式会社 中部支社');
ok($zip->set_number('4558639')->is_valid_number, '(株) 服部家具センター');
ok($zip->set_number('4558648')->is_valid_number, '愛日木研 株式会社');
ok($zip->set_number('4558668')->is_valid_number, '共立マテリアル 株式会社');
ok($zip->set_number('4558671')->is_valid_number, '株式会社 正直屋');
ok($zip->set_number('4568501')->is_valid_number, '名古屋市熱田区役所');
ok($zip->set_number('4568502')->is_valid_number, '郵送請求に係る証明書交付センター');
ok($zip->set_number('4568511')->is_valid_number, '東邦ガス 株式会社');
ok($zip->set_number('4568516')->is_valid_number, '株式会社 中部プラントサービス');
ok($zip->set_number('4568523')->is_valid_number, '愛知日産自動車 株式会社');
ok($zip->set_number('4568530')->is_valid_number, '愛知県労働者共済生活 協同組合');
ok($zip->set_number('4568555')->is_valid_number, '名古屋トヨペット 株式会社');
ok($zip->set_number('4568556')->is_valid_number, 'NTPホールディングス 株式会社');
ok($zip->set_number('4568560')->is_valid_number, '株式会社 名給');
ok($zip->set_number('4568567')->is_valid_number, '熱田社会保険事務所');
ok($zip->set_number('4568580')->is_valid_number, '株式会社 名鉄パレ管財');
ok($zip->set_number('4568585')->is_valid_number, '熱田神宮宮庁');
ok($zip->set_number('4568587')->is_valid_number, '財団法人 ファインセラミックスセンター');
ok($zip->set_number('4568588')->is_valid_number, '株式会社 山善 名古屋営業本部');
ok($zip->set_number('4568601')->is_valid_number, '愛知機械工業 株式会社');
ok($zip->set_number('4568602')->is_valid_number, '株式会社 昭和');
ok($zip->set_number('4568610')->is_valid_number, '伊藤忠食品 株式会社 東海営業本部');
ok($zip->set_number('4568611')->is_valid_number, 'みなと医療生活 協同組合 協立総合病院');
ok($zip->set_number('4568612')->is_valid_number, '学校法人 名古屋学院大学');
ok($zip->set_number('4568620')->is_valid_number, '中部森林管理局 名古屋事務所');
ok($zip->set_number('4568666')->is_valid_number, 'アイホン 株式会社');
ok($zip->set_number('4568668')->is_valid_number, 'ネッツトヨタ中京 株式会社');
ok($zip->set_number('4568686')->is_valid_number, '株式会社 イノアックリビング');
ok($zip->set_number('4568688')->is_valid_number, '名古屋青果 株式会社');
ok($zip->set_number('4568711')->is_valid_number, '熱田税務署');
ok($zip->set_number('4568739')->is_valid_number, '商工組合中央金庫 熱田支店');
ok($zip->set_number('4568763')->is_valid_number, 'イオン熱田ショッピングセンター');
ok($zip->set_number('4578501')->is_valid_number, 'ネッツトヨタ東海 株式会社');
ok($zip->set_number('4578505')->is_valid_number, '日清紡績 株式会社 名古屋工場');
ok($zip->set_number('4578508')->is_valid_number, '名古屋市南区役所');
ok($zip->set_number('4578510')->is_valid_number, '社会保険中京病院');
ok($zip->set_number('4578511')->is_valid_number, '大同病院');
ok($zip->set_number('4578512')->is_valid_number, '社会福祉法人 大同福祉会');
ok($zip->set_number('4578515')->is_valid_number, '愛精病院');
ok($zip->set_number('4578520')->is_valid_number, '株式会社 バッファローハイテクセンター');
ok($zip->set_number('4578522')->is_valid_number, '三井化学 株式会社 名古屋工場');
ok($zip->set_number('4578530')->is_valid_number, '大同工業大学 滝春校舎');
ok($zip->set_number('4578531')->is_valid_number, '大同工業大学 大同校舎');
ok($zip->set_number('4578532')->is_valid_number, '大同工業大学 白水校舎');
ok($zip->set_number('4578533')->is_valid_number, '株式会社 丸政');
ok($zip->set_number('4578535')->is_valid_number, '近藤産興 株式会社');
ok($zip->set_number('4578545')->is_valid_number, '大同特殊鋼 株式会社 星崎工場');
ok($zip->set_number('4578551')->is_valid_number, '株式会社 ミック');
ok($zip->set_number('4578555')->is_valid_number, 'カネハツ食品 株式会社');
ok($zip->set_number('4578558')->is_valid_number, '三菱ふそうトラック・バス 株式会社 東海ふそう');
ok($zip->set_number('4578560')->is_valid_number, '株式会社 テイラド');
ok($zip->set_number('4578566')->is_valid_number, '株式会社 チップトン');
ok($zip->set_number('4578567')->is_valid_number, '株式会社 あかのれん 内田橋店');
ok($zip->set_number('4578570')->is_valid_number, '株式会社 バッファローテクニカルサービスセンター');
ok($zip->set_number('4578577')->is_valid_number, '株式会社 大同機械製作所');
ok($zip->set_number('4578585')->is_valid_number, '株式会社 ナカガワ');
ok($zip->set_number('4578711')->is_valid_number, '株式会社 中部シントー');
ok($zip->set_number('4588501')->is_valid_number, '株式会社 東亜製作所');
ok($zip->set_number('4588502')->is_valid_number, '日本車輌製造 株式会社 鳴海製作所');
ok($zip->set_number('4588505')->is_valid_number, '中央発條 株式会社');
ok($zip->set_number('4588508')->is_valid_number, 'ソルダーコート 株式会社');
ok($zip->set_number('4588510')->is_valid_number, '佐久間特殊鋼 株式会社');
ok($zip->set_number('4588511')->is_valid_number, 'トヨタオート愛知 株式会社');
ok($zip->set_number('4588515')->is_valid_number, '中部電力 株式会社 緑電力センター');
ok($zip->set_number('4588520')->is_valid_number, '中部日産ディーゼル 株式会社');
ok($zip->set_number('4588521')->is_valid_number, '株式会社 光金属工業所');
ok($zip->set_number('4588522')->is_valid_number, '高砂電気工業 株式会社');
ok($zip->set_number('4588525')->is_valid_number, '株式会社 中日電子');
ok($zip->set_number('4588530')->is_valid_number, '鳴海製陶 株式会社');
ok($zip->set_number('4588555')->is_valid_number, 'ユニー 株式会社 アピタ鳴海店');
ok($zip->set_number('4588570')->is_valid_number, 'ヒルズウォーク 徳重ガーデンズ');
ok($zip->set_number('4588571')->is_valid_number, 'ピアゴ ラフーズ コア 徳重店');
ok($zip->set_number('4588580')->is_valid_number, '名鉄自動車整備 株式会社');
ok($zip->set_number('4588581')->is_valid_number, '名城食品 株式会社');
ok($zip->set_number('4588585')->is_valid_number, '名古屋市緑区役所');
ok($zip->set_number('4598511')->is_valid_number, 'ゴムノイナキ 株式会社 大高本社');
ok($zip->set_number('4598522')->is_valid_number, '中部電力 株式会社 技術開発本部研究企画部');
ok($zip->set_number('4598540')->is_valid_number, '総合病院 南生協病院');
ok($zip->set_number('4608201')->is_valid_number, '個人市民税特別徴収センター');
ok($zip->set_number('4608202')->is_valid_number, '名古屋市 市税収納事務センター');
ok($zip->set_number('4608203')->is_valid_number, '日刊スポーツ新聞 名古屋本社');
ok($zip->set_number('4608204')->is_valid_number, '社団法人 日本電気協会 中部支部');
ok($zip->set_number('4608302')->is_valid_number, 'エヌエスディ 株式会社');
ok($zip->set_number('4608310')->is_valid_number, '中部電力 株式会社 中電千代田ビル(名古屋支店・中営業所・中電力センター)');
ok($zip->set_number('4608311')->is_valid_number, '名古屋テレビ放送 株式会社');
ok($zip->set_number('4608312')->is_valid_number, 'セルバンク クリニック');
ok($zip->set_number('4608314')->is_valid_number, 'リンタツ 株式会社');
ok($zip->set_number('4608315')->is_valid_number, '株式会社 バッファロー');
ok($zip->set_number('4608318')->is_valid_number, '株式会社 八神製作所');
ok($zip->set_number('4608319')->is_valid_number, 'NTT 東海支社');
ok($zip->set_number('4608320')->is_valid_number, 'テルウェル西日本 株式会社 東海支店');
ok($zip->set_number('4608321')->is_valid_number, 'ミサワホーム東海 株式会社');
ok($zip->set_number('4608325')->is_valid_number, 'テレビ愛知 株式会社');
ok($zip->set_number('4608330')->is_valid_number, '株式会社 槌屋');
ok($zip->set_number('4608331')->is_valid_number, '株式会社 カテックス');
ok($zip->set_number('4608333')->is_valid_number, 'ゴムノイナキ 株式会社');
ok($zip->set_number('4608338')->is_valid_number, '株式会社 ナデックス');
ok($zip->set_number('4608350')->is_valid_number, '株式会社 セディナ');
ok($zip->set_number('4608351')->is_valid_number, '株式会社 毎日新聞社 中部本社');
ok($zip->set_number('4608351')->is_valid_number, '株式会社 毎日新聞社 中部本社 名古屋本部');
ok($zip->set_number('4608358')->is_valid_number, '寿がきや食品 株式会社');
ok($zip->set_number('4608360')->is_valid_number, '株式会社 愛知冠婚葬祭互助会');
ok($zip->set_number('4608366')->is_valid_number, '日本経済新聞社 名古屋支社');
ok($zip->set_number('4608380')->is_valid_number, '悠閑堂 株式会社');
ok($zip->set_number('4608383')->is_valid_number, '大有建設 株式会社');
ok($zip->set_number('4608388')->is_valid_number, '株式会社 エフエム愛知');
ok($zip->set_number('4608401')->is_valid_number, '富士ゼロックス愛知 株式会社 本社');
ok($zip->set_number('4608402')->is_valid_number, '株式会社 熊谷組 名古屋支店');
ok($zip->set_number('4608403')->is_valid_number, '株式会社 御園座');
ok($zip->set_number('4608405')->is_valid_number, 'CBC中部日本放送 株式会社');
ok($zip->set_number('4608406')->is_valid_number, '株式会社 松坂屋ホールディングス');
ok($zip->set_number('4608407')->is_valid_number, 'セントラルリース 株式会社');
ok($zip->set_number('4608408')->is_valid_number, '株式会社 トーエネック');
ok($zip->set_number('4608411')->is_valid_number, '木曽興業 株式会社');
ok($zip->set_number('4608412')->is_valid_number, '大日本土木 株式会社 名古屋支店');
ok($zip->set_number('4608415')->is_valid_number, '株式会社 ポッカコーポレーション');
ok($zip->set_number('4608416')->is_valid_number, '株式会社 松村組 名古屋支店');
ok($zip->set_number('4608417')->is_valid_number, '日石三菱 株式会社 中部支店');
ok($zip->set_number('4608420')->is_valid_number, '大成建設 株式会社 名古屋支店');
ok($zip->set_number('4608422')->is_valid_number, '名古屋商工会議所');
ok($zip->set_number('4608425')->is_valid_number, 'TIS 株式会社');
ok($zip->set_number('4608426')->is_valid_number, '株式会社 エイシアインターナショナル');
ok($zip->set_number('4608430')->is_valid_number, '株式会社 松坂屋 名古屋店(本店)');
ok($zip->set_number('4608431')->is_valid_number, '東海東京証券 株式会社');
ok($zip->set_number('4608432')->is_valid_number, '東海物産 株式会社');
ok($zip->set_number('4608433')->is_valid_number, '株式会社 新潟鐵工所 名古屋支店');
ok($zip->set_number('4608434')->is_valid_number, '中央電気工事 株式会社');
ok($zip->set_number('4608435')->is_valid_number, '株式会社 日立製作所 中部支社');
ok($zip->set_number('4608436')->is_valid_number, '株式会社 セントラルファイナンス 本店営業部');
ok($zip->set_number('4608439')->is_valid_number, '株式会社 アトム');
ok($zip->set_number('4608440')->is_valid_number, '株式会社 ベネッセコーポレーション 名古屋事業所');
ok($zip->set_number('4608441')->is_valid_number, '阪和興業 株式会社 名古屋支社');
ok($zip->set_number('4608444')->is_valid_number, 'アリコ ジャパン');
ok($zip->set_number('4608445')->is_valid_number, '株式会社 電通 中部支社');
ok($zip->set_number('4608447')->is_valid_number, '名古屋市中区役所');
ok($zip->set_number('4608448')->is_valid_number, '株式会社 旭通信社 名古屋支社');
ok($zip->set_number('4608450')->is_valid_number, 'あいおい損害保険 株式会社 名古屋栄ビル');
ok($zip->set_number('4608451')->is_valid_number, '兼松エレクトロニクス 株式会社 名古屋支店');
ok($zip->set_number('4608455')->is_valid_number, '新日本法規出版 株式会社');
ok($zip->set_number('4608456')->is_valid_number, '新日本法規出版 株式会社 名古屋支社');
ok($zip->set_number('4608460')->is_valid_number, '株式会社 鈴丹');
ok($zip->set_number('4608461')->is_valid_number, '株式会社 名古屋流行発信');
ok($zip->set_number('4608462')->is_valid_number, '中部テレメッセージ 株式会社 本店');
ok($zip->set_number('4608468')->is_valid_number, 'NTT東海移動通信網 株式会社');
ok($zip->set_number('4608470')->is_valid_number, '読売新聞 中部本社');
ok($zip->set_number('4608472')->is_valid_number, 'リッチ 株式会社 名古屋管理センター');
ok($zip->set_number('4608473')->is_valid_number, '新栄県税事務所');
ok($zip->set_number('4608475')->is_valid_number, '株式会社 名古屋リビング新聞社');
ok($zip->set_number('4608477')->is_valid_number, '株式会社 ワークスジャパン');
ok($zip->set_number('4608481')->is_valid_number, '愛知労働金庫');
ok($zip->set_number('4608482')->is_valid_number, 'ピープルスタッフ 株式会社');
ok($zip->set_number('4608483')->is_valid_number, '愛知県 名古屋東部県税事務所');
ok($zip->set_number('4608484')->is_valid_number, '独立行政法人 都市再生機構 中部支社');
ok($zip->set_number('4608485')->is_valid_number, '株式会社 日本メディカル総研 名古屋支社');
ok($zip->set_number('4608488')->is_valid_number, '朝日新聞 名古屋本社');
ok($zip->set_number('4608490')->is_valid_number, 'リゾートトラスト 株式会社 本社');
ok($zip->set_number('4608491')->is_valid_number, '大和ハウス工業 株式会社 名古屋支社');
ok($zip->set_number('4608501')->is_valid_number, '愛知県庁');
ok($zip->set_number('4608503')->is_valid_number, '名古屋高等裁判所');
ok($zip->set_number('4608504')->is_valid_number, '名古屋地方裁判所');
ok($zip->set_number('4608505')->is_valid_number, '名古屋簡易裁判所');
ok($zip->set_number('4608506')->is_valid_number, '日本電信電話 株式会社 名古屋支店');
ok($zip->set_number('4608507')->is_valid_number, '愛知労働基準局');
ok($zip->set_number('4608508')->is_valid_number, '名古屋市役所');
ok($zip->set_number('4608509')->is_valid_number, '名古屋地方裁判所 執行部 民事第2部');
ok($zip->set_number('4608510')->is_valid_number, '中部経済産業局');
ok($zip->set_number('4608511')->is_valid_number, '中日新聞');
ok($zip->set_number('4608512')->is_valid_number, '愛知県 尾張事務所');
ok($zip->set_number('4608513')->is_valid_number, '名古屋法務局');
ok($zip->set_number('4608514')->is_valid_number, '国土交通省 中部地方設備局');
ok($zip->set_number('4608515')->is_valid_number, '中北薬品 株式会社 本社事務所');
ok($zip->set_number('4608516')->is_valid_number, '東海農政局');
ok($zip->set_number('4608518')->is_valid_number, 'ぴあ 株式会社 名古屋支局');
ok($zip->set_number('4608520')->is_valid_number, '名古屋国税局');
ok($zip->set_number('4608521')->is_valid_number, '東海財務局');
ok($zip->set_number('4608522')->is_valid_number, '名古屋中税務署');
ok($zip->set_number('4608523')->is_valid_number, '名古屋地方検察庁');
ok($zip->set_number('4608524')->is_valid_number, '名古屋保護観察所');
ok($zip->set_number('4608525')->is_valid_number, 'NEC 中部支社');
ok($zip->set_number('4608528')->is_valid_number, '中部運輸局');
ok($zip->set_number('4608530')->is_valid_number, '社団法人 名古屋タイムズ社');
ok($zip->set_number('4608531')->is_valid_number, 'マスダ 株式会社');
ok($zip->set_number('4608532')->is_valid_number, 'キャノンマーケティングジャパン 株式会社 名古屋支店');
ok($zip->set_number('4608533')->is_valid_number, '株式会社 中薬');
ok($zip->set_number('4608534')->is_valid_number, '愛知県教育委員会');
ok($zip->set_number('4608535')->is_valid_number, '株式会社 ロイヤル');
ok($zip->set_number('4608538')->is_valid_number, '株式会社 ダイテック');
ok($zip->set_number('4608540')->is_valid_number, '株式会社 市文');
ok($zip->set_number('4608541')->is_valid_number, '東京海上日動火災保険 株式会社');
ok($zip->set_number('4608543')->is_valid_number, '三木産業 株式会社 名古屋支店');
ok($zip->set_number('4608545')->is_valid_number, '株式会社 中部しんきんカード');
ok($zip->set_number('4608550')->is_valid_number, '株式会社 藤栄');
ok($zip->set_number('4608551')->is_valid_number, '株式会社 損害保険ジャパン 中部本部');
ok($zip->set_number('4608555')->is_valid_number, '旭屋 株式会社');
ok($zip->set_number('4608558')->is_valid_number, '伊勢久 株式会社');
ok($zip->set_number('4608559')->is_valid_number, '財団法人 日本無線協会 東海支部');
ok($zip->set_number('4608560')->is_valid_number, '長瀬産業 株式会社 名古屋支店');
ok($zip->set_number('4608566')->is_valid_number, '愛知県 住宅供給公社');
ok($zip->set_number('4608567')->is_valid_number, '日本メナード化粧品 株式会社');
ok($zip->set_number('4608568')->is_valid_number, '株式会社 角川マーケティング 東海オフィス');
ok($zip->set_number('4608570')->is_valid_number, '株式会社 小林大薬房');
ok($zip->set_number('4608574')->is_valid_number, '八神商事 株式会社 本社');
ok($zip->set_number('4608575')->is_valid_number, '社団法人 中部建設協会');
ok($zip->set_number('4608577')->is_valid_number, '株式会社 加名市');
ok($zip->set_number('4608578')->is_valid_number, '株式会社 エフエム名古屋');
ok($zip->set_number('4608580')->is_valid_number, '清水建設 株式会社 名古屋支店');
ok($zip->set_number('4608585')->is_valid_number, '富士通 株式会社 東海支社');
ok($zip->set_number('4608586')->is_valid_number, '株式会社 オリエントコーポレーション 名古屋支店');
ok($zip->set_number('4608587')->is_valid_number, '株式会社 丸愛商会');
ok($zip->set_number('4608588')->is_valid_number, 'ヤマハ 株式会社 名古屋支店');
ok($zip->set_number('4608601')->is_valid_number, '鳴河 株式会社');
ok($zip->set_number('4608602')->is_valid_number, '八木兵 株式会社');
ok($zip->set_number('4608603')->is_valid_number, '株式会社 日本コンタクトレンズ');
ok($zip->set_number('4608606')->is_valid_number, '株式会社 シーエフプランニング');
ok($zip->set_number('4608608')->is_valid_number, '株式会社 名古屋観光ホテル');
ok($zip->set_number('4608609')->is_valid_number, '富士ゼロックス 株式会社 中部統括部');
ok($zip->set_number('4608610')->is_valid_number, 'ニチハ 株式会社');
ok($zip->set_number('4608611')->is_valid_number, '国際ロータリー旅行 株式会社 名古屋支店');
ok($zip->set_number('4608613')->is_valid_number, '株式会社 中京テレビ事業');
ok($zip->set_number('4608614')->is_valid_number, '五洋建設 株式会社 名古屋支店');
ok($zip->set_number('4608615')->is_valid_number, '徳倉建設 株式会社');
ok($zip->set_number('4608616')->is_valid_number, '万兵 株式会社');
ok($zip->set_number('4608617')->is_valid_number, '日本紙パルプ商事 株式会社 中部支社');
ok($zip->set_number('4608618')->is_valid_number, '石田 株式会社');
ok($zip->set_number('4608619')->is_valid_number, '安藤証券 株式会社');
ok($zip->set_number('4608620')->is_valid_number, '日本信販ニコスカードセンター');
ok($zip->set_number('4608621')->is_valid_number, '株式会社 東海総合研究所');
ok($zip->set_number('4608623')->is_valid_number, '県民共済愛知県 生活協同組合');
ok($zip->set_number('4608625')->is_valid_number, '興和 株式会社');
ok($zip->set_number('4608626')->is_valid_number, '名古屋市 金山市税事務所');
ok($zip->set_number('4608628')->is_valid_number, '丹羽幸 株式会社');
ok($zip->set_number('4608630')->is_valid_number, '天野エンザイム 株式会社 本社');
ok($zip->set_number('4608631')->is_valid_number, '国際電信電話 株式会社 名古屋支店(KDD)');
ok($zip->set_number('4608632')->is_valid_number, 'コスモ石油 株式会社 名古屋支店');
ok($zip->set_number('4608633')->is_valid_number, '株式会社 竹中工務店 名古屋支店');
ok($zip->set_number('4608635')->is_valid_number, '三井海上火災保険 株式会社');
ok($zip->set_number('4608636')->is_valid_number, '日本火災海上保険 株式会社 中部営業本部');
ok($zip->set_number('4608637')->is_valid_number, '株式会社 アルペン');
ok($zip->set_number('4608638')->is_valid_number, 'スターキャット・ケーブルネットワーク 株式会社');
ok($zip->set_number('4608650')->is_valid_number, '株式会社 川本製作所');
ok($zip->set_number('4608651')->is_valid_number, '遠山産業 株式会社');
ok($zip->set_number('4608653')->is_valid_number, '大和證券 株式会社 名古屋支店');
ok($zip->set_number('4608655')->is_valid_number, 'シヤチハタ商事 株式会社 名古屋支店');
ok($zip->set_number('4608656')->is_valid_number, '株式会社 日本長期信用銀行 名古屋支店');
ok($zip->set_number('4608657')->is_valid_number, '伊藤伊 株式会社');
ok($zip->set_number('4608660')->is_valid_number, '株式会社 東海銀行 本店');
ok($zip->set_number('4608663')->is_valid_number, 'タキヒヨー 株式会社');
ok($zip->set_number('4608665')->is_valid_number, '兼松 株式会社 名古屋支社');
ok($zip->set_number('4608666')->is_valid_number, '岡谷鋼機 株式会社');
ok($zip->set_number('4608667')->is_valid_number, '瀧定 株式会社');
ok($zip->set_number('4608668')->is_valid_number, '日商岩井 株式会社 名古屋支社');
ok($zip->set_number('4608669')->is_valid_number, '株式会社 名古屋三越 栄本店');
ok($zip->set_number('4608670')->is_valid_number, '株式会社 セディナ');
ok($zip->set_number('4608671')->is_valid_number, '豊島 株式会社 名古屋本社');
ok($zip->set_number('4608672')->is_valid_number, 'あいおい損害保険 株式会社');
ok($zip->set_number('4608674')->is_valid_number, '株式会社 丸栄');
ok($zip->set_number('4608678')->is_valid_number, '株式会社 愛知銀行 本店');
ok($zip->set_number('4608679')->is_valid_number, 'モリリン 株式会社 名古屋支店');
ok($zip->set_number('4608681')->is_valid_number, '株式会社 中京銀行');
ok($zip->set_number('4608682')->is_valid_number, '株式会社 春日井');
ok($zip->set_number('4608683')->is_valid_number, '出光興産 株式会社 名古屋支店');
ok($zip->set_number('4608684')->is_valid_number, '株式会社 さくら銀行 名古屋支店');
ok($zip->set_number('4608685')->is_valid_number, '中央三井信託銀行 株式会社 名古屋支店');
ok($zip->set_number('4608686')->is_valid_number, '株式会社 リオ横山');
ok($zip->set_number('4608687')->is_valid_number, '愛知県共済生活 協同組合');
ok($zip->set_number('4608688')->is_valid_number, '株式会社 富士銀行 名古屋支店');
ok($zip->set_number('4608689')->is_valid_number, '野村證券 株式会社 名古屋支店');
ok($zip->set_number('4608690')->is_valid_number, '中電コンピューターサービス 株式会社');
ok($zip->set_number('4608701')->is_valid_number, 'ニチメン 株式会社 名古屋支社');
ok($zip->set_number('4608702')->is_valid_number, '株式会社 東京三菱銀行 名古屋伏見営業部');
ok($zip->set_number('4608703')->is_valid_number, 'ジャックス 株式会社 名古屋支店');
ok($zip->set_number('4608704')->is_valid_number, '東芝中部ライフエレクトロニクス 株式会社');
ok($zip->set_number('4608706')->is_valid_number, '株式会社 第一勧業銀行 名古屋支店');
ok($zip->set_number('4608707')->is_valid_number, '株式会社 NIPPOコーポレーション 中部支店');
ok($zip->set_number('4608708')->is_valid_number, '日本銀行 名古屋支店');
ok($zip->set_number('4608711')->is_valid_number, '丸紅 株式会社 名古屋支社');
ok($zip->set_number('4608718')->is_valid_number, '桜井 株式会社');
ok($zip->set_number('4608720')->is_valid_number, '富永電機 株式会社 本社');
ok($zip->set_number('4608765')->is_valid_number, '安田信託銀行 株式会社 名古屋支店');
ok($zip->set_number('4608791')->is_valid_number, '共通事務センター');
ok($zip->set_number('4618501')->is_valid_number, '東海テレビ放送');
ok($zip->set_number('4618503')->is_valid_number, '東海ラジオ放送');
ok($zip->set_number('4618504')->is_valid_number, '東海ラジオ放送');
ok($zip->set_number('4618505')->is_valid_number, '株式会社 梅澤');
ok($zip->set_number('4618506')->is_valid_number, '株式会社 大林組 名古屋支店');
ok($zip->set_number('4618507')->is_valid_number, '住友林業 株式会社 営業本部 東海支店');
ok($zip->set_number('4618508')->is_valid_number, '東カン名古屋ビル');
ok($zip->set_number('4618511')->is_valid_number, 'キヤノンマーケティングジャパン 株式会社 名古屋支店');
ok($zip->set_number('4618512')->is_valid_number, '佐藤工業 株式会社 名古屋支店');
ok($zip->set_number('4618515')->is_valid_number, '全国健康保険協会 愛知支部');
ok($zip->set_number('4618520')->is_valid_number, '萩原電気 株式会社');
ok($zip->set_number('4618522')->is_valid_number, 'サンデーフォークプロモーション');
ok($zip->set_number('4618525')->is_valid_number, '愛知芸術文化センター');
ok($zip->set_number('4618530')->is_valid_number, '松下電器産業 株式会社');
ok($zip->set_number('4618531')->is_valid_number, 'アスゲン製薬 株式会社');
ok($zip->set_number('4618532')->is_valid_number, '愛知県国民健康保険団体連合会');
ok($zip->set_number('4618539')->is_valid_number, '玉野総合コンサルタント 株式会社');
ok($zip->set_number('4618540')->is_valid_number, '関西電力 株式会社 東海支社');
ok($zip->set_number('4618541')->is_valid_number, '東京海上日動火災保険 株式会社');
ok($zip->set_number('4618550')->is_valid_number, '第一法規出版 (株) 東海支社');
ok($zip->set_number('4618555')->is_valid_number, '株式会社 松本義肢製作所');
ok($zip->set_number('4618558')->is_valid_number, '西松建設 株式会社 中部支店');
ok($zip->set_number('4618560')->is_valid_number, '六合エレメック');
ok($zip->set_number('4618575')->is_valid_number, '名古屋北労働基準監督署');
ok($zip->set_number('4618577')->is_valid_number, '(株) レアールパスコベーカリーズ 名古屋本部');
ok($zip->set_number('4618580')->is_valid_number, '社団法人 中部産業連盟');
ok($zip->set_number('4618581')->is_valid_number, '大同特殊鋼 株式会社');
ok($zip->set_number('4618582')->is_valid_number, '株式会社 日刊工業新聞社 名古屋支社');
ok($zip->set_number('4618585')->is_valid_number, '日本国土開発 株式会社 名古屋支店');
ok($zip->set_number('4618586')->is_valid_number, '名古屋拘置所');
ok($zip->set_number('4618588')->is_valid_number, '株式会社 小出物産');
ok($zip->set_number('4618602')->is_valid_number, '住友生命保険 相互会社 愛知南支社');
ok($zip->set_number('4618603')->is_valid_number, '株式会社 大塚屋');
ok($zip->set_number('4618605')->is_valid_number, '(株) NTTデータ 東海支社');
ok($zip->set_number('4618608')->is_valid_number, '株式会社 ヤマナカ');
ok($zip->set_number('4618610')->is_valid_number, '山田学園');
ok($zip->set_number('4618612')->is_valid_number, 'トヨタカローラ中京 株式会社');
ok($zip->set_number('4618614')->is_valid_number, '阪和興業 株式会社 名古屋支社');
ok($zip->set_number('4618620')->is_valid_number, 'ダイテック');
ok($zip->set_number('4618621')->is_valid_number, '名古屋東 税務署');
ok($zip->set_number('4618626')->is_valid_number, '名古屋市 栄市税事務所');
ok($zip->set_number('4618630')->is_valid_number, 'いその 株式会社');
ok($zip->set_number('4618631')->is_valid_number, '(株) 三和化学研究所');
ok($zip->set_number('4618639')->is_valid_number, '愛知国際放送 株式会社');
ok($zip->set_number('4618640')->is_valid_number, '名古屋市東区役所');
ok($zip->set_number('4618641')->is_valid_number, '愛知大学');
ok($zip->set_number('4618645')->is_valid_number, 'ジェイルハウス');
ok($zip->set_number('4618650')->is_valid_number, 'ホーユー 株式会社');
ok($zip->set_number('4618651')->is_valid_number, '千趣会 名古屋支社');
ok($zip->set_number('4618654')->is_valid_number, '旭陵高等学校');
ok($zip->set_number('4618655')->is_valid_number, '株式会社 タカコム');
ok($zip->set_number('4618658')->is_valid_number, '森永乳業 株式会社 東海支店');
ok($zip->set_number('4618666')->is_valid_number, 'ぴあ 株式会社 中部支局');
ok($zip->set_number('4618670')->is_valid_number, '三菱電機 株式会社 名古屋製作所');
ok($zip->set_number('4618671')->is_valid_number, '中京コカ・コーラボトリング 株式会社');
ok($zip->set_number('4618672')->is_valid_number, '株式会社 明治屋 名古屋支店');
ok($zip->set_number('4618673')->is_valid_number, '名古屋大学医学部保健学科 名古屋大学医療技術短期大学部');
ok($zip->set_number('4618675')->is_valid_number, '三菱電機システムサービス 株式会社');
ok($zip->set_number('4618676')->is_valid_number, '学校法人 名古屋学院(中学校・高等学校)');
ok($zip->set_number('4618678')->is_valid_number, '尾張精機 株式会社');
ok($zip->set_number('4618680')->is_valid_number, '中部電力');
ok($zip->set_number('4618703')->is_valid_number, 'ホーユー 株式会社');
ok($zip->set_number('4618706')->is_valid_number, 'ヒサゴ 株式会社');
ok($zip->set_number('4618707')->is_valid_number, '名古屋モザイク工業');
ok($zip->set_number('4618708')->is_valid_number, '株式会社 永楽開発');
ok($zip->set_number('4618710')->is_valid_number, 'NHK 名古屋放送局');
ok($zip->set_number('4618714')->is_valid_number, '(株) 豊田自動織機 トヨタL&Fカンパニー 東桜ビル');
ok($zip->set_number('4618715')->is_valid_number, '千趣会');
ok($zip->set_number('4618717')->is_valid_number, '星野楽器 株式会社');
ok($zip->set_number('4618721')->is_valid_number, '敷島製パン 株式会社');
ok($zip->set_number('4618725')->is_valid_number, '日本放送協会 名古屋放送局');
ok($zip->set_number('4618729')->is_valid_number, '住友商事 名古屋支社');
ok($zip->set_number('4618795')->is_valid_number, '東海総合通信局');
ok($zip->set_number('4618798')->is_valid_number, '名古屋逓信病院');
ok($zip->set_number('4628501')->is_valid_number, '株式会社 ニッショー');
ok($zip->set_number('4628508')->is_valid_number, '名古屋市立西部医療センター');
ok($zip->set_number('4628509')->is_valid_number, '東急鯱バス 株式会社');
ok($zip->set_number('4628511')->is_valid_number, '名古屋市北区役所');
ok($zip->set_number('4628512')->is_valid_number, '親和電機 株式会社');
ok($zip->set_number('4628519')->is_valid_number, '株式会社 東急サービス');
ok($zip->set_number('4628522')->is_valid_number, '名古屋北保健所');
ok($zip->set_number('4628523')->is_valid_number, '愛知県社会保険診療報酬支払基金');
ok($zip->set_number('4628530')->is_valid_number, '中京スポーツ');
ok($zip->set_number('4628535')->is_valid_number, '株式会社 名古屋三越 OSセンター');
ok($zip->set_number('4628540')->is_valid_number, '株式会社 カケン');
ok($zip->set_number('4628543')->is_valid_number, '名古屋北税務署');
ok($zip->set_number('4628551')->is_valid_number, 'アサダ 株式会社');
ok($zip->set_number('4628555')->is_valid_number, 'ヤマハ中部 株式会社');
ok($zip->set_number('4628558')->is_valid_number, '社会福祉法人 名古屋市社会福祉協議会');
ok($zip->set_number('4628575')->is_valid_number, '社団法人 名北労働基準協会');
ok($zip->set_number('4628576')->is_valid_number, '愛知県 衛生研究所');
ok($zip->set_number('4628577')->is_valid_number, '菅原電気 株式会社 名古屋支店');
ok($zip->set_number('4628580')->is_valid_number, 'ビジネス教養専門学校エクセレンス');
ok($zip->set_number('4628588')->is_valid_number, '株式会社 メイチュー');
ok($zip->set_number('4628666')->is_valid_number, '名古屋北社会保険事務所');
ok($zip->set_number('4638501')->is_valid_number, '新栄機工 株式会社');
ok($zip->set_number('4638502')->is_valid_number, '愛知県立看護大学');
ok($zip->set_number('4638503')->is_valid_number, '愛知県立守山高等学校');
ok($zip->set_number('4638505')->is_valid_number, '緑ケ丘カンツリークラブ');
ok($zip->set_number('4638510')->is_valid_number, '守山区役所');
ok($zip->set_number('4638521')->is_valid_number, '金城学院大学');
ok($zip->set_number('4638522')->is_valid_number, 'グリーンシティケーブルテレビ 株式会社');
ok($zip->set_number('4638528')->is_valid_number, '理科研 株式会社');
ok($zip->set_number('4638530')->is_valid_number, '医療法人 香流会 絋仁病院');
ok($zip->set_number('4638533')->is_valid_number, '株式会社 清水屋 藤ケ丘店');
ok($zip->set_number('4638535')->is_valid_number, '株式会社 サガミチェーン');
ok($zip->set_number('4638536')->is_valid_number, '株式会社 ショクブン');
ok($zip->set_number('4638538')->is_valid_number, 'トーシック 株式会社');
ok($zip->set_number('4638540')->is_valid_number, '株式会社 あらた家庭用品 東海支店');
ok($zip->set_number('4638541')->is_valid_number, '応用地質 株式会社 中部支社');
ok($zip->set_number('4638543')->is_valid_number, '東海大日本印刷 株式会社');
ok($zip->set_number('4638545')->is_valid_number, '丸眞 株式会社');
ok($zip->set_number('4638547')->is_valid_number, '日本コンクリート 株式会社');
ok($zip->set_number('4638548')->is_valid_number, '株式会社 青柳ういろう');
ok($zip->set_number('4638550')->is_valid_number, '大日本印刷 株式会社 中部事業部');
ok($zip->set_number('4638555')->is_valid_number, '尾家産業 株式会社 名古屋支店');
ok($zip->set_number('4638557')->is_valid_number, '株式会社 豊和化成');
ok($zip->set_number('4638560')->is_valid_number, '独立行政法人 産業総合研究所 中部センター');
ok($zip->set_number('4638561')->is_valid_number, '独立行政法人 産業技術総合研究所 中部センター 中部産学官連携研究棟');
ok($zip->set_number('4638565')->is_valid_number, '名古屋手袋 株式会社');
ok($zip->set_number('4638567')->is_valid_number, '名古屋市立 守山市民病院');
ok($zip->set_number('4638571')->is_valid_number, '昌和物産 株式会社');
ok($zip->set_number('4638575')->is_valid_number, 'アサヒロジ 株式会社 名古屋支店');
ok($zip->set_number('4638577')->is_valid_number, '西部機械 株式会社');
ok($zip->set_number('4638580')->is_valid_number, 'アサヒビール 株式会社 名古屋工場');
ok($zip->set_number('4648511')->is_valid_number, 'ユニー千代田橋店');
ok($zip->set_number('4648512')->is_valid_number, '国家公務員共済組合連合会 東海病院');
ok($zip->set_number('4648520')->is_valid_number, '愛知高等学校');
ok($zip->set_number('4648521')->is_valid_number, 'アスティショッピングセンター');
ok($zip->set_number('4648522')->is_valid_number, '名古屋コミュニタス 株式会社');
ok($zip->set_number('4648525')->is_valid_number, '株式会社 中日新聞社 中日スポーツ総局');
ok($zip->set_number('4648530')->is_valid_number, '株式会社 油久');
ok($zip->set_number('4648531')->is_valid_number, '株式会社 名古屋医理科商会');
ok($zip->set_number('4648533')->is_valid_number, '学校法人 市邨学園 市邨学園高等学校 市邨学園中学校');
ok($zip->set_number('4648536')->is_valid_number, 'サンスター 株式会社 名古屋支店');
ok($zip->set_number('4648539')->is_valid_number, '株式会社 榎村鐵工所 株式会社 エムラ販売');
ok($zip->set_number('4648540')->is_valid_number, '学校法人 名古屋電気学園');
ok($zip->set_number('4648543')->is_valid_number, '愛知厚生年金会館');
ok($zip->set_number('4648545')->is_valid_number, '株式会社 八木一');
ok($zip->set_number('4648546')->is_valid_number, '東海物産 株式会社');
ok($zip->set_number('4648547')->is_valid_number, '名古屋市立 東部医療センター');
ok($zip->set_number('4648550')->is_valid_number, 'セキセー 株式会社');
ok($zip->set_number('4648555')->is_valid_number, '千種税務署');
ok($zip->set_number('4648558')->is_valid_number, '中央建材工業 株式会社');
ok($zip->set_number('4648560')->is_valid_number, '株式会社 ニイミ');
ok($zip->set_number('4648561')->is_valid_number, '株式会社 スギヤマ薬品');
ok($zip->set_number('4648566')->is_valid_number, '沖テクノシステムズラボラトリ');
ok($zip->set_number('4648567')->is_valid_number, '株式会社 フューチャーイン');
ok($zip->set_number('4648570')->is_valid_number, 'KDDI 株式会社');
ok($zip->set_number('4648571')->is_valid_number, '株式会社 同和紙業');
ok($zip->set_number('4648577')->is_valid_number, '株式会社 三幸商会');
ok($zip->set_number('4648585')->is_valid_number, '名古屋少年鑑別所');
ok($zip->set_number('4648601')->is_valid_number, '名古屋大学(理、工を除く東山地区)');
ok($zip->set_number('4648602')->is_valid_number, '名古屋大学 理学部');
ok($zip->set_number('4648603')->is_valid_number, '名古屋大学 工学部');
ok($zip->set_number('4648610')->is_valid_number, '学校法人 河合塾');
ok($zip->set_number('4648611')->is_valid_number, '学校法人 河合塾学園 (トライデントスクール)');
ok($zip->set_number('4648613')->is_valid_number, 'フジクリーン工業 株式会社');
ok($zip->set_number('4648615')->is_valid_number, '佐藤製薬 株式会社 名古屋営業所');
ok($zip->set_number('4648616')->is_valid_number, '名古屋造形ビジネス専門学校');
ok($zip->set_number('4648617')->is_valid_number, 'ビーシープロダクツ (株)');
ok($zip->set_number('4648621')->is_valid_number, '住宅金融公庫 名古屋支店');
ok($zip->set_number('4648631')->is_valid_number, '株式会社 丸の内');
ok($zip->set_number('4648632')->is_valid_number, '大正製薬 株式会社 名古屋支店');
ok($zip->set_number('4648633')->is_valid_number, '加藤商事 株式会社');
ok($zip->set_number('4648635')->is_valid_number, '日産プリンス名古屋販売 株式会社');
ok($zip->set_number('4648637')->is_valid_number, 'メーキュー 株式会社');
ok($zip->set_number('4648641')->is_valid_number, '西川印刷 株式会社');
ok($zip->set_number('4648643')->is_valid_number, '日本電子計算 株式会社 名古屋支店');
ok($zip->set_number('4648644')->is_valid_number, '名古屋市千種区役所');
ok($zip->set_number('4648650')->is_valid_number, '学校法人 愛知学院');
ok($zip->set_number('4648651')->is_valid_number, '愛知学院大学歯学部附属病院');
ok($zip->set_number('4648652')->is_valid_number, 'ダイトーエムイー 株式会社');
ok($zip->set_number('4648653')->is_valid_number, 'ヤフー 株式会社');
ok($zip->set_number('4648654')->is_valid_number, '(株) 中部松坂屋ストア');
ok($zip->set_number('4648661')->is_valid_number, '株式会社 名古屋三越星ヶ丘店');
ok($zip->set_number('4648662')->is_valid_number, '学校法人 椙山女学園');
ok($zip->set_number('4648663')->is_valid_number, 'ミサワホーム東海 株式会社');
ok($zip->set_number('4648671')->is_valid_number, '学校法人 愛知淑徳学園');
ok($zip->set_number('4648681')->is_valid_number, '愛知県がんセンター');
ok($zip->set_number('4648710')->is_valid_number, '金城軒');
ok($zip->set_number('4658501')->is_valid_number, '株式会社 チヨダ 中部地区本部');
ok($zip->set_number('4658505')->is_valid_number, 'サンコー商事 株式会社');
ok($zip->set_number('4658506')->is_valid_number, '名東保健所');
ok($zip->set_number('4658507')->is_valid_number, '愛知県立 千種高等学校');
ok($zip->set_number('4658508')->is_valid_number, '名東区役所');
ok($zip->set_number('4658510')->is_valid_number, '新統情報センター 株式会社');
ok($zip->set_number('4658511')->is_valid_number, '藤久 株式会社');
ok($zip->set_number('4658515')->is_valid_number, '愛知東邦大学');
ok($zip->set_number('4658516')->is_valid_number, '東邦高等学校');
ok($zip->set_number('4658520')->is_valid_number, '株式会社 コムラ');
ok($zip->set_number('4658550')->is_valid_number, '株式会社 富士');
ok($zip->set_number('4658551')->is_valid_number, '日本圧着端子製造 株式会社 名古屋営業所');
ok($zip->set_number('4658552')->is_valid_number, '株式会社 トヨマック');
ok($zip->set_number('4658555')->is_valid_number, '藤久 株式会社 第2ビル');
ok($zip->set_number('4658558')->is_valid_number, '愛知県 名東警察署');
ok($zip->set_number('4658560')->is_valid_number, '中京三洋 株式会社');
ok($zip->set_number('4658565')->is_valid_number, '株式会社 プロトコーポレーション');
ok($zip->set_number('4658566')->is_valid_number, 'トヨタホーム名古屋 株式会社');
ok($zip->set_number('4658567')->is_valid_number, 'アルフレッサ 株式会社 東海オフィス');
ok($zip->set_number('4658610')->is_valid_number, '名古屋市厚生院');
ok($zip->set_number('4658611')->is_valid_number, '東海コープ事業連合・めいきん生協');
ok($zip->set_number('4658612')->is_valid_number, '株式会社 アトム');
ok($zip->set_number('4658620')->is_valid_number, '国立療養所 東名古屋病院');
ok($zip->set_number('4658622')->is_valid_number, '日本ぱちんこ部品 株式会社');
ok($zip->set_number('4658626')->is_valid_number, '名古屋市 栄市税事務所 上社出張所');
ok($zip->set_number('4658651')->is_valid_number, 'エレックヒシキ 株式会社');
ok($zip->set_number('4658668')->is_valid_number, 'ネットトヨタ中部 株式会社');
ok($zip->set_number('4658670')->is_valid_number, 'トーヨーキッチンアンドリビング 株式会社');
ok($zip->set_number('4668501')->is_valid_number, '愛知県名古屋南部県税事務所 高辻間税課');
ok($zip->set_number('4668502')->is_valid_number, 'トヨタL&F中部 株式会社');
ok($zip->set_number('4668505')->is_valid_number, '白川電気土木 株式会社');
ok($zip->set_number('4668506')->is_valid_number, '宮吉硝子 株式会社');
ok($zip->set_number('4668507')->is_valid_number, '株式会社 木曽路');
ok($zip->set_number('4668508')->is_valid_number, 'トヨタカローラ愛豊 株式会社');
ok($zip->set_number('4668510')->is_valid_number, '榊原 株式会社');
ok($zip->set_number('4668511')->is_valid_number, '中央工機 株式会社');
ok($zip->set_number('4668512')->is_valid_number, '竹田印刷 株式会社');
ok($zip->set_number('4668515')->is_valid_number, '安藤 株式会社');
ok($zip->set_number('4668522')->is_valid_number, '日本ペイント販売 株式会社 中部支社');
ok($zip->set_number('4668525')->is_valid_number, '中京大学附属 中京高等学校');
ok($zip->set_number('4668533')->is_valid_number, '株式会社 日伝 名古屋支店');
ok($zip->set_number('4668539')->is_valid_number, '株式会社 一光 名古屋支店');
ok($zip->set_number('4668540')->is_valid_number, '株式会社 ホンダベルノ愛知');
ok($zip->set_number('4668550')->is_valid_number, '名古屋大学 医学部');
ok($zip->set_number('4668554')->is_valid_number, '味の素 株式会社 名古屋支社');
ok($zip->set_number('4668555')->is_valid_number, '名古屋工業大学');
ok($zip->set_number('4668558')->is_valid_number, '愛知県 自動車会館');
ok($zip->set_number('4668560')->is_valid_number, '名古屋大学 医学部 附属病院');
ok($zip->set_number('4668565')->is_valid_number, '(JAF)社団法人 日本自動車連盟 中部本部');
ok($zip->set_number('4668567')->is_valid_number, '日本年金機構 昭和年金事務所');
ok($zip->set_number('4668580')->is_valid_number, '社団法人 日本自動車連盟 愛知支部');
ok($zip->set_number('4668585')->is_valid_number, '名古屋市昭和区役所');
ok($zip->set_number('4668588')->is_valid_number, 'パイロットインキ 株式会社');
ok($zip->set_number('4668630')->is_valid_number, '光洋マテリカ 株式会社');
ok($zip->set_number('4668633')->is_valid_number, '聖霊病院');
ok($zip->set_number('4668635')->is_valid_number, '中京テレビ放送 株式会社');
ok($zip->set_number('4668650')->is_valid_number, '名古屋第二赤十字病院');
ok($zip->set_number('4668655')->is_valid_number, '愛知県保険医協会');
ok($zip->set_number('4668656')->is_valid_number, '矢崎総業 株式会社 名古屋支店');
ok($zip->set_number('4668657')->is_valid_number, '大学生協 東海会館');
ok($zip->set_number('4668660')->is_valid_number, '(株) ジョットインターナショナル 名古屋支店');
ok($zip->set_number('4668666')->is_valid_number, '中京大学');
ok($zip->set_number('4668673')->is_valid_number, '南山大学');
ok($zip->set_number('4668701')->is_valid_number, '愛知トヨタ自動車 株式会社');
ok($zip->set_number('4668707')->is_valid_number, '中京テレビ放送 株式会社');
ok($zip->set_number('4668711')->is_valid_number, '辰巳屋興業 株式会社');
ok($zip->set_number('4678501')->is_valid_number, '名古屋市立大学 (経済学部、人文社会学部、教養教育、自然科学研究教育センター、計算センター)');
ok($zip->set_number('4678510')->is_valid_number, '昭和税務署');
ok($zip->set_number('4678511')->is_valid_number, '名古屋大谷高等学校');
ok($zip->set_number('4678520')->is_valid_number, '株式会社 シーテック');
ok($zip->set_number('4678521')->is_valid_number, '瑞穂高等学校');
ok($zip->set_number('4678522')->is_valid_number, 'マドラス 株式会社');
ok($zip->set_number('4678525')->is_valid_number, '日本特殊陶業 株式会社');
ok($zip->set_number('4678530')->is_valid_number, '日本ガイシ 株式会社');
ok($zip->set_number('4678531')->is_valid_number, '名古屋市瑞穂区役所');
ok($zip->set_number('4678533')->is_valid_number, '丸美産業 株式会社');
ok($zip->set_number('4678555')->is_valid_number, '社団法人 愛知県トラック協会');
ok($zip->set_number('4678558')->is_valid_number, '名古屋経済大学高蔵高等学校 名古屋経済大学高蔵中学校');
ok($zip->set_number('4678561')->is_valid_number, 'ブラザー工業 株式会社 本社');
ok($zip->set_number('4678562')->is_valid_number, 'ブラザー工業 株式会社 瑞穂工場');
ok($zip->set_number('4678563')->is_valid_number, '株式会社 中央製作所');
ok($zip->set_number('4678566')->is_valid_number, '株式会社 エクシング');
ok($zip->set_number('4678567')->is_valid_number, '株式会社 エルモ社');
ok($zip->set_number('4678571')->is_valid_number, '石原商事 株式会社');
ok($zip->set_number('4678577')->is_valid_number, 'ブラザー販売 株式会社');
ok($zip->set_number('4678580')->is_valid_number, 'アミテック 株式会社');
ok($zip->set_number('4678581')->is_valid_number, '木村刃物製造 株式会社');
ok($zip->set_number('4678585')->is_valid_number, '株式会社 パロマ');
ok($zip->set_number('4678588')->is_valid_number, '愛知日野自動車 株式会社');
ok($zip->set_number('4678601')->is_valid_number, '公立大学法人 名古屋市立大学');
ok($zip->set_number('4678602')->is_valid_number, '名古屋市立 大学病院');
ok($zip->set_number('4678603')->is_valid_number, '名古屋市立大学 薬学部');
ok($zip->set_number('4678610')->is_valid_number, '名古屋女子大学・名古屋女子大学短期大学部');
ok($zip->set_number('4678611')->is_valid_number, '名古屋女子大学中学校・高等学校');
ok($zip->set_number('4678615')->is_valid_number, '名古屋市衛生研究所');
ok($zip->set_number('4678622')->is_valid_number, '名古屋市総合リハビリテーションセンター');
ok($zip->set_number('4678626')->is_valid_number, '享栄高等学校');
ok($zip->set_number('4678630')->is_valid_number, '明治乳業 株式会社 東海支社');
ok($zip->set_number('4678633')->is_valid_number, '(医)新生会 新生会・第一病院');
ok($zip->set_number('4678639')->is_valid_number, '愛知県立昭和高校');
ok($zip->set_number('4678651')->is_valid_number, 'フジパン 株式会社');
ok($zip->set_number('4678686')->is_valid_number, 'フジパンストアー 株式会社');
ok($zip->set_number('4688501')->is_valid_number, '株式会社 セントラルファイナンス ナゴヤジムセンター');
ok($zip->set_number('4688502')->is_valid_number, '名城大学');
ok($zip->set_number('4688503')->is_valid_number, '名城大学 薬学部');
ok($zip->set_number('4688504')->is_valid_number, '社団法人 日本自動車連盟 愛知支部');
ok($zip->set_number('4688505')->is_valid_number, '中日販売 株式会社');
ok($zip->set_number('4688506')->is_valid_number, '株式会社 セントラルファイナンス カード業務センター');
ok($zip->set_number('4688507')->is_valid_number, '名古屋女子大学 天白学舎');
ok($zip->set_number('4688510')->is_valid_number, '天白区役所');
ok($zip->set_number('4688511')->is_valid_number, '豊田工業大学');
ok($zip->set_number('4688512')->is_valid_number, 'リョービ販売 株式会社');
ok($zip->set_number('4688513')->is_valid_number, '愛知県警察運転免許試験場');
ok($zip->set_number('4688514')->is_valid_number, '東海学園大学 名古屋キャンパス');
ok($zip->set_number('4688520')->is_valid_number, '名古屋記念病院');
ok($zip->set_number('4688522')->is_valid_number, 'トヨタホーム名古屋 株式会社');
ok($zip->set_number('4688531')->is_valid_number, '大洋技研工業 株式会社');
ok($zip->set_number('4688532')->is_valid_number, '安藤技建 株式会社');
ok($zip->set_number('4688533')->is_valid_number, 'ナカシャクリエイテブ 株式会社');
ok($zip->set_number('4688534')->is_valid_number, '日本ベターリビング 株式会社');
ok($zip->set_number('4688536')->is_valid_number, '株式会社 瓶屋');
ok($zip->set_number('4688585')->is_valid_number, '株式会社 丸越');
ok($zip->set_number('4688588')->is_valid_number, '名古屋製酪 株式会社');
ok($zip->set_number('4688626')->is_valid_number, '名古屋市 金山市税事務所 野並出張所');
ok($zip->set_number('4698793')->is_valid_number, '郵便事業 株式会社 東海支社 郵便事業部 (三種)');
ok($zip->set_number('4698794')->is_valid_number, '名古屋貯金事務センター');
ok($zip->set_number('4698796')->is_valid_number, '東海監査室');
ok($zip->set_number('4698797')->is_valid_number, '株式会社 ゆうちょ銀行 名古屋支店');
ok($zip->set_number('4698797')->is_valid_number, '株式会社 かんぽ生命 名古屋支店');
ok($zip->set_number('4698797')->is_valid_number, '郵便局 株式会社 東海支社');
ok($zip->set_number('4698797')->is_valid_number, '郵便事業 株式会社 東海支社');
ok($zip->set_number('4700188')->is_valid_number, '中西学園 中央図書館');
ok($zip->set_number('4700192')->is_valid_number, '日進市役所');
ok($zip->set_number('4700194')->is_valid_number, 'マスプロ電工 株式会社');
ok($zip->set_number('4700195')->is_valid_number, '愛知学院大学');
ok($zip->set_number('4700196')->is_valid_number, '名古屋学芸大学');
ok($zip->set_number('4700198')->is_valid_number, '東郷町役場');
ok($zip->set_number('4700292')->is_valid_number, 'NCA');
ok($zip->set_number('4700293')->is_valid_number, 'ノリタケカンパニー');
ok($zip->set_number('4700294')->is_valid_number, '三五');
ok($zip->set_number('4700295')->is_valid_number, 'みよし市役所');
ok($zip->set_number('4700296')->is_valid_number, '愛知大学');
ok($zip->set_number('4700297')->is_valid_number, '昌和物産 株式会社');
ok($zip->set_number('4700392')->is_valid_number, '愛知工業大学');
ok($zip->set_number('4700393')->is_valid_number, '中京大学');
ok($zip->set_number('4700394')->is_valid_number, '愛知みずほ大学');
ok($zip->set_number('4700395')->is_valid_number, 'トヨタ紡織 株式会社 猿投工場');
ok($zip->set_number('4700396')->is_valid_number, '愛知県厚生農業協同組合連合会 豊田厚生病院');
ok($zip->set_number('4700492')->is_valid_number, 'アイシン化工 株式会社');
ok($zip->set_number('4700493')->is_valid_number, '豊田市役所 藤岡支所');
ok($zip->set_number('4700495')->is_valid_number, 'あいち豊田農協 藤岡支店');
ok($zip->set_number('4700496')->is_valid_number, '豊和化成 株式会社');
ok($zip->set_number('4700592')->is_valid_number, '豊田市役所 小原支所');
ok($zip->set_number('4701192')->is_valid_number, '藤田保健衛生大学');
ok($zip->set_number('4701193')->is_valid_number, '名古屋短期大学');
ok($zip->set_number('4701194')->is_valid_number, 'ホシザキ電機 株式会社');
ok($zip->set_number('4701195')->is_valid_number, '豊明市役所');
ok($zip->set_number('4701196')->is_valid_number, '笹徳印刷 株式会社');
ok($zip->set_number('4701198')->is_valid_number, '寿がきや食品 株式会社 本社工場');
ok($zip->set_number('4701292')->is_valid_number, 'トヨタ生活 協同組合');
ok($zip->set_number('4701293')->is_valid_number, '豊生ブレーキ工業 株式会社');
ok($zip->set_number('4701294')->is_valid_number, '矢崎総業 株式会社');
ok($zip->set_number('4701295')->is_valid_number, '東洋工業');
ok($zip->set_number('4701296')->is_valid_number, 'シンテックホズミ');
ok($zip->set_number('4702192')->is_valid_number, '愛知県知多郡東浦町役場');
ok($zip->set_number('4702193')->is_valid_number, 'カリモク家具 株式会社 本社');
ok($zip->set_number('4702195')->is_valid_number, 'カリモク家具 株式会社 お客様相談室');
ok($zip->set_number('4702196')->is_valid_number, '積水フィルム 株式会社 名古屋工場');
ok($zip->set_number('4702197')->is_valid_number, '株式会社 ティラド名古屋製作所');
ok($zip->set_number('4702292')->is_valid_number, '阿久比町役場');
ok($zip->set_number('4702296')->is_valid_number, 'デンソーエレックス 株式会社');
ok($zip->set_number('4702297')->is_valid_number, '株式会社 デンソーウェーブ');
ok($zip->set_number('4702298')->is_valid_number, '株式会社 デンソー 阿久比製作所');
ok($zip->set_number('4702392')->is_valid_number, '武豊町役場');
ok($zip->set_number('4702393')->is_valid_number, 'ファイザー製薬');
ok($zip->set_number('4702394')->is_valid_number, '旭硝子 愛知工場');
ok($zip->set_number('4702398')->is_valid_number, '日本油脂 愛知事業所');
ok($zip->set_number('4702492')->is_valid_number, '美浜町役場');
ok($zip->set_number('4702493')->is_valid_number, '加藤化学 株式会社');
ok($zip->set_number('4703295')->is_valid_number, '日本福祉大学');
ok($zip->set_number('4703296')->is_valid_number, '日本福祉大学 生活協同組合');
ok($zip->set_number('4703495')->is_valid_number, '南知多町役場');
ok($zip->set_number('4718501')->is_valid_number, '豊田市役所');
ok($zip->set_number('4718502')->is_valid_number, '大豊工業 株式会社');
ok($zip->set_number('4718503')->is_valid_number, '愛知県豊田事務所');
ok($zip->set_number('4718506')->is_valid_number, '豊田商工会議所');
ok($zip->set_number('4718507')->is_valid_number, '豊田鉄工 株式会社');
ok($zip->set_number('4718508')->is_valid_number, '住友ゴム工業 株式会社 名古屋工場');
ok($zip->set_number('4718510')->is_valid_number, '株式会社 F T S');
ok($zip->set_number('4718512')->is_valid_number, '豊田通商 株式会社 豊田支店');
ok($zip->set_number('4718513')->is_valid_number, 'トヨタ記念病院');
ok($zip->set_number('4718515')->is_valid_number, '株式会社 協豊製作所');
ok($zip->set_number('4718521')->is_valid_number, '豊田税務署');
ok($zip->set_number('4718522')->is_valid_number, '中部工業 株式会社');
ok($zip->set_number('4718525')->is_valid_number, '豊田工業高等専門学校');
ok($zip->set_number('4718527')->is_valid_number, 'トヨタ輸送 株式会社');
ok($zip->set_number('4718530')->is_valid_number, '株式会社 三菱東京UFJ銀行 豊田支店');
ok($zip->set_number('4718531')->is_valid_number, '合資会社 原田屋');
ok($zip->set_number('4718532')->is_valid_number, '愛知学泉大学');
ok($zip->set_number('4718535')->is_valid_number, 'トリニティ工業 株式会社');
ok($zip->set_number('4718536')->is_valid_number, '三井海上火災保険 株式会社');
ok($zip->set_number('4718537')->is_valid_number, '愛知県豊田加茂県税事務所');
ok($zip->set_number('4718550')->is_valid_number, '光生アルミニューム工業 株式会社');
ok($zip->set_number('4718555')->is_valid_number, '株式会社 ニコフ 名古屋事業所');
ok($zip->set_number('4718560')->is_valid_number, '株式会社 松坂屋 豊田店');
ok($zip->set_number('4718565')->is_valid_number, '日本赤十字豊田看護大学');
ok($zip->set_number('4718566')->is_valid_number, '愛知県 豊田加茂農林水産事務所');
ok($zip->set_number('4718571')->is_valid_number, 'トヨタ自動車 株式会社');
ok($zip->set_number('4718572')->is_valid_number, 'トヨタ自動車 株式会社(本社技術部門)');
ok($zip->set_number('4718573')->is_valid_number, 'トヨタ自動車 株式会社 元町工場');
ok($zip->set_number('4718574')->is_valid_number, 'トヨタ自動車 株式会社 貞宝工場');
ok($zip->set_number('4718585')->is_valid_number, '名古屋法務局 豊田支局');
ok($zip->set_number('4718588')->is_valid_number, '小島プレス工業 株式会社');
ok($zip->set_number('4718601')->is_valid_number, '豊田信用金庫');
ok($zip->set_number('4718602')->is_valid_number, '豊田社会保険事務所');
ok($zip->set_number('4718603')->is_valid_number, '豊田市農業協同組合');
ok($zip->set_number('4718609')->is_valid_number, '豊田公共職業安定所');
ok($zip->set_number('4728555')->is_valid_number, '(宗) 遍照院');
ok($zip->set_number('4728585')->is_valid_number, '愛知県立 知立高等学校');
ok($zip->set_number('4728639')->is_valid_number, '愛知県立知立東高等学校');
ok($zip->set_number('4728666')->is_valid_number, '知立市役所');
ok($zip->set_number('4728686')->is_valid_number, '富士機械製造 株式会社');
ok($zip->set_number('4738501')->is_valid_number, 'アイシン高丘 株式会社');
ok($zip->set_number('4738511')->is_valid_number, '富士精工 株式会社');
ok($zip->set_number('4738512')->is_valid_number, 'アラコ 株式会社');
ok($zip->set_number('4738533')->is_valid_number, '日本エーエムピー 株式会社');
ok($zip->set_number('4748501')->is_valid_number, '住友重機械工業 株式会社 名古屋製造所');
ok($zip->set_number('4748502')->is_valid_number, '株式会社 新居浜鐵工所 名古屋工場');
ok($zip->set_number('4748503')->is_valid_number, '大府市商工会');
ok($zip->set_number('4748505')->is_valid_number, '愛協産業 株式会社');
ok($zip->set_number('4748510')->is_valid_number, 'イヅミ工業 株式会社');
ok($zip->set_number('4748511')->is_valid_number, '独立行政法人 国立長寿医療研究センター');
ok($zip->set_number('4748522')->is_valid_number, '国立長寿医療センター研究所');
ok($zip->set_number('4748535')->is_valid_number, '大和機工 株式会社');
ok($zip->set_number('4748543')->is_valid_number, '株式会社 名南製作所');
ok($zip->set_number('4748550')->is_valid_number, '住友建機 (株) 名古屋工場');
ok($zip->set_number('4748555')->is_valid_number, '住友エール 株式会社');
ok($zip->set_number('4748557')->is_valid_number, '(株) 東海理機製作所 横根工場');
ok($zip->set_number('4748558')->is_valid_number, '株式会社 東海理機製作所 長根工場');
ok($zip->set_number('4748580')->is_valid_number, 'アイサンコンピュータサービス 株式会社');
ok($zip->set_number('4748581')->is_valid_number, '株式会社 アンセイ');
ok($zip->set_number('4748584')->is_valid_number, '株式会社 八神');
ok($zip->set_number('4748585')->is_valid_number, '株式会社 アペックス');
ok($zip->set_number('4748588')->is_valid_number, '愛三工業 株式会社');
ok($zip->set_number('4748601')->is_valid_number, '株式会社 豊田自動織機製作所 共和工場');
ok($zip->set_number('4748610')->is_valid_number, '株式会社 富士プレス');
ok($zip->set_number('4748611')->is_valid_number, '株式会社 富新住宅設備');
ok($zip->set_number('4748642')->is_valid_number, '東洋クッション 株式会社');
ok($zip->set_number('4748651')->is_valid_number, '中京女子大学');
ok($zip->set_number('4748666')->is_valid_number, '(株) 名機製作所');
ok($zip->set_number('4748686')->is_valid_number, '(株) 豊田自動織機製作所 長草工場');
ok($zip->set_number('4748688')->is_valid_number, '東海興業 (株)');
ok($zip->set_number('4748701')->is_valid_number, '愛知県大府市役所');
ok($zip->set_number('4748707')->is_valid_number, '東知多農業 協同組合');
ok($zip->set_number('4748710')->is_valid_number, 'あいち小児保健医療総合センター');
ok($zip->set_number('4748766')->is_valid_number, 'ネットオフ 株式会社 「書籍・CDコース」買取センター');
ok($zip->set_number('4748777')->is_valid_number, 'ネットオフ 株式会社 「ブランド・家電コース」買取センター');
ok($zip->set_number('4758501')->is_valid_number, '愛知県知多事務所');
ok($zip->set_number('4758502')->is_valid_number, '半田公共職業安定所');
ok($zip->set_number('4758510')->is_valid_number, '山田紡績 株式会社');
ok($zip->set_number('4758511')->is_valid_number, '社団法人 半田市医師会健康管理センター');
ok($zip->set_number('4758522')->is_valid_number, '社団法人 半田市医師会健康管理センター');
ok($zip->set_number('4758528')->is_valid_number, '株式会社 鶴弥');
ok($zip->set_number('4758541')->is_valid_number, '株式会社 中京医薬品');
ok($zip->set_number('4758550')->is_valid_number, 'ツカサ工業 株式会社');
ok($zip->set_number('4758555')->is_valid_number, '半田法人会');
ok($zip->set_number('4758557')->is_valid_number, '株式会社 イシハラフード');
ok($zip->set_number('4758560')->is_valid_number, '半田労働基準監督署');
ok($zip->set_number('4758574')->is_valid_number, '加藤電機 株式会社');
ok($zip->set_number('4758585')->is_valid_number, '株式会社 中埜酢店');
ok($zip->set_number('4758588')->is_valid_number, '株式会社 UFJ銀行 半田支店');
ok($zip->set_number('4758599')->is_valid_number, '半田市立半田病院');
ok($zip->set_number('4758601')->is_valid_number, '半田社会保険事務所');
ok($zip->set_number('4758611')->is_valid_number, 'JFEスチール 株式会社');
ok($zip->set_number('4758655')->is_valid_number, '半田信用金庫');
ok($zip->set_number('4758666')->is_valid_number, '半田市役所');
ok($zip->set_number('4758668')->is_valid_number, '輸送機工業 株式会社');
ok($zip->set_number('4758686')->is_valid_number, '半田税務署');
ok($zip->set_number('4768501')->is_valid_number, '東邦ガス 株式会社 総合技術研究所');
ok($zip->set_number('4768503')->is_valid_number, '大洋プラスチック');
ok($zip->set_number('4768510')->is_valid_number, '協栄興業株式会社、協栄工機株式会社、協栄運輸株式会社、協栄高圧ガス株式会社');
ok($zip->set_number('4768511')->is_valid_number, '中央病院');
ok($zip->set_number('4768533')->is_valid_number, '豊田スチールセンター 株式会社');
ok($zip->set_number('4768567')->is_valid_number, '東レ 株式会社 東海工場');
ok($zip->set_number('4768577')->is_valid_number, '株式会社 坂角 総本舗');
ok($zip->set_number('4768585')->is_valid_number, 'カゴメ 株式会社 上野工場');
ok($zip->set_number('4768588')->is_valid_number, '学校法人 名古屋石田学園、名古屋明徳短期大学');
ok($zip->set_number('4768601')->is_valid_number, '東海市役所');
ok($zip->set_number('4768666')->is_valid_number, '愛知製鋼 株式会社');
ok($zip->set_number('4768686')->is_valid_number, '新日本製鐵 株式會社 名古屋製鐵所');
ok($zip->set_number('4778521')->is_valid_number, '知多メディアスネットワーク (株)');
ok($zip->set_number('4778538')->is_valid_number, '中部第一輸送 株式会社');
ok($zip->set_number('4788501')->is_valid_number, '日清丸紅飼料 株式会社 知多工場');
ok($zip->set_number('4788502')->is_valid_number, '中部飼料 株式会社');
ok($zip->set_number('4788503')->is_valid_number, 'サンエイ糖化 株式会社');
ok($zip->set_number('4788504')->is_valid_number, 'JX日鉱日石エネルギー 株式会社 知多製造所');
ok($zip->set_number('4788505')->is_valid_number, '株式会社 LIXIL 知多事業所');
ok($zip->set_number('4788555')->is_valid_number, '出光興産 株式会社 愛知製油所');
ok($zip->set_number('4788601')->is_valid_number, '知多市役所');
ok($zip->set_number('4788640')->is_valid_number, '知多市民病院');
ok($zip->set_number('4788641')->is_valid_number, '株式会社 エフエスケー');
ok($zip->set_number('4798501')->is_valid_number, '常滑市競艇事業部 (常滑競艇)');
ok($zip->set_number('4798510')->is_valid_number, '常滑市民病院');
ok($zip->set_number('4798511')->is_valid_number, '大信精機 株式会社');
ok($zip->set_number('4798518')->is_valid_number, '丸茂工業');
ok($zip->set_number('4798555')->is_valid_number, '知多半島ケーブルネットワーク 株式会社');
ok($zip->set_number('4798577')->is_valid_number, 'ジャニス工業 株式会社');
ok($zip->set_number('4798585')->is_valid_number, '株式会社 INAX 本社');
ok($zip->set_number('4798586')->is_valid_number, '世界のタイル博物館');
ok($zip->set_number('4798587')->is_valid_number, '株式会社 INAX 常滑東工場');
ok($zip->set_number('4798588')->is_valid_number, '株式会社 INAX 榎戸工場');
ok($zip->set_number('4798589')->is_valid_number, '株式会社 INAX 大谷工場');
ok($zip->set_number('4798601')->is_valid_number, '知多農業 協同組合');
ok($zip->set_number('4798610')->is_valid_number, '常滑市役所');
ok($zip->set_number('4798623')->is_valid_number, '株式会社 マキノ');
ok($zip->set_number('4798668')->is_valid_number, '常滑商工会議所');
ok($zip->set_number('4798686')->is_valid_number, '常滑 信用組合');
ok($zip->set_number('4798701')->is_valid_number, '中部国際空港 株式会社');
ok($zip->set_number('4798702')->is_valid_number, '中部国際空港情報通信 株式会社');
ok($zip->set_number('4798703')->is_valid_number, '中部国際空港施設サービス 株式会社');
ok($zip->set_number('4798704')->is_valid_number, '中部国際空港旅客サービス 株式会社');
ok($zip->set_number('4798705')->is_valid_number, '中部国際空港エネルギー供給 株式会社');
ok($zip->set_number('4798706')->is_valid_number, '中部国際空港給油施設 株式会社');
ok($zip->set_number('4798707')->is_valid_number, '名古屋税関中部空港税関支署(中部空港CIQ庁舎)');
ok($zip->set_number('4798708')->is_valid_number, '名古屋税関中部空港税関支署(中部空港合同庁舎)');
ok($zip->set_number('4798711')->is_valid_number, '中部国際空港 株式会社 経営企画部運航支援グループ');
ok($zip->set_number('4798712')->is_valid_number, '中部国際空港 株式会社 営業部貨物事業グループ');
ok($zip->set_number('4798787')->is_valid_number, '国土交通省大阪航空局中部空港事務所');
ok($zip->set_number('4800192')->is_valid_number, '兼房 株式会社');
ok($zip->set_number('4800193')->is_valid_number, 'オークマ 株式会社');
ok($zip->set_number('4800195')->is_valid_number, '株式会社 東海理化電機製作所');
ok($zip->set_number('4800197')->is_valid_number, 'ヤマザキマザック 株式会社');
ok($zip->set_number('4800198')->is_valid_number, '青山製作所 株式会社');
ok($zip->set_number('4800281')->is_valid_number, '株式会社 丸市青果');
ok($zip->set_number('4800282')->is_valid_number, 'アピタ名古屋空港店');
ok($zip->set_number('4800288')->is_valid_number, 'エアポートウォーク名古屋');
ok($zip->set_number('4800291')->is_valid_number, '名北魚市場 株式会社');
ok($zip->set_number('4800292')->is_valid_number, '豊山町役場');
ok($zip->set_number('4800294')->is_valid_number, '中日本航空 株式会社');
ok($zip->set_number('4800296')->is_valid_number, '名果 株式会社');
ok($zip->set_number('4800392')->is_valid_number, '愛知県 心身障害者コロニー');
ok($zip->set_number('4800393')->is_valid_number, '東洋電機 株式会社');
ok($zip->set_number('4800395')->is_valid_number, 'ダイコク電機 (株)');
ok($zip->set_number('4801188')->is_valid_number, '株式会社 ホンダベルノ愛知');
ok($zip->set_number('4801189')->is_valid_number, '日東工業 株式会社');
ok($zip->set_number('4801192')->is_valid_number, '株式会社 豊田中央研究所');
ok($zip->set_number('4801193')->is_valid_number, '愛知県農業総合試験場');
ok($zip->set_number('4801194')->is_valid_number, '愛知県立芸術大学');
ok($zip->set_number('4801195')->is_valid_number, '愛知医科大学');
ok($zip->set_number('4801196')->is_valid_number, '長久手町役場');
ok($zip->set_number('4801197')->is_valid_number, '愛知淑徳大学');
ok($zip->set_number('4801198')->is_valid_number, '愛知県立大学');
ok($zip->set_number('4801298')->is_valid_number, '名古屋学院大学');
ok($zip->set_number('4818501')->is_valid_number, '北名古屋市役所東庁舎');
ok($zip->set_number('4818502')->is_valid_number, '名古屋自由学院');
ok($zip->set_number('4818503')->is_valid_number, '名古屋芸術大学 音楽学部');
ok($zip->set_number('4818504')->is_valid_number, '名古屋自由学院 短期大学');
ok($zip->set_number('4818505')->is_valid_number, '株式会社 フジワラ');
ok($zip->set_number('4818508')->is_valid_number, '日進電気 株式会社');
ok($zip->set_number('4818510')->is_valid_number, '(株) ポッカコーポレーション 名古屋工場');
ok($zip->set_number('4818511')->is_valid_number, '株式会社 長登屋');
ok($zip->set_number('4818513')->is_valid_number, '(株) 三菱東京UFJ銀行 師勝ビル');
ok($zip->set_number('4818515')->is_valid_number, '(株) ポッカコーポレーション 中央研究所');
ok($zip->set_number('4818526')->is_valid_number, '株式会社 真誠');
ok($zip->set_number('4818531')->is_valid_number, '北名古屋市役所');
ok($zip->set_number('4818533')->is_valid_number, '天野エンザイム 株式会社 名古屋工場');
ok($zip->set_number('4818535')->is_valid_number, '名古屋芸術大学 西キャンパス');
ok($zip->set_number('4818539')->is_valid_number, '大橋鉄工 株式会社');
ok($zip->set_number('4818540')->is_valid_number, '三洋機工 株式会社');
ok($zip->set_number('4818543')->is_valid_number, '天野エンザイム 株式会社 西春工場');
ok($zip->set_number('4818550')->is_valid_number, 'チタカ・インターナショナル・フーズ 株式会社');
ok($zip->set_number('4818555')->is_valid_number, '株式会社 八幡ねじ');
ok($zip->set_number('4818558')->is_valid_number, '株式会社 大一商会');
ok($zip->set_number('4818588')->is_valid_number, '北名古屋市東図書館・北名古屋市歴史民俗資料館');
ok($zip->set_number('4818601')->is_valid_number, 'ゼネラルパッカー 株式会社');
ok($zip->set_number('4818615')->is_valid_number, '株式会社 百五銀行 西春支店');
ok($zip->set_number('4818678')->is_valid_number, '新東ブレーター 株式会社');
ok($zip->set_number('4818681')->is_valid_number, '株式会社 日進医療器');
ok($zip->set_number('4828501')->is_valid_number, '三興石油工業 株式会社');
ok($zip->set_number('4828510')->is_valid_number, '石塚硝子 株式会社 岩倉工場');
ok($zip->set_number('4828511')->is_valid_number, 'ミヨシ油脂 株式会社 名古屋工場');
ok($zip->set_number('4828530')->is_valid_number, 'テクノエース 株式会社');
ok($zip->set_number('4828555')->is_valid_number, '愛知県立 岩倉高等学校');
ok($zip->set_number('4828651')->is_valid_number, 'いちい信用金庫 愛北営業部');
ok($zip->set_number('4828652')->is_valid_number, 'カウパック 株式会社');
ok($zip->set_number('4828686')->is_valid_number, '岩倉市役所');
ok($zip->set_number('4838502')->is_valid_number, '株式会社 ミサワテクノ');
ok($zip->set_number('4838503')->is_valid_number, 'オークマ 株式会社 江南工場');
ok($zip->set_number('4838505')->is_valid_number, 'JA 愛知北');
ok($zip->set_number('4838507')->is_valid_number, 'アピタ 江南店');
ok($zip->set_number('4838555')->is_valid_number, 'サン電子 株式会社');
ok($zip->set_number('4838701')->is_valid_number, '江南市役所');
ok($zip->set_number('4838704')->is_valid_number, '愛知県厚生農業協同組合連合会 江南厚生病院');
ok($zip->set_number('4848501')->is_valid_number, '犬山市役所');
ok($zip->set_number('4848502')->is_valid_number, '村田機械 株式会社 犬山工場');
ok($zip->set_number('4848503')->is_valid_number, '名古屋経済大学 短期大学部');
ok($zip->set_number('4848504')->is_valid_number, '名古屋経済大学');
ok($zip->set_number('4848505')->is_valid_number, 'エナジーサポート 株式会社');
ok($zip->set_number('4848506')->is_valid_number, '京都大学霊長類研究所');
ok($zip->set_number('4848507')->is_valid_number, '(株) 今仙電機製作所');
ok($zip->set_number('4848508')->is_valid_number, '東洋紡績 (株) 犬山工場');
ok($zip->set_number('4848510')->is_valid_number, '犬山商工会議所');
ok($zip->set_number('4848511')->is_valid_number, '医療法人社団 志聖会 犬山中央病院');
ok($zip->set_number('4848609')->is_valid_number, '犬山公共職業安定所');
ok($zip->set_number('4858505')->is_valid_number, '丸菱工業 株式会社');
ok($zip->set_number('4858510')->is_valid_number, '日本特殊陶業 株式会社 小牧工場');
ok($zip->set_number('4858511')->is_valid_number, '三ツ星ベルト販賣 株式会社 小牧営業所');
ok($zip->set_number('4858512')->is_valid_number, '(株) 三河屋');
ok($zip->set_number('4858516')->is_valid_number, '大日本塗料 株式会社 小牧工場');
ok($zip->set_number('4858520')->is_valid_number, '小牧市民病院');
ok($zip->set_number('4858521')->is_valid_number, '株式会社 国盛化学');
ok($zip->set_number('4858522')->is_valid_number, 'センコー 株式会社 小牧営業所');
ok($zip->set_number('4858523')->is_valid_number, '佐藤食品工業 株式会社');
ok($zip->set_number('4858530')->is_valid_number, 'サカイ創建 株式会社');
ok($zip->set_number('4858531')->is_valid_number, '三友工業 株式会社');
ok($zip->set_number('4858533')->is_valid_number, '愛知陸運 株式会社');
ok($zip->set_number('4858540')->is_valid_number, '株式会社 テクノワシノ');
ok($zip->set_number('4858550')->is_valid_number, '東海ゴム工業 株式会社');
ok($zip->set_number('4858551')->is_valid_number, 'CKD 株式会社');
ok($zip->set_number('4858552')->is_valid_number, '小牧商工会議所');
ok($zip->set_number('4858555')->is_valid_number, '(株)松本義肢製作所');
ok($zip->set_number('4858561')->is_valid_number, '三菱重工業 株式会社 名古屋誘導推進システム製作所');
ok($zip->set_number('4858562')->is_valid_number, '株式会社 ホウトク');
ok($zip->set_number('4858563')->is_valid_number, '名古屋造形芸術大学・短期大学');
ok($zip->set_number('4858565')->is_valid_number, '愛知文教大学');
ok($zip->set_number('4858650')->is_valid_number, '小牧市役所');
ok($zip->set_number('4858651')->is_valid_number, '小牧税務署');
ok($zip->set_number('4858652')->is_valid_number, '航空自衛隊 小牧基地');
ok($zip->set_number('4858653')->is_valid_number, '(株) ダイフク小牧事業所');
ok($zip->set_number('4858654')->is_valid_number, '株式会社 クラウンパッケージ');
ok($zip->set_number('4858655')->is_valid_number, '飯田工業 株式会社');
ok($zip->set_number('4858750')->is_valid_number, '中部電力 株式会社 小牧営業所 小牧電力センター');
ok($zip->set_number('4868501')->is_valid_number, '愛知金属工業 株式会社');
ok($zip->set_number('4868510')->is_valid_number, '春日井市民病院');
ok($zip->set_number('4868511')->is_valid_number, '春日井商工会議所');
ok($zip->set_number('4868515')->is_valid_number, '愛知県東尾張県税事務所');
ok($zip->set_number('4868522')->is_valid_number, 'パナソニックエコシステムズ 株式会社');
ok($zip->set_number('4868524')->is_valid_number, 'パナソニック環境エンジニアリング 株式会社');
ok($zip->set_number('4868540')->is_valid_number, '中部電力 株式会社 春日井営業所');
ok($zip->set_number('4868550')->is_valid_number, '陸上自衛隊 春日井駐屯地');
ok($zip->set_number('4868551')->is_valid_number, 'イダリホームズ、 株式会社');
ok($zip->set_number('4868555')->is_valid_number, '株式会社 イエローハット 中部エリア');
ok($zip->set_number('4868567')->is_valid_number, '株式会社 イケックス工業');
ok($zip->set_number('4868575')->is_valid_number, '(株) 中日ホームサービス');
ok($zip->set_number('4868585')->is_valid_number, '東洋電機 株式会社 春日井工場');
ok($zip->set_number('4868588')->is_valid_number, '株式会社 ゲオ');
ok($zip->set_number('4868666')->is_valid_number, '愛知電機 株式会社');
ok($zip->set_number('4868686')->is_valid_number, '春日井市役所');
ok($zip->set_number('4878501')->is_valid_number, '中部大学');
ok($zip->set_number('4878622')->is_valid_number, '株式会社 キクチメガネ');
ok($zip->set_number('4878650')->is_valid_number, '中部精機 株式会社');
ok($zip->set_number('4888501')->is_valid_number, '日立オムロンターミナルソリューションズ (株)');
ok($zip->set_number('4888505')->is_valid_number, '株式会社 トキワ 製紙事業本部');
ok($zip->set_number('4888520')->is_valid_number, 'パナソニック電工電路 株式会社');
ok($zip->set_number('4888555')->is_valid_number, '愛知県森林公園協会');
ok($zip->set_number('4888578')->is_valid_number, '尾張精機 株式会社');
ok($zip->set_number('4888585')->is_valid_number, '独立行政法人 労働者健康福祉機構 旭労災病院');
ok($zip->set_number('4888655')->is_valid_number, '旭精機工業 株式会社');
ok($zip->set_number('4888666')->is_valid_number, '尾張旭市役所');
ok($zip->set_number('4888686')->is_valid_number, '株式会社 アイトー');
ok($zip->set_number('4888688')->is_valid_number, '旭サナック 株式会社');
ok($zip->set_number('4898450')->is_valid_number, '(株) 尾張東部放送');
ok($zip->set_number('4898510')->is_valid_number, 'テクノエイト 株式会社');
ok($zip->set_number('4898511')->is_valid_number, '瀬戸商工会議所');
ok($zip->set_number('4898520')->is_valid_number, '尾張瀬戸税務署');
ok($zip->set_number('4898550')->is_valid_number, '豊精密工業 株式会社');
ok($zip->set_number('4898555')->is_valid_number, '愛知県赤十字血液センター');
ok($zip->set_number('4898567')->is_valid_number, 'インロック社 株式会社 インロック');
ok($zip->set_number('4898610')->is_valid_number, '東芝家電製造 株式会社 愛知工場');
ok($zip->set_number('4898611')->is_valid_number, '河村電器産業 株式会社');
ok($zip->set_number('4898642')->is_valid_number, '公立陶生病院');
ok($zip->set_number('4898645')->is_valid_number, '(株) オプトン');
ok($zip->set_number('4898650')->is_valid_number, '瀬戸信用金庫');
ok($zip->set_number('4898680')->is_valid_number, '株式会社 成田製陶所');
ok($zip->set_number('4898701')->is_valid_number, '瀬戸市役所');
ok($zip->set_number('4898777')->is_valid_number, 'ロック・セールス社');
ok($zip->set_number('4901192')->is_valid_number, '海部郡大治町役場');
ok($zip->set_number('4901193')->is_valid_number, '株式会社 コーワ');
ok($zip->set_number('4901194')->is_valid_number, '株式会社 鎌倉ハム');
ok($zip->set_number('4901198')->is_valid_number, 'あま市役所 甚目寺庁舎');
ok($zip->set_number('4901292')->is_valid_number, 'あま市役所');
ok($zip->set_number('4901293')->is_valid_number, '株式会社 岩月屋');
ok($zip->set_number('4901295')->is_valid_number, '美和高等学校');
ok($zip->set_number('4901296')->is_valid_number, '旭中部資材 株式会社');
ok($zip->set_number('4901392')->is_valid_number, '愛知県稲沢市 平和支所');
ok($zip->set_number('4910192')->is_valid_number, 'ソニー一宮 株式会社');
ok($zip->set_number('4910392')->is_valid_number, '岩田食品 株式会社');
ok($zip->set_number('4910393')->is_valid_number, '橋本毛織 株式会社');
ok($zip->set_number('4910394')->is_valid_number, 'アイコクアルファ 株式会社 一宮工場');
ok($zip->set_number('4910395')->is_valid_number, '和泉化成 株式会社');
ok($zip->set_number('4918501')->is_valid_number, '一宮市役所');
ok($zip->set_number('4918502')->is_valid_number, '一宮 税務署');
ok($zip->set_number('4918505')->is_valid_number, 'サンファイン 株式会社');
ok($zip->set_number('4918508')->is_valid_number, '株式会社 ジェイオーディ');
ok($zip->set_number('4918509')->is_valid_number, '一宮公共職業安定所');
ok($zip->set_number('4918512')->is_valid_number, '株式会社 油伝商店');
ok($zip->set_number('4918513')->is_valid_number, 'ササキセルム 株式会社');
ok($zip->set_number('4918515')->is_valid_number, '株式会社 ファッションヤマグチ');
ok($zip->set_number('4918516')->is_valid_number, '株式会社 滝善');
ok($zip->set_number('4918523')->is_valid_number, '杉秀商事 株式会社');
ok($zip->set_number('4918526')->is_valid_number, '中日本高速道路 株式会社');
ok($zip->set_number('4918528')->is_valid_number, '株式会社 三昭堂');
ok($zip->set_number('4918531')->is_valid_number, '医療法人 山下病院');
ok($zip->set_number('4918532')->is_valid_number, '株式会社 カネスエ');
ok($zip->set_number('4918533')->is_valid_number, '県立一宮高校');
ok($zip->set_number('4918535')->is_valid_number, '株式会社 アバンセコーポレーション');
ok($zip->set_number('4918551')->is_valid_number, '医療法人 大雄会');
ok($zip->set_number('4918553')->is_valid_number, '株式会社 タナカふとんサービス');
ok($zip->set_number('4918555')->is_valid_number, 'ワシズ機械 株式会社');
ok($zip->set_number('4918558')->is_valid_number, '一宮市立市民病院');
ok($zip->set_number('4918561')->is_valid_number, '日本毛織 株式会社 一宮工場');
ok($zip->set_number('4918562')->is_valid_number, '大井田工業 株式会社');
ok($zip->set_number('4918571')->is_valid_number, '中部電力 株式会社 一宮営業所');
ok($zip->set_number('4918572')->is_valid_number, '株式会社 三愛鋼機');
ok($zip->set_number('4918575')->is_valid_number, '株式会社 中日尾張折込ホールディングス');
ok($zip->set_number('4918576')->is_valid_number, '松永 株式会社');
ok($zip->set_number('4918577')->is_valid_number, 'ユニー 一宮店');
ok($zip->set_number('4918585')->is_valid_number, '株式会社 名鉄百貨店 一宮店');
ok($zip->set_number('4918601')->is_valid_number, '株式会社 壱番屋');
ok($zip->set_number('4918608')->is_valid_number, '長大 株式会社');
ok($zip->set_number('4918610')->is_valid_number, 'モリリン 株式会社');
ok($zip->set_number('4918611')->is_valid_number, 'いちい信用金庫');
ok($zip->set_number('4918612')->is_valid_number, '中外国島 株式会社');
ok($zip->set_number('4918686')->is_valid_number, '一宮商工会議所');
ok($zip->set_number('4918688')->is_valid_number, '愛和産業 株式会社');
ok($zip->set_number('4928501')->is_valid_number, '東朋テクノロジー 株式会社');
ok($zip->set_number('4928502')->is_valid_number, 'ARC 株式会社');
ok($zip->set_number('4928510')->is_valid_number, '稲沢市民病院');
ok($zip->set_number('4928511')->is_valid_number, '株式会社 ダイドーリミテッド 稲沢工場');
ok($zip->set_number('4928512')->is_valid_number, '丸徳産業 株式会社');
ok($zip->set_number('4928513')->is_valid_number, '日軽産業 株式会社');
ok($zip->set_number('4928520')->is_valid_number, '名古屋文理短期大学');
ok($zip->set_number('4928521')->is_valid_number, '愛知文教女子短期大学');
ok($zip->set_number('4928523')->is_valid_number, '三菱東京UFJ銀行');
ok($zip->set_number('4928525')->is_valid_number, '稲沢商工会議所');
ok($zip->set_number('4928528')->is_valid_number, '愛松建設 株式会社');
ok($zip->set_number('4928529')->is_valid_number, '稲沢女子高等学校');
ok($zip->set_number('4928540')->is_valid_number, '豊田合成 株式会社 技術センター');
ok($zip->set_number('4928541')->is_valid_number, '豊田合成 株式会社 北島物流センター');
ok($zip->set_number('4928542')->is_valid_number, '豊田合成 株式会社 稲沢工場');
ok($zip->set_number('4928545')->is_valid_number, 'ソニー稲沢 株式会社');
ok($zip->set_number('4928546')->is_valid_number, '三和式ベンチレーター 株式会社');
ok($zip->set_number('4928547')->is_valid_number, 'イイダ産業 株式会社');
ok($zip->set_number('4928548')->is_valid_number, '中部抵抗器 株式会社');
ok($zip->set_number('4928601')->is_valid_number, 'ユニー 株式会社 リーフウォーク稲沢');
ok($zip->set_number('4928621')->is_valid_number, '株式会社 サカイナゴヤ');
ok($zip->set_number('4928622')->is_valid_number, '株式会社 中部日立エレクトリック');
ok($zip->set_number('4928628')->is_valid_number, '東新住建 株式会社');
ok($zip->set_number('4928646')->is_valid_number, '株式会社 ソーゴー');
ok($zip->set_number('4928651')->is_valid_number, 'ユニー 株式会社 アピタ稲沢東店');
ok($zip->set_number('4928680')->is_valid_number, 'ユニー 株式会社');
ok($zip->set_number('4928681')->is_valid_number, 'ユニー株式会社 アピタ稲沢店');
ok($zip->set_number('4928682')->is_valid_number, '三菱電機 株式会社 稲沢製作所');
ok($zip->set_number('4928683')->is_valid_number, '尾州ウール');
ok($zip->set_number('4928684')->is_valid_number, '尾州ウール');
ok($zip->set_number('4928685')->is_valid_number, 'サークルケイ・ジャパン (株)');
ok($zip->set_number('4928686')->is_valid_number, 'UCS');
ok($zip->set_number('4928687')->is_valid_number, '株式会社 ユーストア');
ok($zip->set_number('4948501')->is_valid_number, '株式会社 ソトー 本社');
ok($zip->set_number('4948502')->is_valid_number, '豊田合成 株式会社 尾西工場');
ok($zip->set_number('4948505')->is_valid_number, '尾西市民病院');
ok($zip->set_number('4948507')->is_valid_number, '栗原産業 株式会社');
ok($zip->set_number('4948511')->is_valid_number, '株式会社 山田ドビー');
ok($zip->set_number('4948516')->is_valid_number, '株式会社 ソトー 第二事業部');
ok($zip->set_number('4948518')->is_valid_number, '艶金興業 株式会社 起工場');
ok($zip->set_number('4948601')->is_valid_number, '一宮市役所 尾西庁舎');
ok($zip->set_number('4948611')->is_valid_number, '尾西信用金庫');
ok($zip->set_number('4948686')->is_valid_number, '加藤産業 株式会社 名古屋支店');
ok($zip->set_number('4958501')->is_valid_number, 'アイコクアルファ 株式会社');
ok($zip->set_number('4958505')->is_valid_number, '愛知県立 杏和高等学校');
ok($zip->set_number('4958510')->is_valid_number, '帝人テクロス 株式会社');
ok($zip->set_number('4958511')->is_valid_number, '稲沢市 祖父江支所');
ok($zip->set_number('4958517')->is_valid_number, '株式会社 コメットカトウ');
ok($zip->set_number('4958531')->is_valid_number, '愛知県 厚生連 尾西病院');
ok($zip->set_number('4958601')->is_valid_number, '王子板紙 株式会社 祖父江工場');
ok($zip->set_number('4968501')->is_valid_number, '義津屋 津島駅前店');
ok($zip->set_number('4968503')->is_valid_number, '株式会社 西日本宇佐美 東海支店');
ok($zip->set_number('4968508')->is_valid_number, '株式会社 前田');
ok($zip->set_number('4968531')->is_valid_number, '愛知県海部県民センター');
ok($zip->set_number('4968532')->is_valid_number, '愛知県 海部農林水産事務所');
ok($zip->set_number('4968533')->is_valid_number, '愛知県海部建設事務所');
ok($zip->set_number('4968534')->is_valid_number, '愛知県 海部教育事務所');
ok($zip->set_number('4968535')->is_valid_number, '愛知県海部福祉相談センター');
ok($zip->set_number('4968537')->is_valid_number, '津島市民病院');
ok($zip->set_number('4968555')->is_valid_number, '愛西市役所');
ok($zip->set_number('4968558')->is_valid_number, '津島商工会議所');
ok($zip->set_number('4968575')->is_valid_number, '(株) 中日ホームサービス');
ok($zip->set_number('4968585')->is_valid_number, '株式会社 ユーストア');
ok($zip->set_number('4968601')->is_valid_number, '愛西市役所 佐織庁舎');
ok($zip->set_number('4968633')->is_valid_number, '愛西市役所 立田庁舎');
ok($zip->set_number('4968639')->is_valid_number, '愛西市役所 八開庁舎');
ok($zip->set_number('4968648')->is_valid_number, '海部農協 八開支店');
ok($zip->set_number('4968686')->is_valid_number, '津島市役所');
ok($zip->set_number('4968720')->is_valid_number, '津島税務署');
ok($zip->set_number('4978501')->is_valid_number, '株式会社 加藤建設');
ok($zip->set_number('4978502')->is_valid_number, '株式会社 第一商事');
ok($zip->set_number('4978505')->is_valid_number, '七宝病院');
ok($zip->set_number('4978508')->is_valid_number, '株式会社 ヨシズヤ 蟹江店');
ok($zip->set_number('4978510')->is_valid_number, '株式会社 マツヤ');
ok($zip->set_number('4978511')->is_valid_number, '丸信製粉 株式会社');
ok($zip->set_number('4978512')->is_valid_number, '株式会社 エイビス');
ok($zip->set_number('4978520')->is_valid_number, '株式会社 ニッセン');
ok($zip->set_number('4978522')->is_valid_number, 'あま市役所 七宝庁舎');
ok($zip->set_number('4978527')->is_valid_number, '高梨産業 株式会社');
ok($zip->set_number('4978528')->is_valid_number, '海部中央病院');
ok($zip->set_number('4978530')->is_valid_number, '蟹江高等学校');
ok($zip->set_number('4978531')->is_valid_number, '株式会社 アンレット');
ok($zip->set_number('4978533')->is_valid_number, '加藤軽金属工業 株式会社');
ok($zip->set_number('4978541')->is_valid_number, 'NTN特殊合金 株式会社');
ok($zip->set_number('4978545')->is_valid_number, '株式会社 松岡');
ok($zip->set_number('4978548')->is_valid_number, '小山 株式会社');
ok($zip->set_number('4978601')->is_valid_number, '蟹江町役場');
ok($zip->set_number('4988501')->is_valid_number, '弥富市役所');
ok($zip->set_number('4988502')->is_valid_number, '愛知県厚生農業協同組合連合会 海南病院');
ok($zip->set_number('4988503')->is_valid_number, '木曽岬町役場');
ok($zip->set_number('4988505')->is_valid_number, '株式会社 川スミ');
ok($zip->set_number('5008501')->is_valid_number, '岐阜県警察本部');
ok($zip->set_number('5008502')->is_valid_number, '社団法人 岐阜県建設業協会');
ok($zip->set_number('5008504')->is_valid_number, '岐阜県音楽療法研究所');
ok($zip->set_number('5008505')->is_valid_number, '財団法人 岐阜県産業経済振興センター');
ok($zip->set_number('5008507')->is_valid_number, '岐阜県県民ふれあい会館');
ok($zip->set_number('5008508')->is_valid_number, '岐阜県市町村職員共済組合');
ok($zip->set_number('5008510')->is_valid_number, '社団法人 岐阜県医師会');
ok($zip->set_number('5008513')->is_valid_number, '岐阜市民病院');
ok($zip->set_number('5008515')->is_valid_number, 'シンガポール 株式会社');
ok($zip->set_number('5008518')->is_valid_number, '株式会社 市川工務店');
ok($zip->set_number('5008521')->is_valid_number, 'ハートフルスクエアG');
ok($zip->set_number('5008522')->is_valid_number, 'イギン 株式会社');
ok($zip->set_number('5008523')->is_valid_number, '朝日大学歯学部附属村上記念病院');
ok($zip->set_number('5008524')->is_valid_number, '住友生命保険 相互会社 岐阜支社');
ok($zip->set_number('5008525')->is_valid_number, '株式会社 高島屋 岐阜店');
ok($zip->set_number('5008530')->is_valid_number, '株式会社 エヌ・ティ・ティ・ドコモ東海 岐阜支店');
ok($zip->set_number('5008533')->is_valid_number, '東邦ガス 株式会社 岐阜営業所');
ok($zip->set_number('5008535')->is_valid_number, 'ラブリークィーン 株式会社');
ok($zip->set_number('5008540')->is_valid_number, '住友海上火災保険 株式会社 岐阜支店');
ok($zip->set_number('5008544')->is_valid_number, '吉岡 株式会社');
ok($zip->set_number('5008545')->is_valid_number, '商工組合中央金庫 岐阜支店');
ok($zip->set_number('5008550')->is_valid_number, '株式会社 篠田商会');
ok($zip->set_number('5008552')->is_valid_number, '日興コーディアル証券 株式会社 岐阜支店');
ok($zip->set_number('5008554')->is_valid_number, '日本放送協会 岐阜放送局');
ok($zip->set_number('5008555')->is_valid_number, '大日本土木 株式会社');
ok($zip->set_number('5008556')->is_valid_number, '株式会社 十六ディーシーカード');
ok($zip->set_number('5008557')->is_valid_number, '濃飛倉庫運輸 株式会社');
ok($zip->set_number('5008558')->is_valid_number, 'アピ 株式会社');
ok($zip->set_number('5008560')->is_valid_number, '日建産業 株式会社');
ok($zip->set_number('5008561')->is_valid_number, '株式会社 電算システム');
ok($zip->set_number('5008565')->is_valid_number, '株式会社 岐阜銀行');
ok($zip->set_number('5008566')->is_valid_number, '大和証券 株式会社 岐阜支店');
ok($zip->set_number('5008567')->is_valid_number, '岐阜南税務署');
ok($zip->set_number('5008570')->is_valid_number, '岐阜県庁');
ok($zip->set_number('5008577')->is_valid_number, '株式会社 岐阜新聞社');
ok($zip->set_number('5008588')->is_valid_number, '株式会社 岐阜放送');
ok($zip->set_number('5008601')->is_valid_number, '日本赤十字社 岐阜県支部');
ok($zip->set_number('5008602')->is_valid_number, '株式会社 岐阜魚介');
ok($zip->set_number('5008603')->is_valid_number, '岐果 岐阜青果 株式会社');
ok($zip->set_number('5008605')->is_valid_number, '日本ガード 株式会社');
ok($zip->set_number('5008607')->is_valid_number, '岐阜中央青果 株式会社');
ok($zip->set_number('5008610')->is_valid_number, '岐阜丸魚 株式会社');
ok($zip->set_number('5008615')->is_valid_number, '株式会社 田幸');
ok($zip->set_number('5008616')->is_valid_number, '小林薬品工業 株式会社');
ok($zip->set_number('5008620')->is_valid_number, '岐阜日野自動車 株式会社 岐阜支店');
ok($zip->set_number('5008621')->is_valid_number, '山彦鋼管 株式会社');
ok($zip->set_number('5008622')->is_valid_number, 'サンラリー 株式会社');
ok($zip->set_number('5008625')->is_valid_number, '富士ゼロックス岐阜 株式会社');
ok($zip->set_number('5008630')->is_valid_number, '株式会社 ヒマラヤ');
ok($zip->set_number('5008635')->is_valid_number, '濃尾電機 株式会社');
ok($zip->set_number('5008636')->is_valid_number, '大和ハウス工業 株式会社 岐阜支店');
ok($zip->set_number('5008637')->is_valid_number, 'トヨタカローラ岐阜 株式会社');
ok($zip->set_number('5008638')->is_valid_number, '株式会社 安部日鋼工業');
ok($zip->set_number('5008639')->is_valid_number, '資生堂化粧品販売 株式会社 岐阜支社');
ok($zip->set_number('5008640')->is_valid_number, '株式会社 スギトー');
ok($zip->set_number('5008645')->is_valid_number, '内藤建設 株式会社');
ok($zip->set_number('5008646')->is_valid_number, '株式会社 マキムラ');
ok($zip->set_number('5008648')->is_valid_number, '株式会社 小林三之助商店');
ok($zip->set_number('5008650')->is_valid_number, '株式会社 ヤマニパッケージ');
ok($zip->set_number('5008651')->is_valid_number, 'YKKファスニングプロダクツ販売 株式会社');
ok($zip->set_number('5008655')->is_valid_number, '二幸 株式会社');
ok($zip->set_number('5008657')->is_valid_number, '株式会社 キタガワ');
ok($zip->set_number('5008660')->is_valid_number, '株式会社 若原工機');
ok($zip->set_number('5008666')->is_valid_number, '日本興亜損害保険 株式会社 岐阜支店');
ok($zip->set_number('5008667')->is_valid_number, '全国健康保険協会 岐阜支部');
ok($zip->set_number('5008668')->is_valid_number, '丸杉建設 株式会社');
ok($zip->set_number('5008670')->is_valid_number, '日動火災海上保険 株式会社 岐阜支店');
ok($zip->set_number('5008671')->is_valid_number, '東京海上日動火災保険 株式会社 岐阜支店');
ok($zip->set_number('5008672')->is_valid_number, '荒井 株式会社');
ok($zip->set_number('5008676')->is_valid_number, '日産プリンス 岐阜販売 株式会社');
ok($zip->set_number('5008677')->is_valid_number, 'ヒロタ 株式会社');
ok($zip->set_number('5008678')->is_valid_number, '石田 株式会社');
ok($zip->set_number('5008680')->is_valid_number, '日本通運 株式会社 岐阜支店');
ok($zip->set_number('5008681')->is_valid_number, '日通商事 株式会社 岐阜支店');
ok($zip->set_number('5008682')->is_valid_number, '松久 株式会社');
ok($zip->set_number('5008685')->is_valid_number, '株式会社 損害保険ジャパン');
ok($zip->set_number('5008686')->is_valid_number, '株式会社 マンチェス');
ok($zip->set_number('5008687')->is_valid_number, '井上精機 株式会社');
ok($zip->set_number('5008689')->is_valid_number, '梅本 株式会社');
ok($zip->set_number('5008701')->is_valid_number, '岐阜市役所');
ok($zip->set_number('5008702')->is_valid_number, '中部電力 株式会社 岐阜営業所');
ok($zip->set_number('5008703')->is_valid_number, '昭和コンクリート工業 株式会社');
ok($zip->set_number('5008707')->is_valid_number, '中部電力 株式会社 岐阜支店');
ok($zip->set_number('5008708')->is_valid_number, '岐阜振興局');
ok($zip->set_number('5008710')->is_valid_number, '岐阜地方裁判所');
ok($zip->set_number('5008711')->is_valid_number, '岐阜北税務署');
ok($zip->set_number('5008715')->is_valid_number, '西日本電信電話 株式会社');
ok($zip->set_number('5008716')->is_valid_number, '財務省 東海財務局 岐阜財務事務所');
ok($zip->set_number('5008717')->is_valid_number, '岐阜県立岐阜病院');
ok($zip->set_number('5008718')->is_valid_number, '国立療養所岐阜病院');
ok($zip->set_number('5008720')->is_valid_number, '岐阜市役所 南庁舎');
ok($zip->set_number('5008721')->is_valid_number, '岐阜プラスチック工業 株式会社');
ok($zip->set_number('5008722')->is_valid_number, '岐阜乗合自動車 株式会社');
ok($zip->set_number('5008725')->is_valid_number, '日本信販岐阜 株式会社');
ok($zip->set_number('5008727')->is_valid_number, '岐阜商工会議所');
ok($zip->set_number('5008728')->is_valid_number, '株式会社 パルコ 岐阜店');
ok($zip->set_number('5008729')->is_valid_number, '岐阜地方法務局');
ok($zip->set_number('5008730')->is_valid_number, '株式会社 新岐阜百貨店');
ok($zip->set_number('5008731')->is_valid_number, 'オンダ国際特許事務所');
ok($zip->set_number('5008732')->is_valid_number, '財団法人 岐阜県教職員互助会');
ok($zip->set_number('5008733')->is_valid_number, '丸丹 株式会社');
ok($zip->set_number('5008734')->is_valid_number, '岐阜観光索道 株式会社');
ok($zip->set_number('5008737')->is_valid_number, 'シーシーエヌ (株)');
ok($zip->set_number('5008740')->is_valid_number, '岐阜県 社会保険診療報酬支払基金');
ok($zip->set_number('5008741')->is_valid_number, '済美高等学校');
ok($zip->set_number('5008742')->is_valid_number, '株式会社 藤田商店');
ok($zip->set_number('5008743')->is_valid_number, '株式会社 岡本');
ok($zip->set_number('5008748')->is_valid_number, '株式会社 丸杉');
ok($zip->set_number('5008750')->is_valid_number, '岐阜県労働金庫');
ok($zip->set_number('5008751')->is_valid_number, '株式会社 日本タクシー');
ok($zip->set_number('5008752')->is_valid_number, '安田 株式会社');
ok($zip->set_number('5008753')->is_valid_number, '株式会社 ニツショー 岐阜支店');
ok($zip->set_number('5008755')->is_valid_number, '株式会社 ダイテックソリューション');
ok($zip->set_number('5008765')->is_valid_number, '学校法人 富田学園');
ok($zip->set_number('5010192')->is_valid_number, '岐阜市立女子短期大学');
ok($zip->set_number('5010292')->is_valid_number, '西濃信用金庫 本部');
ok($zip->set_number('5010293')->is_valid_number, '瑞穂市役所');
ok($zip->set_number('5010294')->is_valid_number, '三甲 株式会社');
ok($zip->set_number('5010295')->is_valid_number, 'ヤナゲン FAL店');
ok($zip->set_number('5010296')->is_valid_number, '朝日大学');
ok($zip->set_number('5010392')->is_valid_number, '瑞穂市役所 巣南庁舎');
ok($zip->set_number('5010492')->is_valid_number, '北方町役場');
ok($zip->set_number('5010493')->is_valid_number, '本巣市役所 糸貫分庁舎');
ok($zip->set_number('5010494')->is_valid_number, '本巣市役所 真正分庁舎');
ok($zip->set_number('5010495')->is_valid_number, '岐阜工業高等専門学校');
ok($zip->set_number('5010496')->is_valid_number, '魚供養観音菩薩円境寺事務局');
ok($zip->set_number('5010497')->is_valid_number, 'モレラ岐阜');
ok($zip->set_number('5010498')->is_valid_number, 'レシップ 株式会社');
ok($zip->set_number('5010592')->is_valid_number, '大野町役場');
ok($zip->set_number('5010692')->is_valid_number, '揖斐川町役場');
ok($zip->set_number('5010693')->is_valid_number, 'いび川 農業協同組合 本店');
ok($zip->set_number('5010694')->is_valid_number, '西建産業 株式会社');
ok($zip->set_number('5010695')->is_valid_number, 'イビデン 株式会社 大垣北工場');
ok($zip->set_number('5010696')->is_valid_number, '揖斐厚生病院');
ok($zip->set_number('5010697')->is_valid_number, '西濃建設 株式会社');
ok($zip->set_number('5010797')->is_valid_number, '揖斐川町役場 久瀬振興事務所');
ok($zip->set_number('5010798')->is_valid_number, '株式会社 ヤマモト');
ok($zip->set_number('5011192')->is_valid_number, '医療法人社団 誠広会 平野総合病院');
ok($zip->set_number('5011193')->is_valid_number, '岐阜大学');
ok($zip->set_number('5011194')->is_valid_number, '岐阜大学 医学部');
ok($zip->set_number('5011195')->is_valid_number, '株式会社 KVK');
ok($zip->set_number('5011196')->is_valid_number, '岐阜薬科大学');
ok($zip->set_number('5011196')->is_valid_number, '岐阜薬科大学 本部');
ok($zip->set_number('5011198')->is_valid_number, '岐阜中央病院');
ok($zip->set_number('5011292')->is_valid_number, '本巣市役所');
ok($zip->set_number('5011392')->is_valid_number, '揖斐川町谷汲振興事務所');
ok($zip->set_number('5011592')->is_valid_number, '本巣市役所 根尾総合支庁');
ok($zip->set_number('5012192')->is_valid_number, '山県市役所');
ok($zip->set_number('5012292')->is_valid_number, '喜多村合金製作所 株式会社');
ok($zip->set_number('5012592')->is_valid_number, '岐阜女子大学');
ok($zip->set_number('5012695')->is_valid_number, '関市武芸川事務所');
ok($zip->set_number('5012697')->is_valid_number, '株式会社 ナガセインテグレックス');
ok($zip->set_number('5012698')->is_valid_number, '東海理研 株式会社');
ok($zip->set_number('5012892')->is_valid_number, '関市役所 洞戸事務所');
ok($zip->set_number('5013293')->is_valid_number, '関税務署');
ok($zip->set_number('5013295')->is_valid_number, 'トーヨーキッチンアンドリビング 株式会社');
ok($zip->set_number('5013296')->is_valid_number, 'サンサンシティマーゴ');
ok($zip->set_number('5013392')->is_valid_number, '岐阜県加茂郡富加町役場');
ok($zip->set_number('5013393')->is_valid_number, '(株) 喜多村合金製作所 富加工場');
ok($zip->set_number('5013395')->is_valid_number, '野田産業 株式会社');
ok($zip->set_number('5013792')->is_valid_number, '美濃市役所');
ok($zip->set_number('5013892')->is_valid_number, '岐阜医療科学大学 岐阜医療技術科学短期大学');
ok($zip->set_number('5013893')->is_valid_number, '関信用金庫');
ok($zip->set_number('5013894')->is_valid_number, '関市役所');
ok($zip->set_number('5013992')->is_valid_number, 'カイインダストリーズ 株式会社');
ok($zip->set_number('5013993')->is_valid_number, '中部学院大学 中部学院大学短期大学部');
ok($zip->set_number('5013994')->is_valid_number, '(株) マサヒロ');
ok($zip->set_number('5013998')->is_valid_number, '中部学院大学 通信教育部');
ok($zip->set_number('5014192')->is_valid_number, '郡上市 美並地域振興事務所');
ok($zip->set_number('5014193')->is_valid_number, '慈恵中央病院');
ok($zip->set_number('5014292')->is_valid_number, '郡上総合庁舎');
ok($zip->set_number('5014297')->is_valid_number, '郡上市役所');
ok($zip->set_number('5014298')->is_valid_number, '八幡信用金庫');
ok($zip->set_number('5014592')->is_valid_number, '郡上市和良地域振興事務所');
ok($zip->set_number('5014595')->is_valid_number, '郡上市国保和良病院');
ok($zip->set_number('5015192')->is_valid_number, '郡上市白鳥地域振興事務所');
ok($zip->set_number('5015393')->is_valid_number, '郡上市高鷲地域振興事務所');
ok($zip->set_number('5015492')->is_valid_number, '高山市 荘川支所');
ok($zip->set_number('5015692')->is_valid_number, '白川村役場');
ok($zip->set_number('5016180')->is_valid_number, '岐阜市 柳津地域振興事務所');
ok($zip->set_number('5016181')->is_valid_number, '笠松町役場');
ok($zip->set_number('5016192')->is_valid_number, '岐阜県自動車税事務所');
ok($zip->set_number('5016193')->is_valid_number, 'ジーエフシー 株式会社');
ok($zip->set_number('5016194')->is_valid_number, '岐阜聖徳学園大学');
ok($zip->set_number('5016195')->is_valid_number, 'エーザイ 株式会社 川島工園');
ok($zip->set_number('5016196')->is_valid_number, '株式会社 電算システム');
ok($zip->set_number('5016197')->is_valid_number, '岐南町役場');
ok($zip->set_number('5016198')->is_valid_number, '各務原市 川島振興事務所');
ok($zip->set_number('5016292')->is_valid_number, '羽島市役所');
ok($zip->set_number('5016293')->is_valid_number, '丸栄コンクリート工業 株式会社');
ok($zip->set_number('5016295')->is_valid_number, '岐阜県立 看護大学');
ok($zip->set_number('5016296')->is_valid_number, '岩仲毛織 株式会社');
ok($zip->set_number('5016297')->is_valid_number, '株式会社 文溪堂');
ok($zip->set_number('5028501')->is_valid_number, 'カワボウ 株式会社');
ok($zip->set_number('5028511')->is_valid_number, '岐阜赤十字病院');
ok($zip->set_number('5028521')->is_valid_number, 'カワボウ 株式会社');
ok($zip->set_number('5028558')->is_valid_number, '独立行政法人国立病院機構長良医療センター');
ok($zip->set_number('5028567')->is_valid_number, '株式会社 岐阜グランドホテル');
ok($zip->set_number('5028792')->is_valid_number, '岐阜サービスセンター');
ok($zip->set_number('5030192')->is_valid_number, '大垣市 墨俣地域事務所');
ok($zip->set_number('5030195')->is_valid_number, '三洋電機 株式会社');
ok($zip->set_number('5030198')->is_valid_number, '安八町役場');
ok($zip->set_number('5030292')->is_valid_number, '輪之内町役場');
ok($zip->set_number('5030295')->is_valid_number, '未来工業 株式会社');
ok($zip->set_number('5030296')->is_valid_number, '株式会社 ワイ・ヨット');
ok($zip->set_number('5030392')->is_valid_number, '海津市役所 平田庁舎');
ok($zip->set_number('5030495')->is_valid_number, '海津市役所南濃庁舎');
ok($zip->set_number('5030695')->is_valid_number, '海津市役所');
ok($zip->set_number('5031392')->is_valid_number, '養老町役場');
ok($zip->set_number('5031393')->is_valid_number, '玉泉堂酒造 株式会社');
ok($zip->set_number('5031394')->is_valid_number, '西美濃厚生病院');
ok($zip->set_number('5031395')->is_valid_number, '藤井ハウス産業 株式会社');
ok($zip->set_number('5031396')->is_valid_number, '佐竹鉄工 株式会社');
ok($zip->set_number('5031592')->is_valid_number, '関ケ原町役場');
ok($zip->set_number('5031593')->is_valid_number, '株式会社 関ケ原製作所');
ok($zip->set_number('5031595')->is_valid_number, '関ケ原石材 株式会社');
ok($zip->set_number('5032192')->is_valid_number, 'ティーエスコーポレーション 株式会社 岐阜第一工場');
ok($zip->set_number('5032193')->is_valid_number, '垂井町役場');
ok($zip->set_number('5032392')->is_valid_number, '神戸町役場');
ok($zip->set_number('5032393')->is_valid_number, 'コダマ樹脂工業 株式会社');
ok($zip->set_number('5032394')->is_valid_number, '三菱マテリアル 株式会社 岐阜製作所');
ok($zip->set_number('5032395')->is_valid_number, '東レ 株式会社 岐阜工場');
ok($zip->set_number('5032396')->is_valid_number, '丸山工業 株式会社');
ok($zip->set_number('5032397')->is_valid_number, '太平洋工業 株式会社 北大垣工場');
ok($zip->set_number('5032492')->is_valid_number, '池田町役場');
ok($zip->set_number('5032493')->is_valid_number, '平和教会');
ok($zip->set_number('5032494')->is_valid_number, 'タニサケ (株)');
ok($zip->set_number('5032495')->is_valid_number, '岐阜県立 池田高等学校');
ok($zip->set_number('5038501')->is_valid_number, '西濃運輸 株式会社');
ok($zip->set_number('5038502')->is_valid_number, '大垣市民病院');
ok($zip->set_number('5038503')->is_valid_number, 'イビデン 株式会社');
ok($zip->set_number('5038504')->is_valid_number, '日本合成');
ok($zip->set_number('5038505')->is_valid_number, '神鋼造機');
ok($zip->set_number('5038506')->is_valid_number, '日本耐酸壜工業 株式会社');
ok($zip->set_number('5038507')->is_valid_number, '大垣扶桑紡績 株式会社');
ok($zip->set_number('5038508')->is_valid_number, '株式会社 デリカスイト');
ok($zip->set_number('5038509')->is_valid_number, '株式会社 セイノー商事');
ok($zip->set_number('5038510')->is_valid_number, '株式会社 丸順');
ok($zip->set_number('5038511')->is_valid_number, '日本合成化学工業(株)大垣事業所大垣フイルム工場');
ok($zip->set_number('5038512')->is_valid_number, 'セイノー情報サービス');
ok($zip->set_number('5038513')->is_valid_number, '大垣機工');
ok($zip->set_number('5038514')->is_valid_number, '株式会社 川口屋スーパーチェン');
ok($zip->set_number('5038515')->is_valid_number, '大丸松下食品 株式会社');
ok($zip->set_number('5038516')->is_valid_number, '(株)宇佐美組');
ok($zip->set_number('5038517')->is_valid_number, '大光');
ok($zip->set_number('5038518')->is_valid_number, 'サンメッセ 株式会社');
ok($zip->set_number('5038519')->is_valid_number, '太平洋精工');
ok($zip->set_number('5038520')->is_valid_number, '大垣西高等学校');
ok($zip->set_number('5038521')->is_valid_number, '大垣工業高等学校');
ok($zip->set_number('5038522')->is_valid_number, '大垣南高等学校');
ok($zip->set_number('5038523')->is_valid_number, '(株) 平和堂東海 鶴見店');
ok($zip->set_number('5038550')->is_valid_number, '岐阜経済大学');
ok($zip->set_number('5038552')->is_valid_number, '揖斐川工業 株式会社');
ok($zip->set_number('5038553')->is_valid_number, '株式会社 吉田ハム');
ok($zip->set_number('5038554')->is_valid_number, '大垣女子短期大学');
ok($zip->set_number('5038556')->is_valid_number, '大垣税務署');
ok($zip->set_number('5038557')->is_valid_number, '日電精密工業 株式会社');
ok($zip->set_number('5038558')->is_valid_number, 'ヤナゲン');
ok($zip->set_number('5038559')->is_valid_number, 'イビデン 株式会社 河間工場');
ok($zip->set_number('5038560')->is_valid_number, 'イビデングリーンテック 株式会社');
ok($zip->set_number('5038561')->is_valid_number, 'イビケン 株式会社');
ok($zip->set_number('5038562')->is_valid_number, '株式会社 大垣村田製作所');
ok($zip->set_number('5038564')->is_valid_number, 'オーミケンシ 株式会社 大垣工場');
ok($zip->set_number('5038565')->is_valid_number, '大垣商工会議所');
ok($zip->set_number('5038566')->is_valid_number, 'NTT 大垣営業所');
ok($zip->set_number('5038567')->is_valid_number, 'スイトピアセンター');
ok($zip->set_number('5038568')->is_valid_number, '大垣ステーションビル アピオ');
ok($zip->set_number('5038569')->is_valid_number, '財団法人 ソフトピアジャパン');
ok($zip->set_number('5038570')->is_valid_number, 'ユニー 株式会社 アピタ大垣店');
ok($zip->set_number('5038571')->is_valid_number, 'ユニー 株式会社 アクアウォーク大垣');
ok($zip->set_number('5038601')->is_valid_number, '大垣市役所');
ok($zip->set_number('5038603')->is_valid_number, '太平洋工業 株式会社');
ok($zip->set_number('5038604')->is_valid_number, 'イビデン 株式会社');
ok($zip->set_number('5048501')->is_valid_number, '岐阜県立 岐阜各務野高等学 校岐女商校舎');
ok($zip->set_number('5048504')->is_valid_number, '東海女子短期大学');
ok($zip->set_number('5048511')->is_valid_number, '東海女子大学');
ok($zip->set_number('5048545')->is_valid_number, '各務原西高校');
ok($zip->set_number('5048551')->is_valid_number, '榎本ビーエー 株式会社');
ok($zip->set_number('5048555')->is_valid_number, '各務原市役所');
ok($zip->set_number('5048585')->is_valid_number, '各務原高校');
ok($zip->set_number('5048601')->is_valid_number, '公立学校共済組合 東海中央病院');
ok($zip->set_number('5048642')->is_valid_number, '天龍ホールディングス 株式会社');
ok($zip->set_number('5048701')->is_valid_number, '航空自衛隊');
ok($zip->set_number('5048702')->is_valid_number, '岐阜プラスチック工業 (株) 生産本部');
ok($zip->set_number('5048710')->is_valid_number, '川崎重工業 株式会社');
ok($zip->set_number('5050392')->is_valid_number, '八百津町役場');
ok($zip->set_number('5058501')->is_valid_number, '坂祝町役場');
ok($zip->set_number('5058503')->is_valid_number, '医療法人厚生会 木沢記念病院');
ok($zip->set_number('5058505')->is_valid_number, 'パジェロ製造 株式会社');
ok($zip->set_number('5058508')->is_valid_number, '可茂総合庁舎');
ok($zip->set_number('5058606')->is_valid_number, '美濃加茂市役所');
ok($zip->set_number('5060192')->is_valid_number, '高山市役所 清見支所');
ok($zip->set_number('5060194')->is_valid_number, 'オーク・ヴィレッジ (株)');
ok($zip->set_number('5061195')->is_valid_number, '飛騨市 神岡振興事務所');
ok($zip->set_number('5061196')->is_valid_number, '神岡鉱業 株式会社');
ok($zip->set_number('5061392')->is_valid_number, '高山市 上宝支所');
ok($zip->set_number('5061492')->is_valid_number, '奥飛騨ガーデンホテル本陣');
ok($zip->set_number('5061493')->is_valid_number, '穂高荘山のホテル');
ok($zip->set_number('5061495')->is_valid_number, '(有) 岡田旅館');
ok($zip->set_number('5061496')->is_valid_number, '株式会社 飛騨湯の花本舗');
ok($zip->set_number('5061498')->is_valid_number, 'ホテル平湯館');
ok($zip->set_number('5062192')->is_valid_number, '高山市丹生川支所');
ok($zip->set_number('5068502')->is_valid_number, '久美愛 厚生病院');
ok($zip->set_number('5068506')->is_valid_number, '飛騨運輸 株式会社');
ok($zip->set_number('5068550')->is_valid_number, '高山赤十字病院');
ok($zip->set_number('5068555')->is_valid_number, '高山市役所');
ok($zip->set_number('5068577')->is_valid_number, '高山短期大学');
ok($zip->set_number('5068585')->is_valid_number, '柏木工 株式会社');
ok($zip->set_number('5068601')->is_valid_number, '高山 税務署');
ok($zip->set_number('5068603')->is_valid_number, '飛騨農業協同組合');
ok($zip->set_number('5068666')->is_valid_number, '高山信用金庫');
ok($zip->set_number('5068678')->is_valid_number, '高山商工会議所');
ok($zip->set_number('5068686')->is_valid_number, '飛騨産業 株式会社');
ok($zip->set_number('5068687')->is_valid_number, '飛騨産業 株式会社 本社工場');
ok($zip->set_number('5068688')->is_valid_number, '飛騨県事務所');
ok($zip->set_number('5078511')->is_valid_number, '社会医療法人厚生会 多治見市民病院');
ok($zip->set_number('5078522')->is_valid_number, '岐阜県立多治見病院');
ok($zip->set_number('5078523')->is_valid_number, '太陽社電気 株式会社');
ok($zip->set_number('5078527')->is_valid_number, '中部電力 株式会社 多治見電力所');
ok($zip->set_number('5078533')->is_valid_number, '株式会社 三菱東京UFJ銀行 多治見支店');
ok($zip->set_number('5078561')->is_valid_number, '株式会社 アンシア');
ok($zip->set_number('5078601')->is_valid_number, '株式会社 バロー');
ok($zip->set_number('5078602')->is_valid_number, '美濃包材 株式会社');
ok($zip->set_number('5078603')->is_valid_number, '産業文化センター 指定管理者 株式会社');
ok($zip->set_number('5078605')->is_valid_number, '岐阜県立多治見工業高等学校');
ok($zip->set_number('5078607')->is_valid_number, '株式会社 T Y K');
ok($zip->set_number('5078608')->is_valid_number, '多治見商工会議所');
ok($zip->set_number('5078650')->is_valid_number, '多治見市役所 笠原庁舎');
ok($zip->set_number('5078701')->is_valid_number, '前畑陶器 株式会社');
ok($zip->set_number('5078702')->is_valid_number, '東濃信用金庫');
ok($zip->set_number('5078703')->is_valid_number, '多治見市役所');
ok($zip->set_number('5078705')->is_valid_number, '協同組合 日本陶芸チェーン');
ok($zip->set_number('5078706')->is_valid_number, '多治見税務署');
ok($zip->set_number('5078708')->is_valid_number, '東濃西部総合庁舎');
ok($zip->set_number('5080292')->is_valid_number, '中津川市 福岡総合事務所');
ok($zip->set_number('5080494')->is_valid_number, '中津川市 加子母総合事務所');
ok($zip->set_number('5088500')->is_valid_number, '北恵那交通 (株)');
ok($zip->set_number('5088501')->is_valid_number, '中津川市役所');
ok($zip->set_number('5088502')->is_valid_number, '総合病院中津川市民病院');
ok($zip->set_number('5088511')->is_valid_number, '株式会社 吉川工務店');
ok($zip->set_number('5088555')->is_valid_number, '株式会社 トキワ');
ok($zip->set_number('5088585')->is_valid_number, '中央板紙 株式会社');
ok($zip->set_number('5088611')->is_valid_number, '中津川税務署');
ok($zip->set_number('5088666')->is_valid_number, '三菱電機 株式会社 中津川製作所');
ok($zip->set_number('5088686')->is_valid_number, '王子製紙 株式会社 中津川工場');
ok($zip->set_number('5090192')->is_valid_number, '岐阜車体工業 株式会社');
ok($zip->set_number('5090197')->is_valid_number, '生活協同組合コープぎふ');
ok($zip->set_number('5090198')->is_valid_number, '(株) 八幡ねじ H・I事業部');
ok($zip->set_number('5090292')->is_valid_number, '可児市役所');
ok($zip->set_number('5090295')->is_valid_number, '名古屋パルプ 株式会社');
ok($zip->set_number('5090296')->is_valid_number, 'FM でんでん');
ok($zip->set_number('5090297')->is_valid_number, 'カヤバ工業 株式会社 岐阜南工場');
ok($zip->set_number('5090298')->is_valid_number, 'カヤバ工業 株式会社 岐阜北工場');
ok($zip->set_number('5090393')->is_valid_number, '川辺町役場');
ok($zip->set_number('5090492')->is_valid_number, '七宗町役場');
ok($zip->set_number('5091192')->is_valid_number, '白川町役場');
ok($zip->set_number('5091193')->is_valid_number, '白川観光開発 株式会社');
ok($zip->set_number('5091392')->is_valid_number, '東白川村役場');
ok($zip->set_number('5091393')->is_valid_number, '東白川村国民健康保険病院');
ok($zip->set_number('5091394')->is_valid_number, '株式会社 岐阜部品');
ok($zip->set_number('5091395')->is_valid_number, '株式会社 ふるさと企画');
ok($zip->set_number('5091396')->is_valid_number, '株式会社 白川物産');
ok($zip->set_number('5091492')->is_valid_number, '(株) ますぶち園');
ok($zip->set_number('5091692')->is_valid_number, '株式会社 マツオカ');
ok($zip->set_number('5091693')->is_valid_number, '下呂市立金山病院');
ok($zip->set_number('5091695')->is_valid_number, '下呂市役所 金山振興事務所');
ok($zip->set_number('5092292')->is_valid_number, '岐阜県立 下呂温泉病院');
ok($zip->set_number('5092293')->is_valid_number, '株式会社 ハウテック');
ok($zip->set_number('5092295')->is_valid_number, '下呂市役所');
ok($zip->set_number('5092592')->is_valid_number, '岐阜県 下呂総合庁舎');
ok($zip->set_number('5092593')->is_valid_number, '岐阜県立 益田清風高等学校');
ok($zip->set_number('5092595')->is_valid_number, '下呂市役所 萩原庁舎');
ok($zip->set_number('5092598')->is_valid_number, '金子工業 株式会社');
ok($zip->set_number('5093195')->is_valid_number, '下呂市役所 小坂振興事務所');
ok($zip->set_number('5093292')->is_valid_number, '高山市 久々野支所');
ok($zip->set_number('5094192')->is_valid_number, '高山市 国府支所');
ok($zip->set_number('5094292')->is_valid_number, '飛騨市役所');
ok($zip->set_number('5094392')->is_valid_number, '飛騨市 河合振興事務所');
ok($zip->set_number('5095192')->is_valid_number, '土岐市役所');
ok($zip->set_number('5095193')->is_valid_number, '土岐市立総合病院');
ok($zip->set_number('5095195')->is_valid_number, '協同組合 王将チェーン');
ok($zip->set_number('5095198')->is_valid_number, '株式会社 丸辰');
ok($zip->set_number('5095292')->is_valid_number, '核融合科学研究所');
ok($zip->set_number('5096192')->is_valid_number, '中京短期大学');
ok($zip->set_number('5096193')->is_valid_number, '廣池学園');
ok($zip->set_number('5096194')->is_valid_number, '財団法人 モラロジー研究所');
ok($zip->set_number('5096195')->is_valid_number, '瑞浪市役所');
ok($zip->set_number('5096196')->is_valid_number, '瑞浪高等学校');
ok($zip->set_number('5097292')->is_valid_number, '恵那市役所');
ok($zip->set_number('5097492')->is_valid_number, '恵那市岩村振興事務所');
ok($zip->set_number('5097493')->is_valid_number, '岩村高等学校');
ok($zip->set_number('5097592')->is_valid_number, '恵那市上矢作振興事務所');
ok($zip->set_number('5097692')->is_valid_number, '恵那市役所山岡振興事務所');
ok($zip->set_number('5097693')->is_valid_number, '国土交通省 中部地方整備局 小里川ダム管理所');
ok($zip->set_number('5097792')->is_valid_number, '恵那市明智振興事務所');
ok($zip->set_number('5097793')->is_valid_number, '岐阜県立 恵那南高等学校');
ok($zip->set_number('5097795')->is_valid_number, '明智セラミックス 株式会社');
ok($zip->set_number('5097797')->is_valid_number, '株式会社 富士カントリー明智ゴルフ倶楽部');
ok($zip->set_number('5097892')->is_valid_number, '恵那市串原振興事務所');
ok($zip->set_number('5098392')->is_valid_number, '蛭川総合事務所');
ok($zip->set_number('5099192')->is_valid_number, '恵那峡パークカントリークラブ');
ok($zip->set_number('5099195')->is_valid_number, '中京学院大学');
ok($zip->set_number('5099292')->is_valid_number, '中津川市 坂下総合事務所');
ok($zip->set_number('5099293')->is_valid_number, '国民健康保険 坂下病院');
ok($zip->set_number('5099295')->is_valid_number, '中津川市川上総合事務所');
ok($zip->set_number('5099296')->is_valid_number, '株式会社 高峰楽器製作所');
ok($zip->set_number('5099298')->is_valid_number, 'ヤマコー (株)');
ok($zip->set_number('5100192')->is_valid_number, '四日市市 楠総合支所');
ok($zip->set_number('5100292')->is_valid_number, '株式会社 ケーブルネット鈴鹿');
ok($zip->set_number('5100293')->is_valid_number, '鈴鹿医療科学大学');
ok($zip->set_number('5100294')->is_valid_number, '鈴鹿工業高等専門学校');
ok($zip->set_number('5100295')->is_valid_number, 'モビリティランド 鈴鹿サーキット');
ok($zip->set_number('5100298')->is_valid_number, '鈴鹿国際大学');
ok($zip->set_number('5100392')->is_valid_number, '津市 河芸総合支所');
ok($zip->set_number('5101292')->is_valid_number, '菰野町役場');
ok($zip->set_number('5108503')->is_valid_number, '住友電装 株式会社');
ok($zip->set_number('5108504')->is_valid_number, 'ドッグイヤー');
ok($zip->set_number('5108505')->is_valid_number, 'コスモ石油サービス 株式会社 三重カンパニー');
ok($zip->set_number('5108506')->is_valid_number, 'エフエムよっかいち 株式会社');
ok($zip->set_number('5108510')->is_valid_number, '三重県立 四日市高等学校');
ok($zip->set_number('5108511')->is_valid_number, '三重県四日市庁舎');
ok($zip->set_number('5108512')->is_valid_number, 'ささがわ通り心・身クリニック');
ok($zip->set_number('5108515')->is_valid_number, '東京海上日動火災保険 株式会社');
ok($zip->set_number('5108520')->is_valid_number, '出入国手続センター三重');
ok($zip->set_number('5108522')->is_valid_number, '朝日町役場');
ok($zip->set_number('5108525')->is_valid_number, '株式会社 扇港電機');
ok($zip->set_number('5108530')->is_valid_number, '三菱化学 株式会社 四日市事業所');
ok($zip->set_number('5108540')->is_valid_number, '東ソー 株式会社 四日市事業所');
ok($zip->set_number('5108550')->is_valid_number, '三重三菱自動車販売 株式会社');
ok($zip->set_number('5108552')->is_valid_number, 'JSR 株式会社 四日市工場');
ok($zip->set_number('5108555')->is_valid_number, 'トヨタカローラ三重 株式会社');
ok($zip->set_number('5108557')->is_valid_number, '四日市税務署');
ok($zip->set_number('5108560')->is_valid_number, '松下電工 株式会社 四日市工場');
ok($zip->set_number('5108561')->is_valid_number, '三重県立 総合医療センター');
ok($zip->set_number('5108562')->is_valid_number, '三重県立 四日市南高等学校');
ok($zip->set_number('5108567')->is_valid_number, '市立四日市病院');
ok($zip->set_number('5108575')->is_valid_number, '四日市日永病院');
ok($zip->set_number('5108577')->is_valid_number, '株式会社 オリエントコーポレーション 四日市支店');
ok($zip->set_number('5108580')->is_valid_number, '太陽化学 株式会社');
ok($zip->set_number('5108585')->is_valid_number, '株式会社 中部近鉄百貨店 四日市店');
ok($zip->set_number('5108588')->is_valid_number, '川越町役場');
ok($zip->set_number('5108601')->is_valid_number, '四日市市役所');
ok($zip->set_number('5108604')->is_valid_number, '野村証券 (株) 四日市支店');
ok($zip->set_number('5108605')->is_valid_number, '伊勢湾倉庫 株式会社');
ok($zip->set_number('5108615')->is_valid_number, '百五リース 株式会社 四日市支店');
ok($zip->set_number('5108616')->is_valid_number, '百五銀行 四日市支店');
ok($zip->set_number('5108621')->is_valid_number, '第一信販 株式会社');
ok($zip->set_number('5108631')->is_valid_number, '富士電機リテイルシステムズ 株式会社 三重工場');
ok($zip->set_number('5108642')->is_valid_number, '商工組合 中央金庫 四日市支店');
ok($zip->set_number('5108651')->is_valid_number, '日本トランスシティ 株式会社');
ok($zip->set_number('5108655')->is_valid_number, '株式会社 みずほ銀行 四日市支店');
ok($zip->set_number('5108666')->is_valid_number, '北伊勢上野信用金庫');
ok($zip->set_number('5108670')->is_valid_number, '三重銀行 本店');
ok($zip->set_number('5110192')->is_valid_number, '富士通セミコンダクター 株式会社 三重工場');
ok($zip->set_number('5110198')->is_valid_number, '多度町総合支所');
ok($zip->set_number('5110292')->is_valid_number, 'いなべ市役所 大安庁舎');
ok($zip->set_number('5110293')->is_valid_number, 'いなべ市役所 員弁庁舎');
ok($zip->set_number('5110294')->is_valid_number, '東洋ゴム工業 株式会社 桑名工場');
ok($zip->set_number('5110295')->is_valid_number, '東員町役場');
ok($zip->set_number('5110296')->is_valid_number, '株式会社 デンソー 大安製作所');
ok($zip->set_number('5110492')->is_valid_number, 'いなべ市役所 北勢庁舎');
ok($zip->set_number('5110592')->is_valid_number, 'いなべ市役所 藤原庁舎');
ok($zip->set_number('5110593')->is_valid_number, '太平洋セメント 株式会社 藤原工場');
ok($zip->set_number('5111192')->is_valid_number, '長島観光開発 株式会社');
ok($zip->set_number('5118502')->is_valid_number, '桑栄ビル管理組合法人');
ok($zip->set_number('5118510')->is_valid_number, '桑名税務署');
ok($zip->set_number('5118511')->is_valid_number, '日立金属 株式会社 桑名工場');
ok($zip->set_number('5118533')->is_valid_number, 'ヤマモリ 株式会社');
ok($zip->set_number('5118550')->is_valid_number, '森田フードシステム 株式会社');
ok($zip->set_number('5118555')->is_valid_number, '株式会社 柿安 本店');
ok($zip->set_number('5118558')->is_valid_number, '扶桑工機 株式会社');
ok($zip->set_number('5118567')->is_valid_number, '桑名県税事務所');
ok($zip->set_number('5118577')->is_valid_number, '桑名商工会議所');
ok($zip->set_number('5118585')->is_valid_number, '株式会社 中部コーポレーション');
ok($zip->set_number('5118588')->is_valid_number, '株式会社 杉山コンテック');
ok($zip->set_number('5118601')->is_valid_number, '桑名市役所');
ok($zip->set_number('5118666')->is_valid_number, '桑名信用金庫');
ok($zip->set_number('5118678')->is_valid_number, 'NTN 株式会社 桑名製作所');
ok($zip->set_number('5118686')->is_valid_number, '株式会社 山本 本店');
ok($zip->set_number('5118711')->is_valid_number, 'ヤマモリ 株式会社 桑名・大山田事業所');
ok($zip->set_number('5118798')->is_valid_number, '東海郵政研修センター');
ok($zip->set_number('5128512')->is_valid_number, '四日市大学');
ok($zip->set_number('5128538')->is_valid_number, '暁学園');
ok($zip->set_number('5128550')->is_valid_number, '株式会社 東芝 四日市工場');
ok($zip->set_number('5138501')->is_valid_number, '独立行政法人 国立病院機構 鈴鹿病院');
ok($zip->set_number('5138505')->is_valid_number, '鈴鹿回生総合病院');
ok($zip->set_number('5138510')->is_valid_number, '津地方法務局 鈴鹿出張所');
ok($zip->set_number('5138520')->is_valid_number, '鈴鹿短期大学');
ok($zip->set_number('5138530')->is_valid_number, '株式会社 サンケイ');
ok($zip->set_number('5138601')->is_valid_number, '株式会社 ホンダ・エクスプレス');
ok($zip->set_number('5138630')->is_valid_number, '鈴鹿中央総合病院');
ok($zip->set_number('5138631')->is_valid_number, '住友電装 株式会社 鈴鹿製作所');
ok($zip->set_number('5138632')->is_valid_number, '味の素ゼネラルフーヅ 株式会社 鈴鹿工場');
ok($zip->set_number('5138633')->is_valid_number, '富士電機 株式会社 鈴鹿工場');
ok($zip->set_number('5138650')->is_valid_number, '鈴鹿農業 協同組合');
ok($zip->set_number('5138660')->is_valid_number, '旭化成工業 株式会社 鈴鹿工場');
ok($zip->set_number('5138661')->is_valid_number, 'カネボウウール 株式会社 鈴鹿工場');
ok($zip->set_number('5138666')->is_valid_number, '本田技研工業 株式会社 鈴鹿製作所');
ok($zip->set_number('5138670')->is_valid_number, '鈴鹿医療科学大学 白子キャンパス');
ok($zip->set_number('5138680')->is_valid_number, '株式会社 鈴鹿メディアパーク');
ok($zip->set_number('5138686')->is_valid_number, '株式会社 鈴鹿ハンター');
ok($zip->set_number('5138701')->is_valid_number, '鈴鹿市役所');
ok($zip->set_number('5140392')->is_valid_number, '津市 香良洲総合支所');
ok($zip->set_number('5140393')->is_valid_number, 'JFEエンジニアリング 株式会社 津製作所');
ok($zip->set_number('5140395')->is_valid_number, '中部運輸局 三重運輸支局');
ok($zip->set_number('5140396')->is_valid_number, 'カヤバシステムマシナリー 株式会社 三重工場');
ok($zip->set_number('5140397')->is_valid_number, '中部日産ディーゼル 株式会社');
ok($zip->set_number('5141192')->is_valid_number, '津市 久居総合支所');
ok($zip->set_number('5141195')->is_valid_number, '全国健康保険協会 三重支部');
ok($zip->set_number('5141292')->is_valid_number, '独立行政法人 国立病院機構 榊原病院');
ok($zip->set_number('5141293')->is_valid_number, '医療法人 しょう純会 榊原温泉病院');
ok($zip->set_number('5141294')->is_valid_number, '横河マニュファクチャリング 株式会社');
ok($zip->set_number('5141295')->is_valid_number, '藤田保健衛生大学 七栗サナトリウム');
ok($zip->set_number('5141296')->is_valid_number, '藤田保健衛生大学 藤田記念七栗研究所');
ok($zip->set_number('5141297')->is_valid_number, 'ユリカ 株式会社');
ok($zip->set_number('5142192')->is_valid_number, '津市 美里総合支所');
ok($zip->set_number('5142292')->is_valid_number, '津市庁 芸濃総合支所');
ok($zip->set_number('5142293')->is_valid_number, '(株)赤塚植物園、赤塚物産(株)、(株)エフエフシー・ジャパン');
ok($zip->set_number('5142294')->is_valid_number, 'ヤマギシズム社会豊里実顕地・ヤマギシズム生活豊里実顕地農事組合法人');
ok($zip->set_number('5142392')->is_valid_number, '独立行政法人 農業・食品産業技術総合研究機構 野菜茶業研究所');
ok($zip->set_number('5142393')->is_valid_number, '津市 安濃総合支所');
ok($zip->set_number('5142395')->is_valid_number, '株式会社 中川製作所');
ok($zip->set_number('5142396')->is_valid_number, '株式会社 中勢ゴム');
ok($zip->set_number('5142398')->is_valid_number, '三恵技研工業 株式会社 安濃工場');
ok($zip->set_number('5148501')->is_valid_number, '伊勢湾飼料畜産 株式会社');
ok($zip->set_number('5148502')->is_valid_number, '三重工事事務所');
ok($zip->set_number('5148503')->is_valid_number, '津地方法務局');
ok($zip->set_number('5148505')->is_valid_number, '三重エフエム放送 株式会社');
ok($zip->set_number('5148507')->is_valid_number, '三重大学');
ok($zip->set_number('5148508')->is_valid_number, '医療法人 永井病院');
ok($zip->set_number('5148511')->is_valid_number, 'クレハエラストマー 株式会社');
ok($zip->set_number('5148512')->is_valid_number, '津地方検察庁');
ok($zip->set_number('5148513')->is_valid_number, '株式会社 久居屋');
ok($zip->set_number('5148514')->is_valid_number, '三重県警察本部');
ok($zip->set_number('5148515')->is_valid_number, '三重県トラック協会');
ok($zip->set_number('5148518')->is_valid_number, '交通部 運転免許センター');
ok($zip->set_number('5148520')->is_valid_number, '東海農政局 三重統計情報事務所');
ok($zip->set_number('5148521')->is_valid_number, '津公共職業安定所');
ok($zip->set_number('5148524')->is_valid_number, '三重労働局');
ok($zip->set_number('5148526')->is_valid_number, '津地方家庭簡易裁判所');
ok($zip->set_number('5148528')->is_valid_number, '三重県 社会保険診療報酬支払基金');
ok($zip->set_number('5148530')->is_valid_number, '井村屋製菓 株式会社');
ok($zip->set_number('5148531')->is_valid_number, '日本放送協会 津放送局');
ok($zip->set_number('5148532')->is_valid_number, '日産サニー三重販売 (株)');
ok($zip->set_number('5148533')->is_valid_number, '帝人製機 株式会社 津工場');
ok($zip->set_number('5148538')->is_valid_number, '三重県 医師会');
ok($zip->set_number('5148540')->is_valid_number, '三重県労働者住宅生活 協同組合');
ok($zip->set_number('5148543')->is_valid_number, '日本たばこ産業 (株) 津支店');
ok($zip->set_number('5148545')->is_valid_number, '津税務署');
ok($zip->set_number('5148546')->is_valid_number, '関西紙業 株式会社');
ok($zip->set_number('5148550')->is_valid_number, '株式会社 三重電子計算センター');
ok($zip->set_number('5148552')->is_valid_number, '社会福祉法人 三重県社会福祉協議会');
ok($zip->set_number('5148553')->is_valid_number, '三重県 国民健康保険団体連合会');
ok($zip->set_number('5148555')->is_valid_number, '松下電工 株式会社 津工場');
ok($zip->set_number('5148558')->is_valid_number, '中部電力 株式会社 三重支店');
ok($zip->set_number('5148560')->is_valid_number, '東海財務局 津財務事務所');
ok($zip->set_number('5148566')->is_valid_number, '住友生命保険 相互会社');
ok($zip->set_number('5148567')->is_valid_number, '三重県津地方県民局');
ok($zip->set_number('5148568')->is_valid_number, '(株) マイカル津サティ');
ok($zip->set_number('5148570')->is_valid_number, '三重県庁');
ok($zip->set_number('5148571')->is_valid_number, '日本信販 株式会社');
ok($zip->set_number('5148577')->is_valid_number, '三重県退職教職員互助会');
ok($zip->set_number('5148578')->is_valid_number, '富士ゼロックス三重 株式会社');
ok($zip->set_number('5148585')->is_valid_number, '株式会社 トーエネック 三重支店');
ok($zip->set_number('5148586')->is_valid_number, '日本土建 (株)');
ok($zip->set_number('5148588')->is_valid_number, '全日本自治団体労働組合 三重県本部');
ok($zip->set_number('5148601')->is_valid_number, '大和証券 株式会社 津支店');
ok($zip->set_number('5148611')->is_valid_number, '津市役所');
ok($zip->set_number('5148633')->is_valid_number, '三重テレビ放送');
ok($zip->set_number('5148635')->is_valid_number, '三重交通 株式会社');
ok($zip->set_number('5148666')->is_valid_number, '株式会社 百五銀行');
ok($zip->set_number('5148686')->is_valid_number, '商工中金 津支店');
ok($zip->set_number('5150592')->is_valid_number, '株式会社 牛虎');
ok($zip->set_number('5150595')->is_valid_number, '株式会社 伊勢魚類市場');
ok($zip->set_number('5150596')->is_valid_number, 'ヤマナカフーズ 株式会社');
ok($zip->set_number('5150598')->is_valid_number, '三重国分 株式会社');
ok($zip->set_number('5152592')->is_valid_number, '株式会社 おやつカンパニー');
ok($zip->set_number('5152692')->is_valid_number, '日生学園第二高等学校');
ok($zip->set_number('5152693')->is_valid_number, '津市役所 白山総合支所');
ok($zip->set_number('5158501')->is_valid_number, 'マックスバリュー中部 株式会社');
ok($zip->set_number('5158503')->is_valid_number, 'オムロン松阪 株式会社');
ok($zip->set_number('5158505')->is_valid_number, '(有) パンジィ');
ok($zip->set_number('5158509')->is_valid_number, '松阪公共職業安定所');
ok($zip->set_number('5158510')->is_valid_number, '津地方法務局 松阪支局');
ok($zip->set_number('5158511')->is_valid_number, '三重中京大学');
ok($zip->set_number('5158513')->is_valid_number, 'ヤマモリ 株式会社 松阪工場');
ok($zip->set_number('5158515')->is_valid_number, '松阪市役所');
ok($zip->set_number('5158522')->is_valid_number, '三重中京大学短期大学部');
ok($zip->set_number('5158525')->is_valid_number, '津地方裁判所 松阪支部');
ok($zip->set_number('5158530')->is_valid_number, '株式会社 第三銀行');
ok($zip->set_number('5158533')->is_valid_number, '三重高等学校');
ok($zip->set_number('5158550')->is_valid_number, '松阪税務署');
ok($zip->set_number('5158555')->is_valid_number, 'パナソニックエレクトロニックデバイス 株式会社');
ok($zip->set_number('5158557')->is_valid_number, '済生会 松阪総合病院');
ok($zip->set_number('5158558')->is_valid_number, '宇野重工 株式会社');
ok($zip->set_number('5158566')->is_valid_number, '松阪中央総合病院');
ok($zip->set_number('5158567')->is_valid_number, '株式会社 オークワ');
ok($zip->set_number('5158577')->is_valid_number, '三重県立松阪高等学校');
ok($zip->set_number('5158585')->is_valid_number, '株式会社 三交百貨店');
ok($zip->set_number('5158586')->is_valid_number, '三重信用金庫');
ok($zip->set_number('5158588')->is_valid_number, '和田金');
ok($zip->set_number('5158688')->is_valid_number, '株式会社 中部ハーバー');
ok($zip->set_number('5160192')->is_valid_number, '株式会社 ネットアール');
ok($zip->set_number('5160193')->is_valid_number, '独立行政法人 水産総合研究センター 養殖研究所');
ok($zip->set_number('5160194')->is_valid_number, '南伊勢町役場 南勢庁舎');
ok($zip->set_number('5160198')->is_valid_number, '楓幸房');
ok($zip->set_number('5161192')->is_valid_number, '伊勢電子工業 株式会社');
ok($zip->set_number('5161195')->is_valid_number, 'ウェルサンピア伊勢(三重厚生年金休暇センター)');
ok($zip->set_number('5161196')->is_valid_number, '日本特殊陶業 株式会社 伊勢工場');
ok($zip->set_number('5161198')->is_valid_number, '株式会社 玉木鐵鋼所');
ok($zip->set_number('5161492')->is_valid_number, '南伊勢町役場 南島庁舎');
ok($zip->set_number('5162195')->is_valid_number, '度会町役場');
ok($zip->set_number('5168501')->is_valid_number, '伊勢市御薗総合支所');
ok($zip->set_number('5168502')->is_valid_number, '伊勢市立 御薗中学校');
ok($zip->set_number('5168503')->is_valid_number, '津地方法務局 伊勢支部');
ok($zip->set_number('5168505')->is_valid_number, '有限会社 弥次喜多');
ok($zip->set_number('5168511')->is_valid_number, '伊勢税務署');
ok($zip->set_number('5168515')->is_valid_number, '伊勢高等学校');
ok($zip->set_number('5168516')->is_valid_number, 'ジャスコ 株式会社 新伊勢店');
ok($zip->set_number('5168518')->is_valid_number, '猿田彦神社社務所');
ok($zip->set_number('5168520')->is_valid_number, '伊勢市生涯学習センター (いせトピア)');
ok($zip->set_number('5168543')->is_valid_number, '伊勢公共職業安定所');
ok($zip->set_number('5168544')->is_valid_number, '株式会社 神電テクノリサーチ');
ok($zip->set_number('5168545')->is_valid_number, '神電ファクトリーサービス 株式会社');
ok($zip->set_number('5168546')->is_valid_number, '神電メタル 株式会社');
ok($zip->set_number('5168547')->is_valid_number, '株式会社 セルテクノ');
ok($zip->set_number('5168548')->is_valid_number, '株式会社 セルワークス');
ok($zip->set_number('5168549')->is_valid_number, '神電商事 株式会社 流通営業部');
ok($zip->set_number('5168550')->is_valid_number, '神鋼電機 株式会社 伊勢製作所');
ok($zip->set_number('5168551')->is_valid_number, '株式会社 アイシーエス');
ok($zip->set_number('5168552')->is_valid_number, '神電商事 株式会社 保険営業部');
ok($zip->set_number('5168553')->is_valid_number, '神電エンジニアリング 株式会社');
ok($zip->set_number('5168554')->is_valid_number, '神電商事 株式会社 本部');
ok($zip->set_number('5168555')->is_valid_number, '皇學館大學');
ok($zip->set_number('5168558')->is_valid_number, '有限会社 伊勢福');
ok($zip->set_number('5168566')->is_valid_number, '三重県南勢志摩県民局');
ok($zip->set_number('5168567')->is_valid_number, 'ララパーク');
ok($zip->set_number('5168577')->is_valid_number, '皇學館高等学校');
ok($zip->set_number('5168581')->is_valid_number, '御木本製薬 株式会社');
ok($zip->set_number('5168588')->is_valid_number, '皇學館中学校');
ok($zip->set_number('5168601')->is_valid_number, '伊勢市役所');
ok($zip->set_number('5168602')->is_valid_number, 'ミワネットワークス');
ok($zip->set_number('5168686')->is_valid_number, '株式会社 菊川鉄工所');
ok($zip->set_number('5170292')->is_valid_number, '株式会社 志摩スペイン村');
ok($zip->set_number('5170494')->is_valid_number, 'ホテル 志摩石亭');
ok($zip->set_number('5170592')->is_valid_number, '志摩市役所');
ok($zip->set_number('5170593')->is_valid_number, '株式会社 賢島宝生苑');
ok($zip->set_number('5178501')->is_valid_number, '国立鳥羽商船高等専門学校');
ok($zip->set_number('5178511')->is_valid_number, '御木本真珠島');
ok($zip->set_number('5178517')->is_valid_number, '鳥羽水族館');
ok($zip->set_number('5180192')->is_valid_number, '日生学園第一高等学校 日生学園附属中学校');
ok($zip->set_number('5180292')->is_valid_number, '伊賀市役所 青山支所');
ok($zip->set_number('5180293')->is_valid_number, 'JA伊賀南部青山支店');
ok($zip->set_number('5180294')->is_valid_number, '独立行政法人 水資源機構 川上ダム建設所');
ok($zip->set_number('5180295')->is_valid_number, 'メナード青山リゾート');
ok($zip->set_number('5180296')->is_valid_number, '伊賀南部クリーンセンター');
ok($zip->set_number('5180492')->is_valid_number, '名張市役所');
ok($zip->set_number('5180493')->is_valid_number, '新神戸電機 株式会社 名張工場');
ok($zip->set_number('5180494')->is_valid_number, 'ニッタ・ムアー(株) 名張工場');
ok($zip->set_number('5180495')->is_valid_number, 'ボルグワーナー・モールステック・ジャパン 株式会社');
ok($zip->set_number('5180496')->is_valid_number, '株式会社 マキシンコー 名張工場');
ok($zip->set_number('5180498')->is_valid_number, '皇學館大学 社会福祉学部');
ok($zip->set_number('5188501')->is_valid_number, '伊賀市役所');
ok($zip->set_number('5188518')->is_valid_number, 'パナソニック電工インテリア照明 株式会社');
ok($zip->set_number('5188533')->is_valid_number, '三重県伊賀庁舎');
ok($zip->set_number('5190193')->is_valid_number, '日東電工 株式会社 亀山事業所');
ok($zip->set_number('5190195')->is_valid_number, '亀山市役所');
ok($zip->set_number('5190196')->is_valid_number, 'カメヤマ 株式会社');
ok($zip->set_number('5190197')->is_valid_number, '株式会社 エイチワン 亀山製作所');
ok($zip->set_number('5190198')->is_valid_number, 'シャープ 株式会社 亀山工場');
ok($zip->set_number('5190292')->is_valid_number, '古河電気工業 株式会社 三重事務所');
ok($zip->set_number('5190393')->is_valid_number, '鈴鹿富士ゼロックス 株式会社');
ok($zip->set_number('5190492')->is_valid_number, '松下電工 株式会社 伊勢工場');
ok($zip->set_number('5190493')->is_valid_number, 'ミマス 株式会社');
ok($zip->set_number('5190495')->is_valid_number, '玉城町役場');
ok($zip->set_number('5190497')->is_valid_number, '京セラ 株式会社 三重工場');
ok($zip->set_number('5190592')->is_valid_number, '伊勢市 小俣総合支所');
ok($zip->set_number('5190593')->is_valid_number, 'ユニチカ 株式会社 宮川工場');
ok($zip->set_number('5190594')->is_valid_number, '株式会社 マスヤ');
ok($zip->set_number('5190595')->is_valid_number, '美和ロック 株式会社 伊勢工場');
ok($zip->set_number('5190696')->is_valid_number, '伊勢市二見総合支所');
ok($zip->set_number('5191192')->is_valid_number, '亀山市関支所');
ok($zip->set_number('5192192')->is_valid_number, 'シャープ 株式会社');
ok($zip->set_number('5192592')->is_valid_number, '大台町役場 宮川総合支所');
ok($zip->set_number('5192593')->is_valid_number, '三重県立 昴学園高等学校');
ok($zip->set_number('5192792')->is_valid_number, '大紀町役場');
ok($zip->set_number('5193492')->is_valid_number, '紀北町役場');
ok($zip->set_number('5193692')->is_valid_number, '尾鷲社会保険事務所');
ok($zip->set_number('5193693')->is_valid_number, '尾鷲総合病院');
ok($zip->set_number('5193694')->is_valid_number, '尾鷲税務署');
ok($zip->set_number('5193695')->is_valid_number, '三重県 紀北県民局');
ok($zip->set_number('5193696')->is_valid_number, '尾鷲市役所');
ok($zip->set_number('5194392')->is_valid_number, '熊野市役所');
ok($zip->set_number('5194393')->is_valid_number, '三重県紀南県民局 紀南振興事務所');
ok($zip->set_number('5194394')->is_valid_number, '三重県立木本高等学校');
ok($zip->set_number('5194395')->is_valid_number, '熊野工業高等専門学校');
ok($zip->set_number('5194396')->is_valid_number, '津地方裁判所 熊野支部');
ok($zip->set_number('5195292')->is_valid_number, '御浜町役場');
ok($zip->set_number('5195293')->is_valid_number, '公立紀南病院');
ok($zip->set_number('5200287')->is_valid_number, '滋賀地域センター');
ok($zip->set_number('5200292')->is_valid_number, '東洋紡績 株式会社 総合研究所');
ok($zip->set_number('5200580')->is_valid_number, '大津赤十字志賀病院');
ok($zip->set_number('5200588')->is_valid_number, 'BSCウォータースポーツセンター');
ok($zip->set_number('5201188')->is_valid_number, '株式会社 高島デリバリー、進研アド物流センター');
ok($zip->set_number('5201192')->is_valid_number, '高島市役所 高島支所');
ok($zip->set_number('5201292')->is_valid_number, '高島市役所 安曇川支所');
ok($zip->set_number('5201492')->is_valid_number, '高島市役所 朽木支所');
ok($zip->set_number('5201495')->is_valid_number, '朽木ゴルフ倶楽部');
ok($zip->set_number('5201592')->is_valid_number, '高島市役所');
ok($zip->set_number('5201692')->is_valid_number, '高島市役所 今津支所');
ok($zip->set_number('5201892')->is_valid_number, '高島市役所 マキノ支所');
ok($zip->set_number('5202192')->is_valid_number, '滋賀医科大学');
ok($zip->set_number('5202194')->is_valid_number, '龍谷大学');
ok($zip->set_number('5202392')->is_valid_number, 'ソニーモバイルディスプレイ 株式会社');
ok($zip->set_number('5202393')->is_valid_number, '(株) 村田製作所 野洲事業所');
ok($zip->set_number('5202394')->is_valid_number, '(株) 長府製作所 滋賀工場');
ok($zip->set_number('5202395')->is_valid_number, '野洲市役所 本庁舎');
ok($zip->set_number('5202492')->is_valid_number, '野洲市 市民サービスセンター');
ok($zip->set_number('5202592')->is_valid_number, '竜王町役場');
ok($zip->set_number('5202594')->is_valid_number, '竜王ゴルフコース');
ok($zip->set_number('5202595')->is_valid_number, '積水樹脂 株式会社 滋賀竜王工場滋賀製造所');
ok($zip->set_number('5202596')->is_valid_number, '積水樹脂 株式会社 R&Dプラザ・滋賀竜王工場竜王製造所');
ok($zip->set_number('5203080')->is_valid_number, '三菱重工業 株式会社 工作機械事業部');
ok($zip->set_number('5203081')->is_valid_number, '積水化学工業 株式会社 滋賀栗東工場');
ok($zip->set_number('5203082')->is_valid_number, '積水ハウス 株式会社 滋賀工場');
ok($zip->set_number('5203083')->is_valid_number, '日清食品 株式会社 滋賀工場');
ok($zip->set_number('5203084')->is_valid_number, '日本ジョンクレーン');
ok($zip->set_number('5203085')->is_valid_number, '日本中央競馬会 栗東トレーニングセンター');
ok($zip->set_number('5203088')->is_valid_number, '栗東市役所');
ok($zip->set_number('5203180')->is_valid_number, '日本精工 株式会社 石部工場');
ok($zip->set_number('5203182')->is_valid_number, '株式会社 エム・エス・コミュニケーションズ 大阪物流部 物流センター');
ok($zip->set_number('5203185')->is_valid_number, 'シーアイ化成 株式会社 滋賀事業所');
ok($zip->set_number('5203188')->is_valid_number, '甲賀高分子 株式会社');
ok($zip->set_number('5203189')->is_valid_number, '株式会社 ゴーシュー');
ok($zip->set_number('5203194')->is_valid_number, '社会福祉法人 大木会');
ok($zip->set_number('5203195')->is_valid_number, '湖南市役所 西庁舎');
ok($zip->set_number('5203281')->is_valid_number, '東陶機器 株式会社 滋賀工場');
ok($zip->set_number('5203282')->is_valid_number, '王子製紙 株式会社 滋賀工場');
ok($zip->set_number('5203285')->is_valid_number, 'ナストーア 株式会社 近江工場');
ok($zip->set_number('5203288')->is_valid_number, '湖南市役所 東庁舎');
ok($zip->set_number('5203289')->is_valid_number, '日本ポリスター 株式会社');
ok($zip->set_number('5203393')->is_valid_number, '甲賀市役所 甲南庁舎');
ok($zip->set_number('5203492')->is_valid_number, '甲賀市役所 甲賀支所');
ok($zip->set_number('5203493')->is_valid_number, 'バイエル薬品 株式会社 滋賀工場');
ok($zip->set_number('5208501')->is_valid_number, '滋賀県警察 本部');
ok($zip->set_number('5208511')->is_valid_number, '大津赤十字病院');
ok($zip->set_number('5208512')->is_valid_number, '大津地方検察庁');
ok($zip->set_number('5208513')->is_valid_number, '全国健康保険協会 滋賀支部');
ok($zip->set_number('5208516')->is_valid_number, '大津法務局');
ok($zip->set_number('5208520')->is_valid_number, '大津プリンスホテル');
ok($zip->set_number('5208530')->is_valid_number, '浜大津都市開発 (株)');
ok($zip->set_number('5208550')->is_valid_number, '滋賀県市町村職員共済組合');
ok($zip->set_number('5208555')->is_valid_number, '関西日本電気 株式会社');
ok($zip->set_number('5208558')->is_valid_number, '東レ 株式会社 滋賀事業場');
ok($zip->set_number('5208567')->is_valid_number, '株式会社 東レリサーチセンター');
ok($zip->set_number('5208570')->is_valid_number, '関西電力 (株) 滋賀支店');
ok($zip->set_number('5208575')->is_valid_number, '大津市役所');
ok($zip->set_number('5208577')->is_valid_number, '滋賀県庁');
ok($zip->set_number('5208580')->is_valid_number, '株式会社 西武百貨店 大津店');
ok($zip->set_number('5208585')->is_valid_number, 'びわ湖放送 株式会社');
ok($zip->set_number('5208586')->is_valid_number, '(株) みんなで作る新聞社');
ok($zip->set_number('5208588')->is_valid_number, 'NTT 大津支店');
ok($zip->set_number('5208639')->is_valid_number, '日本電気硝子 (株)');
ok($zip->set_number('5208666')->is_valid_number, '滋賀刑務所');
ok($zip->set_number('5210292')->is_valid_number, '米原市役所 山東庁舎');
ok($zip->set_number('5210392')->is_valid_number, '米原市役所 伊吹庁舎');
ok($zip->set_number('5211192')->is_valid_number, 'タカタ 株式会社 彦根製造所');
ok($zip->set_number('5211292')->is_valid_number, '東近江市能登川支所');
ok($zip->set_number('5211295')->is_valid_number, '日本電気硝子 株式会社 能登川事業場');
ok($zip->set_number('5211392')->is_valid_number, '近江八幡市 安土町総合支所');
ok($zip->set_number('5211398')->is_valid_number, 'キタイ設計 株式会社');
ok($zip->set_number('5218501')->is_valid_number, '米原市役所 米原庁舎');
ok($zip->set_number('5218511')->is_valid_number, 'ヤンマーディーゼル 株式会社');
ok($zip->set_number('5218521')->is_valid_number, 'ヤンマー農機 株式会社');
ok($zip->set_number('5218601')->is_valid_number, '米原市役所 近江庁舎');
ok($zip->set_number('5220292')->is_valid_number, '大日本スクリーン製造 株式会社 彦根地区事業所');
ok($zip->set_number('5220297')->is_valid_number, '新神戸電機 株式会社 彦根工場');
ok($zip->set_number('5228501')->is_valid_number, '彦根市役所');
ok($zip->set_number('5228503')->is_valid_number, '近江鉄道 株式会社');
ok($zip->set_number('5228511')->is_valid_number, '株式会社 平和堂');
ok($zip->set_number('5228520')->is_valid_number, '松下電工 株式会社 彦根工場');
ok($zip->set_number('5228522')->is_valid_number, '滋賀大学');
ok($zip->set_number('5228523')->is_valid_number, 'アル・プラザ彦根');
ok($zip->set_number('5228533')->is_valid_number, '滋賀県立大学');
ok($zip->set_number('5228539')->is_valid_number, '彦根市立病院');
ok($zip->set_number('5228540')->is_valid_number, '日本年金機構 彦根年金事務所');
ok($zip->set_number('5228585')->is_valid_number, 'KBS 滋賀');
ok($zip->set_number('5228588')->is_valid_number, 'フジテック 株式会社 Big Wing');
ok($zip->set_number('5228655')->is_valid_number, '彦根信用金庫');
ok($zip->set_number('5228666')->is_valid_number, '株式会社 文教スタヂオ');
ok($zip->set_number('5238501')->is_valid_number, '近江八幡市役所');
ok($zip->set_number('5238502')->is_valid_number, '近江八幡税務署');
ok($zip->set_number('5238503')->is_valid_number, '八幡青樹会病院');
ok($zip->set_number('5238510')->is_valid_number, '滋賀職業能力開発短期大学校');
ok($zip->set_number('5238515')->is_valid_number, '株式会社 近江兄弟社');
ok($zip->set_number('5238523')->is_valid_number, 'ヴォーリズ記念病院');
ok($zip->set_number('5238555')->is_valid_number, '株式会社 日吉');
ok($zip->set_number('5238558')->is_valid_number, '株式会社 たねや 日牟禮ヴィレッジ');
ok($zip->set_number('5238651')->is_valid_number, '滋賀中央信用金庫 本店');
ok($zip->set_number('5240292')->is_valid_number, '株式会社 鮎家');
ok($zip->set_number('5248501')->is_valid_number, 'グンゼ 株式会社 守山工場');
ok($zip->set_number('5248524')->is_valid_number, '滋賀県立成人病センター');
ok($zip->set_number('5248577')->is_valid_number, '立命館守山中学校・高等学校');
ok($zip->set_number('5248585')->is_valid_number, '滋賀県 守山市役所');
ok($zip->set_number('5258501')->is_valid_number, '草津電機 株式会社');
ok($zip->set_number('5258502')->is_valid_number, '松下電器産業 株式会社 カーエアコン部');
ok($zip->set_number('5258505')->is_valid_number, '滋賀県 赤十字血液センター');
ok($zip->set_number('5258511')->is_valid_number, 'ニチデン機械 株式会社');
ok($zip->set_number('5258515')->is_valid_number, '株式会社 草津近鉄百貨店');
ok($zip->set_number('5258520')->is_valid_number, '松下電器産業 株式会社 エアコン事業部');
ok($zip->set_number('5258521')->is_valid_number, '不二電機工業 株式会社');
ok($zip->set_number('5258522')->is_valid_number, '東西電工 株式会社');
ok($zip->set_number('5258525')->is_valid_number, '滋賀県草津県事務所');
ok($zip->set_number('5258555')->is_valid_number, '松下冷機 株式会社 冷蔵庫事業部');
ok($zip->set_number('5258558')->is_valid_number, '川重冷熱工業 株式会社');
ok($zip->set_number('5258566')->is_valid_number, '学校法人 聖パウロ学園 光泉中学・高等学校');
ok($zip->set_number('5258567')->is_valid_number, '新世代 株式会社');
ok($zip->set_number('5258577')->is_valid_number, '立命館大学 びわこくさつキャンパス');
ok($zip->set_number('5258585')->is_valid_number, '医療法人 誠光会 草津総合病院');
ok($zip->set_number('5258588')->is_valid_number, '草津市役所');
ok($zip->set_number('5260292')->is_valid_number, '長浜市役所 浅井支所');
ok($zip->set_number('5260293')->is_valid_number, '株式会社 セネファ');
ok($zip->set_number('5268501')->is_valid_number, '長浜市役所');
ok($zip->set_number('5268545')->is_valid_number, 'タカタ (株) 長浜製造所');
ok($zip->set_number('5268558')->is_valid_number, 'ヤンマー (株) 小形エンジン事業部');
ok($zip->set_number('5268580')->is_valid_number, '市立長浜病院');
ok($zip->set_number('5268585')->is_valid_number, '長浜赤十字病院');
ok($zip->set_number('5268660')->is_valid_number, '三菱樹脂 株式会社 長浜工場');
ok($zip->set_number('5268686')->is_valid_number, '長浜信用金庫');
ok($zip->set_number('5270195')->is_valid_number, '東近江市役所 湖東支所');
ok($zip->set_number('5278505')->is_valid_number, '独立行政法人 国立病院機構 滋賀病院');
ok($zip->set_number('5278508')->is_valid_number, '株式会社 ティラド 滋賀製作所');
ok($zip->set_number('5278509')->is_valid_number, '平和奥田 株式会社');
ok($zip->set_number('5278511')->is_valid_number, '東近江地域振興局');
ok($zip->set_number('5278512')->is_valid_number, '滋賀県東近江地域振興局 地域健康福祉部');
ok($zip->set_number('5278527')->is_valid_number, '東近江市役所');
ok($zip->set_number('5278542')->is_valid_number, '三光合成 株式会社 滋賀工場');
ok($zip->set_number('5278550')->is_valid_number, '満田工業 (株)');
ok($zip->set_number('5278554')->is_valid_number, '東近江労働基準監督署');
ok($zip->set_number('5278555')->is_valid_number, '京セラ 株式会社 滋賀八日市工場');
ok($zip->set_number('5278558')->is_valid_number, '株式会社 村田製作所 八日市事業所');
ok($zip->set_number('5278566')->is_valid_number, '凸版印刷 株式会社 エレクトロニクス事業本部');
ok($zip->set_number('5278567')->is_valid_number, '医療法人 敬愛会');
ok($zip->set_number('5278577')->is_valid_number, 'シキボウ 株式会社 八日市工場');
ok($zip->set_number('5278580')->is_valid_number, 'タキロン 株式会社 八日市工場');
ok($zip->set_number('5278585')->is_valid_number, '関西電力 株式会社 八日市営業所');
ok($zip->set_number('5278588')->is_valid_number, '株式会社 ノエビア 滋賀事業所');
ok($zip->set_number('5278687')->is_valid_number, '湖東信用金庫');
ok($zip->set_number('5288501')->is_valid_number, 'NECライティング 株式会社 滋賀工場');
ok($zip->set_number('5288502')->is_valid_number, '甲賀市役所 水口庁舎');
ok($zip->set_number('5288510')->is_valid_number, 'HOYA 株式会社 水口ラボラトリー');
ok($zip->set_number('5288511')->is_valid_number, '滋賀県甲賀環境・総合事務所');
ok($zip->set_number('5288555')->is_valid_number, '水口税務署');
ok($zip->set_number('5288585')->is_valid_number, '積水化学工業 株式会社 滋賀水口工場');
ok($zip->set_number('5288666')->is_valid_number, '甲賀市役所 水口支所');
ok($zip->set_number('5290292')->is_valid_number, '日本電気硝子 株式会社 滋賀高月事業場');
ok($zip->set_number('5290492')->is_valid_number, '長浜市役所 木之本支所');
ok($zip->set_number('5290493')->is_valid_number, '湖北総合病院');
ok($zip->set_number('5290498')->is_valid_number, 'ハヤミ工産 株式会社');
ok($zip->set_number('5290792')->is_valid_number, '長浜市役所 西浅井支所');
ok($zip->set_number('5291195')->is_valid_number, '昭和電工 (株) 彦根事業所');
ok($zip->set_number('5291380')->is_valid_number, '愛荘町役場 愛知川庁舎');
ok($zip->set_number('5291381')->is_valid_number, '青木産商 株式会社');
ok($zip->set_number('5291382')->is_valid_number, 'キユーピー醸造 株式会社 滋賀工場');
ok($zip->set_number('5291383')->is_valid_number, '栗本コンクリート工業 株式会社');
ok($zip->set_number('5291386')->is_valid_number, '株式会社 ユニックス');
ok($zip->set_number('5291388')->is_valid_number, 'タカタ 株式会社 愛知川製造所');
ok($zip->set_number('5291393')->is_valid_number, '大丸工業 株式会社 滋賀支店');
ok($zip->set_number('5291492')->is_valid_number, '東近江市役所 五個荘支所');
ok($zip->set_number('5291493')->is_valid_number, '藤野商事 株式会社');
ok($zip->set_number('5291495')->is_valid_number, 'フジノ食品 株式会社');
ok($zip->set_number('5291592')->is_valid_number, '東近江市 蒲生支所');
ok($zip->set_number('5291595')->is_valid_number, '京セラ 株式会社 滋賀蒲生工場');
ok($zip->set_number('5291597')->is_valid_number, '株式会社 名神八日市カントリー倶楽部');
ok($zip->set_number('5291598')->is_valid_number, '朝日野カントリー倶楽部');
ok($zip->set_number('5291692')->is_valid_number, '株式会社 ダイフク 滋賀事業所');
ok($zip->set_number('5291698')->is_valid_number, '日野町役場');
ok($zip->set_number('5291892')->is_valid_number, '甲賀市役所 信楽支所');
ok($zip->set_number('5306051')->is_valid_number, '株式会社 明治 関西支社');
ok($zip->set_number('5308201')->is_valid_number, '大阪市役所');
ok($zip->set_number('5308203')->is_valid_number, 'サントリー 株式会社');
ok($zip->set_number('5308204')->is_valid_number, 'サントリー 株式会社 アネックスビル');
ok($zip->set_number('5308205')->is_valid_number, '旭化成 株式会社');
ok($zip->set_number('5308206')->is_valid_number, '三菱電機 株式会社 関西支社');
ok($zip->set_number('5308210')->is_valid_number, '大建工業 株式会社');
ok($zip->set_number('5308211')->is_valid_number, '朝日新聞 大阪本社');
ok($zip->set_number('5308212')->is_valid_number, '株式会社 ニチメン 保険センター');
ok($zip->set_number('5308215')->is_valid_number, '株式会社 エイチ・アイ・エス');
ok($zip->set_number('5308216')->is_valid_number, '大阪市 梅田市税事務所');
ok($zip->set_number('5308217')->is_valid_number, 'JR西日本SC開発 株式会社');
ok($zip->set_number('5308222')->is_valid_number, '東レ 株式会社 大阪本社');
ok($zip->set_number('5308227')->is_valid_number, 'プロミス 株式会社');
ok($zip->set_number('5308230')->is_valid_number, '東洋紡績 株式会社');
ok($zip->set_number('5308234')->is_valid_number, '山発産業 株式会社');
ok($zip->set_number('5308239')->is_valid_number, 'オリックス自動車 株式会社');
ok($zip->set_number('5308241')->is_valid_number, '大和ハウス工業 株式会社');
ok($zip->set_number('5308245')->is_valid_number, 'オリックス 株式会社');
ok($zip->set_number('5308247')->is_valid_number, '安田火災海上保険 株式会社');
ok($zip->set_number('5308251')->is_valid_number, '毎日新聞社');
ok($zip->set_number('5308252')->is_valid_number, '住信・パナソニックフィナンシャルサービス 株式会社');
ok($zip->set_number('5308262')->is_valid_number, '株式会社 博報堂 関西支社');
ok($zip->set_number('5308266')->is_valid_number, '森六ケミカルズ 株式会社 大阪支店');
ok($zip->set_number('5308270')->is_valid_number, '関西電力 株式会社');
ok($zip->set_number('5308278')->is_valid_number, '株式会社 スポーツニッポン新聞社 大阪本社');
ok($zip->set_number('5308281')->is_valid_number, 'Be Happy!789');
ok($zip->set_number('5308282')->is_valid_number, '株式会社 日本交通公社 関西営業本部');
ok($zip->set_number('5308288')->is_valid_number, '株式会社 カネカ');
ok($zip->set_number('5308304')->is_valid_number, '株式会社 毎日放送');
ok($zip->set_number('5308308')->is_valid_number, '株式会社 ダイワエクシード');
ok($zip->set_number('5308311')->is_valid_number, 'ヤンマー (株) 本社');
ok($zip->set_number('5308318')->is_valid_number, 'JFE商事 株式会社');
ok($zip->set_number('5308321')->is_valid_number, 'ヤンマー農機販売 株式会社');
ok($zip->set_number('5308323')->is_valid_number, 'ダイキン工業 株式会社 本社');
ok($zip->set_number('5308324')->is_valid_number, 'マルニ 株式会社');
ok($zip->set_number('5308334')->is_valid_number, '大阪日刊スポーツ新聞社');
ok($zip->set_number('5308338')->is_valid_number, '株式会社 ウィルコム');
ok($zip->set_number('5308341')->is_valid_number, '西日本旅客鉄道 株式会社');
ok($zip->set_number('5308346')->is_valid_number, '大阪市役所内郵送事務処理センター');
ok($zip->set_number('5308350')->is_valid_number, '株式会社 阪急百貨店');
ok($zip->set_number('5308355')->is_valid_number, '株式会社 阪急交通社 トラピックス');
ok($zip->set_number('5308383')->is_valid_number, '株式会社 阪急交通社');
ok($zip->set_number('5308388')->is_valid_number, '株式会社 大阪梅田秘書センター');
ok($zip->set_number('5308389')->is_valid_number, '阪急電鉄 株式会社');
ok($zip->set_number('5308410')->is_valid_number, '株式会社 千趣会');
ok($zip->set_number('5308411')->is_valid_number, '高圧ガス工業 株式会社');
ok($zip->set_number('5308415')->is_valid_number, '東宝 株式会社 関西支社');
ok($zip->set_number('5308441')->is_valid_number, 'コモライフ 株式会社');
ok($zip->set_number('5308448')->is_valid_number, '伊藤忠商事 株式会社');
ok($zip->set_number('5308475')->is_valid_number, 'ぴあ 株式会社 関西支社');
ok($zip->set_number('5308501')->is_valid_number, '弁護士法人 みお綜合法律事務所');
ok($zip->set_number('5308511')->is_valid_number, '象印マホービン 株式会社');
ok($zip->set_number('5308512')->is_valid_number, '株式会社 読売ライフ');
ok($zip->set_number('5308513')->is_valid_number, '三ツワ理化学工業 株式会社');
ok($zip->set_number('5308517')->is_valid_number, '株式会社 鴻池組 大阪本店');
ok($zip->set_number('5308521')->is_valid_number, '大阪高等裁判所');
ok($zip->set_number('5308522')->is_valid_number, '大阪地方裁判所');
ok($zip->set_number('5308523')->is_valid_number, '大阪簡易裁判所');
ok($zip->set_number('5308535')->is_valid_number, 'デュプロ (株)');
ok($zip->set_number('5308544')->is_valid_number, '国分 株式会社 近畿支社');
ok($zip->set_number('5308551')->is_valid_number, '株式会社 読売新聞 大阪本社');
ok($zip->set_number('5308555')->is_valid_number, 'ニッセイ同和損害保険 株式会社');
ok($zip->set_number('5308556')->is_valid_number, '全国柔整師協会');
ok($zip->set_number('5308558')->is_valid_number, 'JR大阪三越伊勢丹');
ok($zip->set_number('5308565')->is_valid_number, '積水化学工業 株式会社');
ok($zip->set_number('5308566')->is_valid_number, '中西金属工業 株式会社');
ok($zip->set_number('5308567')->is_valid_number, '梅田公共職業安定所');
ok($zip->set_number('5308574')->is_valid_number, '共栄火災海上保険 株式会社');
ok($zip->set_number('5308575')->is_valid_number, '株式会社 日刊現代大阪');
ok($zip->set_number('5308580')->is_valid_number, '株式会社 FM802');
ok($zip->set_number('5308582')->is_valid_number, '大阪市住宅供給公社');
ok($zip->set_number('5308583')->is_valid_number, 'ゲッツ編集部');
ok($zip->set_number('5308586')->is_valid_number, '株式会社 読売情報開発大阪');
ok($zip->set_number('5308588')->is_valid_number, '株式会社 松村組');
ok($zip->set_number('5308601')->is_valid_number, '日本生命保険 相互会社');
ok($zip->set_number('5308602')->is_valid_number, '三菱商事 株式会社');
ok($zip->set_number('5308610')->is_valid_number, '読売テレビ放送 株式会社');
ok($zip->set_number('5308611')->is_valid_number, '株式会社 クラレ');
ok($zip->set_number('5308618')->is_valid_number, 'ニチメン 株式会社');
ok($zip->set_number('5308680')->is_valid_number, '株式会社 住友銀行 本店');
ok($zip->set_number('5308688')->is_valid_number, '株式会社 ぎょうせい 関西支社');
ok($zip->set_number('5308791')->is_valid_number, '共通事務センター');
ok($zip->set_number('5308793')->is_valid_number, '郵便事業 株式会社 近畿支社 郵便事業部 (三種)');
ok($zip->set_number('5308796')->is_valid_number, '大阪監査室');
ok($zip->set_number('5308797')->is_valid_number, '株式会社 ゆうちょ銀行 大阪支店');
ok($zip->set_number('5308797')->is_valid_number, '株式会社 かんぽ生命 大阪支店');
ok($zip->set_number('5308797')->is_valid_number, '郵便局 株式会社 近畿支社');
ok($zip->set_number('5308797')->is_valid_number, '郵便事業 株式会社 近畿支社');
ok($zip->set_number('5308798')->is_valid_number, '大阪北逓信病院');
ok($zip->set_number('5318501')->is_valid_number, 'ザ・シンフォニーホール');
ok($zip->set_number('5318502')->is_valid_number, '関電プラント 株式会社');
ok($zip->set_number('5318503')->is_valid_number, 'カバーマーク 株式会社');
ok($zip->set_number('5318511')->is_valid_number, 'ニッポンペイント 株式会社');
ok($zip->set_number('5318555')->is_valid_number, '三菱電機クレジット 株式会社');
ok($zip->set_number('5318558')->is_valid_number, '報知新聞 大阪本社');
ok($zip->set_number('5318567')->is_valid_number, '株式会社 日本電商');
ok($zip->set_number('5318787')->is_valid_number, '大阪地域センター');
ok($zip->set_number('5328501')->is_valid_number, '大阪市淀川区役所');
ok($zip->set_number('5328505')->is_valid_number, '田辺製薬 株式会社 加島事業所');
ok($zip->set_number('5328507')->is_valid_number, '淀川労働基準監督署');
ok($zip->set_number('5328508')->is_valid_number, '株式会社 パールエース 関西支店');
ok($zip->set_number('5328511')->is_valid_number, '株式会社 日本公文教育研究会');
ok($zip->set_number('5328514')->is_valid_number, 'アステラス製薬 (株) 加島事業場');
ok($zip->set_number('5328515')->is_valid_number, 'オール日本スーパーマーケット 協会');
ok($zip->set_number('5328520')->is_valid_number, '全国金物連合商業協同組合');
ok($zip->set_number('5328524')->is_valid_number, '日清食品 株式会社 本社');
ok($zip->set_number('5328525')->is_valid_number, 'コプロ 株式会社');
ok($zip->set_number('5328535')->is_valid_number, '株式会社 チップワンストップ 関西営業所');
ok($zip->set_number('5328550')->is_valid_number, 'IDEC 株式会社');
ok($zip->set_number('5328552')->is_valid_number, '株式会社 ロプロ');
ok($zip->set_number('5328555')->is_valid_number, 'オー・ジー 株式会社 本社/大阪支店');
ok($zip->set_number('5328558')->is_valid_number, '東淀川税務署');
ok($zip->set_number('5328560')->is_valid_number, '株式会社 ニイタカ');
ok($zip->set_number('5328577')->is_valid_number, 'バイエル薬品 株式会社');
ok($zip->set_number('5328585')->is_valid_number, '新大阪センイシティー');
ok($zip->set_number('5328680')->is_valid_number, '株式会社 シェル石油大阪発売所');
ok($zip->set_number('5338501')->is_valid_number, '東淀川区役所');
ok($zip->set_number('5338502')->is_valid_number, '杉本商事 株式会社 本社');
ok($zip->set_number('5338533')->is_valid_number, '大阪経済大学');
ok($zip->set_number('5338555')->is_valid_number, '株式会社 キーエンス');
ok($zip->set_number('5338558')->is_valid_number, 'ライフコーポレーション');
ok($zip->set_number('5338585')->is_valid_number, '株式会社 ダイヤモンドプレス');
ok($zip->set_number('5338651')->is_valid_number, '参天製薬 株式会社');
ok($zip->set_number('5348501')->is_valid_number, '都島区役所');
ok($zip->set_number('5348502')->is_valid_number, '大阪市 京橋市税事務所');
ok($zip->set_number('5348511')->is_valid_number, 'よみうりテレビサービス');
ok($zip->set_number('5348585')->is_valid_number, '大阪拘置所');
ok($zip->set_number('5358501')->is_valid_number, '大阪市旭区役所');
ok($zip->set_number('5358555')->is_valid_number, '旭 税務署');
ok($zip->set_number('5358585')->is_valid_number, '学校法人 大阪工大摂南大学(大阪工業大学工学部・大阪工業大学短期大学部・大阪工業大学高等学校)');
ok($zip->set_number('5368501')->is_valid_number, '大阪府 なにわ東府税事務所');
ok($zip->set_number('5368503')->is_valid_number, '株式会社 大丸・城東総合センター');
ok($zip->set_number('5368505')->is_valid_number, '大阪府赤十字血液センター');
ok($zip->set_number('5368508')->is_valid_number, '大正製薬 株式会社 大阪支店');
ok($zip->set_number('5368510')->is_valid_number, '大阪市城東区役所');
ok($zip->set_number('5368522')->is_valid_number, '独立行政法人 都市再生機構 西日本支社 大阪住宅管理センター');
ok($zip->set_number('5368523')->is_valid_number, '扶桑薬品工業 株式会社');
ok($zip->set_number('5368527')->is_valid_number, '城東税務署');
ok($zip->set_number('5368536')->is_valid_number, 'タカラスタンダード 株式会社');
ok($zip->set_number('5368550')->is_valid_number, '独立行政法人 都市再生機構 西日本支社');
ok($zip->set_number('5368553')->is_valid_number, '大阪市立工業研究所');
ok($zip->set_number('5368558')->is_valid_number, 'DoCoMoサービス 関西');
ok($zip->set_number('5368567')->is_valid_number, '大阪府貨物運送健康保険組合');
ok($zip->set_number('5368585')->is_valid_number, '学校法人 大阪信愛女学院');
ok($zip->set_number('5368588')->is_valid_number, '財団法人 大阪がん予防検診センター');
ok($zip->set_number('5368686')->is_valid_number, '牛乳石鹸共進社 株式会社');
ok($zip->set_number('5378501')->is_valid_number, '東成区役所');
ok($zip->set_number('5378511')->is_valid_number, '大阪府立 成人病センター');
ok($zip->set_number('5378686')->is_valid_number, 'コクヨ (株)');
ok($zip->set_number('5388501')->is_valid_number, '株式会社 タカラ');
ok($zip->set_number('5388510')->is_valid_number, '大阪市鶴見区役所');
ok($zip->set_number('5388555')->is_valid_number, '株式会社 コジット');
ok($zip->set_number('5388585')->is_valid_number, '株式会社 鶴見製作所');
ok($zip->set_number('5388655')->is_valid_number, 'カナヱ塗料 株式会社');
ok($zip->set_number('5388666')->is_valid_number, '株式会社 アサヒペン');
ok($zip->set_number('5388686')->is_valid_number, '株式会社 椿本チエイン');
ok($zip->set_number('5398794')->is_valid_number, '大阪貯金事務センター');
ok($zip->set_number('5406255')->is_valid_number, 'パナソニック 株式会社');
ok($zip->set_number('5408501')->is_valid_number, 'NHK大阪放送局');
ok($zip->set_number('5408505')->is_valid_number, '東京海上日動火災保険 株式会社');
ok($zip->set_number('5408508')->is_valid_number, '株式会社 サクラクレパス');
ok($zip->set_number('5408510')->is_valid_number, '読売テレビ放送 株式会社');
ok($zip->set_number('5408511')->is_valid_number, '西日本電信電話 株式会社');
ok($zip->set_number('5408512')->is_valid_number, '住友生命保険 相互会社');
ok($zip->set_number('5408515')->is_valid_number, '西松建設 株式会社 関西支店');
ok($zip->set_number('5408517')->is_valid_number, '年金記録確認大阪地方第三者委員会');
ok($zip->set_number('5408519')->is_valid_number, 'テレビ大阪 株式会社');
ok($zip->set_number('5408522')->is_valid_number, '伊藤忠食品 株式会社');
ok($zip->set_number('5408526')->is_valid_number, '株式会社 リヒトラブ');
ok($zip->set_number('5408527')->is_valid_number, '大阪労働局');
ok($zip->set_number('5408530')->is_valid_number, '株式会社 マンダム');
ok($zip->set_number('5408533')->is_valid_number, '近畿管区行政評価局');
ok($zip->set_number('5408534')->is_valid_number, 'YKK AP 株式会社');
ok($zip->set_number('5408535')->is_valid_number, '近畿経済産業局');
ok($zip->set_number('5408540')->is_valid_number, '大阪府警察本部');
ok($zip->set_number('5408541')->is_valid_number, '大阪国税局');
ok($zip->set_number('5408544')->is_valid_number, '大阪法務局');
ok($zip->set_number('5408550')->is_valid_number, '近畿財務局');
ok($zip->set_number('5408551')->is_valid_number, '日本電気 株式会社 関西支社');
ok($zip->set_number('5408555')->is_valid_number, '財団法人 日本中小企業福祉事業財団 (日本フルハップ)');
ok($zip->set_number('5408558')->is_valid_number, '近畿運輸局');
ok($zip->set_number('5408559')->is_valid_number, '大阪航空局');
ok($zip->set_number('5408566')->is_valid_number, '森下仁丹 株式会社');
ok($zip->set_number('5408570')->is_valid_number, '大阪府庁');
ok($zip->set_number('5408571')->is_valid_number, '大阪府庁 (大阪府教育委員会)');
ok($zip->set_number('5408575')->is_valid_number, 'アルフレッサファーマ 株式会社');
ok($zip->set_number('5408577')->is_valid_number, '株式会社 丸島アクアシステム');
ok($zip->set_number('5408578')->is_valid_number, '株式会社 ホテルニューオータニ ホテルニューオータニ大阪');
ok($zip->set_number('5408581')->is_valid_number, '株式会社 総通');
ok($zip->set_number('5408584')->is_valid_number, '株式会社 大林組');
ok($zip->set_number('5408585')->is_valid_number, '京セラミタ 株式会社 本社');
ok($zip->set_number('5408586')->is_valid_number, '国土交通省 近畿地方整備局');
ok($zip->set_number('5408587')->is_valid_number, '大阪司法書士会');
ok($zip->set_number('5408588')->is_valid_number, '株式会社 日本経済新聞社 大阪本社');
ok($zip->set_number('5408602')->is_valid_number, 'CBC 株式会社 大阪支店');
ok($zip->set_number('5408603')->is_valid_number, '蝶理 株式会社');
ok($zip->set_number('5408604')->is_valid_number, '野村證券 株式会社');
ok($zip->set_number('5408605')->is_valid_number, '和光純薬工業 株式会社');
ok($zip->set_number('5408606')->is_valid_number, '株式会社 ジェーシービー 大阪支社');
ok($zip->set_number('5408607')->is_valid_number, '株式会社 りそな銀行 年金信託部');
ok($zip->set_number('5408608')->is_valid_number, '株式会社 りそなホールディングス');
ok($zip->set_number('5408610')->is_valid_number, '株式会社 りそな銀行 大阪本社');
ok($zip->set_number('5408611')->is_valid_number, '塩野義製薬 株式会社');
ok($zip->set_number('5408620')->is_valid_number, '株式会社 住友銀行 本店');
ok($zip->set_number('5408630')->is_valid_number, '株式会社 みずほ銀行 大阪支店');
ok($zip->set_number('5408639')->is_valid_number, '住友信託銀行 株式会社');
ok($zip->set_number('5408642')->is_valid_number, '三共生興 株式会社');
ok($zip->set_number('5408645')->is_valid_number, '武田薬品工業 株式会社');
ok($zip->set_number('5408660')->is_valid_number, '株式会社 ヤギ');
ok($zip->set_number('5408668')->is_valid_number, '瀧定大阪 株式会社');
ok($zip->set_number('5408670')->is_valid_number, '三菱ウェルファーマ 株式会社');
ok($zip->set_number('5408677')->is_valid_number, '三井住友海上火災保険 株式会社');
ok($zip->set_number('5408678')->is_valid_number, 'ユニチカ通商 (株)');
ok($zip->set_number('5408686')->is_valid_number, '村中医療器 株式会社');
ok($zip->set_number('5408689')->is_valid_number, '双日ロジスティクス 株式会社');
ok($zip->set_number('5408795')->is_valid_number, '近畿電気通信監理局');
ok($zip->set_number('5416666')->is_valid_number, '株式会社 大西');
ok($zip->set_number('5418501')->is_valid_number, '日本生命保険 相互会社');
ok($zip->set_number('5418502')->is_valid_number, '三菱UFJ信託銀行 株式会社 大阪証券代行部');
ok($zip->set_number('5418503')->is_valid_number, '株式会社 プロルート丸光');
ok($zip->set_number('5418504')->is_valid_number, '株式会社 ウインディ');
ok($zip->set_number('5418505')->is_valid_number, '田辺三菱製薬 株式会社');
ok($zip->set_number('5418506')->is_valid_number, '清原 株式会社');
ok($zip->set_number('5418508')->is_valid_number, '朝日火災海上保険 株式会社');
ok($zip->set_number('5418509')->is_valid_number, 'GEコンシューマーファイナンス 株式会社');
ok($zip->set_number('5418511')->is_valid_number, '興和 株式会社 大阪支店');
ok($zip->set_number('5418512')->is_valid_number, '三菱UFJリサーチ&コンサルテイング 株式会社');
ok($zip->set_number('5418514')->is_valid_number, 'アステラス製薬 株式会社 道修町事業場');
ok($zip->set_number('5418515')->is_valid_number, '株式会社 新生銀行 大阪支店');
ok($zip->set_number('5418516')->is_valid_number, 'シキボウ 株式会社');
ok($zip->set_number('5418517')->is_valid_number, '株式会社 森本組');
ok($zip->set_number('5418518')->is_valid_number, '大阪市中央区役所');
ok($zip->set_number('5418519')->is_valid_number, '東邦テキスタイル 株式会社');
ok($zip->set_number('5418520')->is_valid_number, '清水建設 株式会社 大阪支店');
ok($zip->set_number('5418521')->is_valid_number, 'コスモ証券 株式会社');
ok($zip->set_number('5418523')->is_valid_number, '関西ペイント 株式会社');
ok($zip->set_number('5418524')->is_valid_number, '大日本住友製薬 株式会社');
ok($zip->set_number('5418525')->is_valid_number, '大日本インキ化学工業 株式会社 大阪支店');
ok($zip->set_number('5418526')->is_valid_number, '小野薬品工業 株式会社');
ok($zip->set_number('5418528')->is_valid_number, '株式会社 日建設計');
ok($zip->set_number('5418529')->is_valid_number, '前田建設工業 株式会社 関西支店');
ok($zip->set_number('5418530')->is_valid_number, '株式会社 三菱東京UFJ銀行 大阪事務センター');
ok($zip->set_number('5418534')->is_valid_number, '村田長 株式会社');
ok($zip->set_number('5418535')->is_valid_number, '株式会社 三菱東京UFJ銀行 大阪中央支店');
ok($zip->set_number('5418537')->is_valid_number, '三井住友カード 株式会社');
ok($zip->set_number('5418538')->is_valid_number, 'ミズノ 株式会社 大阪店');
ok($zip->set_number('5418539')->is_valid_number, 'UFJニコス 株式会社');
ok($zip->set_number('5418540')->is_valid_number, 'NI帝人商事 株式会社');
ok($zip->set_number('5418541')->is_valid_number, 'オーミケンシ 株式会社');
ok($zip->set_number('5418542')->is_valid_number, '野村貿易 株式会社');
ok($zip->set_number('5418543')->is_valid_number, '上野製薬 株式会社');
ok($zip->set_number('5418545')->is_valid_number, '株式会社 損害保険ジャパン');
ok($zip->set_number('5418546')->is_valid_number, '住宅金融公庫 大阪支店');
ok($zip->set_number('5418547')->is_valid_number, 'あいおい損害保険 株式会社');
ok($zip->set_number('5418548')->is_valid_number, '大阪府中小企業信用保証協会');
ok($zip->set_number('5418549')->is_valid_number, '全国健康保険協会 大阪支部');
ok($zip->set_number('5418550')->is_valid_number, '住友工業 株式会社');
ok($zip->set_number('5418553')->is_valid_number, 'サッポロビール 株式会社 近畿圏本部');
ok($zip->set_number('5418554')->is_valid_number, '株式会社 日経ラジオ社 大阪支社');
ok($zip->set_number('5418556')->is_valid_number, '近畿厚生局');
ok($zip->set_number('5418557')->is_valid_number, '神鋼商事 株式会社');
ok($zip->set_number('5418558')->is_valid_number, '日商岩井 株式会社');
ok($zip->set_number('5418559')->is_valid_number, '日本板硝子 株式会社');
ok($zip->set_number('5418563')->is_valid_number, '旭洋紙パルプ 株式会社');
ok($zip->set_number('5418565')->is_valid_number, '株式会社 三越大阪店');
ok($zip->set_number('5418566')->is_valid_number, 'ユニチカ 株式会社');
ok($zip->set_number('5418568')->is_valid_number, 'コスモ石油 株式会社 大阪支店');
ok($zip->set_number('5418571')->is_valid_number, '日本流通産業 株式会社');
ok($zip->set_number('5418575')->is_valid_number, '株式会社 明成商会');
ok($zip->set_number('5418576')->is_valid_number, '住友商事ケミカル 株式会社 関西支社');
ok($zip->set_number('5418577')->is_valid_number, '伊藤忠商事 株式会社');
ok($zip->set_number('5418578')->is_valid_number, '財団法人 簡易保険加入者協会 近畿地方本部');
ok($zip->set_number('5418579')->is_valid_number, 'オリックス・レンテック 株式会社');
ok($zip->set_number('5418581')->is_valid_number, '倉敷紡績 株式会社');
ok($zip->set_number('5418583')->is_valid_number, '三菱UFJ信託銀行 株式会社 大阪証券代行部(北浜分室)');
ok($zip->set_number('5418584')->is_valid_number, '松下リース・クレジット 株式会社');
ok($zip->set_number('5418585')->is_valid_number, '阪和興業 株式会社');
ok($zip->set_number('5418586')->is_valid_number, '日本ハム 株式会社');
ok($zip->set_number('5418587')->is_valid_number, '帝人 株式会社');
ok($zip->set_number('5418589')->is_valid_number, 'オザックス 株式会社');
ok($zip->set_number('5428501')->is_valid_number, '株式会社 大丸 大阪心斎橋店');
ok($zip->set_number('5428502')->is_valid_number, '株式会社 ジェイテクト');
ok($zip->set_number('5428503')->is_valid_number, '南海電気鉄道 株式会社');
ok($zip->set_number('5428504')->is_valid_number, '住江織物 株式会社');
ok($zip->set_number('5428510')->is_valid_number, '株式会社 高島屋 大阪店');
ok($zip->set_number('5428511')->is_valid_number, '大和証券 株式会社 難波支店');
ok($zip->set_number('5428522')->is_valid_number, '村本建設 株式会社');
ok($zip->set_number('5428523')->is_valid_number, '日産プリンス大阪販売 株式会社');
ok($zip->set_number('5428525')->is_valid_number, '株式会社 ドウシシャ');
ok($zip->set_number('5428533')->is_valid_number, '株式会社 東急ハンズ 心斎橋店');
ok($zip->set_number('5428542')->is_valid_number, '株式会社 USEN 大阪事務センター');
ok($zip->set_number('5428550')->is_valid_number, '豊田通商 株式会社 大阪支店');
ok($zip->set_number('5428554')->is_valid_number, '株式会社 カナデン 関西支社');
ok($zip->set_number('5428555')->is_valid_number, '株式会社 そごう 大阪店');
ok($zip->set_number('5428558')->is_valid_number, '稲畑産業 株式会社');
ok($zip->set_number('5428566')->is_valid_number, 'クラブツーリズム 株式会社');
ok($zip->set_number('5428567')->is_valid_number, '冨士火災海上保険 株式会社');
ok($zip->set_number('5428577')->is_valid_number, '株式会社 誠和商会');
ok($zip->set_number('5428580')->is_valid_number, '大阪府医師協同組合');
ok($zip->set_number('5428585')->is_valid_number, '株式会社 エスエスケイ');
ok($zip->set_number('5428586')->is_valid_number, '南税務署');
ok($zip->set_number('5428588')->is_valid_number, '株式会社 日伝');
ok($zip->set_number('5428654')->is_valid_number, '株式会社 関西アーバン銀行');
ok($zip->set_number('5428660')->is_valid_number, 'ユアサ商事 株式会社 関西支社');
ok($zip->set_number('5428686')->is_valid_number, '株式会社 福徳銀行');
ok($zip->set_number('5428688')->is_valid_number, '株式会社 住友クレジットサービス');
ok($zip->set_number('5428745')->is_valid_number, '大阪府医師協同組合');
ok($zip->set_number('5438501')->is_valid_number, '大阪市天王寺区役所');
ok($zip->set_number('5438502')->is_valid_number, '大阪警察病院');
ok($zip->set_number('5438543')->is_valid_number, '株式会社 近鉄百貨店 上本町店');
ok($zip->set_number('5438555')->is_valid_number, '大阪赤十字病院');
ok($zip->set_number('5438558')->is_valid_number, '株式会社 森本組');
ok($zip->set_number('5438585')->is_valid_number, '近畿日本鉄道 株式会社');
ok($zip->set_number('5438588')->is_valid_number, '天王寺年金事務所');
ok($zip->set_number('5438601')->is_valid_number, 'ゼット 株式会社');
ok($zip->set_number('5438666')->is_valid_number, '大阪信用金庫');
ok($zip->set_number('5438686')->is_valid_number, 'ギフコ 株式会社');
ok($zip->set_number('5438688')->is_valid_number, '株式会社 浅沼組 大阪本店');
ok($zip->set_number('5448501')->is_valid_number, '生野区役所');
ok($zip->set_number('5448555')->is_valid_number, '生野税務署');
ok($zip->set_number('5448666')->is_valid_number, 'ロート製薬 株式会社');
ok($zip->set_number('5458501')->is_valid_number, '大阪市阿倍野区役所');
ok($zip->set_number('5458511')->is_valid_number, '大杉製薬 株式会社');
ok($zip->set_number('5458522')->is_valid_number, 'シャープ 株式会社');
ok($zip->set_number('5458533')->is_valid_number, '大阪市 あべの市税事務所');
ok($zip->set_number('5458545')->is_valid_number, '株式会社 近鉄百貨店');
ok($zip->set_number('5458550')->is_valid_number, '大阪市環境事業局');
ok($zip->set_number('5458555')->is_valid_number, '株式会社 奥村組');
ok($zip->set_number('5458558')->is_valid_number, '大阪府 なにわ南府税事務所');
ok($zip->set_number('5458585')->is_valid_number, '大阪市立大学 医学部');
ok($zip->set_number('5458586')->is_valid_number, '大阪市立大学 医学部付属病院');
ok($zip->set_number('5468501')->is_valid_number, '東住吉区役所');
ok($zip->set_number('5478501')->is_valid_number, '東住吉税務署');
ok($zip->set_number('5478510')->is_valid_number, 'シャープエンジニアリング 株式会社');
ok($zip->set_number('5478514')->is_valid_number, '株式会社 コアデ');
ok($zip->set_number('5478580')->is_valid_number, '平野区役所');
ok($zip->set_number('5498501')->is_valid_number, '関西国際空港 株式会社');
ok($zip->set_number('5498585')->is_valid_number, 'A&F・Aviation 株式会社');
ok($zip->set_number('5508501')->is_valid_number, '大阪市西区役所');
ok($zip->set_number('5508502')->is_valid_number, '杉本商事 株式会社');
ok($zip->set_number('5508503')->is_valid_number, '労働法令新報社');
ok($zip->set_number('5508505')->is_valid_number, '大阪府 なにわ西府税事務所');
ok($zip->set_number('5508522')->is_valid_number, 'クラブツーリズム 株式会社');
ok($zip->set_number('5508527')->is_valid_number, 'アズワン 株式会社');
ok($zip->set_number('5508538')->is_valid_number, '近畿労働金庫');
ok($zip->set_number('5508550')->is_valid_number, '住友電設 株式会社');
ok($zip->set_number('5508552')->is_valid_number, '大阪市交通局');
ok($zip->set_number('5508555')->is_valid_number, '株式会社 立花エレテック');
ok($zip->set_number('5508558')->is_valid_number, '株式会社 角川マーケティング関西オフィス');
ok($zip->set_number('5508566')->is_valid_number, '大阪市消防局');
ok($zip->set_number('5508567')->is_valid_number, '大阪トヨペット 株式会社');
ok($zip->set_number('5508570')->is_valid_number, 'デイリースポーツ 大阪本社');
ok($zip->set_number('5508575')->is_valid_number, '株式会社 京阪神エルマガジン社');
ok($zip->set_number('5508577')->is_valid_number, '日本興亜損害保険 株式会社');
ok($zip->set_number('5508578')->is_valid_number, '(株) オーエムエムジー');
ok($zip->set_number('5508580')->is_valid_number, '株式会社 栗本鐵工所');
ok($zip->set_number('5508585')->is_valid_number, '三木産業 株式会社 大阪支店');
ok($zip->set_number('5508659')->is_valid_number, '株式会社 オーツー');
ok($zip->set_number('5508660')->is_valid_number, '株式会社 山善');
ok($zip->set_number('5518501')->is_valid_number, '大正区役所');
ok($zip->set_number('5518551')->is_valid_number, '株式会社 中山製鋼所');
ok($zip->set_number('5528501')->is_valid_number, '大阪放送 株式会社');
ok($zip->set_number('5528510')->is_valid_number, '大阪市港区役所');
ok($zip->set_number('5538501')->is_valid_number, '大阪市福島区役所');
ok($zip->set_number('5538511')->is_valid_number, '大阪高等検察庁');
ok($zip->set_number('5538512')->is_valid_number, '大阪地方検察庁');
ok($zip->set_number('5538513')->is_valid_number, '人事院近畿事務局');
ok($zip->set_number('5538550')->is_valid_number, '株式会社 大水');
ok($zip->set_number('5538553')->is_valid_number, '阪神電気鉄道 株式会社');
ok($zip->set_number('5538567')->is_valid_number, '大阪福島税務署');
ok($zip->set_number('5538585')->is_valid_number, '福島年金事務所');
ok($zip->set_number('5538739')->is_valid_number, '学校法人 創造社学園 創造社デザイン専門学校');
ok($zip->set_number('5548501')->is_valid_number, '大阪市此花区役所');
ok($zip->set_number('5548511')->is_valid_number, '住友電気工業 株式会社 大阪製作所');
ok($zip->set_number('5548555')->is_valid_number, '住友金属工業 株式会社 交通産機品カンパニー製鋼所');
ok($zip->set_number('5548558')->is_valid_number, '住友化学工業 株式会社 大阪工場');
ok($zip->set_number('5548588')->is_valid_number, '株式会社 アド・ダイセン');
ok($zip->set_number('5558501')->is_valid_number, '大阪市西淀川区役所');
ok($zip->set_number('5558502')->is_valid_number, '江崎グリコ 株式会社');
ok($zip->set_number('5558555')->is_valid_number, '国分 株式会社 近畿支社 西淀川流通センター');
ok($zip->set_number('5568501')->is_valid_number, '浪速区役所');
ok($zip->set_number('5568510')->is_valid_number, 'fm osaka');
ok($zip->set_number('5568512')->is_valid_number, '株式会社 損害保険ジャパン');
ok($zip->set_number('5568515')->is_valid_number, '株式会社 サンケイリビング新聞社');
ok($zip->set_number('5568516')->is_valid_number, '株式会社 リビングプロシード');
ok($zip->set_number('5568550')->is_valid_number, '上新電機 株式会社');
ok($zip->set_number('5568555')->is_valid_number, '東洋紙業 株式会社');
ok($zip->set_number('5568558')->is_valid_number, 'エルエイト');
ok($zip->set_number('5568585')->is_valid_number, '難波年金事務所');
ok($zip->set_number('5568601')->is_valid_number, '株式会社 クボタ 本社');
ok($zip->set_number('5568660')->is_valid_number, '株式会社 産業経済新聞社');
ok($zip->set_number('5568663')->is_valid_number, 'サンケイスポーツ');
ok($zip->set_number('5568664')->is_valid_number, '夕刊フジ');
ok($zip->set_number('5568665')->is_valid_number, 'サンケイチケットセンター');
ok($zip->set_number('5568666')->is_valid_number, '産經新聞開発 株式会社');
ok($zip->set_number('5568670')->is_valid_number, '大阪市 なんば市税事務所');
ok($zip->set_number('5578501')->is_valid_number, '大阪市西成区役所');
ok($zip->set_number('5588501')->is_valid_number, '大阪市住吉区役所');
ok($zip->set_number('5588555')->is_valid_number, '住吉税務署');
ok($zip->set_number('5588558')->is_valid_number, '大阪府立 急性期・総合医療センター');
ok($zip->set_number('5588585')->is_valid_number, '大阪市立大学');
ok($zip->set_number('5598501')->is_valid_number, '株式会社 ライカ');
ok($zip->set_number('5598510')->is_valid_number, 'ミズノ 株式会社');
ok($zip->set_number('5598511')->is_valid_number, '社団法人 大阪府自動車整備振興会');
ok($zip->set_number('5598519')->is_valid_number, 'いであ 株式会社 大阪支社');
ok($zip->set_number('5598522')->is_valid_number, '関西インターメディア (株) FM.CO.CO.LO');
ok($zip->set_number('5598550')->is_valid_number, '津田産業 株式会社');
ok($zip->set_number('5598553')->is_valid_number, '株式会社 ロゴスコーポレーション');
ok($zip->set_number('5598555')->is_valid_number, '大阪府 咲洲庁舎');
ok($zip->set_number('5598558')->is_valid_number, '大阪市水道局');
ok($zip->set_number('5598559')->is_valid_number, '日立造船 株式会社');
ok($zip->set_number('5598560')->is_valid_number, '玉出年金事務所');
ok($zip->set_number('5598561')->is_valid_number, '株式会社 グルメ杵屋');
ok($zip->set_number('5598585')->is_valid_number, '真生印刷 株式会社');
ok($zip->set_number('5598588')->is_valid_number, 'デジタルプラネット衛星放送');
ok($zip->set_number('5598601')->is_valid_number, '住之江区役所');
ok($zip->set_number('5598611')->is_valid_number, '森ノ宮医療大学');
ok($zip->set_number('5598651')->is_valid_number, '三井造船 株式会社 大阪事業所');
ok($zip->set_number('5598658')->is_valid_number, '永大産業 株式会社 本社');
ok($zip->set_number('5598729')->is_valid_number, 'パナソニック 株式会社 エナジー住之江工場');
ok($zip->set_number('5608531')->is_valid_number, '大阪大学 基礎工学部/大学院基礎工学研究科');
ok($zip->set_number('5608532')->is_valid_number, '大阪大学 文学部');
ok($zip->set_number('5608543')->is_valid_number, 'パナホーム 株式会社');
ok($zip->set_number('5608548')->is_valid_number, '全日空整備 株式会社');
ok($zip->set_number('5608552')->is_valid_number, '独立行政法人 国立病院機構 刀根山病院');
ok($zip->set_number('5608555')->is_valid_number, '株式会社 ニッショーストアー事業本部');
ok($zip->set_number('5608560')->is_valid_number, '豊中年金事務所');
ok($zip->set_number('5608561')->is_valid_number, 'NHK 千里営業センター');
ok($zip->set_number('5608565')->is_valid_number, '市立豊中病院');
ok($zip->set_number('5608567')->is_valid_number, '株式会社 廣済堂');
ok($zip->set_number('5608579')->is_valid_number, '株式会社 オートバックスセブン');
ok($zip->set_number('5608580')->is_valid_number, '株式会社 損害保険ジャパン');
ok($zip->set_number('5618501')->is_valid_number, '豊中市役所');
ok($zip->set_number('5618510')->is_valid_number, '株式会社 日本経営');
ok($zip->set_number('5618511')->is_valid_number, '大阪北生活協同組合');
ok($zip->set_number('5618520')->is_valid_number, '摂津水都信用金庫');
ok($zip->set_number('5618550')->is_valid_number, '株式会社 イーパック');
ok($zip->set_number('5618555')->is_valid_number, '学校法人 大阪音楽大学');
ok($zip->set_number('5618558')->is_valid_number, '松尾電機 株式会社');
ok($zip->set_number('5618561')->is_valid_number, '阪急バス 株式会社');
ok($zip->set_number('5618577')->is_valid_number, '学校法人 大商学園 大商学園高等学校');
ok($zip->set_number('5628505')->is_valid_number, 'フィガロ技研 株式会社');
ok($zip->set_number('5628508')->is_valid_number, '宗教法人 勝尾寺');
ok($zip->set_number('5628511')->is_valid_number, '株式会社 ロイネ');
ok($zip->set_number('5628522')->is_valid_number, '宇野 株式会社');
ok($zip->set_number('5628543')->is_valid_number, '学校法人 聖母被昇天学院');
ok($zip->set_number('5628555')->is_valid_number, '株式会社 アラミック');
ok($zip->set_number('5628558')->is_valid_number, '国立大学法人 大阪大学 外国語学部');
ok($zip->set_number('5628560')->is_valid_number, '株式会社 理喜');
ok($zip->set_number('5628562')->is_valid_number, '箕面市立病院');
ok($zip->set_number('5628567')->is_valid_number, 'ガラシア病院');
ok($zip->set_number('5628568')->is_valid_number, 'キングベビー 株式会社');
ok($zip->set_number('5628580')->is_valid_number, '大阪青山短期大学・大阪青山大学');
ok($zip->set_number('5628585')->is_valid_number, 'おたふく手袋 株式会社');
ok($zip->set_number('5628586')->is_valid_number, 'ヘンケルジャパン 株式会社');
ok($zip->set_number('5628588')->is_valid_number, 'センコー 株式会社 東大阪支店船場PDセンター');
ok($zip->set_number('5628686')->is_valid_number, '株式会社 ペプチド研究所、財団法人 蛋白質研究奨励会、有限会社 千里インターナショナル');
ok($zip->set_number('5630292')->is_valid_number, '豊能町');
ok($zip->set_number('5630392')->is_valid_number, '能勢町役場');
ok($zip->set_number('5638510')->is_valid_number, '市立 池田病院');
ok($zip->set_number('5638567')->is_valid_number, '大阪法務局 池田出張所');
ok($zip->set_number('5638577')->is_valid_number, '独立行政法人 産業技術総合研究所 関西センター');
ok($zip->set_number('5638588')->is_valid_number, '大阪府 豊能府税事務所');
ok($zip->set_number('5648501')->is_valid_number, 'オッペン化粧品');
ok($zip->set_number('5648503')->is_valid_number, 'ジェフサセントラル 株式会社');
ok($zip->set_number('5648511')->is_valid_number, '大阪学院大学');
ok($zip->set_number('5648515')->is_valid_number, '吹田税務署');
ok($zip->set_number('5648523')->is_valid_number, '日本システム収納 株式会社');
ok($zip->set_number('5648550')->is_valid_number, '吹田市役所');
ok($zip->set_number('5648551')->is_valid_number, '吹田市水道部');
ok($zip->set_number('5648555')->is_valid_number, '株式会社 日本創造教育研究所');
ok($zip->set_number('5648567')->is_valid_number, '吹田市民病院');
ok($zip->set_number('5648580')->is_valid_number, '株式会社 メディカ出版');
ok($zip->set_number('5648585')->is_valid_number, '株式会社 フォーベル');
ok($zip->set_number('5648650')->is_valid_number, '株式会社 モリタ');
ok($zip->set_number('5648651')->is_valid_number, '三井信託銀行 大阪事務センター');
ok($zip->set_number('5648680')->is_valid_number, '関西大学');
ok($zip->set_number('5658511')->is_valid_number, '国立民族学博物館');
ok($zip->set_number('5658540')->is_valid_number, '株式会社 クリエイティブ阪急');
ok($zip->set_number('5658565')->is_valid_number, '国立循環器病センター');
ok($zip->set_number('5668501')->is_valid_number, '学校法人 薫英学園');
ok($zip->set_number('5668513')->is_valid_number, 'コカ・コーラウエスト 株式会社');
ok($zip->set_number('5668555')->is_valid_number, '摂津市役所');
ok($zip->set_number('5668566')->is_valid_number, '株式会社 梅丹本舗');
ok($zip->set_number('5668585')->is_valid_number, 'ダイキン工業 株式会社 淀川製作所');
ok($zip->set_number('5668686')->is_valid_number, '株式会社 エネゲート 千里丘事業所');
ok($zip->set_number('5678501')->is_valid_number, '株式会社 明治屋食品工場');
ok($zip->set_number('5678502')->is_valid_number, '追手門学院大学');
ok($zip->set_number('5678505')->is_valid_number, '茨木市役所');
ok($zip->set_number('5678510')->is_valid_number, 'フジテック 株式会社');
ok($zip->set_number('5678511')->is_valid_number, '医療法人 恒昭会 藍野病院');
ok($zip->set_number('5678515')->is_valid_number, '大阪府 三島府税事務所');
ok($zip->set_number('5678520')->is_valid_number, 'マルカキカイ 株式会社');
ok($zip->set_number('5678521')->is_valid_number, 'サッポロビール 株式会社 大阪工場');
ok($zip->set_number('5678523')->is_valid_number, '大阪府立 茨木高等学校');
ok($zip->set_number('5678525')->is_valid_number, '株式会社 桜川ポンプ製作所');
ok($zip->set_number('5678530')->is_valid_number, '茨木労働基準監督署');
ok($zip->set_number('5678540')->is_valid_number, '大阪府立 茨木東高等学校');
ok($zip->set_number('5678557')->is_valid_number, 'ゴルフ場用品 株式会社');
ok($zip->set_number('5678567')->is_valid_number, '日立マクセル 株式会社 本社大阪事業所');
ok($zip->set_number('5678578')->is_valid_number, '梅花女子大学');
ok($zip->set_number('5678585')->is_valid_number, '大阪府 茨木保健所');
ok($zip->set_number('5678651')->is_valid_number, '摂津水都信用金庫');
ok($zip->set_number('5678680')->is_valid_number, '日東電工 株式会社 茨木事業所');
ok($zip->set_number('5691092')->is_valid_number, '平安女学院大学');
ok($zip->set_number('5691094')->is_valid_number, '大阪薬科大学');
ok($zip->set_number('5691095')->is_valid_number, '関西大学 高槻キャンパス');
ok($zip->set_number('5691096')->is_valid_number, '高槻赤十字病院');
ok($zip->set_number('5691098')->is_valid_number, '関西大学');
ok($zip->set_number('5691192')->is_valid_number, '医療法人 愛仁会 高槻病院');
ok($zip->set_number('5691193')->is_valid_number, '松下電器産業 株式会社・松下東芝映像ディスプレイ 株式会社');
ok($zip->set_number('5691194')->is_valid_number, '松下プラズマディスプレイ 株式会社');
ok($zip->set_number('5691195')->is_valid_number, 'サンスター 株式会社');
ok($zip->set_number('5691196')->is_valid_number, '株式会社 西武百貨店 高槻店');
ok($zip->set_number('5691197')->is_valid_number, '医療法人 美喜和会 美喜和会オレンジホスピタル');
ok($zip->set_number('5698501')->is_valid_number, '高槻市役所');
ok($zip->set_number('5698503')->is_valid_number, 'コニカミノルタ 高槻サイト');
ok($zip->set_number('5698505')->is_valid_number, '学校法人 高槻高等学校');
ok($zip->set_number('5698510')->is_valid_number, 'アルインコ (株)');
ok($zip->set_number('5698511')->is_valid_number, '関西電力 (株) 高槻営業所');
ok($zip->set_number('5698512')->is_valid_number, 'シンワ (株)');
ok($zip->set_number('5698520')->is_valid_number, '(株) 日新化学研究所');
ok($zip->set_number('5698522')->is_valid_number, '(株) 松坂屋 高槻店');
ok($zip->set_number('5698533')->is_valid_number, 'ムネカタ (株)');
ok($zip->set_number('5698549')->is_valid_number, '太陽エンジニヤ (株)');
ok($zip->set_number('5698555')->is_valid_number, '山下鉄工 (株)');
ok($zip->set_number('5698558')->is_valid_number, 'サンユレジン (株)');
ok($zip->set_number('5698566')->is_valid_number, '岩谷物流 (株)');
ok($zip->set_number('5698567')->is_valid_number, 'イオン (株) ジャスコシティー 高槻店');
ok($zip->set_number('5698569')->is_valid_number, '大阪ガス (株) 北東部事業本部北部事業所');
ok($zip->set_number('5698577')->is_valid_number, '丸大食品 (株)');
ok($zip->set_number('5698585')->is_valid_number, '医療法人 仙養会 北摂総合病院');
ok($zip->set_number('5698588')->is_valid_number, '港製器工業 (株)');
ok($zip->set_number('5698660')->is_valid_number, '酉島製作所');
ok($zip->set_number('5698686')->is_valid_number, '大阪医科大学');
ok($zip->set_number('5708501')->is_valid_number, '松下電器産業 (株) 技術総務センター');
ok($zip->set_number('5708502')->is_valid_number, '三洋電機 株式会社 淀川事業所');
ok($zip->set_number('5708505')->is_valid_number, '三洋電機 (株) ハイリビング事業本部');
ok($zip->set_number('5708506')->is_valid_number, '関西医科大学');
ok($zip->set_number('5708507')->is_valid_number, '関西医科大学附属病院');
ok($zip->set_number('5708511')->is_valid_number, '松下電池工業 株式会社');
ok($zip->set_number('5708515')->is_valid_number, 'NTTプリコム 株式会社');
ok($zip->set_number('5708539')->is_valid_number, '奥村機械 (株)');
ok($zip->set_number('5708540')->is_valid_number, '松下電器 健康保険組合・松下記念病院・松下健康管理センター');
ok($zip->set_number('5708555')->is_valid_number, '(学) 大阪国際学園・大阪国際女子大学・大阪国際女子短期大学');
ok($zip->set_number('5708558')->is_valid_number, '株式会社 京阪百貨店');
ok($zip->set_number('5708585')->is_valid_number, '山岡金属工業 株式会社');
ok($zip->set_number('5708588')->is_valid_number, 'いすゞ自動車近畿 株式会社');
ok($zip->set_number('5708634')->is_valid_number, '三洋電機貿易 株式会社');
ok($zip->set_number('5708666')->is_valid_number, '守口市役所');
ok($zip->set_number('5708677')->is_valid_number, '三洋電機 株式会社 本社');
ok($zip->set_number('5708686')->is_valid_number, '三洋ITソリューションズ 株式会社');
ok($zip->set_number('5718503')->is_valid_number, 'パナソニック (株) AVCネットワークス社');
ok($zip->set_number('5718504')->is_valid_number, 'パナソニック (株) AVCネットワークス社');
ok($zip->set_number('5718507')->is_valid_number, '松下産業機器 株式会社 配電器事業部');
ok($zip->set_number('5718545')->is_valid_number, '門真税務署');
ok($zip->set_number('5718555')->is_valid_number, '大阪府警察本部交通部門真運転免許試験場');
ok($zip->set_number('5718567')->is_valid_number, '大阪府 中小企業信用保証協会 門真支所');
ok($zip->set_number('5718571')->is_valid_number, 'タイガー魔法瓶 株式会社');
ok($zip->set_number('5718580')->is_valid_number, '東和薬品 株式会社');
ok($zip->set_number('5718585')->is_valid_number, '門真市役所');
ok($zip->set_number('5718633')->is_valid_number, '株式会社 アテナ商会');
ok($zip->set_number('5718686')->is_valid_number, 'パナソニック電工 株式会社');
ok($zip->set_number('5728501')->is_valid_number, '日本ペイント 株式会社 寝屋川事業所');
ok($zip->set_number('5728505')->is_valid_number, '株式会社 前田組');
ok($zip->set_number('5728507')->is_valid_number, '大阪府立 南寝屋川高等学校');
ok($zip->set_number('5728508')->is_valid_number, '摂南大学');
ok($zip->set_number('5728510')->is_valid_number, '株式会社 イトーキ寝屋川工場');
ok($zip->set_number('5728511')->is_valid_number, '寝屋川市教育委員会');
ok($zip->set_number('5728522')->is_valid_number, '大日本エリオ 株式会社 大阪工場');
ok($zip->set_number('5728528')->is_valid_number, '成田山明王院');
ok($zip->set_number('5728530')->is_valid_number, '大阪電気通信大学');
ok($zip->set_number('5728531')->is_valid_number, '聖母女学院中学高等学校・大阪聖母学院小学校');
ok($zip->set_number('5728533')->is_valid_number, '寝屋川市総合センター');
ok($zip->set_number('5728540')->is_valid_number, 'オンキョー 株式会社');
ok($zip->set_number('5728550')->is_valid_number, '関西マネジ興業 株式会社');
ok($zip->set_number('5728551')->is_valid_number, '関西医科大学香里病院');
ok($zip->set_number('5728555')->is_valid_number, '寝屋川市');
ok($zip->set_number('5728558')->is_valid_number, '日本科学冶金 株式会社');
ok($zip->set_number('5728567')->is_valid_number, '医療法人 協仁会小松病院');
ok($zip->set_number('5728570')->is_valid_number, '株式会社 エクセディ');
ok($zip->set_number('5728572')->is_valid_number, '大阪府立工業高等専門学校');
ok($zip->set_number('5728580')->is_valid_number, 'ネッツトヨタ新大阪 株式会社');
ok($zip->set_number('5728581')->is_valid_number, 'オリエント化学工業 株式会社');
ok($zip->set_number('5728585')->is_valid_number, '同志社香里高等学校');
ok($zip->set_number('5728588')->is_valid_number, '株式会社 三笑堂 大阪支店');
ok($zip->set_number('5728589')->is_valid_number, '株式会社 横井製作所');
ok($zip->set_number('5730192')->is_valid_number, '大阪国際大学');
ok($zip->set_number('5730195')->is_valid_number, '関西外語大学 穂谷学舎');
ok($zip->set_number('5731001')->is_valid_number, '学校法人 関西外国語大学');
ok($zip->set_number('5731030')->is_valid_number, '枚方市上下水道局');
ok($zip->set_number('5731040')->is_valid_number, '(株) 枚方自動車教習所');
ok($zip->set_number('5738511')->is_valid_number, '星ヶ丘厚生年金病院');
ok($zip->set_number('5738534')->is_valid_number, '三洋電機 株式会社 研究開発本部');
ok($zip->set_number('5738573')->is_valid_number, '株式会社 クボタ 枚方製造所');
ok($zip->set_number('5738666')->is_valid_number, '枚方市役所');
ok($zip->set_number('5748501')->is_valid_number, '京セラ 株式会社 大阪大東事業所');
ok($zip->set_number('5748530')->is_valid_number, '大阪産業大学');
ok($zip->set_number('5748534')->is_valid_number, '三洋電機 株式会社');
ok($zip->set_number('5748555')->is_valid_number, '大阪府 大東市役所');
ok($zip->set_number('5758501')->is_valid_number, '四條畷市役所');
ok($zip->set_number('5758511')->is_valid_number, '畷生会脳神経外科病院');
ok($zip->set_number('5758555')->is_valid_number, '大岡広 株式会社');
ok($zip->set_number('5758558')->is_valid_number, '竹本行政書士事務所');
ok($zip->set_number('5758585')->is_valid_number, 'サン電子工業 株式会社');
ok($zip->set_number('5758588')->is_valid_number, '松本引越センター');
ok($zip->set_number('5768501')->is_valid_number, '交野市役所');
ok($zip->set_number('5778502')->is_valid_number, '近畿大学');
ok($zip->set_number('5778503')->is_valid_number, '若井産業 株式会社');
ok($zip->set_number('5778505')->is_valid_number, '学校法人 谷岡学園 大阪商業大学');
ok($zip->set_number('5778509')->is_valid_number, '大阪府 中河内府税事務所');
ok($zip->set_number('5778511')->is_valid_number, '近畿車輛 株式会社');
ok($zip->set_number('5778520')->is_valid_number, 'ハウス食品 株式会社 大阪本社');
ok($zip->set_number('5778521')->is_valid_number, '東大阪市役所');
ok($zip->set_number('5778522')->is_valid_number, '株式会社 エルネット ぱど事業部 東大阪営業部');
ok($zip->set_number('5778533')->is_valid_number, '株式会社 鳴門屋');
ok($zip->set_number('5778537')->is_valid_number, 'ホリアキ 株式会社');
ok($zip->set_number('5778540')->is_valid_number, '株式会社 多磨屋');
ok($zip->set_number('5778550')->is_valid_number, '学校法人 樟蔭学園 大阪樟蔭女子大学 樟蔭高等学校 樟蔭中学校 大阪樟蔭女子大学付属幼稚園');
ok($zip->set_number('5778551')->is_valid_number, '内外電機 株式会社');
ok($zip->set_number('5778554')->is_valid_number, '東大阪社会保険事務所');
ok($zip->set_number('5778555')->is_valid_number, '大阪法務局 東大阪支局');
ok($zip->set_number('5778558')->is_valid_number, '東大阪簡易裁判所');
ok($zip->set_number('5778560')->is_valid_number, '株式会社 ライオン事務器');
ok($zip->set_number('5778566')->is_valid_number, '株式会社 竹綱製作所');
ok($zip->set_number('5778567')->is_valid_number, '学校法人 村上学園 (東大阪大学 東大阪大学短期大学部 敬愛女子高等学校 東大阪大学付属幼稚園)');
ok($zip->set_number('5778575')->is_valid_number, '(株) ダイモ');
ok($zip->set_number('5778577')->is_valid_number, '株式会社 丸金');
ok($zip->set_number('5778581')->is_valid_number, 'ミカミ工業 株式会社');
ok($zip->set_number('5778582')->is_valid_number, 'トーコー 株式会社');
ok($zip->set_number('5778585')->is_valid_number, '布施公共職業安定所 (ハローワーク布施)');
ok($zip->set_number('5778588')->is_valid_number, '井上定 株式会社');
ok($zip->set_number('5778611')->is_valid_number, 'P&Gパンパース');
ok($zip->set_number('5788501')->is_valid_number, 'トラスコ中山 株式会社 大阪支店');
ok($zip->set_number('5788502')->is_valid_number, '大阪ガス 株式会社 北東部事業本部');
ok($zip->set_number('5788511')->is_valid_number, '株式会社 日伝');
ok($zip->set_number('5788515')->is_valid_number, 'ホーチキ 株式会社');
ok($zip->set_number('5788522')->is_valid_number, '株式会社 不二越 西日本支社');
ok($zip->set_number('5788555')->is_valid_number, 'トラスコ中山 株式会社');
ok($zip->set_number('5788577')->is_valid_number, '白子 株式会社 大阪支店');
ok($zip->set_number('5788585')->is_valid_number, 'タツタ電線 株式会社');
ok($zip->set_number('5788588')->is_valid_number, '東大阪市立 総合病院');
ok($zip->set_number('5798501')->is_valid_number, '法務省 大阪法務局 枚岡出張所');
ok($zip->set_number('5798502')->is_valid_number, '三浦工業 株式会社');
ok($zip->set_number('5808501')->is_valid_number, '松原市役所');
ok($zip->set_number('5808502')->is_valid_number, '阪南大学');
ok($zip->set_number('5808503')->is_valid_number, '藤本製薬 株式会社');
ok($zip->set_number('5808504')->is_valid_number, '山崎製パン 株式会社 大阪第二工場');
ok($zip->set_number('5808505')->is_valid_number, '株式会社 犬印本舗');
ok($zip->set_number('5808601')->is_valid_number, 'シャディ 株式会社');
ok($zip->set_number('5818505')->is_valid_number, '三起商行 株式会社');
ok($zip->set_number('5818511')->is_valid_number, '大阪経済法科大学');
ok($zip->set_number('5818539')->is_valid_number, '(株) ヤラカス舘 プロダクトセンター');
ok($zip->set_number('5818558')->is_valid_number, '株式会社 ミキハウス');
ok($zip->set_number('5818585')->is_valid_number, 'シャープ 株式会社 健康・環境システム事業本部');
ok($zip->set_number('5818686')->is_valid_number, '株式会社 クボタ 久宝寺事業センター');
ok($zip->set_number('5828501')->is_valid_number, 'パナソニックサイクルテック 株式会社');
ok($zip->set_number('5828555')->is_valid_number, '柏原市役所');
ok($zip->set_number('5828582')->is_valid_number, '大阪教育大学');
ok($zip->set_number('5828585')->is_valid_number, '東大阪大学柏原高等学校');
ok($zip->set_number('5838501')->is_valid_number, '四天王寺国際仏教大学');
ok($zip->set_number('5838522')->is_valid_number, 'シャープ 株式会社 藤井寺事業所');
ok($zip->set_number('5838550')->is_valid_number, 'ミツワ電機工業 株式会社');
ok($zip->set_number('5838555')->is_valid_number, '大阪府立看護大学');
ok($zip->set_number('5838558')->is_valid_number, '大阪女子短期大学・大阪女子短期大学高等学校');
ok($zip->set_number('5838563')->is_valid_number, 'ニチバン 株式会社 大阪工場');
ok($zip->set_number('5838580')->is_valid_number, '太子町役場');
ok($zip->set_number('5838583')->is_valid_number, '藤井寺市役所');
ok($zip->set_number('5838585')->is_valid_number, '羽曳野市役所');
ok($zip->set_number('5838588')->is_valid_number, '大阪府立 羽曳野病院');
ok($zip->set_number('5848511')->is_valid_number, '富田林市役所');
ok($zip->set_number('5848522')->is_valid_number, '大阪大谷短期大学');
ok($zip->set_number('5848531')->is_valid_number, '大阪府 南河内府税事務所');
ok($zip->set_number('5848540')->is_valid_number, '大阪大谷大学');
ok($zip->set_number('5848585')->is_valid_number, '医療法人 宝生会PL病院');
ok($zip->set_number('5848651')->is_valid_number, 'パーフェクトリバティー教団 (PL)大本庁');
ok($zip->set_number('5858501')->is_valid_number, '千早赤阪村役場');
ok($zip->set_number('5858550')->is_valid_number, '大阪芸術大学 通信教育部');
ok($zip->set_number('5858555')->is_valid_number, '大阪芸術大学');
ok($zip->set_number('5858585')->is_valid_number, '河南町役場');
ok($zip->set_number('5868501')->is_valid_number, '河内長野市役所');
ok($zip->set_number('5868511')->is_valid_number, '大阪千代田短期大学');
ok($zip->set_number('5868515')->is_valid_number, '大阪法務局 長野出張所');
ok($zip->set_number('5868521')->is_valid_number, '独立行政法人 国立病院機構 大阪南医療センター');
ok($zip->set_number('5868528')->is_valid_number, '(株) 吉年');
ok($zip->set_number('5868555')->is_valid_number, 'モリ工業 株式会社');
ok($zip->set_number('5868577')->is_valid_number, '学校法人 千代田学園');
ok($zip->set_number('5868585')->is_valid_number, '学校法人 清教学園');
ok($zip->set_number('5878555')->is_valid_number, '学校法人 天満学園 太成学院大学');
ok($zip->set_number('5878585')->is_valid_number, '美原区役所');
ok($zip->set_number('5878586')->is_valid_number, '美原区役所 別館');
ok($zip->set_number('5898501')->is_valid_number, '大阪狭山市役所');
ok($zip->set_number('5898502')->is_valid_number, '象印チェンブロック 株式会社');
ok($zip->set_number('5898511')->is_valid_number, '近畿大学医学部付属病院');
ok($zip->set_number('5898585')->is_valid_number, '帝塚山学院大学');
ok($zip->set_number('5900481')->is_valid_number, '原子燃料工業 株式会社 熊取事業所');
ok($zip->set_number('5900482')->is_valid_number, '関西鍼灸大学');
ok($zip->set_number('5900493')->is_valid_number, '大阪観光大学');
ok($zip->set_number('5900494')->is_valid_number, '京都大学 原子炉実験所');
ok($zip->set_number('5900495')->is_valid_number, '熊取町役場');
ok($zip->set_number('5900496')->is_valid_number, '学校法人 浪商学園大阪体育大学');
ok($zip->set_number('5900592')->is_valid_number, '大阪府泉南市役所');
ok($zip->set_number('5908501')->is_valid_number, 'ダイセル化学工業 株式会社 大阪本社');
ok($zip->set_number('5908503')->is_valid_number, 'コーニングジャパン 株式会社 堺工場');
ok($zip->set_number('5908511')->is_valid_number, '大阪地方裁判所 堺支部');
ok($zip->set_number('5908517')->is_valid_number, '大陽日酸 株式会社 堺浜ファインガスセンター');
ok($zip->set_number('5908522')->is_valid_number, 'シャープ 株式会社 堺コンビナート建設推進本部');
ok($zip->set_number('5908527')->is_valid_number, 'ナガセケムテックス 株式会社 堺工場');
ok($zip->set_number('5908528')->is_valid_number, '長瀬産業 株式会社 堺営業所');
ok($zip->set_number('5908529')->is_valid_number, '株式会社 堺ガスセンター');
ok($zip->set_number('5908530')->is_valid_number, '生活情報サンロクマル事業部');
ok($zip->set_number('5908540')->is_valid_number, '新日本製鐵 株式會社 堺製鐵所');
ok($zip->set_number('5908550')->is_valid_number, '堺税務署');
ok($zip->set_number('5908551')->is_valid_number, 'コニカミノルタホールディングス 株式会社 堺サイトー');
ok($zip->set_number('5908560')->is_valid_number, '大阪法務局 堺支局');
ok($zip->set_number('5908567')->is_valid_number, '株式会社 泉州銀行 事務統括部');
ok($zip->set_number('5908577')->is_valid_number, '株式会社 シマノ');
ok($zip->set_number('5908585')->is_valid_number, 'EH 株式会社');
ok($zip->set_number('5908588')->is_valid_number, '真諭商 株式会社');
ok($zip->set_number('5908686')->is_valid_number, 'サマーウッド 株式会社');
ok($zip->set_number('5918501')->is_valid_number, '大阪労災病院');
ok($zip->set_number('5918502')->is_valid_number, '堺商工会議所');
ok($zip->set_number('5918505')->is_valid_number, '堺市上下水道局');
ok($zip->set_number('5918511')->is_valid_number, 'ダイキン工業 株式会社 堺製作所 金岡工場');
ok($zip->set_number('5918555')->is_valid_number, '国立療養所 近畿中央病院');
ok($zip->set_number('5928585')->is_valid_number, '高石市役所');
ok($zip->set_number('5941198')->is_valid_number, '桃山学院大学');
ok($zip->set_number('5948501')->is_valid_number, '和泉市役所');
ok($zip->set_number('5948502')->is_valid_number, '自衛隊 信太山駐屯地');
ok($zip->set_number('5958555')->is_valid_number, '株式会社 GNN');
ok($zip->set_number('5958558')->is_valid_number, '大阪法務局 泉出張所');
ok($zip->set_number('5958585')->is_valid_number, '泉大津税務署');
ok($zip->set_number('5958650')->is_valid_number, '住友ゴム工業 泉大津工場');
ok($zip->set_number('5958686')->is_valid_number, '泉大津市役所');
ok($zip->set_number('5968510')->is_valid_number, '岸和田市役所');
ok($zip->set_number('5968624')->is_valid_number, 'フジ住宅 株式会社 フジホームバンク おうち館');
ok($zip->set_number('5968654')->is_valid_number, '株式会社 泉州銀行 本店');
ok($zip->set_number('5968686')->is_valid_number, '泉州信用金庫 本部');
ok($zip->set_number('5978501')->is_valid_number, '株式会社 デザック二色浜製造所');
ok($zip->set_number('5978502')->is_valid_number, '根来産業 株式会社');
ok($zip->set_number('5978511')->is_valid_number, '寺田紡績 株式会社');
ok($zip->set_number('5978515')->is_valid_number, '奥本製粉 株式会社');
ok($zip->set_number('5978522')->is_valid_number, 'マルフク事業 協同組合');
ok($zip->set_number('5978543')->is_valid_number, '加藤産業 株式会社 阪和支店');
ok($zip->set_number('5978555')->is_valid_number, '株式会社 セイサ');
ok($zip->set_number('5978585')->is_valid_number, '貝塚市役所');
ok($zip->set_number('5978588')->is_valid_number, '宮崎鉄工 株式会社');
ok($zip->set_number('5978686')->is_valid_number, '貝塚社会保険事務所');
ok($zip->set_number('5988503')->is_valid_number, '泉佐野 税務署');
ok($zip->set_number('5988508')->is_valid_number, 'りんくう プレミアム・アウトレット');
ok($zip->set_number('5988511')->is_valid_number, '全日空ゲートタワーホテル大阪');
ok($zip->set_number('5988522')->is_valid_number, '関西エアポートワシントンホテル');
ok($zip->set_number('5988531')->is_valid_number, '大阪府立大学 りんくうキャンパス');
ok($zip->set_number('5988550')->is_valid_number, '泉佐野市役所');
ok($zip->set_number('5988555')->is_valid_number, 'りんくうパピリオ管理事務所');
ok($zip->set_number('5988560')->is_valid_number, '大阪府立 佐野工業高等学校');
ok($zip->set_number('5988566')->is_valid_number, 'ジェイコムウエストメディア事業部りんくうサブセンター');
ok($zip->set_number('5990292')->is_valid_number, '阪南市役所');
ok($zip->set_number('5990392')->is_valid_number, '岬町役場');
ok($zip->set_number('5998531')->is_valid_number, '大阪府立大学');
ok($zip->set_number('6008501')->is_valid_number, '浄土真宗本願寺派宗務所');
ok($zip->set_number('6008502')->is_valid_number, '株式会社 京都西川');
ok($zip->set_number('6008503')->is_valid_number, '株式会社 井筒');
ok($zip->set_number('6008505')->is_valid_number, '真宗大谷派 (東本願寺) 宗務所');
ok($zip->set_number('6008510')->is_valid_number, '株式会社 阪急百貨店 四条河原町阪急');
ok($zip->set_number('6008511')->is_valid_number, '株式会社 大丸 京都店');
ok($zip->set_number('6008519')->is_valid_number, '株式会社 京都東急ホテル');
ok($zip->set_number('6008530')->is_valid_number, 'オムロン (株) 京都事業所');
ok($zip->set_number('6008540')->is_valid_number, 'ワタベウェディング 株式会社');
ok($zip->set_number('6008550')->is_valid_number, '株式会社 ロプロ');
ok($zip->set_number('6008555')->is_valid_number, '株式会社 ジェイアール西日本伊勢丹');
ok($zip->set_number('6008558')->is_valid_number, '医療法人 財団康生会 武田病院');
ok($zip->set_number('6008566')->is_valid_number, '株式会社 エフエム京都');
ok($zip->set_number('6008567')->is_valid_number, '株式会社 丸井 京都マルイ');
ok($zip->set_number('6008570')->is_valid_number, '東京海上日動火災保険 株式会社');
ok($zip->set_number('6008581')->is_valid_number, '京つけもの 西利');
ok($zip->set_number('6008585')->is_valid_number, '財団法人 日本漢字能力検定協会');
ok($zip->set_number('6008586')->is_valid_number, '株式会社 京都パープルサンガ');
ok($zip->set_number('6008588')->is_valid_number, '京都市下京区役所');
ok($zip->set_number('6008652')->is_valid_number, '株式会社 京都銀行');
ok($zip->set_number('6008665')->is_valid_number, '京都中央信用金庫');
ok($zip->set_number('6008666')->is_valid_number, '株式会社 千趣会');
ok($zip->set_number('6008677')->is_valid_number, '株式会社 ニッセン');
ok($zip->set_number('6008686')->is_valid_number, 'タキイ種苗 株式会社');
ok($zip->set_number('6008711')->is_valid_number, '株式会社 ジェイアール西日本伊勢丹');
ok($zip->set_number('6008787')->is_valid_number, '京都地域センター');
ok($zip->set_number('6010292')->is_valid_number, '京都市 京北合同庁舎');
ok($zip->set_number('6010797')->is_valid_number, '南丹市役所美山支所');
ok($zip->set_number('6011192')->is_valid_number, '株式会社 川島織物セルコン 市原事業所');
ok($zip->set_number('6011495')->is_valid_number, '医療法人 医仁会 武田総合病院');
ok($zip->set_number('6018501')->is_valid_number, '任天堂 株式会社');
ok($zip->set_number('6018510')->is_valid_number, '株式会社 堀場製作所');
ok($zip->set_number('6018511')->is_valid_number, '京都市南区役所');
ok($zip->set_number('6018530')->is_valid_number, '株式会社 ワコール');
ok($zip->set_number('6018533')->is_valid_number, '株式会社 三笑堂');
ok($zip->set_number('6018550')->is_valid_number, '日本新薬 株式会社');
ok($zip->set_number('6018585')->is_valid_number, '社団法人 京都府農協会館');
ok($zip->set_number('6018588')->is_valid_number, '橋爪食品 株式会社');
ok($zip->set_number('6028501')->is_valid_number, 'NHK 京都放送局');
ok($zip->set_number('6028511')->is_valid_number, '上京区役所');
ok($zip->set_number('6028520')->is_valid_number, '株式会社 播磨屋本店');
ok($zip->set_number('6028525')->is_valid_number, '日本年金機構 京都事務センター');
ok($zip->set_number('6028555')->is_valid_number, '上京 税務署');
ok($zip->set_number('6028566')->is_valid_number, '京都府立 医科大学');
ok($zip->set_number('6028570')->is_valid_number, '京都府庁');
ok($zip->set_number('6028580')->is_valid_number, '同志社大学・学校法人 同志社法人部');
ok($zip->set_number('6028585')->is_valid_number, '大日本スクリーン製造 株式会社');
ok($zip->set_number('6028588')->is_valid_number, 'KBS京都');
ok($zip->set_number('6028611')->is_valid_number, '宮内庁 京都事務所');
ok($zip->set_number('6038511')->is_valid_number, '京都市北区役所');
ok($zip->set_number('6038522')->is_valid_number, '日本年金機構 上京年金事務所');
ok($zip->set_number('6038555')->is_valid_number, '京都産業大学');
ok($zip->set_number('6038577')->is_valid_number, '立命館大学');
ok($zip->set_number('6048501')->is_valid_number, '中京税務署');
ok($zip->set_number('6048502')->is_valid_number, '京都国際ホテル');
ok($zip->set_number('6048503')->is_valid_number, '株式会社 ホピー');
ok($zip->set_number('6048505')->is_valid_number, '株式会社 OPA 河原町オーパ');
ok($zip->set_number('6048508')->is_valid_number, '全国健康保険協会 京都支部');
ok($zip->set_number('6048510')->is_valid_number, '日本年金機構 中京年金事務所');
ok($zip->set_number('6048511')->is_valid_number, '株式会社 島津製作所');
ok($zip->set_number('6048520')->is_valid_number, '学校法人 立命館');
ok($zip->set_number('6048550')->is_valid_number, '京都地方裁判所');
ok($zip->set_number('6048551')->is_valid_number, '日本写真印刷 株式会社');
ok($zip->set_number('6048555')->is_valid_number, '京都新聞開発 株式会社 (週刊テレビ京都)');
ok($zip->set_number('6048556')->is_valid_number, '株式会社 京都新聞印刷');
ok($zip->set_number('6048558')->is_valid_number, '株式会社 京都ホテル');
ok($zip->set_number('6048560')->is_valid_number, '株式会社 京都リビング新聞社');
ok($zip->set_number('6048567')->is_valid_number, '株式会社 京都新聞COM');
ok($zip->set_number('6048571')->is_valid_number, '京都市役所');
ok($zip->set_number('6048577')->is_valid_number, '京都新聞社');
ok($zip->set_number('6048578')->is_valid_number, '京都新聞企画事業 株式会社');
ok($zip->set_number('6048580')->is_valid_number, '上原成商事 株式会社');
ok($zip->set_number('6048585')->is_valid_number, '社団法人 京都府医師会');
ok($zip->set_number('6048588')->is_valid_number, '中京区役所');
ok($zip->set_number('6048666')->is_valid_number, '日本銀行 京都支店');
ok($zip->set_number('6048798')->is_valid_number, '京都逓信病院');
ok($zip->set_number('6058501')->is_valid_number, '学校法人 京都女子学園(京都女子大学・京都女子短期大学部・京都女子高等学校・京都女子中学校・京都女子大学附属小学校・京都幼稚園)');
ok($zip->set_number('6058511')->is_valid_number, '東山区役所');
ok($zip->set_number('6058686')->is_valid_number, '宗教法人 知恩院');
ok($zip->set_number('6068501')->is_valid_number, '京都大学');
ok($zip->set_number('6068502')->is_valid_number, '京都大学農学部、農学部附属演習林、大学院理学研究科、理学部、基礎物理学研究所、数理解析研究所');
ok($zip->set_number('6068505')->is_valid_number, '京都宝ヶ池プリンスホテル');
ok($zip->set_number('6068507')->is_valid_number, '京都大学医学部附属病院、胸部疾患研究所、ウイルス研究所、生体医療工学研究センター、遺伝子実験施設、医療技術短期大学部');
ok($zip->set_number('6068511')->is_valid_number, '京都市左京区役所');
ok($zip->set_number('6068522')->is_valid_number, '京都府立大学');
ok($zip->set_number('6068536')->is_valid_number, '(財) 京都市国際交流協会');
ok($zip->set_number('6068540')->is_valid_number, '北斗プリント社');
ok($zip->set_number('6068555')->is_valid_number, '左京税務署');
ok($zip->set_number('6068558')->is_valid_number, '同志社中学校・高等学校');
ok($zip->set_number('6068585')->is_valid_number, '京都工芸繊維大学');
ok($zip->set_number('6068588')->is_valid_number, '京都精華大学');
ok($zip->set_number('6068792')->is_valid_number, '京都サービスセンター');
ok($zip->set_number('6078501')->is_valid_number, '株式会社 新学社');
ok($zip->set_number('6078511')->is_valid_number, '京都市 山科区役所');
ok($zip->set_number('6078571')->is_valid_number, '全家研ポピー');
ok($zip->set_number('6100192')->is_valid_number, '星和電機 株式会社');
ok($zip->set_number('6100195')->is_valid_number, '城陽市役所');
ok($zip->set_number('6100196')->is_valid_number, '城陽商工会議所');
ok($zip->set_number('6100281')->is_valid_number, '株式会社 宇治田原製茶場');
ok($zip->set_number('6100287')->is_valid_number, '須河車体 株式会社');
ok($zip->set_number('6100289')->is_valid_number, '宇治田原町役場');
ok($zip->set_number('6100380')->is_valid_number, '株式会社 椿本チエイン 京田辺工場');
ok($zip->set_number('6100393')->is_valid_number, '京田辺市役所');
ok($zip->set_number('6100394')->is_valid_number, '同志社大学');
ok($zip->set_number('6100395')->is_valid_number, '同志社女子大学');
ok($zip->set_number('6100396')->is_valid_number, 'ワタキューセイモア 株式会社');
ok($zip->set_number('6101192')->is_valid_number, '国際日本文化研究センター');
ok($zip->set_number('6101195')->is_valid_number, '京都経済短期大学 (学校法人 明徳学園)');
ok($zip->set_number('6101197')->is_valid_number, '京都市立芸術大学');
ok($zip->set_number('6101198')->is_valid_number, '京都市西京区役所 洛西支所');
ok($zip->set_number('6118501')->is_valid_number, '宇治市役所');
ok($zip->set_number('6118555')->is_valid_number, 'ユニチカ 株式会社 宇治事業所');
ok($zip->set_number('6118585')->is_valid_number, '松下電子部品 株式会社 コンデンサ事業部');
ok($zip->set_number('6128501')->is_valid_number, '京セラ 株式会社');
ok($zip->set_number('6128511')->is_valid_number, '京都市 伏見区役所');
ok($zip->set_number('6128522')->is_valid_number, '京都教育大学');
ok($zip->set_number('6128530')->is_valid_number, '株式会社 ワコールウイングブランド事業部');
ok($zip->set_number('6128533')->is_valid_number, '株式会社 モリタ製作所');
ok($zip->set_number('6128550')->is_valid_number, '株式会社 近鉄百貨店 桃山店');
ok($zip->set_number('6128555')->is_valid_number, '国立京都病院');
ok($zip->set_number('6128558')->is_valid_number, '日本年金機構 京都南年金事務所');
ok($zip->set_number('6128577')->is_valid_number, '龍谷大学');
ok($zip->set_number('6128585')->is_valid_number, '株式会社 京都自動車会館');
ok($zip->set_number('6128660')->is_valid_number, '月桂冠 株式会社');
ok($zip->set_number('6128677')->is_valid_number, '京都府自動車税管理事務所');
ok($zip->set_number('6128686')->is_valid_number, '村田機械 株式会社');
ok($zip->set_number('6138585')->is_valid_number, '久御山町役場');
ok($zip->set_number('6148501')->is_valid_number, '八幡市役所');
ok($zip->set_number('6148511')->is_valid_number, '城南衛生管理組合');
ok($zip->set_number('6148588')->is_valid_number, '石清水八幡宮');
ok($zip->set_number('6158501')->is_valid_number, '竹菱電機 株式会社');
ok($zip->set_number('6158510')->is_valid_number, '京都大学 大学院 工学研究科 Aクラスター');
ok($zip->set_number('6158511')->is_valid_number, '京都西社会保険事務所');
ok($zip->set_number('6158520')->is_valid_number, '京都大学 国際融合創造センター');
ok($zip->set_number('6158522')->is_valid_number, '京都市西京区役所');
ok($zip->set_number('6158530')->is_valid_number, '京都大学大学院 工学研究科Bクラスター');
ok($zip->set_number('6158540')->is_valid_number, '京都大学大学院 工学研究科Cクラスター');
ok($zip->set_number('6158555')->is_valid_number, 'サンコール 株式会社');
ok($zip->set_number('6158558')->is_valid_number, '京都外国語大学');
ok($zip->set_number('6158686')->is_valid_number, '日新電機 株式会社');
ok($zip->set_number('6168501')->is_valid_number, '三菱自動車工業 株式会社 パワートレイン製作所');
ok($zip->set_number('6168511')->is_valid_number, '京都市右京区役所');
ok($zip->set_number('6168533')->is_valid_number, '大日本印刷 株式会社 京都工場');
ok($zip->set_number('6168555')->is_valid_number, '日本クリニック 株式会社');
ok($zip->set_number('6168566')->is_valid_number, '美空ひばり館');
ok($zip->set_number('6168585')->is_valid_number, 'ハマナカ 株式会社');
ok($zip->set_number('6168586')->is_valid_number, '東映太秦映画村');
ok($zip->set_number('6178501')->is_valid_number, '長岡京市役所');
ok($zip->set_number('6178511')->is_valid_number, '(株) 工進');
ok($zip->set_number('6178520')->is_valid_number, 'パナソニック株式会社 セミコンダクター社');
ok($zip->set_number('6178530')->is_valid_number, 'サントリー 株式会社 桂ビール工場');
ok($zip->set_number('6178550')->is_valid_number, '三菱電機 株式会社 AV統括事業部');
ok($zip->set_number('6178551')->is_valid_number, 'エイエムジー 株式会社');
ok($zip->set_number('6178555')->is_valid_number, '株式会社 村田製作所');
ok($zip->set_number('6178566')->is_valid_number, '株式会社 村田製作所 長岡事業所');
ok($zip->set_number('6178585')->is_valid_number, '日本輸送機 株式会社');
ok($zip->set_number('6178588')->is_valid_number, '佐川印刷 株式会社');
ok($zip->set_number('6178665')->is_valid_number, '向日市役所');
ok($zip->set_number('6178666')->is_valid_number, '三菱製紙 株式会社 京都工場');
ok($zip->set_number('6188501')->is_valid_number, '大山崎町役場');
ok($zip->set_number('6188503')->is_valid_number, 'サントリー 株式会社 研究センター');
ok($zip->set_number('6188511')->is_valid_number, '日立建機 株式会社 西日本事業部');
ok($zip->set_number('6188518')->is_valid_number, '社会福祉法人 大阪水上隣保館');
ok($zip->set_number('6188525')->is_valid_number, '日立マクセル 株式会社 アドバンスドテープ事業部・二次電池事業部');
ok($zip->set_number('6188555')->is_valid_number, '株式会社 NEOMAX');
ok($zip->set_number('6188558')->is_valid_number, 'マクセル精器 株式会社');
ok($zip->set_number('6188567')->is_valid_number, '株式会社 東亜セイコー');
ok($zip->set_number('6188570')->is_valid_number, '島本町役場');
ok($zip->set_number('6188585')->is_valid_number, '小野薬品工業 株式会社 水無瀬総合研究所');
ok($zip->set_number('6190280')->is_valid_number, '木津川市役所 山城支所');
ok($zip->set_number('6190282')->is_valid_number, '私のしごと館');
ok($zip->set_number('6190283')->is_valid_number, 'オムロン 株式会社 京阪奈イノベーションセンタ');
ok($zip->set_number('6190285')->is_valid_number, '精華町役場');
ok($zip->set_number('6190286')->is_valid_number, '木津川市役所');
ok($zip->set_number('6190287')->is_valid_number, '国立国会図書館 関西館');
ok($zip->set_number('6190288')->is_valid_number, '(株) 国際電気通信基礎技術研究所');
ok($zip->set_number('6190289')->is_valid_number, '独立行政法人 情報通信研究機構');
ok($zip->set_number('6190292')->is_valid_number, '財団法人 地球環境産業技術研究機構');
ok($zip->set_number('6190295')->is_valid_number, '株式会社 福寿園');
ok($zip->set_number('6191195')->is_valid_number, '木津川市役所 加茂支所');
ok($zip->set_number('6191295')->is_valid_number, '和束町役場');
ok($zip->set_number('6191393')->is_valid_number, '笠置町役場');
ok($zip->set_number('6201492')->is_valid_number, '福知山市役所 三和支所');
ok($zip->set_number('6201493')->is_valid_number, '京都機械 株式会社');
ok($zip->set_number('6208501')->is_valid_number, '福知山市役所');
ok($zip->set_number('6208502')->is_valid_number, '陸上自衛隊');
ok($zip->set_number('6208503')->is_valid_number, '株式会社 さとう');
ok($zip->set_number('6208504')->is_valid_number, 'JR西日本 福知山支社');
ok($zip->set_number('6208505')->is_valid_number, '市立福知山市民病院');
ok($zip->set_number('6208506')->is_valid_number, '京都ルネス病院');
ok($zip->set_number('6208507')->is_valid_number, '株式会社 雪印アクセス 北近畿支店');
ok($zip->set_number('6218501')->is_valid_number, '亀岡市役所');
ok($zip->set_number('6218555')->is_valid_number, '京都学園大学');
ok($zip->set_number('6218585')->is_valid_number, '亀岡市立病院');
ok($zip->set_number('6218686')->is_valid_number, '宗教法人 大本');
ok($zip->set_number('6220292')->is_valid_number, '京丹波町役場');
ok($zip->set_number('6228651')->is_valid_number, '南丹市役所');
ok($zip->set_number('6238501')->is_valid_number, '綾部市役所');
ok($zip->set_number('6238588')->is_valid_number, '京セラSLCコンポーネンツ 株式会社');
ok($zip->set_number('6248555')->is_valid_number, '日本年金機構 舞鶴年金事務所');
ok($zip->set_number('6248686')->is_valid_number, '第八管区海上保安本部');
ok($zip->set_number('6258501')->is_valid_number, '日立造船 株式会社 舞鶴工場');
ok($zip->set_number('6258502')->is_valid_number, '独立行政法人 国立病院機構 舞鶴医療センター');
ok($zip->set_number('6258510')->is_valid_number, '海上自衛隊 舞鶴地方総監部');
ok($zip->set_number('6258511')->is_valid_number, '舞鶴工業高等専門学校');
ok($zip->set_number('6258555')->is_valid_number, '舞鶴市役所');
ok($zip->set_number('6258585')->is_valid_number, '舞鶴共済病院');
ok($zip->set_number('6258666')->is_valid_number, '日本板硝子 株式会社 舞鶴工場');
ok($zip->set_number('6260493')->is_valid_number, '伊根町役場');
ok($zip->set_number('6268501')->is_valid_number, '宮津市役所');
ok($zip->set_number('6268510')->is_valid_number, '宮津ロイヤルホテル');
ok($zip->set_number('6268571')->is_valid_number, '宮津 税務署');
ok($zip->set_number('6278555')->is_valid_number, '財団法人 丹後中央病院');
ok($zip->set_number('6278567')->is_valid_number, '京丹後市役所');
ok($zip->set_number('6278570')->is_valid_number, '京都府 丹後広域振興局');
ok($zip->set_number('6278688')->is_valid_number, '京都府立 峰山高等学校');
ok($zip->set_number('6290192')->is_valid_number, '泰宏商事');
ok($zip->set_number('6290196')->is_valid_number, '公立 南丹看護専門学校');
ok($zip->set_number('6290197')->is_valid_number, '公立 南丹病院');
ok($zip->set_number('6290198')->is_valid_number, '南丹市役所 八木支所');
ok($zip->set_number('6290392')->is_valid_number, '明治国際医療大学');
ok($zip->set_number('6290398')->is_valid_number, '南丹市役所 日吉支所');
ok($zip->set_number('6291192')->is_valid_number, '京丹波町 和知支所');
ok($zip->set_number('6292498')->is_valid_number, '与謝野町 加悦庁舎');
ok($zip->set_number('6300192')->is_valid_number, '奈良先端科学技術大学院大学');
ok($zip->set_number('6300288')->is_valid_number, '生駒市役所');
ok($zip->set_number('6300292')->is_valid_number, '近鉄ケーブルネットワーク 株式会社');
ok($zip->set_number('6300293')->is_valid_number, '近畿大学 医学部 奈良病院');
ok($zip->set_number('6302192')->is_valid_number, '社会福祉法人史明会 ボイス');
ok($zip->set_number('6308501')->is_valid_number, '奈良県庁');
ok($zip->set_number('6308502')->is_valid_number, '奈良県 教育委員会');
ok($zip->set_number('6308503')->is_valid_number, '市民生活協同組合 ならコープ');
ok($zip->set_number('6308505')->is_valid_number, '西日本電信電話 株式会社 奈良支店');
ok($zip->set_number('6308506')->is_valid_number, '奈良女子大学');
ok($zip->set_number('6308508')->is_valid_number, '株式会社 ヒラサワ');
ok($zip->set_number('6308512')->is_valid_number, '奈良社会保険事務所');
ok($zip->set_number('6308518')->is_valid_number, '関西セキスイ工業 株式会社');
ok($zip->set_number('6308520')->is_valid_number, 'スケーター 株式会社');
ok($zip->set_number('6308522')->is_valid_number, '航空自衛隊 奈良基地');
ok($zip->set_number('6308528')->is_valid_number, '国立大学法人 奈良教育大学');
ok($zip->set_number('6308529')->is_valid_number, '奈良県 社会保険診療報酬支払基金');
ok($zip->set_number('6308530')->is_valid_number, '関西電力 株式会社 奈良営業所');
ok($zip->set_number('6308533')->is_valid_number, '奈良警察署');
ok($zip->set_number('6308535')->is_valid_number, '全国健康保険協会 奈良支部');
ok($zip->set_number('6308536')->is_valid_number, '朝日新聞 奈良総局');
ok($zip->set_number('6308540')->is_valid_number, 'NHK 奈良放送局');
ok($zip->set_number('6308543')->is_valid_number, '住友生命保険 相互会社 奈良支社');
ok($zip->set_number('6308548')->is_valid_number, '関西電力 株式会社 奈良支店');
ok($zip->set_number('6308550')->is_valid_number, '奈良県 農業協同組合 中央会');
ok($zip->set_number('6308552')->is_valid_number, '奈良県 共済農業協同連合会');
ok($zip->set_number('6308555')->is_valid_number, '積水化学工業 株式会社 奈良工場');
ok($zip->set_number('6308558')->is_valid_number, '学校法人 奈良育英学園 奈良育英中学校 奈良育英高等学校');
ok($zip->set_number('6308563')->is_valid_number, '薬師寺');
ok($zip->set_number('6308566')->is_valid_number, '奈良佐保女学院短期大学');
ok($zip->set_number('6308567')->is_valid_number, '奈良税務署');
ok($zip->set_number('6308570')->is_valid_number, '奈良労働局');
ok($zip->set_number('6308575')->is_valid_number, '奈良テレビ放送 株式会社');
ok($zip->set_number('6308577')->is_valid_number, '独立行政法人 文化財研究所 奈良文化財研究所');
ok($zip->set_number('6308578')->is_valid_number, '奈良県 警察本部');
ok($zip->set_number('6308580')->is_valid_number, '奈良市役所');
ok($zip->set_number('6308585')->is_valid_number, '日本自動車連盟奈良支部');
ok($zip->set_number('6308586')->is_valid_number, '奈良商工会議所');
ok($zip->set_number('6308587')->is_valid_number, '東大寺');
ok($zip->set_number('6308588')->is_valid_number, '草竹コンクリート工業 株式会社');
ok($zip->set_number('6308651')->is_valid_number, '奈良交通 株式会社');
ok($zip->set_number('6308655')->is_valid_number, '奈良県 信用農業協同組合連合会');
ok($zip->set_number('6308666')->is_valid_number, '大和証券 株式会社 奈良支店');
ok($zip->set_number('6308668')->is_valid_number, '奈良県信用保証協会');
ok($zip->set_number('6308670')->is_valid_number, '株式会社 呉竹精昇堂');
ok($zip->set_number('6308677')->is_valid_number, '株式会社 南都銀行 本店');
ok($zip->set_number('6308686')->is_valid_number, '(株) 奈良新聞社');
ok($zip->set_number('6308688')->is_valid_number, '株式会社 南都銀行 事務センター');
ok($zip->set_number('6318501')->is_valid_number, '帝塚山大学');
ok($zip->set_number('6318502')->is_valid_number, '奈良大学');
ok($zip->set_number('6318503')->is_valid_number, '三和建設 株式会社');
ok($zip->set_number('6318505')->is_valid_number, '近畿大学 農学部');
ok($zip->set_number('6318511')->is_valid_number, '株式会社 近鉄百貨店 奈良店');
ok($zip->set_number('6318522')->is_valid_number, '奈良学園幼稚園・奈良学園小学校・奈良学園登美ヶ丘中学校・奈良学園登美ヶ丘高等学校');
ok($zip->set_number('6318523')->is_valid_number, '奈良文化女子短期大学');
ok($zip->set_number('6318555')->is_valid_number, '奈良大学附属高等学校');
ok($zip->set_number('6318585')->is_valid_number, '帝塚山短期大学');
ok($zip->set_number('6320292')->is_valid_number, '奈良市 都祁行政センター');
ok($zip->set_number('6328510')->is_valid_number, '天理大学');
ok($zip->set_number('6328540')->is_valid_number, '天理大学附属参考館');
ok($zip->set_number('6328552')->is_valid_number, '天理よろづ相談所');
ok($zip->set_number('6328555')->is_valid_number, '天理市役所');
ok($zip->set_number('6328558')->is_valid_number, '天理市 水道局');
ok($zip->set_number('6328567')->is_valid_number, 'シャープ 株式会社');
ok($zip->set_number('6328577')->is_valid_number, '天理大学附属図書館');
ok($zip->set_number('6328585')->is_valid_number, '天理高等学校');
ok($zip->set_number('6328587')->is_valid_number, '株式会社 花の大和');
ok($zip->set_number('6328588')->is_valid_number, '光洋サーモシステム 株式会社');
ok($zip->set_number('6328679')->is_valid_number, '天理教 一れつ会');
ok($zip->set_number('6328688')->is_valid_number, '天理教 少年会本部');
ok($zip->set_number('6330292')->is_valid_number, '宇陀市役所');
ok($zip->set_number('6330298')->is_valid_number, '宇陀市立病院');
ok($zip->set_number('6330392')->is_valid_number, '室生地域事務所');
ok($zip->set_number('6330398')->is_valid_number, '株式会社 室生ロイヤルカントリークラブ');
ok($zip->set_number('6332192')->is_valid_number, '宇陀市大宇陀地域事務所');
ok($zip->set_number('6332492')->is_valid_number, '東吉野村役場');
ok($zip->set_number('6338501')->is_valid_number, '桜井年金事務所');
ok($zip->set_number('6338538')->is_valid_number, '大神神社');
ok($zip->set_number('6338585')->is_valid_number, '桜井市役所');
ok($zip->set_number('6338686')->is_valid_number, '大和信用金庫');
ok($zip->set_number('6348501')->is_valid_number, '橿原警察署');
ok($zip->set_number('6348502')->is_valid_number, '奈良県医師会');
ok($zip->set_number('6348503')->is_valid_number, '奈良県 警察交通反則通告センター');
ok($zip->set_number('6348505')->is_valid_number, 'マルコ 株式会社 本社事務所');
ok($zip->set_number('6348510')->is_valid_number, 'オカハシ 株式会社');
ok($zip->set_number('6348511')->is_valid_number, '株式会社 近鉄百貨店 橿原店');
ok($zip->set_number('6348521')->is_valid_number, '奈良県立医科大学');
ok($zip->set_number('6348522')->is_valid_number, '奈良県立医科大学付属病院');
ok($zip->set_number('6348523')->is_valid_number, '奈良県立医科大学付属図書館');
ok($zip->set_number('6348524')->is_valid_number, '奈良県立医科大学 看護短期大学部');
ok($zip->set_number('6348550')->is_valid_number, '橿原神宮');
ok($zip->set_number('6348551')->is_valid_number, '株式会社 タカギ');
ok($zip->set_number('6348555')->is_valid_number, '株式会社 ジェイテクト 奈良工場');
ok($zip->set_number('6348560')->is_valid_number, '大和平野土地改良区事務所');
ok($zip->set_number('6348561')->is_valid_number, '奈良県 市町村職員共済組合');
ok($zip->set_number('6348567')->is_valid_number, '佐藤薬品工業 株式会社');
ok($zip->set_number('6348580')->is_valid_number, '株式会社 タカトリ');
ok($zip->set_number('6348585')->is_valid_number, '三和澱粉工業 株式会社');
ok($zip->set_number('6348586')->is_valid_number, '橿原市役所');
ok($zip->set_number('6358501')->is_valid_number, '大和高田市立病院');
ok($zip->set_number('6358502')->is_valid_number, '奈良地方裁判所葛城支部・奈良家庭裁判所葛城支部・葛城簡易裁判所・葛城検察審査会');
ok($zip->set_number('6358508')->is_valid_number, '奈良県 葛城保健所');
ok($zip->set_number('6358510')->is_valid_number, '株式会社 マイカル 高田サティ');
ok($zip->set_number('6358511')->is_valid_number, '大和高田市役所');
ok($zip->set_number('6358515')->is_valid_number, '広陵町役場');
ok($zip->set_number('6358520')->is_valid_number, '浪華ゴム工業 株式会社');
ok($zip->set_number('6358528')->is_valid_number, '(株) ナカガワ');
ok($zip->set_number('6358530')->is_valid_number, '奈良文化女子短期大学');
ok($zip->set_number('6358585')->is_valid_number, 'ハローワーク大和高田 (大和高田公共職業安定所)');
ok($zip->set_number('6358787')->is_valid_number, '奈良地域センター');
ok($zip->set_number('6360192')->is_valid_number, '東洋シール工業 株式会社');
ok($zip->set_number('6360193')->is_valid_number, '株式会社 植嶋');
ok($zip->set_number('6360198')->is_valid_number, '斑鳩町役場');
ok($zip->set_number('6360292')->is_valid_number, '奈良トヨタ自動車 株式会社');
ok($zip->set_number('6360293')->is_valid_number, '大日本印刷 株式会社 BF事業部奈良工場');
ok($zip->set_number('6360294')->is_valid_number, '旭食品 株式会社 阪奈支店');
ok($zip->set_number('6360295')->is_valid_number, '株式会社 GMB');
ok($zip->set_number('6360298')->is_valid_number, '株式会社 カギオカ');
ok($zip->set_number('6360392')->is_valid_number, '田原本町役場');
ok($zip->set_number('6360393')->is_valid_number, '社会福祉法人 奈良県社会福祉事業団 奈良県心身障害者リハビリテーションセンター');
ok($zip->set_number('6360398')->is_valid_number, '奈良中央信用金庫');
ok($zip->set_number('6368501')->is_valid_number, '河合町役場');
ok($zip->set_number('6368503')->is_valid_number, '奈良産業大学');
ok($zip->set_number('6368511')->is_valid_number, '王寺町役場');
ok($zip->set_number('6368535')->is_valid_number, '三郷町役場');
ok($zip->set_number('6368555')->is_valid_number, 'FM西大和 (株) ・FMハイホー');
ok($zip->set_number('6368585')->is_valid_number, '平群町役場');
ok($zip->set_number('6368798')->is_valid_number, '近畿郵政研修センター');
ok($zip->set_number('6378501')->is_valid_number, '五條市役所');
ok($zip->set_number('6378511')->is_valid_number, '五條病院');
ok($zip->set_number('6380292')->is_valid_number, '黒滝村役場');
ok($zip->set_number('6380392')->is_valid_number, '天川村役場');
ok($zip->set_number('6388501')->is_valid_number, '大淀町役場');
ok($zip->set_number('6388510')->is_valid_number, '下市町役場');
ok($zip->set_number('6388521')->is_valid_number, '町立大淀病院');
ok($zip->set_number('6390292')->is_valid_number, '香芝市役所');
ok($zip->set_number('6390293')->is_valid_number, '上牧町役場');
ok($zip->set_number('6390298')->is_valid_number, '樟蔭女子短期大学');
ok($zip->set_number('6391080')->is_valid_number, '奈良工業高等専門学校');
ok($zip->set_number('6391081')->is_valid_number, '岩崎工業 株式会社');
ok($zip->set_number('6391082')->is_valid_number, '奈良信用金庫');
ok($zip->set_number('6391085')->is_valid_number, 'ニッタ 株式会社 奈良工場');
ok($zip->set_number('6391089')->is_valid_number, '株式会社 南都銀行 郡山支店');
ok($zip->set_number('6391093')->is_valid_number, '奈良学園');
ok($zip->set_number('6391095')->is_valid_number, '安堵町役場');
ok($zip->set_number('6391183')->is_valid_number, '株式会社 森精機製作所');
ok($zip->set_number('6391186')->is_valid_number, 'シャープ 株式会社');
ok($zip->set_number('6391188')->is_valid_number, 'パナソニック 株式会社 ホームアプライアンス社');
ok($zip->set_number('6391192')->is_valid_number, '奈良大果 株式会社');
ok($zip->set_number('6391196')->is_valid_number, '株式会社 奈良魚市');
ok($zip->set_number('6391197')->is_valid_number, '奈良中央青果 株式会社');
ok($zip->set_number('6391198')->is_valid_number, '大和郡山市役所');
ok($zip->set_number('6392195')->is_valid_number, '葛城市役所 新庄庁舎');
ok($zip->set_number('6392197')->is_valid_number, '葛城市役所 當麻庁舎');
ok($zip->set_number('6392198')->is_valid_number, 'シャープ 株式会社');
ok($zip->set_number('6392292')->is_valid_number, '塚本産業 株式会社');
ok($zip->set_number('6392295')->is_valid_number, '田村薬品工業 株式会社');
ok($zip->set_number('6392298')->is_valid_number, '御所市役所');
ok($zip->set_number('6393192')->is_valid_number, '吉野町役場');
ok($zip->set_number('6393594')->is_valid_number, '川上村役場');
ok($zip->set_number('6400492')->is_valid_number, '紀の川市役所 貴志川支所');
ok($zip->set_number('6401192')->is_valid_number, '紀美野町役場');
ok($zip->set_number('6401196')->is_valid_number, '株式会社 クロシオ');
ok($zip->set_number('6408501')->is_valid_number, '和歌山県農業協同組合中央会・和歌山県信用農業協同組合連合会・和歌山県農業協同組合連合会・和歌山県共済農業協同組合連合会');
ok($zip->set_number('6408502')->is_valid_number, '株式会社 長崎屋 和歌山店');
ok($zip->set_number('6408503')->is_valid_number, '株式会社 貴志');
ok($zip->set_number('6408505')->is_valid_number, '独立行政法人 労働者健康福祉機構 和歌山労災病院');
ok($zip->set_number('6408507')->is_valid_number, '和歌山刑務所');
ok($zip->set_number('6408508')->is_valid_number, '南海通信特機 株式会社');
ok($zip->set_number('6408510')->is_valid_number, '和歌山大学');
ok($zip->set_number('6408511')->is_valid_number, '和歌山市役所');
ok($zip->set_number('6408512')->is_valid_number, '株式会社 雪印アクセス 和歌山支店');
ok($zip->set_number('6408513')->is_valid_number, '和歌山県 赤十字血液センター');
ok($zip->set_number('6408514')->is_valid_number, '和歌山県医師会');
ok($zip->set_number('6408515')->is_valid_number, '株式会社 スズケン 和歌山支店');
ok($zip->set_number('6408516')->is_valid_number, '全国健康保険協会 和歌山支部');
ok($zip->set_number('6408519')->is_valid_number, '西日本電信電話 株式会社 和歌山支店');
ok($zip->set_number('6408520')->is_valid_number, '和歌山税務署');
ok($zip->set_number('6408522')->is_valid_number, '日本火災海上保険 株式会社 和歌山支店');
ok($zip->set_number('6408524')->is_valid_number, '和歌山県 警察本部交通センター');
ok($zip->set_number('6408525')->is_valid_number, '株式会社 大黒');
ok($zip->set_number('6408533')->is_valid_number, '株式会社 テレビ和歌山');
ok($zip->set_number('6408535')->is_valid_number, 'パームシティ 和歌山店');
ok($zip->set_number('6408536')->is_valid_number, '和歌山市 選挙管理委員会事務局');
ok($zip->set_number('6408540')->is_valid_number, '住友生命保険 相互会社 和歌山支社');
ok($zip->set_number('6408544')->is_valid_number, '有限会社 ジェイ・ウィング');
ok($zip->set_number('6408545')->is_valid_number, '社会福祉法人 和歌山県社会福祉協議会');
ok($zip->set_number('6408546')->is_valid_number, '株式会社 和歌山近鉄百貨店');
ok($zip->set_number('6408550')->is_valid_number, 'ノーリツ鋼機 株式会社');
ok($zip->set_number('6408551')->is_valid_number, '株式会社 淺川組');
ok($zip->set_number('6408552')->is_valid_number, '和歌山地方法務局');
ok($zip->set_number('6408555')->is_valid_number, '住友金属工業 株式会社 和歌山製鉄所');
ok($zip->set_number('6408556')->is_valid_number, '日本放送協会 和歌山放送局');
ok($zip->set_number('6408557')->is_valid_number, '株式会社 和歌山リビング新聞社');
ok($zip->set_number('6408558')->is_valid_number, '日本赤十字社 和歌山医療センター');
ok($zip->set_number('6408560')->is_valid_number, '千代田火災海上保険 株式会社 和歌山支店');
ok($zip->set_number('6408564')->is_valid_number, '株式会社 ゴトウ洋服店');
ok($zip->set_number('6408565')->is_valid_number, '株式会社 山本種苗園');
ok($zip->set_number('6408566')->is_valid_number, '社団法人 和歌山県 経済センター');
ok($zip->set_number('6408567')->is_valid_number, '和歌山商工会議所');
ok($zip->set_number('6408570')->is_valid_number, 'ニュース和歌山 株式会社');
ok($zip->set_number('6408575')->is_valid_number, '株式会社 丸正');
ok($zip->set_number('6408577')->is_valid_number, '株式会社 和歌山放送');
ok($zip->set_number('6408580')->is_valid_number, '花王 株式会社 和歌山工場');
ok($zip->set_number('6408581')->is_valid_number, '和歌山労働局');
ok($zip->set_number('6408582')->is_valid_number, '和歌山労働基準監督署');
ok($zip->set_number('6408585')->is_valid_number, '和歌山県庁');
ok($zip->set_number('6408588')->is_valid_number, '和歌山県警察本部');
ok($zip->set_number('6408589')->is_valid_number, '株式会社 日本教育書道研究会');
ok($zip->set_number('6408651')->is_valid_number, '大和証券 株式会社 和歌山支店');
ok($zip->set_number('6408652')->is_valid_number, '泉州銀行 和歌山支店');
ok($zip->set_number('6408653')->is_valid_number, '商工組合中央金庫 和歌山支店');
ok($zip->set_number('6408654')->is_valid_number, '東洋信託銀行 和歌山支店');
ok($zip->set_number('6408655')->is_valid_number, 'きのくに信用金庫');
ok($zip->set_number('6408656')->is_valid_number, '株式会社 紀陽銀行');
ok($zip->set_number('6408657')->is_valid_number, '農林中央金庫 和歌山事務所');
ok($zip->set_number('6408659')->is_valid_number, '株式会社 和歌山銀行');
ok($zip->set_number('6408666')->is_valid_number, '日本生命保険 相互会社 和歌山支社');
ok($zip->set_number('6408668')->is_valid_number, '株式会社 紀陽銀行 向芝オフィス');
ok($zip->set_number('6408686')->is_valid_number, '三菱電機 株式会社 冷熱システム製作所');
ok($zip->set_number('6408687')->is_valid_number, '野村證券 株式会社 和歌山支店');
ok($zip->set_number('6408787')->is_valid_number, '和歌山地域センター');
ok($zip->set_number('6418501')->is_valid_number, '株式会社 オークワ本社');
ok($zip->set_number('6418508')->is_valid_number, 'hi-hoインフォメーションデスク');
ok($zip->set_number('6418509')->is_valid_number, '公立大学法人 和歌山県立 医科大学');
ok($zip->set_number('6418510')->is_valid_number, '和歌山県立 医科大学付属病院');
ok($zip->set_number('6418511')->is_valid_number, '株式会社 島精機製作所');
ok($zip->set_number('6418770')->is_valid_number, 'エフエム和歌山');
ok($zip->set_number('6428501')->is_valid_number, '海南市役所');
ok($zip->set_number('6441292')->is_valid_number, '日高川町役場 美山支所');
ok($zip->set_number('6448655')->is_valid_number, '国保日高総合病院');
ok($zip->set_number('6448686')->is_valid_number, '御坊市役所');
ok($zip->set_number('6458511')->is_valid_number, '河本食品 株式会社');
ok($zip->set_number('6460292')->is_valid_number, '中田食品 株式会社・株式会社 ナカタ');
ok($zip->set_number('6461192')->is_valid_number, '田辺市 大塔行政局');
ok($zip->set_number('6461492')->is_valid_number, '田辺市 中辺路行政局');
ok($zip->set_number('6468501')->is_valid_number, '紀伊田辺簡易保険保養センター');
ok($zip->set_number('6468511')->is_valid_number, '田辺労働基準監督署');
ok($zip->set_number('6468544')->is_valid_number, '大阪松下ライフエレクトロニクス 株式会社');
ok($zip->set_number('6468545')->is_valid_number, '田辺市役所');
ok($zip->set_number('6468550')->is_valid_number, '丸惣食品');
ok($zip->set_number('6468558')->is_valid_number, '国立南和歌山病院');
ok($zip->set_number('6468580')->is_valid_number, '西牟婁振興局');
ok($zip->set_number('6468585')->is_valid_number, '日本電信電話 株式会社 田辺支店');
ok($zip->set_number('6468588')->is_valid_number, '社会保険紀南病院');
ok($zip->set_number('6468660')->is_valid_number, '紀伊民報社');
ok($zip->set_number('6471294')->is_valid_number, '新宮市役所 熊野川行政局');
ok($zip->set_number('6471792')->is_valid_number, '田辺市 本宮行政局');
ok($zip->set_number('6478555')->is_valid_number, '新宮市役所');
ok($zip->set_number('6480198')->is_valid_number, '九度山町役場');
ok($zip->set_number('6480280')->is_valid_number, '学校法人 高野山学園 高野山大学');
ok($zip->set_number('6480281')->is_valid_number, '高野町役場');
ok($zip->set_number('6480282')->is_valid_number, '宗教法人 宿坊大円院');
ok($zip->set_number('6480283')->is_valid_number, '持明院');
ok($zip->set_number('6480284')->is_valid_number, '高野山不動院');
ok($zip->set_number('6480285')->is_valid_number, '高野山苅萱堂 密厳院');
ok($zip->set_number('6480286')->is_valid_number, '竜泉院');
ok($zip->set_number('6480287')->is_valid_number, '西南院');
ok($zip->set_number('6480288')->is_valid_number, '高野山高等学校');
ok($zip->set_number('6480289')->is_valid_number, '西禅院');
ok($zip->set_number('6480292')->is_valid_number, '正智院');
ok($zip->set_number('6480293')->is_valid_number, '普賢院');
ok($zip->set_number('6480294')->is_valid_number, '総本山金剛峯寺');
ok($zip->set_number('6480295')->is_valid_number, '大師陀羅尼製薬');
ok($zip->set_number('6480296')->is_valid_number, '総持院');
ok($zip->set_number('6480297')->is_valid_number, '遍照尊院');
ok($zip->set_number('6480298')->is_valid_number, '宝善院');
ok($zip->set_number('6480392')->is_valid_number, '野迫川村役場');
ok($zip->set_number('6488541')->is_valid_number, '伊都県事務所');
ok($zip->set_number('6488585')->is_valid_number, '橋本市役所');
ok($zip->set_number('6490192')->is_valid_number, '海南市 下津行政局');
ok($zip->set_number('6492192')->is_valid_number, '上富田町役場');
ok($zip->set_number('6492193')->is_valid_number, '有限会社 紀の里食品');
ok($zip->set_number('6492195')->is_valid_number, '熊野高等学校');
ok($zip->set_number('6492198')->is_valid_number, '有限会社 深見梅店');
ok($zip->set_number('6493592')->is_valid_number, '串本町役場');
ok($zip->set_number('6494192')->is_valid_number, '串本町役場 古座分庁舎');
ok($zip->set_number('6496192')->is_valid_number, '紀の川市 桃山支所');
ok($zip->set_number('6496292')->is_valid_number, '岩出市役所');
ok($zip->set_number('6496492')->is_valid_number, '紀の川市役所');
ok($zip->set_number('6496493')->is_valid_number, '近畿大学 生物理工学部');
ok($zip->set_number('6496494')->is_valid_number, '紀の里 農業協同組合');
ok($zip->set_number('6496592')->is_valid_number, '粉河税務署');
ok($zip->set_number('6496593')->is_valid_number, '紀の川市役所 粉河支所');
ok($zip->set_number('6496595')->is_valid_number, '粉河高等学校');
ok($zip->set_number('6496692')->is_valid_number, '紀の川市役所 那賀支所');
ok($zip->set_number('6497192')->is_valid_number, 'かつらぎ町役場');
ok($zip->set_number('6497194')->is_valid_number, '築野食品工業 株式会社');
ok($zip->set_number('6497195')->is_valid_number, '溝端紙工印刷 株式会社');
ok($zip->set_number('6508501')->is_valid_number, '損保ジャパン 株式会社');
ok($zip->set_number('6508502')->is_valid_number, '神戸県税事務所');
ok($zip->set_number('6508505')->is_valid_number, '株式会社 ファミリア');
ok($zip->set_number('6508510')->is_valid_number, '兵庫県 警察本部');
ok($zip->set_number('6508511')->is_valid_number, '神戸税務署');
ok($zip->set_number('6508515')->is_valid_number, 'NHK 神戸放送局');
ok($zip->set_number('6508521')->is_valid_number, '株式会社 ノエビア');
ok($zip->set_number('6508522')->is_valid_number, 'あいおい損害保険 株式会社');
ok($zip->set_number('6508528')->is_valid_number, '兵庫県 社会保険診療報酬支払基金');
ok($zip->set_number('6508530')->is_valid_number, '兵庫医療大学');
ok($zip->set_number('6508533')->is_valid_number, '日本興亜損害保険 株式会社 神戸支店');
ok($zip->set_number('6508536')->is_valid_number, '株式会社 サンテレビジョン');
ok($zip->set_number('6508539')->is_valid_number, '神戸親和女子大学 通信教育部事務室');
ok($zip->set_number('6508543')->is_valid_number, '神戸商工会議所');
ok($zip->set_number('6508550')->is_valid_number, '田崎真珠 株式会社');
ok($zip->set_number('6508551')->is_valid_number, '第五管区海上保安本部');
ok($zip->set_number('6508555')->is_valid_number, '株式会社 アシックス');
ok($zip->set_number('6508558')->is_valid_number, 'フジッコ 株式会社');
ok($zip->set_number('6508559')->is_valid_number, 'フジッコ 株式会社 ウェルネス倶楽部');
ok($zip->set_number('6508560')->is_valid_number, '株式会社 ホテルオークラ神戸');
ok($zip->set_number('6508565')->is_valid_number, '神戸簡易裁判所');
ok($zip->set_number('6508567')->is_valid_number, '兵庫県庁');
ok($zip->set_number('6508570')->is_valid_number, '神戸市役所');
ok($zip->set_number('6508571')->is_valid_number, '株式会社 神戸新聞社');
ok($zip->set_number('6508575')->is_valid_number, '神戸地方裁判所');
ok($zip->set_number('6508576')->is_valid_number, '株式会社 リーフ・パブリケーションズ 神戸支局 ぱど事業部');
ok($zip->set_number('6508580')->is_valid_number, '株式会社 ラジオ関西');
ok($zip->set_number('6508584')->is_valid_number, '株式会社 リクルート ホットペッパー神戸版編集部');
ok($zip->set_number('6508585')->is_valid_number, '株式会社 ワールド');
ok($zip->set_number('6508586')->is_valid_number, '神戸学院大学 ポートアイランド キャンパス');
ok($zip->set_number('6508588')->is_valid_number, 'イマージュ');
ok($zip->set_number('6508589')->is_valid_number, '株式会社 Kiss-FM KOBE');
ok($zip->set_number('6508660')->is_valid_number, '株式会社 三井住友銀行');
ok($zip->set_number('6508666')->is_valid_number, '全国農業協同組合連合会 兵庫県本部');
ok($zip->set_number('6508670')->is_valid_number, '川崎重工業 株式会社 神戸工場');
ok($zip->set_number('6508677')->is_valid_number, '宮野医療器 株式会社');
ok($zip->set_number('6508680')->is_valid_number, '川崎重工業 株式会社 神戸本社');
ok($zip->set_number('6508686')->is_valid_number, '神戸信用金庫');
ok($zip->set_number('6508787')->is_valid_number, '兵庫地域センター');
ok($zip->set_number('6508794')->is_valid_number, '大阪貯金事務センター 神戸分館');
ok($zip->set_number('6510170')->is_valid_number, 'みなとカード 株式会社');
ok($zip->set_number('6510171')->is_valid_number, '三井住友海上火災保険 株式会社 神戸支店');
ok($zip->set_number('6510172')->is_valid_number, '中央三井信託銀行 株式会社 神戸支店');
ok($zip->set_number('6510175')->is_valid_number, '東京海上日動火災保険 株式会社 神戸中央支店');
ok($zip->set_number('6510177')->is_valid_number, '日興コーディアル証券 株式会社 神戸支店');
ok($zip->set_number('6510178')->is_valid_number, '神栄 株式会社');
ok($zip->set_number('6510181')->is_valid_number, '株式会社 りそな銀行 神戸支店');
ok($zip->set_number('6510185')->is_valid_number, '住友生命保険 相互会社 神戸支社');
ok($zip->set_number('6510187')->is_valid_number, '株式会社 ノザワ');
ok($zip->set_number('6510188')->is_valid_number, '富永貿易 株式会社');
ok($zip->set_number('6510193')->is_valid_number, 'みなと銀行');
ok($zip->set_number('6510195')->is_valid_number, '兵庫県 信用保証協会');
ok($zip->set_number('6511195')->is_valid_number, '神戸市北区役所');
ok($zip->set_number('6512180')->is_valid_number, '神戸学院大学 有瀬キャンパス');
ok($zip->set_number('6512187')->is_valid_number, '神戸市外国語大学');
ok($zip->set_number('6512194')->is_valid_number, '神戸市立工業高等専門学校');
ok($zip->set_number('6512195')->is_valid_number, '神戸市西区役所');
ok($zip->set_number('6512196')->is_valid_number, '神戸芸術工科大学');
ok($zip->set_number('6512197')->is_valid_number, '兵庫県立大学 学園都市キャンパス');
ok($zip->set_number('6512492')->is_valid_number, '独立行政法人 情報通信研究機構 関西先端研究センター');
ok($zip->set_number('6512494')->is_valid_number, 'ヒラキ 株式会社');
ok($zip->set_number('6518511')->is_valid_number, '株式会社 そごう 神戸店');
ok($zip->set_number('6518512')->is_valid_number, '全国健康保険協会 兵庫支部');
ok($zip->set_number('6518525')->is_valid_number, '株式会社 フェリシモ 交換返品係(日本郵便神戸支店留め)');
ok($zip->set_number('6518526')->is_valid_number, '神戸市郵送請求処理センター');
ok($zip->set_number('6518567')->is_valid_number, '住友ゴム工業 (株)');
ok($zip->set_number('6518570')->is_valid_number, '神戸市中央区役所');
ok($zip->set_number('6518585')->is_valid_number, '株式会社 神戸製鋼所');
ok($zip->set_number('6518798')->is_valid_number, '神戸逓信病院');
ok($zip->set_number('6528501')->is_valid_number, '神戸トヨペット (株)');
ok($zip->set_number('6528510')->is_valid_number, '富士通テン 株式会社');
ok($zip->set_number('6528550')->is_valid_number, '兵庫税務署');
ok($zip->set_number('6528555')->is_valid_number, '三菱電機 株式会社 電力産業システム事業所');
ok($zip->set_number('6528570')->is_valid_number, '兵庫区役所');
ok($zip->set_number('6528585')->is_valid_number, '三菱重工業 (株) 神戸造船所');
ok($zip->set_number('6538570')->is_valid_number, '長田区役所');
ok($zip->set_number('6538585')->is_valid_number, '株式会社 ケーブルネット神戸芦屋 J:COM神戸・三木');
ok($zip->set_number('6540192')->is_valid_number, '株式会社 シャルレ');
ok($zip->set_number('6540193')->is_valid_number, 'カネボウ薬品 株式会社 関西配送センター');
ok($zip->set_number('6540195')->is_valid_number, '須磨区役所 北須磨支所');
ok($zip->set_number('6540198')->is_valid_number, '(株) フェリシモ');
ok($zip->set_number('6548570')->is_valid_number, '須磨区役所');
ok($zip->set_number('6548585')->is_valid_number, '神戸女子大学');
ok($zip->set_number('6558570')->is_valid_number, '垂水区役所');
ok($zip->set_number('6560192')->is_valid_number, '南あわじ市役所 緑庁舎');
ok($zip->set_number('6560393')->is_valid_number, '南あわじ市役所 西淡庁舎');
ok($zip->set_number('6560492')->is_valid_number, '南あわじ市役所 三原庁舎');
ok($zip->set_number('6560592')->is_valid_number, '南あわじ市役所 南淡庁舎');
ok($zip->set_number('6560595')->is_valid_number, '株式会社 森長組');
ok($zip->set_number('6561395')->is_valid_number, '洲本市役所 五色庁舎');
ok($zip->set_number('6561592')->is_valid_number, '淡路市 一宮総合事務所');
ok($zip->set_number('6561598')->is_valid_number, '株式会社 大発');
ok($zip->set_number('6561792')->is_valid_number, '淡路市 北淡総合事務所');
ok($zip->set_number('6562292')->is_valid_number, '淡路市役所');
ok($zip->set_number('6562392')->is_valid_number, '淡路市 東浦総合事務所');
ok($zip->set_number('6562492')->is_valid_number, '淡路市 岩屋総合事務所');
ok($zip->set_number('6568555')->is_valid_number, '三洋電機 株式会社 ソフトエナジー事業本部');
ok($zip->set_number('6568656')->is_valid_number, '洲本 税務署');
ok($zip->set_number('6568666')->is_valid_number, '淡陽信用組合');
ok($zip->set_number('6568686')->is_valid_number, '洲本市役所');
ok($zip->set_number('6578501')->is_valid_number, '神戸大学');
ok($zip->set_number('6578570')->is_valid_number, '灘区役所');
ok($zip->set_number('6588501')->is_valid_number, '甲南学園');
ok($zip->set_number('6588555')->is_valid_number, '生活協同組合 コープこうべ');
ok($zip->set_number('6588558')->is_valid_number, '神戸薬科大学');
ok($zip->set_number('6588570')->is_valid_number, '東灘区役所');
ok($zip->set_number('6598501')->is_valid_number, '芦屋市役所');
ok($zip->set_number('6598502')->is_valid_number, '市立 芦屋病院');
ok($zip->set_number('6598503')->is_valid_number, '芦屋税務署');
ok($zip->set_number('6598511')->is_valid_number, '学校法人 芦屋学園');
ok($zip->set_number('6608501')->is_valid_number, '尼崎市役所');
ok($zip->set_number('6608511')->is_valid_number, '独立行政法人 労働者健康福祉機構 関西労災病院');
ok($zip->set_number('6608540')->is_valid_number, '株式会社 ミドリ電化');
ok($zip->set_number('6608544')->is_valid_number, '尼崎 税務署');
ok($zip->set_number('6608555')->is_valid_number, '阪神南県民局 尼崎県税事務所');
ok($zip->set_number('6608558')->is_valid_number, '関西電力 株式会社 阪神営業所');
ok($zip->set_number('6608580')->is_valid_number, '日本山村硝子 株式会社');
ok($zip->set_number('6608585')->is_valid_number, 'ヤンマー 株式会社 特機エンジン事業部');
ok($zip->set_number('6608588')->is_valid_number, '兵庫県 阪神南県民局');
ok($zip->set_number('6618501')->is_valid_number, '株式会社 日立プラントテクノロジー尼崎事業所');
ok($zip->set_number('6618510')->is_valid_number, '日本スピンドル製造 株式会社');
ok($zip->set_number('6618511')->is_valid_number, '神東塗料 株式会社');
ok($zip->set_number('6618520')->is_valid_number, '園田学園女子大学・短期大学部');
ok($zip->set_number('6618530')->is_valid_number, '学校法人 英知大学');
ok($zip->set_number('6618550')->is_valid_number, '技研化成 株式会社');
ok($zip->set_number('6618555')->is_valid_number, '関西ペイント 株式会社 尼崎工場');
ok($zip->set_number('6618558')->is_valid_number, 'ジャパン・エア・ガシズ 株式会社');
ok($zip->set_number('6618564')->is_valid_number, '積水化学工業 株式会社 尼崎工場');
ok($zip->set_number('6618567')->is_valid_number, '株式会社 クボタ 本社阪神事務所');
ok($zip->set_number('6618577')->is_valid_number, '株式会社 アシックス 関西支社');
ok($zip->set_number('6618585')->is_valid_number, '第一電工 株式会社 尼崎工場');
ok($zip->set_number('6618661')->is_valid_number, '三菱電機 株式会社');
ok($zip->set_number('6628501')->is_valid_number, '学校法人 関西学院 (西宮上ケ原キャンパス)');
ok($zip->set_number('6628502')->is_valid_number, '株式会社 新井組');
ok($zip->set_number('6628503')->is_valid_number, '阪神南県民局 西宮県税事務所');
ok($zip->set_number('6628505')->is_valid_number, '学校法人 神戸女学院');
ok($zip->set_number('6628510')->is_valid_number, '辰馬本家酒造 株式会社');
ok($zip->set_number('6628521')->is_valid_number, '西宮酒造 株式会社');
ok($zip->set_number('6628533')->is_valid_number, '兵庫栄養専門学校');
ok($zip->set_number('6628543')->is_valid_number, '加藤産業 株式会社');
ok($zip->set_number('6628552')->is_valid_number, '大手前女子大学');
ok($zip->set_number('6628555')->is_valid_number, '夙川学院短期大学');
ok($zip->set_number('6628558')->is_valid_number, 'アサヒパーツ 株式会社');
ok($zip->set_number('6628567')->is_valid_number, '西宮市役所');
ok($zip->set_number('6628580')->is_valid_number, '古野電気 株式会社');
ok($zip->set_number('6628585')->is_valid_number, '西宮税務署');
ok($zip->set_number('6628586')->is_valid_number, '山村硝子 株式会社');
ok($zip->set_number('6638501')->is_valid_number, '学校法人 兵庫医科大学');
ok($zip->set_number('6638510')->is_valid_number, '関電システムソリューションズ 株式会社');
ok($zip->set_number('6638545')->is_valid_number, '極東開発工業 株式会社');
ok($zip->set_number('6638558')->is_valid_number, '学校法人 武庫川学院');
ok($zip->set_number('6638567')->is_valid_number, '日本年金機構 西宮年金事務所');
ok($zip->set_number('6638577')->is_valid_number, 'エスフーズ 株式会社');
ok($zip->set_number('6638585')->is_valid_number, '布亀 株式会社');
ok($zip->set_number('6638586')->is_valid_number, '伊藤ハム 株式会社');
ok($zip->set_number('6638588')->is_valid_number, '加藤産業 株式会社 阪神事業部');
ok($zip->set_number('6648501')->is_valid_number, '日東紡績 株式会社 伊丹生産センター');
ok($zip->set_number('6648502')->is_valid_number, 'パスカル 株式会社');
ok($zip->set_number('6648503')->is_valid_number, '伊丹市役所');
ok($zip->set_number('6648505')->is_valid_number, '伊丹税務署');
ok($zip->set_number('6648507')->is_valid_number, 'サカタインクス 株式会社 大阪工場');
ok($zip->set_number('6648508')->is_valid_number, '松谷化学工業 株式会社');
ok($zip->set_number('6648510')->is_valid_number, '伊丹産業 株式会社');
ok($zip->set_number('6648511')->is_valid_number, 'コニカミノルタ 伊丹サイト');
ok($zip->set_number('6648520')->is_valid_number, '日本板硝子 株式会社 技術研究所');
ok($zip->set_number('6648522')->is_valid_number, '兵庫県阪神北県民局 企画調整部 伊丹県税事務所');
ok($zip->set_number('6648533')->is_valid_number, '公立学校共済組合 近畿中央病院');
ok($zip->set_number('6648540')->is_valid_number, '市立 伊丹病院');
ok($zip->set_number('6648545')->is_valid_number, '伊丹簡易裁判所');
ok($zip->set_number('6648558')->is_valid_number, '伊丹コミュニティ放送 株式会社');
ok($zip->set_number('6648588')->is_valid_number, '凸版印刷 株式会社 伊丹工場');
ok($zip->set_number('6648610')->is_valid_number, '東リ 株式会社');
ok($zip->set_number('6648611')->is_valid_number, '住友電気工業 株式会社 伊丹製作所');
ok($zip->set_number('6648615')->is_valid_number, '株式会社 フジコー');
ok($zip->set_number('6648624')->is_valid_number, '小西酒造 株式会社');
ok($zip->set_number('6648641')->is_valid_number, '三菱電機 株式会社 高周波光デバイス製作所');
ok($zip->set_number('6648650')->is_valid_number, '陸上自衛隊 中部方面総監部');
ok($zip->set_number('6658501')->is_valid_number, '株式会社 ハイレックスコーポレーション');
ok($zip->set_number('6658543')->is_valid_number, '株式会社 エフエム宝塚');
ok($zip->set_number('6658550')->is_valid_number, '新明和工業 株式会社 本社');
ok($zip->set_number('6658555')->is_valid_number, '住友化学工業 (株) 農業化学品研究所');
ok($zip->set_number('6658567')->is_valid_number, '阪神北県民局');
ok($zip->set_number('6658585')->is_valid_number, '宝塚歌劇団');
ok($zip->set_number('6658588')->is_valid_number, '大本山 中山寺');
ok($zip->set_number('6658665')->is_valid_number, '宝塚市役所');
ok($zip->set_number('6660292')->is_valid_number, '猪名川町役場');
ok($zip->set_number('6668501')->is_valid_number, '川西市役所');
ok($zip->set_number('6670198')->is_valid_number, '養父市 養父地域局');
ok($zip->set_number('6678555')->is_valid_number, '公立八鹿病院');
ok($zip->set_number('6678651')->is_valid_number, '養父市役所');
ok($zip->set_number('6680292')->is_valid_number, '豊岡市役所 出石総合支所');
ok($zip->set_number('6680293')->is_valid_number, '株式会社 川嶋建設');
ok($zip->set_number('6680298')->is_valid_number, 'パナソニック エレクトロニックデバイス但馬 株式会社');
ok($zip->set_number('6680393')->is_valid_number, '豊岡市役所 但東総合支所');
ok($zip->set_number('6688650')->is_valid_number, '株式会社 但馬銀行');
ok($zip->set_number('6688655')->is_valid_number, '但馬信用金庫 本店');
ok($zip->set_number('6688666')->is_valid_number, '豊岡市');
ok($zip->set_number('6691592')->is_valid_number, '独立行政法人 国立病院機構 兵庫中央病院');
ok($zip->set_number('6691595')->is_valid_number, '三田市役所');
ok($zip->set_number('6692192')->is_valid_number, '篠山市役所今田支所');
ok($zip->set_number('6692292')->is_valid_number, '篠山市役所 丹南支所');
ok($zip->set_number('6692397')->is_valid_number, '篠山市役所');
ok($zip->set_number('6693192')->is_valid_number, '宗教法人・円応教');
ok($zip->set_number('6693198')->is_valid_number, '丹波市役所 山南支所');
ok($zip->set_number('6693392')->is_valid_number, '柏原税務署');
ok($zip->set_number('6693394')->is_valid_number, '関西電力 (株) 柏原営業所');
ok($zip->set_number('6693395')->is_valid_number, '兵庫県立 柏原病院');
ok($zip->set_number('6693396')->is_valid_number, '丹波市役所 柏原支所');
ok($zip->set_number('6693692')->is_valid_number, '丹波市役所');
ok($zip->set_number('6693693')->is_valid_number, '中兵庫信用金庫');
ok($zip->set_number('6693892')->is_valid_number, '丹波市役所 青垣支所');
ok($zip->set_number('6694192')->is_valid_number, '丹波市役所 春日庁舎');
ok($zip->set_number('6694392')->is_valid_number, '丹波市役所 市島支所');
ok($zip->set_number('6695192')->is_valid_number, '朝来市役所 山東支所');
ok($zip->set_number('6695193')->is_valid_number, '但南建設 株式会社');
ok($zip->set_number('6695197')->is_valid_number, '公立梁瀬病院');
ok($zip->set_number('6695198')->is_valid_number, '藤井電機 株式会社');
ok($zip->set_number('6695292')->is_valid_number, '朝来市役所');
ok($zip->set_number('6695392')->is_valid_number, '公立日高病院');
ok($zip->set_number('6695395')->is_valid_number, '県立日高高等学校');
ok($zip->set_number('6695398')->is_valid_number, 'フジテック 株式会社 Big Step');
ok($zip->set_number('6696192')->is_valid_number, '日和山観光 株式会社・城崎マリンワールド');
ok($zip->set_number('6696195')->is_valid_number, '豊岡市役所 城崎総合支所');
ok($zip->set_number('6696292')->is_valid_number, '豊岡市役所 竹野総合支所');
ok($zip->set_number('6696592')->is_valid_number, '香美町役場');
ok($zip->set_number('6696792')->is_valid_number, '新温泉町役場');
ok($zip->set_number('6696892')->is_valid_number, '新温泉町役場 温泉総合支所');
ok($zip->set_number('6708501')->is_valid_number, '姫路市役所');
ok($zip->set_number('6708502')->is_valid_number, '関西電力 株式会社 姫路営業所');
ok($zip->set_number('6708505')->is_valid_number, '姫路商工会議所');
ok($zip->set_number('6708506')->is_valid_number, 'むつみ 株式会社');
ok($zip->set_number('6708510')->is_valid_number, '株式会社 タビックスジャパン 姫路営業支店');
ok($zip->set_number('6708511')->is_valid_number, 'ジャスコ 株式会社 西部カンパニー');
ok($zip->set_number('6708517')->is_valid_number, '千代田火災海上保険 株式会社');
ok($zip->set_number('6708520')->is_valid_number, '国立姫路病院');
ok($zip->set_number('6708522')->is_valid_number, '日本興亜損害保険 株式会社');
ok($zip->set_number('6708524')->is_valid_number, '姫路獨協大学');
ok($zip->set_number('6708530')->is_valid_number, '姫路市中央保健所');
ok($zip->set_number('6708533')->is_valid_number, 'セルディア/株式会社 三商');
ok($zip->set_number('6708543')->is_valid_number, '姫路税務署');
ok($zip->set_number('6708550')->is_valid_number, '株式会社 富強');
ok($zip->set_number('6708554')->is_valid_number, '株式会社 帝国データバンク 姫路支店');
ok($zip->set_number('6708555')->is_valid_number, '株式会社 ヤマトヤシキ');
ok($zip->set_number('6708558')->is_valid_number, '株式会社 ラボ');
ok($zip->set_number('6708566')->is_valid_number, '株式会社 姫路シティエフエム21');
ok($zip->set_number('6708567')->is_valid_number, 'グローリー 株式会社');
ok($zip->set_number('6708570')->is_valid_number, '丸魚水産 株式会社');
ok($zip->set_number('6708575')->is_valid_number, '株式会社 山陽百貨店');
ok($zip->set_number('6708577')->is_valid_number, '関西電力 株式会社 姫路支店');
ok($zip->set_number('6708580')->is_valid_number, '陸上自衛隊 姫路駐屯地');
ok($zip->set_number('6708585')->is_valid_number, 'ジャスコ 株式会社 姫路フォーラス');
ok($zip->set_number('6708588')->is_valid_number, '株式会社 板文');
ok($zip->set_number('6708652')->is_valid_number, '姫路信用金庫');
ok($zip->set_number('6708655')->is_valid_number, '兵庫信用金庫');
ok($zip->set_number('6708660')->is_valid_number, '株式会社さくら銀行 姫路支店');
ok($zip->set_number('6708666')->is_valid_number, '株式会社 サラト');
ok($zip->set_number('6708668')->is_valid_number, '株式会社 神崎組');
ok($zip->set_number('6708670')->is_valid_number, 'シンキ 株式会社 姫路本部');
ok($zip->set_number('6708675')->is_valid_number, '日本生命保険 相互会社 姫路支社');
ok($zip->set_number('6708677')->is_valid_number, '三菱電機 株式会社 姫路製作所');
ok($zip->set_number('6708680')->is_valid_number, '播州信用金庫');
ok($zip->set_number('6708682')->is_valid_number, '商工組合中央金庫 姫路支店');
ok($zip->set_number('6708688')->is_valid_number, '第一生命保険 相互会社 姫路支社');
ok($zip->set_number('6708689')->is_valid_number, '日本フエルト工業 株式会社');
ok($zip->set_number('6710295')->is_valid_number, '株式会社 寶角ギヤー');
ok($zip->set_number('6711180')->is_valid_number, '日鐵物流 株式会社 広畑支店');
ok($zip->set_number('6711181')->is_valid_number, '株式会社 吉田組');
ok($zip->set_number('6711188')->is_valid_number, '新日本製鐵 株式会社 広畑製鐵所');
ok($zip->set_number('6711192')->is_valid_number, '大和工業 株式会社');
ok($zip->set_number('6711280')->is_valid_number, '西芝電機 株式会社');
ok($zip->set_number('6711281')->is_valid_number, 'ダイセル化学工業姫路製造所');
ok($zip->set_number('6711282')->is_valid_number, '株式会社 日本触媒');
ok($zip->set_number('6711283')->is_valid_number, 'ダイセル化学工業総合研究所');
ok($zip->set_number('6711285')->is_valid_number, 'ティー・エフ・ピー・ディー 株式会社');
ok($zip->set_number('6711286')->is_valid_number, '兵庫県立網干高校');
ok($zip->set_number('6711288')->is_valid_number, '大和産業 株式会社');
ok($zip->set_number('6711289')->is_valid_number, '大日本プラスチック 株式会社');
ok($zip->set_number('6711292')->is_valid_number, '(株) 日本触媒 研究企画部');
ok($zip->set_number('6711293')->is_valid_number, 'シーダム 株式会社 姫路工場');
ok($zip->set_number('6711295')->is_valid_number, '株式会社 東芝 姫路工場');
ok($zip->set_number('6711392')->is_valid_number, 'たつの市 御津総合支所');
ok($zip->set_number('6711393')->is_valid_number, 'タキロン 株式会社 網干工場');
ok($zip->set_number('6711592')->is_valid_number, '太子町役場');
ok($zip->set_number('6711593')->is_valid_number, '株式会社 うかいや');
ok($zip->set_number('6711595')->is_valid_number, '株式会社 東芝姫路工場太子分工場');
ok($zip->set_number('6711680')->is_valid_number, '日本丸天醤油 株式会社');
ok($zip->set_number('6711681')->is_valid_number, 'ダイセル化学工業 株式会社 播磨工場');
ok($zip->set_number('6711682')->is_valid_number, '兵庫西農業協同組合 揖保川支店');
ok($zip->set_number('6711684')->is_valid_number, '揖保川町商工会');
ok($zip->set_number('6711688')->is_valid_number, '医療法人 古橋会 揖保川病院');
ok($zip->set_number('6711692')->is_valid_number, 'たつの市 揖保川総合支所');
ok($zip->set_number('6712192')->is_valid_number, '姫路市夢前事務所');
ok($zip->set_number('6712193')->is_valid_number, '日生学園第三高等学校');
ok($zip->set_number('6712198')->is_valid_number, 'ヤマサ蒲鉾 株式会社');
ok($zip->set_number('6712280')->is_valid_number, '兵庫県立大学');
ok($zip->set_number('6712288')->is_valid_number, '三相電機 株式会社');
ok($zip->set_number('6712592')->is_valid_number, 'NECトーキン 株式会社 兵庫事業所');
ok($zip->set_number('6712593')->is_valid_number, '宍粟市役所');
ok($zip->set_number('6712595')->is_valid_number, '西兵庫信用金庫');
ok($zip->set_number('6712598')->is_valid_number, '宍粟市 山崎市民局');
ok($zip->set_number('6714192')->is_valid_number, '宍粟市 一宮市民局');
ok($zip->set_number('6714193')->is_valid_number, 'ハリマ農業協同組合');
ok($zip->set_number('6728501')->is_valid_number, '医療法人公仁会 姫路中央病院');
ok($zip->set_number('6728550')->is_valid_number, '株式会社 フードサプライジャスコ兵庫事業所');
ok($zip->set_number('6728555')->is_valid_number, '第一燃料工業 株式会社');
ok($zip->set_number('6728558')->is_valid_number, 'トラスコ中山 株式会社 姫路支店');
ok($zip->set_number('6728567')->is_valid_number, '株式会社 アスノ');
ok($zip->set_number('6728585')->is_valid_number, '出光興産 株式会社 兵庫製油所');
ok($zip->set_number('6728655')->is_valid_number, '合同製鐵 株式会社 姫路製造所');
ok($zip->set_number('6728666')->is_valid_number, '横田石油 株式会社');
ok($zip->set_number('6728677')->is_valid_number, '山陽特殊製鋼 株式会社');
ok($zip->set_number('6730492')->is_valid_number, '三木市役所');
ok($zip->set_number('6730592')->is_valid_number, '生活協同組合 コープこうべ');
ok($zip->set_number('6731192')->is_valid_number, '三木市役所 吉川支所');
ok($zip->set_number('6731395')->is_valid_number, '加東市役所 東条庁舎');
ok($zip->set_number('6731493')->is_valid_number, '加東市役所 社庁舎');
ok($zip->set_number('6731494')->is_valid_number, '国立大学法人 兵庫教育大学');
ok($zip->set_number('6731495')->is_valid_number, '加東市やしろ国際学習塾');
ok($zip->set_number('6738511')->is_valid_number, '関西電力 株式会社 明石営業所');
ok($zip->set_number('6738558')->is_valid_number, '兵庫県立成人病センター');
ok($zip->set_number('6738585')->is_valid_number, '兵庫県立明石高等学校');
ok($zip->set_number('6738666')->is_valid_number, '川崎重工業 株式会社 明石工場');
ok($zip->set_number('6738686')->is_valid_number, '明石市役所');
ok($zip->set_number('6748501')->is_valid_number, '明石工業高等専門学校');
ok($zip->set_number('6748555')->is_valid_number, '富士通 株式会社 明石工場');
ok($zip->set_number('6748585')->is_valid_number, '日工 株式会社');
ok($zip->set_number('6748686')->is_valid_number, '新キャタピラー三菱 株式会社 明石事業所');
ok($zip->set_number('6750180')->is_valid_number, '川崎重工業 株式会社');
ok($zip->set_number('6750181')->is_valid_number, '日本エア・リキード 株式会社');
ok($zip->set_number('6750182')->is_valid_number, '播磨町役場');
ok($zip->set_number('6750183')->is_valid_number, '住友精化 株式会社');
ok($zip->set_number('6750184')->is_valid_number, '関西熱化学 株式会社');
ok($zip->set_number('6750185')->is_valid_number, '株式会社 神戸製鋼所 加古川製鉄所');
ok($zip->set_number('6750186')->is_valid_number, '滝川工業 株式会社');
ok($zip->set_number('6750188')->is_valid_number, '兵庫県 いなみの学園');
ok($zip->set_number('6750192')->is_valid_number, '多木化学 株式会社');
ok($zip->set_number('6750193')->is_valid_number, '昭和住宅 株式会社');
ok($zip->set_number('6750194')->is_valid_number, '株式会社 大真空');
ok($zip->set_number('6750196')->is_valid_number, '財団法人 加古川総合保健センター');
ok($zip->set_number('6750198')->is_valid_number, 'バンドー化学 株式会社 加古川工場');
ok($zip->set_number('6751192')->is_valid_number, 'キング醸造 株式会社');
ok($zip->set_number('6751297')->is_valid_number, '播磨社会復帰促進センター');
ok($zip->set_number('6751380')->is_valid_number, '小野市役所');
ok($zip->set_number('6751395')->is_valid_number, '小野商工会議所');
ok($zip->set_number('6752393')->is_valid_number, '市立加西病院');
ok($zip->set_number('6752395')->is_valid_number, '加西市役所');
ok($zip->set_number('6752398')->is_valid_number, '三洋電機 株式会社 ハイ・リビング事業部 回転機事業部加西管理センター');
ok($zip->set_number('6758501')->is_valid_number, '加古川市役所');
ok($zip->set_number('6758510')->is_valid_number, '(株) マルアイ');
ok($zip->set_number('6758511')->is_valid_number, '株式会社 テイエルブイ');
ok($zip->set_number('6758519')->is_valid_number, '本州製罐 株式会社 兵庫工場');
ok($zip->set_number('6758522')->is_valid_number, '加古川市 中央消防署');
ok($zip->set_number('6758533')->is_valid_number, '株式会社 コスモライフ');
ok($zip->set_number('6758555')->is_valid_number, '兵庫県立 加古川医療センター');
ok($zip->set_number('6758558')->is_valid_number, '加古川プラスチックス 株式会社');
ok($zip->set_number('6758566')->is_valid_number, '兵庫県 加古川県税事務所');
ok($zip->set_number('6758577')->is_valid_number, '社会福祉法人 加古川市社会福祉協議会');
ok($zip->set_number('6758588')->is_valid_number, '加古川市 水道局');
ok($zip->set_number('6758686')->is_valid_number, '但陽信用金庫');
ok($zip->set_number('6758688')->is_valid_number, '株式会社 アプコ');
ok($zip->set_number('6768501')->is_valid_number, '高砂市役所');
ok($zip->set_number('6768510')->is_valid_number, 'キッコーマン 株式会社 高砂工場');
ok($zip->set_number('6768513')->is_valid_number, '黒崎播磨 株式会社');
ok($zip->set_number('6768533')->is_valid_number, 'ヤング開発 株式会社');
ok($zip->set_number('6768540')->is_valid_number, '株式会社 タクマ 播磨工場');
ok($zip->set_number('6768558')->is_valid_number, '高砂商工会議所');
ok($zip->set_number('6768566')->is_valid_number, '丸山印刷 株式会社');
ok($zip->set_number('6768585')->is_valid_number, '高砂市民病院');
ok($zip->set_number('6768655')->is_valid_number, '旭硝子 株式会社 高砂工場');
ok($zip->set_number('6768670')->is_valid_number, '株式会社 神戸製鋼所 高砂製作所');
ok($zip->set_number('6768677')->is_valid_number, '三菱製紙 株式会社 高砂工場');
ok($zip->set_number('6768686')->is_valid_number, '三菱重工業 株式会社 高砂製作所');
ok($zip->set_number('6768688')->is_valid_number, '株式会社 カネカ 高砂工業所');
ok($zip->set_number('6778510')->is_valid_number, '西脇ロイヤルホテル');
ok($zip->set_number('6778511')->is_valid_number, '西脇市役所');
ok($zip->set_number('6780192')->is_valid_number, 'アース製薬 株式会社 赤穂本部');
ok($zip->set_number('6780193')->is_valid_number, '赤穂化成 株式会社');
ok($zip->set_number('6780195')->is_valid_number, '大木産業 株式会社');
ok($zip->set_number('6780292')->is_valid_number, '赤穂市役所');
ok($zip->set_number('6781195')->is_valid_number, '兵庫丸門運輸 株式会社');
ok($zip->set_number('6781198')->is_valid_number, '株式会社 赤穂国際カントリークラブ');
ok($zip->set_number('6781292')->is_valid_number, '上郡町役場');
ok($zip->set_number('6781295')->is_valid_number, '兵庫県 西播磨県民局 上郡県税事務所');
ok($zip->set_number('6781297')->is_valid_number, '兵庫県立大学 理学部');
ok($zip->set_number('6788543')->is_valid_number, '関西電力 (株) 相生発電所');
ok($zip->set_number('6788585')->is_valid_number, '相生市役所');
ok($zip->set_number('6790180')->is_valid_number, '伊東電機 株式会社');
ok($zip->set_number('6790181')->is_valid_number, '椿本チエイン 兵庫工場');
ok($zip->set_number('6790187')->is_valid_number, '財団法人 兵庫県フラワーセンター協会');
ok($zip->set_number('6790188')->is_valid_number, '加西市農業協同組合');
ok($zip->set_number('6790198')->is_valid_number, '兵庫県立 中央農業技術センター');
ok($zip->set_number('6790292')->is_valid_number, '加東市役所 滝野庁舎');
ok($zip->set_number('6790295')->is_valid_number, '藤井電工 株式会社');
ok($zip->set_number('6791192')->is_valid_number, '多可町役場');
ok($zip->set_number('6791292')->is_valid_number, '多可町役場 加美地域局');
ok($zip->set_number('6792280')->is_valid_number, '福崎町役場');
ok($zip->set_number('6792281')->is_valid_number, '近畿福祉大学');
ok($zip->set_number('6792282')->is_valid_number, '中小企業大学校関西校');
ok($zip->set_number('6792283')->is_valid_number, '凸版印刷 株式会社 福崎工場');
ok($zip->set_number('6792284')->is_valid_number, 'グローリープロダクツ 株式会社');
ok($zip->set_number('6792285')->is_valid_number, '千寿製薬 (株)');
ok($zip->set_number('6792288')->is_valid_number, '福伸電機 株式会社');
ok($zip->set_number('6792289')->is_valid_number, 'エーモン工業 株式会社');
ok($zip->set_number('6792292')->is_valid_number, '池田デンソー 株式会社');
ok($zip->set_number('6792295')->is_valid_number, 'サンライズ工業 株式会社');
ok($zip->set_number('6792392')->is_valid_number, '市川町役場');
ok($zip->set_number('6792493')->is_valid_number, '公立神崎総合病院');
ok($zip->set_number('6793392')->is_valid_number, '朝来市役所 生野支所');
ok($zip->set_number('6793393')->is_valid_number, 'ヒラキ 株式会社 生野事業所');
ok($zip->set_number('6794192')->is_valid_number, 'たつの市役所');
ok($zip->set_number('6794193')->is_valid_number, 'ヒガシマル醤油 株式会社');
ok($zip->set_number('6794195')->is_valid_number, '極東産機 株式会社');
ok($zip->set_number('6794298')->is_valid_number, 'ヤヱガキ 株式会社');
ok($zip->set_number('6794392')->is_valid_number, 'たつの市 新宮総合支所');
ok($zip->set_number('6794393')->is_valid_number, 'ブンセン 株式会社');
ok($zip->set_number('6794395')->is_valid_number, '株式会社 帝国電機製作所');
ok($zip->set_number('6795192')->is_valid_number, '佐用町役場 三日月支所');
ok($zip->set_number('6795198')->is_valid_number, '財団法人 高輝度光科学研究センター');
ok($zip->set_number('6795292')->is_valid_number, '佐用町役場 南光支所');
ok($zip->set_number('6795380')->is_valid_number, '佐用町役場');
ok($zip->set_number('6795381')->is_valid_number, '兵庫県立 佐用高等学校');
ok($zip->set_number('6795382')->is_valid_number, '佐用共立病院');
ok($zip->set_number('6795383')->is_valid_number, '医療法人 聖医会 佐用中央病院');
ok($zip->set_number('6795392')->is_valid_number, '兵庫西農業共同組合 佐用支店');
ok($zip->set_number('6795595')->is_valid_number, '佐用町役場 上月支所');
ok($zip->set_number('6800197')->is_valid_number, '国府町総合支所');
ok($zip->set_number('6800492')->is_valid_number, '鳥取県立 八頭高等学校');
ok($zip->set_number('6800493')->is_valid_number, '八頭町役場');
ok($zip->set_number('6800495')->is_valid_number, '八頭町役場船岡支所');
ok($zip->set_number('6800792')->is_valid_number, '若桜町役場');
ok($zip->set_number('6801192')->is_valid_number, '鳥取刑務所');
ok($zip->set_number('6808501')->is_valid_number, '鳥取市立病院');
ok($zip->set_number('6808502')->is_valid_number, '全国農業協同組合連合会 鳥取県本部');
ok($zip->set_number('6808510')->is_valid_number, '住友生命保険 相互会社 鳥取支社');
ok($zip->set_number('6808511')->is_valid_number, '大和証券 株式会社 鳥取支店');
ok($zip->set_number('6808517')->is_valid_number, '鳥取赤十字病院');
ok($zip->set_number('6808520')->is_valid_number, '鳥取県警察本部');
ok($zip->set_number('6808522')->is_valid_number, '鳥取労働局');
ok($zip->set_number('6808533')->is_valid_number, '株式会社 ナカニシ');
ok($zip->set_number('6808541')->is_valid_number, '鳥取税務署');
ok($zip->set_number('6808550')->is_valid_number, '鳥取大学 本部');
ok($zip->set_number('6808551')->is_valid_number, '鳥取大学 地域学部');
ok($zip->set_number('6808552')->is_valid_number, '鳥取大学 工学部');
ok($zip->set_number('6808553')->is_valid_number, '鳥取大学 農学部');
ok($zip->set_number('6808554')->is_valid_number, '鳥取大学附属図書館');
ok($zip->set_number('6808555')->is_valid_number, '日本海信販 株式会社');
ok($zip->set_number('6808560')->is_valid_number, '全国健康保険協会 鳥取支部');
ok($zip->set_number('6808566')->is_valid_number, '鳥取商工会議所');
ok($zip->set_number('6808570')->is_valid_number, '鳥取県庁');
ok($zip->set_number('6808571')->is_valid_number, '鳥取市役所');
ok($zip->set_number('6808572')->is_valid_number, '日本海テレビジョン放送 株式会社');
ok($zip->set_number('6808575')->is_valid_number, 'ソニーモバイルディスプレイ (株) 鳥取事業所');
ok($zip->set_number('6808577')->is_valid_number, '三洋エプソンイメージングデバイス 株式会社 鳥取事業所');
ok($zip->set_number('6808585')->is_valid_number, '鳥取県医師会');
ok($zip->set_number('6808588')->is_valid_number, '株式会社 山陰カラー綜合現像所');
ok($zip->set_number('6808601')->is_valid_number, '株式会社 鳥取大丸');
ok($zip->set_number('6808611')->is_valid_number, '鳥取信用金庫');
ok($zip->set_number('6808622')->is_valid_number, '中国電力 株式会社 鳥取営業所');
ok($zip->set_number('6808634')->is_valid_number, '鳥取三洋電機 株式会社');
ok($zip->set_number('6808644')->is_valid_number, '商工組合中央金庫 鳥取支店');
ok($zip->set_number('6808666')->is_valid_number, '中国電力 株式会社 鳥取支店');
ok($zip->set_number('6808678')->is_valid_number, '日本生命保険 相互会社 鳥取支社');
ok($zip->set_number('6808686')->is_valid_number, '株式会社 鳥取銀行');
ok($zip->set_number('6808688')->is_valid_number, '株式会社 新日本海新聞社');
ok($zip->set_number('6808701')->is_valid_number, '日本放送協会 鳥取放送局');
ok($zip->set_number('6818501')->is_valid_number, '岩美町役場');
ok($zip->set_number('6820192')->is_valid_number, '岡山大学医学部・歯学部付属病院 三朝医療センター');
ok($zip->set_number('6820193')->is_valid_number, '岡山大学固体地球研究センター');
ok($zip->set_number('6820195')->is_valid_number, '三朝町役場');
ok($zip->set_number('6820197')->is_valid_number, '鳥取県中部医師会立三朝温泉病院');
ok($zip->set_number('6820498')->is_valid_number, '倉吉市役所 関金支所');
ok($zip->set_number('6828501')->is_valid_number, 'オムロン倉吉 株式会社');
ok($zip->set_number('6828505')->is_valid_number, '新日本海新聞社 中部本社');
ok($zip->set_number('6828522')->is_valid_number, '倉吉 税務署');
ok($zip->set_number('6828555')->is_valid_number, '鳥取短期大学');
ok($zip->set_number('6828585')->is_valid_number, '有限会社 ホテイ堂');
ok($zip->set_number('6828601')->is_valid_number, '倉吉信用金庫');
ok($zip->set_number('6828611')->is_valid_number, '倉吉市役所');
ok($zip->set_number('6838501')->is_valid_number, '株式会社 米子駅前サティ');
ok($zip->set_number('6838502')->is_valid_number, '独立行政法人 国立高等専門学校機構 米子工業高等専門学校');
ok($zip->set_number('6838503')->is_valid_number, '国立大学法人 鳥取大学医学部');
ok($zip->set_number('6838504')->is_valid_number, '国立大学法人 鳥取大学医学部 附属病院');
ok($zip->set_number('6838505')->is_valid_number, '協同組合 丸合');
ok($zip->set_number('6838506')->is_valid_number, '株式会社 さんれいフーズ');
ok($zip->set_number('6838508')->is_valid_number, '株式会社 雪印 アクセス山陰支店');
ok($zip->set_number('6838510')->is_valid_number, '株式会社 米子しんまち天満屋');
ok($zip->set_number('6838511')->is_valid_number, '協同組合 やよいデパート');
ok($zip->set_number('6838512')->is_valid_number, '県立米子西高等学校');
ok($zip->set_number('6838515')->is_valid_number, '西日本信販 株式会社');
ok($zip->set_number('6838516')->is_valid_number, '山陰酸素工業 株式会社');
ok($zip->set_number('6838518')->is_valid_number, '独立行政法人 国立病院機構 米子医療センター');
ok($zip->set_number('6838520')->is_valid_number, '新日本海新聞社 西部本社');
ok($zip->set_number('6838601')->is_valid_number, '米子信用金庫');
ok($zip->set_number('6838602')->is_valid_number, '山陰信販 株式会社');
ok($zip->set_number('6838603')->is_valid_number, '商工組合中央金庫 米子支店');
ok($zip->set_number('6838604')->is_valid_number, '陸上自衛隊 米子駐屯地');
ok($zip->set_number('6838605')->is_valid_number, '独立行政法人 労働者健康福祉機構 山陰労災病院');
ok($zip->set_number('6838670')->is_valid_number, '株式会社 山陰放送');
ok($zip->set_number('6838686')->is_valid_number, '米子市役所');
ok($zip->set_number('6848501')->is_valid_number, '鳥取県 境港市役所');
ok($zip->set_number('6848511')->is_valid_number, '航空自衛隊 美保基地');
ok($zip->set_number('6848555')->is_valid_number, '鳥取県 済生会 境港総合病院');
ok($zip->set_number('6848585')->is_valid_number, '鳥取県立 境水産高等学校');
ok($zip->set_number('6848601')->is_valid_number, '鳥取県立 境高等学校');
ok($zip->set_number('6848686')->is_valid_number, '境港商工会議所');
ok($zip->set_number('6858512')->is_valid_number, '島根県立 隠岐高等学校');
ok($zip->set_number('6858555')->is_valid_number, '隠岐水産高等学校');
ok($zip->set_number('6858585')->is_valid_number, '隠岐の島町役場');
ok($zip->set_number('6858601')->is_valid_number, '隠岐支庁');
ok($zip->set_number('6858666')->is_valid_number, '西郷税務署');
ok($zip->set_number('6890592')->is_valid_number, '鳥取市役所 青谷町総合支所');
ok($zip->set_number('6890595')->is_valid_number, '鳥取県立 青谷高等学校');
ok($zip->set_number('6891192')->is_valid_number, 'ダイヤモンド電機 株式会社');
ok($zip->set_number('6891193')->is_valid_number, '日本セラミック 株式会社');
ok($zip->set_number('6892292')->is_valid_number, '北栄町役場 大栄庁舎');
ok($zip->set_number('6892293')->is_valid_number, '株式会社 サンセキ');
ok($zip->set_number('6892295')->is_valid_number, '鳥取県立 鳥取中央育英高等学校');
ok($zip->set_number('6892298')->is_valid_number, 'JA鳥取中央 大栄支所');
ok($zip->set_number('6892392')->is_valid_number, '琴浦町役場');
ok($zip->set_number('6892393')->is_valid_number, '大山乳業農業 協同組合');
ok($zip->set_number('6892395')->is_valid_number, '東伯町農業 協同組合');
ok($zip->set_number('6893492')->is_valid_number, '米子市 淀江支所');
ok($zip->set_number('6893592')->is_valid_number, '王子製紙 株式会社 米子工場');
ok($zip->set_number('6894292')->is_valid_number, '伯耆町役場 溝口分庁舎');
ok($zip->set_number('6895292')->is_valid_number, '日南町役場');
ok($zip->set_number('6900393')->is_valid_number, '中国電力 株式会社 島根原子力発電所');
ok($zip->set_number('6900396')->is_valid_number, '松江市役所 鹿島支所');
ok($zip->set_number('6901492')->is_valid_number, '有限会社 日本庭園 由志園');
ok($zip->set_number('6902192')->is_valid_number, '松江市役所 八雲支所');
ok($zip->set_number('6902198')->is_valid_number, '小松電機産業 株式会社');
ok($zip->set_number('6908501')->is_valid_number, '島根県庁');
ok($zip->set_number('6908502')->is_valid_number, '島根県 教育委員会');
ok($zip->set_number('6908503')->is_valid_number, '島根県 信用保証協会');
ok($zip->set_number('6908504')->is_valid_number, '島根大学');
ok($zip->set_number('6908505')->is_valid_number, '松江税務署');
ok($zip->set_number('6908507')->is_valid_number, '県立松江農林高等学校');
ok($zip->set_number('6908508')->is_valid_number, '株式会社 エフエム山陰');
ok($zip->set_number('6908509')->is_valid_number, '松江市立病院');
ok($zip->set_number('6908510')->is_valid_number, '島根県 警察本部');
ok($zip->set_number('6908512')->is_valid_number, '松江警察署');
ok($zip->set_number('6908513')->is_valid_number, '松江土建 株式会社');
ok($zip->set_number('6908515')->is_valid_number, '中国電力 株式会社 松江営業所');
ok($zip->set_number('6908516')->is_valid_number, '中国労働金庫 島根県営業本部');
ok($zip->set_number('6908517')->is_valid_number, '学校法人 淞南学園');
ok($zip->set_number('6908518')->is_valid_number, '松江工業高等専門学校');
ok($zip->set_number('6908519')->is_valid_number, '県立松江南高等学校');
ok($zip->set_number('6908520')->is_valid_number, '西日本電信電話 株式会社 島根支店');
ok($zip->set_number('6908521')->is_valid_number, '松江市消防本部');
ok($zip->set_number('6908522')->is_valid_number, '松江生協病院');
ok($zip->set_number('6908523')->is_valid_number, '松江地方裁判所');
ok($zip->set_number('6908525')->is_valid_number, '県立松江商業高等学校');
ok($zip->set_number('6908526')->is_valid_number, '東京海上日動火災保険 株式会社');
ok($zip->set_number('6908528')->is_valid_number, '県立松江工業高等学校');
ok($zip->set_number('6908530')->is_valid_number, '株式会社 マイカル松江サティ');
ok($zip->set_number('6908531')->is_valid_number, '全国健康保険協会 島根支部');
ok($zip->set_number('6908535')->is_valid_number, '島根県医師会');
ok($zip->set_number('6908539')->is_valid_number, '株式会社 山陰合同銀行 クレジットカードセンター');
ok($zip->set_number('6908540')->is_valid_number, '松江市役所');
ok($zip->set_number('6908550')->is_valid_number, 'カナツ技建工業 株式会社');
ok($zip->set_number('6908551')->is_valid_number, '島根県 東部県民センター');
ok($zip->set_number('6908552')->is_valid_number, '松江保健生活協同組合');
ok($zip->set_number('6908555')->is_valid_number, '株式会社 一畑百貨店');
ok($zip->set_number('6908556')->is_valid_number, '国立療養所 松江病院');
ok($zip->set_number('6908558')->is_valid_number, '株式会社 ユニコン');
ok($zip->set_number('6908560')->is_valid_number, '全労済島根県本部');
ok($zip->set_number('6908567')->is_valid_number, '協同組合 島根県鐵工会');
ok($zip->set_number('6908577')->is_valid_number, '日本通運 株式会社 松江支店');
ok($zip->set_number('6908580')->is_valid_number, '株式会社 山陰合同銀行 事務センター');
ok($zip->set_number('6908588')->is_valid_number, 'フジキ 学園通り店');
ok($zip->set_number('6908601')->is_valid_number, '日本放送協会 松江放送局');
ok($zip->set_number('6908611')->is_valid_number, '株式会社 千茶荘');
ok($zip->set_number('6908660')->is_valid_number, '島根県信用農業協同組合連合会');
ok($zip->set_number('6908666')->is_valid_number, '山陰中央テレビジョン放送 株式会社');
ok($zip->set_number('6908668')->is_valid_number, '株式会社 山陰中央新報社');
ok($zip->set_number('6908670')->is_valid_number, '全逓島根地区本部');
ok($zip->set_number('6908677')->is_valid_number, '山陰総合リース');
ok($zip->set_number('6908686')->is_valid_number, '株式会社 山陰合同銀行');
ok($zip->set_number('6908688')->is_valid_number, '株式会社 島根銀行');
ok($zip->set_number('6918601')->is_valid_number, '出雲市役所 平田支所');
ok($zip->set_number('6918602')->is_valid_number, '株式会社 ソノ');
ok($zip->set_number('6928506')->is_valid_number, '(株) さんれいフーズ安来営業所');
ok($zip->set_number('6928510')->is_valid_number, '株式会社 フーズマーケットホック');
ok($zip->set_number('6928550')->is_valid_number, '高林商事 株式会社');
ok($zip->set_number('6928601')->is_valid_number, '日立金属 株式会社 安来工場');
ok($zip->set_number('6928686')->is_valid_number, '安来市役所');
ok($zip->set_number('6938501')->is_valid_number, '島根医科大学');
ok($zip->set_number('6938510')->is_valid_number, '中国電力 株式会社 出雲営業所');
ok($zip->set_number('6938511')->is_valid_number, '出雲総務事務所');
ok($zip->set_number('6938523')->is_valid_number, '松江地方裁判所 出雲支部');
ok($zip->set_number('6938530')->is_valid_number, '出雲市役所');
ok($zip->set_number('6938531')->is_valid_number, '出雲市教育委員会');
ok($zip->set_number('6938533')->is_valid_number, '中国電力 株式会社 出雲電力所');
ok($zip->set_number('6938550')->is_valid_number, '島根県立 看護短期大学');
ok($zip->set_number('6938555')->is_valid_number, '島根県立 中央病院');
ok($zip->set_number('6938566')->is_valid_number, '株式会社 一畑百貨店');
ok($zip->set_number('6938585')->is_valid_number, 'いずも農業 協同組合');
ok($zip->set_number('6938587')->is_valid_number, 'いずも農業 協同組合 ラピタ');
ok($zip->set_number('6938601')->is_valid_number, '株式会社 山陰合同銀行 出雲支店');
ok($zip->set_number('6938614')->is_valid_number, '出雲信用組合');
ok($zip->set_number('6938686')->is_valid_number, '出雲 税務署');
ok($zip->set_number('6948501')->is_valid_number, '石見大田税務署');
ok($zip->set_number('6958501')->is_valid_number, '江津市役所');
ok($zip->set_number('6958502')->is_valid_number, '江の川高等学校');
ok($zip->set_number('6958505')->is_valid_number, '社会福祉法人 恩賜財団 島根県済生会 江津総合病院');
ok($zip->set_number('6958577')->is_valid_number, '株式会社 しちだ・教育研究所');
ok($zip->set_number('6958585')->is_valid_number, '協同組合 グリーンモール');
ok($zip->set_number('6960192')->is_valid_number, '邑南町役場');
ok($zip->set_number('6960193')->is_valid_number, '公立邑智病院');
ok($zip->set_number('6960195')->is_valid_number, '島根おおち農協 石見基幹支所');
ok($zip->set_number('6960198')->is_valid_number, '矢上高等学校');
ok($zip->set_number('6960393')->is_valid_number, '邑南町役場 瑞穂町支所');
ok($zip->set_number('6960692')->is_valid_number, '邑南町役場 羽須美支所');
ok($zip->set_number('6968510')->is_valid_number, '川本総務事務所');
ok($zip->set_number('6970492')->is_valid_number, '島根あさひ社会復帰促進センター');
ok($zip->set_number('6978501')->is_valid_number, '浜田市');
ok($zip->set_number('6978511')->is_valid_number, '浜田医療センター');
ok($zip->set_number('6978512')->is_valid_number, '国立浜田病院附属看護学校');
ok($zip->set_number('6978585')->is_valid_number, 'NTT西日本電信電話 株式会社 島根西支店 (株) NTTネオメイト 中国浜田営業所');
ok($zip->set_number('6978686')->is_valid_number, '浜田 税務署');
ok($zip->set_number('6980292')->is_valid_number, '益田市役所美都総合支所');
ok($zip->set_number('6988501')->is_valid_number, '益田赤十字病院');
ok($zip->set_number('6988503')->is_valid_number, '株式会社 キヌヤ');
ok($zip->set_number('6988504')->is_valid_number, '株式会社 イズミゆめタウン益田');
ok($zip->set_number('6988505')->is_valid_number, '益田サティ');
ok($zip->set_number('6988650')->is_valid_number, '益田市役所');
ok($zip->set_number('6988651')->is_valid_number, '益田 税務署');
ok($zip->set_number('6990192')->is_valid_number, '東出雲町役場');
ok($zip->set_number('6990193')->is_valid_number, 'フジキコーポレーション 株式会社');
ok($zip->set_number('6990195')->is_valid_number, '三菱農機 株式会社');
ok($zip->set_number('6990292')->is_valid_number, '松江市役所 玉湯支所');
ok($zip->set_number('6990293')->is_valid_number, '玉造厚生年金病院');
ok($zip->set_number('6990492')->is_valid_number, '島根県立 宍道高等学校');
ok($zip->set_number('6990496')->is_valid_number, '株式会社 原商');
ok($zip->set_number('6990588')->is_valid_number, '社団法人 日本アマチュア無線連盟 JARL QSLビューロー');
ok($zip->set_number('6990592')->is_valid_number, '斐川町役場');
ok($zip->set_number('6990593')->is_valid_number, '斐川町農業協同組合 (JA斐川町)');
ok($zip->set_number('6990696')->is_valid_number, '株式会社 出雲村田製作所');
ok($zip->set_number('6990697')->is_valid_number, 'JA全農 島根県本部');
ok($zip->set_number('6990792')->is_valid_number, '出雲市役所 大社支所');
ok($zip->set_number('6991292')->is_valid_number, '雲南市役所 大東総合センター');
ok($zip->set_number('6991293')->is_valid_number, '公立雲南総合病院');
ok($zip->set_number('6991392')->is_valid_number, '雲南市役所');
ok($zip->set_number('6991393')->is_valid_number, 'ホシザキ電機 株式会社 島根工場');
ok($zip->set_number('6991394')->is_valid_number, '島根三洋工業 株式会社');
ok($zip->set_number('6991395')->is_valid_number, '雲南農業 協同組合');
ok($zip->set_number('6991396')->is_valid_number, '東部県民センター 雲南事務所');
ok($zip->set_number('6991592')->is_valid_number, '奥出雲町役場');
ok($zip->set_number('6991898')->is_valid_number, '島根県立 横田高等学校');
ok($zip->set_number('6992598')->is_valid_number, '大田市役所 温泉津支所');
ok($zip->set_number('6994292')->is_valid_number, '江津市 桜江支所');
ok($zip->set_number('6994298')->is_valid_number, '今井産業 株式会社');
ok($zip->set_number('6994692')->is_valid_number, '美郷町役場');
ok($zip->set_number('6995292')->is_valid_number, '津和野町役場');
ok($zip->set_number('6995695')->is_valid_number, '津和野町 教育委員会');
ok($zip->set_number('7008502')->is_valid_number, '株式会社 天満屋ストア');
ok($zip->set_number('7008503')->is_valid_number, '犬飼医療器 株式会社');
ok($zip->set_number('7008504')->is_valid_number, '株式会社 両備システムズ');
ok($zip->set_number('7008505')->is_valid_number, '川崎医科大学附属川崎病院');
ok($zip->set_number('7008506')->is_valid_number, '全国健康保険協会 岡山支部');
ok($zip->set_number('7008507')->is_valid_number, '中国電力 株式会社 岡山営業所');
ok($zip->set_number('7008511')->is_valid_number, '岡山済生会総合病院');
ok($zip->set_number('7008512')->is_valid_number, '岡山県警察本部');
ok($zip->set_number('7008515')->is_valid_number, '株式会社 ホテルグランヴィア岡山');
ok($zip->set_number('7008516')->is_valid_number, 'ノートルダム清心女子大学');
ok($zip->set_number('7008517')->is_valid_number, '自衛隊 岡山地方連絡部');
ok($zip->set_number('7008518')->is_valid_number, '両備ホールディングス 株式会社');
ok($zip->set_number('7008519')->is_valid_number, '西日本電信電話 株式会社 岡山支店');
ok($zip->set_number('7008522')->is_valid_number, '財団法人 社会保険健康事業財団 岡山県支部');
ok($zip->set_number('7008525')->is_valid_number, '岡山大学大学院 医歯薬学総合研究科(歯学部)、岡山大学病院(歯科)');
ok($zip->set_number('7008527')->is_valid_number, '岡山県立 岡山芳泉高等学校');
ok($zip->set_number('7008528')->is_valid_number, '株式会社 カワニシ');
ok($zip->set_number('7008530')->is_valid_number, '岡山大学');
ok($zip->set_number('7008532')->is_valid_number, '中国四国農政局');
ok($zip->set_number('7008534')->is_valid_number, '株式会社 山陽新聞社 編集局');
ok($zip->set_number('7008535')->is_valid_number, '岡山市 農業協同組合');
ok($zip->set_number('7008538')->is_valid_number, '株式会社 トミヤコーポレーション');
ok($zip->set_number('7008539')->is_valid_number, '中国地方整備局 岡山国道事務所');
ok($zip->set_number('7008540')->is_valid_number, '株式会社 荒木組');
ok($zip->set_number('7008544')->is_valid_number, '岡山市役所');
ok($zip->set_number('7008545')->is_valid_number, '株式会社 金辺商会');
ok($zip->set_number('7008546')->is_valid_number, '岡山市保健福祉会館');
ok($zip->set_number('7008549')->is_valid_number, 'コーホク印刷 株式会社');
ok($zip->set_number('7008550')->is_valid_number, '株式会社 大本組');
ok($zip->set_number('7008551')->is_valid_number, '旭電業 株式会社');
ok($zip->set_number('7008554')->is_valid_number, '岡山市役所 (分庁舎)');
ok($zip->set_number('7008555')->is_valid_number, '中国財務局 岡山財務事務所');
ok($zip->set_number('7008556')->is_valid_number, '岡山商工会議所');
ok($zip->set_number('7008557')->is_valid_number, '総合病院 岡山市立市民病院');
ok($zip->set_number('7008558')->is_valid_number, '岡山大学大学院 医歯薬学総合研究科(医学部)、岡山大学病院(医科)');
ok($zip->set_number('7008560')->is_valid_number, '浅野産業 株式会社');
ok($zip->set_number('7008561')->is_valid_number, '株式会社 マイカル岡山ビブレ');
ok($zip->set_number('7008562')->is_valid_number, 'カイタック 株式会社 GM営業部');
ok($zip->set_number('7008568')->is_valid_number, '岡山県国民健康保険団体連合会');
ok($zip->set_number('7008569')->is_valid_number, '全労済岡山県本部');
ok($zip->set_number('7008570')->is_valid_number, '岡山県庁');
ok($zip->set_number('7008571')->is_valid_number, 'あいおい損害保険 株式会社');
ok($zip->set_number('7008572')->is_valid_number, '岡山西社会保険事務所');
ok($zip->set_number('7008575')->is_valid_number, '富士通 株式会社 岡山支店');
ok($zip->set_number('7008577')->is_valid_number, '高塚ライフサイエンス 株式会社');
ok($zip->set_number('7008578')->is_valid_number, '株式会社 タビックスジャパン 岡山支店');
ok($zip->set_number('7008580')->is_valid_number, '山陽放送 株式会社');
ok($zip->set_number('7008581')->is_valid_number, '株式会社 瀬戸内海放送 岡山本社');
ok($zip->set_number('7008585')->is_valid_number, '東京海上日動火災保険 株式会社 岡山支店');
ok($zip->set_number('7008586')->is_valid_number, 'カイタック 株式会社');
ok($zip->set_number('7008588')->is_valid_number, '丸紅 株式会社 岡山支店');
ok($zip->set_number('7008589')->is_valid_number, 'ワールドトレーディングサービス&Co');
ok($zip->set_number('7008601')->is_valid_number, '岡山商科大学');
ok($zip->set_number('7008603')->is_valid_number, '岡山食品容器 株式会社');
ok($zip->set_number('7008604')->is_valid_number, '岡山県 備前県民局');
ok($zip->set_number('7008605')->is_valid_number, '新生電機 株式会社');
ok($zip->set_number('7008606')->is_valid_number, '大和流通システム 株式会社');
ok($zip->set_number('7008607')->is_valid_number, '総合病院 岡山赤十字病院');
ok($zip->set_number('7008608')->is_valid_number, '蜂谷工業 株式会社');
ok($zip->set_number('7008610')->is_valid_number, '株式会社 イーオン');
ok($zip->set_number('7008611')->is_valid_number, '岡山労働局');
ok($zip->set_number('7008613')->is_valid_number, '(株) 岡山リビング新聞社');
ok($zip->set_number('7008614')->is_valid_number, 'スミクラ 株式会社');
ok($zip->set_number('7008615')->is_valid_number, '岡山社会保険事務局');
ok($zip->set_number('7008616')->is_valid_number, '岡山地方法務局');
ok($zip->set_number('7008617')->is_valid_number, '株式会社 エイトコンサルタント');
ok($zip->set_number('7008618')->is_valid_number, '株式会社 全備');
ok($zip->set_number('7008619')->is_valid_number, 'トップツアー 株式会社 岡山支店');
ok($zip->set_number('7008620')->is_valid_number, '株式会社 夢番地');
ok($zip->set_number('7008621')->is_valid_number, '日本放送協会 岡山放送局');
ok($zip->set_number('7008623')->is_valid_number, '商工中金 岡山支店');
ok($zip->set_number('7008625')->is_valid_number, '株式会社 天満屋 岡山店');
ok($zip->set_number('7008628')->is_valid_number, '株式会社 中国銀行');
ok($zip->set_number('7008634')->is_valid_number, '株式会社 山陽新聞社');
ok($zip->set_number('7008635')->is_valid_number, '岡山放送 株式会社');
ok($zip->set_number('7008639')->is_valid_number, 'おかやま信用金庫');
ok($zip->set_number('7008640')->is_valid_number, '野村証券 株式会社 岡山支店');
ok($zip->set_number('7008645')->is_valid_number, '清水産業 株式会社');
ok($zip->set_number('7008655')->is_valid_number, '岡山東税務署');
ok($zip->set_number('7008657')->is_valid_number, '全日信販 株式会社');
ok($zip->set_number('7008660')->is_valid_number, '三井住友海上火災保険 株式会社');
ok($zip->set_number('7008673')->is_valid_number, '三菱UFJ信託銀行 株式会社 岡山支店');
ok($zip->set_number('7008677')->is_valid_number, 'テレビせとうち 株式会社');
ok($zip->set_number('7008678')->is_valid_number, '株式会社 岡山日日新聞新社');
ok($zip->set_number('7008686')->is_valid_number, '株式会社 ベネッセコーポレーション 本社');
ok($zip->set_number('7008701')->is_valid_number, '木原興業 株式会社');
ok($zip->set_number('7008706')->is_valid_number, '中国電力 株式会社 岡山支社');
ok($zip->set_number('7008707')->is_valid_number, '日本銀行 岡山支店');
ok($zip->set_number('7008722')->is_valid_number, '全国農業協同組合連合会 岡山県本部');
ok($zip->set_number('7008727')->is_valid_number, '農林中央金庫 岡山支店');
ok($zip->set_number('7008731')->is_valid_number, '中銀リース 株式会社');
ok($zip->set_number('7008732')->is_valid_number, '岡山県 信用保証協会');
ok($zip->set_number('7008733')->is_valid_number, 'アイサワ工業 株式会社');
ok($zip->set_number('7008734')->is_valid_number, '株式会社 山陽新聞社 新聞製作センター');
ok($zip->set_number('7008738')->is_valid_number, '第一生命保険 相互会社 岡山支社');
ok($zip->set_number('7010192')->is_valid_number, '川崎医科大学');
ok($zip->set_number('7010193')->is_valid_number, '川崎医療福祉大学');
ok($zip->set_number('7010194')->is_valid_number, '川崎医療短期大学');
ok($zip->set_number('7010195')->is_valid_number, 'ノートルダム清心学園');
ok($zip->set_number('7010197')->is_valid_number, '中国学園');
ok($zip->set_number('7010292')->is_valid_number, '小橋工業 株式会社');
ok($zip->set_number('7010295')->is_valid_number, '全農岡山県本部総合流通センター');
ok($zip->set_number('7010296')->is_valid_number, '岡山市民生活協同組合');
ok($zip->set_number('7010297')->is_valid_number, '岡山県立 興陽高等学校');
ok($zip->set_number('7010298')->is_valid_number, '岡山県 環境保健センター');
ok($zip->set_number('7010393')->is_valid_number, '株式会社 ハローズ');
ok($zip->set_number('7011192')->is_valid_number, '独立行政法人 国立病院機構 岡山医療センター');
ok($zip->set_number('7011195')->is_valid_number, '独立行政法人 国立病院機構 岡山医療センター附属岡山看護学校');
ok($zip->set_number('7011292')->is_valid_number, '黒住教本部');
ok($zip->set_number('7011296')->is_valid_number, '岡山県 工業技術センター');
ok($zip->set_number('7012292')->is_valid_number, '赤磐市 赤坂支所');
ok($zip->set_number('7012595')->is_valid_number, '赤磐市 吉井支所');
ok($zip->set_number('7013292')->is_valid_number, '備前市 日生総合支所');
ok($zip->set_number('7013293')->is_valid_number, '日生信用金庫');
ok($zip->set_number('7014292')->is_valid_number, '瀬戸内市役所');
ok($zip->set_number('7014293')->is_valid_number, '瀬戸内市役所 長船支所');
ok($zip->set_number('7014392')->is_valid_number, '瀬戸内市役所 牛窓支所');
ok($zip->set_number('7014394')->is_valid_number, '日本オリーブ 株式会社');
ok($zip->set_number('7014398')->is_valid_number, '株式会社 元浜組');
ok($zip->set_number('7014592')->is_valid_number, '国立療養所 長島愛生園');
ok($zip->set_number('7014593')->is_valid_number, '国立療養所 邑久光明園');
ok($zip->set_number('7028501')->is_valid_number, '株式会社 源吉兆庵');
ok($zip->set_number('7028502')->is_valid_number, '株式会社 アルファ');
ok($zip->set_number('7028505')->is_valid_number, '岡山労災病院');
ok($zip->set_number('7028506')->is_valid_number, '同和鉱業 株式会社');
ok($zip->set_number('7028507')->is_valid_number, '三井製糖 株式会社 岡山工場');
ok($zip->set_number('7028508')->is_valid_number, '財団法人 慈圭会 慈圭病院');
ok($zip->set_number('7028510')->is_valid_number, 'トラスコ中山 株式会社 岡山支店');
ok($zip->set_number('7028511')->is_valid_number, '株式会社 岡山県水');
ok($zip->set_number('7028512')->is_valid_number, '双葉電機 株式会社');
ok($zip->set_number('7028515')->is_valid_number, 'セイレイ工業 株式会社');
ok($zip->set_number('7028601')->is_valid_number, '株式会社 クラレ 岡山事業所');
ok($zip->set_number('7028602')->is_valid_number, '株式会社 岡山丸果');
ok($zip->set_number('7028603')->is_valid_number, '岡山宮地弘商事 株式会社');
ok($zip->set_number('7028605')->is_valid_number, 'トリツ機工 株式会社');
ok($zip->set_number('7028606')->is_valid_number, '小林機工 株式会社');
ok($zip->set_number('7028607')->is_valid_number, '株式会社 前嶋');
ok($zip->set_number('7028609')->is_valid_number, '同和工営 株式会社');
ok($zip->set_number('7038501')->is_valid_number, '山陽学園大学.山陽学園短期大学');
ok($zip->set_number('7038502')->is_valid_number, 'オムロン 株式会社 岡山事業所');
ok($zip->set_number('7038505')->is_valid_number, 'オハヨー乳業 株式会社');
ok($zip->set_number('7038508')->is_valid_number, '財団法人 岡山県教育会');
ok($zip->set_number('7038510')->is_valid_number, '中国セキスイ工業 株式会社');
ok($zip->set_number('7038511')->is_valid_number, '総合病院 岡山協立病院');
ok($zip->set_number('7038516')->is_valid_number, '就実大学.就実短期大学');
ok($zip->set_number('7038520')->is_valid_number, '財団法人 林精神医学研究所 附属林道倫精神科神経科病院');
ok($zip->set_number('7038522')->is_valid_number, '社団法人 岡山県医師会');
ok($zip->set_number('7038530')->is_valid_number, '株式会社 ヒラタ');
ok($zip->set_number('7038533')->is_valid_number, '岡山東社会保険事務所');
ok($zip->set_number('7038544')->is_valid_number, '中区役所');
ok($zip->set_number('7038550')->is_valid_number, '岡山県 学校生活協同組合');
ok($zip->set_number('7038555')->is_valid_number, '社会福祉法人 旭川荘');
ok($zip->set_number('7038558')->is_valid_number, '岡山積水工業 株式会社');
ok($zip->set_number('7038560')->is_valid_number, '旭川荘厚生専門学院');
ok($zip->set_number('7038566')->is_valid_number, '岡山市東福祉事務所');
ok($zip->set_number('7038570')->is_valid_number, '株式会社 岡山農栄社');
ok($zip->set_number('7038573')->is_valid_number, '岡山県立 岡山操山高等学校');
ok($zip->set_number('7038574')->is_valid_number, '岡山県立 岡山操山高等学校 通信制課程');
ok($zip->set_number('7038575')->is_valid_number, '岡山東警察署');
ok($zip->set_number('7038580')->is_valid_number, 'ナカウン 株式会社');
ok($zip->set_number('7038585')->is_valid_number, '岡山四国共和 株式会社');
ok($zip->set_number('7038588')->is_valid_number, '内山工業 株式会社');
ok($zip->set_number('7038655')->is_valid_number, '株式会社 ジョセイ新聞社');
ok($zip->set_number('7038686')->is_valid_number, '株式会社 中国銀行事務センター');
ok($zip->set_number('7038750')->is_valid_number, '岡山県 学校生活協同組合');
ok($zip->set_number('7048501')->is_valid_number, 'JA西大寺 西大寺農業協同組合');
ok($zip->set_number('7048502')->is_valid_number, '岡山学芸館高等学校');
ok($zip->set_number('7048510')->is_valid_number, '日本エクスラン工業 株式会社 西大寺工場');
ok($zip->set_number('7048555')->is_valid_number, '東区役所');
ok($zip->set_number('7048588')->is_valid_number, 'カーツ 株式会社 本部');
ok($zip->set_number('7058501')->is_valid_number, '市立備前病院');
ok($zip->set_number('7058502')->is_valid_number, 'あかいわ農業共同組合備前支店');
ok($zip->set_number('7058507')->is_valid_number, '岡山県立 備前緑陽高等学校');
ok($zip->set_number('7058510')->is_valid_number, 'NTN 株式会社 岡山製作所');
ok($zip->set_number('7058555')->is_valid_number, '岡山大鵬薬品 株式会社');
ok($zip->set_number('7058558')->is_valid_number, '備前商工会議所');
ok($zip->set_number('7058575')->is_valid_number, '宗教法人 熊山油滝神社');
ok($zip->set_number('7058577')->is_valid_number, '品川白煉瓦 株式会社 技術研究所');
ok($zip->set_number('7058585')->is_valid_number, 'パナソニック株式会社 岡山工場');
ok($zip->set_number('7058588')->is_valid_number, '日生運輸 株式会社');
ok($zip->set_number('7058602')->is_valid_number, '備前市役所');
ok($zip->set_number('7058603')->is_valid_number, '備前信用金庫');
ok($zip->set_number('7058609')->is_valid_number, '九州耐火煉瓦 株式会社');
ok($zip->set_number('7058614')->is_valid_number, '興亜耐火工業 株式会社');
ok($zip->set_number('7058615')->is_valid_number, '品川白煉瓦 株式会社 岡山工場');
ok($zip->set_number('7068501')->is_valid_number, '三井造船生活 協同組合');
ok($zip->set_number('7068510')->is_valid_number, '玉野市役所');
ok($zip->set_number('7068511')->is_valid_number, '三井金属鉱業株式会社 金属事業部 日比製煉所');
ok($zip->set_number('7068531')->is_valid_number, '総合病院玉野市立玉野市民病院');
ok($zip->set_number('7068533')->is_valid_number, '玉野商工会議所');
ok($zip->set_number('7068555')->is_valid_number, '岡山県立玉野高等学校');
ok($zip->set_number('7068651')->is_valid_number, '三井造船 株式会社 玉野事業所');
ok($zip->set_number('7068655')->is_valid_number, '玉野税務署');
ok($zip->set_number('7078501')->is_valid_number, '美作市役所');
ok($zip->set_number('7078502')->is_valid_number, 'みまさか商工会');
ok($zip->set_number('7078585')->is_valid_number, '岡山県 美作県民局 勝英支局');
ok($zip->set_number('7080392')->is_valid_number, '鏡野町役場');
ok($zip->set_number('7080393')->is_valid_number, '株式会社 山田養蜂場');
ok($zip->set_number('7080698')->is_valid_number, '独立行政法人 日本原子力研究開発機構 人形峠環境技術センター');
ok($zip->set_number('7081193')->is_valid_number, 'トーステ 株式会社 サニタリー事業本部');
ok($zip->set_number('7081198')->is_valid_number, '山陽ロード工業 株式会社');
ok($zip->set_number('7081392')->is_valid_number, '奈義町役場');
ok($zip->set_number('7081393')->is_valid_number, '陸上自衛隊 日本原駐屯地');
ok($zip->set_number('7088501')->is_valid_number, '津山市役所');
ok($zip->set_number('7088502')->is_valid_number, '津山卸センター');
ok($zip->set_number('7088503')->is_valid_number, '津山総合食品卸売市場');
ok($zip->set_number('7088505')->is_valid_number, 'マルイ 株式会社');
ok($zip->set_number('7088506')->is_valid_number, '岡山県美作県民局');
ok($zip->set_number('7088507')->is_valid_number, 'ナンバ 株式会社');
ok($zip->set_number('7088509')->is_valid_number, '津山工業高等専門学校');
ok($zip->set_number('7088510')->is_valid_number, '津山教育事務所');
ok($zip->set_number('7088511')->is_valid_number, '美作大学');
ok($zip->set_number('7088512')->is_valid_number, '小原産業 株式会社');
ok($zip->set_number('7088515')->is_valid_number, 'イズミ津山店');
ok($zip->set_number('7088516')->is_valid_number, '津山商工会議所');
ok($zip->set_number('7088517')->is_valid_number, 'パナソニックエレクトロニックデバイスジャパン 株式会社 津山ディビジョン');
ok($zip->set_number('7088518')->is_valid_number, '作陽高等学校');
ok($zip->set_number('7088519')->is_valid_number, '株式会社 天満屋 津山店');
ok($zip->set_number('7088520')->is_valid_number, 'アルネ・津山');
ok($zip->set_number('7088609')->is_valid_number, '津山公共職業安定所');
ok($zip->set_number('7088652')->is_valid_number, '日本植生 株式会社');
ok($zip->set_number('7088653')->is_valid_number, '中国銀行 津山支店');
ok($zip->set_number('7088654')->is_valid_number, '中国電力 津山営業所');
ok($zip->set_number('7088657')->is_valid_number, '津山 税務署');
ok($zip->set_number('7090492')->is_valid_number, '岡山県備前県民局 東備支局');
ok($zip->set_number('7090494')->is_valid_number, '和気農業 協同組合');
ok($zip->set_number('7090495')->is_valid_number, '和気町役場');
ok($zip->set_number('7090496')->is_valid_number, '株式会社 徳永こいのぼり');
ok($zip->set_number('7090497')->is_valid_number, '北川病院');
ok($zip->set_number('7090498')->is_valid_number, '平病院');
ok($zip->set_number('7090792')->is_valid_number, '赤磐市 熊山支所');
ok($zip->set_number('7090892')->is_valid_number, 'みのる産業 株式会社');
ok($zip->set_number('7090893')->is_valid_number, '松下電器産業 株式会社 AVC社 ビデオ事業部 ビデオ工場 岡山');
ok($zip->set_number('7090895')->is_valid_number, 'キリンビール 株式会社 岡山工場');
ok($zip->set_number('7090897')->is_valid_number, '岡山市 瀬戸支所');
ok($zip->set_number('7090898')->is_valid_number, '赤磐市役所');
ok($zip->set_number('7091292')->is_valid_number, '南区役所');
ok($zip->set_number('7092192')->is_valid_number, '岡山県 運転免許センター');
ok($zip->set_number('7092196')->is_valid_number, 'カバヤ食品 株式会社');
ok($zip->set_number('7092198')->is_valid_number, '岡山市役所 御津支所');
ok($zip->set_number('7092393')->is_valid_number, '吉備高原学園高等学校');
ok($zip->set_number('7092398')->is_valid_number, '吉備中央町役場 加茂川庁舎');
ok($zip->set_number('7093198')->is_valid_number, '岡山市 北区役所 建部支所');
ok($zip->set_number('7093494')->is_valid_number, '岡山県 総合畜産センター');
ok($zip->set_number('7093497')->is_valid_number, '津山農業協同組合 旭支店');
ok($zip->set_number('7093498')->is_valid_number, '美咲町 旭総合支所');
ok($zip->set_number('7094292')->is_valid_number, '美作市役所 作東総合支所');
ok($zip->set_number('7094392')->is_valid_number, '株式会社 ミルキーエイジ');
ok($zip->set_number('7100292')->is_valid_number, '学校法人 作陽学園');
ok($zip->set_number('7100293')->is_valid_number, '倉敷市 船穂支所');
ok($zip->set_number('7100294')->is_valid_number, 'JA岡山西 農業協同組合 船穂支店');
ok($zip->set_number('7100298')->is_valid_number, '株式会社 北原産業');
ok($zip->set_number('7101398')->is_valid_number, '倉敷市役所 真備支所');
ok($zip->set_number('7108501')->is_valid_number, '萩原 株式会社');
ok($zip->set_number('7108505')->is_valid_number, '丸五ゴム工業 株式会社');
ok($zip->set_number('7108511')->is_valid_number, '岡山学院大学・岡山短期大学');
ok($zip->set_number('7108520')->is_valid_number, '岡山地方法務局 倉敷支局');
ok($zip->set_number('7108522')->is_valid_number, '財団法人 倉敷成人病センター');
ok($zip->set_number('7108525')->is_valid_number, '株式会社 帝国データバンク 倉敷支店');
ok($zip->set_number('7108528')->is_valid_number, '株式会社 エフエムくらしき');
ok($zip->set_number('7108530')->is_valid_number, '岡山県 備中県民局');
ok($zip->set_number('7108535')->is_valid_number, '倉敷中央天寿会');
ok($zip->set_number('7108543')->is_valid_number, '中国電力 株式会社 倉敷営業所');
ok($zip->set_number('7108550')->is_valid_number, '株式会社 天満屋 倉敷店');
ok($zip->set_number('7108555')->is_valid_number, '株式会社 日之出運輸');
ok($zip->set_number('7108558')->is_valid_number, '倉敷簡易裁判所');
ok($zip->set_number('7108560')->is_valid_number, 'イオン倉敷ショッピングセンター');
ok($zip->set_number('7108565')->is_valid_number, '倉敷市役所');
ok($zip->set_number('7108575')->is_valid_number, '(財) 大原美術館');
ok($zip->set_number('7108581')->is_valid_number, '倉敷木材 株式会社');
ok($zip->set_number('7108585')->is_valid_number, '倉敷商工会議所');
ok($zip->set_number('7108588')->is_valid_number, '明治乳業 株式会社 中国支店 岡山オフィス');
ok($zip->set_number('7108601')->is_valid_number, '株式会社 中国銀行 倉敷駅前支店');
ok($zip->set_number('7108602')->is_valid_number, '財団法人 倉敷中央病院');
ok($zip->set_number('7108605')->is_valid_number, '日本生命保険相互会社 倉敷支社');
ok($zip->set_number('7108611')->is_valid_number, 'カモ井加工紙 株式会社');
ok($zip->set_number('7108615')->is_valid_number, '株式会社 中国銀行 倉敷支店');
ok($zip->set_number('7108622')->is_valid_number, '株式会社 クラレ 倉敷事業所');
ok($zip->set_number('7108638')->is_valid_number, '平松エンタープライズ 株式会社');
ok($zip->set_number('7108648')->is_valid_number, '倉敷 税務署');
ok($zip->set_number('7108666')->is_valid_number, '藤徳物産 株式会社');
ok($zip->set_number('7108678')->is_valid_number, 'カモ井食品工業 株式会社');
ok($zip->set_number('7108686')->is_valid_number, '株式会社 トクラ');
ok($zip->set_number('7118510')->is_valid_number, '旭化成ケミカルズ 株式会社 水島製造所');
ok($zip->set_number('7118511')->is_valid_number, '日本ゼオン 株式会社 水島工場');
ok($zip->set_number('7118520')->is_valid_number, '瀬戸埠頭 株式会社');
ok($zip->set_number('7118555')->is_valid_number, '倉敷ファッションセンター 株式会社');
ok($zip->set_number('7118565')->is_valid_number, '倉敷市 児島支所');
ok($zip->set_number('7118567')->is_valid_number, '倉敷市 競艇事業局');
ok($zip->set_number('7118588')->is_valid_number, '株式会社 サノヤス・ヒシノ明昌水島製造所');
ok($zip->set_number('7118611')->is_valid_number, '明石被服興業 株式会社');
ok($zip->set_number('7118622')->is_valid_number, '尾崎商事 株式会社');
ok($zip->set_number('7118650')->is_valid_number, '児島 税務署');
ok($zip->set_number('7118686')->is_valid_number, '株式会社 ビッグジョン');
ok($zip->set_number('7118688')->is_valid_number, '難波プレス工業 株式会社');
ok($zip->set_number('7128501')->is_valid_number, '三菱自動車工業 株式会社 生産・物流本部 水島製作所');
ok($zip->set_number('7128502')->is_valid_number, '萩原工業 株式会社');
ok($zip->set_number('7128505')->is_valid_number, '倉敷芸術科学大学 倉敷 食と器 専門学校');
ok($zip->set_number('7128511')->is_valid_number, 'JFEスチール 株式会社 西日本製鉄所 倉敷地区');
ok($zip->set_number('7128512')->is_valid_number, 'JFE物流 株式会社');
ok($zip->set_number('7128513')->is_valid_number, '水島合金鉄 株式会社');
ok($zip->set_number('7128514')->is_valid_number, 'JFEシステムズ 株式会社');
ok($zip->set_number('7128515')->is_valid_number, '水島共同火力 株式会社');
ok($zip->set_number('7128525')->is_valid_number, '三菱ガス化学 株式会社 水島工場');
ok($zip->set_number('7128533')->is_valid_number, '関東電化工業 株式会社 水島工場')