package Google::Ads::AdWords::v201705::PerformanceTarget;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201705' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %volumeGoalType_of :ATTR(:get<volumeGoalType>);
my %volumeTargetValue_of :ATTR(:get<volumeTargetValue>);
my %efficiencyTargetType_of :ATTR(:get<efficiencyTargetType>);
my %efficiencyTargetValue_of :ATTR(:get<efficiencyTargetValue>);
my %spendTarget_of :ATTR(:get<spendTarget>);
my %spendTargetType_of :ATTR(:get<spendTargetType>);
my %forecastStatus_of :ATTR(:get<forecastStatus>);
my %hasPromotedSuggestions_of :ATTR(:get<hasPromotedSuggestions>);
my %startDate_of :ATTR(:get<startDate>);
my %endDate_of :ATTR(:get<endDate>);

__PACKAGE__->_factory(
    [ qw(        volumeGoalType
        volumeTargetValue
        efficiencyTargetType
        efficiencyTargetValue
        spendTarget
        spendTargetType
        forecastStatus
        hasPromotedSuggestions
        startDate
        endDate

    ) ],
    {
        'volumeGoalType' => \%volumeGoalType_of,
        'volumeTargetValue' => \%volumeTargetValue_of,
        'efficiencyTargetType' => \%efficiencyTargetType_of,
        'efficiencyTargetValue' => \%efficiencyTargetValue_of,
        'spendTarget' => \%spendTarget_of,
        'spendTargetType' => \%spendTargetType_of,
        'forecastStatus' => \%forecastStatus_of,
        'hasPromotedSuggestions' => \%hasPromotedSuggestions_of,
        'startDate' => \%startDate_of,
        'endDate' => \%endDate_of,
    },
    {
        'volumeGoalType' => 'Google::Ads::AdWords::v201705::VolumeGoalType',
        'volumeTargetValue' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'efficiencyTargetType' => 'Google::Ads::AdWords::v201705::EfficiencyTargetType',
        'efficiencyTargetValue' => 'SOAP::WSDL::XSD::Typelib::Builtin::double',
        'spendTarget' => 'Google::Ads::AdWords::v201705::Money',
        'spendTargetType' => 'Google::Ads::AdWords::v201705::SpendTargetType',
        'forecastStatus' => 'Google::Ads::AdWords::v201705::PerformanceTargetStatus',
        'hasPromotedSuggestions' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'startDate' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'endDate' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'volumeGoalType' => 'volumeGoalType',
        'volumeTargetValue' => 'volumeTargetValue',
        'efficiencyTargetType' => 'efficiencyTargetType',
        'efficiencyTargetValue' => 'efficiencyTargetValue',
        'spendTarget' => 'spendTarget',
        'spendTargetType' => 'spendTargetType',
        'forecastStatus' => 'forecastStatus',
        'hasPromotedSuggestions' => 'hasPromotedSuggestions',
        'startDate' => 'startDate',
        'endDate' => 'endDate',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201705::PerformanceTarget

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
PerformanceTarget from the namespace https://adwords.google.com/api/adwords/cm/v201705.

This class is used to configure various Performance Targets. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * volumeGoalType


=item * volumeTargetValue


=item * efficiencyTargetType


=item * efficiencyTargetValue


=item * spendTarget


=item * spendTargetType


=item * forecastStatus


=item * hasPromotedSuggestions


=item * startDate


=item * endDate




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

