#!/usr/bin/perl -T

# This test outputs information about the testing machine to help fingerprint it in the test report
# and tries to make the error in tempdir happen, using the most mininal subset of SATest for init

use v5.14.0;
use strict;
use warnings;

use Cwd;
use Config;
use File::Spec;
use POSIX;

BEGIN {
  my $RUNNING_ON_WINDOWS = ($^O =~ /^(mswin|dos|os2)/oi);

  # Clean PATH so taint doesn't complain
  if (!$RUNNING_ON_WINDOWS) {
    $ENV{'PATH'} = '/bin:/usr/bin:/usr/local/bin';
    # Remove tainted envs, at least ENV used in FreeBSD
    delete @ENV{qw(IFS CDPATH ENV BASH_ENV)};
  } else {
    # Windows might need non-system directories in PATH to run a Perl installation
    # The best we can do is clean out obviously bad stuff such as relative paths or \..\
    my @pathdirs = split(';', $ENV{'PATH'});
    $ENV{'PATH'} =
      join(';', # filter for only dirs that are canonical absolute paths that exist
        map {
              my $pathdir = $_;
              $pathdir =~ s/\\*\z//;
              my $abspathdir = Cwd::realpath($pathdir) if (File::Spec->file_name_is_absolute($pathdir) and (-d $pathdir));
              if (defined $abspathdir) {
                $abspathdir  =~ /^(.*)\z/s;
                $abspathdir = $1; # untaint it
              }
              ((defined $abspathdir) and (lc $pathdir eq lc $abspathdir))?($abspathdir):()
            }
          @pathdirs);
  }  
}

# This must be compiled after the BEGIN block or else it fails in taint mode in OpenBSD
use Net::Address::Ethernet qw(get_addresses);

use Test::More tests => 1;

# ---------------------------------------------------------------------------

# Output various id information for this computer
# in an attempt to have something that uniquely identifies
# the machine that is running these tests
# so future runs on the same tester can be correlated

sub _get_machine_id {
  ## DEBUG - ID the machine so we know which tester is having the problems
  my $machineid = "unknown";
  if (open(my $file, '<', "/etc/machine-id")) { 
    $machineid = <$file>; 
    close $file;
    chomp $machineid;
  }
  return $machineid;
}

sub _get_active_mac_addresses {
    return join("; ", map ($_->{'sEthernet'}, grep ($_->{'iActive'} && $_->{'sEthernet'} && $_->{'sIP'}, get_addresses())));
}

sub _get_uname_string {
  return join("; ", POSIX::uname());
}

diag("\ncwd is ", Cwd::cwd, "\n");
diag "\nINC is '@INC'\nPATH is '$ENV{'PATH'}\n";
diag("\nMachine ID: ", _get_machine_id(), "\nMAC addresses ", _get_active_mac_addresses(), "\nuname: ", _get_uname_string(), "\n");

ok(1, "dummy test");
