#
# CSwitch.pm CSwitch Prederefed
#        this is a mixture of prederefed register addressing and
#        switched runloop
#        Please consult the corresponding OpTrans files for more
#
# Author: leo
#
# $Id: CSwitch.pm,v 1.1 2003/05/18 10:03:21 leo Exp $
#

use strict;
#use warnings;

package Parrot::OpTrans::CSwitch;

use Parrot::OpTrans;
use Parrot::OpTrans::CPrederef;
use vars qw(@ISA);
@ISA = qw(Parrot::OpTrans::CPrederef);


#
# suffix()
#

sub suffix
{
  return "_switch";
}

sub defines
{
  return <<END;
#define REL_PC ((size_t)((opcode_t*)cur_opcode - (opcode_t*)interpreter->prederef_code))
#define CUR_OPCODE (interpreter->code->byte_code + REL_PC)


static void** opcode_to_prederef(struct Parrot_Interp* interpreter,
                                        opcode_t* opcode_addr)
{
    INTVAL offset_in_ops;
    if (opcode_addr == NULL) return NULL;
    offset_in_ops = opcode_addr - (opcode_t*) interpreter->code->byte_code;
    return interpreter->prederef_code + offset_in_ops;
}

END
}
#
# goto_address()
#

sub goto_address
{
  my ($self, $addr) = @_;
#print STDERR "pbcc: map_ret_abs($addr)\n";
  if ($addr eq '0') {
  	return "return (0);"
  } else {
  	return " {cur_opcode = (opcode_t *) opcode_to_prederef(interpreter, $addr); goto SWITCH_AGAIN; }";
  }
}

#
# goto_offset()
#

sub goto_offset
{
  my ($self, $offset) = @_;
  return "{ cur_opcode += $offset; goto SWITCH_AGAIN; }";
}
#
# goto_pop()
#

sub goto_pop
{
  my ($self) = @_;
  return "{ cur_opcode = (opcode_t*)opcode_to_prederef(interpreter,pop_dest(interpreter));\n  goto SWITCH_AGAIN; }";
}
