package BenchmarkAnything::Storage::Frontend::HTTP::Controller::Search;
BEGIN {
  $BenchmarkAnything::Storage::Frontend::HTTP::Controller::Search::AUTHORITY = 'cpan:SCHWIGON';
}
# ABSTRACT: BenchmarkAnything - Mojolicious - REST API
$BenchmarkAnything::Storage::Frontend::HTTP::Controller::Search::VERSION = '0.001';
use Mojo::Base 'Mojolicious::Controller';


sub hello
{
        my ($self) = @_;

        $self->render;
}


sub search
{
        my ($self) = @_;

        my $value_id = $self->param('value_id');
        my $query    = $self->req->json;

        if ($value_id) {
                $self->render(json => $self->tapper_benchmark->get_single_benchmark_point($value_id));
        }
        elsif ($query)
        {
                $self->render(json => $self->tapper_benchmark->search_array($query));
        }
        else
        {
                $self->render(json => []);
        }
}


sub listnames
{
        my ($self) = @_;

        my $pattern = $self->param('pattern');

        my @pattern = $pattern ? ($pattern) : ();
        my $answer = $self->tapper_benchmark->list_benchmark_names(@pattern);

        $self->render(json => $self->tapper_benchmark->list_benchmark_names(@pattern));
}

1;

__END__

=pod

=encoding utf-8

=head1 NAME

BenchmarkAnything::Storage::Frontend::HTTP::Controller::Search - BenchmarkAnything - Mojolicious - REST API

=head2 hello

Returns a hello answer. Mostly for self and unit testing.

=head2 search

Parameters:

=over 4

=item * value_id (INTEGER)

If a single integer value is provided the complete data point for that
ID is returned.

=item * JSON request body

If a JSON request is provided it is interpreted as query according to
L<Tapper::Benchmark::search()|Tapper::Benchmark/search>.

=back

=head2 listnames

Returns a list of available benchmark metric NAMEs.

Parameters:

=over 4

=item * pattern (STRING)

If a pattern is provided it restricts the results. The pattern is used
as SQL LIKE pattern, i.e., it allows to use C<%> as wildcards.

=back

=head1 AUTHOR

Steffen Schwigon <ss5@renormalist.net>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Steffen Schwigon.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
