# Copyright (C) 1999 Bibliotech Ltd., 631-633 Fulham Rd., London SW6 5UQ.
#
# $Id: Net-FTPServer.spec.PL,v 1.10 2001/09/01 09:44:18 rich Exp $

use strict;

my $output = (@ARGV > 0 ? $ARGV[0] : "Net-FTPServer.spec");

unless (do "lib/Net/FTPServer.pm")
  {
    if ($@) { die $@ }
    die "lib/Net/FTPServer.pm: $!"
  }

local $/ = undef;
$_ = <DATA>;
s/\@VERSION\@/$Net::FTPServer::VERSION/g;
s/\@RELEASE\@/$Net::FTPServer::RELEASE/g;

open SPEC, ">$output" or die "$output: $!";
print SPEC $_;
close SPEC;

__DATA__
# Automatically generated by Net-FTPServer.spec.PL

%define perlsitearch %(perl -e 'use Config; print $Config{installsitearch}, "\\n"')
%define perlsitelib %(perl -e 'use Config; print $Config{installsitelib}, "\\n"')
%define perlman1dir %(perl -e 'use Config; print $Config{installman1dir}, "\\n"')
%define perlman3dir %(perl -e 'use Config; print $Config{installman3dir}, "\\n"')
%define perlversion %(perl -e 'use Config; print $Config{version}, "\\n"')

Summary: Net::FTPServer - an extensible, secure FTP server
Name: Net-FTPServer
Version: @VERSION@
Release: @RELEASE@
Copyright: GPL
Group: Applications/Internet
Source: %{name}-%{version}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-root
Requires: Archive-Tar >= 0.22
Requires: Archive-Zip >= 0.11
Requires: Authen-PAM >= 0.12
Requires: BSD-Resource >= 1.08
Requires: Compress-Zlib >= 1.14
Requires: File-Sync >= 0.09
Requires: IO-stringy >= 1.220
Requires: perl >= %{perlversion}

%description


%prep
%setup -q


%build
perl Makefile.PL
make
make test


%install
rm -rf $RPM_BUILD_ROOT
make PREFIX=$RPM_BUILD_ROOT/usr install
find $RPM_BUILD_ROOT/usr -type f -print | perl -p -e "s@^$RPM_BUILD_ROOT(.*)@\$1*@g" | grep -v perllocal.pod > %{name}-filelist

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}-filelist
%defattr(-,root,root)

%changelog
* Tue Feb 15 2001 Rob Brown <rbrown@about-inc.com>
- Generalized files - works with Perl 5.6 as well as with Perl 5.005
* Tue Feb 08 2001 Richard Jones <rich@annexia.org>
- initial creation
