#!/usr/bin/perl
#

use strict;
use warnings;
use Test::More tests => 7;

use Net::DNS::Multicast;


my $resolver = Net::DNS::Resolver->new( retrans => 0, retry => 0 );

my $packet = Net::DNS::Packet->new('example.local');
my ($q) = $packet->question;
is( $q->unicast_response(1), 1, 'set/read MDNS unicast_response flag' );
ok( !$resolver->send($packet), 'multicast $resolver->send("example.local")' );

ok( !$resolver->bgsend('example.local'), 'multicast $resolver->bgsend("example.local")' );

ok( !$resolver->send('example.com'),   'unicast $resolver->send("example.com")' );
ok( !$resolver->bgsend('example.com'), 'unicast $resolver->bgsend("example.com")' );

ok( $resolver->string, '$resolver->string' );

my $rr = Net::DNS::RR->new('example.local. AAAA ::1');
is( $rr->cache_flush(1), 1, 'set/read MDNS cache_flush flag' );

exit;


package Net::DNS::Resolver;		## off-line dry test
sub _create_tcp_socket {return}		## stub
sub _create_udp_socket {return}		## stub

__END__

