#-*- mode: perl;-*-

use Test::More tests => 44;
use Test::Warn;

use_ok('Module::MakefilePL::Parse');

{
  my $s = qq{
use 5.006001;
use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    NAME              => 'Module::MakefilePL::Parse',
);
};

  my $m = Module::MakefilePL::Parse->new( $s );
  ok(defined $m);

  my $req = $m->required;
  ok(defined $req);
  ok((keys %$req) == 0);
}

{
  my $VERSION = 0;
  my $s = qq{
use 5.006001;
use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    NAME              => 'Module::MakefilePL::Parse',
    VERSION_FROM      => 'lib/Module/MakefilePL/Parse.pm', # finds $VERSION
    PREREQ_PM         => { }, # e.g., Module::Name => 1.1
    ($] >= 5.005 ?     ## Add these new keywords supported since 5.005
      (ABSTRACT_FROM  => 'lib/Module/MakefilePL/Parse.pm', # retrieve abstract from module
       AUTHOR         => 'Robert Rothenberg <rrwo at cpan.org>') : ()),
};


#  print STDERR $s;

  my $m = Module::MakefilePL::Parse->new( $s );
  ok(defined $m);

  my $req = $m->required;
  ok(defined $req);
  ok((keys %$req) == 0);
}

{
  my $s = qq{
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME              => 'Module::MakefilePL::Parse',
    VERSION_FROM      => 'lib/Module/MakefilePL/Parse.pm',
    PREREQ_PM         => {
      'Test::More' => 0,
    },
);

};

#  print STDERR $s;

  my $m = Module::MakefilePL::Parse->new( $s );
  ok(defined $m);

  my $req = $m->required;
  ok(defined $req);
  ok((keys %$req) == 1);
}

{
  my $s = qq{
# Note: this file was auto-generated by Module::Build::Compat version 0.03
use ExtUtils::MakeMaker;
WriteMakefile
(
          'NAME' => 'List::SkipList',
          'VERSION_FROM' => 'lib/List/SkipList.pm',
          'PREREQ_PM' => {
                           'Test::More' => '0',
                           'enum' => '1.016'
                         },
          'INSTALLDIRS' => 'site',
          'PL_FILES' => {}
        )
;
};

#  print STDERR $s;

  my $m = Module::MakefilePL::Parse->new( $s );
  ok(defined $m);

  my $req = $m->required;
  ok(defined $req);
  ok((keys %$req) == 2);
}

{
  my $s = qq{
use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    'NAME'		=> 'Acme::Beatnik',
    'PREREQ_PM'		=> { Filter::Simple => 0.78 }, # e.g., Module::Name => 1.1
);
};

#  print STDERR $s;

  my $m = Module::MakefilePL::Parse->new( $s );
  ok(defined $m);

  my $req = $m->required;
  ok(defined $req);
  ok((keys %$req) == 1);
}

{
  my $s = qq{
use ExtUtils::MakeMaker;
WriteMakefile(
     'NAME'             => 'Acme::Chef',
     'PREREQ_PM'        => {Test::More => 0.44, File::Temp => 0.12}, # e.g., Module::Name => 1.1);
);
};

#  print STDERR $s;

  my $m = Module::MakefilePL::Parse->new( $s );
  ok(defined $m);

  my $req = $m->required;
  ok(defined $req);
  ok((keys %$req) == 2);
}

{
  my $s = qq{
use ExtUtils::MakeMaker;
WriteMakefile(
     'NAME'             => 'Acme::Currency',
     'PREREQ_PM'        => {Test::More=>0,Filter::Simple=>0}, # e.g., Module::Name => 1.1);
);
};

#  print STDERR $s;

  my $m = Module::MakefilePL::Parse->new( $s );
  ok(defined $m);

  my $req = $m->required;
  ok(defined $req);
  ok((keys %$req) == 2);
}

{
  my ($LAST_API_CHANGE,$PACKAGE) = (0, "Module::MakefilePL::Parse");
  my $s = qq{
use ExtUtils::MakeMaker;
# - Fill in your dependencies in PREREQ_PM
unless ($@) { # Make sure we did find the module.
    print <<"CHANGE_WARN" if ${$PACKAGE.'::VERSION'} < $LAST_API_CHANGE;

Some warning message here.

CHANGE_WARN
}
WriteMakefile(
    'NAME'          => 'AnyLoader',
    'PREREQ_PM'     => {   
                        Class::ISA      => '0.31',
                       },
);
};

#  print STDERR $s;

  my $m = Module::MakefilePL::Parse->new( $s );
  ok(defined $m);

  my $req = $m->required;
  ok(defined $req);
  ok((keys %$req) == 1);
}


{
  my $s = qq{
use ExtUtils::MakeMaker;
WriteMakefile(
    'NAME'             => 'Chemistry::File::SMARTS',
    'PREREQ_PM'		=> {qw(
        Chemistry::Mol          0.24
        Chemistry::Pattern      0.21
        List::Util              0
        Test::More              0
    )}, 
);
};

#  print STDERR $s;

  my $m = Module::MakefilePL::Parse->new( $s );
  ok(defined $m);

  my $req = $m->required;
  ok(defined $req);
  ok((keys %$req) == 4);
}

{
  my $s = qq{
use ExtUtils::MakeMaker;
WriteMakefile(
    'PREREQ_PM'		=> {
      'Foo::Bar', 1.1,
      'Bo::Baz',  0,
    }, 
);
};

  my $m = Module::MakefilePL::Parse->new( $s );
  ok(defined $m);

  my $req = $m->required;
  ok(defined $req);
  ok((keys %$req) == 2);
}

{
  my $s = qq{
use ExtUtils::MakeMaker;
WriteMakefile(
    'PREREQ_PM'	=> \%some_hash, 
    'ANOTHER'   => { foo => 'bar', },
);
};

  my $m = Module::MakefilePL::Parse->new( $s );
  ok(!defined $m);
}

{
  my $s = qq{
use ExtUtils::MakeMaker;
WriteMakefile(
    'PREREQ_PM'	=> {
      'Module' => 0,
      \$Dynamic => 0,
    },
);
};

  my $m;
  warning_is {
    $m = Module::MakefilePL::Parse->new( $s );
  } "Warning: possible variable references";
  ok(!defined $m);
}

{
  my $s = qq{
use ExtUtils::MakeMaker;
WriteMakefile(
    'PREREQ_PM'	=> {
      'Module' => sub { return 1; },
    },
);
};


  my $m;
  warning_is {
    $m = Module::MakefilePL::Parse->new( $s );
  } "Warning: embedded hash references or code";

  local $TODO = "Undetermined behavior";
  ok(!defined $m, "May or may not be defined");
}

{
  my $s = qq[
use ExtUtils::MakeMaker;
WriteMakefile(
    'PREREQ_PM'	=> {
      'Module' => 1,

);
];

  my $m;
  warning_is {
    $m = Module::MakefilePL::Parse->new( $s );
  } "Missing closing bracket";

  ok(!defined $m);
}

{
  my $s = qq{
use Module::Install;

};

  my $m;
  eval {
    $m = Module::MakefilePL::Parse->new( $s );
  };
  ok(!defined $m);
}

{
  my $s = qq{
use ExtUtils::MakeMaker;
WriteMakefile(
    'PREREQ_PM'	=> [
      'Module', 0,
    ],
);
};


  my $m;
  eval {
    $m = Module::MakefilePL::Parse->new( $s );
  };

  ok(!defined $m);
}

{
  my $s = qq{
use ExtUtils::MakeMaker;
WriteMakefile(
    'PREREQ_PM'	=> (
      'Module', 0,
    ),
);
};


  my $m;
  eval {
    $m = Module::MakefilePL::Parse->new( $s );
  };
  ok(!defined $m);
}


{
  my $s = qq{
use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

WriteMakefile
(
'DISTNAME'			=> 'DBIx-MSSQLReporter',
'PREREQ_PM'			=>
	{
		DBI			=> '1.13',
	},
};

  my $m = Module::MakefilePL::Parse->new( $s );
  ok(defined $m);

  my $req = $m->required;
  ok(defined $req);
  ok((keys %$req) == 1);
}
