/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.converter.json;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jmx4perl.Config;
import org.jmx4perl.JmxRequest;
import org.jmx4perl.converter.StringToObjectConverter;
import org.jmx4perl.converter.json.ArrayHandler;
import org.jmx4perl.converter.json.BeanHandler;
import org.jmx4perl.converter.json.CompositeDataHandler;
import org.jmx4perl.converter.json.ListHandler;
import org.jmx4perl.converter.json.MapHandler;
import org.jmx4perl.converter.json.TabularDataHandler;
import org.jmx4perl.converter.json.simplifier.ClassHandler;
import org.jmx4perl.converter.json.simplifier.DomElementHandler;
import org.jmx4perl.converter.json.simplifier.FileHandler;
import org.jmx4perl.converter.json.simplifier.UrlHandler;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectToJsonConverter {
    private List<Handler> handlers;
    private ArrayHandler arrayHandler;
    private ThreadLocal<StackContext> stackContextLocal = new ThreadLocal();
    private StringToObjectConverter stringToObjectConverter;
    private int hardMaxDepth;
    private int hardMaxCollectionSize;
    private int hardMaxObjects;
    private static final Set<Class> SIMPLE_TYPES = new HashSet<Class>(Arrays.asList(String.class, Number.class, Long.class, Integer.class, Boolean.class, Date.class));

    public ObjectToJsonConverter(StringToObjectConverter pStringToObjectConverter, Map<Config, String> pConfig) {
        this.initLimits(pConfig);
        this.handlers = new ArrayList<Handler>();
        this.handlers.add(new ListHandler());
        this.handlers.add(new MapHandler());
        this.handlers.add(new ClassHandler());
        this.handlers.add(new FileHandler());
        this.handlers.add(new DomElementHandler());
        this.handlers.add(new UrlHandler());
        this.handlers.add(new CompositeDataHandler());
        this.handlers.add(new TabularDataHandler());
        this.handlers.add(new BeanHandler());
        this.arrayHandler = new ArrayHandler();
        this.stringToObjectConverter = pStringToObjectConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject convertToJson(Object pValue, JmxRequest pRequest) throws AttributeNotFoundException {
        Stack<String> extraStack = this.reverseArgs(pRequest);
        this.setupContext(pRequest.getMaxDepth(), pRequest.getMaxCollectionSize(), pRequest.getMaxObjects());
        try {
            Object jsonResult = this.extractObject(pValue, extraStack, true);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"value", jsonResult);
            jsonObject.put((Object)"request", (Object)pRequest.toJSON());
            JSONObject jSONObject = jsonObject;
            return jSONObject;
        }
        finally {
            this.clearContext();
        }
    }

    public Object[] getValues(String pType, Object pCurrentValue, JmxRequest pRequest) throws AttributeNotFoundException, IllegalAccessException, InvocationTargetException {
        List<String> extraArgs = pRequest.getExtraArgs();
        if (extraArgs != null && extraArgs.size() > 0) {
            if (pCurrentValue == null) {
                throw new IllegalArgumentException("Cannot set value with path when parent object is not set");
            }
            String lastPathElement = extraArgs.remove(extraArgs.size() - 1);
            Stack<String> extraStack = this.reverseArgs(pRequest);
            Object inner = this.extractObject(pCurrentValue, extraStack, false);
            Object oldValue = this.setObjectValue(inner, lastPathElement, pRequest.getValue());
            return new Object[]{pCurrentValue, oldValue};
        }
        return new Object[]{this.stringToObjectConverter.convertFromString(pType, pRequest.getValue()), pCurrentValue};
    }

    private void initLimits(Map<Config, String> pConfig) {
        if (pConfig != null) {
            this.hardMaxDepth = Integer.parseInt(Config.MAX_DEPTH.getValue(pConfig));
            this.hardMaxCollectionSize = Integer.parseInt(Config.MAX_COLLECTIONS_SIZE.getValue(pConfig));
            this.hardMaxObjects = Integer.parseInt(Config.MAX_OBJECTS.getValue(pConfig));
        } else {
            this.hardMaxDepth = 0;
            this.hardMaxCollectionSize = 0;
            this.hardMaxObjects = 0;
        }
    }

    private Stack<String> reverseArgs(JmxRequest pRequest) {
        Stack<String> extraStack = new Stack<String>();
        List<String> extraArgs = pRequest.getExtraArgs();
        if (extraArgs != null) {
            for (int i = extraArgs.size() - 1; i >= 0; --i) {
                extraStack.push(extraArgs.get(i));
            }
        }
        return extraStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractObject(Object pValue, Stack<String> pExtraArgs, boolean jsonify) throws AttributeNotFoundException {
        StackContext stackContext = this.stackContextLocal.get();
        String limitReached = this.checkForLimits(pValue, stackContext);
        if (limitReached != null) {
            return limitReached;
        }
        try {
            stackContext.push(pValue);
            stackContext.incObjectCount();
            if (pValue == null) {
                Object var6_6 = null;
                return var6_6;
            }
            if (pValue.getClass().isArray()) {
                Object object = this.arrayHandler.extractObject(this, pValue, pExtraArgs, jsonify);
                return object;
            }
            Object object = this.callHandler(pValue, pExtraArgs, jsonify);
            return object;
        }
        finally {
            stackContext.pop();
        }
    }

    private String checkForLimits(Object pValue, StackContext pStackContext) {
        int maxDepth = pStackContext.getMaxDepth();
        if (maxDepth != 0 && pStackContext.size() > maxDepth) {
            return "[Depth limit " + pValue.getClass().getName() + "@" + Integer.toHexString(pValue.hashCode()) + "]";
        }
        if (pValue != null && pStackContext.alreadyVisited(pValue)) {
            return "[Reference " + pValue.getClass().getName() + "@" + Integer.toHexString(pValue.hashCode()) + "]";
        }
        if (this.exceededMaxObjects()) {
            return "[Object limit exceeded]";
        }
        return null;
    }

    private Object callHandler(Object pValue, Stack<String> pExtraArgs, boolean jsonify) throws AttributeNotFoundException {
        Class<?> pClazz = pValue.getClass();
        for (Handler handler : this.handlers) {
            if (handler.getType() == null || !handler.getType().isAssignableFrom(pClazz)) continue;
            return handler.extractObject(this, pValue, pExtraArgs, jsonify);
        }
        throw new IllegalStateException("Internal error: No handler found for class " + pClazz + " (object: " + pValue + ", extraArgs: " + pExtraArgs + ")");
    }

    private Object setObjectValue(Object pInner, String pAttribute, String pValue) throws IllegalAccessException, InvocationTargetException {
        Class<?> clazz = pInner.getClass();
        if (clazz.isArray()) {
            return this.arrayHandler.setObjectValue(this.stringToObjectConverter, pInner, pAttribute, pValue);
        }
        for (Handler handler : this.handlers) {
            if (handler.getType() == null || !handler.getType().isAssignableFrom(clazz)) continue;
            return handler.setObjectValue(this.stringToObjectConverter, pInner, pAttribute, pValue);
        }
        throw new IllegalStateException("Internal error: No handler found for class " + clazz + " for getting object value." + " (object: " + pInner + ", attribute: " + pAttribute + ", value: " + pValue + ")");
    }

    final ThreadLocal<StackContext> getStackContextLocal() {
        return this.stackContextLocal;
    }

    int getCollectionLength(int originalLength) {
        StackContext ctx = this.stackContextLocal.get();
        int maxSize = ctx.getMaxCollectionSize();
        if (maxSize > 0 && originalLength > maxSize) {
            return maxSize;
        }
        return originalLength;
    }

    void incObjectCount() {
        StackContext ctx = this.stackContextLocal.get();
        ctx.incObjectCount();
    }

    boolean exceededMaxObjects() {
        StackContext ctx = this.stackContextLocal.get();
        return ctx.getMaxObjects() > 0 && ctx.getObjectCount() > ctx.getMaxObjects();
    }

    void clearContext() {
        this.stackContextLocal.remove();
    }

    void setupContext(int pMaxDepth, int pMaxCollectionSize, int pMaxObjects) {
        int maxDepth = this.getLimit(pMaxDepth, this.hardMaxDepth);
        int maxCollectionSize = this.getLimit(pMaxCollectionSize, this.hardMaxCollectionSize);
        int maxObjects = this.getLimit(pMaxObjects, this.hardMaxObjects);
        StackContext stackContext = new StackContext(maxDepth, maxCollectionSize, maxObjects);
        this.stackContextLocal.set(stackContext);
    }

    private int getLimit(int pReqValue, int pHardLimit) {
        if (pHardLimit != 0) {
            return pReqValue > pHardLimit ? pHardLimit : pReqValue;
        }
        return pReqValue;
    }

    static class StackContext {
        private Set objectsInCallStack = new HashSet();
        private Stack callStack = new Stack();
        private int maxDepth;
        private int maxCollectionSize;
        private int maxObjects;
        private int objectCount = 0;

        public StackContext(int pMaxDepth, int pMaxCollectionSize, int pMaxObjects) {
            this.maxDepth = pMaxDepth;
            this.maxCollectionSize = pMaxCollectionSize;
            this.maxObjects = pMaxObjects;
        }

        void push(Object object) {
            this.callStack.push(object);
            if (object != null && !SIMPLE_TYPES.contains(object.getClass())) {
                this.objectsInCallStack.add(object);
            }
        }

        Object pop() {
            Object ret = this.callStack.pop();
            if (ret != null && !SIMPLE_TYPES.contains(ret.getClass())) {
                this.objectsInCallStack.remove(ret);
            }
            return ret;
        }

        boolean alreadyVisited(Object object) {
            return this.objectsInCallStack.contains(object);
        }

        int stackLevel() {
            return this.callStack.size();
        }

        public int size() {
            return this.objectsInCallStack.size();
        }

        public void setMaxDepth(int pMaxDepth) {
            this.maxDepth = pMaxDepth;
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public void setMaxCollectionSize(int pMaxCollectionSize) {
            this.maxCollectionSize = pMaxCollectionSize;
        }

        public int getMaxCollectionSize() {
            return this.maxCollectionSize;
        }

        public void incObjectCount() {
            ++this.objectCount;
        }

        public int getObjectCount() {
            return this.objectCount;
        }

        public int getMaxObjects() {
            return this.maxObjects;
        }

        public void setMaxObjects(int pMaxObjects) {
            this.maxObjects = pMaxObjects;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Handler {
        public Class getType();

        public Object extractObject(ObjectToJsonConverter var1, Object var2, Stack<String> var3, boolean var4) throws AttributeNotFoundException;

        public Object setObjectValue(StringToObjectConverter var1, Object var2, String var3, String var4) throws IllegalAccessException, InvocationTargetException;
    }
}

