/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.converter.json;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jmx4perl.converter.StringToObjectConverter;
import org.jmx4perl.converter.json.ObjectToJsonConverter;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanHandler
implements ObjectToJsonConverter.Handler {
    private static final Set<Class> FINAL_CLASSES = new HashSet<Class>(Arrays.asList(String.class, Number.class, Byte.class, Double.class, Float.class, Long.class, Short.class, Integer.class, Boolean.class, Date.class));
    private static final Set<String> IGNORE_METHODS = new HashSet<String>(Arrays.asList("getClass"));
    private static final String[] GETTER_PREFIX = new String[]{"get", "is"};

    @Override
    public Class getType() {
        return Object.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pExtraArgs, boolean jsonify) throws AttributeNotFoundException {
        if (!pExtraArgs.isEmpty()) {
            String attribute = pExtraArgs.pop();
            Object attributeValue = this.extractBeanAttribute(pValue, attribute);
            return pConverter.extractObject(attributeValue, pExtraArgs, jsonify);
        }
        if (!jsonify) {
            return pValue;
        }
        if (pValue.getClass().isPrimitive() || FINAL_CLASSES.contains(pValue.getClass())) {
            return pValue.toString();
        }
        List<String> attributes = this.extractBeanAttributes(pValue);
        if (attributes != null && attributes.size() > 0) {
            JSONObject ret = new JSONObject();
            for (String attribute : attributes) {
                Object value = this.extractBeanAttribute(pValue, attribute);
                if (value == null) {
                    ret.put(attribute, null);
                    continue;
                }
                if (value == pValue) {
                    ret.put(attribute, "[this]");
                    continue;
                }
                ret.put(attribute, pConverter.extractObject(value, pExtraArgs, jsonify));
            }
            return ret;
        }
        return pValue.toString();
    }

    private List<String> extractBeanAttributes(Object pValue) {
        ArrayList<String> attrs = new ArrayList<String>();
        for (Method method : pValue.getClass().getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || IGNORE_METHODS.contains(method.getName())) continue;
            String name = method.getName();
            for (String pref : GETTER_PREFIX) {
                if (!name.startsWith(pref) || name.length() <= pref.length() || method.getParameterTypes().length != 0) continue;
                int len = pref.length();
                String attribute = new StringBuffer(name.substring(len, len + 1).toLowerCase()).append(name.substring(len + 1)).toString();
                attrs.add(attribute);
            }
        }
        return attrs;
    }

    private Object extractBeanAttribute(Object pValue, String pAttribute) throws AttributeNotFoundException {
        Class<?> clazz = pValue.getClass();
        Method method = null;
        for (String pref : GETTER_PREFIX) {
            String methodName = new StringBuffer(pref).append(pAttribute.substring(0, 1).toUpperCase()).append(pAttribute.substring(1)).toString();
            try {
                method = clazz.getMethod(methodName, new Class[0]);
                break;
            }
            catch (NoSuchMethodException e) {
            }
        }
        if (method == null) {
            throw new AttributeNotFoundException("No getter known for attribute " + pAttribute + " for class " + pValue.getClass().getName());
        }
        try {
            method.setAccessible(true);
            return method.invoke(pValue, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Error while extracting " + pAttribute + " from " + pValue, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Error while extracting " + pAttribute + " from " + pValue, e);
        }
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, String pValue) throws IllegalAccessException, InvocationTargetException {
        Object oldValue;
        String rest = new StringBuffer(pAttribute.substring(0, 1).toUpperCase()).append(pAttribute.substring(1)).toString();
        String setter = new StringBuffer("set").append(rest).toString();
        String getter = new StringBuffer("get").append(rest).toString();
        Class<?> clazz = pInner.getClass();
        Method found = null;
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(setter)) continue;
            found = method;
            break;
        }
        if (found == null) {
            throw new IllegalArgumentException("No Method " + setter + " known for object of type " + clazz.getName());
        }
        Class<?>[] params = found.getParameterTypes();
        if (params.length != 1) {
            throw new IllegalArgumentException("Invalid parameter signature for " + setter + " known for object of type " + clazz.getName() + ". Setter must take exactly one parameter.");
        }
        try {
            Method getMethod = clazz.getMethod(getter, new Class[0]);
            oldValue = getMethod.invoke(pInner, new Object[0]);
        }
        catch (NoSuchMethodException exp) {
            oldValue = null;
        }
        found.invoke(pInner, pConverter.convertFromString(params[0].getName(), pValue));
        return oldValue;
    }
}

