# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as
# `perl -I/usr/local/bin t/File-Rename-script.t'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use Test::More;
plan skip_all => "No feature unicode_strings", 1 if $] < 5.012;
plan tests => 1;

push @INC, qw(blib/script) if -d 'blib';
unshift @INC, 't' if -d 't';
require 'testlib.pl';

my $script = script_name();
my $require_ok =  eval { require($script) };
die $@ unless $require_ok;

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

my $dir = tempdir();

create(qq(b\x{A0}g.txt));
my @files = listdir($dir);
die unless 1 == @files;
die unless 7 == length $files[0];

main_argv( '-u', 's/\s//', File::Spec->catfile($dir,$files[0]));
is_deeply( [ sort( listdir( $dir ) ) ], [qw(bg.txt)], 'rename - unicode' );
# diag map length, listdir($dir);

File::Path::rmtree($dir);
