
use strict;
use warnings;

use 5.010000;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Convert cpan distribution from BackPAN to a git repository",
  "AUTHOR" => "Graham Ollis <plicease\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "App-cpangitify",
  "EXE_FILES" => [
    "bin/cpangitify"
  ],
  "LICENSE" => "perl",
  "NAME" => "App::cpangitify",
  "PREREQ_PM" => {
    "BackPAN::Index" => 0,
    "File::Copy::Recursive" => 0,
    "File::chdir" => 0,
    "Git::Wrapper" => 0,
    "IPC::System::Simple" => 0,
    "JSON" => 0,
    "LWP::UserAgent" => 0,
    "Path::Class" => 0,
    "PerlX::Maybe" => 0,
    "URI" => 0,
    "autodie" => 0
  },
  "TEST_REQUIRES" => {
    "Capture::Tiny" => 0,
    "File::HomeDir" => 0,
    "Test::More" => 0,
    "URI::file" => 0
  },
  "VERSION" => "0.04",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  my $tr = delete $WriteMakefileArgs{TEST_REQUIRES};
  my $br = $WriteMakefileArgs{BUILD_REQUIRES};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



