use strict; use warnings;
BEGIN {
  unless(eval q{ use 5.006; 1}) {
    print "Perl 5.006 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.28.
use strict;
use warnings;
use 5.006;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Perl Foreign Function interface based on libffi",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "7.24",
    "FFI::Build"          => "0.10"
  },
  "DISTNAME"         => "Alt-FFI-libffi",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.006",
  "NAME"             => "Alt::FFI::libffi",
  "PM"               => {
    "lib/Alt/FFI/libffi.pm" => "\$(INST_LIB)/Alt/FFI/libffi.pm",
    "lib/FFI.pm"            => "\$(INST_LIB)/FFI.pm",
    "lib/FFI/Library.pm"    => "\$(INST_LIB)/FFI/Library.pm"
  },
  "PREREQ_PM" => {
    "FFI::Platypus" => "0.59"
  },
  "TEST_REQUIRES" => {
    "FFI::Build"    => "0.10",
    "FFI::CheckLib" => "0.06",
    "Test::More"    => "0.94"
  },
  "VERSION" => "0.05",
  "test"    => {
    "TESTS" => "t/*.t"
    }
);

my %FallbackPrereqs = (
  "FFI::Build"    => "0.10",
  "FFI::CheckLib" => "0.06",
  "FFI::Platypus" => "0.59",
  "Test::More"    => "0.94"
);

# BEGIN code inserted by Dist::Zilla::Plugin::FFI::Build
use FFI::Build::MM;
my $fbmm = FFI::Build::MM->new;
%WriteMakefileArgs = $fbmm->mm_args(%WriteMakefileArgs);

# END code inserted by Dist::Zilla::Plugin::FFI::Build

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

# begin inserted by Dist::Zilla::Plugin::Alt 0.05
my $alt = $ENV{PERL_ALT_INSTALL} || '';
$WriteMakefileArgs{DESTDIR} =
  $alt ? $alt eq 'OVERWRITE' ? '' : $alt : 'no-install-alt';

# end inserted by Dist::Zilla::Plugin::Alt 0.05
WriteMakefile(%WriteMakefileArgs);

# BEGIN code inserted by Dist::Zilla::Plugin::FFI::Build
BEGIN {
  # append to any existing postamble.
  if ( my $old = MY->can('postamble') )
  {
    no warnings 'redefine';
    *MY::postamble = sub {
      $old->(@_) .
        "\n" .
        $fbmm->mm_postamble;
    };
  }
  else
  {
    *MY::postamble = sub {
      $fbmm->mm_postamble;
    };
  }
}

# END code inserted by Dist::Zilla::Plugin::FFI::Build