use strict; use warnings;
BEGIN {
  unless($^O =~ /^(MSWin32|msys|cygwin)$/ || $ENV{ALIEN_MSYS2_NON_NATIVE})
  {
    print "operating system not supported";
    exit;
  }
  unless(eval q{ use 5.010; 1}) {
    print "Perl 5.010 or better required\n";
    exit;
  }
}
# This file was automatically generated by inc::My::MakeMaker v(dev).
use strict;
use warnings;

use 5.010;

use ExtUtils::MakeMaker;

use File::ShareDir::Install;
$File::ShareDir::Install::INCLUDE_DOTFILES = 1;
$File::ShareDir::Install::INCLUDE_DOTDIRS = 1;
install_share dist => "share";


my %WriteMakefileArgs = (
  "ABSTRACT" => "Tools required for autogen scripts in Windows (MSYS2)",
  "AUTHOR" => "Graham Ollis <plicease\@cpan.org>",
  "BUILD_REQUIRES" => {
    "Archive::Extract" => "0.48",
    "HTTP::Tiny" => 0,
    "IO::Uncompress::UnXz" => 0,
    "JSON::PP" => 0
  },
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::ShareDir::Install" => "0.06"
  },
  "DISTNAME" => "Alien-MSYS2",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.010",
  "NAME" => "Alien::MSYS2",
  "PM" => {
    "lib/Alien/MSYS2.pm" => "\$(INST_LIB)/Alien/MSYS2.pm"
  },
  "PREREQ_PM" => {
    "File::ShareDir" => 0,
    "JSON::PP" => 0
  },
  "TEST_REQUIRES" => {
    "Test2::Suite" => "0.000030",
    "Test::Alien" => 0,
    "Test::More" => "0.94"
  },
  "VERSION" => "0.01",
  "clean" => {
    "FILES" => "share/msys* msys2-*-latest.tar.xz share/alien_msys2.json"
  },
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Archive::Extract" => "0.48",
  "File::ShareDir" => 0,
  "HTTP::Tiny" => 0,
  "IO::Uncompress::UnXz" => 0,
  "JSON::PP" => 0,
  "Test2::Suite" => "0.000030",
  "Test::Alien" => 0,
  "Test::More" => "0.94"
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

{
package
MY;
use File::ShareDir::Install qw(postamble);
}

# yeah because this is so much better than MB
sub MY::postamble {
  "alien_download:\n" .
  "\t\$(FULLPERL) share/download.pl --blib\n\n" .
  "pure_all :: alien_download";
}