use Test2::V0 -no_srand => 1;

sub require_ok ($);

require_ok 'Alien::Base';
require_ok 'Alien::Base::PkgConfig';
require_ok 'Alien::Base::Wrapper';
require_ok 'Alien::Build';
require_ok 'Alien::Build::CommandSequence';
require_ok 'Alien::Build::Interpolate';
require_ok 'Alien::Build::Interpolate::Default';
require_ok 'Alien::Build::MM';
require_ok 'Alien::Build::Plugin';
require_ok 'Alien::Build::Plugin::Build::Autoconf';
require_ok 'Alien::Build::Plugin::Build::CMake';
require_ok 'Alien::Build::Plugin::Build::MSYS';
require_ok 'Alien::Build::Plugin::Build::Make';
require_ok 'Alien::Build::Plugin::Build::SearchDep';
require_ok 'Alien::Build::Plugin::Core::Download';
require_ok 'Alien::Build::Plugin::Core::FFI';
require_ok 'Alien::Build::Plugin::Core::Gather';
require_ok 'Alien::Build::Plugin::Core::Legacy';
require_ok 'Alien::Build::Plugin::Core::Override';
require_ok 'Alien::Build::Plugin::Core::Setup';
require_ok 'Alien::Build::Plugin::Core::Tail';
require_ok 'Alien::Build::Plugin::Decode::DirListing';
require_ok 'Alien::Build::Plugin::Decode::DirListingFtpcopy';
require_ok 'Alien::Build::Plugin::Decode::HTML';
require_ok 'Alien::Build::Plugin::Download::Negotiate';
require_ok 'Alien::Build::Plugin::Extract::ArchiveTar';
require_ok 'Alien::Build::Plugin::Extract::ArchiveZip';
require_ok 'Alien::Build::Plugin::Extract::CommandLine';
require_ok 'Alien::Build::Plugin::Extract::Directory';
require_ok 'Alien::Build::Plugin::Extract::Negotiate';
require_ok 'Alien::Build::Plugin::Fetch::CurlCommand';
require_ok 'Alien::Build::Plugin::Fetch::HTTPTiny';
require_ok 'Alien::Build::Plugin::Fetch::LWP';
require_ok 'Alien::Build::Plugin::Fetch::Local';
require_ok 'Alien::Build::Plugin::Fetch::LocalDir';
require_ok 'Alien::Build::Plugin::Fetch::NetFTP';
require_ok 'Alien::Build::Plugin::Fetch::Wget';
require_ok 'Alien::Build::Plugin::Gather::IsolateDynamic';
require_ok 'Alien::Build::Plugin::PkgConfig::CommandLine';
require_ok 'Alien::Build::Plugin::PkgConfig::LibPkgConf';
require_ok 'Alien::Build::Plugin::PkgConfig::MakeStatic';
require_ok 'Alien::Build::Plugin::PkgConfig::Negotiate';
require_ok 'Alien::Build::Plugin::PkgConfig::PP';
require_ok 'Alien::Build::Plugin::Prefer::BadVersion';
require_ok 'Alien::Build::Plugin::Prefer::SortVersions';
require_ok 'Alien::Build::Plugin::Probe::CBuilder';
require_ok 'Alien::Build::Plugin::Probe::CommandLine';
require_ok 'Alien::Build::Util';
require_ok 'Alien::Build::Version::Basic';
require_ok 'Alien::Role';
require_ok 'Test::Alien';
require_ok 'Test::Alien::Build';
require_ok 'Test::Alien::CanCompile';
require_ok 'Test::Alien::CanPlatypus';
require_ok 'Test::Alien::Run';
require_ok 'Test::Alien::Synthetic';
require_ok 'alienfile';
ok -f 't/alien_base.t',                                  'test for Alien::Base';
ok -f 't/alien_base_pkgconfig.t',                        'test for Alien::Base::PkgConfig';
ok -f 't/alien_base_wrapper.t',                          'test for Alien::Base::Wrapper';
ok -f 't/alien_build.t',                                 'test for Alien::Build';
ok -f 't/alien_build_commandsequence.t',                 'test for Alien::Build::CommandSequence';
ok -f 't/alien_build_interpolate.t',                     'test for Alien::Build::Interpolate';
ok -f 't/alien_build_interpolate_default.t',             'test for Alien::Build::Interpolate::Default';
ok -f 't/alien_build_mm.t',                              'test for Alien::Build::MM';
ok -f 't/alien_build_plugin.t',                          'test for Alien::Build::Plugin';
ok -f 't/alien_build_plugin_build_autoconf.t',           'test for Alien::Build::Plugin::Build::Autoconf';
ok -f 't/alien_build_plugin_build_cmake.t',              'test for Alien::Build::Plugin::Build::CMake';
ok -f 't/alien_build_plugin_build_msys.t',               'test for Alien::Build::Plugin::Build::MSYS';
ok -f 't/alien_build_plugin_build_make.t',               'test for Alien::Build::Plugin::Build::Make';
ok -f 't/alien_build_plugin_build_searchdep.t',          'test for Alien::Build::Plugin::Build::SearchDep';
ok -f 't/alien_build_plugin_core_download.t',            'test for Alien::Build::Plugin::Core::Download';
ok -f 't/alien_build_plugin_core_ffi.t',                 'test for Alien::Build::Plugin::Core::FFI';
ok -f 't/alien_build_plugin_core_gather.t',              'test for Alien::Build::Plugin::Core::Gather';
ok -f 't/alien_build_plugin_core_legacy.t',              'test for Alien::Build::Plugin::Core::Legacy';
ok -f 't/alien_build_plugin_core_override.t',            'test for Alien::Build::Plugin::Core::Override';
ok -f 't/alien_build_plugin_core_setup.t',               'test for Alien::Build::Plugin::Core::Setup';
ok -f 't/alien_build_plugin_core_tail.t',                'test for Alien::Build::Plugin::Core::Tail';
ok -f 't/alien_build_plugin_decode_dirlisting.t',        'test for Alien::Build::Plugin::Decode::DirListing';
ok -f 't/alien_build_plugin_decode_dirlistingftpcopy.t', 'test for Alien::Build::Plugin::Decode::DirListingFtpcopy';
ok -f 't/alien_build_plugin_decode_html.t',              'test for Alien::Build::Plugin::Decode::HTML';
ok -f 't/alien_build_plugin_download_negotiate.t',       'test for Alien::Build::Plugin::Download::Negotiate';
ok -f 't/alien_build_plugin_extract_archivetar.t',       'test for Alien::Build::Plugin::Extract::ArchiveTar';
ok -f 't/alien_build_plugin_extract_archivezip.t',       'test for Alien::Build::Plugin::Extract::ArchiveZip';
ok -f 't/alien_build_plugin_extract_commandline.t',      'test for Alien::Build::Plugin::Extract::CommandLine';
ok -f 't/alien_build_plugin_extract_directory.t',        'test for Alien::Build::Plugin::Extract::Directory';
ok -f 't/alien_build_plugin_extract_negotiate.t',        'test for Alien::Build::Plugin::Extract::Negotiate';
ok -f 't/alien_build_plugin_fetch_curlcommand.t',        'test for Alien::Build::Plugin::Fetch::CurlCommand';
ok -f 't/alien_build_plugin_fetch_httptiny.t',           'test for Alien::Build::Plugin::Fetch::HTTPTiny';
ok -f 't/alien_build_plugin_fetch_lwp.t',                'test for Alien::Build::Plugin::Fetch::LWP';
ok -f 't/alien_build_plugin_fetch_local.t',              'test for Alien::Build::Plugin::Fetch::Local';
ok -f 't/alien_build_plugin_fetch_localdir.t',           'test for Alien::Build::Plugin::Fetch::LocalDir';
ok -f 't/alien_build_plugin_fetch_netftp.t',             'test for Alien::Build::Plugin::Fetch::NetFTP';
ok -f 't/alien_build_plugin_fetch_wget.t',               'test for Alien::Build::Plugin::Fetch::Wget';
ok -f 't/alien_build_plugin_gather_isolatedynamic.t',    'test for Alien::Build::Plugin::Gather::IsolateDynamic';
ok -f 't/alien_build_plugin_pkgconfig_commandline.t',    'test for Alien::Build::Plugin::PkgConfig::CommandLine';
ok -f 't/alien_build_plugin_pkgconfig_libpkgconf.t',     'test for Alien::Build::Plugin::PkgConfig::LibPkgConf';
ok -f 't/alien_build_plugin_pkgconfig_makestatic.t',     'test for Alien::Build::Plugin::PkgConfig::MakeStatic';
ok -f 't/alien_build_plugin_pkgconfig_negotiate.t',      'test for Alien::Build::Plugin::PkgConfig::Negotiate';
ok -f 't/alien_build_plugin_pkgconfig_pp.t',             'test for Alien::Build::Plugin::PkgConfig::PP';
ok -f 't/alien_build_plugin_prefer_badversion.t',        'test for Alien::Build::Plugin::Prefer::BadVersion';
ok -f 't/alien_build_plugin_prefer_sortversions.t',      'test for Alien::Build::Plugin::Prefer::SortVersions';
ok -f 't/alien_build_plugin_probe_cbuilder.t',           'test for Alien::Build::Plugin::Probe::CBuilder';
ok -f 't/alien_build_plugin_probe_commandline.t',        'test for Alien::Build::Plugin::Probe::CommandLine';
ok -f 't/alien_build_util.t',                            'test for Alien::Build::Util';
ok -f 't/alien_build_version_basic.t',                   'test for Alien::Build::Version::Basic';
ok -f 't/alien_role.t',                                  'test for Alien::Role';
ok -f 't/test_alien.t',                                  'test for Test::Alien';
ok -f 't/test_alien_build.t',                            'test for Test::Alien::Build';
ok -f 't/test_alien_cancompile.t',                       'test for Test::Alien::CanCompile';
ok -f 't/test_alien_canplatypus.t',                      'test for Test::Alien::CanPlatypus';
ok -f 't/test_alien_run.t',                              'test for Test::Alien::Run';
ok -f 't/test_alien_synthetic.t',                        'test for Test::Alien::Synthetic';
ok -f 't/alienfile.t',                                   'test for alienfile';
done_testing;

sub require_ok ($) {

  # special case of when I really do want require_ok.
  # I just want a test that checks that the modules
  # will compile okay.  I won't be trying to use them.
  my ($mod) = @_;
  my $ctx = context();
  eval qq{ require $mod };
  my $error = $@;
  my $ok    = !$error;
  $ctx->ok( $ok, "require $mod" );
  $ctx->diag("error: $error") if $error ne '';
  $ctx->release;
}
