import javax.swing.event.PopupMenuListener;
import org.perl.inline.java.*;

public class      PerlPopupMenuListener
       extends    InlineJavaPerlCaller
       implements PopupMenuListener
{
    String sender;
    String callbacks;

    public PerlPopupMenuListener(String sender, String callbacks)
        throws InlineJavaException
    {
        this.sender    = sender;
        this.callbacks = callbacks;
    }

    public void popupMenuWillBecomeVisible(javax.swing.event.PopupMenuEvent event)  {
        try {
            CallPerl(
                "Java::Swing::PopupMenuListener",
                "_PopupMenuListener",
                new Object[] {sender, callbacks, "popupMenuWillBecomeVisible", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
    public void popupMenuWillBecomeInvisible(javax.swing.event.PopupMenuEvent event)  {
        try {
            CallPerl(
                "Java::Swing::PopupMenuListener",
                "_PopupMenuListener",
                new Object[] {sender, callbacks, "popupMenuWillBecomeInvisible", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
    public void popupMenuCanceled(javax.swing.event.PopupMenuEvent event)  {
        try {
            CallPerl(
                "Java::Swing::PopupMenuListener",
                "_PopupMenuListener",
                new Object[] {sender, callbacks, "popupMenuCanceled", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
}
