#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

use Net::Prometheus;

my $client = Net::Prometheus->new;

{
   my $counter = $client->new_counter(
      name => "test_total",
      help => "A testing counter",
   );

   ok( defined $counter, 'defined $counter' );

   is( $client->render, <<'EOF', '$client->render contains counter' );
# HELP test_total A testing counter
# TYPE test_total counter
EOF

   $counter->inc;

   is( $client->render, <<'EOF', 'render after $counter->inc' );
# HELP test_total A testing counter
# TYPE test_total counter
test_total 1
EOF
}

done_testing;
