package Bencher::Scenario::ArraySet::diff;

our $DATE = '2016-09-16'; # DATE
our $VERSION = '0.002'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark diff operation',
    participants => [
        {
            fcall_template => 'Array::Set::set_diff(<set1>, <set2>)',
        },
        {
            module => 'Set::Object',
            function => 'difference',
            code_template => 'my $set1 = Set::Object->new; $set1->insert(@{<set1>}); my $set2 = Set::Object->new; $set2->insert(@{<set2>}); my $res = $set1->difference($set2);', # $res->as_string
        },
        {
            module => 'Set::Scalar',
            function => 'difference',
            code_template => 'my $set1 = Set::Scalar->new; $set1->insert(@{<set1>}); my $set2 = Set::Scalar->new; $set2->insert(@{<set2>}); my $res = $set1->difference($set2);', # $res->as_string
        },
    ],
    datasets => [
        { name => '1_1'  , args => { set1=>[1], set2=>[1] } },

        { name => '10_1' , args => { set1=>[1..10], set2=>[1] } },
        { name => '10_5' , args => { set1=>[1..10], set2=>[1..5] } },
        { name => '10_10', args => { set1=>[1..10], set2=>[1..10] } },

        { name => '100_1'  , args => { set1=>[1..100], set2=>[1] } },
        { name => '100_10' , args => { set1=>[1..100], set2=>[1..10] } },
        { name => '100_100', args => { set1=>[1..100], set2=>[1..100] } },

        { name => '1000_1'   , args => { set1=>[1..1000], set2=>[1] } },
        { name => '1000_10'  , args => { set1=>[1..1000], set2=>[1..10] } },
        { name => '1000_100' , args => { set1=>[1..1000], set2=>[1..100] } },
        { name => '1000_1000', args => { set1=>[1..1000], set2=>[1..1000] } },
    ],
};

1;
# ABSTRACT: Benchmark diff operation

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ArraySet::diff - Benchmark diff operation

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::ArraySet::diff (from Perl distribution Bencher-Scenarios-ArraySet), released on 2016-09-16.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m ArraySet::diff

To run module startup overhead benchmark:

 % bencher --module-startup -m ArraySet::diff

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Array::Set> 0.05

L<Set::Object> 1.35

L<Set::Scalar> 1.29

=head1 BENCHMARK PARTICIPANTS

=over

=item * Array::Set::set_diff (perl_code)

Function call template:

 Array::Set::set_diff(<set1>, <set2>)



=item * Set::Object::difference (perl_code)

Code template:

 my $set1 = Set::Object->new; $set1->insert(@{<set1>}); my $set2 = Set::Object->new; $set2->insert(@{<set2>}); my $res = $set1->difference($set2);



=item * Set::Scalar::difference (perl_code)

Code template:

 my $set1 = Set::Scalar->new; $set1->insert(@{<set1>}); my $set2 = Set::Scalar->new; $set2->insert(@{<set2>}); my $res = $set1->difference($set2);



=back

=head1 BENCHMARK DATASETS

=over

=item * 1_1

=item * 10_1

=item * 10_5

=item * 10_10

=item * 100_1

=item * 100_10

=item * 100_100

=item * 1000_1

=item * 1000_10

=item * 1000_100

=item * 1000_1000

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with C<< bencher -m ArraySet::diff --include-path archive/Array-Set-0.02/lib --include-path archive/Array-Set-0.05/lib --multimodver Array::Set >>:

 #table1#
 {dataset=>"1000_1"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_diff    | 0.02   |       344 |     2.91  |       1    | 2.1e-06 |      22 |
 | Set::Scalar::difference |        |       410 |     2.4   |       1.2  | 8.9e-06 |      20 |
 | Set::Object::difference |        |      1450 |     0.689 |       4.22 | 6.4e-07 |      20 |
 | Array::Set::set_diff    | 0.05   |      3160 |     0.317 |       9.19 | 2.1e-07 |      20 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table2#
 {dataset=>"1000_10"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_diff    | 0.02   |       240 |     4.2   |       1    | 4.3e-06 |      20 |
 | Set::Scalar::difference |        |       390 |     2.6   |       1.6  |   1e-05 |      22 |
 | Set::Object::difference |        |      1420 |     0.705 |       6.02 | 4.3e-07 |      20 |
 | Array::Set::set_diff    | 0.05   |      3140 |     0.319 |      13.3  | 2.1e-07 |      20 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table3#
 {dataset=>"1000_100"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_diff    | 0.02   |        57 |     18    |          1 | 7.4e-05 |      22 |
 | Set::Scalar::difference |        |       300 |      3    |          6 |   3e-05 |      20 |
 | Set::Object::difference |        |      1400 |      0.73 |         24 | 8.5e-07 |      20 |
 | Array::Set::set_diff    | 0.05   |      2600 |      0.38 |         46 | 4.8e-07 |      20 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table4#
 {dataset=>"1000_1000"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_diff    | 0.02   |        14 |    73     |        1   | 8.9e-05 |      20 |
 | Set::Scalar::difference |        |       232 |     4.31  |       17   | 1.6e-06 |      20 |
 | Set::Object::difference |        |      1210 |     0.823 |       88.9 | 2.5e-07 |      22 |
 | Array::Set::set_diff    | 0.05   |      1950 |     0.512 |      143   | 2.4e-07 |      24 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table5#
 {dataset=>"100_1"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_diff    | 0.02   |      3300 |       300 |        1   | 4.2e-07 |      21 |
 | Set::Scalar::difference |        |      3310 |       303 |        1   | 2.1e-07 |      21 |
 | Set::Object::difference |        |     14000 |        72 |        4.2 | 1.3e-07 |      21 |
 | Array::Set::set_diff    | 0.05   |     33000 |        31 |        9.9 | 4.4e-08 |      29 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table6#
 {dataset=>"100_10"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_diff    | 0.02   |      2440 |     410   |       1    |   2e-07 |      22 |
 | Set::Scalar::difference |        |      3010 |     332   |       1.24 | 1.9e-07 |      26 |
 | Set::Object::difference |        |     13000 |      74   |       5.5  | 1.2e-07 |      25 |
 | Array::Set::set_diff    | 0.05   |     31200 |      32.1 |      12.8  | 1.2e-08 |      26 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table7#
 {dataset=>"100_100"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_diff    | 0.02   |    1070   |  937      |      1     | 2.7e-07 |      20 |
 | Set::Scalar::difference |        |    1730   |  578      |      1.62  | 4.3e-07 |      20 |
 | Set::Object::difference |        |   12000   |   82      |     11     |   1e-07 |      22 |
 | Array::Set::set_diff    | 0.05   |   22053.2 |   45.3449 |     20.668 |   0     |      26 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table8#
 {dataset=>"10_1"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::difference |        |     12000 |     85    |       1    | 1.1e-07 |      20 |
 | Array::Set::set_diff    | 0.02   |     28000 |     35    |       2.4  | 5.4e-08 |      31 |
 | Set::Object::difference |        |    100000 |      9.96 |       8.49 | 3.3e-09 |      21 |
 | Array::Set::set_diff    | 0.05   |    210000 |      4.8  |      18    | 6.7e-09 |      20 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table9#
 {dataset=>"10_10"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::difference |        |      9000 |   111     |      1     | 5.3e-08 |      20 |
 | Array::Set::set_diff    | 0.02   |     22000 |    45     |      2.5   | 5.2e-08 |      21 |
 | Set::Object::difference |        |     94374 |    10.596 |     10.485 | 3.8e-11 |      20 |
 | Array::Set::set_diff    | 0.05   |    171000 |     5.85  |     19     | 5.7e-09 |      27 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table10#
 {dataset=>"10_5"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::difference |        |   10417.2 |   95.9952 |       1    | 3.7e-11 |      22 |
 | Array::Set::set_diff    | 0.02   |   24000   |   42      |       2.3  | 4.2e-08 |      32 |
 | Set::Object::difference |        |   97300   |   10.3    |       9.34 | 3.3e-09 |      20 |
 | Array::Set::set_diff    | 0.05   |  180000   |    5.4    |      18    | 6.5e-09 |      21 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table11#
 {dataset=>"1_1"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::difference |        |     16200 |     61.7  |        1   | 2.7e-08 |      20 |
 | Array::Set::set_diff    | 0.02   |    130000 |      7.8  |        7.9 | 1.2e-08 |      23 |
 | Set::Object::difference |        |    250000 |      3.9  |       16   | 6.7e-09 |      20 |
 | Array::Set::set_diff    | 0.05   |    502000 |      1.99 |       31   | 6.9e-10 |      29 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m ArraySet::diff --module-startup >>):

 #table12#
 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Set::Object         |      16   |                   11.5 |        1   | 5.8e-05 |      20 |
 | Set::Scalar         |      15   |                   10.5 |        1.1 | 2.7e-05 |      20 |
 | Array::Set          |       8.1 |                    3.6 |        2   | 4.7e-05 |      21 |
 | perl -e1 (baseline) |       4.5 |                    0   |        3.7 | 5.8e-06 |      20 |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-ArraySet>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-ArraySet>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-ArraySet>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
