#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "INLINE.h"
# include <stdlib.h>
# include <stdio.h>
# include <omp.h>

/* added for integration for use with OpenMP::Environment */
int _ENV_set_num_threads() {
  char *num;
  num = getenv("OMP_NUM_THREADS");
  omp_set_num_threads(atoi(num));
  return atoi(num);
}

SV *sum(SV *array) {
    int numelts, i;
    /* update OMP_NUM_THREADS from %ENV */
    int numthreads = _ENV_set_num_threads();
    if ((!SvROK(array))
        || (SvTYPE(SvRV(array)) != SVt_PVAV)
        || ((numelts = av_len((AV *)SvRV(array))) < 0)
    ) {
        return &PL_sv_undef;
    }
    int total = 0;
    #pragma omp parallel sections reduction(+:total)
    for (i = 0; i <= numelts; i++) {
        total += SvIV(*av_fetch((AV *)SvRV(array), i, 0));
    }
    return newSViv(total);
}

MODULE = _09_array_sum_pl_3af6  PACKAGE = main  

PROTOTYPES: DISABLE


int
_ENV_set_num_threads ()

SV *
sum (array)
	SV *	array

