#-*- perl -*-

package Unicode::LineBreak;

sub ea_A {
    return <<'END';
00A1		
00A4		
00A7	00A8	
00AA		
00AE		
00B0	00B4	
00B6	00BA	
00BC	00BF	
00C6		
00D0		
00D7	00D8	
00DE	00E1	
00E6		
00E8	00EA	
00EC	00ED	
00F0		
00F2	00F3	
00F7	00FA	
00FC		
00FE		
0101		
0111		
0113		
011B		
0126	0127	
012B		
0131	0133	
0138		
013F	0142	
0144		
0148	014B	
014D		
0152	0153	
0166	0167	
016B		
01CE		
01D0		
01D2		
01D4		
01D6		
01D8		
01DA		
01DC		
0251		
0261		
02C4		
02C7		
02C9	02CB	
02CD		
02D0		
02D8	02DB	
02DD		
02DF		
0391	03A1	
03A3	03A9	
03B1	03C1	
03C3	03C9	
0401		
0410	044F	
0451		
2010		
2013	2016	
2018	2019	
201C	201D	
2020	2022	
2024	2027	
2030		
2032	2033	
2035		
203B		
203E		
2074		
207F		
2081	2084	
20AC		
2103		
2105		
2109		
2113		
2116		
2121	2122	
2126		
212B		
2153	2154	
215B	215E	
2160	216B	
2170	2179	
2190	2199	
21B8	21B9	
21D2		
21D4		
21E7		
2200		
2202	2203	
2207	2208	
220B		
220F		
2211		
2215		
221A		
221D	2220	
2223		
2225		
2227	222C	
222E		
2234	2237	
223C	223D	
2248		
224C		
2252		
2260	2261	
2264	2267	
226A	226B	
226E	226F	
2282	2283	
2286	2287	
2295		
2299		
22A5		
22BF		
2312		
2460	24E9	
24EB	254B	
2550	2573	
2580	258F	
2592	2595	
25A0	25A1	
25A3	25A9	
25B2	25B3	
25B6	25B7	
25BC	25BD	
25C0	25C1	
25C6	25C8	
25CB		
25CE	25D1	
25E2	25E5	
25EF		
2605	2606	
2609		
260E	260F	
2614	2615	
261C		
261E		
2640		
2642		
2660	2661	
2663	2665	
2667	266A	
266C	266D	
266F		
273D		
2776	277F	
E000	F8FF	
FFFD		
F0000	FFFFD	
100000	10FFFD	
END
}

sub ea_F {
    return <<'END';
3000		
FF01	FF60	
FFE0	FFE6	
END
}

sub ea_H {
    return <<'END';
20A9		
FF61	FFBE	
FFC2	FFC7	
FFCA	FFCF	
FFD2	FFD7	
FFDA	FFDC	
FFE8	FFEE	
END
}

sub ea_N {
    return <<'END';
00A0		
00A9		
00AB		
00B5		
00BB		
00C0	00C5	
00C7	00CF	
00D1	00D6	
00D9	00DD	
00E2	00E5	
00E7		
00EB		
00EE	00EF	
00F1		
00F4	00F6	
00FB		
00FD		
00FF	0100	
0102	0110	
0112		
0114	011A	
011C	0125	
0128	012A	
012C	0130	
0134	0137	
0139	013E	
0143		
0145	0147	
014C		
014E	0151	
0154	0165	
0168	016A	
016C	01CD	
01CF		
01D1		
01D3		
01D5		
01D7		
01D9		
01DB		
01DD	0250	
0252	0260	
0262	02C3	
02C5	02C6	
02C8		
02CC		
02CE	02CF	
02D1	02D7	
02DC		
02DE		
02E0	02FF	
0370	0377	
037A	037E	
0384	038A	
038C		
038E	0390	
03AA	03B0	
03C2		
03CA	0400	
0402	040F	
0450		
0452	0482	
048A	0523	
0531	0556	
0559	055F	
0561	0587	
0589	058A	
05BE		
05C0		
05C3		
05C6		
05D0	05EA	
05F0	05F4	
0606	060F	
061B		
061E	061F	
0621	064A	
0660	066F	
0671	06D5	
06E5	06E6	
06E9		
06EE	070D	
0710		
0712	072F	
074D	07A5	
07B1		
07C0	07EA	
07F4	07FA	
0904	0939	
093D		
0950		
0958	0961	
0964	0972	
097B	097F	
0985	098C	
098F	0990	
0993	09A8	
09AA	09B0	
09B2		
09B6	09B9	
09BD		
09CE		
09DC	09DD	
09DF	09E1	
09E6	09FA	
0A05	0A0A	
0A0F	0A10	
0A13	0A28	
0A2A	0A30	
0A32	0A33	
0A35	0A36	
0A38	0A39	
0A59	0A5C	
0A5E		
0A66	0A6F	
0A72	0A74	
0A85	0A8D	
0A8F	0A91	
0A93	0AA8	
0AAA	0AB0	
0AB2	0AB3	
0AB5	0AB9	
0ABD		
0AD0		
0AE0	0AE1	
0AE6	0AEF	
0AF1		
0B05	0B0C	
0B0F	0B10	
0B13	0B28	
0B2A	0B30	
0B32	0B33	
0B35	0B39	
0B3D		
0B5C	0B5D	
0B5F	0B61	
0B66	0B71	
0B83		
0B85	0B8A	
0B8E	0B90	
0B92	0B95	
0B99	0B9A	
0B9C		
0B9E	0B9F	
0BA3	0BA4	
0BA8	0BAA	
0BAE	0BB9	
0BD0		
0BE6	0BFA	
0C05	0C0C	
0C0E	0C10	
0C12	0C28	
0C2A	0C33	
0C35	0C39	
0C3D		
0C58	0C59	
0C60	0C61	
0C66	0C6F	
0C78	0C7F	
0C85	0C8C	
0C8E	0C90	
0C92	0CA8	
0CAA	0CB3	
0CB5	0CB9	
0CBD		
0CDE		
0CE0	0CE1	
0CE6	0CEF	
0CF1	0CF2	
0D05	0D0C	
0D0E	0D10	
0D12	0D28	
0D2A	0D39	
0D3D		
0D60	0D61	
0D66	0D75	
0D79	0D7F	
0D85	0D96	
0D9A	0DB1	
0DB3	0DBB	
0DBD		
0DC0	0DC6	
0DF4		
0E01	0E30	
0E32	0E33	
0E3F	0E46	
0E4F	0E5B	
0E81	0E82	
0E84		
0E87	0E88	
0E8A		
0E8D		
0E94	0E97	
0E99	0E9F	
0EA1	0EA3	
0EA5		
0EA7		
0EAA	0EAB	
0EAD	0EB0	
0EB2	0EB3	
0EBD		
0EC0	0EC4	
0EC6		
0ED0	0ED9	
0EDC	0EDD	
0F00	0F17	
0F1A	0F34	
0F36		
0F38		
0F3A	0F3D	
0F40	0F47	
0F49	0F6C	
0F85		
0F88	0F8B	
0FBE	0FC5	
0FC7	0FCC	
0FCE	0FD4	
1000	102A	
103F	1055	
105A	105D	
1061		
1065	1066	
106E	1070	
1075	1081	
108E		
1090	1099	
109E	10C5	
10D0	10FC	
1160	11A2	
11A8	11F9	
1200	1248	
124A	124D	
1250	1256	
1258		
125A	125D	
1260	1288	
128A	128D	
1290	12B0	
12B2	12B5	
12B8	12BE	
12C0		
12C2	12C5	
12C8	12D6	
12D8	1310	
1312	1315	
1318	135A	
1360	137C	
1380	1399	
13A0	13F4	
1401	1676	
1680	169C	
16A0	16F0	
1700	170C	
170E	1711	
1720	1731	
1735	1736	
1740	1751	
1760	176C	
176E	1770	
1780	17B3	
17D4	17DC	
17E0	17E9	
17F0	17F9	
1800	180A	
180E		
1810	1819	
1820	1877	
1880	18A8	
18AA		
1900	191C	
1940		
1944	196D	
1970	1974	
1980	19A9	
19C1	19C7	
19D0	19D9	
19DE	1A16	
1A1E	1A1F	
1B05	1B33	
1B45	1B4B	
1B50	1B6A	
1B74	1B7C	
1B83	1BA0	
1BAE	1BB9	
1C00	1C23	
1C3B	1C49	
1C4D	1C7F	
1D00	1DBF	
1E00	1F15	
1F18	1F1D	
1F20	1F45	
1F48	1F4D	
1F50	1F57	
1F59		
1F5B		
1F5D		
1F5F	1F7D	
1F80	1FB4	
1FB6	1FC4	
1FC6	1FD3	
1FD6	1FDB	
1FDD	1FEF	
1FF2	1FF4	
1FF6	1FFE	
2000	200A	
2011	2012	
2017		
201A	201B	
201E	201F	
2023		
202F		
2031		
2034		
2036	203A	
203C	203D	
203F	205F	
2070	2071	
2075	207E	
2080		
2085	208E	
2090	2094	
20A0	20A8	
20AA	20AB	
20AD	20B5	
2100	2102	
2104		
2106	2108	
210A	2112	
2114	2115	
2117	2120	
2123	2125	
2127	212A	
212C	214F	
2155	215A	
215F		
216C	216F	
217A	2188	
219A	21B7	
21BA	21D1	
21D3		
21D5	21E6	
21E8	21FF	
2201		
2204	2206	
2209	220A	
220C	220E	
2210		
2212	2214	
2216	2219	
221B	221C	
2221	2222	
2224		
2226		
222D		
222F	2233	
2238	223B	
223E	2247	
2249	224B	
224D	2251	
2253	225F	
2262	2263	
2268	2269	
226C	226D	
2270	2281	
2284	2285	
2288	2294	
2296	2298	
229A	22A4	
22A6	22BE	
22C0	2311	
2313	2328	
232B	23E7	
2400	2426	
2440	244A	
24EA		
254C	254F	
2574	257F	
2590	2591	
2596	259F	
25A2		
25AA	25B1	
25B4	25B5	
25B8	25BB	
25BE	25BF	
25C2	25C5	
25C9	25CA	
25CC	25CD	
25D2	25E1	
25E6	25EE	
25F0	2604	
2607	2608	
260A	260D	
2610	2613	
2616	261B	
261D		
261F	263F	
2641		
2643	265F	
2662		
2666		
266B		
266E		
2670	269D	
26A0	26BC	
26C0	26C3	
2701	2704	
2706	2709	
270C	2727	
2729	273C	
273E	274B	
274D		
274F	2752	
2756		
2758	275E	
2761	2775	
2780	2794	
2798	27AF	
27B1	27BE	
27C0	27CA	
27CC		
27D0	27E5	
27EE	2984	
2987	2B4C	
2B50	2B54	
2C00	2C2E	
2C30	2C5E	
2C60	2C6F	
2C71	2C7D	
2C80	2CEA	
2CF9	2D25	
2D30	2D65	
2D6F		
2D80	2D96	
2DA0	2DA6	
2DA8	2DAE	
2DB0	2DB6	
2DB8	2DBE	
2DC0	2DC6	
2DC8	2DCE	
2DD0	2DD6	
2DD8	2DDE	
2E00	2E30	
303F		
4DC0	4DFF	
A500	A62B	
A640	A65F	
A662	A66E	
A673		
A67E	A697	
A700	A78C	
A7FB	A801	
A803	A805	
A807	A80A	
A80C	A822	
A828	A82B	
A840	A877	
A882	A8B3	
A8CE	A8D9	
A900	A925	
A92E	A946	
A95F		
AA00	AA28	
AA40	AA42	
AA44	AA4B	
AA50	AA59	
AA5C	AA5F	
D800	DFFF	
FB00	FB06	
FB13	FB17	
FB1D		
FB1F	FB36	
FB38	FB3C	
FB3E		
FB40	FB41	
FB43	FB44	
FB46	FBB1	
FBD3	FD3F	
FD50	FD8F	
FD92	FDC7	
FDF0	FDFD	
FE70	FE74	
FE76	FEFC	
FFFC		
10000	1000B	
1000D	10026	
10028	1003A	
1003C	1003D	
1003F	1004D	
10050	1005D	
10080	100FA	
10100	10102	
10107	10133	
10137	1018A	
10190	1019B	
101D0	101FC	
10280	1029C	
102A0	102D0	
10300	1031E	
10320	10323	
10330	1034A	
10380	1039D	
1039F	103C3	
103C8	103D5	
10400	1049D	
104A0	104A9	
10800	10805	
10808		
1080A	10835	
10837	10838	
1083C		
1083F		
10900	10919	
1091F	10939	
1093F		
10A00		
10A10	10A13	
10A15	10A17	
10A19	10A33	
10A40	10A47	
10A50	10A58	
12000	1236E	
12400	12462	
12470	12473	
1D000	1D0F5	
1D100	1D126	
1D129	1D164	
1D16A	1D16C	
1D183	1D184	
1D18C	1D1A9	
1D1AE	1D1DD	
1D200	1D241	
1D245		
1D300	1D356	
1D360	1D371	
1D400	1D454	
1D456	1D49C	
1D49E	1D49F	
1D4A2		
1D4A5	1D4A6	
1D4A9	1D4AC	
1D4AE	1D4B9	
1D4BB		
1D4BD	1D4C3	
1D4C5	1D505	
1D507	1D50A	
1D50D	1D514	
1D516	1D51C	
1D51E	1D539	
1D53B	1D53E	
1D540	1D544	
1D546		
1D54A	1D550	
1D552	1D6A5	
1D6A8	1D7CB	
1D7CE	1D7FF	
1F000	1F02B	
1F030	1F093	
END
}

sub ea_Na {
    return <<'END';
0020	007E	
00A2	00A3	
00A5	00A6	
00AC		
00AF		
27E6	27ED	
2985	2986	
END
}

sub ea_W {
    return <<'END';
1100	1159	
115F		
2329	232A	
2E80	2E99	
2E9B	2EF3	
2F00	2FD5	
2FF0	2FFB	
3001	3029	
3030	303E	
3041	3096	
309B	30FF	
3105	312D	
3131	318E	
3190	31B7	
31C0	31E3	
31F0	321E	
3220	3243	
3250	32FE	
3300	4DB5	
4E00	9FC3	
A000	A48C	
A490	A4C6	
AC00	D7A3	
F900	FA2D	
FA30	FA6A	
FA70	FAD9	
FE10	FE19	
FE30	FE52	
FE54	FE66	
FE68	FE6B	
20000	2FFFD	
30000	3FFFD	
END
}

sub ea_z {
    return <<'END';
0000	001F	
007F	009F	
00AD		
0300	036F	
0483	0489	
0591	05BD	
05BF		
05C1	05C2	
05C4	05C5	
05C7		
0600	0603	
0610	061A	
064B	065E	
0670		
06D6	06E4	
06E7	06E8	
06EA	06ED	
070F		
0711		
0730	074A	
07A6	07B0	
07EB	07F3	
0901	0903	
093C		
093E	094D	
0951	0954	
0962	0963	
0981	0983	
09BC		
09BE	09C4	
09C7	09C8	
09CB	09CD	
09D7		
09E2	09E3	
0A01	0A03	
0A3C		
0A3E	0A42	
0A47	0A48	
0A4B	0A4D	
0A51		
0A70	0A71	
0A75		
0A81	0A83	
0ABC		
0ABE	0AC5	
0AC7	0AC9	
0ACB	0ACD	
0AE2	0AE3	
0B01	0B03	
0B3C		
0B3E	0B44	
0B47	0B48	
0B4B	0B4D	
0B56	0B57	
0B62	0B63	
0B82		
0BBE	0BC2	
0BC6	0BC8	
0BCA	0BCD	
0BD7		
0C01	0C03	
0C3E	0C44	
0C46	0C48	
0C4A	0C4D	
0C55	0C56	
0C62	0C63	
0C82	0C83	
0CBC		
0CBE	0CC4	
0CC6	0CC8	
0CCA	0CCD	
0CD5	0CD6	
0CE2	0CE3	
0D02	0D03	
0D3E	0D44	
0D46	0D48	
0D4A	0D4D	
0D57		
0D62	0D63	
0D82	0D83	
0DCA		
0DCF	0DD4	
0DD6		
0DD8	0DDF	
0DF2	0DF3	
0E31		
0E34	0E3A	
0E47	0E4E	
0EB1		
0EB4	0EB9	
0EBB	0EBC	
0EC8	0ECD	
0F18	0F19	
0F35		
0F37		
0F39		
0F3E	0F3F	
0F71	0F84	
0F86	0F87	
0F90	0F97	
0F99	0FBC	
0FC6		
102B	103E	
1056	1059	
105E	1060	
1062	1064	
1067	106D	
1071	1074	
1082	108D	
108F		
135F		
1712	1714	
1732	1734	
1752	1753	
1772	1773	
17B4	17D3	
17DD		
180B	180D	
18A9		
1920	192B	
1930	193B	
19B0	19C0	
19C8	19C9	
1A17	1A1B	
1B00	1B04	
1B34	1B44	
1B6B	1B73	
1B80	1B82	
1BA1	1BAA	
1C24	1C37	
1DC0	1DE6	
1DFE	1DFF	
200B	200F	
2028	202E	
2060	2064	
206A	206F	
20D0	20F0	
2DE0	2DFF	
302A	302F	
3099	309A	
A66F	A672	
A67C	A67D	
A802		
A806		
A80B		
A823	A827	
A880	A881	
A8B4	A8C4	
A926	A92D	
A947	A953	
AA29	AA36	
AA43		
AA4C	AA4D	
FB1E		
FE00	FE0F	
FE20	FE26	
FEFF		
FFF9	FFFB	
101FD		
10A01	10A03	
10A05	10A06	
10A0C	10A0F	
10A38	10A3A	
10A3F		
1D165	1D169	
1D16D	1D182	
1D185	1D18B	
1D1AA	1D1AD	
1D242	1D244	
E0001		
E0020	E007F	
E0100	E01EF	
END
}

sub lb_AI {
    return <<'END';
00A7	00A8	
00AA		
00B2	00B3	
00B6	00BA	
00BC	00BE	
00D7		
00F7		
02C7		
02C9	02CB	
02CD		
02D0		
02D8	02DB	
02DD		
2015	2016	
2020	2021	
203B		
2074		
207F		
2081	2084	
2105		
2113		
2121	2122	
212B		
2154	2155	
215B		
215E		
2160	216B	
2170	2179	
2190	2199	
21D2		
21D4		
2200		
2202	2203	
2207	2208	
220B		
220F		
2211		
2215		
221A		
221D	2220	
2223		
2225		
2227	222C	
222E		
2234	2237	
223C	223D	
2248		
224C		
2252		
2260	2261	
2264	2267	
226A	226B	
226E	226F	
2282	2283	
2286	2287	
2295		
2299		
22A5		
22BF		
2312		
2460	24FE	
2500	254B	
2550	2574	
2580	258F	
2592	2595	
25A0	25A1	
25A3	25A9	
25B2	25B3	
25B6	25B7	
25BC	25BD	
25C0	25C1	
25C6	25C8	
25CB		
25CE	25D1	
25E2	25E5	
25EF		
2605	2606	
2609		
260E	260F	
2614	2617	
261C		
261E		
2640		
2642		
2660	2661	
2663	2665	
2667	266A	
266C	266D	
266F		
2776	2793	
FFFD		
END
}

sub lb_AL {
    return <<'END';
0023		
0026		
002A		
003C	003E	
0040	005A	
005E	007A	
007E		
00A6		
00A9		
00AC		
00AE	00AF	
00B5		
00C0	00D6	
00D8	00F6	
00F8	02C6	
02CE	02CF	
02D1	02D7	
02DC		
02DE		
02E0	02FF	
0370	0377	
037A	037D	
0384	038A	
038C		
038E	03A1	
03A3	0482	
048A	0523	
0531	0556	
0559	055F	
0561	0587	
05C0		
05C3		
05D0	05EA	
05F0	05F4	
0600	0603	
0606	0608	
060E	060F	
0621	064A	
066D	066F	
0671	06D3	
06D5		
06DD		
06E5	06E6	
06E9		
06EE	06EF	
06FA	070D	
070F	0710	
0712	072F	
074D	07A5	
07B1		
07CA	07EA	
07F4	07F7	
07FA		
0904	0939	
093D		
0950		
0958	0961	
0970	0972	
097B	097F	
0985	098C	
098F	0990	
0993	09A8	
09AA	09B0	
09B2		
09B6	09B9	
09BD		
09CE		
09DC	09DD	
09DF	09E1	
09F0	09F1	
09F4	09FA	
0A05	0A0A	
0A0F	0A10	
0A13	0A28	
0A2A	0A30	
0A32	0A33	
0A35	0A36	
0A38	0A39	
0A59	0A5C	
0A5E		
0A72	0A74	
0A85	0A8D	
0A8F	0A91	
0A93	0AA8	
0AAA	0AB0	
0AB2	0AB3	
0AB5	0AB9	
0ABD		
0AD0		
0AE0	0AE1	
0B05	0B0C	
0B0F	0B10	
0B13	0B28	
0B2A	0B30	
0B32	0B33	
0B35	0B39	
0B3D		
0B5C	0B5D	
0B5F	0B61	
0B70	0B71	
0B83		
0B85	0B8A	
0B8E	0B90	
0B92	0B95	
0B99	0B9A	
0B9C		
0B9E	0B9F	
0BA3	0BA4	
0BA8	0BAA	
0BAE	0BB9	
0BD0		
0BF0	0BF8	
0BFA		
0C05	0C0C	
0C0E	0C10	
0C12	0C28	
0C2A	0C33	
0C35	0C39	
0C3D		
0C58	0C59	
0C60	0C61	
0C78	0C7F	
0C85	0C8C	
0C8E	0C90	
0C92	0CA8	
0CAA	0CB3	
0CB5	0CB9	
0CBD		
0CDE		
0CE0	0CE1	
0CF1	0CF2	
0D05	0D0C	
0D0E	0D10	
0D12	0D28	
0D2A	0D39	
0D3D		
0D60	0D61	
0D70	0D75	
0D7A	0D7F	
0D85	0D96	
0D9A	0DB1	
0DB3	0DBB	
0DBD		
0DC0	0DC6	
0DF4		
0E4F		
0F00		
0F05		
0F13		
0F15	0F17	
0F1A	0F1F	
0F2A	0F33	
0F36		
0F38		
0F40	0F47	
0F49	0F6C	
0F88	0F8B	
0FC0	0FC5	
0FC7	0FCC	
0FCE	0FCF	
0FD4		
104C	104F	
10A0	10C5	
10D0	10FC	
1200	1248	
124A	124D	
1250	1256	
1258		
125A	125D	
1260	1288	
128A	128D	
1290	12B0	
12B2	12B5	
12B8	12BE	
12C0		
12C2	12C5	
12C8	12D6	
12D8	1310	
1312	1315	
1318	135A	
1360		
1362	137C	
1380	1399	
13A0	13F4	
1401	1676	
1681	169A	
16A0	16EA	
16EE	16F0	
1700	170C	
170E	1711	
1720	1731	
1740	1751	
1760	176C	
176E	1770	
17D9		
17F0	17F9	
1800	1801	
1807		
180A		
1820	1877	
1880	18A8	
18AA		
1900	191C	
1940		
19E0	1A16	
1A1E	1A1F	
1B05	1B33	
1B45	1B4B	
1B61	1B6A	
1B74	1B7C	
1B83	1BA0	
1BAE	1BAF	
1C00	1C23	
1C4D	1C4F	
1C5A	1C7D	
1D00	1DBF	
1E00	1F15	
1F18	1F1D	
1F20	1F45	
1F48	1F4D	
1F50	1F57	
1F59		
1F5B		
1F5D		
1F5F	1F7D	
1F80	1FB4	
1FB6	1FC4	
1FC6	1FD3	
1FD6	1FDB	
1FDD	1FEF	
1FF2	1FF4	
1FF6	1FFC	
1FFE		
2017		
2022	2023	
2038		
203E	2043	
204A	2055	
2057		
205C		
2061	2064	
2070	2071	
2075	207C	
2080		
2085	208C	
2090	2094	
2100	2102	
2104		
2106	2108	
210A	2112	
2114	2115	
2117	2120	
2123	212A	
212C	214F	
2153		
2156	215A	
215C	215D	
215F		
216C	216F	
217A	2188	
219A	21D1	
21D3		
21D5	21FF	
2201		
2204	2206	
2209	220A	
220C	220E	
2210		
2214		
2216	2219	
221B	221C	
2221	2222	
2224		
2226		
222D		
222F	2233	
2238	223B	
223E	2247	
2249	224B	
224D	2251	
2253	225F	
2262	2263	
2268	2269	
226C	226D	
2270	2281	
2284	2285	
2288	2294	
2296	2298	
229A	22A4	
22A6	22BE	
22C0	2311	
2313	2328	
232B	23E7	
2400	2426	
2440	244A	
24FF		
254C	254F	
2575	257F	
2590	2591	
2596	259F	
25A2		
25AA	25B1	
25B4	25B5	
25B8	25BB	
25BE	25BF	
25C2	25C5	
25C9	25CA	
25CC	25CD	
25D2	25E1	
25E6	25EE	
25F0	2604	
2607	2608	
260A	260D	
2610	2613	
2618	261B	
261D		
261F	263F	
2641		
2643	265F	
2662		
2666		
266B		
266E		
2670	269D	
26A0	26BC	
26C0	26C3	
2701	2704	
2706	2709	
270C	2727	
2729	274B	
274D		
274F	2752	
2756		
2758	275A	
2761		
2764	2767	
2794		
2798	27AF	
27B1	27BE	
27C0	27C4	
27C7	27CA	
27CC		
27D0	27E5	
27F0	2982	
2999	29D7	
29DC	29FB	
29FE	2B4C	
2B50	2B54	
2C00	2C2E	
2C30	2C5E	
2C60	2C6F	
2C71	2C7D	
2C80	2CEA	
2CFD		
2D00	2D25	
2D30	2D65	
2D6F		
2D80	2D96	
2DA0	2DA6	
2DA8	2DAE	
2DB0	2DB6	
2DB8	2DBE	
2DC0	2DC6	
2DC8	2DCE	
2DD0	2DD6	
2DD8	2DDE	
2E16		
2E1A	2E1B	
2E1E	2E1F	
2E2F		
4DC0	4DFF	
A500	A60C	
A610	A61F	
A62A	A62B	
A640	A65F	
A662	A66E	
A673		
A67E	A697	
A700	A78C	
A7FB	A801	
A803	A805	
A807	A80A	
A80C	A822	
A828	A82B	
A840	A873	
A882	A8B3	
A90A	A925	
A930	A946	
A95F		
AA00	AA28	
AA40	AA42	
AA44	AA4B	
AA5C		
FB00	FB06	
FB13	FB17	
FB1D		
FB1F	FB36	
FB38	FB3C	
FB3E		
FB40	FB41	
FB43	FB44	
FB46	FBB1	
FBD3	FD3D	
FD50	FD8F	
FD92	FDC7	
FDF0	FDFB	
FDFD		
FE70	FE74	
FE76	FEFC	
FF66		
FF71	FF9D	
FFA0	FFBE	
FFC2	FFC7	
FFCA	FFCF	
FFD2	FFD7	
FFDA	FFDC	
FFE8	FFEE	
10000	1000B	
1000D	10026	
10028	1003A	
1003C	1003D	
1003F	1004D	
10050	1005D	
10080	100FA	
10107	10133	
10137	1018A	
10190	1019B	
101D0	101FC	
10280	1029C	
102A0	102D0	
10300	1031E	
10320	10323	
10330	1034A	
10380	1039D	
103A0	103C3	
103C8	103CF	
103D1	103D5	
10400	1049D	
10800	10805	
10808		
1080A	10835	
10837	10838	
1083C		
1083F		
10900	10919	
10920	10939	
1093F		
10A00		
10A10	10A13	
10A15	10A17	
10A19	10A33	
10A40	10A47	
10A58		
12000	1236E	
12400	12462	
1D000	1D0F5	
1D100	1D126	
1D129	1D164	
1D16A	1D16C	
1D183	1D184	
1D18C	1D1A9	
1D1AE	1D1DD	
1D200	1D241	
1D245		
1D300	1D356	
1D360	1D371	
1D400	1D454	
1D456	1D49C	
1D49E	1D49F	
1D4A2		
1D4A5	1D4A6	
1D4A9	1D4AC	
1D4AE	1D4B9	
1D4BB		
1D4BD	1D4C3	
1D4C5	1D505	
1D507	1D50A	
1D50D	1D514	
1D516	1D51C	
1D51E	1D539	
1D53B	1D53E	
1D540	1D544	
1D546		
1D54A	1D550	
1D552	1D6A5	
1D6A8	1D7CB	
1F000	1F02B	
1F030	1F093	
END
}

sub lb_B2 {
    return <<'END';
2014		
END
}

sub lb_BA {
    return <<'END';
0009		
007C		
00AD		
058A		
05BE		
0964	0965	
0E5A	0E5B	
0F0B		
0F34		
0F7F		
0F85		
0FBE	0FBF	
0FD2		
104A	104B	
1361		
1680		
16EB	16ED	
1735	1736	
17D4	17D5	
17D8		
17DA		
1804	1805	
1B5A	1B60	
1C3B	1C3F	
1C7E	1C7F	
2000	2006	
2008	200A	
2010		
2012	2013	
2027		
2056		
2058	205B	
205D	205F	
2CFA	2CFC	
2CFF		
2E0E	2E15	
2E17		
2E19		
2E2A	2E2D	
2E30		
A60D		
A60F		
A8CE	A8CF	
A92E	A92F	
AA5D	AA5F	
10100	10102	
1039F		
103D0		
1091F		
10A50	10A57	
12470	12473	
END
}

sub lb_BB {
    return <<'END';
00B4		
02C8		
02CC		
02DF		
0F01	0F04	
0F06	0F07	
0F09	0F0A	
0FD0	0FD1	
0FD3		
1806		
1FFD		
A874	A875	
END
}

sub lb_BK {
    return <<'END';
000B	000C	
2028	2029	
END
}

sub lb_CB {
    return <<'END';
FFFC		
END
}

sub lb_CL {
    return <<'END';
0029		
005D		
007D		
0F3B		
0F3D		
169C		
2046		
207E		
208E		
232A		
2769		
276B		
276D		
276F		
2771		
2773		
2775		
27C6		
27E7		
27E9		
27EB		
27ED		
27EF		
2984		
2986		
2988		
298A		
298C		
298E		
2990		
2992		
2994		
2996		
2998		
29D9		
29DB		
29FD		
2E23		
2E25		
2E27		
2E29		
3001	3002	
3009		
300B		
300D		
300F		
3011		
3015		
3017		
3019		
301B		
301E	301F	
FD3F		
FE11	FE12	
FE18		
FE36		
FE38		
FE3A		
FE3C		
FE3E		
FE40		
FE42		
FE44		
FE48		
FE50		
FE52		
FE5A		
FE5C		
FE5E		
FF09		
FF0C		
FF0E		
FF3D		
FF5D		
FF60	FF61	
FF63	FF64	
END
}

sub lb_CM {
    return <<'END';
0000	0008	
000E	001F	
007F	0084	
0086	009F	
0300	034E	
0350	035B	
0363	036F	
0483	0489	
0591	05BD	
05BF		
05C1	05C2	
05C4	05C5	
05C7		
0610	061A	
064B	065E	
0670		
06D6	06DC	
06DE	06E4	
06E7	06E8	
06EA	06ED	
0711		
0730	074A	
07A6	07B0	
07EB	07F3	
0901	0903	
093C		
093E	094D	
0951	0954	
0962	0963	
0981	0983	
09BC		
09BE	09C4	
09C7	09C8	
09CB	09CD	
09D7		
09E2	09E3	
0A01	0A03	
0A3C		
0A3E	0A42	
0A47	0A48	
0A4B	0A4D	
0A51		
0A70	0A71	
0A75		
0A81	0A83	
0ABC		
0ABE	0AC5	
0AC7	0AC9	
0ACB	0ACD	
0AE2	0AE3	
0B01	0B03	
0B3C		
0B3E	0B44	
0B47	0B48	
0B4B	0B4D	
0B56	0B57	
0B62	0B63	
0B82		
0BBE	0BC2	
0BC6	0BC8	
0BCA	0BCD	
0BD7		
0C01	0C03	
0C3E	0C44	
0C46	0C48	
0C4A	0C4D	
0C55	0C56	
0C62	0C63	
0C82	0C83	
0CBC		
0CBE	0CC4	
0CC6	0CC8	
0CCA	0CCD	
0CD5	0CD6	
0CE2	0CE3	
0D02	0D03	
0D3E	0D44	
0D46	0D48	
0D4A	0D4D	
0D57		
0D62	0D63	
0D82	0D83	
0DCA		
0DCF	0DD4	
0DD6		
0DD8	0DDF	
0DF2	0DF3	
0F18	0F19	
0F35		
0F37		
0F39		
0F3E	0F3F	
0F71	0F7E	
0F80	0F84	
0F86	0F87	
0F90	0F97	
0F99	0FBC	
0FC6		
135F		
1712	1714	
1732	1734	
1752	1753	
1772	1773	
180B	180D	
18A9		
1920	192B	
1930	193B	
1A17	1A1B	
1B00	1B04	
1B34	1B44	
1B6B	1B73	
1B80	1B82	
1BA1	1BAA	
1C24	1C37	
1DC0	1DE6	
1DFE	1DFF	
200C	200F	
202A	202E	
206A	206F	
20D0	20F0	
2DE0	2DFF	
302A	302F	
3099	309A	
A66F	A672	
A67C	A67D	
A802		
A806		
A80B		
A823	A827	
A880	A881	
A8B4	A8C4	
A926	A92D	
A947	A953	
AA29	AA36	
AA43		
AA4C	AA4D	
FB1E		
FE00	FE0F	
FE20	FE26	
FFF9	FFFB	
101FD		
10A01	10A03	
10A05	10A06	
10A0C	10A0F	
10A38	10A3A	
10A3F		
1D165	1D169	
1D16D	1D182	
1D185	1D18B	
1D1AA	1D1AD	
1D242	1D244	
E0001		
E0020	E007F	
E0100	E01EF	
END
}

sub lb_CR {
    return <<'END';
000D		
END
}

sub lb_EX {
    return <<'END';
0021		
003F		
05C6		
061B		
061E	061F	
06D4		
07F9		
0F0D	0F11	
0F14		
1802	1803	
1808	1809	
1944	1945	
2762	2763	
2CF9		
2CFE		
2E2E		
A60E		
A876	A877	
FE15	FE16	
FE56	FE57	
FF01		
FF1F		
END
}

sub lb_GL {
    return <<'END';
00A0		
034F		
035C	0362	
0F08		
0F0C		
0F12		
180E		
2007		
2011		
202F		
END
}

sub lb_H2 {
    return <<'END';
AC00		
AC1C		
AC38		
AC54		
AC70		
AC8C		
ACA8		
ACC4		
ACE0		
ACFC		
AD18		
AD34		
AD50		
AD6C		
AD88		
ADA4		
ADC0		
ADDC		
ADF8		
AE14		
AE30		
AE4C		
AE68		
AE84		
AEA0		
AEBC		
AED8		
AEF4		
AF10		
AF2C		
AF48		
AF64		
AF80		
AF9C		
AFB8		
AFD4		
AFF0		
B00C		
B028		
B044		
B060		
B07C		
B098		
B0B4		
B0D0		
B0EC		
B108		
B124		
B140		
B15C		
B178		
B194		
B1B0		
B1CC		
B1E8		
B204		
B220		
B23C		
B258		
B274		
B290		
B2AC		
B2C8		
B2E4		
B300		
B31C		
B338		
B354		
B370		
B38C		
B3A8		
B3C4		
B3E0		
B3FC		
B418		
B434		
B450		
B46C		
B488		
B4A4		
B4C0		
B4DC		
B4F8		
B514		
B530		
B54C		
B568		
B584		
B5A0		
B5BC		
B5D8		
B5F4		
B610		
B62C		
B648		
B664		
B680		
B69C		
B6B8		
B6D4		
B6F0		
B70C		
B728		
B744		
B760		
B77C		
B798		
B7B4		
B7D0		
B7EC		
B808		
B824		
B840		
B85C		
B878		
B894		
B8B0		
B8CC		
B8E8		
B904		
B920		
B93C		
B958		
B974		
B990		
B9AC		
B9C8		
B9E4		
BA00		
BA1C		
BA38		
BA54		
BA70		
BA8C		
BAA8		
BAC4		
BAE0		
BAFC		
BB18		
BB34		
BB50		
BB6C		
BB88		
BBA4		
BBC0		
BBDC		
BBF8		
BC14		
BC30		
BC4C		
BC68		
BC84		
BCA0		
BCBC		
BCD8		
BCF4		
BD10		
BD2C		
BD48		
BD64		
BD80		
BD9C		
BDB8		
BDD4		
BDF0		
BE0C		
BE28		
BE44		
BE60		
BE7C		
BE98		
BEB4		
BED0		
BEEC		
BF08		
BF24		
BF40		
BF5C		
BF78		
BF94		
BFB0		
BFCC		
BFE8		
C004		
C020		
C03C		
C058		
C074		
C090		
C0AC		
C0C8		
C0E4		
C100		
C11C		
C138		
C154		
C170		
C18C		
C1A8		
C1C4		
C1E0		
C1FC		
C218		
C234		
C250		
C26C		
C288		
C2A4		
C2C0		
C2DC		
C2F8		
C314		
C330		
C34C		
C368		
C384		
C3A0		
C3BC		
C3D8		
C3F4		
C410		
C42C		
C448		
C464		
C480		
C49C		
C4B8		
C4D4		
C4F0		
C50C		
C528		
C544		
C560		
C57C		
C598		
C5B4		
C5D0		
C5EC		
C608		
C624		
C640		
C65C		
C678		
C694		
C6B0		
C6CC		
C6E8		
C704		
C720		
C73C		
C758		
C774		
C790		
C7AC		
C7C8		
C7E4		
C800		
C81C		
C838		
C854		
C870		
C88C		
C8A8		
C8C4		
C8E0		
C8FC		
C918		
C934		
C950		
C96C		
C988		
C9A4		
C9C0		
C9DC		
C9F8		
CA14		
CA30		
CA4C		
CA68		
CA84		
CAA0		
CABC		
CAD8		
CAF4		
CB10		
CB2C		
CB48		
CB64		
CB80		
CB9C		
CBB8		
CBD4		
CBF0		
CC0C		
CC28		
CC44		
CC60		
CC7C		
CC98		
CCB4		
CCD0		
CCEC		
CD08		
CD24		
CD40		
CD5C		
CD78		
CD94		
CDB0		
CDCC		
CDE8		
CE04		
CE20		
CE3C		
CE58		
CE74		
CE90		
CEAC		
CEC8		
CEE4		
CF00		
CF1C		
CF38		
CF54		
CF70		
CF8C		
CFA8		
CFC4		
CFE0		
CFFC		
D018		
D034		
D050		
D06C		
D088		
D0A4		
D0C0		
D0DC		
D0F8		
D114		
D130		
D14C		
D168		
D184		
D1A0		
D1BC		
D1D8		
D1F4		
D210		
D22C		
D248		
D264		
D280		
D29C		
D2B8		
D2D4		
D2F0		
D30C		
D328		
D344		
D360		
D37C		
D398		
D3B4		
D3D0		
D3EC		
D408		
D424		
D440		
D45C		
D478		
D494		
D4B0		
D4CC		
D4E8		
D504		
D520		
D53C		
D558		
D574		
D590		
D5AC		
D5C8		
D5E4		
D600		
D61C		
D638		
D654		
D670		
D68C		
D6A8		
D6C4		
D6E0		
D6FC		
D718		
D734		
D750		
D76C		
D788		
END
}

sub lb_H3 {
    return <<'END';
AC01	AC1B	
AC1D	AC37	
AC39	AC53	
AC55	AC6F	
AC71	AC8B	
AC8D	ACA7	
ACA9	ACC3	
ACC5	ACDF	
ACE1	ACFB	
ACFD	AD17	
AD19	AD33	
AD35	AD4F	
AD51	AD6B	
AD6D	AD87	
AD89	ADA3	
ADA5	ADBF	
ADC1	ADDB	
ADDD	ADF7	
ADF9	AE13	
AE15	AE2F	
AE31	AE4B	
AE4D	AE67	
AE69	AE83	
AE85	AE9F	
AEA1	AEBB	
AEBD	AED7	
AED9	AEF3	
AEF5	AF0F	
AF11	AF2B	
AF2D	AF47	
AF49	AF63	
AF65	AF7F	
AF81	AF9B	
AF9D	AFB7	
AFB9	AFD3	
AFD5	AFEF	
AFF1	B00B	
B00D	B027	
B029	B043	
B045	B05F	
B061	B07B	
B07D	B097	
B099	B0B3	
B0B5	B0CF	
B0D1	B0EB	
B0ED	B107	
B109	B123	
B125	B13F	
B141	B15B	
B15D	B177	
B179	B193	
B195	B1AF	
B1B1	B1CB	
B1CD	B1E7	
B1E9	B203	
B205	B21F	
B221	B23B	
B23D	B257	
B259	B273	
B275	B28F	
B291	B2AB	
B2AD	B2C7	
B2C9	B2E3	
B2E5	B2FF	
B301	B31B	
B31D	B337	
B339	B353	
B355	B36F	
B371	B38B	
B38D	B3A7	
B3A9	B3C3	
B3C5	B3DF	
B3E1	B3FB	
B3FD	B417	
B419	B433	
B435	B44F	
B451	B46B	
B46D	B487	
B489	B4A3	
B4A5	B4BF	
B4C1	B4DB	
B4DD	B4F7	
B4F9	B513	
B515	B52F	
B531	B54B	
B54D	B567	
B569	B583	
B585	B59F	
B5A1	B5BB	
B5BD	B5D7	
B5D9	B5F3	
B5F5	B60F	
B611	B62B	
B62D	B647	
B649	B663	
B665	B67F	
B681	B69B	
B69D	B6B7	
B6B9	B6D3	
B6D5	B6EF	
B6F1	B70B	
B70D	B727	
B729	B743	
B745	B75F	
B761	B77B	
B77D	B797	
B799	B7B3	
B7B5	B7CF	
B7D1	B7EB	
B7ED	B807	
B809	B823	
B825	B83F	
B841	B85B	
B85D	B877	
B879	B893	
B895	B8AF	
B8B1	B8CB	
B8CD	B8E7	
B8E9	B903	
B905	B91F	
B921	B93B	
B93D	B957	
B959	B973	
B975	B98F	
B991	B9AB	
B9AD	B9C7	
B9C9	B9E3	
B9E5	B9FF	
BA01	BA1B	
BA1D	BA37	
BA39	BA53	
BA55	BA6F	
BA71	BA8B	
BA8D	BAA7	
BAA9	BAC3	
BAC5	BADF	
BAE1	BAFB	
BAFD	BB17	
BB19	BB33	
BB35	BB4F	
BB51	BB6B	
BB6D	BB87	
BB89	BBA3	
BBA5	BBBF	
BBC1	BBDB	
BBDD	BBF7	
BBF9	BC13	
BC15	BC2F	
BC31	BC4B	
BC4D	BC67	
BC69	BC83	
BC85	BC9F	
BCA1	BCBB	
BCBD	BCD7	
BCD9	BCF3	
BCF5	BD0F	
BD11	BD2B	
BD2D	BD47	
BD49	BD63	
BD65	BD7F	
BD81	BD9B	
BD9D	BDB7	
BDB9	BDD3	
BDD5	BDEF	
BDF1	BE0B	
BE0D	BE27	
BE29	BE43	
BE45	BE5F	
BE61	BE7B	
BE7D	BE97	
BE99	BEB3	
BEB5	BECF	
BED1	BEEB	
BEED	BF07	
BF09	BF23	
BF25	BF3F	
BF41	BF5B	
BF5D	BF77	
BF79	BF93	
BF95	BFAF	
BFB1	BFCB	
BFCD	BFE7	
BFE9	C003	
C005	C01F	
C021	C03B	
C03D	C057	
C059	C073	
C075	C08F	
C091	C0AB	
C0AD	C0C7	
C0C9	C0E3	
C0E5	C0FF	
C101	C11B	
C11D	C137	
C139	C153	
C155	C16F	
C171	C18B	
C18D	C1A7	
C1A9	C1C3	
C1C5	C1DF	
C1E1	C1FB	
C1FD	C217	
C219	C233	
C235	C24F	
C251	C26B	
C26D	C287	
C289	C2A3	
C2A5	C2BF	
C2C1	C2DB	
C2DD	C2F7	
C2F9	C313	
C315	C32F	
C331	C34B	
C34D	C367	
C369	C383	
C385	C39F	
C3A1	C3BB	
C3BD	C3D7	
C3D9	C3F3	
C3F5	C40F	
C411	C42B	
C42D	C447	
C449	C463	
C465	C47F	
C481	C49B	
C49D	C4B7	
C4B9	C4D3	
C4D5	C4EF	
C4F1	C50B	
C50D	C527	
C529	C543	
C545	C55F	
C561	C57B	
C57D	C597	
C599	C5B3	
C5B5	C5CF	
C5D1	C5EB	
C5ED	C607	
C609	C623	
C625	C63F	
C641	C65B	
C65D	C677	
C679	C693	
C695	C6AF	
C6B1	C6CB	
C6CD	C6E7	
C6E9	C703	
C705	C71F	
C721	C73B	
C73D	C757	
C759	C773	
C775	C78F	
C791	C7AB	
C7AD	C7C7	
C7C9	C7E3	
C7E5	C7FF	
C801	C81B	
C81D	C837	
C839	C853	
C855	C86F	
C871	C88B	
C88D	C8A7	
C8A9	C8C3	
C8C5	C8DF	
C8E1	C8FB	
C8FD	C917	
C919	C933	
C935	C94F	
C951	C96B	
C96D	C987	
C989	C9A3	
C9A5	C9BF	
C9C1	C9DB	
C9DD	C9F7	
C9F9	CA13	
CA15	CA2F	
CA31	CA4B	
CA4D	CA67	
CA69	CA83	
CA85	CA9F	
CAA1	CABB	
CABD	CAD7	
CAD9	CAF3	
CAF5	CB0F	
CB11	CB2B	
CB2D	CB47	
CB49	CB63	
CB65	CB7F	
CB81	CB9B	
CB9D	CBB7	
CBB9	CBD3	
CBD5	CBEF	
CBF1	CC0B	
CC0D	CC27	
CC29	CC43	
CC45	CC5F	
CC61	CC7B	
CC7D	CC97	
CC99	CCB3	
CCB5	CCCF	
CCD1	CCEB	
CCED	CD07	
CD09	CD23	
CD25	CD3F	
CD41	CD5B	
CD5D	CD77	
CD79	CD93	
CD95	CDAF	
CDB1	CDCB	
CDCD	CDE7	
CDE9	CE03	
CE05	CE1F	
CE21	CE3B	
CE3D	CE57	
CE59	CE73	
CE75	CE8F	
CE91	CEAB	
CEAD	CEC7	
CEC9	CEE3	
CEE5	CEFF	
CF01	CF1B	
CF1D	CF37	
CF39	CF53	
CF55	CF6F	
CF71	CF8B	
CF8D	CFA7	
CFA9	CFC3	
CFC5	CFDF	
CFE1	CFFB	
CFFD	D017	
D019	D033	
D035	D04F	
D051	D06B	
D06D	D087	
D089	D0A3	
D0A5	D0BF	
D0C1	D0DB	
D0DD	D0F7	
D0F9	D113	
D115	D12F	
D131	D14B	
D14D	D167	
D169	D183	
D185	D19F	
D1A1	D1BB	
D1BD	D1D7	
D1D9	D1F3	
D1F5	D20F	
D211	D22B	
D22D	D247	
D249	D263	
D265	D27F	
D281	D29B	
D29D	D2B7	
D2B9	D2D3	
D2D5	D2EF	
D2F1	D30B	
D30D	D327	
D329	D343	
D345	D35F	
D361	D37B	
D37D	D397	
D399	D3B3	
D3B5	D3CF	
D3D1	D3EB	
D3ED	D407	
D409	D423	
D425	D43F	
D441	D45B	
D45D	D477	
D479	D493	
D495	D4AF	
D4B1	D4CB	
D4CD	D4E7	
D4E9	D503	
D505	D51F	
D521	D53B	
D53D	D557	
D559	D573	
D575	D58F	
D591	D5AB	
D5AD	D5C7	
D5C9	D5E3	
D5E5	D5FF	
D601	D61B	
D61D	D637	
D639	D653	
D655	D66F	
D671	D68B	
D68D	D6A7	
D6A9	D6C3	
D6C5	D6DF	
D6E1	D6FB	
D6FD	D717	
D719	D733	
D735	D74F	
D751	D76B	
D76D	D787	
D789	D7A3	
END
}

sub lb_HY {
    return <<'END';
002D		
END
}

sub lb_ID {
    return <<'END';
2E80	2E99	
2E9B	2EF3	
2F00	2FD5	
2FF0	2FFB	
3000		
3003	3004	
3006	3007	
3012	3013	
3020	3029	
3030	303A	
303D	303F	
3042		
3044		
3046		
3048		
304A	3062	
3064	3082	
3084		
3086		
3088	308D	
308F	3094	
309F		
30A2		
30A4		
30A6		
30A8		
30AA	30C2	
30C4	30E2	
30E4		
30E6		
30E8	30ED	
30EF	30F4	
30F7	30FA	
30FF		
3105	312D	
3131	318E	
3190	31B7	
31C0	31E3	
3200	321E	
3220	3243	
3250	32FE	
3300	4DB5	
4E00	9FC3	
A000	A014	
A016	A48C	
A490	A4C6	
F900	FA2D	
FA30	FA6A	
FA70	FAD9	
FE30	FE34	
FE45	FE46	
FE49	FE4F	
FE51		
FE58		
FE5F	FE66	
FE68		
FE6B		
FF02	FF03	
FF06	FF07	
FF0A	FF0B	
FF0D		
FF0F	FF19	
FF1C	FF1E	
FF20	FF3A	
FF3C		
FF3E	FF5A	
FF5C		
FF5E		
FFE2	FFE4	
20000	2A6D6	
2F800	2FA1D	
END
}

sub lb_IN {
    return <<'END';
2024	2026	
FE19		
END
}

sub lb_IS {
    return <<'END';
002C		
002E		
003A	003B	
037E		
0589		
060C	060D	
07F8		
2044		
FE10		
FE13	FE14	
END
}

sub lb_JL {
    return <<'END';
1100	1159	
115F		
END
}

sub lb_JT {
    return <<'END';
11A8	11F9	
END
}

sub lb_JV {
    return <<'END';
1160	11A2	
END
}

sub lb_LF {
    return <<'END';
000A		
END
}

sub lb_NL {
    return <<'END';
0085		
END
}

sub lb_NS {
    return <<'END';
17D6		
203C	203D	
2047	2049	
3005		
301C		
303B	303C	
309B	309E	
30A0		
30FB		
30FD	30FE	
A015		
FE54	FE55	
FF1A	FF1B	
FF65		
FF9E	FF9F	
END
}

sub lb_NSid {
    return <<'END';
3041		
3043		
3045		
3047		
3049		
3063		
3083		
3085		
3087		
308E		
3095	3096	
30A1		
30A3		
30A5		
30A7		
30A9		
30C3		
30E3		
30E5		
30E7		
30EE		
30F5	30F6	
30FC		
31F0	31FF	
FF67	FF70	
END
}

sub lb_NU {
    return <<'END';
0030	0039	
0660	0669	
066B	066C	
06F0	06F9	
07C0	07C9	
0966	096F	
09E6	09EF	
0A66	0A6F	
0AE6	0AEF	
0B66	0B6F	
0BE6	0BEF	
0C66	0C6F	
0CE6	0CEF	
0D66	0D6F	
0E50	0E59	
0ED0	0ED9	
0F20	0F29	
1040	1049	
1090	1099	
17E0	17E9	
1810	1819	
1946	194F	
19D0	19D9	
1B50	1B59	
1BB0	1BB9	
1C40	1C49	
1C50	1C59	
A620	A629	
A8D0	A8D9	
A900	A909	
AA50	AA59	
104A0	104A9	
1D7CE	1D7FF	
END
}

sub lb_OP {
    return <<'END';
0028		
005B		
007B		
00A1		
00BF		
0F3A		
0F3C		
169B		
201A		
201E		
2045		
207D		
208D		
2329		
2768		
276A		
276C		
276E		
2770		
2772		
2774		
27C5		
27E6		
27E8		
27EA		
27EC		
27EE		
2983		
2985		
2987		
2989		
298B		
298D		
298F		
2991		
2993		
2995		
2997		
29D8		
29DA		
29FC		
2E18		
2E22		
2E24		
2E26		
2E28		
3008		
300A		
300C		
300E		
3010		
3014		
3016		
3018		
301A		
301D		
FD3E		
FE17		
FE35		
FE37		
FE39		
FE3B		
FE3D		
FE3F		
FE41		
FE43		
FE47		
FE59		
FE5B		
FE5D		
FF08		
FF3B		
FF5B		
FF5F		
FF62		
END
}

sub lb_PO {
    return <<'END';
0025		
00A2		
00B0		
0609	060B	
066A		
0D79		
2030	2037	
20A7		
2103		
2109		
FDFC		
FE6A		
FF05		
FFE0		
END
}

sub lb_PR {
    return <<'END';
0024		
002B		
005C		
00A3	00A5	
00B1		
09F2	09F3	
0AF1		
0BF9		
0E3F		
17DB		
20A0	20A6	
20A8	20B5	
2116		
2212	2213	
FE69		
FF04		
FFE1		
FFE5	FFE6	
END
}

sub lb_QU {
    return <<'END';
0022		
0027		
00AB		
00BB		
2018	2019	
201B	201D	
201F		
2039	203A	
275B	275E	
2E00	2E0D	
2E1C	2E1D	
2E20	2E21	
END
}

sub lb_SA {
    return <<'END';
0E01	0E30	
0E32	0E33	
0E40	0E46	
0E81	0E82	
0E84		
0E87	0E88	
0E8A		
0E8D		
0E94	0E97	
0E99	0E9F	
0EA1	0EA3	
0EA5		
0EA7		
0EAA	0EAB	
0EAD	0EB0	
0EB2	0EB3	
0EBD		
0EC0	0EC4	
0EC6		
0EDC	0EDD	
1000	102A	
103F		
1050	1055	
105A	105D	
1061		
1065	1066	
106E	1070	
1075	1081	
108E		
109E	109F	
1780	17B5	
17D7		
17DC		
1950	196D	
1970	1974	
1980	19A9	
19C1	19C7	
19DE	19DF	
END
}

sub lb_SAcm {
    return <<'END';
0E31		
0E34	0E3A	
0E47	0E4E	
0EB1		
0EB4	0EB9	
0EBB	0EBC	
0EC8	0ECD	
102B	103E	
1056	1059	
105E	1060	
1062	1064	
1067	106D	
1071	1074	
1082	108D	
108F		
17B6	17D3	
17DD		
19B0	19C0	
19C8	19C9	
END
}

sub lb_SG {
    return <<'END';
D800	DFFF	
END
}

sub lb_SP {
    return <<'END';
0020		
END
}

sub lb_SY {
    return <<'END';
002F		
END
}

sub lb_WJ {
    return <<'END';
2060		
FEFF		
END
}

sub lb_XX {
    return <<'END';
E000	F8FF	
F0000	FFFFD	
100000	10FFFD	
END
}

sub lb_ZW {
    return <<'END';
200B		
END
}

1;
