use 5.10.0;
use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME               => 'DateTime::Age',
    AUTHOR             => q{Mario Zieschang  <mziescha@cpan.org>},
    VERSION_FROM       => 'lib/DateTime/Age.pm',
    ABSTRACT_FROM      => 'lib/DateTime/Age.pm',
    LICENSE            => 'artistic_2',
    PL_FILES           => {},
    MIN_PERL_VERSION   => 5.10.0,
    CONFIGURE_REQUIRES => {
        'ExtUtils::MakeMaker' => 0,
    },
    BUILD_REQUIRES => {
        'DateTime::Span::Birthdate' => 0.03,
        'Test::More'                => 0,
        'FindBin'                   => 0,
        'Test::Pod'                 => 1.22,
        'Pod::Coverage::TrustPod'   => 0,
        'Test::CheckManifest'       => 0.9,
    },
    PREREQ_PM => {
        'Time::Local' => 0,
        'Exporter'    => 0,
    },
    dist  => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean => { FILES    => 'DateTime-Age-*' },
);
