/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import java.util.Date;

public class Item {
    private String key;
    private int flags;
    private int exptime;
    private byte[] value;
    private long cas;
    private long mtime;

    public Item(String key, int flags, int exptime, byte[] value, long cas) {
        this.key = key;
        this.flags = flags;
        this.exptime = exptime;
        this.value = value;
        this.cas = cas;
    }

    public int getExptime() {
        return this.exptime;
    }

    public int getExptimeInMillis() {
        return this.exptime * 1000;
    }

    public void setExptime(int e) {
        this.exptime = e;
    }

    public long getMtime() {
        return this.mtime;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public long getCas() {
        return this.cas;
    }

    void setCas(long l) {
        this.mtime = new Date().getTime();
        this.cas = l;
    }

    public void append(Item i) {
        byte[] s1 = this.value;
        byte[] s2 = i.getValue();
        byte[] dst = new byte[s1.length + s2.length];
        System.arraycopy(s1, 0, dst, 0, s1.length);
        System.arraycopy(s2, 0, dst, s1.length, s2.length);
        this.value = dst;
    }

    public void prepend(Item i) {
        byte[] s1 = this.value;
        byte[] s2 = i.getValue();
        byte[] dst = new byte[s1.length + s2.length];
        System.arraycopy(s2, 0, dst, 0, s2.length);
        System.arraycopy(s1, 0, dst, s2.length, s1.length);
        this.value = dst;
    }
}

