package B::Showlex;
use strict;
use B qw(svref_2object comppadlist class);
use B::Terse ();

#
# Invoke as
#     perl -MO=Showlex,foo bar.pl
# to see the names of lexical variables used by &foo
# or as
#     perl -MO=Showlex bar.pl
# to see the names of file scope lexicals used by bar.pl
#    

sub showarray {
    my ($name, $av) = @_;
    my @els = $av->ARRAY;
    my $count = @els;
    my $i;
    print "$name has $count entries\n";
    for ($i = 0; $i < $count; $i++) {
	print "$i: ";
	$els[$i]->terse;
    }
}

sub showlex {
    my ($objname, $namesav, $valsav) = @_;
    showarray("Pad of lexical names for $objname", $namesav);
    showarray("Pad of lexical values for $objname", $valsav);
}

sub showlex_obj {
    my ($objname, $obj) = @_;
    $objname =~ s/^&main::/&/;
    showlex($objname, svref_2object($obj)->PADLIST->ARRAY);
}

sub showlex_main {
    showlex("comppadlist", comppadlist->ARRAY);
}

sub compile {
    my @options = @_;
    if (@options) {
	return sub {
	    my $objname;
	    foreach $objname (@options) {
		$objname = "main::$objname" unless $objname =~ /::/;
		eval "showlex_obj('&$objname', \\&$objname)";
	    }
	}
    } else {
	return \&showlex_main;
    }
}

1;
