// Support for registering field handlers that can write into a proto2
// message that uses GeneratedMessageReflection (which includes all messages
// generated by the proto2 compiler as well as DynamicMessage).
//
// This is an internal-only interface.

#ifndef UPB_GOOGLE_PROTO2_H_
#define UPB_GOOGLE_PROTO2_H_

namespace proto2 {
class FieldDescriptor;
class Message;
}

namespace google {
namespace protobuf {
class FieldDescriptor;
class Message;
}
}

namespace upb {
class FieldDef;
class Handlers;
}

namespace upb {
namespace googlepb {

// Sets field handlers in the given Handlers object for writing to a single
// field (as described by "proto2_f" and "upb_f") into a message constructed
// by the same factory as "prototype."  Returns true if this was successful
// (this will fail if "prototype" is not a proto1 message, or if we can't
// handle it for some reason).
bool TrySetWriteHandlers(const proto2::FieldDescriptor* proto2_f,
                         const proto2::Message& prototype,
                         const upb::FieldDef* upb_f, upb::Handlers* h);
bool TrySetWriteHandlers(const ::google::protobuf::FieldDescriptor* proto2_f,
                         const ::google::protobuf::Message& prototype,
                         const upb::FieldDef* upb_f, upb::Handlers* h);

// Returns a prototype for the given field in "m", if the given message uses
// GeneratedMessageReflection.  Otherwise returns NULL.
const proto2::Message* GetProto2FieldPrototype(
    const proto2::Message& m, const proto2::FieldDescriptor* f);
const ::google::protobuf::Message* GetProto2FieldPrototype(
    const ::google::protobuf::Message& m,
    const ::google::protobuf::FieldDescriptor* f);

}  // namespace googlepb
}  // namespace upb

#endif  // UPB_GOOGLE_PROTO2_H_
