package HTML::Menu::TreeView::GER;
use strict;
use warnings;
$HTML::Menu::TreeView::GER::VERSION = '1.05';

=head1 NAME

HTML::Menu::TreeView

=head1 SYNOPSIS

     use HTML::Menu::TreeView qw(Tree);

     my @tree =( {

     text => 'Folder',

     subtree => [

          {

          text => 'treeview Homepage',

          href => 'http://treeview.lindnerei.de',

          }

            ],

     },);

     Tree(\@tree);

=head2 OO Syntax

     use HTML::Menu::TreeView;

     use strict;

     my @tree =(

          {

               image => 'tar.png',

               onclick => "alert('onclick');",

               text => 'Node',

          },

          {

               text => 'Folder',

               folderclass => 'folderMan', # Nur fr Crystal Styles.

               subtree => [

                    {

                         text => 'subversion',

                         href => 'http://treeview.tigris.org',

                    },

               ],

          },

     );

     my $Treeview = new HTML::Menu::TreeView();

     print $Treeview->css("/srv/www/httpdocs");

     print $Treeview->jscript();

     print $Treeview->preload();

     print $Treeview->Tree(\@tree);

=head2 FO Syntax

     use HTML::Menu::TreeView qw(:all);

     print css();

     print jscript();

     print preload();

     print Tree(\@tree,"Crystal");


=head3 Funktions- Sets

Hier die liste der mglichen Import Sets

:all

Tree css jscript clasic preload help folderFirst size documentRoot loadTree saveTree sortTree orderBy prefix Style orderByColumn border TrOver

:recommend

Tree css jscript clasic preload folderFirst size Style documentRoot loadTree saveTree sortTree orderBy prefix

:standart

Tree css jscript preload size Style documentRoot clasic,

:backward

setDocumentRoot getDocumentRoot setSize setClasic setStyle style setModern %anker

:columns

border columns orderByColumn

=head1 Beschreibung

HTML::Menu::TreeView ist ein Module HTML Baumansicht zu erstellen.

=head1 nderungen

1.05

desc rckwrts sortieren

TrOver Mouseover effekt fr spalten gefixt

1.04

TrOver Mouseover effekt fr Zeilen


=head1 ffentlich

=head2 new

     Bei der Objektorientierten Schnittstelle kann man die Array Referenz direkt an new bergeben

     ms $TreeView = new HTML::Menu::TreeView(\@tree, optional style);

     und Tree dann ohne Argumente aufrufen.

     print $TreeView->Tree();

=head2 css

Gibt den bentigten Stylesheet(css) zurck, der In die Seite eingebunden werden muss.

Mann kann den Document Root setzen wenn man ein Argument bergibt.

     css('/document/root/');

Man kann den bentigten Stylesheet natrlich per Hand einbinden:

     <link href="/style/Crystal/16/html-menu-treeview/Crystal.css" rel="stylesheet" type="text/css">

=head2 documentRoot

Setzt den Document Root im Scalar Context, gibt Ihn ohne argument zurck.

default: Diese Variable wird durch make gesetzt.

=head2 jscript

Gibt den bentigten Javascript zurck, der In die Seite eingebunden werden muss.

Mann kann den Document Root setzen wenn man ein Argument bergibt.

Man kann den bentigten Javascript natrlich per Hand einbinden:

     <script language="JavaScript" type="text/javascript" src="/style/treeview.js"></script>

=head2 preload

Gibt den bentigten javascript zurck um Bilder per Javascript in Vorhinein zu laden.

Mann kann den document root setzen wenn man ein Argument bergibt.

Man kann den bentigten javascript natrlich auch per Hand einbinden.

Fr eine Gre:

     <script language="JavaScript" type="text/javascript" src="/style/Crystal/16/html-menu-treeview/preload.js"></script>

Oder fr alle Gren:

     <script language="JavaScript" type="text/javascript" src="/style/Crystal/preload.js"></script>

=head2 size

Verschiedene Gren sind nur fr den Crystal Style verfgbar.

Setzt die Gre im Scalar Context, gibt Sie ohne argument zurck.

16,32,48,64 und 128 sind mgliche Werte.

=head2 Style

Setzt den Style im Scalar Context, gibt Ihn ohne argument zurck.

     Style('simple');

simple = Redmond miger style.

Crystal = Kde Crystal style (default).

=head2 Tree

     Tree(\@tree,optional $style);

Gibt den HTML teil des Treeviews ohne Javascript und Css zurck.

=head2 clasic

Klassische Knoten Dekoration einschalten

     clasic(1);

klassische Knoten Dekoration ausschalten

     clasic(0);

gibt den Status in ohne argument zurck.

     $status = clasic();

=head2 columns

Anzahl der Spalten setzen.

     columns(3);

Gibt die Anzahl in ohne argument  zurck.

     $anzahl = columns();

Oder man kann die Titel fr die Spalten Setzen

     columns("Name","Column 1","Column 2","Column 3");

=head2 border

Spalten Rahmen ein- oder ausschalten.

=head2 sortTree

Spalten nach Name oder dem Attribute das von orderBy gesetzt wurde sortieren.


=head2 desc

rckwrts sortieren

     desc(1);

ohne argument wird der wert zurckgegeben.

     $status = desc();

=cut

=head2 orderBy

Setzt das Attribute das von sortTree und folderFirst benutzt wird.

=head2 orderByColumn

Nach Spalte Sortieren.

     orderByColumn(i)

=head2 folderFirst

Verzeichnisse zuerst anzeigen.

=head2 prefix

Wenn man eine offline Webseite erstellen will kann man

z.Bsp:

     prefix('.');

setzen.

=head2 TrOver

mouseover aktivieren

tr.trOver{}

=cut

=head2 saveTree

     saveTree('filename',\@ref); # oder saveTree()

default: ./TreeViewDump.pl

=head2 loadTree

     loadTree('filename')  oder loadTree()

default: ./TreeViewDump.pl


=head2 help

Die Hilfe fr die Link Attribute

gibt eine Referenz auf ein hash zurck (ohne argument ),

     my $hashref =  help();

     foreach my $key (sort(keys %{$hashref})){

          print "$key : ", $hashref->{$key} ,$/;

     }

oder eine Hilfe Nachricht.

     print help('href'),$/;

(Nur auf Englisch verfgbar)

=head3 reservierte Attribute:

=over

=item href

Dieses Attribut gibt die Position einer Web-Ressource an und definiert so einen Link zwischen dem

aktuellen Element (dem Quellanker) und dem durch dieses Attribut definierten Zielanker.

=item accesskey

Dieses Attribut weist einem Element eine Zugriffstaste zu.

=item charset

Gibt die Zeichenkodierungen an.

=item class

Name der Klasse des Elements.

=item coords

Fr Image maps.

=item dir

Leserichtung.

=item hreflang

Sprache vom Link Ziel.

=item lang

Basis-Sprache der Attribute und des Inhalts.

=item onblur

Element verliert die Auswahl.

=item ondblclick

Wenn mit der Maus auf das Element doppelt angeklickt wird.

=item onclick

Wenn mit der Maus auf das Element geklickt wird.

=item onfocus

Element wird ausgewhlt.

=item onkeydown

Wenn eine taste gedrckt wird.

=item onkeypress

Wenn eine taste gedrckt und wieder losgelassen wird.

=item onkeyup

Wenn die taste wieder losgelassen wird.

=item onmousedown

Wenn eine Maustaste gedrckt wird.

=item onmousemove

Maus wird bewegt.

=item onmouseout

Maus verlsst den link.

=item onmouseover

Maus ber den link

=item onmouseup

Wenn die Maustaste wieder losgelassen wird.

=item rel

Dieses Attribut beschreibt die Beziehung vom aktuellen Dokument zu dem durch das href-Attribut angegebenen Anker.

=item rev

Dieses Attribut gibt die Zeichenkodierung der durch den Link bezeichneten Ressource an.

=item shape

Fr image maps.

=item style

Stylesheet Informationen.

=item tabindex

Position in der tab Reihenfolge.

=item target

Mit dem Attribut target im einleitenden <a>-Tag knnen Sie ein Zielfenster fr den Verweis festlegen. Der im Wert zugewiesene Name muss mit einem Buchstaben (A-Z, a-z) beginnen, auer in den folgenden

Ausnahmen, die durch einen fhrenden Unterstrich gekennzeichnet sind:

_blank, um den Verweis in einem neuen Fenster zu ffnen,

 _self, um den Verweis im aktuellen Fenster zu ffnen,

 _parent, um bei verschachtelten Framesets das aktuelle Frameset zu sprengen,

 _top, um bei verschachtelten Framesets alle Framesets zu sprengen.


=item type

Content type.

=item title

Titel.

=item id

Die id des links. Wird gesetzt.

=item addition

Zustzlicher text hinter dem link.

=item subtree

     subtree => [{

          text => 'Fo'},

          {text => 'Bar'}

     ]

=item image.

Bild Name, muss im /style/mimetypes Verzeichnis liegen

=item folderclass :

Nur fr Crystal styles

Mgliche Werte:

folderMan, folderVideo,folderCrystal,

folderLocked , folderText, folderFavorite,

folderPrint,folderHtml,

folderImage,folderSound,folderImportant,

folderTar,folderYellow ,folderGray,

folderGreen und folderRed

http://treeview.lindnerei.de/cgi-bin/crystal.pl gibt es eine komplette liste mglicher werte.

=item columns

Ein Array mit den Spalten.

=item empty.

Auf wahr setzen wenn man einen geschlossenes Verzeichnis haben mchte.

=back

=head1 rckwrts kompatibilitt

=head2 getDocumentRoot

siehe documentRoot()

=head2 setClasic

siehe clasic()

=head2 setDocumentRoot

siehe documentRoot()

=head2 setModern

siehe clasic()

=head2 setSize

siehe size()

=head2 setStyle

siehe Style()

=head2 style

siehe Style()

=head1 Private

=head2 initTree

Erzeugt den Treeview, wird von initTree, new  oder rekursive von appendFolder aufgerufen.

=head2 ffolderFirst

Wird innerhalb von initTree zum sortieren benutzt wenn Verzeichnisse zuerst angezeigt werden sollen.

=head2 getSelf

Dieses Module benutzt ein Lincoln loader miges Klassen System.

Wenn der erste bergebene Parameter von ein HTML::Menu::TreeView Objekt ist (oo syntax). werden einfach die bergebenen Parameter zurck gegeben.

Ansonsten (fo syntax)  wird ein neues HTML::Menu::TreeView Objekt erzeugt und als erster wert gefolgt von den bergeben Parametern zurckgegeben.

=head2 appendFolder

Wird von initTree aufgerufen wenn ein item vom aktuellen (sub)tree ein Verzeichnis ist.

=head2 appendLastFolder

$self->appendLastFolder(\@tree);

Wird von initTree aufgerufen wenn das letzte item vom aktuellen (sub)tree ein Verzeichnis ist.

=head2 appendEmptyFolder

$self->appendEmptyFolder(\$node);

Wird von initTree aufgerufen wenn ein item vom aktuellen (sub)tree ein ein leeres Verzeichnis ist.

=head2 appendLastEmptyFolder

$self->appendEmptyFolder(\$node);

Wird von initTree aufgerufen wenn das letzte item vom aktuellen (sub)tree ein leeres Verzeichnis ist.

=head2 appendNode

$self->appendNode(\$node);

Wird von initTree aufgerufen wenn ein item vom aktuellen (sub)tree ein Knoten ist.

=head2 appendLastNode

$self->appendLastNode(\$node);

wir von initTree aufgerufen wenn das letzte item vom aktuellen (sub)tree ein Knoten ist.

=head1 Siehe auch

http://www.lindnerei.de, http://treeview.lindnerei.de,

L<HTML::Menu::TreeView>, http://treeview.tigris.org,

=head1 AUTHOR

Dirk Lindner <lze@cpan.org>

=head1 Lizenz

LGPL

Copyright (C) 2009  Dirk Lindner

Diese Bibliothek ist freie Software. Sie drfen sie unter den Bedingungen
der GNU Lesser General Public License, wie von der Free Software Foundation verffentlicht,
weiterverteilen und/oder modifizieren; entweder gem Version 2.1 der Lizenz oder (nach Ihrer
Option) jeder spteren Version. Diese Bibliothek wird in der Hoffnung weiterverbreitet,
da sie ntzlich sein wird, jedoch OHNE IRGENDEINE GARANTIE,
auch ohne die implizierte Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
Mehr Details finden Sie in der GNU Lesser General Public License.
Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit dieser Bibliothek erhalten haben.
falls nicht,
schreiben Sie an die Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA.

=cut

1;
