/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;

public class FirefoxChromeLauncher
implements BrowserLauncher {
    private static final String DEFAULT_NONWINDOWS_LOCATION = "/Applications/Firefox.app/Contents/MacOS/firefox-bin";
    private static boolean simple = false;
    private int port;
    private String sessionId;
    private File customProfileDir;
    private String[] cmdarray;
    private boolean closed = false;
    private String commandPath;
    private Process process;
    private static AsyncExecute exe = new AsyncExecute();
    static final Pattern JAVA_STYLE_UNC_URL = Pattern.compile("^file:////([^/]+/.*)$");

    public FirefoxChromeLauncher(int port, String sessionId) {
        this(port, sessionId, FirefoxChromeLauncher.findBrowserLaunchLocation());
    }

    public FirefoxChromeLauncher(int port, String sessionId, String browserLaunchLocation) {
        this.commandPath = browserLaunchLocation;
        this.port = port;
        this.sessionId = sessionId;
        exe.setEnvironment(new String[]{"MOZ_NO_REMOTE=1"});
        if (!WindowsUtils.thisIsWindows()) {
            File execDirect;
            File firefoxBin = AsyncExecute.whichExec(this.commandPath);
            if (firefoxBin == null && (execDirect = new File(this.commandPath)).isAbsolute() && execDirect.exists()) {
                firefoxBin = execDirect;
            }
            if (firefoxBin != null) {
                String libPathKey = FirefoxChromeLauncher.getLibPathKey();
                String libPath = WindowsUtils.loadEnvironment().getProperty(libPathKey);
                exe.setEnvironment(new String[]{"MOZ_NO_REMOTE=1", libPathKey + "=" + libPath + ":" + firefoxBin.getParent()});
            }
        }
    }

    private static String getLibPathKey() {
        if (WindowsUtils.thisIsWindows()) {
            return WindowsUtils.getExactPathEnvKey();
        }
        if (Os.isFamily("mac")) {
            return "DYLD_LIBRARY_PATH";
        }
        return "LD_LIBRARY_PATH";
    }

    private static String findBrowserLaunchLocation() {
        File defaultLocation;
        String defaultPath = System.getProperty("firefoxDefaultPath");
        if (defaultPath == null) {
            defaultPath = WindowsUtils.thisIsWindows() ? WindowsUtils.getProgramFilesPath() + "\\Mozilla Firefox\\firefox.exe" : DEFAULT_NONWINDOWS_LOCATION;
        }
        if ((defaultLocation = new File(defaultPath)).exists()) {
            return defaultLocation.getAbsolutePath();
        }
        if (WindowsUtils.thisIsWindows()) {
            File firefoxEXE = AsyncExecute.whichExec("firefox.exe");
            if (firefoxEXE != null) {
                return firefoxEXE.getAbsolutePath();
            }
            throw new RuntimeException("Firefox couldn't be found in the path!\nPlease add the directory containing firefox.exe to your PATH environment\nvariable, or explicitly specify a path to Firefox like this:\n*firefox c:\\blah\\firefox.exe");
        }
        File firefoxBin = AsyncExecute.whichExec("firefox-bin");
        if (firefoxBin != null) {
            return firefoxBin.getAbsolutePath();
        }
        throw new RuntimeException("Firefox couldn't be found in the path!\nPlease add the directory containing 'firefox-bin' to your PATH environment\nvariable, or explicitly specify a path to Firefox like this:\n*firefox /blah/blah/firefox-bin");
    }

    private static String pathToBrowserURL(String path) {
        if (path == null) {
            return null;
        }
        String url = new File(path).toURI().toString();
        Matcher m = JAVA_STYLE_UNC_URL.matcher(url);
        if (m.find()) {
            url = "file://///";
            url = url + m.group(1);
        }
        return url;
    }

    public void launch(String url, String htmlName) {
        try {
            String query = LauncherUtils.getQueryString(url);
            if (null == query) {
                query = "";
            }
            query = query + "&baseUrl=http://localhost:" + this.port + "/selenium-server/";
            String homePage = "chrome://src/content/" + htmlName + "?" + query;
            String profilePath = this.makeCustomProfile(homePage);
            String chromeURL = "chrome://killff/content/kill.html";
            this.cmdarray = new String[]{this.commandPath, "-profile", profilePath, chromeURL};
            System.out.println("Preparing Firefox profile...");
            exe.setCommandline(this.cmdarray);
            exe.execute();
            this.waitForFullProfileToBeCreated(20000L);
            System.out.println("Launching Firefox...");
            this.cmdarray = new String[]{this.commandPath, "-profile", profilePath};
            exe.setCommandline(this.cmdarray);
            this.process = exe.asyncSpawn();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String makeCustomProfile(String homePage) throws IOException {
        this.customProfileDir = LauncherUtils.createCustomProfileDir(this.sessionId);
        if (simple) {
            return this.customProfileDir.getAbsolutePath();
        }
        File proxyPAC = LauncherUtils.makeProxyPAC(this.customProfileDir, this.port);
        this.embedKillFirefoxExtension();
        this.embedSeleniumExtension();
        File prefsJS = new File(this.customProfileDir, "prefs.js");
        PrintStream out = new PrintStream(new FileOutputStream(prefsJS));
        out.println("user_pref('browser.shell.checkDefaultBrowser', false);");
        out.println("user_pref('startup.homepage_override_url', '" + homePage + "');");
        out.println("user_pref('browser.allowpopups', true);");
        out.println("user_pref('dom.disable_open_during_load', false);");
        out.println("user_pref('network.proxy.type', 2);");
        out.println("user_pref('network.proxy.autoconfig_url', '" + FirefoxChromeLauncher.pathToBrowserURL(proxyPAC.getAbsolutePath()) + "');");
        out.println("user_pref('security.warn_submit_insecure', false);");
        out.println("user_pref('security.warn_submit_insecure.show_once', false);");
        out.println("user_pref('security.warn_entering_secure', false);");
        out.println("user_pref('security.warn_entering_secure.show_once', false);");
        out.println("user_pref('security.warn_entering_weak', false);");
        out.println("user_pref('security.warn_entering_weak.show_once', false);");
        out.println("user_pref('security.warn_leaving_secure', false);");
        out.println("user_pref('security.warn_leaving_secure.show_once', false);");
        out.println("user_pref('security.warn_viewing_mixed', false);");
        out.println("user_pref('security.warn_viewing_mixed.show_once', false);");
        out.println("user_pref('signon.rememberSignons', false);");
        out.close();
        return this.customProfileDir.getAbsolutePath();
    }

    private void embedKillFirefoxExtension() throws FileNotFoundException, MalformedURLException {
        File extensionDir = new File(this.customProfileDir, "extensions/{538F0036-F358-4f84-A764-89FB437166B4}");
        extensionDir.mkdirs();
        File killHTML = new File(this.customProfileDir, "kill.html");
        PrintStream out = new PrintStream(new FileOutputStream(killHTML));
        out.println("<html><body>Firefox should die immediately upon viewing this!  If you're reading this, there must be a bug!");
        out.println("<script src=\"chrome://global/content/globalOverlay.js\"></script>");
        out.println("");
        out.println("<script>");
        out.println("goQuitApplication();");
        out.println("</script>  ");
        out.println("</body></html>");
        out.close();
        File installRDF = new File(extensionDir, "install.rdf");
        out = new PrintStream(new FileOutputStream(installRDF));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<RDF xmlns=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"");
        out.println("     xmlns:em=\"http://www.mozilla.org/2004/em-rdf#\">");
        out.println("");
        out.println("    <Description about=\"urn:mozilla:install-manifest\">");
        out.println("        <em:id>{538F0036-F358-4f84-A764-89FB437166B4}</em:id>");
        out.println("        <em:type>2</em:type>");
        out.println("        <em:name>KillFF</em:name>");
        out.println("        <em:version>1.0</em:version>");
        out.println("        <em:description>Provides a chrome URL that can kill the browser</em:description>");
        out.println("");
        out.println("        <!-- Firefox -->");
        out.println("        <em:targetApplication>");
        out.println("            <Description>");
        out.println("                <em:id>{ec8030f7-c20a-464f-9b0e-13a3a9e97384}</em:id>");
        out.println("                <em:minVersion>1.4.1</em:minVersion>");
        out.println("                <em:maxVersion>1.6</em:maxVersion>");
        out.println("            </Description>");
        out.println("        </em:targetApplication>");
        out.println("");
        out.println("    </Description>");
        out.println("</RDF>");
        out.close();
        File chromeManifest = new File(extensionDir, "chrome.manifest");
        out = new PrintStream(new FileOutputStream(chromeManifest));
        out.print("content\tkillff\t");
        out.println(killHTML.toURL());
        out.close();
    }

    private void embedSeleniumExtension() throws FileNotFoundException, MalformedURLException {
        String guid = "{503A0CD4-EDC8-489b-853B-19E0BAA8F0A4}";
        File extensionDir = new File(this.customProfileDir, "extensions/" + guid);
        File htmlDir = new File(extensionDir, "chrome");
        htmlDir.mkdirs();
        LauncherUtils.extractHTAFile(htmlDir, this.port, "/core/TestRunner.html", "TestRunner.html");
        LauncherUtils.extractHTAFile(htmlDir, this.port, "/core/SeleneseRunner.html", "SeleneseRunner.html");
        File installRDF = new File(extensionDir, "install.rdf");
        PrintStream out = new PrintStream(new FileOutputStream(installRDF));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<RDF xmlns=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"");
        out.println("     xmlns:em=\"http://www.mozilla.org/2004/em-rdf#\">");
        out.println("");
        out.println("    <Description about=\"urn:mozilla:install-manifest\">");
        out.println("        <em:id>" + guid + "</em:id>");
        out.println("        <em:type>2</em:type>");
        out.println("        <em:name>Selenium RC Runner</em:name>");
        out.println("        <em:version>1.0</em:version>");
        out.println("        <em:description>Provides a chrome URL that can accept commands from Selenium Remote Control</em:description>");
        out.println("");
        out.println("        <!-- Firefox -->");
        out.println("        <em:targetApplication>");
        out.println("            <Description>");
        out.println("                <em:id>{ec8030f7-c20a-464f-9b0e-13a3a9e97384}</em:id>");
        out.println("                <em:minVersion>1.4.1</em:minVersion>");
        out.println("                <em:maxVersion>1.6</em:maxVersion>");
        out.println("            </Description>");
        out.println("        </em:targetApplication>");
        out.println("");
        out.println("    </Description>");
        out.println("</RDF>");
        out.close();
        File chromeManifest = new File(extensionDir, "chrome.manifest");
        out = new PrintStream(new FileOutputStream(chromeManifest));
        out.print("content\tsrc\t");
        out.println(htmlDir.toURL());
        out.close();
    }

    public void close() {
        if (this.closed) {
            return;
        }
        System.out.println("Killing Firefox...");
        Throwable taskKillException = null;
        FileLockRemainedException fileLockException = null;
        this.process.destroy();
        int exitValue = AsyncExecute.waitForProcessDeath(this.process, 10000L);
        if (exitValue == 0) {
            System.err.println("WARNING: Firefox seems to have ended on its own (did we kill the real browser???)");
        }
        try {
            this.waitForFileLockToGoAway(0L, 500L);
        }
        catch (FileLockRemainedException e1) {
            fileLockException = e1;
        }
        try {
            LauncherUtils.deleteTryTryAgain(this.customProfileDir, 6);
        }
        catch (RuntimeException e) {
            if (taskKillException != null || fileLockException != null) {
                e.printStackTrace();
                System.err.print("Perhaps caused by: ");
                if (taskKillException != null) {
                    taskKillException.printStackTrace();
                }
                if (fileLockException != null) {
                    fileLockException.printStackTrace();
                }
                throw new RuntimeException("Couldn't delete custom Firefox profile directory, presumably because task kill failed; see stderr!", e);
            }
            throw e;
        }
        this.closed = true;
    }

    private void waitForFileLockToGoAway(long timeout, long timeToWait) throws FileLockRemainedException {
        File lock = new File(this.customProfileDir, "parent.lock");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            AsyncExecute.sleepTight(500L);
            if (lock.exists() || !this.makeSureFileLockRemainsGone(lock, timeToWait)) continue;
            return;
        }
        if (lock.exists()) {
            throw new FileLockRemainedException("Lock file still present! " + lock.getAbsolutePath());
        }
    }

    private boolean makeSureFileLockRemainsGone(File lock, long timeToWait) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeToWait) {
            AsyncExecute.sleepTight(500L);
            if (!lock.exists()) continue;
            return false;
        }
        return !lock.exists();
    }

    private void waitForFullProfileToBeCreated(long timeout) {
        File testFile = new File(this.customProfileDir, "extensions.ini");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            AsyncExecute.sleepTight(500L);
            if (!testFile.exists()) continue;
        }
        if (!testFile.exists()) {
            throw new RuntimeException("Timed out waiting for profile to be created!");
        }
        long subTimeout = timeout - (System.currentTimeMillis() - start);
        try {
            this.waitForFileLockToGoAway(subTimeout, 500L);
        }
        catch (FileLockRemainedException e) {
            throw new RuntimeException("Firefox refused shutdown while preparing a profile", e);
        }
    }

    public void launchHTMLSuite(String suiteUrl, String browserURL) {
        this.launch("http://localhost:" + this.port + "/selenium-server/core/TestRunner.html?auto=true&resultsUrl=http://localhost:" + this.port + "/selenium-server/postResults&test=" + suiteUrl, "TestRunner.html");
    }

    public void launchRemoteSession(String browserURL) {
        this.launch(LauncherUtils.getDefaultRemoteSessionUrl(browserURL, this.sessionId), "SeleneseRunner.html");
    }

    private class FileLockRemainedException
    extends Exception {
        FileLockRemainedException(String message) {
            super(message);
        }
    }
}

