#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_SPVM__Time__Info__sec = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Time__Info__sec = -1;
static int32_t FIELD_ID_SPVM__Time__Info__min = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Time__Info__min = -1;
static int32_t FIELD_ID_SPVM__Time__Info__hour = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Time__Info__hour = -1;
static int32_t FIELD_ID_SPVM__Time__Info__mday = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Time__Info__mday = -1;
static int32_t FIELD_ID_SPVM__Time__Info__mon = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Time__Info__mon = -1;
static int32_t FIELD_ID_SPVM__Time__Info__year = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Time__Info__year = -1;
// Sub id declarations
static int32_t SUB_ID_SPVM__Time__gmtime = - 1;
static int32_t SUB_ID_SPVM__Time__localtime = - 1;
static int32_t SUB_ID_SPVM__Time__strptime = - 1;
static int32_t SUB_ID_SPVM__Time__strftime = - 1;
static int32_t SUB_ID_SPVM__Time__Info__sec = - 1;
static int32_t SUB_ID_SPVM__Time__Info__min = - 1;
static int32_t SUB_ID_SPVM__Time__Info__hour = - 1;
static int32_t SUB_ID_SPVM__Time__Info__mday = - 1;
static int32_t SUB_ID_SPVM__Time__Info__mon = - 1;
static int32_t SUB_ID_SPVM__Time__Info__year = - 1;
static int32_t SUB_ID_SPVM__Time__time = - 1;
static int32_t SUB_ID_SPVM__Time__timegm = - 1;
static int32_t SUB_ID_SPVM__Time__timelocal = - 1;
// Basic type id declarations
// Function Declarations
// [SIG]SPVM::Time::Info(long)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Time__test_gmtime(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]SPVM::Time::Info(long)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Time__test_localtime(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Time__test_strftime(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Time__test_strptime(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Time__test_time(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Time__test_timegm(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Time__test_timelocal(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Time__test_gmtime(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[1];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  long_vars[0] = *(int64_t*)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_ARG_LONG
  *(int64_t*)&stack[0] = long_vars[0];
L3: // CALL_SUB_OBJECT
  // SPVM::Time->gmtime
  {
    if (SUB_ID_SPVM__Time__gmtime < 0) {
      SUB_ID_SPVM__Time__gmtime = env->get_sub_id(env, "SPVM::Time", "gmtime", "SPVM::Time::Info(long)");
      if (SUB_ID_SPVM__Time__gmtime < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Time gmtime");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Time__gmtime;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_gmtime";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 17;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L9;
  }
L5: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L9;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L8: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L9;
L9: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L10: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Time__test_localtime(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[1];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  long_vars[0] = *(int64_t*)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_ARG_LONG
  *(int64_t*)&stack[0] = long_vars[0];
L3: // CALL_SUB_OBJECT
  // SPVM::Time->localtime
  {
    if (SUB_ID_SPVM__Time__localtime < 0) {
      SUB_ID_SPVM__Time__localtime = env->get_sub_id(env, "SPVM::Time", "localtime", "SPVM::Time::Info(long)");
      if (SUB_ID_SPVM__Time__localtime < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Time localtime");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Time__localtime;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_localtime";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 11;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L9;
  }
L5: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L9;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L8: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L9;
L9: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L10: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Time__test_strftime(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x32\x30\x31\x39\x2D\x30\x33\x2D\x32\x35\x20\x31\x32\x3A\x35\x31\x3A\x33\x37\x20\x47\x4D\x54", 23));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x25\x59\x2D\x25\x6D\x2D\x25\x64\x20\x25\x48\x3A\x25\x4D\x3A\x25\x53\x20\x47\x4D\x54", 21));
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L8: // CALL_SUB_OBJECT
  // SPVM::Time->strptime
  {
    if (SUB_ID_SPVM__Time__strptime < 0) {
      SUB_ID_SPVM__Time__strptime = env->get_sub_id(env, "SPVM::Time", "strptime", "SPVM::Time::Info(string,string)");
      if (SUB_ID_SPVM__Time__strptime < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Time strptime");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Time__strptime;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_strftime";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 55;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L11: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L13: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x25\x59\x2D\x25\x6D\x2D\x25\x64\x20\x25\x48\x3A\x25\x4D\x3A\x25\x53\x20\x47\x4D\x54", 21));
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L15: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L16: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L17: // CALL_SUB_OBJECT
  // SPVM::Time->strftime
  {
    if (SUB_ID_SPVM__Time__strftime < 0) {
      SUB_ID_SPVM__Time__strftime = env->get_sub_id(env, "SPVM::Time", "strftime", "string(string,SPVM::Time::Info)");
      if (SUB_ID_SPVM__Time__strftime < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Time strftime");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Time__strftime;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_strftime";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 57;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L19: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L21: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x32\x30\x31\x39\x2D\x30\x33\x2D\x32\x35\x20\x31\x32\x3A\x35\x31\x3A\x33\x37\x20\x47\x4D\x54", 23));
L22: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_strftime";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L29: // GOTO
  goto L30;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L37: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Time__test_strptime(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x32\x30\x31\x39\x2D\x30\x33\x2D\x32\x35\x20\x31\x32\x3A\x35\x31\x3A\x33\x37\x20\x47\x4D\x54", 23));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x25\x59\x2D\x25\x6D\x2D\x25\x64\x20\x25\x48\x3A\x25\x4D\x3A\x25\x53\x20\x47\x4D\x54", 21));
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L8: // CALL_SUB_OBJECT
  // SPVM::Time->strptime
  {
    if (SUB_ID_SPVM__Time__strptime < 0) {
      SUB_ID_SPVM__Time__strptime = env->get_sub_id(env, "SPVM::Time", "strptime", "SPVM::Time::Info(string,string)");
      if (SUB_ID_SPVM__Time__strptime < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Time strptime");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Time__strptime;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_strptime";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 25;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L11: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L12: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Time__Info__sec < 0, 0)) {
      FIELD_ID_SPVM__Time__Info__sec = env->get_field_id(env, "SPVM::Time::Info", "sec", "int");
      if (FIELD_ID_SPVM__Time__Info__sec < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Time::Info sec");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Time__Info__sec = env->get_field_offset(env, FIELD_ID_SPVM__Time__Info__sec);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Time__Info__sec);
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_strptime";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 27;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L14: // MOVE_CONSTANT_INT
  int_vars[3] = 37;
L15: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L71;
L20: // GOTO
  goto L21;
L21: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Time__Info__min < 0, 0)) {
      FIELD_ID_SPVM__Time__Info__min = env->get_field_id(env, "SPVM::Time::Info", "min", "int");
      if (FIELD_ID_SPVM__Time__Info__min < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Time::Info min");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Time__Info__min = env->get_field_offset(env, FIELD_ID_SPVM__Time__Info__min);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Time__Info__min);
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_strptime";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[5] = 51;
L24: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L71;
L29: // GOTO
  goto L30;
L30: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Time__Info__hour < 0, 0)) {
      FIELD_ID_SPVM__Time__Info__hour = env->get_field_id(env, "SPVM::Time::Info", "hour", "int");
      if (FIELD_ID_SPVM__Time__Info__hour < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Time::Info hour");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Time__Info__hour = env->get_field_offset(env, FIELD_ID_SPVM__Time__Info__hour);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Time__Info__hour);
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_strptime";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 33;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[5] = 12;
L33: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_NE_ZERO
  if (int_vars[0]) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L71;
L38: // GOTO
  goto L39;
L39: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Time__Info__mday < 0, 0)) {
      FIELD_ID_SPVM__Time__Info__mday = env->get_field_id(env, "SPVM::Time::Info", "mday", "int");
      if (FIELD_ID_SPVM__Time__Info__mday < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Time::Info mday");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Time__Info__mday = env->get_field_offset(env, FIELD_ID_SPVM__Time__Info__mday);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Time__Info__mday);
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_strptime";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 36;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[5] = 25;
L42: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L43: // BOOL_INT
  int_vars[0] = int_vars[0];
L44: // IF_NE_ZERO
  if (int_vars[0]) { goto L48; }
L45: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L71;
L47: // GOTO
  goto L48;
L48: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Time__Info__mon < 0, 0)) {
      FIELD_ID_SPVM__Time__Info__mon = env->get_field_id(env, "SPVM::Time::Info", "mon", "int");
      if (FIELD_ID_SPVM__Time__Info__mon < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Time::Info mon");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Time__Info__mon = env->get_field_offset(env, FIELD_ID_SPVM__Time__Info__mon);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Time__Info__mon);
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_strptime";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 40;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L51: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_NE_ZERO
  if (int_vars[0]) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L71;
L56: // GOTO
  goto L57;
L57: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Time__Info__year < 0, 0)) {
      FIELD_ID_SPVM__Time__Info__year = env->get_field_id(env, "SPVM::Time::Info", "year", "int");
      if (FIELD_ID_SPVM__Time__Info__year < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Time::Info year");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Time__Info__year = env->get_field_offset(env, FIELD_ID_SPVM__Time__Info__year);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Time__Info__year);
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_strptime";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 44;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L59: // MOVE_CONSTANT_INT
  int_vars[5] = 119;
L60: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_NE_ZERO
  if (int_vars[0]) { goto L66; }
L63: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L64: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L71;
L65: // GOTO
  goto L66;
L66: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L67: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L68: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L71;
L69: // INIT_INT
  int_vars[6] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L71;
L71: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L72: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Time__test_time(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_LONG
  // SPVM::Time->time
  {
    if (SUB_ID_SPVM__Time__time < 0) {
      SUB_ID_SPVM__Time__time = env->get_sub_id(env, "SPVM::Time", "time", "long()");
      if (SUB_ID_SPVM__Time__time < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Time time");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Time__time;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_time";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 5;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L6;
  }
L3: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L6;
L4: // INIT_LONG
  long_vars[1] = 0;
L5: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L6;
L6: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Time__test_timegm(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_LONG
  // SPVM::Time->time
  {
    if (SUB_ID_SPVM__Time__time < 0) {
      SUB_ID_SPVM__Time__time = env->get_sub_id(env, "SPVM::Time", "time", "long()");
      if (SUB_ID_SPVM__Time__time < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Time time");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Time__time;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_timegm";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 88;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_LONG
  *(int64_t*)&stack[0] = long_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Time->gmtime
  {
    if (SUB_ID_SPVM__Time__gmtime < 0) {
      SUB_ID_SPVM__Time__gmtime = env->get_sub_id(env, "SPVM::Time", "gmtime", "SPVM::Time::Info(long)");
      if (SUB_ID_SPVM__Time__gmtime < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Time gmtime");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Time__gmtime;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_timegm";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 90;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L7: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L8: // CALL_SUB_LONG
  // SPVM::Time->timegm
  {
    if (SUB_ID_SPVM__Time__timegm < 0) {
      SUB_ID_SPVM__Time__timegm = env->get_sub_id(env, "SPVM::Time", "timegm", "long(SPVM::Time::Info)");
      if (SUB_ID_SPVM__Time__timegm < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Time timegm");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Time__timegm;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_timegm";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 92;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // BOOL_INT
  int_vars[0] = int_vars[2];
L12: // MOVE_INT
  int_vars[0] = int_vars[0];
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_NE_ZERO
  if (int_vars[0]) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L17: // GOTO
  goto L18;
L18: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L23: // GOTO
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L29;
L27: // INIT_INT
  int_vars[6] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L29;
L29: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L30: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Time__test_timelocal(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_LONG
  // SPVM::Time->time
  {
    if (SUB_ID_SPVM__Time__time < 0) {
      SUB_ID_SPVM__Time__time = env->get_sub_id(env, "SPVM::Time", "time", "long()");
      if (SUB_ID_SPVM__Time__time < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Time time");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Time__time;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_timelocal";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 69;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_LONG
  *(int64_t*)&stack[0] = long_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Time->localtime
  {
    if (SUB_ID_SPVM__Time__localtime < 0) {
      SUB_ID_SPVM__Time__localtime = env->get_sub_id(env, "SPVM::Time", "localtime", "SPVM::Time::Info(long)");
      if (SUB_ID_SPVM__Time__localtime < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Time localtime");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Time__localtime;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_timelocal";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 71;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L7: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L8: // CALL_SUB_LONG
  // SPVM::Time->timelocal
  {
    if (SUB_ID_SPVM__Time__timelocal < 0) {
      SUB_ID_SPVM__Time__timelocal = env->get_sub_id(env, "SPVM::Time", "timelocal", "long(SPVM::Time::Info)");
      if (SUB_ID_SPVM__Time__timelocal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Time timelocal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Time__timelocal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Time";
    const char* sub_name = "test_timelocal";
    const char* file = "TestCase/Lib/SPVM/Time.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // BOOL_INT
  int_vars[0] = int_vars[2];
L12: // MOVE_INT
  int_vars[0] = int_vars[0];
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_NE_ZERO
  if (int_vars[0]) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L17: // GOTO
  goto L18;
L18: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L23: // GOTO
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L29;
L27: // INIT_INT
  int_vars[6] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L29;
L29: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L30: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


