#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
static int32_t VAR_PACKAGE_VAR_ID_TestCase__Callback__var_prec = -1;
// Field id and index declarations
static int32_t FIELD_ID_TestCase__Minimal__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Minimal__x = -1;
static int32_t FIELD_ID_anon0__capture1 = -1;
static int32_t FIELD_BYTE_OFFSET_anon0__capture1 = -1;
static int32_t FIELD_ID_anon0__capture2 = -1;
static int32_t FIELD_BYTE_OFFSET_anon0__capture2 = -1;
static int32_t FIELD_ID_anon1__var_prec = -1;
static int32_t FIELD_BYTE_OFFSET_anon1__var_prec = -1;
// Sub id declarations
static int32_t SUB_ID_TestCase__Minimal__new = - 1;
static int32_t SUB_ID_TestCase__Callback__ImplementCallback1__new = - 1;
static int32_t SUB_ID_TestCase__Callback__ImplementCallback2__new = - 1;
static int32_t SUB_ID_TestCase__Callback__Callback__ = - 1;
static int32_t SUB_ID_anon0__ = - 1;
static int32_t SUB_ID_anon1__ = - 1;
static int32_t SUB_ID_TestCase__Callback__sort_obj = - 1;
static int32_t SUB_ID_SPVM__Comparator__ = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_TestCase__Minimal = -1;
static int32_t BASIC_TYPE_ID_anon0 = -1;
static int32_t BASIC_TYPE_ID_anon1 = -1;
static int32_t BASIC_TYPE_ID_anon2 = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Callback__basic(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Callback__capture(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Callback__capture_var_high_precidence_than_package_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Callback__comparator(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]void(oarray,SPVM::Comparator)
int32_t SPPRECOMPILE__TestCase__Callback__sort_obj(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Callback__basic(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[4] = {0};
  int64_t long_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "basic";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 101;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // CALL_SUB_OBJECT
  // TestCase::Callback::ImplementCallback1->new
  {
    if (SUB_ID_TestCase__Callback__ImplementCallback1__new < 0) {
      SUB_ID_TestCase__Callback__ImplementCallback1__new = env->get_sub_id(env, "TestCase::Callback::ImplementCallback1", "new", "TestCase::Callback::ImplementCallback1()");
      if (SUB_ID_TestCase__Callback__ImplementCallback1__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Callback::ImplementCallback1 new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Callback__ImplementCallback1__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "basic";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 102;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // CALL_SUB_OBJECT
  // TestCase::Callback::ImplementCallback2->new
  {
    if (SUB_ID_TestCase__Callback__ImplementCallback2__new < 0) {
      SUB_ID_TestCase__Callback__ImplementCallback2__new = env->get_sub_id(env, "TestCase::Callback::ImplementCallback2", "new", "TestCase::Callback::ImplementCallback2()");
      if (SUB_ID_TestCase__Callback__ImplementCallback2__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Callback::ImplementCallback2 new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Callback__ImplementCallback2__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "basic";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 103;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L12: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L13: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L14: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L15: // PUSH_ARG_LONG
  *(int64_t*)&stack[2] = long_vars[0];
L16: // CALL_METHOD_INT
  // TestCase::Callback::Callback->
  {
    void* object = object_vars[1];
    int32_t call_sub_id = env->get_method_sub_id(env, object, "", "int(self,int,long)");
    if (call_sub_id == 0) {
      void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Callback::Callback ");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "basic";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L21: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L22: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L23: // PUSH_ARG_LONG
  *(int64_t*)&stack[2] = long_vars[0];
L24: // CALL_METHOD_INT
  // TestCase::Callback::Callback->
  {
    void* object = object_vars[2];
    int32_t call_sub_id = env->get_method_sub_id(env, object, "", "int(self,int,long)");
    if (call_sub_id == 0) {
      void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Callback::Callback ");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "basic";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 106;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L27: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "basic";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 108;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L30: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[3];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[2];
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "basic";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 109;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L33: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L51; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L37: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L50; }
L40: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[3];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "basic";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 113;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L43: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L49; }
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L53;
L48: // GOTO
  goto L49;
L49: // GOTO
  goto L50;
L50: // GOTO
  goto L51;
L51: // INIT_INT
  int_vars[6] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L53;
L53: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L54: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Callback__capture(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 7;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 10;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon0 < 0) {
      BASIC_TYPE_ID_anon0 = env->get_basic_type_id(env, "anon0");
      if (BASIC_TYPE_ID_anon0 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon0");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon0;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_anon0__capture1 < 0, 0)) {
      FIELD_ID_anon0__capture1 = env->get_field_id(env, "anon0", "capture1", "int");
      if (FIELD_ID_anon0__capture1 < 0) {
        void* exception = env->new_string_raw(env, "Field not found anon0 capture1");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_anon0__capture1 = env->get_field_offset(env, FIELD_ID_anon0__capture1);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_anon0__capture1) = int_vars[1];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "capture";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 16;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L7: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_anon0__capture2 < 0, 0)) {
      FIELD_ID_anon0__capture2 = env->get_field_id(env, "anon0", "capture2", "int");
      if (FIELD_ID_anon0__capture2 < 0) {
        void* exception = env->new_string_raw(env, "Field not found anon0 capture2");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_anon0__capture2 = env->get_field_offset(env, FIELD_ID_anon0__capture2);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_anon0__capture2) = int_vars[3];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "capture";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 16;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L10: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L11: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L13: // CALL_SUB_INT
  // anon0->
  {
    if (SUB_ID_anon0__ < 0) {
      SUB_ID_anon0__ = env->get_sub_id(env, "anon0", "", "int(self)");
      if (SUB_ID_anon0__ < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found anon0 ");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_anon0__;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "capture";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 23;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 17;
L16: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L26;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L26;
L24: // INIT_INT
  int_vars[9] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L26;
L26: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L27: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Callback__capture_var_high_precidence_than_package_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 13;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon1 < 0) {
      BASIC_TYPE_ID_anon1 = env->get_basic_type_id(env, "anon1");
      if (BASIC_TYPE_ID_anon1 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon1");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon1;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L4: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_anon1__var_prec < 0, 0)) {
      FIELD_ID_anon1__var_prec = env->get_field_id(env, "anon1", "var_prec", "int");
      if (FIELD_ID_anon1__var_prec < 0) {
        void* exception = env->new_string_raw(env, "Field not found anon1 var_prec");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_anon1__var_prec = env->get_field_offset(env, FIELD_ID_anon1__var_prec);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_anon1__var_prec) = int_vars[1];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "capture_var_high_precidence_than_package_var";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 35;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L8: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L9: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L10: // CALL_SUB_INT
  // anon1->
  {
    if (SUB_ID_anon1__ < 0) {
      SUB_ID_anon1__ = env->get_sub_id(env, "anon1", "", "int(self)");
      if (SUB_ID_anon1__ < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found anon1 ");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_anon1__;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "capture_var_high_precidence_than_package_var";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 40;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 13;
L13: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L23;
L21: // INIT_INT
  int_vars[7] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Callback__comparator(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[12];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon2 < 0) {
      BASIC_TYPE_ID_anon2 = env->get_basic_type_id(env, "anon2");
      if (BASIC_TYPE_ID_anon2 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon2");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon2;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 83;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 84;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 84;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L13: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L17: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 85;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L19: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[2];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 85;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L23: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 86;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L26: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 86;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L31: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L32: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 87;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L34: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[2];
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 87;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L36: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L38: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 88;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L41: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 88;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L43: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L45: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L46: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L47: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 89;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L49: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[2];
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 89;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L52: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L53: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L54: // CALL_SUB_VOID
  // TestCase::Callback->sort_obj
  {
    if (SUB_ID_TestCase__Callback__sort_obj < 0) {
      SUB_ID_TestCase__Callback__sort_obj = env->get_sub_id(env, "TestCase::Callback", "sort_obj", "void(oarray,SPVM::Comparator)");
      if (SUB_ID_TestCase__Callback__sort_obj < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Callback sort_obj");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Callback__sort_obj;
    exception_flag = SPPRECOMPILE__TestCase__Callback__sort_obj(env, stack);
    if (!exception_flag) {
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L57: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L58: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 93;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L60: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 93;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L62: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L63: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L66: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L69: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 93;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L71: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 93;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L73: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L74: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L75: // BOOL_INT
  int_vars[0] = int_vars[0];
L76: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L81; }
L77: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L78: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L79: // BOOL_INT
  int_vars[0] = int_vars[2];
L80: // GOTO
  goto L83;
L81: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L82: // BOOL_INT
  int_vars[0] = int_vars[3];
L83: // GOTO
  goto L87;
L84: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L85: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L86: // BOOL_INT
  int_vars[0] = int_vars[4];
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L106; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L90: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L91: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 93;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L93: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L94: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "comparator";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 93;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L95: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L96: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L97: // BOOL_INT
  int_vars[0] = int_vars[0];
L98: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L103; }
L99: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L100: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L101: // BOOL_INT
  int_vars[0] = int_vars[2];
L102: // GOTO
  goto L105;
L103: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L104: // BOOL_INT
  int_vars[0] = int_vars[3];
L105: // GOTO
  goto L109;
L106: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L107: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L108: // BOOL_INT
  int_vars[0] = int_vars[4];
L109: // BOOL_INT
  int_vars[0] = int_vars[0];
L110: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L114; }
L111: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L112: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L119;
L113: // GOTO
  goto L114;
L114: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L115: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L116: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L119;
L117: // INIT_INT
  int_vars[6] = 0;
L118: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L119;
L119: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L120: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Callback__sort_obj(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[4] = {0};
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[9];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }
  object_vars[1] = *(void**)&stack[1];
  if (object_vars[1] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[1]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[1] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "sort_obj";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 49;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // SUBTRACT_INT
  int_vars[3] = int_vars[1] - int_vars[2];
L7: // GOTO
  goto L74;
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // GOTO
  goto L66;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "sort_obj";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // ADD_INT
  int_vars[5] = int_vars[2] + int_vars[4];
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L16: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object); 
      } 
    } 
  } 
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "sort_obj";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L18: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L20: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[3];
L21: // CALL_METHOD_INT
  // SPVM::Comparator->
  {
    void* object = object_vars[1];
    int32_t call_sub_id = env->get_method_sub_id(env, object, "", "int(self,object,object)");
    if (call_sub_id == 0) {
      void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Comparator ");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "sort_obj";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L26: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "sort_obj";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 54;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L29: // ADD_INT
  int_vars[5] = int_vars[2] + int_vars[4];
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L31: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object); 
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "sort_obj";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 54;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L34: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L35: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[3];
L36: // CALL_METHOD_INT
  // SPVM::Comparator->
  {
    void* object = object_vars[1];
    int32_t call_sub_id = env->get_method_sub_id(env, object, "", "int(self,object,object)");
    if (call_sub_id == 0) {
      void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Comparator ");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "sort_obj";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 54;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L38: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L39: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[8]);
L40: // BOOL_INT
  int_vars[0] = int_vars[0];
L41: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L60; }
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L43: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L44: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L45: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "sort_obj";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 55;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L48: // ADD_INT
  int_vars[5] = int_vars[2] + int_vars[4];
L49: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L50: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object); 
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "sort_obj";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 56;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L52: // ARRAY_STORE_OBJECT_CHECK_TYPE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        void* object = object_vars[3];
        int32_t is_valid;
        if (object == NULL) {
          is_valid = 1;
        }
        else {
          int32_t array_basic_type_id = *(int32_t*)((intptr_t)array + (intptr_t)env->object_basic_type_id_offset);
          int32_t array_type_dimension = *(uint8_t*)((intptr_t)array + (intptr_t)env->object_type_dimension_offset);
          int32_t element_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
          int32_t element_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
          if (array_basic_type_id == element_basic_type_id && array_type_dimension == element_type_dimension + 1) {
            is_valid = 1;
          }
          else {
            is_valid = 0;
          }
        }
        if (is_valid) {
          SPVM_RUNTIME_API_OBJECT_ASSIGN(element_address, object);
        }
        else {
          void* exception = env->new_string_raw(env, "Element type is invalid");
          env->set_exception(env, exception);
          exception_flag = 1;
        }      }
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "sort_obj";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 56;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L54: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L56: // ADD_INT
  int_vars[5] = int_vars[2] + int_vars[4];
L57: // ARRAY_STORE_OBJECT_CHECK_TYPE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        void* object = object_vars[2];
        int32_t is_valid;
        if (object == NULL) {
          is_valid = 1;
        }
        else {
          int32_t array_basic_type_id = *(int32_t*)((intptr_t)array + (intptr_t)env->object_basic_type_id_offset);
          int32_t array_type_dimension = *(uint8_t*)((intptr_t)array + (intptr_t)env->object_type_dimension_offset);
          int32_t element_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
          int32_t element_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
          if (array_basic_type_id == element_basic_type_id && array_type_dimension == element_type_dimension + 1) {
            is_valid = 1;
          }
          else {
            is_valid = 0;
          }
        }
        if (is_valid) {
          SPVM_RUNTIME_API_OBJECT_ASSIGN(element_address, object);
        }
        else {
          void* exception = env->new_string_raw(env, "Element type is invalid");
          env->set_exception(env, exception);
          exception_flag = 1;
        }      }
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Callback";
    const char* sub_name = "sort_obj";
    const char* file = "TestCase/Callback.spvm";
    int32_t line = 57;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L59: // GOTO
  goto L61;
L60: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L61: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L62: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L63: // MOVE_INT
  int_vars[4] = int_vars[2];
L64: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L65: // ADD_INT
  int_vars[2] = int_vars[4] + int_vars[5];
L66: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L67: // BOOL_INT
  int_vars[0] = int_vars[0];
L68: // IF_NE_ZERO
  if (int_vars[0]) { goto L10; }
L69: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L70: // MOVE_INT
  int_vars[2] = int_vars[3];
L71: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L72: // SUBTRACT_INT
  int_vars[3] = int_vars[2] - int_vars[5];
L73: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L74: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L75: // GT_INT
  int_vars[0] = (int_vars[3] > int_vars[2]);
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_NE_ZERO
  if (int_vars[0]) { goto L8; }
L78: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L79: // RETURN_VOID
  goto L80;
L80: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L81: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


