package Boxer::Types;

use 5.010;
use strictures 1;
use utf8;

use Type::Library -base,
	-declare => qw( DataDir ClassDir NodeDir SkelDir Suite );
use Type::Utils -all;
use Types::Path::Tiny qw(Dir);
use Types::Common::String qw(LowerCaseSimpleStr);

use Role::Commons -all;

our $AUTHORITY = 'cpan:JONASS';
our $VERSION = 'v1.1.3';

declare DataDir, as Dir, coercion => 1, message {
	'Must be an existing directory containing directories for boxer classes and/or boxer nodes';
};

declare ClassDir, as Dir,
	coercion => 1,
	message {'Must be an existing directory containing boxer classes'};

declare NodeDir, as Dir,
	coercion => 1,
	message {'Must be an existing directory containing boxer nodes'};

declare SkelDir, as Dir,
	coercion => 1,
	message {'Must be an existing directory containing boxer skeleton files'};

declare Suite, as LowerCaseSimpleStr,
	coercion => 1,
	message {'Must be a single lowercase word'};

1
