#-----------------------------------------------------------------------------
# 01write.t	OpenOffice::OODoc 1.108 Installation test	(c) GENICORP
#-----------------------------------------------------------------------------

use Test;
BEGIN	{ plan tests => 17 }

use XML::XPath		1.13;
ok(1);
use Archive::Zip	1.05	qw ( :DEFAULT :CONSTANTS :ERROR_CODES );
ok(1);

use OpenOffice::OODoc	1.108;
ok(1);

#-----------------------------------------------------------------------------

my $testfile	= "ootest.sxw";
my $imagefile	= 'data/scarab.png';

# Creating an empty new OpenOffice.org file using Archive::Zip
my $zipfile	= Archive::Zip->new;
foreach my $file (glob("data/mimetype data/*.xml data/*/*.xml"))
	{
	$file =~ /data\/(.*)/;
	my $membername = $1;
	my $member = $zipfile->addFile($file, $membername);
	unless ($membername eq 'meta.xml')
		{
		$member->desiredCompressionMethod
			(COMPRESSION_DEFLATED);
		$member->desiredCompressionLevel
			(COMPRESSION_LEVEL_BEST_COMPRESSION);
		}
	else
		{
		$member->desiredCompressionMethod
			(COMPRESSION_STORED);
		}
	}
die "Archive::Zip error\n"
	unless $zipfile->writeToFileNamed($testfile) == AZ_OK;
ok(1);

#-----------------------------------------------------------------------------

my $notice	= 
"This OpenOffice.org document has been generated by the OpenOffice::OODoc " .
"installation test. If you can read this paragraph in blue letters with " .
"a yellow background, and if you can see a green scarab at the top of the " .
"page, your installation is probably OK.";

my $generator	= "OpenOffice::OODoc 1.108 installation test";

my $description	= "Generated by $generator";

# Opening the OpenOffice.org file using OpenOffice::OODoc::File
my $archive	= ooFile($testfile)
	or die "Unable to get the test file\n";
ok(1);
# Opening the content using OpenOffice::OODoc::Document
my $doc	= ooDocument(archive => $archive, member => 'content')
	or die "Unable to find a regular OpenOffice.org content\n";
ok(1);

# Creating a graphic style
ok($doc->createImageStyle('Logo'));
# Inserting an image in the document
ok	(
	$doc->createImageElement
		(
		"Logo",
		style		=> 'Logo',
		page		=> 1,
		position	=> '2cm, 2cm',
		size		=> '2cm, 2.824cm',
		import		=> $imagefile
		)
	);

# Appending a paragraph
ok	(
	$doc->appendParagraph( text => "File creation date : " . localtime() )
	);
# Appending a level 1 header
ok	(
	$doc->appendHeader( text => "Congratulations !", level => "1" )
	);
# Creating a coloured paragraph style (blue foreground, yellow background)
ok	(
	$doc->createStyle
		(
		"Colour",
		family		=> 'paragraph',
		parent		=> 'Standard',
		properties	=>
			{
			'fo:color'			=> '#000080',
			'style:text-background-color'	=> '#ffff00'
			}
		)
	);
# Appending another paragraph using the new style
ok	(
	$doc->appendParagraph( text => $notice, style => "Colour" )
	);
# Appending another level 1 header
ok	(
	$doc->appendHeader( text => "Your environment :", level => "1" )
	);
# Appending an item list with 5 elements
$doc->setText
	(
	$doc->appendItemList,
	"Platform : $^O",
	"Perl version : $]",
	"Archive::Zip version : $Archive::Zip::VERSION",
	"XML::XPath version : $XML::XPath::VERSION",
	"OpenOffice::OODoc version : $OpenOffice::OODoc::VERSION"
	);
my $list = $doc->getUnorderedList(0);
my $count = scalar $doc->selectElements($list, 'text:list-item');
ok($count == 5);

# Opening the metadata of the document
my $meta = ooMeta(archive => $archive)
	or die "Unable to find regular OpenOffice.org metadata\n";
ok(1);
# Checking the title of the document
my $title = $meta->title || '';
ok($title eq "Test document");
$meta->description($description);
$meta->generator($generator);

# Saving the $testfile file
ok($archive->save);

exit 0;
