
package Paws::Inspector::LocalizeText;
  use Moose;
  has Locale => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'locale' , required => 1);
  has LocalizedTexts => (is => 'ro', isa => 'ArrayRef[Paws::Inspector::LocalizedText]', traits => ['NameInRequest'], request_name => 'localizedTexts' , required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'LocalizeText');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::Inspector::LocalizeTextResponse');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::Inspector::LocalizeText - Arguments for method LocalizeText on Paws::Inspector

=head1 DESCRIPTION

This class represents the parameters used for calling the method LocalizeText on the 
Amazon Inspector service. Use the attributes of this class
as arguments to method LocalizeText.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to LocalizeText.

As an example:

  $service_obj->LocalizeText(Att1 => $value1, Att2 => $value2, ...);

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Locale => Str

The locale that you want to translate a textual identifier into.



=head2 B<REQUIRED> LocalizedTexts => ArrayRef[L<Paws::Inspector::LocalizedText>]

A list of textual identifiers.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method LocalizeText in L<Paws::Inspector>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: https://github.com/pplu/aws-sdk-perl

Please report bugs to: https://github.com/pplu/aws-sdk-perl/issues

=cut

