use Test::More;
use Test::Mojo;
use Mojolicious::Lite;
use Mojo::Facebook;

my $t = Test::Mojo->new('main');
my($fb, $tx);

post '/me/feed' => sub { shift->render_json({ id => 1234 }) };

{ # post
    $fb = Mojo::Facebook->new(_url => '/', _ua => $t->ua);
    my($message, $tags) = $fb->_message_to_tags('@[289459768534:Some person] did some cool stuff with @[1234567891:Some other person] yey!');

    is($message, 'Some person did some cool stuff with Some other person yey!', '@[...] was removed from message');
    is_deeply($tags, [
        {
            id => 289459768534,
            name => 'Some person',
            offset => 0,
            length => 11,
        },
        {
            id => 1234567891,
            name => 'Some other person',
            offset => 37,
            length => 17,
        },
    ], 'tags was created');

    $fb->access_token('secr3t');
    $fb->post({
        to => 'me',
        message => 'some @[289459768534:cool] message',
        link => 'http://perl.org',
        name => 'Perl',
        caption => 'is ice cool',
        description => 'and what cooler than beeing cool? ice cool',
        picture => 'http://st.pimg.net/perlweb/images/camel_head.v25e738a.png',
    }, sub { $tx = $_[1]->{__tx}; Mojo::IOLoop->stop });

    Mojo::IOLoop->start;
    like($tx->req->url, qr{/me/feed$}, 'correct url');
    like($tx->req->body, qr{access_token=secr3t}, 'got access_token in body');
    like($tx->req->body, qr{message=some\+cool\+message}, 'got message in body');
    like($tx->req->body, qr{link=http.*?perl\.org}, 'got link in body');
    like($tx->req->body, qr{name=Perl}, 'got name in body');
    like($tx->req->body, qr{caption=is\+ice\+cool}, 'got caption in body');
    like($tx->req->body, qr{description=and\+}, 'got description in body');
    like($tx->req->body, qr{picture=http.*?images}, 'got picture in body');

TODO: {
    local $TODO = 'I cannot figure out tagging. The doc is cryptic:/';
    like($tx->req->body, qr{tags=\%5B.*length\%22}, 'tags were added');
}

    delete $tx->res->json->{__tx};
    is_deeply($tx->res->json, { id => 1234 }, 'got id in response');
}

{ # publish
    $fb = Mojo::Facebook->new(_url => '/', _ua => $t->ua);
    $fb->access_token('secr3t');
    $fb->app_namespace('coolestapp');
    $fb->publish({
        to => 'me',
        action => 'cook',
        food => 'http://food.com/dinner/hamburger/story',
        message => 'some @[289459768534:cool] description',
        custom_attr => 123,
    }, sub { $tx = $_[1]->{__tx}; Mojo::IOLoop->stop });

    Mojo::IOLoop->start;
    like($tx->req->url, qr{/me/coolestapp:cook$}, 'correct url');
    like($tx->req->body, qr{access_token=secr3t}, 'got access_token in body');
    like($tx->req->body, qr{food=http.*?hamburger/story}, 'got food in body');
    like($tx->req->body, qr{message=some\+cool\+description}, 'got message in body');
    like($tx->req->body, qr{custom_attr=123}, 'got custom_attr in body');
    like($tx->req->body, qr{tags=289459768534}, 'got tags in body');
}

{ # delete_object
    $fb = Mojo::Facebook->new(_url => '/', _ua => $t->ua, access_token => 'secr3t');
    $fb->delete_object(289459768534, sub { $tx = $_[1]->{__tx}; Mojo::IOLoop->stop });

    Mojo::IOLoop->start;
    like($tx->req->url, qr{/289459768534\?access_token=secr3t$}, 'correct url');
}

if($ENV{TOKEN}) {
    $fb = Mojo::Facebook->new(access_token => $ENV{TOKEN});
    $fb->post('this is just a test @[790975580:Jan] with tags', {
        link => 'http://github.com/jhthorsen',
        name => 'Link to my github page',
        caption => 'This message was generated by Mojo::Facebook',
        description => '...and I will delete this post soon',
        picture => 'https://secure.gravatar.com/avatar/806800a3aeddbad6af673dade958933b',
    }, sub { $tx = $_[1]->{__tx}; Mojo::IOLoop->stop });

    Mojo::IOLoop->start;
    diag $tx->req->url;
    diag $tx->req->body;
    diag $tx->res->error;
    diag $tx->res->body;
    like($tx->res->json->{id}, qr{^\w+$}, 'got post id in return');
}

if($ENV{LIVE}) {
    $fb = Mojo::Facebook->new;
    $fb->fetch({ from => 'billclinton' }, sub { $tx = $_[1]->{__tx}; Mojo::IOLoop->stop });

    Mojo::IOLoop->start;
    is(eval { $tx->res->json->{id} }, '65646572251', 'got response from facebook') or diag Data::Dumper::Dumper($tx->res);
}

done_testing;
