
use strict;
use warnings;

use 5.010;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Translate a ECMAScript source to an AST",
  "AUTHOR" => "Jean-Damien Durand <jeandamiendurand\@free.fr>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "MarpaX-Languages-ECMAScript-AST",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "MarpaX::Languages::ECMAScript::AST",
  "PREREQ_PM" => {
    "CHI" => 0,
    "Carp" => 0,
    "Data::Dumper" => 0,
    "Digest::MD4" => 0,
    "Exception::Class" => 0,
    "Exporter" => 0,
    "File::Basename" => 0,
    "File::HomeDir" => 0,
    "File::Spec" => 0,
    "Log::Any" => 0,
    "Marpa::R2" => "2.074",
    "Module::Util" => 0,
    "SUPER" => 0,
    "constant" => 0,
    "diagnostics" => 0,
    "parent" => 0,
    "strict" => 0,
    "version" => "0.77",
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "File::Spec::Functions" => 0,
    "File::Temp" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "List::Util" => 0,
    "Test::More" => 0
  },
  "VERSION" => "0.005",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "CHI" => 0,
  "Carp" => 0,
  "Data::Dumper" => 0,
  "Digest::MD4" => 0,
  "Exception::Class" => 0,
  "Exporter" => 0,
  "ExtUtils::MakeMaker" => 0,
  "File::Basename" => 0,
  "File::HomeDir" => 0,
  "File::Spec" => 0,
  "File::Spec::Functions" => 0,
  "File::Temp" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "List::Util" => 0,
  "Log::Any" => 0,
  "Marpa::R2" => "2.074",
  "Module::Util" => 0,
  "SUPER" => 0,
  "Test::More" => 0,
  "constant" => 0,
  "diagnostics" => 0,
  "parent" => 0,
  "strict" => 0,
  "version" => "0.77",
  "warnings" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



