#!/usr/bin/env perl

use strict;
use warnings;

use Getopt::Long;
use Data::Dumper;

use File::chdir;
use File::Spec;
use File::Copy qw/copy/;

my $config_file = 'config';
my %clean = ( 
  src => [qw/libdontpanic.so libdontpanic.o/], 
  '.' => [$config_file],
);
my %install = (
  lib     => [qw/libdontpanic.so/],
  include => [qw/libdontpanic.h/],
);

my $prefix = $CWD;
GetOptions(
  'prefix=s' => \$prefix,
);

my $action = shift || 'build';

my $config = _load_options();

$config->{prefix} ||= $prefix;

my $sub = __PACKAGE__->can($action) or die "Unknown action: $action";
$sub->();

sub build {
  local $CWD = 'src';
  system('gcc -fPIC -c libdontpanic.c');
  system('ld -shared -soname libdontpanic.so -o libdontpanic.so libdontpanic.o');
}

sub configure {
  _store_options( { prefix => $prefix } );
}

sub install {
  my %files = do {
    local $CWD = 'src';
    map {
      my $folder = $_;
      my @files = map {File::Spec->rel2abs($_)} @{$install{$folder}};
      ($folder, \@files)
    } keys %install;
  };

  local $CWD = $config->{prefix};

  foreach my $folder (keys %files) {
    mkdir $folder unless -d $folder;
    local $CWD = $folder;
    copy $_, $CWD for @{$files{$folder}};
  }

  {
    local $CWD = 'lib';
    _write_pc();
    
  }
}

sub clean {
  foreach my $folder (keys %clean) {
    local $CWD = $folder;
    unlink @{$clean{$folder}};
  }
}

sub _load_options {
  return {} unless -e $config_file;

  my $config = do $config_file;
  return $config;
}

sub _store_options {
  my $opts = shift;
  open my $fh, '>', $config_file;
  print $fh Dumper $opts;
}

sub _write_pc {
  open my $fh, '>', 'dontpanic.pc';

  my $prefix = $config->{prefix};

  print $fh <<END_PC;
prefix=$prefix
libdir=$prefix/lib
includedir=$prefix/include

Name: DontPanic
Description: Test Library for Alien::Base
Version: 1.01
Libs: -L$prefix/lib -ldontpanic
Cflags: -I$prefix/include
END_PC
}

