#############################################################
# This file was automatically generated on 2018-11-28.      #
#                                                           #
# Perl Bindings Version 2.1.20                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletThermalImaging - 80x60 pixel thermal imaging camera

=cut

package Tinkerforge::BrickletThermalImaging;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a Thermal Imaging Bricklet.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 278;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a Thermal Imaging Bricklet.

=cut

use constant DEVICE_DISPLAY_NAME => 'Thermal Imaging Bricklet';

=item CALLBACK_HIGH_CONTRAST_IMAGE_LOW_LEVEL

This constant is used with the register_callback() subroutine to specify
the CALLBACK_HIGH_CONTRAST_IMAGE_LOW_LEVEL callback.

=cut

use constant CALLBACK_HIGH_CONTRAST_IMAGE_LOW_LEVEL => 12;

=item CALLBACK_TEMPERATURE_IMAGE_LOW_LEVEL

This constant is used with the register_callback() subroutine to specify
the CALLBACK_TEMPERATURE_IMAGE_LOW_LEVEL callback.

=cut

use constant CALLBACK_TEMPERATURE_IMAGE_LOW_LEVEL => 13;

=item CALLBACK_HIGH_CONTRAST_IMAGE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_HIGH_CONTRAST_IMAGE callback.

=cut

use constant CALLBACK_HIGH_CONTRAST_IMAGE => -12;

=item CALLBACK_TEMPERATURE_IMAGE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_TEMPERATURE_IMAGE callback.

=cut

use constant CALLBACK_TEMPERATURE_IMAGE => -13;

=item FUNCTION_GET_HIGH_CONTRAST_IMAGE_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_HIGH_CONTRAST_IMAGE_LOW_LEVEL => 1;

=item FUNCTION_GET_TEMPERATURE_IMAGE_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TEMPERATURE_IMAGE_LOW_LEVEL => 2;

=item FUNCTION_GET_STATISTICS

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATISTICS => 3;

=item FUNCTION_SET_RESOLUTION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_RESOLUTION => 4;

=item FUNCTION_GET_RESOLUTION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_RESOLUTION => 5;

=item FUNCTION_SET_SPOTMETER_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_SPOTMETER_CONFIG => 6;

=item FUNCTION_GET_SPOTMETER_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPOTMETER_CONFIG => 7;

=item FUNCTION_SET_HIGH_CONTRAST_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_HIGH_CONTRAST_CONFIG => 8;

=item FUNCTION_GET_HIGH_CONTRAST_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_HIGH_CONTRAST_CONFIG => 9;

=item FUNCTION_SET_IMAGE_TRANSFER_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_IMAGE_TRANSFER_CONFIG => 10;

=item FUNCTION_GET_IMAGE_TRANSFER_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IMAGE_TRANSFER_CONFIG => 11;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 234;

=item FUNCTION_SET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BOOTLOADER_MODE => 235;

=item FUNCTION_GET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BOOTLOADER_MODE => 236;

=item FUNCTION_SET_WRITE_FIRMWARE_POINTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_WRITE_FIRMWARE_POINTER => 237;

=item FUNCTION_WRITE_FIRMWARE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_FIRMWARE => 238;

=item FUNCTION_SET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STATUS_LED_CONFIG => 239;

=item FUNCTION_GET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATUS_LED_CONFIG => 240;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_UID => 248;

=item FUNCTION_READ_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_UID => 249;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant RESOLUTION_0_TO_6553_KELVIN => 0;
use constant RESOLUTION_0_TO_655_KELVIN => 1;
use constant FFC_STATUS_NEVER_COMMANDED => 0;
use constant FFC_STATUS_IMMINENT => 1;
use constant FFC_STATUS_IN_PROGRESS => 2;
use constant FFC_STATUS_COMPLETE => 3;
use constant IMAGE_TRANSFER_MANUAL_HIGH_CONTRAST_IMAGE => 0;
use constant IMAGE_TRANSFER_MANUAL_TEMPERATURE_IMAGE => 1;
use constant IMAGE_TRANSFER_CALLBACK_HIGH_CONTRAST_IMAGE => 2;
use constant IMAGE_TRANSFER_CALLBACK_TEMPERATURE_IMAGE => 3;
use constant BOOTLOADER_MODE_BOOTLOADER => 0;
use constant BOOTLOADER_MODE_FIRMWARE => 1;
use constant BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT => 2;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT => 3;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT => 4;
use constant BOOTLOADER_STATUS_OK => 0;
use constant BOOTLOADER_STATUS_INVALID_MODE => 1;
use constant BOOTLOADER_STATUS_NO_CHANGE => 2;
use constant BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT => 3;
use constant BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT => 4;
use constant BOOTLOADER_STATUS_CRC_MISMATCH => 5;
use constant STATUS_LED_CONFIG_OFF => 0;
use constant STATUS_LED_CONFIG_ON => 1;
use constant STATUS_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant STATUS_LED_CONFIG_SHOW_STATUS => 3;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 0]);

	$self->{response_expected}->{&FUNCTION_GET_HIGH_CONTRAST_IMAGE_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_TEMPERATURE_IMAGE_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_STATISTICS} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_RESOLUTION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_RESOLUTION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_SPOTMETER_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_SPOTMETER_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_HIGH_CONTRAST_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_HIGH_CONTRAST_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_IMAGE_TRANSFER_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IMAGE_TRANSFER_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_WRITE_FIRMWARE_POINTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_FIRMWARE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_HIGH_CONTRAST_IMAGE_LOW_LEVEL} = 'S C62';
	$self->{callback_formats}->{&CALLBACK_TEMPERATURE_IMAGE_LOW_LEVEL} = 'S S31';

	$self->{high_level_callbacks}->{&CALLBACK_HIGH_CONTRAST_IMAGE} = shared_clone([shared_clone({stream_chunk_offset => 0, stream_chunk_data => 1}), shared_clone(['stream_chunk_offset', 'stream_chunk_data']), shared_clone({fixed_length => 4800, single_chunk => 0}), undef]);
	$self->{high_level_callbacks}->{&CALLBACK_TEMPERATURE_IMAGE} = shared_clone([shared_clone({stream_chunk_offset => 0, stream_chunk_data => 1}), shared_clone(['stream_chunk_offset', 'stream_chunk_data']), shared_clone({fixed_length => 4800, single_chunk => 0}), undef]);

	bless($self, $class);

	return $self;
}


=item get_high_contrast_image_low_level()

Returns the current high contrast image. See `here <https://www.tinkerforge.com/en/doc/Hardware/Bricklets/Thermal_Imaging.html#high-contrast-image-vs-temperature-image>`__
for the difference between
High Contrast and Temperature Image. If you don't know what to use
the High Contrast Image is probably right for you.

The data is organized as a 8-bit value 80x60 pixel matrix linearized in
a one-dimensional array. The data is arranged line by line from top left to
bottom right.

Each 8-bit value represents one gray-scale image pixel that can directly be
shown to a user on a display.

Before you can use this function you have to enable it with
:func:`Set Image Transfer Config`.

=cut

sub get_high_contrast_image_low_level
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_HIGH_CONTRAST_IMAGE_LOW_LEVEL, [], '', 'S C62');
}

=item get_temperature_image_low_level()

Returns the current temperature image. See `here <https://www.tinkerforge.com/en/doc/Hardware/Bricklets/Thermal_Imaging.html#high-contrast-image-vs-temperature-image>`__
for the difference between High Contrast and Temperature Image.
If you don't know what to use the High Contrast Image is probably right for you.

The data is organized as a 16-bit value 80x60 pixel matrix linearized in
a one-dimensional array. The data is arranged line by line from top left to
bottom right.

Each 16-bit value represents one temperature measurement in either
Kelvin/10 or Kelvin/100 (depending on the resolution set with:func:`Set Resolution`).

Before you can use this function you have to enable it with
:func:`Set Image Transfer Config`.

=cut

sub get_temperature_image_low_level
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_TEMPERATURE_IMAGE_LOW_LEVEL, [], '', 'S S31');
}

=item get_statistics()

Returns the spotmeter statistics, various temperatures, current resolution and status bits.

The spotmeter statistics are:

* Index 0: Mean Temperature.
* Index 1: Maximum Temperature.
* Index 2: Minimum Temperature.
* Index 3: Pixel Count of spotmeter region of interest.

The temperatures are:

* Index 0: Focal Plain Array temperature.
* Index 1: Focal Plain Array temperature at last FFC (Flat Field Correction).
* Index 2: Housing temperature.
* Index 3: Housing temperature at last FFC.

The resolution is either `0 to 6553 Kelvin` or `0 to 655 Kelvin`. If the resolution is the former,
the temperatures are in Kelvin/10, if it is the latter the temperatures are in Kelvin/100.

FFC (Flat Field Correction) Status:

* FFC Never Commanded: Only seen on startup before first FFC.
* FFC Imminent: This state is entered 2 seconds prior to initiating FFC.
* FFC In Progress: Flat field correction is started (shutter moves in front of lens and back). Takes about 1 second.
* FFC Complete: Shutter is in waiting position again, FFC done.

Temperature warning bits:

* Index 0: Shutter lockout (if true shutter is locked out because temperature is outside -10°C to +65°C)
* Index 1: Overtemperature shut down imminent (goes true 10 seconds before shutdown)

=cut

sub get_statistics
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_STATISTICS, [], '', 'S4 S4 C C ?2');
}

=item set_resolution()

Sets the resolution. The Thermal Imaging Bricklet can either measure

* from 0 to 6553 Kelvin (-273.15°C to +6279.85°C) with 0.1°C resolution or
* from 0 to 655 Kelvin (-273.15°C to +381.85°C) with 0.01°C resolution.

The accuracy is specified for -10°C to 450°C in the
first range and -10°C and 140°C in the second range.

The default value is 0 to 655 Kelvin.

=cut

sub set_resolution
{
	my ($self, $resolution) = @_;

	$self->_send_request(&FUNCTION_SET_RESOLUTION, [$resolution], 'C', '');
}

=item get_resolution()

Returns the resolution as set by :func:`Set Resolution`.

=cut

sub get_resolution
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_RESOLUTION, [], '', 'C');
}

=item set_spotmeter_config()

Sets the spotmeter region of interest. The 4 values are

* Index 0: Column start (has to be smaller then Column end).
* Index 1: Row start (has to be smaller then Row end).
* Index 2: Column end (has to be smaller then 80).
* Index 3: Row end (has to be smaller then 60).

The spotmeter statistics can be read out with :func:`Get Statistics`.

The default region of interest is (39, 29, 40, 30).

=cut

sub set_spotmeter_config
{
	my ($self, $region_of_interest) = @_;

	$self->_send_request(&FUNCTION_SET_SPOTMETER_CONFIG, [$region_of_interest], 'C4', '');
}

=item get_spotmeter_config()

Returns the spotmeter config as set by :func:`Set Spotmeter Config`.

=cut

sub get_spotmeter_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SPOTMETER_CONFIG, [], '', 'C4');
}

=item set_high_contrast_config()

Sets the high contrast region of interest, dampening factor, clip limit and empty counts.
This config is only used in high contrast mode (see :func:`Set Image Transfer Config`).

The high contrast region of interest consists of four values:

* Index 0: Column start (has to be smaller or equal then Column end).
* Index 1: Row start (has to be smaller then Row end).
* Index 2: Column end (has to be smaller then 80).
* Index 3: Row end (has to be smaller then 60).

The algorithm to generate the high contrast image is applied to this region.

Dampening Factor: This parameter is the amount of temporal dampening applied to the HEQ
(history equalization) transformation function. An IIR filter of the form::

 (N / 256) * previous + ((256 - N) / 256) * current

is applied, and the HEQ dampening factor
represents the value N in the equation, i.e., a value that applies to the amount of
influence the previous HEQ transformation function has on the current function. The
lower the value of N the higher the influence of the current video frame whereas
the higher the value of N the more influence the previous damped transfer function has.

Clip Limit Index 0 (AGC HEQ Clip Limit Low): This parameter defines an artificial population that is added to
every non-empty histogram bin. In other words, if the Clip Limit Low is set to L, a bin
with an actual population of X will have an effective population of L + X. Any empty bin
that is nearby a populated bin will be given an artificial population of L. The effect of
higher values is to provide a more linear transfer function; lower values provide a more
non-linear (equalized) transfer function.

Clip Limit Index 1 (AGC HEQ Clip Limit High): This parameter defines the maximum number of pixels allowed
to accumulate in any given histogram bin. Any additional pixels in a given bin are clipped.
The effect of this parameter is to limit the influence of highly-populated bins on the
resulting HEQ transformation function.

Empty Counts: This parameter specifies the maximum number of pixels in a bin that will be
interpreted as an empty bin. Histogram bins with this number of pixels or less will be
processed as an empty bin.

The default values are

* Region Of Interest = (0, 0, 79, 59),
* Dampening Factor = 64,
* Clip Limit = (4800, 512) and
* Empty Counts = 2.

=cut

sub set_high_contrast_config
{
	my ($self, $region_of_interest, $dampening_factor, $clip_limit, $empty_counts) = @_;

	$self->_send_request(&FUNCTION_SET_HIGH_CONTRAST_CONFIG, [$region_of_interest, $dampening_factor, $clip_limit, $empty_counts], 'C4 S S2 S', '');
}

=item get_high_contrast_config()

Returns the high contrast config as set by :func:`Set High Contrast Config`.

=cut

sub get_high_contrast_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_HIGH_CONTRAST_CONFIG, [], '', 'C4 S S2 S');
}

=item set_image_transfer_config()

The necessary bandwidth of this Bricklet is too high to use getter/callback or
high contrast/temperature image at the same time. You have to configure the one
you want to use, the Bricklet will optimize the internal configuration accordingly.

Corresponding functions:

* Manual High Contrast Image: :func:`Get High Contrast Image`.
* Manual Temperature Image: :func:`Get Temperature Image`.
* Callback High Contrast Image: :cb:`High Contrast Image` callback.
* Callback Temperature Image: :cb:`Temperature Image` callback.

The default is Manual High Contrast Image (0).

=cut

sub set_image_transfer_config
{
	my ($self, $config) = @_;

	$self->_send_request(&FUNCTION_SET_IMAGE_TRANSFER_CONFIG, [$config], 'C', '');
}

=item get_image_transfer_config()

Returns the image transfer config, as set by :func:`Set Image Transfer Config`.

=cut

sub get_image_transfer_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IMAGE_TRANSFER_CONFIG, [], '', 'C');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Bricklet side. All
Bricks have a similar function that returns the errors on the Brick side.

=cut

sub get_spitfp_error_count
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [], '', 'L L L L');
}

=item set_bootloader_mode()

Sets the bootloader mode and returns the status after the requested
mode change was instigated.

You can change from bootloader mode to firmware mode and vice versa. A change
from bootloader mode to firmware mode will only take place if the entry function,
device identifier and CRC are present and correct.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_bootloader_mode
{
	my ($self, $mode) = @_;

	return $self->_send_request(&FUNCTION_SET_BOOTLOADER_MODE, [$mode], 'C', 'C');
}

=item get_bootloader_mode()

Returns the current bootloader mode, see :func:`Set Bootloader Mode`.

=cut

sub get_bootloader_mode
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_BOOTLOADER_MODE, [], '', 'C');
}

=item set_write_firmware_pointer()

Sets the firmware pointer for :func:`Write Firmware`. The pointer has
to be increased by chunks of size 64. The data is written to flash
every 4 chunks (which equals to one page of size 256).

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_write_firmware_pointer
{
	my ($self, $pointer) = @_;

	$self->_send_request(&FUNCTION_SET_WRITE_FIRMWARE_POINTER, [$pointer], 'L', '');
}

=item write_firmware()

Writes 64 Bytes of firmware at the position as written by
:func:`Set Write Firmware Pointer` before. The firmware is written
to flash every 4 chunks.

You can only write firmware in bootloader mode.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_firmware
{
	my ($self, $data) = @_;

	return $self->_send_request(&FUNCTION_WRITE_FIRMWARE, [$data], 'C64', 'C');
}

=item set_status_led_config()

Sets the status LED configuration. By default the LED shows
communication traffic between Brick and Bricklet, it flickers once
for every 10 received data packets.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.

=cut

sub set_status_led_config
{
	my ($self, $config) = @_;

	$self->_send_request(&FUNCTION_SET_STATUS_LED_CONFIG, [$config], 'C', '');
}

=item get_status_led_config()

Returns the configuration as set by :func:`Set Status LED Config`

=cut

sub get_status_led_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_STATUS_LED_CONFIG, [], '', 'C');
}

=item get_chip_temperature()

Returns the temperature in °C as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has bad
accuracy. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 's');
}

=item reset()

Calling this function will reset the Bricklet. All configurations
will be lost.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_RESET, [], '', '');
}

=item write_uid()

Writes a new UID into flash. If you want to set a new UID
you have to decode the Base58 encoded UID string into an
integer first.

We recommend that you use Brick Viewer to change the UID.

=cut

sub write_uid
{
	my ($self, $uid) = @_;

	$self->_send_request(&FUNCTION_WRITE_UID, [$uid], 'L', '');
}

=item read_uid()

Returns the current UID as an integer. Encode as
Base58 to get the usual string version.

=cut

sub read_uid
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_READ_UID, [], '', 'L');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c' or 'd'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 'Z8 Z8 a C3 C3 S');
}

=item get_high_contrast_image()

Returns the current high contrast image. See `here <https://www.tinkerforge.com/en/doc/Hardware/Bricklets/Thermal_Imaging.html#high-contrast-image-vs-temperature-image>`__
for the difference between
High Contrast and Temperature Image. If you don't know what to use
the High Contrast Image is probably right for you.

The data is organized as a 8-bit value 80x60 pixel matrix linearized in
a one-dimensional array. The data is arranged line by line from top left to
bottom right.

Each 8-bit value represents one gray-scale image pixel that can directly be
shown to a user on a display.

Before you can use this function you have to enable it with
:func:`Set Image Transfer Config`.

=cut

sub get_high_contrast_image
{
    my ($self) = @_;
    my $image_length = 4800;

    lock(${$self->{stream_lock_ref}});

    my @ret = $self->get_high_contrast_image_low_level();
    my $image_chunk_offset = $ret[0];
    my $image_out_of_sync = undef;
    my $image_data = undef;

    if($image_chunk_offset == (1 << 16) - 1) # maximum chunk offset -> stream has no data
    {
        $image_length = 0;
        $image_chunk_offset = 0;
        $image_out_of_sync = 0;
        $image_data = [];
    }
    else
    {
        $image_out_of_sync = $image_chunk_offset != 0;
        $image_data = $ret[1];
    }

    while(!$image_out_of_sync && scalar(@{$image_data}) < $image_length)
    {
        @ret = $self->get_high_contrast_image_low_level();
        $image_chunk_offset = $ret[0];
        $image_out_of_sync = $image_chunk_offset != scalar(@{$image_data});
        push(@{$image_data}, @{$ret[1]});
    }

    if($image_out_of_sync) # discard remaining stream to bring it back in-sync
    {
        while($image_chunk_offset + 62 < $image_length)
        {
            @ret = $self->get_high_contrast_image_low_level();
            $image_chunk_offset = $ret[0];
        }

        croak(Tinkerforge::Error->_new(Tinkerforge::Error->STREAM_OUT_OF_SYNC, 'Image stream is out-of-sync'));
    }

    splice(@{$image_data}, $image_length);

    return $image_data;
}

=item get_temperature_image()

Returns the current temperature image. See `here <https://www.tinkerforge.com/en/doc/Hardware/Bricklets/Thermal_Imaging.html#high-contrast-image-vs-temperature-image>`__
for the difference between High Contrast and Temperature Image.
If you don't know what to use the High Contrast Image is probably right for you.

The data is organized as a 16-bit value 80x60 pixel matrix linearized in
a one-dimensional array. The data is arranged line by line from top left to
bottom right.

Each 16-bit value represents one temperature measurement in either
Kelvin/10 or Kelvin/100 (depending on the resolution set with:func:`Set Resolution`).

Before you can use this function you have to enable it with
:func:`Set Image Transfer Config`.

=cut

sub get_temperature_image
{
    my ($self) = @_;
    my $image_length = 4800;

    lock(${$self->{stream_lock_ref}});

    my @ret = $self->get_temperature_image_low_level();
    my $image_chunk_offset = $ret[0];
    my $image_out_of_sync = undef;
    my $image_data = undef;

    if($image_chunk_offset == (1 << 16) - 1) # maximum chunk offset -> stream has no data
    {
        $image_length = 0;
        $image_chunk_offset = 0;
        $image_out_of_sync = 0;
        $image_data = [];
    }
    else
    {
        $image_out_of_sync = $image_chunk_offset != 0;
        $image_data = $ret[1];
    }

    while(!$image_out_of_sync && scalar(@{$image_data}) < $image_length)
    {
        @ret = $self->get_temperature_image_low_level();
        $image_chunk_offset = $ret[0];
        $image_out_of_sync = $image_chunk_offset != scalar(@{$image_data});
        push(@{$image_data}, @{$ret[1]});
    }

    if($image_out_of_sync) # discard remaining stream to bring it back in-sync
    {
        while($image_chunk_offset + 31 < $image_length)
        {
            @ret = $self->get_temperature_image_low_level();
            $image_chunk_offset = $ret[0];
        }

        croak(Tinkerforge::Error->_new(Tinkerforge::Error->STREAM_OUT_OF_SYNC, 'Image stream is out-of-sync'));
    }

    splice(@{$image_data}, $image_length);

    return $image_data;
}

=back
=cut

1;
