## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

package TeX::Hyphen::Pattern::Af_ec v1.1.3;
use strict;
use warnings;
use 5.014000;
use utf8;

use Moose;

my $pattern_file = q{};
while (<DATA>) {
    $pattern_file .= $_;
}

sub pattern_data {
    return $pattern_file;
}

sub version {
    return $TeX::Hyphen::Pattern::Af_ec::VERSION;
}

1;
## no critic qw(RequirePodAtEnd RequireASCII ProhibitFlagComments)

=encoding utf8

=head1 C<Af_ec> hyphenation pattern class

=head1 SUBROUTINES/METHODS

=over 4

=item $pattern-E<gt>pattern_data();

Returns the pattern data.

=item $pattern-E<gt>version();

Returns the version of the pattern package.

=back

=head1 Copyright

The copyright of the patterns is not covered by the copyright of this package
since this pattern is generated from the source at
L<svn://tug.org/texhyphen/trunk/hyph-utf8/tex/generic/hyph-utf8/patterns/ptex/hyph-af.ec.tex>

The copyright of the source can be found in the DATA section in the source of
this package file.

=cut

__DATA__
% pTeX-friendly hyphenation patterns
%
% language: afrikaans (af)
% encoding: ec
%
% This file has been auto-generated from hyph-af.tex
% with a script [texmf]/scripts/generic/hyph-utf8/generate-ptex-patterns.rb
% See the original file for details about author, licence etc.
%
\bgroup
\lccode"E4="E4
\lccode"E8="E8
\lccode"EA="EA
\lccode"EB="EB
\lccode"EE="EE
\lccode"EF="EF
\lccode"F4="F4
\lccode"F6="F6
\lccode"FB="FB
\lccode"FC="FC
\patterns{
.aan5s4
.a^^e47lawa
.a6bc-b
.a4b5la
.ab7salo
.a6b-ja
.ac7cra.
.a6farm
.af7arm.
.a6feet
.af7eet.
.a4f5en
.a6fets
.af7ets.
.a6foes
.af7oes.
.a4f5oo
.a4f5ra
.af6ro'
.a7fro's
.af6ro-
.a7fro-h
.a6fry.
.af3s
.ag6aam
.agte6r5
.a6guur
.a9ha.
.ah7lers
.a3kw
.a6leer
.al7eer.
.alf4
.al7fagr
.al5fr
.al6lda
.a4l3o
.al6o^^efe
.a7lo^^efen
.al3p
.al5st
.al7thea
.al7twee
.al6zhe
.amp4s
.amps5w
.a6na^^ebr
.an7a^^ebro
.an6cpl
.and4
.an5dr
.ang4
.an5gl
.angs5
.a4n5io
.an7thro
.a3pr
.ap7side
.a5rag
.ara6p.
.ar7thur
.ar6zbe
.as7jas.
.a6snog
.a6sof.
.a5sti
.a7straa
.a7s6tral
.at6hol
.a7thol.
.a5tsj
.atte4
.au7drey
.b6aanv
.ba6din
.ba4d5o
.ba7loi.
.ba7ragw
.ba7rins
.ba6sek
.ba7tho.
.be7deks
.be6kaf
.bek7af.
.be5la
.be7lol.
.be7skos
.be7thel
.be7thul
.bi7sho.
.bli4
.blus5
.bo7kerf
.bo7kies
.bo7kors
.bo7maat
.b4on
.bo7plaa
.bo5ro
.bo7sor.
.bo5sta
.bo7trit
.bo7tswa
.bo7uit.
.bout5j
.b4re
.bu6eno
.bu6lol
.bu7thel
.by6ldr
.by6lho
.by6lne
.by6lpi
.by7port
.bys4
.by6tal
.ca7thy.
.ca7yenn
.chlo7e.
.ci6rca
.ci7trus
.cos7ta.
.cy6pri
.d2
.da7gon.
.dag5s
.da6kat
.da6koo
.da7tage
.da6tji
.dat7jie
.da6wki
.de6k7laa
.de6klo
.de6kwe
.de5la
.de7roga
.de6sal
.de6sok
.de4sp
.diep5l
.di6jks
.di4si
.di7thak
.do4m5a
.do4m5o
.dor7ste.
.dr6oef
.dun5s
.du6pre
.dut5j
.dy7spie
.e6bcu.
.ed5wa
.ed7win.
.eer6sk
.ee4t
.e6fron
.ef7ron.
.eg7gofo
.e6indu
.ei5st
.ek4s5k
.ek7sopa
.ek7sord
.eks7tri
.eks7tro
.en7dres
.enk4
.en5kl
.e6noft
.en7ofta
.en4t5j
.en7topt
.ep7soms
.er4d5a
.er6dwo
.er6fle
.er6foo
.er6inv
.ern4
.er4t4
.er5te
.ert5j
.ert7se.
.erts5w
.e2s
.e9sau
.e4s3k
.e3so
.es3p
.es8p.
.es6pma
.es3t
.es6tco
.es6tni
.es5tr
.e7tage.
.et4sn
.eur5a
.eu7stac
.ex7odus
.e6zra.
.f2
.fo6chv
.fo6wle
.f4ri
.fy6tji
.g2
.ga7lage
.ga7lago
.ga6lap
.ga6loo
.g6arbo
.ga6sen
.ge7dart
.ge3g
.ge7geks
.ge7guil
.gekun5
.gekuns6
.ge5la
.ge7mopp
.ge7muit
.ge7n^^e8ve
.ge7rogg
.ges4
.ge7sjab
.ge7sjar
.ge5sk
.ge5so
.ges7pe.
.ge7sper.
.ge7steg
.gif3
.gi7gagr
.gi6sen
.gly3
.gly5k
.g6lyna
.g4oo
.gou7da.
.gr6^^e4be
.g6ruba
.gui7do.
.hang5s
.he6blu
.he6gor
.he6gra
.h6eind
.hek5o
.he7rakl
.he6r5en
.he6wle
.hi8v.
.ho6fet
.ho6laa
.ho6loo
.hooi5
.ho7taze
.ho4t5o
.hy6gro
.ic7teru
.i4gl
.ile7us.
.i2n1
.i9n8a.
.in6ari
.i7narie
.ind4
.in7dwar
.ing4
.in5gr
.in5gw
.in6iti
.in5kl
.in6kly
.in5kn
.in5kw
.in6osi
.i7nosie
.in3s4
.in7snee
.in7twyf
.i5raa
.i3sa
.i4sk
.i3so
.ja6gli
.jah7we.
.ja6spa
.ja7taga
.j6^^e4ger
.je7sopp
.jo7dofo
.jo7safa
.ju6kos
.juk7os.
.j6^^fc6rge
.jy6sel
.k2
.kaar4
.kade4
.kadet5
.k4af
.ka^^ef7ro.
.ka7nont
.ka6pla
.ka7plak
.k6arbe
.ka7thar
.ka7thu.
.ka6to^^eb
.kat7o^^eb.
.ka6tui
.ke6ple
.ker6k5a
.ker6k5l
.kerk5r
.ker6sa
.ker6sl
.ker6s5p
.ke4s5t
.kie6st
.ki6pli
.ki4r
.kit7se.
.k4la
.k6leyn
.k4li
.klip5
.knik5
.kn6opn
.ko6maa
.ko6maf
.k4op
.kope4
.koper7a
.ko6pla
.kop5o
.ko7rag.
.kor6st
.kors7te.
.k6rak.
.kr6^^fcge
.kryt5
.ku7mon.
.k4we
.k4wo
.ky7otop
.l'7etji
.la6eti
.la6kwa
.la5sa
.lei5s4
.lek7o^^eb.
.le6poo
.le5pr
.le7shab
.le6son
.le4sp
.les5t
.le6suu
.lig5e
.li4gi
.li6gom
.li6gre
.li7pase
.l6loyd
.lo6chn
.lof7ui.
.lo6gl^^ea
.l6ontd
.los5k
.lu6gen
.lui5sl
.l6^^fcder
.m2
.m'7etji
.ma6cdo
.ma6nal
.ma6nur
.ma7stek
.ma7thes
.ma6zda
.mel6k5a
.mel6k5l
.mer6k5l
.mes5m
.me4sw
.me6tem
.mi6dos
.mi6rba
.mi7traa
.m4ne
.mo7djad
.mo7flam
.mo6sin
.mo4sk
.mu4e
.my6nen
.my6n5in
.my7unis
.n2
.n6aand
.na5fl
.na6gro
.na7groe
.na7smaa
.na7stor
.na7uurs
.ne4k5a
.ne4k5o
.ne6kri
.nek7rin
.ne6kys
.ne4s3
.ne7serh
.n6etik
.ne4t5j
.ne6tru
.ne6wca
.ne6wfo
.ne6wla
.ne6wma
.ni4e
.ni6jho
.ni6rva
.nix7on.
.n6kosa
.noet4
.noe5tj
.no6gee
.no4k
.n6ondu
.nu4l
.ny7lont
.oe5kr
.oe4r
.oe7ralg
.oe7rang
.oer7os.
.oe4s3
.o4gl
.oh7rigs
.o6klah
.ok7laho
.ol6ieu
.o7lieui
.oms4
.o2n1
.ond6ui
.on7duit
.o6nemo
.on6ias
.o7nias.
.on3k
.on7parm
.on3s4
.on6she
.on6sse
.on6t7eer
.on6t5er
.on4tr
.ont7ras
.ont5ri
.o9nus
.on6us.
.oon4
.oon7de.
.o4op
.oor5n
.oor5s4
.oo4s
.o6peet
.op7eet.
.o6peg.
.o6pein
.o6p5erd
.o4pof
.o4pr
.op5ra
.ops4
.op7smuk
.o7ragie
.or6kne
.o3ro
.orto5
.o4sk
.os5ko
.os7oog.
.ot6hel
.o7thell
.ou6doo
.ou7n^^f4i.
.ou5tj
.p2
.pa4d3
.pa7die.
.pa6vlo
.pe5la
.pel6sk
.per6st
.pe4sk
.pe4st
.pie6tj
.pi7laf.
.pit5s
.p4la
.po6dzo
.p6oefe
.poen4
.p6ontw
.po6sad
.p4re
.pu6tad
.py6paa
.py6pla
.py6pol
.pyp5r
.py7thon
.r2
.r'7etji
.r6aard
.ra7dart
.ra6seg
.ras7eg.
.re7aumu
.re6gru
.rek5s
.re6mas
.rem7as.
.re6mco
.re4sl
.rie4t
.riet5j
.riet5r
.ri6ple
.roc7ky.
.ro6gak
.ron7do.
.rond5s
.ro5py
.ros5t
.ro6tre
.ro6wli
.ru7klip
.ruk4o
.ru7kope
.ru7staa
.ru6suu
.ry4k5a
.ry6ste
.s6aans
.s4af
.s4ag
.sa7gopa
.s6akty
.s4am
.sa6vlo
.s4ca
.se6an.
.see5ra
.see7ys.
.se7khuk
.se6laa
.se6lop
.se7reni
.se6sle
.ses5t
.se6suu
.se6tap
.se4tr
.sex5y
.s6fale
.s4fi
.s4gr
.s4ha4
.s4he
.s4hi
.s4ho
.s4hu
.s4in
.si6nes
.si7pho.
.si7rag.
.s4ja
.s4ka
.s4ke
.s4kl
.s4ko
.s4kr
.s4ku
.slag5
.s4ma
.s4me
.s4mi
.s4mo
.s4mu
.s6nags
.s4ne
.sod4
.so7dafa
.so7dwan
.so7iets
.so6kop
.some4
.s6oms.
.s4on
.so6neg
.s4op
.so6pek
.so7phok
.so7ross
.s4pe
.s4pl
.spo4g
.s6pren
.s4py
.s8ri.
.s4ta
.s6temp
.ste7rol
.ster6ta
.ster6t7j
.s4ti
.s4to
.straf5
.s6trei
.s6tuar
.stuc5
.su7biet
.sub5m
.sub5p
.su8e.
.s4ui
.su5kr
.su7ther
.su7tra.
.s4we
.s4wi
.s4wo
.sy1
.sy6lvi
.sy7nagr
.sy7slag
.t2
.t6afsy
.t4ag
.tee5k
.te6flo
.te7rafi
.te7ragr
.ter6tj
.tert7ji
.te4s5t
.te7stud
.ti6ene
.tie6t5j
.ti4k
.ti6ner
.t6jaai
.tjok5
.toe7ys.
.to6kla
.to7ky7o.
.to6lun
.to7ront
.tou3
.trap5r
.trek5
.tre4s
.trie4
.tries5
.t4sa
.ts4h
.ts6jaa
.ty6daa
.ty6dor
.ty6dra
.ui6laa
.ui4t3
.ui5ti
.ui5t6ji
.um7hlan
.uns4
.un5st
.u5raa
.u5tra
.va6kad
.va6kei
.va6naf
.va4n5o
.va7raan
.va6sen
.va6swa
.vas7ys.
.ve7cino
.ve7laar
.ve7lare
.ve7l^^ear.
.ve7loer
.ve7lome
.ve7meng
.ve7rema
.ve7rena
.ve7reve
.ve7skaf
.ve7tore
.vlas5
.vo6gin
.vo6lyw
.vo6sko
.wa7ghri
.wa4n
.wa7smou
.wa6spa
.web5m
.we4bo
.we6b-o
.week7lan
.wee4t5
.we6kuu
.we4l5a
.we6lin
.wel7ing
.we6nan
.werk5l
.wer6k5r
.we4s5k
.we6soe
.we6swa
.w8h^^ea.
.w4hi
.wi6id.
.wins5
.wi4p
.wi4t
.w^^ee9e.
.wy7kwas
.wy7nand
.wy6net
.x2
.y6amin
.y6anni
.y6asud
.yk7loon
.ys3
.ys6ere
.ys5la
.ze5us
.z6^^fcric
.z4wa
.z4wi
aa2
aad1
aa4da
aa4de
aa4do
aa4d3r
aaf7emme
aaf6sat
aag5al
aag7asem
aag7elas
aag3r
aag7rond
aag5s4l
aag5sp
aag5st
aag7swee
aai7lag.
aak1
aa4ka
aa4ko
aak3r
aak7ster
aak3w
aal1
aal6dys
aald7ys.
aal5fe
aal6fpo
aal5sa
aal7sfee
aam1
aa4ma
aa4me
aa4mo
aam7smul
aan1
aan6dou
aand6re
aan7dren
aan7dros
aan7gons
aan3k4
aan5kl
5aankon
aan7kry.
5aanleg
aan7sage
aan6see
aans7eer
aan6sek
5aansig
aan7skem
aan5sl
aan5sn
aan6som
aan6son
aan5sp
aan7tuig
5aanva
aap1
aa4pa
aa4po
aap3r
aa4pu
aar3a
aar6dan
aard7ang
aard7as.
aar5de
aar7ding
aar4du
aar3e
aar3i
aar7kwek
aar6lbe
aar6lka
aar6lva
aar6lzi
aar6l-o
aar3o
aar7ser.
aar7seri
aar6sid
aars8teek
aars8tell
aars6ti
5aartap
aar6tin
aar7tomo
aar7tryb
aar3u
aas3
aa4so
aas7omel
aat1
aat7nagt
aa4to
aat3r
aat6sef
aat7sfee
aat7slim
aat6slo
aat6sly
aat7sonn
aat6sow
aat6sti
aau6wbe
a^^e45ron
aba6kas
abak7as.
aba7komb
abare4
aba7ster
ab3d
aber6sp
ab5lau
ab5rup
3abso
abu7scha
ab5wie
ac5que
a2d
a3da
a4d3aa
adam4
adam7pe.
ada4r
a3de
ades7lan
ade7smee
a3di
adi6eus
5adjud
5admin
a3do
a4dow
a3dr
5adres.
ads7erwe
ad4sn
ads6op.
ad5sor
ads7teso
ad4su
a3du
ad5uit
adu7spel
adu5tj
5advert
a3dy
ady7smit
a1e
ael7atoo
ae4l5ei
ae4lo
aes5to
aes5tr
aes7tuur
a^^eb1
4afee
af5eks
afel5aa
af4fre
af5gha
af5inr
af3l
a4fof
af1r
af5raa
af5ram
af5ran
a4f3re
3afri
a4f5rit
a4f3ro
a5frod
a4f3ru
af3s4w
3afva
afval5
ag3aa
a6gaanv
a4gaar
ag5adv
a4g3ak
ag5alg
ag5api
ag5are
4age.
4ageb
4aged
age6ddo
a4gei
4agem
a4g5erv
4ages
a6g5ewen
agge7us.
a3gi
a5ging
a4g5ins
agi5s6tr
ag1l
ag5ogg
ag5ord
ag5ork
ag5oud
a4g3re
ag5rei
a4g3ru
ag3sa
ags7abno
ag6sins
ag5ska
ags7koev
ag5skol
ag5skr
ag5sky
ags4lo
ag4sn
ags6oep
ag5som.
ags6oom
ags6op.
ag5spe
ag5s6por
ags4t
ags7taal
ag5sti
ags6waa
ags6wee
ag4tu
agt7uur.
a4g3ui
ag5ure
ag5uur
ag-7lag.
aher4
ahe5ri
a4hs.
ai1
aig6ne.
ai^^ef5er
ai4lp
ain6ste
aip6eis
ai3s4k
ai5sla
ais4p
ais7prys
ais4t
ai3tj
ai3t4r
a4k5aan
ak5arb
ake6lee
ake6lof
ak5ess
ak5ins
akis4
akis7te.
5akkoo
a2k3l
a5klank
ak6leet
a2k3n
ako6bre
ak5oms
a1kr
a4k3re
ak5rig
ak4sc
ak5sme
ak3sp
a4k3ui
a2kw
ak3we
ak5win
a3ky
a4kys
a1la
ala7gadi
a5lagm
al5agt
ala7kled
alan7gaa
al5dei
a4lef
ale6str
al4f3e
alf6eni
al4fh
al5fie
al4fj
alf7olie
alf6sko
alf6sni
alf6sta
alfs7tan
al4fu
alf4-
5algori
alien5s
ali6gal
ali7glas
alk7aard
alk7laag
alk7oond
alk5sp
al4kui
alk7wyk.
5alleen
alm7eier
alm7lont
a1lo
als4a
als7agti
als7ghaa
al6skel
als7kelk
als5li
al4s5oo
als7pret
als5waa
als7werw
alt6hea
alt6hus
alt7rots
alt6sas
alt6wee
a1lu
alve5o
a2m
a3ma
ama3k4
aman6t5j
ama7rins
am5atoo
5ambag
5ambass
a3me
am5egt
ame6sin
ame5sm
ame6spo
a3mi
ami7skyw
amm6afu
5ammun
a3mo
amp7arre
amp7lag.
amp7leer
amp7lig.
amp7lug.
amp7omhe
amp7se^^ebl
amp7sfee
amp7sier
amp7staf
amp7staw
ams7esel
am6s5kop
ams7lend
am6smet
ams7meti
ams6mul
am4s3o
ams7pels
am6swan
am6swar
ams7wyn.
a3mu
a4mui
am5uit
a3my
an5agt
ana7kwal
an5alf
ana6spi
an4c-
and7aans
and7adel
an6dakt
an5dan
and7anal
an4dap
an6dase
an6datt
and7attr
an6degt
and7egte
and5eks
and7emal
an6derf
and7erf.
an6dete
and7etes
and7eval
an6dinw
and7inwa
and6ja.
and6jar
an4d5om
an4don
an4d5op
and7oud.
an6drak
an4dro
and6ser
and6s7kop
and7spaa
and7spre
and7steg
and7swee
an7dwing
and7wyn.
ane6ron
ang7aal.
ang7adem
ang7ghor
ang6hai
ang6lad
an5g4li
an6glig
ang7lig.
ang7lip.
ang6nol
ang6ons
ang7ore.
ang7repu
ang7sakm
ang6ska
ang7snee
ang6s7te.
ang7stem
ang6sur
ang7ure.
anie6t5r
an5inl
ani5sf
ani7slaw
an6kase
ank7asem
ank7refe
an4kry
ank3w
an5ops
an5opt
an5opv
an5ord
an5org
ano7roei
ano7stoe
anr6hyn
ans7aalw
an4s5am
an6sass
ans7asse
an4sc
ans7eila
ans7eura
an6sink
ans7ink.
an6sjek
ans7jekk
ans7jord
an4ske
ans5kei
an6skin
an6s5kop
ans7kous
an6slat
ans7mada
an4sn
ans7oran
an4s5pa
an6sper
ans7pet.
an4spo
ans4ti
ans7toil
ant5aan
ant5aar
an6tass
ant7asso
an4tei
an6teks
ant7ekst
5antenn
ant7ete.
an6tins
ant5jo
an4tol
ant7opru
ant7rest
ant5rin
ant7rob.
ant6ski
ant6sko
an4tui
5antwo
a1ny
a1o
a2p
a3pa
a4p5aan
a4p5agt
ap5aks
ap5arm
5aparth
a3pe
ape6nop
a3pi
api6rfa
ap3l
a3po
apo6kaa
ap5ond
apo5sta
5appar
ap1r
ap5rol
ap3ru
a4pry
ap5ryk
a5prys
ap6sall
aps7alli
ap6seko
aps7iden
ap6skof
ap6s5taa
ap5sti
aps7toet
aps5we
a3pu
a4pui
ap5uit
a3py
a1ra
ara7gwan
ara7klee
ara6kop
ara3p4
ara6ppa
ar6d5agt
ar6das.
ar6datm
ar5der
ar6deti
ar6d5opp
3area
aree5s
areg7swe
ar3ei
are7knip
ar5fla
arg4h
ar5gha
5argite
ar4gl
arg4o
arie4f
ari6jke
ar6k5ana
ar6kini
ark7leer
ar5klo
ark6los
ark7onvo
arko6v.
ark7snui
ark5sp
ar4kw
ark5wa
arn6avo
a1ro
aroet6j
aroe7tji
aroo5h
aroom4
aroo5p
aroo5s
ar3op
aro6wva
ar5rag
arres5t
ars5ag
ars7elek
5arsena
ar5sie
ars6kou
ars7krap
ar6skre
ars7kree
ar6skro
ars7pan.
ar4spr
ar6stal
ars7tall
ars7tee.
ars6-in
ar6taas
art7aasv
ar6talb
art7albu
ar4t5as
ar4tc
ar5te.
art7eend
ar5teh
ar4tei
art6hol
art6hur
art6omo
art5oog
art5oor
ar4tor
art7reek
art7roep
art6ryb
art7samb
art6slu
art6spr
art7spyn
a1ru
arus6o.
a1ry
ary7taal
as3ag
as5app
as3c
as4d.
as4dh
as5egt
ase6rak
as5ete
as3f
asg6hit
as4hi
asi7freu
a4sj.
a4sjm
a2s3k
a5skool
a5skri
as5kru
a2s3l
as5laag
as3m
a4smy
a4sna
as3no
as9of.
as5ogi
a4s3oo
as3op
as3p
as4por
as3t
as4t.
a5staa
as4th
ast6les
a5stof
a7strak.
a5s6tran
a5s6troo
as3w
a4sys
as5yst
at5aar
a4tag
ata3s4
ata6sse
atas7se.
ata6wba
ate5it
5atelj
ate6rar
ate6rer
ate6ron
a6tetes
ath7cart
a5t4hee
ath7kinp
ath7lone
atie6te
a2t3j
atk6v-s
5atleet
5atmos
at5oog
at5ry.
ats7alma
at6sint
ats7inte
at4sj
at6skin
ats6kom
at6skop
ats7kop.
ats7krip
at4s5le
ats7lykh
at4sm
ats6maa
ats7nood
at6somw
ats7omwe
at4son
ats5ond
ats7onko
ats7onlu
ats5op
ats7ower
ats7tend
ats7trek
ats8treke
at6stro
ats3w
at5the
att6hys
at4tu
atu6maa
2au
aud6rey
au5gra
aug6sbu
aul6spo
au3p
aure5u
auri5s4
aus4t
aus7tin.
au5str
aus7tus.
aut6ste
ava6lop
ave7lott
avlo6v.
3avon
awa7glas
awas4
awe5ga
awe4r5a
awer6ui
aws6han
ax5ofo
a3ya
ay4a.
ay5ist
ayn6ard
ayn6or.
a3yo
a3yw
azoo7ka.
azz7agti
az4zl
azz7orke
1^^e4
1b2
2b.
babak4
bab7wi^^ebr
ba4d5ra
bad5sp
ba4kin
ba3kl
ba4kla
ba6kleu
ba4k3o
ba4k3r
bak3w
bal6kla
ba4lo
bal7onts
bal5or
bal7tsas
ban4da
ban6dek
ban4d5r
ban7glad
bang7ste
bangs8te.
ban4k5a
ban6kre
ban4kw
bar7kaan
bar4s3
bar5th
bas7ekst
bas7ghit
bas7jan.
ba4sn
ba5spe
bas7peer
bat5aan
ba3t4j
2bb
b3ba
b3be
b3bi
b3bl
b3bo
b3by
2bd
b3de
b3di
b3do
bed7slaa
bed6sta
beds7taa
be3dw
beel6dr
bek7neus
bek7wind
bel6aga
belk6li
bel7klik
bel6ldo
ber6gaa
berg7aar
ber4gl
ber4g5r
ber7grys
ber6gzi
bers7pan
ber6spr
bers7pre
bert6sk
bes6aan
bes4k
be5ska
be3sl
be3sm
be3so
be5son
be5s^^f4r
be3s4t
be6s5ter
be5sti
be6stia
bes7tial
bes7trol
bet4h
be5tha
bet7hesd
be5ton
be3tw
2b1f
2b1g
b3ge
bid3s
bi4du
bid7ure.
bie6dui
bie4g
bieg5r
bi4jl
bin6dri
bio7sfee
bi4rc
bis4a
bis6ho.
bis7scho
bi3tr
2bj
b3je
2b1k
b3kl
b3ko
b3ku
bla4d5a
bla6don
bla4d5r
bla5so
4blau
bleem5
ble4s
ble7ser.
bles5k
ble6tji
blet7jie
bl^^ea6rfl
blik5o
blix7en.
blo4k3
blo7kaal
blo4m3
blu6sem
bly7mare
bly3s4
2b1n
b3no
bob7slee
boe6kil
boe6kom
boe6koo
boer6st
boers7te
boe4s5k
bog7gher
bog7skut
bo2k1
bo3ka
bok6aak
bok6ale
bok6as.
bok6erf
bok6ies
bok3l
bo7kleed
bok6om.
bok6ors
bok6ost
bok3r
bok6rag
bo4m5aa
bom6aat
bo4m3o
bon6dam
bon6dra
bond7raa
bon6tel
bon4t5r
bo9op.
bop6laa
bor6dak
bor6des
bor4g5a
bor6gri
b4ors
bor6saa
bor4s5k
bor4s5l
bor4s5t
bo2s
bos7anem
bos7jamb
bos7pepe
bos7taai
bo5s4tr
bos7uil.
bo5t4ha
bot6sto
bou6it.
bou3s4
b3pr
brand5a
breek5
br4ei
brei5s4
brengs7t
brie6kw
briek7wa
3bro
bro4n
bro4sk
bro6vni
bro6wni
bru4l
4brup
br4^^fcm
2b1s
b3se
b3si
b3sk
b3so
b3sp
b3st
bs4ti
b3su
2bt
b3te
b3ti
buc7cleu
buik5s
bui5t4j
bult7af.
bul4t5j
bul6top
bult7op.
bul6tui
bun7senb
bus6had
bus7toer
but6hel
buu7rend
2bv
b3ve
b3vi
2bw
b3we
by1
by3d
by3k
by4lb
by4lt
by3n4a
by3s
bys6kot
bys4l
bys6tek
bys7ter.
bys6tor
bys4w
byt7alka
byt7eier
by3tr
1c2
2c.
ca4es
cam5ph
ca3pr
ca3ra
car6lto
caru7so.
cat4h
ca5tha
2cc
c3ca
c3ch
c3ci
c3co
ce4st
ces5te
2ch.
che6lan
5chemi
che6reg
che5r4i
che7ryl.
che7styl
che6vvi
ch5hoe
ch5lei
ch5nik
cho7rage
ch5sia
2cht
2ck
c3ke
cot7rand
cove7ry.
2ct
c3ta
c3to
c3tu
cus5to
cyp7rian
1d
2d.
4d5aanb
d5aand
4d5aank
d5aansl
daard5u
4dabs
2d1af
da2g
da5gas
dag5et
da5gha
dag6ham
da5gra
dag4sk
dag5so
dag7ster
dak7lei.
dak7oorh
da4k3r
dak5wa
4d5alar
4damb
dam6plu
3dan
dan6k7erk
dan6sak
dan6sko
dans5m
dan4so
dan4s5t
dan4t5r
daph7ne.
dap4l
da5pla
4d3arm
4dart
d5arti
da4s.
das7lag.
das7traa
da3t4j
2db
dby6lvo
2dd
dda5kl
dda3s4
dde6lee
ddel5so
dder7aal
dde6ras
dder7as.
d3dh
dd4hi
deba4t
dee4g
deeg5r
dee4l
dee7lig.
4d5eenh
de^^eb7skou
4deg.
2dei
de3ka
dek6aan
de6klad
de6k5lat
de6klei
dek7lei.
de4kna
6dekono
de6krie
dek7riet
4deksa
dek6ska
del7appe
del5eeu
del5egg
d5elekt
del7elek
6d5eleme
de6leng
del7enge
del6fer
del5fi
del6fos
delf7os.
del5oor
del7oper
del6ser
del4so
del7sold
del7sone
del4sp
del6str
del7stre
delt6ag
del7tagt
del7weis
4demm
dem6pla
den6din
4d3eng
4denj
den6kar
den6kja
den4k5l
den4kr
dens7pre
den4t5j
den6tri
deo7plek
deo7sfee
3dep
der5ast
de6reen
der7een.
der7emig
der7ent.
der7flap
de6rin.
derm7ins
der5na
de4ro
de5rob
de5roe
der5of
de5rol
der5on
der5ow
der5ps
der6sjo
der5s6kr
der6slu
der6spu
der7thal
der6uit
de5sag
des7alni
des5ap
de6seng
des7enge
de4s5in
deskat5
de6skor
des7leed
de4sn
des7offe
des7oksi
de4s5on
de4sor
de4spa
des7pari
des7po^^ebs
des7prik
des7taal
des7tele
de4sti
de5stig
de4sw
des7we^^eb.
4d5ete.
deten6te
de3tw
4deuro
deur5s6w
2d1f
2d1g
dge5sp
dg4li
2dh
dias4
dia7stol
dia6zvi
dic7kie.
dic7tio.
die6fal
die6kes
5diens
die4pl
die6tom
die4t5u
dig6ofa
di4gre
digs4
dig7skro
dig7som.
di6kamp
dik7amp.
di4k3l
di4kr
dik7ribs
di4kw
dik7wyn.
di4l5al
din6gas
din4gr
4d3inl
4dins
4d3int
4d3inv
di6sass
dis7assi
di4so
di5son
dis6pne
dis7quis
dit6hak
dit7jies
2dj
dja7dji.
d4ji.
d4jia
2d1k
dklo4
2d1l
d3la
2dm
2d1n
doek5r
doe6lon
doe6sko
does7kop
2dof
4dogi
do4l5os
dol6sou
dols7ou.
3dom
dom6pli
dom6sap
4d5omse
dom7slim
dom6sw^^ea
4domt
don4sk
4d5oord
4dopn
dop6rof
dop6rys
3dor
4d3org
dor7othy
dor4sl
dor4st
dos6tel
dou3t
do3y
doy4e
2dp
d2r
3dra
dra6gaa
4d5rand
dra7stan
4dre^^eb
4d3reg
d4rela
d4rew
4driff
d5rigt
d5riss
4driv
dro^^eb7ys.
4d5rond
d5rooi
4d5roos
dr4op
dro6pan
dro5pn
dro7sfee
4d3rug
d5ruim
d5ruit
4d3rus
4d3ry.
4d3rye
4d3ryk
4drym
d4ryw
2ds
ds5aamb
ds5aar
d4s3ad
d5sakr
ds5aks
ds5angs
d4s3ar
ds3as
d3se
d4s5een
ds5eis.
d4s5eko
dse4l
dse7leer
d4s5eng
d4s5era
dser6tj
dsert7ji
d4s5erv
d5sfeer
ds3id
ds5imp
ds5inde
d4s5ins
ds5int
d2s3j
d5skee
d4skin
ds5kind
d4skis
d5skole
d4skom
d5skoo
d6skraa
d6skrit
d6skroo
d4s3le
ds3li
ds6luie
ds3m
d5s4mee
ds6moor
d4sna
ds5neu
ds5noo
ds5not
d2s1o
d3soe
d5some
ds3on
d7sonde.
d7sondes
dson4t
ds5oog
ds3op
ds3ow
d5s4pel
d5spes
d3spi
ds5pop
ds6prek
d7spreker
ds7preki
d1st
ds5taak
d4staf
d5stand
ds5tea
d5stel
ds5tent
d5ster.
ds5terr
d5sters
ds4ti
d3str
d3stu
ds3w
d3sy
2dt
dter6tj
dtert7ji
du4e-
duns6te
dur6rhe
dusie5k
dus6kap
dus6pel
2dv
dverdiens9
dverdien8st
dve6sid
dvie4
2dw
d4waal
d5waar
5d4wang
dwa6nor
4dwarm
dwar7se.
d3wat
d4weil
5dwerg
dwerk5o
dwe6tar
d3wil
d4wing
4dwoo
d4wyn
dys5ag
dys6mit
dys7tuin
2d-
d-r6hod
e1a
eam6ses
eang4
eate4
eau7mont
e3ba
eb5adr
eb9cu.
ebou5t
ebou6t.
eb4re
ebrons5
eb5tui
ec5cle
e4chn
ech7tiaa
eda7gaat
eda5go
e3de
ed5eis
eder7as.
ede7ring
ede6sap
ed5off
edors5
ed4ra
ed5rep
ed6saks
eds7kalm
ed4sl
eds7lafe
eds5om
ed3sp
ed5s4we
ed5uit
ed2w
ed5woo
ed5yst
ed3yw
ee5agt
eed6atu
eed5we
ee4dy
ee2f
eef7laag
eef7lopi
eef7rant
eef7rek.
eeg3l
eeg5ru
eeg3s4
eeg6sdi
e5eila
ee2k
eek5ass
ee5klaa
ee5klag
eek5lo
eek3n
eek5og
eek7oors
eek7rooi
eek3w
eek6wal
eel5ap
eel6doo
eel7doos
eel5een
eel7eer.
eel5ei
eel7indr
eeling7s6
ee6lins
eel5int
ee4l3o
ee5lob
eel6ood
eel6oon
eel5sa
eel7snag
eem7onde
eem5ou
ee2n1
5eendj
een6ema
ee5nen
3eenj
eenk4
een5kl
een7slot
een5sm
eens6pa
een7swee
een7topp
ee4ny
eep7esel
eep7leer
eep7loog
ee4pop
eep7roes
eep6sam
eep7skep
eeps5ko
eep7skui
eep6sti
ee2r
eer5ap
ee5red
eer5ee
eer5end
eer5in
ee5rob
eer7oes.
eer5om
eer5on
ee5row
eer5ps
eer7skur
eers7lam
eer7smed
eer6sow
eer3u
eer6ust
eery4
eer5ys
ee2s3
ee4s.
ees6ala
ees6ap.
ees6lep
ees5me
ees7muil
ee5sna
ee5sny
ees6op.
ees6pre
ee5staa
ees6tal
ees4tr
ee6styd
ee4sw
ee5syd
ees6yfe
eet7appe
eet7eenh
ee4ti
eet5in
eet7rek.
ee6troe
eet7roed
eet7ruik
eet7wiel
eeu3g4
eeu5in
eeus4
eeu7spoe
eeu5tj
eeu6ur.
ee5yst
e3^^ear
e^^eb5aan
e^^ebks5t
e^^ebl7eier
e^^ebl7yste
e^^eb4na
e3^^ebr
e^^ebr7agti
e^^eb5ran
e^^ebr7arm.
e^^eb5rod
e^^ebr6ske
e^^eb4sk
e^^ebt6ste
e^^ebts7te.
e4faf
ef5afs
ef5eks
5effek
ef5inh
e1fl
ef5loo
e4fly
ef5oms
ef5oue
ef3st
efs6tal
eg5amp
ega5s4k
e3ge
ege6las
egel7as.
eges7per
eges4t
ege6vwo
e6ginko
eg5ogg
eg5rig
egs7enti
eg6sins
eg6s5int
eg3sk
egs6lot
egs6pre
egs6pri
egs6pyk
eg6s7taal
egte6re
e4g3ui
eher6in
ehe7rinn
eho6kra
eib7niz.
eid7rok.
eid7saam
eid7salo
eid7sirk
eid7skou
eid7sku.
eid7spa.
eid7spek
eid7ste.
eid7stoo
eid7sug.
ei1e
eie7naan
eig6h-n
eig7opro
eik7aard
ei5kno
eik7wydt
eil6spa
3eind
ei4n5ed
ein7eed.
ein7glas
ei4non
ein7oord
ei4n5op
ein7otte
ein6sad
ein6sep
eis7angs
ei5sei
ei6s5ind
ei5sja
eis7kamm
eis6kaw
ei5sk^^ea
eis6kot
eis6laa
4eiso
eis7ouer
eis6pir
ei5s6tel
ei5s6tre
eit2
eit7hand
ei3tj
eit7klin
eit7nisp
eit7onde
ei5tra
eits5ko
eits5l
eits5o
eit7spor
eit7stak
eit7stra
eits5w
e^^ef5mit
e^^ef4na
e^^efn7klin
e^^ef4no
e^^ef4nu
e^^ef5oni
e^^ef4sl
eja7stas
ek5aan
ekaars8te
ek5aks
e3kan
ek5asg
e3ke
ek5een
eke7naar
eke6tam
e3k^^ea
e4k5ins
ek3k
e4k5les
e5kleu
e4kl^^ea
ek5log
e3koe
eko6mol
ekom4s
ek5omsl
ekoms5t
5ekono
ek5ooi
e3kop
eko6pap
e4k5opm
ek5opn
ekor6da
eko7rum.
ekou6st
ek5owe
e1kr
ek5rad
e4k5rok
e5krom
ek5rug
ek6sapp
5eksemp
eks5esk
eks7inge
eks7logi
eks7loks
eks7outo
eks5pir
eks5po
eks6poe
eks6tel
ek6sten
ek4sti
eks7uur.
ek5uit
e4kw^^ea
ek5wie
e4kwu
e1ky
e1la
e6l5aand
el5aanh
e6laanv
el5aard
el5adm
el5adv
el3af
el3ag
e5lag.
ela7klon
e4l3al
e5lari
e4l5arm
ela7slan
el5asp
eld7adel
el4dap
el5de.
el6d5ele
eld7erfe
eld7evan
eld7olie
eld7onde
eld7smid
e3le
el5eien
eleis6t
elei7sta
e6lelek
el5erts
ele7sett
ele6too
el4faa
elf6abr
elf6eit
elf7en-d
elf5erk
elf6lan
elf6les
el4fon
elf7onth
elf7ontp
el6foop
elf7oops
el6foor
elf7oors
elf6ron
elf7twyf
e3li
eling8stell
el5inh
e6linko
el5inv
elk7nage
elks4
el4kwi
el4lv
elm5agt
e1lo
el4ob
e4lol
el5oli
el5ond
el5ont
e4loor
e4l5opd
el6ope.
e4l3or
el5phi
els7angs
el5sfe
el6sind
els7indr
el6skan
el6skom
els7korr
els7krit
els7lof.
el5smi
els7mora
els6nag
els7nood
els7onde
els7oork
el6stek
el6s7tran
els7ware
el5swee
elt7akke
e1lu
el5uit
eluit6j
elui7tji
e3ly
ely6kaa
em5app
e5masj
eme6lek
eme6lew
eme6ron
eme4s
eme7sis.
emes5m
emes5t
e5metf
em5eva
e4moef
em3op
em5org
emp7laag
emp6skr
ems4p
em5spl
e4naf
ena7glas
en5agt
en5akk
en5alt
e4n5art
ena6spe
en6d5agt
ende7ro.
end7raak
end7rit.
ends7o^^eb.
end7sons
end7ure.
end6wer
en5eil
en4en
e4n5ent
5energ
ener6tj
enert7ji
eng6hor
eng4la
eng6lor
e3ni
en4ig
en4im
en5inh
e6n5ink.
eni7soms
3enji
en6kinh
enkom4
enkoms5
enk3w
e5nomm
eno7ryn.
en5out
ens7adem
en6sall
ens7are.
ens7eise
ens7elek
ens7elik
en5sen
ens5erv
ens7esse
ens6haw
en5sie
ens7inga
en5sji
ens7koei
ens7kyke
ens7luik
ens6med
ens7nuk.
en4son
ens7onru
ens7onva
en6spei
ens7pist
ens7pot.
en6spou
ens7pous
ens7taak
en6stak
ens6tam
en6steh
ens6tei
ens6tel
ens7tele
en7sters
en7s6tes.
ens6tet
ens6teu
ens6too
ens7toom
ens7trek
ens7uil.
ens7ure.
en5sy.
ent5akt
en6teks
ent7inte
ent7rif.
ent7rok.
ent6sin
ent6son
ent6spa
ent6wen
en3ui
enu6lin
enu5sk
enu5st
e3ny
en-7steg
e1o
eoe4s
eo5fag
eo3g4n
eoi6ste
eop6lek
eo3ro
eo1s
eos4t
eo3tr
e4paf
e4p3ag
epe6loo
ep5emm
ep5epi
epers7te
5epidem
e4p5int
ep4la
ep5lap
ep5ligg
ep5lus
epoet4
epo6nin
ep5ops
e4p5rei
eps7ameu
ep6s5eis
eps5id
ep4sj
ep4sk
eps7kano
ep5ski
eps7kohe
ep4slu
eps7luik
eps6oms
eps5on
ep4s5pr
eps7waar
ep5uit
e1ra
er4a.
er5aan
er5afd
er5afh
er5afsk
er5aft
er5afv
er5afw
er3ag
era7gree
era7kles
er5aks
er5akt
er5alb
er6ald.
er5alt
er5ana
e5randa
e4rapp
er3ar
era6ser
era7uitv
erd7ryle
erd7slip
erd7tree
er3dw
er4eb
er6eenk
er5eers
er5eff
er5eie
er5eil
er4ek
er5ekst
er5elm
e4r5emm
e6rengt
e4reni
e4renj
er5erg
er5erv
e3r4es
er5esel
ere7spio
eres6ta
ere6stp
ere7temm
e5rewa
e1r^^ea
er4fh
er6flaa
erf7leen
er6flet
erf7lett
er5flo
erf7lug.
erf7lus.
erf7omhe
erf7oom.
er4fp
erf7reuk
erf7ruik
erg7aren
erg7lyn.
erg7renm
erg7rymp
erg6rys
erg6sho
erg7stra
erg7uitj
er4id
eri5fr
e3rig
eri4g5a
e4r5ind
e6rink.
e6rinna
er5ins
e4r5int
e6r5ital
eri7trea
erk5aan
erk7esel
erk6has
erk7ink.
er6kins
erk7inwy
er4kj
er6klat
er5kle
erk7onde
erk6opn
erk6s5on
erk7spas
erk6sto
erk7uurr
er6kwe^^eb
erk7we^^eb.
erk7ywer
er5lik
er5lui
erm4a
erm7aanh
erm7afsl
ern7eiwi
ern7kwes
er4nm
er4nn
ern7oes.
er4nr
e1ro
er5oew
er3o^^eb
er5ogg
e3ro^^ef
e5rok.
e4r5oks
e4r5oli
er5om.
er5omh
er5oms
er6ona.
er5oog
e5room
er5oond
e5roos
e4r3op
e5ropa
er6opla
e5ropo
e4ror
e5rora
5erosi
e4r5oss
ero7stil
er5oud
er5oue
erou6t.
erp7anke
er6pinh
erp7inho
erp6lan
erp7ruik
erp6sig
err6ein
ers7assi
er6s5eli
ers7ete.
ers7inda
ers7jean
ers7kaia
er6skaj
ers7kaju
er7skake
ers7kaki
ers7kete
ers7kiss
ers7koet
ers7koor
ers7kop.
er5sky
ers7less
ers7lone
ers7luid
ers6mal
er7smara
er6smat
er4s5om
ers7onvr
ers6opn
ers7ower
ers7pien
ers7put.
ers7scen
er5ste
ers7tele
ers6teo
ers4ti
ers7treg
ers7waar
ert5aan
er6taap
ert7aap.
er5tap
ert7ape.
er6tend
ert7end.
er5tes
ert6hal
ert7jakk
ert7opin
ert7orre
er6tres
ert7rok.
erts5l
ert7uur.
ert6wak
er5twi
e1ru
erug3
er5uin
er5uit
er3uu
e1ry
ery7doel
ery7salf
erys6ma
ery7smaa
ery7suur
ery7trek
e5saan.
e5sage
es5agt
es4ak
es5all
esa6mol
es4an
es3c
es4dh
e3se
e4s5een
e4s5epi
es4er
e3si
es4ia
es4ie
es4if
esi6gei
e4sill
esin6s5i
es4it
e2sj
e4s5ke.
es5kle
eskor6s
eskors7t
e5s4kut
e3sla
es5lem
es4lip
e1sm
es4me
es5me.
es5men
es9m^^e8.
e5smou
es4mu
es5nie
es5noo
es4ny
esoet6j
esoe7tji
eso7fagu
es4ol
e3s4oo
es4ou
e1sp
e5spel
es5pen
e4sper
es5pet
es5pir
es4pli
es4pra
ess6opv
e1st
es4t.
e5stad
es5tas
e4s5te.
es5tea
es5teli
e4s5tes
estes5o
est6her
es6tik.
es5toi
es5tos
e6strak
es4tre
e5stuk
e3sw
es4yd
e4t3ag
eta7stas
e3te
e4t5eie
ete5r6aa
etie4l5
5etike
et7jie-k
etk6ysi
eto6nop
et5opv
e4t5ord
e4t5ram
e6treke
e6treko
etre7kor
et5rim
ets7fyn.
et6skat
ets7kato
ets7kous
ets7krie
et6s5lap
ets6maa
ets5ong
et6spaa
et4spr
et6stek
ett6re.
et5uits
et5unie
et4wi
et5win
et4wy
et5yst
2eu.
eug6rie
e3uit
euk7inte
euk4l
eul7eien
eu4loo
eu5mon
eum7uitg
eu4na
eun6sla
eup7aand
eu4ra
eur5aa
eur6aal
eu5ral
eu4ree
eur7eet.
eu6reg.
eu6regt
eur7egth
eur7ekst
eur7elem
eur7spar
eu4sa
eus7ape.
eus7jig.
eus6kot
eus6tac
eute4l
eu5tem
eu3tr
e1uu
2eu-
eva7kwaa
eva6les
evr6ore
evu6es.
ewal4s5
ew4ar
ewee4
ewe7gaan
ewe7goed
ewe7inde
e5weis
ewe6nee
ewen8stes
ewe6res
ewe7span
ewik4s
ewiks7te
exy7ste.
eyn4o
e5yste
e3yw
e4zka
ez9ra.
^^e81r
^^ea1
^^eae4ro
^^eala7flui
^^ea4rde
^^eare6loe
^^ea4rhe
1^^eb
^^eb1g
^^ebi3e
^^ebk4sk
^^ebks3p
^^ebks6pek
^^ebk4st
^^eb3laa
^^ebl5agt
^^ebl5alb
^^ebl5as.
^^eb4lei
^^ebl5ent
^^eblf4l
^^ebl5fle
^^eb5loop
^^ebls7kuil
^^ebn5agt
^^ebn4tr
^^ebnt5re
^^ebpre4
^^ebr5aan
^^ebr5afd
^^ebr5off
^^ebrog4
^^ebro3s
^^ebr5owe
^^ebrs7kent
^^eb1ry
^^eb1s
2f.
1fa
f5aanb
f3aar
f3ad
2f1ag
f4agi
fah7renh
fai6r-n
fak6ste
faks7te.
fan4t5j
fan4tr
fant6s5t
f3ap
f3art
faru6q.
2fb
2fd
f5dein
fde4s
fde7sake
fde7sess
fde7skei
fde7stor
fde7stra
fde7sust
f3d2w
1fe
4feen
3f4ees
f3eie
fe4l5ap
fel7asem
fel7enti
fe6loon
fel7oond
fel5s4m
fel6spoo
fe4lu
fe4ly
fel5ys
fer6skr
fers7kra
fer6sku
fers7kui
f5erts
fe2s
fes3t
fet7ete.
f1f
ffe6las
ffe6ret
ffe6tet
ffi6eek
ffies6m
ff5rei
f1g
fge7sper
fg4ha
fg4li
fg4ly
fgod4s5
1fi
fi3d
fid6ji-
fie7ekst
fie7lafo
fie7smaa
fie4s5o
fie6tol
fi5lag
fil4m5a
4finr
fi5sto
fit4z
2f1k
fkom6st
fkoms7te
fla4p
flap5o
f2le
f5lees
f5lese
fle4t
flet5j
flex7or.
2fli
5f4liek
3f4lit
2fm
fmo4no
f1n
fni4s3
1fo
f3of
4foff
fok4s5t
fol4k3
4foms
5fonds
fond6sk
fond6st
fonds7te
f5ontb
5fonte
f5ontl
f5oorl
2fop
fo4po
fop7spen
f5orde
f3org
for7oksi
fo5rom
fo3ru
fos7feen
fout5j
fox7hill
fox7stra
fp4sa
1f2r
frag6aa
4fram
f4ras
f4ren
fre4s5k
4f3rig
fri6too
f4rod
fru5ga
f3ry
2f1s
fs5agt
f4s5ank
f4s5eko
f4skon
fs5log
f3sm
f4sma
fs4me
fs4mi
f3sp
fs4pl
f4spro
f4s5tak
fs4ti
2ft
ftre4
ftre5d
ftrek5
1fu
fu4ch
fur6ore
fu3so
4fuur
f5uur.
2fv
fva4l
2fw
1fy
fyn7goud
2f1ys
fyt7appe
fyt7jie.
2g.
1ga
g4aai
gaam6s7te
g4aan.
g5aanbi
g6aandh
g5aanl
g5aanw
g4aat
4g3add
2g1af
g4afo
2g1ag
g4agr
ga5gre
gag6rep
gak4l
ga5kla
gal7afsk
gal7appe
galei5
gal7oog.
gan6gra
4g5anke
gans7ke.
g3app
ga3ra
4g3arb
4g3arm
gar4s3
gars6ti
gar7stig
g5arti
ga6sarm
gas7arm.
gas6mok
ga4so
ga5sol
gas6pel
gas6tre
ga4tr
gat7ruik
gay7nor.
2gb
gbys4
2gd
gde7roof
gdut7jie
g3dw
gd4wa
1ge
ge3d
gedi4s
g5eenh
gee6tal
geet7al.
ge^^ebs3
ge^^eb6sti
ge3f
4ge4ff
gef4l
ge1g2
4geg.
geges5p
geg6uil
g3eie
ge^^ef7migr
ge7k6lik.
4geks
gek4y
gel6agk
gel6dad
gel4do
ge5lol
ge5loo
ge6loon
gel7oond
gel6s7te.
gemi7au.
gem6opp
3gen
gen4dr
gen6dur
genes5t
4geng
ge4oi
gep4a
ge5pag
geper6st
gepon6s
3ger
ge5rap
ger6ard
ger5ete
ger7iden
ge6roef
ger6ogg
ger6spo
ger5sw
ger6uit
ge3sa
ge5sfe
ge5sin
ges7jagt
ges4k
ges7kade
ge3sl
ge3s4m
ge5sne
ge3sp
ges7perb
ges7pers
ges7pes.
ge3st
ges6tas
ges6tig
ges4w
ge5tja
ge3tw
ge3ui
ge5um.
gev7woes
gewens7te
ge1y
2g1f
g3fl
gf4li
2g1g2
g3ga
gga7kwee
gga7stre
gga5t4j
gge6sti
2gh
5g4hoer
gho7ghok
gho4l
5gholf
g4hs.
ghu6moe
1gi
g5iden
gie6far
gi4fa
4gimp
gin6gaa
4g5inri
gip4s
gip7siet
gis7enti
gi5tra
git5sw
2g1k
gkaar4
5g4lans
gla4sa
gla6sel
gla6ska
glas5o
g4le.
5g4len.
gli6don
g4lif
gli6gur
4glik
g4lim
g4lip
3glis
g4lob
4glod
3g4loe
g4lof
3g4lom
g3lop
3g4lot
g4lo-
g3lus
3g4luu
g4ly.
4glyn
2gm
gma7skui
2g1n
gneem5
gneet5
gnie6ko
1go
god6sak
god6sid
4g3oef
goe7krui
4goes
g5oes.
g5oeta
goe7the.
go^^eb7lary
2g1of
3gogi
gol4f5o
4g5olie
go4mag
4g3ong
gon6sto
g3ont
goo5gl
4g3oor
2g1op
go5pla
3g4opo
g5orig
go3sl
gos7pelr
g5osse
go3s4t
gou4d3
goud6a.
gou7dief
gou7dini
gou7dink
goud6s.
gow7rie.
go9ya.
2gp
1g2r
g4rab
g5rak.
gra4ma
gra7mado
gra4m5o
g4ras
gra4s5a
gra4se
4g3red
g4ree4
g5reek
greep5
4gre^^eb
g4ren
gren6st
g5rese
gre4sp
gre6sur
gre6tji
gret7jie
g4reu
griek6s7t
grie6t5j
4grig
gri4p
g5rit.
4g3rok
g4ron
4g5rooi
g5rook
g5room
g5rowe
4grug
g5ruim
4g3ryk
4grym
gry6ste
2gs
g2s1a
g5saam
gs3ad
gs6ade.
g4saf
gs5agt
gs5aks
g5sala
g5sale
gs5ana
gs5ant
gs5app
gs6appe
gs3ar
gs3as
g4s5een
g4s3ef
gs5eis.
g6seise
gs5eko
gs5eks
g5sekt
g4s5ele
g4s5eli
g4s5ene
g4s5est
g4sew
gs5ewe
gs3f
g5s6feer
g4sid
gs5ide
g6simpa
gs5inde
gs5ini
gs5inl
gs5ins
g2s3j
g2s1k
g5skaal
gs5kab
g5skad
g6skapa
g5skatt
g5sked
g5sker
g7skeur.
gs7keurd
g3ski
g4s5kin
g4skl
g5skof
g5skole
g4skom
g5skoo
g6s5koor
gs5korr
g5skot
g5skou
gs3kr
g2s3l
g3s4la
g5s4lop
gs3m
g5snel
g2s3o
gs4ol
gso6pro
gs4ou
gs3p
g5s4pel
gs5per
g5spes
g3s4pi
g6spill
gs4poe
gs6pore
g7sports
g5s4pru
g1st
g6s5taak
g4s5tab
gs6tabi
g4stak
g4stal
g4star
g4s5tek
g6stelg
g6stera
gs5teri
g6sterr
gster6s
g6stese
g4sti
g5stigt
g4stoe
g7stoele
gs5toer
gs5toet
g4s5ton
gs5trad
g6strak
g6stran
g6strap
g6strib
gs5troe
gs7troon
g6struu
g4s3ui
gs3w
gs6werw
2gt
gte7eenh
gte7lagi
gte6ras
gte6rer
gte4ro
gte7roer
gte7rol.
gtes4
gte7sfee
gte7smee
gt5uri
1gu
gu2a
gu2e
gu5ela
guid6o.
gui6rla
4guit
2gv
2gw
g3yst
2g-
1h2
2h.
2ha.
hal4f3
hal6m5ag
4halo
hal4s5k
hal6s5tr
ham7pagn
ham6skr
hams7kra
han6dan
han7dja.
han4dr
han4du
han6gli
han6gor
hangs6l
hang5s6w
han4s5k
han6ska
har6dop
hard7op.
har6sel
har6sol
har6spa
har6t5aa
har4t5j
har4to
har7toem
ha4wk
haw7shan
hay6eli
heb7lus.
hee4l
heer8s7te.
hees6e.
heg7orga
heg7rank
heg7spyk
5heid.
heid7stem
he4ko
hek7saan
he4k3w
hel7ange
hend4
hen4so
he2r
her3a
he9ra.
her6akl
he7rald.
he5r4an
he3re
her7egpa
he4r5ek
he4r5ev
herf4
herfs5
her3i
her6ib.
he5rid
he5rod
he5rol
her5ond
her7ontm
he5ros
her6oss
he5rou
her5ow
her7sche
her3u
her5yk
he4sp
hes7peru
he4s3t
hete5r6o
heu6paa
he3us
hev3
he4vr
hewen7st
hie4r
hier7in.
hie7roni
hie7rony
hi^^eb1
hil6lbr
5hings
hing6s5t
hipe4
hi4rl
hi4sp
his5pa
hi4v-
2hl
h3li
2hm
h3ma
2hn
hode6sl
hodes7la
hoe7kaai
hoe6kys
hoe6spi
hoe4s5t
ho^^ebr7op.
ho4fa
hof5aa
hof7amp.
hof7uits
hog6hok
hoi7swer
hok7rakk
hol7aar.
holes5
4holf
hol5in
hol7oog.
4hon.
hon6daa
hon6dag
hon6dro
hop7land
hop7smaa
ho3ro
hor4s
hor4t5j
hos6hol
ho4ta
hou4t5a
hout5j
hou6tol
hou6tom
hou6who
2hr
hre6sto
hrie4
hries5
hris5t
h3te
h3to
hu9go.
hui6daa
hui6dui
hui6sef
huit6ji
hui7tjie
huk6hun
hul4p5a
hul6pek
hul6ple
hul6por
hul6ste
huls7te.
hu3mo
hum7oes.
humus5
huter6s
hut7jie.
hut6spo
hut6ste
huts7te.
h5vill
2hw
hyg7roma
hys3k
hys7tang
i1a
iaan6so
iaan6sp
iaan6st
iaans7te
iam7son.
ia4nop
ias6koo
ia5spo
ia5sta
ia5s4tr
i4baf
i4bag
ibou6s.
ic5ky.
i2d
i3da
ida7groe
id5agt
idde6ra
i3de
ide7snui
i3d^^ea
i3di
idia5s
id4ja
i5djan
i3do
i3dr
id2s1
id4s5et
ids7inoe
id4ska
ids7kerm
ids5kr
ids3l
ids7lags
ids7nye.
ids3o
ids3p
ids6pa.
ids6pek
ids6pie
id6spil
ids6pri
id6spry
ids7taal
ids7tee.
ids7teks
ids7tele
ids5ti
ids5toe
id6s7trek
ids7ure.
i3du
id3uu
ieding6s7
ied7ione
ied5rol
ied3w
i1ee
i4eee
ie5een
ie^^eb7aard
ie^^eb6lys
ief7alar
ie5fie
ie4f3r
ief7stal
ief7uitg
ie5gla
ieg7loka
ieg7riem
ie6grit
ieg5st
iek7asyn
ie5ke.
ie6k5erv
iek7esse
ie5kie
ie6klaa
iek7laai
ie4kni
ie6k5ond
iek7ople
ie6kops
iek7opse
iek5opv
ie4kre
iek7revu
iek7rigt
iek7ware
iek7wees
ie4k5wi
iek6wos
iek7wyd.
ie4laa
iel6afo
ie6lene
iel7oor.
iel6san
iel6s5on
ien7anal
ien7glor
ien6kro
ien7olie
ie4n5oo
ien4s
ien7sakk
iens5or
ien7sout
ien7span
iens5t
ien7stam
ien7stel
ien8stele
ien7stet
ien7stoo
ien5suu
ie4n5ur
ie6poog
iep7oog.
ie6proo
iep7rooi
ier7afma
ie6rafs
ier7engt
ier7eter
ier7neff
ier7omtr
ie4r5on
ier6oni
ier6ony
ier7swee
ies6amp
ie5se.
ie6senk
ies7enke
ies7ents
ies7ferw
ies7kaf.
ie6skon
ies7kop.
ies7kraa
ies6kry
ies7laag
ie6slep
ies7lepe
ies5li
ies7luik
ies7meub
ies7mooi
ie3so
ies7oes.
ies5ond
ies7oorp
ie6sopn
ies7opne
ies7pane
ies5per
ies7plig
ie6s7taal
ies6tas
ies7tee.
ie6steh
ies7tele
ies7tent
ies6tin
ies5uil
ie4s3w
iet7aans
iet7aard
iet7alba
ie5te.
iet7erts
iet7omse
iet7reke
iet7reko
iet4sl
iet7uie.
ie5twi
ie4tys
i1eu
i4eub
i4eud
i4eug
ieu7grie
i4e3ui
ieu7ing.
i4eul
i4eum
ieu7skot
i4euu
i4euv
i4euw
ie5wie
ie4w-
ie5yst
ie-7klik
i3^^e8r
i1^^ea
i^^ebl6sku
i^^ebn6tji
i^^ebnt7jie
i^^eb4s3t
i4fei
i4fim
i4fin
if1l
i2f3r
i4f3ui
i4g5aan
i4gap
igare4
igaret5
ig5eff
ige6naa
ig5ete
ig5ins
ig1l
ig5loe
ig4op
ig5opt
ig5org
igo7roos
ig5res
ig5roo
i4g3ry
ig3sa
igs6ins
igs7kaps
ig7skend
igs5ko
ig5sku
igs6mee
igs6ona
ig5soo
igs7poei
ig5sti
ig7stoei
igu7era.
ihu6ahu
i1i
ike6roe
iket5j
ik5kli
i2k3n
iko6nat
i1kr
ik6sakt
iks7akte
iks7iden
ik4sin
iks7inve
iks7juk.
ik6skom
iks7paar
iks6pad
iks7pare
iks6tik
iks6tuu
iks6wel
ik5wan
i4k3we
i4kwy
2il
i1la
il5agt
ila6too
ilbe6st
ild7agti
ild7smaa
ild6stj
ild7temm
ilet5a
ile6tji
ilet7jie
ilf4l
il5fli
il5gha
ilinde6
illo4w
3illu
il4m5at
ilm7oper
i1lo
ilo5sk
ils7insp
ils7orde
il4spr
ilt7aar.
i1lu
i2m
i3ma
im5agt
i3me
i4mek
im5eks
ime7laar
iment6s
ime4s
imes5t
i3m^^ea
i3mi
5immigr
i3mo
i4m3o4p
imo7theu
5implik
i3mu
imu6maa
in5aard
i4naf
i4n3ag
in5akk
in5arg
in4d5aa
in4das
inder7as
5indiv
ind6oef
in6doog
ind7oogm
in6d5oor
ind7sleu
ind5sw
3indu
in5dwi
inee7tji
ine5ra
2inf
ing7aars
in5gan
ing7eter
ing6hpa
in6gind
in6ginf
ing7infr
ing7inst
ing6leb
ing6ope
ing6opl
ing5ou
ing7pseu
in4g5ru
ing7saag
ing7sap.
ing7see.
ing7sekr
ing7seku
ing7sfer
ing7sin.
ing7sinj
ing7skal
ing7sk^^ear
ing7skud
ing7slep
ing7slym
ing7sofa
ing7som.
ing7somm
ing6s7pil
ings9telle
ing7stin
ing7suie
ing7suil
ing7swel
ing7uil.
i3ni
ini6gaa
in4ik
in5inf
5inisia
ink7erts
ink7laag
ink7ler.
ink7nerf
ink5nu
ink7ogie
in4kol
ink7olie
5inkom
ink7ring
in6krol
ink5st
ink7wit.
5innam
5innemi
innes6t
inne7ste
in5ong
ino7skaa
in5rag
5inrig
ins7epou
in6s5ete
5insets
in4sg
ins7kaps
ins6kin
in3sl
ins7molt
ins7moor
ins6ond
5inspek
ins7prie
ins4t
5insti
insti7t.
ins6ton
ins7twis
int7appe
int5ess
inte6s5t
int6he.
int6uit
int6wyf
inu5e.
5invlo
i1o
io3pr
ior6ubr
io1s
ios4k
io5skl
ios4p
ios4t
io3tr
i2p
i3pa
i4p3ag
i3pe
i3pi
i3pl
ip4lo
i3po
ipo4s5t
i3pr
ipre4
ip4s.
ips7kopi
i3pu
i4pui
i3py
i1r
ir4ch
irke4
irkel5o
irop4
iro5pr
iru4s
i4rwa
is3ag
i5sagi
i4s5aks
i6sangs
is3ar
i4sarg
is5asp
i4sav
is3c
i4s3ei
i4s3et
ise5um
i5sfeer
ish7nie.
i4s5int
is5inv
i2sj
i4sj.
is5jan
is5joe
i2s3k
is4k.
i4ska
is6kaaf
is5kan
is4k^^ea
is5kui
i2s3l
is5laa
i5slag
is3m
i5s4mit
i2s3n
is5oes
is5ond
is3or
is3p
is4p.
is3t
is4t.
is4th
isto7pho
i5s4tyn
i4s3ui
i5suik
isu6maa
is3w
i2t
i3ta
it3ag
ita6tis
it3b
i3te
ite7dwal
ite7glas
itek7te.
ite6mas
i5tenh
it4er
ite5ru
i4t5ete
i3t^^ea
i3ti
it4in
i4t5ins
i3to
ito5fa
ito7plan
ito7rowe
it1r
it3re
it3ry
it4sc
it5ser
its5ete
its7jood
it4s5oo
its7perk
its6tek
its7tori
its7uur.
i3tu
itu6saa
it5win
i3ty
ity7sokk
itz7laan
i1u
ium1
iu4ma
iu4me
iu4mi
iu5mie
ium6uur
iwel6s5k
iwe7mos.
iwes4
iwe7spor
iwe5st
1^^ef
^^ef2m
^^efn5akt
^^efn3o
^^efns4t
^^efn5und
^^efs5lam
^^efs3t
1j
3jaa
jaar6s7kr
3jac
ja4cq
3jag
ja4ga
jan7ghai
jan7knap
jap4l
ja5pla
3jare
3jari
ja4sm
jas7pant
jas6tas
jaz4z
jaz7zeri
je4kn
je4kr
jek7rasi
je5rop
jes7ni^^eb.
jes4t
je4t3r
jet6sjn
jeu4g
5jie5kn
jie6nan
jie6nol
jien5s
5jieon
5jieop
jie6ska
jie7skap
jies7kat
jie6ski
jie6skop
jie6s5lo
jie6slu
jie6sol
jie6son
jie6spa
jie6s5tr
jie6sui
jie7suik
ji4eu
jin7gope
ji4rp
job4s3
joe7kwee
joen6sk
5joern
3jong
jos6afa
jou7kuit
juit6sp
juk7riem
3jun
jun6kre
2k.
1ka
k4aal
k5aand
kaan8s7te.
k5aanw
kaar7se.
kaars7te
5kaart
kaar6ti
kaar6t5j
kade6la
kade6sl
4k3adv
5kafee
kaf6oef
4kafr
4k3afs
2k1ag
5kagem
k4agg
5kagge
k4ago
k4agr
4kaks
kal4k5a
kal4k5l
5kalko
kal6koo
kal4kw
kal4s5p
kal4st
3kam
kam6par
kam6ple
kams4
3kana
kaner5o
3kank
kan6ont
kan6sko
kan6ste
kans7te.
3kant
kan4t5j
kant7om.
kan4t5r
ka4pak
5kapas
kap7inte
5kapit
kap6lak
kap7lat.
kapo4
ka5pri
kap7seis
kap6spr
kap6stek
5kapte
3kar.
5karak
4k5arbe
k5arm.
ka5roo
kar6oor
kar4st
k5arti
kar5to
3kas
4kasg
kas7laai
kas6maa
kas7traa
ka5s6tro
5kateg
kat7etes
kat6har
kat6hu.
ka4too
kat7ryk.
kats4
kat5sw
kat7uil.
kay6aku
2kb
kbe6kwi
kbout7ji
2kd
k3de
1ke
kede6lo
kee2
keel5a
4keen
keep6s5t
keer6so
keer6ste
ke^^eb6laa
ke^^ebl7aar
4keff
kei6dro
keids7pr
4keik
keis4
kei5st
4k3eks
ke4l5ak
ke6lane
kel7anem
kel7assi
kel7eenh
4k5elem
ke6linb
kel7inbr
kel6mag
ke4l5ou
kels8onde
kem6afa
4k3emm
ken6aar
ken6dra
ken7eel.
4k3enj
3kenm
3kenn
ke4nou
ken7son.
kep7laai
kep7ler.
ke4p5lo
kep5sk
ker7een.
ke4rel
ker7els.
ker7flan
3kerk
ker6kal
ker6kin
ker6k5or
ker6kow
ker4kr
ker7kris
ker6kui
kerk7uil
kerk5wy
ker6m7eng
ker6naf
ker6nei
ker6nen
ker4n5o
ker7oes.
ke4r5on
ker6pru
ker6set
ker4sk
ker7skil
kers7kom
ker6slo
ker4sn
ker4so
ker7son.
ker6s5pi
kers5w
4kerts
6k5ervar
kes6el.
ke4sn
ke6trol
ket6ska
5ketti
ke4tu
keu6ror
3keus
keut7jie
key7kleu
key7nooi
k^^ea4rb
2k1f
2k1g
kga7laga
kge5la
2kh
kha7yeli
k4hoi
khu7khun
1ki
ki2e
kie6dro
kie7laai
kie6mas
kiem7as.
kie6sent
kie4s5k
kie7skry
kies5l
kie6slo
kies7tan
kie4ta
kieu5s
ki4kl
ki4ma
4kimm
5kind.
6k5indel
kin5dr
4kindu
k3inh
4kinl
4k5inst
kio4s
kios7ke.
kip7ling
ki4rc
3kis.
kis7obli
ki5s4po
ki5s6tew
kit4s
kits5k
2k1k
kk4ag
kka7smaa
kka5str
k3ke
kke6nee
kker5kr
kk4li
1k2l
k5ladi
4kland
k5lang
k4lank
klas3
klas6e.
kla6sin
k5leerd
4kleg
k5lege
k4l4ei
4klel
4k3len
3kle4p
klep7as.
k4ler
5klere
kle5us
k3l^^ea
4klied
k4lier
4k3lig
4k3lik
5klikk
kli6kop
k4lim
kli6moe
k4lin
5klink
k5linn
kli4p3
k4lis
kli7sjee
4klog
klo6kon
k5loos.
k4lou
klub5h
klu6bre
4klug
2k3ly
2km
kman7spo
1k2n
k4nap
4knav
5kneg.
4knei
4knem
kne4t
knet5j
3kni
kni6kla
kni4p3
knoe4
knoe7te.
4k3nom
k5noot
k4nop
knor7os.
1ko
kob7rego
3kod
4k3oef
3koek
koe6kei
koe4l5o
koe5pl
3koer
koe4s3
koe7sist
3ko^^eb
4ko^^eb.
k4ofi
4kogi
kok7onth
kok6skr
ko5lag
kol6for
3koll
3kolo
3kolw
3kom
kom7aan.
kom7bina
4komg
kom7ghad
k5omhu
kom7miss
kom7saal
kom4sp
kon7atoo
4k5ontl
kon5tr
4k5onts
4k3oog
ko4op
5koord
3ko^^f6
ko4pag
kop7ape.
kope7la.
kop7las.
4koplo
3kopm
4kopn
5kopno
ko4po
6kopper
kop7uits
kord7aan
kor6doe
kor6foo
k3org
koring7s
k3ork
ko3ro
3korp
kor4s5l
kor7sten
kor4t5a
kor6tji
kort7jie
3kos
kos7eetp
kos7inko
kos7juff
ko4sk
ko5ski
kos5ko
kos5pe
kos5taa
ko4t5ak
5kotel
kous7te.
kou5tj
kovi7ev.
ko4vk
ko4vs
k5owerh
2kp
kpro6pa
kp4si
k2r
k5raad
3kra4g
kra7gers
krag5o
k5rak.
4krand
5krank
5kredi
5kreet.
k4re^^ebe
4k3reg
4k3rek
k3rel
k5rese
3kret
4kri4f3
4krig
kri4k3
kri6moo
3krin
kri4p
krip7lee
3kris
4k3riv
k5roet
k5rolp
5kroon
kr4or
4k3row
4krub
3krui
4kruim
kru6kas
kruk6s.
kru4l
k5rusp
kry6fin
krygs5t
4k3ryk
kry7sket
3kryt
2k1s
ks6aan.
ks5agt
ks4ak
ks5chi
k4s5een
k4s5erv
k4s5eti
k3si
k6singe
ks5ins
ks6jari
k4skan
ks5kin
k4skon
k4sl^^ea
ks3li
k5s6maak
ks5moo
k5smou
k2s3n
k5snob
k4sob
ks5obj
k4s5ond
ks5onl
ks5opk
k2sp
k5spek
k5spel
ks5pen
ks5per
k5spes
k3spi
k4spir
k5spra
k5spri
ks5pur
k6s5taal
ks5tant
k6steken
k6stemp
ks5tens
k6stera
k6s5teri
k6sterr
kster6t7j
ks5tet
ks5tip
k7strado
k6s5trah
k5s6trak
ks5tur
ks5tuu
k3sty
ks3ui
k4s5ure
ks3w
k5swei
ksyn4
2kt
kte6rad
kte6ron
kter6sp
ktes4
k4the
k3ti
k3to
kto6rev
k3tu
kt4wi
1ku
kud7aksi
3kuik
4kuim
kuin4
kuins5t
4kuit
kul6der
kul6plo
kul6poo
3kult
3kun
4k3uni
kun6sin
3kurs
3kus
ku6seen
kus7lang
kus7node
kus7taak
kut3r
kut6slu
kuus6te
kuu7ste.
2kv
kvang6s
1k2w
4k5waar
k3wae
k4wan
3k4war
kwa7skaa
k4week
4kwees
4kweg
4k3wer
kw^^ea7lafl
kwik3
kwi6kwa
3kwis
2k3wo
3k4wot
k3wu
ky4fa
kyk7uit.
k1ys
2k-
k-5kli
2l.
4laanb
4laanh
4laard
laat7slo
laat6str
lad7onde
la4du
4ladv
2laf
la4fa
l3afd
2lag
l4ag.
la4ga
la5ga.
la5gas
l4agi
la5gie
l4agl
lag7lag.
l4ago
lag5ri
lag7some
lai6rgo
lak7albu
lak6led
lak7okul
lak7oore
4l5aksi
lak3w
lak7ware
lamb7da.
la4m5oo
lam6pli
lam6pol
lamp7oli
lam6sko
lam6sle
lam6spe
3land
lan6daa
land7aar
lan6dad
lan4d5r
land6sta
land6s7te
lan6gaa
lan7gnol
lan4go
lang7ste
langs8te.
lan6gur
lan4k5a
lan4k5l
lan6kop
lank7ope
lan4k5r
lan6kwi
lan4s5k
lan4sp
lan4s5t
lan6taa
lan7taat
lan4t5j
lan6tre
4lantw
lap3r
4l3art
las7elek
las6ie.
la4sn
la4so
la5sol
la4sp
las5pa
late5r6a
5lawaa
lba6spe
lbe6kne
lbo6wvi
lb4re
ld5amb
ldan7ha.
ld5apt
l4d5een
ld5eis
lde6rat
lder7os.
ld5ins
ld3of
ld5oor
ld6oor.
ld5ord
l4dow
ld5owe
l5draa
l4d3re
lds4k
lds6maa
ld3so
lds6ond
ld3sp
l4d5uit
1le
lec5tr
lee2
lee4g3
4leep3
leer5a
leer7eis
5leerl
leer5o
leer5s
lee4s
lees7tra
lee7tjie
lee7vaar
4l3eff
leg7slot
4leien
lei7gleu
lei6kaa
lei6naa
lei6not
lei7skoo
lei6spa
leis7pan
lei7spir
leit5s
lek7loti
le4kn
lek6suu
3leli
5lengt
4lenj
len6sel
len6ste
lens7te.
len6tji
lent7jie
le5pel
lep5li
lep7oog.
lep7ratw
lep5sk
lep6szy
leps7zy.
ler4a
5leraa
ler6kam
lerk7amp
lerk5sp
4lerts
le4see
le4set
les5ete
les6hab
les7insl
le4ske
les7kes.
les7lie.
les7onde
le4s5oo
le3st
les7taak
le4ste
le5stel
les6tin
les5tra
les4ty
les7uur.
les7wete
l5etan
le4tc
let5em
let7oorb
let7rol.
let6sko
4leuf
le3u4m
leun5s
leur7eg.
leu4r5o
leute4
lew6ein
6l5ewena
4l5ewig
3ley
1l^^ea
l^^ea4rw
lf5aan
lfa7stra
lf3ei
l4fek
lf5eks
l4fen
l4f3ev
lf4ie
l4fin
lf5ing
lf3l
l5flap
lf5onde
l5fone
lf5onts
lf3op
l2f3r
lf6skar
lfs7karm
lfs7kop.
lfs7kuil
lfs7nier
lfs7oog.
lfs7perk
lft4w
l4f3ui
l4f3uu
l1g
lg4ha
l4gli
lgo7lagn
lg6ordy
lgs6mee
1li
liat6ji
lia7tjie
3lid
lid7onts
3lied
lie6gli
lie6kwy
lie5la
liers5w
lie5sme
lie7steg
lie7stys
lie7swak
4l3i4eu
lig7inte
lig6las
lig6ny.
lig7omge
lig7rekl
lig7riet
li4gro
lig7skag
lig7sona
lig5s4p
lig5s4w
lig7ure.
lik7aspa
4likk
5likkew
li4kl
lik7opsi
lik6see
lik6sju
lik6soo
li4k5wa
lin6gid
lin6gin
lin6gli
lin6goo
ling7ooi
4linh
lin4k5l
lin4kr
l5inli
4l3inr
l5insp
lin4t5j
4linv
li4pa
li4p3l
lip5la
li5plo
li6poml
lip7omly
li4p3r
lips4
lip7soom
5lisen
l5item
liter6t7j
lit3j
litjie6
lit3r
lit7sha.
lit4sp
lit4s5t
lit6zdo
ljus4
l1k
l4kaf
lka6tio
lkat7ion
lk5een
lks7emos
lks7epos
lk6skap
lk4sku
lk4sl
lk4son
lks7ower
lk5spe
lk5spr
lk6stel
lks7tell
lkter6t
lktert7j
lk5uil
lk5wat
lk5wit
l4kwy
lk5wyf
2l1l
l3la
llat6ji
lla7tjie
llei5s
lle7knop
lle6rui
lle6swe
lleve7^^eb.
llo5sk
lls7moor
l4maf
lmo6kal
lmo4no
lm3sm
l1n
lne4s
lob7eend
loe6dal
loe6det
loe7dja.
loe6don
loe4d5r
4loef
loe6gos
loeg7os.
loers7te
loe6skr
loe4st
lof7opri
lof6spa
4logig
log4o
lo5gop
log7sot.
log4st
log7stok
lo4k3l
lok7onde
lok7swin
lo5kwi
l5olie.
lomer4
lomert5
loms4
4lond
lon6gaa
long7aar
lon6spa
lon6ste
lons7te.
4lont
lon4t5j
3lood
loofs5w
l4oop
5loopb
l5oore
5loosh
loo7stra
lop7emme
4lopl
lop6rys
lo3ro
lo5ryn
5lose.
lo4sj
lo4sk
los7laat
los5ta
los7trum
los7wikk
lo4tak
lot7riet
lot7ru^^efn
lot7swan
lot5ui
loui7sa.
lou3t
lou6wna
lou6wre
lou6wtj
lo4wr
low5ry
lox7era.
l^^f64jd
l^^f6j6don
lp5aan
lpe6nin
lp4he
l4pon
lp5ond
l1r
2l1s
l4s5aar
l4sad
ls5arm
l4s5asp
l4s5eko
lse4l
lse5le
lse6mek
ls5erva
ls5fei
lsg6haa
lsi6g5aa
ls5jas
l4s5kin
l4skon
l6skorr
l4skre
l4skru
l5s6maak
l5s4mee
l4snaa
ls5opw
ls6plet
l5s4pli
l4spu
l3st
ls4ti
l6stoeg
ls5waar
ls5wet
ls5wyn
l4t3ag
l4t5amp
lta7spie
lter6sk
lt5oond
l5t4wak
lu4bh
lu4bl
lub5le
lub7loka
lu2g1
lug6er.
lu5gub
3lui.
4l5uie.
lui7masi
lui7slan
4luit
luk5raa
luk7rake
luk6s5pa
l5unie.
luns6a.
lur6pag
lus7moor
lu3t4h
lut6zpu
luus6te
luu7ste.
lva7soor
lve5ti
lwe4r5a
lwe6rui
1ly
lyce7um.
ly4fe
ly4fo
lyk7aant
lyk7lope
lyk7lug.
ly4kn
ly4k3o
lyk6ont
lyk7rede
lyk5sk
ly4ma
lym5ag
lym7uint
3lyn
lyn6aaf
ly3pl
ly3sp
lyt7ring
1m
2m.
mac7dona
made7us.
mae4s
m1af
4mafd
m4afo
ma5fro
4mafs
mag6sta
ma4hd
mah5di
mak6lot
ma3kw
ma5lag
mal7thus
mamat6j
mama7tji
man7djar
man3g4
man7gona
man6n-p
man7salm
man7spen
man6spr
man6s7taa
man6sto
man7ure.
map4l
ma3ra
mar6kek
mar6kle
mar6kom
mar6kon
mar4k5r
mar6lpr
mar4s5k
mar4s5t
mar6tro
mary7na.
mas6koo
mas6kri
mas6kui
mas6tek
ma5s4tr
mat6hes
mat7thys
may7nard
2mb
mb4re
2md
mdo6po^^eb
mdop7o^^eb.
md5soo
m3dw
md4wa
4meder
mee7kole
mee5kr
5meel.
mee5l4o
mee5ne
mee7reis
mee7reke
mee5sl
mee7spre
meest7al
mee6tre
me3ga
megas4
mega5st
4megt
mei6nee
mel6aar
mel7ekwa
mel6kal
mel6kjo
mel6kla
mel6kna
mel4k5r
melk5s
mel4k5w
mel7spul
mel6too
mem7phis
men7angs
men7eise
men7opga
men6sky
men6snu
men4s5p
men6s5ta
men6tin
men4t5j
men4t5r
me5phi
me4rak
me6rass
mer7asse
mer5ast
mer7dein
me4rei
me6reng
mer7enge
mer7esse
mering8s9taa
mer6kli
mer6kna
mer7kopn
mer4kw
mer7kwar
mer5oes
mer7onth
mer7tre^^eb
mes4a
me4sal
me4s5ka
me6s7koor
me6skor
mes7kore
me6skro
mes7kroe
me4sl
me5slu
mes7moss
mes7port
me6stas
me4s5to
mes7ware
me4t5ee
met7emps
meter6so
meu6las
meul7as.
2m1f
mfloer6
2m1g
mgang4
mgangs5
mgeper6
mges7per
2mh
mh4ei
4mid.
mid7osea
4mids
mids5t
mie6kas
mie6kwa
mie6ret
mie4r5y
mie6skr
mie6taa
mie6tji
miet7jie
mig6re.
migu7el.
mih7rab.
mil6taa
min7gopl
4m5insp
6minstu
mi4rl
mi3sf
mis7s^^ear.
mis6tkr
mis6tok
mit7swa.
mi4v-
2m1k
mkaar4
mkom6st
mkoms7te
2m1l
m3la
2mm
mma5sp
mmas6to
mma7stor
mmat6ji
mma7tjie
mme7loor
mme6res
mme4r5o
mmi7stok
2m1n
3mod
mode4l
mod6jad
3moe
moed4s
moe6nes
moe4st
mof6lam
mok7alba
mole4s5
m5olie.
mol4m5a
mon6dch
mon6dop
4m5onts
3moon
moor6da
2mop
m3opl
4morg
mo3ro
mor6sju
mor6spo
mor4s5t
mo5saa
mos3f
mos7fles
mos7inen
mo4ske
mos7ke^^eb.
mo5sta
3mot
mote7us.
mot6heu
motor5a
mou5fl
mou7slip
mou6ste
mous7te.
mou6tek
mo9ya.
5m^^f4re.
2mp
m4pag
mpa7gne.
mp5agt
mpe6lys
mpen6to
mp4her
mp5ops
mps7kraa
mp5sli
mps7taal
2m1r
2m1s
ms5app
m4s5kat
m4skon
ms7kraal
m5slin
m3s4me
ms3op
ms5pen
m6s5taal
ms4te
m5steg
m5steo
m3sw
2mt
mter6t5j
muc7klen
mues7li.
muf7smaa
mui6les
4muit
3mul
mum7aant
muns4
mun5st
mun6tou
mur4g
mur7gie.
3mus
2mv
mvi6tra
2mw
myl7afst
myl6sla
3myn
myn7ent.
myn7impa
myn7inge
m1ys
2m-
2n.
1na
3naal
3n4aam
4n3aan
6n5aardi
naar6skr
n5admi
4n3adv
nae6lys
nael7yst
n1af
n4afi
naf6lad
nag6aand
na6gaap
na4g5ap
na6gemm
nag7emme
nag6las
n4ago
nag5ron
nag3s
4nagt
n5agtig
na4gu
nai7set.
na5kli
nak6lip
4nalf
4nalt
3nam
na3p4l
na3pr
nap7roet
4n3arb
4narea
na3s4k
nas7klip
na3s4l
nas6maa
na3sp
nas6pel
nas4pr
na5s4ta
nas6ten
nas6tor
na5s4tr
na5stu
nas6tuu
nas4w
na5swe
na5t4ha
nat6jie
nat7onde
3nav
5nawee
na9yl.
2nb
nba6chs
4nche
2nd
nda7gesk
nd5akt
nd5app
n4d5arb
nd5art
n4d5ass
nda7stoe
nde7eier
n4d5een
nd5eg.
nd3ei
nd5eksa
ndel8s7kor
ndel8s7taa
nd5emm
nde6rad
nde6raf
nder7af.
nde6rar
nde6rem
nde6r7ent
nde6r7ess
nde6rim
nder7in.
n6deros
nde7rosi
nde7sill
nde6zvo
nd5ide
ndi5go
nd5ins
nd3of
n5dome
nd5omt
nd5ond
nd5ont
n4d5opb
ndo5st
nd5rak
nd5rat
n4d3re
nd6resd
nd5riff
nd5riv
nd5roe
nd5rok
nd5rot
n6druim
nds7ertj
nds7geru
nd6sinl
nds7kenn
nds7koor
nds7kraa
nd6s7laag
nds6leg
nd5s6maa
nds6ons
nds7oorn
nd5sor
nd6spre
nd5spu
nds7taal
nd6stek
nds7toet
nds7troe
nds6wee
ndt6wis
ndu4e
n4d5uit
ndu7kraa
n4d3ys
1ne
nebe6st
nec7ticu
5neder
nee2
nee4l
neel5a
n4eem
4n5eend
4n5eenh
neer5o
neer5s
nee6tew
neeu3
nee7uur.
nee7woor
4neff
4neg.
ne5gla
n3eie
4neil
4neksp
n5ekspe
nel6lma
ne6loon
nel7oond
nel6spo
3nem
nem6afi
nen4sl
nep7olie
3ner.
ner6faf
nerf7af.
ne4ros
ner7psig
ner6sle
ner5sw
ners6we
nes7evan
nes6tas
ne4ste
net7omge
ne4tri
ne5um.
neu7moko
neu7raal
neu6sji
neu6ska
neu7stoo
neu6to^^eb
neut7o^^eb.
ne4wt
3nez
1n^^ea
2n1f2
n3fl
nfy6tap
2ng
n4gad
n4g3ak
n4g5apt
n4g5ase
ng5ass
n4g5een
n4g3ei
ng5eks
nge6r7aap
nge6r5al
nger6d5r
nge6ret
nges7per
ng5eten
n6geter
ng5imp
n4g5ink
n6ginst
ng1l
ng6lasu
n4go^^eb
ng5o^^eb.
n4g3on
n4g5oog
n4gou
ngp6seu
n6g5raad
ng5ran
ng5rat
n4g3ri
ng7sade.
ngs7agit
ng7sappe
ng4see
ngs7eise
ng4sek
ng6serk
ngs7erke
ng6sero
ng6serv
ngs6fer
ngs7impa
ng4sin
ngs5int
ngs5kan
ng7skat.
ng7skoel
ngs7koep
ngs7kop.
ng7skors
ngs7kort
ngs7kurw
ngs7kuur
ng6s5laa
ng6slab
ngs7labo
ngs7ladi
ngs6lep
ng7s6loop
ngs6lym
ng4sn
ng5sni
ngs6oet
ngs6ofa
ngs6omm
ngs7pelo
ngs7pill
ng5spoe
ng7stabi
ngs7tal.
ng6steh
ng6stei
ngs7teik
ngs7telg
ng6stem
ngs7tema
ng7stemm
ngs7temp
ng6s5ten
ngs7tese
ngs6tin
ng6stou
ngs7tou.
ngs7trap
ngs7truu
ngs6uie
ngs7ure.
ngs6wel
ng5uit
2nh
1ni
nie6kaa
nie7knik
nie6raa
nier7aar
niers5w
nie6uin
nig7aard
ni4g5ee
ni4g5ie
niks7py.
nik7warm
4n3ind
4ninf
nin6g7ele
nin6get
4ninh
4n3ins
4n3int
4ninv
n5invo
n2is
nis7alma
nis6ara
ni5see
nis5id
nis7insp
nis6oms
ni4son
ni3tr
nit7sare
nje7glas
nje7krui
njie6st
2n1k
nkaar4
nk5aard
n4k3af
n4kak
nk5aks
nk5eff
n4kei
nk5eie
nke6las
nke6lit
nke6ree
nkers6w
nker7swe
n4k3li
n2kn
nk3na
nk5nes
nk5neu
n4k3of
n5kofi
nk5psi
nk5rig
nk5rol
n4k5roo
nk5ros
nk5rye
nks6noe
nk4s5om
nk3sp
nks4t
nk3s4w
nk5uit
n2kw
nk5wat
n5kwen
2n1l
n3la
nli4ga
nlu4s
n1n
nna6spo
nna7tjie
nne6pol
nne6sev
nni4s
1no
4noef
4noes
noe4st
no4g5al
nog7eens
nok5as
no9ko.
nok7riww
3n4oma
n4omm
nomo7yi.
no4n3a
4n3ond
4n3ont
noo6dan
n3oog
noor6di
4nopb
no5pla
nop6laa
4noplo
nop7omhu
nop6rod
4norg
n5orga
nor6kla
3norm
nor7tham
nos6kaa
no3sp
3nota
3note
not4r
no5tre
2np
n1r
nroet6j
nroe7tji
2n1s
n4s5aar
ns3ag
ns4an
ns5angs
ns4e.
ns4el
nse4pr
nser6to
nser6tr
ns3f
ns6feer
ns5gel
n3si
ns4ia
ns4ie
ns4ig
nsi6gar
ns7inges
nsi6tri
ns4iu
ns3ja
n6skafe
n5skap
n4skar
n4s5kel
ns5kin
n6skous
n4s5kra
n2sl
n3sla
ns5lam
n6sland
ns3le
n4s3li
n4s3lo
ns6lotg
ns6lott
n3slu
ns4mee
n5snar
n4sne
n5snel
ns5noo
n5soek
n4so^^eb
ns5o^^eb.
ns5ond
nson4t5
ns5onw
ns3op
ns5par
ns5pas
n4s5per
ns7portr
n4spot
n6sprat
ns6prek
n6staak
n4staf
ns5teh
ns6tel.
ns6tels
n5s6ter.
ns6ters
ns5trak
n3s4tu
n4s3tw
nst6wyf
ns5tyd
ns3w
ns6weer
n4syw
ns5ywe
2nt
nt5ags
nt5ark
n4t5art
nta5tj
n4t5eie
nte6ram
nte5sm
nte6sti
n5t4hon
nti7kwaa
nt5inv
nt3ja
n4tjo
nto7fakt
nt7oksie
n4t5oli
nto6nad
nt5ond
n4top
nt5ops
n4t5org
nt7radin
nt5raf
n5tref
ntre7kor
nt5rim
nt5roe
nt5rom
nt5ron
nt5room
n5troos
n5trou
nt5row
nt5rui
nt5ryk
nt3sa
nts7inge
nt6skan
nts7kand
nt4s5le
nt3s4m
nts7onde
nts5paa
nt3st
nt5uit
ntu4m3
n4t3ys
1nu
3nua
nu4e.
nu4es.
2nui
nuk4w
nu5kwa
nul7soms
4nuni
nu5skr
nu6skra
nus4t
nu3tr
4n3uur
2nv
nva6lis
2nw
ny4so
nza6cs.
o1a
o4bag
ob5agt
o3bo
ob5vor
oby6nro
ock7wyn.
oda5gr
od5een
ode7leie
ode7spaa
od5lui
od3op
od3re
ods7akke
ods7kish
od6slak
ods7lake
ods7lopi
ods5oo
ods6op.
ods6org
ods7paar
ods7rogg
ods6uit
ods6waa
ods6war
ods6wyg
odu4k
oe4d5aa
oe4d5ag
oe4dei
oed7eie.
oed7ette
oe6dind
oed6ja.
oed7onde
oe4d5oo
oe4d5op
oe4d5or
oe4d5ro
oed7stry
oe4du
oed3w
oed7wyn.
oe4f5aa
oe4f5an
3oefe
oe4fek
oe4f5lo
oe4f3o
oef7rit.
oeg7aand
oeg7laer
oeg7lam.
oe4gog
oeg3s
oeg7yska
oei1
oeien6a
oeis4
oei7sker
oe4kaa
oek7eier
oe6kerf
oek7erf.
oek7eval
oe4k3l
oek6lap
oek7olie
oek7oort
oe4kr
oek5rak
oek5re
oek5ro
oek7sten
oe4k3w
oe4lei
oe5leie
oe6lemm
oel7emme
oel7eter
oeling6
oelings7
oe6lins
oel7inst
oel7onbe
oel7opri
oel6ser
oel6skr
oel7slik
oe4nei
oen7eike
oe6nert
oen7ertj
oen7esse
oenk4
oen5kl
oen7knoo
oen5kw
oe4n3o
oens5ko
oen5sm
oens4o
oen7ysbe
oep7aang
oep7inst
oe6pinv
oe4pl
oe5pla
oep5li
oe5plo
oep6s5ee
oep6s5in
oep4sl
oe4pu
oeras5e
oer3k
oe4r5on
oer5ou
oer6ske
oer7twak
oe5ser
oe5sie
oe5sje
oes7kraa
oes7limt
oe4s5lo
oes7medi
oes7pil.
oe4s5po
oes5ter
oes7troe
oe4swe
oet7aanp
oe4t5am
oet6he.
oe4t3j
oe6t5oli
oe4t5oo
oe4t5ri
oe4t5ru
oets7kra
oet6sna
oet6spe
oet6s5te
oet6sti
oet5wy
o^^eb5rug
of3at
of5een
5offis
o4f3in
of3l
o4fok
of5oks
o4f3om
of5psa
o2f3r
of6sant
ofs7iden
of6sins
ofs7insi
of4s5le
of4s5oo
ofs7paar
o4fui
o1g
og4d.
oge4s5t
ogge6lo
oggel7oo
ogi7faal
3ogig
og1l
og4nat
ogo7steo
o4gry
og5rye
og4s.
og4sg
ogs6inf
og5ska
ogs7last
ogs6ot.
ogs4p
ogs7pad.
ogs7pris
ogs6uip
ogs6wan
oi1
oig6aff
oi3k
oile4
ois4a
oi5sag
oi5ski
ois6kuu
oi5sky
oi5sla
ois4p
ois4t
ois7te^^efs
ois6wer
oi3tj
oje4k
ojek5l
o4k5aas
o4kag
ok4am
ok4an
oke4t
oket5j
okie4
o4k5ins
ok5lat
ok6leed
ok3n
oko7seil
oko6sol
o4kou
o1kr
o4k3ro
ok4s.
ok5sig
ok6sins
ok4sj
oks7kraa
oks6lip
ok3sp
ok3st
oks6win
o2k3w
ok4win
o1la
ol5agt
olf7ent.
ol5f^^e8g
olf6lap
olf6sku
olf6sme
ol4gl
olg7onde
ol4g5or
olg7smee
5olieb
olies6m
olie7sma
5olifa
oli7gny.
olk6sem
olk6sep
olk6sow
olk6sti
o1lo
olo5kw
o4l5oor
olo5sp
olp6hta
ol4sar
ols7are.
olt6zha
o1lu
olyf5o
o2m
o3ma
om5agt
oma7pleg
o4m5arm
omat6ji
oma7tjie
o3me
ome4s
ome5us
omg6had
o3mi
omka5s4
5omloop
o3mo
omos6fe
omo7sfee
omp7ligs
omp7oor.
om6pop.
oms6aal
om5sla
oms6lag
oms7perk
5omstan
oms6tin
o4n3ag
o5n4age
o3n4an
ona6skl
ona7sten
ond7aap.
ond5agt
ond7ampt
ond7dwaa
4ondes
onde7us.
on4did
on4dom
ond7rol.
ond5sle
ond5so
ond5sp
ond6spl
ond7twis
on5eff
o4n3ei
ong5aan
on4g5os
o3n4ik
o4nil
onin6gr
onk7ert7j
on4kj
on5kno
onk7omge
onk7rugh
onne5st
o4n5oks
ono7sfee
on4s.
onse4p5
ons7iden
ons7kepe
ons7kori
ons7pamp
ons7self
ons4t
on5ste
ons7tol.
on6t5aar
3ontd
ont7elsi
5ontgi
ont5raa
on4tri
ont7rol.
on4t5ru
ont7slik
3ontw
o1ny
ony7okol
oo2
oo5agt
ood3a
oo5deb
ood5ee
oo5dek
ood5er
ood5et
ood5ok
ood7onge
ood3r
ood6san
ood7smoo
ood7sorg
ood7spui
ood7suit
ood7swaa
ood7swar
ood5ui
oof1
oof6ser
oof6sid
oog3
oog6enh
oog6les
5oogpu
oog7sinf
oog7suip
oog6-lo
ooi6spa
ook3
oo4ka
ook6sst
ool1
ool6and
ool7snaa
oom1
oo4ma
oo4me
oo4mo
oon1
oon6ag.
oong4
oons6ko
oon5sl
oop1
oo4pa
oo4pe
oop7klik
o4opn
oo4po
oop6swe
oor1
oor6daa
oor7daad
oor6dap
oor7darm
oor6dca
oor6d5om
oor7doop
oor7frek
oor3i
oor7klik
5oorlog
oor6ot.
4oort.
oor6taa
oor6t5in
oort7ja.
oor6tyl
oort7yl.
oorve7^^eb.
oos3a
oos3k
oo4so
oos7pers
oot1
oo4ta
oot6aai
oot6en.
oo4ti
oo4to
oo4t3r
oo4tu
oo3v
o^^f65spo
o2p
o3pa
o4paf
op5agt
opa6les
o4p3am
5opdrag
o3pe
op5een
op9eg.
5openi
op4er
oper7aar
ope7rage
op6horu
o3pi
opie6le
opk6lik
op3l
op4lan
op6lein
3oplo
1opn
4opno
o3po
opo7fagi
op5off
op5ont
opo7sfee
5opperv
op3r
o5p4rot
o4pru
op6skre
ops6maa
ops7neus
op5son
ops5or
op3st
op3sw
ops7wels
o3pu
o1ra
or5afd
or5agt
ora6lee
ora6loo
orat6ji
ora7tjie
ord7akti
ord6arm
ord7eksa
ord7ierl
ord7inst
ord5oes
or4d5oo
ord6oop
or6dord
ord7orde
or4d5ri
ord7roma
ore7ster
o3r^^ea
orf7oond
4org.
or3gh
or4glo
4orgp
org7ring
3ori^^eb
orings8ku
or5kaa
orkes5
ork7lag.
ork6lik
ork7ney.
orkom6s
orkoms7t
or6maan
or4mj
or4nj
or5ond
or5ong
o5rot.
oro7thy.
or3p4h
orp6ski
orp4sn
ors7aar.
ors5ag
ors7jurk
ors5mo
ors7pot.
ors7teri
ors7tery
or4sti
ors7trek
ort7aan.
ort5aar
ort5akt
or4tar
ort6ham
5ortod
ort7onde
ort7rol.
ort7ruk.
ort5sw
or1u
o3r4us
o3ry.
ory4s
os3ag
osa7phat
os5api
osas4
osa7tjie
os5cen
o3se
ose7phin
ose7phus
o3si
osi6nen
o4sjo
os1k
o4s3ka
os5kee
os5kis
os5koe
os5kop.
os5kor
os5kou
os5kow
os3kr
o5skri
o4sku
o2s3l
os3m
o2s3n
os5oli
os5oor
o4sor
os5ord
os3p
os4pe
os5ste
os3t
os4t.
os4ta
os5taf
os5tak
os5tal
os5tar
os4td
os4th
ost7impe
os4tm
o5strat
os6trev
ost7revo
ost6roo
os4tw
os4t-
os3w
os-7lond
o2t
o3ta
ot5akk
otas4
ota5st
ota7tjie
o3te
oteek5
ote4s5a
ote6sno
ote6spr
ote4s5t
o4the
oth7nage
o3ti
ot3j
o3to
ot5opm
oto6ran
oto6ren
otor5o
otos4
oto5sk
ot3re
o3tro
ot5ryk
ots7eila
ots7karr
ot4s5ko
ot4sl
ots5la
ot4s5po
ots7r^^fbe.
ots7tee.
ot6stek
ots7toet
ot4stu
otte6l5o
o3tu
o4tui
otu6set
oua6che
oud7agti
ou6dakt
oud7akti
oud6ief
oud6ini
oud6ink
oud7oorg
oud7styd
ou4du
oud7uitg
oue6rio
ou3g
ou4gh
ou4gl
oug4r
ou1i
ou5ill
ouis6a.
ou1k
oul7ontl
ou3m
ou5nyw
ou5rei
ous6kak
ous6ken
ou5ski
ous6lip
ous6ouw
ou3s4p
ous7pan.
ou3s4t
ous7tert
ou7stiek
ous7ties
out7aar.
out7aksy
ou4t5as
out7ekst
out7emme
5outoma
out7omhe
ou4t5oo
out3r
out6rap
out6rei
ou4wb
ouw7rens
ou4wv
ou4-o
ove5re
over6y.
ovie6v.
ov5ket
owe6nal
owen7al.
owe6ral
ower7al.
ower7kon
oy4a.
oy4eu
^^f41
^^f42i
^^f4i3e
^^f4re5st
1^^f6
^^f6jd7onde
^^f61l
1p
2p.
5paaie.
4paanv
paar7dui
3pad.
pa4da
pad6ie.
pa4d3r
pad6-eg
p1af
pag6ne.
3pak
pa4ke
pak5es
paki3
pakket5
pa4ko
pak5os
4p5akti
3pale
pal7esse
pal5fr
pal6mol
pa4nop
pan5sp
pan4t5j
3pap
pa5pri
pap7ryp.
paps4
pap7saf.
pap7smee
3pa3ra
pa6ramn
par7amne
3park
par6kar
par4ko
park5r
4parm
par4sk
par6ste
pars7te.
5party
pa5sja
pa4so
p5aspi
3pass
5paste
pas7til.
pa4taa
pat7are.
4patel
pat4j
pa5tji
3patr
pats4
pat5sj
pav7lov.
2pb
pbe6koo
pbreng6
2pd
p3dw
pd4wa
pd4wi
3pe.
pe4ak
pe4ar
3ped
pede4r
pe5dof
pee2
peel5a
peel5u
4peen
peet3
3pei
4peie
p5eien
4p3eis
pek7nek.
pe4k3r
pel7aktr
pe4l5oe
pel7oond
pels7kra
pel6tak
pel7yste
4pemm
pe6nars
3penn
pen7opsl
pen6slu
pen7smed
pen6sop
4pepi
3pera
pe6raap
per7aap.
per7admi
per6ary
per7asid
pera5s6t
5perd.
per6dag
per6dry
per6dwy
per7enke
per5est
3peri
pe4rok
3pers
pers5ag
per6set
per6sje
pers7med
5perso
per6s7ond
pers8tel.
5pertj
per6top
per7tsja
per7uran
3pes.
4pesi
pe4sl
pe4s5te
peu6rel
2p1f
p3fl
pf4li
2p1g
pges4
pge5sp
pg4ly
2ph
phe6ars
p2hi
phi5s4t
p3hit
piek5n
pie6raf
pie6rom
pie4ru
pie7samp
pie6ska
pik7erts
pik3s4
6p5inges
ping6la
pin7glas
pin5kl
4pinst
pipe4
pipet5
pi3s4k
pit3j
pit4s5k
pit4st
pits5te
pits7tek
pit6suu
pit6zko
2pj
2p1k
pkom4s5
p2l
pla6kal
pla6kok
5plan.
5p4lant
4p3lap
3p4las
3p4lat
pla4t5r
plee4
pleet5
p5leie
ple4k
5pleks
4p3lep
pleu7ra.
p3l^^ea
pli4g
pli4t5e
4plits
p5loos
p5lose
plu6ska
4plyn
2pm
2p1n
p4neum
poe6doe
3poei
poe4s5t
poe6tol
po4fa
pog7rest
pog5sk
pok5aa
pok7olie
3pol
3pom
4pomh
3pone
pon7opbr
pon4s5k
pons7te.
4pont
5pont.
p5onts
4poor.
5poort.
3poot
poo6tel
po4pag
4popd
pop6lek
4pops
p5ordo
po3ro
por6tak
6portso
por6t5ui
3pos
po4sk
pos6tim
pos6tko
pos6tna
po4t5as
3pote
pou6ste
2pp
ppe6las
ppel7as.
ppe6rad
ppe4ro
ppie6sl
ppoor6t
ppoort7j
p2r
p4raa
4praak
p5raam
5praat
pra6esi
5prakt
3pren
3pres
pre4s5t
4preu
3p4ria
p3rib
p4rie4
prie7^^ebl.
5pries5
priet5j
5prins
3prio
3prob
3prod
pr4oe
3prof
3p4rog
3proj
4p5rok.
3p4rop
pro6pop
pro5pr
pr4or
3pros
pro5sa
pro7sopa
pru4t
3pry
pry4st
2p1s
p4sad
p4s5aks
p4sakt
5psalm.
p4sas
ps5asp
p4sat
p4sid
5p4sigi
5psigo
p4s5ing
p4s5int
ps3j
p5skaa
p4s5ket
ps5kof
p4skon
ps5loj
ps3m
ps4my
p4son
p5son.
p4s3oo
p4sor
ps7portr
p6stera
ps4ti
p6stoet
p4ston
p5swar
ps5wer
2pt
ptos4
3pub
pue4b
4puit
3pun
pun4t5j
pus7tipo
put7adde
put7emme
put5ji
put7rioo
2pv
2pw
3pyn
3pyp
pyp7aard
pyp3l
pyp7las.
pyp3o
py4pr
pys3k
4p5yste
py5tha
pyt6hon
2p-
1q
qu2
qua7driv
que6str
qui7nas.
2r.
raa6min
4raan
r6aans.
4r5aard
4rabs
rac5te
5radio
4r3adv
4rafd
ra4fek
4rafh
ra4foe
4raft
ra4fu
raf7urn.
4rafv
4rafw
2rag
rag6aal
5rageb
ra5gie
ra6ginl
rag7inli
r4agr
rag7raad
rag7ryer
rag6sab
rag6sak
rag6sin
rag7soep
ragu5e
rag6wan
rai7gne.
rak6les
rak7oper
rak7wate
4ralb
ral7eer.
ral7oor.
4ralt
ram7argi
4r5ameu
ram6pla
r4anda
ran6daa
ran7dafe
ran6d7akk
ran6dem
ran6dev
ran6doe
ran4dr
ran4g5o
rank5l
ran4k5r
ran6saa
ran6seu
ran6sjo
ran6sko
ran6sor
ran4s5p
ran4s5t
ran6tad
ran6tet
ran4t5j
ran4tr
4r3any
rapa7da.
ra6pas.
ra5pes
rap7ewen
rap6lo^^ef
ra4pon
rap7onge
rap7para
rap7rem.
rap7righ
r4ari
4rarm
4rarr
4rart
r5asia
ras6tan
ra5s4to
ra5s4tr
ra4su
ras5ui
ra5t4ho
4r5atom
rats5o
rbo6lol
rd5agti
r4d5ame
rd5eil
r6delek
rd5esel
rde5sm
rd5euro
r3do
r4d5oli
r4d5ont
r4d5oon
rd^^f46nne
rd7raais
r6droma
rds6lip
rd3so
rd3sp
rdt6ree
rdu6sol
rd4wa
r5dwar
r4dwu
r4d5yst
1re
3r2e.
3reak
reed5a
ree4k
reek5e
ree7kier
ree7loon
4r5eend
4r5eenh
4reenv
ree6pes
ree6ple
ree6pro
4reers
ree7sala
ree7stra
3re^^eb
4re^^eb.
4reff
3reg.
reg7ruk.
reg6sen
reg6skw
regs7om.
reg7spre
4reie
4reil
rei6nar
4reind
rei6noo
rei6ser
rei6sou
reit7ze.
re4kn
rek7naar
rek5ne
rek4r
rek7spoe
4rekst
re4kwa
rel4d
rel7dae.
rel7diag
rel7dopp
reld7ran
rel7duik
rel7oest
ren6agt
r4end
5rend.
r5enig
ren7shaw
ren4so
ren4sp
rens7te.
ren6sto
ren6str
ren6tak
ren6tcl
ren4t5j
ren4t5r
4rerg
4r3er4t
rert5j
4resel
re4s5ka
res7lap.
res5lo
re3s4m
res7ore.
re4spi
re4ste
re5stel
re4sti
res7toet
res7toma
res7ure.
ret5art
reu6kin
reu4kl
reu4k5o
re5usg
r4ewa
rey5no
r^^ea4rh
r4faa
rf5laa
rf5lat
r3fle
r5f4lie
r5flui
rf5opv
r4fre
rf5reg
rf4sl
r1g
r4gak
rg5akt
rgek6li
rge7klik
rg5eng
rgeper6
rge6rid
rg4hu
rg5hut
rg4len
rg4let
rg5loo
r4g3lu
rg4ly
rgo6wri
rgrie4
rg5ros
rg3s
rg4s.
rgs4p
rguit6j
rgui7tji
1r2i
3rib.
rib7file
rie6dio
rie6dop
rieket5
rie6klo
rie5me
rie6pri
ries6e.
rie6skr
rie6taa
ri4fa
rif6ree
rig6ska
rig7smee
rig7styf
ri4kl
rik6sid
rik5sj
rik7spad
ri4kw
rim4s
4r3inf
rin6gaa
rin7gaan
ring7aar
6r7ingest
rin7gleb
rin4g5r
rin6gui
4r3inh
rin6kar
4r5inko
rink5w
rin6kwa
4r3inl
4r3inr
4rins
r5inst
rin7the.
r3inv
4rinve
rio7rye.
rip4s5t
ri5s4ko
ris4o
ri5son
ris5op
ris6per
rit5ji
rit7oond
rit6rea
ri5tro
rit6zri
5rivie
rix7tont
2r1k
r4kaan
rk5een
rk5eik
rke6lap
rke4s3
rke7sel.
r6kink.
rk5inl
rk5leie
r4klid
r5klip
r4k5los
rk5nei
rk5omg
rkom6sti
r4k5opd
r4k5ops
rk5rand
rk5red
rk5rib
rk5rok
rks6maa
rk5spo
rks6uid
rk5twi
rk5uit
r4k5ure
rk5wag
r4k5wat
rk5wee
r4k5wet
rk5wil
rk5win
r4kwy
r1l
r3la
rli4g
rlo6gja
rloo7ple
rlo6wpa
2rm
r6maanh
rma5g^^f4
rma6gun
rma7klot
rma7plaa
rma7raan
rme6raa
rmer7aar
rme5sa
rmi4l
rmos4
rmo7stro
rm5uit
rmy6nim
2r1n
r5nagte
rna6spl
r4n5ele
rne4s
rne4t5a
rne6tom
rn5oor
rn6stig
rns6tin
r3nu
roduk5
roe6fas
roef7as.
roe4f5l
roe6fri
roe4ga
roe7glas
roe4n5a
roe4pa
roep5l
roe4p5o
roe4s5k
roe6sla
roes7lag
roe4s5t
roes5w
roe6taa
4roew
rog7akke
4rogg
rog6lis
ro5gna
ro4kn
rok4r
rok7slip
rok4s5p
ro5kyn
ro4l5aa
rol7gord
r6olien
rol7mops
romp7op.
4roms
ron7aar.
ron6dag
ron6dak
ron6d7er6t7
ron6d5et
ron4d5o
rond6o.
ron4d5r
ronds4
rond5sw
ron4du
ron6gaa
ron6kaa
ronker6
ron6kert
ron4k5l
ron6kow
ron4kr
ronk7wa.
ron6ske
ron6ste
rons7te.
ron7stel
ron6s5ti
r5ontp
ron4t5r
ron6tui
4rontw
roo7dewa
roo7dist
3roof
4roog
roo7gron
roo7mens
roo7nag.
4roond
roop6la
4r3oor
roo7taai
r4opa
rop7aans
rop7anys
ro5pee
rop6een
4r5open
r4opi
r4opo
r1or
r4ora
ro3ro
ros6afr
4r5osea
ros7kie.
ro3s4p
ro5sta
ros6til
rot6hsc
ro5ton
ro3tr
rot4sa
4roud
rou7floe
rou5sk
rou3t
rovi7ch.
rov7nik.
ro4w-
rox9y.
r2^^f6
rpe4s3
r4pid
rp5ide
r4p5lik
rp5opd
r4p5reg
rps7idio
rp4sl
rps5no
rp6spri
rp4stu
2r1r2
rre7glob
rre7nagt
rre4st
rre7stau
rres5tr
rri6gin
rron7kaa
2rs
r4sakt
rs5alm
r4s3ar
r5scha
rs5eila
rseuns6
rs3f
r5s6feer
rs4ie
rsi7flag
r6sinda
rs5inko
r6sinsp
r6sinst
r5sjam
r6skaki
r5skap
r6skapa
r6skapi
r6skeus
r4s5kin
rs6kink
r6skoet
rs6komm
rs6koni
r4skor
r5skors
r5skou
rs5krib
r6skroo
r4skur
r4sl^^ea
rs5lis
r4s5los
rs5lyf
rs6maad
rs6maai
r5s6maak
r6smaat
rs6magt
rs6mak.
r6smake
rs6mara
rs6mede
rs4mee
r5smeer
rs4mel
rsnee5m
r5snoo
r4snot
r4s3og
rsonde6
rsonder7
rs5ong
rs5oog
r6soors
rs3op
rs4op.
rs5ord
r1sp
r6spaar
r4s5par
r6spien
r5spri
r1st
r6s5tal.
r4stb
r6stegn
rs6terp
r5s6ters
rs6tigl
rs4tik
rs4tis
r4s5tit
r4stj
r6s5toet
r6streg
r3sty
rs3un
rsu4s
rs5wa.
rs5wap
rs3we
rs6werf
rs5wyk
2rt
rt5afd
rt7angel
rt5art
r6teend
rte6loe
rtie4s
rting4
rti7saan
r4t3om
rt5ont
rt5opr
rt5org
r6treda
rt5reis
rt5ren
r4t5rie
r6trol.
r4t3ry
rt6s5aar
rts5ond
rts6pyn
rt5uits
rt4wis
rt4wyf
3rub
ru4ga
rug6-sk
rui6lek
rui6moe
5ruimte
rui6niv
4ruit5s
ru2k3
ru5kaa
ruk6lip
ruk6opp
ruk6-en
rul5aa
rul7ape.
rul7yste
r2um
rum7grok
4runi
rup7lys.
ru5spi
rus6tak
rus6tka
rus6tma
rus6tvo
rus7uur.
rut7oond
2ruu
ruus6te
ruu7ste.
rweg5a
rwe6gei
rwe6skr
rwi7sje.
rwoes5
rwy6sak
rwy6see
ry4fa
ryf7ink.
ry4fo
ryf7ode.
ryf6sch
ryf6sin
ryf6ska
ryg7stek
ryg6str
ry6kinr
ryk3l
ry5klu
3rym.
ryn4s5l
ryp7arm.
ry5ple
ryp7lus.
ryp7nagt
ry4s3a
rys6alf
ry6sinl
rys5pi
rys5po
ry3st
rys4ti
ry4su
ry4ta
ry5tra
s2
2s.
s'9ie.
1sa
3sa.
s4aad
saa6dui
3saak
3saal
4s3aan
4s3aap
4s5aard
4s3aas
4s3adm
s5adre
4s3adv
2s3af
2sag
3s4ag.
sa4gal
s3age
s4agi
s4ag4n
sa5gne
3s4ago
sag6opa
5sagte.
5s6agtew
3sak.
s5akad
3sake
3sakk
sa6k5rok
sa6krus
saks4
s3akt
4s5akti
sa6lamm
sal7ammo
4salb
s5albu
3salf
sal6fol
4s3alg
4salm
sal6mei
sal6tro
3sam
4samba
same4n
4s3amp
sam6swy
4sana
s5anal
san6d5ag
san6dak
sand7akk
san6dru
3sang
san4g5a
san6gre
sang7ste
4s5anke
sap6hat
s5appa
s5appel
sa3pr
4s3arb
4sarea
sar7olie
4s3art
4sase
s5asem
4s5aspe
sa5spr
sat6jie
4s3atl
4s5atta
sav7lon.
2sb
s3ba
s3be
s3bi
s3bl
s3bo
s3br
s3bu
s3by
s3ca
s3ci
2sd
s3da
s3de
s3di
s3do
s3dr
s3du
s3dw
sd4wa
s3dy
1se
3se.
s5eed.
see3f
see3k
s5eenhe
see6plo
see5ram
seer7as.
see5rei
see7roet
see3s4
see7soog
see5sw
se^^eb7kran
s5egpa
4segt
4s3eie
4seik
s5eik.
4seila
sei6nan
4seind
4seis.
sek6huk
4seksa
s5eksam
sek4s5k
sek4s5p
sek4st
3sel
sel5aan
sel7anal
se4l5el
sel4f5a
sel7fabr
sel6fer
self5i
sel6fid
6seliks
sel5of
sel7oor.
sel5op
sels7kak
sel6slo
sel7spen
sel6s7taa
se4m5ag
4s5emal
sem7ekst
sen6dan
sen7ghor
sen7sord
sen6str
sep6hus
ser7afse
4serf
s5erf.
ser6s5in
ser6skr
ser6sta
sers7taa
ser7stad
sers7tal
ser6tuu
s5ervar
ses6aan
4se4s5ka
ses7lett
se4s5po
se4st
se4s5ur
ses7uur.
se4sw
ses7weke
s4et.
sewes6t
sewe7ste
sey7stof
1s^^ea
2s1f2
s3fa
s3fi
s3fl
s3fo
s3fr
s3fu
2s1g
s3ga
sga4s5e
s3ge
sges7per
s3gi
s3gl
sg4ly
s3go
s3gr
s3gu
2sh
s3ha
s4ha.
sha7ron.
s3he
s3hi
s3ho
sho7shol
s3hu
1si
4s5idea
s5idee.
4s5ideo
3sie
sie7kwos
sies6li
sies7mee
si5fle
sif6reu
4si3go
si4gro
4simpl
3sin.
si5nag
s5indek
5sindr
4sindu
sin7enti
sin7este
4s3inf
s4ing
sin6gaa
sing7aan
6singes
sin7gle.
sin6gre
s5ingry
4s3inh
sin6kch
sin4kl
4sinko
s5inlig
4s3inm
4s3inr
sin6see
sin6sin
6sinslu
sin5sn
4sinv
sip6ho.
s4ist
sit6are
4s5item
si3tr
si4tre
sit7riem
sit6sik
sit5sl
3situ
siu6mur
1sj
2sja
sje6ans
5sjoko
4sjuf
1sk2
2sk.
5skaaf
skaar6s
6skaart
s5kafe
3skak
6skakeb
s5kakt
4s5kalf
4skam
4skant
3skap
ska6pin
ska6pon
skap5r
4skar.
4skara
4skas
s5kata
ska6tel
ska6tit
5skawe
3skem
4skenn
3s4kep
ske6pla
ske4p5r
4skerk
4s5kern
ske7smee
5skets
4skett
s5kiem
ski7klub
s4kil
4s5kilj
ski6lol
s4kip
5skip.
4skis.
2s3kl
2s3kn
4skod
4s5koe^^eb
5s4koen
4skoer
sko6kaa
sko4ko
4skoll
4skolo
4skolw
4skomb
4skomi
4skomp
s3kon
s4kone
4skonf
4skong
4skons
4skont
6skoord
s4koot
4sko^^f6
4skos
sko6see
5skott
4skow
6skraan
4skrag
4skran
sk4re
6skreet
s5kres
5skrif
4skrin
5s4krip
4skris
4skrui
3s4kry
4s5kryt
sku6dak
4skuik
s5kuip
5skuld
4skult
4skun
5skurf
4skus
sku6tar
2s3kw
sky7drin
s4kyf
s4kyw
1sl
s4laa
4s3lad
s4la4g
4slam
4s5land
s4lang
s5lant
4s3las
4s3lat
s4law
4s3led
5sleep
4s5leer
4s3le^^eb
s4le^^eb.
4s3lei
4s3lek
4slel
4sleng
sle6tji
slet7jie
s4leu
4s5leue
s5leus
5sleut
4s3lew
4sley
s3l^^ea
2sli
slib3
5slier
s3li4g
5slinge
slo6bee
s4lof
4sloj
4slok
4s5loon
4s5loos
4slop
slo4t5a
s5loter
s4low
sl4^^f6j
4s3lug
4slui.
4s5luia
s5luih
5sluit
4s3lus
4s3lye
4slyf
sly6mui
4slyn
sly6paf
4s3lys
2sm
s3ma
s4mad
5s4mart
s3me
s5melk
5s4melt
s3mi
5smid.
smi4s
smit4h5
3smok
s5mol.
s3mon
s3mu
3smy
smy6nin
s4myt
1sn
s5naai
4snaam
s5naat
4s3na4g
snag5e
snag6s.
4snam
sna6pro
s4nar
s3nas
4snat
4snav
snee7tji
4s3nek
3s4nel
4s3nes
4s3net
4sneu
sni6kwa
sni6tre
s4nob
5snoet
4s3nom
4snoo
4snorm
s4nui
sny3
s4nye
5snyer
sny6-ys
1so
4soef
3s4oek
soe6kal
soe6kev
soe6kol
soe4k5u
s4oen
soe6nys
4soes
5soet.
soets6t
soet7ste
sof6agu
4soff
so3fr
sof6ree
sog4l
soi6ets
sok7opho
3sol
s5olie.
sol6lme
solo5s
s4om.
s4ome
4s3omg
4s3oms
4s3omv
3s4on.
s6onde.
s7ondern
3s4one
so6neek
son7eekh
son5eg
4son3g
son7kwas
so4n5op
son4so
4s3ont
son7uit.
s4onv
4sonw
4soog
3s4ool
4s5oond
soon4s
4s5oor.
4s5oorb
4s5oord
4s5oore
s5oorg
4s5oorl
s5oors
5soort.
s5oortr
2s1op
3sop.
sop7ekst
so5phi
sop6hok
s4opi
5sopie
s3opl
3sopo
so3pr
5s4op4ra
s3ops
s3opt
s3opv
4sord
5sorg.
4s5orga
sor6gee
sor6gra
sorg7raa
s5orke
so5ror
4sorto
sos4h
so5sha
so3th
sot4ho
so3tr
3sou
4soud
s5oude
sou6spa
sou4s5t
sou6taa
sou6tak
4souto
s5outom
so9ya.
s5paal
5spaan
4spad
4spak
3s4pan
span5o
spa6noo
4spap
4spark
4s5pas.
4spast
spa6tar
4spatr
4spe.
3s4pee
spe4k5l
spe6kne
spe6lak
5speler
s4pell
6spelot
4spen
s5pen.
4sperd
4sperk
5sperm.
4spers
4spes.
5spesi
4spet
s4peu
4s5piek
s4pio
2s3pl
5s4plee
5s4plin
5splits
3s4ply
4spoei
4spol
4spom
spon6st
5spoor.
4spoot
5spore
6sportr
4spos
4spote
s5poti
5spraak
6sprakt
4s5prat
spreek5
s5prem
4spres
5spreu
4sprob
5sproei
4sprof
4sprog
5s4pron
4spros
5spruit
4spry
s3ps
sp4si
4spub
3s4pul
4spun
4spyn
4spyp
2s1r
s3ra
sra4e
s3re
s3ri
s3ro
s3ru
s3ry
2s1s
s3sa
ss4af
ss4ag
ssa6rol
ssay7is.
s3se
sse6nas
sse4n5i
sser4s
sse5st
s3si
ssie6l7ei
s3sk
ss4ko
s3sl
s3sm
ss4ma
ss4me
s3sn
s3so
s3sp
ss4pl
s3st
ss4ti
s3su
s3sw
s3sy
2st.
4sta.
s4taa
st5aard
5staat
3s4tad
4stafe
sta6las
stal7as.
4stale
sta6lee
sta6lem
4stali
5s4talt
5s4tam.
sta4m5o
5s4tan.
stand8s7ta
4stari
3s4tat
s5tatr
4stea
s4tedd
5s4tede
s4tee4k
5s4teen
4steer
4steg
ste6gre
st4ei
ste6kli
ste6lek
stel7eks
6stelev
5s6telse
stel6tj
stelt7ji
5s4tem.
5stemm
ste6mom
ste6nou
4stent
s5teny
4steo
6sterap
ste6r5ei
5sterkt
4sterm
ste6rom
ster5sm
ste6rys
ster7ys.
ste6ser
ste6sin
ste6ska
ste6ski
ste4sl
ste6sma
2sth
s3ti
4stie
s4tigt
4s5tiku
sti6laa
s4timu
sting5a
5stinkh
s4tip
4stir
4s5tite
s3tj
4sto.
s5toeg
s5toek
5stoel.
6stoela
s5toen
4stoer
4stoes
s5toev
s4tof
sto6fek
sto6fem
sto6fen
sto4fo
4stog
sto4ka
sto6kle
sto6kre
3s4tom
4stone
4stoon
st4op
sto6poo
4stos
sto4st
3s4tot
s4tow
s4traa
4strad
s6trak.
4s5trei
s4trew
4s5tril
6strins
4stroe
s5trog
str6ont
6stroon
6strosp
4strot
s5trots
4strou
4strov
s4tru
5struk
4s5trus
3s4try
stu4c
3s4tud
4stuig
3s4tuk
stu6kin
stu7klep
stu7stra
stu4to
stu6tys
st4wi
2sty
4styd
5styf.
3s4tyl
sty6loo
1su
su2b1
sub3a
sub7gids
sub7hoof
sub7nasi
sub5oo
sub7reko
3suid
sui6daf
sui6dei
s4uik
s4uil
suip5l
sui6pro
4s3uit
s4uiw
sul6tin
sum7aans
2sun
s3uni
su4su
sut6her
su9yo.
2sv
s3va
s3ve
s3vi
s3vl
s3vo
s3vr
s3vu
s3vy
svy7kraa
2sw
5s4waai
5swael
s5waen
3s4wak
3s4wa4m
swam5a
s5wand
5swart
s3wat
3s4waw
6sweefs
s6weeft
s5week
5s4weep
5s4weet
4sweg
5sweis
s4welg
3s4we4m
5s4werm
swe6tre
s3w^^ea
s3wi
s4wik
4swil
s3wo
5swoeg
swor6st
4swort
s3wr
s3wu
3swyg
1sy
5syfer
sy3k
syn6agr
syn6sin
syn5sm
sy5pla
sy3sk
4syst
s5yster
4sywe
s5ywer
2s-
1t
2t.
3ta.
taa6nam
4taand
taan5s6f
6taansi
4taant
4t5aanv
3tabb
4tadm
ta4d5ro
tad6ser
tad4s5i
tad6ska
tads5n
tads5p
tad6ste
tad6s5to
4taf.
4tafd
3tafe
tafe4l
4ta4fr
4t3afs
4tafv
4t3afw
t4age
4t5agen
4tags
4t3agt
tai4l
ta5inv
tai7peis
5take.
tak6lep
ta5kli
ta4kr
tak7rol.
3takt
tak7wyn.
3tale
tal7eenh
tal7emme
5talig
tal6kaa
tal6sor
ta6mind
tam7inde
tan6dat
tan4dr
tand7rin
tand6sto
tang5st
4t5anna
tan4sk
tap5ro
3tari
4tark
4tarm
t5arm.
tar5oo
t5artik
ta4s.
t5asem
tas4p
tas6tas
tat7isol
tat4j
tat7jies
ta4t5ra
2tb
tba6lun
tby6tei
2td
tdy7ing.
teby6s.
3tedo
teek5r
tee6lee
tee7lood
tee6mev
tee4mo
tee4n
4teenh
3teer
tee7raad
tee7renv
tees4
tee5sk
tee5sl
tee5st
tee7suik
4t3eeu
tef7lon.
3tegn
teg6ori
teg7ren.
5tehui
tei6noo
tek2
5tekam
tek7bak.
5teken
teke8n7aap
tek7haak
tek7limi
5tekor
tek7semp
tek6sin
teks5k
teks5t
tek7stel
tek5vo
te6laap
tel7aap.
te4l5ak
te4l5ap
tel7dwei
te4l5el
tel7fles
tel7idee
5telik
tel6lho
tel7oes.
tel7oog.
te6loon
tel7oond
tel7smed
tem7asse
4temm
tem7omva
te6moog
tem7oog.
5tempo
tena6ge
5tend.
t4enh
ten6kaa
ten6koo
ten7ouer
ten6san
ten7slot
5tenso
ten4s5u
ten4t5j
ten4tr
tent7reg
ten7treu
ten7twen
3teo
te3p4h
ter7adel
5te4r5af
ter6afi
ter6ago
te4rak
ter7akro
ter7als.
ter7aman
ter7amer
te6ramp
ter7amp.
5terap
ter5app
ter6arg
ter6dro
terd7roo
ter5een
te4r5el
te4rem
4terft
te6rin.
ter7ink.
terk7wyn
3term
ter7omra
ter5ond
ter5ont
5teror
ter5os.
te4r5ow
ter7raan
5terrei
ter7rein
5terri
ter6sas
ter6sef
ter6seg
ter6skop
ter7sopn
ters6we
ter7swee
ter7syst
ter6tap
te4rui
ter7uie.
te6ryst
ter7yste
ter6-in
3tesi
tes7inst
tes7loe.
tes7lydi
tes7mart
tes7meto
tes7proe
tes7teri
tes6tud
te5sty
te4s3w
3teti
teun5s4
2t1f
tf4li
2t1g
tg4af
tge6nap
tg4li
2th
3tha.
t4has
4thei
3t4hen
ther6aa
the7raan
the5ro
3t2hi
4thit
t5hitt
th5leh
t4ho.
tho6nat
ths7chil
t4hy.
tib7niet
tie4f
tief5o
tie6gri
tie6kap
tie4k5l
tie6kom
tie4k5r
tie4k5w
tie6ro^^eb
tie7smoo
4tif.
4tiff
4tigm
tike4
ti4kla
tik7lug.
tik5ro
tik6waa
4til.
til7aan.
4tild
4til3s
4tilt
4t3ind
tin7erts
tin4ga
tin7gaal
ting7aan
ting7eg.
tin4g5r
ting6su
tings7uu
4tinkh
tink7wa.
4t3inl
4tinv
5tipe.
5tipes
ti4rp
tis6aan
ti3sj
ti3tr
tive5r
t2j
2tja
tje6sni
tjo4k
2t1k
tki6sob
tkom4s5
2t1l
t3la
tla6sin
t3li
t3lo
t5lont
2tm
tme6sti
2t1n
tne6ywe
tnot4s5
3to.
toe7eien
4toef
5toef.
toe7gly.
toe7klap
toe5kr
4toel.
5toe5la
4toele
toe6let
toe6lop
4toelt
4toep.
toe7plei
5toern
toe6rou
5toeru
3toes
toe5sl
toe5sm
toe7swel
to^^eb7roti
to4fa
tof7ekst
tof7emis
to4f5io
tof7onde
3tog
to4gl
tok7las.
tok7lett
tok5ou
t5olie.
4tom.
4tond
3tone
ton4gr
tong5s
4tont
t5ontl
t5onts
3toon
t5oper
to5p4he
4topm
top7oorl
4topv
tor7eien
tor7eval
to6rint
tor7inte
tor6m5ag
tor6mom
to1s
to3sf
tos6tro
to3tr
tot6ste
tou3s4
tou7tjie
tou6wsr
to4wn
toy7ota.
2tp
tpen6sk
tpie6tj
tpiet7ji
tplek5
tpoor6t
tpoort7j
tp4sa
t5psal
t2r
4t5raad
t5raam
5tradis
4traf
tra6fas
traf5o
tra6foo
5trakta
5transa
5transf
tra6paf
trap7as.
tra6pew
tra7plo^^ef
5trapp
trat4
tra5tj
4tratu
4trea
t3rec
t5reda
t5redd
t4ree
4treek
4t5reen
4tre^^eb
4treg.
t5regi
tr4ei
t5reini
tre6ink
4treis
tre4ka
tre4k5l
tre4ko
tre4kr
trek5w
tre6kwi
t4rer
t5rese
tre4st
tre4t
tre7talb
tret5j
t5reuk
t5rewo
5tribu
t5rief
trie6kl
5tries
tri5g4l
4tring
trobo5
4t5roer
tro6las
trol7as.
tro6lin
tro6naf
troo4
4troom
tro6ski
3trou
3trov
4trub
4t3rug
truit6j
trui7tji
4truk
tru7kopp
trust5r
4tryk
2t1s
ts5agt
t4sam
t4sar
ts5arg
t4s5eks
t4s5eng
tse6raf
tse6rys
tser7ys.
t6singr
t4s5ins
ts5inv
tsi7tsik
ts5jae
t4skar
ts5kok
t4skon
t4skor
t6skrie
t6skrip
t4skru
ts5lam
t5s6maak
t5s4mee
ts4mel
t4smo
ts5mot
t5smou
ts5nat
ts5neu
ts5oon
t4s5pas
ts5pen
ts5pot
t4s5pro
ts5tea
t5stel
t6stend
ts4ti
ts5toer
ts5tron
t3stu
t3su
ts5waar
t5swar
t5swen
ts6wing
ts5wyn
2tt
tta5tj
tte6lo^^eb
tte6ral
tte6ram
tte7ridg
tte4ro
tte7ruil
tte6slo
tte6s5ta
tte5us
tt4he
tting5a
tt5uur
3tua
3tue
3tuig
3tuin
4tuits
tu4kl
tum7aanw
tur6kna
4turt
tus7aart
tus7eter
tussen5
tu5t^^ear
2tv
tv4li
2tw
twee5k
twee5l
twees4
twerp5o
twi6sap
3tyd
tyd7aanw
tyd7lont
tyd7orde
tyd3r
tyd6sat
3tye
tyl7oorw
3tyn
tyn7spre
ty3o
t5yster
2tz
tze6nel
2t-
u1a
ua4e4s
uahu6a.
u4b3ag
ubas4
uba7slag
ub5eko
ub3f
ub5gro
ub5int
u3bl
u4blu
ub5lun
ub3or
ub5sch
ub3t
ub3v
ub5wyk
uck6len
u4d3ar
udi6top
u4d3re
u4dri
uds6med
ud5sor
ud6stoe
uds6tyd
u1e
ueb5lo
uer7ione
ue4ron
uer7onde
ues7tria
ue5uni
u4fri
uf5rin
ufs6maa
ug5aan
u4gei
uge6ska
ug1l
u2go
ugo6mol
ug3or
u2g3r
ug3s
ugs4k
ugs4l
ug4soo
ugs4p
ug5ste
ugs6tek
ug5sto
ug5sui
ug4ub
ui4dag
uid7arts
ui4d3o
ui4dr
uid7reek
uid7simb
uid7skat
uid7skel
uid7skil
uid7slui
uid5spr
uids6to
uid7stoe
uid7uits
ui1e
uiers6w
uies6ma
uie7smaa
ui4f3a
uif7eend
uif5le
ui4go
ui4g3r
uig3s4
ui4k3a
ui4k3l
ui4k3r
uik7sfee
uik6sta
uik7uitk
ui4kw
uil7aap.
uil5eks
uil7esel
ui4l5oo
uil7tjan
ui4ma
uim7oes.
ui4na
ui5nae
uin5ar
uin7asyn
uind4
uin7drek
uin7ivoo
uin7kole
ui4n3o
uin7ser.
uin5si
uin6ska
ui4pl
ui4po
uip5oo
uip7ore.
uip7roes
ui4s3a
uis3j
ui4s3o
uis5ta
ui4t3a
uit7dein
ui4t5ee
ui5ter
uit3j
uit3r
uit4sj
uit6-as
uk4aa
ukaar4
uk5loo
u4kof
uk5off
u4kor
u5krat
uk3ry
ukse4s
uk4ski
uks4m
uks7pop.
uk4sv
uk4th
uku7yama
u2k3w
u1la
ul3ag
uld5erk
ule6sta
ul^^ea6r-w
ulf6api
ul5ins
u1lo
ul5oog
ulp7eksa
ulp7oort
ulp7orga
ul4saa
uls6oms
ult7inge
ult7uit.
u1lu
u2m
u3ma
um5agt
umat4
uma5tj
u3me
umg6rok
u3mi
um4ie
um5ond
um4s.
ums7feld
u3mu
u4mui
umu4s
un5arm
uner6st
5unifo
3univ
unk7reda
un2s3
uns6enb
un4sid
uns6kap
un5s6kol
un7s6kool
uns7lagg
uns7taal
un5str
unt7eenh
un6tinn
unt7real
unt6roe
unts6ko
unt5sw
unug6s.
u1o
upi6lop
u4ply
u4pon
u1ra
ur5aar
ur3af
ur5agt
ur3ak
u5ra5s4t
ur5atl
ur5een
u4ref
ur5eff
ure5um
urf7loop
urg6h-s
urg7laag
u4r5int
urke5s
urk7nael
u1ro
uro7pesi
urp7agti
urr7heim
urs7agte
ur4s5ek
urs6fee
ur6sloo
urs7mous
ur4sno
ur4s5oo
urs7paar
urs6par
ur4spr
urs6wee
urs6wie
ur6t5oor
ur4top
urt7room
u1ru
u1ry
us3ag
usa7lag.
u4sap
us5een
use5st
ush7die.
ush7koal
usie4k
usiek5l
u4s5ins
u2s3k
us4k.
us4kok
us4kri
u2s3l
u3s4lu
u4sno
u2s3o
us4ol
us4or
us3p
us4pie
u4spo
us5pot
usse7us.
us3t
us4t.
ust5akt
usta6v.
us4tb
us4tf
us4tg
us4th
us6tink
us4to
us6trek
us5tru
us4ts
us3w
u2t
u3ta
ut5adm
u4t3ag
uta7spek
u3te
ute7ling
ute7rago
u3ti
u3to
u4topl
ut5org
ut4rek
uts7luis
ut4spr
u3tu
u3ty
uu2
uur1
uur3i
uur6s5in
uus3
uus6khe
uut3j
uwees4
uwe7smit
u5yste
u3yu
^^fb1
1^^fc1
1v2
vaar6st
va4kar
vak7eie.
va4kes
va4ki
va5kie
va4k3o
va4kr
val7este
val7fees
val7funk
val7isog
valk7o^^eb.
val7opto
val4sa
val6spa
vals7pan
val6spo
val6spr
val6s5te
val6sth
va4n5ee
van7effe
van6gap
van6gre
van7uit.
vari5et
var6kja
var6kle
var4k5n
var4k5o
var4k5r
vas7ent.
vas6oor
vas7waai
ve2
ve3d
vee7kong
vee5kr
vee4l
veer5a
vee3s4
ve9ga.
veis4
vei5st
vel6don
vel4d5r
vel5oo
ve5lop
vel5sm
vel7sple
ve5lum
ve3na
ve3ne
ve5nor
ven4t5j
ve3nu
vep7legi
3ver1
ve9ra.
verd4
verdien7s8
ve5reb
ve5rek
ver6ema
ver6ena
ve5rend
ver6eve
ver6flu
ver6fru
ve3ri
ve6r5inn
verk4
ver5kl
ver5kw
ve7rona.
ver5sa
vers6ki
ver7skin
vers8kop.
ver5sl
ver5sm
vers6mag
ver5sp
ver7stal
ver5s4w
vers8waar
ver4t5j
ver5tw
ves3p
ves3t
ves7taal
ve5suv
vet5in
vet5ji
vet7opga
vet3r
vets4
vet5sm
vid5so
vie7ring
vig4s
vi5rag
vi4rg
vi4r-
vi4sar
vi4so
vis5ol
vis7oog.
vis5tr
vi3tr
vit7rate
vlag5s
vla4k
vla7koek
vla6sak
vle4k
vlek5l
v4lie
vlie6so
voe6rek
voe6rui
vo^^eb4l
vo^^ebl7o^^eb.
vog7inho
vo4gr
vo4lei
vol4g5a
vol6gon
vo4l3o
vol7song
vol7uit.
vol7ywer
vond6s7te
von6klo
voo7doo.
voor5s4
vor4s5t
vor7ster
vou7pops
vou5tj
vra6gry
v4re.
vree6tj
vreet7ji
vrie6sp
vri6jze
vry7duik
vry7kyk.
vry3s4
vry5st
vry7uit.
vu4e.
vu9yo.
vyf7armi
vy3s
1w
2w.
4wael
wae6lat
4wa4eo
3wag.
wag6las
wal6ste
wand6sk
wan6gaa
wan7inge
wans4
wan5sm
5wapen
3warm
war4s3
wars6e.
4wart
war6thi
war4t5j
war6to^^eb
wart7o^^eb.
war6too
war4t5r
war6tys
wa5shi
was6kaa
was5la
was6mou
was7pan.
wa5str
wate6ra
water7aa
wat5so
we4bad
we4bm
we4b5ru
web7taal
web7vlie
3wed
we4d3r
we5dra
we5dry
we4dy
5weefse
weeg6s.
wee5ran
wee5sa
wee7skaa
wee5sko
wee5sl
wee5s4p
wee5st
wee6tru
3weg
we4ga
weg7dof.
weg3l
we4go
weg7orde
we4g3r
weg3s4
weg5st
we4gu
4weis
we4k5ro
wek7uur.
wel7aanb
we6larg
we4l5ee
wel7flan
wel7fron
wel5oor
we4l5op
wel6ske
we4m3o
wem6os.
we4nak
we4n5as
wen7eens
wen6sad
wen6san
wen6sar
wen6sei
wen6ser
wen6ses
wen4sk
wens5ka
wen7skud
wen4s5l
wen4so
wen6spr
wen6ste
wens7tes
wen4s5u
wer7esse
wer6fom
wer6gar
wer6gre
wer6int
3werk
wer6kad
wer6k5af
wer6kes
wer4kl
werk7laa
wer7klan
wer7klap
wer7klok
wer6koms
wer6kon
wer7kony
wer6kre
wer6kro
wer6kuu
wer4kw
wer5kwa
wer4ky
we4r3o
wer6paf
wer6pan
wer6plo
wer6pon
wer6poo
wer6por
wer7smed
wer7uil.
wes6mit
wes7oewe
we4sp
wes7pemi
we4s3t
we5sta
wes4th
we5s4tr
wes7waar
3wet.
wet7regu
wet4s5o
wet4s5t
wet7wysi
3w^^ear
4wfon
wids7tor
wiel5a
wie4t5j
wi4gr
wi4kl
wi4ko
wiks7te.
wil6dag
wil6sin
wil4sk
wind7as.
win6del
win6dop
wind7op.
win4dr
wind7ruk
win6kle
win4sk
win7sky.
win4s5t
win7ston
win6tap
win6tes
wip7lig.
wip7roos
wit5el
wit7inkb
wit5ji
wi4t3o
wit5ro
2wj
wje6tun
4woeg
woe4s
wo4l3a
wol7invo
wol6klo
wo4l3o
woor6dr
wo5rum
wou6dag
w2r
wree4
wri6gon
2ws
wur4gr
wur4m
wurm5a
2ww
wwe7rint
wyd5oo
wyd7uite
wyk6was
wyn6and
wyn5sm
3wys
wys7aksi
wys3k
wys3p
wys5ta
wyt7raak
x'9ie.
x1a
xe1
x3em
xerox7e.
x2h
x1i
xys6te.
y1a
y4ama
ybe6lil
y2d
y3da
y3de
yden4s
ydgele6
ydg6leu
y3di
yd3of
yd3re
yd3ro
yd4sin
yd6skat
yds7krit
yds7orde
y1e
y4enn
yer2
yer7hof.
yer7maat
yer4s
yer7ton.
yer7vill
yer7vo^^ebl
yes6agt
3yeu
yf3aa
y4far
yf5as.
yf3l
y2f3r
yf5ren
yf4sl
yf4su
y1g
yg4le
yg4li
yg4ly
yg5saa
ygs7kans
yg5sko
ygs5le
ygs6tek
yg4sto
yg4stu
ykaar4
yker6st
y4k5ins
y2kl
yk3li
yk4lu
yk5lui
yk5lus
ykoms4
y4kor
yk3ri
yk4s5ad
yk4sk
yks7kans
yk3sp
yks4t
yk4su
y2k3w
y1la
y1lo
y4loe
yls7laar
y2n1a
yn4a.
y4nei
y4n5ete
yn1g2
yn5kli
yn5kwa
y2n1o
y3n4om
yns6agt
yn4s5am
yns5ins
yn5sly
yns4m
yns7maan
yn4s5or
yn4sp
yns7paar
yns4t
yn3u
yo9yo.
y2p
y3pa
y3pe
y3pi
y5plan
yp3li
yp5org
y3pr
y3pu
y1r
y4sam
ys4ig
y4s5ind
y4s5ins
y2sk
ys5kar
ys3ko
y5s4koo
y2s3l
y2s3n
y2s3o
ys4ok
ys4ou
ys5poe
ys3t
ys4ta
y4s5taf
y5s4tel
y4ster
y3s4tr
ys4tu
ys3ui
ys3w
y2t
y3ta
yt3ag
y3te
yt4ha
y3ti
y3tj
y3to
y3tu
y3ty
yve7sant
1z
2z.
4zbur
zee7rust
zen7elle
zi2c
zi5cat
4zman
zook6a.
2zz
2-1
-er4t
-ert5j
-ha-7ha.
-k4li
-na6gew
-s4ti
-t4we
-5twee
}
\hyphenation{
sandaal
aand-e-tes
aan-gons
aan-sit-riem
af-ets
af-glooi
a-fri-kaans-eer-ste-taal-spre-ker
al-berts-kroon
al-ler-geen
baad-jie-mou-e
baan-vak
bar-mit-swa
boek-il-lus-tra-sies
bruids-ka-mer
buf-fels-poort
bur-ger-drag
chris-sies-meer
da-gha-men-ger
dak-oor-hang
dek-la-ding
dek-weef-sel
del-gings-fonds-plan
deur-swer-we
di-a-lek-woor-de-boek
dik-bek-wind
di-vi-dend-uit-ke-ring
dom-siek-te
drie-hoeks-me-ting
druk-ker-fonts
ei-en-doms-w^^ea-reld
eks-trin-sie-ke
e-lands-kraal
e-lek-tro-ne-ga-ti-wi-teit
et-ter-sweer
fru-ga-le
gang-lig
gars-aar
ge-beds-ket-ting
ge-bruik-sfeer
ge-loofs-i-den-ti-teit
gem-mer-es-sens
ge-skoert
ge-slags-om-gang
ge-voels-kri-tiek
ge-voels-waar-de
ge-we-tens-angs
ge-wrig-smeer
gras-ta-pyt
grie-kwa
groeps-por-tret-te
grond-sop
haard-ys-ter
haat-skrif
han-dels-per-seel
han-ger-tjie-hei-de
har-sing-aan-doe-ning
hel-toe-gaan-vloek-woor-de
hond-ag-tig
ie-der-een
in-dink
in-gaar
in-skink
in-steek-slot
in-tap
in-ter-net-om-ge-wing
in-tree-da-tum
in-twy-fel-trek-king
ja-ka-ran-da-ko-nin-gin
jong-mei-sie-dro-me
ka-juits-maat
ka-li-glas
kam-de-bo-stink-hout
ka-me-roens
kam-sti-ge
kant-ruit
ka-ree-paal
karst-treg-ter
keg-an-ker
kies-a-re-as
klik-spaan
knal-kwik
kon-sep-or-don-nan-sie
kooks-oond
ko-tan-gens
kui-pers-am-bag
kuns-te-ra-de
kwak-sal-wers-mid-del
lamp-staan-der
lands-op-me-ting
lang-ter-myn-im-pak
lang-u-re
la-ven-tel-tak-kies
le-wens-kiem
lies-maat
lig-gaams-tem-pe-ra-tuur
limf-weef-sel
lip-om-ly-ner
maand-uit-ga-we
man-gaan-staal
mas-korf
mens-ky-ker
me-to-diek-es-sen-sies
mid-o-se-a-nie-se
mou-ska-kel
na-gaan-de
nar-re-slee
ne-gev-woes-tyn
nek-a-re
om-me-swaai
on-der-wys-ak-sie
on-tra-di-si-o-ne-le
oor-deels-plek
o-ra-gie
paarl-oos
pa-si-^^ebnt-re-kords
pas-to-rie-tuin
plan-ke-koors
poe-toe-pap
pos-a-dres
pot-te-bak-kers-oond
pries-ter-amp
prins-loo-straat
proe-gla-sie
pte-ri-gi-um
raar-der
re-gi-ments-kom-man-dant
regs-en-ti-teit
res-lap
rond-skink
rooi-poot-el-sie
room-ter-te
ru-staal
se-ren-ge-ti
seun-so-praan
siek-wees
sies-tog
skaats-loop-baan
skree-tjies
slet-jie
snik-warm
soet-o-lie
son-de-val
sor-ghum-oes
spoed-oe-fe-nin-ge
spoor-weg-in-kom-ste
stads-n^^f4i
sti-let-jie
stok-siel-sa-lig-al-leen
straat-slim
stre-pies-fer-weel
suid-ein-de
suip-roes
swaan-nes-te
swart-aas-vo-^^ebls
swie-ren-ga
ta-ke-la-sie
teen-sank-sies
tip-pe-ra-ry
tref-en-trap-on-ge-luk
tui-me-laar-dop
twis-ap-pel
tyds-ter-me
ui-er-sweer
uit-tree-loon
val-reep-leer
ver-band-uit-ma-ker
ver-koops-wel-sla-e
ver-sap-te
ver-val-funk-sie
ver-wy-sings-half-le-we-in-deks
vin-ger-e-te
volks-e-mo-sie
volks-ka-pi-ta-lis-me
vol-son-ge
vond-se
vos-kop
vre-des-en-gel
vre-des-par-ty
wa-pen-stil-stand
wa-ter-ver-koe-lings-to-rings
we-du-wee-skof
wel-oor-wo-^^eb
werp-lood
wes-oe-wer
xho-sa-tjie
}
\egroup

