## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

package TeX::Hyphen::Pattern::Th v1.1.2;
use strict;
use warnings;
use 5.014000;
use utf8;

use Moose;

my $pattern_file = q{};
while (<DATA>) {
    $pattern_file .= $_;
}

sub data {
    return $pattern_file;
}

sub version {
    return $TeX::Hyphen::Pattern::Th::VERSION;
}

1;
## no critic qw(RequirePodAtEnd RequireASCII ProhibitFlagComments)

=encoding utf8

=head1 C<Th> hyphenation pattern class

=head1 SUBROUTINES/METHODS

=over 4

=item $pattern-E<gt>data();

Returns the pattern data.

=item $pattern-E<gt>version();

Returns the version of the pattern package.

=back

=head1 Copyright

The copyright of the patterns is not covered by the copyright of this package
since this pattern is generated from the source at
L<svn://tug.org/texhyphen/trunk/hyph-utf8/tex/generic/hyph-utf8/patterns/tex/hyph-th.tex>

The copyright of the source can be found in the DATA section in the source of
this package file.

=cut

__DATA__
% Thai hyphenation patterns
%
% Copyright 2012-2013 Theppitak Karoonboonyanan <theppitak at gmail.com>
%
% This work may be distributed and/or modified under the
% conditions of the LaTeX Project Public License, either version 1.3
% of this license or (at your option) any later version.
% The latest version of this license is in
%   http://www.latex-project.org/lppl.txt
% and version 1.3 or later is part of all distributions of LaTeX
% version 2005/12/01 or later.
%
% This work has the LPPL maintenance status `maintained'.
%
% The Current Maintainer of this work is Theppitak Karoonboonyanan.
%
% http://linux.thai.net/projects/thailatex
% http://linux.thai.net/svn/software/thailatex/trunk
%
\patterns{%
.ชี5วั
.ทัศนู5
.ที่3
.บท1
.รง4
.ราย3
.ลำ3
.สน5ท
.สู3ต
.ใบ3
2ก1ก
ก4กม
กก4ส
2ก1ข
ก4ขค
กข5คณ
ก4ขช
กข5ชา
ก4ขณ
ก5ขณะ
ก5ขณา
ก4ขบ
กข5บุ
ก4ขภ
กข5ภั
ก4ขม
ก5ขมั
กข5มา
กข5มู
กข5ลา
กข5ศั
ก4ขเ
กข5เท
กข5เว
ก4ข์
ก1ค
กง5บว
ก1จ
ก1ช
2กซ
ก3ซิ
กญ5จน
กฎ5หม
กฎ5เก
กฏ5หม
ก5ดิน
ก1ต
ก4ตด
กต5ดิ
ก4ตส
ก4ตเ
ก1ท
ก1น
ก4นด
ก4นธ
ก1บ
ก1ป
กป4ร
ก1พ
ก1ฟ
ก1ม
ก4มม
กม5ลา
ก4มส
ก4มเ
กย5มุ
ก3ย้
กร5กฎ
ก5ร5ณั
กร5ต๋
1ก4รร
กร5รา
กร5ลา
ก5ราค
ก4รู
กร5ไฟ
กล5นค
กล5บิ
กล5มห
ก2ว
ก5วัต
ก5ษณน
ก3ษณะ
ก5ษณา
ก5ษมา
ก5ษมี
กษ5เท
ก1ส
กส4น
ก4สโ
ก1ห
กอ5อิ
กะ5ถั
กะ5ผล
4กะร
1กั
1กา
กา5กะ
กา5ดู
กา5นี
กา5น้
กา5บอ
กา5ฝา
กา5ร่
กำ5ด้
กำ5ทอ
กำ5ผล
1กิ
กิ5กะ
กิ4ต
กิ5นี
กี5รณ
กี5รต
กี5สถ
1กุ
กุ5งอ
กุ5ชิ
กุ5ฎุ
กุ5มุ
กุ5รร
กุ5ลี
กุ5แห
1กู
กู5ปร
กู5รข
กู5รม
กู5ลิ
ก1เ
ก1แ
ก1โ
ก1ไ
ก่5กอ
ก่5บ้
ก่5ป่
ก์5ท็
ข2
ขม5หิ
4ขลา
ขอ5ขม
ขอ5ง้
ขอ5อภ
1ขั
1ขา
ขา5ก๊
ขา5ทน
ขิ5ปส
ขิ5ไณ
ขี้1
ข่5มุ
ข่5หง
ข้าว3
ค1ค
คช5สี
คช5เช
คช5เม
ค4ณิ
ค4ทร
คท5รี
คท5วอ
คน5ยอ
4คนิ
คป5ซู
คป5ผก
3คมน
คม5ฟร
คม5ลอ
2คย
คร5ซอ
คร5นอ
คร5นี
คร5พน
คร5ฟิ
คร5มเ
คร5ร้
คร5ลิ
คร5หา
4ค5รัก
คฤ5หบ
คฤ5หา
คฤ5โฆ
คล5คู
ค2ว
คว5ทอ
3ควา
2คส
คส5ติ
คห5กร
คห5นิ
คห5บด
คห5สถ
3คอน
3คัน
1คา
คา5ปู
คา5พจ
คา5พย
คา5รว
คา5วจ
คำ5ดี
คำ5โอ
คำ5ไก
คี5รี
1คุ
คุ5ณู
คุ5ลี
4คุ์
คู5ปอ
คู5ลอ
2ค1เ
ค1โ
2ค์
ค์5จำ
1ฆา
ฆา5ณั
ฆี5ยก
ง1ก
ง4กห
งกะ4ร
ง4กเ
ง4ก์
ง1ข
ง4ขก
ง4ขต
ง1ค
ง4คจ
ง4คช
ง4คญ
ง4คธ
ง4คบ
ง4คป
งค5วั
ง4คศ
ง4คโ
งฆ5ปร
งฆ5สภ
งฆ5เถ
งฆ5เภ
ง1ง
ง4งเ
ง1จ
ง1ฉ
ง1ช
ง4ชี
ง1ซ
ง1ด
ง1ต
ง1ท
ง1น
งบ5ดุ
ง1ป
ง1ผ
ง1พ
ง1ม
ง1ย
ง1ร
ง1ล
ง1ว
ง4วเ
ง1ส
งส5กล
งส5กุ
ง4สบ
ง4สพ
งส5พย
ง4สภ
ง1ห
งห5นา
ง4หบ
งห5บั
งห5รา
1งา
งา5ช้
งา5รำ
งู5สว
ง1เ
ง1แ
ง1โ
ง1ไ
ง่5งอ
จ1จ
จ4จว
จ1ฉ
จด5จ่
จต5จำ
จต5มู
จป4ก
จมบ5พ
3จริ
จอ5งอ
1จั
1จา
จา5มร
จา5มี
จา5รึ
จำ5ทว
จำ5อว
1จิ
จิ5จู
จิ5ตอ
จี5ดี
จุ5ฑา
จุ5สม
จ1เ
ฉ2
ฉก5ฉว
ฉก4ษ
ฉท5ทิ
ฉร5ฉิ
1ฉั
1ฉา
ฉา5ก๊
ฉา5พย
ช1ช
ช1ฌ
ช4ฌก
ช4ฌฆ
ช5นีก
4ชน์
ชฟ5รอ
ชฟ5โร
ชร5กล
ชร5ริ
ชร5ฤก
ชร5หล
ชร5หึ
ชร5อุ
ชว4โ
ชอง4
1ชั
1ชา
ชา2ต
ชา5ตร
ชา5ปี
ชา5มต
ชา5ยต
ชา5สง
ชำ5งั
ชิ5นี
ชิ5รณ
ชิ5แก
ชี5ผะ
ชี5ผ้
ชี5ฟอ
ชี5รณ
3ชีว
ชี5วน
ชุ5ติ
ชุ5ลด
ชู5ปก
ชู5ปถ
ชู5ปโ
ช่5อิ
ช้5สอ
ช้5ได
ซน5ทร
ซ5ราม
ซล5ฟี
1ซั
1ซา
ซา5ชู
ซา5มู
ซิ5ตร
ซิ5ฟิ
ซิ5แล
ซี5ดี
ซี5นี
ซี5รา
ซี5ริ
ซี5รี
ซี5ร็
ซี5ลี
ซู5ซู
ซู5บิ
ซู5ริ
ซู5ลิ
ซู5ฮา
ซ1เ
ซ1โ
ซ่5ง่
ซ่5ซ้
1ซ่า
ญจ5ดุ
ญ4จน
ญ5จ5นท
ญ5จ5นบ
ญ5จนา
ญจ5บร
ญ5จ5มบ
ญจ5รง
ญจ5วี
ญจ5ศี
ญ4ฉน
ญ1ช
ญ1ญ
ญประ4
1ญา
ญา4ต
ญ่5บ้
ฏ1ฐ
ฏ4ฐบ
ฏิ5ทิ
ฏิ5ปท
ฏิ5ปุ
ฏิ5สน
ฏิ5สว
ฐ4ภั
ฐม5ฌา
ฐม5พย
ฐม5ฤก
1ฐา
ฐา5นี
ฐุ5ชุ
ฑา5มณ
ฑา5สถ
3ฑูร
ฒิ5สภ
ฒิ5สม
ณ1ฑ
ณ4ฑก
ณ4ฑฆ
ณ4ฑน
ณ5ฑนะ
ณ4ฑบ
ณ4ฑม
ณฑ5ลา
ณ4ฑส
ณ5ฑสก
ณฑ5สถ
ณ5ฑ5สี
ณฑ5โล
ณ4ฑ์
ณย5รั
ณ1ร
ณ4วา
ณสม4
ณห5พล
ณห5ภู
1ณา
ณา5ปี
1ณิ
1ณี
ณี5สง
ณู5ปโ
ด1ก
ด4กง
ด4กด
ดก5ดื
ด4กเ
ด4กแ
ด1ข
ด1ค
ดง4ค
ดง5ออ
ด1ช
ด4ชน
ด5ชนะ
ด1ด
ด4ดเ
ด1ต
ด1ท
ด1ป
ด1พ
ดร5ลิ
ด3ร้
ด1ส
ด4สก
ด1ห
1ดั
ดัส5ต
1ดา
ดา5มุ
ดา5รก
ดา5สว
ดำ5ฤษ
ดิ5ทอ
ดิ5ทิ
ดิ4บ
ดิ5วร
ดิ5ศว
ดี5ดี
3ดีน
ดี5ฝ่
ดี5รอ
ดี5ลิ
ดี5วี
ดี5หม
ดี5หว
ดู5ถู
ดู5ปอ
ดู5รั
ดู5หม
ดู5แค
ด1เ
ด1แ
ด1โ
ด้5ยิ
2ด์
ด์5สป
2ตก
ตก5ร้
ต1ค
2ต1ช
2ต1ต
ต4ตภ
ต4ตส
ต4ตโ
ต5ถกะ
ตถ5กิ
ต3ถา
ต5ถุป
ต5ถุศ
ตถ5เล
ตทัศนูป5
2ตน
ตน5ฟอ
ตน5วร
ต4นาธ
2ต1บ
ต4บช
ตบ5ชว
ตป5นี
ต1ภ
2ตย
4ตรก
ตร5งอ
ตร5จี
ตร5จุ
4ตรฐ
ตร5ตร
ตร5ทว
ตร5ผล
ตร5ฝร
ตร5พล
ตร5รง
ตร5ลด
ต5ริยา
ต4รู
2ตร์
ตฤ5ตี
ตล5รั
ต1ส
ต4สค
ตส5วา
ตส4เ
ต4สแ
ตส5แต
ตอ5ม่
ตะ5ใภ
1ตั
1ตา
ตา5กล
ตา5กว
ตา5นึ
ตา5ปร
ตา5ปล
ตา5ผิ
ตา5ฟู
ตา3มห
ตา5มอ
ตา5มะ
ตา5ฬี
3ติก.
ติ5จู
ติ5ช่
ติ5ทิ
ติ5นร
ติ5บอ
ติ5มศ
ติ5มส
ติ5มอ
ติ5ยม
4ติ์
ตี5ขล
ตี5คู
ตี5ตื
ตี5รว
ตี5ลั
3ตี้.
ตุ5ตถ
ตุ5ทส
ตุ5ป่
ตุ5มห
ตุ5รก
ตุ5ลั
ตุ5สด
ตู5ดิ
ต1เ
ต3แล
ต1โ
ต่5ถา
ต่5ว่
ต่5สว
ต้5ก๋
ต้5ตอ
ต้5ฝุ
ต๋5เต
ต์5คล
ต์5ฟู
ต์5ศต
ถ4กิ
ถด5ถอ
ถม5ถื
ถล5ไถ
ถว5ไม
ถะ5ถั
ถ4าธ
ถา5วร
ถ4ีย
ถี5ลิ
3ถุน
ถ่5ถอ
ถ่5ถา
4ทกา
ทค5ติ
ทค5นี
ทด5รอ
ทด5ลอ
ทธ5คย
ท5ธชะ
ทธ5ฎี
ทธ5ปฏ
ทธ5พร
ทธ5รั
ทธ5ศต
ทธ5สี
ทธ5อง
ท5ธิก
ท5ธิช
ท5ธิบ
ท5ธิป
ท5ธิผ
ท5ธิพ
ท5ธิภ
ท5ธิร
ท5ธิฤ
ท5ธิศ
ท5ธิโ
ทธ5เจ
ทพ5ธิ
ทพ5ยุ
ทฟ5ลอ
2ทย
ท5ยาน
ทร5คต
ทร5คร
ทร5ชิ
ทร5ธน
3ทรร
ทร5สโ
ทร5หว
ทร5หึ
1ทรา
ท5ราก
4ท5ราห
1ทรี
ทว5ทห
ทว5สถ
ทศ5ทิ
ทศ5วร
ทสน5ท
ทส5โก
ทห5วั
ทห5ฬิ
1ทั
1ทา
ทา5ฐิ
ทา5ฒิ
ทา5นอ
ทา5มร
ทา5รพ
ทำ5ขว
ทำ5ซ้
ทำ5ท่
ทำ5โท
ทิ5ฆั
ทิ5ฐิ
ทิ4พ
ทิ5พา
ทิ5วง
ที5นว
ที5นี
ที5รา
ทุ5คต
ทุ5ลั
ทุ5ศี
1ทู
ทู5น่
ท1เ
ท์5ดอ
1ธร
4ธรส
4ธรั
1ธา
ธา1รณ
ธิ5ฤท
ธิ5ศี
ธิ5สม
ธี5รี
ธุ5ดง
ธุ5ลี
ธู5ปน
น1ก
น4กค
น4กป
นก5ยู
นก5รู
น1ข
นข5ลิ
น1ค
นค5ริ
น1จ
น4จอ
นจ5อน
น1ช
น4ชญ
น1ซ
น1ด
น4ดร
น1ต
นต5กว
น5ตกะ
นต5ดิ
น4ตท
นต5ทิ
นต5ปิ
น4ตภ
น5ตระ
น5ตรั
น3ตรา
น5ต5ริ
นต5ฤด
น3ติ
น5ตุก
น5ตุฏ
น4ต์
นถ5ธุ
นถ5รจ
นท5ขี
นท5นน
น5ทนะ
นท5ผล
นท4ย
น5ทรง
น5ทรล
น5ทรั
น5ทรุ
นท5ฤก
น5ทลา
น5ทวย
น3ทอ
น1ทิ
น3ที
นธ5กร
น5ธกะ
น5ธนะ
น5ธุก
น5ธุร
น5ธุว
น5ธุศ
นธ5ไม
น1น
น4นต
น4นท
น4นร
นน5รา
น1บ
นบ5นอ
น1ป
น4ปจ
นป5จู
น4ปท
น1พ
นพ5ปฎ
นพ5ศู
นภ5ศู
น5ยนต
นฤ5คห
นฤ5ปเ
นฤ5เท
นฤ5เบ
น1ล
น4ลล
นว5ร่
น1ศ
นษ5กร
น1ส
น4สซ
น4สส
นส5แด
น4สโ
น1ห
นอ5กะ
3นอน
1นั
1นา
นา4คร
นา5ณั
นา5ปร
นา5รย
นา5วต
นา5วล
นา5สณ
นา5สน
นา5สว
นา5ฬิ
4นาะ
1นิ
นิ5ด้
นิ5ฟอ
นิ5มน
นิ5ยม
นิ5ยา
นิ5รอ
นิ5ลุ
นิ5วร
นิ5สง
นิ5สถ
นิ5สี
นิ5แด
นี5มี
นี5มู
1นุ
นุ5พย
1นู
2น1เ
น1แ
น1โ
น1ไ
น่5อี
3น้อ
1น้ำ
น์5สไ
บ1ก
บ4กษ
บกิส5
บ4กแ
บ1ข
บ1ค
บ4คท
บค5ที
บ4คโ
1บดี
บ1ท
บบ5ฉบ
บบ5ฝึ
บบ5อย
บ1ป
บ1พ
บร5มี
บ1ส
บ4สบ
บส4เ
บ1ห
บอ5ดี
บอ5ระ
3บอล
1บั
บัพพาชนี5
1บา
บาจ5ร
บา4ต
บา5ตอ
บา2ท
บา5ทา
บา5ทุ
บา5รน
บา5รอ
บา5สม
บิ5ชอ
บี5คิ
บี5ร่
1บุ
บุค3
บุ5ตร
บุ5ถุ
บุ5รพ
1บู
บู4ช5น
บู5ติ
บ1เ
บ1แ
บ1โ
บ๊5จี
บ๊5เบ
ปก4ส
ป4จั
ป4จา
ปฐ5ปท
ปฐ5พี
ปต5ถก
ปต5พล
ป4ทา
ป1ป
ป4ปเ
ปม5ด้
ป4ยุ
ปร5ตอ
ปร5ตี
ปร5ตุ
ปร5ผั
ปร5ษณ
1ประ
ปร5แก
ปร5แท
ปร5ไฟ
ปล5ญว
ป4วา
ปส4ต
1ปั
1ปา
ปา5ฐก
ปา5ณก
ปา5นี
ปา5ปิ
ปาร4
ปา5รเ
ปิ5ดอ
ปิ5ดิ
ปิ5ยภ
ปิ5ยอ
ปิ5หก
ปี5ชี
ปี5มะ
ปี5ฬก
ปี่3
ปุ5คล
ปุ5ถุ
ปู5จ๋
ปู5ติ
ป1เ
ป1ไ
ผก5ผั
ผณิ5ศ
ผน5ผั
ผ4นิ
ผ4ยา
ผล5พล
ผล5ไม
ผ4สา
ผี5ดิ
ผี5ตอ
ผี5ถ้
ผี5ห่
ผ้า3
3ฝอย
ฝี5มะ
ฝ่5ฝั
3พจน
พจ5นี
พช5ฉล
พช5รา
พท5ริ
พทัก4
พน5ทะ
พ4นั
พนิ4
พ1พ
2พ2ย
พย5ก๊
พร5ชย
พร5ซี
พร5มี
1พรร
พ4รู
พร5ไฟ
3พฤก
พฤ5ฒา
พล5ทิ
พล5ร่
พส5เฟ
พอ5คว
พอ5สม
1พั
1พา
4พาจ
พา5ชน
พา5นร
1พิ
พิ5ถั
พิ5ถี
พิ5ปล
พิ5รอ
พิ5รี
พิ5ลึ
พิ5ศุ
พิส5ม
พี5ระ
พุ5ชิ
พุ5พอ
พู5ทว
พู5พอ
พ1เ
พ4เย
พ่5ป๊
พ่อ3
พ้5ท้
2พ์
พ์5ดี
1ฟั
1ฟา
ฟิ4ลา
ฟี5ฟ่
ฟู5ฟ่
ฟ1เ
1ฟ้
ภค5ทร
ภค3ว
ภช5นี
1ภั
1ภา
ภา5ณก
ภา5ณว
ภา5รด
ภา5รต
ภา5รย
ภา5วน
ภิ5ชน
ภิ5มห
ภิ3ร
ภิ5สม
ภิ5ไธ
ภุ5ชง
1ภู
ภู5ฏา
ภู5ริ
ม1ก
ม4กม
ม4กษ
ม1ข
ม4ขล
ม1ค
ม4คค
ม4คอ
มค5อิ
1มงคล
มง5ฟอ
ม1จ
ม1ช
มช4ว
ม1ซ
3มณฑ
มณ5ฑน
มณ5บร
มณ5พร
มณ5เฑ
มณ5เพ
มด5ยอ
มด5ลู
ม1ต
ม4ตธ
ม4ติ
ม4ตไ
มต5ไต
ม1ท
3มนตร
มน5ฮั
ม4นุ
ม1บ
มบ4พ
ม1ป
มป4ช
มป5ฤด
มป5ฤๅ
ม4ป์
ม1พ
ม4พก
ม4พว
ม1ภ
มภ5กถ
ม1ม
ม4มเ
ม4มโ
มย5รา
3มรร
ม3รั
ม3ริ
มฤ5คิ
มฤ5เค
มล5ทิ
ม3ลิ
ม3ล้
ม1ว
มว5มอ
ม4วล
ม1ส
มส4เ
มห5กร
ม3หน
มห5ภา
ม5หาญ
ม5หาย
มหา3ส
มอ5ขว
มอ5คร
มอ5ดู
มอ5ตำ
มอ5นว
มอ5นอ
มอ5ระ
4มอั
มะ5ถั
มะ5ฝ่
มะ5ฮอ
1มั
ม4ั่
1มา
มา4ก
มา5ดร
มา5นร
มา5ป่
มา5พจ
มา5มก
มา5มุ
มา5ม่
มา5ยณ
มา5ยอ
มา5ร่
มา3ว4
1มิ
มิ5กภ
มิ5ซร
มิ5ตล
มิ5ถิ
มิ5น่
มิ5ฟล
มิ5ลำ
มิ5แพ
มี5ขม
3มืด
1มือ.
มุ5ทะ
มุ5ทั
มุ5ทิ
มุ5ทุ
มุ5ฮั
มู5ซี
มู5ป่
มู5รต
มู5ลิ
มู5หย
มู5หร
มู5ฮั
มู5แด
มู5แผ
มู5แฮ
ม1เ
ม1แ
ม1โ
ม1ไ
ม4่า
3ม้า
ม์5ภิ
ยก5ย่
ย1กร
ย4ก5ร้
ย1ค
ยง5บ่
ยง5ฝ้
ยง5อย
ยจ5คร
ยด5ย้
ย1ต
ย1ท
ย1ธ
ยบ5ร้
ย1ป
ย1พ
ย1ภ
ยม5ยอ
ยม5รา
ยม5หา
ยม5อี
ย4มิ
ย1ย
ยย4ส
ยร5ถี
ย5รบั
ยล5ไท
ยว5ข้
ยว5จ๊
ยว5ดอ
ยว5นี
ยว5ย่
ยว5รั
ยว5ไส
ย1ศ
ย1ส
ย1ห
ย4หฐ
ยห5ฐา
ย4หป
ยห5ปร
ยอ5บี
ยอ5รม
1ยั
1ยา
ยา5กฤ
ยา5กว
ยา5ฉุ
ยา5ณม
ยา5ณว
ยา5ถ่
ยา5บร
ยา5สล
ยา5สี
ยา5ฬั
ยำ5ทว
ยี5รา
1ยุ
ยุ5คล
ยุ5ตก
4ยุภ
ยุ5แย
ยุ5แห
ยู5ถิ
ยู5ฟ่
ยู5ริ
ยู5ไน
ย1เ
ย1แ
ย1โ
ย์5กล
ย์5ถ่
ย์5มน
ย์5หน
2รก
รก5ซอ
รก5ซึ
รก5ซ้
ร1กร
รก5รา
รก5ร้
รค5พว
รง5พย
รง5รอ
รจ5ถร
รณ5คด
รณ5ตร
รณ5ถั
รณ5พฤ
รณ5สถ
ร5ณาญ
รณู5ป
4รณ์
ร1ด
ร4ดป
ร4ดแ
ร4ดโ
ร4ดไ
รด5ไอ
รถ1
รถ5พย
ร1ท
ร4ทฤ
รท5ฤด
ร4ท4ว
รท5วิ
รธ5ขึ
รธ5สร
รธ5เก
รน5ทุ
4รนา
ร1บ
ร4บค
ร4บถ
รบ5ถ้
ร4บม
ร4บั
ร4บไ
รบ5ไก
ร1ป
ร4ปณ
ร5พชา
ร5พ5ชิ
รพ5ทิ
ร1ภ
ร4ภย
รม5รอ
รมาว5
รม4เห
ร4ยั
รร4ก
รร5คา
รร5จถ
รร5จว
รร5ชิ
รร5ณึ
รร5ถา
รร5ยง
รร5ยเ
รร3ล
รร5หา
รร5แท
รร5แส
รร5ไก
รร5ไต
รล5ออ
รศ5นี
รษ5ฐิ
รษ5ตร
ร1ส
ร4สก
ร4สช
ร4สเ
ร4สโ
ร3หิ
ระ1
ระ5สา
ระ5หก
5รังส
3รัฐ
1รัต
รา5กฏ
รา5กฤ
รา5กว
1ราช
รา5ชู
รา5ดร
รา5ดว
รา5ดู
รา5ม่
รา5วณ
รา5สง
รา2ห
รา5หุ
รำ5งั
รำ5จว
ริ5กอ
ริ5ซึ
ริ5ตร
ริ5ทึ
4ริพ
ริ5มน
4ริยจ
4ริยย
4ริร
ริ5แล
4ริ่
รี5คู
รี5ฑา
รี5ดู
รี5ตร
รี5ตอ
รี5มู
รี5รั
รี5รา
รี5ริ
รี5ลั
รี5ลิ
รี5ล่
รี5สอ
รี5สะ
รุ5กว
รุ5ขร
รุ5คร
รุ5ทว
รุ5ธิ
รุ5มุ
รุ5วน
1รู
รู5ที
รู5นี
รู5บิ
รูป5ก
รู5ปิ
รู5มา
รู5มู
รู5หร
2ร1เ
ร1โ
ร่5กะ
ร่5ตร
ร่5ร่
ร่5หล
ร์5กอ
ร์5กี
ร์5คั
ร์5ดิ
ร์5ติ
ร์5ตู
ร์5ทิ
ร์5ฟอ
ร์5ฟู
ร์5ลี
ร์5วอ
ฤ4ดา
ฤป4เ
ฤษ5ฎี
ฤห5บด
ล5กนะ
ลก5ลา
ลก5วั
ล3กอ
ล4กัย
ลข5คณ
ลข5หม
ลชี4
ลด5ระ
ลด5ลิ
ล4ดา
ล1ต
ล4ตฟ
ลต5ฟอ
ลบ5ตะ
ลบ5มุ
ลบ5ล้
ลบ5ไส
ลป5ตอ
ลม5งว
ล3มอ
2ลย
ล1ล
ล4ล์
ล3วี
ลว5ไห
ลส5ไต
ลห5กุ
ลอก5ล
ลอ5จี
ลอ5สร
ละ5ผล
1ลักษ
ลา5กล
ลา5นี
ลา5บร
ลา5ป๋
ลา5พอ
ลา5มี
3ลาร
ลา5รอ
ลา5ร้
ลา5ฤก
ลา5ส้
ลิ5ก่
ลิ5จู
ลิ5ซิ
ลิ5ซึ
ลิ5ตอ
ลิ5นอ
ลิ5น่
ลิ4บ
ลิ5บา
ลิ5ฟอ
ลิ5มู
ลิ5ไท
ลิ5ไล
ลี5ตะ
3ลีน
ลี5ผล
ลี5ลา
ลี5วู
ลุก5ร
ลุก5ล
ลุ5ล่
ลูก1
ลู5ที
ลู5มิ
ลู5ลอ
ลู5ออ
2ล1เ
2ล1แ
ล1โ
ล่5ติ
ล่5ที
ล่5หล
ล่5ออ
ล้5โพ
ล์5สต
ว3กร
วก5ว่
ว5การ
ว1ค
1วงศ
วจ5ตร
วจ5สอ
วช5นี
วด5ถ่
วด5มว
วด5ยิ
วด5ระ
วด5ลา
วด5ล้
วด5อ้
ว1ต
ว4ตฉ
วน5ถี
วน5ท้
วน5ผส
วน5รว
วน5ร่
วน5อิ
วน5อุ
วบ5ยอ
วบ5รว
วบ5รั
วบ5ฮา
ว1ป
ว1พ
วม5รอ
ว3มู
วย5ก้
วย5จี
วย5ริ
วย5รื
วย5ล้
วย5ไท
วย5ไม
วร5ธิ
วร5มณ
วร5มห
ว4รย
1วรร4
ว4ร์
วล5ระ
ว1ห
วอ5ชิ
1วั
วัน3
วันต5
วันท4
1วา
วา5ดะ
วา4ต
วา5ตก
วา5ติ
วา5นร
วา5นึ
วา5บร
วา5มน
วา5รณ
วา5สนะ
วา4ห
วา5หน
วา5หิ
1วิ
วิ5กล
วิ5กส
วิ5คห
วิ5จุ
วิ5ดี
วิ5ตก
วิ5ตร
วิ5ตี
วิ5ถี
3วิท
วิ5ทิ
วิ5ธุ
วิ5ธู
วิ5ปก
วิ5ปฏ
วิ5ปล
วิ5ปว
วิภู5
วิ5มล
วิ5รง
วิ5วร
วิ5ศร
วิ5ศุ
วิ5ษุ
วิ5สร
วิ5สฤ
วิเล5
วิ5ไล
วี5คู
วี5ชน
วี5ดิ
1วุ
ว1เ
ว1แ
ว1โ
ว่5ห้
ว้5ชื
ว้5ทุ
ว้5ลา
ว์5ลิ
ศ1จ
ศน5อุ
ศพิ4
3ศรี
ศ2วร
ศษ5ซ้
ศษ5เก
ศษ5เห
1ศั
ศัก5ร
1ศา2
ศา5กา
ศา5ขบ
ศา5นุ
ศา5ภิ
ศา5รย
ศา5รั
ศา5ริ
ศา5ลา
1ศิ
ศิ5รพ
ศิ5รว
ศิ5ศี
1ศึ
ศุ5กล
ศู5ลิ
ศเจ5ร
ษ3ฎา
ษฐ5ภค
ษ5มณี
ษ4มา
1ษั
1ษา
ษา5คเ
1ษิ
ษ์5พย
สก5ลิ
สก5ลึ
สก5วั
สก5วา
ส4กา
4ส4กุ
สข5บุ
สง5ขล
ส1ซ
ส5ดิก
ส5ดิน
ส5ดิภ
ส5ดิม
สต5ทิ
ส3ตรา
2สต์
สถ5วี
4สถ์
สน5ธย
สน5ธิ
ส5นียะ
ส4นุ
สนูป5
ส4ปา
สพ5ติ
ส2ม
สม5ดุ
3สมบ
สม5ผส
สม5ผุ
สม5ผเ
สม5ยอ
สม5ฤด
สม5ฤต
สม5หว
ส5มัท
ส5มัน
สมุ4
สรร5ช
สร5ลอ
สล5บร
สว4ก
สว5ยม
ส4วร
สว5ริ
ส4วา
4สวิ
ส1ส
สห5กร
สห5กา
สห5ชา
สห5ธร
สห5ปร
สห5พั
สห5ภา
สห5รา
สห5ศึ
สอ5พล
สอ5พอ
สะ5ใภ
1สั
สัญประ5
สัน3ถ
สัม3
1สา
สา5คเ
4สาธ
สา5นึ
สา5มน
สา5มี
สา5วพ
สำ5ออ
สำ5โร
1สิ
สิ5ถิ
สี5ข้
สี5ชอ
สี5ดว
สี5ตล
สี5ตโ
สี5ถ่
สี5ผึ
สี5ฝุ
สี5ละ
สี5ลั
สี5วล
1สุ
สุ5กร
สุ5กำ
สุ5กี
สุ5ขิ
สุ5ขุ
สุ5คต
สุ5คร
สุ5นี
สุ5บร
สุ5บิ
สุ5ปร
สุ5มน
สุ5สง
สุ5ไห
2สุ์
1สู
ส1เ
ส4เฟ
ส1โ
ส4โก
ส4โค
3ส่ว
ส่5ไค
ส้5กร
ส้5ติ
ส้5ไก
2ส์
ส์5หย
ห2
2ห1ก
หก5ระ
หก5ล้
5หการ
หง4ส
หง5สา
หฤ5หร
หฤ5โห
หล5สะ
หอ5คอ
หอ5สม
1หั
หา5กฐ
หา5บพ
หา5ปณ
หา5พร
หา5รื
หา5ฤก
หิ5รก
หิ5ศว
หุ5คู
หู5กร
หู5กว
หู5หน
ห้5ท่
ห้5ท้
ห้5ร้
2ห์
ห์5กร
ห์5สน
ฬว5รา
ฬห5บู
1ฬา
ฬา5มณ
ฬา5รึ
อก5ซอ
อก5ถล
อก5รณ
อก5รี
อก5รู
อก5ร่
อก5ฤท
อก5ลว
อก5ลอ
อก5ลา
อก5ล่
อก5ว่
อก5ใบ
อค5ที
อฆ5สง
อง4คม
อง5ถิ
อง5บร
อง5บิ
อง5ฟอ
อง5ฟุ
อง5ระ
อง5อุ
อง5อ้
อด5ถอ
อด5น่
อด5ฝา
อด5ยอ
อด5รั
อด5อย
อด5ออ
อด5อุ
อด5อ้
อ3ดิ
อต5ดอ
อต5ด็
อต5ไว
อ1ท
อ4ทค
อท5คอ
อน5ง้
อน5ดร
อน5ทำ
อน5ผั
อน5ฝู
อน5ฟิ
อน5ย้
อน5รา
อ4นา
อ4นุ1
อบ5ช้
อบ5ถา
อบ5บี
อบ3อ
อบ5ไล
อป5คอ
อป5ติ
อป5พร
อป5พล
อป4ร
อป5วา
อป5โล
อพ5ริ
อฟ5ฟิ
อฟ5ฟี
อฟ5ริ
อฟ5ไล
อ4ภั
อม5ฎอ
อม5ดอ
อม5ถอ
อม5ยิ
อม5รา
อม5ร่
อม5ฤต
อม5หล
อม5หว
อม5ห้
อ5มอน
อย5กอ
อย5ก๋
อย5นว
อย5ร่
อย5ร้
อย5อิ
อ4ยา
อย5ได
อร5ชุ
อร5มน
อ3รอ
อ3รั
อ3รา
อ1ริ
อ1รี
อ3ร้
อร์1
อล5จี
อล5นี
อล5ฟ่
อล5หม
อ3ลั
อ1ลิ
อว5รุ
อศ5กร
อษ5ฐช
อษ5ฐภ
อส5กา
อส5ติ
อส5ตู
อส5นี
อส5พล
อส5ฟอ
อส5มิ
อส5เฟ
อส5แอ
อส5ไพ
อ1ห
ออ5อว
อะ5ธี
1อั
1อา
อา5ค5เ
อา5ฏา
อา5ณั
อา5ดุ
อา5ดู
อา2ต
อา5ถร
อา5นน
อา5ปณ
อา5มล
อา5ย5ต
อา5รด
อา5รต
อา5รบ
อา3รย
อา5ลป
อา5วร
อา5วี
อา5สว
อำ5ยว
อำ5อว
อิ5ชย
อิ5ดะ
อิ5ระ
อิ5ศว
อี5จู
อี5ซู
อี5ยิ
อี5รุ
อี5ลุ
อี5ศว
อี5หร
อุ5กฤ
อุ5กล
อุ5คร
อุ5ดม
อุ5ดร
อุ5ด้
อุ3ตรา
อุ5ตุ
อุ5ทร
อุ5ทิ
อุ5ทุ
อุ5ธั
อุ5บล
อุ5บ๊
อุ5มง
อุ5รพ
อุ5ลก
อุ5แว
อู5คู
อู5รา
อู5ลา
อ1เ
อเป5ร
อเสก5
อเส5ข
อเห5ต
อ1แ
อ1โ
อโร3
อ1ไ
3อ่อ
อ่5อว
อ่5อ่
อ่5โถ
อ้5อว
อ้5โถ
อ้5โล
ฮก5ฮา
ฮก5ฮื
ฮน5รี
ฮฟ5วี
ฮล5ซิ
ฮล5ดิ
3ฮอล
ฮา5นอ
ฮา5ป่
ฮา5ร่
ฮิ5บร
ฮี5บร
3ฮื้
ฮู5ลา
ฮู5ล่
ฮ1เ
ฮ่5กึ
ะ1ก
ะ1ข
ะ1ค
ะ1ง
ะ1จ
ะ1ฉ
ะ1ช
ะ1ซ
ะ1ด
ะ1ต
ะตะ4
ะ1ท
ะ1น
ะ1บ
ะ1ป
ะผี4
ะ1พ
ะ1ม
ะ1ย
ะ1ร
ะ1ล
ะ1ว
ะ1ส
ะ1ห
ะ1อ
ะ1เ
ะ1แ
ะ1โ
ะ1ไ
ั2
ัก5ง่
ัก5ซ้
ัก5ตบ
ัก5ผ่
ัก5ฝ่
ัก5ยอ
ัก5ยิ
ัก5รั
ัก5ร้
ัก3ล
ัก5วิ
ัก5ษร
ัก5อิ
ัก5อี
ัก5อ่
ัก5ใค
ัก5ใฝ
ัค5ฆิ
ัค5ซี
ัค5สถ
ัง5ถึ
ัง5ศุ
ัง4ส5ว
ัง5อว
ัง5อุ
ัง5ฮี
ัจ5กล
ัจ5ญะ
ัจ5ถร
ัจ5นึ
ัจ5โจ
ัช5ฎา
ัช5นี
ัช5พย
ัช5พื
ัช5รา
ัช5ริ
ัช5สม
ัช5เร
ัช5แพ
ัช5โญ
ัญ1
ัฏ5ทุ
ัฏ5สง
ัฐ5ทิ
ัฐ5บร
ัฐ5สภ
ัฐ5เค
ัณ5ฏก
ัณ3ฐ
ัณ5ยก
ัณ5เฑ
ัณ5โร
ัด1
ัต5ดึ
ัต5ถล
ัต5ถั
ัต5ถิ
ัต5มณ
ัต5มห
ัต5รา
ัต5รี
ัต5ฤก
ัต5ลั
ัต5หล
ัต5หี
ัท5คี
ัท5ทว
ัท5ธน
ัท5ธิ
ัท5รา
ัท5ลี
ัท5ลุ
ัธ5ยม
ัน5ฉ่
ัน2ต
ัน5ตภ
ัน5ตะ
ัน5ตั
ัน5ตา
ัน5ถธ
ัน5ทึ
ัน5ทุ
ัน5ท่
ัน4ธ
ัน5ธา
ัน5ธิ
ัน5ผว
ัน5ฝร
ัน5ฝ่
ัน5ภิ
ัน5ยะ
ัน5ย่
ับ1
ัป5คั
ัป5ผา
ัป4ร
ัป5ลา
ัป5หง
ัป5โป
ัป5โห
ัพ5ยอ
ัพ5ยา
ัพ5โพ
ัพ5โห
ัฟ5ฟิ
ัฟ5ริ
ัม4ช
ัม5ลา
ัม5หม
ัย5มร
ัย5รุ
ัล5ดี
ัล5ปน
ัล5ปพ
ัล5ปิ
ัล5ฟิ
ัล5มุ
ัล5ออ
ัล5ไซ
ัล5ไฟ
ัว1
ัศ5นี
ัศ5มี
ัศ5เจ
ัส5กา
ัส5ดง
ัส5ดน
ัส5ดี
ัส5ติ
ัส5ถา
ัส5ปู
ัส5มั
ัส5มิ
ัส5ยิ
ัส5รั
ัส5ลิ
ัส5วด
ัส5วร
าก5ถา
าก5ฝร
าก5ฝั
า1กร
า5กรร
าก5รุ
า3กอ
าก5ฮอ
า3กี
า1ข
า4ขบ
าข5บู
า1ค
า4คจ
า4คท
า4คบ
า4คป
าค5ปร
า4คพ
าค5พื
า4คภ
า5ครี
าง5บำ
าง5ฝี
าง5ฟิ
าง5ออ
าง5อิ
า1จ
า4จญ
า4จห
าจ5หา
า4จอ
า4จเ
าช5กร
าช5คร
าช5คฤ
าช5ทิ
า5ชนะ
าช5นี
าช5ปะ
าช5ลั
าช5วโ
าช5สก
าช5สี
าช5อง
า1ชิ
า3ชี
าช5เป
าช5เล
าช5โอ
า1ซ
าญ5รอ
า5ฏกะ
าฏ5ดน
า5ฏลิ
าฏ5ลี
า3ฏิ
าฐ5กถ
าณ5คด
าณ5สถ
าด5ผว
า3ดอ
า3ดิ
าด5ไท
าด5ไห
า1ต
า4ตญ
า4ตภ
าต4ว
า1ท
า4ทธ
า4ทน
า5ทนะ
าท5บง
าท5บร
าท5สก
าท5หล
า4ท์
า1ธ
า4ธน
า2ธย
าธ5ยม
าน5ญ่
าน5ผู
าน5รว
าน5รั
าน5รา
าน5ฤด
าน5อว
านุ1
าบ5จ้
าบ5ฉว
าบ5ช้
าบ5ซึ
าบ4พ
าบ5รื
าบ5ละ
า3บิ
าป5สร
าป5ส่
าป5แช
าพ5ถ่
าพ5ยน
าพ5รั
าพ5ลว
าฟ5ต้
าฟ5ริ
า3ฟิ
า1ภ
า4ภป
า4ภล
าภ5ลอ
าม5ง่
าม4น4
าม5สก
าม2ห
าม5หม
าม5หล
าม5หา
าย5กล
าย5กอ
าย5ขว
าย5ข้
าย5ชน
าย5ดิ
าย5ด้
า5ยตน
า5ยนธ
า5ยนม
าย5นอ
า5ยนเ
าย5บร
าย5ผอ
าย5ฝั
าย5มุ
าย5ม่
าย5รุ
าย5ร้
าย5ลั
าย5ล่
าย5วอ
าย5อำ
า3ยิ
าย5ไห
าร5กำ
าร3ค
าร5ชุ
าร5ณู
าร5ตร
า5รทะ
าร5ธุ
าร5บั
าร5ผจ
าร5พร
า5รภย
า1รม
าร5รา
าร5ละ
าร5วด
าร5ว่
าร5หน
า1ระ
า1รั
า1รา
า1ริ
า5ริก
า5ริยะ
า3รี
า1รุ
า1ล
า4ลก
า4ลค
า4ลจ
าล5ฎี
า4ลด
าล5ดี
าล5ทห
า4ลป
าล5ปก
าล5พร
า4ลว
าล5อุ
า4ลโ
า4ล์
าว5ก่
าว5ข้
า3วดี
าว5ดึ
าว5นี
าว5บอ
าว5ยอ
าว5ยื
า5วรณ
าว5รภ
าว5รา
า5ว5รี
าว5รุ
าว5ร้
าว5ฤก
า5วอน
าศ5นี
า3ศร
าศ5เล
าษ5ดื
าษ5ตร
าษ5รา
าษ5แก
าส5กา
าส5ด้
าส5ต้
าส5นี
าส5ปอ
าส5มห
า1ห
าห3ก
าห5มง
าฬ5โร
า1อ
าอนา4
า1ฮ
า1เ
าเม5ศ
า1แ
า1โ
า1ไ
ำ1ก
ำ1ค
ำท4ว
ำ1น
ำ1บ
ำ1ป
ำ1พ
ำ1ม
ำม5รง
ำม5ลา
ำ1ร
ำ1ล
ำ1ส
ำ1ห
ำ1เ
ำ1แ
ิก5ซี
ิก5ถอ
ิ1กร
ิก5ร้
ิ3กฤ
ิก5ล้
ิก5วา
ิก5ษุ
ิกิ5ส
ิ1ข
ิ4ขส
ิข5สิ
ิ1ค
ิ4คต
ิค5ตอ
ิ4คหะ
ิฆ5เน
ิง5ชี
ิง4สต
ิง4ห
ิง5หา
ิง5ห้
ิง5อร
ิจ5ศี
ิช4น
ิช5ลิ
ิ3ชิ
ิช5เช
ิญ5หน
ิญ5โญ
ิด5ฉิ
ิด5นี
ิด5ผน
ิด5รอ
ิด5ระ
ิด5ลั
ิด5ออ
ิด5อ่
ิต5ซู
ิต5ถี
ิต5ฟอ
ิต5ลด
ิต5ลา
ิต5วส
ิ1ติ
ิ3ตุ
ิท5ธั
ิท5สน
ิ3ธี
ิน5งอ
ิน5ฟร
ิน5ยว
ิน5ยอ
ิน5ย้
ิน5ระ
ิน5ริ
ิน5ร้
ิ5นอบ
ิน5อิ
ิน5ฮุ
ินู5ป
ิบ5บิ
ิบ5ผย
ิบ5ยื
ิบ5ระ
ิบ5รี
ิบ5ลั
ิบ5ลิ
ิบ5ล้
ิป4ก
ิป5ทอ
ิป5ผล
ิ3ปร
ิป5สต
ิป5ฮอ
ิป5โป
ิป5โย
ิ1พ
ิ4พพ
ิ4พโ
ิพ5โส
ิฟ5ฟอ
ิ1ภ
ิม5ฝี
ิม5ลา
ิ1มุ
ิย5มิ
ิร5ชร
ิร5วด
ิ1รั
ิ1รา
ิ1ริ
ิ1รุ
ิล5ปิ
ิ1ลั
ิ1ลา
ิ1ลิ
ิว5ซี
ิว5ทร
ิว5บิ
ิว5ยอ
ิว5ริ
ิว5ลิ
ิว5ลึ
ิว5ออ
ิวา5ส
ิศ5พร
ิศ5ร้
ิศ5เล
ิศ5แพ
ิษ5ณุ
ิษ5ตร
ิส5กร
ิส5กี
ิ5สตร
ิส5ติ
ิส5ที
ิส5นี
ิส5บอ
ิส5รา
ิส5ริ
ิส5ลา
ิส5ไซ
ิ1ห
ิหา4
ิ1อ
ิ1เ
ิเน4
ิ1โ
ี1ก
ี4กต
ี4กย
ีก5ย่
ีก5ริ
ีฆ5สร
ีช5คณ
ีซ5สถ
ีด5ฆ่
ีต5กว
ีต5ปฏ
ี1ท
ีท4น
ีบ5รั
ีบ5รุ
ีบ5ร้
ี1ป
ี1พ
ี4พจ
ีย5กถ
ีย5รย
ีย5รอ
ีย5ระ
ีย5รั
ี5ยวน
ีร5ณั
ีล5จุ
ี4วั
ีวา4
ีษ5มา
ีห5นา
ี5หน้
ีห5บั
ีห5มุ
ีห5รา
ี3หล
ีห5โม
ีห5ไส
ี1อ
ีอ4ร
ีอา4
ี1เ
ี1แ
ี1โ
ี1ไ
ี่5ก่
ี่5ถ้
ี่5ปุ
ี่5ปู
ี่3ห
ี่5โค
ี่5โป
ี้5กร
ี้5จ้
ี้5ตะ
ี้5ริ
ี้5ลั
ี้5ลุ
ี๊5กร
ี๋5จ้
ี๋5อ๋
ึก5ซึ
ึก5ดำ
ึก5ดื
ึก5ยื
ึก5ระ
ึก5ลั
ึก5ล้
ึก5ฮั
ึด5ถื
ึด5ฮั
ึน5ทึ
ืด5ฮา
ือ5กล
ือ5กอ
ือ5กำ
ือ5ข่
ือ5จ้
ือ5ชื
ือ5ดำ
ือ5ตร
ือ5ถื
ือ5นำ
ือ5บิ
ือ5ปล
ือ5ปื
ือ5ป่
ือ5พว
ือ5พ่
ือ5ยน
ือ5ยา
ือ5รื
ือ5ลา
ือ5ล้
ือ5สอ
ือ5สำ
ือ5อี
ุก5งอ
ุก5ฉก
ุก5ซ่
ุก5ดิ
ุก5ผา
ุก5รา
ุก5รุ
ุก5ละ
ุก5ลี
ุก5ล้
ุก5อี
ุก5ฮื
ุข5นา
ุข5ปา
ุข5ภั
ุข5ภา
ุข5ลั
ุข5ศา
ุข5ศึ
ุข5เด
ุค5ทอ
ุ3คน
ุง5ถุ
ุจ5ลิ
ุจ5หน
ุช5รา
ุช5เช
ุญ5จน
ุญ5ฤท
ุญ5แจ
ุฎ5ฐั
ุฑ5พ่
ุณ5ค่
ุณ5ฑก
ุณสม5
ุณ5หญ
ุณ5หา
ุณ5หิ
ุณูป5
ุด5ผา
ุด5ผ่
ุด5ลอ
ุด5ลุ
ุด5อู
ุต5กว
ุต5ซอ
ุต5ตก
ุ5ตระ
ุ5ตริ
ุต5ลุ
ุ3ทก
ุท5ธั
ุ5ทริ
ุท5ลุ
ุท5โธ
ุน5ทร
ุน5ผล
ุน5รอ
ุบ5งิ
ุบ5ซิ
ุบ5บิ
ุบ5ผล
ุบ5ยิ
ุบ5อิ
ุป5กร
ุป5จา
ุป5ถั
ุป5ทา
ุป5ยุ
ุป3รา
ุ5ปริ
ุ4ปส
ุป5สง
ุป5สร
ุป5ฮา
ุป5โภ
ุป5โล
ุพ5พา
ุพ5ภิ
ุภ5ชล
ุภ5เค
ุม4น
ุม5นุ
ุม5รุ
ุม5หย
ุย5ช่
ุย5ฝ้
ุ1ร
ุร5ข่
ุ4รค
ุ4รฉ
ุ4รช
ุ4รท
ุ4รธ
ุ4รบ
ุ4รพ
ุ4รภ
ุ5รภี
ุ4รย
ุ4รร
ุ4รล
ุ4รว
ุ4รศ
ุ4รส
ุ4รอ
ุ4รแ
ุ4รโ
ุล5จอ
ุล5ชี
ุล5ธิ
ุล5มุ
ุล5สต
ุล5สแ
ุ3ลา
ุ3ลิ
ุศ5โล
ุษ5จี
ุษ5ฎี
ุษ5ปร
ุ4ษย
ุษ5รา
ุษ5ร้
ุษ5เพ
ุส5รา
ุ5สละ
ุส5ลิ
ุส5วา
ุ1ห
ุห5กล
ุห5นา
ุ4หย
ุห5ยา
ุ4หเ
ุห5เท
ุห5เส
ุ4หโ
ุห5โย
ุ1เ
ุ1โ
ุ๊5ต๊
ูก5วั
ู1ช
ูญ5หา
ูญ5เป
ูญ5เส
ูด5บึ
ูด5รี
ูต5รู
ูธ5เร
ูบ5ไล
ูป4ก
ูป5ฌา
ูป5ถ่
ูป5ทร
ูป5พร
ูป5ร่
ูป5แบ
ูป5โฉ
ูฟ5วี
ู2ม
ู5มิน
ูร5ข่
ูร4ณ
ู5รณภ
ู5รณม
ู5รณะ
ู5รณาก
ูร4พ
ู5รพะ
ู5รพา
ูร4ม
ูล5กร
ูล5ค่
ู3ลั
ูส4ว
ู1เ
ู1โ
ู่1
ู้1
ู๊5ตึ
ู๋5กร
ู๋5จี
ู๋5อี
เ2
เก5ยู
เก5วั
เก5ศว
เก5อิ
เค5ซอ
เค5มี
เค5ศว
เจ5ดี
เจ5นี
เ4จร
เจ5ลิ
เจ5โต
เซ5ทิ
เซ5นอ
เซ5รุ
เซ5แค
เด5ซิ
เด5บิ
เด5รั
เด5ลา
เด5ลิ
เด5ลี
2เตช
เต5ปุ
เต5มี
เต5มู
เต5ริ
เต5ลุ
เต5ศว
เต5หะ
เถ5รา
เท5กร
เท5คร
เท5คว
เท5โว
เท5โศ
เน4ต
เน5ติ
4เนย
เน5ระ
เน5รั
เน4ส
เน5สา
เน5เว
เบ5ต้
เบ5บี
เบ5ริ
เบ5รุ
เบ5ลี
เป5ตอ
เป5สก
เป5สล
เพ5ชุ
เพ5ทุ
เพ5สล
เพ5โท
เฟ5อี
เภ5ตร
เภ5ทุ
เม5ฆิ
เม5ดิ
เม5ลา
เร5กอ
เร5กะ
เร5ซิ
เร5มอ
เร5รว
เร5วด
เล5กร
เล5คอ
เล5ดี
เล5วร
เล5วู
เล5หล
เล5ฮุ
เลิ4
เว5ก้
เว5ทิ
เว5ล่
เว5ฬุ
เส5ฉว
เส5นีย์
เส5รี
เส5วก
เส5วน
เส5แส
เห5มั
เห5ยง
เห5ระ
เห5รั
เห5ศว
เห5ศั
เห5สั
เฬ5วร
เอ5กว
เอ5ซิ
เอ5ธิ
เอ5ฬก
เฮ5ละ
เฮ5ลิ
เฮ5โม
เฮ5โร
แก5วั
แค5รอ
แค5ริ
แค5ลอ
แค5ลิ
แค5แต
แค5แส
แช5บ๊
แช5เช
แซ5ยิ
แด5รี
แต5แต
แน2
แบ4ค
แป5ซิ
แ4ปร
3แพท
แฟ5รี
แ4ฟ้
แม2
แม5ชี
แม5รี
แม5เร
แม่3
แอ5นะ
โก4ฐ
โก5ลอ
โก5ลา
โก5ลิ
โก5วา
โก5วี
โก5ฮา
โข5ทั
โข5ภิ
โข5เภ
โข5โล
โค5ตม
โค5ติ
โค5มู
โค5ม่
โค5ริ
โค5ลอ
โค5ลั
โค5ล่
โค5ออ
โค5อะ
โค5แท
โค5ไซ
โจ5ปก
โฉ5เบ
โช5ดึ
โช5ห่
โซ5กร
โซ5นี
โซ5ฟิ
โซ5ยู
โซ5ลู
โซ5สเ
โญ4ช
โญ5ปว
โด5จี
โด5นี
โด5รา
โด5ลิ
โต5กร
โต5รอ
โต5รา
โต5ริ
โต5ลิ
โท5กร
โท5คอ
โท5พล
โท5รอ
โท5แอ
โธ5ทน
โธ5ปก
โธ5ปิ
โธ5วน
โธ5เฟ
โน5ทุ
โน5ปจ
โน5รม
โน5รา
โบ5ชุ
โบ5ซอ
โบ5ต้
โบ5รอ
โบ5รั
โบ5รา
โบ5ลิ
โบ5ล่
โบ5ไฮ
โป5กส
โป5ลิ
โป5แล
โป5โป
โป5โล
โพ5ซิ
โพ5ทะ
โพ5ระ
โพ5ลา
โพ5ลิ
โพ5ลี
โพ5หา
โพ5แท
โพ5ไซ
โฟ5กร
โฟ5นี
โภ5คิ
โภ5ไค
โม5ฆี
โม5ดู
โม5ร็
โม5หา
โม5ฮั
โย5ถิ
โร5กะ
โร5คิ
โร5งั
โร5ชิ
โร5ธนะ
โร5รา
โร5ล่
โรส4
โร5สเ
โร5หน
โร5อี
โร5ฮิ
โร5แม
โร5ไล
โล5กร
โล5กี
โล5จน
โล5ปุ
โล5มก
โล5รา
โล5วะ
โล5หิ
โว5นอ
โศ5ธน
โศ5ภิ
โส5กร
โส5ติ
โส5ธน
โส5ภิ
โส5ลิ
โส5วร
โส5หุ
โส5โค
โห5ฐา
โห5รส
โห5ระ
โห5รา
โห5สิ
โห5ฬา
โอ5คล
โอ5ค็
โอ5ดี
โอ5รส
โอ5ละ
โอ5สถ
โอ5อิ
โฮ5โล
3ใช้
1ให
ไก5ลา
ไก5วั
ไข5ข้
ไข5คว
ไข5มั
ไข5สั
ไข5สื
ไค5ศว
ไช5น่
ไช5ศว
ไซ5ดอ
ไซ5บอ
ไซ5บี
ไซ5ปร
ไซ5ออ
ได5ฟุ
ได5ฟู
ได5ลิ
ได5ออ
ไท5ฟอ
ไท5รอ
ไท5แท
3ไนย
ไป5ริ
ไพ5ชย
ไพ5ธอ
ไพ5รั
ไพ5ริ
ไพ5ลิ
ไพ5หา
ไพ5โร
ไพ5โอ
ไฟ5แช
ไฟ5แน
ไภ5ริ
ไม5ถิ
ไม้1
ไล5บร
ไล5บี
ไว5รั
ไว5อะ
ไห5รณ
ไห5ศว
ไห5หม
ไห5หล
ไอ5กร
ไอ5ซี
ไอ5ดอ
ไอ5ติ
ไอ5พอ
ไอ5พ็
ไอ5ศว
ไอ5ศุ
ไอ5ศู
ไอ5ออ
ไฮ1
็ก5ซี
็จ5ขบ
็จ5สร
็ด5ลอ
็ด5อร
็ด5อึ
็น5ฉ่
็น5ทร
็น5รอ
็น5วู
็น5อย
็น5อ้
็บ5ด้
็ป5ท็
็ม5หม
่ก5ลั
่1ค
่ง5ริ
่ง5อร
่ง5อำ
่ง5อ่
่4ฉี
่น5ง่
่น5ฉ่
่น5ทะ
่น5มื
่4นย
่น5ยน
่น5ย่
่น5รม
่ม1
่ม5พว
่ย5กะ
่ย5ฉุ
่ย5รา
่ย5ร่
่ว5ช้
่ว5ถึ
่ว5ยว
่ว5ไห
่อ5กร
่อ5กว
่อ5กะ
่อ5กี
่อ5ก้
่อ5ข่
่อ5ตร
่อ5ตะ
่อ5ต้
่อ5ถื
่อ5บื
่อ5ผส
่อ5มว
่อ5ม่
่อย3
่อ5ยอ
่อ5ย่
่อ5ร่
่อ3ล
่อ5ว่
่อ5สร
่อ5ฮั
่อ5ฮ่
่า5กล
่า5ช้
่า5ดง
่า5ด้
่า5ฝื
่า5พร
่า5มง
่า5รึ
่า5ร้
่าว3
่ำ5ชอ
่ำ5ช้
่ำ5ต้
่ำ5ต๊
่ำ5ไห
่1เ
่1แ
้ก5อ้
้ง5ถ่
้ง5ฝุ
้น5งู
้น5ฉบ
้น5ฉ่
้น5ทะ
้น5ทุ
้น5ท้
้น5รุ
้น5ร่
้ม5งว
้ม5ฉุ
้ม5น้
้ม5ยิ
้ม5ละ
้ม5ลุ
้ม5อล
้ย5กล
้ย5งช
้ย5ล่
้ย5อ้
้ย5ใบ
้ว5รอ
้1ห
้อ5กร
้อ5กล
้อ5คร
้อ5คู
้อ5งอ
้อ5ฉี
้อ5ดึ
้อ5ด้
้อ5ต๊
้อ5ถอ
้อน3
้อ5ผ้
้อ5ฝั
้อ5ฟื
้อ5มู
้อ5ระ
้อ5ร่
้อ5อึ
้อ5ฮื
้า5จอ
้า5ชื
้า5ชู
้า5ช่
้า5ช้
้า5ดี
้า5ถิ
้า5ถึ
้า5บ่
้า5บ้
้า5บ๋
้า5ปี
้า5ผา
้า5ฝร
้า3พ
้า5มุ
้า5ว่
้า5สม
้า5สร
้า5สล
้ำ1
้1เ
้1แ
๊ก5ซอ
๊ก5ริ
๊ก5ลุ
๊ก5ฮว
๊ป5ซี
๊ย5ก่
๋ย5อิ
๋อ5ด๋
์ค5สเ
์ค5แล
์1บ
์1พ
์1ร
์1เ
์1แ
์1โ
%%
%% No hyphenation at the very word begin
%%
.ก6
.ข6
.ฃ6
.ค6
.ฅ6
.ฆ6
.ง6
.จ6
.ฉ6
.ช6
.ซ6
.ฌ6
.ญ6
.ฎ6
.ฏ6
.ฐ6
.ฑ6
.ฒ6
.ณ6
.ด6
.ต6
.ถ6
.ท6
.ธ6
.น6
.บ6
.ป6
.ผ6
.ฝ6
.พ6
.ฟ6
.ภ6
.ม6
.ย6
.ร6
.ฤ6
.ล6
.ฦ6
.ว6
.ศ6
.ษ6
.ส6
.ห6
.ฬ6
.อ6
.ฮ6
%%
%% No hyphenation at the very word end.
%%
6ก.
6ข.
6ฃ.
6ค.
6ฅ.
6ฆ.
6ง.
6จ.
6ฉ.
6ช.
6ซ.
6ฌ.
6ญ.
6ฎ.
6ฏ.
6ฐ.
6ฑ.
6ฒ.
6ณ.
6ด.
6ต.
6ถ.
6ท.
6ธ.
6น.
6บ.
6ป.
6ผ.
6ฝ.
6พ.
6ฟ.
6ภ.
6ม.
6ย.
6ร.
6ล.
6ว.
6ศ.
6ษ.
6ส.
6ห.
6ฬ.
6อ.
6ฮ.
6ก์.
6ข์.
6ฃ์.
6ค์.
6ฅ์.
6ฆ์.
6ง์.
6จ์.
6ฉ์.
6ช์.
6ซ์.
6ฌ์.
6ญ์.
6ฎ์.
6ฏ์.
6ฐ์.
6ฑ์.
6ฒ์.
6ณ์.
6ด์.
6ต์.
6ถ์.
6ท์.
6ธ์.
6น์.
6บ์.
6ป์.
6ผ์.
6ฝ์.
6พ์.
6ฟ์.
6ภ์.
6ม์.
6ย์.
6ร์.
6ล์.
6ว์.
6ศ์.
6ษ์.
6ส์.
6ห์.
6ฬ์.
6อ์.
6ฮ์.
6กิ์.
6ขิ์.
6ฃิ์.
6คิ์.
6ฅิ์.
6ฆิ์.
6งิ์.
6จิ์.
6ฉิ์.
6ชิ์.
6ซิ์.
6ฌิ์.
6ญิ์.
6ฎิ์.
6ฏิ์.
6ฐิ์.
6ฑิ์.
6ฒิ์.
6ณิ์.
6ดิ์.
6ติ์.
6ถิ์.
6ทิ์.
6ธิ์.
6นิ์.
6บิ์.
6ปิ์.
6ผิ์.
6ฝิ์.
6พิ์.
6ฟิ์.
6ภิ์.
6มิ์.
6ยิ์.
6ริ์.
6ลิ์.
6วิ์.
6ศิ์.
6ษิ์.
6สิ์.
6หิ์.
6ฬิ์.
6อิ์.
6ฮิ์.
6กุ์.
6ขุ์.
6ฃุ์.
6คุ์.
6ฅุ์.
6ฆุ์.
6งุ์.
6จุ์.
6ฉุ์.
6ชุ์.
6ซุ์.
6ฌุ์.
6ญุ์.
6ฎุ์.
6ฏุ์.
6ฐุ์.
6ฑุ์.
6ฒุ์.
6ณุ์.
6ดุ์.
6ตุ์.
6ถุ์.
6ทุ์.
6ธุ์.
6นุ์.
6บุ์.
6ปุ์.
6ผุ์.
6ฝุ์.
6พุ์.
6ฟุ์.
6ภุ์.
6มุ์.
6ยุ์.
6รุ์.
6ลุ์.
6วุ์.
6ศุ์.
6ษุ์.
6สุ์.
6หุ์.
6ฬุ์.
6อุ์.
6ฮุ์.
%%
%% Force hyphenation/no-hyphenation on certain characters.
%%
6ะ
%6ั
6า
6ๅ
6ำ7
6ิ
6ี
6ึ
6ื
6ุ
6ู
%เ6
แ6
โ6
5ไ6
7ใ6
6็
6่
6้
6๊
6๋
6์
6ํ
6ฺ
6๎
% Since 'เ6' conflicts with 'เ2', let's elaborate it instead
%เ6ก
เ6ข
เ6ฃ
เ6ค
เ6ฅ
เ6ฆ
เ6ง
เ6จ
เ6ฉ
เ6ช
เ6ซ
เ6ฌ
เ6ญ
เ6ฎ
เ6ฏ
เ6ฐ
เ6ฑ
เ6ฒ
เ6ณ
เ6ด
เ6ต
เ6ถ
เ6ท
เ6ธ
เ6น
เ6บ
เ6ป
% (also force 'โผ-เผ')
7เ6ผ
เ6ฝ
เ6พ
เ6ฟ
เ6ภ
เ6ม
เ6ย
เ6ร
เ6ล
เ6ว
เ6ศ
เ6ษ
เ6ส
เ6ห
เ6ฬ
เ6อ
เ6ฮ
%%
%% Begin of exception lists
%%
% Block 'ช-วา'
ช6วา.
% Block 'ไอน์~ส-ไตน์', after '5ไ6' pattern
% but still enable 'ปา~เลส-ไตน์'
ช6ไ
ธ6ไน
ม6ไห
ส6ไต
เลส7ไต
ส6ไน
ส6ไบ
ส6ไป
ส6ไล
% Block 'บ-ท~ความ'
บ6ทคว
% Fix aggressive 'ม1ว'
% but still enable 'เหม-วดี', 'ล้อม-วง'
ม6วก
ม6วน
ม6วด
ม7วดี
ม6วย
ะม6วง
% Force 'มวล-ชน', but not 'แฟล-ช'
ล7ชน
% Force 'วัต-ถุ', 'สัต-ถุ', but not 'วัต-ถ์', 'นัต-ถุ์'
ัต5ถุ
ัต6ถุ์
% Block 'เม-ตร', 'สู-ตร', 'ปริ-ตร', etc.
6ตร.
% Block 'ธา-ตุ' caused by 'ธา5ตุ' pattern
% but still allow 'ธา-ตุ-โขภ' and 'ธา-ตุม-มิส-สา'
ธา6ตุ.
% Block 'บุ-ตร' caused by 'บุ5ตร' pattern
% but still allow 'บุ-ตรี'
บุ6ตร.
% Block 'ค-รู' caused by '1รู' pattern
ค6รู
% Block 'ฮิ~บ-รู', 'ฮี~บ-รู' caused by '1รู' pattern
ฮิบ6รู
ฮีบ6รู
% Block 'ส-ภา' caused by '1ภา' pattern
% but still allow 'เส-ภา', 'โส-ภา', 'อังส-ภา~ระ'
ส6ภา
ส7ภาร
เส7ภา
โส7ภา
% Block 'ผ-วา' caused by '1วา' pattern
ผ6วา
% Block 'สกล~น-คร' caused by 'น1ค' pattern
% but still allow 'ครืน-ครั่น', 'ปืน-ครก', 'สวน-ครัว', 'สำ-มะ-โน-ครัว'
น6คร.
% Block 'เห-ยง' caused by 'เห5ยง' pattern
% but still allow 'มเห-ยงค์'
.เห6ยง
% Block 'เปี่-ยม' caused by 'ปี่3' pattern
เปี่6
% Block 'เขี้-ยว' caused by 'ขี้1' pattern
เขี้6
% Block 'ม-ณี' caused by '1ณี' pattern
% but still allow 'คาม-ณีย์', 'พราหม-ณี', 'รม-ณีย์', 'รม-ณีย-สถาน', 'รัม-ณีย-สถาน'
ม6ณี
คาม7ณี
.รม7ณี
.รัม7ณี
หม7ณี
% Block 'งง~ง-วย', 'จอ~หง-วน', 'ทราม~สง-วน', 'ลม~ง-วง', 'หง-วน', 'เข้ม~ง-วด'
%   caused by 'ง1ว'
% but still allow many others, including 'ฆ้อง-วง', 'วัง-วน'
ง6วด
ง6วน
วัง7วน
ง6วย
มง6วง
% Block 'ต่อ~ย-อด' caused by a mysterious pattern
อย6อด
% Block 'นาง~พ-ญา' caused by '1ญา' pattern
พ6ญา
% Block 'จุ-รณ' caused by 'ุ1ร' pattern
จุ6รณ
% Block 'ฤ-ชา' caused by '1ชา' pattern
ฤ6ชา
% Block 'ฤ-ทัย' caused by '5ทัย.' pattern
% but still allow 'หฤ-ทัย'
.ฤ6ทัย
% Block 'พรร-ดิ' caused by 'ร1ด'
พรร6ดิ
% Block 'สวา-ดิ' caused by 'า1ดิ'
สวา6ดิ
% Block 'คู่~อ-ริ' caused by 'อ1ริ'
อ6ริ.
% Block 'ปัญ~จ~น-ที' caused by 'น3ที'
% but sill allow 'กุน-ที' etc.
จน6ที.
% Block 'พุทธ~ค-ยา' caused by '1ยา'
% but still allow 'ภาค-ยา-นุ-วัติ'
ธค6ยา
% Block 'มนิ~ม-นา', 'มนุษย์~ม-นา'
% but still allow 'กรม-นา' etc.
นิม6นา
ย์ม6นา
% Force 'ปา-ณะ', 'หริ-ณะ', 'ตรุ-ณะ'
า7ณะ
ิ7ณะ
ุ7ณะ
% Force 'ปัณ-ณะ', 'โก-ณะ', 'โท-ณะ', 'โล-ณะ'
ณ7ณะ
ก7ณะ
ท7ณะ
ล7ณะ
% Force 'ชุษ-ณะ', 'กฤษ-ณะ' but not 'ลัก~ษ-ณะ'
ุษ7ณะ
ฤษ7ณะ
% Force 'ทรรป-ณะ', 'พราหม-ณะ', 'สม-ณะ', 'ลว-ณะ', 'ศรว-ณะ'
รป7ณะ
หม7ณะ
สม7ณะ
ลว7ณะ
รว7ณะ
% Force 'ร-ณะ' (e.g. มร-ณะ, สร-ณะ, วรร-ณะ)
ร5ณะ
% Block 'บัณ-ร-สี', 'ปัณ-ร-สี'
% but still allow 'นร-สีห์'
ณร6สี
% Block 'ก-นะ' caused by 'ก1น' pattern
% but still allow 'ยก-นะ'
ก6นะ
ยก7นะ
% Force 'คค-นะ', 'นย-นะ', 'ภว-นะ', 'มท-นะ', 'รต-นะ', 'ลว-นะ', 'ลว-ณะ',
% 'วจ-นะ', 'วท-นะ', 'วส-นะ', 'ศม-นะ', 'สว-นะ', 'อา-ลป-นะ', 'โภช-นะ', 'ไช-นะ'
ค7นะ
ย7นะ
ภว7นะ
มท7นะ
รต7นะ
ลว7นะ
วจ7นะ
วท7นะ
วส7นะ
ศม7นะ
ภช7นะ
ไช7นะ
% Force 'อา-ลป-นะ', but not 'วิ~เล~ป-นะ'
าลป7นะ
% Force 'วรรธ-นะ', but not 'อวิ~โร~ธ-นะ'
รรธ7นะ
% Force 'สธ-นะ', but not 'โส~ธ-นะ'
สธ5นะ
โสธ6นะ
% Force 'สว-นะ', but not 'เส~ว-นะ'
สว5นะ
เสว6นะ
% Force 'เสาว-นะ'
สาว7นะ
% Force 'ปัฏ-นะ', 'พัฒ-นะ', 'ชัป-นะ', 'ทัส-นะ', 'มัท-นะ', 'มุจ-นะ', 'รัต-นะ', 'วัจ-นะ',
%   'รัช-นะ'
ัจ7นะ
ัช7นะ
ัฏ7นะ
ัฒ7นะ
ัต7นะ
ัท7นะ
ัป7นะ
ัส7นะ
ุจ7นะ
% Force 'อา-สนะ', but not 'วา~ส-นะ', 'เส~นา~ส-นะ'
อาส7นะ
% Force 'ศุ-นะ'
ุ7นะ
% Force '-ผี'
5ผี
% Force '-จำ'
7จำ
% Force '-งำ', but not 'ห-งำ'
5งำ
ห6งำ
% Force 'ร่าย-รำ', 'ละ~คร-รำ', 'เต้น-รำ', 'โค-รำ', 'ไพ-รำ'
% but not 'ค-รำ', 'พ-รำ'
น7รำ
ย7รำ
ร7รำ
โค7รำ
ไพ7รำ
% Force 'ต้ม-ยำ', 'แม่น-ยำ'
น7ยำ
ม7ยำ
% Force '-งง', but not 'หงอง~แห-งง'
5งง.
ห6งง
% Force 'งัน-งก'
น7งก
% Force '-ขน', but not '-ชน์', 'เ-ชน', 'โ-ชน'
5ชน.
เ6ชน
โ6ชน
% Force '-กร', but not 'จั-กร'
5กร.
ั6กร
% Force 'มา-นะ', 'ฐา-นะ', 'ปา-นะ', 'คา-นะ', etc.
า7นะ
% Force 'เถ-ระ'
ถ7ระ
% Force 'นา-ยก', 'ทา-ยก'
า7ยก.
% Force 'า-ยน', 'า-นี', 'า-วี', 'า-ฐี'
า7ยน.
า7ฐี
า7นี
า7วี
% Force 'ป-โ', but not 'สัม~ป-โยค', 'สา~ธา~รณุ~ป-โภค'
% but still allow 'วิป-โยค', 'อุป-โภค'
ป5โ
ป6โย
ป6โภ
วิป7โย
อุป7โภ
% Force 'ทัศ-นะ', 'ทรรศ-นะ'
ศ7นะ
% Force 'ธรร-มะ'
รร7มะ
% Force 'ต-ถี', but not 'จตุ~ต-ถี'
ต5ถี
ุต6ถี
% Force '-บท', but not 'ปรัส~ส-บท'
5บท.
ส6บท
% Force '-บถ', but not 'ข-บถ', 'ส-บถ'
5บถ.
ข6บถ
ส6บถ
% Force 'กัง-ฟู', 'ถ้วย-ฟู', 'ผง-ฟู', 'ฟื้น-ฟู', 'เดียน~เบียน-ฟู', 'เฟื่อง-ฟู'
7ฟู
% Force 'จัก-ษุ'
7ษุ
% Force 'ชา-ตะ', 'นา~ริ-ตะ', 'ผิ-ตะ', 'ภี-ตะ', 'มุ-ตะ', 'รช-ตะ', 'วา-ตะ', 'ศิ-ตะ',
%   'สร-ตะ', 'สังข-ตะ', 'สิ-ตะ', 'หัส-ตะ', 'อภู-ตะ', 'อัจ~จุ-ตะ'
% but not 'ทุ-คตะ', 'ภา-รตะ', 'สวา-คตะ'
5ตะ.
ค6ตะ
ร6ตะ
สร7ตะ
% Force 'บรร~ดา-มี', 'ประ~ดา-มี', 'สก~ทา~คา-มี', 'สกิ~ทา~คา-มี', 'สวา-มี', 'อนา~คา-มี'
า7มี
% Force 'สก~ทา-คา-มิผล', 'สกิ~ทา-คา-มิผล', 'อนา~คา-มิผล'
มิ7ผ
% Force 'นา~งา~ซา-กิ', 'อิ~บา~รา-กิ', 'โด~รา~ยา-กิ'
า7กิ
% Force 'พิ~รา-กล', 'มา~ยา-กล', 'วิท~ยา-กล', 'สา-กล'
า7กล
% Force 'พิ-กล', but not 'เลิ-ก~ลา', 'บุค~ลิ-ก~ลัก~ษณะ'
ิ7กล.
% Force 'เล่ห์-กล'
์7กล
% Force '-นำ', but not 'ห-นำ'
5นำ
ห6นำ
% Force 'นารี-ผล'
รี7ผ
% Force '-ณุ'
7ณุ
% Force '-นี.', but not 'กุ-หนี', 'ตัจ-ฉนี', 'บา-รนี', 'วี-ชนี', 'หนี', 'หน่าย-หนี',
%   'อัส-สนี', 'เม-ทนี', 'เยอ-ร-มนี'
5นี.
ห6นี
ฉ6นี
าร6นี
วีช6นี
สส6นี
มท6นี
รม6นี
% Force 'คัน-ยิ'
น7ยิ
% Force 'ชิ-ลี', 'ชุ-ลี', 'า-ลี', 'โค-ลี', 'โป-ลี', 'โม-ลี', 'นนท-ลี', 'กท-ลี', 'จร-ลี'
ิ5ลี
ุ5ลี
า7ลี
โค7ลี
โม7ลี
ท7ลี
ร7ลี
% Force 'ศาก-ยะ', 'โยค-ยะ', 'สาธ-ยะ', 'มัท-ยะ', 'อน-ยะ', 'วา~จา~ไป-ยะ', 'บุษ-ยะ'
% Force 'วา-ยะ', 'ปิ-ยะ', '*ริ-ยะ' etc., 'ณี-ยะ', 'นี-ยะ', 'ภา~คี-ยะ', 'โม~ฆี-ยะ'
% Force 'สุน~ทรี-ยะ', 'ปรี-ยะ' but not 'เปรี-ยะ'
ก7ยะ
ค7ยะ
ป7ยะ
ท7ยะ
ธ7ยะ
น7ยะ
ษ7ยะ
า7ยะ
ิ7ยะ
คี7ยะ
ฆี7ยะ
ณี7ยะ
นี7ยะ
รี5ยะ
เปรี6ยะ
% Force 'มโห-รี', 'มโห-สถ', but not 'มโห-ร~สพ'
มโห5
% Force 'สิ-รี', 'กัศ~มี-รี', 'ภู-รี', 'พิ~หา-รี', 'จม-รี' (but not 'ม-รี~จิ')
ิ7รี
ี7รี
ู7รี
หา7รี
ม7รี.
% Force 'กิน-รี', 'โน-รี', but not 'น-รี~เวช'
น5รี.
% Force 'บัค~เต-รี', but not 'เต-รียม', 'ออส~เต-รีย'
เต7รี.
% Force 'วัช-รี', but not 'เช-รียง'
ช7รี.
% Force 'เถ-รี', 'เภ-รี'
ถ7รี
ภ7รี
% Force 'ภม-รี', 'ภุม-รี', 'โม-รี' but not 'ภระ~ม-รี'
ภม7รี
โม7รี
% Force 'ภุม-รี', 'ภุม-รา'
ภุม7ร
% Force 'ไพ-รี', but not 'เพ-รียว'
พ7รี.
% Force 'เว-รี', but not 'ว-รี'
เว7รี
% Force '-ผล'
5ผล
% Force '-ดล.', but not 'โม~เ-ดล'
5ดล.
% Force '-รส.', but not 'คอง-เกรส', 'จรส', 'ซู-โครส', 'เดกซ์-โทรส', 'เพรส',
%   'เอ็กซ์-เพรส', 'แอด-เดรส'
5รส.
ก6รส
จ6รส
โค6รส
ท6รส
พ6รส
ด6รส
% Force '-คน.', but not 'โ-คน', 'เ-คน', 'แ-คน'
5คน.
% Force 'กัณ-หา', 'ตัณ-หา'
ณ7หา
% Force 'ฤๅ-' and the misspelled 'ฤา-'
ฤๅ5
ฤา5
% Force '.ยี่-'
.ยี่7
% Force 'ภา-วะ', 'กา~สา-วะ', 'ปัส~สา-วะ'
า7วะ
% Force 'เท-พี', 'เท-วี'
เท7พี
เท7วี
% Force 'บรร-จง', 'บรร-จบ', 'บรร-จุ', 'บรร-ถร', 'บรร-พต', but not 'บรร-พ~ชน'
บรร7จ
บรร7ถ
บรร7พต
% Force 'ทัก~ษิ~โณ-ทก', 'ปริต~โต-ทก', 'วัส~โส-ทก' etc.
% but not 'กระ~แ-ทก' etc.
5ทก.
% Force '-ดร.', but not 'ไฮ~โ-ดร'
5ดร.
% Force 'น-ทร.', 'อา-ทร', 'นโค-ทร', 'ชโล-ทร', 'โส-ทร'
น7ทร.
า7ทร.
โค7ทร.
โล7ทร.
โส7ทร.
% Force 'กวน-อู', 'ตอง-อู'
7อู.
% Force '-พล.', but not 'เ-พล'
5พล.
% Force 'ไพร่-'
ไพร่7
% Force '-ศก', but not 'โ-ศก'
5ศก.
% Force 'อัฐ-', but not 'อัฐิ', 'อัฐ-ม', but still allow 'อัฐ-มี'
อัฐ5
อัฐ6ม
อัฐ7มี
% Force 'ชี-วี', 'ยู-วี', 'ปัถ-วี', 'มนัส-วี', 'อฏ-วี'
ี7วี
ู7วี
ถ7วี.
ส7วี.
ฏ7วี.
% Force 'ขัน-ตี', 'โร-ตี', 'ต่อ-ตี', 'คิ~ริ~บา-ตี', 'กรา~ฟิ-ตี', 'ซิ-ตี', 'จิ~บู-ตี'
น7ตี
ร7ตี
อ7ตี
า7ตี
ิ7ตี
ู7ตี
% Force 'กะ~ลา-สี', 'พา~ราณ-สี', 'มเห-สี', 'สัม~ภเว-สี', 'สู-สี', 'อิ-สี', 'เก-สี'
า7สี
ณ7สี
ห7สี
เว7สี
ู7สี
ิ7สี
ก7สี
% Force 'โบ-ลา', 'มู-ลา', 'อจ-ลา', 'เว-ลา', 'เน~บิว-ลา', 'เมข-ลา',
%   'เว~เน~ซู~เอ-ลา', แชง~กรี-ลา', 'โม~โต~โร-ลา', 'วิ~โอ-ลา', 'โซ-ลา'
โบ7ลา
ู7ลา
อจ7ลา
เว7ลา
บิว7ลา
มข7ลา
เอ7ลา
ี7ลา
โร7ลา
โอ7ลา
โซ7ลา
% Force 'สัท~ธา~ธิ-กะ', 'อา~คัน~ตุ-กะ'
ิ7กะ
ุ7กะ
% Force 'ฟุ~กุ~โอ-กะ'
อ7กะ
% Force 'นว-กะ'
นว7กะ
% Force 'ปกิณ-กะ'
ิณ7กะ
% Force 'เภ-กะ'
เภ7กะ
% Force 'มา~ตา~มหัย-กะ', 'อริย-กะ'
ัย7กะ
ิย7กะ
% Force 'วรรธ-กะ'
รธ7กะ
% Force 'วัฏ-กะ', 'วัฒ-กะ', 'วา~ณิช-กะ'
ัฏ7กะ
ัฒ7กะ
ิช7กะ
% Force 'ศต-กะ'
ศต7กะ
% Force 'อา~มล-กะ'
มล7กะ
% Force '-ทุ.'
7ทุ.
% Block 'โซ-รม', caused by 'โซ1' pattern
โซ6ร
% Block 'อินทร~ธ-นู', caused by '1นู' pattern
ธ6นู
% Force 'วัส-ดุ', 'พัส-ดุ', 'ศุภ~มัส-ดุ' but not 'กบิล~พัส-ดุ์'
ัส7ดุ.
% Force 'สวรร-คต', 'สุร-คต'
ร7คต
% Force 'อัส~ดง-คต' inhibited by 'ดง4ค' pattern
ดง7คต
% Force '-กง.' but not 'เ-กง.'
5กง.
เ6กง
% Force 'ปิ-ฎก', 'สา-ฎก', etc.
7ฎก
% Force 'บู~รณ-มี', 'ภู-มี', 'ทศ-มี', 'นว-มี'
ณ7มี
ว7มี
ศ7มี
ู7มี
% Force 'ปี-ติ', 'สัง~คี-ติ', 'ศรุ-ติ', 'สุ-ติ', 'เฮ-ติ', 'อร-ติ', 'ปัญ~จ-วีส-ติ',
%   'ติงส-ติ' (but not หนัง~ส-ติ๊ก), 'คุป-ติ' (but not 'ภค~วัม~ป-ติ')
ี7ติ
รุ7ติ
สุ7ติ
ฮ7ติ
อร7ติ
วีส7ติ
ติงส7ติ
คุป7ติ
% Block 'มุต-ติ', 'วิ~ภัต-ติ'
มุต6ติ
ภัต6ติ
% Force 'ภัก-ดี', 'ปร~นิม~มิต~วส~วัต-ดี', 'ยุพ-ดี', 'วสุม-ดี', 'ไย-ดี', 'พัศ-ดี', 'มือ-ดี',
%   'พอ-ดี', 'อรา-ดี', 'ดี~วี-ดี', 'ปรี-ดี', 'สดุ-ดี', 'ยุว-ดี', 'ดิบ-ดี'
ก7ดี
ต7ดี
พ7ดี
ม7ดี
ย7ดี
ศ7ดี
อ5ดี
า7ดี
ี7ดี
ุ7ดี
ุว7ดี
ดิบ7ดี
% Force 'นัก-รบ'
นัก7
% Force 'กุณ-ฑล', 'กุณ-ฑี', 'กุณ-โฑ', but not 'กุณ-ฑ์'
กุณ5
กุณ6ฑ์
% Force 'พร็อก-ซี', 'ยิป-ซี', 'เชล-ซี', 'เซียม-ซี'
7ซี.
% Force 'กต~เว-ที', 'เว-ที', 'ได้-ที', 'ไพ-ที', but not 'ปัญ~จ~น-ที'
5ที.
จน6ที
% Force 'เยอ-บี-รา'; 'ดู-รา'; 'มโนห์-รา', 'เซียร์-รา'
ี7รา
ู7รา
์7รา
% Force 'จิต-รา'
ิต7รา
% Force 'แรม-รา', 'โม-รา'; 'โรย-รา', 'ไอย-รา'
ม7รา
ย7รา
% Force 'มก-รา' (but not 'ก้าม~ก-ราม', 'เยี่ยม~ก-ราย'); 'รบ-รา';
%   'เลิก-รา'(but not 'วิ~ก-รานต์')
.มก7รา
รบ7รา
ลิก7รา
% Force 'เห-รา' but not 'เห-ราะ'
เห7รา.
% Force 'กร-กฎ', 'กรร-กฎ', (common misspelt) 'ปรา-กฎ'; 'กร-กฏ', 'ทุ-กฏ'
7กฎ.
7กฏ.
% Force '-หะ',
% but not '-คหะ' (e.g. ปัค-คหะ) except 'เค-หะ', 'นิค-หะ';
%         '-ทหะ' (e.g. เทว-ทหะ) except 'เท-หะ'
5หะ
ค6หะ
นิค7หะ
เค7หะ
ท6หะ
เท7หะ
% Force 'คู-หา', 'ลีฬ-หา', 'เค-หา', 'สิ~เน-หา', 'เสน่-หา'
ู7หา
ฬ7หา
ค7หา
เน7หา
่7หา
% Force '-มะ', but not 'กู~ร-มะ', 'แห-มะ', 'มหา~ต-มะ'
5มะ
ร6มะ
ห6มะ
ต6มะ
% Force '-หู', but not 'พ-หู'
5หู
% Force '-ดำ', but not 'ส-ดำ'
5ดำ
ส6ดำ
% Force '-คำ'
7คำ
% Force '-สะ', but not 'ว-สะ'
5สะ
ว6สะ
% Force '-ฐะ', but not 'ส-ฐะ'
5ฐะ
ส6ฐะ
% Force '-ธะ'
7ธะ
% Force '-พี.', but not 'ทา~ร-พี' except 'ทร-พี'
5พี.
ร6พี
ทร7พี
% Force 'ปฐ-วี'
ปฐ7วี
% Force 'พนิ-ดา'
ิ7ดา
% Force 'บุษ-บก', 'บุษ-บง', 'บุษ-ปะ'
ษ7บ
ษ7ป
% Force 'พิ-ระ', 'ธี-ระ', 'ปู-ระ'
ิ7ระ
ี7ระ
ู7ระ
% Force 'พช-ระ', 'พัช-ระ', 'วัช-ระ', but not 'ช-ระ~ลุ'
ช5ระ
% Force 'จิต-ระ', but not 'โล~กุ~ต-ระ'
ิต7ระ
% Force 'ทห-ระ', but not 'ยี่~ห-ระ'
ทห7ระ
% Force 'ภัท-ระ', 'อท-ระ', 'รุท-ระ' but not 'ทระ-นง'
ท7ระ.
% Force 'ศุก-ระ', but not 'ก-ระ', 'แก-ระ', 'อนุ~ก-ระ~เบียด'
ุก5ระ.
% Force 'สว-ระ'
สว7ระ
% Force 'อา~ภัส-ระ', 'อิส-ระ'
ัส7ระ
ิส7ระ
% Force 'เป-ระ'
เป7ระ
% Force 'ดื้อ-ยา', 'หมอ-ยา' inhibited by 'อ4ยา' pattern
อ7ยา.
% Force 'กัต-ติ-เก-ยา' inhibited by 'เก2' pattern
เก7ยา
% Force 'สวรร-ยา' inhibited by '1วรร4' pattern
รร7ยา
% Force 'สา-วก'
สา7วก
% Force 'นิ-ธิ', 'ปณิ-ธิ'
ิ7ธิ
% Force 'สุท-ธิ', 'พุท-ธิ', 'ศุท-ธิ', but not 'บริ~สุท-ธิ์'
ุท7ธิ.
% Force '~สิท-ธิ', 'มหิท-ธิ'
% but not 'สิท-ธิ์', '.สิท-ธิ.', 'บุ~ริม~สิท-ธิ', 'ไกร~สิท-ธิ'
ิท5ธิ.
.สิท6ธิ.
บุริมสิท6ธิ.
ไกรสิท6ธิ.
% Force 'อุป-ธิ'
ป7ธิ
% Block 'ขัด~สมา-ธิ' caused by 'า1ธ' pattern, but not '.สมา-ธิ.'
ขัดสมา6ธิ
% Block 'พยา-ธิ' caused by 'า1ธ' pattern
พยา6ธิ.
% Force 'ชฎา~มัง-ษี', 'ปัก-ษี', 'ภา-ษี', 'มหิ-ษี', 'ยัก-ษี', but not 'ฤ-ษี'
5ษี.
% Block 'วร~ด-นู' caused by '1นู' pattern
ด6นู
% Force 'ศิ-วะ', 'สิ-วะ'; 'ชี-วะ'; 'สุ-วะ'
ิ7วะ
ี7วะ
ุ7วะ
% Force 'อา~ชี-วก'
ี7วก
% Force 'อวัย-วะ', 'อวย-วะ'
ย7วะ
% Force 'ปริ~เท-วะ', 'ไท-วะ', 'อุ~ปัท-วะ', but not 'มัท-ทวะ'
เท7วะ
ไท7วะ
ัท7วะ
% Force 'อาช-วะ'
าช7วะ
% Force 'ไศ-วะ'
ไศ7วะ
% Force '-ถะ'
7ถะ
% Force '-ษะ'
7ษะ
% Force 'จตุ-พร', 'จตุร~พิธ-พร', 'ทศ-พร', 'สถา-พร', 'เจริญ-พร'
% but not "มะ~แ-พร้ว', 'ยุ-พ~ราช'
5พร.
% Force 'นม-ผง', 'ผุย-ผง', but not 'แผง'
5ผง
% Force 'คาน-ธี', 'ชล-ธี', 'สิน-ธี', 'สุ-ธี', 'เม-ธี'
5ธี
% Force 'ชิ-ชะ', 'ทิ-ชะ'; 'รา-ชะ', 'ลา-ชะ'
า7ชะ
ิ7ชะ
% Force 'สโร-ชะ', 'อัตร-ชะ', but not 'ร-ชะ'
ร5ชะ
% Force 'สต~ภิส-ชะ'
ส7ชะ
% Force 'โอ-ชะ'
โอ7ชะ
% Force 'ปฏิ-ฆะ', 'มา-ฆะ', 'โม-ฆะ', 'โอ-ฆะ', but not 'ม-ฆะ'
5ฆะ
% Force 'เฟอะ-ฟะ', 'เฟะ-ฟะ', but not 'เ-ฟะ~ฟะ'
5ฟะ
% Force 'กัด~ดา-ฟี', 'โคร~มา~โท~กรา-ฟี'
า7ฟี
% Force 'ดิ-ถี', 'ติ-ถี', 'ศิ-ถี', 'อติ-ถี'
ิ7ถี
% Force 'สาร-ถี'
ร7ถี
% Force 'หุย-ฮา', 'เฮ-ฮา', 'โด-ฮา', but not 'เ-ฮา'
5ฮา
% Force 'ราช-ญี', 'หัจ-ญี', 'ฮัจ-ญี', but not 'เ-ญีย*'
5ญี
% Force 'บุป-ผา', 'ภู-ผา', 'หุบ-ผา', 'เลข-ผา', but not 'เ-ผา'
5ผา
% Force 'ทัฬ-หิ', 'ปัณ-หิ', 'อัป~เป-หิ', 'อเป-หิ', but not 'เ-หิน'
5หิ.
% Force 'สิน-ธพ', 'สิน-ธุ' (but not 'สิน-ธุ์'), 'สิน-ธู'
สิน7ธพ
สิน7ธุ.
สิน7ธู
% Force 'คิว-ชู', 'สาย-ชู', but not 'ร-ชู'
5ชู
% Force 'เท-ศะ', 'เป-ศะ', 'วัง-ศะ', but not 'ว-ศะ', 'ศ-ศะ'
5ศะ
% Force 'กา~วิ-ละ', 'ติ-ละ', 'อัม~พิ-ละ'; 'มา~ตุ-ละ'; 'มู-ละ', 'ศู-ละ'
ิ7ละ
ุ7ละ
ู7ละ
% Force 'ร้อย-ละ'
ย7ละ
% Force 'ลด-ละ'
ด7ละ
% Force 'วส-ละ'
.วส7ละ
% Force 'อเจ-ละ', 'อเจ-ลก'
อเจ7ล
% Force 'เต-ละ'
เต7ละ
% Force 'แต่-ละ'
่7ละ
% Force 'กลัน-ทะ', 'ฉัน-ทะ', 'สัน-ทะ'
น7ทะ
% Force 'อุต~ตร~ภัท-ทะ'
ท7ทะ
% Force 'เส-ทะ'
ส7ทะ
% Force 'ชัน-ตุ', but not 'รัง~สิ-มันตุ์'
น7ตุ.
% Block 'กรร-ตุ' caused by '1ตุ' pattern
รร6ตุ
% Force 'มา-ตฤ'
มา7ตฤ
% Force 'ปฏิ-รพ', 'ประ~ติ-รพ'
ิ7รพ
% Force 'เคา-รพ', 'มณ~ฑา-รพ', but not 'ธา-ร~พระ~กร'
า7รพ.
% Force 'ไกรพ'
ไก7รพ
% Force 'ปร-ศุ', 'อา-ศุ', but not 'ป-ศุ'
5ศุ.
% Force 'คา-ถา', 'อนา-ถา'
า7ถา
% Force 'ขี~ณา-สพ', 'วา-สพ'
า7สพ
% Force 'โพ-สพ', 'ไพ-สพ'
พ7สพ
% Force 'คุ~รุ~มุ-ขี', 'สุ-ขี'
ุ7ขี
% Force 'คน~ทิ-สอ', 'สี-สอ'
7สอ.
% Force 'จำ~ปา-ดะ'
า7ดะ
% Force 'ซา-บะ', 'มะ-ตะ-บะ', 'อุ-บะ', but not 'ต-บะ'
5บะ.
% Force 'นันท~ทา-ยี', 'ฐา-ยี', 'ยา-ยี', but not 'ยา~ห-ยี'
5ยี.
ห6ยี
% Force 'จับ~ยี่-กี', 'วัฒ-กี', 'หริต-กี', 'อัย-กี', 'โศ-กี', but not 'ส-กี'
5กี.
% Force 'กระ~ดาน-หก', 'วลา-หก', 'โก-หก', etc., but not 'แ-หก'
5หก.
% Force 'จง-อร', 'เอม-อร', but not 'สลัง~ง-อร์'
ง7อร.
% Force 'เอม-อร', but not 'พอ~ลิ~เม-อร์'
ม7อร.
% Force 'จี-วร', 'อิน~ที-วร'
ี7วร
% Force 'ภาส-วร', but not 'พร~ส-วรรค์'
ส7วร.
% Force 'ชม~พู-นท'
พู7นท
% Force '-จร.', but not 'ฉกา~มา~พ-จร', 'ฉกา~มา~ว-จร', 'โย~คา~พ-จร', 'โย~คา~ว-จร'
% but not potential '*โ-จร'
5จร.
โ6จร.
% Force 'ซาก-ศพ'
7ศพ.
% Force 'ตริ~โป-ลี', 'ทริ~โป-ลี'
โป7ลี
% Force 'ตรี-ภพ', 'เอก-ภพ', etc.
7ภพ.
% Force 'ทา-นพ', 'มา-นพ', 'อา~ที-นพ'
7นพ.
% Force 'อรร-ณพ', 'มหรร-ณพ', 'มา-ณพ', 'อัณ-ณพ', etc.
7ณพ.
% Force 'กา-รก', 'ทา-รก', but not potential 'กา-ร~กระ~ทำ'
า7รก.
% Force 'กะ~ทก-รก'
ทก7รก
% Force 'สาย-รก', but not potential 'เพียร~ก-ระ~ทำ
ย7รก.
% Force 'เรี้ยว-รก', but not potential 'คว-ร~กระ~ทำ'
ยว7รก.
% Force 'นฤ-มล', 'พิ-มล' etc., but not 'ก-มล', 'ย-มล', 'เ-มล'
5มล.
% Force 'นิ~ลุ-บล', 'ยุ-บล'
ุ5บล.
% Force 'นิ~โล-บล'
โล7บล.
% Force 'นิ~สา-ชล', 'อัส~สุ-ชล', etc. but not 'เ-ชล'
5ชล.
% Force 'ปริ~พา-ชก', 'โภ-ชก', but not 'โ-ชก'
5ชก.
% Force 'บุพ-โพ', 'เท-โพ'
7โพ
% Force 'ปร~มา-ณู', 'เร-ณู', but not 'อ-ณู'
5ณู
% Force 'นา-ปี', 'ปริน~ซิ-ปี', 'รู-ปี', 'วา-ปี', 'ศิล-ปี'
7ปี.
% Force 'ปัญ~จา-บี', 'อา~บู~ดา-บี', but not 'น-บี'
า7บี.
% Force 'ปุ-ฏะ', 'วัฏ-ฏะ', 'สก-ฏะ', but not 'ว-ฏะ'
5ฏะ.
% Force 'นา-ฬี', 'เมา-ฬี'
า7ฬี
% Force 'ปุ-ปะ', 'ศิล-ปะ', 'สัม~ผัป~ลา-ปะ', 'สู-ปะ', 'อา-ปะ'
% but not 'กัจ~ฉ-ปะ', 'กัส~ส-ปะ', 'แ-ปะ'
5ปะ.
ฉ6ปะ
ส6ปะ
% Force 'ซู-ลู', 'ปู-ลู', 'ฮอน~โน~ลู-ลู'
ู7ลู
% Force 'พัน-ตู', 'วา~นู~อา-ตู', 'อู~บัน-ตู', but not 'ส-ตู'
5ตู.
% Force 'มฤต-ยู', 'มลา-ยู', 'ศรัณ-ยู', 'ไอ~ซี-ยู'
% but not 'พ-ยู่ห์', 'อ-ยู่', 'ม-ยูร', 'ห-ยูก~ยา'
5ยู.
% Force 'พยัค-ฆี', 'เม-ฆี'
7ฆี.
% Force 'อวิ-จี', 'อาร์~พี-จี'; 'กุ-จี', 'รุ-จี'; 'ซู-จี', 'รู-จี'
ิ7จี
ี7จี
ุ7จี
ู7จี
% Force 'อเว-จี', but not 'ว-จี'
เว7จี
% Force 'รา-ศี', 'ประ~ทา-ศี', 'เก-ศี', but not 'ศ-ศี', 'เ-ศียร'
5ศี.
% Force 'มืด-มน', 'วิ-มน', but not 'เ-มน'
5มน.
% Force 'ป้อ-ยอ', 'ยก-ยอ', 'หมู-ยอ', but not 'เผ-ยอ'
5ยอ.
ผ6ยอ.
% Force 'พิษ-สง', 'ลิ-สง', but not 'อ-สง~ไขย'
5สง.
% Force 'กา-สร', 'มา~ธุ-สร', 'อัป-สร', but not 'อ-สร~พิษ', 'อิ-สร~ชน'
7สร.
% Force 'ชา-ดก', 'มฤ-ดก', 'โช-ดก', 'โป-ดก'
% but not 'สัต~ส-ดก', 'โส-ดก', 'แ-ดก'
5ดก.
ส6ดก
% Force 'มอส-โก', 'ยู~เนส-โก', 'เฉ-โก', but not 'ป-โกฏิ', '*ส-โกป'
7โก.
% Force 'ฝึก-ฝน'
ก7ฝ
% Force 'ลา-มก', 'อุ~ลา-มก'
า7มก.
% Force 'มอ-ซอ', 'ลี-ซอ', but not 'เ-ซอ'
5ซอ
% Force 'วิ~สา-ขะ', 'ไพ~ศา-ขะ'; 'ลู-ขะ'
า7ขะ
ู7ขะ
% Force 'เส-ขะ', but not 'ส-ขะ'
ส5ขะ
% Force 'วรร-ษา'
ร7ษา
% Force 'วส-ภะ', 'อส-ภะ', 'โศ-ภะ'
5ภะ
% Force 'โศ-ภน', 'โศ-ภี'
ศ7ภ
% Force 'ดิ-ลก', 'ติ-ลก'
ิ7ลก
% Force 'กุ-ฎี'
ุ7ฎี
% Force 'วิ~ศา-ขา', but not potential 'ไพ-ศาข์'
ศา5ข
% Force 'วิ~เห-สา', 'เก-สา', but not 'เ-สา', 'สหั-สา'
5สา.
ั6สา
% Force 'วู-ซู', 'เย-ซู'
7ซู
% Force 'กรร-ษก', 'ศิก-ษก', 'โฆ-ษก', but not 'บรร~ย~เวก-ษก์', 'อภิ~เ-ษก'
5ษก.
% Force 'เศรษ-ฐี', 'ษัษ-ฐี'
ษ7ฐี
% Force 'โค-ดม', 'หโย-ดม', 'อุต-ดม', but not 'ส-ดมภ์', 'โส-ดม'
5ดม.
ส6ดม
% Force 'ติด-ลม', 'หลอด-ลม', 'กระ~แส-ลม', 'เพรียว-ลม', 'สี-ลม'
ด7ลม.
ส7ลม.
ว7ลม.
ี7ลม.
% Force 'กุ-ศล', 'โก-ศล', but not 'ไศ-ล'
5ศล.
% Force 'นิ-ยต', 'อนิ-ยต'
นิ7ยต
% Force 'กระ~ดูก-งู', 'หมอ-งู'
7งู
% Force 'อนี-จะ', 'เบญ-จะ', but not 'กระ~แ-จะ'
5จะ.
% Force 'อนุ~ศา-สก', 'อันตร~วา-สก', 'อุ~บา-สก', but not 'ปัณ~ณา-สก์
า7สก.
% Force 'โป-สก'
โป7สก
% Force 'ทร-ยศ', 'อป-ยศ', 'อัป-ยศ', 'เกียรติ-ยศ', but not 'พ-ยศ', 'สุ~ริ~เ-ยศ'
5ยศ.
% Force 'อว~รุท-ธก', 'โส-ธก' but not 'เ-ธก'
5ธก.
% Force 'มนุษย์-กบ', 'เป่า-กบ', but not potential 'โ-กบ'
5กบ.
% Force 'เต~ลุ-คู', 'เวท-คู'
7คู.
% Force 'พลาส-มา', 'เส-มา', but not 'ส-มา'
ส5มา.
% Force 'กุ-แล', 'ดู-แล', 'แค-แล', but not 'ส-แลง', 'ส-แล็ก'
5แล.
% Force 'ศรา-พก', 'แถม-พก', but not 'สะ-โ-พก'
5พก.
% Force 'โส-ภณ', 'โส-ภี'
โส7ภ
% Block 'กรร-ดิ' caused by 'ร1ด' pattern
% but still allow 'กรร-ดิก'
รร6ดิ.
% Force 'กา-ฬา-วก', 'ศรา-วก', but not 'ก้า-ว~ก่าย'
า7วก.
% Force 'กิน-นร', inhibited by 'น4นร' pattern (สนน-รา-คา)
น7นร.
% Force 'กุ~ลี~กุ-จอ', but not 'เ-จอ', 'อา-จ~อง', 'อเน-จ~อนาถ'
5จอ.
% Force 'ขจร-จบ', but not 'แ-จบ'
5จบ.
% Force 'ค่า-คบ', but not 'แ-คบ'
5คบ.
% Force 'ฉ้อ-ฉล', but not 'แ-ฉลบ'
5ฉล.
% Force 'ชม-รม', but not 'โค-รม'
ม7รม
% Force 'อบ-รม', but not 'บ-รม'
อบ7รม
% Force 'บริ-รม' (but not 'นิ-ร~มล'), 'อี-รม'
ิ7รม.
ี7รม.
% Force 'ซุก-ซน', but not 'โ-ซน'
5ซน.
% Force 'สี-ดอ', but not 'เ-ดอะ'
5ดอ.
% Force 'ซู~ซู-กิ' but not 'เ-กิด', 'ป-กิณ~กะ'
5กิ.
% Force 'อี~ซู-ซุ' (but not potential 'ซู-ซ'), 'ซู-ฮก' (but not potential 'ซู-ฮ์')
ซู7ซุ
ซู7ฮก
% Force 'ดา-บส', 'ดาว-บส', but not 'เ-บส', 'จ็อ-บส์'
5บส.
% Force 'ดิ้น-รน', but not 'เนร-นาด'
น7รน.
% Force 'ตก-ลง', but not 'แก-ลง'
ตก7ลง
% Force 'ลืม-ตน'
ม7ตน
% Force 'ตัว-ตน', but not 'เว-ตน์'
ตัว7ตน
% Force 'ตี-วง'
ี7วง
% Force 'พิศ-วง'
ศ7วง.
% Force 'แตร-วง', 'แวด-วง' explicitly
แตร7วง
แวด7วง
% Force 'ทมิฬ~นา-ฑู'
า7ฑู
% Force 'ทร-หด', but not 'โ-หด'
5หด.
% Force 'นอบ-นบ', but not 'บ-น~บาน'
อบ7นบ
% Force 'นา-คร' inhibited by 'นา4คร' pattern, but not 'นา-ค~ราช'
นา7คร.
% Force 'บี-ฑา', but not 'ค-ฑา'
ี7ฑา
% Force 'บู-ดู'
ู7ดู
% Force 'ปรา-รภ', but not 'สา-ร~ภาพ', 'สา-ร~ภี' (for now)
า7รภ.
% Force 'ปลา-ฝา'
า7ฝ
% Force 'พล-รบ', 'แนว-รบ', 'เรือ-รบ'
ล7รบ.
ว7รบ.
อ7รบ.
% Force 'พา-รณ'
า7รณ.
% Force 'ยืน-ยง', 'โฉม-ยง', 'ยุ-ยง', 'สุ~ริ-ยง'
น7ยง
ม7ยง
ุ7ยง
ิ7ยง
% Force 'สุ~ริ-ยน'
ิ7ยน
% Force 'มหา-พน'
หา7พน
% Force 'มิ~ยา-งิ'
า7งิ
% Force 'ราช-รถ', 'มโน-รถ', 'หงส-รถ'
ช7รถ.
น7รถ.
ส7รถ.
% Force 'ยุ~คัน-ธร' inhibited by 'ัน4ธ' pattern, but not 'สุ~คัน-ธ~รส'
ัน7ธร.
% Force 'มณ-ฑก' (but not 'มณ-ฑ์'), 'มณ-โฑ' explicitly
มณ7ฑก
มณ7โฑ
% Force 'มร-กต', 'มร-ฑป' explicitly
มร7กต
มร7ฑป
% Force 'ยอด-อก', 'โล่ง-อก' explicitly (ambiguous)
ยอด7อก
โล่ง7อก
% Force 'ยืด-อก' explicitly
ยืด7อก
% Force 'ระ~เห-หน
ห7ห
% Force 'รัน-ทด', but not 'แค~โ-ทด'
5ทด.
% Force 'ราว-นม', 'เทพ-นม', 'โค-นม'
ว7นม.
ทพ7นม.
โค7นม
% Force 'ราษ-ฎร', but not 'รา-ษฎร์'
ษ7ฎร.
% Force 'ริ-ปุ', 'ริ-ปู'
ิ7ปุ
ิ7ปู
% Force 'รี-รอ'
ี7รอ.
% Force 'ลอย-ลำ', 'หมอ-ลำ', 'แก้-ลำ'
ย7ลำ
อ7ลำ
้7ลำ
% Force 'ลั่น-ทม', 'อุป-ทม'
น7ทม.
ป7ทม.
% Force 'วก-วน', 'อล-วน' explicitly
วก7วน
อล7วน
% Force 'วิ-จล'
ิ7จล.
% Force 'วิช-ญะ'
ช7ญะ
% Force 'ศี-ขร'
ี7ข
% Force 'ศีล-อด'
ศีล7
% Force 'สดก~ก๊อก-ธม', but not potential 'แ-ธม'
5ธม.
% Force 'สม-รด', 'สัก-วา' explicitly
สม7รด
สัก7วา
% Force 'สัป-ดน', 'สัป-ทน'
สัป7ด
สัป7ท
% Force 'สา-สม', 'เจือ-สม'
า7สม.
อ7สม.
% Force 'สิ~ขา-นล'
า7นล.
% Force 'ภี-รุ', 'อู-รุ', 'สิ~เน-รุ'
ี7รุ
ู7รุ
เน7รุ
% Force 'สิง-หล'
ง7หล
% Force 'สีห-นุ' explicitly
สีห7นุ
% Force 'สุ-ภร', but not 'เ-ภ~รี', 'อุ~สุ-ภ~ราช'
5ภร.
% Force 'หมด-จด', but not potential 'โ-จด'
5จด.
% Force 'หยิบ-ยก'
บ7ยก.
% Force 'อดิ-ศร', 'ไกร-ศร'
ดิ7ศร
ร7ศร
% Force 'อพ-ยพ' explicitly
อพ7ยพ
% Force 'อร-ชร'
ร7ชร.
% Force 'เน~แบรส-กา', 'อะ~แลส-กา'
รส7กา
ลส7กา
% Force 'อาจ-อง' explicitly (ambiguous)
อาจ7อง
% Force 'อี-มู'
ี7มู
% Force 'อึง-อล' explicitly (ambiguous)
อึง7อล
% Force 'อุ-ชุ'
ุ7ชุ
% Force 'อุ-สภ'
ุ7สภ.
% Force 'เก-ชา', 'เก-ศา' explicitly
เก7ชา
เก7ศา
% Force 'โช-ตก', 'เก็บ-ตก'
ช7ตก.
บ7ตก.
% Force 'เข-ฬะ' explicitly
เข7ฬะ
% Force 'เคราห-ณี'
ห7ณี
% Force 'เจือ-ปน'
อ7ปน.
% Force 'เชย-ชม'
ย7ชม.
% Force 'เบื้อง-บน'
เบื้อง7
% Force 'ตุร-คะ', 'เพ-คะ', 'โภ-คะ', but not 'ภ-คะ'
5คะ
% Force 'เพียง-ออ', 'เออ-ออ'
ง7ออ.
อ7ออ.
% Force 'เรือ-ธง', 'เรือ-บด'
เรือ7ธ
เรือ7บ
% Force 'เลี้ยว-ลด'
เลี้ยว7
% Force 'เสื่อ-กก', but not 'เ-กก'
5กก.
เ6กก
% Force 'เหลือ-ขอ', 'เหล่า-กอ'
อ7ขอ.
า7กอ.
% Force 'แด-วู' explicitly
แด7วู
% Force 'แยบ-ยล'
บ7ยล.
% Force 'โฉ-เก' explicitly
โฉ7เก
% Force 'โด-มร', 'โต-มร' explicitly
โด7มร
โต7มร
% Force 'โต้-โผ'
7โผ
% Force 'โท-โส' explicitly
โท7โส
% Force 'โป้-ปด'
้7ปด.
% Force 'โภ-คี'
7คี.
% Force 'โย-นก', but not โย-น~กลอง
โย7นก.
% Force 'โส-มม' explicitly
โส7มม
% Force 'โส-ฬส', but not 'กา-ฬ~สินธุ์
7ฬส.
% Force 'โสต-ถิ'
ต7ถิ
% Force 'โอ้-โฮ'
7โฮ
% Force 'ใจ-คอ'
ใจ7
% Force 'ไค-ฟง', but not 'แ-ฟง'
5ฟง
% Force 'ไช-โย' explicitly
ไช7โย
% Force 'ไอ~รา-พต', but not potential 'แ-พต'
5พต.
% Force 'กรร-กศ' explicitly
กรร7กศ
% Force 'กัล-บก'
ล7บก.
% Force 'กัศ-ยป'
ศ7ยป.
% Force 'กา-นน', but not 'โล~ซา-นน์'
า7นน.
% Force 'กุ-ฎา', 'กู-ฏา'
ุ7ฎา
ู7ฏา
% Force 'กุ~โน~กา-มอ'
า7มอ.
% Force 'ขิ~ป~สัท-โท'
ท7โท
% Force 'จุ-ทส'
ุ7ทส
% Force 'จ่า-รง'
จ่า7ร
% Force 'ทัฬ-หี'
ฬ7หี
% Force 'ทา-ฒะ', but not potential 'เ-ฒะ'
า7ฒะ
% Force 'ธต-รฐ' explicitly
ธต7รฐ
% Force 'บุท-คล'
ท7คล.
% Force 'ปัต-ถร'
ต7ถร.
% Force 'ปิ-ฐิ'
ิ7ฐิ
% Force 'ปุป-ผะ'
ป7ผะ
% Force 'พฤ-ษภ' explicitly, but not 'พฤ-ษ~ภา~คม'
พฤ7ษภ.
% Force 'พิ-ธุ'
ิ7ธุ
% Force 'มา-ฬก'
า7ฬก.
% Force 'มเห-สิ'
ห7สิ
% Force 'วัฏ-ฏิ', 'ยัษ-ฏิ'
ฏ7ฏิ.
ษ7ฏิ.
% Force 'ศิษ-ฎิ' explicitly (not to affect 'สฤ-ษฎิ')
ศิษ7ฎิ
% Force 'อิษ-ฏี'
ษ7ฏี
% Force 'ราก-ษส', but not 'กระ~ดา-ษ~สา', 'เศ-ษ~ส่วน', and potential 'เ-ษส'
5ษส.
% Force 'ลิ-ปิ'
ิ7ปิ
% Force 'สู-ริ', but not 'เพ~ฑู-ริย์'
ู7ริ.
% Force 'เลฑ-ฑุ'
ฑ7ฑุ
% Force 'เลษ-ฏุ'
ษ7ฏุ
% Force 'ชา-ตา' inhibited by 'ชา2ต' pattern
า7ตา
% Force 'ดาว-ตก', 'ปลง-ตก' inhibited by '2ตก' pattern
ว7ตก
ง7ตก
% Block 'เก-ตุ' caused by 'ก1ต' pattern, but allows potential 'เก-ตุม~วดี'
เก6ตุ.
% Force 'เส-ตุ', 'มัส-ตุ'
ส7ตุ
% Force 'ลิ-บง' inhibited by 'ลิ4บ' pattern
ลิ7บง
% Force 'เฮ-โล'
ฮ7โ
% Force 'เอก-อุ', but not 'ช-อุ่ม'
7อุ.
% Force 'อิศ-รา'
ิศ7รา
}

