package Bot::BasicBot::Pluggable::Module::VieDeMerde;

use warnings;
use strict;

use WWW::VieDeMerde;

use base qw(Bot::BasicBot::Pluggable::Module);

our $VERSION = '0.01';

sub said {
    my ($self, $mess, $pri) = @_;

    my $body = $mess->{body}; 
    my $who  = $mess->{who};

    return unless $body =~ /^\@vdm\s*(.*)/;
    my $vdm = WWW::VieDeMerde->new();
    my $cmd = $1;

    my $msg = $vdm->random();

    my $response = $msg->texte;
    $response .= " #" . $msg->id;
    $response .= " (+" . $msg->je_valide . ",-" . $msg->bien_merite . ")";
    return $response;
}

sub help {'@vdm'}

1;

__END__

=head1 NAME

Bot::BasicBot::Pluggable::Module::VieDeMerde - VieDeMerde plugin for BasicBot::Pluggable

=head1 VERSION

Version 0.01

=head1 SYNOPSIS

On a channel with the bot, type @vdm to get a random VDM.

=head1 DESCRIPTION

IRC frontend for the WWW::VieDeMerde module.

=head1 IRC USAGE

@vdm or @vdm cmd

Currently there are no commands implemented.

=head1 METHODS (it's not interesting)

=head2 said

Read the commands and return the answers.

=head2 help

Display the help

=head1 AUTHOR

Olivier Schwander, C<< <iderrick at cpan.org> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-bot-basicbot-pluggable-module-watchlinks at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Bot-BasicBot-Pluggable-Module-VieDeMerde>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Bot::BasicBot::Pluggable::Module::VieDeMerde


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Bot-BasicBot-Pluggable-Module-VieDeMerde>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Bot-BasicBot-Pluggable-Module-VieDeMerde>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Bot-BasicBot-Pluggable-Module-VieDeMerde>

=item * Search CPAN

L<http://search.cpan.org/dist/Bot-BasicBot-Pluggable-Module-VieDeMerde>

=back


=head1 ACKNOWLEDGEMENTS


=head1 COPYRIGHT & LICENSE

Copyright 2009 Olivier Schwander, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

