package Mojo::Cloudstack::Base;
use Mojo::Base -base;

sub new {
  my $class    = shift;
  my $cs_class = shift;

  my $self = bless shift, $cs_class;

  no strict 'refs';
  *{ "${cs_class}::import" } = *{ "Mojo::Base::import" };
  *{ "${cs_class}::attr" }   = *{ "Mojo::Base::attr" };
  use strict 'refs';

  $self->import('-base');

  foreach my $key (keys %$self) {

    $self->attr(
      $key => sub {
        my ($self, $value) = @_;
        return $value ? (($self->{ $key } = $value) and $self) : $self->{ $key };
      }
    );
    if ($key eq 'jobresult') {
      my $otype = (keys %{ $self->{ jobresult } })[0];
      $self->$key(Mojo::Cloudstack::Base->new('Mojo::Cloudstack::' . ucfirst ($otype), $self->{ $key }{ $otype }));
    }
  }
  return $self;
}

1;

__END__

=pod

=head1 NAME

Mojo::Cloudstack::Base

=head1 DESCRIPTION

This is the base class for all autogenerated Cloudstack API call response classes

=head1 SYNOPSIS

  use Mojo::Cloudstack::Base;

=head1 METHODS

=head2 new

  my $class = Mojo::Cloudstack::Base->new('Mojo::Cloudstack::Virualmachine', $memberhash);

=cut
