use Mathx::Stat;
use LossFunction;
 
class Strategy is DistributionPopulation {

	has @.strategypopulation;

	method BUILD(@lossfuncs) {
		.population = @lossfuncs; ### LossFunction instances
		.strategypopulation = new Population();
	}

	method addStrategy($s) {
		.stratgeypopulation.add($s);
	}
	
	method minimax(@condps) {

		my $sup = 0.0.	

		for .population -> $f {
			my $loss = $f.BayesianLoss(@condps);
			if ($loss > $sup) {
				$sup = $loss;
			}		
		}

		return $sup;
	}

	method randomstrategyminimax(@condps) {
		my $sup = 0.0.	

		loop (my $i = 0; $i < 0..^.strategypopulation.population.length.rand)
		 {
			my $loss = self.minimax(@condps);
			if ($loss > $sup) {
				$sup = $loss;
			}		
		}
		
		return $sup;
	}

}
