use SDL;

class Game::QFG::Message {

	has $.originator is rw;  ### sending instance of this message
	has $.acceptor is rw;    ### receiver instance of this message
	has $.friend-or-foe is rw; ### karma of message
	has $.msg-body is rw; ### body (text) of message

	method BUILD(:$originator, :$acceptor, :$friend-or-foe, :$msg-body) {

		$!originator = $originator; 
		$!acceptor = $acceptor; 
		$!friend-or-foe = $friend-or-foe;
		$!msg-body = $msg-body;

	}

	multi method split-message {

		return (self.originator, self.acceptor, self.friend-or-foe, self.msg-body);

	}

	multi method split-message($msg) {

		return ($msg.originator, $msg.acceptor, $msg.friend-or-foe, $msg.msg-body);

	}

}
