package Tk::TabbedForm::CFolderItem;

=head1 NAME

Tk::TabbedForm::CFolderItem - Folder select entry widget for Tk::TabbedForm.

=cut

use strict;
use warnings;
use Tk;
use base qw(Tk::Derived Tk::TabbedForm::CFileItem);
Construct Tk::Widget 'CFolderItem';

=head1 SYNOPSIS

 require Tk::TabbedForm::CFolderItem;
 my $bool = $window->CFolderItem(@options)->pack;

=head1 DESCRIPTION

Inherits L<Tk::TabbedForm::CFileItem>. Provides a folder entry with dialog for L<Tk::TabbedForm>.

You should never create an instance directly like above. This should
be handled by L<Tk::TabbedForm>.

=cut

sub createHandler {
	my ($self, $var) = @_;
	$self->SUPER::createHandler($var);
	$self->Subwidget('Select')->configure(
		-command => sub {
			my $file = $self->chooseDirectory(
# 				-initialdir => $initdir,
				-popover => $self->toplevel,
			);
			if (defined $file) {
				my $var = $self->cget('-variable');
				$$var = $file
			}
		}
	);
}

=head1 LICENSE

Same as Perl.

=head1 AUTHOR

Hans Jeuken (hanje at cpan dot org)

=head1 BUGS

Unknown. If you find any, please contact the author.

=head1 SEE ALSO

=over 4

=item L<Tk::TabbedForm>

=item L<Tk::TabbedForm::CBaseClass>

=item L<Tk::TabbedForm::CFileItem>

=item L<Tk::TabbedForm::CTextItem>


=back

=cut




1;

__END__
