@rem = '--*-Perl-*--
@echo off
perl -x -S %0.bat %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
@rem ';
#!/usr/local/bin/perl -w
#line 8

# This script demonstrates the various widgets provided by Tk, along with
# many of the features of the Tk toolkit.  This file only contains code to
# generate the main window for the application, which invokes individual
# demonstrations.  The code for the actual demonstrations is contained in
# separate ".pl" files in the "widget_lib" directory, which are autoloaded 
# by this script as needed.
#
# widget looks in the directory specified on the command line to load user
# contributed demonstrations.  If no directory name is specified when widget is
# invoked and the environment variable WIDTRIB is defined then demonstrations
# are loaded from the WIDTRIB directory. If WIDTRIB is undefined then widget
# defaults to the released user contributed directory.
#
# Stephen O. Lidie, LUCC, 96/03/11.  lusol@Lehigh.EDU
# Stephen O. Lidie, LUCC, 97/01/01.  lusol@Lehigh.EDU
# Stephen O. Lidie, LUCC, 97/02/11.  lusol@Lehigh.EDU

require 5.002;

use English;
use Tk;
use Tk::widgets qw(Dialog ErrorDialog Menubutton Text Scrollbar);
use lib Tk->findINC('demos/widget_lib');
use WidgetDemo;
use strict;

# Global subroutine and variable declarations required by my() and use strict.

use subs qw(dpos inswt invoke lsearch see_code see_vars view_widget_code);

my($T, $CODE, $CODE_TEXT, $SEE_DEMO, $VARS, $VIEW, $VIEW_TEXT);
my($BRAKES, $LIGHTS, $OIL, $SOBER, $TRANS, $WIPERS);
my($COLOR, $FONT_STYLE, $POINT_SIZE);

my $MW = MainWindow->new;
$MW->title('Widget Demonstration');
my $FONT = '-*-Helvetica-Medium-R-Normal--*-140-*-*-*-*-*-*';
my $WIDGET_LIB = Tk->findINC('demos/widget_lib');
my $WIDTRIB = Tk->findINC('demos/widtrib');
$WIDTRIB = $ENV{WIDTRIB} if defined $ENV{WIDTRIB}; 
$WIDTRIB = $ARGV[0] if defined $ARGV[0]; 

# The code below creates the main window, consisting of a menu bar
# and a text widget that explains how to use the program, plus lists
# all of the demos as hypertext items.

my $menuBar = $MW->Frame;
$menuBar->pack(-side => 'top', -fill => 'x');
my $menuBar_file = $menuBar->Menubutton(
    -text      => 'File',
    -underline => 0,
);
$menuBar_file->command(
    -label     => 'View',
    -underline => 0,
    -command   => [\&view_widget_code, __FILE__],
);
$menuBar_file->separator;
$menuBar_file->command(
    -label     => 'Quit',
    -underline => 0,
    -command   => \&exit,
);
$menuBar_file->pack(-side => 'left');

my $s = $MW->Scrollbar(-orient => 'vertical');
$s->pack(-side => 'right', -fill => 'y');
$T = $MW->Text(
    -yscrollcommand =>  [$s => 'set'],
    -wrap           => 'word',
    -width          => 60,
    -height         => 30, 
    -font           => $FONT,
    -setgrid        => 1,
);
$s->configure(-command => [$T => 'yview']);
$T->pack(-expand => 1, -fill => 'both');
$T->bindtags(qw(widget_demo));	# remove all bindings but dummy "widget_demo"

# Create a bunch of tags to use in the text widget, such as those for
# section titles and demo descriptions.  Also define the bindings for
# tags.

$T->tag('configure', 'title',
    -font => '-*-Helvetica-Bold-R-Normal--*-180-*-*-*-*-*-*',
);

$T->tag('configure', 'demo',
    -lmargin1 => '1c',
    -lmargin2 => '1c',
    -foreground => 'blue',
);
if ($MW->depth  == 1) {
    $T->tag('configure', 'hot',
        -background => 'black',
	-foreground => 'white',
    );
    $T->tag('configure', 'visited',
	-lmargin1  => '1c',
	-lmargin2  => '1c',
	-underline => 1,
    );
} else {
    $T->tag('configure', 'hot',
	-relief      => 'raised',
	-borderwidth => 1,
	-foreground  => 'red',
    );
    $T->tag('configure', 'visited',
	-lmargin1   => '1c',
	-lmargin2   => '1c',
	-foreground => '#303080',
    );
}
$T->tag('bind', 'demo',
    '<Button-1>' => sub {
	invoke $T->index('current');
    }
);
my $lastLine = '';
$T->tag('bind', 'demo',
    '<Enter>' => sub {
	my $e = $T->XEvent;
	my($x, $y) = ($e->x, $e->y);
	$lastLine = $T->index("\@$x,$y linestart");
	$T->tag('add', 'hot', $lastLine, "$lastLine lineend");
    }
);
$T->tag('bind', 'demo',
    '<Leave>' => sub {
	$T->tag('remove', 'hot', '1.0', 'end');
    }
);
$T->tag('bind', 'demo',
    '<Motion>' => sub {
	my $e = $T->XEvent;
	my($x, $y) = ($e->x, $e->y);
	my $newLine = $T->index("\@$x,$y linestart");
	if ($newLine ne $lastLine) {
	    $T->tag('remove', 'hot', '1.0', 'end');
	    $lastLine = $newLine;
	    $T->tag('add', 'hot', $lastLine, "$lastLine lineend");
	}
    }
);

# Create the text for the text widget.

$T->insert('end', "Tk Widget Demonstrations\n", 'title');
$T->insert('end', 
"\nThis application provides a front end for several short scripts that demonstrate what you can do with Tk widgets.  Each of the numbered lines below describes a demonstration;  you can click on it to invoke the demonstration.  Once the demonstration window appears, you can click the \"See Code\" button to see the Perl/Tk code that created the demonstration.  If you wish, you can edit the code and click the \"Rerun Demo\" button in the code window to reinvoke the demonstration with the modified code.\n");

# Define globals for demo toplevels, informative text with tags for
# highlighting and specifying the demo's file name.

my($LABEL, $BUTTON, $CHECK, $RADIO, $PUZZLE, $ICON, $IMAGE1, $IMAGE2);
$T->insert('end', "\n", '', 
	   "Labels, buttons, checkbuttons, and radiobuttons\n", 'title');
$T->insert('end', "1. Labels (text and images).\n", [qw(demo demo-labels)]);
$T->insert('end', "2. Buttons.\n", [qw(demo demo-button)]);
$T->insert('end', "3. Checkbuttons (select any of a group).\n",
    [qw(demo demo-check)]);
$T->insert('end', "4. Radiobuttons (select one of a group).\n",
    [qw(demo demo-radio)]);
$T->insert('end', "5. A 15-puzzle game made out of buttons.\n",
    [qw(demo demo-puzzle)]);
$T->insert('end', "6. Iconic buttons that use bitmaps.\n",
    [qw(demo demo-icon)]);
$T->insert('end', "7. Two labels displaying images.\n",
    [qw(demo demo-image1)]);
$T->insert('end', "8. A simple user interface for viewing images.\n",
    [qw(demo demo-image2)]);

my($STATES, $COLORS, $SAYINGS);
$T->insert('end', "\n", '', "Listboxes\n", 'title');
$T->insert('end', "1. 50 states.\n", [qw(demo demo-states)]);
$T->insert('end', "2. Colors: change the color scheme for the application.\n",
    [qw(demo demo-colors)]);
$T->insert('end', "3. A collection of famous sayings.\n",
    [qw(demo demo-sayings)]);

my($ENTRY1, $ENTRY2, $FORM);
$T->insert('end', "\n", '', "Entries\n", 'title');
$T->insert('end', "1. Without scrollbars.\n", [qw(demo demo-entry1)]);
$T->insert('end', "2. With scrollbars.\n", [qw(demo demo-entry2)]);
$T->insert('end', "3. Simple Rolodex-like form.\n", [qw(demo demo-form)]);

my($TEXTS, $STYLE, $BIND, $TWIND, $SEARCH);
$T->insert('end', "\n", '', "Text\n", 'title');
$T->insert('end', "1. Basic editable text.\n", [qw(demo demo-texts)]);
$T->insert('end', "2. Text display styles.\n", [qw(demo demo-style)]);
$T->insert('end', "3. Hypertext (tag bindings).\n", [qw(demo demo-bind)]);
$T->insert('end', "4. A text widget with embedded windows.\n",
    [qw(demo demo-twind)]);
$T->insert('end', "5. A search tool built with a text widget.\n",
    [qw(demo demo-search)]);

my($ITEMS, $PLOT, $CTEXT, $ARROWS, $RULER, $FLOOR, $CSCROLL);
$T->insert('end', "\n", '', "Canvases\n", 'title');
$T->insert('end', "1. The canvas item types.\n", [qw(demo demo-items)]);
$T->insert('end', "2. A simple 2-D plot.\n", [qw(demo demo-plot)]);
$T->insert('end', "3. Text items in canvases.\n", [qw(demo demo-ctext)]);
$T->insert('end', "4. An editor for arrowheads on canvas lines.\n",
    [qw(demo demo-arrows)]);
$T->insert('end', "5. A ruler with adjustable tab stops.\n",
    [qw(demo demo-ruler)]);
$T->insert('end', "6. A building floor plan.\n", [qw(demo demo-floor)]);
$T->insert('end', "7. A simple scrollable canvas.\n", [qw(demo demo-cscroll)]);

my($VSCALE, $HSCALE);
$T->insert('end', "\n", '', "Scales\n", 'title');
$T->insert('end', "1. Vertical scale.\n", [qw(demo demo-vscale)]);
$T->insert('end', "2. Horizontal scale.\n", [qw(demo demo-hscale)]);

my($MENUS);
$T->insert('end', "\n", '', "Menus\n", 'title');
$T->insert('end', "1. A window containing several menus and cascades.\n",
    [qw(demo demo-menus)]);

my($BOUNCE);
$T->insert('end', "\n", '', "Simulations\n", 'title');
$T->insert('end', "1. Balls bouncing in a cavity.\n", [qw(demo demo-bounce)]);

my($BITMAPS, $DIALOG1, $DIALOG2);
$T->insert('end', "\n", '', "Miscellaneous\n", 'title');
$T->insert('end', "1. The built-in bitmaps.\n", [qw(demo demo-bitmaps)]);
$T->insert('end', "2. A dialog box with a local grab.\n",
    [qw(demo demo-dialog1)]);
$T->insert('end', "3. A dialog box with a global grab.\n",
    [qw(demo demo-dialog2)]);

$T->insert('end', "\n", '', "User Contributed Demonstrations\n", 'title');
opendir C, $WIDTRIB;
my(@dirent) = grep /^.+\.pl$/, sort(readdir C);
closedir C;
my $i;
while ($ARG = shift @dirent) {
    open(C, "$WIDTRIB/$ARG") or warn "Cannot open $ARG: $!";
    my($name) = /^(.*)\.pl$/;
    $ARG = <C>;
    my($title) = /^#\s*(.*)$/;
    close C;
    $T->insert('end', ++$i . ". $title\n", ['demo', "demo-$name"]);
}
$T->configure(-state => 'disabled');

# Create all the dialogs required by this demonstration.

my $DIALOG_ICON = $MW->Dialog(
    -title          => 'Bitmap Menu Entry',
    -bitmap         => undef,
    -default_button => 'OK',
    -buttons        => ['OK'],
    -text           => 'The menu entry you invoked displays a bitmap rather than a text string.  Other than this, it is just like any other menu entry.',
);
$DIALOG_ICON->configure(-bitmap => undef); # keep -w from complaining

MainLoop;

sub AUTOLOAD {

    # This routine handles the loading of most demo methods.

    my($demo) = @ARG;

    $T->Busy;
    {
	local $INPUT_RECORD_SEPARATOR = undef;
	my $file;
	$file = "$WIDTRIB/${demo}.pl" if -f "$WIDTRIB/${demo}.pl";
	$file = "$WIDGET_LIB/${demo}.pl" if -f "$WIDGET_LIB/${demo}.pl";
	open(DEMO, $file) or warn "cannot open demo file $file!";
	eval <DEMO>;
	warn $EVAL_ERROR if $EVAL_ERROR;
	close DEMO;
    }
    $T->Unbusy;
    goto &$::AUTOLOAD;

} # end AUTOLOAD

sub dpos {

    # Position a window at a reasonable place on the display.

    shift->geometry('+300+300');

} # end dpos

sub inswt {

    # insert_with_tags
    #
    # The procedure below inserts text into a given text widget and applies
    # one or more tags to that text.  The arguments are:
    #
    # w		Window in which to insert
    # text	Text to insert (it's inserted at the "insert" mark)
    # args	One or more tags to apply to text.  If this is empty then all
    #           tags are removed from the text.

    my($w, $text, @args) = @ARG;
    my($tag, $i, $start);

    $start = $w->index('insert');
    $w->insert('insert', $text);
    foreach $tag ($w->tag('names', $start)) {
	$w->tag('remove', $tag, $start, 'insert');
    }
    foreach $i (@args) {
	$w->tag('add', $i, $start, 'insert');
    }

} # end inswt

sub invoke {

    # This procedure is called when the user clicks on a demo description.

    my($index) = @ARG;

    my @tags = $T->tag('names', $index);
    my $i = lsearch('demo\-.*', @tags);
    return if $i < 0;
    my($demo) = $tags[$i] =~ /demo-(.*)/;
    $T->tag('add', 'visited', "$index linestart",
                              "$index lineend -1 chars");
    {no strict 'refs'; &$demo($demo);}

} # end invoke

sub lsearch {

    # Search the list using the supplied regular expression and return it's
    # ordinal, or -1 if not found.

    my($regexp, @list) = @ARG;
    my($i);

    for ($i=0; $i<=$#list; $i++) {
        return $i if $list[$i] =~ /$regexp/;
    }
    return -1;

} # end lsearch

sub see_code {

    # This procedure creates a toplevel window that displays the code for
    # a demonstration and allows it to be edited and reinvoked.

    my($demo) = @ARG;

    my $file = "${demo}.pl";
    $SEE_DEMO = $demo;
    if (not Exists $CODE) {
	$CODE = $MW->Toplevel;
	my $code_buttons=$CODE->Frame;
	$code_buttons->pack(-side => 'bottom', -fill => 'x');
	my $code_buttons_dismiss = $code_buttons->Button(
            -text    => 'Dismiss',
            -command => [$CODE => 'withdraw'],
	);
	my $code_buttons_rerun = $code_buttons->Button(
            -text => 'Rerun Demo',
            -command => [sub {
		    eval $CODE_TEXT->get('1.0', 'end');
		    {no strict qw(refs); &$SEE_DEMO($SEE_DEMO);}
		}],
        );
	$code_buttons_dismiss->pack(-side => 'left', -expand => 1);
	$code_buttons_rerun->pack(-side => 'left', -expand => 1);
	$CODE_TEXT = $CODE->Text(-height => 40, -setgrid => 1);
	$CODE_TEXT->pack(-side => 'left', -expand => 1, -fill => 'both');
	my $code_scroll = $CODE->Scrollbar(
            -command => [$CODE_TEXT => 'yview'],
        );
	$code_scroll->pack(-side => 'right', -fill => 'y');
	$CODE_TEXT->configure(-yscrollcommand =>  [$code_scroll => 'set']);
    } else {
	$CODE->deiconify;
	$CODE->raise;
    }
    $CODE->iconname($file);
    $file = "$WIDTRIB/${demo}.pl" if -f "$WIDTRIB/${demo}.pl";
    $file = "$WIDGET_LIB/${demo}.pl" if -f "$WIDGET_LIB/${demo}.pl";
    $CODE->title("Demo code: $file");
    $CODE_TEXT->delete('1.0', 'end');
    open(CODE, "<$file") or warn "cannot open widget demo file $file!";
    {
	local $INPUT_RECORD_SEPARATOR = undef;
	$CODE_TEXT->insert('1.0', <CODE>);
    }
    close CODE;
    $CODE_TEXT->mark('set', 'insert', '1.0');

} # end see_code

sub see_vars {

    # Create a top-level window that displays a bunch of global variable values
    # and keeps the display up-to-date even when the variables change value.
    # $args is a pointer to a list of list of 2: 
    #
    #   ["variable description", \$VAR]
    #
    # The old trick of passing a string to serve as the description and a soft
    # reference to the variable no longer works with lexicals and use strict.

    my($parent, $args) = @ARG;

    $VARS->destroy if Exists($VARS);
    $VARS = $parent->Toplevel;
    my $w = $VARS;
    dpos($w);
    $w->title('Variable Values');
    $w->iconname('Variables');

    my $w_title = $w->Label(
        -text   => 'Variable Values:',
        -width  => 20,
        -anchor => 'center',
        -font   => '-*-helvetica-medium-r-normal--*-180-*-*-*-*-*-*',
    );
    $w_title->pack(-side => 'top', -fill => 'x');
    my($i, $label, $var);
    foreach $i (@$args) {
	($label, $var) = @$i;
	my $wf = $w->Frame->pack(-anchor => 'w');
	$wf->Label(-text => "$label: ")->pack(-side => 'left');
	$wf->Label(-textvariable => $var)->pack(-side => 'left');
    }
    $w->Button(-text => 'OK', -command => [$w => 'destroy'])->
        pack(-side => 'bottom', -pady => 2);

} # end see_vars

sub view_widget_code {

    # Expose a file's innards to the world too, but only for viewing.

    my($widget) = @ARG;

    if (not Exists $VIEW) {
	$VIEW = $MW->Toplevel;
	$VIEW->iconname('Demo');
	my $view_buttons=$VIEW->Frame;
	$view_buttons->pack(-side => 'bottom',  -expand => 1, -fill => 'x');
	my $view_buttons_dismiss = $view_buttons->Button(
            -text    => 'Dismiss',
            -command => [$VIEW => 'withdraw'],
	);
	$view_buttons_dismiss->pack(-side => 'left', -expand => 1);
	$VIEW_TEXT = $VIEW->Text(-height => 40, -setgrid => 1);
	$VIEW_TEXT->pack(-side => 'left', -expand => 1, -fill => 'both');
	my $view_scroll = $VIEW->Scrollbar(
            -command => [$VIEW_TEXT => 'yview'],
        );
	$view_scroll->pack(-side => 'right', -fill => 'y');
	$VIEW_TEXT->configure(-yscrollcommand =>  [$view_scroll => 'set']);
    } else {
	$VIEW->deiconify;
	$VIEW->raise;
    }
    $VIEW->title("Demo code: $widget");
    $VIEW_TEXT->configure(-state => 'normal');
    $VIEW_TEXT->delete('1.0', 'end');
    open(VIEW, "<$widget") or warn "cannot open widget demo file $widget!";
    {
	local $INPUT_RECORD_SEPARATOR = undef;
	$VIEW_TEXT->insert('1.0', <VIEW>);
    }
    close VIEW;
    $VIEW_TEXT->mark('set', 'insert', '1.0');
    $VIEW_TEXT->configure(-state => 'disabled');

} # end view_widget_code
__END__
:endofperl
