@rem = '--*-Perl-*--
@echo off
perl\bin\perl -x -S %0.bat %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
@rem ';
#!.\perl\bin\perl -w
#line 8
#
# Install Perl binary distribution.
# Takes care of munging a Config.pm template.
#

use Cwd;
use File::Path;

my %OPT = ();
my $PWD = cwd;
$PWD =~ s|/|\\|g;
my $FROM = "$PWD\\perl";
my $TO = shift;
die "usage: $0 g:\\your\\top\\level\\install\\dir\n"
	if not $TO or $TO =~ /^-/;

die "Please run this from the top level directory of Perl binary distribution\n"
	unless -e $FROM;

$OPT{INST_DRV} = ($TO =~ /^([A-Z]:)/i or $FROM =~ /^([A-Z]:)/i ? $1 : "c:");
$TO = "$PWD\\$TO" unless $TO =~ /^([\/\\]|[A-Z]:)/; 
$OPT{INST_TOP} = $TO;

print <<EOT;

Welcome to the Perl Binary Distribution for the Intel Win32
platform!

To install this package, you will need 16MB of free space on
the destination volume.

EOT

print "Proceed? [y] ";
die "Bailing out\n" if scalar(<STDIN>) !~ /^\s*(y|$)/i;

unless (-d $TO) {
    print "Ok to create `$TO'? [y] ";
    chomp (my $resp = <STDIN>);
    die "Can't proceed without destination directory `$TO', quitting\n"
		unless $resp =~ /^\s*(y|$)/i;
    mkpath($TO, 1, 0777);
    mkpath($TO."\\lib", 1, 0777);
    die "Failed to create `$TO': $!\n" unless -d $TO;
}

print "Copying distribution from `$FROM' to `$TO'\n\n";
system "xcopy /f /r /i /e /d $FROM $TO";

my $CFGPM = "$TO\\lib\\Config.pm";
print "Generating new `$CFGPM'\n";

my $TEMPLATE = shift || "$PWD\\Configpm.tpl";

open(T, "<$TEMPLATE") or die "Can't open $TEMPLATE: $!";
open(C, ">$CFGPM") or die "Can't open $CFGPM: $!";
while (<T>) {
    s/~(\w+)~/$OPT{$1}/g;
    print C $_;
}
close T; close C;

print <<EOT;

Perl has been successfully installed at `$TO'.

To start using this Perl please add `$TO\\bin'
to your `Path' environment variable.  You can do this in the `Environment'
tab of the `System' Control Panel (accessible by mousing "Start" ->
"Settings" -> "Control Panel").

You can also set the `PERL5LIB' environment variable to a `;' separated
list of paths if you install modules in locations other than
`$TO'.

Setting PERL5LIB should not be required if you want to simply use the
stuff that got installed just now.

Have a nice day.

EOT

__END__
:endofperl
