package Foo::Testmysqlorm::Team::ResultClassX;

use Modern::Perl;
use Moose;
use namespace::autoclean;
use Method::Signatures;
use Data::Printer alias => 'pdump';

extends 'Foo::Testmysqlorm::Team::ResultClass';

has league_name => (
## type:    varchar(20)
## key:     MUL
## autoinc: no
## null:    no
## default:
    is      => 'rw',
    isa     => 'Str|HashRef',
    trigger => sub {
        my $self = shift;
        $self->_touched->{league_name}++;
    },
);

has sport_id => (
## type:    int(11)
## key:     MUL
## autoinc: no
## null:    no
## default:
    is      => 'rw',
    isa     => 'Num|HashRef',
    trigger => sub {
        my $self = shift;
        $self->_touched->{sport_id}++;
    },
);

1;
