package WWW::Search::Scraper::Response::Job;


=head1 NAME

WWW::Search::Scraper::Response::Job - result class for scrapes of Job Listings


=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 AUTHOR

C<WWW::Search::Scraper::Response::Job> is written and maintained
by Glenn Wood, http://search.cpan.org/search?mode=author&query=GLENNWOOD.

=cut

use strict;
use vars qw($VERSION @ISA);
@ISA = qw(WWW::Search::Scraper::Response);
use WWW::Search::Scraper::Response;
$VERSION = sprintf("%d.%02d", q$Revision: 1.3 $ =~ /(\d+)\.(\d+)/);

sub resultTitles {
    return {
                'relevance'  => 'Relevance'
               ,'title'      => 'Title'
               ,'description' => 'Description'
               ,'companyProfileURL'    => 'Company Profile URL'
               ,'company'    => 'Company'
               ,'location'   => 'Location'
               ,'postDate'   => 'Post-Date'
               ,'url'        => 'URL'
           };
}

sub results {
    my $self = shift;
    return {
                'relevance'  => $self->relevance()
               ,'title'      => $self->title()
               ,'description' => $self->description()
               ,'companyProfileURL'    => $self->companyProfileURL()
               ,'company'    => $self->company()
               ,'location'   => $self->location()
               ,'postDate'   => $self->postDate()
               ,'url'        => $self->url()
           } 
}

sub relevance { return $_[0]->_elem('relevance'); }
sub title { return $_[0]->_elem('title'); }
sub description { return $_[0]->_elem('description'); }
sub company { return $_[0]->_elem('company'); }
sub companyProfileURL { return $_[0]->_elem('companyProfileURL'); }
sub location { return $_[0]->_elem('location'); }
sub postDate { return $_[0]->_elem('postDate'); }

1;

