#!perl -T
use 5.10.0;
use strict;
use warnings;
use Test::More;

my $base  = 'Net::IPAM::IP';
my $class = 'My::IP';
@My::IP::ISA = ( $base );

use_ok( $base );
can_ok( $class, 'new' );

my $ip = '1.2.3.4';

my $object = $class->new($ip);
isa_ok( $object, $class );
ok( $object eq $ip, 'stringification' );

my $clone;
ok( $clone = $object->clone, 'clone');
ok( $clone eq $ip, 'stringification of cloned obj' );

done_testing();

