require 5.005;
use ExtUtils::MakeMaker;
use File::Spec;

my $tmpl = File::Spec->catfile("Info.pm.tmpl");
my $info_pm = File::Spec->catfile("lib", "Image", "Info.pm");
my $idir = File::Spec->catdir("lib", "Image", "Info");
opendir(DIR, $idir) || die "Can't opendir $idir: $!";
my @code;
my @desc;
for my $file (sort readdir(DIR)) {
    next unless $file =~ /^([a-zA-Z]\w*)\.pm$/;
    my $format = $1;

    open(F, File::Spec->catfile($idir, $file)) || die "Can't open '$idir/$file': $!";
    my @magic;
    my @desc;
    while (<F>) {
	if (/^=begin\s+register\b/ ... /^=end\s+register\b/) {
	    next if /^=(begin|end)/;
	    if (/^MAGIC:\s+(.*)/) {
		push(@magic, $1);
		next;
	    }
	    push(@desc, $_);
	}
    }
    die "Missing magic for $format" unless @magic;
    for (@magic) {
	if (m:^/:) {
	    push(@code, qq(return "$format" if $_;));
	}
	else {
	    push(@code, qq(return "$format" if \$_ eq $_;));
	}
    }

    # trim
    shift(@desc) while @desc && $desc[0]  =~ /^\s*$/;
    pop(@desc)   while @desc && $desc[-1] =~ /^\s*$/;

    $desc .= "\n=item $format\n" unless @desc && $desc[0] =~ /^=item/;
    $desc .= "\n" . join("", @desc);

}
closedir(DIR);

my $code = "sub determine_file_format
{
   local(\$_) = \@_;
   " . join("\n   ", @code) . "
   return undef;
}
";

# Copy template to top level module with substitutions
open(TMPL, $tmpl) || die "Can't open $tmpl: $!";
open(INFO, ">$info_pm") || die "Can't create $info_pm: $!";
print INFO <<"EOT";
# This file is autogenerated from $tmpl.
# Please do not edit!!

EOT

while (<TMPL>) {
    if (/^%%DETERMINE_FILE_FORMAT%%/) {
        $_ = $code;
    }
    elsif (/^%%FORMAT_DESC%%/) {
       $_ = $desc;
    }
    print INFO $_;
}
close(INFO);
close(TMPL);

WriteMakefile(
    NAME         => 'Image::Info',
    AUTHOR       => 'Gisle Aas <gisle@ActiveState.com',
    VERSION_FROM => $info_pm,
    PREREQ_PM    => {
                      ($] < 5.008 ? ('IO::String' => 1) : ()),
                    },
    clean        => { FILES => $info_pm },
    dist         => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
);

