package ClearCase::Wrapper::Site::MySite;

$VERSION = '0.01';

use AutoLoader 'AUTOLOAD';

use strict;

#############################################################################
# Usage Message Extensions
#############################################################################
{
   local $^W = 0;
   no strict 'vars';

   # Usage message additions for actual cleartool commands that we extend.

   # Usage messages for pseudo cleartool commands that we implement here.
   local $0 = $ARGV[0] || '';
   $mysite	= "$0 [-aflag] [-bflag] ...";
}

#############################################################################
# Command Aliases
#############################################################################
*site_example		= *mysite;

1;

__END__

=head1 NAME

ClearCase::Wrapper::Site::MySite - ClearCase::Wrapper extensions for MySite

=head1 SYNOPSIS

MySite-specific synopsis (if any) goes here.

=head1 CLEARTOOL ENHANCEMENTS

=over 4

=item * MYSITE

This is an example of a site-specific enhancement. It's nothing but a
demo which prints out its arguments and flags when run.

=cut

# You should be able to run "ct mysite -aflag xx yy" to see that
# it works. Other extensions are equally simple: just make a subroutine
# by that name.
sub mysite {
    my %opt;
    my $name = shift @ARGV;
    print "In $::prog $name (with args='@ARGV')!\n";
    GetOptions(\%opt, qw(aflag bflag));
    for (qw(aflag bflag)) {
	print "You passed me the -$_ flag\n" if $opt{$_};
    }
    exit 0;
}

=back

=head1 SEE ALSO

perl(1), ClearCase::Wrapper, ClearCase::Wrapper::DSB

=cut
